/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.sew;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tim.prune.data.DataPoint;
import tim.prune.data.Track;
import tim.prune.function.sew.Segment;

public class SegmentChain {
    private final ArrayList<Segment> _segments = new ArrayList();
    private final Track _track;

    public SegmentChain(Track track, Segment segment) {
        this._segments.add(segment);
        this._track = track;
    }

    private DataPoint getFirstPoint() {
        return this._track.getPoint(this._segments.get(0).getStartIndex());
    }

    private DataPoint getLastPoint() {
        return this._track.getPoint(this._segments.get(this._segments.size() - 1).getEndIndex());
    }

    private boolean arePointsSame(DataPoint dataPoint, DataPoint dataPoint2) {
        return dataPoint.getLatitude().equals(dataPoint2.getLatitude()) && dataPoint.getLongitude().equals(dataPoint2.getLongitude());
    }

    public boolean append(Segment segment) {
        DataPoint dataPoint = this.getFirstPoint();
        DataPoint dataPoint2 = this.getLastPoint();
        int n = 0;
        while (n < 2) {
            DataPoint dataPoint3 = this._track.getPoint(segment.getStartIndex());
            if (this.arePointsSame(dataPoint2, dataPoint3)) {
                this._segments.add(segment);
                return true;
            }
            DataPoint dataPoint4 = this._track.getPoint(segment.getEndIndex());
            if (this.arePointsSame(dataPoint, dataPoint4)) {
                this._segments.add(0, segment);
                return true;
            }
            segment.reverse();
            ++n;
        }
        return false;
    }

    private void reverse() {
        for (Segment segment : this._segments) {
            segment.reverse();
        }
        Collections.reverse(this._segments);
    }

    public boolean append(SegmentChain segmentChain) {
        DataPoint dataPoint = this.getFirstPoint();
        DataPoint dataPoint2 = this.getLastPoint();
        int n = 0;
        while (n < 2) {
            DataPoint dataPoint3 = segmentChain.getFirstPoint();
            if (this.arePointsSame(dataPoint2, dataPoint3)) {
                this._segments.addAll(segmentChain._segments);
                return true;
            }
            DataPoint dataPoint4 = segmentChain.getLastPoint();
            if (this.arePointsSame(dataPoint, dataPoint4)) {
                this._segments.addAll(0, segmentChain._segments);
                return true;
            }
            segmentChain.reverse();
            ++n;
        }
        return false;
    }

    public List<Integer> getPointIndexes() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Segment segment : this._segments) {
            arrayList.addAll(segment.getPointIndexes(arrayList.isEmpty()));
        }
        return arrayList;
    }
}

