/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.registry.ApplicationPolicyProvider;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.dialogs.BlockingPopupDialog;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.utils.CommonUtils;

public class BaseAuthDialog
extends BaseDialog
implements BlockingPopupDialog {
    private String userNameLabel = UIConnectionMessages.dialog_connection_auth_label_username;
    private String passwordLabel = UIConnectionMessages.dialog_connection_auth_label_password;
    private final boolean passwordOnly;
    private final boolean showSavePassword;
    private final DBPAuthInfo authInfo = new DBPAuthInfo();
    private String savePasswordText;
    private String savePasswordToolTipText;
    private String description;
    protected Text usernameText;
    protected Text passwordText;
    private Button savePasswordCheck;

    public BaseAuthDialog(Shell parentShell, String title, boolean passwordOnly, boolean showSavePassword) {
        super(parentShell, title, (DBPImage)DBIcon.TREE_USER);
        this.passwordOnly = passwordOnly;
        this.showSavePassword = showSavePassword && !ApplicationPolicyProvider.getInstance().isPolicyEnabled("connection.credentials.save.restricted");
    }

    public void setUserNameLabel(String userNameLabel) {
        this.userNameLabel = userNameLabel;
    }

    public void setPasswordLabel(String passwordLabel) {
        this.passwordLabel = passwordLabel;
    }

    public DBPAuthInfo getAuthInfo() {
        return this.authInfo;
    }

    public String getUserName() {
        return this.authInfo.getUserName();
    }

    public void setUserName(String userName) {
        this.authInfo.setUserName(userName);
    }

    public String getUserPassword() {
        return this.authInfo.getUserPassword();
    }

    public void setUserPassword(String userPassword) {
        this.authInfo.setUserPassword(userPassword);
    }

    public boolean isSavePassword() {
        return this.authInfo.isSavePassword();
    }

    public void setSavePassword(boolean savePassword) {
        this.authInfo.setSavePassword(savePassword);
    }

    public String getSavePasswordText() {
        return this.savePasswordText;
    }

    public void setSavePasswordText(String text) {
        this.savePasswordText = text;
    }

    public String getSavePasswordToolTipText() {
        return this.savePasswordToolTipText;
    }

    public void setSavePasswordToolTipText(String text) {
        this.savePasswordToolTipText = text;
    }

    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @NotNull
    protected Composite createDialogArea(@NotNull Composite parent) {
        Composite addrGroup = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginHeight = 10;
        gl.marginWidth = 10;
        addrGroup.setLayout((Layout)gl);
        GridData gd = new GridData(1808);
        addrGroup.setLayoutData((Object)gd);
        if (CommonUtils.isNotEmpty((String)this.description)) {
            UIUtils.createInfoLabel((Composite)addrGroup, (String)this.description);
        }
        Composite credGroup = UIUtils.createTitledComposite((Composite)addrGroup, (String)UIConnectionMessages.dialog_connection_auth_group_user_cridentials, (int)2, (int)1808);
        if (!this.passwordOnly) {
            Label usernameLabel = new Label(credGroup, 0);
            usernameLabel.setText(this.userNameLabel);
            usernameLabel.setLayoutData((Object)new GridData(32));
            this.usernameText = new Text(credGroup, 2048);
            gd = new GridData(768);
            gd.grabExcessHorizontalSpace = true;
            gd.widthHint = 200;
            this.usernameText.setLayoutData((Object)gd);
            if (this.authInfo.getUserName() != null) {
                this.usernameText.setText(this.authInfo.getUserName());
            }
        }
        Label passwordLabel = new Label(credGroup, 0);
        passwordLabel.setText(this.passwordLabel);
        passwordLabel.setLayoutData((Object)new GridData(32));
        this.passwordText = new Text(credGroup, 0x400800);
        gd = new GridData(768);
        gd.grabExcessHorizontalSpace = true;
        this.passwordText.setLayoutData((Object)gd);
        if (this.authInfo.getUserPassword() != null && this.authInfo.isSavePassword()) {
            this.passwordText.setText(this.authInfo.getUserPassword());
        }
        if (this.showSavePassword) {
            this.savePasswordCheck = new Button(addrGroup, 32);
            this.savePasswordCheck.setEnabled(this.showSavePassword);
            this.savePasswordCheck.setText(CommonUtils.toString((Object)this.savePasswordText, (String)UIConnectionMessages.dialog_connection_auth_checkbox_save_password));
            this.savePasswordCheck.setToolTipText(this.savePasswordToolTipText);
            gd = new GridData(32);
            this.savePasswordCheck.setLayoutData((Object)gd);
            this.savePasswordCheck.setSelection(this.authInfo.isSavePassword());
        }
        if (this.passwordOnly || !CommonUtils.isEmpty((String)this.usernameText.getText())) {
            this.passwordText.setFocus();
        }
        return addrGroup;
    }

    protected void okPressed() {
        if (!this.passwordOnly) {
            this.authInfo.setUserName(this.usernameText.getText());
        }
        this.authInfo.setUserPassword(this.passwordText.getText());
        if (this.showSavePassword) {
            this.authInfo.setSavePassword(this.savePasswordCheck.getSelection());
        }
        super.okPressed();
    }
}

