/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Spliterator;
import java.util.function.LongConsumer;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.Hash;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.HashCommon;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongArrayList;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongCollection;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongIterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.LongSpliterator;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.j;
import org.jetbrains.kotlin.it.unimi.dsi.fastutil.longs.m;

public class LongOpenHashSet
extends m
implements Hash,
Serializable,
Cloneable {
    private static final long serialVersionUID = 0L;
    protected transient long[] key;
    protected transient int mask;
    protected transient boolean containsNull;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    /*
     * WARNING - void declaration
     */
    public LongOpenHashSet(int expected, float f2) {
        void var2_2;
        void var1_1;
        if (f2 <= 0.0f || f2 >= 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f2;
        LongOpenHashSet longOpenHashSet = this;
        longOpenHashSet.minN = longOpenHashSet.n = HashCommon.arraySize((int)var1_1, f2);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, (float)var2_2);
        this.key = new long[this.n + 1];
    }

    /*
     * WARNING - void declaration
     */
    public LongOpenHashSet(int expected) {
        this((int)var1_1, 0.75f);
        void var1_1;
    }

    public LongOpenHashSet() {
        this(16, 0.75f);
    }

    private int a() {
        if (this.containsNull) {
            return this.size - 1;
        }
        return this.size;
    }

    public void ensureCapacity(int capacity) {
        int n2 = HashCommon.arraySize(capacity, this.f);
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    private void a(long l2) {
        int n2 = (int)Math.min(0x40000000L, Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)l2 / this.f))));
        if (n2 > this.n) {
            this.rehash(n2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(LongCollection c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            LongOpenHashSet longOpenHashSet = this;
            longOpenHashSet.a((long)(longOpenHashSet.size() + c2.size()));
        }
        return super.addAll((LongCollection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends Long> c2) {
        void var1_1;
        if ((double)this.f <= 0.5) {
            this.ensureCapacity(c2.size());
        } else {
            LongOpenHashSet longOpenHashSet = this;
            longOpenHashSet.a((long)(longOpenHashSet.size() + c2.size()));
        }
        return super.addAll((Collection<? extends Long>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(long k2) {
        if (k2 == 0L) {
            if (this.containsNull) {
                return false;
            }
            this.containsNull = true;
        } else {
            void var1_1;
            long[] lArray = this.key;
            int n2 = (int)HashCommon.mix(k2) & this.mask;
            long l2 = this.key[n2];
            if (l2 != 0L) {
                if (l2 == k2) {
                    return false;
                }
                while ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) {
                    if (l2 != k2) continue;
                    return false;
                }
            }
            lArray[n2] = var1_1;
        }
        if (this.size++ >= this.maxFill) {
            LongOpenHashSet longOpenHashSet = this;
            longOpenHashSet.rehash(HashCommon.arraySize(longOpenHashSet.size + 1, this.f));
        }
        return true;
    }

    private boolean a(int n2) {
        --this.size;
        int n3 = n2;
        LongOpenHashSet longOpenHashSet = this;
        long[] lArray = longOpenHashSet.key;
        block0: while (true) {
            long l2;
            int n4 = n3;
            n3 = n4 + 1 & longOpenHashSet.mask;
            while (true) {
                if ((l2 = lArray[n3]) == 0L) break block0;
                int n5 = (int)HashCommon.mix(l2) & longOpenHashSet.mask;
                if (n4 > n3 ? n4 >= n5 && n5 > n3 : n4 >= n5 || n5 > n3) break;
                n3 = n3 + 1 & longOpenHashSet.mask;
            }
            lArray[n4] = l2;
        }
        lArray[n4] = 0L;
        if (this.n > this.minN && this.size < this.maxFill / 4 && this.n > 16) {
            LongOpenHashSet longOpenHashSet2 = this;
            longOpenHashSet2.rehash(longOpenHashSet2.n / 2);
        }
        return true;
    }

    @Override
    public boolean remove(long k222) {
        long k222;
        if (k222 == 0L) {
            if (this.containsNull) {
                LongOpenHashSet k222 = this;
                this.containsNull = false;
                k222.key[k222.n] = 0L;
                --k222.size;
                if (k222.n > k222.minN && k222.size < k222.maxFill / 4 && k222.n > 16) {
                    LongOpenHashSet longOpenHashSet = k222;
                    longOpenHashSet.rehash(longOpenHashSet.n / 2);
                }
                return true;
            }
            return false;
        }
        long[] lArray = this.key;
        int n2 = (int)HashCommon.mix(k222) & this.mask;
        long l2 = this.key[n2];
        if (l2 == 0L) {
            return false;
        }
        if (k222 == l2) {
            return this.a(n2);
        }
        do {
            if ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k222 != l2);
        return this.a(n2);
    }

    @Override
    public boolean contains(long k2) {
        if (k2 == 0L) {
            return this.containsNull;
        }
        long[] lArray = this.key;
        int n2 = (int)HashCommon.mix(k2) & this.mask;
        long l2 = this.key[n2];
        if (l2 == 0L) {
            return false;
        }
        if (k2 == l2) {
            return true;
        }
        do {
            if ((l2 = lArray[n2 = n2 + 1 & this.mask]) != 0L) continue;
            return false;
        } while (k2 != l2);
        return true;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        this.containsNull = false;
        Arrays.fill(this.key, 0L);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public LongIterator iterator() {
        return new a(this, 0);
    }

    @Override
    public LongSpliterator spliterator() {
        return new b(this);
    }

    @Override
    public void forEach(LongConsumer action) {
        if (this.containsNull) {
            action.accept(this.key[this.n]);
        }
        long[] lArray = this.key;
        int n2 = this.n;
        while (n2-- != 0) {
            if (lArray[n2] == 0L) continue;
            action.accept(lArray[n2]);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void rehash(int newN) {
        void var1_1;
        long[] lArray = this.key;
        int n2 = newN - 1;
        long[] lArray2 = new long[newN + 1];
        int n3 = this.n;
        int n4 = this.a();
        while (n4-- != 0) {
            while (lArray[--n3] == 0L) {
            }
            int n5 = (int)HashCommon.mix(lArray[n3]) & n2;
            if (lArray2[n5] != 0L) {
                while (lArray2[n5 = n5 + 1 & n2] != 0L) {
                }
            }
            lArray2[n5] = lArray[n3];
        }
        this.n = var1_1;
        this.mask = n2;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = lArray2;
    }

    public LongOpenHashSet clone() {
        LongOpenHashSet longOpenHashSet;
        try {
            longOpenHashSet = (LongOpenHashSet)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        longOpenHashSet.key = (long[])this.key.clone();
        longOpenHashSet.containsNull = this.containsNull;
        return longOpenHashSet;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        int n3 = this.a();
        int n4 = 0;
        while (n3-- != 0) {
            while (this.key[n4] == 0L) {
                ++n4;
            }
            n2 += HashCommon.long2int(this.key[n4]);
            ++n4;
        }
        return n2;
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        LongIterator longIterator = ((j)this).iterator();
        s2.defaultWriteObject();
        int n2 = this.size;
        while (n2-- != 0) {
            s2.writeLong(longIterator.nextLong());
        }
    }

    private void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new long[this.n + 1];
        long[] lArray = this.key;
        int n2 = this.size;
        while (n2-- != 0) {
            int n3;
            long l2 = s2.readLong();
            if (l2 == 0L) {
                n3 = this.n;
                this.containsNull = true;
            } else {
                n3 = (int)HashCommon.mix(l2) & this.mask;
                if (lArray[n3] != 0L) {
                    while (lArray[n3 = n3 + 1 & this.mask] != 0L) {
                    }
                }
            }
            lArray[n3] = l2;
        }
    }

    private final class a
    implements LongIterator {
        private int a;
        private int b;
        private int c;
        private boolean d;
        private LongArrayList e;
        private /* synthetic */ LongOpenHashSet f;

        private a(LongOpenHashSet longOpenHashSet) {
            this.f = longOpenHashSet;
            this.a = this.f.n;
            this.b = -1;
            this.c = this.f.size;
            this.d = this.f.containsNull;
        }

        @Override
        public final boolean hasNext() {
            return this.c != 0;
        }

        @Override
        public final long nextLong() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.c;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                return this.f.key[this.f.n];
            }
            long[] lArray = this.f.key;
            do {
                if (--this.a >= 0) continue;
                this.b = Integer.MIN_VALUE;
                return this.e.getLong(-this.a - 1);
            } while (lArray[this.a] == 0L);
            this.b = this.a;
            return lArray[this.b];
        }

        @Override
        public final void remove() {
            block9: {
                if (this.b == -1) {
                    throw new IllegalStateException();
                }
                if (this.b == this.f.n) {
                    this.f.containsNull = false;
                    this.f.key[this.f.n] = 0L;
                } else {
                    if (this.a >= 0) {
                        a a2 = this;
                        int n2 = a2.b;
                        a a3 = a2;
                        long[] lArray = a2.f.key;
                        while (true) {
                            long l2;
                            int n3 = n2;
                            n2 = n3 + 1 & a3.f.mask;
                            while (true) {
                                if ((l2 = lArray[n2]) == 0L) {
                                    lArray[n3] = 0L;
                                    break block9;
                                }
                                int n4 = (int)HashCommon.mix(l2) & a3.f.mask;
                                if (n3 > n2 ? n3 >= n4 && n4 > n2 : n3 >= n4 || n4 > n2) break;
                                n2 = n2 + 1 & a3.f.mask;
                            }
                            if (n2 < n3) {
                                if (a3.e == null) {
                                    a3.e = new LongArrayList(2);
                                }
                                ((j)a3.e).add(lArray[n2]);
                            }
                            lArray[n3] = l2;
                        }
                    }
                    ((m)this.f).remove(this.e.getLong(-this.a - 1));
                    this.b = -1;
                    return;
                }
            }
            --this.f.size;
            this.b = -1;
        }

        @Override
        public final void forEachRemaining(LongConsumer action) {
            long[] lArray = this.f.key;
            if (this.d) {
                this.d = false;
                this.b = this.f.n;
                action.accept(lArray[this.f.n]);
                --this.c;
            }
            while (this.c != 0) {
                if (--this.a < 0) {
                    this.b = Integer.MIN_VALUE;
                    action.accept(this.e.getLong(-this.a - 1));
                    --this.c;
                    continue;
                }
                if (lArray[this.a] == 0L) continue;
                this.b = this.a;
                action.accept(lArray[this.b]);
                --this.c;
            }
        }

        /* synthetic */ a(LongOpenHashSet longOpenHashSet, byte by) {
            this(longOpenHashSet);
        }
    }

    private final class b
    implements LongSpliterator {
        private int a = 0;
        private int b;
        private int c;
        private boolean d;
        private boolean e;
        private /* synthetic */ LongOpenHashSet f;

        b(LongOpenHashSet longOpenHashSet) {
            this.f = longOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
        }

        private b(LongOpenHashSet longOpenHashSet, int n2, int n3, boolean bl) {
            this.f = longOpenHashSet;
            this.b = this.f.n;
            this.c = 0;
            this.d = this.f.containsNull;
            this.e = false;
            this.a = n2;
            this.b = n3;
            this.d = bl;
            this.e = true;
        }

        @Override
        public final boolean tryAdvance(LongConsumer action) {
            if (this.d) {
                this.d = false;
                ++this.c;
                action.accept(this.f.key[this.f.n]);
                return true;
            }
            long[] lArray = this.f.key;
            while (this.a < this.b) {
                if (lArray[this.a] != 0L) {
                    ++this.c;
                    action.accept(lArray[this.a++]);
                    return true;
                }
                ++this.a;
            }
            return false;
        }

        @Override
        public final void forEachRemaining(LongConsumer action) {
            long[] lArray = this.f.key;
            if (this.d) {
                this.d = false;
                action.accept(lArray[this.f.n]);
                ++this.c;
            }
            while (this.a < this.b) {
                if (lArray[this.a] != 0L) {
                    action.accept(lArray[this.a]);
                    ++this.c;
                }
                ++this.a;
            }
        }

        @Override
        public final int characteristics() {
            if (this.e) {
                return 257;
            }
            return 321;
        }

        @Override
        public final long estimateSize() {
            if (!this.e) {
                return this.f.size - this.c;
            }
            return Math.min((long)(this.f.size - this.c), (long)((double)this.f.a() / (double)this.f.n * (double)(this.b - this.a)) + (long)(this.d ? 1 : 0));
        }

        private b b() {
            if (this.a >= this.b - 1) {
                return null;
            }
            int n2 = this.b - this.a >> 1;
            if (n2 <= 1) {
                return null;
            }
            n2 = this.a + n2;
            int n3 = this.a;
            int n4 = n2;
            b b2 = new b(this.f, n3, n4, this.d);
            this.a = n2;
            this.d = false;
            this.e = true;
            return b2;
        }

        @Override
        public final /* synthetic */ LongSpliterator a() {
            return this.b();
        }

        @Override
        public final /* synthetic */ Spliterator.OfLong trySplit() {
            return this.b();
        }

        @Override
        public final /* synthetic */ Spliterator.OfPrimitive trySplit() {
            return this.b();
        }

        @Override
        public final /* synthetic */ Spliterator trySplit() {
            return this.b();
        }
    }
}

