/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.it.unimi.dsi.fastutil;

public class HashCommon {
    public static int mix(int x2) {
        int n2 = x2 * -1640531527;
        return n2 ^ n2 >>> 16;
    }

    public static long mix(long x2) {
        long l2 = x2 * -7046029254386353131L;
        long l3 = l2 ^ l2 >>> 32;
        return l3 ^ l3 >>> 16;
    }

    public static int float2int(float f2) {
        return Float.floatToRawIntBits(f2);
    }

    public static int double2int(double d2) {
        long l2 = Double.doubleToRawLongBits(d2);
        return (int)(l2 ^ l2 >>> 32);
    }

    public static int long2int(long l2) {
        long l3 = l2;
        return (int)(l3 ^ l3 >>> 32);
    }

    public static int nextPowerOfTwo(int x2) {
        int n2;
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    public static long nextPowerOfTwo(long x2) {
        long l2;
        return 1L << 64 - Long.numberOfLeadingZeros(l2 - 1L);
    }

    /*
     * WARNING - void declaration
     */
    public static int maxFill(int n2, float f2) {
        int n3;
        void var1_1;
        return Math.min((int)Math.ceil((float)n2 * var1_1), n3 - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int arraySize(int expected, float f2) {
        long l2 = Math.max(2L, HashCommon.nextPowerOfTwo((long)Math.ceil((float)expected / f2)));
        if (l2 > 0x40000000L) {
            void var1_1;
            int n2;
            throw new IllegalArgumentException("Too large (" + n2 + " expected elements with load factor " + (float)var1_1 + ")");
        }
        return (int)l2;
    }
}

