/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization.exception;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.execution.MultipleBuildFailures;
import org.gradle.initialization.exception.ExceptionCollector;
import org.gradle.internal.exception.ExceptionAnalyser;
import org.jspecify.annotations.Nullable;

public class MultipleBuildFailuresExceptionAnalyser
implements ExceptionAnalyser {
    private final ExceptionCollector collector;

    public MultipleBuildFailuresExceptionAnalyser(ExceptionCollector collector) {
        this.collector = collector;
    }

    public RuntimeException transform(Throwable failure) {
        return this.transform(Collections.singletonList(failure));
    }

    public @Nullable RuntimeException transform(List<Throwable> failures) {
        if (failures.isEmpty()) {
            return null;
        }
        ArrayList result = new ArrayList(failures.size());
        for (Throwable failure : failures) {
            if (failure instanceof MultipleBuildFailures) {
                for (Throwable cause : ((MultipleBuildFailures)((Object)failure)).getCauses()) {
                    this.collector.collectFailures(cause, result);
                }
                continue;
            }
            this.collector.collectFailures(failure, result);
        }
        if (result.size() == 1 && result.get(0) instanceof RuntimeException) {
            return (RuntimeException)result.get(0);
        }
        return new MultipleBuildFailures(result);
    }
}

