// Code generated by "infoblox-go-client-generator"; DO NOT EDIT.

package ibclient

// WAPI_VERSION is a version of WAPI, which was used to generate infoblox-go-client.
const WAPI_VERSION = "2.12.1"

// AdAuthService represents Infoblox object ad_auth_service.
// This object allows you to specify an Active Directory (AD) authentication
// method and the AD authentication servers that Infoblox uses to authenticate
// administrators.
type AdAuthService struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Active Directory domain to which this server belongs.
	AdDomain *string `json:"ad_domain,omitempty"`

	// The unordered list of additional search paths for nested group querying.
	AdditionalSearchPaths []string `json:"additional_search_paths,omitempty"`

	// The descriptive comment for the AD authentication service.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the default search path for nested group querying is
	// used.
	DisableDefaultSearchPath *bool `json:"disable_default_search_path,omitempty"`

	// Determines if Active Directory Authentication Service is disabled.
	Disabled *bool `json:"disabled,omitempty"`

	// The AD authentication server list.
	DomainControllers []*AdAuthServer `json:"domain_controllers,omitempty"`

	// The AD authentication service name.
	Name *string `json:"name,omitempty"`

	// Determines whether the nested group querying is enabled.
	NestedGroupQuerying *bool `json:"nested_group_querying,omitempty"`

	// The number of seconds that the appliance waits for a response from the AD
	// server.
	Timeout *uint32 `json:"timeout,omitempty"`
}

func (AdAuthService) ObjectType() string {
	return "ad_auth_service"
}

func (obj AdAuthService) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// Admingroup represents Infoblox object admingroup.
// An Admin Group object creates and manages a local admin group on the
// Infoblox appliance. The privileges and properties that are set for the group
// apply to all the admin accounts that are assigned to the group.
type Admingroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Access methods specify whether an admin group can use the GUI and the API to
	// access the appliance or to send Taxii messages to the appliance. Note that
	// API includes both the Perl API and RESTful API.
	AccessMethod []string `json:"access_method,omitempty"`

	// Admin set commands for the admin command group.
	AdminSetCommands *AdmingroupAdminsetcommands `json:"admin_set_commands,omitempty"`

	// Admin show commands for the admin command group.
	AdminShowCommands *AdmingroupAdminshowcommands `json:"admin_show_commands,omitempty"`

	// Admin_toplevel commands for the admin command group
	AdminToplevelCommands *AdmingroupAdmintoplevelcommands `json:"admin_toplevel_commands,omitempty"`

	// Cloud set commands for the cloud command group.
	CloudSetCommands *AdmingroupCloudsetcommands `json:"cloud_set_commands,omitempty"`

	// Cloud show commands for admin group
	CloudShowCommands *AdmingroupCloudshowcommands `json:"cloud_show_commands,omitempty"`

	// Comment for the Admin Group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Database show commands for admin group.
	DatabaseSetCommands *AdmingroupDatabasesetcommands `json:"database_set_commands,omitempty"`

	// Database show commands for the database command
	DatabaseShowCommands *AdmingroupDatabaseshowcommands `json:"database_show_commands,omitempty"`

	// Dhcp set commands for the dhcp command group.
	DhcpSetCommands *AdmingroupDhcpsetcommands `json:"dhcp_set_commands,omitempty"`

	// Dhcp show commands for the dhcp command group.
	DhcpShowCommands *AdmingroupDhcpshowcommands `json:"dhcp_show_commands,omitempty"`

	// Determines whether the Admin Group is disabled or not. When this is set to
	// False, the Admin Group is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Disable concurrent login feature
	DisableConcurrentLogin *bool `json:"disable_concurrent_login,omitempty"`

	// Dns set commands for the dns command group.
	DnsSetCommands *AdmingroupDnssetcommands `json:"dns_set_commands,omitempty"`

	// Dns show commands for the dns command group.
	DnsShowCommands *AdmingroupDnsshowcommands `json:"dns_show_commands,omitempty"`

	// Dns toplevel commands for the dns command group.
	DnsToplevelCommands *AdmingroupDnstoplevelcommands `json:"dns_toplevel_commands,omitempty"`

	// Docker set commands for the dcoker command group.
	DockerSetCommands *AdmingroupDockersetcommands `json:"docker_set_commands,omitempty"`

	// Docker show commands for the dcoker command group.
	DockerShowCommands *AdmingroupDockershowcommands `json:"docker_show_commands,omitempty"`

	// The e-mail addresses for the Admin Group.
	EmailAddresses []string `json:"email_addresses,omitempty"`

	// Determines whether the restrictions will be applied to the admin connector
	// level for users of this Admin Group.
	EnableRestrictedUserAccess *bool `json:"enable_restricted_user_access,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Grid set commands for the grid command group.
	GridSetCommands *AdmingroupGridsetcommands `json:"grid_set_commands,omitempty"`

	// Show commands for the grid command group.
	GridShowCommands *AdmingroupGridshowcommands `json:"grid_show_commands,omitempty"`

	// The Admin group inactivity lockout settings.
	InactivityLockoutSetting *SettingInactivelockout `json:"inactivity_lockout_setting,omitempty"`

	// Set commands for the licensing command group.
	LicensingSetCommands *AdmingroupLicensingsetcommands `json:"licensing_set_commands,omitempty"`

	// Show commands for the licensing command group.
	LicensingShowCommands *AdmingroupLicensingshowcommands `json:"licensing_show_commands,omitempty"`

	// This struct specifies security policy settings in admin group.
	LockoutSetting *AdmingroupLockoutsetting `json:"lockout_setting,omitempty"`

	// Machine control toplevel commands for the machine control command group.
	MachineControlToplevelCommands *AdmingroupMachinecontroltoplevelcommands `json:"machine_control_toplevel_commands,omitempty"`

	// The name of the Admin Group.
	Name *string `json:"name,omitempty"`

	// Set commands for the networking command group.
	NetworkingSetCommands *AdmingroupNetworkingsetcommands `json:"networking_set_commands,omitempty"`

	// Show commands for the networking command group.
	NetworkingShowCommands *AdmingroupNetworkingshowcommands `json:"networking_show_commands,omitempty"`

	// The Admin Group password settings.
	PasswordSetting *AdmingroupPasswordsetting `json:"password_setting,omitempty"`

	// The names of roles this Admin Group applies to.
	Roles []string `json:"roles,omitempty"`

	// The Admin Group SAML settings.
	SamlSetting *AdmingroupSamlsetting `json:"saml_setting,omitempty"`

	// Set commands for the security command group.
	SecuritySetCommands *AdmingroupSecuritysetcommands `json:"security_set_commands,omitempty"`

	// Show commands for the security command group.
	SecurityShowCommands *AdmingroupSecurityshowcommands `json:"security_show_commands,omitempty"`

	// Determines whether this Admin Group is a superuser group. A superuser group
	// can perform all operations on the appliance, and can view and configure all
	// types of data.
	Superuser *bool `json:"superuser,omitempty"`

	// Toplevel commands for the troubleshooting command group.
	TroubleShootingToplevelCommands *AdmingroupTroubleshootingtoplevelcommands `json:"trouble_shooting_toplevel_commands,omitempty"`

	// This is the use flag for account inactivity lockout settings.
	UseAccountInactivityLockoutEnable *bool `json:"use_account_inactivity_lockout_enable,omitempty"`

	// Whether to override grid concurrent login
	UseDisableConcurrentLogin *bool `json:"use_disable_concurrent_login,omitempty"`

	// Whether to override grid sequential lockout setting
	UseLockoutSetting *bool `json:"use_lockout_setting,omitempty"`

	// Whether grid password expiry setting should be override.
	UsePasswordSetting *bool `json:"use_password_setting,omitempty"`

	// The access control items for this Admin Group.
	UserAccess []*Addressac `json:"user_access,omitempty"`
}

func (Admingroup) ObjectType() string {
	return "admingroup"
}

func (obj Admingroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Adminrole represents Infoblox object adminrole.
// An Admin Role object creates and manages a local admin role on the Infoblox
// appliance. A Role object is used to aggregate a set of permissions
// (represented by Permission objects).
type Adminrole struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment of the Admin Role object.
	Comment *string `json:"comment,omitempty"`

	// The disable flag.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of an admin role.
	Name *string `json:"name,omitempty"`
}

func (Adminrole) ObjectType() string {
	return "adminrole"
}

func (obj Adminrole) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Adminuser represents Infoblox object adminuser.
// An admin account provides access to the Infoblox appliance. An admin account
// inherits the privileges and properties of the group to which it belongs.
type Adminuser struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The names of the Admin Groups to which this Admin User belongs. Currently,
	// this is limited to only one Admin Group.
	AdminGroups []string `json:"admin_groups,omitempty"`

	// Determines the way of authentication
	AuthMethod string `json:"auth_method,omitempty"`

	// The authentication type for the admin user.
	AuthType string `json:"auth_type,omitempty"`

	// The CA certificate that is used for user lookup during authentication.
	CaCertificateIssuer *string `json:"ca_certificate_issuer,omitempty"`

	// The serial number of the client certificate.
	ClientCertificateSerialNumber *string `json:"client_certificate_serial_number,omitempty"`

	// Comment for the admin user; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the admin user is disabled or not. When this is set to
	// False, the admin user is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The e-mail address for the admin user.
	Email *string `json:"email,omitempty"`

	// Determines whether the user is allowed to log in only with the certificate.
	// Regular username/password authentication will be disabled for this user.
	EnableCertificateAuthentication *bool `json:"enable_certificate_authentication,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the admin user.
	Name *string `json:"name,omitempty"`

	// The password for the administrator to use when logging in.
	Password *string `json:"password,omitempty"`

	// List of ssh keys for a particular user.
	SshKeys []*SshKey `json:"ssh_keys,omitempty"`

	// Status of the user account.
	Status string `json:"status,omitempty"`

	// The time zone for this admin user.
	TimeZone string `json:"time_zone,omitempty"`

	// \, Enable/disable the ssh keypair authentication.
	UseSshKeys *bool `json:"use_ssh_keys,omitempty"`

	// Use flag for: time_zone
	UseTimeZone *bool `json:"use_time_zone,omitempty"`
}

func (Adminuser) ObjectType() string {
	return "adminuser"
}

func (obj Adminuser) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"admin_groups", "comment", "name"}
	}
	return obj.returnFields
}

// Allendpoints represents Infoblox object allendpoints.
// The object provides information about all thrid-party servers configured on
// the Grid.
type Allendpoints struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid endpoint IPv4 Address or IPv6 Address or Fully-Qualified Domain
	// Name (FQDN).
	Address string `json:"address,omitempty"`

	// The Grid endpoint descriptive comment.
	Comment string `json:"comment,omitempty"`

	// Determines whether a Grid endpoint is disabled or not. When this is set to
	// False, the Grid endpoint is enabled.
	Disable bool `json:"disable,omitempty"`

	// The name of the Grid Member object that is serving Grid endpoint.
	SubscribingMember string `json:"subscribing_member,omitempty"`

	// The Grid endpoint type.
	Type string `json:"type,omitempty"`

	// The Grid endpoint version.
	Version string `json:"version,omitempty"`
}

func (Allendpoints) ObjectType() string {
	return "allendpoints"
}

func (obj Allendpoints) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// Allnsgroup represents Infoblox object allnsgroup.
// The All NS Groups object is a generic name server group object that provides
// information about all name server groups.
type Allnsgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the name server group.
	Comment string `json:"comment,omitempty"`

	// The name of the name server group.
	Name string `json:"name,omitempty"`

	// The type of the name server group.
	Type string `json:"type,omitempty"`
}

func (Allnsgroup) ObjectType() string {
	return "allnsgroup"
}

func (obj Allnsgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "type"}
	}
	return obj.returnFields
}

// Allrecords represents Infoblox object allrecords.
// The allrecords object is a read-only synthetic object used to retrieve
// records that belong to a particular zone.
type Allrecords struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The record address.
	Address string `json:"address,omitempty"`

	// The record comment.
	Comment string `json:"comment,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected bool `json:"ddns_protected,omitempty"`

	// The disable value determines if the record is disabled or not. "False" means
	// the record is enabled.
	Disable bool `json:"disable,omitempty"`

	// The specific LBDN record.
	DtcObscured string `json:"dtc_obscured,omitempty"`

	// The name of the record.
	Name string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The record object, if supported by the WAPI. Otherwise, the value is "None".
	Record string `json:"record,omitempty"`

	// The Time To Live (TTL) value for which the record is valid or being cached.
	// The 32-bit unsigned integer represents the duration in seconds. Zero
	// indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// The record type. When searching for an unspecified record type, the search
	// is performed for all records. On retrieval, the appliance returns
	// "UNSUPPORTED" for unsupported records.
	Type string `json:"type,omitempty"`

	// Name of the DNS View in which the record resides.
	View string `json:"view,omitempty"`

	// Name of the zone in which the record resides.
	Zone string `json:"zone,omitempty"`
}

func (Allrecords) ObjectType() string {
	return "allrecords"
}

func (obj Allrecords) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "type", "view", "zone"}
	}
	return obj.returnFields
}

// Allrpzrecords represents Infoblox object allrpzrecords.
// A synthetic object used to return record object types that belong to a
// Response Policy Zone.
type Allrpzrecords struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The alert type of the record associated with the allrpzrecords object.
	AlertType string `json:"alert_type,omitempty"`

	// The descriptive comment of the record associated with the allrpzrecords
	// object.
	Comment string `json:"comment,omitempty"`

	// The disable flag of the record associated with the allrpzrecords object (if
	// present).
	Disable bool `json:"disable,omitempty"`

	// The expiration time of the record associated with the allrpzrecords object.
	ExpirationTime uint32 `json:"expiration_time,omitempty"`

	// The time when the record associated with the allrpzrecords object was last
	// updated.
	LastUpdated uint32 `json:"last_updated,omitempty"`

	// The name of the record associated with the allrpzrecords object. Note that
	// this value might be different than the value of the name field for the
	// associated record.
	Name string `json:"name,omitempty"`

	// The record object associated with the allrpzrecords object.
	Record string `json:"record,omitempty"`

	// The RPZ rule type of the record associated with the allrpzrecrods object.
	RpzRule string `json:"rpz_rule,omitempty"`

	// The TTL value of the record associated with the allrpzrecords object (if
	// present).
	Ttl uint32 `json:"ttl,omitempty"`

	// The type of record associated with the allrpzrecords object. This is a
	// descriptive string that identifies the record to which this allrpzrecords
	// object refers. (Examples: 'record:rpz:a', 'record:rpz:mx', etc.)
	Type string `json:"type,omitempty"`

	// The DNS view name of the record associated with the allrpzrecords object.
	View string `json:"view,omitempty"`

	// The Response Policy Zone name of the record associated with the
	// allrpzrecords object.
	Zone string `json:"zone,omitempty"`
}

func (Allrpzrecords) ObjectType() string {
	return "allrpzrecords"
}

func (obj Allrpzrecords) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "type", "view", "zone"}
	}
	return obj.returnFields
}

// Approvalworkflow represents Infoblox object approvalworkflow.
// The approval workflow object supports routing certain core network service
// tasks submitted by an admin group to another approval. You can add an admin
// group to an approval workflow and define the group as a submitter or an
// approver group. You can also define when and to whom e-mail notifications
// must be sent, and configure options such as whether the submitters or
// approvers must enter a comment or a ticket number when they submit tasks for
// approval. Approval workflows are useful when you want to control tasks that
// require reviews.
type Approvalworkflow struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The approval administration group.
	ApprovalGroup *string `json:"approval_group,omitempty"`

	// The destination for approval task notifications.
	ApprovalNotifyTo string `json:"approval_notify_to,omitempty"`

	// The destination for approved task notifications.
	ApprovedNotifyTo string `json:"approved_notify_to,omitempty"`

	// The requirement for the comment when an approver approves a submitted task.
	ApproverComment string `json:"approver_comment,omitempty"`

	// Determines whether approval task notifications are enabled.
	EnableApprovalNotify *bool `json:"enable_approval_notify,omitempty"`

	// Determines whether approved task notifications are enabled.
	EnableApprovedNotify *bool `json:"enable_approved_notify,omitempty"`

	// Determines whether failed task notifications are enabled.
	EnableFailedNotify *bool `json:"enable_failed_notify,omitempty"`

	// Determines whether e-mail notifications to admin group's e-mail address are
	// enabled.
	EnableNotifyGroup *bool `json:"enable_notify_group,omitempty"`

	// Determines whether e-mail notifications to an admin member's e-mail address
	// are enabled.
	EnableNotifyUser *bool `json:"enable_notify_user,omitempty"`

	// Determines whether rejected task notifications are enabled.
	EnableRejectedNotify *bool `json:"enable_rejected_notify,omitempty"`

	// Determines whether rescheduled task notifications are enabled.
	EnableRescheduledNotify *bool `json:"enable_rescheduled_notify,omitempty"`

	// Determines whether succeeded task notifications are enabled.
	EnableSucceededNotify *bool `json:"enable_succeeded_notify,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The destination for failed task notifications.
	FailedNotifyTo string `json:"failed_notify_to,omitempty"`

	// The destination for rejected task notifications.
	RejectedNotifyTo string `json:"rejected_notify_to,omitempty"`

	// The destination for rescheduled task notifications.
	RescheduledNotifyTo string `json:"rescheduled_notify_to,omitempty"`

	// The requirement for the comment when a submitter submits a task for
	// approval.
	SubmitterComment string `json:"submitter_comment,omitempty"`

	// The submitter admininstration group.
	SubmitterGroup string `json:"submitter_group,omitempty"`

	// The destination for succeeded task notifications.
	SucceededNotifyTo string `json:"succeeded_notify_to,omitempty"`

	// The requirement for the ticket number when a submitter submits a task for
	// approval.
	TicketNumber string `json:"ticket_number,omitempty"`
}

func (Approvalworkflow) ObjectType() string {
	return "approvalworkflow"
}

func (obj Approvalworkflow) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"approval_group", "submitter_group"}
	}
	return obj.returnFields
}

// Authpolicy represents Infoblox object authpolicy.
// The authentication policy defines which authentication server groups the
// appliance uses to authenticate admins and lists the local admin groups that
// map to the remote admin groups.
type Authpolicy struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// List of names of local administration groups that are mapped to remote
	// administration groups.
	AdminGroups []string `json:"admin_groups,omitempty"`

	// The array that contains an ordered list of refs to
	// :doc:`localuser:authservice object </objects/localuser.authservice>`,
	// ldap_auth_service object ldap_auth_service, :doc:`radius:authservice object
	// </objects/radius.authservice>`, :doc:`tacacsplus:authservice object
	// </objects/tacacsplus.authservice>`, ad_auth_service object ad_auth_service,
	// :doc:`certificate:authservice object </objects/certificate.authservice>`.
	// :doc:`saml:authservice object </objects/saml.authservice>`,
	AuthServices []*LocaluserAuthservice `json:"auth_services,omitempty"`

	// The default admin group that provides authentication in case no valid group
	// is found.
	DefaultGroup *string `json:"default_group,omitempty"`

	// Remote policies usage.
	UsageType string `json:"usage_type,omitempty"`
}

func (Authpolicy) ObjectType() string {
	return "authpolicy"
}

func (obj Authpolicy) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"default_group", "usage_type"}
	}
	return obj.returnFields
}

// Awsrte53taskgroup represents Infoblox object awsrte53taskgroup.
// An AWS Route53 task group is a collection of one or more tasks allowing you
// to specify various zone filters to retrieve DNS zone data from AWS Route53
// service using specified AWS user credentials. Grouping these tasks together
// helps organize related groups of sync data, enable/disable these and manage
// the grid member these run on.
type Awsrte53taskgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The AWS Account ID associated with this task group.
	AccountId string `json:"account_id,omitempty"`

	// Comment for the task group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Indicates if all zones need to be saved into a single view.
	ConsolidateZones bool `json:"consolidate_zones,omitempty"`

	// The name of the DNS view for consolidating zones.
	ConsolidatedView string `json:"consolidated_view,omitempty"`

	// Indicates if the task group is enabled or disabled.
	Disabled *bool `json:"disabled,omitempty"`

	// Member on which the tasks in this task group will be run.
	GridMember *string `json:"grid_member,omitempty"`

	// The name of this AWS Route53 sync task group.
	Name *string `json:"name,omitempty"`

	// The name of the tenant's network view.
	NetworkView string `json:"network_view,omitempty"`

	// The network view mapping policy.
	NetworkViewMappingPolicy string `json:"network_view_mapping_policy,omitempty"`

	// Indicate the overall sync status of this task group.
	SyncStatus string `json:"sync_status,omitempty"`

	// List of AWS Route53 tasks in this group.
	TaskList []*Awsrte53task `json:"task_list,omitempty"`
}

func (Awsrte53taskgroup) ObjectType() string {
	return "awsrte53taskgroup"
}

func (obj Awsrte53taskgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"account_id", "comment", "disabled", "name", "sync_status"}
	}
	return obj.returnFields
}

// Awsuser represents Infoblox object awsuser.
// An AWS user object represents a specific access key and secret key pair
// credentials of an AWS user.
type Awsuser struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The unique Access Key ID of this AWS user. Maximum 255 characters.
	AccessKeyId *string `json:"access_key_id,omitempty"`

	// The AWS Account ID of this AWS user. Maximum 64 characters.
	AccountId *string `json:"account_id,omitempty"`

	// The timestamp when this AWS user credentials was last used.
	LastUsed *UnixTime `json:"last_used,omitempty"`

	// The AWS user name. Maximum 64 characters.
	Name *string `json:"name,omitempty"`

	// The NIOS user name mapped to this AWS user. Maximum 64 characters.
	NiosUserName *string `json:"nios_user_name,omitempty"`

	// The Secret Access Key for the Access Key ID of this user. Maximum 255
	// characters.
	SecretAccessKey *string `json:"secret_access_key,omitempty"`

	// Indicate the validity status of this AWS user.
	Status string `json:"status,omitempty"`
}

func (Awsuser) ObjectType() string {
	return "awsuser"
}

func (obj Awsuser) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"access_key_id", "account_id", "name"}
	}
	return obj.returnFields
}

// Bfdtemplate represents Infoblox object bfdtemplate.
// The Bidirectional Forwarding Detection (BFD) template contains a
// configuration of advanced BFD settings such as authentication and timer
// intervals.
type Bfdtemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The authentication key for BFD protocol message-digest authentication.
	AuthenticationKey *string `json:"authentication_key,omitempty"`

	// The authentication key identifier for BFD protocol authentication. Valid
	// values are between 1 and 255.
	AuthenticationKeyId *uint32 `json:"authentication_key_id,omitempty"`

	// The authentication type for BFD protocol.
	AuthenticationType string `json:"authentication_type,omitempty"`

	// The detection time multiplier value for BFD protocol. The negotiated
	// transmit interval, multiplied by this value, provides the detection time for
	// the receiving system in asynchronous BFD mode. Valid values are between 3
	// and 50.
	DetectionMultiplier *uint32 `json:"detection_multiplier,omitempty"`

	// The minimum receive time (in seconds) for BFD protocol. Valid values are
	// between 50 and 9999.
	MinRxInterval *uint32 `json:"min_rx_interval,omitempty"`

	// The minimum transmission time (in seconds) for BFD protocol. Valid values
	// are between 50 and 9999.
	MinTxInterval *uint32 `json:"min_tx_interval,omitempty"`

	// The name of the BFD template object.
	Name *string `json:"name,omitempty"`
}

func (Bfdtemplate) ObjectType() string {
	return "bfdtemplate"
}

func (obj Bfdtemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// Bulkhost represents Infoblox object bulkhost.
// If you need to add a large number of hosts, you can have the Infoblox
// appliance add them as a group and automatically assign host names based on a
// range of IP addresses and name format applied to it. This group of hosts is
// referred to as a BulkHost. The Infoblox appliance uses the name space
// bulk-xx-xx-xx-xx for bulk host, so this name should not be used for CNAMEs
// and host aliases because doing so causes conflicts. Before adding a bulk
// host, make sure that no CNAMEs or host aliases uses this name.
type Bulkhost struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The cloud API related information.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The disable flag of a DNS BulkHost record.
	Disable *bool `json:"disable,omitempty"`

	// The prefix, in punycode format, for the bulk host.
	DnsPrefix string `json:"dns_prefix,omitempty"`

	// The last IP address in the address range for the bulk host.
	EndAddr *string `json:"end_addr,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The bulk host name template.
	NameTemplate *string `json:"name_template,omitempty"`

	// The network view associated with the bulk host view.
	NetworkView string `json:"network_view,omitempty"`

	// The hostname policy for records under the bulk host parent zone.
	Policy string `json:"policy,omitempty"`

	// The prefix for the bulk host. The prefix is the name (or a series of
	// characters) inserted at the beginning of each host name.
	Prefix *string `json:"prefix,omitempty"`

	// The reverse flag of the BulkHost record.
	Reverse *bool `json:"reverse,omitempty"`

	// The first IP address in the address range for the bulk host.
	StartAddr *string `json:"start_addr,omitempty"`

	// The bulk host name template format.
	TemplateFormat string `json:"template_format,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: name_template
	UseNameTemplate *bool `json:"use_name_template,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The view for the bulk host.
	View *string `json:"view,omitempty"`

	// The zone name.
	Zone *string `json:"zone,omitempty"`
}

func (Bulkhost) ObjectType() string {
	return "bulkhost"
}

func (obj Bulkhost) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "prefix"}
	}
	return obj.returnFields
}

// Bulkhostnametemplate represents Infoblox object bulkhostnametemplate.
// The object manages the DNS bulk host name formats defined at the Grid level.
type Bulkhostnametemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// True if this template is Grid default.
	IsGridDefault bool `json:"is_grid_default,omitempty"`

	// True if this is a pre-defined template, False otherwise.
	PreDefined bool `json:"pre_defined,omitempty"`

	// The format of bulk host name template. It should follow certain rules
	// (please use Administration Guide as reference).
	TemplateFormat *string `json:"template_format,omitempty"`

	// The name of bulk host name template.
	TemplateName *string `json:"template_name,omitempty"`
}

func (Bulkhostnametemplate) ObjectType() string {
	return "bulkhostnametemplate"
}

func (obj Bulkhostnametemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"is_grid_default", "template_format", "template_name"}
	}
	return obj.returnFields
}

// Cacertificate represents Infoblox object cacertificate.
// An CA Certificate object represents a CA certificate description.
type Cacertificate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The certificate subject name.
	DistinguishedName string `json:"distinguished_name,omitempty"`

	// The certificate issuer subject name.
	Issuer string `json:"issuer,omitempty"`

	// The certificate serial number in hex format.
	Serial string `json:"serial,omitempty"`

	// Information about the CA certificate usage.
	UsedBy string `json:"used_by,omitempty"`

	// The date after which the certificate becomes invalid.
	ValidNotAfter *UnixTime `json:"valid_not_after,omitempty"`

	// The date before which the certificate is not valid.
	ValidNotBefore *UnixTime `json:"valid_not_before,omitempty"`
}

func (Cacertificate) ObjectType() string {
	return "cacertificate"
}

func (obj Cacertificate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"distinguished_name", "issuer", "serial", "used_by", "valid_not_after", "valid_not_before"}
	}
	return obj.returnFields
}

// CapacityReport represents Infoblox object capacityreport.
// The capacity report object provides information about the object count,
// interface count, and other memory usage statistics for a Grid member.
type CapacityReport struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Hardware type of a Grid member.
	HardwareType string `json:"hardware_type,omitempty"`

	// The maximum amount of capacity available for the Grid member.
	MaxCapacity uint32 `json:"max_capacity,omitempty"`

	// The Grid member name.
	Name string `json:"name,omitempty"`

	// A list of instance counts for object types created on the Grid member.
	ObjectCounts []*CapacityreportObjectcount `json:"object_counts,omitempty"`

	// The percentage of the capacity in use by the Grid member.
	PercentUsed uint32 `json:"percent_used,omitempty"`

	// The Grid member role.
	Role string `json:"role,omitempty"`

	// The total number of objects created by the Grid member.
	TotalObjects uint32 `json:"total_objects,omitempty"`
}

func (CapacityReport) ObjectType() string {
	return "capacityreport"
}

func (obj CapacityReport) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "percent_used", "role"}
	}
	return obj.returnFields
}

func NewCapcityReport(capReport CapacityReport) *CapacityReport {
	res := capReport
	returnFields := []string{"name", "hardware_type", "max_capacity", "object_counts", "percent_used", "role", "total_objects"}
	res.returnFields = returnFields
	return &res
}

// Captiveportal represents Infoblox object captiveportal.
// This object represents the captive portal configuration.
type Captiveportal struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The authentication server group assigned to this captive portal.
	AuthnServerGroup *string `json:"authn_server_group,omitempty"`

	// The company name that appears in the guest registration page.
	CompanyName *string `json:"company_name,omitempty"`

	// Determines if authentication failures are logged to syslog or not.
	EnableSyslogAuthFailure *bool `json:"enable_syslog_auth_failure,omitempty"`

	// Determines if successful authentications are logged to syslog or not.
	EnableSyslogAuthSuccess *bool `json:"enable_syslog_auth_success,omitempty"`

	// The type of user to be enabled for the captive portal.
	EnableUserType string `json:"enable_user_type,omitempty"`

	// The encryption the captive portal uses.
	Encryption string `json:"encryption,omitempty"`

	// The list of files associated with the captive portal.
	Files []*CaptiveportalFile `json:"files,omitempty"`

	// The name of the custom field that you are adding to the guest registration
	// page.
	GuestCustomField1Name *string `json:"guest_custom_field1_name,omitempty"`

	// Determines if the custom field is required or not.
	GuestCustomField1Required *bool `json:"guest_custom_field1_required,omitempty"`

	// The name of the custom field that you are adding to the guest registration
	// page.
	GuestCustomField2Name *string `json:"guest_custom_field2_name,omitempty"`

	// Determines if the custom field is required or not.
	GuestCustomField2Required *bool `json:"guest_custom_field2_required,omitempty"`

	// The name of the custom field that you are adding to the guest registration
	// page.
	GuestCustomField3Name *string `json:"guest_custom_field3_name,omitempty"`

	// Determines if the custom field is required or not.
	GuestCustomField3Required *bool `json:"guest_custom_field3_required,omitempty"`

	// The name of the custom field that you are adding to the guest registration
	// page.
	GuestCustomField4Name *string `json:"guest_custom_field4_name,omitempty"`

	// Determines if the custom field is required or not.
	GuestCustomField4Required *bool `json:"guest_custom_field4_required,omitempty"`

	// Determines if the email address of the guest is required or not.
	GuestEmailRequired *bool `json:"guest_email_required,omitempty"`

	// Determines if the first name of the guest is required or not.
	GuestFirstNameRequired *bool `json:"guest_first_name_required,omitempty"`

	// Determines if the last name of the guest is required or not.
	GuestLastNameRequired *bool `json:"guest_last_name_required,omitempty"`

	// Determines if the middle name of the guest is required or not.
	GuestMiddleNameRequired *bool `json:"guest_middle_name_required,omitempty"`

	// Determines if the phone number of the guest is required or not.
	GuestPhoneRequired *bool `json:"guest_phone_required,omitempty"`

	// The helpdesk message that appears in the guest registration page.
	HelpdeskMessage *string `json:"helpdesk_message,omitempty"`

	// Determines the IP address on which the captive portal listens. Valid if
	// listen address type is 'IP'.
	ListenAddressIp *string `json:"listen_address_ip,omitempty"`

	// Determines the type of the IP address on which the captive portal listens.
	ListenAddressType string `json:"listen_address_type,omitempty"`

	// The hostname of the Grid member that hosts the captive portal.
	Name string `json:"name,omitempty"`

	// The network view of the captive portal.
	NetworkView *string `json:"network_view,omitempty"`

	// The TCP port used by the Captive Portal service. The port is required when
	// the Captive Portal service is enabled. Valid values are between 1 and 63999.
	// Please note that setting the port number to 80 or 443 might impact
	// performance.
	Port *uint32 `json:"port,omitempty"`

	// Determines if the captive portal service is enabled or not.
	ServiceEnabled *bool `json:"service_enabled,omitempty"`

	// The syslog level at which authentication failures are logged.
	SyslogAuthFailureLevel string `json:"syslog_auth_failure_level,omitempty"`

	// The syslog level at which successful authentications are logged.
	SyslogAuthSuccessLevel string `json:"syslog_auth_success_level,omitempty"`

	// The welcome message that appears in the guest registration page.
	WelcomeMessage *string `json:"welcome_message,omitempty"`
}

func (Captiveportal) ObjectType() string {
	return "captiveportal"
}

func (obj Captiveportal) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// CertificateAuthservice represents Infoblox object certificate:authservice.
// This object represents an certificate authentication service.
type CertificateAuthservice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Specifies the value of the client certificate for automatically populating
	// the NIOS login name.
	AutoPopulateLogin string `json:"auto_populate_login,omitempty"`

	// The list of CA certificates.
	CaCertificates []*Cacertificate `json:"ca_certificates,omitempty"`

	// The descriptive comment for the certificate authentication service.
	Comment *string `json:"comment,omitempty"`

	// Determines if this certificate authentication service is enabled or
	// disabled.
	Disabled *bool `json:"disabled,omitempty"`

	// Determines if username/password authentication together with client
	// certificate authentication is enabled or disabled.
	EnablePasswordRequest *bool `json:"enable_password_request,omitempty"`

	// Determines if the lookup for user group membership information on remote
	// services is enabled or disabled.
	EnableRemoteLookup *bool `json:"enable_remote_lookup,omitempty"`

	// The number of validation attempts before the appliance contacts the next
	// responder.
	MaxRetries *uint32 `json:"max_retries,omitempty"`

	// The name of the certificate authentication service.
	Name *string `json:"name,omitempty"`

	// Specifies the source of OCSP settings.
	OcspCheck string `json:"ocsp_check,omitempty"`

	// An ordered list of OCSP responders that are part of the certificate
	// authentication service.
	OcspResponders []*OcspResponder `json:"ocsp_responders,omitempty"`

	// The period of time the appliance waits before it attempts to contact a
	// responder that is out of service again. The value must be between 1 and 600
	// seconds.
	RecoveryInterval *uint32 `json:"recovery_interval,omitempty"`

	// The password for the service account.
	RemoteLookupPassword *string `json:"remote_lookup_password,omitempty"`

	// The service that will be used for remote lookup.
	RemoteLookupService *string `json:"remote_lookup_service,omitempty"`

	// The username for the service account.
	RemoteLookupUsername *string `json:"remote_lookup_username,omitempty"`

	// The validation timeout period in milliseconds.
	ResponseTimeout *uint32 `json:"response_timeout,omitempty"`

	// The OCSP trust model.
	TrustModel string `json:"trust_model,omitempty"`

	// Specifies how to search for a user.
	UserMatchType string `json:"user_match_type,omitempty"`
}

func (CertificateAuthservice) ObjectType() string {
	return "certificate:authservice"
}

func (obj CertificateAuthservice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// CiscoiseEndpoint represents Infoblox object ciscoise:endpoint.
// The object contains information and configuration for third-party Cisco ISE
// servers integration, configuration for Cisco ISE publishing and
// subscription.
type CiscoiseEndpoint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Cisco ISE endpoint IPv4 Address or IPv6 Address or Fully-Qualified
	// Domain Name (FQDN)
	Address *string `json:"address,omitempty"`

	// The Cisco ISE bulk download certificate subject.
	BulkDownloadCertificateSubject string `json:"bulk_download_certificate_subject,omitempty"`

	// The token returned by the uploadinit function call in object fileop for
	// Cisco ISE bulk download certificate.
	BulkDownloadCertificateToken *string `json:"bulk_download_certificate_token,omitempty"`

	// The Cisco ISE bulk download certificate valid from.
	BulkDownloadCertificateValidFrom *UnixTime `json:"bulk_download_certificate_valid_from,omitempty"`

	// The Cisco ISE bulk download certificate valid to.
	BulkDownloadCertificateValidTo *UnixTime `json:"bulk_download_certificate_valid_to,omitempty"`

	// The Cisco ISE client certificate subject.
	ClientCertificateSubject string `json:"client_certificate_subject,omitempty"`

	// The token returned by the uploadinit function call in object fileop for
	// Cisco ISE client certificate.
	ClientCertificateToken *string `json:"client_certificate_token,omitempty"`

	// The Cisco ISE client certificate valid from.
	ClientCertificateValidFrom *UnixTime `json:"client_certificate_valid_from,omitempty"`

	// The Cisco ISE client certificate valid to.
	ClientCertificateValidTo *UnixTime `json:"client_certificate_valid_to,omitempty"`

	// The Cisco ISE endpoint descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The Cisco ISE connection status.
	ConnectionStatus string `json:"connection_status,omitempty"`

	// The Cisco ISE connection timeout.
	ConnectionTimeout *uint32 `json:"connection_timeout,omitempty"`

	// Determines whether a Cisco ISE endpoint is disabled or not. When this is set
	// to False, the Cisco ISE endpoint is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The Cisco ISE network view name.
	NetworkView *string `json:"network_view,omitempty"`

	// The Cisco ISE publish settings.
	PublishSettings *CiscoisePublishsetting `json:"publish_settings,omitempty"`

	// The resolved IPv4 Address or IPv6 Address of the Cisco ISE endpoint.
	ResolvedAddress string `json:"resolved_address,omitempty"`

	// The resolved IPv4 Address or IPv6 Address of the Cisco ISE endpoint.
	ResolvedSecondaryAddress string `json:"resolved_secondary_address,omitempty"`

	// The Cisco ISE endpoint secondary IPv4 Address or IPv6 Address or
	// Fully-Qualified Domain Name (FQDN)
	SecondaryAddress *string `json:"secondary_address,omitempty"`

	// The Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// The name of the Grid Member object that is serving Cisco ISE endpoint.
	SubscribingMember *string `json:"subscribing_member,omitempty"`

	// The Cisco ISE endpoint type.
	Type string `json:"type,omitempty"`

	// The Cisco ISE endpoint version.
	Version string `json:"version,omitempty"`
}

func (CiscoiseEndpoint) ObjectType() string {
	return "ciscoise:endpoint"
}

func (obj CiscoiseEndpoint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "disable", "resolved_address", "type", "version"}
	}
	return obj.returnFields
}

// Csvimporttask represents Infoblox object csvimporttask.
// This object represents a CSV import task, if the task was created but not
// started by an import operation, it can be started by modifying it and
// assigning the value ‘START’ to the ‘action’ field.
type Csvimporttask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The action to execute.
	Action string `json:"action,omitempty"`

	// The login name of the administrator.
	AdminName string `json:"admin_name,omitempty"`

	// The end time of this import operation.
	EndTime *UnixTime `json:"end_time,omitempty"`

	// The name of the file used for the import operation.
	FileName string `json:"file_name,omitempty"`

	// The size of the file used for the import operation.
	FileSize uint32 `json:"file_size,omitempty"`

	// The ID of the current import task.
	ImportId uint32 `json:"import_id,omitempty"`

	// The number of lines that encountered an error.
	LinesFailed uint32 `json:"lines_failed,omitempty"`

	// The number of lines that have been processed.
	LinesProcessed uint32 `json:"lines_processed,omitempty"`

	// The number of lines that encountered a warning.
	LinesWarning uint32 `json:"lines_warning,omitempty"`

	// The action to take when an error is encountered.
	OnError string `json:"on_error,omitempty"`

	// The operation to execute.
	Operation string `json:"operation,omitempty"`

	// The separator to be used for the data in the CSV file.
	Separator string `json:"separator,omitempty"`

	// The start time of the import operation.
	StartTime *UnixTime `json:"start_time,omitempty"`

	// The status of the import operation
	Status string `json:"status,omitempty"`

	// The update method to be used for the operation.
	UpdateMethod string `json:"update_method,omitempty"`
}

func (Csvimporttask) ObjectType() string {
	return "csvimporttask"
}

func (obj Csvimporttask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"action", "admin_name", "end_time", "file_name", "file_size", "import_id", "lines_failed", "lines_processed", "lines_warning", "on_error", "operation", "separator", "start_time", "status", "update_method"}
	}
	return obj.returnFields
}

// DbObjects represents Infoblox object db_objects.
// The DB Objects object is used to search for changes in objects of the
// Infoblox Grid.
type DbObjects struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The last returned sequence ID.
	LastSequenceId string `json:"last_sequence_id,omitempty"`

	// The record object when supported by WAPI. Otherwise, the value is "None".
	Object string `json:"object,omitempty"`

	// The object type. This is undefined if the object is not supported.
	ObjectTypeField string `json:"object_type,omitempty"`

	// The unique ID of the requested object.
	UniqueId string `json:"unique_id,omitempty"`
}

func (DbObjects) ObjectType() string {
	return "db_objects"
}

func (obj DbObjects) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"last_sequence_id", "object", "object_type", "unique_id"}
	}
	return obj.returnFields
}

// Dbsnapshot represents Infoblox object dbsnapshot.
// The object provides information about the OneDB snapshot, the last time it
// was taken and the descriptive comment.
type Dbsnapshot struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment.
	Comment string `json:"comment,omitempty"`

	// The time when the latest OneDB snapshot was taken in Epoch seconds format.
	Timestamp *UnixTime `json:"timestamp,omitempty"`
}

func (Dbsnapshot) ObjectType() string {
	return "dbsnapshot"
}

func (obj Dbsnapshot) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "timestamp"}
	}
	return obj.returnFields
}

// DdnsPrincipalcluster represents Infoblox object ddns:principalcluster.
// The DDNS Principal Cluster object represents a set of principals such that
// any principal in a DDNS Principal Cluster can update records created by any
// other principal in the same cluster.
type DdnsPrincipalcluster struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the DDNS Principal Cluster.
	Comment *string `json:"comment,omitempty"`

	// The DDNS Principal cluster group name.
	Group *string `json:"group,omitempty"`

	// The name of this DDNS Principal Cluster.
	Name *string `json:"name,omitempty"`

	// The list of equivalent principals.
	Principals []string `json:"principals,omitempty"`
}

func (DdnsPrincipalcluster) ObjectType() string {
	return "ddns:principalcluster"
}

func (obj DdnsPrincipalcluster) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "group", "name", "principals"}
	}
	return obj.returnFields
}

// DdnsPrincipalclusterGroup represents Infoblox object ddns:principalcluster:group.
// The DDNS Principal Cluster Group object represents a set of DDNS Principal
// Clusters. A single group can be active at any time.
type DdnsPrincipalclusterGroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of equivalent DDNS principal clusters.
	Clusters []*DdnsPrincipalcluster `json:"clusters,omitempty"`

	// Comment for the DDNS Principal Cluster Group.
	Comment *string `json:"comment,omitempty"`

	// The name of this DDNS Principal Cluster Group.
	Name *string `json:"name,omitempty"`
}

func (DdnsPrincipalclusterGroup) ObjectType() string {
	return "ddns:principalcluster:group"
}

func (obj DdnsPrincipalclusterGroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DeletedObjects represents Infoblox object deleted_objects.
// The Deleted Objects object is used to display information about deleted
// objects. You can retrieve it from the appliance only as a part of DB Objects
// response.
type DeletedObjects struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The object type of the deleted object. This is undefined if the object is
	// not supported.
	ObjectTypeField string `json:"object_type,omitempty"`
}

func (DeletedObjects) ObjectType() string {
	return "deleted_objects"
}

func (obj DeletedObjects) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"object_type"}
	}
	return obj.returnFields
}

// DhcpStatistics represents Infoblox object dhcp:statistics.
// DHCP Statistics object is used to display information about DHCP utilization
// status, number of static and dynamic hosts, overall DHCP utilization in
// percentage. DHCP Statistics object supports references on following objects:
// network, range, sharednetwork, msserver:dhcp, member:dhcpproperties.
type DhcpStatistics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The percentage of the total DHCP utilization of DHCP objects multiplied by
	// 1000. This is the percentage of the total number of available IP addresses
	// belonging to the object versus the total number of all IP addresses in
	// object.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of the DHCP object.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// The total number of DHCP leases issued for the DHCP object.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// The number of static DHCP addresses configured in the DHCP object.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The total number of DHCP addresses configured in the DHCP object.
	TotalHosts uint32 `json:"total_hosts,omitempty"`
}

func (DhcpStatistics) ObjectType() string {
	return "dhcp:statistics"
}

func (obj DhcpStatistics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dhcp_utilization", "dhcp_utilization_status", "dynamic_hosts", "static_hosts", "total_hosts"}
	}
	return obj.returnFields
}

// Dhcpfailover represents Infoblox object dhcpfailover.
// DHCP failover is a protocol designed to allow a backup DHCP server to take
// over for a main server if the main server is taken off the network for any
// reason. DHCP failover can be used to configure two DHCP servers to operate
// as a redundant pair.
type Dhcpfailover struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The value indicating whether the failover assoctaion is Microsoft or Grid
	// based. This is a read-only attribute.
	AssociationType string `json:"association_type,omitempty"`

	// A descriptive comment about a DHCP failover object.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines the TCP port on which the server should listen for connections
	// from its failover peer. Valid values are between 1 and 63999.
	FailoverPort *uint32 `json:"failover_port,omitempty"`

	// A load balancing split value of a DHCP failover object. Specify the value of
	// the maximum load balancing delay in a 8-bit integer format (range from 0 to
	// 256).
	LoadBalanceSplit *uint32 `json:"load_balance_split,omitempty"`

	// The maximum client lead time value of a DHCP failover object. Specify the
	// value of the maximum client lead time in a 32-bit integer format (range from
	// 0 to 4294967295) that represents the duration in seconds. Valid values are
	// between 1 and 4294967295.
	MaxClientLeadTime *uint32 `json:"max_client_lead_time,omitempty"`

	// The maximum load balancing delay value of a DHCP failover object. Specify
	// the value of the maximum load balancing delay in a 32-bit integer format
	// (range from 0 to 4294967295) that represents the duration in seconds. Valid
	// values are between 1 and 4294967295.
	MaxLoadBalanceDelay *uint32 `json:"max_load_balance_delay,omitempty"`

	// The maximum response delay value of a DHCP failover object. Specify the
	// value of the maximum response delay in a 32-bit integer format (range from 0
	// to 4294967295) that represents the duration in seconds. Valid values are
	// between 1 and 4294967295.
	MaxResponseDelay *uint32 `json:"max_response_delay,omitempty"`

	// The maximum number of unacked updates value of a DHCP failover object.
	// Specify the value of the maximum number of unacked updates in a 32-bit
	// integer format (range from 0 to 4294967295) that represents the number of
	// messages. Valid values are between 1 and 4294967295.
	MaxUnackedUpdates *uint32 `json:"max_unacked_updates,omitempty"`

	// The value that indicates whether the failover association is read-write or
	// read-only. This is a read-only attribute.
	MsAssociationMode string `json:"ms_association_mode,omitempty"`

	// Determines if the authentication for the failover association is enabled or
	// not.
	MsEnableAuthentication *bool `json:"ms_enable_authentication,omitempty"`

	// Determines if the switchover interval is enabled or not.
	MsEnableSwitchoverInterval *bool `json:"ms_enable_switchover_interval,omitempty"`

	// The mode for the failover association.
	MsFailoverMode string `json:"ms_failover_mode,omitempty"`

	// Failover partner defined in the association with the Microsoft Server.
	MsFailoverPartner string `json:"ms_failover_partner,omitempty"`

	// The partner role in the case of HotStandby.
	MsHotstandbyPartnerRole string `json:"ms_hotstandby_partner_role,omitempty"`

	// Determines if the matching Microsfot failover association (if any) is in
	// synchronization (False) or not (True). If there is no matching failover
	// association the returned values is False. This is a read-only attribute.
	MsIsConflict bool `json:"ms_is_conflict,omitempty"`

	// The previous failover association state. This is a read-only attribute.
	MsPreviousState string `json:"ms_previous_state,omitempty"`

	// The primary Microsoft Server.
	MsServer string `json:"ms_server,omitempty"`

	// The failover association authentication. This is a write-only attribute.
	MsSharedSecret *string `json:"ms_shared_secret,omitempty"`

	// The failover association state. This is a read-only attribute.
	MsState string `json:"ms_state,omitempty"`

	// The time (in seconds) that DHCPv4 server will wait before transitioning the
	// server from the COMMUNICATION-INT state to PARTNER-DOWN state.
	MsSwitchoverInterval *uint32 `json:"ms_switchover_interval,omitempty"`

	// The name of a DHCP failover object.
	Name *string `json:"name,omitempty"`

	// The primary server of a DHCP failover object.
	Primary *string `json:"primary,omitempty"`

	// The type of the primary server of DHCP Failover association object.
	PrimaryServerType string `json:"primary_server_type,omitempty"`

	// The primary server status of a DHCP failover object.
	PrimaryState string `json:"primary_state,omitempty"`

	// Determines if the leases are kept in recycle bin until one week after
	// expiration or not.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// The secondary server of a DHCP failover object.
	Secondary *string `json:"secondary,omitempty"`

	// The type of the secondary server of DHCP Failover association object.
	SecondaryServerType string `json:"secondary_server_type,omitempty"`

	// The secondary server status of a DHCP failover object.
	SecondaryState string `json:"secondary_state,omitempty"`

	// Use flag for: failover_port
	UseFailoverPort *bool `json:"use_failover_port,omitempty"`

	// Use flag for: ms_switchover_interval
	UseMsSwitchoverInterval *bool `json:"use_ms_switchover_interval,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`
}

func (Dhcpfailover) ObjectType() string {
	return "dhcpfailover"
}

func (obj Dhcpfailover) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// Dhcpoptiondefinition represents Infoblox object dhcpoptiondefinition.
// An option definition defines a DHCP option within a specific option space. A
// custom option can be defined in the predefined DHCP option space or in the
// user-defined vendor option space. To define an option, add the option
// definition to the required option space.
type Dhcpoptiondefinition struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The code of a DHCP option definition object. An option code number is used
	// to identify the DHCP option.
	Code *uint32 `json:"code,omitempty"`

	// The name of a DHCP option definition object.
	Name *string `json:"name,omitempty"`

	// The space of a DHCP option definition object.
	Space *string `json:"space,omitempty"`

	// The data type of the Grid DHCP option.
	Type string `json:"type,omitempty"`
}

func (Dhcpoptiondefinition) ObjectType() string {
	return "dhcpoptiondefinition"
}

func (obj Dhcpoptiondefinition) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"code", "name", "type"}
	}
	return obj.returnFields
}

// Dhcpoptionspace represents Infoblox object dhcpoptionspace.
// An Option Space defines a namespace in which vendor options can be defined.
// To define a specific vendor option space, add an option space to DHCP.
type Dhcpoptionspace struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// A descriptive comment of a DHCP option space object.
	Comment *string `json:"comment,omitempty"`

	// The name of a DHCP option space object.
	Name *string `json:"name,omitempty"`

	// The list of DHCP option definition objects.
	OptionDefinitions []string `json:"option_definitions,omitempty"`

	// The type of a DHCP option space object.
	SpaceType string `json:"space_type,omitempty"`
}

func (Dhcpoptionspace) ObjectType() string {
	return "dhcpoptionspace"
}

func (obj Dhcpoptionspace) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Discovery represents Infoblox object discovery.
// This object can be used to control the Network Insight functionality of the
// appliance.
type Discovery struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`
}

func (Discovery) ObjectType() string {
	return "discovery"
}

func (obj Discovery) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// DiscoveryCredentialgroup represents Infoblox object discovery:credentialgroup.
// This object provides information about the Credential group.
type DiscoveryCredentialgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the Credential group.
	Name *string `json:"name,omitempty"`
}

func (DiscoveryCredentialgroup) ObjectType() string {
	return "discovery:credentialgroup"
}

func (obj DiscoveryCredentialgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// DiscoveryDevice represents Infoblox object discovery:device.
// The devices discovered by Network Automation
type DiscoveryDevice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IPv4 Address or IPv6 Address of the device.
	Address string `json:"address,omitempty"`

	// The ref to management IP address of the device.
	AddressRef string `json:"address_ref,omitempty"`

	// The list of available management IPs for the device.
	AvailableMgmtIps []string `json:"available_mgmt_ips,omitempty"`

	// Determines whether to modify the admin status of an interface of the device.
	CapAdminStatusInd bool `json:"cap_admin_status_ind,omitempty"`

	// The reason that the edit admin status action is not available.
	CapAdminStatusNaReason string `json:"cap_admin_status_na_reason,omitempty"`

	// Determines whether to modify the description of an interface on the device.
	CapDescriptionInd bool `json:"cap_description_ind,omitempty"`

	// The reason that the edit description action is not available.
	CapDescriptionNaReason string `json:"cap_description_na_reason,omitempty"`

	// Determines whether to deprovision a network from interfaces of the device.
	CapNetDeprovisioningInd bool `json:"cap_net_deprovisioning_ind,omitempty"`

	// The reason that the deprovision a network from interfaces of this device is
	// not available.
	CapNetDeprovisioningNaReason string `json:"cap_net_deprovisioning_na_reason,omitempty"`

	// Determines whether to modify the network associated to an interface of the
	// device.
	CapNetProvisioningInd bool `json:"cap_net_provisioning_ind,omitempty"`

	// The reason that network provisioning is not available.
	CapNetProvisioningNaReason string `json:"cap_net_provisioning_na_reason,omitempty"`

	// Determines whether to create a VLAN and then provision a network to the
	// interface of the device.
	CapNetVlanProvisioningInd bool `json:"cap_net_vlan_provisioning_ind,omitempty"`

	// The reason that network provisioning on VLAN is not available.
	CapNetVlanProvisioningNaReason string `json:"cap_net_vlan_provisioning_na_reason,omitempty"`

	// Determines whether to modify the VLAN assignement of an interface of the
	// device.
	CapVlanAssignmentInd bool `json:"cap_vlan_assignment_ind,omitempty"`

	// The reason that VLAN assignment action is not available.
	CapVlanAssignmentNaReason string `json:"cap_vlan_assignment_na_reason,omitempty"`

	// Determines whether to modify the voice VLAN assignment of an interface of
	// the device.
	CapVoiceVlanInd bool `json:"cap_voice_vlan_ind,omitempty"`

	// The reason that voice VLAN assignment action is not available.
	CapVoiceVlanNaReason string `json:"cap_voice_vlan_na_reason,omitempty"`

	// The device chassis serial number.
	ChassisSerialNumber string `json:"chassis_serial_number,omitempty"`

	// The description of the device.
	Description string `json:"description,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// List of the device interfaces.
	Interfaces []*DiscoveryDeviceinterface `json:"interfaces,omitempty"`

	// The location of the device.
	Location string `json:"location,omitempty"`

	// The model name of the device.
	Model string `json:"model,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The name of the device.
	Name string `json:"name,omitempty"`

	// List of the device neighbors.
	Neighbors []*DiscoveryDeviceneighbor `json:"neighbors,omitempty"`

	// The ref to the network to which belongs the management IP address belongs.
	Network string `json:"network,omitempty"`

	// The list of networks to which the device interfaces belong.
	NetworkInfos []*DiscoveryNetworkinfo `json:"network_infos,omitempty"`

	// The name of the network view in which this device resides.
	NetworkView string `json:"network_view,omitempty"`

	// The list of networks to which the device interfaces belong.
	Networks []*Ipv4Network `json:"networks,omitempty"`

	// The Operating System version running on the device.
	OsVersion string `json:"os_version,omitempty"`

	// The port statistics of the device.
	PortStats *DiscoveryDevicePortstatistics `json:"port_stats,omitempty"`

	// A flag indicated that NI should send enable command when interacting with
	// device.
	PrivilegedPolling *bool `json:"privileged_polling,omitempty"`

	// The type of the device.
	Type string `json:"type,omitempty"`

	// User-defined management IP address of the device.
	UserDefinedMgmtIp *string `json:"user_defined_mgmt_ip,omitempty"`

	// The vendor name of the device.
	Vendor string `json:"vendor,omitempty"`

	// The list of VLAN information associated with the device.
	VlanInfos []*DiscoveryVlaninfo `json:"vlan_infos,omitempty"`
}

func (DiscoveryDevice) ObjectType() string {
	return "discovery:device"
}

func (obj DiscoveryDevice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "name", "network_view"}
	}
	return obj.returnFields
}

// DiscoveryDevicecomponent represents Infoblox object discovery:devicecomponent.
// The device components discovered by Network Automation.
type DiscoveryDevicecomponent struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The component name.
	ComponentName string `json:"component_name,omitempty"`

	// The description of the device component.
	Description string `json:"description,omitempty"`

	// A reference to a device, to which this component belongs to.
	Device string `json:"device,omitempty"`

	// The model of the device component.
	Model string `json:"model,omitempty"`

	// The serial number of the device component.
	Serial string `json:"serial,omitempty"`

	// The type of device component.
	Type string `json:"type,omitempty"`
}

func (DiscoveryDevicecomponent) ObjectType() string {
	return "discovery:devicecomponent"
}

func (obj DiscoveryDevicecomponent) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"component_name", "description", "model", "serial", "type"}
	}
	return obj.returnFields
}

// DiscoveryDeviceinterface represents Infoblox object discovery:deviceinterface.
// Interfaces on devices discovered by Network Automation
type DiscoveryDeviceinterface struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Administrative state of the interface.
	AdminStatus string `json:"admin_status,omitempty"`

	// The configured admin status task info of the interface.
	AdminStatusTaskInfo *DiscoveryPortConfigAdminstatus `json:"admin_status_task_info,omitempty"`

	// Name of the port channel current interface belongs to.
	AggrInterfaceName string `json:"aggr_interface_name,omitempty"`

	// Determines whether to modify the admin status of the interface.
	CapIfAdminStatusInd bool `json:"cap_if_admin_status_ind,omitempty"`

	// The reason that the edit admin status action is not available.
	CapIfAdminStatusNaReason string `json:"cap_if_admin_status_na_reason,omitempty"`

	// Determines whether to modify the description of the interface.
	CapIfDescriptionInd bool `json:"cap_if_description_ind,omitempty"`

	// The reason that the edit description action is not available.
	CapIfDescriptionNaReason string `json:"cap_if_description_na_reason,omitempty"`

	// Determines whether to deprovision a IPv4 network from the interfaces.
	CapIfNetDeprovisioningIpv4Ind bool `json:"cap_if_net_deprovisioning_ipv4_ind,omitempty"`

	// The reason that the deprovision a IPv4 network from the interface.
	CapIfNetDeprovisioningIpv4NaReason string `json:"cap_if_net_deprovisioning_ipv4_na_reason,omitempty"`

	// Determines whether to deprovision a IPv6 network from the interfaces.
	CapIfNetDeprovisioningIpv6Ind bool `json:"cap_if_net_deprovisioning_ipv6_ind,omitempty"`

	// The reason that the deprovision a IPv6 network from the interface.
	CapIfNetDeprovisioningIpv6NaReason string `json:"cap_if_net_deprovisioning_ipv6_na_reason,omitempty"`

	// Determines whether to modify the IPv4 network associated to the interface.
	CapIfNetProvisioningIpv4Ind bool `json:"cap_if_net_provisioning_ipv4_ind,omitempty"`

	// The reason that IPv4 network provisioning is not available.
	CapIfNetProvisioningIpv4NaReason string `json:"cap_if_net_provisioning_ipv4_na_reason,omitempty"`

	// Determines whether to modify the IPv6 network associated to the interface.
	CapIfNetProvisioningIpv6Ind bool `json:"cap_if_net_provisioning_ipv6_ind,omitempty"`

	// The reason that IPv6 network provisioning is not available.
	CapIfNetProvisioningIpv6NaReason string `json:"cap_if_net_provisioning_ipv6_na_reason,omitempty"`

	// Determines whether to modify the VLAN assignement of the interface.
	CapIfVlanAssignmentInd bool `json:"cap_if_vlan_assignment_ind,omitempty"`

	// The reason that VLAN assignment action is not available.
	CapIfVlanAssignmentNaReason string `json:"cap_if_vlan_assignment_na_reason,omitempty"`

	// Determines whether to modify the voice VLAN assignement of the interface.
	CapIfVoiceVlanInd bool `json:"cap_if_voice_vlan_ind,omitempty"`

	// The reason that voice VLAN assignment action is not available.
	CapIfVoiceVlanNaReason string `json:"cap_if_voice_vlan_na_reason,omitempty"`

	// The description of the interface.
	Description string `json:"description,omitempty"`

	// The configured description task info of the interface.
	DescriptionTaskInfo *DiscoveryPortConfigDescription `json:"description_task_info,omitempty"`

	// The ref to the device to which the interface belongs.
	Device string `json:"device,omitempty"`

	// The duplex state of the interface.
	Duplex string `json:"duplex,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// List of IFaddr information associated with the interface.
	IfaddrInfos []*DiscoveryIfaddrinfo `json:"ifaddr_infos,omitempty"`

	// The interface index number, as reported by SNMP.
	Index int `json:"index,omitempty"`

	// Timestamp of the last interface property change detected.
	LastChange *UnixTime `json:"last_change,omitempty"`

	// This field indicates if this is a link aggregation interface.
	LinkAggregation bool `json:"link_aggregation,omitempty"`

	// The MAC address of the interface.
	Mac string `json:"mac,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The interface system name.
	Name string `json:"name,omitempty"`

	// Th name of the network view.
	NetworkView string `json:"network_view,omitempty"`

	// Operating state of the interface.
	OperStatus string `json:"oper_status,omitempty"`

	// The Port Fast status of the interface.
	PortFast string `json:"port_fast,omitempty"`

	// The reference to object(Host/FixedAddress/GridMember) to which this port is
	// reserved.
	ReservedObject string `json:"reserved_object,omitempty"`

	// The interface speed in bps.
	Speed uint32 `json:"speed,omitempty"`

	// Indicates if the interface is tagged as a VLAN trunk or not.
	TrunkStatus string `json:"trunk_status,omitempty"`

	// The type of interface.
	Type string `json:"type,omitempty"`

	// The configured VLAN status task info of the interface.
	VlanInfoTaskInfo *DiscoveryPortConfigVlaninfo `json:"vlan_info_task_info,omitempty"`

	// The list of VLAN information associated with the interface.
	VlanInfos []*DiscoveryVlaninfo `json:"vlan_infos,omitempty"`

	// Aggregated interface name of vPC peer device current port is connected to.
	VpcPeer string `json:"vpc_peer,omitempty"`

	// The reference to vPC peer device.
	VpcPeerDevice string `json:"vpc_peer_device,omitempty"`

	// The description of the Virtual Routing and Forwarding (VRF) associated with
	// the interface.
	VrfDescription string `json:"vrf_description,omitempty"`

	// The name of the Virtual Routing and Forwarding (VRF) associated with the
	// interface.
	VrfName string `json:"vrf_name,omitempty"`

	// The route distinguisher of the Virtual Routing and Forwarding (VRF)
	// associated with the interface.
	VrfRd string `json:"vrf_rd,omitempty"`
}

func (DiscoveryDeviceinterface) ObjectType() string {
	return "discovery:deviceinterface"
}

func (obj DiscoveryDeviceinterface) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "type"}
	}
	return obj.returnFields
}

// DiscoveryDeviceneighbor represents Infoblox object discovery:deviceneighbor.
// The neighbor associated with the device discovered by Network Automation.
type DiscoveryDeviceneighbor struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IPv4 Address or IPv6 Address of the device neighbor.
	Address string `json:"address,omitempty"`

	// The ref to the management IP address of the device neighbor.
	AddressRef string `json:"address_ref,omitempty"`

	// The ref to the device to which the device neighbor belongs.
	Device string `json:"device,omitempty"`

	// The ref to the interface to which the device neighbor belongs.
	Interface string `json:"interface,omitempty"`

	// The MAC address of the device neighbor.
	Mac string `json:"mac,omitempty"`

	// The name of the device neighbor.
	Name string `json:"name,omitempty"`

	// The list of VLAN information associated with the device neighbor.
	VlanInfos []*DiscoveryVlaninfo `json:"vlan_infos,omitempty"`
}

func (DiscoveryDeviceneighbor) ObjectType() string {
	return "discovery:deviceneighbor"
}

func (obj DiscoveryDeviceneighbor) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "address_ref", "mac", "name"}
	}
	return obj.returnFields
}

// DiscoveryDevicesupportbundle represents Infoblox object discovery:devicesupportbundle.
// Infoblox frequently provides support files for additional network devices
// that may not have previously been supported by discovery, and updates to
// support new operating system versions of existing devices.
type DiscoveryDevicesupportbundle struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The developer of the device support bundle.
	Author string `json:"author,omitempty"`

	// Determines whether the device support bundle is integrated or imported. Note
	// that integrated support bundles cannot be removed.
	IntegratedInd bool `json:"integrated_ind,omitempty"`

	// The descriptive device name for the device support bundle.
	Name string `json:"name,omitempty"`

	// The version of the currently active device support bundle.
	Version string `json:"version,omitempty"`
}

func (DiscoveryDevicesupportbundle) ObjectType() string {
	return "discovery:devicesupportbundle"
}

func (obj DiscoveryDevicesupportbundle) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"author", "integrated_ind", "name", "version"}
	}
	return obj.returnFields
}

// DiscoveryDiagnostictask represents Infoblox object discovery:diagnostictask.
// The object provides information about the discovery diagnostic task.
type DiscoveryDiagnostictask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The SNMP community string of the discovery diagnostic task.
	CommunityString *string `json:"community_string,omitempty"`

	// The SNMP debug flag of the discovery diagnostic task.
	DebugSnmp *bool `json:"debug_snmp,omitempty"`

	// The force test flag of the discovery diagnostic task.
	ForceTest *bool `json:"force_test,omitempty"`

	// The IP address of the discovery diagnostic task.
	IpAddress *string `json:"ip_address,omitempty"`

	// The network view name of the discovery diagnostic task.
	NetworkView *string `json:"network_view,omitempty"`

	// The time when the discovery diagnostic task was started.
	StartTime *UnixTime `json:"start_time,omitempty"`

	// The ID of the discovery diagnostic task.
	TaskId *string `json:"task_id,omitempty"`
}

func (DiscoveryDiagnostictask) ObjectType() string {
	return "discovery:diagnostictask"
}

func (obj DiscoveryDiagnostictask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ip_address", "network_view", "task_id"}
	}
	return obj.returnFields
}

// DiscoveryGridproperties represents Infoblox object discovery:gridproperties.
// The object provides information about the Grid discovery properties.
type DiscoveryGridproperties struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Discovery advanced polling settings.
	AdvancedPollingSettings *DiscoveryAdvancedpollsetting `json:"advanced_polling_settings,omitempty"`

	// Discovery advanced polling settings.
	AdvancedSdnPollingSettings *DiscoveryAdvancedsdnpollsettings `json:"advanced_sdn_polling_settings,omitempty"`

	// Advisor settings.
	AdvisorSettings *DiscoveryAdvisorsetting `json:"advisor_settings,omitempty"`

	// Automatic conversion settings.
	AutoConversionSettings []*DiscoveryAutoconversionsetting `json:"auto_conversion_settings,omitempty"`

	// Discovery basic polling settings.
	BasicPollingSettings *DiscoveryBasicpollsettings `json:"basic_polling_settings,omitempty"`

	// Discovery basic polling settings.
	BasicSdnPollingSettings *DiscoveryBasicsdnpollsettings `json:"basic_sdn_polling_settings,omitempty"`

	// Discovery CLI credentials.
	CliCredentials []*DiscoveryClicredential `json:"cli_credentials,omitempty"`

	// Discovery blackout setting.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The type of the devices the DNS processor operates on.
	DnsLookupOption string `json:"dns_lookup_option,omitempty"`

	// The percentage of available capacity the DNS processor operates at. Valid
	// values are unsigned integer between 1 and 100, inclusive.
	DnsLookupThrottle *uint32 `json:"dns_lookup_throttle,omitempty"`

	// Advisor application enabled/disabled.
	EnableAdvisor *bool `json:"enable_advisor,omitempty"`

	// The flag that enables automatic conversion of discovered data.
	EnableAutoConversion *bool `json:"enable_auto_conversion,omitempty"`

	// The flag that enables updating discovered data for managed objects.
	EnableAutoUpdates *bool `json:"enable_auto_updates,omitempty"`

	// The Grid name.
	GridName string `json:"grid_name,omitempty"`

	// Determines the timeout to ignore the discovery conflict duration (in
	// seconds).
	IgnoreConflictDuration *uint32 `json:"ignore_conflict_duration,omitempty"`

	// Port control blackout setting.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// Ports to scan.
	Ports []*DiscoveryPort `json:"ports,omitempty"`

	// Determines if the same port control is used for discovery blackout.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// Discovery SNMP v1 and v2 credentials.
	Snmpv1v2Credentials []*DiscoverySnmpcredential `json:"snmpv1v2_credentials,omitempty"`

	// Discovery SNMP v3 credentials.
	Snmpv3Credentials []*DiscoverySnmp3credential `json:"snmpv3_credentials,omitempty"`

	// Limit of discovered unmanaged IP address which determines how frequently the
	// user is notified about the new unmanaged IP address in a particular network.
	UnmanagedIpsLimit *uint32 `json:"unmanaged_ips_limit,omitempty"`

	// Determines the timeout between two notifications (in seconds) about the new
	// unmanaged IP address in a particular network. The value must be between 60
	// seconds and the number of seconds remaining to Jan 2038.
	UnmanagedIpsTimeout *uint32 `json:"unmanaged_ips_timeout,omitempty"`

	// The policy type used to define the behavior of the VRF mapping.
	VrfMappingPolicy string `json:"vrf_mapping_policy,omitempty"`

	// VRF mapping rules.
	VrfMappingRules []*DiscoveryVrfmappingrule `json:"vrf_mapping_rules,omitempty"`
}

func (DiscoveryGridproperties) ObjectType() string {
	return "discovery:gridproperties"
}

func (obj DiscoveryGridproperties) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"grid_name"}
	}
	return obj.returnFields
}

// DiscoveryMemberproperties represents Infoblox object discovery:memberproperties.
// The object provides information about the Grid member discovery properties.
type DiscoveryMemberproperties struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid member address IP address.
	Address string `json:"address,omitempty"`

	// Discovery CLI credentials.
	CliCredentials []*DiscoveryClicredential `json:"cli_credentials,omitempty"`

	// Default seed routers.
	DefaultSeedRouters []*DiscoverySeedrouter `json:"default_seed_routers,omitempty"`

	// The name of the network discovery Grid member.
	DiscoveryMember string `json:"discovery_member,omitempty"`

	// Determines if the discovery service is enabled.
	EnableService *bool `json:"enable_service,omitempty"`

	// Gateway seed routers.
	GatewaySeedRouters []*DiscoverySeedrouter `json:"gateway_seed_routers,omitempty"`

	// Determines if the standalone mode for discovery network monitor is enabled
	// or not.
	IsSa *bool `json:"is_sa,omitempty"`

	// Discovery member role.
	Role string `json:"role,omitempty"`

	// Discovery networks to which the member is assigned.
	ScanInterfaces []*DiscoveryScaninterface `json:"scan_interfaces,omitempty"`

	// List of SDN/SDWAN controller configurations.
	SdnConfigs []*DiscoverySdnconfig `json:"sdn_configs,omitempty"`

	// Seed routers.
	SeedRouters []*DiscoverySeedrouter `json:"seed_routers,omitempty"`

	// Discovery SNMP v1 and v2 credentials.
	Snmpv1v2Credentials []*DiscoverySnmpcredential `json:"snmpv1v2_credentials,omitempty"`

	// Discovery SNMP v3 credentials.
	Snmpv3Credentials []*DiscoverySnmp3credential `json:"snmpv3_credentials,omitempty"`

	// Use flag for: cli_credentials
	UseCliCredentials *bool `json:"use_cli_credentials,omitempty"`

	// Use flag for: snmpv1v2_credentials
	UseSnmpv1v2Credentials *bool `json:"use_snmpv1v2_credentials,omitempty"`

	// Use flag for: snmpv3_credentials
	UseSnmpv3Credentials *bool `json:"use_snmpv3_credentials,omitempty"`
}

func (DiscoveryMemberproperties) ObjectType() string {
	return "discovery:memberproperties"
}

func (obj DiscoveryMemberproperties) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"discovery_member"}
	}
	return obj.returnFields
}

// DiscoverySdnnetwork represents Infoblox object discovery:sdnnetwork.
// This object provides information about the SDN networks. They are the
// elements of address space hierarchy discovered on SDN/SDWAN controllers
type DiscoverySdnnetwork struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Timestamp when this SDN network was first discovered.
	FirstSeen *UnixTime `json:"first_seen,omitempty"`

	// The name of the SDN network.
	Name string `json:"name,omitempty"`

	// The name of the network view assigned to this SDN network.
	NetworkView string `json:"network_view,omitempty"`

	// Name of SDN configuration this network belongs to.
	SourceSdnConfig string `json:"source_sdn_config,omitempty"`
}

func (DiscoverySdnnetwork) ObjectType() string {
	return "discovery:sdnnetwork"
}

func (obj DiscoverySdnnetwork) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "network_view", "source_sdn_config"}
	}
	return obj.returnFields
}

// DiscoveryStatus represents Infoblox object discovery:status.
// The discovery status of discovered data
type DiscoveryStatus struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IPv4 Address or IPv6 Address of the device.
	Address string `json:"address,omitempty"`

	// Indicates if CLI collection is enabled.
	CliCollectionEnabled bool `json:"cli_collection_enabled,omitempty"`

	// The CLI credential status information of the device.
	CliCredentialInfo *DiscoveryStatusinfo `json:"cli_credential_info,omitempty"`

	// The existence status information of the device.
	ExistenceInfo *DiscoveryStatusinfo `json:"existence_info,omitempty"`

	// Indicates if DHCP finterprinting is enabled.
	FingerprintEnabled bool `json:"fingerprint_enabled,omitempty"`

	// This DHCP finterprinting status information of the device.
	FingerprintInfo *DiscoveryStatusinfo `json:"fingerprint_info,omitempty"`

	// The timestamp when the device was first discovered.
	FirstSeen *UnixTime `json:"first_seen,omitempty"`

	// The timestamp of the last detected interface property change.
	LastAction string `json:"last_action,omitempty"`

	// The timestamp when the device was last discovered.
	LastSeen *UnixTime `json:"last_seen,omitempty"`

	// The timestamp of the last executed action for the device.
	LastTimestamp *UnixTime `json:"last_timestamp,omitempty"`

	// The name of the device.
	Name string `json:"name,omitempty"`

	// The name of the network view in which this device resides.
	NetworkView string `json:"network_view,omitempty"`

	// The reachable status information of the device.
	ReachableInfo *DiscoveryStatusinfo `json:"reachable_info,omitempty"`

	// Indicate whether SDN collection enabled for the device.
	SdnCollectionEnabled bool `json:"sdn_collection_enabled,omitempty"`

	// Device SDN collection status information.
	SdnCollectionInfo *DiscoveryStatusinfo `json:"sdn_collection_info,omitempty"`

	// Indicates if SNMP collection is enabled.
	SnmpCollectionEnabled bool `json:"snmp_collection_enabled,omitempty"`

	// The SNMP collection status information of the device.
	SnmpCollectionInfo *DiscoveryStatusinfo `json:"snmp_collection_info,omitempty"`

	// The SNMP credential status information of the device.
	SnmpCredentialInfo *DiscoveryStatusinfo `json:"snmp_credential_info,omitempty"`

	// The overall status of the device.
	Status string `json:"status,omitempty"`

	// The type of device.
	Type string `json:"type,omitempty"`
}

func (DiscoveryStatus) ObjectType() string {
	return "discovery:status"
}

func (obj DiscoveryStatus) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "name", "network_view", "status"}
	}
	return obj.returnFields
}

// DiscoveryVrf represents Infoblox object discovery:vrf.
// This object provides information about the virtual network membership (VRF).
type DiscoveryVrf struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Additional information about the VRF.
	Description string `json:"description,omitempty"`

	// The device to which the VRF belongs.
	Device string `json:"device,omitempty"`

	// The name of the VRF.
	Name string `json:"name,omitempty"`

	// The name of the network view in which this VRF resides.
	NetworkView string `json:"network_view,omitempty"`

	// The route distinguisher associated with the VRF.
	RouteDistinguisher string `json:"route_distinguisher,omitempty"`
}

func (DiscoveryVrf) ObjectType() string {
	return "discovery:vrf"
}

func (obj DiscoveryVrf) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"device", "name", "network_view", "route_distinguisher"}
	}
	return obj.returnFields
}

// Discoverytask represents Infoblox object discoverytask.
// Represents the configuration of network discovery jobs. Configuration
// parameters have control over the behavior of network discovery jobs.
type Discoverytask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The network discovery CSV file name.
	CsvFileName string `json:"csv_file_name,omitempty"`

	// Determines whether IP scanning is disabled.
	DisableIpScanning *bool `json:"disable_ip_scanning,omitempty"`

	// Determines whether VMWare scanning is disabled.
	DisableVmwareScanning *bool `json:"disable_vmware_scanning,omitempty"`

	// The discovery task identifier.
	DiscoveryTaskOid string `json:"discovery_task_oid,omitempty"`

	// The Grid member that runs the discovery.
	MemberName *string `json:"member_name,omitempty"`

	// Determines whether to replace or merge new data with existing data.
	MergeData *bool `json:"merge_data,omitempty"`

	// Network discovery scanning mode.
	Mode string `json:"mode,omitempty"`

	// Name of the network view in which target networks for network discovery
	// reside.
	NetworkView *string `json:"network_view,omitempty"`

	// The list of the networks on which the network discovery will be invoked.
	Networks []*Ipv4Network `json:"networks,omitempty"`

	// The number of times to perfrom ping for ICMP and FULL modes.
	PingRetries *uint32 `json:"ping_retries,omitempty"`

	// The ping timeout for ICMP and FULL modes.
	PingTimeout *uint32 `json:"ping_timeout,omitempty"`

	// The schedule setting for network discovery task.
	ScheduledRun *SettingSchedule `json:"scheduled_run,omitempty"`

	// The network discovery process state.
	State string `json:"state,omitempty"`

	// Time when the network discovery process state was last updated.
	StateTime *UnixTime `json:"state_time,omitempty"`

	// The network discovery process descriptive status.
	Status string `json:"status,omitempty"`

	// The time when the network discovery process status was last updated.
	StatusTime *UnixTime `json:"status_time,omitempty"`

	// The ports to scan for FULL and TCP modes.
	TcpPorts []*Discoverytaskport `json:"tcp_ports,omitempty"`

	// The TCP scan techinque for FULL and TCP modes.
	TcpScanTechnique string `json:"tcp_scan_technique,omitempty"`

	// Name of the network view in which target networks for VMWare scanning
	// reside.
	VNetworkView *string `json:"v_network_view,omitempty"`

	// The list of VMware vSphere servers for VM discovery.
	Vservers []*Discoverytaskvserver `json:"vservers,omitempty"`

	// The network discovery process warning.
	Warning string `json:"warning,omitempty"`
}

func (Discoverytask) ObjectType() string {
	return "discoverytask"
}

func (obj Discoverytask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"discovery_task_oid", "member_name"}
	}
	return obj.returnFields
}

// Distributionschedule represents Infoblox object distributionschedule.
// Distributing the software upgrade files involves unpacking the software
// files and loading the new software. When you distribute the files, the NIOS
// appliance loads the new software code into an alternative disk partition
// that overwrites any previously saved version of existing code. Therefore,
// starting the distribution disables the appliance from reverting to a release
// prior to the current version. The Grid Master distributes the software
// upgrade to each member in the Grid including itself.
type Distributionschedule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the distribution schedule is active.
	Active *bool `json:"active,omitempty"`

	// The start time of the distribution.
	StartTime *UnixTime `json:"start_time,omitempty"`

	// Time zone of the distribution start time.
	TimeZone string `json:"time_zone,omitempty"`

	// The upgrade groups scheduling settings.
	UpgradeGroups []*UpgradegroupSchedule `json:"upgrade_groups,omitempty"`
}

func (Distributionschedule) ObjectType() string {
	return "distributionschedule"
}

func (obj Distributionschedule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"active", "start_time", "time_zone"}
	}
	return obj.returnFields
}

// Dns64group represents Infoblox object dns64group.
// To support the increasing number of IPv6 and dual-stack networks, Infoblox
// DNS servers now support DNS64, a mechanism that synthesizes AAAA records
// from A records when no AAAA records exist.
type Dns64group struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Access Control settings that contain IPv4 and IPv6 DNS clients and networks
	// to which the DNS server is allowed to send synthesized AAAA records with the
	// specified IPv6 prefix.
	Clients []*Addressac `json:"clients,omitempty"`

	// The descriptive comment for the DNS64 synthesis group object.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the DNS64 synthesis group is disabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines whether the DNS64 synthesis of AAAA records is enabled for DNS64
	// synthesis groups that request DNSSEC data.
	EnableDnssecDns64 *bool `json:"enable_dnssec_dns64,omitempty"`

	// Access Control settings that contain IPv6 addresses or prefix ranges that
	// cannot be used by IPv6-only hosts, such as IP addresses in the ::ffff:0:0/96
	// network. When DNS server retrieves an AAAA record that contains an IPv6
	// address that matches an excluded address, it does not return the AAAA
	// record. Instead it synthesizes an AAAA record from the A record.
	Exclude []*Addressac `json:"exclude,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Access Control settings that contain IPv4 addresses and networks for which
	// the DNS server can synthesize AAAA records with the specified prefix.
	Mapped []*Addressac `json:"mapped,omitempty"`

	// The name of the DNS64 synthesis group object.
	Name *string `json:"name,omitempty"`

	// The IPv6 prefix used for the synthesized AAAA records. The prefix length
	// must be /32, /40, /48, /56, /64 or /96, and all bits beyond the specified
	// length must be zero.
	Prefix *string `json:"prefix,omitempty"`
}

func (Dns64group) ObjectType() string {
	return "dns64group"
}

func (obj Dns64group) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disable", "name"}
	}
	return obj.returnFields
}

// Dtc represents Infoblox object dtc.
// This object can be used to control the DTC functionality of the appliance.
type Dtc struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`
}

func (Dtc) ObjectType() string {
	return "dtc"
}

func (obj Dtc) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// DtcAllrecords represents Infoblox object dtc:allrecords.
// The DTC AllRecords object is a read-only synthetic object used to retrieve
// records that belong to a particular DTC server.
type DtcAllrecords struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The record comment.
	Comment string `json:"comment,omitempty"`

	// The disable value determines if the record is disabled or not. "False" means
	// the record is enabled.
	Disable bool `json:"disable,omitempty"`

	// The name of the DTC Server object with which the record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The record object, if supported by the WAPI. Otherwise, the value is "None".
	Record string `json:"record,omitempty"`

	// The TTL value of the record associated with the DTC AllRecords object.
	Ttl *uint32 `json:"ttl,omitempty"`

	// The record type. When searching for an unspecified record type, the search
	// is performed for all records. On retrieval, the appliance returns
	// "UNSUPPORTED" for unsupported records.
	Type string `json:"type,omitempty"`
}

func (DtcAllrecords) ObjectType() string {
	return "dtc:allrecords"
}

func (obj DtcAllrecords) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "dtc_server", "type"}
	}
	return obj.returnFields
}

// DtcCertificate represents Infoblox object dtc:certificate.
// These are DTC health monitor certificates.
type DtcCertificate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Reference to underlying X509Certificate.
	Certificate string `json:"certificate,omitempty"`

	// Determines whether the certificate is in use or not.
	InUse bool `json:"in_use,omitempty"`
}

func (DtcCertificate) ObjectType() string {
	return "dtc:certificate"
}

func (obj DtcCertificate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// DtcLbdn represents Infoblox object dtc:lbdn.
// Load Balanced Domain Name (LBDN) is a Load balanced domain name record type,
// which is served by Infoblox Name Servers. LBDN is a qualified domain name
// associated with a specific service such as ftp.abc.com or www.abc.com.
type DtcLbdn struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// List of linked auth zones.
	AuthZones []*ZoneAuth `json:"auth_zones,omitempty"`

	// Flag for enabling auto managing DTC Consolidated Monitors on related DTC
	// Pools.
	AutoConsolidatedMonitors *bool `json:"auto_consolidated_monitors,omitempty"`

	// Comment for the DTC LBDN; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the DTC LBDN is disabled or not. When this is set to
	// False, the fixed address is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The LBDN health information.
	Health *DtcHealth `json:"health,omitempty"`

	// The load balancing method. Used to select pool.
	LbMethod string `json:"lb_method,omitempty"`

	// The display name of the DTC LBDN, not DNS related.
	Name *string `json:"name,omitempty"`

	// LBDN wildcards for pattern match.
	Patterns []string `json:"patterns,omitempty"`

	// Maximum time, in seconds, for which client specific LBDN responses will be
	// cached. Zero specifies no caching.
	Persistence *uint32 `json:"persistence,omitempty"`

	// The maximum time, in seconds, for which client specific LBDN responses will
	// be cached. Zero specifies no caching.
	Pools []*DtcPoolLink `json:"pools,omitempty"`

	// The LBDN pattern match priority for "overlapping" DTC LBDN objects. LBDNs
	// are "overlapping" if they are simultaneously assigned to a zone and have
	// patterns that can match the same FQDN. The matching LBDN with highest
	// priority (lowest ordinal) will be used.
	Priority *uint32 `json:"priority,omitempty"`

	// The topology rules for TOPOLOGY method.
	Topology *string `json:"topology,omitempty"`

	// The Time To Live (TTL) value for the DTC LBDN. A 32-bit unsigned integer
	// that represents the duration, in seconds, for which the record is valid
	// (cached). Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// The list of resource record types supported by LBDN.
	Types []string `json:"types,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcLbdn) ObjectType() string {
	return "dtc:lbdn"
}

func (obj DtcLbdn) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitor represents Infoblox object dtc:monitor.
// The DTC Monitor object is used to determine the health of a server by
// evaluating the response to a health request.
type DtcMonitor struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for a health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The actual monitor object.
	Monitor *string `json:"monitor,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// The health monitor port value.
	Port *uint32 `json:"port,omitempty"`

	// The number of how many times the server should appear as "DOWN" to be
	// treated as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The number of many times the server should appear as "UP" to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for a health check.
	Timeout *uint32 `json:"timeout,omitempty"`

	// The request transport type.
	Type string `json:"type,omitempty"`
}

func (DtcMonitor) ObjectType() string {
	return "dtc:monitor"
}

func (obj DtcMonitor) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "type"}
	}
	return obj.returnFields
}

// DtcMonitorHttp represents Infoblox object dtc:monitor:http.
// The DTC HTTP monitor object is used to determine the health of a HTTP
// service by first sending a specific http message to a server and then
// examining the response received from the server. The validation is
// successful if the received response matches the expected message.
type DtcMonitorHttp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// An optional cipher list for a secure HTTP/S connection.
	Ciphers *string `json:"ciphers,omitempty"`

	// An optional client certificate, supplied in a secure HTTP/S mode if present.
	ClientCert *string `json:"client_cert,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The content check type.
	ContentCheck string `json:"content_check,omitempty"`

	// A portion of response to use as input for content check.
	ContentCheckInput string `json:"content_check_input,omitempty"`

	// A content check success criteria operator.
	ContentCheckOp string `json:"content_check_op,omitempty"`

	// A content check regular expression.
	ContentCheckRegex *string `json:"content_check_regex,omitempty"`

	// A content extraction sub-expression to extract.
	ContentExtractGroup *uint32 `json:"content_extract_group,omitempty"`

	// A content extraction expected type for the extracted data.
	ContentExtractType string `json:"content_extract_type,omitempty"`

	// A content extraction value to compare with extracted result.
	ContentExtractValue *string `json:"content_extract_value,omitempty"`

	// Determines whether the Server Name Indication (SNI) for HTTPS monitor is
	// enabled.
	EnableSni *bool `json:"enable_sni,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// Port for TCP requests.
	Port *uint32 `json:"port,omitempty"`

	// An HTTP request to send.
	Request *string `json:"request,omitempty"`

	// The type of an expected result.
	Result string `json:"result,omitempty"`

	// The expected return code.
	ResultCode *uint32 `json:"result_code,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The connection security status.
	Secure *bool `json:"secure,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`

	// Determines whether the validation of the remote server's certificate is
	// enabled.
	ValidateCert *bool `json:"validate_cert,omitempty"`
}

func (DtcMonitorHttp) ObjectType() string {
	return "dtc:monitor:http"
}

func (obj DtcMonitorHttp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitorIcmp represents Infoblox object dtc:monitor:icmp.
// The DTC ICMP monitor object is used to determine the health of a server by
// monitoring the response to an ICMP ping.
type DtcMonitorIcmp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`
}

func (DtcMonitorIcmp) ObjectType() string {
	return "dtc:monitor:icmp"
}

func (obj DtcMonitorIcmp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitorPdp represents Infoblox object dtc:monitor:pdp.
// The DTC PDP monitor object is used to determine the health of a server by
// sending a PDP ECHO and considering a valid reply to mean that service is
// available.
type DtcMonitorPdp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// The port value for PDP requests.
	Port *uint32 `json:"port,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`
}

func (DtcMonitorPdp) ObjectType() string {
	return "dtc:monitor:pdp"
}

func (obj DtcMonitorPdp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitorSip represents Infoblox object dtc:monitor:sip.
// The DTC SIP monitor object is used to determine the health of a SIP server
// such as SIP Proxies and Session Border Controllers, and SIP gateways by
// issuing SIP options to a server and examining the response provided by the
// server. The service is considered available If the received response matches
// the expected response.
type DtcMonitorSip struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// An optional cipher list for secure TLS/SIPS connection.
	Ciphers *string `json:"ciphers,omitempty"`

	// An optional client certificate, supplied in TLS and SIPS mode if present.
	ClientCert *string `json:"client_cert,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// The port value for SIP requests.
	Port *uint32 `json:"port,omitempty"`

	// A SIP request to send
	Request *string `json:"request,omitempty"`

	// The type of an expected result.
	Result string `json:"result,omitempty"`

	// The expected return code value.
	ResultCode *uint32 `json:"result_code,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`

	// The transport layer protocol to use for SIP check.
	Transport string `json:"transport,omitempty"`

	// Determines whether the validation of the remote server's certificate is
	// enabled.
	ValidateCert *bool `json:"validate_cert,omitempty"`
}

func (DtcMonitorSip) ObjectType() string {
	return "dtc:monitor:sip"
}

func (obj DtcMonitorSip) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitorSnmp represents Infoblox object dtc:monitor:snmp.
// The DTC SNMP Health Monitor determines the health of SNMP servers, such as
// SNMP Proxies and Session Border Controllers, and SNMP gateways by issuing
// SNMP options to a server and examining the response sent by the server. The
// service is considered available if the returned response matches the
// expected response.
type DtcMonitorSnmp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The SNMP community string for SNMP authentication.
	Community *string `json:"community,omitempty"`

	// The SNMPv3 context.
	Context *string `json:"context,omitempty"`

	// The SNMPv3 engine identifier.
	EngineId *string `json:"engine_id,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// A list of OIDs for SNMP monitoring.
	Oids []*DtcMonitorSnmpOid `json:"oids,omitempty"`

	// The port value for SNMP requests.
	Port *uint32 `json:"port,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`

	// The SNMPv3 user setting.
	User *string `json:"user,omitempty"`

	// The SNMP protocol version for the SNMP health check.
	Version string `json:"version,omitempty"`
}

func (DtcMonitorSnmp) ObjectType() string {
	return "dtc:monitor:snmp"
}

func (obj DtcMonitorSnmp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcMonitorTcp represents Infoblox object dtc:monitor:tcp.
// The DTC TCP monitor object is used to determine the health of a server by
// evaluating the response to a TCP request.
type DtcMonitorTcp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this DTC monitor; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The interval for TCP health check.
	Interval *uint32 `json:"interval,omitempty"`

	// The display name for this DTC monitor.
	Name *string `json:"name,omitempty"`

	// The port value for TCP requests.
	Port *uint32 `json:"port,omitempty"`

	// The value of how many times the server should appear as down to be treated
	// as dead after it was alive.
	RetryDown *uint32 `json:"retry_down,omitempty"`

	// The value of how many times the server should appear as up to be treated as
	// alive after it was dead.
	RetryUp *uint32 `json:"retry_up,omitempty"`

	// The timeout for TCP health check in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`
}

func (DtcMonitorTcp) ObjectType() string {
	return "dtc:monitor:tcp"
}

func (obj DtcMonitorTcp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcObject represents Infoblox object dtc:object.
// An object for all load balancer managed DTC objects.
type DtcObject struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The abstract object type.
	AbstractType string `json:"abstract_type,omitempty"`

	// The comment for the DTC object; maximum 256 characters.
	Comment string `json:"comment,omitempty"`

	// The display object type.
	DisplayType string `json:"display_type,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of IPv4 addresses.
	Ipv4AddressList []string `json:"ipv4_address_list,omitempty"`

	// The list of IPv6 addresses.
	Ipv6AddressList []string `json:"ipv6_address_list,omitempty"`

	// The display name of the DTC object.
	Name string `json:"name,omitempty"`

	// The specific DTC object.
	Object string `json:"object,omitempty"`

	// The availability color status.
	Status string `json:"status,omitempty"`

	// The timestamp when status or health was last determined.
	StatusTime *UnixTime `json:"status_time,omitempty"`
}

func (DtcObject) ObjectType() string {
	return "dtc:object"
}

func (obj DtcObject) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"abstract_type", "comment", "display_type", "name", "status"}
	}
	return obj.returnFields
}

// DtcPool represents Infoblox object dtc:pool.
// The collection of IDNS resources (virtual servers).
type DtcPool struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Flag for enabling auto managing DTC Consolidated Monitors in DTC Pool.
	AutoConsolidatedMonitors *bool `json:"auto_consolidated_monitors,omitempty"`

	// A resource in the pool is available if ANY, at least QUORUM, or ALL monitors
	// for the pool say that it is up.
	Availability string `json:"availability,omitempty"`

	// The comment for the DTC Pool; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// List of monitors and associated members statuses of which are shared across
	// members and consolidated in server availability determination.
	ConsolidatedMonitors []*DtcPoolConsolidatedMonitorHealth `json:"consolidated_monitors,omitempty"`

	// Determines whether the DTC Pool is disabled or not. When this is set to
	// False, the fixed address is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The health status.
	Health *DtcHealth `json:"health,omitempty"`

	// The alternate load balancing method. Use this to select a method type from
	// the pool if the preferred method does not return any results.
	LbAlternateMethod string `json:"lb_alternate_method,omitempty"`

	// The alternate topology for load balancing.
	LbAlternateTopology *string `json:"lb_alternate_topology,omitempty"`

	// The DTC Pool settings for dynamic ratio when it's selected as alternate
	// method.
	LbDynamicRatioAlternate *SettingDynamicratio `json:"lb_dynamic_ratio_alternate,omitempty"`

	// The DTC Pool settings for dynamic ratio when it's selected as preferred
	// method.
	LbDynamicRatioPreferred *SettingDynamicratio `json:"lb_dynamic_ratio_preferred,omitempty"`

	// The preferred load balancing method. Use this to select a method type from
	// the pool.
	LbPreferredMethod string `json:"lb_preferred_method,omitempty"`

	// The preferred topology for load balancing.
	LbPreferredTopology *string `json:"lb_preferred_topology,omitempty"`

	// The monitors related to pool.
	Monitors []*DtcMonitorHttp `json:"monitors,omitempty"`

	// The DTC Pool display name.
	Name *string `json:"name,omitempty"`

	// For availability mode QUORUM, at least this many monitors must report the
	// resource as up for it to be available
	Quorum *uint32 `json:"quorum,omitempty"`

	// The servers related to the pool.
	Servers []*DtcServerLink `json:"servers,omitempty"`

	// The Time To Live (TTL) value for the DTC Pool. A 32-bit unsigned integer
	// that represents the duration, in seconds, for which the record is valid
	// (cached). Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcPool) ObjectType() string {
	return "dtc:pool"
}

func (obj DtcPool) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcRecordA represents Infoblox object dtc:record:a.
// A DTC A object represents a DNS Traffic Control Address (DTC A) resource
// record. This resource record specifies mapping from domain name to IPv4
// address.
type DtcRecordA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Flag that indicates whether this record was automatically created by NIOS.
	AutoCreated string `json:"auto_created,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the DTC Server object with which the DTC record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The IPv4 Address of the domain name.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcRecordA) ObjectType() string {
	return "dtc:record:a"
}

func (obj DtcRecordA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dtc_server", "ipv4addr"}
	}
	return obj.returnFields
}

// DtcRecordAaaa represents Infoblox object dtc:record:aaaa.
// A DTC AAAA object represents a DNS Traffic Control IPv6 Address (DTC AAAA)
// resource record. This resource record specifies mapping from domain name to
// IPv6 address.
type DtcRecordAaaa struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Flag that indicates whether this record was automatically created by NIOS.
	AutoCreated string `json:"auto_created,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the DTC Server object with which the DTC record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The IPv6 Address of the domain name.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcRecordAaaa) ObjectType() string {
	return "dtc:record:aaaa"
}

func (obj DtcRecordAaaa) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dtc_server", "ipv6addr"}
	}
	return obj.returnFields
}

// DtcRecordCname represents Infoblox object dtc:record:cname.
// A DTC CNAME object represents a DNS Traffic Control Canonical name (DTC
// CNAME) resource record. DTC CNAME record maps domain name alias to its
// canonical domain name.
type DtcRecordCname struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Flag that indicates whether this record was automatically created by NIOS.
	AutoCreated string `json:"auto_created,omitempty"`

	// The canonical name of the host.
	Canonical *string `json:"canonical,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The canonical name as server by DNS protocol.
	DnsCanonical string `json:"dns_canonical,omitempty"`

	// The name of the DTC Server object with which the DTC record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcRecordCname) ObjectType() string {
	return "dtc:record:cname"
}

func (obj DtcRecordCname) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "dtc_server"}
	}
	return obj.returnFields
}

// DtcRecordNaptr represents Infoblox object dtc:record:naptr.
// A DTC NAPTR object represents a DNS Traffic Control Naming Authority Pointer
// (DTC NAPTR) resource record. This resource record specifies a regular
// expression-based rewrite rule that, when applied to an existing string,
// produces a new domain name or URI.
type DtcRecordNaptr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the DTC Server object with which the DTC record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The flags used to control the interpretation of the fields for an NAPTR
	// record object. Supported values for the flags field are "U", "S", "P" and
	// "A".
	Flags *string `json:"flags,omitempty"`

	// The order parameter of the NAPTR records. This parameter specifies the order
	// in which the NAPTR rules are applied when multiple rules are present. Valid
	// values are from 0 to 65535 (inclusive), in 32-bit unsigned integer format.
	Order *uint32 `json:"order,omitempty"`

	// The preference of the NAPTR record. The preference field determines the
	// order the NAPTR records are processed when multiple records with the same
	// order parameter are present. Valid values are from 0 to 65535 (inclusive),
	// in 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// The regular expression-based rewriting rule of the NAPTR record. This should
	// be a POSIX compliant regular expression, including the substitution rule and
	// flags. Refer to RFC 2915 for the field syntax details.
	Regexp *string `json:"regexp,omitempty"`

	// The replacement field of the NAPTR record object. For nonterminal NAPTR
	// records, this field specifies the next domain name to look up. This value
	// can be in unicode format.
	Replacement *string `json:"replacement,omitempty"`

	// The services field of the NAPTR record object; maximum 128 characters. The
	// services field contains protocol and service identifiers, such as "http+E2U"
	// or "SIPS+D2T".
	Services *string `json:"services,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (DtcRecordNaptr) ObjectType() string {
	return "dtc:record:naptr"
}

func (obj DtcRecordNaptr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dtc_server", "order", "preference", "regexp", "replacement", "services"}
	}
	return obj.returnFields
}

// DtcRecordSrv represents Infoblox object dtc:record:srv.
// A DTC SRV object represents a DNS Traffic Control (DTC SRV) resource record.
// This resource record provides information on available services.
type DtcRecordSrv struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the DTC Server object with which the DTC record is associated.
	DtcServer string `json:"dtc_server,omitempty"`

	// The name for an SRV record in unicode format.
	Name *string `json:"name,omitempty"`

	// The port of the SRV record. Valid values are from 0 to 65535 (inclusive), in
	// 32-bit unsigned integer format.
	Port *uint32 `json:"port,omitempty"`

	// The priority of the SRV record. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Priority *uint32 `json:"priority,omitempty"`

	// The target of the SRV record in FQDN format. This value can be in unicode
	// format.
	Target *string `json:"target,omitempty"`

	// The Time to Live (TTL) value.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The weight of the SRV record. Valid values are from 0 to 65535 (inclusive),
	// in 32-bit unsigned integer format.
	Weight *uint32 `json:"weight,omitempty"`
}

func (DtcRecordSrv) ObjectType() string {
	return "dtc:record:srv"
}

func (obj DtcRecordSrv) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dtc_server", "name", "port", "priority", "target", "weight"}
	}
	return obj.returnFields
}

// DtcServer represents Infoblox object dtc:server.
// This is a DTC Server. Aka resource, virtual server or pool member.
type DtcServer struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Enabling this option will auto-create a single read-only A/AAAA/CNAME record
	// corresponding to the configured hostname and update it if the hostname
	// changes.
	AutoCreateHostRecord *bool `json:"auto_create_host_record,omitempty"`

	// Comment for the DTC Server; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the DTC Server is disabled or not. When this is set to
	// False, the fixed address is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The health status.
	Health *DtcHealth `json:"health,omitempty"`

	// The address or FQDN of the server.
	Host *string `json:"host,omitempty"`

	// List of IP/FQDN and monitor pairs to be used for additional monitoring.
	Monitors []*DtcServerMonitor `json:"monitors,omitempty"`

	// The DTC Server display name.
	Name *string `json:"name,omitempty"`

	// The hostname for Server Name Indication (SNI) in FQDN format.
	SniHostname *string `json:"sni_hostname,omitempty"`

	// Use flag for: sni_hostname
	UseSniHostname *bool `json:"use_sni_hostname,omitempty"`
}

func (DtcServer) ObjectType() string {
	return "dtc:server"
}

func (obj DtcServer) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "host", "name"}
	}
	return obj.returnFields
}

// DtcTopology represents Infoblox object dtc:topology.
// A topology is a named list of ordered topology rules. Topology rules map
// client IPs to pools or resources. They require the Topology DB and named
// labels refer to it.
type DtcTopology struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the DTC TOPOLOGY monitor object; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Display name of the DTC Topology.
	Name *string `json:"name,omitempty"`

	// Topology rules.
	Rules []*DtcTopologyRule `json:"rules,omitempty"`
}

func (DtcTopology) ObjectType() string {
	return "dtc:topology"
}

func (obj DtcTopology) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// DtcTopologyLabel represents Infoblox object dtc:topology:label.
// This is the label of the field in the Topology database.
type DtcTopologyLabel struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the field in the Topology database the label was obtained from.
	Field string `json:"field,omitempty"`

	// The DTC Topology label name.
	Label string `json:"label,omitempty"`
}

func (DtcTopologyLabel) ObjectType() string {
	return "dtc:topology:label"
}

func (obj DtcTopologyLabel) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"field", "label"}
	}
	return obj.returnFields
}

// DtcTopologyRule represents Infoblox object dtc:topology:rule.
// Topology rules map client IPs to pools or resources. They require the
// Topology DB and named labels refer to it. Can be created only as part of
// topology.
type DtcTopologyRule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The type of the destination for this DTC Topology rule.
	DestType string `json:"dest_type,omitempty"`

	// The reference to the destination DTC pool or DTC server.
	DestinationLink *string `json:"destination_link,omitempty"`

	// Type of the DNS response for rule.
	ReturnType string `json:"return_type,omitempty"`

	// The conditions for matching sources. Should be empty to set rule as default
	// destination.
	Sources []*DtcTopologyRuleSource `json:"sources,omitempty"`

	// The DTC Topology the rule belongs to.
	Topology string `json:"topology,omitempty"`

	// True if the label in the rule exists in the current Topology DB. Always true
	// for SUBNET rules. Rules with non-existent labels may be configured but will
	// never match.
	Valid bool `json:"valid,omitempty"`
}

func (DtcTopologyRule) ObjectType() string {
	return "dtc:topology:rule"
}

func (obj DtcTopologyRule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// DxlEndpoint represents Infoblox object dxl:endpoint.
// The DXL endpoint object represents the settings of a particular DXL
// endpoint.
type DxlEndpoint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of DXL endpoint brokers. Note that you cannot specify brokers and
	// brokers_import_token at the same time.
	Brokers []*DxlEndpointBroker `json:"brokers,omitempty"`

	// The token returned by the uploadinit function call in object fileop for a
	// DXL broker configuration file. Note that you cannot specify brokers and
	// brokers_import_token at the same time.
	BrokersImportToken *string `json:"brokers_import_token,omitempty"`

	// The client certificate subject of a DXL endpoint.
	ClientCertificateSubject string `json:"client_certificate_subject,omitempty"`

	// The token returned by the uploadinit function call in object fileop for a
	// DXL endpoint client certificate.
	ClientCertificateToken *string `json:"client_certificate_token,omitempty"`

	// The timestamp when client certificate for a DXL endpoint was created.
	ClientCertificateValidFrom *UnixTime `json:"client_certificate_valid_from,omitempty"`

	// The timestamp when the client certificate for a DXL endpoint expires.
	ClientCertificateValidTo *UnixTime `json:"client_certificate_valid_to,omitempty"`

	// The comment of a DXL endpoint.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a DXL endpoint is disabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The log level for a DXL endpoint.
	LogLevel string `json:"log_level,omitempty"`

	// The name of a DXL endpoint.
	Name *string `json:"name,omitempty"`

	// The outbound member that will generate events.
	OutboundMemberType string `json:"outbound_member_type,omitempty"`

	// The list of members for outbound events.
	OutboundMembers []string `json:"outbound_members,omitempty"`

	// The DXL template instance. You cannot change the parameters of the DXL
	// endpoint template instance.
	TemplateInstance *NotificationRestTemplateinstance `json:"template_instance,omitempty"`

	// The timeout of session management (in seconds).
	Timeout *uint32 `json:"timeout,omitempty"`

	// DXL topics
	Topics []string `json:"topics,omitempty"`

	// The vendor identifier.
	VendorIdentifier *string `json:"vendor_identifier,omitempty"`

	// The user name for WAPI integration.
	WapiUserName *string `json:"wapi_user_name,omitempty"`

	// The user password for WAPI integration.
	WapiUserPassword *string `json:"wapi_user_password,omitempty"`
}

func (DxlEndpoint) ObjectType() string {
	return "dxl:endpoint"
}

func (obj DxlEndpoint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"disable", "name", "outbound_member_type"}
	}
	return obj.returnFields
}

// EADefinition represents Infoblox object extensibleattributedef.
// The Extensible Attribute Definition object is used to retrieve the
// definition of an extensible attribute.
type EADefinition struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The object types this extensible attribute is allowed to associate with.
	AllowedObjectTypes []string `json:"allowed_object_types,omitempty"`

	// Comment for the Extensible Attribute Definition; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Default value used to pre-populate the attribute value in the GUI. For
	// email, URL, and string types, the value is a string with a maximum of 256
	// characters. For an integer, the value is an integer from -2147483648 through
	// 2147483647. For a date, the value is the number of seconds that have elapsed
	// since January 1st, 1970 UTC.
	DefaultValue *string `json:"default_value,omitempty"`

	// This option describes the action that must be taken on the extensible
	// attribute by its descendant in case the 'Inheritable' flag is set.
	DescendantsAction *ExtensibleattributedefDescendants `json:"descendants_action,omitempty"`

	// This field contains extensible attribute flags. Possible values: (A)udited,
	// (C)loud API, Cloud (G)master, (I)nheritable, (L)isted, (M)andatory value,
	// MGM (P)rivate, (R)ead Only, (S)ort enum values, Multiple (V)alues If there
	// are two or more flags in the field, you must list them according to the
	// order they are listed above. For example, 'CR' is a valid value for the
	// 'flags' field because C = Cloud API is listed before R = Read only. However,
	// the value 'RC' is invalid because the order for the 'flags' field is broken.
	Flags *string `json:"flags,omitempty"`

	// List of Values. Applicable if the extensible attribute type is ENUM.
	ListValues []*EADefListValue `json:"list_values,omitempty"`

	// Maximum allowed value of extensible attribute. Applicable if the extensible
	// attribute type is INTEGER.
	Max *uint32 `json:"max,omitempty"`

	// Minimum allowed value of extensible attribute. Applicable if the extensible
	// attribute type is INTEGER.
	Min *uint32 `json:"min,omitempty"`

	// The name of the Extensible Attribute Definition.
	Name *string `json:"name,omitempty"`

	// Namespace for the Extensible Attribute Definition.
	Namespace string `json:"namespace,omitempty"`

	// Type for the Extensible Attribute Definition.
	Type string `json:"type,omitempty"`
}

func (EADefinition) ObjectType() string {
	return "extensibleattributedef"
}

func (obj EADefinition) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "default_value", "name", "type"}
	}
	return obj.returnFields
}

func NewEADefinition(eadef EADefinition) *EADefinition {
	res := eadef
	res.returnFields = []string{"allowed_object_types", "comment", "flags", "list_values", "name", "type"}

	return &res
}

// Fileop represents Infoblox object fileop.
// This object controls uploading and downloading data from the appliance.
type Fileop struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`
}

func (Fileop) ObjectType() string {
	return "fileop"
}

func (obj Fileop) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// Filterfingerprint represents Infoblox object filterfingerprint.
// The appliance can filter an address request by the DHCP fingerprint of a
// requesting client. Depending on how you apply DHCP fingerprint filters, the
// appliance can grant or deny the address request if the requesting client
// matches the filter criteria.
type Filterfingerprint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of DHCP Fingerprint objects.
	Fingerprint []string `json:"fingerprint,omitempty"`

	// The name of a DHCP Fingerprint Filter object.
	Name *string `json:"name,omitempty"`
}

func (Filterfingerprint) ObjectType() string {
	return "filterfingerprint"
}

func (obj Filterfingerprint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Filtermac represents Infoblox object filtermac.
// An Infoblox appliance can filter address requests by the MAC address and/or
// vendor prefix (i.e., the first 6 hexadecimal characters of the MAC address)
// of a requesting host. The filter instructs the appliance to either grant or
// deny an address request if the requesting host matches the filter.
type Filtermac struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment of a DHCP MAC Filter object.
	Comment *string `json:"comment,omitempty"`

	// The default MAC expiration time of the DHCP MAC Address Filter object. By
	// default, the MAC address filter never expires; otherwise, it is the absolute
	// interval when the MAC address filter expires. The maximum value can extend
	// up to 4294967295 secs. The minimum value is 60 secs (1 min).
	DefaultMacAddressExpiration *uint32 `json:"default_mac_address_expiration,omitempty"`

	// Determines if the DHCP Fingerprint object is disabled or not.
	Disable *bool `json:"disable,omitempty"`

	// The flag to enforce MAC address expiration of the DHCP MAC Address Filter
	// object.
	EnforceExpirationTimes *bool `json:"enforce_expiration_times,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The length of time the DHCP server leases an IP address to a client. The
	// lease time applies to hosts that meet the filter criteria.
	LeaseTime *uint32 `json:"lease_time,omitempty"`

	// The name of a DHCP MAC Filter object.
	Name *string `json:"name,omitempty"`

	// Determines if DHCP MAC Filter never expires or automatically expires.
	NeverExpires *bool `json:"never_expires,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// This is reserved for writing comments related to the particular MAC address
	// filter. The length of comment cannot exceed 1024 bytes.
	ReservedForInfoblox *string `json:"reserved_for_infoblox,omitempty"`
}

func (Filtermac) ObjectType() string {
	return "filtermac"
}

func (obj Filtermac) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Filternac represents Infoblox object filternac.
// If NAC authentication is configured, the appliance receives authentication
// responses from NAC authentication servers, and it grants or denies a lease
// request if the authentication response matches conditions defined by the NAC
// filters.
type Filternac struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment of a DHCP NAC Filter object.
	Comment *string `json:"comment,omitempty"`

	// The conditional expression of a DHCP NAC Filter object.
	Expression *string `json:"expression,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The length of time the DHCP server leases an IP address to a client. The
	// lease time applies to hosts that meet the filter criteria.
	LeaseTime *uint32 `json:"lease_time,omitempty"`

	// The name of a DHCP NAC Filter object.
	Name *string `json:"name,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`
}

func (Filternac) ObjectType() string {
	return "filternac"
}

func (obj Filternac) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Filteroption represents Infoblox object filteroption.
// In the ISC DHCP terms, it defines a class of clients that match a particular
// (option, value) pair. To define an option filter, add Option to the DHCP
// Filter object.
type Filteroption struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines if apply as class is enabled or not. If this flag is set to
	// "true" the filter is treated as global DHCP class, e.g it is written to
	// dhcpd config file even if it is not present in any DHCP range.
	ApplyAsClass *bool `json:"apply_as_class,omitempty"`

	// A name of boot file of a DHCP filter option object.
	Bootfile *string `json:"bootfile,omitempty"`

	// Determines the boot server of a DHCP filter option object. You can specify
	// the name and/or IP address of the boot server that host needs to boot.
	Bootserver *string `json:"bootserver,omitempty"`

	// The descriptive comment of a DHCP filter option object.
	Comment *string `json:"comment,omitempty"`

	// The conditional expression of a DHCP filter option object.
	Expression *string `json:"expression,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines the lease time of a DHCP filter option object.
	LeaseTime *uint32 `json:"lease_time,omitempty"`

	// The name of a DHCP option filter object.
	Name *string `json:"name,omitempty"`

	// Determines the next server of a DHCP filter option object. You can specify
	// the name and/or IP address of the next server that the host needs to boot.
	NextServer *string `json:"next_server,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	OptionList []*Dhcpoption `json:"option_list,omitempty"`

	// The option space of a DHCP filter option object.
	OptionSpace *string `json:"option_space,omitempty"`

	// Determines the PXE (Preboot Execution Environment) lease time of a DHCP
	// filter option object. To specify the duration of time it takes a host to
	// connect to a boot server, such as a TFTP server, and download the file it
	// needs to boot.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`
}

func (Filteroption) ObjectType() string {
	return "filteroption"
}

func (obj Filteroption) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Filterrelayagent represents Infoblox object filterrelayagent.
// The Infoblox appliance can screen address requests through relay agent
// filters (DHCP option 82) that assist the agents in forwarding address
// assignments across the proper circuit. When a relay agent receives the
// DHCPDISCOVER message, it can add one or two agent IDs in the DHCP option 82
// suboption fields to the message. If the agent ID strings match those defined
// in a relay agent filter applied to a DHCP address range, the Infoblox
// appliance either assigns addresses from that range or denies the request
// (based on previously configured parameters; that is, the Grant lease and
// Deny lease parameters).
type Filterrelayagent struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The circuit_id_name of a DHCP relay agent filter object. This filter
	// identifies the circuit between the remote host and the relay agent. For
	// example, the identifier can be the ingress interface number of the circuit
	// access unit, perhaps concatenated with the unit ID number and slot number.
	// Also, the circuit ID can be an ATM virtual circuit ID or cable data virtual
	// circuit ID.
	CircuitIdName *string `json:"circuit_id_name,omitempty"`

	// The circuit ID substring length.
	CircuitIdSubstringLength *uint32 `json:"circuit_id_substring_length,omitempty"`

	// The circuit ID substring offset.
	CircuitIdSubstringOffset *uint32 `json:"circuit_id_substring_offset,omitempty"`

	// A descriptive comment of a DHCP relay agent filter object.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The circuit ID matching rule of a DHCP relay agent filter object. The
	// circuit_id value takes effect only if the value is "MATCHES_VALUE".
	IsCircuitId string `json:"is_circuit_id,omitempty"`

	// Determines if the substring of circuit ID, instead of the full circuit ID,
	// is matched.
	IsCircuitIdSubstring *bool `json:"is_circuit_id_substring,omitempty"`

	// The remote ID matching rule of a DHCP relay agent filter object. The
	// remote_id value takes effect only if the value is Matches_Value.
	IsRemoteId string `json:"is_remote_id,omitempty"`

	// Determines if the substring of remote ID, instead of the full remote ID, is
	// matched.
	IsRemoteIdSubstring *bool `json:"is_remote_id_substring,omitempty"`

	// The name of a DHCP relay agent filter object.
	Name *string `json:"name,omitempty"`

	// The remote ID name attribute of a relay agent filter object. This filter
	// identifies the remote host. The remote ID name can represent many different
	// things such as the caller ID telephone number for a dial-up connection, a
	// user name for logging in to the ISP, a modem ID, etc. When the remote ID
	// name is defined on the relay agent, the DHCP server will have a trusted
	// relationship to identify the remote host. The remote ID name is considered
	// as a trusted identifier.
	RemoteIdName *string `json:"remote_id_name,omitempty"`

	// The remote ID substring length.
	RemoteIdSubstringLength *uint32 `json:"remote_id_substring_length,omitempty"`

	// The remote ID substring offset.
	RemoteIdSubstringOffset *uint32 `json:"remote_id_substring_offset,omitempty"`
}

func (Filterrelayagent) ObjectType() string {
	return "filterrelayagent"
}

func (obj Filterrelayagent) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Fingerprint represents Infoblox object fingerprint.
// The DHCP Fingerprint object is part of the Fingerprint filter.
type Fingerprint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the Fingerprint; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// A class of DHCP Fingerprint object; maximum 256 characters.
	DeviceClass *string `json:"device_class,omitempty"`

	// Determines if the DHCP Fingerprint object is disabled or not.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// A list (comma separated list) of IPv6 option number sequences of the device
	// or operating system.
	Ipv6OptionSequence []string `json:"ipv6_option_sequence,omitempty"`

	// Name of the DHCP Fingerprint object.
	Name *string `json:"name,omitempty"`

	// A list (comma separated list) of IPv4 option number sequences of the device
	// or operating system.
	OptionSequence []string `json:"option_sequence,omitempty"`

	// The type of the DHCP Fingerprint object.
	Type string `json:"type,omitempty"`

	// A list of vendor IDs of the device or operating system.
	VendorId []string `json:"vendor_id,omitempty"`
}

func (Fingerprint) ObjectType() string {
	return "fingerprint"
}

func (obj Fingerprint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "device_class", "name"}
	}
	return obj.returnFields
}

// Ipv4FixedAddress represents Infoblox object fixedaddress.
// A fixed address is a specific IP address that a DHCP server always assigns
// when a lease request comes from a particular MAC address of the client.
type Ipv4FixedAddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The agent circuit ID for the fixed address.
	AgentCircuitId *string `json:"agent_circuit_id,omitempty"`

	// The agent remote ID for the fixed address.
	AgentRemoteId *string `json:"agent_remote_id,omitempty"`

	// This field controls whether the credential is used for both the Telnet and
	// SSH credentials. If set to False, the credential is used only for SSH.
	AllowTelnet *bool `json:"allow_telnet,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP client requests.
	AlwaysUpdateDns *bool `json:"always_update_dns,omitempty"`

	// The bootfile name for the fixed address. You can configure the DHCP server
	// to support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the fixed address. You can specify the name
	// and/or IP address of the boot server that the host needs to boot. The boot
	// server IPv4 Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// The CLI credentials for the fixed address.
	CliCredentials []*DiscoveryClicredential `json:"cli_credentials,omitempty"`

	// This field controls whether there is a prepend for the
	// dhcp-client-identifier of a fixed address.
	ClientIdentifierPrependZero *bool `json:"client_identifier_prepend_zero,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the fixed address; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this fixed address.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// The DDNS host name for this fixed address.
	DdnsHostname *string `json:"ddns_hostname,omitempty"`

	// If set to true, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The description of the device.
	DeviceDescription *string `json:"device_description,omitempty"`

	// The location of the device.
	DeviceLocation *string `json:"device_location,omitempty"`

	// The type of the device.
	DeviceType *string `json:"device_type,omitempty"`

	// The vendor of the device.
	DeviceVendor *string `json:"device_vendor,omitempty"`

	// The DHCP client ID for the fixed address.
	DhcpClientIdentifier *string `json:"dhcp_client_identifier,omitempty"`

	// Determines whether a fixed address is disabled or not. When this is set to
	// False, the fixed address is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines if the discovery for this fixed address is disabled or not. False
	// means that the discovery is enabled.
	DisableDiscovery *bool `json:"disable_discovery,omitempty"`

	// The discovery status of this fixed address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this fixed address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The dynamic DNS updates flag of a DHCP Fixed Address object. If set to True,
	// the DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if the discovery for the fixed address should be immediately
	// enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// The IPv4 Address of the fixed address.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// This flag reflects whether the MAC address for this fixed address is
	// invalid.
	IsInvalidMac bool `json:"is_invalid_mac,omitempty"`

	// This field contains the logic filters to be applied on the this fixed
	// address. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The MAC address value for this fixed address.
	Mac *string `json:"mac,omitempty"`

	// The match_client value for this fixed address. Valid values are:
	// "MAC_ADDRESS": The fixed IP address is leased to the matching MAC address.
	// "CLIENT_ID": The fixed IP address is leased to the matching DHCP client
	// identifier. "RESERVED": The fixed IP address is reserved for later use with
	// a MAC address that only has zeros. "CIRCUIT_ID": The fixed IP address is
	// leased to the DHCP client with a matching circuit ID. Note that the
	// "agent_circuit_id" field must be set in this case. "REMOTE_ID": The fixed IP
	// address is leased to the DHCP client with a matching remote ID. Note that
	// the "agent_remote_id" field must be set in this case.
	MatchClient string `json:"match_client,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// This field contains the Microsoft DHCP options for this fixed address.
	MsOptions []*Msdhcpoption `json:"ms_options,omitempty"`

	// The Microsoft server associated with this fixed address.
	MsServer *Msdhcpserver `json:"ms_server,omitempty"`

	// This field contains the name of this fixed address.
	Name *string `json:"name,omitempty"`

	// The network to which this fixed address belongs, in IPv4 Address/CIDR
	// format.
	Network *string `json:"network,omitempty"`

	// The name of the network view in which this fixed address resides.
	NetworkView *string `json:"network_view,omitempty"`

	// The name in FQDN and/or IPv4 Address format of the next server that the host
	// needs to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The PXE lease time value for a DHCP Fixed Address object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// The ref to the reserved interface to which the device belongs.
	ReservedInterface *string `json:"reserved_interface,omitempty"`

	// Restarts the member service. The restart_if_needed flag can trigger a
	// restart on DHCP services only when it is enabled on CP member.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The SNMPv3 credential for this fixed address.
	Snmp3Credential *DiscoverySnmp3credential `json:"snmp3_credential,omitempty"`

	// The SNMPv1 or SNMPv2 credential for this fixed address.
	SnmpCredential *DiscoverySnmpcredential `json:"snmp_credential,omitempty"`

	// If set on creation, the fixed address will be created according to the
	// values specified in the named template.
	Template string `json:"template,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// If set to true, the CLI credential will override member-level settings.
	UseCliCredentials *bool `json:"use_cli_credentials,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: ms_options
	UseMsOptions *bool `json:"use_ms_options,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Determines if the SNMPv3 credential should be used for the fixed address.
	UseSnmp3Credential *bool `json:"use_snmp3_credential,omitempty"`

	// If set to true, the SNMP credential will override member-level settings.
	UseSnmpCredential *bool `json:"use_snmp_credential,omitempty"`
}

func (Ipv4FixedAddress) ObjectType() string {
	return "fixedaddress"
}

func (obj Ipv4FixedAddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "network_view"}
	}
	return obj.returnFields
}

// Fixedaddresstemplate represents Infoblox object fixedaddresstemplate.
// The fixed address template used to create a fixed address objects in a quick
// and consistent way. Fixed address object created from a fixed address
// template will inherit most properties defined in fixed address template
// object so most of the fixed address template properties are the same as the
// fixed address object properties.
type Fixedaddresstemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The boot file name for the fixed address. You can configure the DHCP server
	// to support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The boot server address for the fixed address. You can specify the name
	// and/or IP address of the boot server that the host needs to boot. The boot
	// server IPv4 Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// A descriptive comment of a fixed address template object.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this fixed address.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// The DDNS host name for this fixed address.
	DdnsHostname *string `json:"ddns_hostname,omitempty"`

	// Determines if BOOTP settings are disabled and BOOTP requests will be denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// Determines if the DHCP server sends DDNS updates to DNS servers in the same
	// Grid, and to external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// This field contains the logic filters to be applied on this fixed address.
	// This list corresponds to the match rules that are written to the dhcpd
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The name of a fixed address template object.
	Name *string `json:"name,omitempty"`

	// The name in FQDN and/or IPv4 Address format of the next server that the host
	// needs to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// The number of addresses for this fixed address.
	NumberOfAddresses *uint32 `json:"number_of_addresses,omitempty"`

	// The start address offset for this fixed address.
	Offset *uint32 `json:"offset,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The PXE lease time value for a DHCP Fixed Address object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`
}

func (Fixedaddresstemplate) ObjectType() string {
	return "fixedaddresstemplate"
}

func (obj Fixedaddresstemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Ftpuser represents Infoblox object ftpuser.
// The FTP user represents the user accounts to be used with the FTP client.
type Ftpuser struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether to create the home directory with the user name or to use
	// the existing directory as the home directory.
	CreateHomeDir bool `json:"create_home_dir,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The absolute path of the FTP user's home directory.
	HomeDir string `json:"home_dir,omitempty"`

	// The FTP user password.
	Password *string `json:"password,omitempty"`

	// The FTP user permission.
	Permission string `json:"permission,omitempty"`

	// The FTP user name.
	Username string `json:"username,omitempty"`
}

func (Ftpuser) ObjectType() string {
	return "ftpuser"
}

func (obj Ftpuser) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"username"}
	}
	return obj.returnFields
}

// Grid represents Infoblox object grid.
// This object represents the Infoblox Grid.
type Grid struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The property to allow recursive deletion. Determines the users who can
	// choose to perform recursive deletion on networks or zones from the GUI only.
	AllowRecursiveDeletion string `json:"allow_recursive_deletion,omitempty"`

	// Determines the audit log format.
	AuditLogFormat string `json:"audit_log_format,omitempty"`

	// If set to True, audit log messages are also copied to the syslog.
	AuditToSyslogEnable *bool `json:"audit_to_syslog_enable,omitempty"`

	// The grid level settings for automated traffic capture.
	AutomatedTrafficCaptureSetting *SettingAutomatedtrafficcapture `json:"automated_traffic_capture_setting,omitempty"`

	// The Grid consent banner settings.
	ConsentBannerSetting *GridConsentbannersetting `json:"consent_banner_setting,omitempty"`

	// The Grid csp api config settings.
	CspApiConfig *GridCspapiconfig `json:"csp_api_config,omitempty"`

	// CSP settings at grid level
	CspGridSetting *GridCspgridsetting `json:"csp_grid_setting,omitempty"`

	// If set to True, the managed Grid will not send snapshots to the Multi-Grid
	// Master.
	DenyMgmSnapshots *bool `json:"deny_mgm_snapshots,omitempty"`

	// The default actions for extensbile attributes that exist on descendants.
	DescendantsAction *ExtensibleattributedefDescendants `json:"descendants_action,omitempty"`

	// The DNS resolver setting.
	DnsResolverSetting *SettingDnsresolver `json:"dns_resolver_setting,omitempty"`

	// The DSCP value. Valid values are integers between 0 and 63 inclusive.
	Dscp *uint32 `json:"dscp,omitempty"`

	// The e-mail settings for the Grid.
	EmailSetting *SettingEmail `json:"email_setting,omitempty"`

	// If set to True, GUI and API access are enabled on the LAN/VIP port and MGMT
	// port (if configured).
	EnableGuiApiForLanVip *bool `json:"enable_gui_api_for_lan_vip,omitempty"`

	// Determines if the LOM functionality is enabled or not.
	EnableLom *bool `json:"enable_lom,omitempty"`

	// Determines redirections is enabled or not for members.
	EnableMemberRedirect *bool `json:"enable_member_redirect,omitempty"`

	// Determines if the Recycle Bin is enabled or not.
	EnableRecycleBin *bool `json:"enable_recycle_bin,omitempty"`

	// Determines if the RIR/SWIP support is enabled or not.
	EnableRirSwip *bool `json:"enable_rir_swip,omitempty"`

	// The list of external backup syslog servers.
	ExternalSyslogBackupServers []*Extsyslogbackupserver `json:"external_syslog_backup_servers,omitempty"`

	// If set to True, external syslog servers are enabled.
	ExternalSyslogServerEnable *bool `json:"external_syslog_server_enable,omitempty"`

	// The Grid HTTP proxy server settings.
	HttpProxyServerSetting *SettingHttpproxyserver `json:"http_proxy_server_setting,omitempty"`

	// The Grid informational level banner settings.
	InformationalBannerSetting *GridInformationalbannersetting `json:"informational_banner_setting,omitempty"`

	// If set to True, graphical visualization of the Grid is enabled.
	IsGridVisualizationVisible *bool `json:"is_grid_visualization_visible,omitempty"`

	// Security Setting for Account lockout.
	LockoutSetting *GridLockoutsetting `json:"lockout_setting,omitempty"`

	// The list of LOM users.
	LomUsers []*Lomuser `json:"lom_users,omitempty"`

	// Determines if strict delegate mode for the Grid managed by the Master Grid
	// is enabled or not.
	MgmStrictDelegateMode *bool `json:"mgm_strict_delegate_mode,omitempty"`

	// The settings for all Microsoft servers in the Grid.
	MsSetting *SettingMsserver `json:"ms_setting,omitempty"`

	// The grid name.
	Name *string `json:"name,omitempty"`

	// The list of all Network Address Translation (NAT) groups configured on the
	// Grid.
	NatGroups []string `json:"nat_groups,omitempty"`

	// The Grid Network Time Protocol (NTP) settings.
	NTPSetting *NTPSetting `json:"ntp_setting,omitempty"`

	// Determines the object changes tracking settings.
	ObjectsChangesTrackingSetting *Objectschangestrackingsetting `json:"objects_changes_tracking_setting,omitempty"`

	// The Grid password settings.
	PasswordSetting *SettingPassword `json:"password_setting,omitempty"`

	// The setting for the Restart Banner.
	RestartBannerSetting *GridRestartbannersetting `json:"restart_banner_setting,omitempty"`

	// The restart status for the Grid.
	RestartStatus string `json:"restart_status,omitempty"`

	// The time interval (in seconds) that determines how often the appliance
	// calculates the RPZ hit rate.
	RpzHitRateInterval *uint32 `json:"rpz_hit_rate_interval,omitempty"`

	// The maximum number of incoming queries between the RPZ hit rate checks.
	RpzHitRateMaxQuery *uint32 `json:"rpz_hit_rate_max_query,omitempty"`

	// The minimum number of incoming queries between the RPZ hit rate checks.
	RpzHitRateMinQuery *uint32 `json:"rpz_hit_rate_min_query,omitempty"`

	// The scheduled backup configuration.
	ScheduledBackup *Scheduledbackup `json:"scheduled_backup,omitempty"`

	// The shared secret of the Grid. This is a write-only attribute.
	Secret *string `json:"secret,omitempty"`

	// The Grid security banner settings.
	SecurityBannerSetting *SettingSecuritybanner `json:"security_banner_setting,omitempty"`

	// The Grid security settings.
	SecuritySetting *SettingSecurity `json:"security_setting,omitempty"`

	// Determines overall service status of the Grid.
	ServiceStatus string `json:"service_status,omitempty"`

	// The Grid SNMP settings.
	SnmpSetting *SettingSnmp `json:"snmp_setting,omitempty"`

	// Support bundle download timeout in seconds.
	SupportBundleDownloadTimeout *uint32 `json:"support_bundle_download_timeout,omitempty"`

	// If 'audit_to_syslog_enable' is set to True, the facility that determines the
	// processes and daemons from which the log messages are generated.
	SyslogFacility string `json:"syslog_facility,omitempty"`

	// The list of external syslog servers.
	SyslogServers []*Syslogserver `json:"syslog_servers,omitempty"`

	// The maximum size for the syslog file expressed in megabytes.
	SyslogSize *uint32 `json:"syslog_size,omitempty"`

	// Determines the list of threshold traps. The user can only change the values
	// for each trap or remove traps.
	ThresholdTraps []*Thresholdtrap `json:"threshold_traps,omitempty"`

	// The time zone of the Grid. The UTC string that represents the time zone,
	// such as "(UTC - 5:00) Eastern Time (US and Canada)".
	TimeZone *string `json:"time_zone,omitempty"`

	// The delayed usage (in minutes) of a permission token.
	TokenUsageDelay *uint32 `json:"token_usage_delay,omitempty"`

	// Grid level settings for enabling authoritative DNS latency thresholds for
	// automated traffic capture.
	TrafficCaptureAuthDnsSetting *SettingTriggeruthdnslatency `json:"traffic_capture_auth_dns_setting,omitempty"`

	// Grid level settings for enabling DNS cache hit ratio threshold for automated
	// traffic capture.
	TrafficCaptureChrSetting *SettingTrafficcapturechr `json:"traffic_capture_chr_setting,omitempty"`

	// Grid level settings for enabling DNS query per second threshold for
	// automated traffic capture.
	TrafficCaptureQpsSetting *SettingTrafficcaptureqps `json:"traffic_capture_qps_setting,omitempty"`

	// Grid level settings for enabling recursive DNS latency thresholds for
	// automated traffic capture.
	TrafficCaptureRecDnsSetting *SettingTriggerrecdnslatency `json:"traffic_capture_rec_dns_setting,omitempty"`

	// Grid level settings for enabling count for concurrent outgoing recursive
	// queries for automated traffic capture.
	TrafficCaptureRecQueriesSetting *SettingTriggerrecqueries `json:"traffic_capture_rec_queries_setting,omitempty"`

	// Determines configuration of the trap notifications.
	TrapNotifications []*Trapnotification `json:"trap_notifications,omitempty"`

	// The list of member configuration structures, which provides information and
	// settings for configuring the member that is responsible for downloading
	// updates.
	UpdatesDownloadMemberConfig []*Updatesdownloadmemberconfig `json:"updates_download_member_config,omitempty"`

	// The VPN port.
	VpnPort *uint32 `json:"vpn_port,omitempty"`
}

func (Grid) ObjectType() string {
	return "grid"
}

func (obj Grid) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

func NewGrid(grid Grid) *Grid {
	result := grid
	returnFields := []string{"name", "ntp_setting"}
	result.returnFields = returnFields
	return &result
}

// GridCloudapi represents Infoblox object grid:cloudapi.
// This object represents the Cloud Grid.
type GridCloudapi struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Defines administrators who can perform cloud API requests on the Grid
	// Master. The valid value is NONE (no administrator), ALL (all
	// administrators), or LIST (administrators on the ACL).
	AllowApiAdmins string `json:"allow_api_admins,omitempty"`

	// The list of administrators who can perform cloud API requests on the Cloud
	// Platform Appliance.
	AllowedApiAdmins []*GridCloudapiUser `json:"allowed_api_admins,omitempty"`

	// Determines whether the recycle bin for deleted cloud objects is enabled or
	// not on the Grid Master.
	EnableRecycleBin *bool `json:"enable_recycle_bin,omitempty"`

	// Structure containing all the information related to Gateway configuration
	// for the Grid Master
	GatewayConfig *GridCloudapiGatewayConfig `json:"gateway_config,omitempty"`
}

func (GridCloudapi) ObjectType() string {
	return "grid:cloudapi"
}

func (obj GridCloudapi) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"allow_api_admins", "allowed_api_admins", "enable_recycle_bin"}
	}
	return obj.returnFields
}

// GridCloudapiCloudstatistics represents Infoblox object grid:cloudapi:cloudstatistics.
// Represents the cloud statistics data.
type GridCloudapiCloudstatistics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Ratio of allocated vs. available IPs
	AllocatedAvailableRatio uint32 `json:"allocated_available_ratio,omitempty"`

	// Total number of IPs allocated by tenants.
	AllocatedIpCount uint32 `json:"allocated_ip_count,omitempty"`

	// The total number of IP addresses available to tenants. Only IP addresses in
	// networks that are within a delegation scope are counted.
	AvailableIpCount string `json:"available_ip_count,omitempty"`

	// The total number of fixed IP addresses currently in use by all tenants in
	// the system.
	FixedIpCount uint32 `json:"fixed_ip_count,omitempty"`

	// The total number of floating IP addresses currently in use by all tenants in
	// the system.
	FloatingIpCount uint32 `json:"floating_ip_count,omitempty"`

	// Total number of tenant currently in the system.
	TenantCount uint32 `json:"tenant_count,omitempty"`

	// The total number of IP addresses currently in use by all tenants in the
	// system.
	TenantIpCount uint32 `json:"tenant_ip_count,omitempty"`

	// The total number of VMs currently in use by all tenants in the system.
	TenantVmCount uint32 `json:"tenant_vm_count,omitempty"`
}

func (GridCloudapiCloudstatistics) ObjectType() string {
	return "grid:cloudapi:cloudstatistics"
}

func (obj GridCloudapiCloudstatistics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"allocated_available_ratio", "allocated_ip_count", "available_ip_count", "fixed_ip_count", "floating_ip_count", "tenant_count", "tenant_ip_count", "tenant_vm_count"}
	}
	return obj.returnFields
}

// GridCloudapiTenant represents Infoblox object grid:cloudapi:tenant.
// A Tenant object represents an abstract administrative concept in Cloud
// Management Platforms, which encompasses all network elements such as
// networks, zones, VMs, IP addresses (fixed and floating), network views,
// default DNS view, and all related extensive attributes.
type GridCloudapiTenant struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the Grid Cloud API Tenant object; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The timestamp when the tenant was first created in the system.
	CreatedTs *UnixTime `json:"created_ts,omitempty"`

	// Unique ID associated with the tenant. This is set only when the tenant is
	// first created.
	Id string `json:"id,omitempty"`

	// The timestamp when the last event associated with the tenant happened.
	LastEventTs *UnixTime `json:"last_event_ts,omitempty"`

	// Name of the tenant.
	Name *string `json:"name,omitempty"`

	// Number of Networks associated with the tenant.
	NetworkCount uint32 `json:"network_count,omitempty"`

	// Number of VMs associated with the tenant.
	VmCount uint32 `json:"vm_count,omitempty"`
}

func (GridCloudapiTenant) ObjectType() string {
	return "grid:cloudapi:tenant"
}

func (obj GridCloudapiTenant) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "id", "name"}
	}
	return obj.returnFields
}

// GridCloudapiVm represents Infoblox object grid:cloudapi:vm.
// A vm object represents a virtual machine which encompasses network elements
// such as IP addresses (fixed and floating, private and public), DNS names and
// all related extensive attributes.
type GridCloudapiVm struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Availability zone of the VM.
	AvailabilityZone string `json:"availability_zone,omitempty"`

	// Structure containing all the cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the vm object; maximum 1024 characters.
	Comment *string `json:"comment,omitempty"`

	// Elastic IP address associated with the VM's primary interface.
	ElasticIpAddress string `json:"elastic_ip_address,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The timestamp when the VM was first seen in the system.
	FirstSeen *UnixTime `json:"first_seen,omitempty"`

	// Hostname part of the FQDN for the address associated with the VM's primary
	// interface.
	Hostname string `json:"hostname,omitempty"`

	// Unique ID associated with the VM. This is set only when the VM is first
	// created.
	Id string `json:"id,omitempty"`

	// Identifier of the kernel that this VM is running; maximum 128 characters.
	KernelId *string `json:"kernel_id,omitempty"`

	// The timestamp when the last event associated with the VM happened.
	LastSeen *UnixTime `json:"last_seen,omitempty"`

	// Name of the VM.
	Name *string `json:"name,omitempty"`

	// Number of Networks containing any address associated with this VM.
	NetworkCount uint32 `json:"network_count,omitempty"`

	// Guest Operating system that this VM is running; maximum 128 characters.
	OperatingSystem *string `json:"operating_system,omitempty"`

	// MAC address associated with the VM's primary interface.
	PrimaryMacAddress string `json:"primary_mac_address,omitempty"`

	// Address of the network that is the container of the address associated with
	// the VM's primary interface.
	SubnetAddress string `json:"subnet_address,omitempty"`

	// CIDR of the network that is the container of the address associated with the
	// VM's primary interface.
	SubnetCidr uint32 `json:"subnet_cidr,omitempty"`

	// Subnet ID of the network that is the container of the address associated
	// with the VM's primary interface.
	SubnetId string `json:"subnet_id,omitempty"`

	// Name of the tenant associated with the VM.
	TenantName string `json:"tenant_name,omitempty"`

	// VM type; maximum 64 characters.
	VmType *string `json:"vm_type,omitempty"`

	// Network address of the parent VPC.
	VpcAddress string `json:"vpc_address,omitempty"`

	// Network CIDR of the parent VPC.
	VpcCidr uint32 `json:"vpc_cidr,omitempty"`

	// Identifier of the parent VPC.
	VpcId string `json:"vpc_id,omitempty"`

	// Name of the parent VPC.
	VpcName string `json:"vpc_name,omitempty"`
}

func (GridCloudapiVm) ObjectType() string {
	return "grid:cloudapi:vm"
}

func (obj GridCloudapiVm) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "id", "name"}
	}
	return obj.returnFields
}

// GridCloudapiVmaddress represents Infoblox object grid:cloudapi:vmaddress.
// VM address is an abstract object that represents a virtual machine running
// on the Cloud Management Platform.
type GridCloudapiVmaddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the interface.
	Address string `json:"address,omitempty"`

	// IP address type (Public, Private, Elastic, Floating, ...).
	AddressType string `json:"address_type,omitempty"`

	// Reference to associated IPv4 or IPv6 address.
	AssociatedIp string `json:"associated_ip,omitempty"`

	// Array of string denoting the types of underlying objects IPv4/IPv6 - "A",
	// "AAAA", "PTR", "HOST", "FA", "RESERVATION", "UNMANAGED" + ("BULKHOST",
	// "DHCP_RANGE", "RESERVED_RANGE", "LEASE", "NETWORK", "BROADCAST", "PENDING"),
	AssociatedObjectTypes []string `json:"associated_object_types,omitempty"`

	// The list of references to the object (Host, Fixed Address, RR, ...) that
	// defines this IP.
	AssociatedObjects []*Ipv4FixedAddress `json:"associated_objects,omitempty"`

	// Structure containing all the cloud API related information. Only management
	// platform "mgmt_platform" is updated for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The list of all FQDNs associated with the IP address.
	DnsNames []string `json:"dns_names,omitempty"`

	// Elastic IP address associated with this private address, if this address is
	// a private address; otherwise empty.
	ElasticAddress string `json:"elastic_address,omitempty"`

	// Name of the interface associated with this IP address.
	InterfaceName string `json:"interface_name,omitempty"`

	// Indicates whether the address is IPv4 or IPv6.
	IsIpv4 bool `json:"is_ipv4,omitempty"`

	// The MAC address of the interface.
	MacAddress string `json:"mac_address,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network to which this address belongs, in IPv4 Address/CIDR format.
	Network string `json:"network,omitempty"`

	// Network view name of the delegated object.
	NetworkView string `json:"network_view,omitempty"`

	// Port identifier of the interface.
	PortId uint32 `json:"port_id,omitempty"`

	// Private IP address associated with this public (or elastic or floating)
	// address, if this address is a public address; otherwise empty.
	PrivateAddress string `json:"private_address,omitempty"`

	// Host part of the FQDN of this address if this address is a private address;
	// otherwise empty
	PrivateHostname string `json:"private_hostname,omitempty"`

	// Public IP address associated with this private address, if this address is a
	// private address; otherwise empty.
	PublicAddress string `json:"public_address,omitempty"`

	// Host part of the FQDN of this address if this address is a public (or
	// elastic or floating) address; otherwise empty
	PublicHostname string `json:"public_hostname,omitempty"`

	// Network address of the subnet that is the container of this address.
	SubnetAddress string `json:"subnet_address,omitempty"`

	// CIDR of the subnet that is the container of this address.
	SubnetCidr uint32 `json:"subnet_cidr,omitempty"`

	// Subnet ID that is the container of this address.
	SubnetId string `json:"subnet_id,omitempty"`

	// The Cloud API Tenant object.
	Tenant string `json:"tenant,omitempty"`

	// Availability zone of the VM.
	VmAvailabilityZone string `json:"vm_availability_zone,omitempty"`

	// VM comment.
	VmComment string `json:"vm_comment,omitempty"`

	// Date/time the VM was first created as NIOS object.
	VmCreationTime *UnixTime `json:"vm_creation_time,omitempty"`

	// Host part of the FQDN of the address attached to the primary interface.
	VmHostname string `json:"vm_hostname,omitempty"`

	// The UUID of the Virtual Machine.
	VmId string `json:"vm_id,omitempty"`

	// Kernel ID of the VM that this address is associated with.
	VmKernelId string `json:"vm_kernel_id,omitempty"`

	// Last time the VM was updated.
	VmLastUpdateTime *UnixTime `json:"vm_last_update_time,omitempty"`

	// The name of the Virtual Machine.
	VmName string `json:"vm_name,omitempty"`

	// Count of networks containing all the addresses of the VM.
	VmNetworkCount uint32 `json:"vm_network_count,omitempty"`

	// Operating system that the VM is running.
	VmOperatingSystem string `json:"vm_operating_system,omitempty"`

	// Type of the VM this address is associated with.
	VmType string `json:"vm_type,omitempty"`

	// Network address of the VPC of the VM that this address is associated with.
	VmVpcAddress string `json:"vm_vpc_address,omitempty"`

	// CIDR of the VPC of the VM that this address is associated with.
	VmVpcCidr uint32 `json:"vm_vpc_cidr,omitempty"`

	// Identifier of the VPC where the VM is defined.
	VmVpcId string `json:"vm_vpc_id,omitempty"`

	// Name of the VPC where the VM is defined.
	VmVpcName string `json:"vm_vpc_name,omitempty"`

	// Reference to the VPC where the VM is defined.
	VmVpcRef string `json:"vm_vpc_ref,omitempty"`
}

func (GridCloudapiVmaddress) ObjectType() string {
	return "grid:cloudapi:vmaddress"
}

func (obj GridCloudapiVmaddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "is_ipv4", "network_view", "port_id", "vm_name"}
	}
	return obj.returnFields
}

// GridDashboard represents Infoblox object grid:dashboard.
// The Grid Dashboard object provides a configuration interface for threshold
// values that are used to warn about critical ATP, RPZ and Analytics events.
// These threshold values are used to calculate the security status for ATP,
// RPZ, and Analytics.
type GridDashboard struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid Dashboard critical threshold for Analytics tunneling events.
	AnalyticsTunnelingEventCriticalThreshold *uint32 `json:"analytics_tunneling_event_critical_threshold,omitempty"`

	// The Grid Dashboard warning threshold for Analytics tunneling events.
	AnalyticsTunnelingEventWarningThreshold *uint32 `json:"analytics_tunneling_event_warning_threshold,omitempty"`

	// The Grid Dashboard critical threshold for ATP critical events.
	AtpCriticalEventCriticalThreshold *uint32 `json:"atp_critical_event_critical_threshold,omitempty"`

	// The Grid Dashboard warning threshold for ATP critical events.
	AtpCriticalEventWarningThreshold *uint32 `json:"atp_critical_event_warning_threshold,omitempty"`

	// The Grid Dashboard critical threshold for ATP major events.
	AtpMajorEventCriticalThreshold *uint32 `json:"atp_major_event_critical_threshold,omitempty"`

	// The Grid Dashboard warning threshold for ATP major events.
	AtpMajorEventWarningThreshold *uint32 `json:"atp_major_event_warning_threshold,omitempty"`

	// The Grid Dashboard critical threshold for ATP warning events.
	AtpWarningEventCriticalThreshold *uint32 `json:"atp_warning_event_critical_threshold,omitempty"`

	// The Grid Dashboard warning threshold for ATP warning events.
	AtpWarningEventWarningThreshold *uint32 `json:"atp_warning_event_warning_threshold,omitempty"`

	// The critical threshold value for blocked RPZ hits in the Grid dashboard.
	RpzBlockedHitCriticalThreshold *uint32 `json:"rpz_blocked_hit_critical_threshold,omitempty"`

	// The warning threshold value for blocked RPZ hits in the Grid dashboard.
	RpzBlockedHitWarningThreshold *uint32 `json:"rpz_blocked_hit_warning_threshold,omitempty"`

	// The Grid Dashboard critical threshold for RPZ passthru events.
	RpzPassthruEventCriticalThreshold *uint32 `json:"rpz_passthru_event_critical_threshold,omitempty"`

	// The Grid Dashboard warning threshold for RPZ passthru events.
	RpzPassthruEventWarningThreshold *uint32 `json:"rpz_passthru_event_warning_threshold,omitempty"`

	// The critical threshold value for substituted RPZ hits in the Grid dashboard.
	RpzSubstitutedHitCriticalThreshold *uint32 `json:"rpz_substituted_hit_critical_threshold,omitempty"`

	// The warning threshold value for substituted RPZ hits in the Grid dashboard.
	RpzSubstitutedHitWarningThreshold *uint32 `json:"rpz_substituted_hit_warning_threshold,omitempty"`
}

func (GridDashboard) ObjectType() string {
	return "grid:dashboard"
}

func (obj GridDashboard) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"analytics_tunneling_event_critical_threshold", "analytics_tunneling_event_warning_threshold", "atp_critical_event_critical_threshold", "atp_critical_event_warning_threshold", "atp_major_event_critical_threshold", "atp_major_event_warning_threshold", "atp_warning_event_critical_threshold", "atp_warning_event_warning_threshold", "rpz_blocked_hit_critical_threshold", "rpz_blocked_hit_warning_threshold", "rpz_passthru_event_critical_threshold", "rpz_passthru_event_warning_threshold", "rpz_substituted_hit_critical_threshold", "rpz_substituted_hit_warning_threshold"}
	}
	return obj.returnFields
}

// GridDhcpproperties represents Infoblox object grid:dhcpproperties.
// This object represents a subset of the Infoblox Grid DHCP properties.
type GridDhcpproperties struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid-level authority flag. This flag specifies whether a DHCP server is
	// authoritative for a domain.
	Authority *bool `json:"authority,omitempty"`

	// The name of a file that DHCP clients need to boot. Some DHCP clients use
	// BOOTP (bootstrap protocol) or include the boot file name option in their
	// DHCPREQUEST messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The name of the server on which a boot file is stored.
	Bootserver *string `json:"bootserver,omitempty"`

	// The Grid-level capture hostname flag. Set this flag to capture the hostname
	// and lease time when assigning a fixed address.
	CaptureHostname *bool `json:"capture_hostname,omitempty"`

	// The member DDNS domain name value.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// Determines if the ability of a DHCP server to generate a host name and
	// update DNS with this host name when it receives a DHCP REQUEST message that
	// does not include a host name is enabled or not.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// Determines the retry interval when the DHCP server makes repeated attempts
	// to send DDNS updates to a DNS server.
	DdnsRetryInterval *uint32 `json:"ddns_retry_interval,omitempty"`

	// Determines that only the DHCP server is allowed to update DNS, regardless of
	// the requests from the DHCP clients.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DDNS TTL (Dynamic DNS Time To Live) value specifies the number of
	// seconds an IP address for the name is cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// Determines if the Grid DHCP server's ability to update the A and PTR records
	// with a fixed address is enabled or not.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// Determines if support for option 81 is enabled or not.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// Determines if deny BOOTP is enabled or not.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// If set to True, NAC filters will be disabled on the Infoblox Grid.
	DisableAllNacFilters *bool `json:"disable_all_nac_filters,omitempty"`

	// The update style for dynamic DNS updates.
	DnsUpdateStyle string `json:"dns_update_style,omitempty"`

	// The Grid-level email_list value. Specify an e-mail address to which you want
	// the Infoblox appliance to send e-mail notifications when the DHCP address
	// usage for the grid crosses a threshold. You can create a list of several
	// e-mail addresses.
	EmailList []string `json:"email_list,omitempty"`

	// Determines if the member DHCP server's ability to send DDNS updates is
	// enabled or not.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Represents the watermarks above or below which address usage in a network is
	// unexpected and might warrant your attention.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines if e-mail warnings are enabled or disabled. When DHCP threshold
	// is enabled and DHCP address usage crosses a watermark threshold, the
	// appliance sends an e-mail notification to an administrator.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Determines if the fingerprint feature is enabled or not. If you enable this
	// feature, the server will match a fingerprint for incoming lease requests.
	EnableFingerprint *bool `json:"enable_fingerprint,omitempty"`

	// Determines whether all appliances are enabled to receive GSS-TSIG
	// authenticated updates from DHCP clients.
	EnableGssTsig *bool `json:"enable_gss_tsig,omitempty"`

	// Determines if the Grid-level host name rewrite feature is enabled or not.
	EnableHostnameRewrite *bool `json:"enable_hostname_rewrite,omitempty"`

	// Determines if lease query is allowed or not.
	EnableLeasequery *bool `json:"enable_leasequery,omitempty"`

	// Determines if DHCP servers in a Grid support roaming hosts or not.
	EnableRoamingHosts *bool `json:"enable_roaming_hosts,omitempty"`

	// Determined if the SNMP warnings on Grid-level are enabled or not. When DHCP
	// threshold is enabled and DHCP address usage crosses a watermark threshold,
	// the appliance sends an SNMP trap to the trap receiver that you defined you
	// defined at the Grid member level.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// The format option for Option 82 logging.
	FormatLogOption82 string `json:"format_log_option_82,omitempty"`

	// Determines the Grid that serves DHCP. This specifies a group of Infoblox
	// appliances that are connected together to provide a single point of device
	// administration and service configuration in a secure, highly available
	// environment.
	Grid string `json:"grid,omitempty"`

	// The list of GSS-TSIG keys for a Grid DHCP object.
	GssTsigKeys []*Kerberoskey `json:"gss_tsig_keys,omitempty"`

	// Determines the high watermark value of a Grid DHCP server. If the percentage
	// of allocated addresses exceeds this watermark, the appliance makes a syslog
	// entry and sends an e-mail notification (if enabled). Specifies the
	// percentage of allocated addresses. The range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// Determines the high watermark reset value of a member DHCP server. If the
	// percentage of allocated addresses drops below this value, a corresponding
	// SNMP trap is reset. Specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// The name of the default hostname rewrite policy, which is also in the
	// protocol_hostname_rewrite_policies array.
	HostnameRewritePolicy *string `json:"hostname_rewrite_policy,omitempty"`

	// Determines if the ignore DHCP option list request flag of a Grid DHCP is
	// enabled or not. If this flag is set to true all available DHCP options will
	// be returned to the client.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses. Valid values are "NONE", "CLIENT", or "MACADDR". The default is
	// "NONE".
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// Determines if the fixed address configuration takes effect immediately
	// without DHCP service restart or not.
	ImmediateFaConfiguration *bool `json:"immediate_fa_configuration,omitempty"`

	// Determines if the IPv6 host name and lease time is captured or not while
	// assigning a fixed address.
	Ipv6CaptureHostname *bool `json:"ipv6_capture_hostname,omitempty"`

	// The Grid-level DDNS domain name value.
	Ipv6DdnsDomainname *string `json:"ipv6_ddns_domainname,omitempty"`

	// Controls whether the FQDN option sent by the client is to be used, or if the
	// server can automatically generate the FQDN.
	Ipv6DdnsEnableOptionFqdn *bool `json:"ipv6_ddns_enable_option_fqdn,omitempty"`

	// Determines if the server always updates DNS or updates only if requested by
	// the client.
	Ipv6DdnsServerAlwaysUpdates *bool `json:"ipv6_ddns_server_always_updates,omitempty"`

	// The Grid-level IPv6 DDNS TTL value.
	Ipv6DdnsTtl *uint32 `json:"ipv6_ddns_ttl,omitempty"`

	// The Grid-level IPv6 default prefix.
	Ipv6DefaultPrefix *string `json:"ipv6_default_prefix,omitempty"`

	// The update style for dynamic DHCPv6 DNS updates.
	Ipv6DnsUpdateStyle string `json:"ipv6_dns_update_style,omitempty"`

	// The IPv6 domain name.
	Ipv6DomainName *string `json:"ipv6_domain_name,omitempty"`

	// The comma separated list of domain name server addresses in IPv6 address
	// format.
	Ipv6DomainNameServers []string `json:"ipv6_domain_name_servers,omitempty"`

	// Determines if sending DDNS updates by the DHCPv6 server is enabled or not.
	Ipv6EnableDdns *bool `json:"ipv6_enable_ddns,omitempty"`

	// Determines whether the all appliances are enabled to receive GSS-TSIG
	// authenticated updates from DHCPv6 clients.
	Ipv6EnableGssTsig *bool `json:"ipv6_enable_gss_tsig,omitempty"`

	// Indicates whether DHCPv6 lease scavenging is enabled or disabled.
	Ipv6EnableLeaseScavenging *bool `json:"ipv6_enable_lease_scavenging,omitempty"`

	// Determines if the DHCPv6 server retries failed dynamic DNS updates or not.
	Ipv6EnableRetryUpdates *bool `json:"ipv6_enable_retry_updates,omitempty"`

	// Determines if the server generates the hostname if it is not sent by the
	// client.
	Ipv6GenerateHostname *bool `json:"ipv6_generate_hostname,omitempty"`

	// The list of GSS-TSIG keys for a Grid DHCPv6 object.
	Ipv6GssTsigKeys []*Kerberoskey `json:"ipv6_gss_tsig_keys,omitempty"`

	// The IPv6 address or FQDN of the Kerberos server for DHCPv6 GSS-TSIG
	// authentication.
	Ipv6KdcServer *string `json:"ipv6_kdc_server,omitempty"`

	// The Grid-level grace period (in seconds) to keep an expired lease before it
	// is deleted by the scavenging process.
	Ipv6LeaseScavengingTime *uint32 `json:"ipv6_lease_scavenging_time,omitempty"`

	// The Grid-level Microsoft client DHCP IPv6 code page value. This value is the
	// hostname translation code page for Microsoft DHCP IPv6 clients.
	Ipv6MicrosoftCodePage string `json:"ipv6_microsoft_code_page,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCPv6 options
	// associated with the object.
	Ipv6Options []*Dhcpoption `json:"ipv6_options,omitempty"`

	// The Grid-level list of IPv6 prefixes.
	Ipv6Prefixes []string `json:"ipv6_prefixes,omitempty"`

	// Determines if the IPv6 recycle leases feature is enabled or not. If the
	// feature is enabled, leases are kept in the Recycle Bin until one week after
	// expiration. When the feature is disabled, the leases are irrecoverably
	// deleted.
	Ipv6RecycleLeases *bool `json:"ipv6_recycle_leases,omitempty"`

	// Enable binding for expired DHCPv6 leases.
	Ipv6RememberExpiredClientAssociation *bool `json:"ipv6_remember_expired_client_association,omitempty"`

	// Determines the retry interval when the member DHCPv6 server makes repeated
	// attempts to send DDNS updates to a DNS server.
	Ipv6RetryUpdatesInterval *uint32 `json:"ipv6_retry_updates_interval,omitempty"`

	// The Grid-level TXT record handling value. This value specifies how DHCPv6
	// should treat the TXT records when performing DNS updates.
	Ipv6TxtRecordHandling string `json:"ipv6_txt_record_handling,omitempty"`

	// Controls whether the DHCPv6 server updates DNS when an IPv6 DHCP lease is
	// renewed.
	Ipv6UpdateDnsOnLeaseRenewal *bool `json:"ipv6_update_dns_on_lease_renewal,omitempty"`

	// The IPv4 address or FQDN of the Kerberos server for DHCPv4 GSS-TSIG
	// authentication.
	KdcServer *string `json:"kdc_server,omitempty"`

	// The Grid member on which you want to store the DHCP lease history log.
	// Infoblox recommends that you dedicate a member other than the master as a
	// logging member. If possible, use this member solely for storing the DHCP
	// lease history log. If you do not select a member, no logging can occur.
	LeaseLoggingMember *string `json:"lease_logging_member,omitempty"`

	// Defines how the appliance releases DHCP leases. Valid values are
	// "RELEASE_MACHING_ID", "NEVER_RELEASE", or "ONE_LEASE_PER_CLIENT". The
	// default is "RELEASE_MATCHING_ID".
	LeasePerClientSettings string `json:"lease_per_client_settings,omitempty"`

	// Determines the lease scavenging time value. When this field is set, the
	// appliance permanently deletes the free and backup leases, that remain in the
	// database beyond a specified period of time. To disable lease scavenging, set
	// the parameter to -1. The minimum positive value must be greater than 86400
	// seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This value specifies whether the Grid DHCP members log lease events is
	// enabled or not.
	LogLeaseEvents *bool `json:"log_lease_events,omitempty"`

	// This field contains the logic filters to be applied on the Infoblox Grid.
	// This list corresponds to the match rules that are written to the dhcpd
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// Determines the low watermark value. If the percent of allocated addresses
	// drops below this watermark, the appliance makes a syslog entry and if
	// enabled, sends an e-mail notification.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// Determines the low watermark reset value.If the percentage of allocated
	// addresses exceeds this value, a corresponding SNMP trap is reset. A number
	// that specifies the percentage of allocated addresses. The range is from 1 to
	// 100. The low watermark reset value must be higher than the low watermark
	// value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// The Microsoft client DHCP IPv4 code page value of a Grid. This value is the
	// hostname translation code page for Microsoft DHCP IPv4 clients.
	MicrosoftCodePage string `json:"microsoft_code_page,omitempty"`

	// The next server value of a DHCP server. This value is the IP address or name
	// of the boot file server on which the boot file is stored.
	Nextserver *string `json:"nextserver,omitempty"`

	// The list of option 60 match rules.
	Option60MatchRules []*Option60matchrule `json:"option60_match_rules,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object. Note that WAPI does not return special options
	// 'routers', 'domain-name-servers', 'domain-name' and 'broadcast-address' with
	// empty values for this object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// Specifies the number of pings that the Infoblox appliance sends to an IP
	// address to verify that it is not in use. Values are range is from 0 to 10,
	// where 0 disables pings.
	PingCount *uint32 `json:"ping_count,omitempty"`

	// Indicates the number of milliseconds the appliance waits for a response to
	// its ping. Valid values are 100, 500, 1000, 2000, 3000, 4000 and 5000
	// milliseconds.
	PingTimeout *uint32 `json:"ping_timeout,omitempty"`

	// The preferred lifetime value.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The Prefix length mode for DHCPv6.
	PrefixLengthMode string `json:"prefix_length_mode,omitempty"`

	// The list of hostname rewrite policies.
	ProtocolHostnameRewritePolicies []*Hostnamerewritepolicy `json:"protocol_hostname_rewrite_policies,omitempty"`

	// Specifies the duration of time it takes a host to connect to a boot server,
	// such as a TFTP server, and download the file it needs to boot. A 32-bit
	// unsigned integer that represents the duration, in seconds, for which the
	// update is cached. Zero indicates that the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// Determines if the recycle leases feature is enabled or not. If you enabled
	// this feature, and then delete a DHCP range, the appliance stores active
	// leases from this range up to one week after the leases expires.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// The restart setting.
	RestartSetting *GridServicerestart `json:"restart_setting,omitempty"`

	// Indicates whether the DHCP server makes repeated attempts to send DDNS
	// updates to a DNS server.
	RetryDdnsUpdates *bool `json:"retry_ddns_updates,omitempty"`

	// The syslog facility is the location on the syslog server to which you want
	// to sort the syslog messages.
	SyslogFacility string `json:"syslog_facility,omitempty"`

	// The Grid-level TXT record handling value. This value specifies how DHCP
	// should treat the TXT records when performing DNS updates.
	TxtRecordHandling string `json:"txt_record_handling,omitempty"`

	// Controls whether the DHCP server updates DNS when a DHCP lease is renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// The valid lifetime for the Grid members.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (GridDhcpproperties) ObjectType() string {
	return "grid:dhcpproperties"
}

func (obj GridDhcpproperties) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"disable_all_nac_filters", "grid"}
	}
	return obj.returnFields
}

// GridDns represents Infoblox object grid:dns.
// This object supports DNS service management and configuration such as
// time-to-live (TTL) settings, zone transfers, queries, root name servers,
// dynamic updates, sort lists, Transaction Signatures (TSIG) for DNS and
// others, all at the grid level. The service configurations of a grid are
// inherited by all members, zones, and networks unless you specifically
// override them for selected members, zones, and networks. For this reason, it
// is recommended that you configure services at the grid level before
// configuring member, zone and network services.
type GridDns struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Add custom IP, MAC and DNS View name ENDS0 options to outgoing recursive
	// queries.
	AddClientIpMacOptions *bool `json:"add_client_ip_mac_options,omitempty"`

	// Determines if DDNS bulk host is allowed or not.
	AllowBulkhostDdns string `json:"allow_bulkhost_ddns,omitempty"`

	// Determines whether GSS-TSIG zone update is enabled for all Grid members.
	AllowGssTsigZoneUpdates *bool `json:"allow_gss_tsig_zone_updates,omitempty"`

	// Determines if queries from the specified IPv4 or IPv6 addresses and networks
	// are allowed or not. The appliance can also use Transaction Signature (TSIG)
	// keys to authenticate the queries.
	AllowQuery []*Addressac `json:"allow_query,omitempty"`

	// Determines if the responses to recursive queries are enabled or not.
	AllowRecursiveQuery *bool `json:"allow_recursive_query,omitempty"`

	// Determines if zone transfers from specified IPv4 or IPv6 addresses and
	// networks or transfers from hosts authenticated by Transaction signature
	// (TSIG) key are allowed or not.
	AllowTransfer []*Addressac `json:"allow_transfer,omitempty"`

	// Determines if dynamic updates from specified IPv4 or IPv6 addresses,
	// networks or from host authenticated by TSIG key are allowed or not.
	AllowUpdate []*Addressac `json:"allow_update,omitempty"`

	// Determines if the anonymization of captured DNS responses is enabled or
	// disabled.
	AnonymizeResponseLogging *bool `json:"anonymize_response_logging,omitempty"`

	// Mitigation settings for DNS attacks.
	AttackMitigation *GridAttackmitigation `json:"attack_mitigation,omitempty"`

	// The auto blackhole settings.
	AutoBlackhole *GridAutoblackhole `json:"auto_blackhole,omitempty"`

	// The BIND check names policy, which indicates the action the appliance takes
	// when it encounters host names that do not comply with the Strict Hostname
	// Checking policy. This method applies only if the host name restriction
	// policy is set to "Strict Hostname Checking".
	BindCheckNamesPolicy string `json:"bind_check_names_policy,omitempty"`

	// The value of the hostname directive for BIND.
	BindHostnameDirective string `json:"bind_hostname_directive,omitempty"`

	// The list of IPv4 or IPv6 addresses and networks from which DNS queries are
	// blocked.
	BlackholeList []*Addressac `json:"blackhole_list,omitempty"`

	// The action to perform when a domain name matches the pattern defined in a
	// rule that is specified by the blacklist ruleset.
	BlacklistAction string `json:"blacklist_action,omitempty"`

	// Determines if blacklist redirection queries are logged or not.
	BlacklistLogQuery *bool `json:"blacklist_log_query,omitempty"`

	// The IP addresses the appliance includes in the response it sends in place of
	// a blacklisted IP address.
	BlacklistRedirectAddresses []string `json:"blacklist_redirect_addresses,omitempty"`

	// The TTL value (in seconds) of the synthetic DNS responses that result from
	// blacklist redirection.
	BlacklistRedirectTtl *uint32 `json:"blacklist_redirect_ttl,omitempty"`

	// The DNS Ruleset object names assigned at the Grid level for blacklist
	// redirection.
	BlacklistRulesets []string `json:"blacklist_rulesets,omitempty"`

	// The list of bulk host name templates. There are four Infoblox predefined
	// bulk host name templates. Template Name Template Format "Four Octets"
	// -$1-$2-$3-$4 "Three Octets" -$2-$3-$4 "Two Octets" -$3-$4 "One Octet" -$4
	BulkHostNameTemplates []*Bulkhostnametemplate `json:"bulk_host_name_templates,omitempty"`

	// Determines if the capture of DNS queries for all domains is enabled or
	// disabled.
	CaptureDnsQueriesOnAllDomains *bool `json:"capture_dns_queries_on_all_domains,omitempty"`

	// Determines whether the application of BIND check-names for zone transfers
	// and DDNS updates are enabled.
	CheckNamesForDdnsAndZoneTransfer *bool `json:"check_names_for_ddns_and_zone_transfer,omitempty"`

	// The list of zone domain names that are allowed or forbidden for EDNS client
	// subnet (ECS) recursion.
	ClientSubnetDomains []*Clientsubnetdomain `json:"client_subnet_domains,omitempty"`

	// Default IPv4 Source Prefix-Length used when sending queries with EDNS client
	// subnet option.
	ClientSubnetIpv4PrefixLength *uint32 `json:"client_subnet_ipv4_prefix_length,omitempty"`

	// Default IPv6 Source Prefix-Length used when sending queries with EDNS client
	// subnet option.
	ClientSubnetIpv6PrefixLength *uint32 `json:"client_subnet_ipv6_prefix_length,omitempty"`

	// Copy custom IP, MAC and DNS View name ENDS0 options from incoming to
	// outgoing recursive queries.
	CopyClientIpMacOptions *bool `json:"copy_client_ip_mac_options,omitempty"`

	// The allowed IPs, from the zone transfer list, added to the also-notify
	// statement in the named.conf file.
	CopyXferToNotify *bool `json:"copy_xfer_to_notify,omitempty"`

	// The list of customized root nameserver(s). You can use Internet root name
	// servers or specify host names and IP addresses of custom root name servers.
	CustomRootNameServers []NameServer `json:"custom_root_name_servers,omitempty"`

	// Defines whether creation timestamp of RR should be updated ' when DDNS
	// update happens even if there is no change to ' the RR.
	DdnsForceCreationTimestampUpdate *bool `json:"ddns_force_creation_timestamp_update,omitempty"`

	// The DDNS Principal cluster group name.
	DdnsPrincipalGroup *string `json:"ddns_principal_group,omitempty"`

	// Determines if the DDNS principal track is enabled or disabled.
	DdnsPrincipalTracking *bool `json:"ddns_principal_tracking,omitempty"`

	// Determines if an option to restrict DDNS update request based on FQDN
	// patterns is enabled or disabled.
	DdnsRestrictPatterns *bool `json:"ddns_restrict_patterns,omitempty"`

	// The unordered list of restriction patterns for an option of to restrict DDNS
	// updates based on FQDN patterns.
	DdnsRestrictPatternsList []string `json:"ddns_restrict_patterns_list,omitempty"`

	// Determines if an option to restrict DDNS update request to protected
	// resource records is enabled or disabled.
	DdnsRestrictProtected *bool `json:"ddns_restrict_protected,omitempty"`

	// Determines if DDNS update request for principal other than target resource
	// record's principal is restricted.
	DdnsRestrictSecure *bool `json:"ddns_restrict_secure,omitempty"`

	// Determines if an option to restrict DDNS update request to resource records
	// which are marked as 'STATIC' is enabled or disabled.
	DdnsRestrictStatic *bool `json:"ddns_restrict_static,omitempty"`

	// Default bulk host name of a Grid DNS.
	DefaultBulkHostNameTemplate *string `json:"default_bulk_host_name_template,omitempty"`

	// The default TTL value of a Grid DNS object. This interval tells the
	// secondary how long the data can be cached.
	DefaultTtl *uint32 `json:"default_ttl,omitempty"`

	// Determines if the EDNS0 support for queries that require recursive
	// resolution on Grid members is enabled or not.
	DisableEdns *bool `json:"disable_edns,omitempty"`

	// The list of DNS64 synthesis groups associated with this Grid DNS object.
	Dns64Groups []string `json:"dns64_groups,omitempty"`

	// The minimum TTL value, in seconds, that a DNS record must have in order for
	// it to be cached by the DNS Cache Acceleration service. An integer from 1 to
	// 65000 that represents the TTL in seconds.
	DnsCacheAccelerationTtl *uint32 `json:"dns_cache_acceleration_ttl,omitempty"`

	// Determines if the anycast failure (BFD session down) is enabled on member
	// failure or not.
	DnsHealthCheckAnycastControl *bool `json:"dns_health_check_anycast_control,omitempty"`

	// The list of domain names for the DNS health check.
	DnsHealthCheckDomainList []string `json:"dns_health_check_domain_list,omitempty"`

	// The time interval (in seconds) for DNS health check.
	DnsHealthCheckInterval *uint32 `json:"dns_health_check_interval,omitempty"`

	// Determines if the recursive DNS health check is enabled or not.
	DnsHealthCheckRecursionFlag *bool `json:"dns_health_check_recursion_flag,omitempty"`

	// The number of DNS health check retries.
	DnsHealthCheckRetries *uint32 `json:"dns_health_check_retries,omitempty"`

	// The DNS health check timeout interval (in seconds).
	DnsHealthCheckTimeout *uint32 `json:"dns_health_check_timeout,omitempty"`

	// The time limit (in minutes) for the DNS query capture file.
	DnsQueryCaptureFileTimeLimit *uint32 `json:"dns_query_capture_file_time_limit,omitempty"`

	// Determines if the blacklist rules for DNSSEC-enabled clients are enabled or
	// not.
	DnssecBlacklistEnabled *bool `json:"dnssec_blacklist_enabled,omitempty"`

	// Determines if the DNS64 groups for DNSSEC-enabled clients are enabled or
	// not.
	DnssecDns64Enabled *bool `json:"dnssec_dns64_enabled,omitempty"`

	// Determines if the DNS security extension is enabled or not.
	DnssecEnabled *bool `json:"dnssec_enabled,omitempty"`

	// Determines when the DNS member accepts expired signatures.
	DnssecExpiredSignaturesEnabled *bool `json:"dnssec_expired_signatures_enabled,omitempty"`

	// This structure contains the DNSSEC key parameters for this zone.
	DnssecKeyParams *Dnsseckeyparams `json:"dnssec_key_params,omitempty"`

	// A list of zones for which the server does not perform DNSSEC validation.
	DnssecNegativeTrustAnchors []string `json:"dnssec_negative_trust_anchors,omitempty"`

	// Determines if the NXDOMAIN rules for DNSSEC-enabled clients are enabled or
	// not.
	DnssecNxdomainEnabled *bool `json:"dnssec_nxdomain_enabled,omitempty"`

	// Determines if the RPZ policies for DNSSEC-enabled clients are enabled or
	// not.
	DnssecRpzEnabled *bool `json:"dnssec_rpz_enabled,omitempty"`

	// The list of trusted keys for the DNSSEC feature.
	DnssecTrustedKeys []*Dnssectrustedkey `json:"dnssec_trusted_keys,omitempty"`

	// Determines if the DNS security validation is enabled or not.
	DnssecValidationEnabled *bool `json:"dnssec_validation_enabled,omitempty"`

	// The DNSTAP settings.
	DnstapSetting *Dnstapsetting `json:"dnstap_setting,omitempty"`

	// The list of domains for DNS query capture.
	DomainsToCaptureDnsQueries []string `json:"domains_to_capture_dns_queries,omitempty"`

	// Setting to control specific behavior for DTC DNS responses for incoming lbdn
	// matched queries.
	DtcDnsQueriesSpecificBehavior string `json:"dtc_dns_queries_specific_behavior,omitempty"`

	// DTC DNSSEC operation mode.
	DtcDnssecMode string `json:"dtc_dnssec_mode,omitempty"`

	// Determines whether to prefer the client address from the edns-client-subnet
	// option for DTC or not.
	DtcEdnsPreferClientSubnet *bool `json:"dtc_edns_prefer_client_subnet,omitempty"`

	// The scheduled backup configuration.
	DtcScheduledBackup *Scheduledbackup `json:"dtc_scheduled_backup,omitempty"`

	// The DTC topology extensible attribute definition list. When configuring a
	// DTC topology, users may configure classification as either "Geographic" or
	// "Extensible Attributes". Selecting extensible attributes will replace
	// supported Topology database labels (Continent, Country, Subdivision, City)
	// with the names of the selection EA types and provide values extracted from
	// DHCP Network Container, Network and Range objects with those extensible
	// attributes.
	DtcTopologyEaList []string `json:"dtc_topology_ea_list,omitempty"`

	// Advertises the EDNS0 buffer size to the upstream server. The value should be
	// between 512 and 4096 bytes. The recommended value is between 512 and 1220
	// bytes.
	EdnsUdpSize *uint32 `json:"edns_udp_size,omitempty"`

	// The email address of a Grid DNS object.
	Email *string `json:"email,omitempty"`

	// Determines if the blocking of DNS queries is enabled or not.
	EnableBlackhole *bool `json:"enable_blackhole,omitempty"`

	// Determines if a blacklist is enabled or not.
	EnableBlacklist *bool `json:"enable_blacklist,omitempty"`

	// Determines if the capture of DNS queries is enabled or disabled.
	EnableCaptureDnsQueries *bool `json:"enable_capture_dns_queries,omitempty"`

	// Determines if the capture of DNS responses is enabled or disabled.
	EnableCaptureDnsResponses *bool `json:"enable_capture_dns_responses,omitempty"`

	// Determines whether to enable forwarding EDNS client subnet options to
	// upstream servers.
	EnableClientSubnetForwarding *bool `json:"enable_client_subnet_forwarding,omitempty"`

	// Determines whether to enable adding EDNS client subnet options in recursive
	// resolution.
	EnableClientSubnetRecursive *bool `json:"enable_client_subnet_recursive,omitempty"`

	// Determines if the ability to automatically remove associated PTR records
	// while deleting A or AAAA records is enabled or not.
	EnableDeleteAssociatedPtr *bool `json:"enable_delete_associated_ptr,omitempty"`

	// Determines if the DNS64 support is enabled or not.
	EnableDns64 *bool `json:"enable_dns64,omitempty"`

	// Determines if the DNS health check is enabled or not.
	EnableDnsHealthCheck *bool `json:"enable_dns_health_check,omitempty"`

	// Determines whether the query messages need to be forwarded to DNSTAP or not.
	EnableDnstapQueries *bool `json:"enable_dnstap_queries,omitempty"`

	// Determines whether the response messages need to be forwarded to DNSTAP or
	// not.
	EnableDnstapResponses *bool `json:"enable_dnstap_responses,omitempty"`

	// Determines if excluding domain names from captured DNS queries and responses
	// is enabled or disabled.
	EnableExcludedDomainNames *bool `json:"enable_excluded_domain_names,omitempty"`

	// Determines if the fixed RRset order FQDN is enabled or not.
	EnableFixedRrsetOrderFqdns *bool `json:"enable_fixed_rrset_order_fqdns,omitempty"`

	// Determines whether Fault Tolerant Caching (FTC) is enabled.
	EnableFtc *bool `json:"enable_ftc,omitempty"`

	// Determines whether all appliances in the Grid are enabled to receive
	// GSS-TSIG authenticated updates from DNS clients.
	EnableGssTsig *bool `json:"enable_gss_tsig,omitempty"`

	// Determines if the host RRset order is enabled or not.
	EnableHostRrsetOrder *bool `json:"enable_host_rrset_order,omitempty"`

	// Determines whether Hardware Security Modules (HSMs) are enabled for key
	// generation and signing. Note, that you must configure the HSM group with at
	// least one enabled HSM.
	EnableHsmSigning *bool `json:"enable_hsm_signing,omitempty"`

	// Determines if the notify source port at the Grid Level is enabled or not.
	EnableNotifySourcePort *bool `json:"enable_notify_source_port,omitempty"`

	// Determines if the DNS query rewrite is enabled or not.
	EnableQueryRewrite *bool `json:"enable_query_rewrite,omitempty"`

	// Determines if the query source port at the Grid Level is enabled or not.
	EnableQuerySourcePort *bool `json:"enable_query_source_port,omitempty"`

	// The list of domains that are excluded from DNS query and response capture.
	ExcludedDomainNames []string `json:"excluded_domain_names,omitempty"`

	// The expiration time of a Grid DNS object. If the secondary DNS server fails
	// to contact the primary server for the specified interval, the secondary
	// server stops giving out answers about the zone because the zone data is too
	// old to be useful.
	ExpireAfter *uint32 `json:"expire_after,omitempty"`

	// The DNS capture file transfer settings.Include the specified parameter to
	// set the attribute value. Omit the parameter to retrieve the attribute value.
	FileTransferSetting *Filetransfersetting `json:"file_transfer_setting,omitempty"`

	// The type of AAAA filtering for this member DNS object.
	FilterAaaa string `json:"filter_aaaa,omitempty"`

	// The list of IPv4 addresses and networks from which queries are received.
	// AAAA filtering is applied to these addresses.
	FilterAaaaList []*Addressac `json:"filter_aaaa_list,omitempty"`

	// The fixed RRset order FQDN. If this field does not contain an empty value,
	// the appliance will automatically set the enable_fixed_rrset_order_fqdns
	// field to 'true', unless the same request sets the enable field to 'false'.
	FixedRrsetOrderFqdns []*GridDnsFixedrrsetorderfqdn `json:"fixed_rrset_order_fqdns,omitempty"`

	// Determines if member sends queries to forwarders only. When the value is
	// "true", the member sends queries to forwarders only, and not to other
	// internal or Internet root servers.
	ForwardOnly *bool `json:"forward_only,omitempty"`

	// Determines if secondary servers is allowed to forward updates to the DNS
	// server or not.
	ForwardUpdates *bool `json:"forward_updates,omitempty"`

	// The forwarders for the member. A forwarder is essentially a name server to
	// which other name servers first send all of their off-site queries. The
	// forwarder builds up a cache of information, avoiding the need for the other
	// name servers to send queries off-site.
	Forwarders []string `json:"forwarders,omitempty"`

	// The timeout interval (in seconds) after which the expired Fault Tolerant
	// Caching (FTC)record is stale and no longer valid.
	FtcExpiredRecordTimeout *uint32 `json:"ftc_expired_record_timeout,omitempty"`

	// The TTL value (in seconds) of the expired Fault Tolerant Caching (FTC)
	// record in DNS responses.
	FtcExpiredRecordTtl *uint32 `json:"ftc_expired_record_ttl,omitempty"`

	// Flag for taking EA values from IPAM Hosts into consideration for the DTC
	// topology EA database.
	GenEadbFromHosts *bool `json:"gen_eadb_from_hosts,omitempty"`

	// Flag for taking EA values from IPAM Network Containers into consideration
	// for the DTC topology EA database.
	GenEadbFromNetworkContainers *bool `json:"gen_eadb_from_network_containers,omitempty"`

	// Flag for taking EA values from IPAM Network into consideration for the DTC
	// topology EA database.
	GenEadbFromNetworks *bool `json:"gen_eadb_from_networks,omitempty"`

	// Flag for taking EA values from IPAM Ranges into consideration for the DTC
	// topology EA database.
	GenEadbFromRanges *bool `json:"gen_eadb_from_ranges,omitempty"`

	// The list of GSS-TSIG keys for a Grid DNS object.
	GssTsigKeys []*Kerberoskey `json:"gss_tsig_keys,omitempty"`

	// The number of seconds to cache lame delegations or lame servers.
	LameTtl *uint32 `json:"lame_ttl,omitempty"`

	// Determines last queried ACL for the specified IPv4 or IPv6 addresses and
	// networks in scavenging settings.
	LastQueriedAcl []*Addressac `json:"last_queried_acl,omitempty"`

	// The logging categories.
	LoggingCategories *GridLoggingcategories `json:"logging_categories,omitempty"`

	// The maximum time (in seconds) for which the server will cache positive
	// answers.
	MaxCacheTtl *uint32 `json:"max_cache_ttl,omitempty"`

	// The maximum time (in seconds) a DNS response can be stored in the hardware
	// acceleration cache. Valid values are unsigned integer between 60 and 86400,
	// inclusive.
	MaxCachedLifetime *uint32 `json:"max_cached_lifetime,omitempty"`

	// The maximum time (in seconds) for which the server will cache negative
	// (NXDOMAIN) responses. The maximum allowed value is 604800.
	MaxNcacheTtl *uint32 `json:"max_ncache_ttl,omitempty"`

	// The value is used by authoritative DNS servers to never send DNS responses
	// larger than the configured value. The value should be between 512 and 4096
	// bytes. The recommended value is between 512 and 1220 bytes.
	MaxUdpSize *uint32 `json:"max_udp_size,omitempty"`

	// Determines if Grid members that are authoritative secondary servers are
	// allowed to send notification messages to external name servers, if the Grid
	// member that is primary for a zone fails or loses connectivity.
	MemberSecondaryNotify *bool `json:"member_secondary_notify,omitempty"`

	// The negative TTL value of a Grid DNS object. This interval tells the
	// secondary how long data can be cached for "Does Not Respond" responses.
	NegativeTtl *uint32 `json:"negative_ttl,omitempty"`

	// Specifies with how many seconds of delay the notify messages are sent to
	// secondaries.
	NotifyDelay *uint32 `json:"notify_delay,omitempty"`

	// The source port for notify messages. When requesting zone transfers from the
	// primary server, some secondary DNS servers use the source port number (the
	// primary server used to send the notify message) as the destination port
	// number in the zone transfer request. Valid values are between 1 and 63999.
	// The default is picked by BIND.
	NotifySourcePort *uint32 `json:"notify_source_port,omitempty"`

	// The default nameserver group.
	NsgroupDefault *string `json:"nsgroup_default,omitempty"`

	// A name server group is a collection of one primary DNS server and one or
	// more secondary DNS servers.
	Nsgroups []string `json:"nsgroups,omitempty"`

	// Determines if NXDOMAIN redirection queries are logged or not.
	NxdomainLogQuery *bool `json:"nxdomain_log_query,omitempty"`

	// Determines if NXDOMAIN redirection is enabled or not.
	NxdomainRedirect *bool `json:"nxdomain_redirect,omitempty"`

	// The list of IPv4 NXDOMAIN redirection addresses.
	NxdomainRedirectAddresses []string `json:"nxdomain_redirect_addresses,omitempty"`

	// The list of IPv6 NXDOMAIN redirection addresses.
	NxdomainRedirectAddressesV6 []string `json:"nxdomain_redirect_addresses_v6,omitempty"`

	// The TTL value (in seconds) of synthetic DNS responses that result from
	// NXDOMAIN redirection.
	NxdomainRedirectTtl *uint32 `json:"nxdomain_redirect_ttl,omitempty"`

	// The Ruleset object names assigned at the Grid level for NXDOMAIN
	// redirection.
	NxdomainRulesets []string `json:"nxdomain_rulesets,omitempty"`

	// Determines if the host RRset order on secondaries is preserved or not.
	PreserveHostRrsetOrderOnSecondaries *bool `json:"preserve_host_rrset_order_on_secondaries,omitempty"`

	// The list of record name policies.
	ProtocolRecordNamePolicies []*Recordnamepolicy `json:"protocol_record_name_policies,omitempty"`

	// The list of domain names that trigger DNS query rewrite.
	QueryRewriteDomainNames []string `json:"query_rewrite_domain_names,omitempty"`

	// The domain name prefix for DNS query rewrite.
	QueryRewritePrefix *string `json:"query_rewrite_prefix,omitempty"`

	// The source port for queries. Specifying a source port number for recursive
	// queries ensures that a firewall will allow the response. Valid values are
	// between 1 and 63999. The default is picked by BIND.
	QuerySourcePort *uint32 `json:"query_source_port,omitempty"`

	// The list of IPv4 or IPv6 addresses, networks or hosts authenticated by
	// Transaction signature (TSIG) key from which recursive queries are allowed or
	// denied.
	RecursiveQueryList []*Addressac `json:"recursive_query_list,omitempty"`

	// The refresh time. This interval tells the secondary how often to send a
	// message to the primary for a zone to check that its data is current, and
	// retrieve fresh data if it is not.
	RefreshTimer *uint32 `json:"refresh_timer,omitempty"`

	// The recursive query timeout for the member.
	ResolverQueryTimeout *uint32 `json:"resolver_query_timeout,omitempty"`

	// The response rate limiting settings for the member.
	ResponseRateLimiting *GridResponseratelimiting `json:"response_rate_limiting,omitempty"`

	// The restart setting.
	RestartSetting *GridServicerestart `json:"restart_setting,omitempty"`

	// The retry time. This interval tells the secondary how long to wait before
	// attempting to recontact the primary after a connection failure occurs
	// between the two servers.
	RetryTimer *uint32 `json:"retry_timer,omitempty"`

	// Determines the type of root name servers.
	RootNameServerType string `json:"root_name_server_type,omitempty"`

	// Determines if NSDNAME and NSIP resource records from RPZ feeds are enabled
	// or not.
	RpzDisableNsdnameNsip *bool `json:"rpz_disable_nsdname_nsip,omitempty"`

	// Enables the appliance to ignore RPZ-IP triggers with prefix lengths less
	// than the specified minimum prefix length.
	RpzDropIpRuleEnabled *bool `json:"rpz_drop_ip_rule_enabled,omitempty"`

	// The minimum prefix length for IPv4 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv4
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv4 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv4,omitempty"`

	// The minimum prefix length for IPv6 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv6
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv6 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv6,omitempty"`

	// Determines if recursive RPZ lookups are enabled.
	RpzQnameWaitRecurse *bool `json:"rpz_qname_wait_recurse,omitempty"`

	// The Grid level scavenging settings.
	ScavengingSettings *SettingScavenging `json:"scavenging_settings,omitempty"`

	// The number of maximum concurrent SOA queries per second. Valid values are
	// unsigned integer between 20 and 1000, inclusive.
	SerialQueryRate *uint32 `json:"serial_query_rate,omitempty"`

	// The value of the server-id directive for BIND and Unbound DNS.
	ServerIdDirective string `json:"server_id_directive,omitempty"`

	// A sort list determines the order of addresses in responses made to DNS
	// queries.
	Sortlist []*Sortlist `json:"sortlist,omitempty"`

	// Determines if the storage of query capture reports on the appliance is
	// enabled or disabled.
	StoreLocally *bool `json:"store_locally,omitempty"`

	// The syslog facility. This is the location on the syslog server to which you
	// want to sort the DNS logging messages.
	SyslogFacility string `json:"syslog_facility,omitempty"`

	// The list of excluded DNS servers during zone transfers.
	TransferExcludedServers []string `json:"transfer_excluded_servers,omitempty"`

	// The BIND format for a zone transfer. This provides tracking capabilities for
	// single or multiple transfers and their associated servers.
	TransferFormat string `json:"transfer_format,omitempty"`

	// The number of maximum concurrent transfers for the Grid. Valid values are
	// unsigned integer between 10 and 10000, inclusive.
	TransfersIn *uint32 `json:"transfers_in,omitempty"`

	// The number of maximum outbound concurrent zone transfers. Valid values are
	// unsigned integer between 10 and 10000, inclusive.
	TransfersOut *uint32 `json:"transfers_out,omitempty"`

	// The number of maximum concurrent transfers per member. Valid values are
	// unsigned integer between 2 and 10000, inclusive.
	TransfersPerNs *uint32 `json:"transfers_per_ns,omitempty"`

	// Determines if the double confirmation during zone deletion is enabled or
	// not.
	ZoneDeletionDoubleConfirm *bool `json:"zone_deletion_double_confirm,omitempty"`
}

func (GridDns) ObjectType() string {
	return "grid:dns"
}

func (obj GridDns) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// GridFiledistribution represents Infoblox object grid:filedistribution.
// The Grid file distribution object represents the file distribution storage
// limit configuration and global file distribution statistics.
type GridFiledistribution struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the uploads to Grid members are allowed.
	AllowUploads *bool `json:"allow_uploads,omitempty"`

	// Determines whether to include distributed files in the backup.
	BackupStorage *bool `json:"backup_storage,omitempty"`

	// The value is the percentage of the allocated TFTP storage space that is
	// used, expressed in tenth of a percent. Valid values are from 0 to 1000.
	CurrentUsage uint32 `json:"current_usage,omitempty"`

	// Determines whether the FTP anonymous login is enabled.
	EnableAnonymousFtp *bool `json:"enable_anonymous_ftp,omitempty"`

	// The Grid file distribution global status.
	GlobalStatus string `json:"global_status,omitempty"`

	// The Grid name.
	Name string `json:"name,omitempty"`

	// Maximum storage in megabytes allowed on the Grid. The maximum storage space
	// allowed for all file distribution services on a Grid is equal to the storage
	// space allowed to the Grid member with the smallest amount of space allowed.
	StorageLimit *uint32 `json:"storage_limit,omitempty"`
}

func (GridFiledistribution) ObjectType() string {
	return "grid:filedistribution"
}

func (obj GridFiledistribution) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"allow_uploads", "current_usage", "global_status", "name", "storage_limit"}
	}
	return obj.returnFields
}

// GridLicensePool represents Infoblox object grid:license_pool.
// This object represents the Grid license pool.
type GridLicensePool struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The number of dynamic licenses allocated to vNIOS appliances.
	Assigned uint32 `json:"assigned,omitempty"`

	// The license expiration status.
	ExpirationStatus string `json:"expiration_status,omitempty"`

	// The expiration timestamp of the license.
	ExpiryDate *UnixTime `json:"expiry_date,omitempty"`

	// The total number of dynamic licenses allowed for this license pool.
	Installed uint32 `json:"installed,omitempty"`

	// The license string for the license pool.
	Key string `json:"key,omitempty"`

	// The limitation of dynamic license that can be allocated from the license
	// pool.
	Limit string `json:"limit,omitempty"`

	// The license limit context.
	LimitContext string `json:"limit_context,omitempty"`

	// The supported vNIOS virtual appliance model.
	Model string `json:"model,omitempty"`

	// The license pool subpools.
	Subpools []*GridLicensesubpool `json:"subpools,omitempty"`

	// The total number of temporary dynamic licenses allocated to vNIOS
	// appliances.
	TempAssigned uint32 `json:"temp_assigned,omitempty"`

	// The license type.
	Type string `json:"type,omitempty"`
}

func (GridLicensePool) ObjectType() string {
	return "grid:license_pool"
}

func (obj GridLicensePool) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"type"}
	}
	return obj.returnFields
}

// GridLicensePoolContainer represents Infoblox object grid:license_pool_container.
// This object represents the Grid license pool container.
type GridLicensePoolContainer struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The timestamp when the last pool licenses were updated.
	LastEntitlementUpdate *UnixTime `json:"last_entitlement_update,omitempty"`

	// The world-wide unique ID for the license pool container.
	LpcUid string `json:"lpc_uid,omitempty"`
}

func (GridLicensePoolContainer) ObjectType() string {
	return "grid:license_pool_container"
}

func (obj GridLicensePoolContainer) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// GridMaxminddbinfo represents Infoblox object grid:maxminddbinfo.
// The information about Topology DB.
type GridMaxminddbinfo struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The major version of DB binary format.
	BinaryMajorVersion uint32 `json:"binary_major_version,omitempty"`

	// The minor version of DB binary format.
	BinaryMinorVersion uint32 `json:"binary_minor_version,omitempty"`

	// The time at which the DB was built.
	BuildTime *UnixTime `json:"build_time,omitempty"`

	// The structure of data records ("GeoLite2-Country", GeoLite2-City", etc.).
	DatabaseType string `json:"database_type,omitempty"`

	// The time at which the current Topology DB was deployed.
	DeploymentTime *UnixTime `json:"deployment_time,omitempty"`

	// The member for testing the connection.
	Member string `json:"member,omitempty"`

	// The topology type.
	TopologyType string `json:"topology_type,omitempty"`
}

func (GridMaxminddbinfo) ObjectType() string {
	return "grid:maxminddbinfo"
}

func (obj GridMaxminddbinfo) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"binary_major_version", "binary_minor_version", "build_time", "database_type", "deployment_time", "member", "topology_type"}
	}
	return obj.returnFields
}

// GridMemberCloudapi represents Infoblox object grid:member:cloudapi.
// Class that represents member Cloud configuration settings.
type GridMemberCloudapi struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Defines which administrators are allowed to perform Cloud API request on the
	// Grid Member: no administrators (NONE), any administrators (ALL) or
	// administrators in the ACL list (LIST). Default is ALL.
	AllowApiAdmins string `json:"allow_api_admins,omitempty"`

	// List of administrators allowed to perform Cloud Platform API requests on
	// that member.
	AllowedApiAdmins []*GridCloudapiUser `json:"allowed_api_admins,omitempty"`

	// Controls whether the Cloud API service runs on the member or not.
	EnableService *bool `json:"enable_service,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Structure containing all the information related to Gateway configuration
	// for the member
	GatewayConfig *GridCloudapiGatewayConfig `json:"gateway_config,omitempty"`

	// The related Grid Member.
	Member *Dhcpmember `json:"member,omitempty"`

	// Status of Cloud API service on the member.
	Status string `json:"status,omitempty"`
}

func (GridMemberCloudapi) ObjectType() string {
	return "grid:member:cloudapi"
}

func (obj GridMemberCloudapi) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"allow_api_admins", "allowed_api_admins", "enable_service", "member", "status"}
	}
	return obj.returnFields
}

// GridServicerestartGroup represents Infoblox object grid:servicerestart:group.
// The Grid Service Restart Group object provides the following information
// about the restart: applicable services, members, restart order, and
// periodicity.
type GridServicerestartGroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the Restart Group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if this Restart Group is the default group.
	IsDefault bool `json:"is_default,omitempty"`

	// The timestamp when the status of the latest request has changed.
	LastUpdatedTime *UnixTime `json:"last_updated_time,omitempty"`

	// The list of members belonging to the group.
	Members []string `json:"members,omitempty"`

	// The default restart method for this Restart Group.
	Mode string `json:"mode,omitempty"`

	// The name of this Restart Group.
	Name *string `json:"name,omitempty"`

	// The order to restart.
	Position uint32 `json:"position,omitempty"`

	// The recurring schedule for restart of a group.
	RecurringSchedule *GridServicerestartGroupSchedule `json:"recurring_schedule,omitempty"`

	// The list of requests associated with a restart group.
	Requests []*GridServicerestartRequest `json:"requests,omitempty"`

	// The applicable service for this Restart Group.
	Service string `json:"service,omitempty"`

	// The restart status for a restart group.
	Status string `json:"status,omitempty"`
}

func (GridServicerestartGroup) ObjectType() string {
	return "grid:servicerestart:group"
}

func (obj GridServicerestartGroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "service"}
	}
	return obj.returnFields
}

// GridServicerestartGroupOrder represents Infoblox object grid:servicerestart:group:order.
// The Grid Service Restart Group Order Setting is used to set the restart
// order for particular services and members.
type GridServicerestartGroupOrder struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The ordered list of the Service Restart Group.
	Groups []string `json:"groups,omitempty"`
}

func (GridServicerestartGroupOrder) ObjectType() string {
	return "grid:servicerestart:group:order"
}

func (obj GridServicerestartGroupOrder) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// GridServicerestartRequest represents Infoblox object grid:servicerestart:request.
// The Restart Request object provides information and statistics about the
// service restart routine for the Service Restart Group.
type GridServicerestartRequest struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The error message if restart has failed.
	Error string `json:"error,omitempty"`

	// Indicates if this is a force restart.
	Forced bool `json:"forced,omitempty"`

	// The name of the Restart Group associated with the request.
	Group string `json:"group,omitempty"`

	// The timestamp when the status of the request has changed.
	LastUpdatedTime *UnixTime `json:"last_updated_time,omitempty"`

	// The member to restart.
	Member string `json:"member,omitempty"`

	// Indicates if restart is needed.
	Needed string `json:"needed,omitempty"`

	// The order to restart.
	Order int `json:"order,omitempty"`

	// The result of the restart operation.
	Result string `json:"result,omitempty"`

	// The service to restart.
	Service string `json:"service,omitempty"`

	// The state of the request.
	State string `json:"state,omitempty"`
}

func (GridServicerestartRequest) ObjectType() string {
	return "grid:servicerestart:request"
}

func (obj GridServicerestartRequest) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"error", "group", "result", "state"}
	}
	return obj.returnFields
}

// GridServicerestartRequestChangedobject represents Infoblox object grid:servicerestart:request:changedobject.
// The Grid service restart request changed object provides information about
// changes that are waiting for the restart.
type GridServicerestartRequestChangedobject struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The operation on the changed object.
	Action string `json:"action,omitempty"`

	// The list of changed properties in the object.
	ChangedProperties []string `json:"changed_properties,omitempty"`

	// The time when the object was changed.
	ChangedTime *UnixTime `json:"changed_time,omitempty"`

	// The name of the changed object.
	ObjectName string `json:"object_name,omitempty"`

	// The type of the changed object. This is undefined if the object is not
	// supported.
	ObjectTypeField string `json:"object_type,omitempty"`

	// The name of the user who changed the object properties.
	UserName string `json:"user_name,omitempty"`
}

func (GridServicerestartRequestChangedobject) ObjectType() string {
	return "grid:servicerestart:request:changedobject"
}

func (obj GridServicerestartRequestChangedobject) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"action", "changed_properties", "changed_time", "object_name", "object_type", "user_name"}
	}
	return obj.returnFields
}

// GridServicerestartStatus represents Infoblox object grid:servicerestart:status.
// The Restart Status object provides information and statistics about service
// restart routine for the Grid or Service Restart Group.
type GridServicerestartStatus struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The number of failed requests.
	Failures uint32 `json:"failures,omitempty"`

	// The number of finished requests.
	Finished uint32 `json:"finished,omitempty"`

	// The type of grouping.
	Grouped string `json:"grouped,omitempty"`

	// The number of created yet unprocessed requests for restart.
	NeededRestart uint32 `json:"needed_restart,omitempty"`

	// The number of requests that did not require a restart.
	NoRestart uint32 `json:"no_restart,omitempty"`

	// A reference to the grid or grid:servicerestart:group object associated with
	// the request.
	Parent string `json:"parent,omitempty"`

	// The number of requests that are pending a restart.
	Pending uint32 `json:"pending,omitempty"`

	// The number of forced or needed requests pending for restart.
	PendingRestart uint32 `json:"pending_restart,omitempty"`

	// The number of not forced and not needed requests pending for restart.
	Processing uint32 `json:"processing,omitempty"`

	// The number of service restarts for corresponding members.
	Restarting uint32 `json:"restarting,omitempty"`

	// The number of requests associated with successful restarts.
	Success uint32 `json:"success,omitempty"`

	// The number of timeout requests.
	Timeouts uint32 `json:"timeouts,omitempty"`
}

func (GridServicerestartStatus) ObjectType() string {
	return "grid:servicerestart:status"
}

func (obj GridServicerestartStatus) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"failures", "finished", "grouped", "needed_restart", "no_restart", "parent", "pending", "pending_restart", "processing", "restarting", "success", "timeouts"}
	}
	return obj.returnFields
}

// GridThreatanalytics represents Infoblox object grid:threatanalytics.
// To mitigate DNS data exfiltration, Infoblox DNS threat analytics employs
// analytics algorithms that analyze incoming DNS queries and responses to
// detect DNS tunneling traffic.
type GridThreatanalytics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Disable domain collapsing at grid level
	ConfigureDomainCollapsing *bool `json:"configure_domain_collapsing,omitempty"`

	// The current threat analytics module set.
	CurrentModuleset string `json:"current_moduleset,omitempty"`

	// The Grid whitelist.
	CurrentWhitelist string `json:"current_whitelist,omitempty"`

	// The list of response policy zones for DNS tunnelling requests.
	DnsTunnelBlackListRpzZones []*ZoneRp `json:"dns_tunnel_black_list_rpz_zones,omitempty"`

	// Level of domain collapsing
	DomainCollapsingLevel *uint32 `json:"domain_collapsing_level,omitempty"`

	// Determines whether the automatic threat analytics module set download is
	// enabled.
	EnableAutoDownload *bool `json:"enable_auto_download,omitempty"`

	// Determines whether the scheduled download of the threat analytics module set
	// is enabled.
	EnableScheduledDownload *bool `json:"enable_scheduled_download,omitempty"`

	// Indicates whether auto download service is enabled
	EnableWhitelistAutoDownload *bool `json:"enable_whitelist_auto_download,omitempty"`

	// Indicates whether the custom scheduled settings for auto download is
	// enabled. If false then default frequency is once per 24 hours
	EnableWhitelistScheduledDownload *bool `json:"enable_whitelist_scheduled_download,omitempty"`

	// The last time when the threat analytics module set was checked for the
	// update.
	LastCheckedForUpdate *UnixTime `json:"last_checked_for_update,omitempty"`

	// Timestamp of last checked whitelist
	LastCheckedForWhitelistUpdate *UnixTime `json:"last_checked_for_whitelist_update,omitempty"`

	// The last update time for the threat analytics module set.
	LastModuleUpdateTime *UnixTime `json:"last_module_update_time,omitempty"`

	// The version number of the last updated threat analytics module set.
	LastModuleUpdateVersion string `json:"last_module_update_version,omitempty"`

	// The last update time for the threat analytics whitelist.
	LastWhitelistUpdateTime *UnixTime `json:"last_whitelist_update_time,omitempty"`

	// The version number of the last updated threat analytics whitelist.
	LastWhitelistUpdateVersion string `json:"last_whitelist_update_version,omitempty"`

	// The update policy for the threat analytics module set.
	ModuleUpdatePolicy string `json:"module_update_policy,omitempty"`

	// The Grid name.
	Name string `json:"name,omitempty"`

	// The schedule settings for the threat analytics module set download.
	ScheduledDownload *SettingSchedule `json:"scheduled_download,omitempty"`

	// Schedule setting for automatic whitelist update run
	ScheduledWhitelistDownload *SettingSchedule `json:"scheduled_whitelist_download,omitempty"`

	// whitelist update policy (manual or automatic)
	WhitelistUpdatePolicy string `json:"whitelist_update_policy,omitempty"`
}

func (GridThreatanalytics) ObjectType() string {
	return "grid:threatanalytics"
}

func (obj GridThreatanalytics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"enable_auto_download", "enable_scheduled_download", "module_update_policy", "name"}
	}
	return obj.returnFields
}

// GridThreatprotection represents Infoblox object grid:threatprotection.
// The Grid threat protection settings.
type GridThreatprotection struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The current Grid ruleset.
	CurrentRuleset *string `json:"current_ruleset,omitempty"`

	// Determines if multiple BIND responses via TCP connection are disabled.
	DisableMultipleDnsTcpRequest *bool `json:"disable_multiple_dns_tcp_request,omitempty"`

	// Determines if DNS responses are sent from acceleration cache before applying
	// Threat Protection rules. Recommended for better performance when using DNS
	// Cache Acceleration.
	EnableAccelRespBeforeThreatProtection *bool `json:"enable_accel_resp_before_threat_protection,omitempty"`

	// Determines if auto download service is enabled.
	EnableAutoDownload *bool `json:"enable_auto_download,omitempty"`

	// Determines if NAT (Network Address Translation) mapping for threat
	// protection is enabled or not.
	EnableNatRules *bool `json:"enable_nat_rules,omitempty"`

	// Determines if scheduled download is enabled. The default frequency is once
	// in every 24 hours if it is disabled.
	EnableScheduledDownload *bool `json:"enable_scheduled_download,omitempty"`

	// The number of events logged per second per rule.
	EventsPerSecondPerRule *uint32 `json:"events_per_second_per_rule,omitempty"`

	// The Grid name.
	GridName string `json:"grid_name,omitempty"`

	// The time when the Grid last checked for updates.
	LastCheckedForUpdate *UnixTime `json:"last_checked_for_update,omitempty"`

	// The last rule update timestamp.
	LastRuleUpdateTimestamp *UnixTime `json:"last_rule_update_timestamp,omitempty"`

	// The version of last rule update.
	LastRuleUpdateVersion string `json:"last_rule_update_version,omitempty"`

	// The list of NAT mapping rules for threat protection.
	NatRules []*ThreatprotectionNatrule `json:"nat_rules,omitempty"`

	// Outbound settings for ATP events.
	OutboundSettings *SettingAtpoutbound `json:"outbound_settings,omitempty"`

	// The update rule policy.
	RuleUpdatePolicy string `json:"rule_update_policy,omitempty"`

	// The schedule setting for automatic rule update.
	ScheduledDownload *SettingSchedule `json:"scheduled_download,omitempty"`
}

func (GridThreatprotection) ObjectType() string {
	return "grid:threatprotection"
}

func (obj GridThreatprotection) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"grid_name"}
	}
	return obj.returnFields
}

// GridX509certificate represents Infoblox object grid:x509certificate.
// In the X.509 system, a certification authority issues a certificate binding
// a public key to a particular distinguished name in the X.500 tradition, or
// to an alternative name such as an e-mail address or a DNS entry.
type GridX509certificate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Certificate issuer.
	Issuer string `json:"issuer,omitempty"`

	// X509Certificate serial number.
	Serial string `json:"serial,omitempty"`

	// A Distinguished Name that is made of multiple relative distinguished names
	// (RDNs).
	Subject string `json:"subject,omitempty"`

	// Certificate expiry date.
	ValidNotAfter *UnixTime `json:"valid_not_after,omitempty"`

	// Certificate validity start date.
	ValidNotBefore *UnixTime `json:"valid_not_before,omitempty"`
}

func (GridX509certificate) ObjectType() string {
	return "grid:x509certificate"
}

func (obj GridX509certificate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"issuer", "serial", "subject"}
	}
	return obj.returnFields
}

// Hostnamerewritepolicy represents Infoblox object hostnamerewritepolicy.
// A hostname rewrite policy object represents the set of valid characters as
// well as replacement characters for names that do not conform to the policy.
type Hostnamerewritepolicy struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// True if the policy is the Grid default.
	IsDefault bool `json:"is_default,omitempty"`

	// The name of a hostname rewrite policy object.
	Name *string `json:"name,omitempty"`

	// Determines whether the policy is a predefined one.
	PreDefined bool `json:"pre_defined,omitempty"`

	// The replacement character for symbols in hostnames that do not conform to
	// the hostname policy.
	ReplacementCharacter *string `json:"replacement_character,omitempty"`

	// The set of valid characters represented in string format.
	ValidCharacters *string `json:"valid_characters,omitempty"`
}

func (Hostnamerewritepolicy) ObjectType() string {
	return "hostnamerewritepolicy"
}

func (obj Hostnamerewritepolicy) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "replacement_character", "valid_characters"}
	}
	return obj.returnFields
}

// HsmAllgroups represents Infoblox object hsm:allgroups.
// The All Hardware Security Module (HSM) groups object is used to retrieve all
// HSM groups configured on the appliance.
type HsmAllgroups struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of HSM groups configured on the appliance.
	Groups []*HsmSafenetgroup `json:"groups,omitempty"`
}

func (HsmAllgroups) ObjectType() string {
	return "hsm:allgroups"
}

func (obj HsmAllgroups) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"groups"}
	}
	return obj.returnFields
}

// HsmSafenetgroup represents Infoblox object hsm:safenetgroup.
// You can integrate a Grid with a third-party, network-attached Hardware
// Security Modules (HSMs) for secure private key storage and generation, and
// zone-signing offloading. Infoblox appliances support integration with either
// SafeNet HSMs or Thales HSMs. When using a network-attached HSM, you can
// provide tight physical access control, allowing only selected security
// personnel to physically access the HSM that stores the DNSSEC keys.
type HsmSafenetgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The HSM SafeNet group comment.
	Comment *string `json:"comment,omitempty"`

	// The HSM SafeNet group serial number.
	GroupSn string `json:"group_sn,omitempty"`

	// The list of HSM SafeNet devices.
	HsmSafenet []*HsmSafenet `json:"hsm_safenet,omitempty"`

	// The HSM SafeNet version.
	HsmVersion string `json:"hsm_version,omitempty"`

	// The HSM SafeNet group name.
	Name *string `json:"name,omitempty"`

	// The pass phrase used to unlock the HSM SafeNet keystore.
	PassPhrase *string `json:"pass_phrase,omitempty"`

	// The status of all HSM SafeNet devices in the group.
	Status string `json:"status,omitempty"`
}

func (HsmSafenetgroup) ObjectType() string {
	return "hsm:safenetgroup"
}

func (obj HsmSafenetgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "hsm_version", "name"}
	}
	return obj.returnFields
}

// HsmThalesgroup represents Infoblox object hsm:thalesgroup.
// You can integrate a Grid with a third-party, network-attached Hardware
// Security Modules (HSMs) for secure private key storage and generation, and
// zone-signing offloading. Infoblox appliances support integration with either
// SafeNet HSMs or Thales HSMs. When using a network-attached HSM, you can
// provide tight physical access control, allowing only selected security
// personnel to physically access the HSM that stores the DNSSEC keys.
type HsmThalesgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Thales HSM softcard name.
	CardName *string `json:"card_name,omitempty"`

	// The Thales HSM group comment.
	Comment *string `json:"comment,omitempty"`

	// The remote file server (RFS) IPv4 Address.
	KeyServerIp *string `json:"key_server_ip,omitempty"`

	// The remote file server (RFS) port.
	KeyServerPort *uint32 `json:"key_server_port,omitempty"`

	// The Thales HSM group name.
	Name *string `json:"name,omitempty"`

	// The password phrase used to unlock the Thales HSM keystore.
	PassPhrase *string `json:"pass_phrase,omitempty"`

	// The level of protection that the HSM group uses for the DNSSEC key data.
	Protection string `json:"protection,omitempty"`

	// The status of all Thales HSM devices in the group.
	Status string `json:"status,omitempty"`

	// The list of Thales HSM devices.
	ThalesHsm []*HsmThales `json:"thales_hsm,omitempty"`
}

func (HsmThalesgroup) ObjectType() string {
	return "hsm:thalesgroup"
}

func (obj HsmThalesgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "key_server_ip", "name"}
	}
	return obj.returnFields
}

// IpamStatistics represents Infoblox object ipam:statistics.
// A synthetic object used to view the IPAM statistics of the network or
// network container in an Infoblox appliance
type IpamStatistics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The network CIDR.
	Cidr uint32 `json:"cidr,omitempty"`

	// The number of conflicts discovered via network discovery. This attribute is
	// only valid for a Network object.
	ConflictCount uint32 `json:"conflict_count,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network address.
	Network string `json:"network,omitempty"`

	// The network view.
	NetworkView string `json:"network_view,omitempty"`

	// The number of unmanaged IP addresses as discovered by network discovery.
	// This attribute is only valid for a Network object.
	UnmanagedCount uint32 `json:"unmanaged_count,omitempty"`

	// The network utilization in percentage.
	Utilization uint32 `json:"utilization,omitempty"`

	// The time that the utilization statistics were updated last. This attribute
	// is only valid for a Network object. For a Network Container object, the
	// return value is undefined.
	UtilizationUpdate *UnixTime `json:"utilization_update,omitempty"`
}

func (IpamStatistics) ObjectType() string {
	return "ipam:statistics"
}

func (obj IpamStatistics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"cidr", "network", "network_view"}
	}
	return obj.returnFields
}

// IPv4Address represents Infoblox object ipv4address.
// This object is created only as part of the record.host object, it cannot be
// created directly.
type IPv4Address struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the address; maximum 256 characters.
	Comment string `json:"comment,omitempty"`

	// Types of the conflict.
	ConflictTypes []string `json:"conflict_types,omitempty"`

	// The client unique identifier.
	DhcpClientIdentifier string `json:"dhcp_client_identifier,omitempty"`

	// Discover now status for this address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// DHCP fingerprint for the address.
	Fingerprint string `json:"fingerprint,omitempty"`

	// The IP address.
	IpAddress string `json:"ip_address,omitempty"`

	// If set to True, the IP address has either a MAC address conflict or a DHCP
	// lease conflict detected through a network discovery.
	IsConflict bool `json:"is_conflict,omitempty"`

	// This flag reflects whether the MAC address for this address is invalid.
	IsInvalidMac bool `json:"is_invalid_mac,omitempty"`

	// The lease state of the address.
	LeaseState string `json:"lease_state,omitempty"`

	// The MAC address.
	MacAddress string `json:"mac_address,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The DNS names. For example, if the IP address belongs to a host record, this
	// field contains the hostname. This field supports both single and array
	// search.
	Names []string `json:"names,omitempty"`

	// The network to which this address belongs, in FQDN/CIDR format.
	Network string `json:"network,omitempty"`

	// The name of the network view.
	NetworkView string `json:"network_view,omitempty"`

	// The objects associated with the IP address.
	Objects []string `json:"objects,omitempty"`

	// The reserved port for the address.
	ReservedPort string `json:"reserved_port,omitempty"`

	// The current status of the address.
	Status string `json:"status,omitempty"`

	// The types of associated objects. This field supports both single and array
	// search.
	Types []string `json:"types,omitempty"`

	// Indicates whether the IP address is configured for DNS or DHCP. This field
	// supports both single and array search.
	Usage []string `json:"usage,omitempty"`

	// The name of the user who created or modified the record.
	Username string `json:"username,omitempty"`
}

func (IPv4Address) ObjectType() string {
	return "ipv4address"
}

func (obj IPv4Address) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dhcp_client_identifier", "ip_address", "is_conflict", "lease_state", "mac_address", "names", "network", "network_view", "objects", "status", "types", "usage", "username"}
	}
	return obj.returnFields
}

// IPv6Address represents Infoblox object ipv6address.
// This object is created only as part of the record.host object, it cannot be
// created directly.
type IPv6Address struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the address; maximum 256 characters.
	Comment string `json:"comment,omitempty"`

	// Types of the conflict.
	ConflictTypes []string `json:"conflict_types,omitempty"`

	// Discover now status for this address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// DHCPv6 Unique Identifier (DUID) of the address object.
	Duid string `json:"duid,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// DHCP fingerprint for the address.
	Fingerprint string `json:"fingerprint,omitempty"`

	// IPv6 addresses of the address object.
	IpAddress string `json:"ip_address,omitempty"`

	// IP address has either a duid conflict or a DHCP lease conflict detected
	// through a network discovery.
	IsConflict bool `json:"is_conflict,omitempty"`

	// The lease state of the address.
	LeaseState string `json:"lease_state,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The DNS names. For example, if the IP address belongs to a host record, this
	// field contains the hostname. This field supports both single and array
	// search.
	Names []string `json:"names,omitempty"`

	// The network to which this address belongs, in FQDN/CIDR format.
	Network string `json:"network,omitempty"`

	// The name of the network view.
	NetworkView string `json:"network_view,omitempty"`

	// The objects associated with the IP address.
	Objects []string `json:"objects,omitempty"`

	// The reserved port for the address.
	ReservedPort string `json:"reserved_port,omitempty"`

	// The current status of the address.
	Status string `json:"status,omitempty"`

	// The types of associated objects. This field supports both single and array
	// search.
	Types []string `json:"types,omitempty"`

	// Indicates whether the IP address is configured for DNS or DHCP. This field
	// supports both single and array search.
	Usage []string `json:"usage,omitempty"`
}

func (IPv6Address) ObjectType() string {
	return "ipv6address"
}

func (obj IPv6Address) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"duid", "ip_address", "is_conflict", "lease_state", "names", "network", "network_view", "objects", "status", "types", "usage"}
	}
	return obj.returnFields
}

// Ipv6dhcpoptiondefinition represents Infoblox object ipv6dhcpoptiondefinition.
// An IPv6 option definition defines a DHCP IPv6 option within a specific IPv6
// option space. A custom IPv6 option can be defined in the predefined DHCP
// IPv6 option space or in the user-defined vendor IPv6 option space. To define
// an IPv6 option, add the IPv6 option definition to the required IPv6 option
// space.
type Ipv6dhcpoptiondefinition struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The code of a DHCP IPv6 option definition object. An option code number is
	// used to identify the DHCP option.
	Code *uint32 `json:"code,omitempty"`

	// The name of a DHCP IPv6 option definition object.
	Name *string `json:"name,omitempty"`

	// The space of a DHCP option definition object.
	Space *string `json:"space,omitempty"`

	// The data type of the Grid DHCP IPv6 option.
	Type string `json:"type,omitempty"`
}

func (Ipv6dhcpoptiondefinition) ObjectType() string {
	return "ipv6dhcpoptiondefinition"
}

func (obj Ipv6dhcpoptiondefinition) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"code", "name", "type"}
	}
	return obj.returnFields
}

// Ipv6dhcpoptionspace represents Infoblox object ipv6dhcpoptionspace.
// An IPv6 option space defines a namespace in which vendor IPv6 options can be
// defined. To define a specific vendor IPv6 option space, add an IPv6 option
// space to DHCP.
type Ipv6dhcpoptionspace struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// A descriptive comment of a DHCP IPv6 option space object.
	Comment *string `json:"comment,omitempty"`

	// The enterprise number of a DHCP IPv6 option space object.
	EnterpriseNumber *uint32 `json:"enterprise_number,omitempty"`

	// The name of a DHCP IPv6 option space object.
	Name *string `json:"name,omitempty"`

	// The list of DHCP IPv6 option definition objects.
	OptionDefinitions []string `json:"option_definitions,omitempty"`
}

func (Ipv6dhcpoptionspace) ObjectType() string {
	return "ipv6dhcpoptionspace"
}

func (obj Ipv6dhcpoptionspace) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "enterprise_number", "name"}
	}
	return obj.returnFields
}

// Ipv6filteroption represents Infoblox object ipv6filteroption.
// In the ISC DHCP terms, it defines a class of clients that match a particular
// (option, value) pair. To define an option filter, add an Option to the IPv6
// DHCP Filter object.
type Ipv6filteroption struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines if apply as class is enabled or not. If this flag is set to
	// "true" the filter is treated as global DHCP class, e.g it is written to
	// DHCPv6 configuration file even if it is not present in any DHCP range.
	ApplyAsClass *bool `json:"apply_as_class,omitempty"`

	// The descriptive comment of a DHCP IPv6 filter option object.
	Comment *string `json:"comment,omitempty"`

	// The conditional expression of a DHCP IPv6 filter option object.
	Expression *string `json:"expression,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines the lease time of a DHCP IPv6 filter option object.
	LeaseTime *uint32 `json:"lease_time,omitempty"`

	// The name of a DHCP IPv6 option filter object.
	Name *string `json:"name,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	OptionList []*Dhcpoption `json:"option_list,omitempty"`

	// The option space of a DHCP IPv6 filter option object.
	OptionSpace *string `json:"option_space,omitempty"`
}

func (Ipv6filteroption) ObjectType() string {
	return "ipv6filteroption"
}

func (obj Ipv6filteroption) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Ipv6FixedAddress represents Infoblox object ipv6fixedaddress.
// A IPv6 fixed address is a specific IP address that a DHCP server always
// assigns when a lease request comes from a particular DUID of the client.
type Ipv6FixedAddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The address type value for this IPv6 fixed address. When the address type is
	// "ADDRESS", a value for the 'ipv6addr' member is required. When the address
	// type is "PREFIX", values for 'ipv6prefix' and 'ipv6prefix_bits' are
	// required. When the address type is "BOTH", values for 'ipv6addr',
	// 'ipv6prefix', and 'ipv6prefix_bits' are all required.
	AddressType string `json:"address_type,omitempty"`

	// This field controls whether the credential is used for both the Telnet and
	// SSH credentials. If set to False, the credential is used only for SSH.
	AllowTelnet *bool `json:"allow_telnet,omitempty"`

	// The CLI credentials for the IPv6 fixed address.
	CliCredentials []*DiscoveryClicredential `json:"cli_credentials,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the fixed address; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The description of the device.
	DeviceDescription *string `json:"device_description,omitempty"`

	// The location of the device.
	DeviceLocation *string `json:"device_location,omitempty"`

	// The type of the device.
	DeviceType *string `json:"device_type,omitempty"`

	// The vendor of the device.
	DeviceVendor *string `json:"device_vendor,omitempty"`

	// Determines whether a fixed address is disabled or not. When this is set to
	// False, the IPv6 fixed address is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines if the discovery for this IPv6 fixed address is disabled or not.
	// False means that the discovery is enabled.
	DisableDiscovery *bool `json:"disable_discovery,omitempty"`

	// The discovery status of this IPv6 fixed address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this IPv6 fixed address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The domain name for this IPv6 fixed address.
	DomainName *string `json:"domain_name,omitempty"`

	// The IPv6 addresses of DNS recursive name servers to which the DHCP client
	// can send name resolution requests. The DHCP server includes this information
	// in the DNS Recursive Name Server option in Advertise, Rebind,
	// Information-Request, and Reply messages.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// The DUID value for this IPv6 fixed address.
	Duid *string `json:"duid,omitempty"`

	// Determines if the discovery for the IPv6 fixed address should be immediately
	// enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv6 Address of the DHCP IPv6 fixed address.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The IPv6 Address prefix of the DHCP IPv6 fixed address.
	Ipv6prefix *string `json:"ipv6prefix,omitempty"`

	// Prefix bits of the DHCP IPv6 fixed address.
	Ipv6prefixBits *uint32 `json:"ipv6prefix_bits,omitempty"`

	// This field contains the logic filters to be applied to this IPv6 fixed
	// address. This list corresponds to the match rules that are written to the
	// DHCPv6 configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// This field contains the name of this IPv6 fixed address.
	Name *string `json:"name,omitempty"`

	// The network to which this IPv6 fixed address belongs, in IPv6 Address/CIDR
	// format.
	Network *string `json:"network,omitempty"`

	// The name of the network view in which this IPv6 fixed address resides.
	NetworkView *string `json:"network_view,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The preferred lifetime value for this DHCP IPv6 fixed address object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The reference to the reserved interface to which the device belongs.
	ReservedInterface *string `json:"reserved_interface,omitempty"`

	// Restarts the member service. The restart_if_needed flag can trigger a
	// restart on DHCP services only when it is enabled on CP member.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The SNMPv3 credential for this IPv6 fixed address.
	Snmp3Credential *DiscoverySnmp3credential `json:"snmp3_credential,omitempty"`

	// The SNMPv1 or SNMPv2 credential for this IPv6 fixed address.
	SnmpCredential *DiscoverySnmpcredential `json:"snmp_credential,omitempty"`

	// If set on creation, the IPv6 fixed address will be created according to the
	// values specified in the named template.
	Template string `json:"template,omitempty"`

	// If set to true, the CLI credential will override member-level settings.
	UseCliCredentials *bool `json:"use_cli_credentials,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Determines if the SNMPv3 credential should be used for the IPv6 fixed
	// address.
	UseSnmp3Credential *bool `json:"use_snmp3_credential,omitempty"`

	// If set to true, SNMP credential will override member level settings.
	UseSnmpCredential *bool `json:"use_snmp_credential,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// The valid lifetime value for this DHCP IPv6 Fixed Address object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (Ipv6FixedAddress) ObjectType() string {
	return "ipv6fixedaddress"
}

func (obj Ipv6FixedAddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"duid", "ipv6addr", "network_view"}
	}
	return obj.returnFields
}

// Ipv6fixedaddresstemplate represents Infoblox object ipv6fixedaddresstemplate.
// The IPv6 fixed address template used to create IPv6 fixed address objects in
// a quick and consistent way. An IPv6 fixed address object created from an
// IPv6 fixed address template will inherit most properties defined in the IPv6
// fixed address template object; therefor, most of the IPv6 fixed address
// template properties are the same as the fixed address object properties.
type Ipv6fixedaddresstemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// A descriptive comment of an IPv6 fixed address template object.
	Comment *string `json:"comment,omitempty"`

	// Domain name of the IPv6 fixed address template object.
	DomainName *string `json:"domain_name,omitempty"`

	// The IPv6 addresses of DNS recursive name servers to which the DHCP client
	// can send name resolution requests. The DHCP server includes this information
	// in the DNS Recursive Name Server option in Advertise, Rebind,
	// Information-Request, and Reply messages.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// This field contains the logic filters to be applied to this IPv6 fixed
	// address. This list corresponds to the match rules that are written to the
	// DHCPv6 configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// Name of an IPv6 fixed address template object.
	Name *string `json:"name,omitempty"`

	// The number of IPv6 addresses for this fixed address.
	NumberOfAddresses *uint32 `json:"number_of_addresses,omitempty"`

	// The start address offset for this IPv6 fixed address.
	Offset *uint32 `json:"offset,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The preferred lifetime value for this DHCP IPv6 fixed address template
	// object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// The valid lifetime value for this DHCP IPv6 fixed address template object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (Ipv6fixedaddresstemplate) ObjectType() string {
	return "ipv6fixedaddresstemplate"
}

func (obj Ipv6fixedaddresstemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Ipv6Network represents Infoblox object ipv6network.
// When DHCP services are configured on an appliance, the network that it
// serves must be defined. After a network is created, you can either create
// all the subnets individually, or create a parent network that encompasses
// the subnets.
type Ipv6Network struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone bool `json:"auto_create_reversezone,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the network; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// Use this method to set or retrieve the ddns_enable_option_fqdn flag of a
	// DHCP IPv6 Network object. This method controls whether the FQDN option sent
	// by the client is to be used, or if the server can automatically generate the
	// FQDN. This setting overrides the upper-level settings.
	DdnsEnableOptionFqdn *bool `json:"ddns_enable_option_fqdn,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP clients requests. Note that changes for this field
	// take effect only if ddns_enable_option_fqdn is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network object. The TTL is
	// a 32-bit unsigned integer that represents the duration, in seconds, for
	// which the update is cached. Zero indicates that the update is not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// The reason for deleting the RIR registration request.
	DeleteReason *string `json:"delete_reason,omitempty"`

	// Determines whether a network is disabled or not. When this is set to False,
	// the network is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Discover now status for this network.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// Number of the discovered BGP AS. When multiple BGP autonomous systems are
	// discovered in the network, this field displays "Multiple".
	DiscoveredBgpAs string `json:"discovered_bgp_as,omitempty"`

	// Discovered bridge domain.
	DiscoveredBridgeDomain *string `json:"discovered_bridge_domain,omitempty"`

	// Discovered tenant.
	DiscoveredTenant *string `json:"discovered_tenant,omitempty"`

	// The identifier of the discovered VLAN. When multiple VLANs are discovered in
	// the network, this field displays "Multiple".
	DiscoveredVlanId string `json:"discovered_vlan_id,omitempty"`

	// The name of the discovered VLAN. When multiple VLANs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVlanName string `json:"discovered_vlan_name,omitempty"`

	// Description of the discovered VRF. When multiple VRFs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVrfDescription string `json:"discovered_vrf_description,omitempty"`

	// The name of the discovered VRF. When multiple VRFs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVrfName string `json:"discovered_vrf_name,omitempty"`

	// Route distinguisher of the discovered VRF. When multiple VRFs are discovered
	// in the network, this field displays "Multiple".
	DiscoveredVrfRd string `json:"discovered_vrf_rd,omitempty"`

	// The discovery basic poll settings for this network.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this network.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The network discovery engine type.
	DiscoveryEngineType string `json:"discovery_engine_type,omitempty"`

	// The member that will run discovery for this network.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// Use this method to set or retrieve the domain_name value of a DHCP IPv6
	// Network object.
	DomainName *string `json:"domain_name,omitempty"`

	// Use this method to set or retrieve the dynamic DNS updates flag of a DHCP
	// IPv6 Network object. The DHCP server can send DDNS updates to DNS servers in
	// the same Grid and to external DNS servers. This setting overrides the member
	// level settings.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// The dynamic DNS updates flag of a DHCP IPv6 network object. If set to True,
	// the DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines whether a discovery is enabled or not for this network. When this
	// is set to False, the network discovery is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if IFMAP publishing is enabled for the network.
	EnableIfmapPublishing *bool `json:"enable_ifmap_publishing,omitempty"`

	// Determines if the discovery for the network should be immediately enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// The endpoints that provides data for the DHCP IPv6 Network object.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The timestamp when the last RIR registration update was sent.
	LastRirRegistrationUpdateSent *UnixTime `json:"last_rir_registration_update_sent,omitempty"`

	// Last RIR registration update status.
	LastRirRegistrationUpdateStatus string `json:"last_rir_registration_update_status,omitempty"`

	// This field contains the logic filters to be applied on this IPv6 network.
	// This list corresponds to the match rules that are written to the DHCPv6
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// A list of members servers that serve DHCP for the network. All members in
	// the array must be of the same type. The struct type must be indicated in
	// each element, by setting the "_struct" member to the struct type.
	Members []*Dhcpmember `json:"members,omitempty"`

	// This field controls whether this object is synchronized with the Multi-Grid
	// Master. If this field is set to True, objects are not synchronized.
	MgmPrivate *bool `json:"mgm_private,omitempty"`

	// This field is assumed to be True unless filled by any conforming objects,
	// such as Network, IPv6 Network, Network Container, IPv6 Network Container,
	// and Network View. This value is set to False if mgm_private is set to True
	// in the parent object.
	MgmPrivateOverridable bool `json:"mgm_private_overridable,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network address in IPv6 Address/CIDR format. For regular expression
	// searches, only the IPv6 Address portion is supported. Searches for the CIDR
	// portion is always an exact match. For example, both network containers
	// 16::0/28 and 26::0/24 are matched by expression '.6' and only 26::0/24 is
	// matched by '.6/24'.
	Network *string `json:"network,omitempty"`

	// The network container to which this network belongs, if any.
	NetworkContainer string `json:"network_container,omitempty"`

	// The name of the network view in which this network resides.
	NetworkView *string `json:"network_view,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The port control blackout setting for this network.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// Use this method to set or retrieve the preferred lifetime value of a DHCP
	// IPv6 Network object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The registry (RIR) that allocated the IPv6 network address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization associated with the IPv6 network.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The RIR registration action.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the IPv6 network in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// The DHCP IPv6 Network Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// If set on creation, the network is created according to the values specified
	// in the selected template.
	Template string `json:"template,omitempty"`

	// Determines whether the DHCP IPv6 Network is unmanaged or not.
	Unmanaged *bool `json:"unmanaged,omitempty"`

	// The number of unmanaged IP addresses as discovered by network discovery.
	UnmanagedCount uint32 `json:"unmanaged_count,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_enable_option_fqdn
	UseDdnsEnableOptionFqdn *bool `json:"use_ddns_enable_option_fqdn,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: enable_ifmap_publishing
	UseEnableIfmapPublishing *bool `json:"use_enable_ifmap_publishing,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: mgm_private
	UseMgmPrivate *bool `json:"use_mgm_private,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// Use flag for: zone_associations
	UseZoneAssociations *bool `json:"use_zone_associations,omitempty"`

	// Use this method to set or retrieve the valid lifetime value of a DHCP IPv6
	// Network object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`

	// List of VLANs assigned to Network.
	Vlans []*Vlanlink `json:"vlans,omitempty"`

	// The list of zones associated with this network.
	ZoneAssociations []*Zoneassociation `json:"zone_associations,omitempty"`
}

func (Ipv6Network) ObjectType() string {
	return "ipv6network"
}

func (obj Ipv6Network) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "network", "network_view"}
	}
	return obj.returnFields
}

// Ipv6NetworkContainer represents Infoblox object ipv6networkcontainer.
// A network can contain child networks. The network that contains child
// networks is called a network container. This object encapsulates an IPv6
// network container object.
type Ipv6NetworkContainer struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone bool `json:"auto_create_reversezone,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the network; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network container.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// Use this method to set or retrieve the ddns_enable_option_fqdn flag of a
	// DHCP IPv6 Network Container object. This method controls whether the FQDN
	// option sent by the client is to be used, or if the server can automatically
	// generate the FQDN. This setting overrides the upper-level settings.
	DdnsEnableOptionFqdn *bool `json:"ddns_enable_option_fqdn,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether the DHCP server is allowed to update DNS,
	// regardless of the DHCP client requests. Note that changes for this field
	// take effect only if ddns_enable_option_fqdn is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network container object.
	// The TTL is a 32-bit unsigned integer that represents the duration, in
	// seconds, for which the update is cached. Zero indicates that the update is
	// not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// The reason for deleting the RIR registration request.
	DeleteReason *string `json:"delete_reason,omitempty"`

	// Discover now status for this network container.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovery basic poll settings for this network container.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this network container.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The network discovery engine type.
	DiscoveryEngineType string `json:"discovery_engine_type,omitempty"`

	// The member that will run discovery for this network container.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// Use this method to set or retrieve the dynamic DNS updates flag of a DHCP
	// IPv6 Network Container object. The DHCP server can send DDNS updates to DNS
	// servers in the same Grid and to external DNS servers. This setting overrides
	// the member level settings.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// The dynamic DNS updates flag of a DHCP IPv6 network container object. If set
	// to True, the DHCP server sends DDNS updates to DNS servers in the same Grid,
	// and to external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines whether a discovery is enabled or not for this network container.
	// When this is set to False, the network container discovery is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if the discovery for the network container should be immediately
	// enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// The endpoints that provides data for the DHCP IPv6 Network Container.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The timestamp when the last RIR registration update was sent.
	LastRirRegistrationUpdateSent *UnixTime `json:"last_rir_registration_update_sent,omitempty"`

	// Last RIR registration update status.
	LastRirRegistrationUpdateStatus string `json:"last_rir_registration_update_status,omitempty"`

	// This field contains the logic filters to be applied on the this network
	// container. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// This field controls whether this object is synchronized with the Multi-Grid
	// Master. If this field is set to True, objects are not synchronized.
	MgmPrivate *bool `json:"mgm_private,omitempty"`

	// This field is assumed to be True unless filled by any conforming objects,
	// such as Network, IPv6 Network, Network Container, IPv6 Network Container,
	// and Network View. This value is set to False if mgm_private is set to True
	// in the parent object.
	MgmPrivateOverridable bool `json:"mgm_private_overridable,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network address in IPv6 Address/CIDR format. For regular expression
	// searches, only the IPv6 Address portion is supported. Searches for the CIDR
	// portion is always an exact match. For example, both network containers
	// 16::0/28 and 26::0/24 are matched by expression '.6' and only 26::0/24 is
	// matched by '.6/24'.
	Network string `json:"network,omitempty"`

	// The network container to which this network belongs, if any.
	NetworkContainer string `json:"network_container,omitempty"`

	// The name of the network view in which this network resides.
	NetworkView *string `json:"network_view,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The port control blackout setting for this network container.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// Use this method to set or retrieve the preferred lifetime value of a DHCP
	// IPv6 Network Container object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// Remove subnets delete option. Determines whether all child objects should be
	// removed alongside with the IPv6 network container or child objects should be
	// assigned to another parental container. By default child objects are deleted
	// with this network container.
	RemoveSubnets bool `json:"remove_subnets,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The registry (RIR) that allocated the IPv6 network container address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization associated with the IPv6 network container.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The RIR registration action.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the IPv6 network container in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// The DHCP IPv6 Network Container Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// Determines whether the network container is unmanaged or not.
	Unmanaged *bool `json:"unmanaged,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_enable_option_fqdn
	UseDdnsEnableOptionFqdn *bool `json:"use_ddns_enable_option_fqdn,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: mgm_private
	UseMgmPrivate *bool `json:"use_mgm_private,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// Use flag for: zone_associations
	UseZoneAssociations *bool `json:"use_zone_associations,omitempty"`

	// The network container utilization in percentage.
	Utilization uint32 `json:"utilization,omitempty"`

	// Use this method to set or retrieve the valid lifetime value of a DHCP IPv6
	// Network Container object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`

	// The list of zones associated with this network container.
	ZoneAssociations []*Zoneassociation `json:"zone_associations,omitempty"`
}

func (Ipv6NetworkContainer) ObjectType() string {
	return "ipv6networkcontainer"
}

func (obj Ipv6NetworkContainer) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "network", "network_view"}
	}
	return obj.returnFields
}

// IPv6NetworkTemplate represents Infoblox object ipv6networktemplate.
// The IPv6 network template used to create IPv6 networks in a quick and
// consistent way. IPv6 networks created from an IPv6 network template inherit
// all the properties defined in the IPv6 network template, except for the
// comment and CIDR that can be defined in the IPv6 network.
type IPv6NetworkTemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This flag controls whether the template allows any netmask. You must specify
	// a netmask when creating a network using this template. If you set this
	// parameter to False, you must specify the "cidr" field for the network
	// template object.
	AllowAnyNetmask *bool `json:"allow_any_netmask,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone *bool `json:"auto_create_reversezone,omitempty"`

	// The CIDR of the network in CIDR format.
	Cidr *uint32 `json:"cidr,omitempty"`

	// This flag controls whether this template can be used to create network
	// objects in a cloud-computing deployment.
	CloudApiCompatible *bool `json:"cloud_api_compatible,omitempty"`

	// Comment for the network; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// Use this method to set or retrieve the ddns_enable_option_fqdn flag of a
	// DHCP IPv6 Network object. This method controls whether the FQDN option sent
	// by the client is to be used, or if the server can automatically generate the
	// FQDN. This setting overrides the upper-level settings.
	DdnsEnableOptionFqdn *bool `json:"ddns_enable_option_fqdn,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether the DHCP server is allowed to update DNS,
	// regardless of the DHCP client requests. Note that changes for this field
	// take effect only if ddns_enable_option_fqdn is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network object. The TTL is
	// a 32-bit unsigned integer that represents the duration, in seconds, for
	// which the update is cached. Zero indicates that the update is not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// Reference the Cloud Platform Appliance to which authority of the object
	// should be delegated when the object is created using the template.
	DelegatedMember *Dhcpmember `json:"delegated_member,omitempty"`

	// Use this method to set or retrieve the domain_name value of a DHCP IPv6
	// Network object.
	DomainName *string `json:"domain_name,omitempty"`

	// Use this method to set or retrieve the dynamic DNS updates flag of a DHCP
	// IPv6 Network object. The DHCP server can send DDNS updates to DNS servers in
	// the same Grid and to external DNS servers. This setting overrides the member
	// level settings.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// The dynamic DNS updates flag of a DHCP IPv6 network object. If set to True,
	// the DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of IPv6 fixed address templates assigned to this IPv6 network
	// template object. When you create an IPv6 network based on an IPv6 network
	// template object that contains IPv6 fixed address templates, the IPv6 fixed
	// addresses are created based on the associated IPv6 fixed address templates.
	FixedAddressTemplates []string `json:"fixed_address_templates,omitempty"`

	// The IPv6 Address prefix of the DHCP IPv6 network.
	Ipv6prefix *string `json:"ipv6prefix,omitempty"`

	// This field contains the logic filters to be applied on this IPv6 network
	// template. This list corresponds to the match rules that are written to the
	// DHCPv6 configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// A list of members that serve DHCP for the network. All members in the array
	// must be of the same type. The struct type must be indicated in each element,
	// by setting the "_struct" member to the struct type.
	Members []*Dhcpmember `json:"members,omitempty"`

	// The name of this IPv6 network template.
	Name *string `json:"name,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// Use this method to set or retrieve the preferred lifetime value of a DHCP
	// IPv6 Network object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The list of IPv6 address range templates assigned to this IPv6 network
	// template object. When you create an IPv6 network based on an IPv6 network
	// template object that contains IPv6 range templates, the IPv6 address ranges
	// are created based on the associated IPv6 address range templates.
	RangeTemplates []string `json:"range_templates,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// The registry (RIR) that allocated the IPv6 network address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization associated with the IPv6 network.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The action for the RIR registration.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the IPv6 network in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_enable_option_fqdn
	UseDdnsEnableOptionFqdn *bool `json:"use_ddns_enable_option_fqdn,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// Use this method to set or retrieve the valid lifetime value of a DHCP IPv6
	// Network object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (IPv6NetworkTemplate) ObjectType() string {
	return "ipv6networktemplate"
}

func (obj IPv6NetworkTemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// IPv6Range represents Infoblox object ipv6range.
// A DHCP IPv6 range defines the specified range of IP addresses in an IPv6
// network. A DHCP IPv6 range should be added for an IPv6 network so the
// Infoblox appliance can assign IP addresses within that specified range to
// DHCP clients. If the client is on an IPv6 network that is assigned a DHCP
// IPv6 range, the device distributes an available IP address from that range
// to the DHCP client, or to a DHCP relay agent if the request came through an
// agent. The DHCP IPv6 range should also be assigned with a device. If devices
// are in a grid, the particular member serving DHCP for the DHCP IPv6 range
// must be specified. If the server is an independent device, this device must
// be specified as the member that serves the DHCP IPv6 range.
type IPv6Range struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Type of a DHCP IPv6 Range object. Valid values are "ADDRESS", "PREFIX", or
	// "BOTH". When the address type is "ADDRESS", values for the 'start_addr' and
	// 'end_addr' members are required. When the address type is "PREFIX", values
	// for 'ipv6_start_prefix', 'ipv6_end_prefix', and 'ipv6_prefix_bits' are
	// required. When the address type is "BOTH", values for 'start_addr',
	// 'end_addr', 'ipv6_start_prefix', 'ipv6_end_prefix', and 'ipv6_prefix_bits'
	// are all required.
	AddressType *string `json:"address_type,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the range; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a range is disabled or not. When this is set to False,
	// the range is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Discover now status for this range.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovery basic poll settings for this range.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this range.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The member that will run discovery for this range.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// Determines whether a discovery is enabled or not for this range. When this
	// is set to False, the discovery for this range is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if the discovery for the range should be immediately enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// The IPv6 Address end address of the DHCP IPv6 range.
	EndAddr *string `json:"end_addr,omitempty"`

	// The endpoints that provides data for the DHCP IPv6 Range object.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// These are ranges of IP addresses that the appliance does not use to assign
	// to clients. You can use these exclusion addresses as static IP addresses.
	// They contain the start and end addresses of the exclusion range, and
	// optionally,information about this exclusion range.
	Exclude []*Exclusionrange `json:"exclude,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv6 Address end prefix of the DHCP IPv6 range.
	Ipv6EndPrefix *string `json:"ipv6_end_prefix,omitempty"`

	// Prefix bits of the DHCP IPv6 range.
	Ipv6PrefixBits *uint32 `json:"ipv6_prefix_bits,omitempty"`

	// The IPv6 Address starting prefix of the DHCP IPv6 range.
	Ipv6StartPrefix *string `json:"ipv6_start_prefix,omitempty"`

	// This field contains the logic filters to be applied to this IPv6 range. This
	// list corresponds to the match rules that are written to the DHCPv6
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The member that will provide service for this range. {ipv6range:ipv6range}
	// needs to be set to 'MEMBER' if you want the server specified here to serve
	// the range. For searching by this field you should use a HTTP method that
	// contains a body (POST or PUT) with Dhcp Member structure dhcpmember and the
	// request should have option _method=GET.
	Member *Dhcpmember `json:"member,omitempty"`

	// This field contains the name of the Microsoft scope.
	Name *string `json:"name,omitempty"`

	// The network this range belongs to, in IPv6 Address/CIDR format.
	Network *string `json:"network,omitempty"`

	// The name of the network view in which this range resides.
	NetworkView *string `json:"network_view,omitempty"`

	// This field contains the Option filters to be applied to this IPv6 range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	OptionFilterRules []*Filterrule `json:"option_filter_rules,omitempty"`

	// The port control blackout setting for this range.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// The type of server that is going to serve the range. Valid values are: *
	// MEMBER * NONE
	ServerAssociationType *string `json:"server_association_type,omitempty"`

	// The IPv6 Address starting address of the DHCP IPv6 range.
	StartAddr *string `json:"start_addr,omitempty"`

	// The DHCP IPv6 Range Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// If set on creation, the range will be created according to the values
	// specified in the named template.
	Template string `json:"template,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`
}

func (IPv6Range) ObjectType() string {
	return "ipv6range"
}

func (obj IPv6Range) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "end_addr", "network", "network_view", "start_addr"}
	}
	return obj.returnFields
}

// Ipv6rangetemplate represents Infoblox object ipv6rangetemplate.
// The IPv6 range template used to create an IPv6 range object in a quick and
// consistent way. The DHCP IPv6 range created from the DHCP IPv6 range
// template will inherit the properties defined in this template.
type Ipv6rangetemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the IPv6 DHCP range template can be used to create
	// network objects in a cloud-computing deployment.
	CloudApiCompatible *bool `json:"cloud_api_compatible,omitempty"`

	// The IPv6 DHCP range template descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The vConnector member that the object should be delegated to when created
	// from the IPv6 DHCP range template. I assume that vConnector refers to VMware
	// vConnector.
	DelegatedMember *Dhcpmember `json:"delegated_member,omitempty"`

	// These are ranges of IPv6 addresses that the appliance does not use to assign
	// to clients. You can use these excluded addresses as static IPv6 addresses.
	// They contain the start and end addresses of the excluded range, and
	// optionally, information about this excluded range.
	Exclude []*Exclusionrangetemplate `json:"exclude,omitempty"`

	// This field contains the logic filters to be applied on this IPv6 range. This
	// list corresponds to the match rules that are written to the DHCPv6
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The member that will provide service for the IPv6 DHCP range. Set
	// {ipv6rangetemplate:ipv6rangetemplate} to 'MEMBER' if you want the server
	// specified here to serve the range. For searching by this field, use an HTTP
	// method that contains a body (POST or PUT) with MS DHCP server structure
	// msdhcpserver and the request should have option _method=GET.
	Member *Dhcpmember `json:"member,omitempty"`

	// Name of the IPv6 DHCP range template.
	Name *string `json:"name,omitempty"`

	// The number of addresses for the IPv6 DHCP range.
	NumberOfAddresses *uint32 `json:"number_of_addresses,omitempty"`

	// The start address offset for the IPv6 DHCP range.
	Offset *uint32 `json:"offset,omitempty"`

	// This field contains the Option filters to be applied to this IPv6 range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	OptionFilterRules []*Filterrule `json:"option_filter_rules,omitempty"`

	// Determines whether the leases are kept in Recycle Bin until one week after
	// expiry. If this is set to False, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// The type of server that is going to serve the IPv6 DHCP range.
	ServerAssociationType string `json:"server_association_type,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`
}

func (Ipv6rangetemplate) ObjectType() string {
	return "ipv6rangetemplate"
}

func (obj Ipv6rangetemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "number_of_addresses", "offset"}
	}
	return obj.returnFields
}

// IPv6SharedNetwork represents Infoblox object ipv6sharednetwork.
// A shared network is a network segment to which you assign two or more
// subnets. When subnets in a shared network contain IP addresses that are
// available for dynamic allocation, the addresses are put into a common pool
// for allocation when client requests arise. When you create a shared network,
// the DHCP server can assign IP addresses to client requests from any subnet
// (that resides on the same network interface) in the shared network.
type IPv6SharedNetwork struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the IPv6 shared network, maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP clients requests. Note that changes for this field
	// take effect only if ddns_use_option81 is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of an IPv6 shared network object.
	// The TTL is a 32-bit unsigned integer that represents the duration, in
	// seconds, for which the update is cached. Zero indicates that the update is
	// not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// The support for DHCP Option 81 at the IPv6 shared network level.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// Determines whether an IPv6 shared network is disabled or not. When this is
	// set to False, the IPv6 shared network is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Use this method to set or retrieve the domain_name value of a DHCP IPv6
	// Shared Network object.
	DomainName *string `json:"domain_name,omitempty"`

	// Use this method to set or retrieve the dynamic DNS updates flag of a DHCP
	// IPv6 Shared Network object. The DHCP server can send DDNS updates to DNS
	// servers in the same Grid and to external DNS servers. This setting overrides
	// the member level settings.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// The dynamic DNS updates flag of an IPv6 shared network object. If set to
	// True, the DHCP server sends DDNS updates to DNS servers in the same Grid,
	// and to external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// This field contains the logic filters to be applied on the this IPv6 shared
	// network. This list corresponds to the match rules that are written to the
	// DHCPv6 configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The name of the IPv6 Shared Network.
	Name *string `json:"name,omitempty"`

	// The name of the network view in which this IPv6 shared network resides.
	NetworkView string `json:"network_view,omitempty"`

	// A list of IPv6 networks belonging to the shared network Each individual list
	// item must be specified as an object containing a '_ref' parameter to a
	// network reference, for example:: [{ "_ref":
	// "ipv6network/ZG5zdHdvcmskMTAuAvMTYvMA", }] if the reference of the wanted
	// network is not known, it is possible to specify search parameters for the
	// network instead in the following way:: [{ "_ref": { 'network': 'aabb::/64',
	// } }] note that in this case the search must match exactly one network for
	// the assignment to be successful.
	Networks []*Ipv6Network `json:"networks,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// Use this method to set or retrieve the preferred lifetime value of a DHCP
	// IPv6 Shared Network object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// Use this method to set or retrieve the valid lifetime value of a DHCP IPv6
	// Shared Network object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (IPv6SharedNetwork) ObjectType() string {
	return "ipv6sharednetwork"
}

func (obj IPv6SharedNetwork) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "network_view", "networks"}
	}
	return obj.returnFields
}

// Kerberoskey represents Infoblox object kerberoskey.
// GSS-TSIG (Generic Security Service Algorithm for Secret Key Transaction) is
// used to authenticate DDNS updates. It is a modified form of TSIG
// authentication that uses Kerberos v5 authentication system.
type Kerberoskey struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Kerberos domain name.
	Domain string `json:"domain,omitempty"`

	// The Kerberos key encryption type.
	Enctype string `json:"enctype,omitempty"`

	// Determines whether the Kerberos key is assigned to the Grid or Grid member.
	InUse bool `json:"in_use,omitempty"`

	// The list of hostnames and services of Grid members where the key is assigned
	// or Grid/DHCP4 or Grid/DHCP6 or Grid/DNS.
	Members []string `json:"members,omitempty"`

	// The principal of the Kerberos key object.
	Principal string `json:"principal,omitempty"`

	// The timestamp of the Kerberos key upload operation.
	UploadTimestamp *UnixTime `json:"upload_timestamp,omitempty"`

	// The Kerberos key version number (KVNO).
	Version uint32 `json:"version,omitempty"`
}

func (Kerberoskey) ObjectType() string {
	return "kerberoskey"
}

func (obj Kerberoskey) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"domain", "enctype", "in_use", "principal", "version"}
	}
	return obj.returnFields
}

// LdapAuthService represents Infoblox object ldap_auth_service.
// LDAP (Lightweight Directory Access Protocol) is an internet protocol for
// accessing distributed directory services. The appliance can authenticate
// admin accounts by verifying user names and passwords against LDAP. This
// object is used to configure the LDAP authentication service.
type LdapAuthService struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The LDAP descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Determines if the LDAP authentication service is disabled.
	Disable *bool `json:"disable,omitempty"`

	// The mapping LDAP fields to extensible attributes.
	EaMapping []*LdapEamapping `json:"ea_mapping,omitempty"`

	// The name of the LDAP attribute that defines group membership.
	LdapGroupAttribute *string `json:"ldap_group_attribute,omitempty"`

	// The LDAP group authentication type.
	LdapGroupAuthenticationType string `json:"ldap_group_authentication_type,omitempty"`

	// The LDAP userid attribute that is used for search.
	LdapUserAttribute *string `json:"ldap_user_attribute,omitempty"`

	// The LDAP authentication mode.
	Mode string `json:"mode,omitempty"`

	// The LDAP authentication service name.
	Name *string `json:"name,omitempty"`

	// The period of time in seconds to wait before trying to contact a LDAP server
	// that has been marked as 'DOWN'.
	RecoveryInterval *uint32 `json:"recovery_interval,omitempty"`

	// The maximum number of LDAP authentication attempts.
	Retries *uint32 `json:"retries,omitempty"`

	// The starting point of the LDAP search.
	SearchScope string `json:"search_scope,omitempty"`

	// The list of LDAP servers used for authentication.
	Servers []*LdapServer `json:"servers,omitempty"`

	// The LDAP authentication timeout in seconds.
	Timeout *uint32 `json:"timeout,omitempty"`
}

func (LdapAuthService) ObjectType() string {
	return "ldap_auth_service"
}

func (obj LdapAuthService) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disable", "ldap_user_attribute", "mode", "name"}
	}
	return obj.returnFields
}

// Lease represents Infoblox object lease.
// A DHCP lease is an IP address that the Infoblox appliance assigns to a DHCP
// client for a certain amount of time. When the appliance assigns a lease, it
// also assignes other information, such as the time when the appliance issued
// or freed an IP address, the MAC address and host name of the client that
// received the IP address, and the Grid member that supplied the lease. The
// DHCP Lease object allows the appliance to store and correlate DHCP lease
// information over the lifetime of a lease.
type Lease struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IPv4 Address or IPv6 Address of the lease.
	Address string `json:"address,omitempty"`

	// The billing_class value of a DHCP Lease object. This field specifies the
	// class to which this lease is currently billed. This field is for IPv4 leases
	// only.
	BillingClass string `json:"billing_class,omitempty"`

	// The binding state for the current lease. Following are some of the values
	// this field can be set to: * ABANDONED: The Infoblox appliance cannot lease
	// this IP address because the appliance received a response when it pinged the
	// address. * ACTIVE: The lease is currently in use by a DHCP client. *
	// EXPIRED: The lease was in use, but the DHCP client never renewed it, so it
	// is no longer valid. * FREE: The lease is available for clients to use. *
	// RELEASED: The DHCP client returned the lease to the appliance.
	BindingState string `json:"binding_state,omitempty"`

	// The client_hostname of a DHCP Lease object. This field specifies the host
	// name that the DHCP client sends to the Infoblox appliance using DHCP option
	// 12.
	ClientHostname string `json:"client_hostname,omitempty"`

	// The CLTT (Client Last Transaction Time) value of a DHCP Lease object. This
	// field specifies the time of the last transaction with the DHCP client for
	// this lease.
	Cltt *UnixTime `json:"cltt,omitempty"`

	// The discovered data for this lease.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The end time value of a DHCP Lease object. This field specifies the time
	// when a lease ended.
	Ends *UnixTime `json:"ends,omitempty"`

	// DHCP fingerprint for the lease.
	Fingerprint string `json:"fingerprint,omitempty"`

	// The hardware type of a DHCP Lease object. This field specifies the MAC
	// address of the network interface on which the lease will be used. This field
	// is for IPv4 leases only.
	Hardware string `json:"hardware,omitempty"`

	// The DUID value for this lease. This field is only applicable for IPv6
	// leases.
	Ipv6Duid string `json:"ipv6_duid,omitempty"`

	// The interface ID of an IPv6 address that the Infoblox appliance leased to
	// the DHCP client. This field is for IPv6 leases only.
	Ipv6Iaid string `json:"ipv6_iaid,omitempty"`

	// The preferred lifetime value of an IPv6 address that the Infoblox appliance
	// leased to the DHCP client. This field is for IPv6 leases only.
	Ipv6PreferredLifetime uint32 `json:"ipv6_preferred_lifetime,omitempty"`

	// Prefix bits for this lease. This field is for IPv6 leases only.
	Ipv6PrefixBits uint32 `json:"ipv6_prefix_bits,omitempty"`

	// This flag reflects whether the MAC address for this lease is invalid.
	IsInvalidMac bool `json:"is_invalid_mac,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network, in "network/netmask" format, with which this lease is
	// associated.
	Network string `json:"network,omitempty"`

	// The name of the network view in which this lease resides.
	NetworkView string `json:"network_view,omitempty"`

	// If this field is set to True, the lease does not have an end time.
	NeverEnds bool `json:"never_ends,omitempty"`

	// If this field is set to True, the lease does not have a start time.
	NeverStarts bool `json:"never_starts,omitempty"`

	// The subsequent binding state when the current lease expires. This field is
	// for IPv4 leases only. Following are some of the values this field can be set
	// to: * ABANDONED: The Infoblox appliance cannot lease this IP address because
	// the appliance received a response when it pinged the address. * ACTIVE: The
	// lease is currently in use by a DHCP client. * EXPIRED: The lease was in use,
	// but the DHCP client never renewed it, so it is no longer valid. * FREE: The
	// lease is available for clients to use. * RELEASED: The DHCP client returned
	// the lease to the appliance.
	NextBindingState string `json:"next_binding_state,omitempty"`

	// The list of commands to be executed when the lease is granted.
	OnCommit string `json:"on_commit,omitempty"`

	// The list of commands to be executed when the lease expires.
	OnExpiry string `json:"on_expiry,omitempty"`

	// The list of commands to be executed when the lease is released.
	OnRelease string `json:"on_release,omitempty"`

	// The option value of a DHCP Lease object. This field specifies the agent
	// circuit ID and remote ID sent by a DHCP relay agent in DHCP option 82. This
	// field is for IPv4 leases only.
	Option string `json:"option,omitempty"`

	// This field determines whether the lease is an IPv4 or IPv6 address.
	Protocol string `json:"protocol,omitempty"`

	// This field represents the "Remote ID" sub-option of DHCP option 82. Remote
	// ID can be in ASCII form (e.g. ``"abcd"``) or in colon-separated HEX form
	// (e.g. ``1:2:ab:cd``). HEX representation is used only when the sub-option
	// value contains unprintable characters. If a remote ID sub-option value is in
	// ASCII form, it is always enclosed in quotes to prevent ambiguous values
	// (e.g. ``"10:20"`` - ASCII 5-byte string; ``10:20`` - HEX 2-byte value). *
	// ASCII representation is used if the remote ID sub-option contains only
	// printable ASCII characters (ASCII characters in range ``x20-0x7E``). * The
	// backslash symbol (``\``) is used as an escape symbol to escape the quote
	// symbol (``"``) in an ASCII string. * Double backslashes (``\\``) are used to
	// represent the backslash symbol (``\``) in an ASCII string. * HEX
	// representation is used only when the remote ID sub-option value contains
	// unprintable characters and is normalized as follows: * starting zero is
	// removed from digits: ``1``, ``a`` - Valid; ``01``, ``0a`` - Invalid; *
	// lowercase characters are used for symbols: ``fa`` - Valid; ``FA`` - Invalid.
	// NIOS does not support the convertion between HEX and ASCII formats. Searches
	// are performed using the exact same format and value as the sub-option is
	// represented. Query examples assume the following leases are stored in the
	// database: .. tabularcolumns:: |p{1in}|p{3in}|p{2in}| =========
	// ========================== ============================ Number Option field
	// Extracted remote ID field ========= ==========================
	// ============================ Lease01 agent.remote-id= "00152654358700"
	// "00152654358700" agent.circuit-id= "BX1-PORT-003" Lease02
	// agent.remote-id="Dhcp "Dhcp Relay 10" Relay 10" agent.circuit-id="Port008"
	// Lease03 agent.remote-id="00:01:02" "00:01:02" Lease04 agent.remote-id=0:1:2
	// 0:1:2 Lease05 agent.remote-id=02:03 2:3 Lease06 agent.remote-id=10:20 10:20
	// Lease07 agent.circuit-id= "no-remote-id" =========
	// ========================== ============================ Expected results: ..
	// tabularcolumns:: |p{1.5in}|p{1.5in}|p{3in}| =========================
	// ==================== ============================= Query Returned leases
	// Comments ========================= ====================
	// ============================= remote_id=01:02 None EXACT query. No results
	// are expected. remote_id="Dhcp Relay 10" Lease02 EXACT query for an ASCII
	// value. remote_id=0:1:2 Lease04 EXACT query for a HEX value.
	// remote_id=00:01:02 None EXACT query for a HEX value. No results are expected
	// as the search value is not normalized to the same format used in the
	// database. remote_id~=10 Lease02, Lease06 REGEX query. remote_id~=^".*1
	// Lease01, Lease02, REGEX query. Only ASCII Lease03 values are expected due to
	// the starting quote (``"``) in the search value. remote_id~=^[^"]*2 Lease04,
	// Lease05, REGEX query. Only HEX values Lease06 are expected as the starting
	// quote (``"``) is excluded from the search value. remote_id="" None EXACT
	// query. No results are expected as no leases that contain an empty remote ID
	// value exist in the database. ID value in the database. remote_id~=""
	// Lease01, Lease02, REGEX query. This query is Lease03, Lease04, expected to
	// match any Lease05, Lease06 lease that contain remote ID set to any value.
	// ========================= ==================== =============================
	// **NOTE:** Lease07 is not expected to be returned when searching for the
	// remote ID sub-option.
	RemoteId string `json:"remote_id,omitempty"`

	// The IP address of the server that sends an active lease to a client.
	ServedBy string `json:"served_by,omitempty"`

	// The host name of the Grid member or Microsoft DHCP server that issues the
	// lease.
	ServerHostName string `json:"server_host_name,omitempty"`

	// The start time of a DHCP Lease object. This field specifies the time when
	// the lease starts.
	Starts *UnixTime `json:"starts,omitempty"`

	// The TSFP (Time Sent From Partner) value of a DHCP Lease object. This field
	// specifies the time that the current lease state ends, from the point of view
	// of a remote DHCP failover peer. This field is for IPv4 leases only.
	Tsfp *UnixTime `json:"tsfp,omitempty"`

	// The TSTP (Time Sent To Partner) value of a DHCP Lease object. This field
	// specifies the time that the current lease state ends, from the point of view
	// of a local DHCP failover peer. This field is for IPv4 leases only.
	Tstp *UnixTime `json:"tstp,omitempty"`

	// The UID (User ID) value of a DHCP Lease object. This field specifies the
	// client identifier that the DHCP client sends the Infoblox appliance (in DHCP
	// option 61) when it acquires the lease. Not all DHCP clients send a UID. This
	// field is for IPv4 leases only.
	Uid string `json:"uid,omitempty"`

	// The user name that the server has associated with a DHCP Lease object.
	Username string `json:"username,omitempty"`

	// The variable value of a DHCP Lease object. This field keeps all variables
	// related to the DDNS update of the DHCP lease. The variables related to the
	// DDNS updates of the DHCP lease. The variables can be one of the following:
	// ddns-text: The ddns-text variable is used to record the value of the
	// client's TXT identification record when the interim DDNS update style has
	// been used to update the DNS service for a particular lease. ddns-fwd-name:
	// When a DDNS update was successfully completed, the ddns-fwd-name variable
	// records the value of the name used when the client's A record was updated.
	// The server may have used this name when it updated the client's PTR record.
	// ddns-client-fqdn: If the server is configured to use the interim DDNS update
	// style and is also configured to allow clients to update their own FQDNs, the
	// ddns-client-fqdn variable records the name that the client used when it
	// updated its own FQDN. This is also the name that the server used to update
	// the client's PTR record. ddns-rev-name: If the server successfully updates
	// the client's PTR record, this variable will record the name that the DHCP
	// server used for the PTR record. The name to which the PTR record points will
	// be either the ddns-fwd-name or the ddns-client-fqdn.
	Variable string `json:"variable,omitempty"`
}

func (Lease) ObjectType() string {
	return "lease"
}

func (obj Lease) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "network_view"}
	}
	return obj.returnFields
}

// LicenseGridwide represents Infoblox object license:gridwide.
// This object represents the Grid-wide license.
type LicenseGridwide struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The license expiration status.
	ExpirationStatus string `json:"expiration_status,omitempty"`

	// The expiration timestamp of the license.
	ExpiryDate *UnixTime `json:"expiry_date,omitempty"`

	// The license string.
	Key string `json:"key,omitempty"`

	// The license limit value.
	Limit string `json:"limit,omitempty"`

	// The license limit context.
	LimitContext string `json:"limit_context,omitempty"`

	// The license type.
	Type string `json:"type,omitempty"`
}

func (LicenseGridwide) ObjectType() string {
	return "license:gridwide"
}

func (obj LicenseGridwide) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"type"}
	}
	return obj.returnFields
}

// LocaluserAuthservice represents Infoblox object localuser:authservice.
// The object represents a local authentication service for authenticating
// users against the local database.
type LocaluserAuthservice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The local user authentication service comment.
	Comment string `json:"comment,omitempty"`

	// Flag that indicates whether the local user authentication service is enabled
	// or not.
	Disabled bool `json:"disabled,omitempty"`

	// The name of the local user authentication service.
	Name string `json:"name,omitempty"`
}

func (LocaluserAuthservice) ObjectType() string {
	return "localuser:authservice"
}

func (obj LocaluserAuthservice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disabled", "name"}
	}
	return obj.returnFields
}

// MACFilterAddress represents Infoblox object macfilteraddress.
// MAC filter address is part of the MAC filter.
type MACFilterAddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The absolute UNIX time (in seconds) since the address was last
	// authenticated.
	AuthenticationTime *UnixTime `json:"authentication_time,omitempty"`

	// Comment for the MAC filter address; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The absolute UNIX time (in seconds) until the address expires.
	ExpirationTime *UnixTime `json:"expiration_time,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name of the MAC filter to which this address belongs.
	Filter *string `json:"filter,omitempty"`

	// DHCP fingerprint for the address.
	Fingerprint string `json:"fingerprint,omitempty"`

	// Guest custom field 1.
	GuestCustomField1 *string `json:"guest_custom_field1,omitempty"`

	// Guest custom field 2.
	GuestCustomField2 *string `json:"guest_custom_field2,omitempty"`

	// Guest custom field 3.
	GuestCustomField3 *string `json:"guest_custom_field3,omitempty"`

	// Guest custom field 4.
	GuestCustomField4 *string `json:"guest_custom_field4,omitempty"`

	// Guest e-mail.
	GuestEmail *string `json:"guest_email,omitempty"`

	// Guest first name.
	GuestFirstName *string `json:"guest_first_name,omitempty"`

	// Guest last name.
	GuestLastName *string `json:"guest_last_name,omitempty"`

	// Guest middle name.
	GuestMiddleName *string `json:"guest_middle_name,omitempty"`

	// Guest phone number.
	GuestPhone *string `json:"guest_phone,omitempty"`

	// Determines if the user has been authenticated or not.
	IsRegisteredUser bool `json:"is_registered_user,omitempty"`

	// MAC Address.
	Mac *string `json:"mac,omitempty"`

	// Determines if MAC address expiration is enabled or disabled.
	NeverExpires *bool `json:"never_expires,omitempty"`

	// Reserved for future use.
	ReservedForInfoblox *string `json:"reserved_for_infoblox,omitempty"`

	// Username for authenticated DHCP purposes.
	Username *string `json:"username,omitempty"`
}

func (MACFilterAddress) ObjectType() string {
	return "macfilteraddress"
}

func (obj MACFilterAddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"authentication_time", "comment", "expiration_time", "filter", "guest_custom_field1", "guest_custom_field2", "guest_custom_field3", "guest_custom_field4", "guest_email", "guest_first_name", "guest_last_name", "guest_middle_name", "guest_phone", "is_registered_user", "mac", "never_expires", "reserved_for_infoblox", "username"}
	}
	return obj.returnFields
}

// Mastergrid represents Infoblox object mastergrid.
// This object represents the Master Grid. The Master Grid object is
// automatically generated when a Grid successfully joins the Master Grid.
type Mastergrid struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The domain name or IP address for the Master Grid.
	Address *string `json:"address,omitempty"`

	// Determines if the sub-grid is currently disabled.
	ConnectionDisabled bool `json:"connection_disabled,omitempty"`

	// The timestamp that indicates when the connection to the Master Grid was
	// established.
	ConnectionTimestamp *UnixTime `json:"connection_timestamp,omitempty"`

	// The detached flag for the Master Grid.
	Detached bool `json:"detached,omitempty"`

	// Determines if the Master Grid is enabled.
	Enable *bool `json:"enable,omitempty"`

	// The flag shows if the Grid has joined the Master Grid.
	Joined bool `json:"joined,omitempty"`

	// The Master Grid's last event.
	LastEvent string `json:"last_event,omitempty"`

	// The details of the Master Grid's last event.
	LastEventDetails string `json:"last_event_details,omitempty"`

	// The timestamp or the last synchronization operation with the Master Grid.
	LastSyncTimestamp *UnixTime `json:"last_sync_timestamp,omitempty"`

	// The Master Grid port to which the Grid connects.
	Port *uint32 `json:"port,omitempty"`

	// The Master Grid's status.
	Status string `json:"status,omitempty"`

	// The flag shows if the MGMT port was used to join the Grid.
	UseMgmtPort bool `json:"use_mgmt_port,omitempty"`
}

func (Mastergrid) ObjectType() string {
	return "mastergrid"
}

func (obj Mastergrid) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "enable", "port"}
	}
	return obj.returnFields
}

// Member represents Infoblox object member.
// This object represents the Infoblox Grid Member.
type Member struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The active server of a Grid member.
	ActivePosition string `json:"active_position,omitempty"`

	// The additional IP list of a Grid member. This list contains additional
	// interface information that can be used at the member level. Note that
	// interface structure(s) with interface type set to 'MGMT' are not supported.
	AdditionalIpList []*Interface `json:"additional_ip_list,omitempty"`

	// Member level settings for automated traffic capture.
	AutomatedTrafficCaptureSetting *SettingAutomatedtrafficcapture `json:"automated_traffic_capture_setting,omitempty"`

	// The BGP configuration for anycast for a Grid member.
	BgpAs []*Bgpas `json:"bgp_as,omitempty"`

	// A descriptive comment of the Grid member.
	Comment *string `json:"comment,omitempty"`

	// Address configuration type.
	ConfigAddrType string `json:"config_addr_type,omitempty"`

	// CSP portal on-prem host access key
	CspAccessKey []string `json:"csp_access_key,omitempty"`

	// csp setting at member level
	CspMemberSetting *MemberCspmembersetting `json:"csp_member_setting,omitempty"`

	// DNS resolver setting for member.
	DnsResolverSetting *SettingDnsresolver `json:"dns_resolver_setting,omitempty"`

	// The DSCP (Differentiated Services Code Point) value.
	Dscp *uint32 `json:"dscp,omitempty"`

	// The email setting for member.
	EmailSetting *SettingEmail `json:"email_setting,omitempty"`

	// If set to True, the member has two physical nodes (HA pair).
	EnableHa *bool `json:"enable_ha,omitempty"`

	// Determines if the LOM functionality is enabled or not.
	EnableLom *bool `json:"enable_lom,omitempty"`

	// Determines if the member will redirect GUI connections to the Grid Master or
	// not.
	EnableMemberRedirect *bool `json:"enable_member_redirect,omitempty"`

	// If set to True and the member object is a Grid Master Candidate, then
	// read-only API access is enabled.
	EnableRoApiAccess *bool `json:"enable_ro_api_access,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of external syslog backup servers.
	ExternalSyslogBackupServers []*Extsyslogbackupserver `json:"external_syslog_backup_servers,omitempty"`

	// Determines if external syslog servers should be enabled.
	ExternalSyslogServerEnable *bool `json:"external_syslog_server_enable,omitempty"`

	// The host name of the Grid member.
	HostName *string `json:"host_name,omitempty"`

	// IPV6 setting for member.
	Ipv6Setting *Ipv6setting `json:"ipv6_setting,omitempty"`

	// List of IPv6 static routes.
	Ipv6StaticRoutes []*Ipv6networksetting `json:"ipv6_static_routes,omitempty"`

	// Determines if a Grid member supports DSCP (Differentiated Services Code
	// Point).
	IsDscpCapable bool `json:"is_dscp_capable,omitempty"`

	// If this is set to "true", the LAN2 port is enabled as an independent port or
	// as a port for failover purposes.
	Lan2Enabled *bool `json:"lan2_enabled,omitempty"`

	// Settings for the Grid member LAN2 port if 'lan2_enabled' is set to "true".
	Lan2PortSetting *Lan2portsetting `json:"lan2_port_setting,omitempty"`

	// Determines if the Liquid Crystal Display (LCD) input buttons on the front
	// panel of the appliance are enabled or not.
	LcdInput *bool `json:"lcd_input,omitempty"`

	// The Network configurations for LOM.
	LomNetworkConfig []*Lomnetworkconfig `json:"lom_network_config,omitempty"`

	// The list of LOM users.
	LomUsers []*Lomuser `json:"lom_users,omitempty"`

	// Determines if a Grid member is a Grid Master Candidate or not. This flag
	// enables the Grid member to assume the role of the Grid Master as a disaster
	// recovery measure.
	MasterCandidate *bool `json:"master_candidate,omitempty"`

	// Configure communication type for various services.
	MemberServiceCommunication []*Memberservicecommunication `json:"member_service_communication,omitempty"`

	// Settings for the member MGMT port.
	MgmtPortSetting *Mgmtportsetting `json:"mgmt_port_setting,omitempty"`

	// Extensible attributes Topology database build time.
	MmdbEaBuildTime *UnixTime `json:"mmdb_ea_build_time,omitempty"`

	// GeoIP Topology database build time.
	MmdbGeoipBuildTime *UnixTime `json:"mmdb_geoip_build_time,omitempty"`

	// NAT settings for the member.
	NatSetting *Natsetting `json:"nat_setting,omitempty"`

	// The node information list with detailed status report on the operations of
	// the Grid Member.
	NodeInfo []*Nodeinfo `json:"node_info,omitempty"`

	// The member Network Time Protocol (NTP) settings.
	NTPSetting *MemberNtp `json:"ntp_setting,omitempty"`

	// The OSPF area configuration (for anycast) list for a Grid member.
	OspfList []*Ospf `json:"ospf_list,omitempty"`

	// The ARP protocol setting on the passive node of an HA pair. If you do not
	// specify a value, the default value is "false". You can only set this value
	// to "true" if the member is an HA pair.
	PassiveHaArpEnabled *bool `json:"passive_ha_arp_enabled,omitempty"`

	// Hardware Platform.
	Platform string `json:"platform,omitempty"`

	// Pre-provisioning information.
	PreProvisioning *Preprovision `json:"pre_provisioning,omitempty"`

	// Set this flag to "true" to prevent the deletion of the member if any
	// delegated object remains attached to it.
	PreserveIfOwnsDelegation *bool `json:"preserve_if_owns_delegation,omitempty"`

	// If set to True, superuser admins can access the Infoblox CLI from a remote
	// location using an SSH (Secure Shell) v2 client.
	RemoteConsoleAccessEnable *bool `json:"remote_console_access_enable,omitempty"`

	// Virutal router identifier. Provide this ID if "ha_enabled" is set to "true".
	// This is a unique VRID number (from 1 to 255) for the local subnet.
	RouterId *uint32 `json:"router_id,omitempty"`

	// The service status list of a grid member.
	ServiceStatus []*Memberservicestatus `json:"service_status,omitempty"`

	// Configure all services to the given type.
	ServiceTypeConfiguration string `json:"service_type_configuration,omitempty"`

	// The Grid Member SNMP settings.
	SnmpSetting *SettingSnmp `json:"snmp_setting,omitempty"`

	// List of static routes.
	StaticRoutes []*SettingNetwork `json:"static_routes,omitempty"`

	// Determines if support access for the Grid member should be enabled.
	SupportAccessEnable *bool `json:"support_access_enable,omitempty"`

	// The information string for support access.
	SupportAccessInfo string `json:"support_access_info,omitempty"`

	// The Grid Member syslog proxy settings.
	SyslogProxySetting *SettingSyslogproxy `json:"syslog_proxy_setting,omitempty"`

	// The list of external syslog servers.
	SyslogServers []*Syslogserver `json:"syslog_servers,omitempty"`

	// The maximum size for the syslog file expressed in megabytes.
	SyslogSize *uint32 `json:"syslog_size,omitempty"`

	// Determines the list of threshold traps. The user can only change the values
	// for each trap or remove traps.
	ThresholdTraps []*Thresholdtrap `json:"threshold_traps,omitempty"`

	// The time zone of the Grid member. The UTC string that represents the time
	// zone, such as "(UTC - 5:00) Eastern Time (US and Canada)".
	TimeZone *string `json:"time_zone,omitempty"`

	// Grid level settings for enabling authoritative DNS latency thresholds for
	// automated traffic capture.
	TrafficCaptureAuthDnsSetting *SettingTriggeruthdnslatency `json:"traffic_capture_auth_dns_setting,omitempty"`

	// Member level settings for enabling DNS cache hit ratio threshold for
	// automated traffic capture.
	TrafficCaptureChrSetting *SettingTrafficcapturechr `json:"traffic_capture_chr_setting,omitempty"`

	// Member level settings for enabling DNS query per second threshold for
	// automated traffic capture.
	TrafficCaptureQpsSetting *SettingTrafficcaptureqps `json:"traffic_capture_qps_setting,omitempty"`

	// Grid level settings for enabling recursive DNS latency thresholds for
	// automated traffic capture.
	TrafficCaptureRecDnsSetting *SettingTriggerrecdnslatency `json:"traffic_capture_rec_dns_setting,omitempty"`

	// Grid level settings for enabling count for concurrent outgoing recursive
	// queries for automated traffic capture.
	TrafficCaptureRecQueriesSetting *SettingTriggerrecqueries `json:"traffic_capture_rec_queries_setting,omitempty"`

	// Determines configuration of the trap notifications.
	TrapNotifications []*Trapnotification `json:"trap_notifications,omitempty"`

	// The name of the upgrade group to which this Grid member belongs.
	UpgradeGroup *string `json:"upgrade_group,omitempty"`

	// This flag is the use flag for enabling automated traffic capture based on
	// DNS cache ratio thresholds.
	UseAutomatedTrafficCapture *bool `json:"use_automated_traffic_capture,omitempty"`

	// Use flag for: dns_resolver_setting
	UseDnsResolverSetting *bool `json:"use_dns_resolver_setting,omitempty"`

	// Use flag for: dscp
	UseDscp *bool `json:"use_dscp,omitempty"`

	// Use flag for: email_setting
	UseEmailSetting *bool `json:"use_email_setting,omitempty"`

	// Use flag for: enable_lom
	UseEnableLom *bool `json:"use_enable_lom,omitempty"`

	// Use flag for: enable_member_redirect
	UseEnableMemberRedirect *bool `json:"use_enable_member_redirect,omitempty"`

	// Use flag for: external_syslog_backup_servers
	UseExternalSyslogBackupServers *bool `json:"use_external_syslog_backup_servers,omitempty"`

	// Use flag for: lcd_input
	UseLcdInput *bool `json:"use_lcd_input,omitempty"`

	// Use flag for: remote_console_access_enable
	UseRemoteConsoleAccessEnable *bool `json:"use_remote_console_access_enable,omitempty"`

	// Use flag for: snmp_setting
	UseSnmpSetting *bool `json:"use_snmp_setting,omitempty"`

	// Use flag for: support_access_enable
	UseSupportAccessEnable *bool `json:"use_support_access_enable,omitempty"`

	// Use flag for: external_syslog_server_enable , syslog_servers,
	// syslog_proxy_setting, syslog_size
	UseSyslogProxySetting *bool `json:"use_syslog_proxy_setting,omitempty"`

	// Use flag for: threshold_traps
	UseThresholdTraps *bool `json:"use_threshold_traps,omitempty"`

	// Use flag for: time_zone
	UseTimeZone *bool `json:"use_time_zone,omitempty"`

	// This flag is the use flag for enabling automated traffic capture based on
	// authorative DNS latency.
	UseTrafficCaptureAuthDns *bool `json:"use_traffic_capture_auth_dns,omitempty"`

	// This flag is the use flag for automated traffic capture settings at member
	// level.
	UseTrafficCaptureChr *bool `json:"use_traffic_capture_chr,omitempty"`

	// This flag is the use flag for enabling automated traffic capture based on
	// DNS querie per second thresholds.
	UseTrafficCaptureQps *bool `json:"use_traffic_capture_qps,omitempty"`

	// This flag is the use flag for enabling automated traffic capture based on
	// recursive DNS latency.
	UseTrafficCaptureRecDns *bool `json:"use_traffic_capture_rec_dns,omitempty"`

	// This flag is the use flag for enabling automated traffic capture based on
	// outgoing recursive queries.
	UseTrafficCaptureRecQueries *bool `json:"use_traffic_capture_rec_queries,omitempty"`

	// Use flag for: trap_notifications
	UseTrapNotifications *bool `json:"use_trap_notifications,omitempty"`

	// Specify "true" to use VRRPv4 or "false" to use VRRPv6.
	UseV4Vrrp *bool `json:"use_v4_vrrp,omitempty"`

	// The network settings for the Grid member.
	VipSetting *SettingNetwork `json:"vip_setting,omitempty"`

	// The VPN maximum transmission unit (MTU).
	VpnMtu *uint32 `json:"vpn_mtu,omitempty"`
}

func (Member) ObjectType() string {
	return "member"
}

func (obj Member) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"config_addr_type", "host_name", "platform", "service_type_configuration"}
	}
	return obj.returnFields
}

func NewMember(member Member) *Member {
	res := member
	returnFields := []string{"host_name", "node_info", "time_zone"}
	res.returnFields = returnFields
	return &res
}

// MemberDHCPProperties represents Infoblox object member:dhcpproperties.
// This object represents a subset of the Infoblox Member DHCP properties.
type MemberDHCPProperties struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Authentication Server Group object associated with this member.
	AuthServerGroup *string `json:"auth_server_group,omitempty"`

	// The captive portal responsible for authenticating this DHCP member.
	AuthnCaptivePortal *string `json:"authn_captive_portal,omitempty"`

	// The MAC filter representing the authenticated range.
	AuthnCaptivePortalAuthenticatedFilter *string `json:"authn_captive_portal_authenticated_filter,omitempty"`

	// The flag that controls if this DHCP member is enabled for captive portal
	// authentication.
	AuthnCaptivePortalEnabled *bool `json:"authn_captive_portal_enabled,omitempty"`

	// The MAC filter representing the guest range.
	AuthnCaptivePortalGuestFilter *string `json:"authn_captive_portal_guest_filter,omitempty"`

	// The flag that controls if this DHCP member can send authentication requests
	// to an authentication server group.
	AuthnServerGroupEnabled *bool `json:"authn_server_group_enabled,omitempty"`

	// The authority flag of a Grid member. This flag specifies if a DHCP server is
	// authoritative for a domain.
	Authority *bool `json:"authority,omitempty"`

	// The name of a file that DHCP clients need to boot. This setting overrides
	// the Grid level setting.
	Bootfile *string `json:"bootfile,omitempty"`

	// The name of the server on which a boot file is stored. This setting
	// overrides the Grid level setting.
	Bootserver *string `json:"bootserver,omitempty"`

	// The member DDNS domain name value.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// Determines the ability of a member DHCP server to generate a host name and
	// update DNS with this host name when it receives a DHCP REQUEST message that
	// does not include a host name.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// Determines the retry interval when the member DHCP server makes repeated
	// attempts to send DDNS updates to a DNS server.
	DdnsRetryInterval *uint32 `json:"ddns_retry_interval,omitempty"`

	// Determines that only the DHCP server is allowed to update DNS, regardless of
	// the requests from the DHCP clients. This setting overrides the Grid level
	// setting.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DDNS TTL (Dynamic DNS Time To Live) value specifies the number of
	// seconds an IP address for the name is cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// Determines if the member DHCP server's ability to update the A and PTR
	// records with a fixed address is enabled or not.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// Determines if support for option 81 is enabled or not.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// An ordered list of zone primaries that will receive DDNS updates.
	DdnsZonePrimaries []*Dhcpddns `json:"ddns_zone_primaries,omitempty"`

	// Determines if a BOOTP server denies BOOTP request or not. This setting
	// overrides the Grid level setting.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The percentage of the total DHCP utilization of DHCP objects belonging to
	// the Grid Member multiplied by 1000. This is the percentage of the total
	// number of available IP addresses from all the DHCP objects belonging to the
	// Grid Member versus the total number of all IP addresses in all of the DHCP
	// objects on the Grid Member.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of DHCP objects that belong to the
	// Grid Member.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// The update style for dynamic DNS updates.
	DnsUpdateStyle string `json:"dns_update_style,omitempty"`

	// The total number of DHCP leases issued for the DHCP objects on the Grid
	// Member.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// The email_list value of a member DHCP server.
	EmailList []string `json:"email_list,omitempty"`

	// Determines if the member DHCP server's ability to send DDNS updates is
	// enabled or not.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if the DHCP service of a member is enabled or not.
	EnableDhcp *bool `json:"enable_dhcp,omitempty"`

	// Determines if the DHCP service on the IPv6 LAN2 interface is enabled or not.
	EnableDhcpOnIpv6Lan2 *bool `json:"enable_dhcp_on_ipv6_lan2,omitempty"`

	// Determines if the DHCP service on the LAN2 interface is enabled or not.
	EnableDhcpOnLan2 *bool `json:"enable_dhcp_on_lan2,omitempty"`

	// Represents the watermarks above or below which address usage in a network is
	// unexpected and might warrant your attention. This setting overrides the Grid
	// level setting.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines if DHCPv6 service for the member is enabled or not.
	EnableDhcpv6Service *bool `json:"enable_dhcpv6_service,omitempty"`

	// Determines if e-mail warnings are enabled or disabled. When DHCP threshold
	// is enabled and DHCP address usage crosses a watermark threshold, the
	// appliance sends an e-mail notification to an administrator.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Determines if fingerprint feature is enabled on this member. If you enable
	// this feature, the server will match a fingerprint for incoming lease
	// requests.
	EnableFingerprint *bool `json:"enable_fingerprint,omitempty"`

	// Determines whether the appliance is enabled to receive GSS-TSIG
	// authenticated updates from DHCP clients.
	EnableGssTsig *bool `json:"enable_gss_tsig,omitempty"`

	// Determines if the Grid member's host name rewrite feature is enabled or not.
	EnableHostnameRewrite *bool `json:"enable_hostname_rewrite,omitempty"`

	// Determines if lease query is allowed or not. This setting overrides the
	// Grid-level setting.
	EnableLeasequery *bool `json:"enable_leasequery,omitempty"`

	// Determines if SNMP warnings are enabled or disabled on this DHCP member.
	// When DHCP threshold is enabled and DHCP address usage crosses a watermark
	// threshold, the appliance sends an SNMP trap to the trap receiver that was
	// defined for the Grid member level.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of GSS-TSIG keys for a member DHCP object.
	GssTsigKeys []*Kerberoskey `json:"gss_tsig_keys,omitempty"`

	// Determines the high watermark value of a member DHCP server. If the
	// percentage of allocated addresses exceeds this watermark, the appliance
	// makes a syslog entry and sends an e-mail notification (if enabled).
	// Specifies the percentage of allocated addresses. The range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// Determines the high watermark reset value of a member DHCP server. If the
	// percentage of allocated addresses drops below this value, a corresponding
	// SNMP trap is reset. Specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// Host name of the Grid member.
	HostName string `json:"host_name,omitempty"`

	// The hostname rewrite policy that is in the protocol hostname rewrite
	// policies array of the Grid DHCP object. This attribute is mandatory if
	// enable_hostname_rewrite is "true".
	HostnameRewritePolicy *string `json:"hostname_rewrite_policy,omitempty"`

	// Determines if the ignore DHCP option list request flag of a Grid member DHCP
	// is enabled or not. If this flag is set to true all available DHCP options
	// will be returned to the client.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses. Valid values are "NONE", "CLIENT", or "MACADDR". The default is
	// "NONE".
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// Determines if the Immediate Fixed address configuration apply feature for
	// the DHCP member is enabled or not.
	ImmediateFaConfiguration *bool `json:"immediate_fa_configuration,omitempty"`

	// The IPv4 Address of the Grid member.
	Ipv4Addr string `json:"ipv4addr,omitempty"`

	// The member DDNS IPv6 domain name value.
	Ipv6DdnsDomainname *string `json:"ipv6_ddns_domainname,omitempty"`

	// Controls whether the FQDN option sent by the DHCPv6 client is to be used, or
	// if the server can automatically generate the FQDN.
	Ipv6DdnsEnableOptionFqdn *bool `json:"ipv6_ddns_enable_option_fqdn,omitempty"`

	// The member IPv6 DDNS hostname value.
	Ipv6DdnsHostname *string `json:"ipv6_ddns_hostname,omitempty"`

	// Determines if the server always updates DNS or updates only if requested by
	// the client.
	Ipv6DdnsServerAlwaysUpdates *bool `json:"ipv6_ddns_server_always_updates,omitempty"`

	// The member IPv6 DDNS TTL value.
	Ipv6DdnsTtl *uint32 `json:"ipv6_ddns_ttl,omitempty"`

	// The update style for dynamic DHCPv6 DNS updates.
	Ipv6DnsUpdateStyle string `json:"ipv6_dns_update_style,omitempty"`

	// The IPv6 domain name.
	Ipv6DomainName *string `json:"ipv6_domain_name,omitempty"`

	// The comma separated list of domain name server addresses in IPv6 address
	// format.
	Ipv6DomainNameServers []string `json:"ipv6_domain_name_servers,omitempty"`

	// Determines if sending DDNS updates by the member DHCPv6 server is enabled or
	// not.
	Ipv6EnableDdns *bool `json:"ipv6_enable_ddns,omitempty"`

	// Determines whether the appliance is enabled to receive GSS-TSIG
	// authenticated updates from DHCPv6 clients.
	Ipv6EnableGssTsig *bool `json:"ipv6_enable_gss_tsig,omitempty"`

	// Indicates whether DHCPv6 lease scavenging is enabled or disabled.
	Ipv6EnableLeaseScavenging *bool `json:"ipv6_enable_lease_scavenging,omitempty"`

	// Determines if the DHCPv6 server retries failed dynamic DNS updates or not.
	Ipv6EnableRetryUpdates *bool `json:"ipv6_enable_retry_updates,omitempty"`

	// Determines if the server generates the hostname if it is not sent by the
	// client.
	Ipv6GenerateHostname *bool `json:"ipv6_generate_hostname,omitempty"`

	// The list of GSS-TSIG keys for a member DHCPv6 object.
	Ipv6GssTsigKeys []*Kerberoskey `json:"ipv6_gss_tsig_keys,omitempty"`

	// Determines the IPv6 address or FQDN of the Kerberos server for DHCPv6
	// GSS-TSIG authentication. This setting overrides the Grid level setting.
	Ipv6KdcServer *string `json:"ipv6_kdc_server,omitempty"`

	// The member-level grace period (in seconds) to keep an expired lease before
	// it is deleted by the scavenging process.
	Ipv6LeaseScavengingTime *uint32 `json:"ipv6_lease_scavenging_time,omitempty"`

	// The Microsoft client DHCP IPv6 code page value of a Grid member. This value
	// is the hostname translation code page for Microsoft DHCP IPv6 clients and
	// overrides the Grid level Microsoft DHCP IPv6 client code page.
	Ipv6MicrosoftCodePage string `json:"ipv6_microsoft_code_page,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCPv6 options
	// associated with the object.
	Ipv6Options []*Dhcpoption `json:"ipv6_options,omitempty"`

	// Determines if the IPv6 recycle leases feature is enabled or not. If the
	// feature is enabled, leases are kept in the Recycle Bin until one week after
	// lease expiration. When the feature is disabled, the leases are irrecoverably
	// deleted.
	Ipv6RecycleLeases *bool `json:"ipv6_recycle_leases,omitempty"`

	// Enable binding for expired DHCPv6 leases.
	Ipv6RememberExpiredClientAssociation *bool `json:"ipv6_remember_expired_client_association,omitempty"`

	// Determines the retry interval when the member DHCPv6 server makes repeated
	// attempts to send DDNS updates to a DNS server.
	Ipv6RetryUpdatesInterval *uint32 `json:"ipv6_retry_updates_interval,omitempty"`

	// The server DHCPv6 unique identifier (DUID) for the Grid member.
	Ipv6ServerDuid *string `json:"ipv6_server_duid,omitempty"`

	// Controls whether the DHCPv6 server updates DNS when an IPv6 DHCP lease is
	// renewed.
	Ipv6UpdateDnsOnLeaseRenewal *bool `json:"ipv6_update_dns_on_lease_renewal,omitempty"`

	// The IPv6 Address of the Grid member.
	Ipv6Addr string `json:"ipv6addr,omitempty"`

	// The IPv4 address or FQDN of the Kerberos server for DHCPv4 GSS-TSIG
	// authentication. This setting overrides the Grid level setting.
	KdcServer *string `json:"kdc_server,omitempty"`

	// Defines how the appliance releases DHCP leases. Valid values are
	// "RELEASE_MACHING_ID", "NEVER_RELEASE", or "ONE_LEASE_PER_CLIENT". The
	// default is "RELEASE_MATCHING_ID".
	LeasePerClientSettings string `json:"lease_per_client_settings,omitempty"`

	// Determines the lease scavenging time value. When this field is set, the
	// appliance permanently deletes the free and backup leases that remain in the
	// database beyond a specified period of time. To disable lease scavenging, set
	// the parameter to -1. The minimum positive value must be greater than 86400
	// seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This value specifies whether the grid member logs lease events. This setting
	// overrides the Grid level setting.
	LogLeaseEvents *bool `json:"log_lease_events,omitempty"`

	// This field contains the logic filters to be applied on the Grid member. This
	// list corresponds to the match rules that are written to the dhcpd
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// Determines the low watermark value. If the percent of allocated addresses
	// drops below this watermark, the appliance makes a syslog entry and sends an
	// e-mail notification (if enabled).
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// Determines the low watermark reset value. If the percentage of allocated
	// addresses exceeds this value, a corresponding SNMP trap is reset. A number
	// that specifies the percentage of allocated addresses. The range is from 1 to
	// 100. The low watermark reset value must be higher than the low watermark
	// value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// The Microsoft client DHCP IPv4 code page value of a grid member. This value
	// is the hostname translation code page for Microsoft DHCP IPv4 clients and
	// overrides the Grid level Microsoft DHCP IPv4 client code page.
	MicrosoftCodePage string `json:"microsoft_code_page,omitempty"`

	// The next server value of a member DHCP server. This value is the IP address
	// or name of the boot file server on which the boot file is stored.
	Nextserver *string `json:"nextserver,omitempty"`

	// The list of option 60 match rules.
	Option60MatchRules []*Option60matchrule `json:"option60_match_rules,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// Specifies the number of pings that the Infoblox appliance sends to an IP
	// address to verify that it is not in use. Values are from 0 to 10, where 0
	// disables pings.
	PingCount *uint32 `json:"ping_count,omitempty"`

	// Indicates the number of milliseconds the appliance waits for a response to
	// its ping. Valid values are 100, 500, 1000, 2000, 3000, 4000 and 5000
	// milliseconds.
	PingTimeout *uint32 `json:"ping_timeout,omitempty"`

	// The preferred lifetime value.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The Prefix length mode for DHCPv6.
	PrefixLengthMode string `json:"prefix_length_mode,omitempty"`

	// Specifies the duration of time it takes a host to connect to a boot server,
	// such as a TFTP server, and download the file it needs to boot. A 32-bit
	// unsigned integer that represents the duration, in seconds, for which the
	// update is cached. Zero indicates that the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// Determines if the recycle leases feature is enabled or not. If you enabled
	// this feature and then delete a DHCP range, the appliance stores active
	// leases from this range up to one week after the leases expires.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// Indicates whether the DHCP server makes repeated attempts to send DDNS
	// updates to a DNS server.
	RetryDdnsUpdates *bool `json:"retry_ddns_updates,omitempty"`

	// The number of static DHCP addresses configured in DHCP objects that belong
	// to the Grid Member.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The syslog facility is the location on the syslog server to which you want
	// to sort the syslog messages.
	SyslogFacility string `json:"syslog_facility,omitempty"`

	// The total number of DHCP addresses configured in DHCP objects that belong to
	// the Grid Member.
	TotalHosts uint32 `json:"total_hosts,omitempty"`

	// Controls whether the DHCP server updates DNS when a DHCP lease is renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: authority
	UseAuthority *bool `json:"use_authority,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_update_fixed_addresses
	UseDdnsUpdateFixedAddresses *bool `json:"use_ddns_update_fixed_addresses,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: dns_update_style
	UseDnsUpdateStyle *bool `json:"use_dns_update_style,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds , high_water_mark,
	// high_water_mark_reset, low_water_mark, low_water_mark_reset
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: enable_fingerprint
	UseEnableFingerprint *bool `json:"use_enable_fingerprint,omitempty"`

	// Use flag for: kdc_server , enable_gss_tsig
	UseEnableGssTsig *bool `json:"use_enable_gss_tsig,omitempty"`

	// Use flag for: enable_hostname_rewrite , hostname_rewrite_policy
	UseEnableHostnameRewrite *bool `json:"use_enable_hostname_rewrite,omitempty"`

	// Use flag for: enable_leasequery
	UseEnableLeasequery *bool `json:"use_enable_leasequery,omitempty"`

	// Use flag for: enable_one_lease_per_client
	UseEnableOneLeasePerClient *bool `json:"use_enable_one_lease_per_client,omitempty"`

	// Use flag for: gss_tsig_keys
	UseGssTsigKeys *bool `json:"use_gss_tsig_keys,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ignore_id
	UseIgnoreId *bool `json:"use_ignore_id,omitempty"`

	// Use flag for: immediate_fa_configuration
	UseImmediateFaConfiguration *bool `json:"use_immediate_fa_configuration,omitempty"`

	// Use flag for: ipv6_ddns_domainname
	UseIpv6DdnsDomainname *bool `json:"use_ipv6_ddns_domainname,omitempty"`

	// Use flag for: ipv6_ddns_enable_option_fqdn
	UseIpv6DdnsEnableOptionFqdn *bool `json:"use_ipv6_ddns_enable_option_fqdn,omitempty"`

	// Use flag for: ipv6_ddns_hostname
	UseIpv6DdnsHostname *bool `json:"use_ipv6_ddns_hostname,omitempty"`

	// Use flag for: ipv6_ddns_ttl
	UseIpv6DdnsTtl *bool `json:"use_ipv6_ddns_ttl,omitempty"`

	// Use flag for: ipv6_dns_update_style
	UseIpv6DnsUpdateStyle *bool `json:"use_ipv6_dns_update_style,omitempty"`

	// Use flag for: ipv6_domain_name
	UseIpv6DomainName *bool `json:"use_ipv6_domain_name,omitempty"`

	// Use flag for: ipv6_domain_name_servers
	UseIpv6DomainNameServers *bool `json:"use_ipv6_domain_name_servers,omitempty"`

	// Use flag for: ipv6_enable_ddns
	UseIpv6EnableDdns *bool `json:"use_ipv6_enable_ddns,omitempty"`

	// Use flag for: ipv6_kdc_server , ipv6_enable_gss_tsig
	UseIpv6EnableGssTsig *bool `json:"use_ipv6_enable_gss_tsig,omitempty"`

	// Use flag for: ipv6_enable_retry_updates , ipv6_retry_updates_interval
	UseIpv6EnableRetryUpdates *bool `json:"use_ipv6_enable_retry_updates,omitempty"`

	// Use flag for: ipv6_generate_hostname
	UseIpv6GenerateHostname *bool `json:"use_ipv6_generate_hostname,omitempty"`

	// Use flag for: ipv6_gss_tsig_keys
	UseIpv6GssTsigKeys *bool `json:"use_ipv6_gss_tsig_keys,omitempty"`

	// Use flag for: ipv6_enable_lease_scavenging , ipv6_lease_scavenging_time,
	// ipv6_remember_expired_client_association
	UseIpv6LeaseScavenging *bool `json:"use_ipv6_lease_scavenging,omitempty"`

	// Use flag for: ipv6_microsoft_code_page
	UseIpv6MicrosoftCodePage *bool `json:"use_ipv6_microsoft_code_page,omitempty"`

	// Use flag for: ipv6_options
	UseIpv6Options *bool `json:"use_ipv6_options,omitempty"`

	// Use flag for: ipv6_recycle_leases
	UseIpv6RecycleLeases *bool `json:"use_ipv6_recycle_leases,omitempty"`

	// Use flag for: ipv6_update_dns_on_lease_renewal
	UseIpv6UpdateDnsOnLeaseRenewal *bool `json:"use_ipv6_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: lease_per_client_settings
	UseLeasePerClientSettings *bool `json:"use_lease_per_client_settings,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: log_lease_events
	UseLogLeaseEvents *bool `json:"use_log_lease_events,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: microsoft_code_page
	UseMicrosoftCodePage *bool `json:"use_microsoft_code_page,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: ping_count
	UsePingCount *bool `json:"use_ping_count,omitempty"`

	// Use flag for: ping_timeout
	UsePingTimeout *bool `json:"use_ping_timeout,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: prefix_length_mode
	UsePrefixLengthMode *bool `json:"use_prefix_length_mode,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: ddns_retry_interval , retry_ddns_updates
	UseRetryDdnsUpdates *bool `json:"use_retry_ddns_updates,omitempty"`

	// Use flag for: syslog_facility
	UseSyslogFacility *bool `json:"use_syslog_facility,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// The valid lifetime for Grid Member DHCP. Specifies the length of time
	// addresses that are assigned to DHCPv6 clients remain in the valid state.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (MemberDHCPProperties) ObjectType() string {
	return "member:dhcpproperties"
}

func (obj MemberDHCPProperties) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"host_name", "ipv4addr", "ipv6addr"}
	}
	return obj.returnFields
}

// MemberDns represents Infoblox object member:dns.
// The Grid Member DNS object can be used to configure DNS properties for a
// Grid member, including enabling or disabling DNS services and other DNS
// service related parameters. Grid service configurations are inherited by all
// members.
type MemberDns struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Add custom IP, MAC and DNS View name ENDS0 options to outgoing recursive
	// queries.
	AddClientIpMacOptions *bool `json:"add_client_ip_mac_options,omitempty"`

	// The list of additional IP addresses on which DNS is enabled for a Grid
	// member. Only one of "additional_ip_list" or "additional_ip_list_struct"
	// should be set when modifying the object.
	AdditionalIpList []string `json:"additional_ip_list,omitempty"`

	// The list of additional IP addresses and IP Space Discriminator short names
	// on which DNS is enabled for a Grid member. Only one of "additional_ip_list"
	// or "additional_ip_list_struct" should be set when modifying the object.
	AdditionalIpListStruct []*MemberDnsip `json:"additional_ip_list_struct,omitempty"`

	// Determines whether the GSS-TSIG zone updates is enabled for the Grid member.
	AllowGssTsigZoneUpdates *bool `json:"allow_gss_tsig_zone_updates,omitempty"`

	// Determines if queries from specified IPv4 or IPv6 addresses and networks are
	// enabled or not. The appliance can also use Transaction Signature (TSIG) keys
	// to authenticate the queries. This setting overrides the Grid query settings.
	AllowQuery []*Addressac `json:"allow_query,omitempty"`

	// Determines if the responses to recursive queries is enabled or not. This
	// setting overrides Grid recursive query settings.
	AllowRecursiveQuery *bool `json:"allow_recursive_query,omitempty"`

	// Allows or rejects zone transfers from specified IPv4 or IPv6 addresses and
	// networks or allows transfers from hosts authenticated by Transaction
	// signature (TSIG) key. This setting overrides the Grid zone transfer
	// settings.
	AllowTransfer []*Addressac `json:"allow_transfer,omitempty"`

	// Allows or rejects dynamic updates from specified IPv4 or IPv6 addresses,
	// networks or from host authenticated by TSIG key. This setting overrides Grid
	// update settings.
	AllowUpdate []*Addressac `json:"allow_update,omitempty"`

	// The flag that indicates whether the anonymization of captured DNS responses
	// is enabled or disabled.
	AnonymizeResponseLogging *bool `json:"anonymize_response_logging,omitempty"`

	// Enable DNS recursive query forwarding to Active Trust Cloud.
	AtcFwdEnable *bool `json:"atc_fwd_enable,omitempty"`

	// Mitigation settings for DNS attacks.
	AttackMitigation *GridAttackmitigation `json:"attack_mitigation,omitempty"`

	// The auto blackhole settings.
	AutoBlackhole *GridAutoblackhole `json:"auto_blackhole,omitempty"`

	// Determines if the auto-generation of A and PTR records for the LAN2 IP
	// address is enabled or not, if DNS service is enabled on LAN2.
	AutoCreateAAndPtrForLan2 *bool `json:"auto_create_a_and_ptr_for_lan2,omitempty"`

	// Determines if auto-generation of AAAA and IPv6 PTR records for LAN2 IPv6
	// address is enabled or not.
	AutoCreateAaaaAndIpv6ptrForLan2 *bool `json:"auto_create_aaaa_and_ipv6ptr_for_lan2,omitempty"`

	// Determines if a Grid member to automatically sort DNS views is enabled or
	// not. The order of the DNS views determines the order in which the appliance
	// checks the match lists.
	AutoSortViews *bool `json:"auto_sort_views,omitempty"`

	// The BIND check names policy, which indicates the action the appliance takes
	// when it encounters host names that do not comply with the Strict Hostname
	// Checking policy. This method applies only if the host name restriction
	// policy is set to 'Strict Hostname Checking'.
	BindCheckNamesPolicy string `json:"bind_check_names_policy,omitempty"`

	// The value of the hostname directive for BIND.
	BindHostnameDirective string `json:"bind_hostname_directive,omitempty"`

	// The value of the user-defined hostname directive for BIND. To enable
	// user-defined hostname directive, you must set the bind_hostname_directive to
	// "USER_DEFINED".
	BindHostnameDirectiveFqdn *string `json:"bind_hostname_directive_fqdn,omitempty"`

	// The list of IPv4 or IPv6 addresses and networks from which DNS queries are
	// blocked. This setting overrides the Grid blackhole_list.
	BlackholeList []*Addressac `json:"blackhole_list,omitempty"`

	// The action to perform when a domain name matches the pattern defined in a
	// rule that is specified by the blacklist_ruleset method.
	BlacklistAction string `json:"blacklist_action,omitempty"`

	// Determines if blacklist redirection queries are logged or not.
	BlacklistLogQuery *bool `json:"blacklist_log_query,omitempty"`

	// The IP addresses the appliance includes in the response it sends in place of
	// a blacklisted IP address.
	BlacklistRedirectAddresses []string `json:"blacklist_redirect_addresses,omitempty"`

	// The TTL value of the synthetic DNS responses that result from blacklist
	// redirection.
	BlacklistRedirectTtl *uint32 `json:"blacklist_redirect_ttl,omitempty"`

	// The DNS Ruleset object names assigned at the Grid level for blacklist
	// redirection.
	BlacklistRulesets []string `json:"blacklist_rulesets,omitempty"`

	// The flag that indicates whether the capture of DNS queries for all domains
	// is enabled or disabled.
	CaptureDnsQueriesOnAllDomains *bool `json:"capture_dns_queries_on_all_domains,omitempty"`

	// Determines whether the application of BIND check-names for zone transfers
	// and DDNS updates are enabled.
	CheckNamesForDdnsAndZoneTransfer *bool `json:"check_names_for_ddns_and_zone_transfer,omitempty"`

	// Copy custom IP, MAC and DNS View name ENDS0 options from incoming to
	// outgoing recursive queries.
	CopyClientIpMacOptions *bool `json:"copy_client_ip_mac_options,omitempty"`

	// Copies the allowed IPs from the zone transfer list into the also-notify
	// statement in the named.conf file.
	CopyXferToNotify *bool `json:"copy_xfer_to_notify,omitempty"`

	// The list of custom root name servers. You can either select and use Internet
	// root name servers or specify custom root name servers by providing a host
	// name and IP address to which the Infoblox appliance can send queries.
	CustomRootNameServers []NameServer `json:"custom_root_name_servers,omitempty"`

	// The EDNS0 support for queries that require recursive resolution on Grid
	// members.
	DisableEdns *bool `json:"disable_edns,omitempty"`

	// The list of DNS64 synthesis groups associated with this member.
	Dns64Groups []string `json:"dns64_groups,omitempty"`

	// The DNS cache acceleration status.
	DnsCacheAccelerationStatus string `json:"dns_cache_acceleration_status,omitempty"`

	// The minimum TTL value, in seconds, that a DNS record must have in order for
	// it to be cached by the DNS Cache Acceleration service. An integer from 1 to
	// 65000 that represents the TTL in seconds.
	DnsCacheAccelerationTtl *uint32 `json:"dns_cache_acceleration_ttl,omitempty"`

	// The flag that indicates whether the anycast failure (BFD session down) is
	// enabled on member failure or not.
	DnsHealthCheckAnycastControl *bool `json:"dns_health_check_anycast_control,omitempty"`

	// The list of domain names for the DNS health check.
	DnsHealthCheckDomainList []string `json:"dns_health_check_domain_list,omitempty"`

	// The time interval (in seconds) for DNS health check.
	DnsHealthCheckInterval *uint32 `json:"dns_health_check_interval,omitempty"`

	// The flag that indicates whether the recursive DNS health check is enabled or
	// not.
	DnsHealthCheckRecursionFlag *bool `json:"dns_health_check_recursion_flag,omitempty"`

	// The number of DNS health check retries.
	DnsHealthCheckRetries *uint32 `json:"dns_health_check_retries,omitempty"`

	// The DNS health check timeout interval (in seconds).
	DnsHealthCheckTimeout *uint32 `json:"dns_health_check_timeout,omitempty"`

	// Determines which IP address is used as the source for DDNS notify and
	// transfer operations.
	DnsNotifyTransferSource string `json:"dns_notify_transfer_source,omitempty"`

	// The source address used if dns_notify_transfer_source type is "IP".
	DnsNotifyTransferSourceAddress *string `json:"dns_notify_transfer_source_address,omitempty"`

	// Enables DNS over TLS service.
	DnsOverTlsService *bool `json:"dns_over_tls_service,omitempty"`

	// The time limit (in minutes) for the DNS query capture file.
	DnsQueryCaptureFileTimeLimit *uint32 `json:"dns_query_capture_file_time_limit,omitempty"`

	// The source address used if dns_query_source_interface type is "IP".
	DnsQuerySourceAddress *string `json:"dns_query_source_address,omitempty"`

	// Determines which IP address is used as the source for DDNS query operations.
	DnsQuerySourceInterface string `json:"dns_query_source_interface,omitempty"`

	// Array of notify/query source settings for views.
	DnsViewAddressSettings []*SettingViewaddress `json:"dns_view_address_settings,omitempty"`

	// Determines if the blacklist rules for DNSSEC-enabled clients are enabled or
	// not.
	DnssecBlacklistEnabled *bool `json:"dnssec_blacklist_enabled,omitempty"`

	// Determines if the DNS64 groups for DNSSEC-enabled clients are enabled or
	// not.
	DnssecDns64Enabled *bool `json:"dnssec_dns64_enabled,omitempty"`

	// Determines if the DNS security extension is enabled or not.
	DnssecEnabled *bool `json:"dnssec_enabled,omitempty"`

	// Determines when the DNS member accepts expired signatures.
	DnssecExpiredSignaturesEnabled *bool `json:"dnssec_expired_signatures_enabled,omitempty"`

	// A list of zones for which the server does not perform DNSSEC validation.
	DnssecNegativeTrustAnchors []string `json:"dnssec_negative_trust_anchors,omitempty"`

	// Determines if the NXDOMAIN rules for DNSSEC-enabled clients are enabled or
	// not.
	DnssecNxdomainEnabled *bool `json:"dnssec_nxdomain_enabled,omitempty"`

	// Determines if the RPZ policies for DNSSEC-enabled clients are enabled or
	// not.
	DnssecRpzEnabled *bool `json:"dnssec_rpz_enabled,omitempty"`

	// The list of trusted keys for the DNSSEC feature.
	DnssecTrustedKeys []*Dnssectrustedkey `json:"dnssec_trusted_keys,omitempty"`

	// Determines if the DNS security validation is enabled or not.
	DnssecValidationEnabled *bool `json:"dnssec_validation_enabled,omitempty"`

	// The DNSTAP settings.
	DnstapSetting *Dnstapsetting `json:"dnstap_setting,omitempty"`

	// DNS over HTTPS sessions duration.
	DohHttpsSessionDuration *uint32 `json:"doh_https_session_duration,omitempty"`

	// Enables DNS over HTTPS service.
	DohService *bool `json:"doh_service,omitempty"`

	// The list of domains for DNS query capture.
	DomainsToCaptureDnsQueries []string `json:"domains_to_capture_dns_queries,omitempty"`

	// Setting to control specific behavior for DTC DNS responses for incoming lbdn
	// matched queries.
	DtcDnsQueriesSpecificBehavior string `json:"dtc_dns_queries_specific_behavior,omitempty"`

	// Determines whether to prefer the client address from the edns-client-subnet
	// option for DTC or not.
	DtcEdnsPreferClientSubnet *bool `json:"dtc_edns_prefer_client_subnet,omitempty"`

	// The health check source type.
	DtcHealthSource string `json:"dtc_health_source,omitempty"`

	// The source address used if dtc_health_source type is "IP".
	DtcHealthSourceAddress *string `json:"dtc_health_source_address,omitempty"`

	// Advertises the EDNS0 buffer size to the upstream server. The value should be
	// between 512 and 4096 bytes. The recommended value is between 512 and 1220
	// bytes.
	EdnsUdpSize *uint32 `json:"edns_udp_size,omitempty"`

	// Determines if the blocking of DNS queries is enabled or not. This setting
	// overrides the Grid enable_blackhole settings.
	EnableBlackhole *bool `json:"enable_blackhole,omitempty"`

	// Determines if a blacklist is enabled or not on the Grid member.
	EnableBlacklist *bool `json:"enable_blacklist,omitempty"`

	// The flag that indicates whether the capture of DNS queries is enabled or
	// disabled.
	EnableCaptureDnsQueries *bool `json:"enable_capture_dns_queries,omitempty"`

	// The flag that indicates whether the capture of DNS responses is enabled or
	// disabled.
	EnableCaptureDnsResponses *bool `json:"enable_capture_dns_responses,omitempty"`

	// Determines if the DNS service of a member is enabled or not.
	EnableDns *bool `json:"enable_dns,omitempty"`

	// Determines if the DNS64 support is enabled or not for this member.
	EnableDns64 *bool `json:"enable_dns64,omitempty"`

	// Determines if the DNS Cache Acceleration service is enabled or not for a
	// member.
	EnableDnsCacheAcceleration *bool `json:"enable_dns_cache_acceleration,omitempty"`

	// The flag that indicates whether the DNS health check is enabled or not.
	EnableDnsHealthCheck *bool `json:"enable_dns_health_check,omitempty"`

	// Determines whether the query messages need to be forwarded to DNSTAP or not.
	EnableDnstapQueries *bool `json:"enable_dnstap_queries,omitempty"`

	// Determines whether the response messages need to be forwarded to DNSTAP or
	// not.
	EnableDnstapResponses *bool `json:"enable_dnstap_responses,omitempty"`

	// The flag that indicates whether excluding domain names from captured DNS
	// queries and responses is enabled or disabled.
	EnableExcludedDomainNames *bool `json:"enable_excluded_domain_names,omitempty"`

	// Determines if the fixed RRset order FQDN is enabled or not.
	EnableFixedRrsetOrderFqdns *bool `json:"enable_fixed_rrset_order_fqdns,omitempty"`

	// Determines whether Fault Tolerant Caching (FTC) is enabled.
	EnableFtc *bool `json:"enable_ftc,omitempty"`

	// Determines whether the appliance is enabled to receive GSS-TSIG
	// authenticated updates from DHCP clients.
	EnableGssTsig *bool `json:"enable_gss_tsig,omitempty"`

	// Determines if the notify source port for a member is enabled or not.
	EnableNotifySourcePort *bool `json:"enable_notify_source_port,omitempty"`

	// Determines if the DNS query rewrite is enabled or not for this member.
	EnableQueryRewrite *bool `json:"enable_query_rewrite,omitempty"`

	// Determines if the query source port for a memer is enabled or not.
	EnableQuerySourcePort *bool `json:"enable_query_source_port,omitempty"`

	// The list of domains that are excluded from DNS query and response capture.
	ExcludedDomainNames []string `json:"excluded_domain_names,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The DNS capture file transfer settings. Include the specified parameter to
	// set the attribute value. Omit the parameter to retrieve the attribute value.
	FileTransferSetting *Filetransfersetting `json:"file_transfer_setting,omitempty"`

	// The type of AAAA filtering for this member DNS object.
	FilterAaaa string `json:"filter_aaaa,omitempty"`

	// The list of IPv4 addresses and networks from which queries are received.
	// AAAA filtering is applied to these addresses.
	FilterAaaaList []*Addressac `json:"filter_aaaa_list,omitempty"`

	// The fixed RRset order FQDN. If this field does not contain an empty value,
	// the appliance will automatically set the enable_fixed_rrset_order_fqdns
	// field to 'true', unless the same request sets the enable field to 'false'.
	FixedRrsetOrderFqdns []*GridDnsFixedrrsetorderfqdn `json:"fixed_rrset_order_fqdns,omitempty"`

	// Permits this member to send queries to forwarders only. When the value is
	// "true", the member sends queries to forwarders only, and not to other
	// internal or Internet root servers.
	ForwardOnly *bool `json:"forward_only,omitempty"`

	// Allows secondary servers to forward updates to the DNS server. This setting
	// overrides grid update settings.
	ForwardUpdates *bool `json:"forward_updates,omitempty"`

	// The forwarders for the member. A forwarder is essentially a name server to
	// which other name servers first send all of their off-site queries. The
	// forwarder builds up a cache of information, avoiding the need for the other
	// name servers to send queries off-site. This setting overrides the Grid level
	// setting.
	Forwarders []string `json:"forwarders,omitempty"`

	// The timeout interval (in seconds) after which the expired Fault Tolerant
	// Caching (FTC)record is stale and no longer valid.
	FtcExpiredRecordTimeout *uint32 `json:"ftc_expired_record_timeout,omitempty"`

	// The TTL value (in seconds) of the expired Fault Tolerant Caching (FTC)
	// record in DNS responses.
	FtcExpiredRecordTtl *uint32 `json:"ftc_expired_record_ttl,omitempty"`

	// The list of glue record addresses.
	GlueRecordAddresses []*MemberDnsgluerecordaddr `json:"glue_record_addresses,omitempty"`

	// The list of GSS-TSIG keys for a member DNS object.
	GssTsigKeys []*Kerberoskey `json:"gss_tsig_keys,omitempty"`

	// The host name of the Grid member.
	HostName string `json:"host_name,omitempty"`

	// The IPv4 Address of the Grid member.
	Ipv4Addr string `json:"ipv4addr,omitempty"`

	// The list of IPv6 glue record addresses.
	Ipv6GlueRecordAddresses []*MemberDnsgluerecordaddr `json:"ipv6_glue_record_addresses,omitempty"`

	// The IPv6 Address of the Grid member.
	Ipv6Addr string `json:"ipv6addr,omitempty"`

	// The flag that indicates whether member DNS supports Unbound as the recursive
	// resolver or not.
	IsUnboundCapable bool `json:"is_unbound_capable,omitempty"`

	// The number of seconds to cache lame delegations or lame servers.
	LameTtl *uint32 `json:"lame_ttl,omitempty"`

	// The logging categories for this DNS member.
	LoggingCategories *GridLoggingcategories `json:"logging_categories,omitempty"`

	// The maximum time (in seconds) for which the server will cache positive
	// answers.
	MaxCacheTtl *uint32 `json:"max_cache_ttl,omitempty"`

	// The maximum time in seconds a DNS response can be stored in the hardware
	// acceleration cache. Valid values are unsigned integer between 60 and 86400,
	// inclusive.
	MaxCachedLifetime *uint32 `json:"max_cached_lifetime,omitempty"`

	// The maximum time (in seconds) for which the server will cache negative
	// (NXDOMAIN) responses. The maximum allowed value is 604800.
	MaxNcacheTtl *uint32 `json:"max_ncache_ttl,omitempty"`

	// The value is used by authoritative DNS servers to never send DNS responses
	// larger than the configured value. The value should be between 512 and 4096
	// bytes. The recommended value is between 512 and 1220 bytes.
	MaxUdpSize *uint32 `json:"max_udp_size,omitempty"`

	// Enables the ability to return a minimal amount of data in response to a
	// query. This capability speeds up the DNS services provided by the appliance.
	MinimalResp *bool `json:"minimal_resp,omitempty"`

	// Specifies the number of seconds of delay the notify messages are sent to
	// secondaries.
	NotifyDelay *uint32 `json:"notify_delay,omitempty"`

	// The source port for notify messages. When requesting zone transfers from the
	// primary server, some secondary DNS servers use the source port number (the
	// primary server used to send the notify message) as the destination port
	// number in the zone transfer request. This setting overrides Grid static
	// source port settings. Valid values are between 1 and 63999. The default is
	// selected by BIND.
	NotifySourcePort *uint32 `json:"notify_source_port,omitempty"`

	// Determines if NXDOMAIN redirection queries are logged or not.
	NxdomainLogQuery *bool `json:"nxdomain_log_query,omitempty"`

	// Enables NXDOMAIN redirection.
	NxdomainRedirect *bool `json:"nxdomain_redirect,omitempty"`

	// The IPv4 NXDOMAIN redirection addresses.
	NxdomainRedirectAddresses []string `json:"nxdomain_redirect_addresses,omitempty"`

	// The IPv6 NXDOMAIN redirection addresses.
	NxdomainRedirectAddressesV6 []string `json:"nxdomain_redirect_addresses_v6,omitempty"`

	// The TTL value of synthetic DNS responses that result from NXDOMAIN
	// redirection.
	NxdomainRedirectTtl *uint32 `json:"nxdomain_redirect_ttl,omitempty"`

	// The names of the Ruleset objects assigned at the Grid level for NXDOMAIN
	// redirection.
	NxdomainRulesets []string `json:"nxdomain_rulesets,omitempty"`

	// The source port for queries. Specifying a source port number for recursive
	// queries ensures that a firewall will allow the response. Valid values are
	// between 1 and 63999. The default is selected by BIND.
	QuerySourcePort *uint32 `json:"query_source_port,omitempty"`

	// The record name restriction policy.
	RecordNamePolicy *string `json:"record_name_policy,omitempty"`

	// A limit on the number of concurrent recursive clients.
	RecursiveClientLimit *uint32 `json:"recursive_client_limit,omitempty"`

	// The list of IPv4 or IPv6 addresses, networks or hosts authenticated by
	// Transaction signature (TSIG) key from which recursive queries are allowed or
	// denied.
	RecursiveQueryList []*Addressac `json:"recursive_query_list,omitempty"`

	// The recursive resolver for member DNS.
	RecursiveResolver string `json:"recursive_resolver,omitempty"`

	// The recursive query timeout for the member. The value must be 0 or between
	// 10 and 30.
	ResolverQueryTimeout *uint32 `json:"resolver_query_timeout,omitempty"`

	// The response rate limiting settings for the member.
	ResponseRateLimiting *GridResponseratelimiting `json:"response_rate_limiting,omitempty"`

	// Determines the type of root name servers.
	RootNameServerType string `json:"root_name_server_type,omitempty"`

	// Enables NSDNAME and NSIP resource records from RPZ feeds at member level.
	RpzDisableNsdnameNsip *bool `json:"rpz_disable_nsdname_nsip,omitempty"`

	// Enables the appliance to ignore RPZ-IP triggers with prefix lengths less
	// than the specified minimum prefix length.
	RpzDropIpRuleEnabled *bool `json:"rpz_drop_ip_rule_enabled,omitempty"`

	// The minimum prefix length for IPv4 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv4
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv4 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv4,omitempty"`

	// The minimum prefix length for IPv6 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv6
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv6 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv6,omitempty"`

	// The flag that indicates whether recursive RPZ lookups are enabled.
	RpzQnameWaitRecurse *bool `json:"rpz_qname_wait_recurse,omitempty"`

	// The number of maximum concurrent SOA queries per second for the member.
	SerialQueryRate *uint32 `json:"serial_query_rate,omitempty"`

	// The value of the server-id directive for BIND and Unbound DNS.
	ServerIdDirective string `json:"server_id_directive,omitempty"`

	// The value of the user-defined hostname directive for BIND and UNBOUND DNS.
	// To enable user-defined hostname directive, you must set the
	// bind_hostname_directive to "USER_DEFINED".
	ServerIdDirectiveString *string `json:"server_id_directive_string,omitempty"`

	// Determines if RPZ rules are applied to queries originated from this member
	// and received by other Grid members.
	SkipInGridRpzQueries *bool `json:"skip_in_grid_rpz_queries,omitempty"`

	// A sort list determines the order of addresses in responses made to DNS
	// queries. This setting overrides Grid sort list settings.
	Sortlist []*Sortlist `json:"sortlist,omitempty"`

	// The flag that indicates whether the storage of query capture reports on the
	// appliance is enabled or disabled.
	StoreLocally *bool `json:"store_locally,omitempty"`

	// The syslog facility. This is the location on the syslog server to which you
	// want to sort the DNS logging messages. This setting overrides the Grid
	// logging facility settings.
	SyslogFacility string `json:"syslog_facility,omitempty"`

	// TCP Idle timeout for DNS over TLS connections.
	TcpIdleTimeout *uint32 `json:"tcp_idle_timeout,omitempty"`

	// DNS over TLS sessions duration.
	TlsSessionDuration *uint32 `json:"tls_session_duration,omitempty"`

	// Excludes specified DNS servers during zone transfers.
	TransferExcludedServers []string `json:"transfer_excluded_servers,omitempty"`

	// The BIND format for a zone transfer. This provides tracking capabilities for
	// single or multiple transfers and their associated servers.
	TransferFormat string `json:"transfer_format,omitempty"`

	// The number of maximum concurrent transfers for the member.
	TransfersIn *uint32 `json:"transfers_in,omitempty"`

	// The number of maximum outbound concurrent zone transfers for the member.
	TransfersOut *uint32 `json:"transfers_out,omitempty"`

	// The number of maximum concurrent transfers per member for the member.
	TransfersPerNs *uint32 `json:"transfers_per_ns,omitempty"`

	// Logging level for the Unbound recursive resolver.
	UnboundLoggingLevel string `json:"unbound_logging_level,omitempty"`

	// Use flag for: add_client_ip_mac_options
	UseAddClientIpMacOptions *bool `json:"use_add_client_ip_mac_options,omitempty"`

	// Use flag for: allow_query
	UseAllowQuery *bool `json:"use_allow_query,omitempty"`

	// Use flag for: allow_transfer
	UseAllowTransfer *bool `json:"use_allow_transfer,omitempty"`

	// Use flag for: attack_mitigation
	UseAttackMitigation *bool `json:"use_attack_mitigation,omitempty"`

	// Use flag for: auto_blackhole
	UseAutoBlackhole *bool `json:"use_auto_blackhole,omitempty"`

	// Use flag for: bind_hostname_directive
	UseBindHostnameDirective *bool `json:"use_bind_hostname_directive,omitempty"`

	// Use flag for: enable_blackhole
	UseBlackhole *bool `json:"use_blackhole,omitempty"`

	// Use flag for: blackhole_list , blacklist_action, blacklist_log_query,
	// blacklist_redirect_addresses, blacklist_redirect_ttl, blacklist_rulesets,
	// enable_blacklist
	UseBlacklist *bool `json:"use_blacklist,omitempty"`

	// Use flag for: capture_dns_queries_on_all_domains
	UseCaptureDnsQueriesOnAllDomains *bool `json:"use_capture_dns_queries_on_all_domains,omitempty"`

	// Use flag for: copy_client_ip_mac_options
	UseCopyClientIpMacOptions *bool `json:"use_copy_client_ip_mac_options,omitempty"`

	// Use flag for: copy_xfer_to_notify
	UseCopyXferToNotify *bool `json:"use_copy_xfer_to_notify,omitempty"`

	// Use flag for: disable_edns
	UseDisableEdns *bool `json:"use_disable_edns,omitempty"`

	// Use flag for: enable_dns64 , dns64_groups
	UseDns64 *bool `json:"use_dns64,omitempty"`

	// Use flag for: dns_cache_acceleration_ttl
	UseDnsCacheAccelerationTtl *bool `json:"use_dns_cache_acceleration_ttl,omitempty"`

	// Use flag for: dns_health_check_domain_list ,
	// dns_health_check_recursion_flag, dns_health_check_anycast_control,
	// enable_dns_health_check, dns_health_check_interval,
	// dns_health_check_timeout, dns_health_check_retries
	UseDnsHealthCheck *bool `json:"use_dns_health_check,omitempty"`

	// Use flag for: dnssec_enabled , dnssec_expired_signatures_enabled,
	// dnssec_validation_enabled, dnssec_trusted_keys
	UseDnssec *bool `json:"use_dnssec,omitempty"`

	// Use flag for: enable_dnstap_queries , enable_dnstap_responses,
	// dnstap_setting
	UseDnstapSetting *bool `json:"use_dnstap_setting,omitempty"`

	// Use flag for: dtc_dns_queries_specific_behavior
	UseDtcDnsQueriesSpecificBehavior *bool `json:"use_dtc_dns_queries_specific_behavior,omitempty"`

	// Use flag for: dtc_edns_prefer_client_subnet
	UseDtcEdnsPreferClientSubnet *bool `json:"use_dtc_edns_prefer_client_subnet,omitempty"`

	// Use flag for: edns_udp_size
	UseEdnsUdpSize *bool `json:"use_edns_udp_size,omitempty"`

	// Use flag for: enable_capture_dns_queries , enable_capture_dns_responses
	UseEnableCaptureDns *bool `json:"use_enable_capture_dns,omitempty"`

	// Use flag for: enable_excluded_domain_names
	UseEnableExcludedDomainNames *bool `json:"use_enable_excluded_domain_names,omitempty"`

	// Use flag for: enable_gss_tsig
	UseEnableGssTsig *bool `json:"use_enable_gss_tsig,omitempty"`

	// Use flag for: enable_query_rewrite
	UseEnableQueryRewrite *bool `json:"use_enable_query_rewrite,omitempty"`

	// Use flag for: filter_aaaa , filter_aaaa_list
	UseFilterAaaa *bool `json:"use_filter_aaaa,omitempty"`

	// Use flag for: fixed_rrset_order_fqdns , enable_fixed_rrset_order_fqdns
	UseFixedRrsetOrderFqdns *bool `json:"use_fixed_rrset_order_fqdns,omitempty"`

	// Use flag for: forward_updates
	UseForwardUpdates *bool `json:"use_forward_updates,omitempty"`

	// Use flag for: forwarders , forward_only
	UseForwarders *bool `json:"use_forwarders,omitempty"`

	// Use flag for: enable_ftc , ftc_expired_record_ttl,
	// ftc_expired_record_timeout
	UseFtc *bool `json:"use_ftc,omitempty"`

	// Use flag for: gss_tsig_keys
	UseGssTsigKeys *bool `json:"use_gss_tsig_keys,omitempty"`

	// Use flag for: lame_ttl
	UseLameTtl *bool `json:"use_lame_ttl,omitempty"`

	// Determines if the DNS service on the IPv6 LAN2 port is enabled or not.
	UseLan2Ipv6Port *bool `json:"use_lan2_ipv6_port,omitempty"`

	// Determines if the DNS service on the LAN2 port is enabled or not.
	UseLan2Port *bool `json:"use_lan2_port,omitempty"`

	// Determines if the DNS service on the IPv6 LAN port is enabled or not.
	UseLanIpv6Port *bool `json:"use_lan_ipv6_port,omitempty"`

	// Determines the status of the use of DNS services on the IPv4 LAN1 port.
	UseLanPort *bool `json:"use_lan_port,omitempty"`

	// Use flag for: logging_categories
	UseLoggingCategories *bool `json:"use_logging_categories,omitempty"`

	// Use flag for: max_cache_ttl
	UseMaxCacheTtl *bool `json:"use_max_cache_ttl,omitempty"`

	// Use flag for: max_cached_lifetime
	UseMaxCachedLifetime *bool `json:"use_max_cached_lifetime,omitempty"`

	// Use flag for: max_ncache_ttl
	UseMaxNcacheTtl *bool `json:"use_max_ncache_ttl,omitempty"`

	// Use flag for: max_udp_size
	UseMaxUdpSize *bool `json:"use_max_udp_size,omitempty"`

	// Determines if the DNS services on the IPv6 MGMT port is enabled or not.
	UseMgmtIpv6Port *bool `json:"use_mgmt_ipv6_port,omitempty"`

	// Determines if the DNS services on the MGMT port is enabled or not.
	UseMgmtPort *bool `json:"use_mgmt_port,omitempty"`

	// Use flag for: notify_delay
	UseNotifyDelay *bool `json:"use_notify_delay,omitempty"`

	// Use flag for: nxdomain_redirect , nxdomain_redirect_addresses,
	// nxdomain_redirect_addresses_v6, nxdomain_redirect_ttl, nxdomain_log_query,
	// nxdomain_rulesets
	UseNxdomainRedirect *bool `json:"use_nxdomain_redirect,omitempty"`

	// Use flag for: record_name_policy
	UseRecordNamePolicy *bool `json:"use_record_name_policy,omitempty"`

	// Use flag for: recursive_client_limit
	UseRecursiveClientLimit *bool `json:"use_recursive_client_limit,omitempty"`

	// Use flag for: allow_recursive_query , recursive_query_list
	UseRecursiveQuerySetting *bool `json:"use_recursive_query_setting,omitempty"`

	// Use flag for: resolver_query_timeout
	UseResolverQueryTimeout *bool `json:"use_resolver_query_timeout,omitempty"`

	// Use flag for: response_rate_limiting
	UseResponseRateLimiting *bool `json:"use_response_rate_limiting,omitempty"`

	// Use flag for: root_name_server_type , custom_root_name_servers,
	// use_root_server_for_all_views
	UseRootNameServer *bool `json:"use_root_name_server,omitempty"`

	// Determines if root name servers should be applied to all views or only to
	// Default view.
	UseRootServerForAllViews *bool `json:"use_root_server_for_all_views,omitempty"`

	// Use flag for: rpz_disable_nsdname_nsip
	UseRpzDisableNsdnameNsip *bool `json:"use_rpz_disable_nsdname_nsip,omitempty"`

	// Use flag for: rpz_drop_ip_rule_enabled ,
	// rpz_drop_ip_rule_min_prefix_length_ipv4,
	// rpz_drop_ip_rule_min_prefix_length_ipv6
	UseRpzDropIpRule *bool `json:"use_rpz_drop_ip_rule,omitempty"`

	// Use flag for: rpz_qname_wait_recurse
	UseRpzQnameWaitRecurse *bool `json:"use_rpz_qname_wait_recurse,omitempty"`

	// Use flag for: serial_query_rate
	UseSerialQueryRate *bool `json:"use_serial_query_rate,omitempty"`

	// Use flag for: server_id_directive
	UseServerIdDirective *bool `json:"use_server_id_directive,omitempty"`

	// Use flag for: sortlist
	UseSortlist *bool `json:"use_sortlist,omitempty"`

	// Use flag for: enable_notify_source_port , notify_source_port,
	// enable_query_source_port, query_source_port
	UseSourcePorts *bool `json:"use_source_ports,omitempty"`

	// Use flag for: syslog_facility
	UseSyslogFacility *bool `json:"use_syslog_facility,omitempty"`

	// Use flag for: transfers_in
	UseTransfersIn *bool `json:"use_transfers_in,omitempty"`

	// Use flag for: transfers_out
	UseTransfersOut *bool `json:"use_transfers_out,omitempty"`

	// Use flag for: transfers_per_ns
	UseTransfersPerNs *bool `json:"use_transfers_per_ns,omitempty"`

	// Use flag for: allow_update , allow_gss_tsig_zone_updates
	UseUpdateSetting *bool `json:"use_update_setting,omitempty"`

	// Use flag for: transfer_excluded_servers , transfer_format
	UseZoneTransferFormat *bool `json:"use_zone_transfer_format,omitempty"`

	// The list of views associated with this member.
	Views []string `json:"views,omitempty"`
}

func (MemberDns) ObjectType() string {
	return "member:dns"
}

func (obj MemberDns) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"host_name", "ipv4addr", "ipv6addr"}
	}
	return obj.returnFields
}

// MemberFiledistribution represents Infoblox object member:filedistribution.
// The Grid member file distribution object is used to configure file
// distribution services such as TFTP, FTP and HTTP, and access control lists
// (ACL) that determine which clients are granted access to the service (TFTP,
// FTP, HTTP), and which clients are denied access to the service.
type MemberFiledistribution struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether uploads to the Grid member are allowed.
	AllowUploads *bool `json:"allow_uploads,omitempty"`

	// The Grid member descriptive comment.
	Comment string `json:"comment,omitempty"`

	// Determines whether the FTP prtocol is enabled for file distribution.
	EnableFtp *bool `json:"enable_ftp,omitempty"`

	// Determines whether the LIST command for FTP is enabled.
	EnableFtpFilelist *bool `json:"enable_ftp_filelist,omitempty"`

	// Determines whether the passive mode for FTP is enabled.
	EnableFtpPassive *bool `json:"enable_ftp_passive,omitempty"`

	// Determines whether the HTTP prtocol is enabled for file distribution.
	EnableHttp *bool `json:"enable_http,omitempty"`

	// Determines whether the HTTP prtocol access control (AC) settings are
	// enabled.
	EnableHttpAcl *bool `json:"enable_http_acl,omitempty"`

	// Determines whether the TFTP prtocol is enabled for file distribution.
	EnableTftp *bool `json:"enable_tftp,omitempty"`

	// Access control (AC) settings for the FTP protocol.
	FtpAcls []*Addressac `json:"ftp_acls,omitempty"`

	// The network port used by the FTP protocol.
	FtpPort *uint32 `json:"ftp_port,omitempty"`

	// The FTP protocol status.
	FtpStatus string `json:"ftp_status,omitempty"`

	// The Grid member host name.
	HostName string `json:"host_name,omitempty"`

	// Access control (AC) settings for the HTTP protocol.
	HttpAcls []*Addressac `json:"http_acls,omitempty"`

	// The HTTP protocol status.
	HttpStatus string `json:"http_status,omitempty"`

	// The IPv4 address of the Grid member.
	Ipv4Address string `json:"ipv4_address,omitempty"`

	// The IPv6 address of the Grid member.
	Ipv6Address string `json:"ipv6_address,omitempty"`

	// The Grid member file distribution status.
	Status string `json:"status,omitempty"`

	// The access control (AC) settings for the TFTP protocol.
	TftpAcls []*Addressac `json:"tftp_acls,omitempty"`

	// The network port used by the TFTP protocol.
	TftpPort *uint32 `json:"tftp_port,omitempty"`

	// The TFTP protocol status.
	TftpStatus string `json:"tftp_status,omitempty"`

	// Use flag for: allow_uploads
	UseAllowUploads *bool `json:"use_allow_uploads,omitempty"`
}

func (MemberFiledistribution) ObjectType() string {
	return "member:filedistribution"
}

func (obj MemberFiledistribution) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"host_name", "ipv4_address", "ipv6_address", "status"}
	}
	return obj.returnFields
}

// MemberLicense represents Infoblox object member:license.
// This object represents the member license.
type MemberLicense struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The license expiration status.
	ExpirationStatus string `json:"expiration_status,omitempty"`

	// The expiration timestamp of the license.
	ExpiryDate *UnixTime `json:"expiry_date,omitempty"`

	// The hardware ID of the physical node on which the license is installed.
	Hwid string `json:"hwid,omitempty"`

	// License string.
	Key string `json:"key,omitempty"`

	// The overall type of license: static or dynamic.
	Kind string `json:"kind,omitempty"`

	// The license limit value.
	Limit string `json:"limit,omitempty"`

	// The license limit context.
	LimitContext string `json:"limit_context,omitempty"`

	// The license type.
	Type string `json:"type,omitempty"`
}

func (MemberLicense) ObjectType() string {
	return "member:license"
}

func (obj MemberLicense) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"type"}
	}
	return obj.returnFields
}

// MemberParentalcontrol represents Infoblox object member:parentalcontrol.
// This object represents a set of parental control properties for the Grid
// member.
type MemberParentalcontrol struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines if the parental control service is enabled.
	EnableService *bool `json:"enable_service,omitempty"`

	// The parental control member hostname.
	Name string `json:"name,omitempty"`
}

func (MemberParentalcontrol) ObjectType() string {
	return "member:parentalcontrol"
}

func (obj MemberParentalcontrol) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"enable_service", "name"}
	}
	return obj.returnFields
}

// MemberThreatanalytics represents Infoblox object member:threatanalytics.
// To mitigate DNS data exfiltration, Infoblox DNS threat analytics employs
// analytics algorithms that analyze incoming DNS queries and responses to
// detect DNS tunneling traffic.
type MemberThreatanalytics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid member descriptive comment.
	Comment string `json:"comment,omitempty"`

	// Determines whether the threat analytics service is enabled.
	EnableService *bool `json:"enable_service,omitempty"`

	// The Grid member host name.
	HostName string `json:"host_name,omitempty"`

	// The IPv4 Address address of the Grid member.
	Ipv4Address string `json:"ipv4_address,omitempty"`

	// The IPv6 Address address of the Grid member.
	Ipv6Address string `json:"ipv6_address,omitempty"`

	// The Grid member threat analytics status.
	Status string `json:"status,omitempty"`
}

func (MemberThreatanalytics) ObjectType() string {
	return "member:threatanalytics"
}

func (obj MemberThreatanalytics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"host_name", "ipv4_address", "ipv6_address", "status"}
	}
	return obj.returnFields
}

// MemberThreatprotection represents Infoblox object member:threatprotection.
// This object provides information about the member threat protection
// settings.
type MemberThreatprotection struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The human readable comment for member threat protection properties.
	Comment string `json:"comment,omitempty"`

	// The ruleset used for threat protection.
	CurrentRuleset *string `json:"current_ruleset,omitempty"`

	// Determines if multiple BIND responses via TCP connection is enabled or not.
	DisableMultipleDnsTcpRequest *bool `json:"disable_multiple_dns_tcp_request,omitempty"`

	// Determines if DNS responses are sent from acceleration cache before applying
	// Threat Protection rules. Recommended for better performance when using DNS
	// Cache Acceleration.
	EnableAccelRespBeforeThreatProtection *bool `json:"enable_accel_resp_before_threat_protection,omitempty"`

	// Determines if NAT (Network Address Translation) mapping for threat
	// protection is enabled or not.
	EnableNatRules *bool `json:"enable_nat_rules,omitempty"`

	// Determines if the Threat protection service is enabled or not.
	EnableService *bool `json:"enable_service,omitempty"`

	// The number of events logged per second per rule.
	EventsPerSecondPerRule *uint32 `json:"events_per_second_per_rule,omitempty"`

	// The hardware model of the member.
	HardwareModel string `json:"hardware_model,omitempty"`

	// The hardware type of the member.
	HardwareType string `json:"hardware_type,omitempty"`

	// A Grid member name.
	HostName string `json:"host_name,omitempty"`

	// The IPv4 address of member threat protection service.
	Ipv4address string `json:"ipv4address,omitempty"`

	// The IPv6 address of member threat protection service.
	Ipv6address string `json:"ipv6address,omitempty"`

	// The list of NAT rules.
	NatRules []*ThreatprotectionNatrule `json:"nat_rules,omitempty"`

	// Outbound settings for ATP events.
	OutboundSettings *SettingAtpoutbound `json:"outbound_settings,omitempty"`

	// The Threat Protection profile associated with the member.
	Profile *string `json:"profile,omitempty"`

	// Use flag for: current_ruleset
	UseCurrentRuleset *bool `json:"use_current_ruleset,omitempty"`

	// Use flag for: disable_multiple_dns_tcp_request
	UseDisableMultipleDnsTcpRequest *bool `json:"use_disable_multiple_dns_tcp_request,omitempty"`

	// Use flag for: enable_accel_resp_before_threat_protection
	UseEnableAccelRespBeforeThreatProtection *bool `json:"use_enable_accel_resp_before_threat_protection,omitempty"`

	// Use flag for: enable_nat_rules
	UseEnableNatRules *bool `json:"use_enable_nat_rules,omitempty"`

	// Use flag for: events_per_second_per_rule
	UseEventsPerSecondPerRule *bool `json:"use_events_per_second_per_rule,omitempty"`

	// Use flag for: outbound_settings
	UseOutboundSettings *bool `json:"use_outbound_settings,omitempty"`
}

func (MemberThreatprotection) ObjectType() string {
	return "member:threatprotection"
}

func (obj MemberThreatprotection) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// Memberdfp represents Infoblox object memberdfp.
// This object represnts DFP fields at member level
type Memberdfp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Option to resolve DNS query if resolution over Active Trust Cloud failed.
	DfpForwardFirst *bool `json:"dfp_forward_first,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Host name of the parent Member
	HostName string `json:"host_name,omitempty"`

	// DFP override lock'.
	IsDfpOverride *bool `json:"is_dfp_override,omitempty"`
}

func (Memberdfp) ObjectType() string {
	return "memberdfp"
}

func (obj Memberdfp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// Msserver represents Infoblox object msserver.
// This object represents the Microsoft Server.
type Msserver struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Active Directory domain to which this server belongs (if applicable).
	AdDomain string `json:"ad_domain,omitempty"`

	// The Active Directory Sites information
	AdSites *Adsites `json:"ad_sites,omitempty"`

	// The Active Directory User synchronization information.
	AdUser *MsserverAduser `json:"ad_user,omitempty"`

	// The address or FQDN of the server.
	Address *string `json:"address,omitempty"`

	// User comments for this Microsoft Server
	Comment *string `json:"comment,omitempty"`

	// Result of the last RPC connection attempt made
	ConnectionStatus string `json:"connection_status,omitempty"`

	// Detail of the last connection attempt made
	ConnectionStatusDetail string `json:"connection_status_detail,omitempty"`

	// RW fields needed for DHCP purposes at Microsoft Server level
	DhcpServer *Dhcpserver `json:"dhcp_server,omitempty"`

	// Allow/forbids usage of this Microsoft Server
	Disabled *bool `json:"disabled,omitempty"`

	// Structure containing DNS information
	DnsServer *Dnsserver `json:"dns_server,omitempty"`

	// Reference to the DNS view
	DnsView *string `json:"dns_view,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// eference to the assigned grid member
	GridMember *string `json:"grid_member,omitempty"`

	// Timestamp of the last message received
	LastSeen *UnixTime `json:"last_seen,omitempty"`

	// Directs logging of sync messages either to syslog or mslog
	LogDestination string `json:"log_destination,omitempty"`

	// Log level for this Microsoft Server
	LogLevel string `json:"log_level,omitempty"`

	// Microsoft Server login name, with optional domainname
	LoginName *string `json:"login_name,omitempty"`

	// Microsoft Server login password
	LoginPassword *string `json:"login_password,omitempty"`

	// Hostname of grid member managing this Microsoft Server
	ManagingMember string `json:"managing_member,omitempty"`

	// Maximum number of connections to MS server
	MsMaxConnection *uint32 `json:"ms_max_connection,omitempty"`

	// Timeout in seconds of RPC connections for this MS Server
	MsRpcTimeoutInSeconds *uint32 `json:"ms_rpc_timeout_in_seconds,omitempty"`

	// Reference to the network view
	NetworkView *string `json:"network_view,omitempty"`

	// Enable read-only management for this Microsoft Server
	ReadOnly *bool `json:"read_only,omitempty"`

	// The root Active Directory domain to which this server belongs (if
	// applicable).
	RootAdDomain string `json:"root_ad_domain,omitempty"`

	// Gives the server name as reported by itself
	ServerName string `json:"server_name,omitempty"`

	// Minimum number of minutes between two synchronizations
	SynchronizationMinDelay *uint32 `json:"synchronization_min_delay,omitempty"`

	// Synchronization status summary
	SynchronizationStatus string `json:"synchronization_status,omitempty"`

	// Detail status if synchronization_status is ERROR
	SynchronizationStatusDetail string `json:"synchronization_status_detail,omitempty"`

	// Override log_destination inherited from grid level
	UseLogDestination *bool `json:"use_log_destination,omitempty"`

	// Override grid ms_max_connection setting
	UseMsMaxConnection *bool `json:"use_ms_max_connection,omitempty"`

	// Flag to override cluster RPC timeout
	UseMsRpcTimeoutInSeconds *bool `json:"use_ms_rpc_timeout_in_seconds,omitempty"`

	// Version of the Microsoft Server
	Version string `json:"version,omitempty"`
}

func (Msserver) ObjectType() string {
	return "msserver"
}

func (obj Msserver) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address"}
	}
	return obj.returnFields
}

// MsserverAdsitesDomain represents Infoblox object msserver:adsites:domain.
// The object provides information about the Active Directory Domain.
type MsserverAdsitesDomain struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the Extensible Attribute Definition object that is linked to the
	// Active Directory Sites Domain.
	EaDefinition string `json:"ea_definition,omitempty"`

	// The IP address or FQDN of the managing master for the MS server, if
	// applicable.
	MsSyncMasterName string `json:"ms_sync_master_name,omitempty"`

	// The name of the Active Directory Domain properties object.
	Name string `json:"name,omitempty"`

	// The NetBIOS name of the Active Directory Domain properties object.
	Netbios string `json:"netbios,omitempty"`

	// The name of the network view in which the Active Directory Domain resides.
	NetworkView string `json:"network_view,omitempty"`

	// Determines whether the Active Directory Domain properties object is a
	// read-only object.
	ReadOnly bool `json:"read_only,omitempty"`
}

func (MsserverAdsitesDomain) ObjectType() string {
	return "msserver:adsites:domain"
}

func (obj MsserverAdsitesDomain) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "netbios", "network_view"}
	}
	return obj.returnFields
}

// MsserverAdsitesSite represents Infoblox object msserver:adsites:site.
// This object provides information about the Active Directory Site.
type MsserverAdsitesSite struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The reference to the Active Directory Domain to which the site belongs.
	Domain *string `json:"domain,omitempty"`

	// The name of the site properties object for the Active Directory Sites.
	Name *string `json:"name,omitempty"`

	// The list of networks to which the device interfaces belong.
	Networks []*Ipv4Network `json:"networks,omitempty"`
}

func (MsserverAdsitesSite) ObjectType() string {
	return "msserver:adsites:site"
}

func (obj MsserverAdsitesSite) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"domain", "name"}
	}
	return obj.returnFields
}

// MsserverDhcp represents Infoblox object msserver:dhcp.
// This object represents a subset of the Microsoft Server DHCP properties.
type MsserverDhcp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The address or FQDN of the DHCP Microsoft Server.
	Address string `json:"address,omitempty"`

	// Comment from Microsoft Server
	Comment string `json:"comment,omitempty"`

	// The percentage of the total DHCP utilization of DHCP objects belonging to
	// the DHCP Microsoft Server multiplied by 1000. This is the percentage of the
	// total number of available IP addresses from all the DHCP objects belonging
	// to the DHCP Microsoft Server versus the total number of all IP addresses in
	// all of the DHCP objects on the DHCP Microsoft Server.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of DHCP objects that belong to the
	// DHCP Microsoft Server.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// The total number of DHCP leases issued for the DHCP objects on the DHCP
	// Microsoft Server.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// Timestamp of the last synchronization attempt
	LastSyncTs *UnixTime `json:"last_sync_ts,omitempty"`

	// The login name of the DHCP Microsoft Server.
	LoginName *string `json:"login_name,omitempty"`

	// The login password of the DHCP Microsoft Server.
	LoginPassword *string `json:"login_password,omitempty"`

	// Network view to update
	NetworkView string `json:"network_view,omitempty"`

	// Defines what control to apply on the DHCP server
	NextSyncControl string `json:"next_sync_control,omitempty"`

	// Whether Microsoft server is read only
	ReadOnly bool `json:"read_only,omitempty"`

	// Microsoft server address
	ServerName string `json:"server_name,omitempty"`

	// The number of static DHCP addresses configured in DHCP objects that belong
	// to the DHCP Microsoft Server.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// Status of the Microsoft DHCP Service
	Status string `json:"status,omitempty"`

	// Detailed status of the DHCP status
	StatusDetail string `json:"status_detail,omitempty"`

	// Timestamp of the last update
	StatusLastUpdated *UnixTime `json:"status_last_updated,omitempty"`

	// Flag indicating if the DHCP supports Failover
	SupportsFailover bool `json:"supports_failover,omitempty"`

	// The minimum number of minutes between two synchronizations.
	SynchronizationInterval *uint32 `json:"synchronization_interval,omitempty"`

	// The total number of DHCP addresses configured in DHCP objects that belong to
	// the DHCP Microsoft Server.
	TotalHosts uint32 `json:"total_hosts,omitempty"`

	// Use flag for: login_name , login_password
	UseLogin *bool `json:"use_login,omitempty"`

	// Use flag for: synchronization_interval
	UseSynchronizationInterval *bool `json:"use_synchronization_interval,omitempty"`
}

func (MsserverDhcp) ObjectType() string {
	return "msserver:dhcp"
}

func (obj MsserverDhcp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address"}
	}
	return obj.returnFields
}

// MsserverDns represents Infoblox object msserver:dns.
// This object represents a subset of the Microsoft Server DNS properties.
type MsserverDns struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The address or FQDN of the DNS Microsoft Server.
	Address string `json:"address,omitempty"`

	// Determines if synchronization of DNS reporting data from the Microsoft
	// server is enabled or not.
	EnableDnsReportsSync *bool `json:"enable_dns_reports_sync,omitempty"`

	// The login name of the DNS Microsoft Server.
	LoginName *string `json:"login_name,omitempty"`

	// The login password of the DNS Microsoft Server.
	LoginPassword *string `json:"login_password,omitempty"`

	// The minimum number of minutes between two synchronizations.
	SynchronizationInterval *uint32 `json:"synchronization_interval,omitempty"`

	// Use flag for: enable_dns_reports_sync
	UseEnableDnsReportsSync *bool `json:"use_enable_dns_reports_sync,omitempty"`

	// Use flag for: login_name , login_password
	UseLogin *bool `json:"use_login,omitempty"`

	// Use flag for: synchronization_interval
	UseSynchronizationInterval *bool `json:"use_synchronization_interval,omitempty"`
}

func (MsserverDns) ObjectType() string {
	return "msserver:dns"
}

func (obj MsserverDns) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address"}
	}
	return obj.returnFields
}

// Mssuperscope represents Infoblox object mssuperscope.
// This object represents a superscope feature of Microsoft DHCP server. You
// can use a superscope to group and activate multiple ranges via a single
// object.
type Mssuperscope struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The superscope descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The percentage of the total DHCP usage of the ranges in the superscope.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// Utilization level of the DHCP range objects that belong to the superscope.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// Determines whether the superscope is disabled.
	Disable *bool `json:"disable,omitempty"`

	// The total number of DHCP leases issued for the DHCP range objects that
	// belong to the superscope.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The percentage value for DHCP range usage after which an alarm will be
	// active.
	HighWaterMark uint32 `json:"high_water_mark,omitempty"`

	// The percentage value for DHCP range usage after which an alarm will be
	// reset.
	HighWaterMarkReset uint32 `json:"high_water_mark_reset,omitempty"`

	// The percentage value for DHCP range usage below which an alarm will be
	// active.
	LowWaterMark uint32 `json:"low_water_mark,omitempty"`

	// The percentage value for DHCP range usage below which an alarm will be
	// reset.
	LowWaterMarkReset uint32 `json:"low_water_mark_reset,omitempty"`

	// The name of the Microsoft DHCP superscope.
	Name *string `json:"name,omitempty"`

	// The name of the network view in which the superscope resides.
	NetworkView *string `json:"network_view,omitempty"`

	// The list of DHCP ranges that are associated with the superscope.
	Ranges []*Range `json:"ranges,omitempty"`

	// The number of static DHCP addresses configured in DHCP range objects that
	// belong to the superscope.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The total number of DHCP addresses configured in DHCP range objects that
	// belong to the superscope.
	TotalHosts uint32 `json:"total_hosts,omitempty"`
}

func (Mssuperscope) ObjectType() string {
	return "mssuperscope"
}

func (obj Mssuperscope) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"disable", "name", "network_view"}
	}
	return obj.returnFields
}

// Namedacl represents Infoblox object namedacl.
// A named ACL (Access Control List) is a list of IPv4/IPv6 addresses,
// networks, TSIG-based anonymous access controls, and other named ACLs, to
// which you can grant or deny permission for operations such as dynamic DNS
// updates or zone transfers.
type Namedacl struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The access control list of IPv4/IPv6 addresses, networks, TSIG-based
	// anonymous access controls, and other named ACLs.
	AccessList []*Addressac `json:"access_list,omitempty"`

	// Comment for the named ACL; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The exploded access list for the named ACL. This list displays all the
	// access control entries in a named ACL and its nested named ACLs, if
	// applicable.
	ExplodedAccessList []*Addressac `json:"exploded_access_list,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the named ACL.
	Name *string `json:"name,omitempty"`
}

func (Namedacl) ObjectType() string {
	return "namedacl"
}

func (obj Namedacl) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Natgroup represents Infoblox object natgroup.
// NAT groups are necessary if the Grid master is behind a NAT device and there
// are members behind both side of the NAT device. Any member on the same side
// as the master goes into the same NAT group as the master and uses its
// interface address for Grid communication. Grid members on the other side of
// that NAT device do not go into the same NAT group as the master and use the
// master’s NAT address for Grid communication.
type Natgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The NAT group descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The name of a NAT group object.
	Name *string `json:"name,omitempty"`
}

func (Natgroup) ObjectType() string {
	return "natgroup"
}

func (obj Natgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Ipv4Network represents Infoblox object network.
// When DHCP services are configured on an appliance, the network that it
// serves must be defined. After a network is created, you can either create
// all the subnets individually, or create a parent network that encompasses
// the subnets.
type Ipv4Network struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Authority for the DHCP network.
	Authority *bool `json:"authority,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone bool `json:"auto_create_reversezone,omitempty"`

	// The bootfile name for the network. You can configure the DHCP server to
	// support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the network. You can specify the name and/or IP
	// address of the boot server that the host needs to boot. The boot server IPv4
	// Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the network, maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The number of conflicts discovered via network discovery.
	ConflictCount uint32 `json:"conflict_count,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP clients requests. Note that changes for this field
	// take effect only if ddns_use_option81 is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network object. The TTL is
	// a 32-bit unsigned integer that represents the duration, in seconds, for
	// which the update is cached. Zero indicates that the update is not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// By default, the DHCP server does not update DNS when it allocates a fixed
	// address to a client. You can configure the DHCP server to update the A and
	// PTR records of a client with a fixed address. When this feature is enabled
	// and the DHCP server adds A and PTR records for a fixed address, the DHCP
	// server never discards the records.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// The support for DHCP Option 81 at the network level.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// The reason for deleting the RIR registration request.
	DeleteReason *string `json:"delete_reason,omitempty"`

	// If set to true, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The percentage of the total DHCP utilization of the network multiplied by
	// 1000. This is the percentage of the total number of available IP addresses
	// belonging to the network versus the total number of all IP addresses in
	// network.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of the network.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// Determines whether a network is disabled or not. When this is set to False,
	// the network is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Discover now status for this network.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// Number of the discovered BGP AS. When multiple BGP autonomous systems are
	// discovered in the network, this field displays "Multiple".
	DiscoveredBgpAs string `json:"discovered_bgp_as,omitempty"`

	// Discovered bridge domain.
	DiscoveredBridgeDomain *string `json:"discovered_bridge_domain,omitempty"`

	// Discovered tenant.
	DiscoveredTenant *string `json:"discovered_tenant,omitempty"`

	// The identifier of the discovered VLAN. When multiple VLANs are discovered in
	// the network, this field displays "Multiple".
	DiscoveredVlanId string `json:"discovered_vlan_id,omitempty"`

	// The name of the discovered VLAN. When multiple VLANs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVlanName string `json:"discovered_vlan_name,omitempty"`

	// Description of the discovered VRF. When multiple VRFs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVrfDescription string `json:"discovered_vrf_description,omitempty"`

	// The name of the discovered VRF. When multiple VRFs are discovered in the
	// network, this field displays "Multiple".
	DiscoveredVrfName string `json:"discovered_vrf_name,omitempty"`

	// Route distinguisher of the discovered VRF. When multiple VRFs are discovered
	// in the network, this field displays "Multiple".
	DiscoveredVrfRd string `json:"discovered_vrf_rd,omitempty"`

	// The discovery basic poll settings for this network.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this network.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The network discovery engine type.
	DiscoveryEngineType string `json:"discovery_engine_type,omitempty"`

	// The member that will run discovery for this network.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// The total number of DHCP leases issued for the network.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// The e-mail lists to which the appliance sends DHCP threshold alarm e-mail
	// messages.
	EmailList []string `json:"email_list,omitempty"`

	// The dynamic DNS updates flag of a DHCP network object. If set to True, the
	// DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if DHCP thresholds are enabled for the network.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines whether a discovery is enabled or not for this network. When this
	// is set to False, the network discovery is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if DHCP threshold warnings are sent through email.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Determines if IFMAP publishing is enabled for the network.
	EnableIfmapPublishing *bool `json:"enable_ifmap_publishing,omitempty"`

	// Determines if the discovery for the network should be immediately enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Determines if DHCP threshold warnings are send through SNMP.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// The endpoints that provides data for the DHCP Network object.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The percentage of DHCP network usage threshold above which network usage is
	// not expected and may warrant your attention. When the high watermark is
	// reached, the Infoblox appliance generates a syslog message and sends a
	// warning (if enabled). A number that specifies the percentage of allocated
	// addresses. The range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// The percentage of DHCP network usage below which the corresponding SNMP trap
	// is reset. A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses. Valid values are "NONE", "CLIENT", or "MACADDR". The default is
	// "NONE".
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// The e-mail lists to which the appliance sends IPAM threshold alarm e-mail
	// messages.
	IpamEmailAddresses []string `json:"ipam_email_addresses,omitempty"`

	// The IPAM Threshold settings for this network.
	IpamThresholdSettings *SettingIpamThreshold `json:"ipam_threshold_settings,omitempty"`

	// The IPAM Trap settings for this network.
	IpamTrapSettings *SettingIpamTrap `json:"ipam_trap_settings,omitempty"`

	// The IPv4 Address of the network.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The timestamp when the last RIR registration update was sent.
	LastRirRegistrationUpdateSent *UnixTime `json:"last_rir_registration_update_sent,omitempty"`

	// Last RIR registration update status.
	LastRirRegistrationUpdateStatus string `json:"last_rir_registration_update_status,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied on the this network.
	// This list corresponds to the match rules that are written to the dhcpd
	// configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The percentage of DHCP network usage below which the Infoblox appliance
	// generates a syslog message and sends a warning (if enabled). A number that
	// specifies the percentage of allocated addresses. The range is from 1 to 100.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// The percentage of DHCP network usage threshold below which network usage is
	// not expected and may warrant your attention. When the low watermark is
	// crossed, the Infoblox appliance generates a syslog message and sends a
	// warning (if enabled). A number that specifies the percentage of allocated
	// addresses. The range is from 1 to 100. The low watermark reset value must be
	// higher than the low watermark value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// A list of members or Microsoft (r) servers that serve DHCP for this network.
	// All members in the array must be of the same type. The struct type must be
	// indicated in each element, by setting the "_struct" member to the struct
	// type.
	Members []*Msdhcpserver `json:"members,omitempty"`

	// This field controls whether this object is synchronized with the Multi-Grid
	// Master. If this field is set to True, objects are not synchronized.
	MgmPrivate *bool `json:"mgm_private,omitempty"`

	// This field is assumed to be True unless filled by any conforming objects,
	// such as Network, IPv6 Network, Network Container, IPv6 Network Container,
	// and Network View. This value is set to False if mgm_private is set to True
	// in the parent object.
	MgmPrivateOverridable bool `json:"mgm_private_overridable,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The netmask of the network in CIDR format.
	Netmask *uint32 `json:"netmask,omitempty"`

	// The network address in IPv4 Address/CIDR format. For regular expression
	// searches, only the IPv4 Address portion is supported. Searches for the CIDR
	// portion is always an exact match. For example, both network containers
	// 10.0.0.0/8 and 20.1.0.0/16 are matched by expression '.0' and only
	// 20.1.0.0/16 is matched by '.0/16'.
	Network *string `json:"network,omitempty"`

	// The network container to which this network belongs (if any).
	NetworkContainer string `json:"network_container,omitempty"`

	// The name of the network view in which this network resides.
	NetworkView string `json:"network_view,omitempty"`

	// The name in FQDN and/or IPv4 Address of the next server that the host needs
	// to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The port control blackout setting for this network.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// The PXE lease time value of a DHCP Network object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The registry (RIR) that allocated the network address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization assoicated with the network.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The RIR registration action.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the network in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// The number of static DHCP addresses configured in the network.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The DHCP Network Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// If set on creation, the network is created according to the values specified
	// in the selected template.
	Template string `json:"template,omitempty"`

	// The total number of DHCP addresses configured in the network.
	TotalHosts uint32 `json:"total_hosts,omitempty"`

	// Determines whether the DHCP IPv4 Network is unmanaged or not.
	Unmanaged *bool `json:"unmanaged,omitempty"`

	// The number of unmanaged IP addresses as discovered by network discovery.
	UnmanagedCount uint32 `json:"unmanaged_count,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: authority
	UseAuthority *bool `json:"use_authority,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_update_fixed_addresses
	UseDdnsUpdateFixedAddresses *bool `json:"use_ddns_update_fixed_addresses,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: enable_ifmap_publishing
	UseEnableIfmapPublishing *bool `json:"use_enable_ifmap_publishing,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ignore_id
	UseIgnoreId *bool `json:"use_ignore_id,omitempty"`

	// Use flag for: ipam_email_addresses
	UseIpamEmailAddresses *bool `json:"use_ipam_email_addresses,omitempty"`

	// Use flag for: ipam_threshold_settings
	UseIpamThresholdSettings *bool `json:"use_ipam_threshold_settings,omitempty"`

	// Use flag for: ipam_trap_settings
	UseIpamTrapSettings *bool `json:"use_ipam_trap_settings,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: mgm_private
	UseMgmPrivate *bool `json:"use_mgm_private,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: zone_associations
	UseZoneAssociations *bool `json:"use_zone_associations,omitempty"`

	// The network utilization in percentage.
	Utilization uint32 `json:"utilization,omitempty"`

	// The timestamp when the utilization statistics were last updated.
	UtilizationUpdate *UnixTime `json:"utilization_update,omitempty"`

	// List of VLANs assigned to Network.
	Vlans []*Vlanlink `json:"vlans,omitempty"`

	// The list of zones associated with this network.
	ZoneAssociations []*Zoneassociation `json:"zone_associations,omitempty"`
}

func (Ipv4Network) ObjectType() string {
	return "network"
}

func (obj Ipv4Network) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "network", "network_view"}
	}
	return obj.returnFields
}

// NetworkDiscovery represents Infoblox object network_discovery.
// This object can be used to control the network discovery process.
type NetworkDiscovery struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`
}

func (NetworkDiscovery) ObjectType() string {
	return "network_discovery"
}

func (obj NetworkDiscovery) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// Ipv4NetworkContainer represents Infoblox object networkcontainer.
// A network can contain child networks. The network that contains child
// networks is called a network container. This object encapsulates an IPv4
// network container object.
type Ipv4NetworkContainer struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Authority for the DHCP network container.
	Authority *bool `json:"authority,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone bool `json:"auto_create_reversezone,omitempty"`

	// The boot server IPv4 Address or name in FQDN format for the network
	// container. You can specify the name and/or IP address of the boot server
	// that the host needs to boot.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the network container. You can specify the name
	// and/or IP address of the boot server that the host needs to boot. The boot
	// server IPv4 Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the network container; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network container.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether the DHCP server is allowed to update DNS,
	// regardless of the DHCP client requests. Note that changes for this field
	// take effect only if ddns_use_option81 is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network container object.
	// The TTL is a 32-bit unsigned integer that represents the duration, in
	// seconds, for which the update is cached. Zero indicates that the update is
	// not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// By default, the DHCP server does not update DNS when it allocates a fixed
	// address to a client. You can configure the DHCP server to update the A and
	// PTR records of a client with a fixed address. When this feature is enabled
	// and the DHCP server adds A and PTR records for a fixed address, the DHCP
	// server never discards the records.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// The support for DHCP Option 81 at the network container level.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// The reason for deleting the RIR registration request.
	DeleteReason *string `json:"delete_reason,omitempty"`

	// If set to True, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// Discover now status for this network container.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovery basic poll settings for this network container.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this network container.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The network discovery engine type.
	DiscoveryEngineType string `json:"discovery_engine_type,omitempty"`

	// The member that will run discovery for this network container.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// The e-mail lists to which the appliance sends DHCP threshold alarm e-mail
	// messages.
	EmailList []string `json:"email_list,omitempty"`

	// The dynamic DNS updates flag of a DHCP network container object. If set to
	// True, the DHCP server sends DDNS updates to DNS servers in the same Grid,
	// and to external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if DHCP thresholds are enabled for the network container.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines whether a discovery is enabled or not for this network container.
	// When this is set to False, the network container discovery is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if DHCP threshold warnings are sent through email.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Determines if the discovery for the network container should be immediately
	// enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Determines if DHCP threshold warnings are send through SNMP.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// The endpoints that provides data for the DHCP Network Container object.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The percentage of DHCP network container usage threshold above which network
	// container usage is not expected and may warrant your attention. When the
	// high watermark is reached, the Infoblox appliance generates a syslog message
	// and sends a warning (if enabled). A number that specifies the percentage of
	// allocated addresses. The range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// The percentage of DHCP network container usage below which the corresponding
	// SNMP trap is reset. A number that specifies the percentage of allocated
	// addresses. The range is from 1 to 100. The high watermark reset value must
	// be lower than the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses.
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// The e-mail lists to which the appliance sends IPAM threshold alarm e-mail
	// messages.
	IpamEmailAddresses []string `json:"ipam_email_addresses,omitempty"`

	// The IPAM Threshold settings for this network container.
	IpamThresholdSettings *SettingIpamThreshold `json:"ipam_threshold_settings,omitempty"`

	// The IPAM Trap settings for this network container.
	IpamTrapSettings *SettingIpamTrap `json:"ipam_trap_settings,omitempty"`

	// The timestamp when the last RIR registration update was sent.
	LastRirRegistrationUpdateSent *UnixTime `json:"last_rir_registration_update_sent,omitempty"`

	// Last RIR registration update status.
	LastRirRegistrationUpdateStatus string `json:"last_rir_registration_update_status,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied on the this network
	// container. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The percentage of DHCP network container usage below which the Infoblox
	// appliance generates a syslog message and sends a warning (if enabled). A
	// number that specifies the percentage of allocated addresses. The range is
	// from 1 to 100.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// The percentage of DHCP network container usage threshold below which network
	// container usage is not expected and may warrant your attention. When the low
	// watermark is crossed, the Infoblox appliance generates a syslog message and
	// sends a warning (if enabled). A number that specifies the percentage of
	// allocated addresses. The range is from 1 to 100. The low watermark reset
	// value must be higher than the low watermark value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// This field controls whether this object is synchronized with the Multi-Grid
	// Master. If this field is set to True, objects are not synchronized.
	MgmPrivate *bool `json:"mgm_private,omitempty"`

	// This field is assumed to be True unless filled by any conforming objects,
	// such as Network, IPv6 Network, Network Container, IPv6 Network Container,
	// and Network View. This value is set to False if mgm_private is set to True
	// in the parent object.
	MgmPrivateOverridable bool `json:"mgm_private_overridable,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network address in IPv4 Address/CIDR format. For regular expression
	// searches, only the IPv4 Address portion is supported. Searches for the CIDR
	// portion is always an exact match. For example, both network containers
	// 10.0.0.0/8 and 20.1.0.0/16 are matched by expression '.0' and only
	// 20.1.0.0/16 is matched by '.0/16'.
	Network string `json:"network,omitempty"`

	// The network container to which this network belongs, if any.
	NetworkContainer string `json:"network_container,omitempty"`

	// The name of the network view in which this network resides.
	NetworkView string `json:"network_view,omitempty"`

	// The name in FQDN and/or IPv4 Address of the next server that the host needs
	// to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The port control blackout setting for this network container.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// The PXE lease time value of a DHCP Network container object. Some hosts use
	// PXE (Preboot Execution Environment) to boot remotely from a server. To
	// better manage your IP resources, set a different lease time for PXE boot
	// requests. You can configure the DHCP server to allocate an IP address with a
	// shorter lease time to hosts that send PXE boot requests, so IP addresses are
	// not leased longer than necessary. A 32-bit unsigned integer that represents
	// the duration, in seconds, for which the update is cached. Zero indicates
	// that the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// Remove subnets delete option. Determines whether all child objects should be
	// removed alongside with the network container or child objects should be
	// assigned to another parental container. By default child objects are deleted
	// with the network container.
	RemoveSubnets bool `json:"remove_subnets,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The registry (RIR) that allocated the network container address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization assoicated with the network container.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The RIR registration action.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the network container in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// The DHCP Network Container Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// Determines whether the network container is unmanaged or not.
	Unmanaged *bool `json:"unmanaged,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: authority
	UseAuthority *bool `json:"use_authority,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_update_fixed_addresses
	UseDdnsUpdateFixedAddresses *bool `json:"use_ddns_update_fixed_addresses,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ignore_id
	UseIgnoreId *bool `json:"use_ignore_id,omitempty"`

	// Use flag for: ipam_email_addresses
	UseIpamEmailAddresses *bool `json:"use_ipam_email_addresses,omitempty"`

	// Use flag for: ipam_threshold_settings
	UseIpamThresholdSettings *bool `json:"use_ipam_threshold_settings,omitempty"`

	// Use flag for: ipam_trap_settings
	UseIpamTrapSettings *bool `json:"use_ipam_trap_settings,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: mgm_private
	UseMgmPrivate *bool `json:"use_mgm_private,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`

	// Use flag for: zone_associations
	UseZoneAssociations *bool `json:"use_zone_associations,omitempty"`

	// The network container utilization in percentage.
	Utilization uint32 `json:"utilization,omitempty"`

	// The list of zones associated with this network.
	ZoneAssociations []*Zoneassociation `json:"zone_associations,omitempty"`
}

func (Ipv4NetworkContainer) ObjectType() string {
	return "networkcontainer"
}

func (obj Ipv4NetworkContainer) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "network", "network_view"}
	}
	return obj.returnFields
}

// NetworkTemplate represents Infoblox object networktemplate.
// The network template used to create networks in a quick and consistent way.
// Networks created from a network template inherit all the properties defined
// in the network template, except for the comment and netmask that can be
// defined in the network.
type NetworkTemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This flag controls whether the template allows any netmask. You must specify
	// a netmask when creating a network using this template. If you set this
	// parameter to false, you must specify the "netmask" field for the network
	// template object.
	AllowAnyNetmask *bool `json:"allow_any_netmask,omitempty"`

	// Authority for the DHCP network.
	Authority *bool `json:"authority,omitempty"`

	// This flag controls whether reverse zones are automatically created when the
	// network is added.
	AutoCreateReversezone *bool `json:"auto_create_reversezone,omitempty"`

	// The boot server IPv4 Address or name in FQDN format for the network. You can
	// specify the name and/or IP address of the boot server that the host needs to
	// boot.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the network. You can specify the name and/or IP
	// address of the boot server that the host needs to boot. The boot server IPv4
	// Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// This flag controls whether this template can be used to create network
	// objects in a cloud-computing deployment.
	CloudApiCompatible *bool `json:"cloud_api_compatible,omitempty"`

	// Comment for the network; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this network.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether the DHCP server is allowed to update DNS,
	// regardless of the DHCP client requests. Note that changes for this field
	// take effect only if ddns_use_option81 is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a DHCP network object. The TTL is
	// a 32-bit unsigned integer that represents the duration, in seconds, for
	// which the update is cached. Zero indicates that the update is not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// By default, the DHCP server does not update DNS when it allocates a fixed
	// address to a client. You can configure the DHCP server to update the A and
	// PTR records of a client with a fixed address. When this feature is enabled
	// and the DHCP server adds A and PTR records for a fixed address, the DHCP
	// server never discards the records.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// The support for DHCP Option 81 at the network level.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// Reference the Cloud Platform Appliance to which authority of the object
	// should be delegated when the object is created using the template.
	DelegatedMember *Dhcpmember `json:"delegated_member,omitempty"`

	// If set to True, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The e-mail lists to which the appliance sends DHCP threshold alarm e-mail
	// messages.
	EmailList []string `json:"email_list,omitempty"`

	// The dynamic DNS updates flag of a DHCP network object. If set to True, the
	// DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if DHCP thresholds are enabled for the network.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines if DHCP threshold warnings are sent through email.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Determines if DHCP threshold warnings are send through SNMP.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of fixed address templates assigned to this network template
	// object. When you create a network based on a network template object that
	// contains fixed address templates, the fixed addresses are created based on
	// the associated fixed address templates.
	FixedAddressTemplates []string `json:"fixed_address_templates,omitempty"`

	// The percentage of DHCP network usage threshold above which network usage is
	// not expected and may warrant your attention. When the high watermark is
	// reached, the Infoblox appliance generates a syslog message and sends a
	// warning (if enabled). A number that specifies the percentage of allocated
	// addresses. The range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// The percentage of DHCP network usage below which the corresponding SNMP trap
	// is reset. A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// The e-mail lists to which the appliance sends IPAM threshold alarm e-mail
	// messages.
	IpamEmailAddresses []string `json:"ipam_email_addresses,omitempty"`

	// The IPAM Threshold settings for this network template.
	IpamThresholdSettings *SettingIpamThreshold `json:"ipam_threshold_settings,omitempty"`

	// The IPAM Trap settings for this network template.
	IpamTrapSettings *SettingIpamTrap `json:"ipam_trap_settings,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied on the this network
	// template. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The percentage of DHCP network usage below which the Infoblox appliance
	// generates a syslog message and sends a warning (if enabled). A number that
	// specifies the percentage of allocated addresses. The range is from 1 to 100.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// The percentage of DHCP network usage threshold below which network usage is
	// not expected and may warrant your attention. When the low watermark is
	// crossed, the Infoblox appliance generates a syslog message and sends a
	// warning (if enabled). A number that specifies the percentage of allocated
	// addresses. The range is from 1 to 100. The low watermark reset value must be
	// higher than the low watermark value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// A list of members or Microsoft (r) servers that serve DHCP for this network.
	// All members in the array must be of the same type. The struct type must be
	// indicated in each element, by setting the "_struct" member to the struct
	// type.
	Members []*Msdhcpserver `json:"members,omitempty"`

	// The name of this network template.
	Name *string `json:"name,omitempty"`

	// The netmask of the network in CIDR format.
	Netmask *uint32 `json:"netmask,omitempty"`

	// The name in FQDN and/or IPv4 Address of the next server that the host needs
	// to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The PXE lease time value of a DHCP Network object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// The list of IP address range templates assigned to this network template
	// object. When you create a network based on a network template object that
	// contains range templates, the IP address ranges are created based on the
	// associated IP address range templates.
	RangeTemplates []string `json:"range_templates,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// THe registry (RIR) that allocated the network address space.
	Rir string `json:"rir,omitempty"`

	// The RIR organization assoicated with the network.
	RirOrganization *string `json:"rir_organization,omitempty"`

	// The RIR registration action.
	RirRegistrationAction string `json:"rir_registration_action,omitempty"`

	// The registration status of the network in RIR.
	RirRegistrationStatus string `json:"rir_registration_status,omitempty"`

	// Determines whether to send the RIR registration request.
	SendRirRequest *bool `json:"send_rir_request,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: authority
	UseAuthority *bool `json:"use_authority,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_update_fixed_addresses
	UseDdnsUpdateFixedAddresses *bool `json:"use_ddns_update_fixed_addresses,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ipam_email_addresses
	UseIpamEmailAddresses *bool `json:"use_ipam_email_addresses,omitempty"`

	// Use flag for: ipam_threshold_settings
	UseIpamThresholdSettings *bool `json:"use_ipam_threshold_settings,omitempty"`

	// Use flag for: ipam_trap_settings
	UseIpamTrapSettings *bool `json:"use_ipam_trap_settings,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`
}

func (NetworkTemplate) ObjectType() string {
	return "networktemplate"
}

func (obj NetworkTemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Networkuser represents Infoblox object networkuser.
// The DHCP Network User object provides information about Active Directory
// users such as user session for a specific IP address, domain, login and
// logout timestamps.
type Networkuser struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IPv4 Address or IPv6 Address of the Network User.
	Address *string `json:"address,omitempty"`

	// The reference of the IPAM IPv4Address or IPv6Address object describing the
	// address of the Network User.
	AddressObject string `json:"address_object,omitempty"`

	// The Network User data source.
	DataSource string `json:"data_source,omitempty"`

	// The Network User data source IPv4 Address or IPv6 Address or FQDN address.
	DataSourceIp string `json:"data_source_ip,omitempty"`

	// The domain name of the Network User.
	Domainname *string `json:"domainname,omitempty"`

	// The first seen timestamp of the Network User.
	FirstSeenTime *UnixTime `json:"first_seen_time,omitempty"`

	// The group identifier of the Network User.
	Guid *string `json:"guid,omitempty"`

	// The last seen timestamp of the Network User.
	LastSeenTime *UnixTime `json:"last_seen_time,omitempty"`

	// The last updated timestamp of the Network User.
	LastUpdatedTime *UnixTime `json:"last_updated_time,omitempty"`

	// The logon identifier of the Network User.
	LogonId *string `json:"logon_id,omitempty"`

	// The logout timestamp of the Network User.
	LogoutTime *UnixTime `json:"logout_time,omitempty"`

	// The name of the Network User.
	Name *string `json:"name,omitempty"`

	// The reference to the network to which the Network User belongs.
	Network string `json:"network,omitempty"`

	// The name of the network view in which this Network User resides.
	NetworkView *string `json:"network_view,omitempty"`

	// The status of the Network User.
	UserStatus string `json:"user_status,omitempty"`
}

func (Networkuser) ObjectType() string {
	return "networkuser"
}

func (obj Networkuser) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "domainname", "name", "network_view", "user_status"}
	}
	return obj.returnFields
}

// NetworkView represents Infoblox object networkview.
// A network view is a single routing domain with its own networks and shared
// networks. A network view can contain both IPv4 and IPv6 networks. All
// networks must belong to a network view.
type NetworkView struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of DNS views associated with this network view.
	AssociatedDnsViews []string `json:"associated_dns_views,omitempty"`

	// The list of members associated with a network view.
	AssociatedMembers []*NetworkviewAssocmember `json:"associated_members,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the network view; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// DNS views that will receive the updates if you enable the appliance to send
	// updates to Grid members.
	DdnsDnsView *string `json:"ddns_dns_view,omitempty"`

	// An array of Ddns Zone Primary dhcpddns structs that lists the information of
	// primary zone to wich DDNS updates should be sent.
	DdnsZonePrimaries []*Dhcpddns `json:"ddns_zone_primaries,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of linked authoritative DNS zones.
	InternalForwardZones []*ZoneAuth `json:"internal_forward_zones,omitempty"`

	// The NIOS appliance provides one default network view. You can rename the
	// default view and change its settings, but you cannot delete it. There must
	// always be at least one network view in the appliance.
	IsDefault bool `json:"is_default,omitempty"`

	// This field controls whether this object is synchronized with the Multi-Grid
	// Master. If this field is set to True, objects are not synchronized.
	MgmPrivate *bool `json:"mgm_private,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// Name of the network view.
	Name *string `json:"name,omitempty"`

	// The list of forward-mapping zones to which the DHCP server sends the
	// updates.
	RemoteForwardZones []*Remoteddnszone `json:"remote_forward_zones,omitempty"`

	// The list of reverse-mapping zones to which the DHCP server sends the
	// updates.
	RemoteReverseZones []*Remoteddnszone `json:"remote_reverse_zones,omitempty"`
}

func (NetworkView) ObjectType() string {
	return "networkview"
}

func (obj NetworkView) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "is_default", "name"}
	}
	return obj.returnFields
}

func NewEmptyNetworkView() *NetworkView {
	res := &NetworkView{}
	res.returnFields = []string{"extattrs", "name", "comment"}
	return res
}

func NewNetworkView(name string, comment string, eas EA, ref string) *NetworkView {
	res := NewEmptyNetworkView()
	res.Name = &name
	res.Comment = &comment
	res.Ea = eas
	res.Ref = ref
	return res
}

// NotificationRestEndpoint represents Infoblox object notification:rest:endpoint.
// The notification REST endpoint object represents settings of particular REST
// API endpoint.
type NotificationRestEndpoint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The client certificate subject of a notification REST endpoint.
	ClientCertificateSubject string `json:"client_certificate_subject,omitempty"`

	// The token returned by the uploadinit function call in object fileop for a
	// notification REST endpoit client certificate.
	ClientCertificateToken *string `json:"client_certificate_token,omitempty"`

	// The timestamp when client certificate for a notification REST endpoint was
	// created.
	ClientCertificateValidFrom *UnixTime `json:"client_certificate_valid_from,omitempty"`

	// The timestamp when client certificate for a notification REST endpoint
	// expires.
	ClientCertificateValidTo *UnixTime `json:"client_certificate_valid_to,omitempty"`

	// The comment of a notification REST endpoint.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The log level for a notification REST endpoint.
	LogLevel string `json:"log_level,omitempty"`

	// The name of a notification REST endpoint.
	Name *string `json:"name,omitempty"`

	// The outbound member which will generate an event.
	OutboundMemberType string `json:"outbound_member_type,omitempty"`

	// The list of members for outbound events.
	OutboundMembers []string `json:"outbound_members,omitempty"`

	// The password of the user that can log into a notification REST endpoint.
	Password *string `json:"password,omitempty"`

	// The server certificate validation type.
	ServerCertValidation string `json:"server_cert_validation,omitempty"`

	// Determines if the sync process is disabled for a notification REST endpoint.
	SyncDisabled *bool `json:"sync_disabled,omitempty"`

	// The notification REST template instance. The parameters of REST API endpoint
	// template instance are prohibited to change.
	TemplateInstance *NotificationRestTemplateinstance `json:"template_instance,omitempty"`

	// The timeout of session management (in seconds).
	Timeout *uint32 `json:"timeout,omitempty"`

	// The URI of a notification REST endpoint.
	Uri *string `json:"uri,omitempty"`

	// The username of the user that can log into a notification REST endpoint.
	Username *string `json:"username,omitempty"`

	// The vendor identifier.
	VendorIdentifier *string `json:"vendor_identifier,omitempty"`

	// The user name for WAPI integration.
	WapiUserName *string `json:"wapi_user_name,omitempty"`

	// The user password for WAPI integration.
	WapiUserPassword *string `json:"wapi_user_password,omitempty"`
}

func (NotificationRestEndpoint) ObjectType() string {
	return "notification:rest:endpoint"
}

func (obj NotificationRestEndpoint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "outbound_member_type", "uri"}
	}
	return obj.returnFields
}

// NotificationRestTemplate represents Infoblox object notification:rest:template.
// The notification REST template object represents settings of particular REST
// API template.
type NotificationRestTemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The action name.
	ActionName string `json:"action_name,omitempty"`

	// The time stamp when a template was added.
	AddedOn *UnixTime `json:"added_on,omitempty"`

	// The comment for this REST API template.
	Comment *string `json:"comment,omitempty"`

	// The JSON formatted content of a template. The data passed by content creates
	// parameters for a template.
	Content *string `json:"content,omitempty"`

	// The event type.
	EventType []string `json:"event_type,omitempty"`

	// The name of a notification REST template.
	Name *string `json:"name,omitempty"`

	// The outbound type for the template.
	OutboundType string `json:"outbound_type,omitempty"`

	// The notification REST template parameters.
	Parameters []*NotificationRestTemplateparameter `json:"parameters,omitempty"`

	// The template type.
	TemplateType string `json:"template_type,omitempty"`

	// The vendor identifier.
	VendorIdentifier string `json:"vendor_identifier,omitempty"`
}

func (NotificationRestTemplate) ObjectType() string {
	return "notification:rest:template"
}

func (obj NotificationRestTemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"content", "name"}
	}
	return obj.returnFields
}

// NotificationRule represents Infoblox object notification:rule.
// Notification rule specifies the server to which this rule is applicable,
// certain conditions (i.e. triggers), and the action to be taken when the rule
// is hit. It also specifies where this rule engine is configured to be run.
type NotificationRule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the notification rule is applied on all members or not.
	// When this is set to False, the notification rule is applied only on
	// selected_members.
	AllMembers *bool `json:"all_members,omitempty"`

	// The notification rule descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a notification rule is disabled or not. When this is set
	// to False, the notification rule is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines whether the notification rule for event deduplication is enabled.
	// Note that to enable event deduplication, you must set at least one
	// deduplication field.
	EnableEventDeduplication *bool `json:"enable_event_deduplication,omitempty"`

	// Determines whether the notification rule for the event deduplication syslog
	// is enabled.
	EnableEventDeduplicationLog *bool `json:"enable_event_deduplication_log,omitempty"`

	// The list of fields that must be used in the notification rule for event
	// deduplication.
	EventDeduplicationFields []string `json:"event_deduplication_fields,omitempty"`

	// The lookback period for the notification rule for event deduplication.
	EventDeduplicationLookbackPeriod *uint32 `json:"event_deduplication_lookback_period,omitempty"`

	// Event priority.
	EventPriority *string `json:"event_priority,omitempty"`

	// The notification rule event type.
	EventType string `json:"event_type,omitempty"`

	// The notification rule expression list.
	ExpressionList []*NotificationRuleexpressionop `json:"expression_list,omitempty"`

	// The notification rule name.
	Name string `json:"name,omitempty"`

	// The notification rule action is applied if expression list evaluates to
	// True.
	NotificationAction string `json:"notification_action,omitempty"`

	// The notification target.
	NotificationTarget *string `json:"notification_target,omitempty"`

	// The publish settings.
	PublishSettings *CiscoisePublishsetting `json:"publish_settings,omitempty"`

	// Schedule setting that must be specified if event_type is SCHEDULE.
	ScheduledEvent *SettingSchedule `json:"scheduled_event,omitempty"`

	// The list of the members on which the notification rule is applied.
	SelectedMembers []string `json:"selected_members,omitempty"`

	// The notification REST template instance.
	TemplateInstance *NotificationRestTemplateinstance `json:"template_instance,omitempty"`

	// Use flag for: publish_settings
	UsePublishSettings *bool `json:"use_publish_settings,omitempty"`
}

func (NotificationRule) ObjectType() string {
	return "notification:rule"
}

func (obj NotificationRule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"event_type", "name", "notification_action", "notification_target"}
	}
	return obj.returnFields
}

// Nsgroup represents Infoblox object nsgroup.
// A name server group is a collection of one or more primary DNS servers and
// one or more secondary DNS servers. Grouping a commonly used set of primary
// and secondary DNS servers together simplifies zone creation, allowing you to
// specify a single name server group instead of specifying multiple name
// servers individually.
type Nsgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the name server group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of external primary servers.
	ExternalPrimaries []NameServer `json:"external_primaries,omitempty"`

	// The list of external secondary servers.
	ExternalSecondaries []NameServer `json:"external_secondaries,omitempty"`

	// The grid primary servers for this group.
	GridPrimary []*Memberserver `json:"grid_primary,omitempty"`

	// The list with Grid members that are secondary servers for this group.
	GridSecondaries []*Memberserver `json:"grid_secondaries,omitempty"`

	// Determines if this name server group is the Grid default.
	IsGridDefault *bool `json:"is_grid_default,omitempty"`

	// Determines if the "multiple DNS primaries" feature is enabled for the group.
	IsMultimaster bool `json:"is_multimaster,omitempty"`

	// The name of this name server group.
	Name *string `json:"name,omitempty"`

	// This flag controls whether the group is using an external primary. Note that
	// modification of this field requires passing values for "grid_secondaries"
	// and "external_primaries".
	UseExternalPrimary *bool `json:"use_external_primary,omitempty"`
}

func (Nsgroup) ObjectType() string {
	return "nsgroup"
}

func (obj Nsgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// NsgroupDelegation represents Infoblox object nsgroup:delegation.
// The NS group delegation object provides delegation servers configuration for
// delegated zones. When you configure a name server group, you can now create
// a set of external name servers as a delegation name server group and assign
// it to delegated zones. Specifying a single delegation name server group
// instead of configuring multiple name servers individually for each delegated
// zones can significantly reduce configuration efforts.
type NsgroupDelegation struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the delegated NS group.
	Comment *string `json:"comment,omitempty"`

	// The list of delegated servers for the delegated NS group.
	DelegateTo []NameServer `json:"delegate_to,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the delegated NS group.
	Name *string `json:"name,omitempty"`
}

func (NsgroupDelegation) ObjectType() string {
	return "nsgroup:delegation"
}

func (obj NsgroupDelegation) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"delegate_to", "name"}
	}
	return obj.returnFields
}

// NsgroupForwardingmember represents Infoblox object nsgroup:forwardingmember.
// The Forwarding Member Name Server Group provides forwarding servers
// configuration for forward zones.
type NsgroupForwardingmember struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the Forwarding Member Name Server Group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of forwarding member servers.
	ForwardingServers []*Forwardingmemberserver `json:"forwarding_servers,omitempty"`

	// The name of the Forwarding Member Name Server Group.
	Name *string `json:"name,omitempty"`
}

func (NsgroupForwardingmember) ObjectType() string {
	return "nsgroup:forwardingmember"
}

func (obj NsgroupForwardingmember) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"forwarding_servers", "name"}
	}
	return obj.returnFields
}

// NsgroupForwardstubserver represents Infoblox object nsgroup:forwardstubserver.
// The Forward Stub Server Name Server Group allows configuring external
// servers for Forward Zone and Stub Zone.
type NsgroupForwardstubserver struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the Forward Stub Server Name Server Group; maximum 256
	// characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of external servers.
	ExternalServers []NameServer `json:"external_servers,omitempty"`

	// The name of this Forward Stub Server Name Server Group.
	Name *string `json:"name,omitempty"`
}

func (NsgroupForwardstubserver) ObjectType() string {
	return "nsgroup:forwardstubserver"
}

func (obj NsgroupForwardstubserver) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"external_servers", "name"}
	}
	return obj.returnFields
}

// NsgroupStubmember represents Infoblox object nsgroup:stubmember.
// The Stub Member Name Server Group provides stub servers configuration for
// stub zones.
type NsgroupStubmember struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for the Stub Member Name Server Group; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the Stub Member Name Server Group.
	Name *string `json:"name,omitempty"`

	// The Grid member servers of this stub zone. Note that the
	// lead/stealth/grid_replicate/
	// preferred_primaries/override_preferred_primaries fields of the struct will
	// be ignored when set in this field.
	StubMembers []*Memberserver `json:"stub_members,omitempty"`
}

func (NsgroupStubmember) ObjectType() string {
	return "nsgroup:stubmember"
}

func (obj NsgroupStubmember) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// Orderedranges represents Infoblox object orderedranges.
// An ordered DHCP ranges object contains an ordered list of DHCP range objects
// that belong to a network.
type Orderedranges struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The reference to the network that contains ranges.
	Network string `json:"network,omitempty"`

	// The ordered list of references to ranges.
	Ranges []*Range `json:"ranges,omitempty"`
}

func (Orderedranges) ObjectType() string {
	return "orderedranges"
}

func (obj Orderedranges) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"network", "ranges"}
	}
	return obj.returnFields
}

// Orderedresponsepolicyzones represents Infoblox object orderedresponsepolicyzones.
// An ordered list of Response Policy Zones in a DNS view. Server will reject
// zones that are disabled or zones without primary name server assigned.
type Orderedresponsepolicyzones struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// An ordered list of Response Policy Zone names.
	RpZones []string `json:"rp_zones,omitempty"`

	// The DNS View name.
	View *string `json:"view,omitempty"`
}

func (Orderedresponsepolicyzones) ObjectType() string {
	return "orderedresponsepolicyzones"
}

func (obj Orderedresponsepolicyzones) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"view"}
	}
	return obj.returnFields
}

// OutboundCloudclient represents Infoblox object outbound:cloudclient.
// You can use the outbound Cloud Client object to configure the detection and
// authentication of domains in the Cloud, and then apply them to on-premises
// DNS firewall RPZ zones within a configurable time frame.
type OutboundCloudclient struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the OutBound Cloud Client is enabled.
	Enable *bool `json:"enable,omitempty"`

	// The Grid member where our outbound is running.
	GridMember *string `json:"grid_member,omitempty"`

	// The time interval (in seconds) for requesting newly detected domains by the
	// Infoblox Outbound Cloud Client and applying them to the list of configured
	// RPZs.
	Interval *uint32 `json:"interval,omitempty"`

	// List of event types to request
	OutboundCloudClientEvents []*OutboundCloudclientEvent `json:"outbound_cloud_client_events,omitempty"`
}

func (OutboundCloudclient) ObjectType() string {
	return "outbound:cloudclient"
}

func (obj OutboundCloudclient) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"enable", "interval"}
	}
	return obj.returnFields
}

// ParentalcontrolAvp represents Infoblox object parentalcontrol:avp.
// The accounting attribute value pair object is used to extract accounting
// information from accounting protocols logs.
type ParentalcontrolAvp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the AVP.
	Comment *string `json:"comment,omitempty"`

	// The list of domains applicable to AVP.
	DomainTypes []string `json:"domain_types,omitempty"`

	// Determines if AVP is restricted to domains.
	IsRestricted *bool `json:"is_restricted,omitempty"`

	// The name of AVP.
	Name *string `json:"name,omitempty"`

	// The type of AVP as per RFC 2865/2866.
	Type *uint32 `json:"type,omitempty"`

	// Determines if AVP was defined by user.
	UserDefined bool `json:"user_defined,omitempty"`

	// The type of value.
	ValueType string `json:"value_type,omitempty"`

	// The vendor ID as per RFC 2865/2866.
	VendorId *uint32 `json:"vendor_id,omitempty"`

	// The vendor type as per RFC 2865/2866.
	VendorType *uint32 `json:"vendor_type,omitempty"`
}

func (ParentalcontrolAvp) ObjectType() string {
	return "parentalcontrol:avp"
}

func (obj ParentalcontrolAvp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "type", "value_type"}
	}
	return obj.returnFields
}

// ParentalcontrolBlockingpolicy represents Infoblox object parentalcontrol:blockingpolicy.
// This object represents a set of parental control properties for blocking
// policy.
type ParentalcontrolBlockingpolicy struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the blocking policy.
	Name *string `json:"name,omitempty"`

	// The 32 bit hex value of the blocking policy.
	Value *string `json:"value,omitempty"`
}

func (ParentalcontrolBlockingpolicy) ObjectType() string {
	return "parentalcontrol:blockingpolicy"
}

func (obj ParentalcontrolBlockingpolicy) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "value"}
	}
	return obj.returnFields
}

// ParentalcontrolSubscriber represents Infoblox object parentalcontrol:subscriber.
// The parental control subscriber properties contains user defined RADIUS
// subscriber information which will be used by DNS/RPZ for reporting and
// logging violations.
type ParentalcontrolSubscriber struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of AVP to be used as an alternate subscriber ID for fixed lines.
	AltSubscriberId *string `json:"alt_subscriber_id,omitempty"`

	// A character string to control aspects of rewriting of the fields.
	AltSubscriberIdRegexp *string `json:"alt_subscriber_id_regexp,omitempty"`

	// The subexpression indicates which subexpression to extract. If zero, then
	// the text matching the entire regular expression is extracted. If non-zero,
	// then the regex must contain at least that many sub-expression groups. It
	// takes values from 0 to 8.
	AltSubscriberIdSubexpression *uint32 `json:"alt_subscriber_id_subexpression,omitempty"`

	// The list of ordered AVP Ancillary Fields.
	Ancillaries []string `json:"ancillaries,omitempty"`

	// Category content account name using the categorization service.
	CatAcctname *string `json:"cat_acctname,omitempty"`

	// Category content account password to access the categorization service.
	CatPassword *string `json:"cat_password,omitempty"`

	// Category content updates every number of hours.
	CatUpdateFrequency *uint32 `json:"cat_update_frequency,omitempty"`

	// Category content vendor url to download category data from and upload
	// feedback to, configure for parental control.
	CategoryUrl *string `json:"category_url,omitempty"`

	// Determines if NAS RADIUS traffic is accepted over MGMT only.
	EnableMgmtOnlyNas *bool `json:"enable_mgmt_only_nas,omitempty"`

	// Determines if parental control is enabled.
	EnableParentalControl *bool `json:"enable_parental_control,omitempty"`

	// The time for collector to be fully populated. Valid values are from 1 to
	// 65535.
	InterimAccountingInterval *uint32 `json:"interim_accounting_interval,omitempty"`

	// The ordered list of IP Anchors AVPs. The list content cannot be changed, but
	// the order of elements.
	IpAnchors []string `json:"ip_anchors,omitempty"`

	// A character string to control aspects of rewriting of the fields.
	IpSpaceDiscRegexp *string `json:"ip_space_disc_regexp,omitempty"`

	// The subexpression indicates which subexpression to extract. If zero, then
	// the text matching the entire regular expression is extracted. If non-zero,
	// then the regex must contain at least that many sub-expression groups. It
	// takes values from 0 to 8.
	IpSpaceDiscSubexpression *uint32 `json:"ip_space_disc_subexpression,omitempty"`

	// The name of AVP to be used as IP address discriminator.
	IpSpaceDiscriminator *string `json:"ip_space_discriminator,omitempty"`

	// The name of AVP to be used as local ID.
	LocalId *string `json:"local_id,omitempty"`

	// A character string to control aspects of rewriting of the fields.
	LocalIdRegexp *string `json:"local_id_regexp,omitempty"`

	// The subexpression indicates which subexpression to extract. If zero, then
	// the text matching the entire regular expression is extracted. If non-zero,
	// then the regex must contain at least that many sub-expression groups. It
	// takes values from 0 to 8.
	LocalIdSubexpression *uint32 `json:"local_id_subexpression,omitempty"`

	// CEF log all guest lookups, will produce two logs in case of a violation.
	LogGuestLookups *bool `json:"log_guest_lookups,omitempty"`

	// NAS contextual information AVP.
	NasContextInfo *string `json:"nas_context_info,omitempty"`

	// The SOA to store parental control records.
	PcZoneName *string `json:"pc_zone_name,omitempty"`

	// Proxy server password used for authentication.
	ProxyPassword *string `json:"proxy_password,omitempty"`

	// Proxy url to download category data from and upload feedback to, configure
	// for parental control. The default value 'None' is no longer valid as it
	// match url regex pattern "^http|https://". The new default value does not get
	// saved in database, but rather used for comparision with object created in
	// unit test cases.
	ProxyUrl *string `json:"proxy_url,omitempty"`

	// Proxy server username used for authentication.
	ProxyUsername *string `json:"proxy_username,omitempty"`

	// The name of AVP to be used as a subscriber.
	SubscriberId *string `json:"subscriber_id,omitempty"`

	// A character string to control aspects of rewriting of the fields.
	SubscriberIdRegexp *string `json:"subscriber_id_regexp,omitempty"`

	// The subexpression indicates which subexpression to extract. If zero, then
	// the text matching the entire regular expression is extracted. If non-zero,
	// then the regex must contain at least that many sub-expression groups. It
	// takes values from 0 to 8.
	SubscriberIdSubexpression *uint32 `json:"subscriber_id_subexpression,omitempty"`
}

func (ParentalcontrolSubscriber) ObjectType() string {
	return "parentalcontrol:subscriber"
}

func (obj ParentalcontrolSubscriber) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"alt_subscriber_id", "local_id", "subscriber_id"}
	}
	return obj.returnFields
}

// ParentalcontrolSubscriberrecord represents Infoblox object parentalcontrol:subscriberrecord.
// This object represents a set of parental control properties for subscriber
// record.
type ParentalcontrolSubscriberrecord struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// accounting_session_id
	AccountingSessionId *string `json:"accounting_session_id,omitempty"`

	// alt_ip_addr
	AltIpAddr *string `json:"alt_ip_addr,omitempty"`

	// ans0
	Ans0 *string `json:"ans0,omitempty"`

	// ans1
	Ans1 *string `json:"ans1,omitempty"`

	// ans2
	Ans2 *string `json:"ans2,omitempty"`

	// ans3
	Ans3 *string `json:"ans3,omitempty"`

	// ans4
	Ans4 *string `json:"ans4,omitempty"`

	// black_list
	BlackList *string `json:"black_list,omitempty"`

	// bwflag
	Bwflag *bool `json:"bwflag,omitempty"`

	// dynamic_category_policy
	DynamicCategoryPolicy *bool `json:"dynamic_category_policy,omitempty"`

	// flags
	Flags *string `json:"flags,omitempty"`

	// ip_addr
	IpAddr *string `json:"ip_addr,omitempty"`

	// ipsd
	Ipsd *string `json:"ipsd,omitempty"`

	// localid
	Localid *string `json:"localid,omitempty"`

	// nas_contextual
	NasContextual *string `json:"nas_contextual,omitempty"`

	// parental_control_policy
	ParentalControlPolicy *string `json:"parental_control_policy,omitempty"`

	// prefix
	Prefix *uint32 `json:"prefix,omitempty"`

	// proxy_all
	ProxyAll *bool `json:"proxy_all,omitempty"`

	// site
	Site *string `json:"site,omitempty"`

	// subscriber_id
	SubscriberId *string `json:"subscriber_id,omitempty"`

	// subscriber_secure_policy
	SubscriberSecurePolicy *string `json:"subscriber_secure_policy,omitempty"`

	// unknown_category_policy
	UnknownCategoryPolicy *bool `json:"unknown_category_policy,omitempty"`

	// white_list
	WhiteList *string `json:"white_list,omitempty"`

	// wpc_category_policy
	WpcCategoryPolicy *string `json:"wpc_category_policy,omitempty"`
}

func (ParentalcontrolSubscriberrecord) ObjectType() string {
	return "parentalcontrol:subscriberrecord"
}

func (obj ParentalcontrolSubscriberrecord) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"accounting_session_id", "ip_addr", "ipsd", "localid", "prefix", "site", "subscriber_id"}
	}
	return obj.returnFields
}

// ParentalcontrolSubscribersite represents Infoblox object parentalcontrol:subscribersite.
// This object represents a set of parental control properties for subscriber
// site.
type ParentalcontrolSubscribersite struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of ABS for the site.
	Abss []*ParentalcontrolAbs `json:"abss,omitempty"`

	// The size of the Deterministic NAT block-size.
	BlockSize *uint32 `json:"block_size,omitempty"`

	// The IPv4 Address of the blocking server.
	BlockingIpv4Vip1 *string `json:"blocking_ipv4_vip1,omitempty"`

	// The IPv4 Address of the blocking server.
	BlockingIpv4Vip2 *string `json:"blocking_ipv4_vip2,omitempty"`

	// The IPv6 Address of the blocking server.
	BlockingIpv6Vip1 *string `json:"blocking_ipv6_vip1,omitempty"`

	// The IPv6 Address of the blocking server.
	BlockingIpv6Vip2 *string `json:"blocking_ipv6_vip2,omitempty"`

	// The human readable comment for the site.
	Comment *string `json:"comment,omitempty"`

	// Enable/disable the DCA subscriber B/W list support.
	DcaSubBwList *bool `json:"dca_sub_bw_list,omitempty"`

	// Enable/disable the DCA subscriber query count.
	DcaSubQueryCount *bool `json:"dca_sub_query_count,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The start of the first Deterministic block.
	FirstPort *uint32 `json:"first_port,omitempty"`

	// The max number of subscribers for the site. It is used to configure the
	// cache size.
	MaximumSubscribers *uint32 `json:"maximum_subscribers,omitempty"`

	// The list of members for the site.
	Members []*ParentalcontrolSitemember `json:"members,omitempty"`

	// The list of MSP for the site.
	Msps []*ParentalcontrolMsp `json:"msps,omitempty"`

	// The name of the site.
	Name string `json:"name,omitempty"`

	// The list of accounting log servers.
	NasGateways []*ParentalcontrolNasgateway `json:"nas_gateways,omitempty"`

	// The port number to reach the collector.
	NasPort *uint32 `json:"nas_port,omitempty"`

	// Enables Proxy RPZ PASSTGHRU.
	ProxyRpzPassthru *bool `json:"proxy_rpz_passthru,omitempty"`

	// The list of SPM for the site.
	Spms []*ParentalcontrolSpm `json:"spms,omitempty"`

	// Stop the anycast service when the subscriber service is in the interim
	// state.
	StopAnycast *bool `json:"stop_anycast,omitempty"`

	// Restrict subscriber cache entries to NATed clients.
	StrictNat *bool `json:"strict_nat,omitempty"`
}

func (ParentalcontrolSubscribersite) ObjectType() string {
	return "parentalcontrol:subscribersite"
}

func (obj ParentalcontrolSubscribersite) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"block_size", "dca_sub_bw_list", "dca_sub_query_count", "first_port", "name", "stop_anycast", "strict_nat"}
	}
	return obj.returnFields
}

// Permission represents Infoblox object permission.
// Limited-access admin groups can access certain DHCP resources only if their
// administrative permissions are defined. By default, the appliance denies
// access when a limited-access admin group does not have defined permissions.
// You can grant admin groups read-only or read/write permission, or deny
// access by using this object.
type Permission struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the admin group this permission applies to.
	Group *string `json:"group,omitempty"`

	// A reference to a WAPI object, which will be the object this permission
	// applies to.
	Object *string `json:"object,omitempty"`

	// The type of permission.
	Permission string `json:"permission,omitempty"`

	// The type of resource this permission applies to. If 'object' is set, the
	// permission is going to apply to child objects of the specified type, for
	// example if 'object' was set to an authoritative zone reference and
	// 'resource_type' was set to 'A', the permission would apply to A Resource
	// Records within the specified zone.
	ResourceType string `json:"resource_type,omitempty"`

	// The name of the role this permission applies to.
	Role *string `json:"role,omitempty"`
}

func (Permission) ObjectType() string {
	return "permission"
}

func (obj Permission) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"group", "permission", "resource_type", "role"}
	}
	return obj.returnFields
}

// PxgridEndpoint represents Infoblox object pxgrid:endpoint.
// The pxgrid endpoint object represents the settings of a particular PXGRID
// endpoint.
type PxgridEndpoint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The pxgrid endpoint IPv4 Address or IPv6 Address or Fully-Qualified Domain
	// Name (FQDN)
	Address *string `json:"address,omitempty"`

	// The Cisco ISE client certificate subject.
	ClientCertificateSubject string `json:"client_certificate_subject,omitempty"`

	// The token returned by the uploadinit function call in object fileop for
	// Cisco ISE client certificate.
	ClientCertificateToken *string `json:"client_certificate_token,omitempty"`

	// The pxgrid endpoint client certificate valid from.
	ClientCertificateValidFrom *UnixTime `json:"client_certificate_valid_from,omitempty"`

	// The pxgrid endpoint client certificate valid to.
	ClientCertificateValidTo *UnixTime `json:"client_certificate_valid_to,omitempty"`

	// The Cisco ISE endpoint descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a Cisco ISE endpoint is disabled or not. When this is set
	// to False, the Cisco ISE endpoint is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The log level for a notification pxgrid endpoint.
	LogLevel string `json:"log_level,omitempty"`

	// The name of the pxgrid endpoint.
	Name *string `json:"name,omitempty"`

	// The pxgrid network view name.
	NetworkView *string `json:"network_view,omitempty"`

	// The outbound member that will generate events.
	OutboundMemberType string `json:"outbound_member_type,omitempty"`

	// The list of members for outbound events.
	OutboundMembers []string `json:"outbound_members,omitempty"`

	// The Cisco ISE publish settings.
	PublishSettings *CiscoisePublishsetting `json:"publish_settings,omitempty"`

	// The Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// The Pxgrid template instance. You cannot change the parameters of the pxgrid
	// endpoint template instance.
	TemplateInstance *NotificationRestTemplateinstance `json:"template_instance,omitempty"`

	// The timeout of session management (in seconds).
	Timeout *uint32 `json:"timeout,omitempty"`

	// The vendor identifier.
	VendorIdentifier *string `json:"vendor_identifier,omitempty"`

	// The user name for WAPI integration.
	WapiUserName *string `json:"wapi_user_name,omitempty"`

	// The user password for WAPI integration.
	WapiUserPassword *string `json:"wapi_user_password,omitempty"`
}

func (PxgridEndpoint) ObjectType() string {
	return "pxgrid:endpoint"
}

func (obj PxgridEndpoint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address", "disable", "name", "outbound_member_type"}
	}
	return obj.returnFields
}

// RadiusAuthservice represents Infoblox object radius:authservice.
// RADIUS provides authentication, accounting, and authorization functions.
type RadiusAuthservice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The number of times to attempt to contact an accounting RADIUS server.
	AcctRetries *uint32 `json:"acct_retries,omitempty"`

	// The number of seconds to wait for a response from the RADIUS server.
	AcctTimeout *uint32 `json:"acct_timeout,omitempty"`

	// The number of times to attempt to contact an authentication RADIUS server.
	AuthRetries *uint32 `json:"auth_retries,omitempty"`

	// The number of seconds to wait for a response from the RADIUS server.
	AuthTimeout *uint32 `json:"auth_timeout,omitempty"`

	// The TTL of cached authentication data in seconds.
	CacheTtl *uint32 `json:"cache_ttl,omitempty"`

	// The RADIUS descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the RADIUS authentication service is disabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines whether the authentication cache is enabled.
	EnableCache *bool `json:"enable_cache,omitempty"`

	// The way to contact the RADIUS server.
	Mode string `json:"mode,omitempty"`

	// The RADIUS authentication service name.
	Name *string `json:"name,omitempty"`

	// The time period to wait before retrying a server that has been marked as
	// down.
	RecoveryInterval *uint32 `json:"recovery_interval,omitempty"`

	// The ordered list of RADIUS authentication servers.
	Servers []*RadiusServer `json:"servers,omitempty"`
}

func (RadiusAuthservice) ObjectType() string {
	return "radius:authservice"
}

func (obj RadiusAuthservice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disable", "name"}
	}
	return obj.returnFields
}

// Range represents Infoblox object range.
// A DHCP range defines the specified range of IP addresses in a network. A
// DHCP range should be added for a network so the Infoblox appliance can
// assign IP addresses within that specified range to DHCP clients. If the
// client is on a network that is assigned a DHCP range, the device distributes
// an available IP address from that range to the DHCP client, or to a DHCP
// relay agent if the request came through an agent. The DHCP range should also
// be assigned with a device. If devices are in a grid, the particular member
// serving DHCP for the DHCP range must be specified. If the server is an
// independent device, this device must be specified as the member that serves
// the DHCP range.
type Range struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP clients requests.
	AlwaysUpdateDns *bool `json:"always_update_dns,omitempty"`

	// The bootfile name for the range. You can configure the DHCP server to
	// support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the range. You can specify the name and/or IP
	// address of the boot server that the host needs to boot. The boot server IPv4
	// Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the range; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this range.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// If True, send NAK forcing the client to take the new address.
	DenyAllClients *bool `json:"deny_all_clients,omitempty"`

	// If set to true, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The percentage of the total DHCP utilization of the range multiplied by
	// 1000. This is the percentage of the total number of available IP addresses
	// belonging to the range versus the total number of all IP addresses in the
	// range.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of the range.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// Determines whether a range is disabled or not. When this is set to False,
	// the range is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Discover now status for this range.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovery basic poll settings for this range.
	DiscoveryBasicPollSettings *DiscoveryBasicpollsettings `json:"discovery_basic_poll_settings,omitempty"`

	// The discovery blackout setting for this range.
	DiscoveryBlackoutSetting *PropertiesBlackoutsetting `json:"discovery_blackout_setting,omitempty"`

	// The member that will run discovery for this range.
	DiscoveryMember *string `json:"discovery_member,omitempty"`

	// The total number of DHCP leases issued for the range.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// The e-mail lists to which the appliance sends DHCP threshold alarm e-mail
	// messages.
	EmailList []string `json:"email_list,omitempty"`

	// The dynamic DNS updates flag of a DHCP range object. If set to True, the
	// DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if DHCP thresholds are enabled for the range.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines whether a discovery is enabled or not for this range. When this
	// is set to False, the discovery for this range is disabled.
	EnableDiscovery *bool `json:"enable_discovery,omitempty"`

	// Determines if DHCP threshold warnings are sent through email.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Determines if IFMAP publishing is enabled for the range.
	EnableIfmapPublishing *bool `json:"enable_ifmap_publishing,omitempty"`

	// Determines if the discovery for the range should be immediately enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Determines if DHCP threshold warnings are send through SNMP.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// The IPv4 Address end address of the range.
	EndAddr *string `json:"end_addr,omitempty"`

	// The endpoints that provides data for the DHCP Range object.
	EndpointSources []*CiscoiseEndpoint `json:"endpoint_sources,omitempty"`

	// These are ranges of IP addresses that the appliance does not use to assign
	// to clients. You can use these exclusion addresses as static IP addresses.
	// They contain the start and end addresses of the exclusion range, and
	// optionally, information about this exclusion range.
	Exclude []*Exclusionrange `json:"exclude,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the failover association: the server in this failover
	// association will serve the IPv4 range in case the main server is out of
	// service. {range:range} must be set to 'FAILOVER' or 'FAILOVER_MS' if you
	// want the failover association specified here to serve the range.
	FailoverAssociation *string `json:"failover_association,omitempty"`

	// This field contains the fingerprint filters for this DHCP range. The
	// appliance uses matching rules in these filters to select the address range
	// from which it assigns a lease.
	FingerprintFilterRules []*Filterrule `json:"fingerprint_filter_rules,omitempty"`

	// The percentage of DHCP range usage threshold above which range usage is not
	// expected and may warrant your attention. When the high watermark is reached,
	// the Infoblox appliance generates a syslog message and sends a warning (if
	// enabled). A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// The percentage of DHCP range usage below which the corresponding SNMP trap
	// is reset. A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses. Valid values are "NONE", "CLIENT", or "MACADDR". The default is
	// "NONE".
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// This field will be 'true' if this particular range is part of a split scope.
	IsSplitScope bool `json:"is_split_scope,omitempty"`

	// Permission for known clients. This can be 'Allow' or 'Deny'. If set to
	// 'Deny' known clients will be denied IP addresses. Known clients include
	// roaming hosts and clients with fixed addresses or DHCP host entries. Unknown
	// clients include clients that are not roaming hosts and clients that do not
	// have fixed addresses or DHCP host entries.
	KnownClients *string `json:"known_clients,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied to this range. This list
	// corresponds to the match rules that are written to the dhcpd configuration
	// file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The percentage of DHCP range usage below which the Infoblox appliance
	// generates a syslog message and sends a warning (if enabled). A number that
	// specifies the percentage of allocated addresses. The range is from 1 to 100.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// The percentage of DHCP range usage threshold below which range usage is not
	// expected and may warrant your attention. When the low watermark is crossed,
	// the Infoblox appliance generates a syslog message and sends a warning (if
	// enabled). A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The low watermark reset value must be higher than
	// the low watermark value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// This field contains the MAC filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	MacFilterRules []*Filterrule `json:"mac_filter_rules,omitempty"`

	// The member that will provide service for this range. {range:range} needs to
	// be set to 'MEMBER' if you want the server specified here to serve the range.
	// For searching by this field you should use a HTTP method that contains a
	// body (POST or PUT) with Dhcp Member structure dhcpmember and the request
	// should have option _method=GET.
	Member *Dhcpmember `json:"member,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// This field contains the Microsoft DHCP options for this range.
	MsOptions []*Msdhcpoption `json:"ms_options,omitempty"`

	// The Microsoft server that will provide service for this range. {range:range}
	// needs to be set to 'MS_SERVER' if you want the server specified here to
	// serve the range. For searching by this field you should use a HTTP method
	// that contains a body (POST or PUT) with MS DHCP server structure
	// msdhcpserver and the request should have option _method=GET.
	MsServer *Msdhcpserver `json:"ms_server,omitempty"`

	// This field contains the NAC filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	NacFilterRules []*Filterrule `json:"nac_filter_rules,omitempty"`

	// This field contains the name of the Microsoft scope.
	Name *string `json:"name,omitempty"`

	// The network to which this range belongs, in IPv4 Address/CIDR format.
	Network *string `json:"network,omitempty"`

	// The name of the network view in which this range resides.
	NetworkView *string `json:"network_view,omitempty"`

	// The name in FQDN and/or IPv4 Address of the next server that the host needs
	// to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// This field contains the Option filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	OptionFilterRules []*Filterrule `json:"option_filter_rules,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The port control blackout setting for this range.
	PortControlBlackoutSetting *PropertiesBlackoutsetting `json:"port_control_blackout_setting,omitempty"`

	// The PXE lease time value of a DHCP Range object. Some hosts use PXE (Preboot
	// Execution Environment) to boot remotely from a server. To better manage your
	// IP resources, set a different lease time for PXE boot requests. You can
	// configure the DHCP server to allocate an IP address with a shorter lease
	// time to hosts that send PXE boot requests, so IP addresses are not leased
	// longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// This field contains the Relay Agent filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	RelayAgentFilterRules []*Filterrule `json:"relay_agent_filter_rules,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// If the field is set to True, the discovery blackout setting will be used for
	// port control blackout setting.
	SamePortControlDiscoveryBlackout *bool `json:"same_port_control_discovery_blackout,omitempty"`

	// The type of server that is going to serve the range.
	ServerAssociationType string `json:"server_association_type,omitempty"`

	// The Microsoft member to which the split scope is assigned. See
	// {next_available_ip:next_available_ip} for more information
	SplitMember *Msdhcpserver `json:"split_member,omitempty"`

	// This field controls the percentage used when creating a split scope. Valid
	// values are numbers between 1 and 99. If the value is 40, it means that the
	// top 40% of the exclusion will be created on the DHCP range assigned to
	// {next_available_ip:next_available_ip} and the lower 60% of the range will be
	// assigned to DHCP range assigned to {next_available_ip:next_available_ip}
	SplitScopeExclusionPercent uint32 `json:"split_scope_exclusion_percent,omitempty"`

	// The IPv4 Address starting address of the range.
	StartAddr *string `json:"start_addr,omitempty"`

	// The number of static DHCP addresses configured in the range.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The DHCP Range Cisco ISE subscribe settings.
	SubscribeSettings *CiscoiseSubscribesetting `json:"subscribe_settings,omitempty"`

	// If set on creation, the range will be created according to the values
	// specified in the named template.
	Template string `json:"template,omitempty"`

	// The total number of DHCP addresses configured in the range.
	TotalHosts uint32 `json:"total_hosts,omitempty"`

	// Permission for unknown clients. This can be 'Allow' or 'Deny'. If set to
	// 'Deny', unknown clients will be denied IP addresses. Known clients include
	// roaming hosts and clients with fixed addresses or DHCP host entries. Unknown
	// clients include clients that are not roaming hosts and clients that do not
	// have fixed addresses or DHCP host entries.
	UnknownClients *string `json:"unknown_clients,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: discovery_blackout_setting , port_control_blackout_setting,
	// same_port_control_discovery_blackout
	UseBlackoutSetting *bool `json:"use_blackout_setting,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: discovery_basic_poll_settings
	UseDiscoveryBasicPollingSettings *bool `json:"use_discovery_basic_polling_settings,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: discovery_member , enable_discovery
	UseEnableDiscovery *bool `json:"use_enable_discovery,omitempty"`

	// Use flag for: enable_ifmap_publishing
	UseEnableIfmapPublishing *bool `json:"use_enable_ifmap_publishing,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ignore_id
	UseIgnoreId *bool `json:"use_ignore_id,omitempty"`

	// Use flag for: known_clients
	UseKnownClients *bool `json:"use_known_clients,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: ms_options
	UseMsOptions *bool `json:"use_ms_options,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: subscribe_settings
	UseSubscribeSettings *bool `json:"use_subscribe_settings,omitempty"`

	// Use flag for: unknown_clients
	UseUnknownClients *bool `json:"use_unknown_clients,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`
}

func (Range) ObjectType() string {
	return "range"
}

func (obj Range) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "end_addr", "network", "network_view", "start_addr"}
	}
	return obj.returnFields
}

// Rangetemplate represents Infoblox object rangetemplate.
// The range template used to create a range objects in a quick and consistant
// way. Range object created from a range template will inherit most properties
// defined in range template object so most of the range template properties
// are the same as the range object properties.
type Rangetemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The bootfile name for the range. You can configure the DHCP server to
	// support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the range. You can specify the name and/or IP
	// address of the boot server that the host needs to boot. The boot server IPv4
	// Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// This flag controls whether this template can be used to create network
	// objects in a cloud-computing deployment.
	CloudApiCompatible *bool `json:"cloud_api_compatible,omitempty"`

	// A descriptive comment of a range template object.
	Comment *string `json:"comment,omitempty"`

	// The dynamic DNS domain name the appliance uses specifically for DDNS updates
	// for this range.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// The vconnector member that the object should be delegated to when created
	// from this range template.
	DelegatedMember *Dhcpmember `json:"delegated_member,omitempty"`

	// If True, send NAK forcing the client to take the new address.
	DenyAllClients *bool `json:"deny_all_clients,omitempty"`

	// Determines if BOOTP settings are disabled and BOOTP requests will be denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The e-mail lists to which the appliance sends DHCP threshold alarm e-mail
	// messages.
	EmailList []string `json:"email_list,omitempty"`

	// Determines if the DHCP server sends DDNS updates to DNS servers in the same
	// Grid, and to external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Determines if DHCP thresholds are enabled for the range.
	EnableDhcpThresholds *bool `json:"enable_dhcp_thresholds,omitempty"`

	// Determines if DHCP threshold warnings are sent through email.
	EnableEmailWarnings *bool `json:"enable_email_warnings,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Determines if DHCP threshold warnings are sent through SNMP.
	EnableSnmpWarnings *bool `json:"enable_snmp_warnings,omitempty"`

	// These are ranges of IP addresses that the appliance does not use to assign
	// to clients. You can use these exclusion addresses as static IP addresses.
	// They contain the start and end addresses of the exclusion range, and
	// optionally, information about this exclusion range.
	Exclude []*Exclusionrangetemplate `json:"exclude,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the failover association: the server in this failover
	// association will serve the IPv4 range in case the main server is out of
	// service. {rangetemplate:rangetemplate} must be set to 'FAILOVER' or
	// 'FAILOVER_MS' if you want the failover association specified here to serve
	// the range.
	FailoverAssociation *string `json:"failover_association,omitempty"`

	// This field contains the fingerprint filters for this DHCP range. The
	// appliance uses matching rules in these filters to select the address range
	// from which it assigns a lease.
	FingerprintFilterRules []*Filterrule `json:"fingerprint_filter_rules,omitempty"`

	// The percentage of DHCP range usage threshold above which range usage is not
	// expected and may warrant your attention. When the high watermark is reached,
	// the Infoblox appliance generates a syslog message and sends a warning (if
	// enabled). A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100.
	HighWaterMark *uint32 `json:"high_water_mark,omitempty"`

	// The percentage of DHCP range usage below which the corresponding SNMP trap
	// is reset. A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The high watermark reset value must be lower than
	// the high watermark value.
	HighWaterMarkReset *uint32 `json:"high_water_mark_reset,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Permission for known clients. If set to 'Deny' known clients will be denied
	// IP addresses. Known clients include roaming hosts and clients with fixed
	// addresses or DHCP host entries. Unknown clients include clients that are not
	// roaming hosts and clients that do not have fixed addresses or DHCP host
	// entries.
	KnownClients string `json:"known_clients,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied on this range. This list
	// corresponds to the match rules that are written to the dhcpd configuration
	// file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The percentage of DHCP range usage below which the Infoblox appliance
	// generates a syslog message and sends a warning (if enabled). A number that
	// specifies the percentage of allocated addresses. The range is from 1 to 100.
	LowWaterMark *uint32 `json:"low_water_mark,omitempty"`

	// The percentage of DHCP range usage threshold below which range usage is not
	// expected and may warrant your attention. When the low watermark is crossed,
	// the Infoblox appliance generates a syslog message and sends a warning (if
	// enabled). A number that specifies the percentage of allocated addresses. The
	// range is from 1 to 100. The low watermark reset value must be higher than
	// the low watermark value.
	LowWaterMarkReset *uint32 `json:"low_water_mark_reset,omitempty"`

	// This field contains the MAC filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	MacFilterRules []*Filterrule `json:"mac_filter_rules,omitempty"`

	// The member that will provide service for this range.
	// {rangetemplate:rangetemplate} needs to be set to 'MEMBER' if you want the
	// server specified here to serve the range. For searching by this field you
	// should use a HTTP method that contains a body (POST or PUT) with Dhcp Member
	// structure dhcpmember and the request should have option _method=GET.
	Member *Dhcpmember `json:"member,omitempty"`

	// The Microsoft DHCP options for this range.
	MsOptions []*Msdhcpoption `json:"ms_options,omitempty"`

	// The Microsoft server that will provide service for this range.
	// {rangetemplate:rangetemplate} needs to be set to 'MS_SERVER' if you want the
	// server specified here to serve the range. For searching by this field you
	// should use a HTTP method that contains a body (POST or PUT) with MS DHCP
	// server structure msdhcpserver and the request should have option
	// _method=GET.
	MsServer *Msdhcpserver `json:"ms_server,omitempty"`

	// This field contains the NAC filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	NacFilterRules []*Filterrule `json:"nac_filter_rules,omitempty"`

	// The name of a range template object.
	Name *string `json:"name,omitempty"`

	// The name in FQDN and/or IPv4 Address format of the next server that the host
	// needs to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// The number of addresses for this range.
	NumberOfAddresses *uint32 `json:"number_of_addresses,omitempty"`

	// The start address offset for this range.
	Offset *uint32 `json:"offset,omitempty"`

	// This field contains the Option filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	OptionFilterRules []*Filterrule `json:"option_filter_rules,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The PXE lease time value for a range object. Some hosts use PXE (Preboot
	// Execution Environment) to boot remotely from a server. To better manage your
	// IP resources, set a different lease time for PXE boot requests. You can
	// configure the DHCP server to allocate an IP address with a shorter lease
	// time to hosts that send PXE boot requests, so IP addresses are not leased
	// longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// If the field is set to True, the leases are kept in the Recycle Bin until
	// one week after expiration. Otherwise, the leases are permanently deleted.
	RecycleLeases *bool `json:"recycle_leases,omitempty"`

	// This field contains the Relay Agent filters to be applied to this range. The
	// appliance uses the matching rules of these filters to select the address
	// range from which it assigns a lease.
	RelayAgentFilterRules []*Filterrule `json:"relay_agent_filter_rules,omitempty"`

	// The type of server that is going to serve the range.
	ServerAssociationType string `json:"server_association_type,omitempty"`

	// Permission for unknown clients. If set to 'Deny' unknown clients will be
	// denied IP addresses. Known clients include roaming hosts and clients with
	// fixed addresses or DHCP host entries. Unknown clients include clients that
	// are not roaming hosts and clients that do not have fixed addresses or DHCP
	// host entries.
	UnknownClients string `json:"unknown_clients,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: email_list
	UseEmailList *bool `json:"use_email_list,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: enable_dhcp_thresholds
	UseEnableDhcpThresholds *bool `json:"use_enable_dhcp_thresholds,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: known_clients
	UseKnownClients *bool `json:"use_known_clients,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: ms_options
	UseMsOptions *bool `json:"use_ms_options,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: recycle_leases
	UseRecycleLeases *bool `json:"use_recycle_leases,omitempty"`

	// Use flag for: unknown_clients
	UseUnknownClients *bool `json:"use_unknown_clients,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`
}

func (Rangetemplate) ObjectType() string {
	return "rangetemplate"
}

func (obj Rangetemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "number_of_addresses", "offset"}
	}
	return obj.returnFields
}

// RecordA represents Infoblox object record:a.
// An A (address) record maps a domain name to an IPv4 address. To define a
// specific name-to-address mapping, add an A record to a previously defined
// authoritative forward-mapping zone.
type RecordA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The discovered data for this A record.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The name for an A record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The IPv4 Address of the record.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// Name for A record in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// Delete option that indicates whether the associated PTR records should be
	// removed while deleting the specified A record.
	RemoveAssociatedPtr bool `json:"remove_associated_ptr,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordA) ObjectType() string {
	return "record:a"
}

func (obj RecordA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "name", "view"}
	}
	return obj.returnFields
}

func NewEmptyRecordA() *RecordA {
	res := &RecordA{}
	res.returnFields = []string{
		"extattrs", "ipv4addr", "name", "view", "zone", "comment", "ttl", "use_ttl"}

	return res
}

func NewRecordA(
	view string,
	zone string,
	name string,
	ipAddr string,
	ttl uint32,
	useTTL bool,
	comment string,
	eas EA,
	ref string) *RecordA {

	res := NewEmptyRecordA()
	res.View = view
	res.Zone = zone
	res.Name = &name
	res.Ipv4Addr = &ipAddr
	res.Ttl = &ttl
	res.UseTtl = &useTTL
	res.Comment = &comment
	res.Ea = eas
	res.Ref = ref

	return res
}

// RecordAAAA represents Infoblox object record:aaaa.
// An AAAA (address) record maps a domain name to an IPv6 address. To define a
// specific name-to-address mapping, add an AAAA record to a previously defined
// authoritative forward-mapping zone.
type RecordAAAA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The discovered data for this AAAA record.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The name for an AAAA record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The IPv6 Address of the record.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// Name for the AAAA record in FQDN format. This value can be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// Delete option that indicates whether the associated PTR records should be
	// removed while deleting the specified A record.
	RemoveAssociatedPtr bool `json:"remove_associated_ptr,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordAAAA) ObjectType() string {
	return "record:aaaa"
}

func (obj RecordAAAA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv6addr", "name", "view"}
	}
	return obj.returnFields
}

func NewEmptyRecordAAAA() *RecordAAAA {
	res := &RecordAAAA{}
	res.returnFields = []string{"extattrs", "ipv6addr", "name", "view", "zone", "use_ttl", "ttl", "comment"}

	return res
}

func NewRecordAAAA(
	view string,
	name string,
	ipAddr string,
	useTtl bool,
	ttl uint32,
	comment string,
	eas EA,
	ref string) *RecordAAAA {

	res := NewEmptyRecordAAAA()
	res.View = view
	res.Name = &name
	res.Ipv6Addr = &ipAddr
	res.UseTtl = &useTtl
	res.Ttl = &ttl
	res.Comment = &comment
	res.Ea = eas
	res.Ref = ref

	return res
}

// RecordAlias represents Infoblox object record:alias.
// Alias resource record allows you to create typed aliases for standard DNS
// resource records which are resolved dynamically by an authoritative server.
// Unlike CNAME Alias can be created in the zone apex.
type RecordAlias struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for an Alias record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Target name in punycode format.
	DnsTargetName string `json:"dns_target_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name for an Alias record in FQDN format. This value can be in unicode
	// format. Regular expression search is not supported for unicode values.
	Name *string `json:"name,omitempty"`

	// Target name in FQDN format. This value can be in unicode format.
	TargetName *string `json:"target_name,omitempty"`

	// Target type.
	TargetType string `json:"target_type,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordAlias) ObjectType() string {
	return "record:alias"
}

func (obj RecordAlias) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "target_name", "target_type", "view"}
	}
	return obj.returnFields
}

// RecordCaa represents Infoblox object record:caa.
// The Certification Authority Authorization (CAA) DNS resource record (RR) is
// used to specify which certificate authorities (CAs) are allowed to issue
// certificates for a domain. For further details see RFC-6844.
type RecordCaa struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Flag of CAA record.
	CaFlag *uint32 `json:"ca_flag,omitempty"`

	// Tag of CAA record.
	CaTag *string `json:"ca_tag,omitempty"`

	// Value of CAA record
	CaValue *string `json:"ca_value,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the CAA record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The CAA record name in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The Time to Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordCaa) ObjectType() string {
	return "record:caa"
}

func (obj RecordCaa) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordCNAME represents Infoblox object record:cname.
// A CNAME record maps an alias to a canonical name. You can use CNAME records
// in both forward- and IPv4 reverse-mapping zones to serve two different
// purposes. (At this time, you cannot use CNAME records with IPv6
// reverse-mapping zones.)
type RecordCNAME struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Canonical name in punycode format.
	DnsCanonical string `json:"dns_canonical,omitempty"`

	// The name for the CNAME record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name for a CNAME record in FQDN format. This value can be in unicode
	// format. Regular expression search is not supported for unicode values.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordCNAME) ObjectType() string {
	return "record:cname"
}

func (obj RecordCNAME) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

func NewEmptyRecordCNAME() *RecordCNAME {
	res := &RecordCNAME{}
	res.returnFields = []string{"extattrs", "canonical", "name", "view", "zone", "comment", "ttl", "use_ttl"}

	return res
}

func NewRecordCNAME(dnsView string,
	canonical string,
	recordName string,
	useTtl bool,
	ttl uint32,
	comment string,
	ea EA,
	ref string) *RecordCNAME {

	res := NewEmptyRecordCNAME()

	res.View = &dnsView
	if *res.View == "" {
		res.View = nil
	}

	res.Canonical = &canonical
	res.Name = &recordName
	res.UseTtl = &useTtl
	res.Ttl = &ttl
	res.Comment = &comment
	res.Ea = ea
	res.Ref = ref

	return res
}

// RecordDhcid represents Infoblox object record:dhcid.
// The DHCID DNS resource record (RR) is used to associate the DNS domain names
// with the DHCP clients using the domain names.
type RecordDhcid struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// The Base64 encoded DHCP client information.
	Dhcid string `json:"dhcid,omitempty"`

	// The name for the DHCID record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The name of the DHCID record in FQDN format.
	Name string `json:"name,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordDhcid) ObjectType() string {
	return "record:dhcid"
}

func (obj RecordDhcid) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordDname represents Infoblox object record:dname.
// A DNAME record maps all the names in one domain to those in another domain,
// essentially substituting one domain name suffix with the other.
type RecordDname struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The comment for the record.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled.
	Disable *bool `json:"disable,omitempty"`

	// Name of a DNS DNAME record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The target domain name of the DNS DNAME record in punycode format.
	DnsTarget string `json:"dns_target,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if reclamation is allowed for the record.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the DNS DNAME record in FQDN format.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The target domain name of the DNS DNAME record in FQDN format.
	Target *string `json:"target,omitempty"`

	// Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, that the record is valid (cached). Zero
	// indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides, for example
	// "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. For example: "zone.com".
	// If a view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordDname) ObjectType() string {
	return "record:dname"
}

func (obj RecordDname) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "target", "view"}
	}
	return obj.returnFields
}

// RecordDnskey represents Infoblox object record:dnskey.
// The DNSKEY resource record stores public keys for the DNSSEC authentication
// process. The DNSKEY records are generated automatically when the
// corresponding authoritative zone is signed. The DNSKEY resource record
// object is read-only.
type RecordDnskey struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The public key encryption algorithm of a DNSKEY Record object.
	Algorithm string `json:"algorithm,omitempty"`

	// The comment for the record.
	Comment string `json:"comment,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// Name of a DNSKEY record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The flags field is a 16-bit unsigned integer. Currently, only two bits of
	// this value are used: the least significant bit and bit 7. The other bits are
	// reserved for future use and must be zero. If bit 7 is set to 1, the key is a
	// DNS zone key. Otherwise, the key is not a zone key and cannot be used to
	// verify zone data. The least significant bit indicates "secure entry point
	// property". If it is not zero, the key is a key signing key (KSK type).
	// Otherwise, the key type is ZSK.
	Flags int `json:"flags,omitempty"`

	// The key tag identifying the public key of a DNSKEY Record object.
	KeyTag uint32 `json:"key_tag,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the DNSKEY record in FQDN format. It has to be the same as the
	// zone, where the record resides.
	Name string `json:"name,omitempty"`

	// The public key. The format of the returned value depends on the key
	// algorithm.
	PublicKey string `json:"public_key,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordDnskey) ObjectType() string {
	return "record:dnskey"
}

func (obj RecordDnskey) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordDs represents Infoblox object record:ds.
// The DS key record is a part of the DNS security extension records. The DS RR
// contains a hash of a child zone’s KSK and can be used as a trust anchor in
// some security-aware resolvers and to create a secure delegation point for a
// signed subzone in DNS servers. It is used to authorize the DNSKEY records of
// the child zone and thus to establish the DNSSEC chain of trust.
type RecordDs struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The algorithm of the DNSKEY RR to which this DS RR refers. It uses the same
	// algorithm values and types as the corresponding DNSKEY RR.
	Algorithm string `json:"algorithm,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The comment for the record.
	Comment string `json:"comment,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// Creator of the record.
	Creator string `json:"creator,omitempty"`

	// The digest of the DNSKEY resource record that is stored in a DS Record
	// object.
	Digest string `json:"digest,omitempty"`

	// The algorithm used to construct the digest.
	DigestType string `json:"digest_type,omitempty"`

	// The name for the DS record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The key tag value that is used to determine which key to use to verify
	// signatures.
	KeyTag uint32 `json:"key_tag,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the DNS DS record in FQDN format.
	Name string `json:"name,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordDs) ObjectType() string {
	return "record:ds"
}

func (obj RecordDs) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordDtclbdn represents Infoblox object record:dtclbdn.
// Load Balanced Domain Name (LBDN) is a Load balanced domain name record type,
// which is served by Infoblox Name Servers. LBDN is a qualified domain name
// associated with a specific service such as ftp.abc.com or www.abc.com. A
// LBDN record must be associated to a zone for which Infoblox is authoritative
// for. User may assign multiple “Resource Pools” to a LBDN record. User
// may also assign one or more DNS Distribution (Load balancing) methods an
// LBDN record. User must not be able to create multiple LBDNs for the same
// name.
type RecordDtclbdn struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the DTC LBDN record object; maximum 256 characters.
	Comment string `json:"comment,omitempty"`

	// Determines whether the DTC LBDN is disabled or not.
	Disable bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The DTC LBDN object.
	Lbdn string `json:"lbdn,omitempty"`

	// The display name of the DTC LBDN record.
	Name string `json:"name,omitempty"`

	// An FQDN pattern, LBDN wildcards can be used.
	Pattern string `json:"pattern,omitempty"`

	// The name of the DNS View in which the record resides.
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides.
	Zone string `json:"zone,omitempty"`
}

func (RecordDtclbdn) ObjectType() string {
	return "record:dtclbdn"
}

func (obj RecordDtclbdn) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "view", "zone"}
	}
	return obj.returnFields
}

// HostRecord represents Infoblox object record:host.
// A host record defines attributes for a node, such as the name-to-address and
// address-to-name mapping. This alleviates having to specify an A record and a
// PTR record separately for the same node. A host can also define aliases and
// DHCP fixed address nodes. The zone must be created first before adding a
// host record for the zone.
type HostRecord struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// This is a list of aliases for the host. The aliases must be in FQDN format.
	// This value can be in unicode format.
	Aliases []string `json:"aliases"`

	// This field controls whether the credential is used for both the Telnet and
	// SSH credentials. If set to False, the credential is used only for SSH.
	AllowTelnet *bool `json:"allow_telnet,omitempty"`

	// The CLI credentials for the host record.
	CliCredentials []*DiscoveryClicredential `json:"cli_credentials,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// When configure_for_dns is false, the host does not have parent zone
	// information.
	EnableDns *bool `json:"configure_for_dns,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// The description of the device.
	DeviceDescription *string `json:"device_description,omitempty"`

	// The location of the device.
	DeviceLocation *string `json:"device_location,omitempty"`

	// The type of the device.
	DeviceType *string `json:"device_type,omitempty"`

	// The vendor of the device.
	DeviceVendor *string `json:"device_vendor,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines if the discovery for the record is disabled or not. False means
	// that the discovery is enabled.
	DisableDiscovery *bool `json:"disable_discovery,omitempty"`

	// The list of aliases for the host in punycode format.
	DnsAliases []string `json:"dns_aliases,omitempty"`

	// The name for a host record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Determines if the discovery for the record should be immediately enabled.
	EnableImmediateDiscovery *bool `json:"enable_immediate_discovery,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// This is a list of IPv4 Addresses for the host.
	Ipv4Addrs []HostRecordIpv4Addr `json:"ipv4addrs"`

	// This is a list of IPv6 Addresses for the host.
	Ipv6Addrs []HostRecordIpv6Addr `json:"ipv6addrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The host name in FQDN format This value can be in unicode format. Regular
	// expression search is not supported for unicode values.
	Name *string `json:"name,omitempty"`

	// The name of the network view in which the host record resides.
	NetworkView string `json:"network_view,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The value of this field specifies the order in which resource record sets
	// are returned. The possible values are "cyclic", "random" and "fixed".
	RrsetOrder *string `json:"rrset_order,omitempty"`

	// The SNMPv3 credential for a host record.
	Snmp3Credential *DiscoverySnmp3credential `json:"snmp3_credential,omitempty"`

	// The SNMPv1 or SNMPv2 credential for a host record.
	SnmpCredential *DiscoverySnmpcredential `json:"snmp_credential,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// If set to true, the CLI credential will override member-level settings.
	UseCliCredentials *bool `json:"use_cli_credentials,omitempty"`

	// Determines if the SNMPv3 credential should be used for the record.
	UseSnmp3Credential *bool `json:"use_snmp3_credential,omitempty"`

	// If set to true, the SNMP credential will override member-level settings.
	UseSnmpCredential *bool `json:"use_snmp_credential,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (HostRecord) ObjectType() string {
	return "record:host"
}

func (obj HostRecord) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addrs", "ipv6addrs", "name", "view"}
	}
	return obj.returnFields
}

func NewEmptyHostRecord() *HostRecord {
	res := &HostRecord{}
	res.returnFields = []string{"extattrs", "ipv4addrs", "ipv6addrs", "name", "view", "zone", "comment", "network_view", "aliases", "use_ttl", "ttl", "configure_for_dns"}
	return res
}

func NewHostRecord(
	netView string,
	name string,
	ipv4Addr string,
	ipv6Addr string,
	ipv4AddrList []HostRecordIpv4Addr,
	ipv6AddrList []HostRecordIpv6Addr,
	eas EA,
	enableDNS bool,
	dnsView string,
	zone string,
	ref string,
	useTtl bool,
	ttl uint32,
	comment string,
	aliases []string,
	disable bool) *HostRecord {

	res := NewEmptyHostRecord()
	res.NetworkView = netView
	res.Name = &name
	res.Ea = eas
	res.View = &dnsView
	if *res.View == "" {
		res.View = nil
	}
	res.Zone = zone
	res.Ref = ref
	res.Comment = &comment
	res.Disable = &disable
	//res.Ipv4Addr = ipv4Addr
	//res.Ipv6Addr = ipv6Addr
	res.Ipv4Addrs = ipv4AddrList
	res.Ipv6Addrs = ipv6AddrList
	res.UseTtl = &useTtl
	res.Ttl = &ttl
	res.Aliases = aliases
	res.EnableDns = &enableDNS

	return res
}

// HostRecordIpv4Addr represents Infoblox object record:host_ipv4addr.
// A Host Address is an object used to specify addresses in the record.host
// object.
type HostRecordIpv4Addr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The name of the boot file the client must download.
	Bootfile *string `json:"bootfile,omitempty"`

	// The IP address or hostname of the boot file server where the boot file is
	// stored.
	Bootserver *string `json:"bootserver,omitempty"`

	// Set this to True to enable the DHCP configuration for this host address.
	EnableDhcp *bool `json:"configure_for_dhcp,omitempty"`

	// Set this to True to disable the BOOTP settings and deny BOOTP boot requests.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The discovery status of this Host Address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this Host Address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients. You can specify the duration of time it takes a host to
	// connect to a boot server, such as a TFTP server, and download the file it
	// needs to boot. For example, set a longer lease time if the client downloads
	// an OS (operating system) or configuration file, or set a shorter lease time
	// if the client downloads only configuration changes. Enter the lease time for
	// the preboot execution environment for hosts to boot remotely from a server.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// The host to which the host address belongs, in FQDN format. It is only
	// present when the host address object is not returned as part of a host.
	Host string `json:"host,omitempty"`

	// If this field is set to false, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreClientRequestedOptions *bool `json:"ignore_client_requested_options,omitempty"`

	// The IPv4 Address of the host.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// This flag reflects whether the MAC address for this host address is invalid.
	IsInvalidMac bool `json:"is_invalid_mac,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// This field contains the logic filters to be applied on the this host
	// address. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The MAC address for this host address.
	Mac *string `json:"mac,omitempty"`

	// Set this to 'MAC_ADDRESS' to assign the IP address to the selected host,
	// provided that the MAC address of the requesting host matches the MAC address
	// that you specify in the field. Set this to 'RESERVED' to reserve this
	// particular IP address for future use, or if the IP address is statically
	// configured on a system (the Infoblox server does not assign the address from
	// a DHCP request).
	MatchClient *string `json:"match_client,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network of the host address, in FQDN/CIDR format.
	Network string `json:"network,omitempty"`

	// The name of the network view in which the host address resides.
	NetworkView string `json:"network_view,omitempty"`

	// The name in FQDN format and/or IPv4 Address of the next server that the host
	// needs to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The lease time for PXE clients, see *enable_pxe_lease_time* for more
	// information.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// The reference to the reserved interface to which the device belongs.
	ReservedInterface *string `json:"reserved_interface,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Set this to True when using this host address for EA inheritance.
	UseForEaInheritance *bool `json:"use_for_ea_inheritance,omitempty"`

	// Use flag for: ignore_client_requested_options
	UseIgnoreClientRequestedOptions *bool `json:"use_ignore_client_requested_options,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`
}

func (HostRecordIpv4Addr) ObjectType() string {
	return "record:host_ipv4addr"
}

func (obj HostRecordIpv4Addr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"configure_for_dhcp", "host", "ipv4addr", "mac"}
	}
	return obj.returnFields
}

func NewEmptyHostRecordIpv4Addr() *HostRecordIpv4Addr {
	return &HostRecordIpv4Addr{}
}

func NewHostRecordIpv4Addr(
	ipAddr string,
	macAddr string,
	enableDhcp bool,
	ref string) *HostRecordIpv4Addr {

	res := NewEmptyHostRecordIpv4Addr()
	res.Ipv4Addr = &ipAddr
	res.Mac = &macAddr
	res.Ref = ref
	res.EnableDhcp = &enableDhcp

	return res
}

// HostRecordIpv6Addr represents Infoblox object record:host_ipv6addr.
// An IPv6 host address is an object used to specify addresses in the
// record.host object.
type HostRecordIpv6Addr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Type of the DHCP IPv6 Host Address object.
	AddressType string `json:"address_type,omitempty"`

	// Set this to True to enable the DHCP configuration for this IPv6 host
	// address.
	EnableDhcp *bool `json:"configure_for_dhcp,omitempty"`

	// The discovery status of this IPv6 Host Address.
	DiscoverNowStatus string `json:"discover_now_status,omitempty"`

	// The discovered data for this host address.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// Use this method to set or retrieve the domain_name value of the DHCP IPv6
	// Host Address object.
	DomainName *string `json:"domain_name,omitempty"`

	// The IPv6 addresses of DNS recursive name servers to which the DHCP client
	// can send name resolution requests. The DHCP server includes this information
	// in the DNS Recursive Name Server option in Advertise, Rebind,
	// Information-Request, and Reply messages.
	DomainNameServers []string `json:"domain_name_servers,omitempty"`

	// DHCPv6 Unique Identifier (DUID) of the address object.
	Duid *string `json:"duid,omitempty"`

	// The host to which the IPv6 host address belongs, in FQDN format. It is only
	// present when the host address object is not returned as part of a host.
	Host string `json:"host,omitempty"`

	// The IPv6 Address prefix of the DHCP IPv6 Host Address object.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The IPv6 Address prefix of the DHCP IPv6 Host Address object.
	Ipv6prefix *string `json:"ipv6prefix,omitempty"`

	// Prefix bits of the DHCP IPv6 Host Address object.
	Ipv6prefixBits *uint32 `json:"ipv6prefix_bits,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// This field contains the logic filters to be applied on the this host
	// address. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// Set this to 'DUID' to assign the IP address to the selected host, provided
	// that the DUID of the requesting host matches the DUID that you specify in
	// the field. Set this to 'RESERVED' to reserve this particular IP address for
	// future use, or if the IP address is statically configured on a system (the
	// Infoblox server does not assign the address from a DHCP request).
	MatchClient *string `json:"match_client,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The network of the host address, in FQDN/CIDR format.
	Network string `json:"network,omitempty"`

	// The name of the network view in which the host address resides.
	NetworkView string `json:"network_view,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// Use this method to set or retrieve the preferred lifetime value of the DHCP
	// IPv6 Host Address object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The reference to the reserved interface to which the device belongs.
	ReservedInterface *string `json:"reserved_interface,omitempty"`

	// Use flag for: domain_name
	UseDomainName *bool `json:"use_domain_name,omitempty"`

	// Use flag for: domain_name_servers
	UseDomainNameServers *bool `json:"use_domain_name_servers,omitempty"`

	// Set this to True when using this host address for EA inheritance.
	UseForEaInheritance *bool `json:"use_for_ea_inheritance,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// Use this method to set or retrieve the valid lifetime value of the DHCP IPv6
	// Host Address object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (HostRecordIpv6Addr) ObjectType() string {
	return "record:host_ipv6addr"
}

func (obj HostRecordIpv6Addr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"configure_for_dhcp", "duid", "host", "ipv6addr"}
	}
	return obj.returnFields
}

func NewEmptyHostRecordIpv6Addr() *HostRecordIpv6Addr {
	return &HostRecordIpv6Addr{}
}

func NewHostRecordIpv6Addr(
	ipAddr string,
	duid string,
	enableDhcp bool,
	ref string) *HostRecordIpv6Addr {

	res := NewEmptyHostRecordIpv6Addr()
	res.Ipv6Addr = &ipAddr
	res.Duid = &duid
	res.Ref = ref
	res.EnableDhcp = &enableDhcp

	return res
}

// RecordMX represents Infoblox object record:mx.
// An MX (mail exchanger) record maps a domain name to a mail exchanger. A mail
// exchanger is a server that either delivers or forwards mail. You can specify
// one or more mail exchangers for a zone, as well as the preference for using
// each mail exchanger. A standard MX record applies to a particular domain or
// subdomain.
type RecordMX struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The Mail exchanger name in punycode format.
	DnsMailExchanger string `json:"dns_mail_exchanger,omitempty"`

	// The name for a MX record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// Mail exchanger name in FQDN format. This value can be in unicode format.
	MailExchanger *string `json:"mail_exchanger,omitempty"`

	// Name for the MX record in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// Preference value, 0 to 65535 (inclusive) in 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordMX) ObjectType() string {
	return "record:mx"
}

func (obj RecordMX) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"mail_exchanger", "name", "preference", "view"}
	}
	return obj.returnFields
}

// RecordNaptr represents Infoblox object record:naptr.
// A DNS NAPTR object represents a Naming Authority Pointer (NAPTR) resource
// record. This resource record specifies a regular expression-based rewrite
// rule that, when applied to an existing string, produces a new domain name or
// URI.
type RecordNaptr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the NAPTR record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The replacement field of the NAPTR record in punycode format.
	DnsReplacement string `json:"dns_replacement,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The flags used to control the interpretation of the fields for an NAPTR
	// record object. Supported values for the flags field are "U", "S", "P" and
	// "A".
	Flags *string `json:"flags,omitempty"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the NAPTR record in FQDN format. This value can be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The order parameter of the NAPTR records. This parameter specifies the order
	// in which the NAPTR rules are applied when multiple rules are present. Valid
	// values are from 0 to 65535 (inclusive), in 32-bit unsigned integer format.
	Order *uint32 `json:"order,omitempty"`

	// The preference of the NAPTR record. The preference field determines the
	// order NAPTR records are processed when multiple records with the same order
	// parameter are present. Valid values are from 0 to 65535 (inclusive), in
	// 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The regular expression-based rewriting rule of the NAPTR record. This should
	// be a POSIX compliant regular expression, including the substitution rule and
	// flags. Refer to RFC 2915 for the field syntax details.
	Regexp *string `json:"regexp,omitempty"`

	// The replacement field of the NAPTR record object. For nonterminal NAPTR
	// records, this field specifies the next domain name to look up. This value
	// can be in unicode format.
	Replacement *string `json:"replacement,omitempty"`

	// The services field of the NAPTR record object; maximum 128 characters. The
	// services field contains protocol and service identifiers, such as "http+E2U"
	// or "SIPS+D2T".
	Services *string `json:"services,omitempty"`

	// The Time to Live (TTL) value for the NAPTR record. A 32-bit unsigned integer
	// that represents the duration, in seconds, for which the record is valid
	// (cached). Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordNaptr) ObjectType() string {
	return "record:naptr"
}

func (obj RecordNaptr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "order", "preference", "regexp", "replacement", "services", "view"}
	}
	return obj.returnFields
}

// RecordNS represents Infoblox object record:ns.
// A DNS NS record identifies an authoritative DNS server for a domain. Each
// authoritative DNS server must have an NS record. The appliance automatically
// creates an NS record when you assign a grid member as the primary server for
// a zone. You can manually create NS records for other zones.
type RecordNS struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of zone name servers.
	Addresses []*ZoneNameServer `json:"addresses,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// The name of the NS record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The MS delegation point name.
	MsDelegationName *string `json:"ms_delegation_name,omitempty"`

	// The name of the NS record in FQDN format. This value can be in unicode
	// format.
	Name string `json:"name,omitempty"`

	// The domain name of an authoritative server for the redirected zone.
	Nameserver *string `json:"nameserver,omitempty"`

	// The host name policy for the record.
	Policy string `json:"policy,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordNS) ObjectType() string {
	return "record:ns"
}

func (obj RecordNS) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "nameserver", "view"}
	}
	return obj.returnFields
}

// RecordNsec represents Infoblox object record:nsec.
// NSEC resource record is one of the resource records included in the DNS
// security extension mechanism (DNSSEC). This record is used to provide
// authenticated denial of existence of a resource record in response to a
// resolver query.
type RecordNsec struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Time that the record was created.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// Creator of the record.
	Creator string `json:"creator,omitempty"`

	// Name for an NSEC record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Name of the next owner in punycode format.
	DnsNextOwnerName string `json:"dns_next_owner_name,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the NSEC record in FQDN format.
	Name string `json:"name,omitempty"`

	// Name of the next owner that has authoritative data or that contains a
	// delegation point NS record.
	NextOwnerName string `json:"next_owner_name,omitempty"`

	// The RRSet types that exist at the original owner name of the NSEC RR.
	RrsetTypes []string `json:"rrset_types,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordNsec) ObjectType() string {
	return "record:nsec"
}

func (obj RecordNsec) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordNsec3 represents Infoblox object record:nsec3.
// When a name server receives a request for a domain name that does not exist
// in a zone, the name server sends an authenticated negative response in the
// form of an NSEC or NSEC3 RR. NSEC and NSEC3 records contain the next secure
// domain name in a zone and list the RR types present at the NSEC or NSEC3
// RR’s owner name. The difference between an NSEC and NSEC3 RRs is that the
// owner name in an NSEC3 RR is a cryptographic hash of the original owner name
// prepended to the name of the zone. NSEC3 RRs protect against zone
// enumeration.
type RecordNsec3 struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The hash algorithm that was used.
	Algorithm string `json:"algorithm,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// Creator of the record.
	Creator string `json:"creator,omitempty"`

	// Name for an NSEC3 record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The set of 8 one-bit flags, of which only one flag, the Opt-Out flag, is
	// defined by RFC 5155. The Opt-Out flag indicates whether the NSEC3 record
	// covers unsigned delegations.
	Flags uint32 `json:"flags,omitempty"`

	// The number of times the hash function was performed.
	Iterations uint32 `json:"iterations,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the NSEC3 record in FQDN format.
	Name string `json:"name,omitempty"`

	// The hashed next owner name that has authoritative data or that contains a
	// delegation point NS record.
	NextOwnerName string `json:"next_owner_name,omitempty"`

	// The RRSet types that exist at the original owner name of the NSEC3 RR.
	RrsetTypes []string `json:"rrset_types,omitempty"`

	// A series of case-insensitive hexadecimal digits. It is appended to the
	// original owner name as protection against pre-calculated dictionary attacks.
	// A new salt value is generated when ZSK rolls over. You can control the
	// period of the rollover. For random salt values, the selected length is
	// between one and 15 octets.
	Salt string `json:"salt,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordNsec3) ObjectType() string {
	return "record:nsec3"
}

func (obj RecordNsec3) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordNsec3param represents Infoblox object record:nsec3param.
// An authoritative DNS server uses NSEC3PARAM RRs to determine which NSEC3
// records it includes in its negative responses. An NSEC3PARAM RR contains the
// parameters that an authoritative server needs to calculate hashed owner
// names. As stated in RFC 5155, the presence of an NSEC3PARAM RR at a zone
// apex indicates that the specified parameters may be used by authoritative
// servers to choose an appropriate set of NSEC3 RRs for negative responses.
type RecordNsec3param struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The hash algorithm that was used.
	Algorithm string `json:"algorithm,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// Creator of the record.
	Creator string `json:"creator,omitempty"`

	// Name for an NSEC3PARAM record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The set of 8 one-bit flags, of which only one flag, the Opt-Out flag, is
	// defined by RFC 5155. The Opt-Out flag indicates whether the NSEC3 record
	// covers unsigned delegations.
	Flags uint32 `json:"flags,omitempty"`

	// The number of times the hash function was performed.
	Iterations uint32 `json:"iterations,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the NSEC3PARAM record in FQDN format. It has to be the same as
	// the zone, where the record resides.
	Name string `json:"name,omitempty"`

	// A series of case-insensitive hexadecimal digits. It is appended to the
	// original owner name as protection against pre-calculated dictionary attacks.
	// A new salt value is generated when the ZSK rolls over, for which the user
	// can control the period. For a random salt value, the selected length is
	// between one and 15 octets.
	Salt string `json:"salt,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordNsec3param) ObjectType() string {
	return "record:nsec3param"
}

func (obj RecordNsec3param) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordPTR represents Infoblox object record:ptr.
// In a forward-mapping zone, a PTR (pointer) record maps a domain name to
// another domain name. In a reverse-mapping zone, a PTR (pointer) record maps
// an address to a domain name. To define a specific address-to-name mapping,
// add a PTR record to a previously defined authoritative reverse-mapping zone.
type RecordPTR struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The discovered data for this PTR record.
	DiscoveredData *Discoverydata `json:"discovered_data,omitempty"`

	// The name for a DNS PTR record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The domain name of the DNS PTR record in punycode format.
	DnsPtrdname string `json:"dns_ptrdname,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The IPv4 Address of the record.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The IPv6 Address of the record.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The name of the DNS PTR record in FQDN format.
	Name *string `json:"name,omitempty"`

	// The domain name of the DNS PTR record in FQDN format.
	PtrdName *string `json:"ptrdname,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, that the record is valid (cached). Zero
	// indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// Name of the DNS View in which the record resides, for example "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. For example: "zone.com".
	// If a view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordPTR) ObjectType() string {
	return "record:ptr"
}

func (obj RecordPTR) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ptrdname", "view"}
	}
	return obj.returnFields
}

func NewEmptyRecordPTR() *RecordPTR {
	res := RecordPTR{}
	res.returnFields = []string{"extattrs", "ipv4addr", "ipv6addr", "name", "ptrdname", "view", "zone", "comment", "use_ttl", "ttl"}

	return &res
}

func NewRecordPTR(dnsView string, ptrdname string, useTtl bool, ttl uint32, comment string, ea EA) *RecordPTR {
	res := NewEmptyRecordPTR()
	res.View = dnsView
	res.PtrdName = &ptrdname
	res.UseTtl = &useTtl
	res.Ttl = &ttl
	res.Comment = &comment
	res.Ea = ea

	return res
}

// RecordRpzA represents Infoblox object record:rpz:a.
// An RPZ Substitute (A Record) Rule maps a domain name to a substitute IPv4
// address. To define a specific name-to-address mapping, add an Substitute (A
// Record) Rule to a previously defined Response Policy Zone.
type RecordRpzA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv4 Address of the substitute rule.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzA) ObjectType() string {
	return "record:rpz:a"
}

func (obj RecordRpzA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzAIpaddress represents Infoblox object record:rpz:a:ipaddress.
// An RPZ AIpAddress is an Substitute (IPv4 Address) Rule that maps an IP
// address represented by a host name to a substitute IPv4 address. To define a
// specific address-to-address mapping, add an Substitute (IPv4 Address) Rule
// to a previously defined Response Policy Zone.
type RecordRpzAIpaddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv4 Address of the substitute rule.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzAIpaddress) ObjectType() string {
	return "record:rpz:a:ipaddress"
}

func (obj RecordRpzAIpaddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzAaaa represents Infoblox object record:rpz:aaaa.
// An RPZ Substitute (AAAA Record) Rule, maps a domain name to a substitute
// IPv6 address. To define a specific name-to-address mapping, add an
// Substitute (AAAA Record) Rule to a previously defined Response Policy Zone.
type RecordRpzAaaa struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv6 Address of the substitute rule.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzAaaa) ObjectType() string {
	return "record:rpz:aaaa"
}

func (obj RecordRpzAaaa) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv6addr", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzAaaaIpaddress represents Infoblox object record:rpz:aaaa:ipaddress.
// An RPZ Substitute (IPv6 Address) Rule maps an IP address represented by a
// host name to a substitute IPv6 address. To define a specific
// address-to-address mapping, add an RPZ Substitute (IPv6 Address) Rule to a
// previously defined Response Policy Zone.
type RecordRpzAaaaIpaddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv6 Address of the substitute rule.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzAaaaIpaddress) ObjectType() string {
	return "record:rpz:aaaa:ipaddress"
}

func (obj RecordRpzAaaaIpaddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv6addr", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzCname represents Infoblox object record:rpz:cname.
// An RPZ CNAME record represents different RPZ rules, depending on the value
// of the canonical name. The intention of this object is to support QNAME
// Trigger policy. The QNAME policy trigger applies to requested domain names
// (QNAME). This record represents Passthru Domain Name Rule, Block Domain Name
// (No Such Domain) Rule, Block Domain Name (No Data) Rule and Substitute
// (Domain Name) Rule.
type RecordRpzCname struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzCname) ObjectType() string {
	return "record:rpz:cname"
}

func (obj RecordRpzCname) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzCnameClientipaddress represents Infoblox object record:rpz:cname:clientipaddress.
// A DNS RPZ CNAMEClientIpAddress record represents different RPZ rules,
// depending on the value of the canonical name. This record represents
// Passthru IP Address Rule, Block IP Address (No Such Domain) Rule, Block IP
// Address (No Data) Rule.
type RecordRpzCnameClientipaddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Indicates whether the record is an IPv4 record. If the return value is
	// "true", it is an IPv4 record. Ohterwise, it is an IPv6 record.
	IsIpv4 bool `json:"is_ipv4,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzCnameClientipaddress) ObjectType() string {
	return "record:rpz:cname:clientipaddress"
}

func (obj RecordRpzCnameClientipaddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzCnameClientipaddressdn represents Infoblox object record:rpz:cname:clientipaddressdn.
// A DNS Substitute Domain Name (Based on Client IP Address) rule represents
// different Response Policy Zone (RPZ) rules, depending on the value of the
// canonical name.
type RecordRpzCnameClientipaddressdn struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Indicates whether the record is an IPv4 record. If the return value is
	// "true", it is an IPv4 record. Ohterwise, it is an IPv6 record.
	IsIpv4 bool `json:"is_ipv4,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzCnameClientipaddressdn) ObjectType() string {
	return "record:rpz:cname:clientipaddressdn"
}

func (obj RecordRpzCnameClientipaddressdn) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzCnameIpaddress represents Infoblox object record:rpz:cname:ipaddress.
// A DNS RPZ CNAMEIpAddress record represents different RPZ rules, depending on
// the value of the canonical name. This record represents Passthru IP Address
// Rule, Block IP Address (No Such Domain) Rule, Block IP Address (No Data)
// Rule.
type RecordRpzCnameIpaddress struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Indicates whether the record is an IPv4 record. If the return value is
	// "true", it is an IPv4 record. Ohterwise, it is an IPv6 record.
	IsIpv4 bool `json:"is_ipv4,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzCnameIpaddress) ObjectType() string {
	return "record:rpz:cname:ipaddress"
}

func (obj RecordRpzCnameIpaddress) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzCnameIpaddressdn represents Infoblox object record:rpz:cname:ipaddressdn.
// A DNS Substitute Domain Name (Based on IP Address) rule represents different
// Response Policy Zone (RPZ) rules, depending on the value of the canonical
// name.
type RecordRpzCnameIpaddressdn struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Indicates whether the record is an IPv4 record. If the return value is
	// "true", it is an IPv4 record. Ohterwise, it is an IPv6 record.
	IsIpv4 bool `json:"is_ipv4,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzCnameIpaddressdn) ObjectType() string {
	return "record:rpz:cname:ipaddressdn"
}

func (obj RecordRpzCnameIpaddressdn) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "view"}
	}
	return obj.returnFields
}

// RecordRpzMx represents Infoblox object record:rpz:mx.
// An RPZ Substitute (MX Record) Rule maps a domain name to a mail exchanger. A
// mail exchanger is a server that either delivers or forwards mail.
type RecordRpzMx struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Mail exchanger name in FQDN format. This value can be in unicode format.
	MailExchanger *string `json:"mail_exchanger,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// Preference value, 0 to 65535 (inclusive) in 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzMx) ObjectType() string {
	return "record:rpz:mx"
}

func (obj RecordRpzMx) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"mail_exchanger", "name", "preference", "view"}
	}
	return obj.returnFields
}

// RecordRpzNaptr represents Infoblox object record:rpz:naptr.
// An RPZ Substitute (NAPTR Record) Rule object represents the substitution
// rule for DNS Naming Authority Pointer (NAPTR) records. This rule specifies a
// regular expression-based rewrite rule that, when applied to an existing
// string, produces a new domain name or URI.
type RecordRpzNaptr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The flags used to control the interpretation of the fields for a Substitute
	// (NAPTR Record) Rule object. Supported values for the flags field are "U",
	// "S", "P" and "A".
	Flags *string `json:"flags,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The order parameter of the Substitute (NAPTR Record) Rule records. This
	// parameter specifies the order in which the NAPTR rules are applied when
	// multiple rules are present. Valid values are from 0 to 65535 (inclusive), in
	// 32-bit unsigned integer format.
	Order *uint32 `json:"order,omitempty"`

	// The preference of the Substitute (NAPTR Record) Rule record. The preference
	// field determines the order NAPTR records are processed when multiple records
	// with the same order parameter are present. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// The regular expression-based rewriting rule of the Substitute (NAPTR Record)
	// Rule record. This should be a POSIX compliant regular expression, including
	// the substitution rule and flags. Refer to RFC 2915 for the field syntax
	// details.
	Regexp *string `json:"regexp,omitempty"`

	// The replacement field of the Substitute (NAPTR Record) Rule object. For
	// nonterminal NAPTR records, this field specifies the next domain name to look
	// up. This value can be in unicode format.
	Replacement *string `json:"replacement,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The services field of the Substitute (NAPTR Record) Rule object; maximum 128
	// characters. The services field contains protocol and service identifiers,
	// such as "http+E2U" or "SIPS+D2T".
	Services *string `json:"services,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzNaptr) ObjectType() string {
	return "record:rpz:naptr"
}

func (obj RecordRpzNaptr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "order", "preference", "regexp", "replacement", "services", "view"}
	}
	return obj.returnFields
}

// RecordRpzPtr represents Infoblox object record:rpz:ptr.
// An RPZ Substitute (PTR Record) Rule object represents a Pointer (PTR)
// resource record. To define a specific address-to-name mapping, add an RPZ
// Substitute (PTR Record) Rule to a previously defined Response Policy Zone.
type RecordRpzPtr struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv4 Address of the substitute rule.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// The IPv6 Address of the substitute rule.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// The name of the RPZ Substitute (PTR Record) Rule object in FQDN format.
	Name *string `json:"name,omitempty"`

	// The domain name of the RPZ Substitute (PTR Record) Rule object in FQDN
	// format.
	PtrdName *string `json:"ptrdname,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzPtr) ObjectType() string {
	return "record:rpz:ptr"
}

func (obj RecordRpzPtr) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ptrdname", "view"}
	}
	return obj.returnFields
}

// RecordRpzSrv represents Infoblox object record:rpz:srv.
// An RPZ Substitute (SRV Record) Rule object represents the substitution rule
// for DNS SRV records.
type RecordRpzSrv struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The port of the Substitute (SRV Record) Rule. Valid values are from 0 to
	// 65535 (inclusive), in 32-bit unsigned integer format.
	Port *uint32 `json:"port,omitempty"`

	// The priority of the Substitute (SRV Record) Rule. Valid values are from 0 to
	// 65535 (inclusive), in 32-bit unsigned integer format.
	Priority *uint32 `json:"priority,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// The target of the Substitute (SRV Record) Rule in FQDN format. This value
	// can be in unicode format.
	Target *string `json:"target,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The weight of the Substitute (SRV Record) Rule. Valid values are from 0 to
	// 65535 (inclusive), in 32-bit unsigned integer format.
	Weight *uint32 `json:"weight,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzSrv) ObjectType() string {
	return "record:rpz:srv"
}

func (obj RecordRpzSrv) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "port", "priority", "target", "view", "weight"}
	}
	return obj.returnFields
}

// RecordRpzTxt represents Infoblox object record:rpz:txt.
// An RPZ Substitute (TXT Record) Rule object represents the substitution rule
// for DNS TXT records.
type RecordRpzTxt struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name for a record in FQDN format. This value cannot be in unicode
	// format.
	Name *string `json:"name,omitempty"`

	// The name of a response policy zone in which the record resides.
	RpZone *string `json:"rp_zone,omitempty"`

	// Text associated with the record. It can contain up to 255 bytes per
	// substring, up to a total of 512 bytes. To enter leading, trailing, or
	// embedded spaces in the text, add quotes around the text to preserve the
	// spaces.
	Text *string `json:"text,omitempty"`

	// The Time To Live (TTL) value for record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRpzTxt) ObjectType() string {
	return "record:rpz:txt"
}

func (obj RecordRpzTxt) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "text", "view"}
	}
	return obj.returnFields
}

// RecordRrsig represents Infoblox object record:rrsig.
// RRSIG records are one of the resource records in DNSSEC. These records store
// digital signatures of resource record sets (RRsets). Digital signatures are
// used to authenticate data that is in the signed RRsets.
type RecordRrsig struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The cryptographic algorithm that was used to create the signature. It uses
	// the same algorithm types as the DNSKEY record indicated in the key tag
	// field.
	Algorithm string `json:"algorithm,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// The creation time of the record.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator.
	Creator string `json:"creator,omitempty"`

	// Name for an RRSIG record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The domain name, in punycode format, of the zone that contains the signed
	// RRset.
	DnsSignerName string `json:"dns_signer_name,omitempty"`

	// The expiry time of an RRSIG record in Epoch seconds format.
	ExpirationTime *UnixTime `json:"expiration_time,omitempty"`

	// The inception time of an RRSIG record in Epoch seconds format.
	InceptionTime *UnixTime `json:"inception_time,omitempty"`

	// The key tag value of the DNSKEY RR that validates the signature.
	KeyTag uint32 `json:"key_tag,omitempty"`

	// The number of labels in the name of the RRset signed with the RRSIG object.
	Labels uint32 `json:"labels,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The name of the RRSIG record in FQDN format.
	Name string `json:"name,omitempty"`

	// The TTL value of the RRset covered by the RRSIG record.
	OriginalTtl uint32 `json:"original_ttl,omitempty"`

	// The Base64 encoded cryptographic signature that covers the RRSIG RDATA of
	// the RRSIG Record object.
	Signature string `json:"signature,omitempty"`

	// The domain name of the zone in FQDN format that contains the signed RRset.
	SignerName string `json:"signer_name,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl uint32 `json:"ttl,omitempty"`

	// The RR type covered by the RRSIG record.
	TypeCovered string `json:"type_covered,omitempty"`

	// Use flag for: ttl
	UseTtl bool `json:"use_ttl,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordRrsig) ObjectType() string {
	return "record:rrsig"
}

func (obj RecordRrsig) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordSRV represents Infoblox object record:srv.
// A DNS SRV object represents an SRV resource record, which is also known as a
// service record. An SRV record provides information on available services.
type RecordSRV struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for an SRV record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The name for a SRV record in punycode format.
	DnsTarget string `json:"dns_target,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// A name in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The port of the SRV record. Valid values are from 0 to 65535 (inclusive), in
	// 32-bit unsigned integer format.
	Port *uint32 `json:"port,omitempty"`

	// The priority of the SRV record. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Priority *uint32 `json:"priority,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// The target of the SRV record in FQDN format. This value can be in unicode
	// format.
	Target *string `json:"target,omitempty"`

	// The Time to Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The weight of the SRV record. Valid values are from 0 to 65535 (inclusive),
	// in 32-bit unsigned integer format.
	Weight *uint32 `json:"weight,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordSRV) ObjectType() string {
	return "record:srv"
}

func (obj RecordSRV) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "port", "priority", "target", "view", "weight"}
	}
	return obj.returnFields
}

// RecordTlsa represents Infoblox object record:tlsa.
// The TLSA DNS resource record (RR) is used to associate a TLS server
// certificate or public key with the domain name where the record is found,
// thus forming a ‘TLSA certificate association’. For further details see
// RFC-6698. Note that you must specify only one view for the attribute
// ‘views’.
type RecordTlsa struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Hex dump of either raw data for matching type 0, or the hash of the raw data
	// for matching types 1 and 2.
	CertificateData *string `json:"certificate_data,omitempty"`

	// Specifies the provided association that will be used to match the
	// certificate presented in the TLS handshake. Based on RFC-6698.
	CertificateUsage *uint32 `json:"certificate_usage,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the TLSA record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// Specifies how the certificate association is presented. Based on RFC-6698.
	MatchedType *uint32 `json:"matched_type,omitempty"`

	// The TLSA record name in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// Specifies which part of the TLS certificate presented by the server will be
	// matched against the association data. Based on RFC-6698.
	Selector *uint32 `json:"selector,omitempty"`

	// The Time to Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordTlsa) ObjectType() string {
	return "record:tlsa"
}

func (obj RecordTlsa) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// RecordTXT represents Infoblox object record:txt.
// A TXT (text record) record contains supplemental information for a host. For
// example, if you have a sales server that serves only North America, you can
// create a text record stating this fact. You can create more than one text
// record for a domain name.
type RecordTXT struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Aws Route 53 record information.
	AwsRte53RecordInfo *Awsrte53recordinfo `json:"aws_rte53_record_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The time of the record creation in Epoch seconds format.
	CreationTime *UnixTime `json:"creation_time,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// The GSS-TSIG principal that owns this record.
	DdnsPrincipal *string `json:"ddns_principal,omitempty"`

	// Determines if the DDNS updates for this record are allowed or not.
	DdnsProtected *bool `json:"ddns_protected,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for a TXT record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Determines if the reclamation is allowed for the record or not.
	ForbidReclamation *bool `json:"forbid_reclamation,omitempty"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// Name for the TXT record in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// Determines if the record is reclaimable or not.
	Reclaimable bool `json:"reclaimable,omitempty"`

	// The name of the shared record group in which the record resides. This field
	// exists only on db_objects if this record is a shared record.
	SharedRecordGroup string `json:"shared_record_group,omitempty"`

	// Text associated with the record. It can contain up to 255 bytes per
	// substring, up to a total of 512 bytes. To enter leading, trailing, or
	// embedded spaces in the text, add quotes around the text to preserve the
	// spaces.
	Text *string `json:"text,omitempty"`

	// The Time To Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordTXT) ObjectType() string {
	return "record:txt"
}

func (obj RecordTXT) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "text", "view"}
	}
	return obj.returnFields
}

func NewEmptyRecordTXT() *RecordTXT {
	res := RecordTXT{}
	res.returnFields = []string{"view", "zone", "name", "text", "ttl", "use_ttl", "comment", "extattrs"}

	return &res
}

func NewRecordTXT(
	dnsview string,
	zone string,
	recordname string,
	text string,
	ttl uint32,
	useTtl bool,
	comment string,
	eas EA) *RecordTXT {

	res := NewEmptyRecordTXT()
	res.View = &dnsview
	if *res.View == "" {
		res.View = nil
	}
	res.Zone = zone
	res.Name = &recordname
	res.Text = &text
	res.Ttl = &ttl
	res.UseTtl = &useTtl
	res.Comment = &comment
	res.Ea = eas

	return res
}

// RecordUnknown represents Infoblox object record:unknown.
// An “RR of unknown type” is an RR whose RDATA format is not known to the
// DNS implementation at hand, and whose type is not an assigned QTYPE or
// Meta-TYPE as specified in 2929] nor within the range reserved in that
// section for assignment only to QTYPEs and Meta-TYPEs. The purpose of the
// Unknown resource record is to allow future DNS implementations to handle new
// RR types transparently. For further details see RFC-3597.
type RecordUnknown struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The record creator. Note that changing creator from or to 'SYSTEM' value is
	// not allowed.
	Creator string `json:"creator,omitempty"`

	// Determines if the record is disabled or not. False means that the record is
	// enabled.
	Disable *bool `json:"disable,omitempty"`

	// Standard textual representation of the RDATA.
	DisplayRdata string `json:"display_rdata,omitempty"`

	// The name of the unknown record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Determines if host name policy is applicable for the record.
	EnableHostNamePolicy *bool `json:"enable_host_name_policy,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The time of the last DNS query in Epoch seconds format.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// The Unknown record name in FQDN format. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The host name policy for the record.
	Policy string `json:"policy,omitempty"`

	// Specifies type of unknown resource record.
	RecordType *string `json:"record_type,omitempty"`

	// The list of rdata subfield values of unknown resource record.
	SubfieldValues []*Rdatasubfield `json:"subfield_values,omitempty"`

	// The Time to Live (TTL) value for the record. A 32-bit unsigned integer that
	// represents the duration, in seconds, for which the record is valid (cached).
	// Zero indicates that the record should not be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The name of the DNS view in which the record resides. Example: "external".
	View *string `json:"view,omitempty"`

	// The name of the zone in which the record resides. Example: "zone.com". If a
	// view is not specified when searching by zone, the default view is used.
	Zone string `json:"zone,omitempty"`
}

func (RecordUnknown) ObjectType() string {
	return "record:unknown"
}

func (obj RecordUnknown) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "view"}
	}
	return obj.returnFields
}

// Recordnamepolicy represents Infoblox object recordnamepolicy.
// You can enforce naming policy for the hostnames of A, AAAA, Host, MX, NS and
// bulk host records based on user-defined or default patterns. For MX and NS
// records, the hostname restrictions apply to the text in the RDATA field of
// the resource record name. Records that you created before you enabled the
// hostname checking policy need not to comply with the hostname restriction
// that you specify.
type Recordnamepolicy struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the record name policy is Grid default.
	IsDefault *bool `json:"is_default,omitempty"`

	// The name of the record name policy object.
	Name *string `json:"name,omitempty"`

	// Determines whether the record name policy is a predefined one.
	PreDefined bool `json:"pre_defined,omitempty"`

	// The POSIX regular expression the record names should match in order to
	// comply with the record name policy.
	Regex *string `json:"regex,omitempty"`
}

func (Recordnamepolicy) ObjectType() string {
	return "recordnamepolicy"
}

func (obj Recordnamepolicy) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"is_default", "name", "regex"}
	}
	return obj.returnFields
}

// Restartservicestatus represents Infoblox object restartservicestatus.
// This object represents the service status. Use the the
// requestrestartservicestatus function call in object grid or the
// requestrestartservicestatus function call in object member to refresh the
// status.
type Restartservicestatus struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The status of the DHCP service.
	DhcpStatus string `json:"dhcp_status,omitempty"`

	// The status of the DNS service.
	DnsStatus string `json:"dns_status,omitempty"`

	// The name of this Grid member in FQDN format.
	Member string `json:"member,omitempty"`

	// The status of the reporting service.
	ReportingStatus string `json:"reporting_status,omitempty"`
}

func (Restartservicestatus) ObjectType() string {
	return "restartservicestatus"
}

func (obj Restartservicestatus) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"dhcp_status", "dns_status", "member", "reporting_status"}
	}
	return obj.returnFields
}

// Rir represents Infoblox object rir.
// An RIR is an entity that manages the Internet number resources, which
// include IP addresses and autonomous system numbers, within a specific region
// of the world. RIRs use SWIP (Shared WHOIS Project) or RWhois (Referral
// WHOIS) servers to provide address allocation information for IP address
// blocks. Typically, an RIR determines the address blocks to be allocated for
// specific organizations (typically ISPs), while an ISP manages the allocated
// address blocks, associated organizations and corresponding RIR
// registrations. An organization can determine when to request for more
// address data with their RIRs every few months.
type Rir struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The communication mode for RIR.
	CommunicationMode string `json:"communication_mode,omitempty"`

	// The e-mail address for RIR.
	Email *string `json:"email,omitempty"`

	// The name of RIR.
	Name string `json:"name,omitempty"`

	// The WebAPI URL for RIR.
	Url *string `json:"url,omitempty"`

	// Use flag for: email
	UseEmail *bool `json:"use_email,omitempty"`

	// Use flag for: url
	UseUrl *bool `json:"use_url,omitempty"`
}

func (Rir) ObjectType() string {
	return "rir"
}

func (obj Rir) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"communication_mode", "email", "name", "url"}
	}
	return obj.returnFields
}

// RirOrganization represents Infoblox object rir:organization.
// An RIR organization provides information about an entity that has registered
// a network resource in the RIPE database. This entity can be a company (such
// as an ISP), a nonprofit group, or an individual. You can add RIR
// organizations defined in the RIPE database and start managing their data
// through NIOS.
type RirOrganization struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The RIR organization identifier.
	Id *string `json:"id,omitempty"`

	// The RIR organization maintainer.
	Maintainer *string `json:"maintainer,omitempty"`

	// The RIR organization name.
	Name *string `json:"name,omitempty"`

	// The password for the maintainer of RIR organization.
	Password *string `json:"password,omitempty"`

	// The RIR associated with RIR organization.
	Rir *string `json:"rir,omitempty"`

	// The sender e-mail address for RIR organization.
	SenderEmail *string `json:"sender_email,omitempty"`
}

func (RirOrganization) ObjectType() string {
	return "rir:organization"
}

func (obj RirOrganization) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"id", "maintainer", "name", "rir", "sender_email"}
	}
	return obj.returnFields
}

// RoamingHost represents Infoblox object roaminghost.
// A roaming host is a specific host that a DHCP server always assigns when a
// lease request comes from a particular MAC address of the client.
type RoamingHost struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The address type for this roaming host.
	AddressType string `json:"address_type,omitempty"`

	// The bootfile name for the roaming host. You can configure the DHCP server to
	// support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The boot server address for the roaming host. You can specify the name
	// and/or IP address of the boot server that the host needs to boot. The boot
	// server IPv4 Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// This field controls whether there is a prepend for the
	// dhcp-client-identifier of a roaming host.
	ClientIdentifierPrependZero *bool `json:"client_identifier_prepend_zero,omitempty"`

	// Comment for the roaming host; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// The DDNS domain name for this roaming host.
	DdnsDomainname *string `json:"ddns_domainname,omitempty"`

	// The DDNS host name for this roaming host.
	DdnsHostname *string `json:"ddns_hostname,omitempty"`

	// If set to true, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The DHCP client ID for the roaming host.
	DhcpClientIdentifier *string `json:"dhcp_client_identifier,omitempty"`

	// Determines whether a roaming host is disabled or not. When this is set to
	// False, the roaming host is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The dynamic DNS updates flag of the roaming host object. If set to True, the
	// DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Set this to True to use the roaming host name as its ddns_hostname.
	ForceRoamingHostname *bool `json:"force_roaming_hostname,omitempty"`

	// If this field is set to False, the appliance returns all the DHCP options
	// the client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// The client hostname of a DHCP roaming host object. This field specifies the
	// host name that the DHCP client sends to the Infoblox appliance using DHCP
	// option 12.
	Ipv6ClientHostname string `json:"ipv6_client_hostname,omitempty"`

	// The IPv6 DDNS domain name for this roaming host.
	Ipv6DdnsDomainname *string `json:"ipv6_ddns_domainname,omitempty"`

	// The IPv6 DDNS host name for this roaming host.
	Ipv6DdnsHostname *string `json:"ipv6_ddns_hostname,omitempty"`

	// The IPv6 domain name for this roaming host.
	Ipv6DomainName *string `json:"ipv6_domain_name,omitempty"`

	// The IPv6 addresses of DNS recursive name servers to which the DHCP client
	// can send name resolution requests. The DHCP server includes this information
	// in the DNS Recursive Name Server option in Advertise, Rebind,
	// Information-Request, and Reply messages.
	Ipv6DomainNameServers []string `json:"ipv6_domain_name_servers,omitempty"`

	// The DUID value for this roaming host.
	Ipv6Duid *string `json:"ipv6_duid,omitempty"`

	// Set this to True to enable IPv6 DDNS.
	Ipv6EnableDdns *bool `json:"ipv6_enable_ddns,omitempty"`

	// Set this to True to use the roaming host name as its ddns_hostname.
	Ipv6ForceRoamingHostname *bool `json:"ipv6_force_roaming_hostname,omitempty"`

	// The identification method for an IPv6 or mixed IPv4/IPv6 roaming host.
	// Currently, the only supported value for this field is "DUID", which
	// corresponds to identification by DHCPv6 unique ID.
	Ipv6MatchOption string `json:"ipv6_match_option,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Ipv6Options []*Dhcpoption `json:"ipv6_options,omitempty"`

	// If set on creation, the roaming host will be created according to the values
	// specified in the named IPv6 roaming host template.
	Ipv6Template string `json:"ipv6_template,omitempty"`

	// The MAC address for this roaming host.
	Mac *string `json:"mac,omitempty"`

	// The match-client value for this roaming host. Valid values are:
	// "MAC_ADDRESS": The fixed IP address is leased to the matching MAC address.
	// "CLIENT_ID": The fixed IP address is leased to the matching DHCP client
	// identifier.
	MatchClient string `json:"match_client,omitempty"`

	// The name of this roaming host.
	Name *string `json:"name,omitempty"`

	// The name of the network view in which this roaming host resides.
	NetworkView *string `json:"network_view,omitempty"`

	// The name in FQDN and/or IPv4 Address format of the next server that the host
	// needs to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The preferred lifetime value for this roaming host object.
	PreferredLifetime *uint32 `json:"preferred_lifetime,omitempty"`

	// The PXE lease time value for this roaming host object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// If set on creation, the roaming host will be created according to the values
	// specified in the named template.
	Template string `json:"template,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_domainname
	UseDdnsDomainname *bool `json:"use_ddns_domainname,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ipv6_ddns_domainname
	UseIpv6DdnsDomainname *bool `json:"use_ipv6_ddns_domainname,omitempty"`

	// Use flag for: ipv6_domain_name
	UseIpv6DomainName *bool `json:"use_ipv6_domain_name,omitempty"`

	// Use flag for: ipv6_domain_name_servers
	UseIpv6DomainNameServers *bool `json:"use_ipv6_domain_name_servers,omitempty"`

	// Use flag for: ipv6_enable_ddns
	UseIpv6EnableDdns *bool `json:"use_ipv6_enable_ddns,omitempty"`

	// Use flag for: ipv6_options
	UseIpv6Options *bool `json:"use_ipv6_options,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: preferred_lifetime
	UsePreferredLifetime *bool `json:"use_preferred_lifetime,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: valid_lifetime
	UseValidLifetime *bool `json:"use_valid_lifetime,omitempty"`

	// The valid lifetime value for this roaming host object.
	ValidLifetime *uint32 `json:"valid_lifetime,omitempty"`
}

func (RoamingHost) ObjectType() string {
	return "roaminghost"
}

func (obj RoamingHost) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"address_type", "name", "network_view"}
	}
	return obj.returnFields
}

// Ruleset represents Infoblox object ruleset.
// Represents a Ruleset object, which is a collection of rules that is used to
// match domain names.
type Ruleset struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Descriptive comment about the Ruleset object.
	Comment *string `json:"comment,omitempty"`

	// The flag that indicates if the Ruleset object is disabled.
	Disabled *bool `json:"disabled,omitempty"`

	// The name of this Ruleset object.
	Name *string `json:"name,omitempty"`

	// The list of Rules assigned to this Ruleset object. Rules can be set only
	// when the Ruleset type is set to "NXDOMAIN".
	NxdomainRules []*Nxdomainrule `json:"nxdomain_rules,omitempty"`

	// The type of this Ruleset object.
	Type string `json:"type,omitempty"`
}

func (Ruleset) ObjectType() string {
	return "ruleset"
}

func (obj Ruleset) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disabled", "name", "type"}
	}
	return obj.returnFields
}

// SamlAuthservice represents Infoblox object saml:authservice.
// This object represents SAML authentication service.
type SamlAuthservice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment for the SAML authentication service.
	Comment *string `json:"comment,omitempty"`

	// The SAML Identity Provider to use for authentication.
	Idp *SamlIdp `json:"idp,omitempty"`

	// The name of the SAML authentication service.
	Name *string `json:"name,omitempty"`

	// The session timeout in seconds.
	SessionTimeout *uint32 `json:"session_timeout,omitempty"`
}

func (SamlAuthservice) ObjectType() string {
	return "saml:authservice"
}

func (obj SamlAuthservice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

// Scavengingtask represents Infoblox object scavengingtask.
// The DNS scavenging task object provides information on scavenging process
// state.
type Scavengingtask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The scavenging action.
	Action string `json:"action,omitempty"`

	// The reference to the object associated with the scavenging task.
	AssociatedObject string `json:"associated_object,omitempty"`

	// The scavenging process end time.
	EndTime *UnixTime `json:"end_time,omitempty"`

	// The number of processed during scavenging resource records.
	ProcessedRecords uint32 `json:"processed_records,omitempty"`

	// The number of resource records that are allowed to be reclaimed during the
	// scavenging process.
	ReclaimableRecords uint32 `json:"reclaimable_records,omitempty"`

	// The number of reclaimed during the scavenging process resource records.
	ReclaimedRecords uint32 `json:"reclaimed_records,omitempty"`

	// The scavenging process start time.
	StartTime *UnixTime `json:"start_time,omitempty"`

	// The scavenging process status. This is a read-only attribute.
	Status string `json:"status,omitempty"`
}

func (Scavengingtask) ObjectType() string {
	return "scavengingtask"
}

func (obj Scavengingtask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"action", "associated_object", "status"}
	}
	return obj.returnFields
}

// ScheduledTask represents Infoblox object scheduledtask.
// This object represents a scheduled task.
type ScheduledTask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The approval status of the task.
	ApprovalStatus string `json:"approval_status,omitempty"`

	// The approver of the task.
	Approver string `json:"approver,omitempty"`

	// The comment specified by the approver of the task.
	ApproverComment *string `json:"approver_comment,omitempty"`

	// Indicates whether there will be an automatic restart when the appliance
	// executes the task.
	AutomaticRestart *bool `json:"automatic_restart,omitempty"`

	// A list of objects that are affected by the task.
	ChangedObjects []*Changedobject `json:"changed_objects,omitempty"`

	// If this scheduled task has dependent tasks, their references will be
	// returned in this field.
	DependentTasks []*ScheduledTask `json:"dependent_tasks,omitempty"`

	// If this field is set to True the specified task will be executed
	// immediately.
	ExecuteNow *bool `json:"execute_now,omitempty"`

	// Messages generated by the execution of the scheduled task after its
	// completion.
	ExecutionDetails []string `json:"execution_details,omitempty"`

	// The type of details generated by the execution of the scheduled task after
	// its completion.
	ExecutionDetailsType string `json:"execution_details_type,omitempty"`

	// The execution status of the task.
	ExecutionStatus string `json:"execution_status,omitempty"`

	// The time when the appliance executed the task.
	ExecutionTime *UnixTime `json:"execution_time,omitempty"`

	// Indicates whether this is a Network Insight scheduled task.
	IsNetworkInsightTask bool `json:"is_network_insight_task,omitempty"`

	// The member where this task was created.
	Member string `json:"member,omitempty"`

	// If this scheduled task has a predecessor task set, its reference will be
	// returned in this field.
	PredecessorTask string `json:"predecessor_task,omitempty"`

	// If set to True, if the scheduled task is a Network Insight task and it
	// failed, a new task will be cloned from this task and re-executed.
	ReExecuteTask *bool `json:"re_execute_task,omitempty"`

	// The time when the task is scheduled to occur.
	ScheduledTime *UnixTime `json:"scheduled_time,omitempty"`

	// The time when the task was submitted.
	SubmitTime *UnixTime `json:"submit_time,omitempty"`

	// The submitter of the task.
	Submitter string `json:"submitter,omitempty"`

	// The comment specified by the submitter of the task.
	SubmitterComment *string `json:"submitter_comment,omitempty"`

	// The task ID.
	TaskId uint32 `json:"task_id,omitempty"`

	// The task type.
	TaskType string `json:"task_type,omitempty"`

	// The task ticket number.
	TicketNumber string `json:"ticket_number,omitempty"`
}

func (ScheduledTask) ObjectType() string {
	return "scheduledtask"
}

func (obj ScheduledTask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"approval_status", "execution_status", "task_id"}
	}
	return obj.returnFields
}

// Search represents Infoblox object search.
// The search object is used to perform global searches for multiple object
// types in the database. This object contains only search parameters and
// returns objects that match the search criteria. The returned objects are
// base objects for the respective object types.
type Search struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`
}

func (Search) ObjectType() string {
	return "search"
}

func (obj Search) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{}
	}
	return obj.returnFields
}

// SharedNetwork represents Infoblox object sharednetwork.
// A shared network is a network segment to which you assign two or more
// subnets. When subnets in a shared network contain IP addresses that are
// available for dynamic allocation, the addresses are put into a common pool
// for allocation when client requests arise. When you create a shared network,
// the DHCP server can assign IP addresses to client requests from any subnet
// (that resides on the same network interface) in the shared network.
type SharedNetwork struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Authority for the shared network.
	Authority *bool `json:"authority,omitempty"`

	// The bootfile name for the shared network. You can configure the DHCP server
	// to support clients that use the boot file name option in their DHCPREQUEST
	// messages.
	Bootfile *string `json:"bootfile,omitempty"`

	// The bootserver address for the shared network. You can specify the name
	// and/or IP address of the boot server that the host needs to boot. The boot
	// server IPv4 Address or name in FQDN format.
	Bootserver *string `json:"bootserver,omitempty"`

	// Comment for the shared network, maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// If this field is set to True, the DHCP server generates a hostname and
	// updates DNS with it when the DHCP client request does not contain a
	// hostname.
	DdnsGenerateHostname *bool `json:"ddns_generate_hostname,omitempty"`

	// This field controls whether only the DHCP server is allowed to update DNS,
	// regardless of the DHCP clients requests. Note that changes for this field
	// take effect only if ddns_use_option81 is True.
	DdnsServerAlwaysUpdates *bool `json:"ddns_server_always_updates,omitempty"`

	// The DNS update Time to Live (TTL) value of a shared network object. The TTL
	// is a 32-bit unsigned integer that represents the duration, in seconds, for
	// which the update is cached. Zero indicates that the update is not cached.
	DdnsTtl *uint32 `json:"ddns_ttl,omitempty"`

	// By default, the DHCP server does not update DNS when it allocates a fixed
	// address to a client. You can configure the DHCP server to update the A and
	// PTR records of a client with a fixed address. When this feature is enabled
	// and the DHCP server adds A and PTR records for a fixed address, the DHCP
	// server never discards the records.
	DdnsUpdateFixedAddresses *bool `json:"ddns_update_fixed_addresses,omitempty"`

	// The support for DHCP Option 81 at the shared network level.
	DdnsUseOption81 *bool `json:"ddns_use_option81,omitempty"`

	// If set to true, BOOTP settings are disabled and BOOTP requests will be
	// denied.
	DenyBootp *bool `json:"deny_bootp,omitempty"`

	// The percentage of the total DHCP utilization of the networks belonging to
	// the shared network multiplied by 1000. This is the percentage of the total
	// number of available IP addresses from all the networks belonging to the
	// shared network versus the total number of all IP addresses in all of the
	// networks in the shared network.
	DhcpUtilization uint32 `json:"dhcp_utilization,omitempty"`

	// A string describing the utilization level of the shared network.
	DhcpUtilizationStatus string `json:"dhcp_utilization_status,omitempty"`

	// Determines whether a shared network is disabled or not. When this is set to
	// False, the shared network is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The total number of DHCP leases issued for the shared network.
	DynamicHosts uint32 `json:"dynamic_hosts,omitempty"`

	// The dynamic DNS updates flag of a shared network object. If set to True, the
	// DHCP server sends DDNS updates to DNS servers in the same Grid, and to
	// external DNS servers.
	EnableDdns *bool `json:"enable_ddns,omitempty"`

	// Set this to True if you want the DHCP server to use a different lease time
	// for PXE clients.
	EnablePxeLeaseTime *bool `json:"enable_pxe_lease_time,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// If set to true, the client identifier will be ignored.
	IgnoreClientIdentifier *bool `json:"ignore_client_identifier,omitempty"`

	// If this field is set to False, the appliance returns all DHCP options the
	// client is eligible to receive, rather than only the list of options the
	// client has requested.
	IgnoreDhcpOptionListRequest *bool `json:"ignore_dhcp_option_list_request,omitempty"`

	// Indicates whether the appliance will ignore DHCP client IDs or MAC
	// addresses. Valid values are "NONE", "CLIENT", or "MACADDR". The default is
	// "NONE".
	IgnoreId string `json:"ignore_id,omitempty"`

	// A list of MAC addresses the appliance will ignore.
	IgnoreMacAddresses []string `json:"ignore_mac_addresses,omitempty"`

	// An integer that specifies the period of time (in seconds) that frees and
	// backs up leases remained in the database before they are automatically
	// deleted. To disable lease scavenging, set the parameter to -1. The minimum
	// positive value must be greater than 86400 seconds (1 day).
	LeaseScavengeTime int `json:"lease_scavenge_time,omitempty"`

	// This field contains the logic filters to be applied on the this shared
	// network. This list corresponds to the match rules that are written to the
	// dhcpd configuration file.
	LogicFilterRules []*Logicfilterrule `json:"logic_filter_rules,omitempty"`

	// The Microsoft Active Directory user related information.
	MsAdUserData *MsserverAduserData `json:"ms_ad_user_data,omitempty"`

	// The name of the IPv6 Shared Network.
	Name *string `json:"name,omitempty"`

	// The name of the network view in which this shared network resides.
	NetworkView string `json:"network_view,omitempty"`

	// A list of networks belonging to the shared network Each individual list item
	// must be specified as an object containing a '_ref' parameter to a network
	// reference, for example:: [{ "_ref":
	// "network/ZG5zLm5ldHdvcmskMTAuMwLvMTYvMA", }] if the reference of the wanted
	// network is not known, it is possible to specify search parameters for the
	// network instead in the following way:: [{ "_ref": { 'network': '10.0.0.0/8',
	// } }] note that in this case the search must match exactly one network for
	// the assignment to be successful.
	Networks []*Ipv4Network `json:"networks,omitempty"`

	// The name in FQDN and/or IPv4 Address of the next server that the host needs
	// to boot.
	Nextserver *string `json:"nextserver,omitempty"`

	// An array of DHCP option dhcpoption structs that lists the DHCP options
	// associated with the object.
	Options []*Dhcpoption `json:"options,omitempty"`

	// The PXE lease time value of a shared network object. Some hosts use PXE
	// (Preboot Execution Environment) to boot remotely from a server. To better
	// manage your IP resources, set a different lease time for PXE boot requests.
	// You can configure the DHCP server to allocate an IP address with a shorter
	// lease time to hosts that send PXE boot requests, so IP addresses are not
	// leased longer than necessary. A 32-bit unsigned integer that represents the
	// duration, in seconds, for which the update is cached. Zero indicates that
	// the update is not cached.
	PxeLeaseTime *uint32 `json:"pxe_lease_time,omitempty"`

	// The number of static DHCP addresses configured in the shared network.
	StaticHosts uint32 `json:"static_hosts,omitempty"`

	// The total number of DHCP addresses configured in the shared network.
	TotalHosts uint32 `json:"total_hosts,omitempty"`

	// This field controls whether the DHCP server updates DNS when a DHCP lease is
	// renewed.
	UpdateDnsOnLeaseRenewal *bool `json:"update_dns_on_lease_renewal,omitempty"`

	// Use flag for: authority
	UseAuthority *bool `json:"use_authority,omitempty"`

	// Use flag for: bootfile
	UseBootfile *bool `json:"use_bootfile,omitempty"`

	// Use flag for: bootserver
	UseBootserver *bool `json:"use_bootserver,omitempty"`

	// Use flag for: ddns_generate_hostname
	UseDdnsGenerateHostname *bool `json:"use_ddns_generate_hostname,omitempty"`

	// Use flag for: ddns_ttl
	UseDdnsTtl *bool `json:"use_ddns_ttl,omitempty"`

	// Use flag for: ddns_update_fixed_addresses
	UseDdnsUpdateFixedAddresses *bool `json:"use_ddns_update_fixed_addresses,omitempty"`

	// Use flag for: ddns_use_option81
	UseDdnsUseOption81 *bool `json:"use_ddns_use_option81,omitempty"`

	// Use flag for: deny_bootp
	UseDenyBootp *bool `json:"use_deny_bootp,omitempty"`

	// Use flag for: enable_ddns
	UseEnableDdns *bool `json:"use_enable_ddns,omitempty"`

	// Use flag for: ignore_client_identifier
	UseIgnoreClientIdentifier *bool `json:"use_ignore_client_identifier,omitempty"`

	// Use flag for: ignore_dhcp_option_list_request
	UseIgnoreDhcpOptionListRequest *bool `json:"use_ignore_dhcp_option_list_request,omitempty"`

	// Use flag for: ignore_id
	UseIgnoreId *bool `json:"use_ignore_id,omitempty"`

	// Use flag for: lease_scavenge_time
	UseLeaseScavengeTime *bool `json:"use_lease_scavenge_time,omitempty"`

	// Use flag for: logic_filter_rules
	UseLogicFilterRules *bool `json:"use_logic_filter_rules,omitempty"`

	// Use flag for: nextserver
	UseNextserver *bool `json:"use_nextserver,omitempty"`

	// Use flag for: options
	UseOptions *bool `json:"use_options,omitempty"`

	// Use flag for: pxe_lease_time
	UsePxeLeaseTime *bool `json:"use_pxe_lease_time,omitempty"`

	// Use flag for: update_dns_on_lease_renewal
	UseUpdateDnsOnLeaseRenewal *bool `json:"use_update_dns_on_lease_renewal,omitempty"`
}

func (SharedNetwork) ObjectType() string {
	return "sharednetwork"
}

func (obj SharedNetwork) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name", "network_view", "networks"}
	}
	return obj.returnFields
}

// SharedRecordA represents Infoblox object sharedrecord:a.
// A shared A (address) record is similar to a regular A record. It maps a
// domain name to an IPv4 address. The difference is that a shared A record
// should be added to a shared record group. If the shared record group is
// associated with other zones, the shared A record is shared among these
// zones.
type SharedRecordA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv4 Address of the shared record.
	Ipv4Addr *string `json:"ipv4addr,omitempty"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (SharedRecordA) ObjectType() string {
	return "sharedrecord:a"
}

func (obj SharedRecordA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "name", "shared_record_group"}
	}
	return obj.returnFields
}

// SharedRecordAAAA represents Infoblox object sharedrecord:aaaa.
// A shared AAAA (address) record is similar to a regular AAAA record. It maps
// a domain name to an IPv6 address. The difference is that a shared AAAA
// record should be added to a shared record group. If the shared record group
// is associated with other zones, the shared AAAA record is shared among these
// zones.
type SharedRecordAAAA struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The IPv6 Address of the shared record.
	Ipv6Addr *string `json:"ipv6addr,omitempty"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (SharedRecordAAAA) ObjectType() string {
	return "sharedrecord:aaaa"
}

func (obj SharedRecordAAAA) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv6addr", "name", "shared_record_group"}
	}
	return obj.returnFields
}

// SharedrecordCname represents Infoblox object sharedrecord:cname.
// A shared CNAME (canonical name) record is similar to a regular CNAME record.
// The difference is that a shared CNAME record should be added to a shared
// record group. If the shared record group is associated with other zones, the
// shared CNAME record is shared among these zones.
type SharedrecordCname struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Canonical name in FQDN format. This value can be in unicode format.
	Canonical *string `json:"canonical,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Canonical name in punycode format.
	DnsCanonical string `json:"dns_canonical,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (SharedrecordCname) ObjectType() string {
	return "sharedrecord:cname"
}

func (obj SharedrecordCname) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"canonical", "name", "shared_record_group"}
	}
	return obj.returnFields
}

// SharedRecordMX represents Infoblox object sharedrecord:mx.
// A shared MX (mail exchanger) record is similar to a regular MX record. It
// maps a domain name to a mail exchanger. The difference is that a shared MX
// record should be added to a shared record group. If the shared record group
// is associated with other zones, the shared MX record is shared among these
// zones.
type SharedRecordMX struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name of the mail exchanger in punycode format.
	DnsMailExchanger string `json:"dns_mail_exchanger,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the mail exchanger in FQDN format. This value can be in unicode
	// format.
	MailExchanger *string `json:"mail_exchanger,omitempty"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The preference value. Valid values are from 0 to 65535 (inclusive), in
	// 32-bit unsigned integer format.
	Preference *uint32 `json:"preference,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (SharedRecordMX) ObjectType() string {
	return "sharedrecord:mx"
}

func (obj SharedRecordMX) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"mail_exchanger", "name", "preference", "shared_record_group"}
	}
	return obj.returnFields
}

// SharedrecordSrv represents Infoblox object sharedrecord:srv.
// A shared SRV (service) record is similar to a regular SRV record. It
// provides information about available services. The difference is that a
// shared SRV record should be added to a shared record group. If the shared
// record group is associated with other zones, the shared SRV record is shared
// among these zones.
type SharedrecordSrv struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// The name for a shared SRV record in punycode format.
	DnsTarget string `json:"dns_target,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The port of the shared SRV record. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Port *uint32 `json:"port,omitempty"`

	// The priority of the shared SRV record. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Priority *uint32 `json:"priority,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// The target of the shared SRV record in FQDN format. This value can be in
	// unicode format.
	Target *string `json:"target,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`

	// The weight of the shared SRV record. Valid values are from 0 to 65535
	// (inclusive), in 32-bit unsigned integer format.
	Weight *uint32 `json:"weight,omitempty"`
}

func (SharedrecordSrv) ObjectType() string {
	return "sharedrecord:srv"
}

func (obj SharedrecordSrv) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "port", "priority", "shared_record_group", "target", "weight"}
	}
	return obj.returnFields
}

// SharedRecordTXT represents Infoblox object sharedrecord:txt.
// A shared TXT (text) record is similar to a regular TXT record. It contains
// supplemental information for a host. SPF (Sender Policy Framework) records
// are specialized TXT records that identify the servers that send mail from a
// domain. The difference is that a shared TXT record should be added to a
// shared record group. If the shared record group is associated with other
// zones, the shared TXT record is shared among these zones.
type SharedRecordTXT struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Comment for this shared record; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines if this shared record is disabled or not. False means that the
	// record is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The name for this shared record in punycode format.
	DnsName string `json:"dns_name,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name for this shared record. This value can be in unicode format.
	Name *string `json:"name,omitempty"`

	// The name of the shared record group in which the record resides.
	SharedRecordGroup *string `json:"shared_record_group,omitempty"`

	// Text associated with the shared record. It can contain up to 255 bytes per
	// substring and up a total of 512 bytes. To enter leading, trailing or
	// embedded spaces in the text, add quotes (" ") around the text to preserve
	// the spaces.
	Text *string `json:"text,omitempty"`

	// The Time To Live (TTL) value for this shared record. A 32-bit unsigned
	// integer that represents the duration, in seconds, for which the shared
	// record is valid (cached). Zero indicates that the shared record should not
	// be cached.
	Ttl *uint32 `json:"ttl,omitempty"`

	// Use flag for: ttl
	UseTtl *bool `json:"use_ttl,omitempty"`
}

func (SharedRecordTXT) ObjectType() string {
	return "sharedrecord:txt"
}

func (obj SharedRecordTXT) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "shared_record_group", "text"}
	}
	return obj.returnFields
}

// Sharedrecordgroup represents Infoblox object sharedrecordgroup.
// A shared record group (SRG) is created to contain DNS shared records and
// share them between different zones. For example, if a group of DNS records
// needs to be in three different zones, you can include the records in a
// shared record group and assign the group to the three zones. For more
// information about shared record groups and shared records, please refer to
// Infoblox Administrator Guide.
type Sharedrecordgroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment of this shared record group.
	Comment *string `json:"comment,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of this shared record group.
	Name *string `json:"name,omitempty"`

	// The record name policy of this shared record group.
	RecordNamePolicy *string `json:"record_name_policy,omitempty"`

	// Use flag for: record_name_policy
	UseRecordNamePolicy *bool `json:"use_record_name_policy,omitempty"`

	// The list of zones associated with this shared record group.
	ZoneAssociations []string `json:"zone_associations,omitempty"`
}

func (Sharedrecordgroup) ObjectType() string {
	return "sharedrecordgroup"
}

func (obj Sharedrecordgroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// SmartfolderChildren represents Infoblox object smartfolder:children.
// The Smart Folder children object is used to read the objects that are
// associated with either a Smart Folder (global or personal) or a set of
// queries that users can make without saving a Smart Folder object on the
// appliance.
type SmartfolderChildren struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The object retuned by the Smart Folder query.
	Resource string `json:"resource,omitempty"`

	// The value returned by the Smart Folder query.
	Value *SmartfolderQueryitemvalue `json:"value,omitempty"`

	// The type of the returned value.
	ValueType string `json:"value_type,omitempty"`
}

func (SmartfolderChildren) ObjectType() string {
	return "smartfolder:children"
}

func (obj SmartfolderChildren) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"resource", "value", "value_type"}
	}
	return obj.returnFields
}

// SmartfolderGlobal represents Infoblox object smartfolder:global.
// Smart Folders are used to organize your core network services data.
// Depending on your administrative roles and business needs, you can filter
// your data object types, names, extensible attributes and discovered data and
// then place the filtered results in a Smart Folder.
type SmartfolderGlobal struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The global Smart Folder descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Global Smart Folder grouping rules.
	GroupBys []*SmartfolderGroupby `json:"group_bys,omitempty"`

	// The global Smart Folder name.
	Name *string `json:"name,omitempty"`

	// The global Smart Folder filter queries.
	QueryItems []*SmartfolderQueryitem `json:"query_items,omitempty"`
}

func (SmartfolderGlobal) ObjectType() string {
	return "smartfolder:global"
}

func (obj SmartfolderGlobal) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// SmartfolderPersonal represents Infoblox object smartfolder:personal.
// Smart Folders are used to organize your core network services data.
// Depending on your administrative roles and business needs, you can filter
// your data object types, names, extensible attributes and discovered data and
// then place the filtered results in a Smart Folder.
type SmartfolderPersonal struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The personal Smart Folder descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The personal Smart Folder groupping rules.
	GroupBys []*SmartfolderGroupby `json:"group_bys,omitempty"`

	// Determines whether the personal Smart Folder is a shortcut.
	IsShortcut bool `json:"is_shortcut,omitempty"`

	// The personal Smart Folder name.
	Name *string `json:"name,omitempty"`

	// The personal Smart Folder filter queries.
	QueryItems []*SmartfolderQueryitem `json:"query_items,omitempty"`
}

func (SmartfolderPersonal) ObjectType() string {
	return "smartfolder:personal"
}

func (obj SmartfolderPersonal) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "is_shortcut", "name"}
	}
	return obj.returnFields
}

// SNMPUser represents Infoblox object snmpuser.
// This object contains information related to SNMPv3 users.
type SNMPUser struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines an authentication password for the user. This is a write-only
	// attribute.
	AuthenticationPassword *string `json:"authentication_password,omitempty"`

	// The authentication protocol to be used for this user.
	AuthenticationProtocol string `json:"authentication_protocol,omitempty"`

	// A descriptive comment for the SNMPv3 User.
	Comment *string `json:"comment,omitempty"`

	// Determines if SNMPv3 user is disabled or not.
	Disable *bool `json:"disable,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of the user.
	Name *string `json:"name,omitempty"`

	// Determines a password for the privacy protocol.
	PrivacyPassword *string `json:"privacy_password,omitempty"`

	// The privacy protocol to be used for this user.
	PrivacyProtocol string `json:"privacy_protocol,omitempty"`
}

func (SNMPUser) ObjectType() string {
	return "snmpuser"
}

func (obj SNMPUser) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Superhost represents Infoblox object superhost.
// The collection of correlated IPAM records which is related to single device.
type Superhost struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for Super Host.
	Comment *string `json:"comment,omitempty"`

	// True if we have to delete all DNS/DHCP associated objects with Super Host,
	// false by default.
	DeleteAssociatedObjects *bool `json:"delete_associated_objects,omitempty"`

	// A list of DHCP objects refs which are associated with Super Host.
	DhcpAssociatedObjects []*Ipv4FixedAddress `json:"dhcp_associated_objects,omitempty"`

	// Disable all DNS/DHCP associated objects with Super Host if True, False by
	// default.
	Disabled *bool `json:"disabled,omitempty"`

	// A list of object refs of the DNS resource records which are associated with
	// Super Host.
	DnsAssociatedObjects []*RecordA `json:"dns_associated_objects,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name of the Superhost.
	Name *string `json:"name,omitempty"`
}

func (Superhost) ObjectType() string {
	return "superhost"
}

func (obj Superhost) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Superhostchild represents Infoblox object superhostchild.
// The superhostchild object is a read-only synthetic object used to retrieve
// records assigned to superhost.
type Superhostchild struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The record object, if supported by the WAPI. Otherwise, the value is "None".
	AssociatedObject string `json:"associated_object,omitempty"`

	// The record comment.
	Comment string `json:"comment,omitempty"`

	// Time at which DNS RR was created.
	CreationTimestamp *UnixTime `json:"creation_timestamp,omitempty"`

	// Specific data of DNS/DHCP records.
	Data string `json:"data,omitempty"`

	// True if the child DNS/DHCP object is disabled.
	Disabled bool `json:"disabled,omitempty"`

	// Name of the associated DNS/DHCP object.
	Name string `json:"name,omitempty"`

	// The name of the network view in which this network record resides.
	NetworkView string `json:"network_view,omitempty"`

	// Name of the Super Host object in which record resides.
	Parent string `json:"parent,omitempty"`

	// Name of a parent zone/network.
	RecordParent string `json:"record_parent,omitempty"`

	// The record type. When searching for an unspecified record type, the search
	// is performed for all records.
	Type string `json:"type,omitempty"`

	// Name of the DNS View in which the record resides.
	View string `json:"view,omitempty"`
}

func (Superhostchild) ObjectType() string {
	return "superhostchild"
}

func (obj Superhostchild) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "data", "name", "network_view", "parent", "record_parent", "type", "view"}
	}
	return obj.returnFields
}

// SyslogEndpoint represents Infoblox object syslog:endpoint.
// The name part of the syslog:endpoint object reference has the following
// components:
type SyslogEndpoint struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The log level for a notification REST endpoint.
	LogLevel string `json:"log_level,omitempty"`

	// The name of a Syslog endpoint.
	Name *string `json:"name,omitempty"`

	// The outbound member that will generate events.
	OutboundMemberType string `json:"outbound_member_type,omitempty"`

	// The list of members for outbound events.
	OutboundMembers []string `json:"outbound_members,omitempty"`

	// List of syslog servers
	SyslogServers []*SyslogEndpointServers `json:"syslog_servers,omitempty"`

	// The Syslog template instance. You cannot change the parameters of the Syslog
	// endpoint template instance.
	TemplateInstance *NotificationRestTemplateinstance `json:"template_instance,omitempty"`

	// The timeout of session management (in seconds).
	Timeout *uint32 `json:"timeout,omitempty"`

	// The vendor identifier.
	VendorIdentifier *string `json:"vendor_identifier,omitempty"`

	// The user name for WAPI integration.
	WapiUserName *string `json:"wapi_user_name,omitempty"`

	// The user password for WAPI integration.
	WapiUserPassword *string `json:"wapi_user_password,omitempty"`
}

func (SyslogEndpoint) ObjectType() string {
	return "syslog:endpoint"
}

func (obj SyslogEndpoint) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "outbound_member_type"}
	}
	return obj.returnFields
}

// TacacsplusAuthservice represents Infoblox object tacacsplus:authservice.
// This object is used to supply configuration for TACACS+ authentication
// service.
type TacacsplusAuthservice struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The number of the accounting retries before giving up and moving on to the
	// next server.
	AcctRetries *uint32 `json:"acct_retries,omitempty"`

	// The accounting retry period in milliseconds.
	AcctTimeout *uint32 `json:"acct_timeout,omitempty"`

	// The number of the authentication/authorization retries before giving up and
	// moving on to the next server.
	AuthRetries *uint32 `json:"auth_retries,omitempty"`

	// The authentication/authorization timeout period in milliseconds.
	AuthTimeout *uint32 `json:"auth_timeout,omitempty"`

	// The TACACS+ authentication service descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the TACACS+ authentication service object is disabled.
	Disable *bool `json:"disable,omitempty"`

	// The TACACS+ authentication service name.
	Name *string `json:"name,omitempty"`

	// The list of the TACACS+ servers used for authentication.
	Servers []*TacacsplusServer `json:"servers,omitempty"`
}

func (TacacsplusAuthservice) ObjectType() string {
	return "tacacsplus:authservice"
}

func (obj TacacsplusAuthservice) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disable", "name"}
	}
	return obj.returnFields
}

// Taxii represents Infoblox object taxii.
// The Taxii Member object provides information about Taxii service
// configuration such as the start/stop flag and RPZ (Response Policy Zone)
// configuration.
type Taxii struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Indicates whether the Taxii service is running on the given member or not.
	EnableService *bool `json:"enable_service,omitempty"`

	// The IPv4 Address of the Grid member.
	Ipv4Addr string `json:"ipv4addr,omitempty"`

	// The IPv6 Address of the Grid member.
	Ipv6Addr string `json:"ipv6addr,omitempty"`

	// The name of the Taxii Member.
	Name string `json:"name,omitempty"`

	// Taxii service RPZ configuration list.
	TaxiiRpzConfig []*TaxiiRpzconfig `json:"taxii_rpz_config,omitempty"`
}

func (Taxii) ObjectType() string {
	return "taxii"
}

func (obj Taxii) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"ipv4addr", "ipv6addr", "name"}
	}
	return obj.returnFields
}

// Tftpfiledir represents Infoblox object tftpfiledir.
// The TFTP file/directory object provides facilities for creating a directory
// structure for file distribution, modifying the directory name and
// permission, creating virtual TFTP root directories, and browsing the
// contents of the directories.
type Tftpfiledir struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The path to the directory that contains file or subdirectory.
	Directory string `json:"directory,omitempty"`

	// Determines whether the TFTP entity is synchronized to Grid Master.
	IsSyncedToGm bool `json:"is_synced_to_gm,omitempty"`

	// The time when the file or directory was last modified.
	LastModify *UnixTime `json:"last_modify,omitempty"`

	// The TFTP directory or file name.
	Name *string `json:"name,omitempty"`

	// The type of TFTP file system entity (directory or file).
	Type string `json:"type,omitempty"`

	// The replication members with TFTP client addresses where this virtual folder
	// is applicable.
	VtftpDirMembers []*Vtftpdirmember `json:"vtftp_dir_members,omitempty"`
}

func (Tftpfiledir) ObjectType() string {
	return "tftpfiledir"
}

func (obj Tftpfiledir) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"directory", "name", "type"}
	}
	return obj.returnFields
}

// ThreatanalyticsAnalyticsWhitelist represents Infoblox object threatanalytics:analytics_whitelist.
// The threat analytics whitelist object contains trusted domains on which NIOS
// allows DNS traffic.
type ThreatanalyticsAnalyticsWhitelist struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Whitelist version string.
	Version string `json:"version,omitempty"`
}

func (ThreatanalyticsAnalyticsWhitelist) ObjectType() string {
	return "threatanalytics:analytics_whitelist"
}

func (obj ThreatanalyticsAnalyticsWhitelist) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"version"}
	}
	return obj.returnFields
}

// ThreatanalyticsModuleset represents Infoblox object threatanalytics:moduleset.
// The threat analytics module set represents the installation or update of
// module information.
type ThreatanalyticsModuleset struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The version number of the threat analytics module set.
	Version string `json:"version,omitempty"`
}

func (ThreatanalyticsModuleset) ObjectType() string {
	return "threatanalytics:moduleset"
}

func (obj ThreatanalyticsModuleset) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"version"}
	}
	return obj.returnFields
}

// ThreatanalyticsWhitelist represents Infoblox object threatanalytics:whitelist.
// The threat analytics whitelist object contains trusted domains on which NIOS
// allows DNS traffic.
type ThreatanalyticsWhitelist struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The descriptive comment for the threat analytics whitelist.
	Comment *string `json:"comment,omitempty"`

	// Determines whether the threat analytics whitelist is disabled.
	Disable *bool `json:"disable,omitempty"`

	// The FQDN of the threat analytics whitelist.
	Fqdn *string `json:"fqdn,omitempty"`

	// The type of the threat analytics whitelist.
	Type string `json:"type,omitempty"`
}

func (ThreatanalyticsWhitelist) ObjectType() string {
	return "threatanalytics:whitelist"
}

func (obj ThreatanalyticsWhitelist) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "disable", "fqdn"}
	}
	return obj.returnFields
}

// ThreatinsightCloudclient represents Infoblox object threatinsight:cloudclient.
// You can use the Threat Insight Cloud Client object to configure the
// detection and authentication of domains in the Cloud, and then apply them to
// on-premises DNS firewall RPZ zones within a configurable time frame.
type ThreatinsightCloudclient struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The RPZs to which you apply newly detected domains through the Infoblox
	// Threat Insight Cloud Client.
	BlacklistRpzList []*ZoneRp `json:"blacklist_rpz_list,omitempty"`

	// Determines whether the Threat Insight in Cloud Client is enabled.
	Enable *bool `json:"enable,omitempty"`

	// Force a refresh if at least one RPZ is configured.
	ForceRefresh *bool `json:"force_refresh,omitempty"`

	// The time interval (in seconds) for requesting newly detected domains by the
	// Infoblox Threat Insight Cloud Client and applying them to the list of
	// configured RPZs.
	Interval *uint32 `json:"interval,omitempty"`
}

func (ThreatinsightCloudclient) ObjectType() string {
	return "threatinsight:cloudclient"
}

func (obj ThreatinsightCloudclient) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"enable", "interval"}
	}
	return obj.returnFields
}

// ThreatprotectionGridRule represents Infoblox object threatprotection:grid:rule.
// This object provides information about the threat protection custom rule
// settings.
type ThreatprotectionGridRule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of allowed actions of the custom rule.
	AllowedActions []string `json:"allowed_actions,omitempty"`

	// The rule category the custom rule assigned to.
	Category string `json:"category,omitempty"`

	// The human readable comment for the custom rule.
	Comment *string `json:"comment,omitempty"`

	// The rule config of the template.
	Config *ThreatprotectionRuleconfig `json:"config,omitempty"`

	// The description of the custom rule.
	Description string `json:"description,omitempty"`

	// Determines if the custom rule is disabled.
	Disabled *bool `json:"disabled,omitempty"`

	// Determines if factory reset is enabled for the custom rule.
	IsFactoryResetEnabled bool `json:"is_factory_reset_enabled,omitempty"`

	// The name of the rule custom rule concatenated with its rule config
	// parameters.
	Name string `json:"name,omitempty"`

	// The version of the ruleset the custom rule assigned to.
	Ruleset string `json:"ruleset,omitempty"`

	// The Rule ID.
	Sid uint32 `json:"sid,omitempty"`

	// The threat protection rule template used to create this rule.
	Template *string `json:"template,omitempty"`

	// The type of the custom rule.
	Type string `json:"type,omitempty"`
}

func (ThreatprotectionGridRule) ObjectType() string {
	return "threatprotection:grid:rule"
}

func (obj ThreatprotectionGridRule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "ruleset", "sid"}
	}
	return obj.returnFields
}

// ThreatprotectionProfile represents Infoblox object threatprotection:profile.
// The Threat Protection profile object facilitates configuring groups of
// Threat Protection members that have similar traffic properties. A member can
// be either associated with a Threat Protection profile or inherit the ruleset
// from the Grid or override the ruleset individually at the member level.
type ThreatprotectionProfile struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The comment for the Threat Protection profile.
	Comment *string `json:"comment,omitempty"`

	// The current Threat Protection profile ruleset.
	CurrentRuleset *string `json:"current_ruleset,omitempty"`

	// Determines if multiple BIND responses via TCP connection are disabled.
	DisableMultipleDnsTcpRequest *bool `json:"disable_multiple_dns_tcp_request,omitempty"`

	// The number of events logged per second per rule.
	EventsPerSecondPerRule *uint32 `json:"events_per_second_per_rule,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of members that are associated with the profile.
	Members []string `json:"members,omitempty"`

	// The name of the Threat Protection profile.
	Name *string `json:"name,omitempty"`

	// The source member. It can be used only during the create operation for
	// cloning a profile from an existing member.
	SourceMember string `json:"source_member,omitempty"`

	// The source profile. It can be used only during the create operation for
	// cloning a profile from an existing profile.
	SourceProfile string `json:"source_profile,omitempty"`

	// Use flag for: current_ruleset
	UseCurrentRuleset *bool `json:"use_current_ruleset,omitempty"`

	// Use flag for: disable_multiple_dns_tcp_request
	UseDisableMultipleDnsTcpRequest *bool `json:"use_disable_multiple_dns_tcp_request,omitempty"`

	// Use flag for: events_per_second_per_rule
	UseEventsPerSecondPerRule *bool `json:"use_events_per_second_per_rule,omitempty"`
}

func (ThreatprotectionProfile) ObjectType() string {
	return "threatprotection:profile"
}

func (obj ThreatprotectionProfile) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// ThreatprotectionProfileRule represents Infoblox object threatprotection:profile:rule.
// This object provides information about the Threat protection profile rule
// settings.
type ThreatprotectionProfileRule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The threat protection rule configuration.
	Config *ThreatprotectionRuleconfig `json:"config,omitempty"`

	// Determines if the rule is enabled or not for the profile.
	Disable *bool `json:"disable,omitempty"`

	// The name of the Threat protection profile.
	Profile string `json:"profile,omitempty"`

	// The rule object name.
	Rule string `json:"rule,omitempty"`

	// The snort rule ID.
	Sid uint32 `json:"sid,omitempty"`

	// Use flag for: config
	UseConfig *bool `json:"use_config,omitempty"`

	// Use flag for: disable
	UseDisable *bool `json:"use_disable,omitempty"`
}

func (ThreatprotectionProfileRule) ObjectType() string {
	return "threatprotection:profile:rule"
}

func (obj ThreatprotectionProfileRule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"profile", "rule"}
	}
	return obj.returnFields
}

// ThreatprotectionRule represents Infoblox object threatprotection:rule.
// This object provides information about the member Threat protection rule
// settings.
type ThreatprotectionRule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The threat protection rule configuration.
	Config *ThreatprotectionRuleconfig `json:"config,omitempty"`

	// Determines if the rule is enabled or not for the member.
	Disable *bool `json:"disable,omitempty"`

	// The name of the Threat protection member.
	Member string `json:"member,omitempty"`

	// The rule object name.
	Rule string `json:"rule,omitempty"`

	// The Rule ID.
	Sid uint32 `json:"sid,omitempty"`

	// Use flag for: config
	UseConfig *bool `json:"use_config,omitempty"`

	// Use flag for: disable
	UseDisable *bool `json:"use_disable,omitempty"`
}

func (ThreatprotectionRule) ObjectType() string {
	return "threatprotection:rule"
}

func (obj ThreatprotectionRule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"member", "rule"}
	}
	return obj.returnFields
}

// ThreatprotectionRulecategory represents Infoblox object threatprotection:rulecategory.
// This object provides information about the threat protection rule category
// settings.
type ThreatprotectionRulecategory struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines if factory reset is enabled for this rule category.
	IsFactoryResetEnabled bool `json:"is_factory_reset_enabled,omitempty"`

	// The name of the rule category.
	Name string `json:"name,omitempty"`

	// The version of the ruleset the category assigned to.
	Ruleset string `json:"ruleset,omitempty"`
}

func (ThreatprotectionRulecategory) ObjectType() string {
	return "threatprotection:rulecategory"
}

func (obj ThreatprotectionRulecategory) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "ruleset"}
	}
	return obj.returnFields
}

// ThreatprotectionRuleset represents Infoblox object threatprotection:ruleset.
// This object represent the Grid protection ruleset information.
type ThreatprotectionRuleset struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines the way the ruleset was added.
	AddType string `json:"add_type,omitempty"`

	// The time when the ruleset was added.
	AddedTime *UnixTime `json:"added_time,omitempty"`

	// The human readable comment for the ruleset.
	Comment *string `json:"comment,omitempty"`

	// Determines if the ruleset will not be deleted during upgrade.
	DoNotDelete *bool `json:"do_not_delete,omitempty"`

	// Determines if factory reset is enabled for this ruleset.
	IsFactoryResetEnabled bool `json:"is_factory_reset_enabled,omitempty"`

	// The users of the ruleset.
	UsedBy []string `json:"used_by,omitempty"`

	// The ruleset version.
	Version string `json:"version,omitempty"`
}

func (ThreatprotectionRuleset) ObjectType() string {
	return "threatprotection:ruleset"
}

func (obj ThreatprotectionRuleset) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"add_type", "version"}
	}
	return obj.returnFields
}

// ThreatprotectionRuletemplate represents Infoblox object threatprotection:ruletemplate.
// This object provides information about the threat protection rule template
// settings.
type ThreatprotectionRuletemplate struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The list of allowed actions of rhe rule template.
	AllowedActions []string `json:"allowed_actions,omitempty"`

	// The rule category this template assigned to.
	Category string `json:"category,omitempty"`

	// The rule config of this template.
	DefaultConfig *ThreatprotectionRuleconfig `json:"default_config,omitempty"`

	// The description of the rule template.
	Description string `json:"description,omitempty"`

	// The name of the rule template.
	Name string `json:"name,omitempty"`

	// The version of the ruleset the template assigned to.
	Ruleset string `json:"ruleset,omitempty"`

	// The Rule ID.
	Sid uint32 `json:"sid,omitempty"`
}

func (ThreatprotectionRuletemplate) ObjectType() string {
	return "threatprotection:ruletemplate"
}

func (obj ThreatprotectionRuletemplate) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "ruleset", "sid"}
	}
	return obj.returnFields
}

// ThreatprotectionStatistics represents Infoblox object threatprotection:statistics.
// This object provides information about the threat protection statistics.
type ThreatprotectionStatistics struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The Grid member name to get threat protection statistics. If nothing is
	// specified then event statistics is returned for the Grid.
	Member string `json:"member,omitempty"`

	// The list of event statistical information for the Grid or particular
	// members.
	StatInfos []*ThreatprotectionStatinfo `json:"stat_infos,omitempty"`
}

func (ThreatprotectionStatistics) ObjectType() string {
	return "threatprotection:statistics"
}

func (obj ThreatprotectionStatistics) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"member", "stat_infos"}
	}
	return obj.returnFields
}

// Upgradegroup represents Infoblox object upgradegroup.
// To minimize the impact of Grid upgrades on system operations, you can
// organize members into upgrade groups and schedule their software
// distributions. The upgrade group object provides configuration of upgrade
// and software distribution for members included in the upgrade group.
type Upgradegroup struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The upgrade group descriptive comment.
	Comment *string `json:"comment,omitempty"`

	// The distribution dependent group name.
	DistributionDependentGroup *string `json:"distribution_dependent_group,omitempty"`

	// The distribution scheduling policy.
	DistributionPolicy string `json:"distribution_policy,omitempty"`

	// The time of the next scheduled distribution.
	DistributionTime *UnixTime `json:"distribution_time,omitempty"`

	// The upgrade group members.
	Members []*UpgradegroupMember `json:"members,omitempty"`

	// The upgrade group name.
	Name *string `json:"name,omitempty"`

	// The time zone for scheduling operations.
	TimeZone string `json:"time_zone,omitempty"`

	// The upgrade dependent group name.
	UpgradeDependentGroup *string `json:"upgrade_dependent_group,omitempty"`

	// The upgrade scheduling policy.
	UpgradePolicy string `json:"upgrade_policy,omitempty"`

	// The time of the next scheduled upgrade.
	UpgradeTime *UnixTime `json:"upgrade_time,omitempty"`
}

func (Upgradegroup) ObjectType() string {
	return "upgradegroup"
}

func (obj Upgradegroup) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "name"}
	}
	return obj.returnFields
}

// Upgradeschedule represents Infoblox object upgradeschedule.
// You can schedule lite and full upgrades for certain NIOS versions. When you
// schedule an upgrade, you schedule the upgrade for the Grid Master and the
// upgrade groups, including the Default group. The Grid Master must always
// upgrade before the upgrade groups.
type Upgradeschedule struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines whether the upgrade schedule is active.
	Active *bool `json:"active,omitempty"`

	// The start time of the upgrade.
	StartTime *UnixTime `json:"start_time,omitempty"`

	// The time zone for upgrade start time.
	TimeZone string `json:"time_zone,omitempty"`

	// The upgrade groups scheduling settings.
	UpgradeGroups []*UpgradegroupSchedule `json:"upgrade_groups,omitempty"`
}

func (Upgradeschedule) ObjectType() string {
	return "upgradeschedule"
}

func (obj Upgradeschedule) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"active", "start_time", "time_zone"}
	}
	return obj.returnFields
}

// UpgradeStatus represents Infoblox object upgradestatus.
// The Upgrade Status object is used to view the upgrade status of Infoblox
// Grid elements.
type UpgradeStatus struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines if distribution is allowed for the Grid.
	AllowDistribution bool `json:"allow_distribution,omitempty"`

	// Determines if distribution scheduling is allowed.
	AllowDistributionScheduling bool `json:"allow_distribution_scheduling,omitempty"`

	// Determines if upgrade is allowed for the Grid.
	AllowUpgrade bool `json:"allow_upgrade,omitempty"`

	// Determines if the Grid is allowed to cancel an upgrade.
	AllowUpgradeCancel bool `json:"allow_upgrade_cancel,omitempty"`

	// Determines if the Grid is allowed to pause an upgrade.
	AllowUpgradePause bool `json:"allow_upgrade_pause,omitempty"`

	// Determines if the Grid is allowed to resume an upgrade.
	AllowUpgradeResume bool `json:"allow_upgrade_resume,omitempty"`

	// Determine if the Grid is allowed to schedule an upgrade.
	AllowUpgradeScheduling bool `json:"allow_upgrade_scheduling,omitempty"`

	// Determines if the Grid is allowed to test an upgrade.
	AllowUpgradeTest bool `json:"allow_upgrade_test,omitempty"`

	// Determine if the Grid is allowed to upload a build.
	AllowUpload bool `json:"allow_upload,omitempty"`

	// The alternative version.
	AlternateVersion string `json:"alternate_version,omitempty"`

	// Comment in readable format for an upgrade group a or virtual node.
	Comment string `json:"comment,omitempty"`

	// The current version.
	CurrentVersion string `json:"current_version,omitempty"`

	// Current version summary for the 'type' requested. This field can be
	// requested for the Grid, a certain group that has virtual nodes as
	// subelements, or for the overall group status.
	CurrentVersionSummary string `json:"current_version_summary,omitempty"`

	// Determines if the distribution schedule is active for the Grid.
	DistributionScheduleActive bool `json:"distribution_schedule_active,omitempty"`

	// The Grid master distribution schedule time.
	DistributionScheduleTime *UnixTime `json:"distribution_schedule_time,omitempty"`

	// The current state of distribution process.
	DistributionState string `json:"distribution_state,omitempty"`

	// The version that is distributed.
	DistributionVersion string `json:"distribution_version,omitempty"`

	// Distribution version summary for the 'type' requested. This field can be
	// requested for the Grid, a certain group that has virtual nodes as
	// subelements, or for the overall group status.
	DistributionVersionSummary string `json:"distribution_version_summary,omitempty"`

	// The status of a certain element with regards to the type requested.
	ElementStatus string `json:"element_status,omitempty"`

	// The state of the Grid.
	GridState string `json:"grid_state,omitempty"`

	// The state of a group.
	GroupState string `json:"group_state,omitempty"`

	// Status of the HA pair.
	HaStatus string `json:"ha_status,omitempty"`

	// The list of hotfixes.
	Hotfixes []*Hotfix `json:"hotfixes,omitempty"`

	// The IPv4 Address of virtual node or physical one.
	Ipv4Address string `json:"ipv4_address,omitempty"`

	// The IPv6 Address of virtual node or physical one.
	Ipv6Address string `json:"ipv6_address,omitempty"`

	// Member that participates in the upgrade process.
	Member string `json:"member,omitempty"`

	// The Grid message.
	Message string `json:"message,omitempty"`

	// Status of the physical node in the HA pair.
	PnodeRole string `json:"pnode_role,omitempty"`

	// Determines if the upgrade process is reverted.
	Reverted bool `json:"reverted,omitempty"`

	// The status time.
	StatusTime *UnixTime `json:"status_time,omitempty"`

	// Status of a certain group, virtual node or physical node.
	StatusValue string `json:"status_value,omitempty"`

	// Timestamp of when the status was updated.
	StatusValueUpdateTime *UnixTime `json:"status_value_update_time,omitempty"`

	// The list of upgrade process steps.
	Steps []*Upgradestep `json:"steps,omitempty"`

	// The number of steps done.
	StepsCompleted int `json:"steps_completed,omitempty"`

	// Total number steps in the upgrade process.
	StepsTotal int `json:"steps_total,omitempty"`

	// The type of subelements to be requested. If 'type' is 'GROUP', or 'VNODE',
	// then 'upgrade_group' or 'member' should have proper values for an operation
	// to return data specific for the values passed. Otherwise, overall data is
	// returned for every group or physical node.
	SubelementType string `json:"subelement_type,omitempty"`

	// Number of subelements that have accomplished an upgrade.
	SubelementsCompleted int `json:"subelements_completed,omitempty"`

	// The upgrade process information of subelements.
	SubelementsStatus []*UpgradeStatus `json:"subelements_status,omitempty"`

	// Number of subelements number in a certain group, virtual node, or the Grid.
	SubelementsTotal int `json:"subelements_total,omitempty"`

	// The type of upper level elements to be requested.
	Type string `json:"type,omitempty"`

	// Upgrade group that participates in the upgrade process.
	UpgradeGroup string `json:"upgrade_group,omitempty"`

	// Determines if the upgrade schedule is active.
	UpgradeScheduleActive bool `json:"upgrade_schedule_active,omitempty"`

	// The upgrade state of the Grid.
	UpgradeState string `json:"upgrade_state,omitempty"`

	// The upgrade test status of the Grid.
	UpgradeTestStatus string `json:"upgrade_test_status,omitempty"`

	// The version that is uploaded.
	UploadVersion string `json:"upload_version,omitempty"`

	// Upload version summary for the 'type' requested. This field can be requested
	// for the Grid, a certain group that has virtual nodes as subelements, or
	// overall group status.
	UploadVersionSummary string `json:"upload_version_summary,omitempty"`
}

func (UpgradeStatus) ObjectType() string {
	return "upgradestatus"
}

func (obj UpgradeStatus) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"alternate_version", "comment", "current_version", "distribution_version", "element_status", "grid_state", "group_state", "ha_status", "hotfixes", "ipv4_address", "ipv6_address", "member", "message", "pnode_role", "reverted", "status_value", "status_value_update_time", "steps", "steps_completed", "steps_total", "type", "upgrade_group", "upgrade_state", "upgrade_test_status", "upload_version"}
	}
	return obj.returnFields
}

func NewUpgradeStatus(upgradeStatus UpgradeStatus) *UpgradeStatus {
	result := upgradeStatus
	returnFields := []string{"subelements_status", "type"}
	result.returnFields = returnFields
	return &result
}

// UserProfile represents Infoblox object userprofile.
// The user profile of the admin who has logged in.
type UserProfile struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Determines the active dashboard type.
	ActiveDashboardType string `json:"active_dashboard_type,omitempty"`

	// The Admin Group object to which the admin belongs. An admin user can belong
	// to only one admin group at a time.
	AdminGroup string `json:"admin_group,omitempty"`

	// The number of days left before the admin's password expires.
	DaysToExpire int `json:"days_to_expire,omitempty"`

	// The email address of the admin.
	Email *string `json:"email,omitempty"`

	// Determines if extensible attribute values will be returned by global search
	// or not.
	GlobalSearchOnEa *bool `json:"global_search_on_ea,omitempty"`

	// Determines if global search will search for network insight devices and
	// interfaces or not.
	GlobalSearchOnNiData *bool `json:"global_search_on_ni_data,omitempty"`

	// List of Admin Group objects that the current user is mapped to.
	GridAdminGroups []string `json:"grid_admin_groups,omitempty"`

	// The timestamp when the admin last logged in.
	LastLogin *UnixTime `json:"last_login,omitempty"`

	// Determines how many nodes are displayed at generation levels.
	LbTreeNodesAtGenLevel *uint32 `json:"lb_tree_nodes_at_gen_level,omitempty"`

	// Determines how many nodes are displayed at the last level.
	LbTreeNodesAtLastLevel *uint32 `json:"lb_tree_nodes_at_last_level,omitempty"`

	// The maximum count of widgets that can be added to one dashboard.
	MaxCountWidgets *uint32 `json:"max_count_widgets,omitempty"`

	// The admin name.
	Name string `json:"name,omitempty"`

	// The current password that will be replaced by a new password. To change a
	// password in the database, you must provide both the current and new password
	// values. This is a write-only attribute.
	OldPassword *string `json:"old_password,omitempty"`

	// The new password of the admin. To change a password in the database, you
	// must provide both the current and new password values. This is a write-only
	// attribute.
	Password *string `json:"password,omitempty"`

	// The number of lines of data a table or a single list view can contain.
	TableSize *uint32 `json:"table_size,omitempty"`

	// The time zone of the admin user.
	TimeZone string `json:"time_zone,omitempty"`

	// Use flag for: time_zone
	UseTimeZone *bool `json:"use_time_zone,omitempty"`

	// The admin type.
	UserType string `json:"user_type,omitempty"`
}

func (UserProfile) ObjectType() string {
	return "userprofile"
}

func (obj UserProfile) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name"}
	}
	return obj.returnFields
}

func NewUserProfile(userprofile UserProfile) *UserProfile {
	res := userprofile
	res.returnFields = []string{"name"}
	return &res
}

// Vdiscoverytask represents Infoblox object vdiscoverytask.
// This object represents vDiscovery Task.
type Vdiscoverytask struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Allow unsecured connection over HTTPS and bypass validation of the remote
	// SSL certificate.
	AllowUnsecuredConnection *bool `json:"allow_unsecured_connection,omitempty"`

	// Whether to insert or update cloud EAs with discovery data.
	AutoConsolidateCloudEa *bool `json:"auto_consolidate_cloud_ea,omitempty"`

	// Whether to replace managed tenant with discovery tenant data.
	AutoConsolidateManagedTenant *bool `json:"auto_consolidate_managed_tenant,omitempty"`

	// Whether to replace managed virtual machine with discovery vm data.
	AutoConsolidateManagedVm *bool `json:"auto_consolidate_managed_vm,omitempty"`

	// Template string used to generate host name.
	AutoCreateDnsHostnameTemplate *string `json:"auto_create_dns_hostname_template,omitempty"`

	// Control whether to create or update DNS record using discovered data.
	AutoCreateDnsRecord *bool `json:"auto_create_dns_record,omitempty"`

	// Indicates the type of record to create if the auto create DNS record is
	// enabled.
	AutoCreateDnsRecordType string `json:"auto_create_dns_record_type,omitempty"`

	// Comment on the task.
	Comment *string `json:"comment,omitempty"`

	// Credentials type used for connecting to the cloud management platform.
	CredentialsType string `json:"credentials_type,omitempty"`

	// The DNS view name for private IPs.
	DnsViewPrivateIp *string `json:"dns_view_private_ip,omitempty"`

	// The DNS view name for public IPs.
	DnsViewPublicIp *string `json:"dns_view_public_ip,omitempty"`

	// The name of the domain to use with keystone v3.
	DomainName *string `json:"domain_name,omitempty"`

	// Type of discovery driver.
	DriverType string `json:"driver_type,omitempty"`

	// Whether to enabled the cloud discovery or not.
	Enabled *bool `json:"enabled,omitempty"`

	// FQDN or IP of the cloud management platform.
	FqdnOrIp *string `json:"fqdn_or_ip,omitempty"`

	// Identity service version.
	IdentityVersion string `json:"identity_version,omitempty"`

	// Timestamp of last run.
	LastRun *UnixTime `json:"last_run,omitempty"`

	// Member on which cloud discovery will be run.
	Member *string `json:"member,omitempty"`

	// Whether to replace the old data with new or not.
	MergeData *bool `json:"merge_data,omitempty"`

	// Name of this cloud discovery task. Uniquely identify a task.
	Name *string `json:"name,omitempty"`

	// Password used for connecting to the cloud management platform.
	Password *string `json:"password,omitempty"`

	// Connection port used for connecting to the cloud management platform.
	Port *uint32 `json:"port,omitempty"`

	// Network view for private IPs.
	PrivateNetworkView *string `json:"private_network_view,omitempty"`

	// Mapping policy for the network view for private IPs in discovery data.
	PrivateNetworkViewMappingPolicy string `json:"private_network_view_mapping_policy,omitempty"`

	// Connection protocol used for connecting to the cloud management platform.
	Protocol string `json:"protocol,omitempty"`

	// Network view for public IPs.
	PublicNetworkView *string `json:"public_network_view,omitempty"`

	// Mapping policy for the network view for public IPs in discovery data.
	PublicNetworkViewMappingPolicy string `json:"public_network_view_mapping_policy,omitempty"`

	// Schedule setting for cloud discovery task.
	ScheduledRun *SettingSchedule `json:"scheduled_run,omitempty"`

	// The service_account_file for GCP.
	ServiceAccountFile *string `json:"service_account_file,omitempty"`

	// Current state of this task.
	State string `json:"state,omitempty"`

	// State message of the complete discovery process.
	StateMsg string `json:"state_msg,omitempty"`

	// If set to true, the appliance uses a specific DNS view for private IPs.
	UpdateDnsViewPrivateIp *bool `json:"update_dns_view_private_ip,omitempty"`

	// If set to true, the appliance uses a specific DNS view for public IPs.
	UpdateDnsViewPublicIp *bool `json:"update_dns_view_public_ip,omitempty"`

	// Whether to update metadata as a result of this network discovery.
	UpdateMetadata *bool `json:"update_metadata,omitempty"`

	// If set true, all keystone connection will use "/identity" endpoint and port
	// value will be ignored.
	UseIdentity *bool `json:"use_identity,omitempty"`

	// Username used for connecting to the cloud management platform.
	Username *string `json:"username,omitempty"`
}

func (Vdiscoverytask) ObjectType() string {
	return "vdiscoverytask"
}

func (obj Vdiscoverytask) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"name", "state"}
	}
	return obj.returnFields
}

// View represents Infoblox object view.
// DNS views provide the ability to serve one version of DNS data to one set of
// clients and another version to another set of clients. With DNS views, the
// appliance can provide a different answer to the same query, depending on the
// source of the query.
type View struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The action to perform when a domain name matches the pattern defined in a
	// rule that is specified by the blacklist_ruleset method. Valid values are
	// "REDIRECT" or "REFUSE". The default value is "REFUSE".
	BlacklistAction string `json:"blacklist_action,omitempty"`

	// The flag that indicates whether blacklist redirection queries are logged.
	// Specify "true" to enable logging, or "false" to disable it. The default
	// value is "false".
	BlacklistLogQuery *bool `json:"blacklist_log_query,omitempty"`

	// The array of IP addresses the appliance includes in the response it sends in
	// place of a blacklisted IP address.
	BlacklistRedirectAddresses []string `json:"blacklist_redirect_addresses,omitempty"`

	// The Time To Live (TTL) value of the synthetic DNS responses resulted from
	// blacklist redirection. The TTL value is a 32-bit unsigned integer that
	// represents the TTL in seconds.
	BlacklistRedirectTtl *uint32 `json:"blacklist_redirect_ttl,omitempty"`

	// The name of the Ruleset object assigned at the Grid level for blacklist
	// redirection.
	BlacklistRulesets []string `json:"blacklist_rulesets,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the DNS view; maximum 64 characters.
	Comment *string `json:"comment,omitempty"`

	// The list of customized root name servers. You can either select and use
	// Internet root name servers or specify custom root name servers by providing
	// a host name and IP address to which the Infoblox appliance can send queries.
	// Include the specified parameter to set the attribute value. Omit the
	// parameter to retrieve the attribute value.
	CustomRootNameServers []NameServer `json:"custom_root_name_servers,omitempty"`

	// Defines whether creation timestamp of RR should be updated ' when DDNS
	// update happens even if there is no change to ' the RR.
	DdnsForceCreationTimestampUpdate *bool `json:"ddns_force_creation_timestamp_update,omitempty"`

	// The DDNS Principal cluster group name.
	DdnsPrincipalGroup *string `json:"ddns_principal_group,omitempty"`

	// The flag that indicates whether the DDNS principal track is enabled or
	// disabled.
	DdnsPrincipalTracking *bool `json:"ddns_principal_tracking,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request
	// based on FQDN patterns is enabled or disabled.
	DdnsRestrictPatterns *bool `json:"ddns_restrict_patterns,omitempty"`

	// The unordered list of restriction patterns for an option of to restrict DDNS
	// updates based on FQDN patterns.
	DdnsRestrictPatternsList []string `json:"ddns_restrict_patterns_list,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request to
	// protected resource records is enabled or disabled.
	DdnsRestrictProtected *bool `json:"ddns_restrict_protected,omitempty"`

	// The flag that indicates whether DDNS update request for principal other than
	// target resource record's principal is restricted.
	DdnsRestrictSecure *bool `json:"ddns_restrict_secure,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request to
	// resource records which are marked as 'STATIC' is enabled or disabled.
	DdnsRestrictStatic *bool `json:"ddns_restrict_static,omitempty"`

	// Determines if the DNS view is disabled or not. When this is set to False,
	// the DNS view is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines if the DNS64 s enabled or not.
	Dns64Enabled *bool `json:"dns64_enabled,omitempty"`

	// The list of DNS64 synthesis groups associated with this DNS view.
	Dns64Groups []string `json:"dns64_groups,omitempty"`

	// Determines if the DNS security extension is enabled or not.
	DnssecEnabled *bool `json:"dnssec_enabled,omitempty"`

	// Determines if the DNS security extension accepts expired signatures or not.
	DnssecExpiredSignaturesEnabled *bool `json:"dnssec_expired_signatures_enabled,omitempty"`

	// A list of zones for which the server does not perform DNSSEC validation.
	DnssecNegativeTrustAnchors []string `json:"dnssec_negative_trust_anchors,omitempty"`

	// The list of trusted keys for the DNS security extension.
	DnssecTrustedKeys []*Dnssectrustedkey `json:"dnssec_trusted_keys,omitempty"`

	// Determines if the DNS security validation is enabled or not.
	DnssecValidationEnabled *bool `json:"dnssec_validation_enabled,omitempty"`

	// Advertises the EDNS0 buffer size to the upstream server. The value should be
	// between 512 and 4096 bytes. The recommended value is between 512 and 1220
	// bytes.
	EdnsUdpSize *uint32 `json:"edns_udp_size,omitempty"`

	// Determines if the blacklist in a DNS view is enabled or not.
	EnableBlacklist *bool `json:"enable_blacklist,omitempty"`

	// Determines if the fixed RRset order FQDN is enabled or not.
	EnableFixedRrsetOrderFqdns *bool `json:"enable_fixed_rrset_order_fqdns,omitempty"`

	// Determines if the 'match-recursive-only' option in a DNS view is enabled or
	// not.
	EnableMatchRecursiveOnly *bool `json:"enable_match_recursive_only,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The type of AAAA filtering for this DNS view object.
	FilterAaaa string `json:"filter_aaaa,omitempty"`

	// Applies AAAA filtering to a named ACL, or to a list of IPv4/IPv6 addresses
	// and networks from which queries are received. This field does not allow TSIG
	// keys.
	FilterAaaaList []*Addressac `json:"filter_aaaa_list,omitempty"`

	// The fixed RRset order FQDN. If this field does not contain an empty value,
	// the appliance will automatically set the enable_fixed_rrset_order_fqdns
	// field to 'true', unless the same request sets the enable field to 'false'.
	FixedRrsetOrderFqdns []*GridDnsFixedrrsetorderfqdn `json:"fixed_rrset_order_fqdns,omitempty"`

	// Determines if this DNS view sends queries to forwarders only or not. When
	// the value is True, queries are sent to forwarders only, and not to other
	// internal or Internet root servers.
	ForwardOnly *bool `json:"forward_only,omitempty"`

	// The list of forwarders for the DNS view. A forwarder is a name server to
	// which other name servers first send their off-site queries. The forwarder
	// builds up a cache of information, avoiding the need for other name servers
	// to send queries off-site.
	Forwarders []string `json:"forwarders,omitempty"`

	// The NIOS appliance provides one default DNS view. You can rename the default
	// view and change its settings, but you cannot delete it. There must always be
	// at least one DNS view in the appliance.
	IsDefault bool `json:"is_default,omitempty"`

	// The number of seconds to cache lame delegations or lame servers.
	LameTtl *uint32 `json:"lame_ttl,omitempty"`

	// Determines last queried ACL for the specified IPv4 or IPv6 addresses and
	// networks in scavenging settings.
	LastQueriedAcl []*Addressac `json:"last_queried_acl,omitempty"`

	// A list of forwarders for the match clients. This list specifies a named ACL,
	// or a list of IPv4/IPv6 addresses, networks, TSIG keys of clients that are
	// allowed or denied access to the DNS view.
	MatchClients []*Addressac `json:"match_clients,omitempty"`

	// A list of forwarders for the match destinations. This list specifies a name
	// ACL, or a list of IPv4/IPv6 addresses, networks, TSIG keys of clients that
	// are allowed or denied access to the DNS view.
	MatchDestinations []*Addressac `json:"match_destinations,omitempty"`

	// The maximum number of seconds to cache ordinary (positive) answers.
	MaxCacheTtl *uint32 `json:"max_cache_ttl,omitempty"`

	// The maximum number of seconds to cache negative (NXDOMAIN) answers.
	MaxNcacheTtl *uint32 `json:"max_ncache_ttl,omitempty"`

	// The value is used by authoritative DNS servers to never send DNS responses
	// larger than the configured value. The value should be between 512 and 4096
	// bytes. The recommended value is between 512 and 1220 bytes.
	MaxUdpSize *uint32 `json:"max_udp_size,omitempty"`

	// Name of the DNS view.
	Name *string `json:"name,omitempty"`

	// The name of the network view object associated with this DNS view.
	NetworkView *string `json:"network_view,omitempty"`

	// The number of seconds of delay the notify messages are sent to secondaries.
	NotifyDelay *uint32 `json:"notify_delay,omitempty"`

	// The flag that indicates whether NXDOMAIN redirection queries are logged.
	// Specify "true" to enable logging, or "false" to disable it. The default
	// value is "false".
	NxdomainLogQuery *bool `json:"nxdomain_log_query,omitempty"`

	// Determines if NXDOMAIN redirection in a DNS view is enabled or not.
	NxdomainRedirect *bool `json:"nxdomain_redirect,omitempty"`

	// The array with IPv4 addresses the appliance includes in the response it
	// sends in place of an NXDOMAIN response.
	NxdomainRedirectAddresses []string `json:"nxdomain_redirect_addresses,omitempty"`

	// The array with IPv6 addresses the appliance includes in the response it
	// sends in place of an NXDOMAIN response.
	NxdomainRedirectAddressesV6 []string `json:"nxdomain_redirect_addresses_v6,omitempty"`

	// The Time To Live (TTL) value of the synthetic DNS responses resulted from
	// NXDOMAIN redirection. The TTL value is a 32-bit unsigned integer that
	// represents the TTL in seconds.
	NxdomainRedirectTtl *uint32 `json:"nxdomain_redirect_ttl,omitempty"`

	// The names of the Ruleset objects assigned at the grid level for NXDOMAIN
	// redirection.
	NxdomainRulesets []string `json:"nxdomain_rulesets,omitempty"`

	// Determines if recursion is enabled or not.
	Recursion *bool `json:"recursion,omitempty"`

	// The response rate limiting settings for the DNS View.
	ResponseRateLimiting *GridResponseratelimiting `json:"response_rate_limiting,omitempty"`

	// Determines the type of root name servers.
	RootNameServerType string `json:"root_name_server_type,omitempty"`

	// Enables the appliance to ignore RPZ-IP triggers with prefix lengths less
	// than the specified minimum prefix length.
	RpzDropIpRuleEnabled *bool `json:"rpz_drop_ip_rule_enabled,omitempty"`

	// The minimum prefix length for IPv4 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv4
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv4 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv4,omitempty"`

	// The minimum prefix length for IPv6 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv6
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv6 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv6,omitempty"`

	// The flag that indicates whether recursive RPZ lookups are enabled.
	RpzQnameWaitRecurse *bool `json:"rpz_qname_wait_recurse,omitempty"`

	// The scavenging settings.
	ScavengingSettings *SettingScavenging `json:"scavenging_settings,omitempty"`

	// A sort list that determines the order of IP addresses in responses sent to
	// DNS queries.
	Sortlist []*Sortlist `json:"sortlist,omitempty"`

	// Use flag for: blacklist_action , blacklist_log_query,
	// blacklist_redirect_addresses, blacklist_redirect_ttl, blacklist_rulesets,
	// enable_blacklist
	UseBlacklist *bool `json:"use_blacklist,omitempty"`

	// Use flag for: ddns_force_creation_timestamp_update
	UseDdnsForceCreationTimestampUpdate *bool `json:"use_ddns_force_creation_timestamp_update,omitempty"`

	// Use flag for: ddns_restrict_patterns_list , ddns_restrict_patterns
	UseDdnsPatternsRestriction *bool `json:"use_ddns_patterns_restriction,omitempty"`

	// Use flag for: ddns_restrict_secure , ddns_principal_tracking,
	// ddns_principal_group
	UseDdnsPrincipalSecurity *bool `json:"use_ddns_principal_security,omitempty"`

	// Use flag for: ddns_restrict_protected
	UseDdnsRestrictProtected *bool `json:"use_ddns_restrict_protected,omitempty"`

	// Use flag for: ddns_restrict_static
	UseDdnsRestrictStatic *bool `json:"use_ddns_restrict_static,omitempty"`

	// Use flag for: dns64_enabled , dns64_groups
	UseDns64 *bool `json:"use_dns64,omitempty"`

	// Use flag for: dnssec_enabled , dnssec_expired_signatures_enabled,
	// dnssec_validation_enabled, dnssec_trusted_keys
	UseDnssec *bool `json:"use_dnssec,omitempty"`

	// Use flag for: edns_udp_size
	UseEdnsUdpSize *bool `json:"use_edns_udp_size,omitempty"`

	// Use flag for: filter_aaaa , filter_aaaa_list
	UseFilterAaaa *bool `json:"use_filter_aaaa,omitempty"`

	// Use flag for: fixed_rrset_order_fqdns , enable_fixed_rrset_order_fqdns
	UseFixedRrsetOrderFqdns *bool `json:"use_fixed_rrset_order_fqdns,omitempty"`

	// Use flag for: forwarders , forward_only
	UseForwarders *bool `json:"use_forwarders,omitempty"`

	// Use flag for: lame_ttl
	UseLameTtl *bool `json:"use_lame_ttl,omitempty"`

	// Use flag for: max_cache_ttl
	UseMaxCacheTtl *bool `json:"use_max_cache_ttl,omitempty"`

	// Use flag for: max_ncache_ttl
	UseMaxNcacheTtl *bool `json:"use_max_ncache_ttl,omitempty"`

	// Use flag for: max_udp_size
	UseMaxUdpSize *bool `json:"use_max_udp_size,omitempty"`

	// Use flag for: nxdomain_redirect , nxdomain_redirect_addresses,
	// nxdomain_redirect_addresses_v6, nxdomain_redirect_ttl, nxdomain_log_query,
	// nxdomain_rulesets
	UseNxdomainRedirect *bool `json:"use_nxdomain_redirect,omitempty"`

	// Use flag for: recursion
	UseRecursion *bool `json:"use_recursion,omitempty"`

	// Use flag for: response_rate_limiting
	UseResponseRateLimiting *bool `json:"use_response_rate_limiting,omitempty"`

	// Use flag for: custom_root_name_servers , root_name_server_type
	UseRootNameServer *bool `json:"use_root_name_server,omitempty"`

	// Use flag for: rpz_drop_ip_rule_enabled ,
	// rpz_drop_ip_rule_min_prefix_length_ipv4,
	// rpz_drop_ip_rule_min_prefix_length_ipv6
	UseRpzDropIpRule *bool `json:"use_rpz_drop_ip_rule,omitempty"`

	// Use flag for: rpz_qname_wait_recurse
	UseRpzQnameWaitRecurse *bool `json:"use_rpz_qname_wait_recurse,omitempty"`

	// Use flag for: scavenging_settings , last_queried_acl
	UseScavengingSettings *bool `json:"use_scavenging_settings,omitempty"`

	// Use flag for: sortlist
	UseSortlist *bool `json:"use_sortlist,omitempty"`
}

func (View) ObjectType() string {
	return "view"
}

func (obj View) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"comment", "is_default", "name"}
	}
	return obj.returnFields
}

// Vlan represents Infoblox object vlan.
// References to vlan are object references.
type Vlan struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// List of objects VLAN is assigned to.
	AssignedTo []*Ipv4Network `json:"assigned_to,omitempty"`

	// A descriptive comment for this VLAN.
	Comment *string `json:"comment,omitempty"`

	// Contact information for person/team managing or using VLAN.
	Contact *string `json:"contact,omitempty"`

	// Department where VLAN is used.
	Department *string `json:"department,omitempty"`

	// Description for the VLAN object, may be potentially used for longer VLAN
	// names.
	Description *string `json:"description,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// VLAN ID value.
	Id *uint32 `json:"id,omitempty"`

	// Name of the VLAN.
	Name *string `json:"name,omitempty"`

	// The VLAN View or VLAN Range to which this VLAN belongs.
	Parent *string `json:"parent,omitempty"`

	// When set VLAN can only be assigned to IPAM object manually.
	Reserved *bool `json:"reserved,omitempty"`

	// Status of VLAN object. Can be Assigned, Unassigned, Reserved.
	Status string `json:"status,omitempty"`
}

func (Vlan) ObjectType() string {
	return "vlan"
}

func (obj Vlan) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"id", "name", "parent"}
	}
	return obj.returnFields
}

// Vlanrange represents Infoblox object vlanrange.
// References to vlanrange are object references.
type Vlanrange struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// A descriptive comment for this VLAN Range.
	Comment *string `json:"comment,omitempty"`

	// Vlans delete option. Determines whether all child objects should be removed
	// alongside with the VLAN Range or child objects should be assigned to another
	// parental VLAN Range/View. By default child objects are re-parented.
	DeleteVlans bool `json:"delete_vlans,omitempty"`

	// End ID for VLAN Range.
	EndVlanId *uint32 `json:"end_vlan_id,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name of the VLAN Range.
	Name *string `json:"name,omitempty"`

	// If set on creation VLAN objects will be created once VLAN Range created.
	PreCreateVlan *bool `json:"pre_create_vlan,omitempty"`

	// Start ID for VLAN Range.
	StartVlanId *uint32 `json:"start_vlan_id,omitempty"`

	// If set on creation prefix string will be used for VLAN name.
	VlanNamePrefix *string `json:"vlan_name_prefix,omitempty"`

	// The VLAN View to which this VLAN Range belongs.
	VlanView *string `json:"vlan_view,omitempty"`
}

func (Vlanrange) ObjectType() string {
	return "vlanrange"
}

func (obj Vlanrange) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"end_vlan_id", "name", "start_vlan_id", "vlan_view"}
	}
	return obj.returnFields
}

// Vlanview represents Infoblox object vlanview.
// References to vlanview are object references.
type Vlanview struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// When set to true VLAN Ranges under VLAN View can have overlapping ID.
	AllowRangeOverlapping *bool `json:"allow_range_overlapping,omitempty"`

	// A descriptive comment for this VLAN View.
	Comment *string `json:"comment,omitempty"`

	// End ID for VLAN View.
	EndVlanId *uint32 `json:"end_vlan_id,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// Name of the VLAN View.
	Name *string `json:"name,omitempty"`

	// If set on creation VLAN objects will be created once VLAN View created.
	PreCreateVlan *bool `json:"pre_create_vlan,omitempty"`

	// Start ID for VLAN View.
	StartVlanId *uint32 `json:"start_vlan_id,omitempty"`

	// If set on creation prefix string will be used for VLAN name.
	VlanNamePrefix *string `json:"vlan_name_prefix,omitempty"`
}

func (Vlanview) ObjectType() string {
	return "vlanview"
}

func (obj Vlanview) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"end_vlan_id", "name", "start_vlan_id"}
	}
	return obj.returnFields
}

// ZoneAuth represents Infoblox object zone_auth.
// An authoritative zone is a zone for which the local (primary or secondary)
// server references its own data when responding to queries. The local server
// is authoritative for the data in this zone and responds to queries for this
// data without referencing another server.
type ZoneAuth struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the server that is serving this zone.
	Address string `json:"address,omitempty"`

	// This field allows the zone to receive GSS-TSIG authenticated DDNS updates
	// from DHCP clients and servers in an AD domain. Note that addresses specified
	// in this field ignore the permission set in the struct which will be set to
	// 'ALLOW'.
	AllowActiveDir []*Addressac `json:"allow_active_dir,omitempty"`

	// The flag that allows to enable or disable fixed RRset ordering for
	// authoritative forward-mapping zones.
	AllowFixedRrsetOrder *bool `json:"allow_fixed_rrset_order,omitempty"`

	// The flag that allows DHCP clients to perform GSS-TSIG signed updates for
	// underscore zones.
	AllowGssTsigForUnderscoreZone *bool `json:"allow_gss_tsig_for_underscore_zone,omitempty"`

	// The flag that enables or disables the zone for GSS-TSIG updates.
	AllowGssTsigZoneUpdates *bool `json:"allow_gss_tsig_zone_updates,omitempty"`

	// Determines whether DNS queries are allowed from a named ACL, or from a list
	// of IPv4/IPv6 addresses, networks, and TSIG keys for the hosts.
	AllowQuery []*Addressac `json:"allow_query,omitempty"`

	// Determines whether zone transfers are allowed from a named ACL, or from a
	// list of IPv4/IPv6 addresses, networks, and TSIG keys for the hosts.
	AllowTransfer []*Addressac `json:"allow_transfer,omitempty"`

	// Determines whether dynamic DNS updates are allowed from a named ACL, or from
	// a list of IPv4/IPv6 addresses, networks, and TSIG keys for the hosts.
	AllowUpdate []*Addressac `json:"allow_update,omitempty"`

	// The list with IP addresses, networks or TSIG keys for clients, from which
	// forwarded dynamic updates are allowed.
	AllowUpdateForwarding *bool `json:"allow_update_forwarding,omitempty"`

	// Additional information for Route53 zone.
	AwsRte53ZoneInfo *Awsrte53zoneinfo `json:"aws_rte53_zone_info,omitempty"`

	// Structure containing all cloud API related information for this object.
	CloudInfo *GridCloudapiInfo `json:"cloud_info,omitempty"`

	// Comment for the zone; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// If this flag is set to True then copy allowed IPs from Allow Transfer to
	// Also Notify.
	CopyXferToNotify *bool `json:"copy_xfer_to_notify,omitempty"`

	// Determines if PTR records are created for hosts automatically, if necessary,
	// when the zone data is imported. This field is meaningful only when
	// import_from is set.
	CreatePtrForBulkHosts *bool `json:"create_ptr_for_bulk_hosts,omitempty"`

	// Determines if PTR records are created for hosts automatically, if necessary,
	// when the zone data is imported. This field is meaningful only when
	// import_from is set.
	CreatePtrForHosts *bool `json:"create_ptr_for_hosts,omitempty"`

	// Determines whether automatic creation of subzones is enabled or not.
	CreateUnderscoreZones *bool `json:"create_underscore_zones,omitempty"`

	// Defines whether creation timestamp of RR should be updated ' when DDNS
	// update happens even if there is no change to ' the RR.
	DdnsForceCreationTimestampUpdate *bool `json:"ddns_force_creation_timestamp_update,omitempty"`

	// The DDNS Principal cluster group name.
	DdnsPrincipalGroup *string `json:"ddns_principal_group,omitempty"`

	// The flag that indicates whether the DDNS principal track is enabled or
	// disabled.
	DdnsPrincipalTracking *bool `json:"ddns_principal_tracking,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request
	// based on FQDN patterns is enabled or disabled.
	DdnsRestrictPatterns *bool `json:"ddns_restrict_patterns,omitempty"`

	// The unordered list of restriction patterns for an option of to restrict DDNS
	// updates based on FQDN patterns.
	DdnsRestrictPatternsList []string `json:"ddns_restrict_patterns_list,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request to
	// protected resource records is enabled or disabled.
	DdnsRestrictProtected *bool `json:"ddns_restrict_protected,omitempty"`

	// The flag that indicates whether DDNS update request for principal other than
	// target resource record's principal is restricted.
	DdnsRestrictSecure *bool `json:"ddns_restrict_secure,omitempty"`

	// The flag that indicates whether an option to restrict DDNS update request to
	// resource records which are marked as 'STATIC' is enabled or disabled.
	DdnsRestrictStatic *bool `json:"ddns_restrict_static,omitempty"`

	// Determines whether a zone is disabled or not. When this is set to False, the
	// zone is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines whether the name servers that host the zone should forward
	// queries (ended with the domain name of the zone) to any configured
	// forwarders.
	DisableForwarding *bool `json:"disable_forwarding,omitempty"`

	// The displayed name of the DNS zone.
	DisplayDomain string `json:"display_domain,omitempty"`

	// The name of this DNS zone in punycode format. For a reverse zone, this is in
	// "address/cidr" format. For other zones, this is in FQDN format in punycode
	// format.
	DnsFqdn string `json:"dns_fqdn,omitempty"`

	// If this is set to True, DNS integrity check is enabled for this zone.
	DnsIntegrityEnable *bool `json:"dns_integrity_enable,omitempty"`

	// The frequency, in seconds, of DNS integrity checks for this zone.
	DnsIntegrityFrequency *uint32 `json:"dns_integrity_frequency,omitempty"`

	// The Grid member that performs DNS integrity checks for this zone.
	DnsIntegrityMember *string `json:"dns_integrity_member,omitempty"`

	// If this is set to True, more information is logged for DNS integrity checks
	// for this zone.
	DnsIntegrityVerboseLogging *bool `json:"dns_integrity_verbose_logging,omitempty"`

	// The SOA email for the zone in punycode format.
	DnsSoaEmail string `json:"dns_soa_email,omitempty"`

	// This structure contains the DNSSEC key parameters for this zone.
	DnssecKeyParams *Dnsseckeyparams `json:"dnssec_key_params,omitempty"`

	// A list of DNSSEC keys for the zone.
	DnssecKeys []*Dnsseckey `json:"dnssec_keys,omitempty"`

	// The rollover date for the Key Signing Key.
	DnssecKskRolloverDate *UnixTime `json:"dnssec_ksk_rollover_date,omitempty"`

	// The rollover date for the Zone Signing Key.
	DnssecZskRolloverDate *UnixTime `json:"dnssec_zsk_rollover_date,omitempty"`

	// Determines if hosts and bulk hosts are automatically created when the zone
	// data is imported. This field is meaningful only when import_from is set.
	DoHostAbstraction *bool `json:"do_host_abstraction,omitempty"`

	// The value of the check names policy, which indicates the action the
	// appliance takes when it encounters host names that do not comply with the
	// Strict Hostname Checking policy. This value applies only if the host name
	// restriction policy is set to "Strict Hostname Checking".
	EffectiveCheckNamesPolicy string `json:"effective_check_names_policy,omitempty"`

	// The selected hostname policy for records under this zone.
	EffectiveRecordNamePolicy string `json:"effective_record_name_policy,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of external primary servers.
	ExternalPrimaries []NameServer `json:"external_primaries,omitempty"`

	// The list of external secondary servers.
	ExternalSecondaries []NameServer `json:"external_secondaries,omitempty"`

	// The name of this DNS zone. For a reverse zone, this is in "address/cidr"
	// format. For other zones, this is in FQDN format. This value can be in
	// unicode format. Note that for a reverse zone, the corresponding zone_format
	// value should be set.
	Fqdn string `json:"fqdn,omitempty"`

	// The grid primary servers for this zone.
	GridPrimary []*Memberserver `json:"grid_primary,omitempty"`

	// Determines if the server is duplicated with parent delegation.
	GridPrimarySharedWithMsParentDelegation bool `json:"grid_primary_shared_with_ms_parent_delegation,omitempty"`

	// The list with Grid members that are secondary servers for this zone.
	GridSecondaries []*Memberserver `json:"grid_secondaries,omitempty"`

	// The IP address of the Infoblox appliance from which zone data is imported.
	// Setting this address to '255.255.255.255' and do_host_abstraction to 'true'
	// will create Host records from A records in this zone without importing zone
	// data.
	ImportFrom *string `json:"import_from,omitempty"`

	// This flag is set to True if DNSSEC is enabled for the zone.
	IsDnssecEnabled bool `json:"is_dnssec_enabled,omitempty"`

	// Determines if the zone is DNSSEC signed.
	IsDnssecSigned bool `json:"is_dnssec_signed,omitempty"`

	// Determines if multi-master DNS is enabled for the zone.
	IsMultimaster bool `json:"is_multimaster,omitempty"`

	// The time the zone was last queried on.
	LastQueried *UnixTime `json:"last_queried,omitempty"`

	// Determines last queried ACL for the specified IPv4 or IPv6 addresses and
	// networks in scavenging settings.
	LastQueriedAcl []*Addressac `json:"last_queried_acl,omitempty"`

	// If you enable this flag, other administrators cannot make conflicting
	// changes. This is for administration purposes only. The zone will continue to
	// serve DNS data even when it is locked.
	Locked *bool `json:"locked,omitempty"`

	// The name of a superuser or the administrator who locked this zone.
	LockedBy string `json:"locked_by,omitempty"`

	// IPv4 Netmask or IPv6 prefix for this zone.
	MaskPrefix string `json:"mask_prefix,omitempty"`

	// The list of per-member SOA MNAME information.
	MemberSoaMnames []*GridmemberSoamname `json:"member_soa_mnames,omitempty"`

	// The list of per-member SOA serial information.
	MemberSoaSerials []*GridmemberSoaserial `json:"member_soa_serials,omitempty"`

	// The flag that determines whether Active Directory is integrated or not. This
	// field is valid only when ms_managed is "STUB", "AUTH_PRIMARY", or
	// "AUTH_BOTH".
	MsAdIntegrated *bool `json:"ms_ad_integrated,omitempty"`

	// The list of DNS clients that are allowed to perform zone transfers from a
	// Microsoft DNS server. This setting applies only to zones with Microsoft DNS
	// servers that are either primary or secondary servers. This setting does not
	// inherit any value from the Grid or from any member that defines an
	// allow_transfer value. This setting does not apply to any grid member. Use
	// the allow_transfer field to control which DNS clients are allowed to perform
	// zone transfers on Grid members.
	MsAllowTransfer []*Addressac `json:"ms_allow_transfer,omitempty"`

	// Determines which DNS clients are allowed to perform zone transfers from a
	// Microsoft DNS server. Valid values are: "ADDRESS_AC", to use
	// ms_allow_transfer field for specifying IP addresses, networks and
	// Transaction Signature (TSIG) keys for clients that are allowed to do zone
	// transfers. "ANY", to allow any client. "ANY_NS", to allow only the
	// nameservers listed in this zone. "NONE", to deny all zone transfer requests.
	MsAllowTransferMode string `json:"ms_allow_transfer_mode,omitempty"`

	// The list of domain controllers that are allowed to create NS records for
	// authoritative zones.
	MsDcNsRecordCreation []*MsserverDcnsrecordcreation `json:"ms_dc_ns_record_creation,omitempty"`

	// Determines whether an Active Directory-integrated zone with a Microsoft DNS
	// server as primary allows dynamic updates. Valid values are: "SECURE" if the
	// zone allows secure updates only. "NONE" if the zone forbids dynamic updates.
	// "ANY" if the zone accepts both secure and nonsecure updates. This field is
	// valid only if ms_managed is either "AUTH_PRIMARY" or "AUTH_BOTH". If the
	// flag ms_ad_integrated is false, the value "SECURE" is not allowed.
	MsDdnsMode string `json:"ms_ddns_mode,omitempty"`

	// The flag that indicates whether the zone is assigned to a Microsoft DNS
	// server. This flag returns the authoritative name server type of the
	// Microsoft DNS server. Valid values are: "NONE" if the zone is not assigned
	// to any Microsoft DNS server. "STUB" if the zone is assigned to a Microsoft
	// DNS server as a stub zone. "AUTH_PRIMARY" if only the primary server of the
	// zone is a Microsoft DNS server. "AUTH_SECONDARY" if only the secondary
	// server of the zone is a Microsoft DNS server. "AUTH_BOTH" if both the
	// primary and secondary servers of the zone are Microsoft DNS servers.
	MsManaged string `json:"ms_managed,omitempty"`

	// The list with the Microsoft DNS servers that are primary servers for the
	// zone. Although a zone typically has just one primary name server, you can
	// specify up to ten independent servers for a single zone.
	MsPrimaries []*Msdnsserver `json:"ms_primaries,omitempty"`

	// Determines if a Grid member manages the zone served by a Microsoft DNS
	// server in read-only mode. This flag is true when a Grid member manages the
	// zone in read-only mode, false otherwise. When the zone has the ms_read_only
	// flag set to True, no changes can be made to this zone.
	MsReadOnly bool `json:"ms_read_only,omitempty"`

	// The list with the Microsoft DNS servers that are secondary servers for the
	// zone.
	MsSecondaries []*Msdnsserver `json:"ms_secondaries,omitempty"`

	// This flag controls whether this zone is synchronized with Microsoft DNS
	// servers.
	MsSyncDisabled *bool `json:"ms_sync_disabled,omitempty"`

	// The name of MS synchronization master for this zone.
	MsSyncMasterName string `json:"ms_sync_master_name,omitempty"`

	// The list with the associated network/network container information.
	NetworkAssociations []*Ipv4Network `json:"network_associations,omitempty"`

	// The name of the network view in which this zone resides.
	NetworkView string `json:"network_view,omitempty"`

	// The number of seconds in delay with which notify messages are sent to
	// secondaries.
	NotifyDelay *uint32 `json:"notify_delay,omitempty"`

	// The name server group that serves DNS for this zone.
	NsGroup *string `json:"ns_group"`

	// The parent zone of this zone. Note that when searching for reverse zones,
	// the "in-addr.arpa" notation should be used.
	Parent string `json:"parent,omitempty"`

	// The RFC2317 prefix value of this DNS zone. Use this field only when the
	// netmask is greater than 24 bits; that is, for a mask between 25 and 31 bits.
	// Enter a prefix, such as the name of the allocated address block. The prefix
	// can be alphanumeric characters, such as 128/26 , 128-189 , or sub-B.
	Prefix *string `json:"prefix,omitempty"`

	// The type of the primary server.
	PrimaryType string `json:"primary_type,omitempty"`

	// The hostname policy for records under this zone.
	RecordNamePolicy *string `json:"record_name_policy,omitempty"`

	// Determines if this zone is also monitoring resource records.
	RecordsMonitored bool `json:"records_monitored,omitempty"`

	// Restarts the member service.
	RestartIfNeeded *bool `json:"restart_if_needed,omitempty"`

	// The time data collection for Not Queried Resource Record was enabled for
	// this zone.
	RrNotQueriedEnabledTime *UnixTime `json:"rr_not_queried_enabled_time,omitempty"`

	// The scavenging settings.
	ScavengingSettings *SettingScavenging `json:"scavenging_settings,omitempty"`

	// The serial number in the SOA record incrementally changes every time the
	// record is modified. The Infoblox appliance allows you to change the serial
	// number (in the SOA record) for the primary server so it is higher than the
	// secondary server, thereby ensuring zone transfers come from the primary
	// server (as they should). To change the serial number you need to set a new
	// value at "soa_serial_number" and pass "set_soa_serial_number" as True.
	SetSoaSerialNumber *bool `json:"set_soa_serial_number,omitempty"`

	// The Time to Live (TTL) value of the SOA record of this zone. This value is
	// the number of seconds that data is cached.
	SoaDefaultTtl *uint32 `json:"soa_default_ttl,omitempty"`

	// The SOA email value for this zone. This value can be in unicode format.
	SoaEmail *string `json:"soa_email,omitempty"`

	// This setting defines the amount of time, in seconds, after which the
	// secondary server stops giving out answers about the zone because the zone
	// data is too old to be useful. The default is one week.
	SoaExpire *uint32 `json:"soa_expire,omitempty"`

	// The negative Time to Live (TTL) value of the SOA of the zone indicates how
	// long a secondary server can cache data for "Does Not Respond" responses.
	SoaNegativeTtl *uint32 `json:"soa_negative_ttl,omitempty"`

	// This indicates the interval at which a secondary server sends a message to
	// the primary server for a zone to check that its data is current, and
	// retrieve fresh data if it is not.
	SoaRefresh *uint32 `json:"soa_refresh,omitempty"`

	// This indicates how long a secondary server must wait before attempting to
	// recontact the primary server after a connection failure between the two
	// servers occurs.
	SoaRetry *uint32 `json:"soa_retry,omitempty"`

	// The serial number in the SOA record incrementally changes every time the
	// record is modified. The Infoblox appliance allows you to change the serial
	// number (in the SOA record) for the primary server so it is higher than the
	// secondary server, thereby ensuring zone transfers come from the primary
	// server (as they should). To change the serial number you need to set a new
	// value at "soa_serial_number" and pass "set_soa_serial_number" as True.
	SoaSerialNumber *uint32 `json:"soa_serial_number,omitempty"`

	// The associated shared record groups of a DNS zone. If a shared record group
	// is associated with a zone, then all shared records in a shared record group
	// will be shared in the zone.
	Srgs []string `json:"srgs,omitempty"`

	// Use this field to allow or deny dynamic DNS updates that are forwarded from
	// specific IPv4/IPv6 addresses, networks, or a named ACL. You can also provide
	// TSIG keys for clients that are allowed or denied to perform zone updates.
	// This setting overrides the member-level setting.
	UpdateForwarding []*Addressac `json:"update_forwarding,omitempty"`

	// Use flag for: allow_active_dir
	UseAllowActiveDir *bool `json:"use_allow_active_dir,omitempty"`

	// Use flag for: allow_query
	UseAllowQuery *bool `json:"use_allow_query,omitempty"`

	// Use flag for: allow_transfer
	UseAllowTransfer *bool `json:"use_allow_transfer,omitempty"`

	// Use flag for: allow_update
	UseAllowUpdate *bool `json:"use_allow_update,omitempty"`

	// Use flag for: allow_update_forwarding
	UseAllowUpdateForwarding *bool `json:"use_allow_update_forwarding,omitempty"`

	// Apply policy to dynamic updates and inbound zone transfers (This value
	// applies only if the host name restriction policy is set to "Strict Hostname
	// Checking".)
	UseCheckNamesPolicy *bool `json:"use_check_names_policy,omitempty"`

	// Use flag for: copy_xfer_to_notify
	UseCopyXferToNotify *bool `json:"use_copy_xfer_to_notify,omitempty"`

	// Use flag for: ddns_force_creation_timestamp_update
	UseDdnsForceCreationTimestampUpdate *bool `json:"use_ddns_force_creation_timestamp_update,omitempty"`

	// Use flag for: ddns_restrict_patterns_list , ddns_restrict_patterns
	UseDdnsPatternsRestriction *bool `json:"use_ddns_patterns_restriction,omitempty"`

	// Use flag for: ddns_restrict_secure , ddns_principal_tracking,
	// ddns_principal_group
	UseDdnsPrincipalSecurity *bool `json:"use_ddns_principal_security,omitempty"`

	// Use flag for: ddns_restrict_protected
	UseDdnsRestrictProtected *bool `json:"use_ddns_restrict_protected,omitempty"`

	// Use flag for: ddns_restrict_static
	UseDdnsRestrictStatic *bool `json:"use_ddns_restrict_static,omitempty"`

	// Use flag for: dnssec_key_params
	UseDnssecKeyParams *bool `json:"use_dnssec_key_params,omitempty"`

	// This flag controls whether the zone is using an external primary.
	UseExternalPrimary *bool `json:"use_external_primary,omitempty"`

	// Use flag for: soa_default_ttl , soa_expire, soa_negative_ttl, soa_refresh,
	// soa_retry
	UseGridZoneTimer *bool `json:"use_grid_zone_timer,omitempty"`

	// Use flag for: import_from
	UseImportFrom *bool `json:"use_import_from,omitempty"`

	// Use flag for: notify_delay
	UseNotifyDelay *bool `json:"use_notify_delay,omitempty"`

	// Use flag for: record_name_policy
	UseRecordNamePolicy *bool `json:"use_record_name_policy,omitempty"`

	// Use flag for: scavenging_settings , last_queried_acl
	UseScavengingSettings *bool `json:"use_scavenging_settings,omitempty"`

	// Use flag for: soa_email
	UseSoaEmail *bool `json:"use_soa_email,omitempty"`

	// This is true if the zone is associated with a shared record group.
	UsingSrgAssociations bool `json:"using_srg_associations,omitempty"`

	// The name of the DNS view in which the zone resides. Example "external".
	View *string `json:"view,omitempty"`

	// Determines the format of this zone.
	ZoneFormat string `json:"zone_format,omitempty"`

	// The time when "DNS Zones Last Queried" was turned on for this zone.
	ZoneNotQueriedEnabledTime *UnixTime `json:"zone_not_queried_enabled_time,omitempty"`
}

func (ZoneAuth) ObjectType() string {
	return "zone_auth"
}

func (obj ZoneAuth) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"fqdn", "view"}
	}
	return obj.returnFields
}

func NewZoneAuth(za ZoneAuth) *ZoneAuth {
	res := za
	res.returnFields = []string{"extattrs", "fqdn", "view"}
	return &res
}

// ZoneAuthDiscrepancy represents Infoblox object zone_auth_discrepancy.
// This object contains information about discrepancies found when performing a
// DNS integrity check for a zone.
type ZoneAuthDiscrepancy struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// Information about the discrepancy.
	Description string `json:"description,omitempty"`

	// The severity of the discrepancy reported.
	Severity string `json:"severity,omitempty"`

	// The time when the DNS integrity check was last run for this zone.
	Timestamp *UnixTime `json:"timestamp,omitempty"`

	// The reference of the zone during a search. Otherwise, this is the zone
	// object of the zone to which the discrepancy refers.
	Zone string `json:"zone,omitempty"`
}

func (ZoneAuthDiscrepancy) ObjectType() string {
	return "zone_auth_discrepancy"
}

func (obj ZoneAuthDiscrepancy) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"description", "severity", "timestamp", "zone"}
	}
	return obj.returnFields
}

// ZoneDelegated represents Infoblox object zone_delegated.
// Instead of a local name server, remote name servers (which the local server
// knows) maintain delegated zone data. When the local name server receives a
// query for a delegated zone, it either responds with the NS record for the
// delegated zone server (if recursion is disabled on the local server) or it
// queries the delegated zone server on behalf of the resolver (if recursion is
// enabled).
type ZoneDelegated struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the server that is serving this zone.
	Address string `json:"address,omitempty"`

	// Comment for the zone; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// This provides information for the remote name server that maintains data for
	// the delegated zone. The Infoblox appliance redirects queries for data for
	// the delegated zone to this remote name server.
	DelegateTo NullableNameServers `json:"delegate_to,omitempty"`

	// You can specify the Time to Live (TTL) values of auto-generated NS and glue
	// records for a delegated zone. This value is the number of seconds that data
	// is cached.
	DelegatedTtl *uint32 `json:"delegated_ttl,omitempty"`

	// Determines whether a zone is disabled or not. When this is set to False, the
	// zone is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The displayed name of the DNS zone.
	DisplayDomain string `json:"display_domain,omitempty"`

	// The name of this DNS zone in punycode format. For a reverse zone, this is in
	// "address/cidr" format. For other zones, this is in FQDN format in punycode
	// format.
	DnsFqdn string `json:"dns_fqdn,omitempty"`

	// This flag controls whether automatic generation of RFC 2317 CNAMEs for
	// delegated reverse zones overwrite existing PTR records. The default behavior
	// is to overwrite all the existing records in the range; this corresponds to
	// "allow_ptr_creation_in_parent" set to False. However, when this flag is set
	// to True the existing PTR records are not overwritten.
	EnableRfc2317Exclusion *bool `json:"enable_rfc2317_exclusion,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The name of this DNS zone. For a reverse zone, this is in "address/cidr"
	// format. For other zones, this is in FQDN format. This value can be in
	// unicode format. Note that for a reverse zone, the corresponding zone_format
	// value should be set.
	Fqdn string `json:"fqdn,omitempty"`

	// If you enable this flag, other administrators cannot make conflicting
	// changes. This is for administration purposes only. The zone will continue to
	// serve DNS data even when it is locked.
	Locked *bool `json:"locked,omitempty"`

	// The name of a superuser or the administrator who locked this zone.
	LockedBy string `json:"locked_by,omitempty"`

	// IPv4 Netmask or IPv6 prefix for this zone.
	MaskPrefix string `json:"mask_prefix,omitempty"`

	// The flag that determines whether Active Directory is integrated or not. This
	// field is valid only when ms_managed is "STUB", "AUTH_PRIMARY", or
	// "AUTH_BOTH".
	MsAdIntegrated *bool `json:"ms_ad_integrated,omitempty"`

	// Determines whether an Active Directory-integrated zone with a Microsoft DNS
	// server as primary allows dynamic updates. Valid values are: "SECURE" if the
	// zone allows secure updates only. "NONE" if the zone forbids dynamic updates.
	// "ANY" if the zone accepts both secure and nonsecure updates. This field is
	// valid only if ms_managed is either "AUTH_PRIMARY" or "AUTH_BOTH". If the
	// flag ms_ad_integrated is false, the value "SECURE" is not allowed.
	MsDdnsMode string `json:"ms_ddns_mode,omitempty"`

	// The flag that indicates whether the zone is assigned to a Microsoft DNS
	// server. This flag returns the authoritative name server type of the
	// Microsoft DNS server. Valid values are: "NONE" if the zone is not assigned
	// to any Microsoft DNS server. "STUB" if the zone is assigned to a Microsoft
	// DNS server as a stub zone. "AUTH_PRIMARY" if only the primary server of the
	// zone is a Microsoft DNS server. "AUTH_SECONDARY" if only the secondary
	// server of the zone is a Microsoft DNS server. "AUTH_BOTH" if both the
	// primary and secondary servers of the zone are Microsoft DNS servers.
	MsManaged string `json:"ms_managed,omitempty"`

	// Determines if a Grid member manages the zone served by a Microsoft DNS
	// server in read-only mode. This flag is true when a Grid member manages the
	// zone in read-only mode, false otherwise. When the zone has the ms_read_only
	// flag set to True, no changes can be made to this zone.
	MsReadOnly bool `json:"ms_read_only,omitempty"`

	// The name of MS synchronization master for this zone.
	MsSyncMasterName string `json:"ms_sync_master_name,omitempty"`

	// The delegation NS group bound with delegated zone.
	NsGroup *string `json:"ns_group"`

	// The parent zone of this zone. Note that when searching for reverse zones,
	// the "in-addr.arpa" notation should be used.
	Parent string `json:"parent,omitempty"`

	// The RFC2317 prefix value of this DNS zone. Use this field only when the
	// netmask is greater than 24 bits; that is, for a mask between 25 and 31 bits.
	// Enter a prefix, such as the name of the allocated address block. The prefix
	// can be alphanumeric characters, such as 128/26 , 128-189 , or sub-B.
	Prefix *string `json:"prefix,omitempty"`

	// Use flag for: delegated_ttl
	UseDelegatedTtl *bool `json:"use_delegated_ttl,omitempty"`

	// This is true if the zone is associated with a shared record group.
	UsingSrgAssociations bool `json:"using_srg_associations,omitempty"`

	// The name of the DNS view in which the zone resides. Example "external".
	View *string `json:"view,omitempty"`

	// Determines the format of this zone.
	ZoneFormat string `json:"zone_format,omitempty"`
}

func (ZoneDelegated) ObjectType() string {
	return "zone_delegated"
}

func (obj ZoneDelegated) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"delegate_to", "fqdn", "view"}
	}
	return obj.returnFields
}

func NewZoneDelegated(za ZoneDelegated) *ZoneDelegated {
	res := za
	res.SetReturnFields(append(res.ReturnFields(), "comment", "disable", "locked", "ns_group", "delegated_ttl", "use_delegated_ttl", "zone_format", "extattrs"))

	return &res
}

// ZoneForward represents Infoblox object zone_forward.
// When you want to forward queries for data in a particular zone, define the
// zone as a forward zone and specify one or more name servers that can resolve
// queries for the zone. For example, define a forward zone so that the NIOS
// appliance forwards queries about a partners internal site to a name server,
// which the partner hosts, configured just for other partners to access.
type ZoneForward struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the server that is serving this zone.
	Address string `json:"address,omitempty"`

	// Comment for the zone; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a zone is disabled or not. When this is set to False, the
	// zone is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines whether a auto-generation of NS records in parent zone is
	// disabled or not. When this is set to False, the auto-generation is enabled.
	DisableNsGeneration *bool `json:"disable_ns_generation,omitempty"`

	// The displayed name of the DNS zone.
	DisplayDomain string `json:"display_domain,omitempty"`

	// The name of this DNS zone in punycode format. For a reverse zone, this is in
	// "address/cidr" format. For other zones, this is in FQDN format in punycode
	// format.
	DnsFqdn string `json:"dns_fqdn,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// A forward stub server name server group.
	ExternalNsGroup *string `json:"external_ns_group"`

	// The information for the remote name servers to which you want the Infoblox
	// appliance to forward queries for a specified domain name.
	ForwardTo NullableNameServers `json:"forward_to,omitempty"`

	// Determines if the appliance sends queries to forwarders only, and not to
	// other internal or Internet root servers.
	ForwardersOnly *bool `json:"forwarders_only,omitempty"`

	// The information for the Grid members to which you want the Infoblox
	// appliance to forward queries for a specified domain name.
	ForwardingServers *NullableForwardingServers `json:"forwarding_servers,omitempty"`

	// The name of this DNS zone. For a reverse zone, this is in "address/cidr"
	// format. For other zones, this is in FQDN format. This value can be in
	// unicode format. Note that for a reverse zone, the corresponding zone_format
	// value should be set.
	Fqdn string `json:"fqdn,omitempty"`

	// If you enable this flag, other administrators cannot make conflicting
	// changes. This is for administration purposes only. The zone will continue to
	// serve DNS data even when it is locked.
	Locked *bool `json:"locked,omitempty"`

	// The name of a superuser or the administrator who locked this zone.
	LockedBy string `json:"locked_by,omitempty"`

	// IPv4 Netmask or IPv6 prefix for this zone.
	MaskPrefix string `json:"mask_prefix,omitempty"`

	// The flag that determines whether Active Directory is integrated or not. This
	// field is valid only when ms_managed is "STUB", "AUTH_PRIMARY", or
	// "AUTH_BOTH".
	MsAdIntegrated *bool `json:"ms_ad_integrated,omitempty"`

	// Determines whether an Active Directory-integrated zone with a Microsoft DNS
	// server as primary allows dynamic updates. Valid values are: "SECURE" if the
	// zone allows secure updates only. "NONE" if the zone forbids dynamic updates.
	// "ANY" if the zone accepts both secure and nonsecure updates. This field is
	// valid only if ms_managed is either "AUTH_PRIMARY" or "AUTH_BOTH". If the
	// flag ms_ad_integrated is false, the value "SECURE" is not allowed.
	MsDdnsMode string `json:"ms_ddns_mode,omitempty"`

	// The flag that indicates whether the zone is assigned to a Microsoft DNS
	// server. This flag returns the authoritative name server type of the
	// Microsoft DNS server. Valid values are: "NONE" if the zone is not assigned
	// to any Microsoft DNS server. "STUB" if the zone is assigned to a Microsoft
	// DNS server as a stub zone. "AUTH_PRIMARY" if only the primary server of the
	// zone is a Microsoft DNS server. "AUTH_SECONDARY" if only the secondary
	// server of the zone is a Microsoft DNS server. "AUTH_BOTH" if both the
	// primary and secondary servers of the zone are Microsoft DNS servers.
	MsManaged string `json:"ms_managed,omitempty"`

	// Determines if a Grid member manages the zone served by a Microsoft DNS
	// server in read-only mode. This flag is true when a Grid member manages the
	// zone in read-only mode, false otherwise. When the zone has the ms_read_only
	// flag set to True, no changes can be made to this zone.
	MsReadOnly bool `json:"ms_read_only,omitempty"`

	// The name of MS synchronization master for this zone.
	MsSyncMasterName string `json:"ms_sync_master_name,omitempty"`

	// A forwarding member name server group.
	NsGroup *string `json:"ns_group"`

	// The parent zone of this zone. Note that when searching for reverse zones,
	// the "in-addr.arpa" notation should be used.
	Parent string `json:"parent,omitempty"`

	// The RFC2317 prefix value of this DNS zone. Use this field only when the
	// netmask is greater than 24 bits; that is, for a mask between 25 and 31 bits.
	// Enter a prefix, such as the name of the allocated address block. The prefix
	// can be alphanumeric characters, such as 128/26 , 128-189 , or sub-B.
	Prefix *string `json:"prefix,omitempty"`

	// This is true if the zone is associated with a shared record group.
	UsingSrgAssociations bool `json:"using_srg_associations,omitempty"`

	// The name of the DNS view in which the zone resides. Example "external".
	View *string `json:"view,omitempty"`

	// Determines the format of this zone.
	ZoneFormat string `json:"zone_format,omitempty"`
}

func (ZoneForward) ObjectType() string {
	return "zone_forward"
}

func (obj ZoneForward) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"forward_to", "fqdn", "view"}
	}
	return obj.returnFields
}

// ZoneRp represents Infoblox object zone_rp.
// DNS RPZs (Response Policy Zones), a technology developed by ISC (Internet
// System Consortium) for allowing reputable sources to dynamically communicate
// domain name reputation so you can implement policy controls for DNS lookups.
// You can configure RPZs and define RPZ rules to block DNS resolution for
// malicious or unauthorized domain names, or redirect clients to a walled
// garden by substituting responses. You can assign actions to RPZ rules. For
// example, abc.com can have an action of pass thru or substitute (domain) with
// the domain xyz.com. You can also configure a Grid member to act as a lead
// secondary that receives RPZ updates from external reputation sources and
// redistributes the updates to other Grid members.
type ZoneRp struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the server that is serving this zone.
	Address string `json:"address,omitempty"`

	// Comment for the zone; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a zone is disabled or not. When this is set to False, the
	// zone is enabled.
	Disable *bool `json:"disable,omitempty"`

	// The displayed name of the DNS zone.
	DisplayDomain string `json:"display_domain,omitempty"`

	// The SOA email for the zone in punycode format.
	DnsSoaEmail string `json:"dns_soa_email,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// The list of external primary servers.
	ExternalPrimaries []NameServer `json:"external_primaries,omitempty"`

	// The list of external secondary servers.
	ExternalSecondaries []NameServer `json:"external_secondaries,omitempty"`

	// Rules to map fireeye alerts.
	FireeyeRuleMapping *FireeyeRulemapping `json:"fireeye_rule_mapping,omitempty"`

	// The name of this DNS zone in FQDN format.
	Fqdn string `json:"fqdn,omitempty"`

	// The grid primary servers for this zone.
	GridPrimary []*Memberserver `json:"grid_primary,omitempty"`

	// The list with Grid members that are secondary servers for this zone.
	GridSecondaries []*Memberserver `json:"grid_secondaries,omitempty"`

	// If you enable this flag, other administrators cannot make conflicting
	// changes. This is for administration purposes only. The zone will continue to
	// serve DNS data even when it is locked.
	Locked *bool `json:"locked,omitempty"`

	// The name of a superuser or the administrator who locked this zone.
	LockedBy string `json:"locked_by,omitempty"`

	// Determines whether RPZ logging enabled or not at zone level. When this is
	// set to False, the logging is disabled.
	LogRpz *bool `json:"log_rpz,omitempty"`

	// IPv4 Netmask or IPv6 prefix for this zone.
	MaskPrefix string `json:"mask_prefix,omitempty"`

	// The list of per-member SOA MNAME information.
	MemberSoaMnames []*GridmemberSoamname `json:"member_soa_mnames,omitempty"`

	// The list of per-member SOA serial information.
	MemberSoaSerials []*GridmemberSoaserial `json:"member_soa_serials,omitempty"`

	// The name of the network view in which this zone resides.
	NetworkView string `json:"network_view,omitempty"`

	// The name server group that serves DNS for this zone.
	NsGroup *string `json:"ns_group,omitempty"`

	// The parent zone of this zone. Note that when searching for reverse zones,
	// the "in-addr.arpa" notation should be used.
	Parent string `json:"parent,omitempty"`

	// The RFC2317 prefix value of this DNS zone. Use this field only when the
	// netmask is greater than 24 bits; that is, for a mask between 25 and 31 bits.
	// Enter a prefix, such as the name of the allocated address block. The prefix
	// can be alphanumeric characters, such as 128/26 , 128-189 , or sub-B.
	Prefix *string `json:"prefix,omitempty"`

	// The type of the primary server.
	PrimaryType string `json:"primary_type,omitempty"`

	// The hostname policy for records under this zone.
	RecordNamePolicy *string `json:"record_name_policy,omitempty"`

	// Enables the appliance to ignore RPZ-IP triggers with prefix lengths less
	// than the specified minimum prefix length.
	RpzDropIpRuleEnabled *bool `json:"rpz_drop_ip_rule_enabled,omitempty"`

	// The minimum prefix length for IPv4 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv4
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv4 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv4,omitempty"`

	// The minimum prefix length for IPv6 RPZ-IP triggers. The appliance ignores
	// RPZ-IP triggers with prefix lengths less than the specified minimum IPv6
	// prefix length.
	RpzDropIpRuleMinPrefixLengthIpv6 *uint32 `json:"rpz_drop_ip_rule_min_prefix_length_ipv6,omitempty"`

	// The timestamp of the last update for zone data.
	RpzLastUpdatedTime *UnixTime `json:"rpz_last_updated_time,omitempty"`

	// The response policy zone override policy.
	RpzPolicy string `json:"rpz_policy,omitempty"`

	// The priority of this response policy zone.
	RpzPriority uint32 `json:"rpz_priority,omitempty"`

	// This number is for UI to identify the end of qualified zone list.
	RpzPriorityEnd uint32 `json:"rpz_priority_end,omitempty"`

	// The severity of this response policy zone.
	RpzSeverity string `json:"rpz_severity,omitempty"`

	// The type of rpz zone.
	RpzType string `json:"rpz_type,omitempty"`

	// The serial number in the SOA record incrementally changes every time the
	// record is modified. The Infoblox appliance allows you to change the serial
	// number (in the SOA record) for the primary server so it is higher than the
	// secondary server, thereby ensuring zone transfers come from the primary
	// server (as they should). To change the serial number you need to set a new
	// value at "soa_serial_number" and pass "set_soa_serial_number" as True.
	SetSoaSerialNumber *bool `json:"set_soa_serial_number,omitempty"`

	// The Time to Live (TTL) value of the SOA record of this zone. This value is
	// the number of seconds that data is cached.
	SoaDefaultTtl *uint32 `json:"soa_default_ttl,omitempty"`

	// The SOA email value for this zone. This value can be in unicode format.
	SoaEmail *string `json:"soa_email,omitempty"`

	// This setting defines the amount of time, in seconds, after which the
	// secondary server stops giving out answers about the zone because the zone
	// data is too old to be useful. The default is one week.
	SoaExpire *uint32 `json:"soa_expire,omitempty"`

	// The negative Time to Live (TTL) value of the SOA of the zone indicates how
	// long a secondary server can cache data for "Does Not Respond" responses.
	SoaNegativeTtl *uint32 `json:"soa_negative_ttl,omitempty"`

	// This indicates the interval at which a secondary server sends a message to
	// the primary server for a zone to check that its data is current, and
	// retrieve fresh data if it is not.
	SoaRefresh *uint32 `json:"soa_refresh,omitempty"`

	// This indicates how long a secondary server must wait before attempting to
	// recontact the primary server after a connection failure between the two
	// servers occurs.
	SoaRetry *uint32 `json:"soa_retry,omitempty"`

	// The serial number in the SOA record incrementally changes every time the
	// record is modified. The Infoblox appliance allows you to change the serial
	// number (in the SOA record) for the primary server so it is higher than the
	// secondary server, thereby ensuring zone transfers come from the primary
	// server (as they should). To change the serial number you need to set a new
	// value at "soa_serial_number" and pass "set_soa_serial_number" as True.
	SoaSerialNumber *uint32 `json:"soa_serial_number,omitempty"`

	// The canonical name of redirect target in substitute policy of response
	// policy zone.
	SubstituteName *string `json:"substitute_name,omitempty"`

	// This flag controls whether the zone is using an external primary.
	UseExternalPrimary *bool `json:"use_external_primary,omitempty"`

	// Use flag for: soa_default_ttl , soa_expire, soa_negative_ttl, soa_refresh,
	// soa_retry
	UseGridZoneTimer *bool `json:"use_grid_zone_timer,omitempty"`

	// Use flag for: log_rpz
	UseLogRpz *bool `json:"use_log_rpz,omitempty"`

	// Use flag for: record_name_policy
	UseRecordNamePolicy *bool `json:"use_record_name_policy,omitempty"`

	// Use flag for: rpz_drop_ip_rule_enabled ,
	// rpz_drop_ip_rule_min_prefix_length_ipv4,
	// rpz_drop_ip_rule_min_prefix_length_ipv6
	UseRpzDropIpRule *bool `json:"use_rpz_drop_ip_rule,omitempty"`

	// Use flag for: soa_email
	UseSoaEmail *bool `json:"use_soa_email,omitempty"`

	// The name of the DNS view in which the zone resides. Example "external".
	View *string `json:"view,omitempty"`
}

func (ZoneRp) ObjectType() string {
	return "zone_rp"
}

func (obj ZoneRp) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"fqdn", "view"}
	}
	return obj.returnFields
}

// ZoneStub represents Infoblox object zone_stub.
// A stub zone contains records that identify the authoritative name servers in
// the zone. It does not contain resource records for resolving IP addresses to
// hosts in the zone. Instead, it contains the following records:
type ZoneStub struct {
	IBBase `json:"-"`

	Ref string `json:"_ref,omitempty"`

	// The IP address of the server that is serving this zone.
	Address string `json:"address,omitempty"`

	// Comment for the zone; maximum 256 characters.
	Comment *string `json:"comment,omitempty"`

	// Determines whether a zone is disabled or not. When this is set to False, the
	// zone is enabled.
	Disable *bool `json:"disable,omitempty"`

	// Determines if the name servers that host the zone should not forward queries
	// that end with the domain name of the zone to any configured forwarders.
	DisableForwarding *bool `json:"disable_forwarding,omitempty"`

	// The displayed name of the DNS zone.
	DisplayDomain string `json:"display_domain,omitempty"`

	// The name of this DNS zone in punycode format. For a reverse zone, this is in
	// "address/cidr" format. For other zones, this is in FQDN format in punycode
	// format.
	DnsFqdn string `json:"dns_fqdn,omitempty"`

	// Extensible attributes associated with the object. For valid values for
	// extensible attributes, see {extattrs:values}.
	Ea EA `json:"extattrs"`

	// A forward stub server name server group.
	ExternalNsGroup *string `json:"external_ns_group,omitempty"`

	// The name of this DNS zone. For a reverse zone, this is in "address/cidr"
	// format. For other zones, this is in FQDN format. This value can be in
	// unicode format. Note that for a reverse zone, the corresponding zone_format
	// value should be set.
	Fqdn string `json:"fqdn,omitempty"`

	// If you enable this flag, other administrators cannot make conflicting
	// changes. This is for administration purposes only. The zone will continue to
	// serve DNS data even when it is locked.
	Locked *bool `json:"locked,omitempty"`

	// The name of a superuser or the administrator who locked this zone.
	LockedBy string `json:"locked_by,omitempty"`

	// IPv4 Netmask or IPv6 prefix for this zone.
	MaskPrefix string `json:"mask_prefix,omitempty"`

	// The flag that determines whether Active Directory is integrated or not. This
	// field is valid only when ms_managed is "STUB", "AUTH_PRIMARY", or
	// "AUTH_BOTH".
	MsAdIntegrated *bool `json:"ms_ad_integrated,omitempty"`

	// Determines whether an Active Directory-integrated zone with a Microsoft DNS
	// server as primary allows dynamic updates. Valid values are: "SECURE" if the
	// zone allows secure updates only. "NONE" if the zone forbids dynamic updates.
	// "ANY" if the zone accepts both secure and nonsecure updates. This field is
	// valid only if ms_managed is either "AUTH_PRIMARY" or "AUTH_BOTH". If the
	// flag ms_ad_integrated is false, the value "SECURE" is not allowed.
	MsDdnsMode string `json:"ms_ddns_mode,omitempty"`

	// The flag that indicates whether the zone is assigned to a Microsoft DNS
	// server. This flag returns the authoritative name server type of the
	// Microsoft DNS server. Valid values are: "NONE" if the zone is not assigned
	// to any Microsoft DNS server. "STUB" if the zone is assigned to a Microsoft
	// DNS server as a stub zone. "AUTH_PRIMARY" if only the primary server of the
	// zone is a Microsoft DNS server. "AUTH_SECONDARY" if only the secondary
	// server of the zone is a Microsoft DNS server. "AUTH_BOTH" if both the
	// primary and secondary servers of the zone are Microsoft DNS servers.
	MsManaged string `json:"ms_managed,omitempty"`

	// Determines if a Grid member manages the zone served by a Microsoft DNS
	// server in read-only mode. This flag is true when a Grid member manages the
	// zone in read-only mode, false otherwise. When the zone has the ms_read_only
	// flag set to True, no changes can be made to this zone.
	MsReadOnly bool `json:"ms_read_only,omitempty"`

	// The name of MS synchronization master for this zone.
	MsSyncMasterName string `json:"ms_sync_master_name,omitempty"`

	// A stub member name server group.
	NsGroup *string `json:"ns_group,omitempty"`

	// The parent zone of this zone. Note that when searching for reverse zones,
	// the "in-addr.arpa" notation should be used.
	Parent string `json:"parent,omitempty"`

	// The RFC2317 prefix value of this DNS zone. Use this field only when the
	// netmask is greater than 24 bits; that is, for a mask between 25 and 31 bits.
	// Enter a prefix, such as the name of the allocated address block. The prefix
	// can be alphanumeric characters, such as 128/26 , 128-189 , or sub-B.
	Prefix *string `json:"prefix,omitempty"`

	// The SOA email for the zone. This value can be in unicode format.
	SoaEmail string `json:"soa_email,omitempty"`

	// This setting defines the amount of time, in seconds, after which the
	// secondary server stops giving out answers about the zone because the zone
	// data is too old to be useful.
	SoaExpire uint32 `json:"soa_expire,omitempty"`

	// The SOA mname value for this zone. The Infoblox appliance allows you to
	// change the name of the primary server on the SOA record that is
	// automatically created when you initially configure a zone. Use this method
	// to change the name of the primary server on the SOA record. For example, you
	// may want to hide the primary server for a zone. If your device is named
	// dns1.zone.tld, and for security reasons, you want to show a secondary server
	// called dns2.zone.tld as the primary server. To do so, you would go to
	// dns1.zone.tld zone (being the true primary) and change the primary server on
	// the SOA to dns2.zone.tld to hide the true identity of the real primary
	// server. This value can be in unicode format.
	SoaMname string `json:"soa_mname,omitempty"`

	// The negative Time to Live (TTL) value of the SOA of the zone indicates how
	// long a secondary server can cache data for "Does Not Respond" responses.
	SoaNegativeTtl uint32 `json:"soa_negative_ttl,omitempty"`

	// This indicates the interval at which a secondary server sends a message to
	// the primary server for a zone to check that its data is current, and
	// retrieve fresh data if it is not.
	SoaRefresh uint32 `json:"soa_refresh,omitempty"`

	// This indicates how long a secondary server must wait before attempting to
	// recontact the primary server after a connection failure between the two
	// servers occurs.
	SoaRetry uint32 `json:"soa_retry,omitempty"`

	// The serial number in the SOA record incrementally changes every time the
	// record is modified. The Infoblox appliance allows you to change the serial
	// number (in the SOA record) for the primary server so it is higher than the
	// secondary server, thereby ensuring zone transfers come from the primary
	// server.
	SoaSerialNumber uint32 `json:"soa_serial_number,omitempty"`

	// The primary servers (masters) of this stub zone.
	StubFrom []NameServer `json:"stub_from,omitempty"`

	// The Grid member servers of this stub zone. Note that the
	// lead/stealth/grid_replicate/
	// preferred_primaries/override_preferred_primaries fields of the struct will
	// be ignored when set in this field.
	StubMembers []*Memberserver `json:"stub_members,omitempty"`

	// The Microsoft DNS servers of this stub zone. Note that the stealth field of
	// the struct will be ignored when set in this field.
	StubMsservers []*Msdnsserver `json:"stub_msservers,omitempty"`

	// This is true if the zone is associated with a shared record group.
	UsingSrgAssociations bool `json:"using_srg_associations,omitempty"`

	// The name of the DNS view in which the zone resides. Example "external".
	View *string `json:"view,omitempty"`

	// Determines the format of this zone.
	ZoneFormat string `json:"zone_format,omitempty"`
}

func (ZoneStub) ObjectType() string {
	return "zone_stub"
}

func (obj ZoneStub) ReturnFields() []string {
	if obj.returnFields == nil {
		obj.returnFields = []string{"fqdn", "stub_from", "view"}
	}
	return obj.returnFields
}

// AdAuthServer represents Infoblox struct ad_auth_server
type AdAuthServer struct {
	// The FQDN (Fully Qualified Domain Name) or IP address of the server.
	FqdnOrIp string `json:"fqdn_or_ip,omitempty"`

	// The authentication port.
	AuthPort uint32 `json:"auth_port,omitempty"`

	// The descriptive comment for the AD authentication server.
	Comment string `json:"comment,omitempty"`

	// Determines if the AD authorization server is disabled.
	Disabled bool `json:"disabled,omitempty"`

	// The type of encryption to use.
	Encryption string `json:"encryption,omitempty"`

	// Determine if the MGMT port is enabled for the AD authentication server.
	MgmtPort bool `json:"mgmt_port,omitempty"`

	// Use flag for: mgmt_port
	UseMgmtPort bool `json:"use_mgmt_port,omitempty"`
}

// Addressac represents Infoblox struct addressac
type Addressac struct {
	// The address this rule applies to or "Any".
	Address string `json:"address,omitempty"`

	// The permission to use for this address.
	Permission string `json:"permission,omitempty"`

	// A generated TSIG key. If the external primary server is a NIOS appliance
	// running DNS One 2.x code, this can be set to :2xCOMPAT.
	TsigKey string `json:"tsig_key,omitempty"`

	// The TSIG key algorithm.
	TsigKeyAlg string `json:"tsig_key_alg,omitempty"`

	// The name of the TSIG key. If 2.x TSIG compatibility is used, this is set to
	// 'tsig_xfer' on retrieval, and ignored on insert or update.
	TsigKeyName string `json:"tsig_key_name,omitempty"`

	// Use flag for: tsig_key_name
	UseTsigKeyName bool `json:"use_tsig_key_name,omitempty"`
}

// AdmingroupAdminsetcommands represents Infoblox struct admingroup:adminsetcommands
type AdmingroupAdminsetcommands struct {
	// If True then CLI user has permission to run the command
	SetAdminGroupAcl bool `json:"set_admin_group_acl,omitempty"`

	// If True then CLI user has permission to run the command
	EtBfd bool `json:"et_bfd,omitempty"`

	// If True then CLI user has permission to run the command
	SetBfd bool `json:"set_bfd,omitempty"`

	// If True then CLI user has permission to run the command
	SetBgp bool `json:"set_bgp,omitempty"`

	// If True then CLI user has permission to run the command
	SetBloxtools bool `json:"set_bloxtools,omitempty"`

	// If True then CLI user has permission to run the command
	SetCleanMscache bool `json:"set_clean_mscache,omitempty"`

	// If True then CLI user has permission to run the command
	SetDebug bool `json:"set_debug,omitempty"`

	// If True then CLI user has permission to run the command
	SetDebugAnalytics bool `json:"set_debug_analytics,omitempty"`

	// If True then CLI user has permission to run the command
	SetDeleteTasksInterval bool `json:"set_delete_tasks_interval,omitempty"`

	// If True then CLI user has permission to run the command
	SetDisableGuiOneClickSupport bool `json:"set_disable_gui_one_click_support,omitempty"`

	// If True then CLI user has permission to run the command
	SetHardwareType bool `json:"set_hardware_type,omitempty"`

	// If True then CLI user has permission to run the command
	SetIbtrap bool `json:"set_ibtrap,omitempty"`

	// If True then CLI user has permission to run the command
	SetLcd bool `json:"set_lcd,omitempty"`

	// If True then CLI user has permission to run the command
	SetLcdSettings bool `json:"set_lcd_settings,omitempty"`

	// If True then CLI user has permission to run the command
	SetLines bool `json:"set_lines,omitempty"`

	// If True then CLI user has permission to run the command
	SetMsMaxConnection bool `json:"set_ms_max_connection,omitempty"`

	// If True then CLI user has permission to run the command
	SetNosafemode bool `json:"set_nosafemode,omitempty"`

	// If True then CLI user has permission to run the command
	SetOcsp bool `json:"set_ocsp,omitempty"`

	// If True then CLI user has permission to run the command
	SetPurgeRestartObjects bool `json:"set_purge_restart_objects,omitempty"`

	// If True then CLI user has permission to run the command
	SetReportingUserCapabilities bool `json:"set_reporting_user_capabilities,omitempty"`

	// If True then CLI user has permission to run the command
	SetRpzRecursiveOnly bool `json:"set_rpz_recursive_only,omitempty"`

	// If True then CLI user has permission to run the command
	SetSafemode bool `json:"set_safemode,omitempty"`

	// If True then CLI user has permission to run the command
	SetScheduled bool `json:"set_scheduled,omitempty"`

	// If True then CLI user has permission to run the command
	SetSnmptrap bool `json:"set_snmptrap,omitempty"`

	// If True then CLI user has permission to run the command
	SetSysname bool `json:"set_sysname,omitempty"`

	// If True then CLI user has permission to run the command
	SetTerm bool `json:"set_term,omitempty"`

	// If True then CLI user has permission to run the command
	SetThresholdtrap bool `json:"set_thresholdtrap,omitempty"`

	// If True then CLI user has permission to run the command
	SetExpertmode bool `json:"set_expertmode,omitempty"`

	// If True then CLI user has permission to run the command
	SetMaintenancemode bool `json:"set_maintenancemode,omitempty"`

	// If True then CLI user has permission to run the command
	SetTransferReportingData bool `json:"set_transfer_reporting_data,omitempty"`

	// If True then CLI user has permission to run the command
	SetTransferSupportbundle bool `json:"set_transfer_supportbundle,omitempty"`

	// If True then CLI user has permission to run the command
	SetAnalyticsDatabaseDump bool `json:"set_analytics_database_dump,omitempty"`

	// If True then CLI user has permission to run the command
	SetAnalyticsParameter bool `json:"set_analytics_parameter,omitempty"`

	// If True then CLI user has permission to run the command
	SetCollectOldLogs bool `json:"set_collect_old_logs,omitempty"`

	// If True then CLI user has permission to run the command
	SetCoreFilesQuota bool `json:"set_core_files_quota,omitempty"`

	// If True then CLI user has permission to run the command
	SetHsmGroup bool `json:"set_hsm_group,omitempty"`

	// If True then CLI user has permission to run the command
	SetWred bool `json:"set_wred,omitempty"`

	// If True then CLI user has permission to run the command
	SetEnableDohKeyLogging bool `json:"set_enable_doh_key_logging,omitempty"`

	// If True then CLI user has permission to run the command
	SetEnableDotKeyLogging bool `json:"set_enable_dot_key_logging,omitempty"`

	// If True then CLI user has permission to run the command
	SetHotfix bool `json:"set_hotfix,omitempty"`

	// If True then CLI user has permission to run the command
	SetMgm bool `json:"set_mgm,omitempty"`

	// If True then CLI user has permission to run the command
	SetNtpStratum bool `json:"set_ntp_stratum,omitempty"`

	// If True then CLI user has permission to run the command
	SetPcDomain bool `json:"set_pc_domain,omitempty"`

	// If True then CLI user has permission to run the command
	SetReportFrequency bool `json:"set_report_frequency,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupAdminshowcommands represents Infoblox struct admingroup:adminshowcommands
type AdmingroupAdminshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowAdminGroupAcl bool `json:"show_admin_group_acl,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAnalyticsParameter bool `json:"show_analytics_parameter,omitempty"`

	// If True then CLI user has permission to run the command
	ShowArp bool `json:"show_arp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowBfd bool `json:"show_bfd,omitempty"`

	// If True then CLI user has permission to run the command
	ShowBgp bool `json:"show_bgp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowBloxtools bool `json:"show_bloxtools,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCapacity bool `json:"show_capacity,omitempty"`

	// If True then CLI user has permission to run the command
	ShowClusterdInfo bool `json:"show_clusterd_info,omitempty"`

	// If True then CLI user has permission to run the command
	ShowConfig bool `json:"show_config,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCpu bool `json:"show_cpu,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDate bool `json:"show_date,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDebug bool `json:"show_debug,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDebugAnalytics bool `json:"show_debug_analytics,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDeleteTasksInterval bool `json:"show_delete_tasks_interval,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDisk bool `json:"show_disk,omitempty"`

	// If True then CLI user has permission to run the command
	ShowFile bool `json:"show_file,omitempty"`

	// If True then CLI user has permission to run the command
	ShowHardwareType bool `json:"show_hardware_type,omitempty"`

	// If True then CLI user has permission to run the command
	ShowHardwareStatus bool `json:"show_hardware_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowHwid bool `json:"show_hwid,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIbtrap bool `json:"show_ibtrap,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLcd bool `json:"show_lcd,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLcdInfo bool `json:"show_lcd_info,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLcdSettings bool `json:"show_lcd_settings,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLog bool `json:"show_log,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLogfiles bool `json:"show_logfiles,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMemory bool `json:"show_memory,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNtp bool `json:"show_ntp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowReportingUserCapabilities bool `json:"show_reporting_user_capabilities,omitempty"`

	// If True then CLI user has permission to run the command
	ShowRpzRecursiveOnly bool `json:"show_rpz_recursive_only,omitempty"`

	// If True then CLI user has permission to run the command
	ShowScheduled bool `json:"show_scheduled,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSnmp bool `json:"show_snmp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowStatus bool `json:"show_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTechSupport bool `json:"show_tech_support,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTemperature bool `json:"show_temperature,omitempty"`

	// If True then CLI user has permission to run the command
	ShowThresholdtrap bool `json:"show_thresholdtrap,omitempty"`

	// If True then CLI user has permission to run the command
	ShowUpgradeHistory bool `json:"show_upgrade_history,omitempty"`

	// If True then CLI user has permission to run the command
	ShowUptime bool `json:"show_uptime,omitempty"`

	// If True then CLI user has permission to run the command
	ShowVersion bool `json:"show_version,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAnalyticsDatabaseDumps bool `json:"show_analytics_database_dumps,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCores bool `json:"show_cores,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCoresummary bool `json:"show_coresummary,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCspThreatDb bool `json:"show_csp_threat_db,omitempty"`

	// If True then CLI user has permission to run the command
	ShowHsmGroup bool `json:"show_hsm_group,omitempty"`

	// If True then CLI user has permission to run the command
	ShowHsmInfo bool `json:"show_hsm_info,omitempty"`

	// If True then CLI user has permission to run the command
	ShowPmap bool `json:"show_pmap,omitempty"`

	// If True then CLI user has permission to run the command
	ShowProcess bool `json:"show_process,omitempty"`

	// If True then CLI user has permission to run the command
	ShowPstack bool `json:"show_pstack,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSafenetSupportInfo bool `json:"show_safenet_support_info,omitempty"`

	// If True then CLI user has permission to run the command
	ShowWredStats bool `json:"show_wred_stats,omitempty"`

	// If True then CLI user has permission to run the command
	ShowWredStatus bool `json:"show_wred_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNtpStratum bool `json:"show_ntp_stratum,omitempty"`

	// If True then CLI user has permission to run the command
	ShowPcDomain bool `json:"show_pc_domain,omitempty"`

	// If True then CLI user has permission to run the command
	ShowReportFrequency bool `json:"show_report_frequency,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupAdmintoplevelcommands represents Infoblox struct admingroup:admintoplevelcommands
type AdmingroupAdmintoplevelcommands struct {
	// If True then CLI user has permission to run the command
	Ps bool `json:"ps,omitempty"`

	// If True then CLI user has permission to run the command
	Iostat bool `json:"iostat,omitempty"`

	// If True then CLI user has permission to run the command
	Netstat bool `json:"netstat,omitempty"`

	// If True then CLI user has permission to run the command
	Vmstat bool `json:"vmstat,omitempty"`

	// If True then CLI user has permission to run the command
	Tcpdump bool `json:"tcpdump,omitempty"`

	// If True then CLI user has permission to run the command
	Rndc bool `json:"rndc,omitempty"`

	// If True then CLI user has permission to run the command
	Sar bool `json:"sar,omitempty"`

	// If True then CLI user has permission to run the command
	Resilver bool `json:"resilver,omitempty"`

	// If True then CLI user has permission to run the command
	RestartProduct bool `json:"restart_product,omitempty"`

	// If True then CLI user has permission to run the command
	Scrape bool `json:"scrape,omitempty"`

	// If True then CLI user has permission to run the command
	SamlRestart bool `json:"saml_restart,omitempty"`

	// If True then CLI user has permission to run the command
	Synctime bool `json:"synctime,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupCloudsetcommands represents Infoblox struct admingroup:cloudsetcommands
type AdmingroupCloudsetcommands struct {
	// If True then CLI user has permission to run the command
	SetCloudServicesPortalForceRefresh bool `json:"set_cloud_services_portal_force_refresh,omitempty"`

	// If True then CLI user has permission to run the command
	SetCloudServicesPortal bool `json:"set_cloud_services_portal,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupCloudshowcommands represents Infoblox struct admingroup:cloudshowcommands
type AdmingroupCloudshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowCloudServicesPortal bool `json:"show_cloud_services_portal,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDatabasesetcommands represents Infoblox struct admingroup:databasesetcommands
type AdmingroupDatabasesetcommands struct {
	// If True then CLI user has permission to run the command
	SetNamedMaxJournalSize bool `json:"set_named_max_journal_size,omitempty"`

	// If True then CLI user has permission to run the command
	SetTxnTrace bool `json:"set_txn_trace,omitempty"`

	// If True then CLI user has permission to run the command
	SetDatabaseTransfer bool `json:"set_database_transfer,omitempty"`

	// If True then CLI user has permission to run the command
	SetDbRollover bool `json:"set_db_rollover,omitempty"`

	// If True then CLI user has permission to run the command
	SetDbSnapshot bool `json:"set_db_snapshot,omitempty"`

	// If True then CLI user has permission to run the command
	SetDbsize bool `json:"set_dbsize,omitempty"`

	// If True then CLI user has permission to run the command
	SetDebugTools bool `json:"set_debug_tools,omitempty"`

	// If True then CLI user has permission to run the command
	SetCircTxnTrace bool `json:"set_circ_txn_trace,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDatabaseshowcommands represents Infoblox struct admingroup:databaseshowcommands
type AdmingroupDatabaseshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowNamedMaxJournalSize bool `json:"show_named_max_journal_size,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTxnTrace bool `json:"show_txn_trace,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDatabaseTransferStatus bool `json:"show_database_transfer_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowBackup bool `json:"show_backup,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDbPh bool `json:"show_db_ph,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDbsize bool `json:"show_dbsize,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIbdbstat bool `json:"show_ibdbstat,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDhcpsetcommands represents Infoblox struct admingroup:dhcpsetcommands
type AdmingroupDhcpsetcommands struct {
	// If True then CLI user has permission to run the command
	SetDhcpdRecvSockBufSize bool `json:"set_dhcpd_recv_sock_buf_size,omitempty"`

	// If True then CLI user has permission to run the command
	SetLogTxnId bool `json:"set_log_txn_id,omitempty"`

	// If True then CLI user has permission to run the command
	SetOverloadBootp bool `json:"set_overload_bootp,omitempty"`

	// If True then CLI user has permission to run the command
	SetRegenerateDhcpUpdaterKeys bool `json:"set_regenerate_dhcp_updater_keys,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDhcpshowcommands represents Infoblox struct admingroup:dhcpshowcommands
type AdmingroupDhcpshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowDhcpGssTsig bool `json:"show_dhcp_gss_tsig,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDhcpv6GssTsig bool `json:"show_dhcpv6_gss_tsig,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDhcpdRecvSockBufSize bool `json:"show_dhcpd_recv_sock_buf_size,omitempty"`

	// If True then CLI user has permission to run the command
	ShowOverloadBootp bool `json:"show_overload_bootp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLogTxnId bool `json:"show_log_txn_id,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDnssetcommands represents Infoblox struct admingroup:dnssetcommands
type AdmingroupDnssetcommands struct {
	// If True then CLI user has permission to run the command
	SetDns bool `json:"set_dns,omitempty"`

	// If True then CLI user has permission to run the command
	SetDnsRrl bool `json:"set_dns_rrl,omitempty"`

	// If True then CLI user has permission to run the command
	SetEnableDnstap bool `json:"set_enable_dnstap,omitempty"`

	// If True then CLI user has permission to run the command
	SetEnableMatchRecursiveOnly bool `json:"set_enable_match_recursive_only,omitempty"`

	// If True then CLI user has permission to run the command
	SetExtraDnsNameValidations bool `json:"set_extra_dns_name_validations,omitempty"`

	// If True then CLI user has permission to run the command
	SetLogGuestLookups bool `json:"set_log_guest_lookups,omitempty"`

	// If True then CLI user has permission to run the command
	SetMaxRecursionDepth bool `json:"set_max_recursion_depth,omitempty"`

	// If True then CLI user has permission to run the command
	SetMaxRecursionQueries bool `json:"set_max_recursion_queries,omitempty"`

	// If True then CLI user has permission to run the command
	SetMonitor bool `json:"set_monitor,omitempty"`

	// If True then CLI user has permission to run the command
	SetMsDnsReportsSyncInterval bool `json:"set_ms_dns_reports_sync_interval,omitempty"`

	// If True then CLI user has permission to run the command
	SetMsStickyIp bool `json:"set_ms_sticky_ip,omitempty"`

	// If True then CLI user has permission to run the command
	SetRestartAnycastWithDnsRestart bool `json:"set_restart_anycast_with_dns_restart,omitempty"`

	// If True then CLI user has permission to run the command
	SetDnsAccel bool `json:"set_dns_accel,omitempty"`

	// If True then CLI user has permission to run the command
	SetDnsAccelDebug bool `json:"set_dns_accel_debug,omitempty"`

	// If True then CLI user has permission to run the command
	SetDnsAutoGen bool `json:"set_dns_auto_gen,omitempty"`

	// If True then CLI user has permission to run the command
	SetAllowQueryDomain bool `json:"set_allow_query_domain,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDnsshowcommands represents Infoblox struct admingroup:dnsshowcommands
type AdmingroupDnsshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowLogGuestLookups bool `json:"show_log_guest_lookups,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsGssTsig bool `json:"show_dns_gss_tsig,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDns bool `json:"show_dns,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnstapStats bool `json:"show_dnstap_stats,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnstapStatus bool `json:"show_dnstap_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsOverTlsConfig bool `json:"show_dns_over_tls_config,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsOverTlsStatus bool `json:"show_dns_over_tls_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsOverTlsStats bool `json:"show_dns_over_tls_stats,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDohConfig bool `json:"show_doh_config,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDohStatus bool `json:"show_doh_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDohStats bool `json:"show_doh_stats,omitempty"`

	// If True then CLI user has permission to run the command
	ShowExtraDnsNameValidations bool `json:"show_extra_dns_name_validations,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMsStickyIp bool `json:"show_ms_sticky_ip,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsRrl bool `json:"show_dns_rrl,omitempty"`

	// If True then CLI user has permission to run the command
	ShowEnableMatchRecursiveOnly bool `json:"show_enable_match_recursive_only,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMaxRecursionDepth bool `json:"show_max_recursion_depth,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMaxRecursionQueries bool `json:"show_max_recursion_queries,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMonitor bool `json:"show_monitor,omitempty"`

	// If True then CLI user has permission to run the command
	ShowQueryCapture bool `json:"show_query_capture,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDtcEa bool `json:"show_dtc_ea,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDtcGeoip bool `json:"show_dtc_geoip,omitempty"`

	// If True then CLI user has permission to run the command
	ShowRestartAnycastWithDnsRestart bool `json:"show_restart_anycast_with_dns_restart,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsAccel bool `json:"show_dns_accel,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDnsAccelDebug bool `json:"show_dns_accel_debug,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAllowQueryDomain bool `json:"show_allow_query_domain,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAllowQueryDomainViews bool `json:"show_allow_query_domain_views,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDnstoplevelcommands represents Infoblox struct admingroup:dnstoplevelcommands
type AdmingroupDnstoplevelcommands struct {
	// If True then CLI user has permission to run the command
	DdnsAdd bool `json:"ddns_add,omitempty"`

	// If True then CLI user has permission to run the command
	DdnsDelete bool `json:"ddns_delete,omitempty"`

	// If True then CLI user has permission to run the command
	Delete bool `json:"delete,omitempty"`

	// If True then CLI user has permission to run the command
	DnsARecordDelete bool `json:"dns_a_record_delete,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDockersetcommands represents Infoblox struct admingroup:dockersetcommands
type AdmingroupDockersetcommands struct {
	// If True then CLI user has permission to run the command
	SetDockerBridge bool `json:"set_docker_bridge,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupDockershowcommands represents Infoblox struct admingroup:dockershowcommands
type AdmingroupDockershowcommands struct {
	// If True then CLI user has permission to run the command
	ShowDockerBridge bool `json:"show_docker_bridge,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupGridsetcommands represents Infoblox struct admingroup:gridsetcommands
type AdmingroupGridsetcommands struct {
	// If True then CLI user has permission to run the command
	SetDefaultRevertWindow bool `json:"set_default_revert_window,omitempty"`

	// If True then CLI user has permission to run the command
	SetDscp bool `json:"set_dscp,omitempty"`

	// If True then CLI user has permission to run the command
	SetMembership bool `json:"set_membership,omitempty"`

	// If True then CLI user has permission to run the command
	SetNogrid bool `json:"set_nogrid,omitempty"`

	// If True then CLI user has permission to run the command
	SetNomastergrid bool `json:"set_nomastergrid,omitempty"`

	// If True then CLI user has permission to run the command
	SetPromoteMaster bool `json:"set_promote_master,omitempty"`

	// If True then CLI user has permission to run the command
	SetRevertGrid bool `json:"set_revert_grid,omitempty"`

	// If True then CLI user has permission to run the command
	SetToken bool `json:"set_token,omitempty"`

	// If True then CLI user has permission to run the command
	SetTestPromoteMaster bool `json:"set_test_promote_master,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupGridshowcommands represents Infoblox struct admingroup:gridshowcommands
type AdmingroupGridshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowTestPromoteMaster bool `json:"show_test_promote_master,omitempty"`

	// If True then CLI user has permission to run the command
	ShowToken bool `json:"show_token,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDscp bool `json:"show_dscp,omitempty"`
}

// AdmingroupLicensingsetcommands represents Infoblox struct admingroup:licensingsetcommands
type AdmingroupLicensingsetcommands struct {
	// If True then CLI user has permission to run the command
	SetLicense bool `json:"set_license,omitempty"`

	// If True then CLI user has permission to run the command
	SetReportingResetLicense bool `json:"set_reporting_reset_license,omitempty"`

	// If True then CLI user has permission to run the command
	SetTempLicense bool `json:"set_temp_license,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupLicensingshowcommands represents Infoblox struct admingroup:licensingshowcommands
type AdmingroupLicensingshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowLicense bool `json:"show_license,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLicensePoolContainer bool `json:"show_license_pool_container,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLicenseUid bool `json:"show_license_uid,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupLockoutsetting represents Infoblox struct admingroup:lockoutsetting
type AdmingroupLockoutsetting struct {
	// Enable/disable sequential failed login attempts lockout for local users
	EnableSequentialFailedLoginAttemptsLockout bool `json:"enable_sequential_failed_login_attempts_lockout,omitempty"`

	// The number of failed login attempts
	SequentialAttempts uint32 `json:"sequential_attempts,omitempty"`

	// Time period the account remains locked after sequential failed login attempt
	// lockout.
	FailedLockoutDuration uint32 `json:"failed_lockout_duration,omitempty"`

	// Never unlock option is also provided and if set then user account is locked
	// forever and only super user can unlock this account
	NeverUnlockUser bool `json:"never_unlock_user,omitempty"`
}

// AdmingroupMachinecontroltoplevelcommands represents Infoblox struct admingroup:machinecontroltoplevelcommands
type AdmingroupMachinecontroltoplevelcommands struct {
	// If True then CLI user has permission to run the command
	Reboot bool `json:"reboot,omitempty"`

	// If True then CLI user has permission to run the command
	Reset bool `json:"reset,omitempty"`

	// If True then CLI user has permission to run the command
	Shutdown bool `json:"shutdown,omitempty"`

	// If True then CLI user has permission to run the command
	Restart bool `json:"restart,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupNetworkingsetcommands represents Infoblox struct admingroup:networkingsetcommands
type AdmingroupNetworkingsetcommands struct {
	// If True then CLI user has permission to run the command
	SetConnectionLimit bool `json:"set_connection_limit,omitempty"`

	// If True then CLI user has permission to run the command
	SetDefaultRoute bool `json:"set_default_route,omitempty"`

	// If True then CLI user has permission to run the command
	SetInterface bool `json:"set_interface,omitempty"`

	// If True then CLI user has permission to run the command
	SetIpRateLimit bool `json:"set_ip_rate_limit,omitempty"`

	// If True then CLI user has permission to run the command
	SetIpv6DisableOnDad bool `json:"set_ipv6_disable_on_dad,omitempty"`

	// If True then CLI user has permission to run the command
	SetIpv6Neighbor bool `json:"set_ipv6_neighbor,omitempty"`

	// If True then CLI user has permission to run the command
	SetIpv6Ospf bool `json:"set_ipv6_ospf,omitempty"`

	// If True then CLI user has permission to run the command
	SetIpv6Status bool `json:"set_ipv6_status,omitempty"`

	// If True then CLI user has permission to run the command
	SetLom bool `json:"set_lom,omitempty"`

	// If True then CLI user has permission to run the command
	SetMldVersion1 bool `json:"set_mld_version_1,omitempty"`

	// If True then CLI user has permission to run the command
	SetNamedRecvSockBufSize bool `json:"set_named_recv_sock_buf_size,omitempty"`

	// If True then CLI user has permission to run the command
	SetNamedTcpClientsLimit bool `json:"set_named_tcp_clients_limit,omitempty"`

	// If True then CLI user has permission to run the command
	SetNetwork bool `json:"set_network,omitempty"`

	// If True then CLI user has permission to run the command
	SetOspf bool `json:"set_ospf,omitempty"`

	// If True then CLI user has permission to run the command
	SetPrompt bool `json:"set_prompt,omitempty"`

	// If True then CLI user has permission to run the command
	SetRemoteConsole bool `json:"set_remote_console,omitempty"`

	// If True then CLI user has permission to run the command
	SetStaticRoute bool `json:"set_static_route,omitempty"`

	// If True then CLI user has permission to run the command
	SetTcpTimestamps bool `json:"set_tcp_timestamps,omitempty"`

	// If True then CLI user has permission to run the command
	SetTrafficCapture bool `json:"set_traffic_capture,omitempty"`

	// If True then CLI user has permission to run the command
	SetWinsForwarding bool `json:"set_wins_forwarding,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupNetworkingshowcommands represents Infoblox struct admingroup:networkingshowcommands
type AdmingroupNetworkingshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowConnectionLimit bool `json:"show_connection_limit,omitempty"`

	// If True then CLI user has permission to run the command
	ShowConnections bool `json:"show_connections,omitempty"`

	// If True then CLI user has permission to run the command
	ShowInterface bool `json:"show_interface,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIpRateLimit bool `json:"show_ip_rate_limit,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIpv6Bgp bool `json:"show_ipv6_bgp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIpv6DisableOnDad bool `json:"show_ipv6_disable_on_dad,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIpv6Neighbor bool `json:"show_ipv6_neighbor,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIpv6Ospf bool `json:"show_ipv6_ospf,omitempty"`

	// If True then CLI user has permission to run the command
	ShowLom bool `json:"show_lom,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMldVersion bool `json:"show_mld_version,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNamedRecvSockBufSize bool `json:"show_named_recv_sock_buf_size,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNamedTcpClientsLimit bool `json:"show_named_tcp_clients_limit,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNetwork bool `json:"show_network,omitempty"`

	// If True then CLI user has permission to run the command
	ShowOspf bool `json:"show_ospf,omitempty"`

	// If True then CLI user has permission to run the command
	ShowRemoteConsole bool `json:"show_remote_console,omitempty"`

	// If True then CLI user has permission to run the command
	ShowRoutes bool `json:"show_routes,omitempty"`

	// If True then CLI user has permission to run the command
	ShowStaticRoutes bool `json:"show_static_routes,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTcpTimestamps bool `json:"show_tcp_timestamps,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTrafficCaptureStatus bool `json:"show_traffic_capture_status,omitempty"`

	// If True then CLI user has permission to run the command
	ShowWinsForwarding bool `json:"show_wins_forwarding,omitempty"`

	// If True then CLI user has permission to run the command
	ShowDefaultRoute bool `json:"show_default_route,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIproute bool `json:"show_iproute,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIprule bool `json:"show_iprule,omitempty"`

	// If True then CLI user has permission to run the command
	ShowIptables bool `json:"show_iptables,omitempty"`

	// If True then CLI user has permission to run the command
	ShowMtuSize bool `json:"show_mtu_size,omitempty"`

	// If True then CLI user has permission to run the command
	ShowNetworkConnectivity bool `json:"show_network_connectivity,omitempty"`

	// If True then CLI user has permission to run the command
	ShowTrafficfiles bool `json:"show_trafficfiles,omitempty"`

	// If True then CLI user has permission to run the command
	ShowInterfaceStats bool `json:"show_interface_stats,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupPasswordsetting represents Infoblox struct admingroup:passwordsetting
type AdmingroupPasswordsetting struct {
	// Whether password expiry enabled or not.
	ExpireEnable bool `json:"expire_enable,omitempty"`

	// The days that password must expire
	ExpireDays uint32 `json:"expire_days,omitempty"`

	// Days to show up reminder prior to expiration
	ReminderDays uint32 `json:"reminder_days,omitempty"`
}

// AdmingroupSamlsetting represents Infoblox struct admingroup:samlsetting
type AdmingroupSamlsetting struct {
	// Whether or not auto create user.
	AutoCreateUser bool `json:"auto_create_user,omitempty"`

	// Whether or not persist auto created user after logout.
	PersistAutoCreatedUser bool `json:"persist_auto_created_user,omitempty"`
}

// AdmingroupSecuritysetcommands represents Infoblox struct admingroup:securitysetcommands
type AdmingroupSecuritysetcommands struct {
	// If True then CLI user has permission to run the command
	SetAdp bool `json:"set_adp,omitempty"`

	// If True then CLI user has permission to run the command
	SetApacheHttpsCert bool `json:"set_apache_https_cert,omitempty"`

	// If True then CLI user has permission to run the command
	SetCcMode bool `json:"set_cc_mode,omitempty"`

	// If True then CLI user has permission to run the command
	SetCertificateAuthAdmins bool `json:"set_certificate_auth_admins,omitempty"`

	// If True then CLI user has permission to run the command
	SetCertificateAuthServices bool `json:"set_certificate_auth_services,omitempty"`

	// If True then CLI user has permission to run the command
	SetCheckAuthNs bool `json:"set_check_auth_ns,omitempty"`

	// If True then CLI user has permission to run the command
	SetCheckSslCertificate bool `json:"set_check_ssl_certificate,omitempty"`

	// If True then CLI user has permission to run the command
	SetDisableHttpsCertRegeneration bool `json:"set_disable_https_cert_regeneration,omitempty"`

	// If True then CLI user has permission to run the command
	SetFipsMode bool `json:"set_fips_mode,omitempty"`

	// If True then CLI user has permission to run the command
	SetReportingCert bool `json:"set_reporting_cert,omitempty"`

	// If True then CLI user has permission to run the command
	SetSecurity bool `json:"set_security,omitempty"`

	// If True then CLI user has permission to run the command
	SetSessionTimeout bool `json:"set_session_timeout,omitempty"`

	// If True then CLI user has permission to run the command
	SetSubscriberSecureData bool `json:"set_subscriber_secure_data,omitempty"`

	// If True then CLI user has permission to run the command
	SetSupportAccess bool `json:"set_support_access,omitempty"`

	// If True then CLI user has permission to run the command
	SetSupportInstall bool `json:"set_support_install,omitempty"`

	// If True then CLI user has permission to run the command
	SetAdpDebug bool `json:"set_adp_debug,omitempty"`

	// If True then CLI user has permission to run the command
	SetSupportTimeout bool `json:"set_support_timeout,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupSecurityshowcommands represents Infoblox struct admingroup:securityshowcommands
type AdmingroupSecurityshowcommands struct {
	// If True then CLI user has permission to run the command
	ShowFipsMode bool `json:"show_fips_mode,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCcMode bool `json:"show_cc_mode,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCertificateAuthAdmins bool `json:"show_certificate_auth_admins,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCertificateAuthServices bool `json:"show_certificate_auth_services,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCheckAuthNs bool `json:"show_check_auth_ns,omitempty"`

	// If True then CLI user has permission to run the command
	ShowCheckSslCertificate bool `json:"show_check_ssl_certificate,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSecurity bool `json:"show_security,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSessionTimeout bool `json:"show_session_timeout,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSubscriberSecureData bool `json:"show_subscriber_secure_data,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSupportAccess bool `json:"show_support_access,omitempty"`

	// If True then CLI user has permission to run the command
	ShowVpnCertDates bool `json:"show_vpn_cert_dates,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAdp bool `json:"show_adp,omitempty"`

	// If True then CLI user has permission to run the command
	ShowAdpDebug bool `json:"show_adp_debug,omitempty"`

	// If True then CLI user has permission to run the command
	ShowSupportTimeout bool `json:"show_support_timeout,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// AdmingroupTroubleshootingtoplevelcommands represents Infoblox struct admingroup:troubleshootingtoplevelcommands
type AdmingroupTroubleshootingtoplevelcommands struct {
	// If True then CLI user has permission to run the command
	Ping bool `json:"ping,omitempty"`

	// If True then CLI user has permission to run the command
	Ping6 bool `json:"ping6,omitempty"`

	// If True then CLI user has permission to run the command
	Strace bool `json:"strace,omitempty"`

	// If True then CLI user has permission to run the command
	Traceroute bool `json:"traceroute,omitempty"`

	// If True then CLI user has permission to run the command
	TrafficCapture bool `json:"traffic_capture,omitempty"`

	// If True then CLI user has permission to run the command
	Dig bool `json:"dig,omitempty"`

	// If True then CLI user has permission to run the command
	Rotate bool `json:"rotate,omitempty"`

	// If True then CLI user has permission to run the command
	Snmpwalk bool `json:"snmpwalk,omitempty"`

	// If True then CLI user has permission to run the command
	Snmpget bool `json:"snmpget,omitempty"`

	// If True then CLI user has permission to run the command
	Console bool `json:"console,omitempty"`

	// If True then CLI user has permission to run the command
	Tracepath bool `json:"tracepath,omitempty"`

	// If True then enable all fields
	EnableAll bool `json:"enable_all,omitempty"`

	// If True then disable all fields
	DisableAll bool `json:"disable_all,omitempty"`
}

// Adsites represents Infoblox struct adsites
type Adsites struct {
	// Flag to override MS Server default IP site link
	UseDefaultIpSiteLink bool `json:"use_default_ip_site_link,omitempty"`

	// Default IP site link for sites created from NIOS
	DefaultIpSiteLink string `json:"default_ip_site_link,omitempty"`

	// Flag to override login name and password from the MS Server
	UseLogin bool `json:"use_login,omitempty"`

	// Microsoft Server login name, with optional
	LoginName string `json:"login_name,omitempty"`

	// Microsoft Server login password.
	LoginPassword string `json:"login_password,omitempty"`

	// Flag to override synchronization interval from the MS Server
	UseSynchronizationMinDelay bool `json:"use_synchronization_min_delay,omitempty"`

	// Minimum number of minutes between two synchronizations
	SynchronizationMinDelay uint32 `json:"synchronization_min_delay,omitempty"`

	// Flag to override cluster LDAP timeoutMS Server
	UseLdapTimeout bool `json:"use_ldap_timeout,omitempty"`

	// Timeout in seconds for LDAP connections for this MS Server
	LdapTimeout uint32 `json:"ldap_timeout,omitempty"`

	// TCP port for LDAP connections for this
	LdapAuthPort uint32 `json:"ldap_auth_port,omitempty"`

	// Encryption for LDAP connections for this MS Server
	LdapEncryption string `json:"ldap_encryption,omitempty"`

	// Controls whether the Sites of this MS Server are to be synchronized by the
	// assigned managing member or not
	Managed bool `json:"managed,omitempty"`

	// Enable/disable read-only synchronization of Sites for this Active Directory
	// domain
	ReadOnly bool `json:"read_only,omitempty"`

	// Timestamp of the last synchronization attempt
	LastSyncTs *UnixTime `json:"last_sync_ts,omitempty"`

	// Status of the last synchronization attempt
	LastSyncStatus string `json:"last_sync_status,omitempty"`

	// The detailed status of the last synchronization attempt.
	LastSyncDetail string `json:"last_sync_detail,omitempty"`

	// Flag indicating if the server supports IPv6
	SupportsIpv6 bool `json:"supports_ipv6,omitempty"`
}

// Awsrte53recordinfo represents Infoblox struct awsrte53recordinfo
type Awsrte53recordinfo struct {
	// DNS name of the alias target.
	AliasTargetDnsName string `json:"alias_target_dns_name,omitempty"`

	// Hosted zone ID of the alias target.
	AliasTargetHostedZoneId string `json:"alias_target_hosted_zone_id,omitempty"`

	// Indicates if Amazon Route 53 evaluates the health of the alias target.
	AliasTargetEvaluateTargetHealth bool `json:"alias_target_evaluate_target_health,omitempty"`

	// Indicates whether this is the primary or secondary resource record for
	// Amazon Route 53 failover routing.
	Failover string `json:"failover,omitempty"`

	// Continent code for Amazon Route 53 geolocation routing.
	GeolocationContinentCode string `json:"geolocation_continent_code,omitempty"`

	// Country code for Amazon Route 53 geolocation routing.
	GeolocationCountryCode string `json:"geolocation_country_code,omitempty"`

	// Subdivision code for Amazon Route 53 geolocation routing.
	GeolocationSubdivisionCode string `json:"geolocation_subdivision_code,omitempty"`

	// ID of the health check that Amazon Route 53 performs for this resource
	// record.
	HealthCheckId string `json:"health_check_id,omitempty"`

	// Amazon EC2 region where this resource record resides for latency routing.
	Region string `json:"region,omitempty"`

	// An identifier that differentiates records with the same DNS name and type
	// for weighted, latency, geolocation, and failover routing.
	SetIdentifier string `json:"set_identifier,omitempty"`

	// Type of Amazon Route 53 resource record.
	Type string `json:"type,omitempty"`

	// Value that determines the portion of traffic for this record in weighted
	// routing. The range is from 0 to 255.
	Weight uint32 `json:"weight,omitempty"`
}

// Awsrte53task represents Infoblox struct awsrte53task
type Awsrte53task struct {
	// The name of this task.
	Name string `json:"name,omitempty"`

	// Indicates if the task is enabled or disabled.
	Disabled bool `json:"disabled,omitempty"`

	// Indicate the sync status of this task.
	State string `json:"state,omitempty"`

	// State message for the task.
	StateMsg string `json:"state_msg,omitempty"`

	// Filter for this task.
	Filter string `json:"filter,omitempty"`

	// Periodic interval for this task.
	ScheduleInterval uint32 `json:"schedule_interval,omitempty"`

	// Units for the schedule interval.
	ScheduleUnits string `json:"schedule_units,omitempty"`

	// Reference to associated AWS user whose credentials are to be used for this
	// task.
	AwsUser string `json:"aws_user,omitempty"`

	// The timestamp when the last state was logged.
	StatusTimestamp *UnixTime `json:"status_timestamp,omitempty"`

	// The timestamp when the task was started last.
	LastRun *UnixTime `json:"last_run,omitempty"`

	// Indicates whether public zones are synchronized.
	SyncPublicZones bool `json:"sync_public_zones,omitempty"`

	// Indicates whether private zones are synchronized.
	SyncPrivateZones bool `json:"sync_private_zones,omitempty"`

	// The number of zones synchronized by this task.
	ZoneCount uint32 `json:"zone_count,omitempty"`

	// Credentials type used for connecting to the cloud management platform.
	CredentialsType string `json:"credentials_type,omitempty"`
}

// Awsrte53zoneinfo represents Infoblox struct awsrte53zoneinfo
type Awsrte53zoneinfo struct {
	// List of AWS VPC strings that are associated with this zone.
	AssociatedVpcs []string `json:"associated_vpcs,omitempty"`

	// User specified caller reference when zone was created.
	CallerReference string `json:"caller_reference,omitempty"`

	// ID of delegation set associated with this zone.
	DelegationSetId string `json:"delegation_set_id,omitempty"`

	// AWS route 53 assigned ID for this zone.
	HostedZoneId string `json:"hosted_zone_id,omitempty"`

	// List of AWS name servers that are authoritative for this domain name.
	NameServers []string `json:"name_servers,omitempty"`

	// Number of resource record sets in the hosted zone.
	RecordSetCount uint32 `json:"record_set_count,omitempty"`

	// Indicates whether private or public zone.
	Type string `json:"type,omitempty"`
}

// Bgpas represents Infoblox struct bgpas
type Bgpas struct {
	// The number of this autonomous system.
	As uint32 `json:"as,omitempty"`

	// The AS keepalive timer (in seconds). The valid value is from 1 to 21845.
	Keepalive uint32 `json:"keepalive,omitempty"`

	// The AS holddown timer (in seconds). The valid value is from 3 to 65535.
	Holddown uint32 `json:"holddown,omitempty"`

	// The BGP neighbors for this AS.
	Neighbors []*Bgpneighbor `json:"neighbors,omitempty"`

	// Determines if link detection on the interface is enabled or not.
	LinkDetect bool `json:"link_detect,omitempty"`
}

// Bgpneighbor represents Infoblox struct bgpneighbor
type Bgpneighbor struct {
	// The interface that sends BGP advertisement information.
	Interface string `json:"interface,omitempty"`

	// The IP address of the BGP neighbor.
	NeighborIp string `json:"neighbor_ip,omitempty"`

	// The remote AS number of the BGP neighbor.
	RemoteAs uint32 `json:"remote_as,omitempty"`

	// The BGP authentication mode.
	AuthenticationMode string `json:"authentication_mode,omitempty"`

	// The password for a BGP neighbor. This is required only if
	// authentication_mode is set to "MD5". When the password is entered, the value
	// is preserved even if authentication_mode is changed to "NONE". This is a
	// write-only attribute.
	BgpNeighborPass string `json:"bgp_neighbor_pass,omitempty"`

	// User comments for this BGP neighbor.
	Comment string `json:"comment,omitempty"`

	// Determines if the multi-hop support is enabled or not.
	Multihop bool `json:"multihop,omitempty"`

	// The Time To Live (TTL) value for multi-hop. Valid values are between 1 and
	// 255.
	MultihopTtl uint32 `json:"multihop_ttl,omitempty"`

	// The BFD template name.
	BfdTemplate string `json:"bfd_template,omitempty"`

	// Determines if BFD is enabled or not.
	EnableBfd bool `json:"enable_bfd,omitempty"`
}

// CapacityreportObjectcount represents Infoblox struct capacityreport:objectcount
type CapacityreportObjectcount struct {
	// Object type name.
	TypeName string `json:"type_name,omitempty"`

	// Number of object type instances created.
	Count uint32 `json:"count,omitempty"`
}

// CaptiveportalFile represents Infoblox struct captiveportal:file
type CaptiveportalFile struct {
	// The name of the uploaded file.
	Name string `json:"name,omitempty"`

	// The type of the uploaded file.
	Type string `json:"type,omitempty"`
}

// Changedobject represents Infoblox struct changedobject
type Changedobject struct {
	// This is a description of the action that is applied to this object.
	Action string `json:"action,omitempty"`

	// The object name.
	Name string `json:"name,omitempty"`

	// A value of the object type, this may contain objects that are not yet
	// available in WAPI.
	Type string `json:"type,omitempty"`

	// The object type. This is undefined if the object is not yet supported.
	ObjectType string `json:"object_type,omitempty"`

	// A list of properties that are being changed.
	Properties []string `json:"properties,omitempty"`
}

// CiscoiseEaassociation represents Infoblox struct ciscoise:eaassociation
type CiscoiseEaassociation struct {
	// The Cisco ISE attribute name that is enabled for publishsing from a Cisco
	// ISE endpoint.
	Name string `json:"name,omitempty"`

	// The name of the extensible attribute definition object the Cisco ISE
	// attribute that is enabled for subscription is mapped on.
	MappedEa string `json:"mapped_ea,omitempty"`
}

// CiscoisePublishsetting represents Infoblox struct ciscoise:publishsetting
type CiscoisePublishsetting struct {
	// The list of NIOS extensible attributes enalbed for publishsing to Cisco ISE
	// endpoint.
	EnabledAttributes []string `json:"enabled_attributes,omitempty"`
}

// CiscoiseSubscribesetting represents Infoblox struct ciscoise:subscribesetting
type CiscoiseSubscribesetting struct {
	// The list of Cisco ISE attributes allowed for subscription.
	EnabledAttributes []string `json:"enabled_attributes,omitempty"`

	// The list of NIOS extensible attributes to Cisco ISE attributes mappings.
	MappedEaAttributes []*CiscoiseEaassociation `json:"mapped_ea_attributes,omitempty"`
}

// Clientsubnetdomain represents Infoblox struct clientsubnetdomain
type Clientsubnetdomain struct {
	// The FQDN that represents the ECS zone domain name.
	Domain string `json:"domain,omitempty"`

	// The ECS domain name permission.
	Permission string `json:"permission,omitempty"`
}

// Dhcpddns represents Infoblox struct dhcpddns
type Dhcpddns struct {
	// Indicate matching type.
	ZoneMatch string `json:"zone_match,omitempty"`

	// The ref of a DNS zone.
	DnsGridZone string `json:"dns_grid_zone,omitempty"`

	// The name of a Grid member.
	DnsGridPrimary string `json:"dns_grid_primary,omitempty"`

	// The name of external zone in FQDN format.
	DnsExtZone string `json:"dns_ext_zone,omitempty"`

	// The IP address of the External server. Valid when zone_match is "EXTERNAL"
	// or "ANY_EXTERNAL".
	DnsExtPrimary string `json:"dns_ext_primary,omitempty"`
}

// Dhcpmember represents Infoblox struct dhcpmember
type Dhcpmember struct {
	// The IPv4 Address of the Grid Member.
	Ipv4Addr string `json:"ipv4addr,omitempty"`

	// The IPv6 Address of the Grid Member.
	Ipv6Addr string `json:"ipv6addr,omitempty"`

	// The Grid member name
	Name string `json:"name,omitempty"`
}

// Dhcpoption represents Infoblox struct dhcpoption
type Dhcpoption struct {
	// Name of the DHCP option.
	Name string `json:"name,omitempty"`

	// The code of the DHCP option.
	Num uint32 `json:"num,omitempty"`

	// The name of the space this DHCP option is associated to.
	VendorClass string `json:"vendor_class,omitempty"`

	// Value of the DHCP option
	Value string `json:"value,omitempty"`

	// Only applies to special options that are displayed separately from other
	// options and have a use flag. These options are: * routers * router-templates
	// * domain-name-servers * domain-name * broadcast-address *
	// broadcast-address-offset * dhcp-lease-time * dhcp6.name-servers
	UseOption bool `json:"use_option,omitempty"`
}

// Dhcpserver represents Infoblox struct dhcpserver
type Dhcpserver struct {
	// Flag to override login name and password from the MS Server
	UseLogin bool `json:"use_login,omitempty"`

	// Microsoft Server login name
	LoginName string `json:"login_name,omitempty"`

	// Microsoft Server login password
	LoginPassword string `json:"login_password,omitempty"`

	// flag indicating if the DNS service is managed
	Managed bool `json:"managed,omitempty"`

	// Defines what control to apply on the DNS server
	NextSyncControl string `json:"next_sync_control,omitempty"`

	// Status of the Microsoft DNS Service
	Status string `json:"status,omitempty"`

	// Timestamp of the last update
	StatusLastUpdated *UnixTime `json:"status_last_updated,omitempty"`

	// Override enable monitoring inherited from grid level
	UseEnableMonitoring bool `json:"use_enable_monitoring,omitempty"`

	// Flag indicating if the DNS service is monitored and controlled
	EnableMonitoring bool `json:"enable_monitoring,omitempty"`

	// Override setting for Enable Invalid Mac Address
	UseEnableInvalidMac bool `json:"use_enable_invalid_mac,omitempty"`

	// Enable Invalid Mac Address
	EnableInvalidMac bool `json:"enable_invalid_mac,omitempty"`

	// Flag indicating if the DHCP supports Failover
	SupportsFailover bool `json:"supports_failover,omitempty"`

	// Flag to override synchronization interval from the MS Server
	UseSynchronizationMinDelay bool `json:"use_synchronization_min_delay,omitempty"`

	// Minimum number of minutes between two synchronizations
	SynchronizationMinDelay uint32 `json:"synchronization_min_delay,omitempty"`
}

// DiscoveryAdvancedpollsetting represents Infoblox struct discovery:advancedpollsetting
type DiscoveryAdvancedpollsetting struct {
	// The TCP scan method.
	TcpScanTechnique string `json:"tcp_scan_technique,omitempty"`

	// The ping timeout in seconds.
	PingTimeout uint32 `json:"ping_timeout,omitempty"`

	// The number of ping retries.
	PingRetries uint32 `json:"ping_retries,omitempty"`

	// The number of days a device remains in database after it is no longer found
	// in network.
	PurgeExpiredDeviceData uint32 `json:"purge_expired_device_data,omitempty"`

	// Determines if purge of expired end host data is enabled.
	EnablePurgeExpiredEndhostData bool `json:"enable_purge_expired_endhost_data,omitempty"`

	// The number of days a end host remains in database after it is no longer
	// found in network.
	PurgeExpiredEndhostData uint32 `json:"purge_expired_endhost_data,omitempty"`

	// The ARP aggregate limit.
	ArpAggregateLimit uint32 `json:"arp_aggregate_limit,omitempty"`

	// Route limit.
	RouteLimit uint32 `json:"route_limit,omitempty"`

	// The hourly wait interval between ping sweeps for individual discovery
	// ranges.
	PingSweepInterval uint32 `json:"ping_sweep_interval,omitempty"`

	// The refresh interval in seconds for ARP cache.
	ArpCacheRefreshInterval uint32 `json:"arp_cache_refresh_interval,omitempty"`

	// Determines if polling and authenticating using SNMPv2c or later is enabled.
	PollingAuthenticateSnmpv2cOrLaterOnly bool `json:"polling_authenticate_snmpv2c_or_later_only,omitempty"`

	// Determines if discovery of networks that are not in IPAM is disabled.
	DisableDiscoveryOutsideIpam bool `json:"disable_discovery_outside_ipam,omitempty"`

	// Determines if DHCP router is used as seed for discovery.
	DhcpRouterAsSeed bool `json:"dhcp_router_as_seed,omitempty"`

	// Determines if syslogging of IPAM sync events is enabled.
	SyslogIpamEvents bool `json:"syslog_ipam_events,omitempty"`

	// Determines if syslogging of Network sync events is enabled.
	SyslogNetworkEvents bool `json:"syslog_network_events,omitempty"`
}

// DiscoveryAdvancedsdnpollsettings represents Infoblox struct discovery:advancedsdnpollsettings
type DiscoveryAdvancedsdnpollsettings struct {
	// Policy of mapping SDN networks to network views. To obtain mapping table use
	// the object discovery:sdnnetwork
	NetworksMappingPolicy string `json:"networks_mapping_policy,omitempty"`

	// Disable discovery of SDN subnets that are not in IPAM.
	DisableSdnDiscoveryOutsideIpam bool `json:"disable_sdn_discovery_outside_ipam,omitempty"`
}

// DiscoveryAdvisorsetting represents Infoblox struct discovery:advisorsetting
type DiscoveryAdvisorsetting struct {
	// Use proxy server if true.
	EnableProxy bool `json:"enable_proxy,omitempty"`

	// Host name or ip address of the proxy server.
	ProxyAddress string `json:"proxy_address,omitempty"`

	// Port number the proxy listens on.
	ProxyPort uint32 `json:"proxy_port,omitempty"`

	// Is proxy authorization required?
	UseProxyUsernamePasswd bool `json:"use_proxy_username_passwd,omitempty"`

	// Proxy username.
	ProxyUsername string `json:"proxy_username,omitempty"`

	// Proxy password.
	ProxyPassword string `json:"proxy_password,omitempty"`

	// Application execution interval in seconds. Must be greater than or equal to
	// 86400 seconds (1 day).
	ExecutionInterval uint32 `json:"execution_interval,omitempty"`

	// Application execution hour.
	ExecutionHour uint32 `json:"execution_hour,omitempty"`

	// The type of the network interface on consolidator member.
	NetworkInterfaceType string `json:"network_interface_type,omitempty"`

	// The interface for Advisor application on consolidator member.
	NetworkInterfaceVirtualIp string `json:"network_interface_virtual_ip,omitempty"`

	// Host name or ip address of the Advisor server
	Address string `json:"address,omitempty"`

	// Port number the Advisor server listens on
	Port uint32 `json:"port,omitempty"`

	// Authentication type used for Advisor server
	AuthType string `json:"auth_type,omitempty"`

	// Advisor AUTH token
	AuthToken string `json:"auth_token,omitempty"`

	// Username for Advisor server
	Username string `json:"username,omitempty"`

	// Password for Advisor server
	Password string `json:"password,omitempty"`

	// Advisor minimal severity
	MinSeverity string `json:"min_severity,omitempty"`

	// Timestamp of the Advisor last execution attempt'
	LastExecTime *UnixTime `json:"last_exec_time,omitempty"`

	// Result of the last execution attempt of Advisor
	LastExecStatus string `json:"last_exec_status,omitempty"`

	// Details of the last execution attempt of Advisor. Describes the error or
	// warning with a string
	LastExecDetails string `json:"last_exec_details,omitempty"`

	// Timestamp of the Advisor last Run Now attempt'
	LastRunNowTime *UnixTime `json:"last_run_now_time,omitempty"`

	// Result of the last Run Now attempt of Advisor
	LastRunNowStatus string `json:"last_run_now_status,omitempty"`

	// Details of the last Run Now attempt of Advisor. Describes the error or
	// warning with a string
	LastRunNowDetails string `json:"last_run_now_details,omitempty"`
}

// DiscoveryAutoconversionsetting represents Infoblox struct discovery:autoconversionsetting
type DiscoveryAutoconversionsetting struct {
	// The network view name which contains discovered data for convert.
	NetworkView string `json:"network_view,omitempty"`

	// The object type used to define the converted object.
	Type string `json:"type,omitempty"`

	// Template string used to generate host names.
	Format string `json:"format,omitempty"`

	// The string that contains condition of use the auto conversion settings.
	Condition string `json:"condition,omitempty"`

	// The comment.
	Comment string `json:"comment,omitempty"`
}

// DiscoveryBasicpollsettings represents Infoblox struct discovery:basicpollsettings
type DiscoveryBasicpollsettings struct {
	// Determines whether port scanning is enabled or not.
	PortScanning bool `json:"port_scanning,omitempty"`

	// Determines whether device profile is enabled or not.
	DeviceProfile bool `json:"device_profile,omitempty"`

	// Determines whether SNMP collection is enabled or not.
	SnmpCollection bool `json:"snmp_collection,omitempty"`

	// Determines whether CLI collection is enabled or not.
	CliCollection bool `json:"cli_collection,omitempty"`

	// Determines whether netbios scanning is enabled or not.
	NetbiosScanning bool `json:"netbios_scanning,omitempty"`

	// Determines whether complete ping sweep is enabled or not.
	CompletePingSweep bool `json:"complete_ping_sweep,omitempty"`

	// Determines whether smart subnet ping sweep is enabled or not.
	SmartSubnetPingSweep bool `json:"smart_subnet_ping_sweep,omitempty"`

	// Determines whether auto ARP refresh before switch port polling is enabled or
	// not.
	AutoArpRefreshBeforeSwitchPortPolling bool `json:"auto_arp_refresh_before_switch_port_polling,omitempty"`

	// A switch port data collection polling mode.
	SwitchPortDataCollectionPolling string `json:"switch_port_data_collection_polling,omitempty"`

	// A Schedule Setting struct that determines switch port data collection
	// polling schedule.
	SwitchPortDataCollectionPollingSchedule *SettingSchedule `json:"switch_port_data_collection_polling_schedule,omitempty"`

	// Indicates the interval for switch port data collection polling.
	SwitchPortDataCollectionPollingInterval uint32 `json:"switch_port_data_collection_polling_interval,omitempty"`

	// Credential group.
	CredentialGroup string `json:"credential_group,omitempty"`
}

// DiscoveryBasicsdnpollsettings represents Infoblox struct discovery:basicsdnpollsettings
type DiscoveryBasicsdnpollsettings struct {
	// Enable/disable SDN discovery.
	SdnDiscovery bool `json:"sdn_discovery,omitempty"`

	// Default network view to map collected SDN networks.
	DefaultNetworkView string `json:"default_network_view,omitempty"`

	// SDN end host polling mode.
	EndHostPolling string `json:"end_host_polling,omitempty"`

	// Valid SDN end host polling interval in seconds. Must be between 1800 and
	// 86400 seconds.
	EndHostPollingInterval uint32 `json:"end_host_polling_interval,omitempty"`

	// A Schedule Setting struct that determines SDN end host polling schedule.
	EndHostPollingSchedule *SettingSchedule `json:"end_host_polling_schedule,omitempty"`
}

// DiscoveryClicredential represents Infoblox struct discovery:clicredential
type DiscoveryClicredential struct {
	// The CLI user name.
	User string `json:"user,omitempty"`

	// The CLI password.
	Password string `json:"password,omitempty"`

	// The type of the credential.
	CredentialType string `json:"credential_type,omitempty"`

	// The commment for the credential.
	Comment string `json:"comment,omitempty"`

	// The Credentials ID.
	Id uint32 `json:"id,omitempty"`

	// Group for the CLI credential.
	CredentialGroup string `json:"credential_group,omitempty"`
}

// DiscoveryDevicePortstatistics represents Infoblox struct discovery:device:portstatistics
type DiscoveryDevicePortstatistics struct {
	// The total number of available interfaces on this device.
	InterfacesCount uint32 `json:"interfaces_count,omitempty"`

	// The total number of interfaces which have both administrative and operating
	// states as 'UP'.
	AdminUpOperUpCount uint32 `json:"admin_up_oper_up_count,omitempty"`

	// The total number of interfaces which have administrative state 'UP' and oper
	// state 'DOWN'.
	AdminUpOperDownCount uint32 `json:"admin_up_oper_down_count,omitempty"`

	// The total number of interfaces which have administrative state 'DOWN' and
	// operating state 'DOWN'.
	AdminDownOperDownCount uint32 `json:"admin_down_oper_down_count,omitempty"`
}

// DiscoveryIfaddrinfo represents Infoblox struct discovery:ifaddrinfo
type DiscoveryIfaddrinfo struct {
	// The IPv4 Address or IPv6 Address of the device.
	Address string `json:"address,omitempty"`

	// The ref to IPv4/Ipv6 Address.
	AddressObject string `json:"address_object,omitempty"`

	// The network to which this device belongs, in IPv4 Address/CIDR format.
	Network string `json:"network,omitempty"`
}

// DiscoveryNetworkinfo represents Infoblox struct discovery:networkinfo
type DiscoveryNetworkinfo struct {
	// The ref to the network to which the management IP address belongs.
	Network string `json:"network,omitempty"`

	// The Network address in format address/cidr.
	NetworkStr string `json:"network_str,omitempty"`
}

// DiscoveryPort represents Infoblox struct discovery:port
type DiscoveryPort struct {
	// The discovery port number.
	Port uint32 `json:"port,omitempty"`

	// The discovery port type.
	Type string `json:"type,omitempty"`

	// The comment for this discovery port.
	Comment string `json:"comment,omitempty"`
}

// DiscoveryPortConfigAdminstatus represents Infoblox struct discovery:port:config:adminstatus
type DiscoveryPortConfigAdminstatus struct {
	// The configured admin status value.
	Status string `json:"status,omitempty"`

	// The associated port control task details.
	Details *DiscoveryPortControlTaskdetails `json:"details,omitempty"`
}

// DiscoveryPortConfigDescription represents Infoblox struct discovery:port:config:description
type DiscoveryPortConfigDescription struct {
	// The configured description value.
	Description string `json:"description,omitempty"`

	// The associated port control task details.
	Details *DiscoveryPortControlTaskdetails `json:"details,omitempty"`
}

// DiscoveryPortConfigVlaninfo represents Infoblox struct discovery:port:config:vlaninfo
type DiscoveryPortConfigVlaninfo struct {
	// The configured data VLAN ID and the name of the interface.
	DataVlanInfo *DiscoveryVlaninfo `json:"data_vlan_info,omitempty"`

	// The configured voice VLAN id and name of interface.
	VoiceVlanInfo *DiscoveryVlaninfo `json:"voice_vlan_info,omitempty"`

	// The associated port control task details.
	Details *DiscoveryPortControlTaskdetails `json:"details,omitempty"`
}

// DiscoveryPortControlTaskdetails represents Infoblox struct discovery:port:control:taskdetails
type DiscoveryPortControlTaskdetails struct {
	// The ID of the associated port control task.
	Id uint32 `json:"id,omitempty"`

	// The task status of the associated port control task.
	Status string `json:"status,omitempty"`

	// True if this port control task is completed and matched with current
	// discovered value.
	IsSynchronized bool `json:"is_synchronized,omitempty"`
}

// DiscoveryScaninterface represents Infoblox struct discovery:scaninterface
type DiscoveryScaninterface struct {
	// The name of the network view associated with the network discovery probing
	// member.
	NetworkView string `json:"network_view,omitempty"`

	// The probing interface associated with the network discovery probing member.
	Type string `json:"type,omitempty"`

	// The virtual ip for discovery scan interface on network discovery probing
	// member.
	ScanVirtualIp string `json:"scan_virtual_ip,omitempty"`
}

// DiscoverySdnconfig represents Infoblox struct discovery:sdnconfig
type DiscoverySdnconfig struct {
	// Type of SDN controller.
	SdnType string `json:"sdn_type,omitempty"`

	// SDN controller IP addresses or FQDNs.
	Addresses []string `json:"addresses,omitempty"`

	// The network view associated with SDN controller.
	NetworkView string `json:"network_view,omitempty"`

	// The connection protocol. Valid values are 'HTTP' and 'HTTPS'.
	Protocol string `json:"protocol,omitempty"`

	// Unique configuration handle.
	Handle string `json:"handle,omitempty"`

	// SDN controller login password.
	Password string `json:"password,omitempty"`

	// SDN controller login name.
	Username string `json:"username,omitempty"`

	// SDN controller API key.
	ApiKey string `json:"api_key,omitempty"`

	// True if controller is on-premises, otherwise we consider it is in cloud.
	OnPrem bool `json:"on_prem,omitempty"`

	// Use global proxy settings to access SDN controller.
	UseGlobalProxy bool `json:"use_global_proxy,omitempty"`

	// Additional information about the SDN configuration.
	Comment string `json:"comment,omitempty"`

	// The type of the network interface on discovery member used for SDN
	// controller discovery
	NetworkInterfaceType string `json:"network_interface_type,omitempty"`

	// Virtual IP of VLAN network interface on discovery member
	NetworkInterfaceVirtualIp string `json:"network_interface_virtual_ip,omitempty"`

	// Unique key of SDN controller structure. Must be specified for existing
	// sdn_config structures, otherwise they will be removed. If not specified, new
	// structure will be created.
	Uuid string `json:"uuid,omitempty"`
}

// DiscoverySeedrouter represents Infoblox struct discovery:seedrouter
type DiscoverySeedrouter struct {
	// Address of the seed router.
	Address string `json:"address,omitempty"`

	// The network view name.
	NetworkView string `json:"network_view,omitempty"`

	// Description of the seed router.
	Comment string `json:"comment,omitempty"`
}

// DiscoverySnmp3credential represents Infoblox struct discovery:snmp3credential
type DiscoverySnmp3credential struct {
	// The SNMPv3 user name.
	User string `json:"user,omitempty"`

	// Authentication protocol for the SNMPv3 user.
	AuthenticationProtocol string `json:"authentication_protocol,omitempty"`

	// Authentication password for the SNMPv3 user.
	AuthenticationPassword string `json:"authentication_password,omitempty"`

	// Privacy protocol for the SNMPv3 user.
	PrivacyProtocol string `json:"privacy_protocol,omitempty"`

	// Privacy password for the SNMPv3 user.
	PrivacyPassword string `json:"privacy_password,omitempty"`

	// Comments for the SNMPv3 user.
	Comment string `json:"comment,omitempty"`

	// Group for the SNMPv3 credential.
	CredentialGroup string `json:"credential_group,omitempty"`
}

// DiscoverySnmpcredential represents Infoblox struct discovery:snmpcredential
type DiscoverySnmpcredential struct {
	// The public community string.
	CommunityString string `json:"community_string,omitempty"`

	// Comments for the SNMPv1 and SNMPv2 users.
	Comment string `json:"comment,omitempty"`

	// Group for the SNMPv1 and SNMPv2 credential.
	CredentialGroup string `json:"credential_group,omitempty"`
}

// DiscoveryStatusinfo represents Infoblox struct discovery:statusinfo
type DiscoveryStatusinfo struct {
	// The overall status of the device.
	Status string `json:"status,omitempty"`

	// The detailed message.
	Message string `json:"message,omitempty"`

	// The timestamp when the status was generated.
	Timestamp *UnixTime `json:"timestamp,omitempty"`
}

// DiscoveryVlaninfo represents Infoblox struct discovery:vlaninfo
type DiscoveryVlaninfo struct {
	// The Vlan ID.
	Id uint32 `json:"id,omitempty"`

	// The Vlan name.
	Name string `json:"name,omitempty"`
}

// DiscoveryVrfmappingrule represents Infoblox struct discovery:vrfmappingrule
type DiscoveryVrfmappingrule struct {
	// The name of the network view associated with the VRF mapping rule.
	NetworkView string `json:"network_view,omitempty"`

	// Extended POSIX regular expression matching the VRF name. The regular
	// expression string should contain the leading caret anchor ^ and the trailing
	// dollar anchor $ symbols.
	Criteria string `json:"criteria,omitempty"`

	// The comment.
	Comment string `json:"comment,omitempty"`
}

// Discoverydata represents Infoblox struct discoverydata
type Discoverydata struct {
	// The model name of the end device in the vendor terminology.
	DeviceModel string `json:"device_model,omitempty"`

	// The system name of the interface associated with the discovered IP address.
	DevicePortName string `json:"device_port_name,omitempty"`

	// The hardware type of the interface associated with the discovered IP
	// address.
	DevicePortType string `json:"device_port_type,omitempty"`

	// The type of end host in vendor terminology.
	DeviceType string `json:"device_type,omitempty"`

	// The vendor name of the end host.
	DeviceVendor string `json:"device_vendor,omitempty"`

	// The name of the network device associated with the discovered IP address.
	DiscoveredName string `json:"discovered_name,omitempty"`

	// Specifies whether the IP address was discovered by a NetMRI or NIOS
	// discovery process.
	Discoverer string `json:"discoverer,omitempty"`

	// For IPv6 address only. The DHCP unique identifier of the discovered host.
	// This is an optional field, and data might not be included.
	Duid string `json:"duid,omitempty"`

	// The date and time the IP address was first discovered in Epoch seconds
	// format.
	FirstDiscovered *UnixTime `json:"first_discovered,omitempty"`

	// The port redundant group number.
	IprgNo uint32 `json:"iprg_no,omitempty"`

	// The status for the IP address within port redundant group.
	IprgState string `json:"iprg_state,omitempty"`

	// The port redundant group type.
	IprgType string `json:"iprg_type,omitempty"`

	// The date and time the IP address was last discovered in Epoch seconds
	// format.
	LastDiscovered *UnixTime `json:"last_discovered,omitempty"`

	// The discovered MAC address for the host. This is the unique identifier of a
	// network device. The discovery acquires the MAC address for hosts that are
	// located on the same network as the Grid member that is running the
	// discovery. This can also be the MAC address of a virtual entity on a
	// specified vSphere server.
	MacAddress string `json:"mac_address,omitempty"`

	// The management IP address of the end host that has more than one IP.
	MgmtIpAddress string `json:"mgmt_ip_address,omitempty"`

	// The name returned in the NetBIOS reply or the name you manually register for
	// the discovered host.
	NetbiosName string `json:"netbios_name,omitempty"`

	// A textual description of the switch that is connected to the end device.
	NetworkComponentDescription string `json:"network_component_description,omitempty"`

	// The IPv4 Address or IPv6 Address of the switch that is connected to the end
	// device.
	NetworkComponentIp string `json:"network_component_ip,omitempty"`

	// Model name of the switch port connected to the end host in vendor
	// terminology.
	NetworkComponentModel string `json:"network_component_model,omitempty"`

	// If a reverse lookup was successful for the IP address associated with this
	// switch, the host name is displayed in this field.
	NetworkComponentName string `json:"network_component_name,omitempty"`

	// A textual description of the switch port that is connected to the end
	// device.
	NetworkComponentPortDescription string `json:"network_component_port_description,omitempty"`

	// The name of the switch port connected to the end device.
	NetworkComponentPortName string `json:"network_component_port_name,omitempty"`

	// The number of the switch port connected to the end device.
	NetworkComponentPortNumber string `json:"network_component_port_number,omitempty"`

	// Identifies the switch that is connected to the end device.
	NetworkComponentType string `json:"network_component_type,omitempty"`

	// The vendor name of the switch port connected to the end host.
	NetworkComponentVendor string `json:"network_component_vendor,omitempty"`

	// The list of opened ports on the IP address, represented as: "TCP: 21,22,23
	// UDP: 137,139". Limited to max total 1000 ports.
	OpenPorts string `json:"open_ports,omitempty"`

	// The operating system of the detected host or virtual entity. The OS can be
	// one of the following: * Microsoft for all discovered hosts that have a
	// non-null value in the MAC addresses using the NetBIOS discovery method. * A
	// value that a TCP discovery returns. * The OS of a virtual entity on a
	// vSphere server.
	Os string `json:"os,omitempty"`

	// The negotiated or operational duplex setting of the switch port connected to
	// the end device.
	PortDuplex string `json:"port_duplex,omitempty"`

	// The link status of the switch port connected to the end device. Indicates
	// whether it is connected.
	PortLinkStatus string `json:"port_link_status,omitempty"`

	// The interface speed, in Mbps, of the switch port.
	PortSpeed string `json:"port_speed,omitempty"`

	// The operational status of the switch port. Indicates whether the port is up
	// or down.
	PortStatus string `json:"port_status,omitempty"`

	// The type of switch port.
	PortType string `json:"port_type,omitempty"`

	// The description of the VLAN of the switch port that is connected to the end
	// device.
	PortVlanDescription string `json:"port_vlan_description,omitempty"`

	// The name of the VLAN of the switch port.
	PortVlanName string `json:"port_vlan_name,omitempty"`

	// The ID of the VLAN of the switch port.
	PortVlanNumber string `json:"port_vlan_number,omitempty"`

	// The name of the physical network adapter through which the virtual entity is
	// connected to the appliance.
	VAdapter string `json:"v_adapter,omitempty"`

	// The name of the VMware cluster to which the virtual entity belongs.
	VCluster string `json:"v_cluster,omitempty"`

	// The name of the vSphere datacenter or container to which the virtual entity
	// belongs.
	VDatacenter string `json:"v_datacenter,omitempty"`

	// The name of the virtual entity.
	VEntityName string `json:"v_entity_name,omitempty"`

	// The virtual entity type. This can be blank or one of the following: Virtual
	// Machine, Virtual Host, or Virtual Center. Virtual Center represents a VMware
	// vCenter server.
	VEntityType string `json:"v_entity_type,omitempty"`

	// The name of the VMware server on which the virtual entity was discovered.
	VHost string `json:"v_host,omitempty"`

	// The name of the switch to which the virtual entity is connected.
	VSwitch string `json:"v_switch,omitempty"`

	// Name of the virtual machine.
	VmiName string `json:"vmi_name,omitempty"`

	// ID of the virtual machine.
	VmiId string `json:"vmi_id,omitempty"`

	// Port group which the virtual machine belongs to.
	VlanPortGroup string `json:"vlan_port_group,omitempty"`

	// Name of the virtual switch.
	VswitchName string `json:"vswitch_name,omitempty"`

	// ID of the virtual switch.
	VswitchId string `json:"vswitch_id,omitempty"`

	// Type of the virtual switch: standard or distributed.
	VswitchType string `json:"vswitch_type,omitempty"`

	// Indicates the virtual switch has IPV6 enabled.
	VswitchIpv6Enabled bool `json:"vswitch_ipv6_enabled,omitempty"`

	// Name of the network adapter on the virtual switch connected with the virtual
	// machine.
	VportName string `json:"vport_name,omitempty"`

	// MAC address of the network adapter on the virtual switch where the virtual
	// machine connected to.
	VportMacAddress string `json:"vport_mac_address,omitempty"`

	// Link status of the network adapter on the virtual switch where the virtual
	// machine connected to.
	VportLinkStatus string `json:"vport_link_status,omitempty"`

	// Configured speed of the network adapter on the virtual switch where the
	// virtual machine connected to. Unit is kb.
	VportConfSpeed string `json:"vport_conf_speed,omitempty"`

	// Configured mode of the network adapter on the virtual switch where the
	// virtual machine connected to.
	VportConfMode string `json:"vport_conf_mode,omitempty"`

	// Actual speed of the network adapter on the virtual switch where the virtual
	// machine connected to. Unit is kb.
	VportSpeed string `json:"vport_speed,omitempty"`

	// Actual mode of the network adapter on the virtual switch where the virtual
	// machine connected to.
	VportMode string `json:"vport_mode,omitempty"`

	// Type of the network segment on which the current virtual machine/vport
	// connected to.
	VswitchSegmentType string `json:"vswitch_segment_type,omitempty"`

	// Name of the network segment on which the current virtual machine/vport
	// connected to.
	VswitchSegmentName string `json:"vswitch_segment_name,omitempty"`

	// ID of the network segment on which the current virtual machine/vport
	// connected to.
	VswitchSegmentId string `json:"vswitch_segment_id,omitempty"`

	// Port group of the network segment on which the current virtual machine/vport
	// connected to.
	VswitchSegmentPortGroup string `json:"vswitch_segment_port_group,omitempty"`

	// Numer of available ports reported by the virtual switch on which the virtual
	// machine/vport connected to.
	VswitchAvailablePortsCount uint32 `json:"vswitch_available_ports_count,omitempty"`

	// Type of virtual tunnel endpoint (VTEP) in the virtual switch.
	VswitchTepType string `json:"vswitch_tep_type,omitempty"`

	// IP address of the virtual tunnel endpoint (VTEP) in the virtual switch.
	VswitchTepIp string `json:"vswitch_tep_ip,omitempty"`

	// Port group of the virtual tunnel endpoint (VTEP) in the virtual switch.
	VswitchTepPortGroup string `json:"vswitch_tep_port_group,omitempty"`

	// VLAN of the virtual tunnel endpoint (VTEP) in the virtual switch.
	VswitchTepVlan string `json:"vswitch_tep_vlan,omitempty"`

	// DHCP server of the virtual tunnel endpoint (VTEP) in the virtual switch.
	VswitchTepDhcpServer string `json:"vswitch_tep_dhcp_server,omitempty"`

	// Muticast address of the virtual tunnel endpoint (VTEP) in the virtual
	// swtich.
	VswitchTepMulticast string `json:"vswitch_tep_multicast,omitempty"`

	// IP address of the physical node on which the virtual machine is hosted.
	VmhostIpAddress string `json:"vmhost_ip_address,omitempty"`

	// Name of the physical node on which the virtual machine is hosted.
	VmhostName string `json:"vmhost_name,omitempty"`

	// MAC address of the physical node on which the virtual machine is hosted.
	VmhostMacAddress string `json:"vmhost_mac_address,omitempty"`

	// CIDR subnet of the physical node on which the virtual machine is hosted.
	VmhostSubnetCidr uint32 `json:"vmhost_subnet_cidr,omitempty"`

	// List of all physical port names used by the virtual switch on the physical
	// node on which the virtual machine is hosted. Represented as:
	// "eth1,eth2,eth3".
	VmhostNicNames string `json:"vmhost_nic_names,omitempty"`

	// ID of the tenant which virtual machine belongs to.
	VmiTenantId string `json:"vmi_tenant_id,omitempty"`

	// If the IP is coming from a Cloud environment, the Cloud Management Platform
	// type.
	CmpType string `json:"cmp_type,omitempty"`

	// Discovered IP address type.
	VmiIpType string `json:"vmi_ip_type,omitempty"`

	// Private IP address of the virtual machine.
	VmiPrivateAddress string `json:"vmi_private_address,omitempty"`

	// Indicates whether the IP address is a public address.
	VmiIsPublicAddress bool `json:"vmi_is_public_address,omitempty"`

	// The Cisco ISE SSID.
	CiscoIseSsid string `json:"cisco_ise_ssid,omitempty"`

	// The Endpoint Profile created in Cisco ISE.
	CiscoIseEndpointProfile string `json:"cisco_ise_endpoint_profile,omitempty"`

	// The Cisco ISE connection session state.
	CiscoIseSessionState string `json:"cisco_ise_session_state,omitempty"`

	// The Cisco ISE security group name.
	CiscoIseSecurityGroup string `json:"cisco_ise_security_group,omitempty"`

	// The name of the discovery task.
	TaskName string `json:"task_name,omitempty"`

	// Location of the network component on which the IP address was discovered.
	NetworkComponentLocation string `json:"network_component_location,omitempty"`

	// Contact information from the network component on which the IP address was
	// discovered.
	NetworkComponentContact string `json:"network_component_contact,omitempty"`

	// Location of device on which the IP address was discovered.
	DeviceLocation string `json:"device_location,omitempty"`

	// Contact information from device on which the IP address was discovered.
	DeviceContact string `json:"device_contact,omitempty"`

	// Discovered name of Wireless Access Point.
	ApName string `json:"ap_name,omitempty"`

	// Discovered IP address of Wireless Access Point.
	ApIpAddress string `json:"ap_ip_address,omitempty"`

	// Service set identifier (SSID) associated with Wireless Access Point.
	ApSsid string `json:"ap_ssid,omitempty"`

	// Discovered bridge domain.
	BridgeDomain string `json:"bridge_domain,omitempty"`

	// A comma-separated list of the discovered endpoint groups.
	EndpointGroups string `json:"endpoint_groups,omitempty"`

	// Discovered tenant.
	Tenant string `json:"tenant,omitempty"`

	// The name of the VRF.
	VrfName string `json:"vrf_name,omitempty"`

	// Description of the VRF.
	VrfDescription string `json:"vrf_description,omitempty"`

	// Route distinguisher of the VRF.
	VrfRd string `json:"vrf_rd,omitempty"`

	// The BGP autonomous system number.
	BgpAs uint32 `json:"bgp_as,omitempty"`
}

// Discoverytaskport represents Infoblox struct discoverytaskport
type Discoverytaskport struct {
	// The TCP port number.
	Number uint32 `json:"number,omitempty"`

	// The TCP port descriptive comment.
	Comment string `json:"comment,omitempty"`
}

// Discoverytaskvserver represents Infoblox struct discoverytaskvserver
type Discoverytaskvserver struct {
	// The disable flag of a vSphere server.
	Disable bool `json:"disable,omitempty"`

	// The connection protocol of a vSphere server.
	ConnectionProtocol string `json:"connection_protocol,omitempty"`

	// The FQDN (Fully Qualified Domain Name) or IP address of the vShpere server.
	FqdnOrIp string `json:"fqdn_or_ip,omitempty"`

	// The user password on the vSphere server.
	Password string `json:"password,omitempty"`

	// The connection port that the vSphere server uses.
	Port uint32 `json:"port,omitempty"`

	// The user name on the vSphere server.
	Username string `json:"username,omitempty"`
}

// Dnsseckey represents Infoblox struct dnsseckey
type Dnsseckey struct {
	// The tag of the key for the zone.
	Tag uint32 `json:"tag,omitempty"`

	// The status of the key for the zone.
	Status string `json:"status,omitempty"`

	// The next event date for the key, the rollover date for an active key or the
	// removal date for an already rolled one.
	NextEventDate *UnixTime `json:"next_event_date,omitempty"`

	// The key type.
	Type string `json:"type,omitempty"`

	// The public-key encryption algorithm.
	Algorithm string `json:"algorithm,omitempty"`

	// The Base-64 encoding of the public key.
	PublicKey string `json:"public_key,omitempty"`
}

// Dnsseckeyalgorithm represents Infoblox struct dnsseckeyalgorithm
type Dnsseckeyalgorithm struct {
	// The signing key algorithm.
	Algorithm string `json:"algorithm,omitempty"`

	// The signing key size, in bits.
	Size uint32 `json:"size,omitempty"`
}

// Dnsseckeyparams represents Infoblox struct dnsseckeyparams
type Dnsseckeyparams struct {
	// If set to True, automatic rollovers for the signing key is enabled.
	EnableKskAutoRollover bool `json:"enable_ksk_auto_rollover,omitempty"`

	// Key Signing Key algorithm. Deprecated.
	KskAlgorithm string `json:"ksk_algorithm,omitempty"`

	// A list of Key Signing Key Algorithms.
	KskAlgorithms []*Dnsseckeyalgorithm `json:"ksk_algorithms,omitempty"`

	// Key Signing Key rollover interval, in seconds.
	KskRollover uint32 `json:"ksk_rollover,omitempty"`

	// Key Signing Key size, in bits. Deprecated.
	KskSize uint32 `json:"ksk_size,omitempty"`

	// NSEC (next secure) types.
	NextSecureType string `json:"next_secure_type,omitempty"`

	// This field controls events for which users will be notified.
	KskRolloverNotificationConfig string `json:"ksk_rollover_notification_config,omitempty"`

	// Enable SNMP notifications for KSK related events.
	KskSnmpNotificationEnabled bool `json:"ksk_snmp_notification_enabled,omitempty"`

	// Enable email notifications for KSK related events.
	KskEmailNotificationEnabled bool `json:"ksk_email_notification_enabled,omitempty"`

	// The minimum length for NSEC3 salts.
	Nsec3SaltMinLength uint32 `json:"nsec3_salt_min_length,omitempty"`

	// The maximum length for NSEC3 salts.
	Nsec3SaltMaxLength uint32 `json:"nsec3_salt_max_length,omitempty"`

	// The number of iterations used for hashing NSEC3.
	Nsec3Iterations uint32 `json:"nsec3_iterations,omitempty"`

	// Signature expiration time, in seconds.
	SignatureExpiration uint32 `json:"signature_expiration,omitempty"`

	// Zone Signing Key algorithm. Deprecated.
	ZskAlgorithm string `json:"zsk_algorithm,omitempty"`

	// A list of Zone Signing Key Algorithms.
	ZskAlgorithms []*Dnsseckeyalgorithm `json:"zsk_algorithms,omitempty"`

	// Zone Signing Key rollover interval, in seconds.
	ZskRollover uint32 `json:"zsk_rollover,omitempty"`

	// Zone Signing Key rollover mechanism.
	ZskRolloverMechanism string `json:"zsk_rollover_mechanism,omitempty"`

	// Zone Signing Key size, in bits. Deprecated.
	ZskSize uint32 `json:"zsk_size,omitempty"`
}

// Dnssectrustedkey represents Infoblox struct dnssectrustedkey
type Dnssectrustedkey struct {
	// The FQDN of the domain for which the member validates responses to recursive
	// queries.
	Fqdn string `json:"fqdn,omitempty"`

	// The DNSSEC algorithm used to generate the key.
	Algorithm string `json:"algorithm,omitempty"`

	// The DNSSEC key.
	Key string `json:"key,omitempty"`

	// The secure entry point flag, if set it means this is a KSK configuration.
	SecureEntryPoint bool `json:"secure_entry_point,omitempty"`

	// Responses must be DNSSEC secure for this hierarchy/domain.
	DnssecMustBeSecure bool `json:"dnssec_must_be_secure,omitempty"`
}

// Dnsserver represents Infoblox struct dnsserver
type Dnsserver struct {
	// Flag to override login name and password from the MS Server
	UseLogin bool `json:"use_login,omitempty"`

	// Microsoft Server login name
	LoginName string `json:"login_name,omitempty"`

	// Microsoft Server login password
	LoginPassword string `json:"login_password,omitempty"`

	// flag indicating if the DNS service is managed
	Managed bool `json:"managed,omitempty"`

	// Defines what control to apply on the DNS server
	NextSyncControl string `json:"next_sync_control,omitempty"`

	// Status of the Microsoft DNS Service
	Status string `json:"status,omitempty"`

	// Detailed status of the DNS status
	StatusDetail string `json:"status_detail,omitempty"`

	// Timestamp of the last update
	StatusLastUpdated *UnixTime `json:"status_last_updated,omitempty"`

	// Timestamp of the last synchronization attempt
	LastSyncTs *UnixTime `json:"last_sync_ts,omitempty"`

	// Status of the last synchronization attempt
	LastSyncStatus string `json:"last_sync_status,omitempty"`

	// Detailled status of the last synchronization attempt
	LastSyncDetail string `json:"last_sync_detail,omitempty"`

	// Ordered list of IP addresses to forward queries to
	Forwarders string `json:"forwarders,omitempty"`

	// Flag indicating if the server supports IPv6
	SupportsIpv6 bool `json:"supports_ipv6,omitempty"`

	// Flag indicating if the server supports reverse IPv6 zones
	SupportsIpv6Reverse bool `json:"supports_ipv6_reverse,omitempty"`

	// Flag indicating if the server supports DNAME records
	SupportsRrDname bool `json:"supports_rr_dname,omitempty"`

	// Flag indicating if the server supports
	SupportsDnssec bool `json:"supports_dnssec,omitempty"`

	// Flag indicating if the server supports AD integrated zones
	SupportsActiveDirectory bool `json:"supports_active_directory,omitempty"`

	// MS Server ip address
	Address string `json:"address,omitempty"`

	// Flag indicating if the server supports NAPTR records
	SupportsRrNaptr bool `json:"supports_rr_naptr,omitempty"`

	// Override enable monitoring inherited from grid level
	UseEnableMonitoring bool `json:"use_enable_monitoring,omitempty"`

	// Flag indicating if the DNS service is monitored and controlled
	EnableMonitoring bool `json:"enable_monitoring,omitempty"`

	// Flag to override synchronization interval from the MS Server
	UseSynchronizationMinDelay bool `json:"use_synchronization_min_delay,omitempty"`

	// Minimum number of minutes between two synchronizations
	SynchronizationMinDelay uint32 `json:"synchronization_min_delay,omitempty"`

	// Override enable reports data inherited from grid level
	UseEnableDnsReportsSync bool `json:"use_enable_dns_reports_sync,omitempty"`

	// Enable or Disable MS DNS data for reports from this MS Server
	EnableDnsReportsSync bool `json:"enable_dns_reports_sync,omitempty"`
}

// Dnstapsetting represents Infoblox struct dnstapsetting
type Dnstapsetting struct {
	// Address of DNSTAP receiver.
	DnstapReceiverAddress string `json:"dnstap_receiver_address,omitempty"`

	// DNSTAP receiver port number.
	DnstapReceiverPort uint32 `json:"dnstap_receiver_port,omitempty"`

	// DNSTAP id string.
	DnstapIdentity string `json:"dnstap_identity,omitempty"`

	// DNSTAP version.
	DnstapVersion string `json:"dnstap_version,omitempty"`
}

// DtcHealth represents Infoblox struct dtc:health
type DtcHealth struct {
	// The availability color status.
	Availability string `json:"availability,omitempty"`

	// The enabled state of the object.
	EnabledState string `json:"enabled_state,omitempty"`

	// The textual description of the object's status.
	Description string `json:"description,omitempty"`
}

// DtcMonitorSnmpOid represents Infoblox struct dtc:monitor:snmp:oid
type DtcMonitorSnmpOid struct {
	// The SNMP OID value for DTC SNMP Monitor health checks.
	Oid string `json:"oid,omitempty"`

	// The comment for a DTC SNMP Health Monitor OID object.
	Comment string `json:"comment,omitempty"`

	// The value of the condition type for DTC SNMP Monitor health check results.
	Type string `json:"type,omitempty"`

	// The condition of the validation result for an SNMP health check. The
	// following conditions can be applied to the health check results: 'ANY'
	// accepts any response; 'EXACT' accepts result equal to 'first'; 'LEQ' accepts
	// result which is less than 'first'; 'GEQ' accepts result which is greater
	// than 'first'; 'RANGE' accepts result value of which is between 'first' and
	// 'last'.
	Condition string `json:"condition,omitempty"`

	// The condition's first term to match against the SNMP health check result.
	First string `json:"first,omitempty"`

	// The condition's second term to match against the SNMP health check result
	// with 'RANGE' condition.
	Last string `json:"last,omitempty"`
}

// DtcPoolConsolidatedMonitorHealth represents Infoblox struct dtc:pool:consolidated_monitor_health
type DtcPoolConsolidatedMonitorHealth struct {
	// Members whose monitor statuses are shared across other members in a pool.
	Members []string `json:"members,omitempty"`

	// Monitor whose statuses are shared across other members in a pool.
	Monitor string `json:"monitor,omitempty"`

	// Servers assigned to a pool with monitor defined are healthy if ANY or ALL
	// members report healthy status.
	Availability string `json:"availability,omitempty"`

	// Flag for switching health performing and sharing behavior to perform health
	// checks on each DTC grid member that serves related LBDN(s) and send them
	// across all DTC grid members from both selected and non-selected lists.
	FullHealthCommunication bool `json:"full_health_communication,omitempty"`
}

// DtcPoolLink represents Infoblox struct dtc:pool:link
type DtcPoolLink struct {
	// The pool to link with.
	Pool string `json:"pool,omitempty"`

	// The weight of pool.
	Ratio uint32 `json:"ratio,omitempty"`
}

// DtcServerLink represents Infoblox struct dtc:server:link
type DtcServerLink struct {
	// The server to link with.
	Server string `json:"server,omitempty"`

	// The weight of server.
	Ratio uint32 `json:"ratio,omitempty"`
}

// DtcServerMonitor represents Infoblox struct dtc:server:monitor
type DtcServerMonitor struct {
	// The monitor related to server.
	Monitor string `json:"monitor,omitempty"`

	// IP address or FQDN of the server used for monitoring.
	Host string `json:"host,omitempty"`
}

// DtcTopologyRuleSource represents Infoblox struct dtc:topology:rule:source
type DtcTopologyRuleSource struct {
	// The source type.
	SourceType string `json:"source_type,omitempty"`

	// The operation used to match the value.
	SourceOp string `json:"source_op,omitempty"`

	// The source value.
	SourceValue string `json:"source_value,omitempty"`
}

// DxlEndpointBroker represents Infoblox struct dxl:endpoint:broker
type DxlEndpointBroker struct {
	// The FQDN for the DXL endpoint broker.
	HostName string `json:"host_name,omitempty"`

	// The IPv4 Address or IPv6 Address for the DXL endpoint broker.
	Address string `json:"address,omitempty"`

	// The communication port for the DXL endpoint broker.
	Port uint32 `json:"port,omitempty"`

	// The unique identifier for the DXL endpoint.
	UniqueId string `json:"unique_id,omitempty"`
}

// Eaexpressionop represents Infoblox struct eaexpressionop
type Eaexpressionop struct {
	// The operation name.
	Op string `json:"op,omitempty"`

	// The name of the Extensible Attribute Definition object which is used as the
	// first operand value.
	Op1 string `json:"op1,omitempty"`

	// The first operand type.
	Op1Type string `json:"op1_type,omitempty"`

	// The second operand value.
	Op2 string `json:"op2,omitempty"`

	// The second operand type.
	Op2Type string `json:"op2_type,omitempty"`
}

// Exclusionrange represents Infoblox struct exclusionrange
type Exclusionrange struct {
	// The IPv4 Address starting address of the exclusion range.
	StartAddress string `json:"start_address,omitempty"`

	// The IPv4 Address ending address of the exclusion range.
	EndAddress string `json:"end_address,omitempty"`

	// Comment for the exclusion range; maximum 256 characters.
	Comment string `json:"comment,omitempty"`
}

// Exclusionrangetemplate represents Infoblox struct exclusionrangetemplate
type Exclusionrangetemplate struct {
	// The address offset of the DHCP exclusion range template.
	Offset uint32 `json:"offset,omitempty"`

	// The number of addresses in the DHCP exclusion range template.
	NumberOfAddresses uint32 `json:"number_of_addresses,omitempty"`

	// A descriptive comment of a DHCP exclusion range template.
	Comment string `json:"comment,omitempty"`
}

// Expressionop represents Infoblox struct expressionop
type Expressionop struct {
	// The operation name.
	Op string `json:"op,omitempty"`

	// The first operand value.
	Op1 string `json:"op1,omitempty"`

	// The first operand type.
	Op1Type string `json:"op1_type,omitempty"`

	// The second operand value.
	Op2 string `json:"op2,omitempty"`

	// The second operand type.
	Op2Type string `json:"op2_type,omitempty"`
}

// ExtensibleattributedefDescendants represents Infoblox struct extensibleattributedef:descendants
type ExtensibleattributedefDescendants struct {
	// This option describes which action must be taken if the extensible attribute
	// exists for both the parent and descendant objects: * INHERIT: inherit the
	// extensible attribute from the parent object. * RETAIN: retain the value of
	// an extensible attribute that was set for the child object. * CONVERT: the
	// value of the extensible attribute must be copied from the parent object.
	OptionWithEa string `json:"option_with_ea,omitempty"`

	// This option describes which action must be taken if the extensible attribute
	// exists for the parent, but is absent from the descendant object: * INHERIT:
	// inherit the extensible attribute from the parent object. * NOT_INHERIT: do
	// nothing.
	OptionWithoutEa string `json:"option_without_ea,omitempty"`

	// This option describes which action must be taken if the extensible attribute
	// exists for the descendant, but is absent for the parent object: * RETAIN:
	// retain the extensible attribute value for the descendant object. * REMOVE:
	// remove this extensible attribute from the descendant object.
	OptionDeleteEa string `json:"option_delete_ea,omitempty"`
}

// EADefListValue represents Infoblox struct extensibleattributedef:listvalues
type EADefListValue struct {
	// Enum value
	Value string `json:"value,omitempty"`
}

// NameServer represents Infoblox struct extserver
type NameServer struct {
	// The IPv4 Address or IPv6 Address of the server.
	Address string `json:"address,omitempty"`

	// A resolvable domain name for the external DNS server.
	Name string `json:"name,omitempty"`

	// This flag represents whether the name server is shared with the parent
	// Microsoft primary zone's delegation server.
	SharedWithMsParentDelegation bool `json:"shared_with_ms_parent_delegation,omitempty"`

	// Set this flag to hide the NS record for the primary name server from DNS
	// queries.
	Stealth bool `json:"stealth,omitempty"`

	// A generated TSIG key.
	TsigKey string `json:"tsig_key,omitempty"`

	// The TSIG key algorithm.
	TsigKeyAlg string `json:"tsig_key_alg,omitempty"`

	// The TSIG key name.
	TsigKeyName string `json:"tsig_key_name,omitempty"`

	// Use flag for: tsig_key_name
	UseTsigKeyName bool `json:"use_tsig_key_name,omitempty"`
}

// Extsyslogbackupserver represents Infoblox struct extsyslogbackupserver
type Extsyslogbackupserver struct {
	// The IPv4 or IPv6 address of the backup syslog server.
	Address string `json:"address,omitempty"`

	// The directory path for the replication of the rotated syslog files.
	DirectoryPath string `json:"directory_path,omitempty"`

	// If set to True, the syslog backup server is enabled.
	Enable bool `json:"enable,omitempty"`

	// The password of the backup syslog server.
	Password string `json:"password,omitempty"`

	// The port used to connect to the backup syslog server.
	Port uint32 `json:"port,omitempty"`

	// The transport protocol used to connect to the backup syslog server.
	Protocol string `json:"protocol,omitempty"`

	// The username of the backup syslog server.
	Username string `json:"username,omitempty"`
}

// Filetransfersetting represents Infoblox struct filetransfersetting
type Filetransfersetting struct {
	// The directory to save the captured DNS queries and responses.
	Directory string `json:"directory,omitempty"`

	// The host name of the destination server for DNS capture transfer.
	Host string `json:"host,omitempty"`

	// The password to access the destination server directory.
	Password string `json:"password,omitempty"`

	// The transfer protocol for the captured DNS queries and responses.
	Type string `json:"type,omitempty"`

	// The username to access the destination server directory.
	Username string `json:"username,omitempty"`

	// Transfer scp port.
	Port uint32 `json:"port,omitempty"`
}

// Filterrule represents Infoblox struct filterrule
type Filterrule struct {
	// The name of the DHCP filter.
	Filter string `json:"filter,omitempty"`

	// The permission to be applied.
	Permission string `json:"permission,omitempty"`
}

// FireeyeAlertmap represents Infoblox struct fireeye:alertmap
type FireeyeAlertmap struct {
	// The type of Fireeye Alert.
	AlertType string `json:"alert_type,omitempty"`

	// The RPZ rule for the alert.
	RpzRule string `json:"rpz_rule,omitempty"`

	// The expiration Lifetime of alert type. The 32-bit unsigned integer
	// represents the amount of seconds this alert type will live for. 0 means the
	// alert will never expire.
	Lifetime uint32 `json:"lifetime,omitempty"`
}

// FireeyeRulemapping represents Infoblox struct fireeye:rulemapping
type FireeyeRulemapping struct {
	// The override setting for APT alerts.
	AptOverride string `json:"apt_override,omitempty"`

	// The FireEye alert mapping.
	FireeyeAlertMapping []*FireeyeAlertmap `json:"fireeye_alert_mapping,omitempty"`

	// The domain name to be substituted, this is applicable only when apt_override
	// is set to "SUBSTITUTE".
	SubstitutedDomainName string `json:"substituted_domain_name,omitempty"`
}

// Forwardingmemberserver represents Infoblox struct forwardingmemberserver
type Forwardingmemberserver struct {
	// The name of this Grid member in FQDN format.
	Name string `json:"name,omitempty"`

	// Determines if the appliance sends queries to forwarders only, and not to
	// other internal or Internet root servers.
	ForwardersOnly bool `json:"forwarders_only,omitempty"`

	// The information for the remote name server to which you want the Infoblox
	// appliance to forward queries for a specified domain name.
	ForwardTo NullableNameServers `json:"forward_to,omitempty"`

	// Use flag for: forward_to
	UseOverrideForwarders bool `json:"use_override_forwarders"`
}

// GridAttackdetect represents Infoblox struct grid:attackdetect
type GridAttackdetect struct {
	// Determines if DNS attack detection is enabled or not.
	Enable bool `json:"enable,omitempty"`

	// The high threshold value (in percentage) for starting DNS attack detection.
	High uint32 `json:"high,omitempty"`

	// The maximum number of events that have occurred before processing DNS attack
	// detection.
	IntervalMax uint32 `json:"interval_max,omitempty"`

	// The minimum number of events that have occurred before processing DNS attack
	// detection.
	IntervalMin uint32 `json:"interval_min,omitempty"`

	// The time interval between detection processing.
	IntervalTime uint32 `json:"interval_time,omitempty"`

	// The low threshold value (in percentage) for starting DNS attack detection.
	Low uint32 `json:"low,omitempty"`
}

// GridAttackmitigation represents Infoblox struct grid:attackmitigation
type GridAttackmitigation struct {
	// Configuration for detecting changes for the Cache Hit Ratio (CHR) of
	// recursive queries.
	DetectChr *GridAttackdetect `json:"detect_chr,omitempty"`

	// The cache utilization (in percentage) when Cache Hit Ratio (CHR) starts.
	DetectChrGrace uint32 `json:"detect_chr_grace,omitempty"`

	// Configuration for detecting NXDOMAIN responses from up-stream servers to all
	// incoming recursive responses.
	DetectNxdomainResponses *GridAttackdetect `json:"detect_nxdomain_responses,omitempty"`

	// Configuration for detecting the UDP packet drop rate.
	DetectUdpDrop *GridAttackdetect `json:"detect_udp_drop,omitempty"`

	// The minimum time interval (in seconds) between changes in attack status.
	Interval uint32 `json:"interval,omitempty"`

	// Enable or disable the mitigation of possible NXDOMAIN attacks by splitting
	// the Lease Recently Used (LRU) list into NX (non-existent) RRsets and all
	// other RRsets, and by removing the least recently used items from the LRU
	// list for NX RRsets before removing items for other RRsets.
	MitigateNxdomainLru bool `json:"mitigate_nxdomain_lru,omitempty"`
}

// GridAutoblackhole represents Infoblox struct grid:autoblackhole
type GridAutoblackhole struct {
	// Enables or disables the configuration of the maximum number of concurrent
	// recursive queries the appliance sends to each upstream DNS server.
	EnableFetchesPerServer bool `json:"enable_fetches_per_server,omitempty"`

	// Enables or disables the configuration of the maximum number of concurrent
	// recursive queries the appliance sends to each DNS zone.
	EnableFetchesPerZone bool `json:"enable_fetches_per_zone,omitempty"`

	// Enables or disables the holddown configuration when the appliance stops
	// sending queries to non-responsive servers.
	EnableHolddown bool `json:"enable_holddown,omitempty"`

	// The maximum number of concurrent recursive queries the appliance sends to a
	// single upstream name server before blocking additional queries to that
	// server.
	FetchesPerServer uint32 `json:"fetches_per_server,omitempty"`

	// The maximum number of concurrent recursive queries that a server sends for
	// its domains.
	FetchesPerZone uint32 `json:"fetches_per_zone,omitempty"`

	// Determines how often (in number of recursive responses) the appliance
	// recalculates the average timeout ratio for each DNS server.
	FpsFreq uint32 `json:"fps_freq,omitempty"`

	// The holddown duration for non-responsive servers.
	Holddown uint32 `json:"holddown,omitempty"`

	// The number of consecutive timeouts before holding down a non-responsive
	// server.
	HolddownThreshold uint32 `json:"holddown_threshold,omitempty"`

	// The minimum time (in seconds) that needs to be passed before a timeout
	// occurs. Note that only these timeouts are counted towards the number of
	// consecutive timeouts.
	HolddownTimeout uint32 `json:"holddown_timeout,omitempty"`
}

// GridCloudapiGatewayConfig represents Infoblox struct grid:cloudapi:gateway:config
type GridCloudapiGatewayConfig struct {
	// Enable Gateway Service.
	EnableProxyService bool `json:"enable_proxy_service,omitempty"`

	// Gateway port
	Port uint32 `json:"port,omitempty"`

	// List of Gateway FQDN to AWS Endpoint Mapping.
	EndpointMapping []*GridCloudapiGatewayEndpointmapping `json:"endpoint_mapping,omitempty"`
}

// GridCloudapiGatewayEndpointmapping represents Infoblox struct grid:cloudapi:gateway:endpointmapping
type GridCloudapiGatewayEndpointmapping struct {
	// Gateway FQDN.
	GatewayFqdn string `json:"gateway_fqdn,omitempty"`

	// Endpoint FQDN.
	EndpointFqdn string `json:"endpoint_fqdn,omitempty"`
}

// GridCloudapiInfo represents Infoblox struct grid:cloudapi:info
type GridCloudapiInfo struct {
	// The Cloud Platform Appliance to which authority of the object is delegated.
	DelegatedMember *Dhcpmember `json:"delegated_member,omitempty"`

	// Indicates the scope of delegation for the object. This can be one of the
	// following: NONE (outside any delegation), ROOT (the delegation point),
	// SUBTREE (within the scope of a delegation), RECLAIMING (within the scope of
	// a delegation being reclaimed, either as the delegation point or in the
	// subtree).
	DelegatedScope string `json:"delegated_scope,omitempty"`

	// Indicates the root of the delegation if delegated_scope is SUBTREE or
	// RECLAIMING. This is not set otherwise.
	DelegatedRoot string `json:"delegated_root,omitempty"`

	// Determines whether the object was created by the cloud adapter or not.
	OwnedByAdaptor bool `json:"owned_by_adaptor,omitempty"`

	// Indicates the cloud origin of the object.
	Usage string `json:"usage,omitempty"`

	// Reference to the tenant object associated with the object, if any.
	Tenant string `json:"tenant,omitempty"`

	// Indicates the specified cloud management platform.
	MgmtPlatform string `json:"mgmt_platform,omitempty"`

	// Type of authority over the object.
	AuthorityType string `json:"authority_type,omitempty"`
}

// GridCloudapiUser represents Infoblox struct grid:cloudapi:user
type GridCloudapiUser struct {
	// Determines whether this is a remote admin user.
	IsRemote bool `json:"is_remote,omitempty"`

	// Username that matches a remote administrator who can perform cloud API
	// requests on the Cloud Platform Appliance.
	RemoteAdmin string `json:"remote_admin,omitempty"`

	// Local administrator who can perform cloud API requests on the Cloud Platform
	// Appliance.
	LocalAdmin string `json:"local_admin,omitempty"`
}

// GridConsentbannersetting represents Infoblox struct grid:consentbannersetting
type GridConsentbannersetting struct {
	// Determines whether the consent banner is enabled.
	Enable bool `json:"enable,omitempty"`

	// The message included in the consent banner.
	Message string `json:"message,omitempty"`
}

// GridCspapiconfig represents Infoblox struct grid:cspapiconfig
type GridCspapiconfig struct {
	// The url for the CspApiConfig.
	Url string `json:"url,omitempty"`

	// The user name for the CspApiConfig.
	Username string `json:"username,omitempty"`

	// The password for the CspApiConfig.
	Password string `json:"password,omitempty"`
}

// GridCspgridsetting represents Infoblox struct grid:cspgridsetting
type GridCspgridsetting struct {
	// Join token required to connect to a cluster
	CspJoinToken string `json:"csp_join_token,omitempty"`

	// IP address of DNS resolver in DFP
	CspDnsResolver string `json:"csp_dns_resolver,omitempty"`

	// HTTP Proxy IP address of CSP Portal
	CspHttpsProxy string `json:"csp_https_proxy,omitempty"`
}

// GridDnsFixedrrsetorderfqdn represents Infoblox struct grid:dns:fixedrrsetorderfqdn
type GridDnsFixedrrsetorderfqdn struct {
	// The FQDN of the fixed RRset configuration item.
	Fqdn string `json:"fqdn,omitempty"`

	// The record type for the specified FQDN in the fixed RRset configuration.
	RecordType string `json:"record_type,omitempty"`
}

// GridInformationalbannersetting represents Infoblox struct grid:informationalbannersetting
type GridInformationalbannersetting struct {
	// Determines whether the display of the informational level banner is enabled.
	Enable bool `json:"enable,omitempty"`

	// The message included in the informational level banner.
	Message string `json:"message,omitempty"`

	// The color for the informational level banner.
	Color string `json:"color,omitempty"`
}

// GridLicensesubpool represents Infoblox struct grid:licensesubpool
type GridLicensesubpool struct {
	// The license string for the license subpool.
	Key string `json:"key,omitempty"`

	// The total number of dynamic licenses allowed for this license subpool.
	Installed uint32 `json:"installed,omitempty"`

	// License expiration date.
	ExpiryDate *UnixTime `json:"expiry_date,omitempty"`
}

// GridLockoutsetting represents Infoblox struct grid:lockoutsetting
type GridLockoutsetting struct {
	// Enable/disable sequential failed login attempts lockout for local users
	EnableSequentialFailedLoginAttemptsLockout bool `json:"enable_sequential_failed_login_attempts_lockout,omitempty"`

	// The number of failed login attempts
	SequentialAttempts uint32 `json:"sequential_attempts,omitempty"`

	// Time period the account remains locked after sequential failed login attempt
	// lockout.
	FailedLockoutDuration uint32 `json:"failed_lockout_duration,omitempty"`

	// Never unlock option is also provided and if set then user account is locked
	// forever and only super user can unlock this account
	NeverUnlockUser bool `json:"never_unlock_user,omitempty"`
}

// GridLoggingcategories represents Infoblox struct grid:loggingcategories
type GridLoggingcategories struct {
	// Determines whether the DTC GSLB activity is captured or not.
	LogDtcGslb bool `json:"log_dtc_gslb,omitempty"`

	// Determines whether the DTC health monitoring information is captured or not.
	LogDtcHealth bool `json:"log_dtc_health,omitempty"`

	// Determines whether the BIND messages that are not specifically classified
	// are captured or not.
	LogGeneral bool `json:"log_general,omitempty"`

	// Determines whether the client requests are captured or not.
	LogClient bool `json:"log_client,omitempty"`

	// Determines whether the configuration file parsing is captured or not.
	LogConfig bool `json:"log_config,omitempty"`

	// Determines whether the BIND's internal database processes are captured or
	// not.
	LogDatabase bool `json:"log_database,omitempty"`

	// Determines whether the DNSSEC-signed responses are captured or not.
	LogDnssec bool `json:"log_dnssec,omitempty"`

	// Determines whether the bad delegation instances are captured or not.
	LogLameServers bool `json:"log_lame_servers,omitempty"`

	// Determines whether the network operation messages are captured or not.
	LogNetwork bool `json:"log_network,omitempty"`

	// Determines whether the asynchronous zone change notification messages are
	// captured or not.
	LogNotify bool `json:"log_notify,omitempty"`

	// Determines whether the query messages are captured or not.
	LogQueries bool `json:"log_queries,omitempty"`

	// Determines whether the query rewrite messages are captured or not.
	LogQueryRewrite bool `json:"log_query_rewrite,omitempty"`

	// Determines whether the response messages are captured or not.
	LogResponses bool `json:"log_responses,omitempty"`

	// Determines whether the DNS resolution instances, including recursive queries
	// from resolvers are captured or not.
	LogResolver bool `json:"log_resolver,omitempty"`

	// Determines whether the approved and denied requests are captured or not.
	LogSecurity bool `json:"log_security,omitempty"`

	// Determines whether the dynamic update instances are captured or not.
	LogUpdate bool `json:"log_update,omitempty"`

	// Determines whether the zone transfer messages from the remote name servers
	// to the appliance are captured or not.
	LogXferIn bool `json:"log_xfer_in,omitempty"`

	// Determines whether the zone transfer messages from the Infoblox appliance to
	// remote name servers are captured or not.
	LogXferOut bool `json:"log_xfer_out,omitempty"`

	// Determines whether the security update messages are captured or not.
	LogUpdateSecurity bool `json:"log_update_security,omitempty"`

	// Determines whether the rate limit messages are captured or not.
	LogRateLimit bool `json:"log_rate_limit,omitempty"`

	// Determines whether the Response Policy Zone messages are captured or not.
	LogRpz bool `json:"log_rpz,omitempty"`
}

// NTPSetting represents Infoblox struct grid:ntp
type NTPSetting struct {
	// Determines whether NTP is enabled on the Grid.
	EnableNTP bool `json:"enable_ntp,omitempty"`

	// The list of NTP servers configured on a Grid.
	NTPServers []*NTPserver `json:"ntp_servers,omitempty"`

	// The list of NTP authentication keys used to authenticate NTP clients.
	NTPKeys []*Ntpkey `json:"ntp_keys,omitempty"`

	// The NTP access control settings.
	NTPAcl *Ntpaccess `json:"ntp_acl,omitempty"`

	// Determines whether the Kiss-o'-Death packets are enabled.
	NTPKod bool `json:"ntp_kod,omitempty"`

	// Grid level GM local NTP stratum.
	GmLocalNtpStratum uint32 `json:"gm_local_ntp_stratum,omitempty"`

	// Local NTP stratum for non-GM members.
	LocalNtpStratum uint32 `json:"local_ntp_stratum,omitempty"`

	// This flag controls whether gm_local_ntp_stratum value be set to a default
	// value
	UseDefaultStratum bool `json:"use_default_stratum,omitempty"`
}

// GridResponseratelimiting represents Infoblox struct grid:responseratelimiting
type GridResponseratelimiting struct {
	// Determines if the response rate limiting is enabled or not.
	EnableRrl bool `json:"enable_rrl,omitempty"`

	// Determines if logging for response rate limiting without dropping any
	// requests is enabled or not.
	LogOnly bool `json:"log_only,omitempty"`

	// The number of responses per client per second.
	ResponsesPerSecond uint32 `json:"responses_per_second,omitempty"`

	// The time interval in seconds over which responses are tracked.
	Window uint32 `json:"window,omitempty"`

	// The response rate limiting slip. Note that if slip is not equal to 0 every
	// n-th rate-limited UDP request is sent a truncated response instead of being
	// dropped.
	Slip uint32 `json:"slip,omitempty"`
}

// GridRestartbannersetting represents Infoblox struct grid:restartbannersetting
type GridRestartbannersetting struct {
	// If set to True, the restart banner is enabled.
	Enabled bool `json:"enabled,omitempty"`

	// If set to True, the user is required to input name before restarting the
	// services.
	EnableDoubleConfirmation bool `json:"enable_double_confirmation,omitempty"`
}

// GridServicerestart represents Infoblox struct grid:servicerestart
type GridServicerestart struct {
	// The time duration to delay a restart for a restart group.
	Delay uint32 `json:"delay,omitempty"`

	// The duration of timeout for a restart group. The value "-1" means infinite.
	Timeout int `json:"timeout,omitempty"`

	// Determines whether the Grid should try to restart offline member.
	RestartOffline bool `json:"restart_offline,omitempty"`
}

// GridServicerestartGroupSchedule represents Infoblox struct grid:servicerestart:group:schedule
type GridServicerestartGroupSchedule struct {
	// The list of applicable services for the restart.
	Services []string `json:"services,omitempty"`

	// The restart method for a Grid restart.
	Mode string `json:"mode,omitempty"`

	// The Schedule Setting struct that determines the schedule for the restart.
	Schedule *SettingSchedule `json:"schedule,omitempty"`

	// Determines if the Restart Group should have a force restart.
	Force bool `json:"force,omitempty"`
}

// GridmemberSoamname represents Infoblox struct gridmember_soamname
type GridmemberSoamname struct {
	// The grid primary server for the zone. Only one of "grid_primary" or
	// "ms_server_primary" should be set when modifying or creating the object.
	GridPrimary string `json:"grid_primary,omitempty"`

	// The primary MS server for the zone. Only one of "grid_primary" or
	// "ms_server_primary" should be set when modifying or creating the object.
	MsServerPrimary string `json:"ms_server_primary,omitempty"`

	// Master's SOA MNAME. This value can be in unicode format.
	Mname string `json:"mname,omitempty"`

	// Master's SOA MNAME in punycode format.
	DnsMname string `json:"dns_mname,omitempty"`
}

// GridmemberSoaserial represents Infoblox struct gridmember_soaserial
type GridmemberSoaserial struct {
	// The grid primary server for the zone. Only one of "grid_primary" or
	// "ms_server_primary" will be set when the object is retrieved from the
	// server.
	GridPrimary string `json:"grid_primary,omitempty"`

	// The primary MS server for the zone. Only one of "grid_primary" or
	// "ms_server_primary" will be set when the object is retrieved from the
	// server.
	MsServerPrimary string `json:"ms_server_primary,omitempty"`

	// The SOA serial number.
	Serial uint32 `json:"serial,omitempty"`
}

// Hotfix represents Infoblox struct hotfix
type Hotfix struct {
	// The status text of the hotfix.
	StatusText string `json:"status_text,omitempty"`

	// Unique ID of the hotfix.
	UniqueId string `json:"unique_id,omitempty"`
}

// HsmSafenet represents Infoblox struct hsm:safenet
type HsmSafenet struct {
	// The HSM SafeNet device IPv4 Address or FQDN.
	Name string `json:"name,omitempty"`

	// The HSM SafeNet device partition serial number (PSN).
	PartitionSerialNumber string `json:"partition_serial_number,omitempty"`

	// Determines whether the HSM SafeNet device is disabled.
	Disable bool `json:"disable,omitempty"`

	// Partition ID that is displayed after the appliance has successfully
	// connected to the HSM SafeNet device.
	PartitionId string `json:"partition_id,omitempty"`

	// Determines whether the HSM SafeNet device is FIPS compliant.
	IsFipsCompliant bool `json:"is_fips_compliant,omitempty"`

	// The token returned by the uploadinit function call in object fileop for a
	// SafeNet HSM device certificate.
	ServerCert string `json:"server_cert,omitempty"`

	// The HSM SafeNet device partition capacity percentage used.
	PartitionCapacity uint32 `json:"partition_capacity,omitempty"`

	// The HSM SafeNet device status.
	Status string `json:"status,omitempty"`
}

// HsmThales represents Infoblox struct hsm:thales
type HsmThales struct {
	// The IPv4 Address of the Thales HSM device.
	RemoteIp string `json:"remote_ip,omitempty"`

	// The Thales HSM device destination port.
	RemotePort uint32 `json:"remote_port,omitempty"`

	// The Thales HSM device status.
	Status string `json:"status,omitempty"`

	// The Thales HSM device electronic serial number.
	RemoteEsn string `json:"remote_esn,omitempty"`

	// The Thales HSM device public key digest.
	Keyhash string `json:"keyhash,omitempty"`

	// Determines whether the Thales HSM device is disabled.
	Disable bool `json:"disable,omitempty"`
}

// Interface represents Infoblox struct interface
type Interface struct {
	// Determines if anycast for the Interface object is enabled or not.
	Anycast bool `json:"anycast,omitempty"`

	// The IPv4 network settings of the Grid Member.
	Ipv4NetworkSetting *SettingNetwork `json:"ipv4_network_setting,omitempty"`

	// The IPv6 network settings of the Grid Member.
	Ipv6NetworkSetting *Ipv6setting `json:"ipv6_network_setting,omitempty"`

	// A descriptive comment of this structure.
	Comment string `json:"comment,omitempty"`

	// Determines if the BGP advertisement setting is enabled for this interface or
	// not.
	EnableBgp bool `json:"enable_bgp,omitempty"`

	// Determines if the OSPF advertisement setting is enabled for this interface
	// or not.
	EnableOspf bool `json:"enable_ospf,omitempty"`

	// The interface type for the Interface object.
	Interface string `json:"interface,omitempty"`
}

// Ipv6networksetting represents Infoblox struct ipv6networksetting
type Ipv6networksetting struct {
	// IPv6 address.
	Address string `json:"address,omitempty"`

	// IPv6 CIDR
	Cidr uint32 `json:"cidr,omitempty"`

	// Gateway address.
	Gateway string `json:"gateway,omitempty"`
}

// Ipv6setting represents Infoblox struct ipv6setting
type Ipv6setting struct {
	// Determines if IPv6 networking should be enabled.
	Enabled bool `json:"enabled,omitempty"`

	// IPv6 address.
	VirtualIp string `json:"virtual_ip,omitempty"`

	// IPv6 cidr prefix
	CidrPrefix uint32 `json:"cidr_prefix,omitempty"`

	// Gateway address.
	Gateway string `json:"gateway,omitempty"`

	// Determines if automatic router configuration should be enabled.
	AutoRouterConfigEnabled bool `json:"auto_router_config_enabled,omitempty"`

	// The identifier for the VLAN. Valid values are from 1 to 4096.
	VlanId uint32 `json:"vlan_id,omitempty"`

	// Determines if the current address is the primary VLAN address or not.
	Primary bool `json:"primary,omitempty"`

	// The DSCP (Differentiated Services Code Point) value determines relative
	// priorities for the type of services on your network. The appliance
	// implements QoS (Quality of Service) rules based on this configuration. Valid
	// values are from 0 to 63.
	Dscp uint32 `json:"dscp,omitempty"`

	// Use flag for: dscp
	UseDscp bool `json:"use_dscp,omitempty"`
}

// Lan2portsetting represents Infoblox struct lan2portsetting
type Lan2portsetting struct {
	// If the 'enabled' field is set to True, this defines the virtual router ID
	// for the LAN2 port.
	VirtualRouterId uint32 `json:"virtual_router_id,omitempty"`

	// If this field is set to True, then it has its own IP settings. Otherwise,
	// port redundancy mechanism is used, in which the LAN1 and LAN2 ports share
	// the same IP settings for failover purposes.
	Enabled bool `json:"enabled,omitempty"`

	// If the 'enable' field is set to True, this defines IPv4 network settings for
	// LAN2.
	NetworkSetting *SettingNetwork `json:"network_setting,omitempty"`

	// If the 'enable' field is set to True, this defines IPv6 network settings for
	// the LAN2 port.
	V6NetworkSetting *Ipv6setting `json:"v6_network_setting,omitempty"`

	// Determines if NIC failover is enabled or not.
	NicFailoverEnabled bool `json:"nic_failover_enabled,omitempty"`

	// Prefer LAN1 when available.
	NicFailoverEnablePrimary bool `json:"nic_failover_enable_primary,omitempty"`

	// Default route failover for LAN1 and LAN2.
	DefaultRouteFailoverEnabled bool `json:"default_route_failover_enabled,omitempty"`
}

// Lanhaportsetting represents Infoblox struct lanhaportsetting
type Lanhaportsetting struct {
	// Public IPv4 address for the LAN1 interface.
	MgmtLan string `json:"mgmt_lan,omitempty"`

	// Public IPv6 address for the LAN1 interface.
	MgmtIpv6addr string `json:"mgmt_ipv6addr,omitempty"`

	// HA IP address.
	HaIpAddress string `json:"ha_ip_address,omitempty"`

	// Physical port settings for the LAN interface.
	LanPortSetting *Physicalportsetting `json:"lan_port_setting,omitempty"`

	// Physical port settings for the HA interface.
	HaPortSetting *Physicalportsetting `json:"ha_port_setting,omitempty"`
}

// LdapEamapping represents Infoblox struct ldap_eamapping
type LdapEamapping struct {
	// The LDAP attribute name.
	Name string `json:"name,omitempty"`

	// The name of the extensible attribute definition object to which the LDAP
	// attribute is mapped.
	MappedEa string `json:"mapped_ea,omitempty"`
}

// LdapServer represents Infoblox struct ldap_server
type LdapServer struct {
	// The IP address or FQDN of the LDAP server.
	Address string `json:"address,omitempty"`

	// The authentication type for the LDAP server.
	AuthenticationType string `json:"authentication_type,omitempty"`

	// The base DN for the LDAP server.
	BaseDn string `json:"base_dn,omitempty"`

	// The user password for authentication.
	BindPassword string `json:"bind_password,omitempty"`

	// The user DN for authentication.
	BindUserDn string `json:"bind_user_dn,omitempty"`

	// The LDAP descriptive comment.
	Comment string `json:"comment,omitempty"`

	// Determines if the LDAP server is disabled.
	Disable bool `json:"disable,omitempty"`

	// The LDAP server encryption type.
	Encryption string `json:"encryption,omitempty"`

	// The LDAP server port.
	Port uint32 `json:"port,omitempty"`

	// Determines if the connection via the MGMT interface is allowed.
	UseMgmtPort bool `json:"use_mgmt_port,omitempty"`

	// The LDAP server version.
	Version string `json:"version,omitempty"`
}

// Logicfilterrule represents Infoblox struct logicfilterrule
type Logicfilterrule struct {
	// The filter name.
	Filter string `json:"filter,omitempty"`

	// The filter type. Valid values are: * MAC * NAC * Option
	Type string `json:"type,omitempty"`
}

// Lomnetworkconfig represents Infoblox struct lomnetworkconfig
type Lomnetworkconfig struct {
	// The IPv4 Address of the Grid member.
	Address string `json:"address,omitempty"`

	// The default gateway for the Grid member.
	Gateway string `json:"gateway,omitempty"`

	// The subnet mask for the Grid member.
	SubnetMask string `json:"subnet_mask,omitempty"`

	// Determines if the physical node supports LOM or not.
	IsLomCapable bool `json:"is_lom_capable,omitempty"`
}

// Lomuser represents Infoblox struct lomuser
type Lomuser struct {
	// The LOM user name.
	Name string `json:"name,omitempty"`

	// The LOM user password.
	Password string `json:"password,omitempty"`

	// The LOM user role which specifies the list of actions that are allowed for
	// the user.
	Role string `json:"role,omitempty"`

	// Determines whether the LOM user is disabled.
	Disable bool `json:"disable,omitempty"`

	// The descriptive comment for the LOM user.
	Comment string `json:"comment,omitempty"`
}

// MemberCspmembersetting represents Infoblox struct member:cspmembersetting
type MemberCspmembersetting struct {
	// Overrides grid join token
	UseCspJoinToken bool `json:"use_csp_join_token,omitempty"`

	// Overrides CSP DNS Resolver
	UseCspDnsResolver bool `json:"use_csp_dns_resolver,omitempty"`

	// Overrides grid https proxy
	UseCspHttpsProxy bool `json:"use_csp_https_proxy,omitempty"`

	// Join token required to connect to a cluster
	CspJoinToken string `json:"csp_join_token,omitempty"`

	// IP address of DNS resolver in DFP
	CspDnsResolver string `json:"csp_dns_resolver,omitempty"`

	// HTTP Proxy IP address of CSP Portal
	CspHttpsProxy string `json:"csp_https_proxy,omitempty"`
}

// MemberDnsgluerecordaddr represents Infoblox struct member:dnsgluerecordaddr
type MemberDnsgluerecordaddr struct {
	// Determines if empty view with recursion enabled will be written into the
	// conf file.
	AttachEmptyRecursiveView bool `json:"attach_empty_recursive_view,omitempty"`

	// The address the appliance uses to generate the glue record.
	GlueRecordAddress string `json:"glue_record_address,omitempty"`

	// The name of the DNS View in which the record resides. Example: "external".
	View string `json:"view,omitempty"`

	// The address choice for auto-created glue records for this view.
	GlueAddressChoice string `json:"glue_address_choice,omitempty"`
}

// MemberDnsip represents Infoblox struct member:dnsip
type MemberDnsip struct {
	// The additional IP address of the member.
	IpAddress string `json:"ip_address,omitempty"`
}

// MemberNtp represents Infoblox struct member:ntp
type MemberNtp struct {
	// Determines whether the NTP service is enabled on the member.
	EnableNTP bool `json:"enable_ntp,omitempty"`

	// The list of NTP servers configured on a member.
	NTPServers []*NTPserver `json:"ntp_servers,omitempty"`

	// The list of NTP authentication keys used to authenticate NTP clients.
	NTPKeys []*Ntpkey `json:"ntp_keys,omitempty"`

	// The NTP access control settings.
	NTPAcl *Ntpaccess `json:"ntp_acl,omitempty"`

	// Determines whether the Kiss-o'-Death packets are enabled or disabled.
	NTPKod bool `json:"ntp_kod,omitempty"`

	// Determines whether the use of the external NTP servers is enabled for the
	// member.
	EnableExternalNtpServers bool `json:"enable_external_ntp_servers,omitempty"`

	// Determines whether the Grid Master is excluded as an NTP server.
	ExcludeGridMasterNtpServer bool `json:"exclude_grid_master_ntp_server,omitempty"`

	// Override Grid level NTP stratum.
	UseLocalNtpStratum bool `json:"use_local_ntp_stratum,omitempty"`

	// Vnode level local NTP stratum.
	LocalNtpStratum uint32 `json:"local_ntp_stratum,omitempty"`

	// Vnode level default stratum.
	UseDefaultStratum bool `json:"use_default_stratum,omitempty"`

	// Use flag for: ntp_servers
	UseNtpServers bool `json:"use_ntp_servers,omitempty"`

	// Use flag for: ntp_keys
	UseNtpKeys bool `json:"use_ntp_keys,omitempty"`

	// Use flag for: ntp_acl
	UseNtpAcl bool `json:"use_ntp_acl,omitempty"`

	// Use flag for: ntp_kod
	UseNtpKod bool `json:"use_ntp_kod,omitempty"`
}

// Memberserver represents Infoblox struct memberserver
type Memberserver struct {
	// The grid member name.
	Name string `json:"name,omitempty"`

	// This flag governs whether the specified Grid member is in stealth mode or
	// not. If set to True, the member is in stealth mode. This flag is ignored if
	// the struct is specified as part of a stub zone.
	Stealth bool `json:"stealth,omitempty"`

	// The flag represents DNS zone transfers if set to True, and ID Grid
	// Replication if set to False. This flag is ignored if the struct is specified
	// as part of a stub zone or if it is set as grid_member in an authoritative
	// zone.
	GridReplicate bool `json:"grid_replicate,omitempty"`

	// This flag controls whether the Grid lead secondary server performs zone
	// transfers to non lead secondaries. This flag is ignored if the struct is
	// specified as grid_member in an authoritative zone.
	Lead bool `json:"lead,omitempty"`

	// The primary preference list with Grid member names and\or External Server
	// extserver structs for this member.
	PreferredPrimaries []NameServer `json:"preferred_primaries,omitempty"`

	// This flag represents whether the preferred_primaries field values of this
	// member are used.
	EnablePreferredPrimaries bool `json:"enable_preferred_primaries,omitempty"`
}

// Memberservicecommunication represents Infoblox struct memberservicecommunication
type Memberservicecommunication struct {
	// The service for a Grid member.
	Service string `json:"service,omitempty"`

	// Communication type.
	Type string `json:"type,omitempty"`

	// The option for communication type.
	Option string `json:"option,omitempty"`
}

// Memberservicestatus represents Infoblox struct memberservicestatus
type Memberservicestatus struct {
	// The description of the current service status.
	Description string `json:"description,omitempty"`

	// The service status.
	Status string `json:"status,omitempty"`

	// The service identifier.
	Service string `json:"service,omitempty"`
}

// Mgmtportsetting represents Infoblox struct mgmtportsetting
type Mgmtportsetting struct {
	// Determines if MGMT port settings should be enabled.
	Enabled bool `json:"enabled,omitempty"`

	// Determines if VPN on the MGMT port is enabled or not.
	VpnEnabled bool `json:"vpn_enabled,omitempty"`

	// Determines if security access on the MGMT port is enabled or not.
	SecurityAccessEnabled bool `json:"security_access_enabled,omitempty"`
}

// Monitoreddomains represents Infoblox struct monitoreddomains
type Monitoreddomains struct {
	// Domain name (FQDN to Query).
	DomainName string `json:"domain_name,omitempty"`

	// Record type(record to query).
	RecordType string `json:"record_type,omitempty"`
}

// Msdhcpoption represents Infoblox struct msdhcpoption
type Msdhcpoption struct {
	// The code of the DHCP option.
	Num uint32 `json:"num,omitempty"`

	// Value of the DHCP option.
	Value string `json:"value,omitempty"`

	// The name of the DHCP option.
	Name string `json:"name,omitempty"`

	// The name of the vendor class with which this DHCP option is associated.
	VendorClass string `json:"vendor_class,omitempty"`

	// The name of the user class with which this DHCP option is associated.
	UserClass string `json:"user_class,omitempty"`

	// The DHCP option type. Valid values are: * "16-bit signed integer" * "16-bit
	// unsigned integer" * "32-bit signed integer" * "32-bit unsigned integer" *
	// "64-bit unsigned integer" * "8-bit signed integer" * "8-bit unsigned integer
	// (1,2,4,8)" * "8-bit unsigned integer" * "array of 16-bit integer" * "array
	// of 16-bit unsigned integer" * "array of 32-bit integer" * "array of 32-bit
	// unsigned integer" * "array of 64-bit unsigned integer" * "array of 8-bit
	// integer" * "array of 8-bit unsigned integer" * "array of ip-address pair" *
	// "array of ip-address" * "array of string" * "binary" * "boolean array of
	// ip-address" * "boolean" * "boolean-text" * "domain-list" * "domain-name" *
	// "encapsulated" * "ip-address" * "string" * "text"
	Type string `json:"type,omitempty"`
}

// Msdhcpserver represents Infoblox struct msdhcpserver
type Msdhcpserver struct {
	// The IPv4 Address or FQDN of the Microsoft server.
	Ipv4Addr string `json:"ipv4addr,omitempty"`
}

// Msdnsserver represents Infoblox struct msdnsserver
type Msdnsserver struct {
	// The address of the server.
	Address string `json:"address,omitempty"`

	// This flag indicates if this server is a synchronization master.
	IsMaster bool `json:"is_master,omitempty"`

	// This address is used when generating the NS record in the zone, which can be
	// different in case of multihomed hosts.
	NsIp string `json:"ns_ip,omitempty"`

	// This name is used when generating the NS record in the zone, which can be
	// different in case of multihomed hosts.
	NsName string `json:"ns_name,omitempty"`

	// Set this flag to hide the NS record for the primary name server from DNS
	// queries.
	Stealth bool `json:"stealth,omitempty"`

	// This flag represents whether the name server is shared with the parent
	// Microsoft primary zone's delegation server.
	SharedWithMsParentDelegation bool `json:"shared_with_ms_parent_delegation,omitempty"`
}

// MsserverAduser represents Infoblox struct msserver:aduser
type MsserverAduser struct {
	// The login name of the Microsoft Server.
	LoginName string `json:"login_name,omitempty"`

	// The login password of the DHCP Microsoft Server.
	LoginPassword string `json:"login_password,omitempty"`

	// Determines whether the Active Directory user synchronization is enabled or
	// not.
	EnableUserSync bool `json:"enable_user_sync,omitempty"`

	// The minimum number of minutes between two synchronizations.
	SynchronizationInterval uint32 `json:"synchronization_interval,omitempty"`

	// Timestamp of the last synchronization attempt.
	LastSyncTime *UnixTime `json:"last_sync_time,omitempty"`

	// The status of the last synchronization attempt.
	LastSyncStatus string `json:"last_sync_status,omitempty"`

	// The detailed status of the last synchronization attempt.
	LastSyncDetail string `json:"last_sync_detail,omitempty"`

	// Timestamp of the last successful synchronization attempt.
	LastSuccessSyncTime *UnixTime `json:"last_success_sync_time,omitempty"`

	// Flag to override login name and password from MS server
	UseLogin bool `json:"use_login,omitempty"`

	// Flag to override AD User sync from grid level
	UseEnableAdUserSync bool `json:"use_enable_ad_user_sync,omitempty"`

	// Flag to override synchronization interval from the MS Server
	UseSynchronizationMinDelay bool `json:"use_synchronization_min_delay,omitempty"`

	// Use flag for: enable_user_sync
	UseEnableUserSync bool `json:"use_enable_user_sync,omitempty"`

	// Use flag for: synchronization_interval
	UseSynchronizationInterval bool `json:"use_synchronization_interval,omitempty"`
}

// MsserverAduserData represents Infoblox struct msserver:aduser:data
type MsserverAduserData struct {
	// The number of active users.
	ActiveUsersCount uint32 `json:"active_users_count,omitempty"`
}

// MsserverDcnsrecordcreation represents Infoblox struct msserver:dcnsrecordcreation
type MsserverDcnsrecordcreation struct {
	// The IPv4 address of the domain controller that is allowed to create NS
	// records.
	Address string `json:"address,omitempty"`

	// Optional user comment.
	Comment string `json:"comment,omitempty"`
}

// Natsetting represents Infoblox struct natsetting
type Natsetting struct {
	// Determines if NAT should be enabled.
	Enabled bool `json:"enabled,omitempty"`

	// External IP address for NAT.
	ExternalVirtualIp string `json:"external_virtual_ip,omitempty"`

	// The NAT group.
	Group string `json:"group,omitempty"`
}

// NetworkviewAssocmember represents Infoblox struct networkview:assocmember
type NetworkviewAssocmember struct {
	// The member object associated with a network view.
	Member string `json:"member,omitempty"`

	// The list of failover objects associated with each member.
	Failovers []string `json:"failovers,omitempty"`
}

// Nodeinfo represents Infoblox struct nodeinfo
type Nodeinfo struct {
	// The service status list of the Grid Member.
	ServiceStatus []*Servicestatus `json:"service_status,omitempty"`

	// The OID of the physical node.
	PhysicalOid string `json:"physical_oid,omitempty"`

	// Status about the node of an HA pair.
	HaStatus string `json:"ha_status,omitempty"`

	// The platform on which NIOS is running on.
	Hwplatform string `json:"hwplatform,omitempty"`

	// Hardware ID.
	Hwid string `json:"hwid,omitempty"`

	// Hardware model.
	Hwmodel string `json:"hwmodel,omitempty"`

	// Hardware type.
	Hwtype string `json:"hwtype,omitempty"`

	// True if node is Paid NIOS.
	PaidNios bool `json:"paid_nios,omitempty"`

	// Network settings for the MGMT port of the node.
	MgmtNetworkSetting *SettingNetwork `json:"mgmt_network_setting,omitempty"`

	// LAN/HA port settings for the node.
	LanHaPortSetting *Lanhaportsetting `json:"lan_ha_port_setting,omitempty"`

	// Physical port settings for the MGMT interface.
	MgmtPhysicalSetting *Physicalportsetting `json:"mgmt_physical_setting,omitempty"`

	// Physical port settings for the LAN2 interface.
	Lan2PhysicalSetting *Physicalportsetting `json:"lan2_physical_setting,omitempty"`

	// The NAT external IP address for the node.
	NatExternalIp string `json:"nat_external_ip,omitempty"`

	// The network settings for the IPv6 MGMT port of the node.
	V6MgmtNetworkSetting *Ipv6setting `json:"v6_mgmt_network_setting,omitempty"`
}

// NotificationRestTemplateinstance represents Infoblox struct notification:rest:templateinstance
type NotificationRestTemplateinstance struct {
	// The name of the REST API template parameter.
	Template string `json:"template,omitempty"`

	// The notification REST template parameters.
	Parameters []*NotificationRestTemplateparameter `json:"parameters,omitempty"`
}

// NotificationRestTemplateparameter represents Infoblox struct notification:rest:templateparameter
type NotificationRestTemplateparameter struct {
	// The name of the REST API template parameter.
	Name string `json:"name,omitempty"`

	// The value of the REST API template parameter.
	Value string `json:"value,omitempty"`

	// The default value of the REST API template parameter.
	DefaultValue string `json:"default_value,omitempty"`

	// The syntax of the REST API template parameter.
	Syntax string `json:"syntax,omitempty"`
}

// NotificationRuleexpressionop represents Infoblox struct notification:ruleexpressionop
type NotificationRuleexpressionop struct {
	// Rule expression type.
	Op string `json:"op,omitempty"`

	// Rule expression first operand value.
	Op1 string `json:"op1,omitempty"`

	// Rule expression fi