#ifdef GET_MIMGBaseOpcode_DECL
enum MIMGBaseOpcode {
  IMAGE_ATOMIC_ADD = 0,
  IMAGE_ATOMIC_ADD_FLT = 1,
  IMAGE_ATOMIC_AND = 2,
  IMAGE_ATOMIC_CMPSWAP = 3,
  IMAGE_ATOMIC_DEC = 4,
  IMAGE_ATOMIC_FCMPSWAP = 5,
  IMAGE_ATOMIC_FMAX = 6,
  IMAGE_ATOMIC_FMIN = 7,
  IMAGE_ATOMIC_INC = 8,
  IMAGE_ATOMIC_MAX_FLT = 9,
  IMAGE_ATOMIC_MIN_FLT = 10,
  IMAGE_ATOMIC_OR = 11,
  IMAGE_ATOMIC_PK_ADD_BF16 = 12,
  IMAGE_ATOMIC_PK_ADD_F16 = 13,
  IMAGE_ATOMIC_RSUB = 14,
  IMAGE_ATOMIC_SMAX = 15,
  IMAGE_ATOMIC_SMIN = 16,
  IMAGE_ATOMIC_SUB = 17,
  IMAGE_ATOMIC_SWAP = 18,
  IMAGE_ATOMIC_UMAX = 19,
  IMAGE_ATOMIC_UMIN = 20,
  IMAGE_ATOMIC_XOR = 21,
  IMAGE_BVH64_INTERSECT_RAY = 22,
  IMAGE_BVH64_INTERSECT_RAY_a16 = 23,
  IMAGE_BVH8_INTERSECT_RAY = 24,
  IMAGE_BVH_DUAL_INTERSECT_RAY = 25,
  IMAGE_BVH_INTERSECT_RAY = 26,
  IMAGE_BVH_INTERSECT_RAY_a16 = 27,
  IMAGE_GATHER4 = 28,
  IMAGE_GATHER4H = 29,
  IMAGE_GATHER4_B = 30,
  IMAGE_GATHER4_B_CL = 31,
  IMAGE_GATHER4_B_CL_O = 32,
  IMAGE_GATHER4_B_O = 33,
  IMAGE_GATHER4_C = 34,
  IMAGE_GATHER4_CL = 35,
  IMAGE_GATHER4_CL_O = 36,
  IMAGE_GATHER4_C_B = 37,
  IMAGE_GATHER4_C_B_CL = 38,
  IMAGE_GATHER4_C_B_CL_O = 39,
  IMAGE_GATHER4_C_B_O = 40,
  IMAGE_GATHER4_C_CL = 41,
  IMAGE_GATHER4_C_CL_O = 42,
  IMAGE_GATHER4_C_L = 43,
  IMAGE_GATHER4_C_LZ = 44,
  IMAGE_GATHER4_C_LZ_O = 45,
  IMAGE_GATHER4_C_L_O = 46,
  IMAGE_GATHER4_C_O = 47,
  IMAGE_GATHER4_L = 48,
  IMAGE_GATHER4_LZ = 49,
  IMAGE_GATHER4_LZ_O = 50,
  IMAGE_GATHER4_L_O = 51,
  IMAGE_GATHER4_O = 52,
  IMAGE_GET_LOD = 53,
  IMAGE_GET_RESINFO = 54,
  IMAGE_LOAD = 55,
  IMAGE_LOAD_MIP = 56,
  IMAGE_LOAD_MIP_PCK = 57,
  IMAGE_LOAD_MIP_PCK_SGN = 58,
  IMAGE_LOAD_PCK = 59,
  IMAGE_LOAD_PCK_SGN = 60,
  IMAGE_MSAA_LOAD = 61,
  IMAGE_MSAA_LOAD_X = 62,
  IMAGE_SAMPLE = 63,
  IMAGE_SAMPLE_B = 64,
  IMAGE_SAMPLE_B_CL = 65,
  IMAGE_SAMPLE_B_CL_O = 66,
  IMAGE_SAMPLE_B_CL_O_nortn = 67,
  IMAGE_SAMPLE_B_CL_nortn = 68,
  IMAGE_SAMPLE_B_O = 69,
  IMAGE_SAMPLE_B_O_nortn = 70,
  IMAGE_SAMPLE_B_nortn = 71,
  IMAGE_SAMPLE_C = 72,
  IMAGE_SAMPLE_CD = 73,
  IMAGE_SAMPLE_CD_CL = 74,
  IMAGE_SAMPLE_CD_CL_G16 = 75,
  IMAGE_SAMPLE_CD_CL_G16_nortn = 76,
  IMAGE_SAMPLE_CD_CL_O = 77,
  IMAGE_SAMPLE_CD_CL_O_G16 = 78,
  IMAGE_SAMPLE_CD_CL_O_G16_nortn = 79,
  IMAGE_SAMPLE_CD_CL_O_nortn = 80,
  IMAGE_SAMPLE_CD_CL_nortn = 81,
  IMAGE_SAMPLE_CD_G16 = 82,
  IMAGE_SAMPLE_CD_G16_nortn = 83,
  IMAGE_SAMPLE_CD_O = 84,
  IMAGE_SAMPLE_CD_O_G16 = 85,
  IMAGE_SAMPLE_CD_O_G16_nortn = 86,
  IMAGE_SAMPLE_CD_O_nortn = 87,
  IMAGE_SAMPLE_CD_nortn = 88,
  IMAGE_SAMPLE_CL = 89,
  IMAGE_SAMPLE_CL_O = 90,
  IMAGE_SAMPLE_CL_O_nortn = 91,
  IMAGE_SAMPLE_CL_nortn = 92,
  IMAGE_SAMPLE_C_B = 93,
  IMAGE_SAMPLE_C_B_CL = 94,
  IMAGE_SAMPLE_C_B_CL_O = 95,
  IMAGE_SAMPLE_C_B_CL_O_nortn = 96,
  IMAGE_SAMPLE_C_B_CL_nortn = 97,
  IMAGE_SAMPLE_C_B_O = 98,
  IMAGE_SAMPLE_C_B_O_nortn = 99,
  IMAGE_SAMPLE_C_B_nortn = 100,
  IMAGE_SAMPLE_C_CD = 101,
  IMAGE_SAMPLE_C_CD_CL = 102,
  IMAGE_SAMPLE_C_CD_CL_G16 = 103,
  IMAGE_SAMPLE_C_CD_CL_G16_nortn = 104,
  IMAGE_SAMPLE_C_CD_CL_O = 105,
  IMAGE_SAMPLE_C_CD_CL_O_G16 = 106,
  IMAGE_SAMPLE_C_CD_CL_O_G16_nortn = 107,
  IMAGE_SAMPLE_C_CD_CL_O_nortn = 108,
  IMAGE_SAMPLE_C_CD_CL_nortn = 109,
  IMAGE_SAMPLE_C_CD_G16 = 110,
  IMAGE_SAMPLE_C_CD_G16_nortn = 111,
  IMAGE_SAMPLE_C_CD_O = 112,
  IMAGE_SAMPLE_C_CD_O_G16 = 113,
  IMAGE_SAMPLE_C_CD_O_G16_nortn = 114,
  IMAGE_SAMPLE_C_CD_O_nortn = 115,
  IMAGE_SAMPLE_C_CD_nortn = 116,
  IMAGE_SAMPLE_C_CL = 117,
  IMAGE_SAMPLE_C_CL_O = 118,
  IMAGE_SAMPLE_C_CL_O_nortn = 119,
  IMAGE_SAMPLE_C_CL_nortn = 120,
  IMAGE_SAMPLE_C_D = 121,
  IMAGE_SAMPLE_C_D_CL = 122,
  IMAGE_SAMPLE_C_D_CL_G16 = 123,
  IMAGE_SAMPLE_C_D_CL_G16_nortn = 124,
  IMAGE_SAMPLE_C_D_CL_O = 125,
  IMAGE_SAMPLE_C_D_CL_O_G16 = 126,
  IMAGE_SAMPLE_C_D_CL_O_G16_nortn = 127,
  IMAGE_SAMPLE_C_D_CL_O_nortn = 128,
  IMAGE_SAMPLE_C_D_CL_nortn = 129,
  IMAGE_SAMPLE_C_D_G16 = 130,
  IMAGE_SAMPLE_C_D_G16_nortn = 131,
  IMAGE_SAMPLE_C_D_O = 132,
  IMAGE_SAMPLE_C_D_O_G16 = 133,
  IMAGE_SAMPLE_C_D_O_G16_nortn = 134,
  IMAGE_SAMPLE_C_D_O_nortn = 135,
  IMAGE_SAMPLE_C_D_nortn = 136,
  IMAGE_SAMPLE_C_L = 137,
  IMAGE_SAMPLE_C_LZ = 138,
  IMAGE_SAMPLE_C_LZ_O = 139,
  IMAGE_SAMPLE_C_LZ_O_nortn = 140,
  IMAGE_SAMPLE_C_LZ_nortn = 141,
  IMAGE_SAMPLE_C_L_O = 142,
  IMAGE_SAMPLE_C_L_O_nortn = 143,
  IMAGE_SAMPLE_C_L_nortn = 144,
  IMAGE_SAMPLE_C_O = 145,
  IMAGE_SAMPLE_C_O_nortn = 146,
  IMAGE_SAMPLE_C_nortn = 147,
  IMAGE_SAMPLE_D = 148,
  IMAGE_SAMPLE_D_CL = 149,
  IMAGE_SAMPLE_D_CL_G16 = 150,
  IMAGE_SAMPLE_D_CL_G16_nortn = 151,
  IMAGE_SAMPLE_D_CL_O = 152,
  IMAGE_SAMPLE_D_CL_O_G16 = 153,
  IMAGE_SAMPLE_D_CL_O_G16_nortn = 154,
  IMAGE_SAMPLE_D_CL_O_nortn = 155,
  IMAGE_SAMPLE_D_CL_nortn = 156,
  IMAGE_SAMPLE_D_G16 = 157,
  IMAGE_SAMPLE_D_G16_nortn = 158,
  IMAGE_SAMPLE_D_O = 159,
  IMAGE_SAMPLE_D_O_G16 = 160,
  IMAGE_SAMPLE_D_O_G16_nortn = 161,
  IMAGE_SAMPLE_D_O_nortn = 162,
  IMAGE_SAMPLE_D_nortn = 163,
  IMAGE_SAMPLE_L = 164,
  IMAGE_SAMPLE_LZ = 165,
  IMAGE_SAMPLE_LZ_O = 166,
  IMAGE_SAMPLE_LZ_O_nortn = 167,
  IMAGE_SAMPLE_LZ_nortn = 168,
  IMAGE_SAMPLE_L_O = 169,
  IMAGE_SAMPLE_L_O_nortn = 170,
  IMAGE_SAMPLE_L_nortn = 171,
  IMAGE_SAMPLE_O = 172,
  IMAGE_SAMPLE_O_nortn = 173,
  IMAGE_SAMPLE_nortn = 174,
  IMAGE_STORE = 175,
  IMAGE_STORE_MIP = 176,
  IMAGE_STORE_MIP_PCK = 177,
  IMAGE_STORE_PCK = 178,
};
#endif

#ifdef GET_MIMGDim_DECL
enum MIMGDim {
  AMDGPUDim1D = 0,
  AMDGPUDim1DArray = 1,
  AMDGPUDim2D = 2,
  AMDGPUDim2DArray = 3,
  AMDGPUDim2DArrayMsaa = 4,
  AMDGPUDim2DMsaa = 5,
  AMDGPUDim3D = 6,
  AMDGPUDimCube = 7,
};
#endif

#ifdef GET_MIMGEncoding_DECL
enum MIMGEncoding {
  MIMGEncGfx10Default = 0,
  MIMGEncGfx10NSA = 1,
  MIMGEncGfx11Default = 2,
  MIMGEncGfx11NSA = 3,
  MIMGEncGfx12 = 4,
  MIMGEncGfx6 = 5,
  MIMGEncGfx8 = 6,
  MIMGEncGfx90a = 7,
};
#endif

#ifdef GET_WMMAOpcode_DECL
enum WMMAOpcode {
  V_DOT2_F32_BF16 = 0,
  V_DOT2_F32_F16 = 1,
  V_DOT2_I32_I16 = 2,
  V_DOT2_U32_U16 = 3,
  V_DOT4_F32_BF8_BF8 = 4,
  V_DOT4_F32_BF8_FP8 = 5,
  V_DOT4_F32_FP8_BF8 = 6,
  V_DOT4_F32_FP8_FP8 = 7,
  V_DOT4_I32_I8 = 8,
  V_DOT4_I32_IU8 = 9,
  V_DOT4_U32_U8 = 10,
  V_DOT8_I32_I4 = 11,
  V_DOT8_I32_IU4 = 12,
  V_DOT8_U32_U4 = 13,
  V_FMA_MIXHI_BF16 = 14,
  V_FMA_MIXHI_F16 = 15,
  V_FMA_MIXLO_BF16 = 16,
  V_FMA_MIXLO_F16 = 17,
  V_FMA_MIX_F32 = 18,
  V_FMA_MIX_F32_BF16 = 19,
  V_MAD_MIXHI_F16 = 20,
  V_MAD_MIXLO_F16 = 21,
  V_MAD_MIX_F32 = 22,
  V_MFMA_LD_SCALE_B32 = 23,
  V_PK_ADD_BF16 = 24,
  V_PK_ADD_F16 = 25,
  V_PK_ADD_F32 = 26,
  V_PK_ADD_I16 = 27,
  V_PK_ADD_MAX_I16 = 28,
  V_PK_ADD_MAX_U16 = 29,
  V_PK_ADD_MIN_I16 = 30,
  V_PK_ADD_MIN_U16 = 31,
  V_PK_ADD_U16 = 32,
  V_PK_ASHRREV_I16 = 33,
  V_PK_FMA_BF16 = 34,
  V_PK_FMA_F16 = 35,
  V_PK_FMA_F32 = 36,
  V_PK_LSHLREV_B16 = 37,
  V_PK_LSHRREV_B16 = 38,
  V_PK_MAD_I16 = 39,
  V_PK_MAD_U16 = 40,
  V_PK_MAX3_I16 = 41,
  V_PK_MAX3_NUM_F16 = 42,
  V_PK_MAX3_U16 = 43,
  V_PK_MAXIMUM3_F16 = 44,
  V_PK_MAXIMUM_F16 = 45,
  V_PK_MAX_F16 = 46,
  V_PK_MAX_I16 = 47,
  V_PK_MAX_NUM_BF16 = 48,
  V_PK_MAX_U16 = 49,
  V_PK_MIN3_I16 = 50,
  V_PK_MIN3_NUM_F16 = 51,
  V_PK_MIN3_U16 = 52,
  V_PK_MINIMUM3_F16 = 53,
  V_PK_MINIMUM_F16 = 54,
  V_PK_MIN_F16 = 55,
  V_PK_MIN_I16 = 56,
  V_PK_MIN_NUM_BF16 = 57,
  V_PK_MIN_U16 = 58,
  V_PK_MOV_B32 = 59,
  V_PK_MUL_BF16 = 60,
  V_PK_MUL_F16 = 61,
  V_PK_MUL_F32 = 62,
  V_PK_MUL_LO_U16 = 63,
  V_PK_SUB_I16 = 64,
  V_PK_SUB_U16 = 65,
  V_SWMMAC_BF16F32_16X16X64_BF16_w32_twoaddr = 66,
  V_SWMMAC_BF16_16X16X32_BF16_w32_twoaddr = 67,
  V_SWMMAC_BF16_16X16X32_BF16_w64_twoaddr = 68,
  V_SWMMAC_BF16_16X16X64_BF16_w32_twoaddr = 69,
  V_SWMMAC_F16_16X16X128_BF8_BF8_w32_twoaddr = 70,
  V_SWMMAC_F16_16X16X128_BF8_FP8_w32_twoaddr = 71,
  V_SWMMAC_F16_16X16X128_FP8_BF8_w32_twoaddr = 72,
  V_SWMMAC_F16_16X16X128_FP8_FP8_w32_twoaddr = 73,
  V_SWMMAC_F16_16X16X32_F16_w32_twoaddr = 74,
  V_SWMMAC_F16_16X16X32_F16_w64_twoaddr = 75,
  V_SWMMAC_F16_16X16X64_F16_w32_twoaddr = 76,
  V_SWMMAC_F32_16X16X128_BF8_BF8_w32_twoaddr = 77,
  V_SWMMAC_F32_16X16X128_BF8_FP8_w32_twoaddr = 78,
  V_SWMMAC_F32_16X16X128_FP8_BF8_w32_twoaddr = 79,
  V_SWMMAC_F32_16X16X128_FP8_FP8_w32_twoaddr = 80,
  V_SWMMAC_F32_16X16X32_BF16_w32_twoaddr = 81,
  V_SWMMAC_F32_16X16X32_BF16_w64_twoaddr = 82,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w32_twoaddr = 83,
  V_SWMMAC_F32_16X16X32_BF8_BF8_w64_twoaddr = 84,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w32_twoaddr = 85,
  V_SWMMAC_F32_16X16X32_BF8_FP8_w64_twoaddr = 86,
  V_SWMMAC_F32_16X16X32_F16_w32_twoaddr = 87,
  V_SWMMAC_F32_16X16X32_F16_w64_twoaddr = 88,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w32_twoaddr = 89,
  V_SWMMAC_F32_16X16X32_FP8_BF8_w64_twoaddr = 90,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w32_twoaddr = 91,
  V_SWMMAC_F32_16X16X32_FP8_FP8_w64_twoaddr = 92,
  V_SWMMAC_F32_16X16X64_BF16_w32_twoaddr = 93,
  V_SWMMAC_F32_16X16X64_F16_w32_twoaddr = 94,
  V_SWMMAC_I32_16X16X128_IU8_w32_twoaddr = 95,
  V_SWMMAC_I32_16X16X32_IU4_w32_twoaddr = 96,
  V_SWMMAC_I32_16X16X32_IU4_w64_twoaddr = 97,
  V_SWMMAC_I32_16X16X32_IU8_w32_twoaddr = 98,
  V_SWMMAC_I32_16X16X32_IU8_w64_twoaddr = 99,
  V_SWMMAC_I32_16X16X64_IU4_w32_twoaddr = 100,
  V_SWMMAC_I32_16X16X64_IU4_w64_twoaddr = 101,
  V_WMMA_BF16F32_16X16X32_BF16_w32_threeaddr = 102,
  V_WMMA_BF16F32_16X16X32_BF16_w32_twoaddr = 103,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w32 = 104,
  V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w64 = 105,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w32 = 106,
  V_WMMA_BF16_16X16X16_BF16_threeaddr_w64 = 107,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w32 = 108,
  V_WMMA_BF16_16X16X16_BF16_twoaddr_w64 = 109,
  V_WMMA_BF16_16X16X16_BF16_w32_threeaddr = 110,
  V_WMMA_BF16_16X16X16_BF16_w32_twoaddr = 111,
  V_WMMA_BF16_16X16X16_BF16_w64_threeaddr = 112,
  V_WMMA_BF16_16X16X16_BF16_w64_twoaddr = 113,
  V_WMMA_BF16_16X16X32_BF16_w32_threeaddr = 114,
  V_WMMA_BF16_16X16X32_BF16_w32_twoaddr = 115,
  V_WMMA_F16_16X16X128_BF8_BF8_w32_threeaddr = 116,
  V_WMMA_F16_16X16X128_BF8_BF8_w32_twoaddr = 117,
  V_WMMA_F16_16X16X128_BF8_FP8_w32_threeaddr = 118,
  V_WMMA_F16_16X16X128_BF8_FP8_w32_twoaddr = 119,
  V_WMMA_F16_16X16X128_FP8_BF8_w32_threeaddr = 120,
  V_WMMA_F16_16X16X128_FP8_BF8_w32_twoaddr = 121,
  V_WMMA_F16_16X16X128_FP8_FP8_w32_threeaddr = 122,
  V_WMMA_F16_16X16X128_FP8_FP8_w32_twoaddr = 123,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w32 = 124,
  V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w64 = 125,
  V_WMMA_F16_16X16X16_F16_threeaddr_w32 = 126,
  V_WMMA_F16_16X16X16_F16_threeaddr_w64 = 127,
  V_WMMA_F16_16X16X16_F16_twoaddr_w32 = 128,
  V_WMMA_F16_16X16X16_F16_twoaddr_w64 = 129,
  V_WMMA_F16_16X16X16_F16_w32_threeaddr = 130,
  V_WMMA_F16_16X16X16_F16_w32_twoaddr = 131,
  V_WMMA_F16_16X16X16_F16_w64_threeaddr = 132,
  V_WMMA_F16_16X16X16_F16_w64_twoaddr = 133,
  V_WMMA_F16_16X16X32_F16_w32_threeaddr = 134,
  V_WMMA_F16_16X16X32_F16_w32_twoaddr = 135,
  V_WMMA_F16_16X16X64_BF8_BF8_w32_threeaddr = 136,
  V_WMMA_F16_16X16X64_BF8_BF8_w32_twoaddr = 137,
  V_WMMA_F16_16X16X64_BF8_FP8_w32_threeaddr = 138,
  V_WMMA_F16_16X16X64_BF8_FP8_w32_twoaddr = 139,
  V_WMMA_F16_16X16X64_FP8_BF8_w32_threeaddr = 140,
  V_WMMA_F16_16X16X64_FP8_BF8_w32_twoaddr = 141,
  V_WMMA_F16_16X16X64_FP8_FP8_w32_threeaddr = 142,
  V_WMMA_F16_16X16X64_FP8_FP8_w32_twoaddr = 143,
  V_WMMA_F32_16X16X128_BF8_BF8_w32_threeaddr = 144,
  V_WMMA_F32_16X16X128_BF8_BF8_w32_twoaddr = 145,
  V_WMMA_F32_16X16X128_BF8_FP8_w32_threeaddr = 146,
  V_WMMA_F32_16X16X128_BF8_FP8_w32_twoaddr = 147,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr = 148,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr = 149,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr = 150,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr = 151,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr = 152,
  V_WMMA_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr = 153,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr = 154,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr = 155,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr = 156,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr = 157,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr = 158,
  V_WMMA_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr = 159,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr = 160,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr = 161,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr = 162,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr = 163,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr = 164,
  V_WMMA_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr = 165,
  V_WMMA_F32_16X16X128_FP8_BF8_w32_threeaddr = 166,
  V_WMMA_F32_16X16X128_FP8_BF8_w32_twoaddr = 167,
  V_WMMA_F32_16X16X128_FP8_FP8_w32_threeaddr = 168,
  V_WMMA_F32_16X16X128_FP8_FP8_w32_twoaddr = 169,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w32 = 170,
  V_WMMA_F32_16X16X16_BF16_threeaddr_w64 = 171,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w32 = 172,
  V_WMMA_F32_16X16X16_BF16_twoaddr_w64 = 173,
  V_WMMA_F32_16X16X16_BF16_w32_threeaddr = 174,
  V_WMMA_F32_16X16X16_BF16_w32_twoaddr = 175,
  V_WMMA_F32_16X16X16_BF16_w64_threeaddr = 176,
  V_WMMA_F32_16X16X16_BF16_w64_twoaddr = 177,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_threeaddr = 178,
  V_WMMA_F32_16X16X16_BF8_BF8_w32_twoaddr = 179,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_threeaddr = 180,
  V_WMMA_F32_16X16X16_BF8_BF8_w64_twoaddr = 181,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_threeaddr = 182,
  V_WMMA_F32_16X16X16_BF8_FP8_w32_twoaddr = 183,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_threeaddr = 184,
  V_WMMA_F32_16X16X16_BF8_FP8_w64_twoaddr = 185,
  V_WMMA_F32_16X16X16_F16_threeaddr_w32 = 186,
  V_WMMA_F32_16X16X16_F16_threeaddr_w64 = 187,
  V_WMMA_F32_16X16X16_F16_twoaddr_w32 = 188,
  V_WMMA_F32_16X16X16_F16_twoaddr_w64 = 189,
  V_WMMA_F32_16X16X16_F16_w32_threeaddr = 190,
  V_WMMA_F32_16X16X16_F16_w32_twoaddr = 191,
  V_WMMA_F32_16X16X16_F16_w64_threeaddr = 192,
  V_WMMA_F32_16X16X16_F16_w64_twoaddr = 193,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_threeaddr = 194,
  V_WMMA_F32_16X16X16_FP8_BF8_w32_twoaddr = 195,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_threeaddr = 196,
  V_WMMA_F32_16X16X16_FP8_BF8_w64_twoaddr = 197,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_threeaddr = 198,
  V_WMMA_F32_16X16X16_FP8_FP8_w32_twoaddr = 199,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_threeaddr = 200,
  V_WMMA_F32_16X16X16_FP8_FP8_w64_twoaddr = 201,
  V_WMMA_F32_16X16X32_BF16_w32_threeaddr = 202,
  V_WMMA_F32_16X16X32_BF16_w32_twoaddr = 203,
  V_WMMA_F32_16X16X32_F16_w32_threeaddr = 204,
  V_WMMA_F32_16X16X32_F16_w32_twoaddr = 205,
  V_WMMA_F32_16X16X4_F32_w32_threeaddr = 206,
  V_WMMA_F32_16X16X4_F32_w32_twoaddr = 207,
  V_WMMA_F32_16X16X64_BF8_BF8_w32_threeaddr = 208,
  V_WMMA_F32_16X16X64_BF8_BF8_w32_twoaddr = 209,
  V_WMMA_F32_16X16X64_BF8_FP8_w32_threeaddr = 210,
  V_WMMA_F32_16X16X64_BF8_FP8_w32_twoaddr = 211,
  V_WMMA_F32_16X16X64_FP8_BF8_w32_threeaddr = 212,
  V_WMMA_F32_16X16X64_FP8_BF8_w32_twoaddr = 213,
  V_WMMA_F32_16X16X64_FP8_FP8_w32_threeaddr = 214,
  V_WMMA_F32_16X16X64_FP8_FP8_w32_twoaddr = 215,
  V_WMMA_F32_32X16X128_F4_w32_threeaddr = 216,
  V_WMMA_F32_32X16X128_F4_w32_twoaddr = 217,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w32 = 218,
  V_WMMA_I32_16X16X16_IU4_threeaddr_w64 = 219,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w32 = 220,
  V_WMMA_I32_16X16X16_IU4_twoaddr_w64 = 221,
  V_WMMA_I32_16X16X16_IU4_w32_threeaddr = 222,
  V_WMMA_I32_16X16X16_IU4_w32_twoaddr = 223,
  V_WMMA_I32_16X16X16_IU4_w64_threeaddr = 224,
  V_WMMA_I32_16X16X16_IU4_w64_twoaddr = 225,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w32 = 226,
  V_WMMA_I32_16X16X16_IU8_threeaddr_w64 = 227,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w32 = 228,
  V_WMMA_I32_16X16X16_IU8_twoaddr_w64 = 229,
  V_WMMA_I32_16X16X16_IU8_w32_threeaddr = 230,
  V_WMMA_I32_16X16X16_IU8_w32_twoaddr = 231,
  V_WMMA_I32_16X16X16_IU8_w64_threeaddr = 232,
  V_WMMA_I32_16X16X16_IU8_w64_twoaddr = 233,
  V_WMMA_I32_16X16X32_IU4_w32_threeaddr = 234,
  V_WMMA_I32_16X16X32_IU4_w32_twoaddr = 235,
  V_WMMA_I32_16X16X32_IU4_w64_threeaddr = 236,
  V_WMMA_I32_16X16X32_IU4_w64_twoaddr = 237,
  V_WMMA_I32_16X16X64_IU8_w32_threeaddr = 238,
  V_WMMA_I32_16X16X64_IU8_w32_twoaddr = 239,
  V_WMMA_LD_SCALE16_PAIRED_B64 = 240,
  V_WMMA_LD_SCALE_PAIRED_B32 = 241,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr = 242,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr = 243,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr = 244,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr = 245,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr = 246,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr = 247,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr = 248,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr = 249,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr = 250,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr = 251,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr = 252,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr = 253,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr = 254,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr = 255,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr = 256,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr = 257,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr = 258,
  V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr = 259,
  V_WMMA_SCALE16_F32_32X16X128_F4_w32_threeaddr = 260,
  V_WMMA_SCALE16_F32_32X16X128_F4_w32_twoaddr = 261,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr = 262,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr = 263,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr = 264,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr = 265,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr = 266,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr = 267,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr = 268,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr = 269,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr = 270,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr = 271,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr = 272,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr = 273,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr = 274,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr = 275,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr = 276,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr = 277,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr = 278,
  V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr = 279,
  V_WMMA_SCALE_F32_32X16X128_F4_w32_threeaddr = 280,
  V_WMMA_SCALE_F32_32X16X128_F4_w32_twoaddr = 281,
};
#endif

#ifdef GET_AMDGPUImageDMaskIntrinsicTable_DECL
const AMDGPUImageDMaskIntrinsic *getAMDGPUImageDMaskIntrinsic(unsigned Intr);
#endif

#ifdef GET_AMDGPUImageDMaskIntrinsicTable_IMPL
constexpr AMDGPUImageDMaskIntrinsic AMDGPUImageDMaskIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_getlod_1d }, // 0
  { Intrinsic::amdgcn_image_getlod_1darray }, // 1
  { Intrinsic::amdgcn_image_getlod_2d }, // 2
  { Intrinsic::amdgcn_image_getlod_2darray }, // 3
  { Intrinsic::amdgcn_image_getlod_3d }, // 4
  { Intrinsic::amdgcn_image_getlod_cube }, // 5
  { Intrinsic::amdgcn_image_getresinfo_1d }, // 6
  { Intrinsic::amdgcn_image_getresinfo_1darray }, // 7
  { Intrinsic::amdgcn_image_getresinfo_2d }, // 8
  { Intrinsic::amdgcn_image_getresinfo_2darray }, // 9
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa }, // 10
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa }, // 11
  { Intrinsic::amdgcn_image_getresinfo_3d }, // 12
  { Intrinsic::amdgcn_image_getresinfo_cube }, // 13
  { Intrinsic::amdgcn_image_load_1d }, // 14
  { Intrinsic::amdgcn_image_load_1darray }, // 15
  { Intrinsic::amdgcn_image_load_2d }, // 16
  { Intrinsic::amdgcn_image_load_2darray }, // 17
  { Intrinsic::amdgcn_image_load_2darraymsaa }, // 18
  { Intrinsic::amdgcn_image_load_2dmsaa }, // 19
  { Intrinsic::amdgcn_image_load_3d }, // 20
  { Intrinsic::amdgcn_image_load_cube }, // 21
  { Intrinsic::amdgcn_image_load_mip_1d }, // 22
  { Intrinsic::amdgcn_image_load_mip_1darray }, // 23
  { Intrinsic::amdgcn_image_load_mip_2d }, // 24
  { Intrinsic::amdgcn_image_load_mip_2darray }, // 25
  { Intrinsic::amdgcn_image_load_mip_3d }, // 26
  { Intrinsic::amdgcn_image_load_mip_cube }, // 27
  { Intrinsic::amdgcn_image_sample_1d }, // 28
  { Intrinsic::amdgcn_image_sample_1d_nortn }, // 29
  { Intrinsic::amdgcn_image_sample_1darray }, // 30
  { Intrinsic::amdgcn_image_sample_1darray_nortn }, // 31
  { Intrinsic::amdgcn_image_sample_2d }, // 32
  { Intrinsic::amdgcn_image_sample_2d_nortn }, // 33
  { Intrinsic::amdgcn_image_sample_2darray }, // 34
  { Intrinsic::amdgcn_image_sample_2darray_nortn }, // 35
  { Intrinsic::amdgcn_image_sample_3d }, // 36
  { Intrinsic::amdgcn_image_sample_3d_nortn }, // 37
  { Intrinsic::amdgcn_image_sample_b_1d }, // 38
  { Intrinsic::amdgcn_image_sample_b_1d_nortn }, // 39
  { Intrinsic::amdgcn_image_sample_b_1darray }, // 40
  { Intrinsic::amdgcn_image_sample_b_1darray_nortn }, // 41
  { Intrinsic::amdgcn_image_sample_b_2d }, // 42
  { Intrinsic::amdgcn_image_sample_b_2d_nortn }, // 43
  { Intrinsic::amdgcn_image_sample_b_2darray }, // 44
  { Intrinsic::amdgcn_image_sample_b_2darray_nortn }, // 45
  { Intrinsic::amdgcn_image_sample_b_3d }, // 46
  { Intrinsic::amdgcn_image_sample_b_3d_nortn }, // 47
  { Intrinsic::amdgcn_image_sample_b_cl_1d }, // 48
  { Intrinsic::amdgcn_image_sample_b_cl_1d_nortn }, // 49
  { Intrinsic::amdgcn_image_sample_b_cl_1darray }, // 50
  { Intrinsic::amdgcn_image_sample_b_cl_1darray_nortn }, // 51
  { Intrinsic::amdgcn_image_sample_b_cl_2d }, // 52
  { Intrinsic::amdgcn_image_sample_b_cl_2d_nortn }, // 53
  { Intrinsic::amdgcn_image_sample_b_cl_2darray }, // 54
  { Intrinsic::amdgcn_image_sample_b_cl_2darray_nortn }, // 55
  { Intrinsic::amdgcn_image_sample_b_cl_3d }, // 56
  { Intrinsic::amdgcn_image_sample_b_cl_3d_nortn }, // 57
  { Intrinsic::amdgcn_image_sample_b_cl_cube }, // 58
  { Intrinsic::amdgcn_image_sample_b_cl_cube_nortn }, // 59
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d }, // 60
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d_nortn }, // 61
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray }, // 62
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray_nortn }, // 63
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d }, // 64
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d_nortn }, // 65
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray }, // 66
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray_nortn }, // 67
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d }, // 68
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d_nortn }, // 69
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube }, // 70
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube_nortn }, // 71
  { Intrinsic::amdgcn_image_sample_b_cube }, // 72
  { Intrinsic::amdgcn_image_sample_b_cube_nortn }, // 73
  { Intrinsic::amdgcn_image_sample_b_o_1d }, // 74
  { Intrinsic::amdgcn_image_sample_b_o_1d_nortn }, // 75
  { Intrinsic::amdgcn_image_sample_b_o_1darray }, // 76
  { Intrinsic::amdgcn_image_sample_b_o_1darray_nortn }, // 77
  { Intrinsic::amdgcn_image_sample_b_o_2d }, // 78
  { Intrinsic::amdgcn_image_sample_b_o_2d_nortn }, // 79
  { Intrinsic::amdgcn_image_sample_b_o_2darray }, // 80
  { Intrinsic::amdgcn_image_sample_b_o_2darray_nortn }, // 81
  { Intrinsic::amdgcn_image_sample_b_o_3d }, // 82
  { Intrinsic::amdgcn_image_sample_b_o_3d_nortn }, // 83
  { Intrinsic::amdgcn_image_sample_b_o_cube }, // 84
  { Intrinsic::amdgcn_image_sample_b_o_cube_nortn }, // 85
  { Intrinsic::amdgcn_image_sample_c_1d }, // 86
  { Intrinsic::amdgcn_image_sample_c_1d_nortn }, // 87
  { Intrinsic::amdgcn_image_sample_c_1darray }, // 88
  { Intrinsic::amdgcn_image_sample_c_1darray_nortn }, // 89
  { Intrinsic::amdgcn_image_sample_c_2d }, // 90
  { Intrinsic::amdgcn_image_sample_c_2d_nortn }, // 91
  { Intrinsic::amdgcn_image_sample_c_2darray }, // 92
  { Intrinsic::amdgcn_image_sample_c_2darray_nortn }, // 93
  { Intrinsic::amdgcn_image_sample_c_3d }, // 94
  { Intrinsic::amdgcn_image_sample_c_3d_nortn }, // 95
  { Intrinsic::amdgcn_image_sample_c_b_1d }, // 96
  { Intrinsic::amdgcn_image_sample_c_b_1d_nortn }, // 97
  { Intrinsic::amdgcn_image_sample_c_b_1darray }, // 98
  { Intrinsic::amdgcn_image_sample_c_b_1darray_nortn }, // 99
  { Intrinsic::amdgcn_image_sample_c_b_2d }, // 100
  { Intrinsic::amdgcn_image_sample_c_b_2d_nortn }, // 101
  { Intrinsic::amdgcn_image_sample_c_b_2darray }, // 102
  { Intrinsic::amdgcn_image_sample_c_b_2darray_nortn }, // 103
  { Intrinsic::amdgcn_image_sample_c_b_3d }, // 104
  { Intrinsic::amdgcn_image_sample_c_b_3d_nortn }, // 105
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d }, // 106
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d_nortn }, // 107
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray }, // 108
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray_nortn }, // 109
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d }, // 110
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d_nortn }, // 111
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray }, // 112
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray_nortn }, // 113
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d }, // 114
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d_nortn }, // 115
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube }, // 116
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube_nortn }, // 117
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d }, // 118
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d_nortn }, // 119
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray }, // 120
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray_nortn }, // 121
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d }, // 122
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d_nortn }, // 123
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray }, // 124
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray_nortn }, // 125
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d }, // 126
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d_nortn }, // 127
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube }, // 128
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube_nortn }, // 129
  { Intrinsic::amdgcn_image_sample_c_b_cube }, // 130
  { Intrinsic::amdgcn_image_sample_c_b_cube_nortn }, // 131
  { Intrinsic::amdgcn_image_sample_c_b_o_1d }, // 132
  { Intrinsic::amdgcn_image_sample_c_b_o_1d_nortn }, // 133
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray }, // 134
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray_nortn }, // 135
  { Intrinsic::amdgcn_image_sample_c_b_o_2d }, // 136
  { Intrinsic::amdgcn_image_sample_c_b_o_2d_nortn }, // 137
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray }, // 138
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray_nortn }, // 139
  { Intrinsic::amdgcn_image_sample_c_b_o_3d }, // 140
  { Intrinsic::amdgcn_image_sample_c_b_o_3d_nortn }, // 141
  { Intrinsic::amdgcn_image_sample_c_b_o_cube }, // 142
  { Intrinsic::amdgcn_image_sample_c_b_o_cube_nortn }, // 143
  { Intrinsic::amdgcn_image_sample_c_cd_1d }, // 144
  { Intrinsic::amdgcn_image_sample_c_cd_1d_nortn }, // 145
  { Intrinsic::amdgcn_image_sample_c_cd_1darray }, // 146
  { Intrinsic::amdgcn_image_sample_c_cd_1darray_nortn }, // 147
  { Intrinsic::amdgcn_image_sample_c_cd_2d }, // 148
  { Intrinsic::amdgcn_image_sample_c_cd_2d_nortn }, // 149
  { Intrinsic::amdgcn_image_sample_c_cd_2darray }, // 150
  { Intrinsic::amdgcn_image_sample_c_cd_2darray_nortn }, // 151
  { Intrinsic::amdgcn_image_sample_c_cd_3d }, // 152
  { Intrinsic::amdgcn_image_sample_c_cd_3d_nortn }, // 153
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d }, // 154
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d_nortn }, // 155
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray }, // 156
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray_nortn }, // 157
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d }, // 158
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d_nortn }, // 159
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray }, // 160
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray_nortn }, // 161
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d }, // 162
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d_nortn }, // 163
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube }, // 164
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube_nortn }, // 165
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d }, // 166
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d_nortn }, // 167
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray }, // 168
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray_nortn }, // 169
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d }, // 170
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d_nortn }, // 171
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray }, // 172
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray_nortn }, // 173
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d }, // 174
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d_nortn }, // 175
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube }, // 176
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube_nortn }, // 177
  { Intrinsic::amdgcn_image_sample_c_cd_cube }, // 178
  { Intrinsic::amdgcn_image_sample_c_cd_cube_nortn }, // 179
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d }, // 180
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d_nortn }, // 181
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray }, // 182
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray_nortn }, // 183
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d }, // 184
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d_nortn }, // 185
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray }, // 186
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray_nortn }, // 187
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d }, // 188
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d_nortn }, // 189
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube }, // 190
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube_nortn }, // 191
  { Intrinsic::amdgcn_image_sample_c_cl_1d }, // 192
  { Intrinsic::amdgcn_image_sample_c_cl_1d_nortn }, // 193
  { Intrinsic::amdgcn_image_sample_c_cl_1darray }, // 194
  { Intrinsic::amdgcn_image_sample_c_cl_1darray_nortn }, // 195
  { Intrinsic::amdgcn_image_sample_c_cl_2d }, // 196
  { Intrinsic::amdgcn_image_sample_c_cl_2d_nortn }, // 197
  { Intrinsic::amdgcn_image_sample_c_cl_2darray }, // 198
  { Intrinsic::amdgcn_image_sample_c_cl_2darray_nortn }, // 199
  { Intrinsic::amdgcn_image_sample_c_cl_3d }, // 200
  { Intrinsic::amdgcn_image_sample_c_cl_3d_nortn }, // 201
  { Intrinsic::amdgcn_image_sample_c_cl_cube }, // 202
  { Intrinsic::amdgcn_image_sample_c_cl_cube_nortn }, // 203
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d }, // 204
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d_nortn }, // 205
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray }, // 206
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray_nortn }, // 207
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d }, // 208
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d_nortn }, // 209
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray }, // 210
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray_nortn }, // 211
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d }, // 212
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d_nortn }, // 213
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube }, // 214
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube_nortn }, // 215
  { Intrinsic::amdgcn_image_sample_c_cube }, // 216
  { Intrinsic::amdgcn_image_sample_c_cube_nortn }, // 217
  { Intrinsic::amdgcn_image_sample_c_d_1d }, // 218
  { Intrinsic::amdgcn_image_sample_c_d_1d_nortn }, // 219
  { Intrinsic::amdgcn_image_sample_c_d_1darray }, // 220
  { Intrinsic::amdgcn_image_sample_c_d_1darray_nortn }, // 221
  { Intrinsic::amdgcn_image_sample_c_d_2d }, // 222
  { Intrinsic::amdgcn_image_sample_c_d_2d_nortn }, // 223
  { Intrinsic::amdgcn_image_sample_c_d_2darray }, // 224
  { Intrinsic::amdgcn_image_sample_c_d_2darray_nortn }, // 225
  { Intrinsic::amdgcn_image_sample_c_d_3d }, // 226
  { Intrinsic::amdgcn_image_sample_c_d_3d_nortn }, // 227
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d }, // 228
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d_nortn }, // 229
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray }, // 230
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray_nortn }, // 231
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d }, // 232
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d_nortn }, // 233
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray }, // 234
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray_nortn }, // 235
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d }, // 236
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d_nortn }, // 237
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube }, // 238
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube_nortn }, // 239
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d }, // 240
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d_nortn }, // 241
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray }, // 242
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray_nortn }, // 243
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d }, // 244
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d_nortn }, // 245
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray }, // 246
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray_nortn }, // 247
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d }, // 248
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d_nortn }, // 249
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube }, // 250
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube_nortn }, // 251
  { Intrinsic::amdgcn_image_sample_c_d_cube }, // 252
  { Intrinsic::amdgcn_image_sample_c_d_cube_nortn }, // 253
  { Intrinsic::amdgcn_image_sample_c_d_o_1d }, // 254
  { Intrinsic::amdgcn_image_sample_c_d_o_1d_nortn }, // 255
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray }, // 256
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray_nortn }, // 257
  { Intrinsic::amdgcn_image_sample_c_d_o_2d }, // 258
  { Intrinsic::amdgcn_image_sample_c_d_o_2d_nortn }, // 259
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray }, // 260
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray_nortn }, // 261
  { Intrinsic::amdgcn_image_sample_c_d_o_3d }, // 262
  { Intrinsic::amdgcn_image_sample_c_d_o_3d_nortn }, // 263
  { Intrinsic::amdgcn_image_sample_c_d_o_cube }, // 264
  { Intrinsic::amdgcn_image_sample_c_d_o_cube_nortn }, // 265
  { Intrinsic::amdgcn_image_sample_c_l_1d }, // 266
  { Intrinsic::amdgcn_image_sample_c_l_1d_nortn }, // 267
  { Intrinsic::amdgcn_image_sample_c_l_1darray }, // 268
  { Intrinsic::amdgcn_image_sample_c_l_1darray_nortn }, // 269
  { Intrinsic::amdgcn_image_sample_c_l_2d }, // 270
  { Intrinsic::amdgcn_image_sample_c_l_2d_nortn }, // 271
  { Intrinsic::amdgcn_image_sample_c_l_2darray }, // 272
  { Intrinsic::amdgcn_image_sample_c_l_2darray_nortn }, // 273
  { Intrinsic::amdgcn_image_sample_c_l_3d }, // 274
  { Intrinsic::amdgcn_image_sample_c_l_3d_nortn }, // 275
  { Intrinsic::amdgcn_image_sample_c_l_cube }, // 276
  { Intrinsic::amdgcn_image_sample_c_l_cube_nortn }, // 277
  { Intrinsic::amdgcn_image_sample_c_l_o_1d }, // 278
  { Intrinsic::amdgcn_image_sample_c_l_o_1d_nortn }, // 279
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray }, // 280
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray_nortn }, // 281
  { Intrinsic::amdgcn_image_sample_c_l_o_2d }, // 282
  { Intrinsic::amdgcn_image_sample_c_l_o_2d_nortn }, // 283
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray }, // 284
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray_nortn }, // 285
  { Intrinsic::amdgcn_image_sample_c_l_o_3d }, // 286
  { Intrinsic::amdgcn_image_sample_c_l_o_3d_nortn }, // 287
  { Intrinsic::amdgcn_image_sample_c_l_o_cube }, // 288
  { Intrinsic::amdgcn_image_sample_c_l_o_cube_nortn }, // 289
  { Intrinsic::amdgcn_image_sample_c_lz_1d }, // 290
  { Intrinsic::amdgcn_image_sample_c_lz_1d_nortn }, // 291
  { Intrinsic::amdgcn_image_sample_c_lz_1darray }, // 292
  { Intrinsic::amdgcn_image_sample_c_lz_1darray_nortn }, // 293
  { Intrinsic::amdgcn_image_sample_c_lz_2d }, // 294
  { Intrinsic::amdgcn_image_sample_c_lz_2d_nortn }, // 295
  { Intrinsic::amdgcn_image_sample_c_lz_2darray }, // 296
  { Intrinsic::amdgcn_image_sample_c_lz_2darray_nortn }, // 297
  { Intrinsic::amdgcn_image_sample_c_lz_3d }, // 298
  { Intrinsic::amdgcn_image_sample_c_lz_3d_nortn }, // 299
  { Intrinsic::amdgcn_image_sample_c_lz_cube }, // 300
  { Intrinsic::amdgcn_image_sample_c_lz_cube_nortn }, // 301
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d }, // 302
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d_nortn }, // 303
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray }, // 304
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray_nortn }, // 305
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d }, // 306
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d_nortn }, // 307
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray }, // 308
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray_nortn }, // 309
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d }, // 310
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d_nortn }, // 311
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube }, // 312
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube_nortn }, // 313
  { Intrinsic::amdgcn_image_sample_c_o_1d }, // 314
  { Intrinsic::amdgcn_image_sample_c_o_1d_nortn }, // 315
  { Intrinsic::amdgcn_image_sample_c_o_1darray }, // 316
  { Intrinsic::amdgcn_image_sample_c_o_1darray_nortn }, // 317
  { Intrinsic::amdgcn_image_sample_c_o_2d }, // 318
  { Intrinsic::amdgcn_image_sample_c_o_2d_nortn }, // 319
  { Intrinsic::amdgcn_image_sample_c_o_2darray }, // 320
  { Intrinsic::amdgcn_image_sample_c_o_2darray_nortn }, // 321
  { Intrinsic::amdgcn_image_sample_c_o_3d }, // 322
  { Intrinsic::amdgcn_image_sample_c_o_3d_nortn }, // 323
  { Intrinsic::amdgcn_image_sample_c_o_cube }, // 324
  { Intrinsic::amdgcn_image_sample_c_o_cube_nortn }, // 325
  { Intrinsic::amdgcn_image_sample_cd_1d }, // 326
  { Intrinsic::amdgcn_image_sample_cd_1d_nortn }, // 327
  { Intrinsic::amdgcn_image_sample_cd_1darray }, // 328
  { Intrinsic::amdgcn_image_sample_cd_1darray_nortn }, // 329
  { Intrinsic::amdgcn_image_sample_cd_2d }, // 330
  { Intrinsic::amdgcn_image_sample_cd_2d_nortn }, // 331
  { Intrinsic::amdgcn_image_sample_cd_2darray }, // 332
  { Intrinsic::amdgcn_image_sample_cd_2darray_nortn }, // 333
  { Intrinsic::amdgcn_image_sample_cd_3d }, // 334
  { Intrinsic::amdgcn_image_sample_cd_3d_nortn }, // 335
  { Intrinsic::amdgcn_image_sample_cd_cl_1d }, // 336
  { Intrinsic::amdgcn_image_sample_cd_cl_1d_nortn }, // 337
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray }, // 338
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray_nortn }, // 339
  { Intrinsic::amdgcn_image_sample_cd_cl_2d }, // 340
  { Intrinsic::amdgcn_image_sample_cd_cl_2d_nortn }, // 341
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray }, // 342
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray_nortn }, // 343
  { Intrinsic::amdgcn_image_sample_cd_cl_3d }, // 344
  { Intrinsic::amdgcn_image_sample_cd_cl_3d_nortn }, // 345
  { Intrinsic::amdgcn_image_sample_cd_cl_cube }, // 346
  { Intrinsic::amdgcn_image_sample_cd_cl_cube_nortn }, // 347
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d }, // 348
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d_nortn }, // 349
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray }, // 350
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray_nortn }, // 351
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d }, // 352
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d_nortn }, // 353
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray }, // 354
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray_nortn }, // 355
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d }, // 356
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d_nortn }, // 357
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube }, // 358
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube_nortn }, // 359
  { Intrinsic::amdgcn_image_sample_cd_cube }, // 360
  { Intrinsic::amdgcn_image_sample_cd_cube_nortn }, // 361
  { Intrinsic::amdgcn_image_sample_cd_o_1d }, // 362
  { Intrinsic::amdgcn_image_sample_cd_o_1d_nortn }, // 363
  { Intrinsic::amdgcn_image_sample_cd_o_1darray }, // 364
  { Intrinsic::amdgcn_image_sample_cd_o_1darray_nortn }, // 365
  { Intrinsic::amdgcn_image_sample_cd_o_2d }, // 366
  { Intrinsic::amdgcn_image_sample_cd_o_2d_nortn }, // 367
  { Intrinsic::amdgcn_image_sample_cd_o_2darray }, // 368
  { Intrinsic::amdgcn_image_sample_cd_o_2darray_nortn }, // 369
  { Intrinsic::amdgcn_image_sample_cd_o_3d }, // 370
  { Intrinsic::amdgcn_image_sample_cd_o_3d_nortn }, // 371
  { Intrinsic::amdgcn_image_sample_cd_o_cube }, // 372
  { Intrinsic::amdgcn_image_sample_cd_o_cube_nortn }, // 373
  { Intrinsic::amdgcn_image_sample_cl_1d }, // 374
  { Intrinsic::amdgcn_image_sample_cl_1d_nortn }, // 375
  { Intrinsic::amdgcn_image_sample_cl_1darray }, // 376
  { Intrinsic::amdgcn_image_sample_cl_1darray_nortn }, // 377
  { Intrinsic::amdgcn_image_sample_cl_2d }, // 378
  { Intrinsic::amdgcn_image_sample_cl_2d_nortn }, // 379
  { Intrinsic::amdgcn_image_sample_cl_2darray }, // 380
  { Intrinsic::amdgcn_image_sample_cl_2darray_nortn }, // 381
  { Intrinsic::amdgcn_image_sample_cl_3d }, // 382
  { Intrinsic::amdgcn_image_sample_cl_3d_nortn }, // 383
  { Intrinsic::amdgcn_image_sample_cl_cube }, // 384
  { Intrinsic::amdgcn_image_sample_cl_cube_nortn }, // 385
  { Intrinsic::amdgcn_image_sample_cl_o_1d }, // 386
  { Intrinsic::amdgcn_image_sample_cl_o_1d_nortn }, // 387
  { Intrinsic::amdgcn_image_sample_cl_o_1darray }, // 388
  { Intrinsic::amdgcn_image_sample_cl_o_1darray_nortn }, // 389
  { Intrinsic::amdgcn_image_sample_cl_o_2d }, // 390
  { Intrinsic::amdgcn_image_sample_cl_o_2d_nortn }, // 391
  { Intrinsic::amdgcn_image_sample_cl_o_2darray }, // 392
  { Intrinsic::amdgcn_image_sample_cl_o_2darray_nortn }, // 393
  { Intrinsic::amdgcn_image_sample_cl_o_3d }, // 394
  { Intrinsic::amdgcn_image_sample_cl_o_3d_nortn }, // 395
  { Intrinsic::amdgcn_image_sample_cl_o_cube }, // 396
  { Intrinsic::amdgcn_image_sample_cl_o_cube_nortn }, // 397
  { Intrinsic::amdgcn_image_sample_cube }, // 398
  { Intrinsic::amdgcn_image_sample_cube_nortn }, // 399
  { Intrinsic::amdgcn_image_sample_d_1d }, // 400
  { Intrinsic::amdgcn_image_sample_d_1d_nortn }, // 401
  { Intrinsic::amdgcn_image_sample_d_1darray }, // 402
  { Intrinsic::amdgcn_image_sample_d_1darray_nortn }, // 403
  { Intrinsic::amdgcn_image_sample_d_2d }, // 404
  { Intrinsic::amdgcn_image_sample_d_2d_nortn }, // 405
  { Intrinsic::amdgcn_image_sample_d_2darray }, // 406
  { Intrinsic::amdgcn_image_sample_d_2darray_nortn }, // 407
  { Intrinsic::amdgcn_image_sample_d_3d }, // 408
  { Intrinsic::amdgcn_image_sample_d_3d_nortn }, // 409
  { Intrinsic::amdgcn_image_sample_d_cl_1d }, // 410
  { Intrinsic::amdgcn_image_sample_d_cl_1d_nortn }, // 411
  { Intrinsic::amdgcn_image_sample_d_cl_1darray }, // 412
  { Intrinsic::amdgcn_image_sample_d_cl_1darray_nortn }, // 413
  { Intrinsic::amdgcn_image_sample_d_cl_2d }, // 414
  { Intrinsic::amdgcn_image_sample_d_cl_2d_nortn }, // 415
  { Intrinsic::amdgcn_image_sample_d_cl_2darray }, // 416
  { Intrinsic::amdgcn_image_sample_d_cl_2darray_nortn }, // 417
  { Intrinsic::amdgcn_image_sample_d_cl_3d }, // 418
  { Intrinsic::amdgcn_image_sample_d_cl_3d_nortn }, // 419
  { Intrinsic::amdgcn_image_sample_d_cl_cube }, // 420
  { Intrinsic::amdgcn_image_sample_d_cl_cube_nortn }, // 421
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d }, // 422
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d_nortn }, // 423
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray }, // 424
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray_nortn }, // 425
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d }, // 426
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d_nortn }, // 427
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray }, // 428
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray_nortn }, // 429
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d }, // 430
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d_nortn }, // 431
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube }, // 432
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube_nortn }, // 433
  { Intrinsic::amdgcn_image_sample_d_cube }, // 434
  { Intrinsic::amdgcn_image_sample_d_cube_nortn }, // 435
  { Intrinsic::amdgcn_image_sample_d_o_1d }, // 436
  { Intrinsic::amdgcn_image_sample_d_o_1d_nortn }, // 437
  { Intrinsic::amdgcn_image_sample_d_o_1darray }, // 438
  { Intrinsic::amdgcn_image_sample_d_o_1darray_nortn }, // 439
  { Intrinsic::amdgcn_image_sample_d_o_2d }, // 440
  { Intrinsic::amdgcn_image_sample_d_o_2d_nortn }, // 441
  { Intrinsic::amdgcn_image_sample_d_o_2darray }, // 442
  { Intrinsic::amdgcn_image_sample_d_o_2darray_nortn }, // 443
  { Intrinsic::amdgcn_image_sample_d_o_3d }, // 444
  { Intrinsic::amdgcn_image_sample_d_o_3d_nortn }, // 445
  { Intrinsic::amdgcn_image_sample_d_o_cube }, // 446
  { Intrinsic::amdgcn_image_sample_d_o_cube_nortn }, // 447
  { Intrinsic::amdgcn_image_sample_l_1d }, // 448
  { Intrinsic::amdgcn_image_sample_l_1d_nortn }, // 449
  { Intrinsic::amdgcn_image_sample_l_1darray }, // 450
  { Intrinsic::amdgcn_image_sample_l_1darray_nortn }, // 451
  { Intrinsic::amdgcn_image_sample_l_2d }, // 452
  { Intrinsic::amdgcn_image_sample_l_2d_nortn }, // 453
  { Intrinsic::amdgcn_image_sample_l_2darray }, // 454
  { Intrinsic::amdgcn_image_sample_l_2darray_nortn }, // 455
  { Intrinsic::amdgcn_image_sample_l_3d }, // 456
  { Intrinsic::amdgcn_image_sample_l_3d_nortn }, // 457
  { Intrinsic::amdgcn_image_sample_l_cube }, // 458
  { Intrinsic::amdgcn_image_sample_l_cube_nortn }, // 459
  { Intrinsic::amdgcn_image_sample_l_o_1d }, // 460
  { Intrinsic::amdgcn_image_sample_l_o_1d_nortn }, // 461
  { Intrinsic::amdgcn_image_sample_l_o_1darray }, // 462
  { Intrinsic::amdgcn_image_sample_l_o_1darray_nortn }, // 463
  { Intrinsic::amdgcn_image_sample_l_o_2d }, // 464
  { Intrinsic::amdgcn_image_sample_l_o_2d_nortn }, // 465
  { Intrinsic::amdgcn_image_sample_l_o_2darray }, // 466
  { Intrinsic::amdgcn_image_sample_l_o_2darray_nortn }, // 467
  { Intrinsic::amdgcn_image_sample_l_o_3d }, // 468
  { Intrinsic::amdgcn_image_sample_l_o_3d_nortn }, // 469
  { Intrinsic::amdgcn_image_sample_l_o_cube }, // 470
  { Intrinsic::amdgcn_image_sample_l_o_cube_nortn }, // 471
  { Intrinsic::amdgcn_image_sample_lz_1d }, // 472
  { Intrinsic::amdgcn_image_sample_lz_1d_nortn }, // 473
  { Intrinsic::amdgcn_image_sample_lz_1darray }, // 474
  { Intrinsic::amdgcn_image_sample_lz_1darray_nortn }, // 475
  { Intrinsic::amdgcn_image_sample_lz_2d }, // 476
  { Intrinsic::amdgcn_image_sample_lz_2d_nortn }, // 477
  { Intrinsic::amdgcn_image_sample_lz_2darray }, // 478
  { Intrinsic::amdgcn_image_sample_lz_2darray_nortn }, // 479
  { Intrinsic::amdgcn_image_sample_lz_3d }, // 480
  { Intrinsic::amdgcn_image_sample_lz_3d_nortn }, // 481
  { Intrinsic::amdgcn_image_sample_lz_cube }, // 482
  { Intrinsic::amdgcn_image_sample_lz_cube_nortn }, // 483
  { Intrinsic::amdgcn_image_sample_lz_o_1d }, // 484
  { Intrinsic::amdgcn_image_sample_lz_o_1d_nortn }, // 485
  { Intrinsic::amdgcn_image_sample_lz_o_1darray }, // 486
  { Intrinsic::amdgcn_image_sample_lz_o_1darray_nortn }, // 487
  { Intrinsic::amdgcn_image_sample_lz_o_2d }, // 488
  { Intrinsic::amdgcn_image_sample_lz_o_2d_nortn }, // 489
  { Intrinsic::amdgcn_image_sample_lz_o_2darray }, // 490
  { Intrinsic::amdgcn_image_sample_lz_o_2darray_nortn }, // 491
  { Intrinsic::amdgcn_image_sample_lz_o_3d }, // 492
  { Intrinsic::amdgcn_image_sample_lz_o_3d_nortn }, // 493
  { Intrinsic::amdgcn_image_sample_lz_o_cube }, // 494
  { Intrinsic::amdgcn_image_sample_lz_o_cube_nortn }, // 495
  { Intrinsic::amdgcn_image_sample_o_1d }, // 496
  { Intrinsic::amdgcn_image_sample_o_1d_nortn }, // 497
  { Intrinsic::amdgcn_image_sample_o_1darray }, // 498
  { Intrinsic::amdgcn_image_sample_o_1darray_nortn }, // 499
  { Intrinsic::amdgcn_image_sample_o_2d }, // 500
  { Intrinsic::amdgcn_image_sample_o_2d_nortn }, // 501
  { Intrinsic::amdgcn_image_sample_o_2darray }, // 502
  { Intrinsic::amdgcn_image_sample_o_2darray_nortn }, // 503
  { Intrinsic::amdgcn_image_sample_o_3d }, // 504
  { Intrinsic::amdgcn_image_sample_o_3d_nortn }, // 505
  { Intrinsic::amdgcn_image_sample_o_cube }, // 506
  { Intrinsic::amdgcn_image_sample_o_cube_nortn }, // 507
  { Intrinsic::amdgcn_image_store_1d }, // 508
  { Intrinsic::amdgcn_image_store_1darray }, // 509
  { Intrinsic::amdgcn_image_store_2d }, // 510
  { Intrinsic::amdgcn_image_store_2darray }, // 511
  { Intrinsic::amdgcn_image_store_2darraymsaa }, // 512
  { Intrinsic::amdgcn_image_store_2dmsaa }, // 513
  { Intrinsic::amdgcn_image_store_3d }, // 514
  { Intrinsic::amdgcn_image_store_cube }, // 515
  { Intrinsic::amdgcn_image_store_mip_1d }, // 516
  { Intrinsic::amdgcn_image_store_mip_1darray }, // 517
  { Intrinsic::amdgcn_image_store_mip_2d }, // 518
  { Intrinsic::amdgcn_image_store_mip_2darray }, // 519
  { Intrinsic::amdgcn_image_store_mip_3d }, // 520
  { Intrinsic::amdgcn_image_store_mip_cube }, // 521
 };

const AMDGPUImageDMaskIntrinsic *getAMDGPUImageDMaskIntrinsic(unsigned Intr) {
  if ((unsigned)Intr != std::clamp((unsigned)Intr, (unsigned)Intrinsic::amdgcn_image_getlod_1d, (unsigned)Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  struct Comp {
    bool operator()(const AMDGPUImageDMaskIntrinsic &LHS, const KeyType &RHS) const {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(AMDGPUImageDMaskIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_FP4FP8DstByteSelTable_DECL
const FP4FP8DstByteSelInfo *getFP4FP8DstByteSelHelper(unsigned Opcode);
#endif

#ifdef GET_FP4FP8DstByteSelTable_IMPL
constexpr FP4FP8DstByteSelInfo FP4FP8DstByteSelTable[] = {
  { V_ACCVGPR_READ_B32_e64, false, false }, // 0
  { V_ACCVGPR_WRITE_B32_e64, false, false }, // 1
  { V_ADD3_U32_e64, false, false }, // 2
  { V_ADDC_U32_e64, false, false }, // 3
  { V_ADD_CO_U32_e64, false, false }, // 4
  { V_ADD_F16_e64, false, false }, // 5
  { V_ADD_F16_fake16_e64, false, false }, // 6
  { V_ADD_F16_t16_e64, false, false }, // 7
  { V_ADD_F32_e64, false, false }, // 8
  { V_ADD_F64_e64, false, false }, // 9
  { V_ADD_F64_pseudo_e64, false, false }, // 10
  { V_ADD_I16_e64, false, false }, // 11
  { V_ADD_I16_fake16_e64, false, false }, // 12
  { V_ADD_I16_t16_e64, false, false }, // 13
  { V_ADD_I32_e64, false, false }, // 14
  { V_ADD_LSHL_U32_e64, false, false }, // 15
  { V_ADD_MAX_I32_e64, false, false }, // 16
  { V_ADD_MAX_U32_e64, false, false }, // 17
  { V_ADD_MIN_I32_e64, false, false }, // 18
  { V_ADD_MIN_U32_e64, false, false }, // 19
  { V_ADD_NC_U16_e64, false, false }, // 20
  { V_ADD_NC_U16_fake16_e64, false, false }, // 21
  { V_ADD_NC_U16_t16_e64, false, false }, // 22
  { V_ADD_U16_e64, false, false }, // 23
  { V_ADD_U32_e64, false, false }, // 24
  { V_ADD_U64_e64, false, false }, // 25
  { V_ALIGNBIT_B32_e64, false, false }, // 26
  { V_ALIGNBIT_B32_fake16_e64, false, false }, // 27
  { V_ALIGNBIT_B32_opsel_e64, false, false }, // 28
  { V_ALIGNBIT_B32_t16_e64, false, false }, // 29
  { V_ALIGNBYTE_B32_e64, false, false }, // 30
  { V_ALIGNBYTE_B32_fake16_e64, false, false }, // 31
  { V_ALIGNBYTE_B32_opsel_e64, false, false }, // 32
  { V_ALIGNBYTE_B32_t16_e64, false, false }, // 33
  { V_AND_B16_fake16_e64, false, false }, // 34
  { V_AND_B16_t16_e64, false, false }, // 35
  { V_AND_B32_e64, false, false }, // 36
  { V_AND_OR_B32_e64, false, false }, // 37
  { V_ASHRREV_I16_e64, false, false }, // 38
  { V_ASHRREV_I16_fake16_e64, false, false }, // 39
  { V_ASHRREV_I16_opsel_e64, false, false }, // 40
  { V_ASHRREV_I16_t16_e64, false, false }, // 41
  { V_ASHRREV_I32_e64, false, false }, // 42
  { V_ASHRREV_I64_e64, false, false }, // 43
  { V_ASHR_I32_e64, false, false }, // 44
  { V_ASHR_I64_e64, false, false }, // 45
  { V_ASHR_PK_I8_I32_e64, false, false }, // 46
  { V_ASHR_PK_U8_I32_e64, false, false }, // 47
  { V_BCNT_U32_B32_e64, false, false }, // 48
  { V_BFE_I32_e64, false, false }, // 49
  { V_BFE_U32_e64, false, false }, // 50
  { V_BFI_B32_e64, false, false }, // 51
  { V_BFM_B32_e64, false, false }, // 52
  { V_BFREV_B32_e64, false, false }, // 53
  { V_BITOP3_B16_e64, false, false }, // 54
  { V_BITOP3_B16_gfx1250_e64, false, false }, // 55
  { V_BITOP3_B16_gfx1250_fake16_e64, false, false }, // 56
  { V_BITOP3_B16_gfx1250_t16_e64, false, false }, // 57
  { V_BITOP3_B32_e64, false, false }, // 58
  { V_CEIL_F16_e64, false, false }, // 59
  { V_CEIL_F16_fake16_e64, false, false }, // 60
  { V_CEIL_F16_t16_e64, false, false }, // 61
  { V_CEIL_F32_e64, false, false }, // 62
  { V_CEIL_F64_e64, false, false }, // 63
  { V_CLREXCP_e64, false, false }, // 64
  { V_CMPSX_EQ_F32_e64, false, false }, // 65
  { V_CMPSX_EQ_F32_nosdst_e64, false, false }, // 66
  { V_CMPSX_EQ_F64_e64, false, false }, // 67
  { V_CMPSX_EQ_F64_nosdst_e64, false, false }, // 68
  { V_CMPSX_F_F32_e64, false, false }, // 69
  { V_CMPSX_F_F32_nosdst_e64, false, false }, // 70
  { V_CMPSX_F_F64_e64, false, false }, // 71
  { V_CMPSX_F_F64_nosdst_e64, false, false }, // 72
  { V_CMPSX_GE_F32_e64, false, false }, // 73
  { V_CMPSX_GE_F32_nosdst_e64, false, false }, // 74
  { V_CMPSX_GE_F64_e64, false, false }, // 75
  { V_CMPSX_GE_F64_nosdst_e64, false, false }, // 76
  { V_CMPSX_GT_F32_e64, false, false }, // 77
  { V_CMPSX_GT_F32_nosdst_e64, false, false }, // 78
  { V_CMPSX_GT_F64_e64, false, false }, // 79
  { V_CMPSX_GT_F64_nosdst_e64, false, false }, // 80
  { V_CMPSX_LE_F32_e64, false, false }, // 81
  { V_CMPSX_LE_F32_nosdst_e64, false, false }, // 82
  { V_CMPSX_LE_F64_e64, false, false }, // 83
  { V_CMPSX_LE_F64_nosdst_e64, false, false }, // 84
  { V_CMPSX_LG_F32_e64, false, false }, // 85
  { V_CMPSX_LG_F32_nosdst_e64, false, false }, // 86
  { V_CMPSX_LG_F64_e64, false, false }, // 87
  { V_CMPSX_LG_F64_nosdst_e64, false, false }, // 88
  { V_CMPSX_LT_F32_e64, false, false }, // 89
  { V_CMPSX_LT_F32_nosdst_e64, false, false }, // 90
  { V_CMPSX_LT_F64_e64, false, false }, // 91
  { V_CMPSX_LT_F64_nosdst_e64, false, false }, // 92
  { V_CMPSX_NEQ_F32_e64, false, false }, // 93
  { V_CMPSX_NEQ_F32_nosdst_e64, false, false }, // 94
  { V_CMPSX_NEQ_F64_e64, false, false }, // 95
  { V_CMPSX_NEQ_F64_nosdst_e64, false, false }, // 96
  { V_CMPSX_NGE_F32_e64, false, false }, // 97
  { V_CMPSX_NGE_F32_nosdst_e64, false, false }, // 98
  { V_CMPSX_NGE_F64_e64, false, false }, // 99
  { V_CMPSX_NGE_F64_nosdst_e64, false, false }, // 100
  { V_CMPSX_NGT_F32_e64, false, false }, // 101
  { V_CMPSX_NGT_F32_nosdst_e64, false, false }, // 102
  { V_CMPSX_NGT_F64_e64, false, false }, // 103
  { V_CMPSX_NGT_F64_nosdst_e64, false, false }, // 104
  { V_CMPSX_NLE_F32_e64, false, false }, // 105
  { V_CMPSX_NLE_F32_nosdst_e64, false, false }, // 106
  { V_CMPSX_NLE_F64_e64, false, false }, // 107
  { V_CMPSX_NLE_F64_nosdst_e64, false, false }, // 108
  { V_CMPSX_NLG_F32_e64, false, false }, // 109
  { V_CMPSX_NLG_F32_nosdst_e64, false, false }, // 110
  { V_CMPSX_NLG_F64_e64, false, false }, // 111
  { V_CMPSX_NLG_F64_nosdst_e64, false, false }, // 112
  { V_CMPSX_NLT_F32_e64, false, false }, // 113
  { V_CMPSX_NLT_F32_nosdst_e64, false, false }, // 114
  { V_CMPSX_NLT_F64_e64, false, false }, // 115
  { V_CMPSX_NLT_F64_nosdst_e64, false, false }, // 116
  { V_CMPSX_O_F32_e64, false, false }, // 117
  { V_CMPSX_O_F32_nosdst_e64, false, false }, // 118
  { V_CMPSX_O_F64_e64, false, false }, // 119
  { V_CMPSX_O_F64_nosdst_e64, false, false }, // 120
  { V_CMPSX_TRU_F32_e64, false, false }, // 121
  { V_CMPSX_TRU_F32_nosdst_e64, false, false }, // 122
  { V_CMPSX_TRU_F64_e64, false, false }, // 123
  { V_CMPSX_TRU_F64_nosdst_e64, false, false }, // 124
  { V_CMPSX_U_F32_e64, false, false }, // 125
  { V_CMPSX_U_F32_nosdst_e64, false, false }, // 126
  { V_CMPSX_U_F64_e64, false, false }, // 127
  { V_CMPSX_U_F64_nosdst_e64, false, false }, // 128
  { V_CMPS_EQ_F32_e64, false, false }, // 129
  { V_CMPS_EQ_F64_e64, false, false }, // 130
  { V_CMPS_F_F32_e64, false, false }, // 131
  { V_CMPS_F_F64_e64, false, false }, // 132
  { V_CMPS_GE_F32_e64, false, false }, // 133
  { V_CMPS_GE_F64_e64, false, false }, // 134
  { V_CMPS_GT_F32_e64, false, false }, // 135
  { V_CMPS_GT_F64_e64, false, false }, // 136
  { V_CMPS_LE_F32_e64, false, false }, // 137
  { V_CMPS_LE_F64_e64, false, false }, // 138
  { V_CMPS_LG_F32_e64, false, false }, // 139
  { V_CMPS_LG_F64_e64, false, false }, // 140
  { V_CMPS_LT_F32_e64, false, false }, // 141
  { V_CMPS_LT_F64_e64, false, false }, // 142
  { V_CMPS_NEQ_F32_e64, false, false }, // 143
  { V_CMPS_NEQ_F64_e64, false, false }, // 144
  { V_CMPS_NGE_F32_e64, false, false }, // 145
  { V_CMPS_NGE_F64_e64, false, false }, // 146
  { V_CMPS_NGT_F32_e64, false, false }, // 147
  { V_CMPS_NGT_F64_e64, false, false }, // 148
  { V_CMPS_NLE_F32_e64, false, false }, // 149
  { V_CMPS_NLE_F64_e64, false, false }, // 150
  { V_CMPS_NLG_F32_e64, false, false }, // 151
  { V_CMPS_NLG_F64_e64, false, false }, // 152
  { V_CMPS_NLT_F32_e64, false, false }, // 153
  { V_CMPS_NLT_F64_e64, false, false }, // 154
  { V_CMPS_O_F32_e64, false, false }, // 155
  { V_CMPS_O_F64_e64, false, false }, // 156
  { V_CMPS_TRU_F32_e64, false, false }, // 157
  { V_CMPS_TRU_F64_e64, false, false }, // 158
  { V_CMPS_U_F32_e64, false, false }, // 159
  { V_CMPS_U_F64_e64, false, false }, // 160
  { V_CMPX_CLASS_F16_e64, false, false }, // 161
  { V_CMPX_CLASS_F16_fake16_e64, false, false }, // 162
  { V_CMPX_CLASS_F16_fake16_nosdst_e64, false, false }, // 163
  { V_CMPX_CLASS_F16_nosdst_e64, false, false }, // 164
  { V_CMPX_CLASS_F16_t16_e64, false, false }, // 165
  { V_CMPX_CLASS_F16_t16_nosdst_e64, false, false }, // 166
  { V_CMPX_CLASS_F32_e64, false, false }, // 167
  { V_CMPX_CLASS_F32_nosdst_e64, false, false }, // 168
  { V_CMPX_CLASS_F64_e64, false, false }, // 169
  { V_CMPX_CLASS_F64_nosdst_e64, false, false }, // 170
  { V_CMPX_EQ_F16_e64, false, false }, // 171
  { V_CMPX_EQ_F16_fake16_e64, false, false }, // 172
  { V_CMPX_EQ_F16_fake16_nosdst_e64, false, false }, // 173
  { V_CMPX_EQ_F16_nosdst_e64, false, false }, // 174
  { V_CMPX_EQ_F16_t16_e64, false, false }, // 175
  { V_CMPX_EQ_F16_t16_nosdst_e64, false, false }, // 176
  { V_CMPX_EQ_F32_e64, false, false }, // 177
  { V_CMPX_EQ_F32_nosdst_e64, false, false }, // 178
  { V_CMPX_EQ_F64_e64, false, false }, // 179
  { V_CMPX_EQ_F64_nosdst_e64, false, false }, // 180
  { V_CMPX_EQ_I16_e64, false, false }, // 181
  { V_CMPX_EQ_I16_fake16_e64, false, false }, // 182
  { V_CMPX_EQ_I16_fake16_nosdst_e64, false, false }, // 183
  { V_CMPX_EQ_I16_nosdst_e64, false, false }, // 184
  { V_CMPX_EQ_I16_t16_e64, false, false }, // 185
  { V_CMPX_EQ_I16_t16_nosdst_e64, false, false }, // 186
  { V_CMPX_EQ_I32_e64, false, false }, // 187
  { V_CMPX_EQ_I32_nosdst_e64, false, false }, // 188
  { V_CMPX_EQ_I64_e64, false, false }, // 189
  { V_CMPX_EQ_I64_nosdst_e64, false, false }, // 190
  { V_CMPX_EQ_U16_e64, false, false }, // 191
  { V_CMPX_EQ_U16_fake16_e64, false, false }, // 192
  { V_CMPX_EQ_U16_fake16_nosdst_e64, false, false }, // 193
  { V_CMPX_EQ_U16_nosdst_e64, false, false }, // 194
  { V_CMPX_EQ_U16_t16_e64, false, false }, // 195
  { V_CMPX_EQ_U16_t16_nosdst_e64, false, false }, // 196
  { V_CMPX_EQ_U32_e64, false, false }, // 197
  { V_CMPX_EQ_U32_nosdst_e64, false, false }, // 198
  { V_CMPX_EQ_U64_e64, false, false }, // 199
  { V_CMPX_EQ_U64_nosdst_e64, false, false }, // 200
  { V_CMPX_F_F16_e64, false, false }, // 201
  { V_CMPX_F_F16_fake16_e64, false, false }, // 202
  { V_CMPX_F_F16_fake16_nosdst_e64, false, false }, // 203
  { V_CMPX_F_F16_nosdst_e64, false, false }, // 204
  { V_CMPX_F_F16_t16_e64, false, false }, // 205
  { V_CMPX_F_F16_t16_nosdst_e64, false, false }, // 206
  { V_CMPX_F_F32_e64, false, false }, // 207
  { V_CMPX_F_F32_nosdst_e64, false, false }, // 208
  { V_CMPX_F_F64_e64, false, false }, // 209
  { V_CMPX_F_F64_nosdst_e64, false, false }, // 210
  { V_CMPX_F_I16_e64, false, false }, // 211
  { V_CMPX_F_I16_fake16_e64, false, false }, // 212
  { V_CMPX_F_I16_fake16_nosdst_e64, false, false }, // 213
  { V_CMPX_F_I16_nosdst_e64, false, false }, // 214
  { V_CMPX_F_I16_t16_e64, false, false }, // 215
  { V_CMPX_F_I16_t16_nosdst_e64, false, false }, // 216
  { V_CMPX_F_I32_e64, false, false }, // 217
  { V_CMPX_F_I32_nosdst_e64, false, false }, // 218
  { V_CMPX_F_I64_e64, false, false }, // 219
  { V_CMPX_F_I64_nosdst_e64, false, false }, // 220
  { V_CMPX_F_U16_e64, false, false }, // 221
  { V_CMPX_F_U16_fake16_e64, false, false }, // 222
  { V_CMPX_F_U16_fake16_nosdst_e64, false, false }, // 223
  { V_CMPX_F_U16_nosdst_e64, false, false }, // 224
  { V_CMPX_F_U16_t16_e64, false, false }, // 225
  { V_CMPX_F_U16_t16_nosdst_e64, false, false }, // 226
  { V_CMPX_F_U32_e64, false, false }, // 227
  { V_CMPX_F_U32_nosdst_e64, false, false }, // 228
  { V_CMPX_F_U64_e64, false, false }, // 229
  { V_CMPX_F_U64_nosdst_e64, false, false }, // 230
  { V_CMPX_GE_F16_e64, false, false }, // 231
  { V_CMPX_GE_F16_fake16_e64, false, false }, // 232
  { V_CMPX_GE_F16_fake16_nosdst_e64, false, false }, // 233
  { V_CMPX_GE_F16_nosdst_e64, false, false }, // 234
  { V_CMPX_GE_F16_t16_e64, false, false }, // 235
  { V_CMPX_GE_F16_t16_nosdst_e64, false, false }, // 236
  { V_CMPX_GE_F32_e64, false, false }, // 237
  { V_CMPX_GE_F32_nosdst_e64, false, false }, // 238
  { V_CMPX_GE_F64_e64, false, false }, // 239
  { V_CMPX_GE_F64_nosdst_e64, false, false }, // 240
  { V_CMPX_GE_I16_e64, false, false }, // 241
  { V_CMPX_GE_I16_fake16_e64, false, false }, // 242
  { V_CMPX_GE_I16_fake16_nosdst_e64, false, false }, // 243
  { V_CMPX_GE_I16_nosdst_e64, false, false }, // 244
  { V_CMPX_GE_I16_t16_e64, false, false }, // 245
  { V_CMPX_GE_I16_t16_nosdst_e64, false, false }, // 246
  { V_CMPX_GE_I32_e64, false, false }, // 247
  { V_CMPX_GE_I32_nosdst_e64, false, false }, // 248
  { V_CMPX_GE_I64_e64, false, false }, // 249
  { V_CMPX_GE_I64_nosdst_e64, false, false }, // 250
  { V_CMPX_GE_U16_e64, false, false }, // 251
  { V_CMPX_GE_U16_fake16_e64, false, false }, // 252
  { V_CMPX_GE_U16_fake16_nosdst_e64, false, false }, // 253
  { V_CMPX_GE_U16_nosdst_e64, false, false }, // 254
  { V_CMPX_GE_U16_t16_e64, false, false }, // 255
  { V_CMPX_GE_U16_t16_nosdst_e64, false, false }, // 256
  { V_CMPX_GE_U32_e64, false, false }, // 257
  { V_CMPX_GE_U32_nosdst_e64, false, false }, // 258
  { V_CMPX_GE_U64_e64, false, false }, // 259
  { V_CMPX_GE_U64_nosdst_e64, false, false }, // 260
  { V_CMPX_GT_F16_e64, false, false }, // 261
  { V_CMPX_GT_F16_fake16_e64, false, false }, // 262
  { V_CMPX_GT_F16_fake16_nosdst_e64, false, false }, // 263
  { V_CMPX_GT_F16_nosdst_e64, false, false }, // 264
  { V_CMPX_GT_F16_t16_e64, false, false }, // 265
  { V_CMPX_GT_F16_t16_nosdst_e64, false, false }, // 266
  { V_CMPX_GT_F32_e64, false, false }, // 267
  { V_CMPX_GT_F32_nosdst_e64, false, false }, // 268
  { V_CMPX_GT_F64_e64, false, false }, // 269
  { V_CMPX_GT_F64_nosdst_e64, false, false }, // 270
  { V_CMPX_GT_I16_e64, false, false }, // 271
  { V_CMPX_GT_I16_fake16_e64, false, false }, // 272
  { V_CMPX_GT_I16_fake16_nosdst_e64, false, false }, // 273
  { V_CMPX_GT_I16_nosdst_e64, false, false }, // 274
  { V_CMPX_GT_I16_t16_e64, false, false }, // 275
  { V_CMPX_GT_I16_t16_nosdst_e64, false, false }, // 276
  { V_CMPX_GT_I32_e64, false, false }, // 277
  { V_CMPX_GT_I32_nosdst_e64, false, false }, // 278
  { V_CMPX_GT_I64_e64, false, false }, // 279
  { V_CMPX_GT_I64_nosdst_e64, false, false }, // 280
  { V_CMPX_GT_U16_e64, false, false }, // 281
  { V_CMPX_GT_U16_fake16_e64, false, false }, // 282
  { V_CMPX_GT_U16_fake16_nosdst_e64, false, false }, // 283
  { V_CMPX_GT_U16_nosdst_e64, false, false }, // 284
  { V_CMPX_GT_U16_t16_e64, false, false }, // 285
  { V_CMPX_GT_U16_t16_nosdst_e64, false, false }, // 286
  { V_CMPX_GT_U32_e64, false, false }, // 287
  { V_CMPX_GT_U32_nosdst_e64, false, false }, // 288
  { V_CMPX_GT_U64_e64, false, false }, // 289
  { V_CMPX_GT_U64_nosdst_e64, false, false }, // 290
  { V_CMPX_LE_F16_e64, false, false }, // 291
  { V_CMPX_LE_F16_fake16_e64, false, false }, // 292
  { V_CMPX_LE_F16_fake16_nosdst_e64, false, false }, // 293
  { V_CMPX_LE_F16_nosdst_e64, false, false }, // 294
  { V_CMPX_LE_F16_t16_e64, false, false }, // 295
  { V_CMPX_LE_F16_t16_nosdst_e64, false, false }, // 296
  { V_CMPX_LE_F32_e64, false, false }, // 297
  { V_CMPX_LE_F32_nosdst_e64, false, false }, // 298
  { V_CMPX_LE_F64_e64, false, false }, // 299
  { V_CMPX_LE_F64_nosdst_e64, false, false }, // 300
  { V_CMPX_LE_I16_e64, false, false }, // 301
  { V_CMPX_LE_I16_fake16_e64, false, false }, // 302
  { V_CMPX_LE_I16_fake16_nosdst_e64, false, false }, // 303
  { V_CMPX_LE_I16_nosdst_e64, false, false }, // 304
  { V_CMPX_LE_I16_t16_e64, false, false }, // 305
  { V_CMPX_LE_I16_t16_nosdst_e64, false, false }, // 306
  { V_CMPX_LE_I32_e64, false, false }, // 307
  { V_CMPX_LE_I32_nosdst_e64, false, false }, // 308
  { V_CMPX_LE_I64_e64, false, false }, // 309
  { V_CMPX_LE_I64_nosdst_e64, false, false }, // 310
  { V_CMPX_LE_U16_e64, false, false }, // 311
  { V_CMPX_LE_U16_fake16_e64, false, false }, // 312
  { V_CMPX_LE_U16_fake16_nosdst_e64, false, false }, // 313
  { V_CMPX_LE_U16_nosdst_e64, false, false }, // 314
  { V_CMPX_LE_U16_t16_e64, false, false }, // 315
  { V_CMPX_LE_U16_t16_nosdst_e64, false, false }, // 316
  { V_CMPX_LE_U32_e64, false, false }, // 317
  { V_CMPX_LE_U32_nosdst_e64, false, false }, // 318
  { V_CMPX_LE_U64_e64, false, false }, // 319
  { V_CMPX_LE_U64_nosdst_e64, false, false }, // 320
  { V_CMPX_LG_F16_e64, false, false }, // 321
  { V_CMPX_LG_F16_fake16_e64, false, false }, // 322
  { V_CMPX_LG_F16_fake16_nosdst_e64, false, false }, // 323
  { V_CMPX_LG_F16_nosdst_e64, false, false }, // 324
  { V_CMPX_LG_F16_t16_e64, false, false }, // 325
  { V_CMPX_LG_F16_t16_nosdst_e64, false, false }, // 326
  { V_CMPX_LG_F32_e64, false, false }, // 327
  { V_CMPX_LG_F32_nosdst_e64, false, false }, // 328
  { V_CMPX_LG_F64_e64, false, false }, // 329
  { V_CMPX_LG_F64_nosdst_e64, false, false }, // 330
  { V_CMPX_LT_F16_e64, false, false }, // 331
  { V_CMPX_LT_F16_fake16_e64, false, false }, // 332
  { V_CMPX_LT_F16_fake16_nosdst_e64, false, false }, // 333
  { V_CMPX_LT_F16_nosdst_e64, false, false }, // 334
  { V_CMPX_LT_F16_t16_e64, false, false }, // 335
  { V_CMPX_LT_F16_t16_nosdst_e64, false, false }, // 336
  { V_CMPX_LT_F32_e64, false, false }, // 337
  { V_CMPX_LT_F32_nosdst_e64, false, false }, // 338
  { V_CMPX_LT_F64_e64, false, false }, // 339
  { V_CMPX_LT_F64_nosdst_e64, false, false }, // 340
  { V_CMPX_LT_I16_e64, false, false }, // 341
  { V_CMPX_LT_I16_fake16_e64, false, false }, // 342
  { V_CMPX_LT_I16_fake16_nosdst_e64, false, false }, // 343
  { V_CMPX_LT_I16_nosdst_e64, false, false }, // 344
  { V_CMPX_LT_I16_t16_e64, false, false }, // 345
  { V_CMPX_LT_I16_t16_nosdst_e64, false, false }, // 346
  { V_CMPX_LT_I32_e64, false, false }, // 347
  { V_CMPX_LT_I32_nosdst_e64, false, false }, // 348
  { V_CMPX_LT_I64_e64, false, false }, // 349
  { V_CMPX_LT_I64_nosdst_e64, false, false }, // 350
  { V_CMPX_LT_U16_e64, false, false }, // 351
  { V_CMPX_LT_U16_fake16_e64, false, false }, // 352
  { V_CMPX_LT_U16_fake16_nosdst_e64, false, false }, // 353
  { V_CMPX_LT_U16_nosdst_e64, false, false }, // 354
  { V_CMPX_LT_U16_t16_e64, false, false }, // 355
  { V_CMPX_LT_U16_t16_nosdst_e64, false, false }, // 356
  { V_CMPX_LT_U32_e64, false, false }, // 357
  { V_CMPX_LT_U32_nosdst_e64, false, false }, // 358
  { V_CMPX_LT_U64_e64, false, false }, // 359
  { V_CMPX_LT_U64_nosdst_e64, false, false }, // 360
  { V_CMPX_NEQ_F16_e64, false, false }, // 361
  { V_CMPX_NEQ_F16_fake16_e64, false, false }, // 362
  { V_CMPX_NEQ_F16_fake16_nosdst_e64, false, false }, // 363
  { V_CMPX_NEQ_F16_nosdst_e64, false, false }, // 364
  { V_CMPX_NEQ_F16_t16_e64, false, false }, // 365
  { V_CMPX_NEQ_F16_t16_nosdst_e64, false, false }, // 366
  { V_CMPX_NEQ_F32_e64, false, false }, // 367
  { V_CMPX_NEQ_F32_nosdst_e64, false, false }, // 368
  { V_CMPX_NEQ_F64_e64, false, false }, // 369
  { V_CMPX_NEQ_F64_nosdst_e64, false, false }, // 370
  { V_CMPX_NE_I16_e64, false, false }, // 371
  { V_CMPX_NE_I16_fake16_e64, false, false }, // 372
  { V_CMPX_NE_I16_fake16_nosdst_e64, false, false }, // 373
  { V_CMPX_NE_I16_nosdst_e64, false, false }, // 374
  { V_CMPX_NE_I16_t16_e64, false, false }, // 375
  { V_CMPX_NE_I16_t16_nosdst_e64, false, false }, // 376
  { V_CMPX_NE_I32_e64, false, false }, // 377
  { V_CMPX_NE_I32_nosdst_e64, false, false }, // 378
  { V_CMPX_NE_I64_e64, false, false }, // 379
  { V_CMPX_NE_I64_nosdst_e64, false, false }, // 380
  { V_CMPX_NE_U16_e64, false, false }, // 381
  { V_CMPX_NE_U16_fake16_e64, false, false }, // 382
  { V_CMPX_NE_U16_fake16_nosdst_e64, false, false }, // 383
  { V_CMPX_NE_U16_nosdst_e64, false, false }, // 384
  { V_CMPX_NE_U16_t16_e64, false, false }, // 385
  { V_CMPX_NE_U16_t16_nosdst_e64, false, false }, // 386
  { V_CMPX_NE_U32_e64, false, false }, // 387
  { V_CMPX_NE_U32_nosdst_e64, false, false }, // 388
  { V_CMPX_NE_U64_e64, false, false }, // 389
  { V_CMPX_NE_U64_nosdst_e64, false, false }, // 390
  { V_CMPX_NGE_F16_e64, false, false }, // 391
  { V_CMPX_NGE_F16_fake16_e64, false, false }, // 392
  { V_CMPX_NGE_F16_fake16_nosdst_e64, false, false }, // 393
  { V_CMPX_NGE_F16_nosdst_e64, false, false }, // 394
  { V_CMPX_NGE_F16_t16_e64, false, false }, // 395
  { V_CMPX_NGE_F16_t16_nosdst_e64, false, false }, // 396
  { V_CMPX_NGE_F32_e64, false, false }, // 397
  { V_CMPX_NGE_F32_nosdst_e64, false, false }, // 398
  { V_CMPX_NGE_F64_e64, false, false }, // 399
  { V_CMPX_NGE_F64_nosdst_e64, false, false }, // 400
  { V_CMPX_NGT_F16_e64, false, false }, // 401
  { V_CMPX_NGT_F16_fake16_e64, false, false }, // 402
  { V_CMPX_NGT_F16_fake16_nosdst_e64, false, false }, // 403
  { V_CMPX_NGT_F16_nosdst_e64, false, false }, // 404
  { V_CMPX_NGT_F16_t16_e64, false, false }, // 405
  { V_CMPX_NGT_F16_t16_nosdst_e64, false, false }, // 406
  { V_CMPX_NGT_F32_e64, false, false }, // 407
  { V_CMPX_NGT_F32_nosdst_e64, false, false }, // 408
  { V_CMPX_NGT_F64_e64, false, false }, // 409
  { V_CMPX_NGT_F64_nosdst_e64, false, false }, // 410
  { V_CMPX_NLE_F16_e64, false, false }, // 411
  { V_CMPX_NLE_F16_fake16_e64, false, false }, // 412
  { V_CMPX_NLE_F16_fake16_nosdst_e64, false, false }, // 413
  { V_CMPX_NLE_F16_nosdst_e64, false, false }, // 414
  { V_CMPX_NLE_F16_t16_e64, false, false }, // 415
  { V_CMPX_NLE_F16_t16_nosdst_e64, false, false }, // 416
  { V_CMPX_NLE_F32_e64, false, false }, // 417
  { V_CMPX_NLE_F32_nosdst_e64, false, false }, // 418
  { V_CMPX_NLE_F64_e64, false, false }, // 419
  { V_CMPX_NLE_F64_nosdst_e64, false, false }, // 420
  { V_CMPX_NLG_F16_e64, false, false }, // 421
  { V_CMPX_NLG_F16_fake16_e64, false, false }, // 422
  { V_CMPX_NLG_F16_fake16_nosdst_e64, false, false }, // 423
  { V_CMPX_NLG_F16_nosdst_e64, false, false }, // 424
  { V_CMPX_NLG_F16_t16_e64, false, false }, // 425
  { V_CMPX_NLG_F16_t16_nosdst_e64, false, false }, // 426
  { V_CMPX_NLG_F32_e64, false, false }, // 427
  { V_CMPX_NLG_F32_nosdst_e64, false, false }, // 428
  { V_CMPX_NLG_F64_e64, false, false }, // 429
  { V_CMPX_NLG_F64_nosdst_e64, false, false }, // 430
  { V_CMPX_NLT_F16_e64, false, false }, // 431
  { V_CMPX_NLT_F16_fake16_e64, false, false }, // 432
  { V_CMPX_NLT_F16_fake16_nosdst_e64, false, false }, // 433
  { V_CMPX_NLT_F16_nosdst_e64, false, false }, // 434
  { V_CMPX_NLT_F16_t16_e64, false, false }, // 435
  { V_CMPX_NLT_F16_t16_nosdst_e64, false, false }, // 436
  { V_CMPX_NLT_F32_e64, false, false }, // 437
  { V_CMPX_NLT_F32_nosdst_e64, false, false }, // 438
  { V_CMPX_NLT_F64_e64, false, false }, // 439
  { V_CMPX_NLT_F64_nosdst_e64, false, false }, // 440
  { V_CMPX_O_F16_e64, false, false }, // 441
  { V_CMPX_O_F16_fake16_e64, false, false }, // 442
  { V_CMPX_O_F16_fake16_nosdst_e64, false, false }, // 443
  { V_CMPX_O_F16_nosdst_e64, false, false }, // 444
  { V_CMPX_O_F16_t16_e64, false, false }, // 445
  { V_CMPX_O_F16_t16_nosdst_e64, false, false }, // 446
  { V_CMPX_O_F32_e64, false, false }, // 447
  { V_CMPX_O_F32_nosdst_e64, false, false }, // 448
  { V_CMPX_O_F64_e64, false, false }, // 449
  { V_CMPX_O_F64_nosdst_e64, false, false }, // 450
  { V_CMPX_TRU_F16_e64, false, false }, // 451
  { V_CMPX_TRU_F16_fake16_e64, false, false }, // 452
  { V_CMPX_TRU_F16_fake16_nosdst_e64, false, false }, // 453
  { V_CMPX_TRU_F16_nosdst_e64, false, false }, // 454
  { V_CMPX_TRU_F16_t16_e64, false, false }, // 455
  { V_CMPX_TRU_F16_t16_nosdst_e64, false, false }, // 456
  { V_CMPX_TRU_F32_e64, false, false }, // 457
  { V_CMPX_TRU_F32_nosdst_e64, false, false }, // 458
  { V_CMPX_TRU_F64_e64, false, false }, // 459
  { V_CMPX_TRU_F64_nosdst_e64, false, false }, // 460
  { V_CMPX_T_I16_e64, false, false }, // 461
  { V_CMPX_T_I16_fake16_e64, false, false }, // 462
  { V_CMPX_T_I16_fake16_nosdst_e64, false, false }, // 463
  { V_CMPX_T_I16_nosdst_e64, false, false }, // 464
  { V_CMPX_T_I16_t16_e64, false, false }, // 465
  { V_CMPX_T_I16_t16_nosdst_e64, false, false }, // 466
  { V_CMPX_T_I32_e64, false, false }, // 467
  { V_CMPX_T_I32_nosdst_e64, false, false }, // 468
  { V_CMPX_T_I64_e64, false, false }, // 469
  { V_CMPX_T_I64_nosdst_e64, false, false }, // 470
  { V_CMPX_T_U16_e64, false, false }, // 471
  { V_CMPX_T_U16_fake16_e64, false, false }, // 472
  { V_CMPX_T_U16_fake16_nosdst_e64, false, false }, // 473
  { V_CMPX_T_U16_nosdst_e64, false, false }, // 474
  { V_CMPX_T_U16_t16_e64, false, false }, // 475
  { V_CMPX_T_U16_t16_nosdst_e64, false, false }, // 476
  { V_CMPX_T_U32_e64, false, false }, // 477
  { V_CMPX_T_U32_nosdst_e64, false, false }, // 478
  { V_CMPX_T_U64_e64, false, false }, // 479
  { V_CMPX_T_U64_nosdst_e64, false, false }, // 480
  { V_CMPX_U_F16_e64, false, false }, // 481
  { V_CMPX_U_F16_fake16_e64, false, false }, // 482
  { V_CMPX_U_F16_fake16_nosdst_e64, false, false }, // 483
  { V_CMPX_U_F16_nosdst_e64, false, false }, // 484
  { V_CMPX_U_F16_t16_e64, false, false }, // 485
  { V_CMPX_U_F16_t16_nosdst_e64, false, false }, // 486
  { V_CMPX_U_F32_e64, false, false }, // 487
  { V_CMPX_U_F32_nosdst_e64, false, false }, // 488
  { V_CMPX_U_F64_e64, false, false }, // 489
  { V_CMPX_U_F64_nosdst_e64, false, false }, // 490
  { V_CMP_CLASS_F16_e64, false, false }, // 491
  { V_CMP_CLASS_F16_fake16_e64, false, false }, // 492
  { V_CMP_CLASS_F16_t16_e64, false, false }, // 493
  { V_CMP_CLASS_F32_e64, false, false }, // 494
  { V_CMP_CLASS_F64_e64, false, false }, // 495
  { V_CMP_EQ_F16_e64, false, false }, // 496
  { V_CMP_EQ_F16_fake16_e64, false, false }, // 497
  { V_CMP_EQ_F16_t16_e64, false, false }, // 498
  { V_CMP_EQ_F32_e64, false, false }, // 499
  { V_CMP_EQ_F64_e64, false, false }, // 500
  { V_CMP_EQ_I16_e64, false, false }, // 501
  { V_CMP_EQ_I16_fake16_e64, false, false }, // 502
  { V_CMP_EQ_I16_t16_e64, false, false }, // 503
  { V_CMP_EQ_I32_e64, false, false }, // 504
  { V_CMP_EQ_I64_e64, false, false }, // 505
  { V_CMP_EQ_U16_e64, false, false }, // 506
  { V_CMP_EQ_U16_fake16_e64, false, false }, // 507
  { V_CMP_EQ_U16_t16_e64, false, false }, // 508
  { V_CMP_EQ_U32_e64, false, false }, // 509
  { V_CMP_EQ_U64_e64, false, false }, // 510
  { V_CMP_F_F16_e64, false, false }, // 511
  { V_CMP_F_F16_fake16_e64, false, false }, // 512
  { V_CMP_F_F16_t16_e64, false, false }, // 513
  { V_CMP_F_F32_e64, false, false }, // 514
  { V_CMP_F_F64_e64, false, false }, // 515
  { V_CMP_F_I16_e64, false, false }, // 516
  { V_CMP_F_I16_fake16_e64, false, false }, // 517
  { V_CMP_F_I16_t16_e64, false, false }, // 518
  { V_CMP_F_I32_e64, false, false }, // 519
  { V_CMP_F_I64_e64, false, false }, // 520
  { V_CMP_F_U16_e64, false, false }, // 521
  { V_CMP_F_U16_fake16_e64, false, false }, // 522
  { V_CMP_F_U16_t16_e64, false, false }, // 523
  { V_CMP_F_U32_e64, false, false }, // 524
  { V_CMP_F_U64_e64, false, false }, // 525
  { V_CMP_GE_F16_e64, false, false }, // 526
  { V_CMP_GE_F16_fake16_e64, false, false }, // 527
  { V_CMP_GE_F16_t16_e64, false, false }, // 528
  { V_CMP_GE_F32_e64, false, false }, // 529
  { V_CMP_GE_F64_e64, false, false }, // 530
  { V_CMP_GE_I16_e64, false, false }, // 531
  { V_CMP_GE_I16_fake16_e64, false, false }, // 532
  { V_CMP_GE_I16_t16_e64, false, false }, // 533
  { V_CMP_GE_I32_e64, false, false }, // 534
  { V_CMP_GE_I64_e64, false, false }, // 535
  { V_CMP_GE_U16_e64, false, false }, // 536
  { V_CMP_GE_U16_fake16_e64, false, false }, // 537
  { V_CMP_GE_U16_t16_e64, false, false }, // 538
  { V_CMP_GE_U32_e64, false, false }, // 539
  { V_CMP_GE_U64_e64, false, false }, // 540
  { V_CMP_GT_F16_e64, false, false }, // 541
  { V_CMP_GT_F16_fake16_e64, false, false }, // 542
  { V_CMP_GT_F16_t16_e64, false, false }, // 543
  { V_CMP_GT_F32_e64, false, false }, // 544
  { V_CMP_GT_F64_e64, false, false }, // 545
  { V_CMP_GT_I16_e64, false, false }, // 546
  { V_CMP_GT_I16_fake16_e64, false, false }, // 547
  { V_CMP_GT_I16_t16_e64, false, false }, // 548
  { V_CMP_GT_I32_e64, false, false }, // 549
  { V_CMP_GT_I64_e64, false, false }, // 550
  { V_CMP_GT_U16_e64, false, false }, // 551
  { V_CMP_GT_U16_fake16_e64, false, false }, // 552
  { V_CMP_GT_U16_t16_e64, false, false }, // 553
  { V_CMP_GT_U32_e64, false, false }, // 554
  { V_CMP_GT_U64_e64, false, false }, // 555
  { V_CMP_LE_F16_e64, false, false }, // 556
  { V_CMP_LE_F16_fake16_e64, false, false }, // 557
  { V_CMP_LE_F16_t16_e64, false, false }, // 558
  { V_CMP_LE_F32_e64, false, false }, // 559
  { V_CMP_LE_F64_e64, false, false }, // 560
  { V_CMP_LE_I16_e64, false, false }, // 561
  { V_CMP_LE_I16_fake16_e64, false, false }, // 562
  { V_CMP_LE_I16_t16_e64, false, false }, // 563
  { V_CMP_LE_I32_e64, false, false }, // 564
  { V_CMP_LE_I64_e64, false, false }, // 565
  { V_CMP_LE_U16_e64, false, false }, // 566
  { V_CMP_LE_U16_fake16_e64, false, false }, // 567
  { V_CMP_LE_U16_t16_e64, false, false }, // 568
  { V_CMP_LE_U32_e64, false, false }, // 569
  { V_CMP_LE_U64_e64, false, false }, // 570
  { V_CMP_LG_F16_e64, false, false }, // 571
  { V_CMP_LG_F16_fake16_e64, false, false }, // 572
  { V_CMP_LG_F16_t16_e64, false, false }, // 573
  { V_CMP_LG_F32_e64, false, false }, // 574
  { V_CMP_LG_F64_e64, false, false }, // 575
  { V_CMP_LT_F16_e64, false, false }, // 576
  { V_CMP_LT_F16_fake16_e64, false, false }, // 577
  { V_CMP_LT_F16_t16_e64, false, false }, // 578
  { V_CMP_LT_F32_e64, false, false }, // 579
  { V_CMP_LT_F64_e64, false, false }, // 580
  { V_CMP_LT_I16_e64, false, false }, // 581
  { V_CMP_LT_I16_fake16_e64, false, false }, // 582
  { V_CMP_LT_I16_t16_e64, false, false }, // 583
  { V_CMP_LT_I32_e64, false, false }, // 584
  { V_CMP_LT_I64_e64, false, false }, // 585
  { V_CMP_LT_U16_e64, false, false }, // 586
  { V_CMP_LT_U16_fake16_e64, false, false }, // 587
  { V_CMP_LT_U16_t16_e64, false, false }, // 588
  { V_CMP_LT_U32_e64, false, false }, // 589
  { V_CMP_LT_U64_e64, false, false }, // 590
  { V_CMP_NEQ_F16_e64, false, false }, // 591
  { V_CMP_NEQ_F16_fake16_e64, false, false }, // 592
  { V_CMP_NEQ_F16_t16_e64, false, false }, // 593
  { V_CMP_NEQ_F32_e64, false, false }, // 594
  { V_CMP_NEQ_F64_e64, false, false }, // 595
  { V_CMP_NE_I16_e64, false, false }, // 596
  { V_CMP_NE_I16_fake16_e64, false, false }, // 597
  { V_CMP_NE_I16_t16_e64, false, false }, // 598
  { V_CMP_NE_I32_e64, false, false }, // 599
  { V_CMP_NE_I64_e64, false, false }, // 600
  { V_CMP_NE_U16_e64, false, false }, // 601
  { V_CMP_NE_U16_fake16_e64, false, false }, // 602
  { V_CMP_NE_U16_t16_e64, false, false }, // 603
  { V_CMP_NE_U32_e64, false, false }, // 604
  { V_CMP_NE_U64_e64, false, false }, // 605
  { V_CMP_NGE_F16_e64, false, false }, // 606
  { V_CMP_NGE_F16_fake16_e64, false, false }, // 607
  { V_CMP_NGE_F16_t16_e64, false, false }, // 608
  { V_CMP_NGE_F32_e64, false, false }, // 609
  { V_CMP_NGE_F64_e64, false, false }, // 610
  { V_CMP_NGT_F16_e64, false, false }, // 611
  { V_CMP_NGT_F16_fake16_e64, false, false }, // 612
  { V_CMP_NGT_F16_t16_e64, false, false }, // 613
  { V_CMP_NGT_F32_e64, false, false }, // 614
  { V_CMP_NGT_F64_e64, false, false }, // 615
  { V_CMP_NLE_F16_e64, false, false }, // 616
  { V_CMP_NLE_F16_fake16_e64, false, false }, // 617
  { V_CMP_NLE_F16_t16_e64, false, false }, // 618
  { V_CMP_NLE_F32_e64, false, false }, // 619
  { V_CMP_NLE_F64_e64, false, false }, // 620
  { V_CMP_NLG_F16_e64, false, false }, // 621
  { V_CMP_NLG_F16_fake16_e64, false, false }, // 622
  { V_CMP_NLG_F16_t16_e64, false, false }, // 623
  { V_CMP_NLG_F32_e64, false, false }, // 624
  { V_CMP_NLG_F64_e64, false, false }, // 625
  { V_CMP_NLT_F16_e64, false, false }, // 626
  { V_CMP_NLT_F16_fake16_e64, false, false }, // 627
  { V_CMP_NLT_F16_t16_e64, false, false }, // 628
  { V_CMP_NLT_F32_e64, false, false }, // 629
  { V_CMP_NLT_F64_e64, false, false }, // 630
  { V_CMP_O_F16_e64, false, false }, // 631
  { V_CMP_O_F16_fake16_e64, false, false }, // 632
  { V_CMP_O_F16_t16_e64, false, false }, // 633
  { V_CMP_O_F32_e64, false, false }, // 634
  { V_CMP_O_F64_e64, false, false }, // 635
  { V_CMP_TRU_F16_e64, false, false }, // 636
  { V_CMP_TRU_F16_fake16_e64, false, false }, // 637
  { V_CMP_TRU_F16_t16_e64, false, false }, // 638
  { V_CMP_TRU_F32_e64, false, false }, // 639
  { V_CMP_TRU_F64_e64, false, false }, // 640
  { V_CMP_T_I16_e64, false, false }, // 641
  { V_CMP_T_I16_fake16_e64, false, false }, // 642
  { V_CMP_T_I16_t16_e64, false, false }, // 643
  { V_CMP_T_I32_e64, false, false }, // 644
  { V_CMP_T_I64_e64, false, false }, // 645
  { V_CMP_T_U16_e64, false, false }, // 646
  { V_CMP_T_U16_fake16_e64, false, false }, // 647
  { V_CMP_T_U16_t16_e64, false, false }, // 648
  { V_CMP_T_U32_e64, false, false }, // 649
  { V_CMP_T_U64_e64, false, false }, // 650
  { V_CMP_U_F16_e64, false, false }, // 651
  { V_CMP_U_F16_fake16_e64, false, false }, // 652
  { V_CMP_U_F16_t16_e64, false, false }, // 653
  { V_CMP_U_F32_e64, false, false }, // 654
  { V_CMP_U_F64_e64, false, false }, // 655
  { V_CNDMASK_B16_fake16_e64, false, false }, // 656
  { V_CNDMASK_B16_t16_e64, false, false }, // 657
  { V_CNDMASK_B32_e64, false, false }, // 658
  { V_COS_BF16_e64, false, false }, // 659
  { V_COS_BF16_fake16_e64, false, false }, // 660
  { V_COS_BF16_t16_e64, false, false }, // 661
  { V_COS_F16_e64, false, false }, // 662
  { V_COS_F16_fake16_e64, false, false }, // 663
  { V_COS_F16_t16_e64, false, false }, // 664
  { V_COS_F32_e64, false, false }, // 665
  { V_CUBEID_F32_e64, false, false }, // 666
  { V_CUBEMA_F32_e64, false, false }, // 667
  { V_CUBESC_F32_e64, false, false }, // 668
  { V_CUBETC_F32_e64, false, false }, // 669
  { V_CVT_F16_BF8_e64, false, false }, // 670
  { V_CVT_F16_BF8_fake16_e64, false, false }, // 671
  { V_CVT_F16_BF8_t16_e64, false, false }, // 672
  { V_CVT_F16_F32_e64, false, false }, // 673
  { V_CVT_F16_F32_fake16_e64, false, false }, // 674
  { V_CVT_F16_F32_t16_e64, false, false }, // 675
  { V_CVT_F16_FP8_e64, false, false }, // 676
  { V_CVT_F16_FP8_fake16_e64, false, false }, // 677
  { V_CVT_F16_FP8_t16_e64, false, false }, // 678
  { V_CVT_F16_I16_e64, false, false }, // 679
  { V_CVT_F16_I16_fake16_e64, false, false }, // 680
  { V_CVT_F16_I16_t16_e64, false, false }, // 681
  { V_CVT_F16_U16_e64, false, false }, // 682
  { V_CVT_F16_U16_fake16_e64, false, false }, // 683
  { V_CVT_F16_U16_t16_e64, false, false }, // 684
  { V_CVT_F32_BF16_e64, false, false }, // 685
  { V_CVT_F32_BF16_fake16_e64, false, false }, // 686
  { V_CVT_F32_BF16_gfx1250_e64, false, false }, // 687
  { V_CVT_F32_BF16_gfx1250_fake16_e64, false, false }, // 688
  { V_CVT_F32_BF16_gfx1250_t16_e64, false, false }, // 689
  { V_CVT_F32_BF16_t16_e64, false, false }, // 690
  { V_CVT_F32_BF8_OP_SEL_e64, false, false }, // 691
  { V_CVT_F32_BF8_e64, false, false }, // 692
  { V_CVT_F32_F16_e64, false, false }, // 693
  { V_CVT_F32_F16_fake16_e64, false, false }, // 694
  { V_CVT_F32_F16_t16_e64, false, false }, // 695
  { V_CVT_F32_F64_e64, false, false }, // 696
  { V_CVT_F32_FP8_OP_SEL_e64, false, false }, // 697
  { V_CVT_F32_FP8_e64, false, false }, // 698
  { V_CVT_F32_FP8_gfx1250_e64, false, false }, // 699
  { V_CVT_F32_I32_e64, false, false }, // 700
  { V_CVT_F32_U32_e64, false, false }, // 701
  { V_CVT_F32_UBYTE0_e64, false, false }, // 702
  { V_CVT_F32_UBYTE1_e64, false, false }, // 703
  { V_CVT_F32_UBYTE2_e64, false, false }, // 704
  { V_CVT_F32_UBYTE3_e64, false, false }, // 705
  { V_CVT_F64_F32_e64, false, false }, // 706
  { V_CVT_F64_I32_e64, false, false }, // 707
  { V_CVT_F64_U32_e64, false, false }, // 708
  { V_CVT_FLR_I32_F32_e64, false, false }, // 709
  { V_CVT_I16_F16_e64, false, false }, // 710
  { V_CVT_I16_F16_fake16_e64, false, false }, // 711
  { V_CVT_I16_F16_t16_e64, false, false }, // 712
  { V_CVT_I32_F32_e64, false, false }, // 713
  { V_CVT_I32_F64_e64, false, false }, // 714
  { V_CVT_I32_I16_e64, false, false }, // 715
  { V_CVT_I32_I16_fake16_e64, false, false }, // 716
  { V_CVT_I32_I16_t16_e64, false, false }, // 717
  { V_CVT_NORM_I16_F16_e64, false, false }, // 718
  { V_CVT_NORM_I16_F16_fake16_e64, false, false }, // 719
  { V_CVT_NORM_I16_F16_t16_e64, false, false }, // 720
  { V_CVT_NORM_U16_F16_e64, false, false }, // 721
  { V_CVT_NORM_U16_F16_fake16_e64, false, false }, // 722
  { V_CVT_NORM_U16_F16_t16_e64, false, false }, // 723
  { V_CVT_OFF_F32_I4_e64, false, false }, // 724
  { V_CVT_PKACCUM_U8_F32_e64, false, false }, // 725
  { V_CVT_PKNORM_I16_F16_e64, false, false }, // 726
  { V_CVT_PKNORM_I16_F16_fake16_e64, false, false }, // 727
  { V_CVT_PKNORM_I16_F16_t16_e64, false, false }, // 728
  { V_CVT_PKNORM_I16_F32_e64, false, false }, // 729
  { V_CVT_PKNORM_U16_F16_e64, false, false }, // 730
  { V_CVT_PKNORM_U16_F16_fake16_e64, false, false }, // 731
  { V_CVT_PKNORM_U16_F16_t16_e64, false, false }, // 732
  { V_CVT_PKNORM_U16_F32_e64, false, false }, // 733
  { V_CVT_PKRTZ_F16_F32_e64, false, false }, // 734
  { V_CVT_PK_BF16_F32_e64, false, false }, // 735
  { V_CVT_PK_BF8_F16_gfx1250_e64, false, false }, // 736
  { V_CVT_PK_BF8_F16_gfx1250_fake16_e64, false, false }, // 737
  { V_CVT_PK_BF8_F16_gfx1250_t16_e64, false, false }, // 738
  { V_CVT_PK_BF8_F32_e64, false, false }, // 739
  { V_CVT_PK_BF8_F32_fake16_e64, false, false }, // 740
  { V_CVT_PK_BF8_F32_t16_e64, false, false }, // 741
  { V_CVT_PK_F16_BF8_e64, false, false }, // 742
  { V_CVT_PK_F16_BF8_fake16_e64, false, false }, // 743
  { V_CVT_PK_F16_BF8_t16_e64, false, false }, // 744
  { V_CVT_PK_F16_F32_e64, false, false }, // 745
  { V_CVT_PK_F16_FP8_e64, false, false }, // 746
  { V_CVT_PK_F16_FP8_fake16_e64, false, false }, // 747
  { V_CVT_PK_F16_FP8_t16_e64, false, false }, // 748
  { V_CVT_PK_F32_BF8_e64, false, false }, // 749
  { V_CVT_PK_F32_BF8_fake16_e64, false, false }, // 750
  { V_CVT_PK_F32_BF8_t16_e64, false, false }, // 751
  { V_CVT_PK_F32_FP8_e64, false, false }, // 752
  { V_CVT_PK_F32_FP8_fake16_e64, false, false }, // 753
  { V_CVT_PK_F32_FP8_t16_e64, false, false }, // 754
  { V_CVT_PK_FP8_F16_gfx1250_e64, false, false }, // 755
  { V_CVT_PK_FP8_F16_gfx1250_fake16_e64, false, false }, // 756
  { V_CVT_PK_FP8_F16_gfx1250_t16_e64, false, false }, // 757
  { V_CVT_PK_FP8_F32_e64, false, false }, // 758
  { V_CVT_PK_FP8_F32_fake16_e64, false, false }, // 759
  { V_CVT_PK_FP8_F32_gfx1250_e64, false, false }, // 760
  { V_CVT_PK_FP8_F32_gfx1250_fake16_e64, false, false }, // 761
  { V_CVT_PK_FP8_F32_gfx1250_t16_e64, false, false }, // 762
  { V_CVT_PK_FP8_F32_t16_e64, false, false }, // 763
  { V_CVT_PK_I16_F32_e64, false, false }, // 764
  { V_CVT_PK_I16_I32_e64, false, false }, // 765
  { V_CVT_PK_U16_F32_e64, false, false }, // 766
  { V_CVT_PK_U16_U32_e64, false, false }, // 767
  { V_CVT_PK_U8_F32_e64, false, false }, // 768
  { V_CVT_RPI_I32_F32_e64, false, false }, // 769
  { V_CVT_SCALEF32_2XPK16_BF6_F32_e64, false, false }, // 770
  { V_CVT_SCALEF32_2XPK16_FP6_F32_e64, false, false }, // 771
  { V_CVT_SCALEF32_F16_BF8_e64, false, false }, // 772
  { V_CVT_SCALEF32_F16_FP8_e64, false, false }, // 773
  { V_CVT_SCALEF32_F32_BF8_e64, false, false }, // 774
  { V_CVT_SCALEF32_F32_FP8_e64, false, false }, // 775
  { V_CVT_SCALEF32_PK16_BF6_BF16_e64, false, false }, // 776
  { V_CVT_SCALEF32_PK16_BF6_F16_e64, false, false }, // 777
  { V_CVT_SCALEF32_PK16_BF6_F32_e64, false, false }, // 778
  { V_CVT_SCALEF32_PK16_FP6_BF16_e64, false, false }, // 779
  { V_CVT_SCALEF32_PK16_FP6_F16_e64, false, false }, // 780
  { V_CVT_SCALEF32_PK16_FP6_F32_e64, false, false }, // 781
  { V_CVT_SCALEF32_PK32_BF16_BF6_e64, false, false }, // 782
  { V_CVT_SCALEF32_PK32_BF16_FP6_e64, false, false }, // 783
  { V_CVT_SCALEF32_PK32_BF6_BF16_e64, false, false }, // 784
  { V_CVT_SCALEF32_PK32_BF6_F16_e64, false, false }, // 785
  { V_CVT_SCALEF32_PK32_F16_BF6_e64, false, false }, // 786
  { V_CVT_SCALEF32_PK32_F16_FP6_e64, false, false }, // 787
  { V_CVT_SCALEF32_PK32_F32_BF6_e64, false, false }, // 788
  { V_CVT_SCALEF32_PK32_F32_FP6_e64, false, false }, // 789
  { V_CVT_SCALEF32_PK32_FP6_BF16_e64, false, false }, // 790
  { V_CVT_SCALEF32_PK32_FP6_F16_e64, false, false }, // 791
  { V_CVT_SCALEF32_PK8_BF8_BF16_e64, false, false }, // 792
  { V_CVT_SCALEF32_PK8_BF8_F16_e64, false, false }, // 793
  { V_CVT_SCALEF32_PK8_BF8_F32_e64, false, false }, // 794
  { V_CVT_SCALEF32_PK8_FP4_BF16_e64, false, false }, // 795
  { V_CVT_SCALEF32_PK8_FP4_F16_e64, false, false }, // 796
  { V_CVT_SCALEF32_PK8_FP4_F32_e64, false, false }, // 797
  { V_CVT_SCALEF32_PK8_FP8_BF16_e64, false, false }, // 798
  { V_CVT_SCALEF32_PK8_FP8_F16_e64, false, false }, // 799
  { V_CVT_SCALEF32_PK8_FP8_F32_e64, false, false }, // 800
  { V_CVT_SCALEF32_PK_BF16_BF8_e64, false, false }, // 801
  { V_CVT_SCALEF32_PK_BF16_FP4_e64, false, false }, // 802
  { V_CVT_SCALEF32_PK_BF16_FP8_e64, false, false }, // 803
  { V_CVT_SCALEF32_PK_BF8_BF16_e64, false, false }, // 804
  { V_CVT_SCALEF32_PK_BF8_F16_e64, false, false }, // 805
  { V_CVT_SCALEF32_PK_BF8_F32_e64, false, false }, // 806
  { V_CVT_SCALEF32_PK_F16_BF8_e64, false, false }, // 807
  { V_CVT_SCALEF32_PK_F16_FP4_e64, false, false }, // 808
  { V_CVT_SCALEF32_PK_F16_FP8_e64, false, false }, // 809
  { V_CVT_SCALEF32_PK_F32_BF8_e64, false, false }, // 810
  { V_CVT_SCALEF32_PK_F32_FP4_e64, false, false }, // 811
  { V_CVT_SCALEF32_PK_F32_FP8_e64, false, false }, // 812
  { V_CVT_SCALEF32_PK_FP4_BF16_e64, true, false }, // 813
  { V_CVT_SCALEF32_PK_FP4_F16_e64, true, false }, // 814
  { V_CVT_SCALEF32_PK_FP4_F32_e64, true, false }, // 815
  { V_CVT_SCALEF32_PK_FP8_BF16_e64, false, false }, // 816
  { V_CVT_SCALEF32_PK_FP8_F16_e64, false, false }, // 817
  { V_CVT_SCALEF32_PK_FP8_F32_e64, false, false }, // 818
  { V_CVT_SCALEF32_SR_BF8_BF16_e64, true, false }, // 819
  { V_CVT_SCALEF32_SR_BF8_F16_e64, true, false }, // 820
  { V_CVT_SCALEF32_SR_BF8_F32_e64, true, false }, // 821
  { V_CVT_SCALEF32_SR_FP8_BF16_e64, true, false }, // 822
  { V_CVT_SCALEF32_SR_FP8_F16_e64, true, false }, // 823
  { V_CVT_SCALEF32_SR_FP8_F32_e64, true, false }, // 824
  { V_CVT_SCALEF32_SR_PK16_BF6_BF16_e64, false, false }, // 825
  { V_CVT_SCALEF32_SR_PK16_BF6_F16_e64, false, false }, // 826
  { V_CVT_SCALEF32_SR_PK16_BF6_F32_e64, false, false }, // 827
  { V_CVT_SCALEF32_SR_PK16_FP6_BF16_e64, false, false }, // 828
  { V_CVT_SCALEF32_SR_PK16_FP6_F16_e64, false, false }, // 829
  { V_CVT_SCALEF32_SR_PK16_FP6_F32_e64, false, false }, // 830
  { V_CVT_SCALEF32_SR_PK32_BF6_BF16_e64, false, false }, // 831
  { V_CVT_SCALEF32_SR_PK32_BF6_F16_e64, false, false }, // 832
  { V_CVT_SCALEF32_SR_PK32_BF6_F32_e64, false, false }, // 833
  { V_CVT_SCALEF32_SR_PK32_FP6_BF16_e64, false, false }, // 834
  { V_CVT_SCALEF32_SR_PK32_FP6_F16_e64, false, false }, // 835
  { V_CVT_SCALEF32_SR_PK32_FP6_F32_e64, false, false }, // 836
  { V_CVT_SCALEF32_SR_PK8_BF8_BF16_e64, false, false }, // 837
  { V_CVT_SCALEF32_SR_PK8_BF8_F16_e64, false, false }, // 838
  { V_CVT_SCALEF32_SR_PK8_BF8_F32_e64, false, false }, // 839
  { V_CVT_SCALEF32_SR_PK8_FP4_BF16_e64, false, false }, // 840
  { V_CVT_SCALEF32_SR_PK8_FP4_F16_e64, false, false }, // 841
  { V_CVT_SCALEF32_SR_PK8_FP4_F32_e64, false, false }, // 842
  { V_CVT_SCALEF32_SR_PK8_FP8_BF16_e64, false, false }, // 843
  { V_CVT_SCALEF32_SR_PK8_FP8_F16_e64, false, false }, // 844
  { V_CVT_SCALEF32_SR_PK8_FP8_F32_e64, false, false }, // 845
  { V_CVT_SCALEF32_SR_PK_FP4_BF16_e64, false, true }, // 846
  { V_CVT_SCALEF32_SR_PK_FP4_F16_e64, false, true }, // 847
  { V_CVT_SCALEF32_SR_PK_FP4_F32_e64, false, true }, // 848
  { V_CVT_SCALE_PK16_BF16_BF6_e64, false, false }, // 849
  { V_CVT_SCALE_PK16_BF16_FP6_e64, false, false }, // 850
  { V_CVT_SCALE_PK16_F16_BF6_e64, false, false }, // 851
  { V_CVT_SCALE_PK16_F16_FP6_e64, false, false }, // 852
  { V_CVT_SCALE_PK16_F32_BF6_e64, false, false }, // 853
  { V_CVT_SCALE_PK16_F32_FP6_e64, false, false }, // 854
  { V_CVT_SCALE_PK8_BF16_BF8_e64, false, false }, // 855
  { V_CVT_SCALE_PK8_BF16_FP4_e64, false, false }, // 856
  { V_CVT_SCALE_PK8_BF16_FP8_e64, false, false }, // 857
  { V_CVT_SCALE_PK8_F16_BF8_e64, false, false }, // 858
  { V_CVT_SCALE_PK8_F16_FP4_e64, false, false }, // 859
  { V_CVT_SCALE_PK8_F16_FP8_e64, false, false }, // 860
  { V_CVT_SCALE_PK8_F32_BF8_e64, false, false }, // 861
  { V_CVT_SCALE_PK8_F32_FP4_e64, false, false }, // 862
  { V_CVT_SCALE_PK8_F32_FP8_e64, false, false }, // 863
  { V_CVT_SR_BF16_F32_e64, false, false }, // 864
  { V_CVT_SR_BF8_F16_e64, true, false }, // 865
  { V_CVT_SR_BF8_F16_fake16_e64, true, false }, // 866
  { V_CVT_SR_BF8_F16_t16_e64, true, false }, // 867
  { V_CVT_SR_BF8_F32_e64, true, false }, // 868
  { V_CVT_SR_BF8_F32_gfx12_e64, true, false }, // 869
  { V_CVT_SR_F16_F32_e64, false, false }, // 870
  { V_CVT_SR_FP8_F16_e64, true, false }, // 871
  { V_CVT_SR_FP8_F16_fake16_e64, true, false }, // 872
  { V_CVT_SR_FP8_F16_t16_e64, true, false }, // 873
  { V_CVT_SR_FP8_F32_e64, true, false }, // 874
  { V_CVT_SR_FP8_F32_gfx1250_e64, true, false }, // 875
  { V_CVT_SR_FP8_F32_gfx12_e64, true, false }, // 876
  { V_CVT_SR_PK_BF16_F32_e64, false, false }, // 877
  { V_CVT_SR_PK_F16_F32_e64, false, false }, // 878
  { V_CVT_U16_F16_e64, false, false }, // 879
  { V_CVT_U16_F16_fake16_e64, false, false }, // 880
  { V_CVT_U16_F16_t16_e64, false, false }, // 881
  { V_CVT_U32_F32_e64, false, false }, // 882
  { V_CVT_U32_F64_e64, false, false }, // 883
  { V_CVT_U32_U16_e64, false, false }, // 884
  { V_CVT_U32_U16_fake16_e64, false, false }, // 885
  { V_CVT_U32_U16_t16_e64, false, false }, // 886
  { V_DIV_FIXUP_F16_e64, false, false }, // 887
  { V_DIV_FIXUP_F16_gfx9_e64, false, false }, // 888
  { V_DIV_FIXUP_F16_gfx9_fake16_e64, false, false }, // 889
  { V_DIV_FIXUP_F16_gfx9_t16_e64, false, false }, // 890
  { V_DIV_FIXUP_F32_e64, false, false }, // 891
  { V_DIV_FIXUP_F64_e64, false, false }, // 892
  { V_DIV_FMAS_F32_e64, false, false }, // 893
  { V_DIV_FMAS_F64_e64, false, false }, // 894
  { V_DIV_SCALE_F32_e64, false, false }, // 895
  { V_DIV_SCALE_F64_e64, false, false }, // 896
  { V_DOT2C_F32_BF16_e64, false, false }, // 897
  { V_DOT2C_F32_F16_e64, false, false }, // 898
  { V_DOT2C_I32_I16_e64, false, false }, // 899
  { V_DOT2_BF16_BF16_e64, false, false }, // 900
  { V_DOT2_BF16_BF16_fake16_e64, false, false }, // 901
  { V_DOT2_BF16_BF16_t16_e64, false, false }, // 902
  { V_DOT2_F16_F16_e64, false, false }, // 903
  { V_DOT2_F16_F16_fake16_e64, false, false }, // 904
  { V_DOT2_F16_F16_t16_e64, false, false }, // 905
  { V_DOT2_F32_BF16, false, false }, // 906
  { V_DOT2_F32_F16, false, false }, // 907
  { V_DOT2_I32_I16, false, false }, // 908
  { V_DOT2_U32_U16, false, false }, // 909
  { V_DOT4C_I32_I8_e64, false, false }, // 910
  { V_DOT4_F32_BF8_BF8, false, false }, // 911
  { V_DOT4_F32_BF8_FP8, false, false }, // 912
  { V_DOT4_F32_FP8_BF8, false, false }, // 913
  { V_DOT4_F32_FP8_FP8, false, false }, // 914
  { V_DOT4_I32_I8, false, false }, // 915
  { V_DOT4_I32_IU8, false, false }, // 916
  { V_DOT4_U32_U8, false, false }, // 917
  { V_DOT8C_I32_I4_e64, false, false }, // 918
  { V_DOT8_I32_I4, false, false }, // 919
  { V_DOT8_I32_IU4, false, false }, // 920
  { V_DOT8_U32_U4, false, false }, // 921
  { V_EXP_BF16_e64, false, false }, // 922
  { V_EXP_BF16_fake16_e64, false, false }, // 923
  { V_EXP_BF16_t16_e64, false, false }, // 924
  { V_EXP_F16_e64, false, false }, // 925
  { V_EXP_F16_fake16_e64, false, false }, // 926
  { V_EXP_F16_t16_e64, false, false }, // 927
  { V_EXP_F32_e64, false, false }, // 928
  { V_EXP_LEGACY_F32_e64, false, false }, // 929
  { V_FFBH_I32_e64, false, false }, // 930
  { V_FFBH_U32_e64, false, false }, // 931
  { V_FFBL_B32_e64, false, false }, // 932
  { V_FLOOR_F16_e64, false, false }, // 933
  { V_FLOOR_F16_fake16_e64, false, false }, // 934
  { V_FLOOR_F16_t16_e64, false, false }, // 935
  { V_FLOOR_F32_e64, false, false }, // 936
  { V_FLOOR_F64_e64, false, false }, // 937
  { V_FMAC_F16_e64, false, false }, // 938
  { V_FMAC_F16_fake16_e64, false, false }, // 939
  { V_FMAC_F16_t16_e64, false, false }, // 940
  { V_FMAC_F32_e64, false, false }, // 941
  { V_FMAC_F64_e64, false, false }, // 942
  { V_FMAC_LEGACY_F32_e64, false, false }, // 943
  { V_FMA_F16_e64, false, false }, // 944
  { V_FMA_F16_gfx9_e64, false, false }, // 945
  { V_FMA_F16_gfx9_fake16_e64, false, false }, // 946
  { V_FMA_F16_gfx9_t16_e64, false, false }, // 947
  { V_FMA_F32_e64, false, false }, // 948
  { V_FMA_F64_e64, false, false }, // 949
  { V_FMA_LEGACY_F32_e64, false, false }, // 950
  { V_FMA_MIXHI_BF16, false, false }, // 951
  { V_FMA_MIXHI_F16, false, false }, // 952
  { V_FMA_MIXLO_BF16, false, false }, // 953
  { V_FMA_MIXLO_F16, false, false }, // 954
  { V_FMA_MIX_F32, false, false }, // 955
  { V_FMA_MIX_F32_BF16, false, false }, // 956
  { V_FRACT_F16_e64, false, false }, // 957
  { V_FRACT_F16_fake16_e64, false, false }, // 958
  { V_FRACT_F16_t16_e64, false, false }, // 959
  { V_FRACT_F32_e64, false, false }, // 960
  { V_FRACT_F64_e64, false, false }, // 961
  { V_FREXP_EXP_I16_F16_e64, false, false }, // 962
  { V_FREXP_EXP_I16_F16_fake16_e64, false, false }, // 963
  { V_FREXP_EXP_I16_F16_t16_e64, false, false }, // 964
  { V_FREXP_EXP_I32_F32_e64, false, false }, // 965
  { V_FREXP_EXP_I32_F64_e64, false, false }, // 966
  { V_FREXP_MANT_F16_e64, false, false }, // 967
  { V_FREXP_MANT_F16_fake16_e64, false, false }, // 968
  { V_FREXP_MANT_F16_t16_e64, false, false }, // 969
  { V_FREXP_MANT_F32_e64, false, false }, // 970
  { V_FREXP_MANT_F64_e64, false, false }, // 971
  { V_INTERP_MOV_F32_e64, false, false }, // 972
  { V_INTERP_P10_F16_F32_inreg_fake16, false, false }, // 973
  { V_INTERP_P10_F16_F32_inreg_t16, false, false }, // 974
  { V_INTERP_P10_F32_inreg, false, false }, // 975
  { V_INTERP_P10_RTZ_F16_F32_inreg_fake16, false, false }, // 976
  { V_INTERP_P10_RTZ_F16_F32_inreg_t16, false, false }, // 977
  { V_INTERP_P1LL_F16, false, false }, // 978
  { V_INTERP_P1LV_F16, false, false }, // 979
  { V_INTERP_P1_F32_e64, false, false }, // 980
  { V_INTERP_P2_F16, false, false }, // 981
  { V_INTERP_P2_F16_F32_inreg_fake16, false, false }, // 982
  { V_INTERP_P2_F16_F32_inreg_t16, false, false }, // 983
  { V_INTERP_P2_F16_gfx9, false, false }, // 984
  { V_INTERP_P2_F32_e64, false, false }, // 985
  { V_INTERP_P2_F32_inreg, false, false }, // 986
  { V_INTERP_P2_RTZ_F16_F32_inreg_fake16, false, false }, // 987
  { V_INTERP_P2_RTZ_F16_F32_inreg_t16, false, false }, // 988
  { V_LDEXP_F16_e64, false, false }, // 989
  { V_LDEXP_F16_fake16_e64, false, false }, // 990
  { V_LDEXP_F16_t16_e64, false, false }, // 991
  { V_LDEXP_F32_e64, false, false }, // 992
  { V_LDEXP_F64_e64, false, false }, // 993
  { V_LERP_U8_e64, false, false }, // 994
  { V_LOG_BF16_e64, false, false }, // 995
  { V_LOG_BF16_fake16_e64, false, false }, // 996
  { V_LOG_BF16_t16_e64, false, false }, // 997
  { V_LOG_CLAMP_F32_e64, false, false }, // 998
  { V_LOG_F16_e64, false, false }, // 999
  { V_LOG_F16_fake16_e64, false, false }, // 1000
  { V_LOG_F16_t16_e64, false, false }, // 1001
  { V_LOG_F32_e64, false, false }, // 1002
  { V_LOG_LEGACY_F32_e64, false, false }, // 1003
  { V_LSHLREV_B16_e64, false, false }, // 1004
  { V_LSHLREV_B16_fake16_e64, false, false }, // 1005
  { V_LSHLREV_B16_opsel_e64, false, false }, // 1006
  { V_LSHLREV_B16_t16_e64, false, false }, // 1007
  { V_LSHLREV_B32_e64, false, false }, // 1008
  { V_LSHLREV_B64_e64, false, false }, // 1009
  { V_LSHLREV_B64_pseudo_e64, false, false }, // 1010
  { V_LSHL_ADD_U32_e64, false, false }, // 1011
  { V_LSHL_ADD_U64_e64, false, false }, // 1012
  { V_LSHL_B32_e64, false, false }, // 1013
  { V_LSHL_B64_e64, false, false }, // 1014
  { V_LSHL_OR_B32_e64, false, false }, // 1015
  { V_LSHRREV_B16_e64, false, false }, // 1016
  { V_LSHRREV_B16_fake16_e64, false, false }, // 1017
  { V_LSHRREV_B16_opsel_e64, false, false }, // 1018
  { V_LSHRREV_B16_t16_e64, false, false }, // 1019
  { V_LSHRREV_B32_e64, false, false }, // 1020
  { V_LSHRREV_B64_e64, false, false }, // 1021
  { V_LSHR_B32_e64, false, false }, // 1022
  { V_LSHR_B64_e64, false, false }, // 1023
  { V_MAC_F16_e64, false, false }, // 1024
  { V_MAC_F32_e64, false, false }, // 1025
  { V_MAC_LEGACY_F32_e64, false, false }, // 1026
  { V_MAD_F16_e64, false, false }, // 1027
  { V_MAD_F16_gfx9_e64, false, false }, // 1028
  { V_MAD_F32_e64, false, false }, // 1029
  { V_MAD_I16_e64, false, false }, // 1030
  { V_MAD_I16_gfx9_e64, false, false }, // 1031
  { V_MAD_I16_gfx9_fake16_e64, false, false }, // 1032
  { V_MAD_I16_gfx9_t16_e64, false, false }, // 1033
  { V_MAD_I32_I16_e64, false, false }, // 1034
  { V_MAD_I32_I16_fake16_e64, false, false }, // 1035
  { V_MAD_I32_I16_t16_e64, false, false }, // 1036
  { V_MAD_I32_I24_e64, false, false }, // 1037
  { V_MAD_I64_I32_e64, false, false }, // 1038
  { V_MAD_I64_I32_gfx11_e64, false, false }, // 1039
  { V_MAD_LEGACY_F32_e64, false, false }, // 1040
  { V_MAD_MIXHI_F16, false, false }, // 1041
  { V_MAD_MIXLO_F16, false, false }, // 1042
  { V_MAD_MIX_F32, false, false }, // 1043
  { V_MAD_NC_I64_I32_e64, false, false }, // 1044
  { V_MAD_NC_U64_U32_e64, false, false }, // 1045
  { V_MAD_U16_e64, false, false }, // 1046
  { V_MAD_U16_gfx9_e64, false, false }, // 1047
  { V_MAD_U16_gfx9_fake16_e64, false, false }, // 1048
  { V_MAD_U16_gfx9_t16_e64, false, false }, // 1049
  { V_MAD_U32_U16_e64, false, false }, // 1050
  { V_MAD_U32_U16_fake16_e64, false, false }, // 1051
  { V_MAD_U32_U16_t16_e64, false, false }, // 1052
  { V_MAD_U32_U24_e64, false, false }, // 1053
  { V_MAD_U32_e64, false, false }, // 1054
  { V_MAD_U64_U32_e64, false, false }, // 1055
  { V_MAD_U64_U32_gfx11_e64, false, false }, // 1056
  { V_MAX3_F16_e64, false, false }, // 1057
  { V_MAX3_F16_fake16_e64, false, false }, // 1058
  { V_MAX3_F16_t16_e64, false, false }, // 1059
  { V_MAX3_F32_e64, false, false }, // 1060
  { V_MAX3_I16_e64, false, false }, // 1061
  { V_MAX3_I16_fake16_e64, false, false }, // 1062
  { V_MAX3_I16_t16_e64, false, false }, // 1063
  { V_MAX3_I32_e64, false, false }, // 1064
  { V_MAX3_U16_e64, false, false }, // 1065
  { V_MAX3_U16_fake16_e64, false, false }, // 1066
  { V_MAX3_U16_t16_e64, false, false }, // 1067
  { V_MAX3_U32_e64, false, false }, // 1068
  { V_MAXIMUM3_F16_e64, false, false }, // 1069
  { V_MAXIMUM3_F16_fake16_e64, false, false }, // 1070
  { V_MAXIMUM3_F16_t16_e64, false, false }, // 1071
  { V_MAXIMUM3_F32_e64, false, false }, // 1072
  { V_MAXIMUMMINIMUM_F16_e64, false, false }, // 1073
  { V_MAXIMUMMINIMUM_F16_fake16_e64, false, false }, // 1074
  { V_MAXIMUMMINIMUM_F16_t16_e64, false, false }, // 1075
  { V_MAXIMUMMINIMUM_F32_e64, false, false }, // 1076
  { V_MAXIMUM_F16_e64, false, false }, // 1077
  { V_MAXIMUM_F16_fake16_e64, false, false }, // 1078
  { V_MAXIMUM_F16_t16_e64, false, false }, // 1079
  { V_MAXIMUM_F32_e64, false, false }, // 1080
  { V_MAXIMUM_F64_e64, false, false }, // 1081
  { V_MAXMIN_F16_e64, false, false }, // 1082
  { V_MAXMIN_F16_fake16_e64, false, false }, // 1083
  { V_MAXMIN_F16_t16_e64, false, false }, // 1084
  { V_MAXMIN_F32_e64, false, false }, // 1085
  { V_MAXMIN_I32_e64, false, false }, // 1086
  { V_MAXMIN_U32_e64, false, false }, // 1087
  { V_MAX_BF16_PSEUDO_e64, false, false }, // 1088
  { V_MAX_F16_e64, false, false }, // 1089
  { V_MAX_F16_fake16_e64, false, false }, // 1090
  { V_MAX_F16_t16_e64, false, false }, // 1091
  { V_MAX_F32_e64, false, false }, // 1092
  { V_MAX_F64_e64, false, false }, // 1093
  { V_MAX_I16_e64, false, false }, // 1094
  { V_MAX_I16_fake16_e64, false, false }, // 1095
  { V_MAX_I16_opsel_e64, false, false }, // 1096
  { V_MAX_I16_t16_e64, false, false }, // 1097
  { V_MAX_I32_e64, false, false }, // 1098
  { V_MAX_I64_e64, false, false }, // 1099
  { V_MAX_LEGACY_F32_e64, false, false }, // 1100
  { V_MAX_NUM_F64_e64, false, false }, // 1101
  { V_MAX_U16_e64, false, false }, // 1102
  { V_MAX_U16_fake16_e64, false, false }, // 1103
  { V_MAX_U16_opsel_e64, false, false }, // 1104
  { V_MAX_U16_t16_e64, false, false }, // 1105
  { V_MAX_U32_e64, false, false }, // 1106
  { V_MAX_U64_e64, false, false }, // 1107
  { V_MBCNT_HI_U32_B32_e64, false, false }, // 1108
  { V_MBCNT_LO_U32_B32_e64, false, false }, // 1109
  { V_MED3_F16_e64, false, false }, // 1110
  { V_MED3_F16_fake16_e64, false, false }, // 1111
  { V_MED3_F16_t16_e64, false, false }, // 1112
  { V_MED3_F32_e64, false, false }, // 1113
  { V_MED3_I16_e64, false, false }, // 1114
  { V_MED3_I16_fake16_e64, false, false }, // 1115
  { V_MED3_I16_t16_e64, false, false }, // 1116
  { V_MED3_I32_e64, false, false }, // 1117
  { V_MED3_U16_e64, false, false }, // 1118
  { V_MED3_U16_fake16_e64, false, false }, // 1119
  { V_MED3_U16_t16_e64, false, false }, // 1120
  { V_MED3_U32_e64, false, false }, // 1121
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_e64, false, false }, // 1122
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, false }, // 1123
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_e64, false, false }, // 1124
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, false }, // 1125
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_e64, false, false }, // 1126
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, false }, // 1127
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_e64, false, false }, // 1128
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, false }, // 1129
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_e64, false, false }, // 1130
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, false }, // 1131
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_e64, false, false }, // 1132
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, false }, // 1133
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_e64, false, false }, // 1134
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, false }, // 1135
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_e64, false, false }, // 1136
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, false }, // 1137
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_e64, false, false }, // 1138
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, false }, // 1139
  { V_MFMA_F32_16X16X16BF16_1K_e64, false, false }, // 1140
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false, false }, // 1141
  { V_MFMA_F32_16X16X16F16_e64, false, false }, // 1142
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false, false }, // 1143
  { V_MFMA_F32_16X16X1F32_e64, false, false }, // 1144
  { V_MFMA_F32_16X16X1F32_mac_e64, false, false }, // 1145
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false, false }, // 1146
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false, false }, // 1147
  { V_MFMA_F32_16X16X2BF16_e64, false, false }, // 1148
  { V_MFMA_F32_16X16X2BF16_mac_e64, false, false }, // 1149
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false, false }, // 1150
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false, false }, // 1151
  { V_MFMA_F32_16X16X32_BF16_e64, false, false }, // 1152
  { V_MFMA_F32_16X16X32_BF16_vgprcd_e64, false, false }, // 1153
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false, false }, // 1154
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false, false }, // 1155
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false, false }, // 1156
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false, false }, // 1157
  { V_MFMA_F32_16X16X32_F16_e64, false, false }, // 1158
  { V_MFMA_F32_16X16X32_F16_vgprcd_e64, false, false }, // 1159
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false, false }, // 1160
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false, false }, // 1161
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false, false }, // 1162
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false, false }, // 1163
  { V_MFMA_F32_16X16X4BF16_1K_e64, false, false }, // 1164
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false, false }, // 1165
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false, false }, // 1166
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false, false }, // 1167
  { V_MFMA_F32_16X16X4F16_e64, false, false }, // 1168
  { V_MFMA_F32_16X16X4F16_mac_e64, false, false }, // 1169
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false, false }, // 1170
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false, false }, // 1171
  { V_MFMA_F32_16X16X4F32_e64, false, false }, // 1172
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false, false }, // 1173
  { V_MFMA_F32_16X16X8BF16_e64, false, false }, // 1174
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false, false }, // 1175
  { V_MFMA_F32_16X16X8XF32_e64, false, false }, // 1176
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false, false }, // 1177
  { V_MFMA_F32_32X32X16_BF16_e64, false, false }, // 1178
  { V_MFMA_F32_32X32X16_BF16_mac_e64, false, false }, // 1179
  { V_MFMA_F32_32X32X16_BF16_mac_vgprcd_e64, false, false }, // 1180
  { V_MFMA_F32_32X32X16_BF16_vgprcd_e64, false, false }, // 1181
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false, false }, // 1182
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false, false }, // 1183
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false, false }, // 1184
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false, false }, // 1185
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false, false }, // 1186
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false, false }, // 1187
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false, false }, // 1188
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false, false }, // 1189
  { V_MFMA_F32_32X32X16_F16_e64, false, false }, // 1190
  { V_MFMA_F32_32X32X16_F16_mac_e64, false, false }, // 1191
  { V_MFMA_F32_32X32X16_F16_mac_vgprcd_e64, false, false }, // 1192
  { V_MFMA_F32_32X32X16_F16_vgprcd_e64, false, false }, // 1193
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false, false }, // 1194
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false, false }, // 1195
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false, false }, // 1196
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false, false }, // 1197
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false, false }, // 1198
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false, false }, // 1199
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false, false }, // 1200
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false, false }, // 1201
  { V_MFMA_F32_32X32X1F32_e64, false, false }, // 1202
  { V_MFMA_F32_32X32X1F32_mac_e64, false, false }, // 1203
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false, false }, // 1204
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false, false }, // 1205
  { V_MFMA_F32_32X32X2BF16_e64, false, false }, // 1206
  { V_MFMA_F32_32X32X2BF16_mac_e64, false, false }, // 1207
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false, false }, // 1208
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false, false }, // 1209
  { V_MFMA_F32_32X32X2F32_e64, false, false }, // 1210
  { V_MFMA_F32_32X32X2F32_mac_e64, false, false }, // 1211
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false, false }, // 1212
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false, false }, // 1213
  { V_MFMA_F32_32X32X4BF16_1K_e64, false, false }, // 1214
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false, false }, // 1215
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false, false }, // 1216
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false, false }, // 1217
  { V_MFMA_F32_32X32X4BF16_e64, false, false }, // 1218
  { V_MFMA_F32_32X32X4BF16_mac_e64, false, false }, // 1219
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false, false }, // 1220
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false, false }, // 1221
  { V_MFMA_F32_32X32X4F16_e64, false, false }, // 1222
  { V_MFMA_F32_32X32X4F16_mac_e64, false, false }, // 1223
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false, false }, // 1224
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false, false }, // 1225
  { V_MFMA_F32_32X32X4XF32_e64, false, false }, // 1226
  { V_MFMA_F32_32X32X4XF32_mac_e64, false, false }, // 1227
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false, false }, // 1228
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false, false }, // 1229
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_e64, false, false }, // 1230
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, false }, // 1231
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, false }, // 1232
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, false }, // 1233
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_e64, false, false }, // 1234
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, false }, // 1235
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, false }, // 1236
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, false }, // 1237
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_e64, false, false }, // 1238
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, false }, // 1239
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, false }, // 1240
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, false }, // 1241
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_e64, false, false }, // 1242
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, false }, // 1243
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, false }, // 1244
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, false }, // 1245
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_e64, false, false }, // 1246
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, false }, // 1247
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, false }, // 1248
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, false }, // 1249
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_e64, false, false }, // 1250
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, false }, // 1251
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, false }, // 1252
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, false }, // 1253
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_e64, false, false }, // 1254
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, false }, // 1255
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, false }, // 1256
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, false }, // 1257
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_e64, false, false }, // 1258
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, false }, // 1259
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, false }, // 1260
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, false }, // 1261
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_e64, false, false }, // 1262
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, false }, // 1263
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, false }, // 1264
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, false }, // 1265
  { V_MFMA_F32_32X32X8BF16_1K_e64, false, false }, // 1266
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false, false }, // 1267
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false, false }, // 1268
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false, false }, // 1269
  { V_MFMA_F32_32X32X8F16_e64, false, false }, // 1270
  { V_MFMA_F32_32X32X8F16_mac_e64, false, false }, // 1271
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false, false }, // 1272
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false, false }, // 1273
  { V_MFMA_F32_4X4X1F32_e64, false, false }, // 1274
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false, false }, // 1275
  { V_MFMA_F32_4X4X2BF16_e64, false, false }, // 1276
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false, false }, // 1277
  { V_MFMA_F32_4X4X4BF16_1K_e64, false, false }, // 1278
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false, false }, // 1279
  { V_MFMA_F32_4X4X4F16_e64, false, false }, // 1280
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false, false }, // 1281
  { V_MFMA_F64_16X16X4F64_e64, false, false }, // 1282
  { V_MFMA_F64_16X16X4F64_mac_e64, false, false }, // 1283
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, false, false }, // 1284
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, false, false }, // 1285
  { V_MFMA_F64_4X4X4F64_e64, false, false }, // 1286
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, false, false }, // 1287
  { V_MFMA_I32_16X16X16I8_e64, false, false }, // 1288
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false, false }, // 1289
  { V_MFMA_I32_16X16X32I8_e64, false, false }, // 1290
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false, false }, // 1291
  { V_MFMA_I32_16X16X4I8_e64, false, false }, // 1292
  { V_MFMA_I32_16X16X4I8_mac_e64, false, false }, // 1293
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false, false }, // 1294
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false, false }, // 1295
  { V_MFMA_I32_16X16X64_I8_e64, false, false }, // 1296
  { V_MFMA_I32_16X16X64_I8_vgprcd_e64, false, false }, // 1297
  { V_MFMA_I32_32X32X16I8_e64, false, false }, // 1298
  { V_MFMA_I32_32X32X16I8_mac_e64, false, false }, // 1299
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false, false }, // 1300
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false, false }, // 1301
  { V_MFMA_I32_32X32X32_I8_e64, false, false }, // 1302
  { V_MFMA_I32_32X32X32_I8_mac_e64, false, false }, // 1303
  { V_MFMA_I32_32X32X32_I8_mac_vgprcd_e64, false, false }, // 1304
  { V_MFMA_I32_32X32X32_I8_vgprcd_e64, false, false }, // 1305
  { V_MFMA_I32_32X32X4I8_e64, false, false }, // 1306
  { V_MFMA_I32_32X32X4I8_mac_e64, false, false }, // 1307
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false, false }, // 1308
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false, false }, // 1309
  { V_MFMA_I32_32X32X8I8_e64, false, false }, // 1310
  { V_MFMA_I32_32X32X8I8_mac_e64, false, false }, // 1311
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false, false }, // 1312
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false, false }, // 1313
  { V_MFMA_I32_4X4X4I8_e64, false, false }, // 1314
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false, false }, // 1315
  { V_MFMA_LD_SCALE_B32, false, false }, // 1316
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_e64, false, false }, // 1317
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, false }, // 1318
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_e64, false, false }, // 1319
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, false }, // 1320
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_e64, false, false }, // 1321
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, false }, // 1322
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_e64, false, false }, // 1323
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, false }, // 1324
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_e64, false, false }, // 1325
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, false }, // 1326
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_e64, false, false }, // 1327
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, false }, // 1328
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_e64, false, false }, // 1329
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, false }, // 1330
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_e64, false, false }, // 1331
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, false }, // 1332
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_e64, false, false }, // 1333
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, false }, // 1334
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_e64, false, false }, // 1335
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, false }, // 1336
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, false }, // 1337
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, false }, // 1338
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_e64, false, false }, // 1339
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, false }, // 1340
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, false }, // 1341
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, false }, // 1342
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_e64, false, false }, // 1343
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, false }, // 1344
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, false }, // 1345
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, false }, // 1346
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_e64, false, false }, // 1347
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, false }, // 1348
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, false }, // 1349
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, false }, // 1350
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_e64, false, false }, // 1351
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, false }, // 1352
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, false }, // 1353
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, false }, // 1354
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_e64, false, false }, // 1355
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, false }, // 1356
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, false }, // 1357
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, false }, // 1358
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_e64, false, false }, // 1359
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, false }, // 1360
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, false }, // 1361
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, false }, // 1362
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_e64, false, false }, // 1363
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, false }, // 1364
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, false }, // 1365
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, false }, // 1366
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_e64, false, false }, // 1367
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, false }, // 1368
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, false }, // 1369
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, false }, // 1370
  { V_MIN3_F16_e64, false, false }, // 1371
  { V_MIN3_F16_fake16_e64, false, false }, // 1372
  { V_MIN3_F16_t16_e64, false, false }, // 1373
  { V_MIN3_F32_e64, false, false }, // 1374
  { V_MIN3_I16_e64, false, false }, // 1375
  { V_MIN3_I16_fake16_e64, false, false }, // 1376
  { V_MIN3_I16_t16_e64, false, false }, // 1377
  { V_MIN3_I32_e64, false, false }, // 1378
  { V_MIN3_U16_e64, false, false }, // 1379
  { V_MIN3_U16_fake16_e64, false, false }, // 1380
  { V_MIN3_U16_t16_e64, false, false }, // 1381
  { V_MIN3_U32_e64, false, false }, // 1382
  { V_MINIMUM3_F16_e64, false, false }, // 1383
  { V_MINIMUM3_F16_fake16_e64, false, false }, // 1384
  { V_MINIMUM3_F16_t16_e64, false, false }, // 1385
  { V_MINIMUM3_F32_e64, false, false }, // 1386
  { V_MINIMUMMAXIMUM_F16_e64, false, false }, // 1387
  { V_MINIMUMMAXIMUM_F16_fake16_e64, false, false }, // 1388
  { V_MINIMUMMAXIMUM_F16_t16_e64, false, false }, // 1389
  { V_MINIMUMMAXIMUM_F32_e64, false, false }, // 1390
  { V_MINIMUM_F16_e64, false, false }, // 1391
  { V_MINIMUM_F16_fake16_e64, false, false }, // 1392
  { V_MINIMUM_F16_t16_e64, false, false }, // 1393
  { V_MINIMUM_F32_e64, false, false }, // 1394
  { V_MINIMUM_F64_e64, false, false }, // 1395
  { V_MINMAX_F16_e64, false, false }, // 1396
  { V_MINMAX_F16_fake16_e64, false, false }, // 1397
  { V_MINMAX_F16_t16_e64, false, false }, // 1398
  { V_MINMAX_F32_e64, false, false }, // 1399
  { V_MINMAX_I32_e64, false, false }, // 1400
  { V_MINMAX_U32_e64, false, false }, // 1401
  { V_MIN_F16_e64, false, false }, // 1402
  { V_MIN_F16_fake16_e64, false, false }, // 1403
  { V_MIN_F16_t16_e64, false, false }, // 1404
  { V_MIN_F32_e64, false, false }, // 1405
  { V_MIN_F64_e64, false, false }, // 1406
  { V_MIN_I16_e64, false, false }, // 1407
  { V_MIN_I16_fake16_e64, false, false }, // 1408
  { V_MIN_I16_opsel_e64, false, false }, // 1409
  { V_MIN_I16_t16_e64, false, false }, // 1410
  { V_MIN_I32_e64, false, false }, // 1411
  { V_MIN_I64_e64, false, false }, // 1412
  { V_MIN_LEGACY_F32_e64, false, false }, // 1413
  { V_MIN_NUM_F64_e64, false, false }, // 1414
  { V_MIN_U16_e64, false, false }, // 1415
  { V_MIN_U16_fake16_e64, false, false }, // 1416
  { V_MIN_U16_opsel_e64, false, false }, // 1417
  { V_MIN_U16_t16_e64, false, false }, // 1418
  { V_MIN_U32_e64, false, false }, // 1419
  { V_MIN_U64_e64, false, false }, // 1420
  { V_MOVRELD_B32_e64, false, false }, // 1421
  { V_MOVRELSD_2_B32_e64, false, false }, // 1422
  { V_MOVRELSD_B32_e64, false, false }, // 1423
  { V_MOVRELS_B32_e64, false, false }, // 1424
  { V_MOV_B16_e64, false, false }, // 1425
  { V_MOV_B16_fake16_e64, false, false }, // 1426
  { V_MOV_B16_t16_e64, false, false }, // 1427
  { V_MOV_B32_e64, false, false }, // 1428
  { V_MOV_B64_e64, false, false }, // 1429
  { V_MQSAD_PK_U16_U8_e64, false, false }, // 1430
  { V_MQSAD_U32_U8_e64, false, false }, // 1431
  { V_MSAD_U8_e64, false, false }, // 1432
  { V_MULLIT_F32_e64, false, false }, // 1433
  { V_MUL_F16_e64, false, false }, // 1434
  { V_MUL_F16_fake16_e64, false, false }, // 1435
  { V_MUL_F16_t16_e64, false, false }, // 1436
  { V_MUL_F32_e64, false, false }, // 1437
  { V_MUL_F64_e64, false, false }, // 1438
  { V_MUL_F64_pseudo_e64, false, false }, // 1439
  { V_MUL_HI_I32_I24_e64, false, false }, // 1440
  { V_MUL_HI_I32_e64, false, false }, // 1441
  { V_MUL_HI_U32_U24_e64, false, false }, // 1442
  { V_MUL_HI_U32_e64, false, false }, // 1443
  { V_MUL_I32_I24_e64, false, false }, // 1444
  { V_MUL_LEGACY_F32_e64, false, false }, // 1445
  { V_MUL_LO_I32_e64, false, false }, // 1446
  { V_MUL_LO_U16_e64, false, false }, // 1447
  { V_MUL_LO_U16_fake16_e64, false, false }, // 1448
  { V_MUL_LO_U16_opsel_e64, false, false }, // 1449
  { V_MUL_LO_U16_t16_e64, false, false }, // 1450
  { V_MUL_LO_U32_e64, false, false }, // 1451
  { V_MUL_U32_U24_e64, false, false }, // 1452
  { V_MUL_U64_e64, false, false }, // 1453
  { V_NOP_e64, false, false }, // 1454
  { V_NOT_B16_e64, false, false }, // 1455
  { V_NOT_B16_fake16_e64, false, false }, // 1456
  { V_NOT_B16_t16_e64, false, false }, // 1457
  { V_NOT_B32_e64, false, false }, // 1458
  { V_OR3_B32_e64, false, false }, // 1459
  { V_OR_B16_fake16_e64, false, false }, // 1460
  { V_OR_B16_t16_e64, false, false }, // 1461
  { V_OR_B32_e64, false, false }, // 1462
  { V_PACK_B32_F16_e64, false, false }, // 1463
  { V_PACK_B32_F16_fake16_e64, false, false }, // 1464
  { V_PACK_B32_F16_t16_e64, false, false }, // 1465
  { V_PERMLANE16_B32_e64, false, false }, // 1466
  { V_PERMLANE16_SWAP_B32_e64, false, false }, // 1467
  { V_PERMLANE16_VAR_B32_e64, false, false }, // 1468
  { V_PERMLANE32_SWAP_B32_e64, false, false }, // 1469
  { V_PERMLANEX16_B32_e64, false, false }, // 1470
  { V_PERMLANEX16_VAR_B32_e64, false, false }, // 1471
  { V_PERMLANE_BCAST_B32_e64, false, false }, // 1472
  { V_PERMLANE_DOWN_B32_e64, false, false }, // 1473
  { V_PERMLANE_IDX_GEN_B32_e64, false, false }, // 1474
  { V_PERMLANE_UP_B32_e64, false, false }, // 1475
  { V_PERMLANE_XOR_B32_e64, false, false }, // 1476
  { V_PERM_B32_e64, false, false }, // 1477
  { V_PERM_PK16_B4_U4_e64, false, false }, // 1478
  { V_PERM_PK16_B6_U4_e64, false, false }, // 1479
  { V_PERM_PK16_B8_U4_e64, false, false }, // 1480
  { V_PIPEFLUSH_e64, false, false }, // 1481
  { V_PK_ADD_BF16, false, false }, // 1482
  { V_PK_ADD_F16, false, false }, // 1483
  { V_PK_ADD_F32, false, false }, // 1484
  { V_PK_ADD_I16, false, false }, // 1485
  { V_PK_ADD_MAX_I16, false, false }, // 1486
  { V_PK_ADD_MAX_U16, false, false }, // 1487
  { V_PK_ADD_MIN_I16, false, false }, // 1488
  { V_PK_ADD_MIN_U16, false, false }, // 1489
  { V_PK_ADD_U16, false, false }, // 1490
  { V_PK_ASHRREV_I16, false, false }, // 1491
  { V_PK_FMAC_F16_e64, false, false }, // 1492
  { V_PK_FMA_BF16, false, false }, // 1493
  { V_PK_FMA_F16, false, false }, // 1494
  { V_PK_FMA_F32, false, false }, // 1495
  { V_PK_LSHLREV_B16, false, false }, // 1496
  { V_PK_LSHRREV_B16, false, false }, // 1497
  { V_PK_MAD_I16, false, false }, // 1498
  { V_PK_MAD_U16, false, false }, // 1499
  { V_PK_MAX3_I16, false, false }, // 1500
  { V_PK_MAX3_NUM_F16, false, false }, // 1501
  { V_PK_MAX3_U16, false, false }, // 1502
  { V_PK_MAXIMUM3_F16, false, false }, // 1503
  { V_PK_MAXIMUM_F16, false, false }, // 1504
  { V_PK_MAX_F16, false, false }, // 1505
  { V_PK_MAX_I16, false, false }, // 1506
  { V_PK_MAX_NUM_BF16, false, false }, // 1507
  { V_PK_MAX_U16, false, false }, // 1508
  { V_PK_MIN3_I16, false, false }, // 1509
  { V_PK_MIN3_NUM_F16, false, false }, // 1510
  { V_PK_MIN3_U16, false, false }, // 1511
  { V_PK_MINIMUM3_F16, false, false }, // 1512
  { V_PK_MINIMUM_F16, false, false }, // 1513
  { V_PK_MIN_F16, false, false }, // 1514
  { V_PK_MIN_I16, false, false }, // 1515
  { V_PK_MIN_NUM_BF16, false, false }, // 1516
  { V_PK_MIN_U16, false, false }, // 1517
  { V_PK_MOV_B32, false, false }, // 1518
  { V_PK_MUL_BF16, false, false }, // 1519
  { V_PK_MUL_F16, false, false }, // 1520
  { V_PK_MUL_F32, false, false }, // 1521
  { V_PK_MUL_LO_U16, false, false }, // 1522
  { V_PK_SUB_I16, false, false }, // 1523
  { V_PK_SUB_U16, false, false }, // 1524
  { V_PRNG_B32_e64, false, false }, // 1525
  { V_QSAD_PK_U16_U8_e64, false, false }, // 1526
  { V_RCP_BF16_e64, false, false }, // 1527
  { V_RCP_BF16_fake16_e64, false, false }, // 1528
  { V_RCP_BF16_t16_e64, false, false }, // 1529
  { V_RCP_CLAMP_F32_e64, false, false }, // 1530
  { V_RCP_CLAMP_F64_e64, false, false }, // 1531
  { V_RCP_F16_e64, false, false }, // 1532
  { V_RCP_F16_fake16_e64, false, false }, // 1533
  { V_RCP_F16_t16_e64, false, false }, // 1534
  { V_RCP_F32_e64, false, false }, // 1535
  { V_RCP_F64_e64, false, false }, // 1536
  { V_RCP_IFLAG_F32_e64, false, false }, // 1537
  { V_RCP_LEGACY_F32_e64, false, false }, // 1538
  { V_RNDNE_F16_e64, false, false }, // 1539
  { V_RNDNE_F16_fake16_e64, false, false }, // 1540
  { V_RNDNE_F16_t16_e64, false, false }, // 1541
  { V_RNDNE_F32_e64, false, false }, // 1542
  { V_RNDNE_F64_e64, false, false }, // 1543
  { V_RSQ_BF16_e64, false, false }, // 1544
  { V_RSQ_BF16_fake16_e64, false, false }, // 1545
  { V_RSQ_BF16_t16_e64, false, false }, // 1546
  { V_RSQ_CLAMP_F32_e64, false, false }, // 1547
  { V_RSQ_CLAMP_F64_e64, false, false }, // 1548
  { V_RSQ_F16_e64, false, false }, // 1549
  { V_RSQ_F16_fake16_e64, false, false }, // 1550
  { V_RSQ_F16_t16_e64, false, false }, // 1551
  { V_RSQ_F32_e64, false, false }, // 1552
  { V_RSQ_F64_e64, false, false }, // 1553
  { V_RSQ_LEGACY_F32_e64, false, false }, // 1554
  { V_SAD_HI_U8_e64, false, false }, // 1555
  { V_SAD_U16_e64, false, false }, // 1556
  { V_SAD_U32_e64, false, false }, // 1557
  { V_SAD_U8_e64, false, false }, // 1558
  { V_SAT_PK4_I4_I8_e64, false, false }, // 1559
  { V_SAT_PK4_I4_I8_fake16_e64, false, false }, // 1560
  { V_SAT_PK4_I4_I8_t16_e64, false, false }, // 1561
  { V_SAT_PK4_U4_U8_e64, false, false }, // 1562
  { V_SAT_PK4_U4_U8_fake16_e64, false, false }, // 1563
  { V_SAT_PK4_U4_U8_t16_e64, false, false }, // 1564
  { V_SAT_PK_U8_I16_e64, false, false }, // 1565
  { V_SAT_PK_U8_I16_fake16_e64, false, false }, // 1566
  { V_SAT_PK_U8_I16_t16_e64, false, false }, // 1567
  { V_SCREEN_PARTITION_4SE_B32_e64, false, false }, // 1568
  { V_SET_INACTIVE_B32, false, false }, // 1569
  { V_SIN_BF16_e64, false, false }, // 1570
  { V_SIN_BF16_fake16_e64, false, false }, // 1571
  { V_SIN_BF16_t16_e64, false, false }, // 1572
  { V_SIN_F16_e64, false, false }, // 1573
  { V_SIN_F16_fake16_e64, false, false }, // 1574
  { V_SIN_F16_t16_e64, false, false }, // 1575
  { V_SIN_F32_e64, false, false }, // 1576
  { V_SMFMAC_F32_16X16X128_BF8_BF8_e64, false, false }, // 1577
  { V_SMFMAC_F32_16X16X128_BF8_FP8_e64, false, false }, // 1578
  { V_SMFMAC_F32_16X16X128_FP8_BF8_e64, false, false }, // 1579
  { V_SMFMAC_F32_16X16X128_FP8_FP8_e64, false, false }, // 1580
  { V_SMFMAC_F32_16X16X32_BF16_e64, false, false }, // 1581
  { V_SMFMAC_F32_16X16X32_F16_e64, false, false }, // 1582
  { V_SMFMAC_F32_16X16X64_BF16_e64, false, false }, // 1583
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false, false }, // 1584
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false, false }, // 1585
  { V_SMFMAC_F32_16X16X64_F16_e64, false, false }, // 1586
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false, false }, // 1587
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false, false }, // 1588
  { V_SMFMAC_F32_32X32X16_BF16_e64, false, false }, // 1589
  { V_SMFMAC_F32_32X32X16_F16_e64, false, false }, // 1590
  { V_SMFMAC_F32_32X32X32_BF16_e64, false, false }, // 1591
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false, false }, // 1592
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false, false }, // 1593
  { V_SMFMAC_F32_32X32X32_F16_e64, false, false }, // 1594
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false, false }, // 1595
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false, false }, // 1596
  { V_SMFMAC_F32_32X32X64_BF8_BF8_e64, false, false }, // 1597
  { V_SMFMAC_F32_32X32X64_BF8_FP8_e64, false, false }, // 1598
  { V_SMFMAC_F32_32X32X64_FP8_BF8_e64, false, false }, // 1599
  { V_SMFMAC_F32_32X32X64_FP8_FP8_e64, false, false }, // 1600
  { V_SMFMAC_I32_16X16X128_I8_e64, false, false }, // 1601
  { V_SMFMAC_I32_16X16X64_I8_e64, false, false }, // 1602
  { V_SMFMAC_I32_32X32X32_I8_e64, false, false }, // 1603
  { V_SMFMAC_I32_32X32X64_I8_e64, false, false }, // 1604
  { V_SQRT_BF16_e64, false, false }, // 1605
  { V_SQRT_BF16_fake16_e64, false, false }, // 1606
  { V_SQRT_BF16_t16_e64, false, false }, // 1607
  { V_SQRT_F16_e64, false, false }, // 1608
  { V_SQRT_F16_fake16_e64, false, false }, // 1609
  { V_SQRT_F16_t16_e64, false, false }, // 1610
  { V_SQRT_F32_e64, false, false }, // 1611
  { V_SQRT_F64_e64, false, false }, // 1612
  { V_SUBBREV_U32_e64, false, false }, // 1613
  { V_SUBB_U32_e64, false, false }, // 1614
  { V_SUBREV_CO_U32_e64, false, false }, // 1615
  { V_SUBREV_F16_e64, false, false }, // 1616
  { V_SUBREV_F16_fake16_e64, false, false }, // 1617
  { V_SUBREV_F16_t16_e64, false, false }, // 1618
  { V_SUBREV_F32_e64, false, false }, // 1619
  { V_SUBREV_U16_e64, false, false }, // 1620
  { V_SUBREV_U32_e64, false, false }, // 1621
  { V_SUB_CO_U32_e64, false, false }, // 1622
  { V_SUB_F16_e64, false, false }, // 1623
  { V_SUB_F16_fake16_e64, false, false }, // 1624
  { V_SUB_F16_t16_e64, false, false }, // 1625
  { V_SUB_F32_e64, false, false }, // 1626
  { V_SUB_I16_e64, false, false }, // 1627
  { V_SUB_I16_fake16_e64, false, false }, // 1628
  { V_SUB_I16_t16_e64, false, false }, // 1629
  { V_SUB_I32_e64, false, false }, // 1630
  { V_SUB_NC_U16_e64, false, false }, // 1631
  { V_SUB_NC_U16_fake16_e64, false, false }, // 1632
  { V_SUB_NC_U16_t16_e64, false, false }, // 1633
  { V_SUB_U16_e64, false, false }, // 1634
  { V_SUB_U32_e64, false, false }, // 1635
  { V_SUB_U64_e64, false, false }, // 1636
  { V_SWMMAC_BF16F32_16X16X64_BF16_w32_twoaddr, false, false }, // 1637
  { V_SWMMAC_BF16_16X16X32_BF16_w32_twoaddr, false, false }, // 1638
  { V_SWMMAC_BF16_16X16X32_BF16_w64_twoaddr, false, false }, // 1639
  { V_SWMMAC_BF16_16X16X64_BF16_w32_twoaddr, false, false }, // 1640
  { V_SWMMAC_F16_16X16X128_BF8_BF8_w32_twoaddr, false, false }, // 1641
  { V_SWMMAC_F16_16X16X128_BF8_FP8_w32_twoaddr, false, false }, // 1642
  { V_SWMMAC_F16_16X16X128_FP8_BF8_w32_twoaddr, false, false }, // 1643
  { V_SWMMAC_F16_16X16X128_FP8_FP8_w32_twoaddr, false, false }, // 1644
  { V_SWMMAC_F16_16X16X32_F16_w32_twoaddr, false, false }, // 1645
  { V_SWMMAC_F16_16X16X32_F16_w64_twoaddr, false, false }, // 1646
  { V_SWMMAC_F16_16X16X64_F16_w32_twoaddr, false, false }, // 1647
  { V_SWMMAC_F32_16X16X128_BF8_BF8_w32_twoaddr, false, false }, // 1648
  { V_SWMMAC_F32_16X16X128_BF8_FP8_w32_twoaddr, false, false }, // 1649
  { V_SWMMAC_F32_16X16X128_FP8_BF8_w32_twoaddr, false, false }, // 1650
  { V_SWMMAC_F32_16X16X128_FP8_FP8_w32_twoaddr, false, false }, // 1651
  { V_SWMMAC_F32_16X16X32_BF16_w32_twoaddr, false, false }, // 1652
  { V_SWMMAC_F32_16X16X32_BF16_w64_twoaddr, false, false }, // 1653
  { V_SWMMAC_F32_16X16X32_BF8_BF8_w32_twoaddr, false, false }, // 1654
  { V_SWMMAC_F32_16X16X32_BF8_BF8_w64_twoaddr, false, false }, // 1655
  { V_SWMMAC_F32_16X16X32_BF8_FP8_w32_twoaddr, false, false }, // 1656
  { V_SWMMAC_F32_16X16X32_BF8_FP8_w64_twoaddr, false, false }, // 1657
  { V_SWMMAC_F32_16X16X32_F16_w32_twoaddr, false, false }, // 1658
  { V_SWMMAC_F32_16X16X32_F16_w64_twoaddr, false, false }, // 1659
  { V_SWMMAC_F32_16X16X32_FP8_BF8_w32_twoaddr, false, false }, // 1660
  { V_SWMMAC_F32_16X16X32_FP8_BF8_w64_twoaddr, false, false }, // 1661
  { V_SWMMAC_F32_16X16X32_FP8_FP8_w32_twoaddr, false, false }, // 1662
  { V_SWMMAC_F32_16X16X32_FP8_FP8_w64_twoaddr, false, false }, // 1663
  { V_SWMMAC_F32_16X16X64_BF16_w32_twoaddr, false, false }, // 1664
  { V_SWMMAC_F32_16X16X64_F16_w32_twoaddr, false, false }, // 1665
  { V_SWMMAC_I32_16X16X128_IU8_w32_twoaddr, false, false }, // 1666
  { V_SWMMAC_I32_16X16X32_IU4_w32_twoaddr, false, false }, // 1667
  { V_SWMMAC_I32_16X16X32_IU4_w64_twoaddr, false, false }, // 1668
  { V_SWMMAC_I32_16X16X32_IU8_w32_twoaddr, false, false }, // 1669
  { V_SWMMAC_I32_16X16X32_IU8_w64_twoaddr, false, false }, // 1670
  { V_SWMMAC_I32_16X16X64_IU4_w32_twoaddr, false, false }, // 1671
  { V_SWMMAC_I32_16X16X64_IU4_w64_twoaddr, false, false }, // 1672
  { V_S_EXP_F16_e64, false, false }, // 1673
  { V_S_EXP_F32_e64, false, false }, // 1674
  { V_S_LOG_F16_e64, false, false }, // 1675
  { V_S_LOG_F32_e64, false, false }, // 1676
  { V_S_RCP_F16_e64, false, false }, // 1677
  { V_S_RCP_F32_e64, false, false }, // 1678
  { V_S_RSQ_F16_e64, false, false }, // 1679
  { V_S_RSQ_F32_e64, false, false }, // 1680
  { V_S_SQRT_F16_e64, false, false }, // 1681
  { V_S_SQRT_F32_e64, false, false }, // 1682
  { V_TANH_BF16_e64, false, false }, // 1683
  { V_TANH_BF16_fake16_e64, false, false }, // 1684
  { V_TANH_BF16_t16_e64, false, false }, // 1685
  { V_TANH_F16_e64, false, false }, // 1686
  { V_TANH_F16_fake16_e64, false, false }, // 1687
  { V_TANH_F16_t16_e64, false, false }, // 1688
  { V_TANH_F32_e64, false, false }, // 1689
  { V_TRIG_PREOP_F64_e64, false, false }, // 1690
  { V_TRUNC_F16_e64, false, false }, // 1691
  { V_TRUNC_F16_fake16_e64, false, false }, // 1692
  { V_TRUNC_F16_t16_e64, false, false }, // 1693
  { V_TRUNC_F32_e64, false, false }, // 1694
  { V_TRUNC_F64_e64, false, false }, // 1695
  { V_WMMA_BF16F32_16X16X32_BF16_w32_threeaddr, false, false }, // 1696
  { V_WMMA_BF16F32_16X16X32_BF16_w32_twoaddr, false, false }, // 1697
  { V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w32, false, false }, // 1698
  { V_WMMA_BF16_16X16X16_BF16_TIED_twoaddr_w64, false, false }, // 1699
  { V_WMMA_BF16_16X16X16_BF16_threeaddr_w32, false, false }, // 1700
  { V_WMMA_BF16_16X16X16_BF16_threeaddr_w64, false, false }, // 1701
  { V_WMMA_BF16_16X16X16_BF16_twoaddr_w32, false, false }, // 1702
  { V_WMMA_BF16_16X16X16_BF16_twoaddr_w64, false, false }, // 1703
  { V_WMMA_BF16_16X16X16_BF16_w32_threeaddr, false, false }, // 1704
  { V_WMMA_BF16_16X16X16_BF16_w32_twoaddr, false, false }, // 1705
  { V_WMMA_BF16_16X16X16_BF16_w64_threeaddr, false, false }, // 1706
  { V_WMMA_BF16_16X16X16_BF16_w64_twoaddr, false, false }, // 1707
  { V_WMMA_BF16_16X16X32_BF16_w32_threeaddr, false, false }, // 1708
  { V_WMMA_BF16_16X16X32_BF16_w32_twoaddr, false, false }, // 1709
  { V_WMMA_F16_16X16X128_BF8_BF8_w32_threeaddr, false, false }, // 1710
  { V_WMMA_F16_16X16X128_BF8_BF8_w32_twoaddr, false, false }, // 1711
  { V_WMMA_F16_16X16X128_BF8_FP8_w32_threeaddr, false, false }, // 1712
  { V_WMMA_F16_16X16X128_BF8_FP8_w32_twoaddr, false, false }, // 1713
  { V_WMMA_F16_16X16X128_FP8_BF8_w32_threeaddr, false, false }, // 1714
  { V_WMMA_F16_16X16X128_FP8_BF8_w32_twoaddr, false, false }, // 1715
  { V_WMMA_F16_16X16X128_FP8_FP8_w32_threeaddr, false, false }, // 1716
  { V_WMMA_F16_16X16X128_FP8_FP8_w32_twoaddr, false, false }, // 1717
  { V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w32, false, false }, // 1718
  { V_WMMA_F16_16X16X16_F16_TIED_twoaddr_w64, false, false }, // 1719
  { V_WMMA_F16_16X16X16_F16_threeaddr_w32, false, false }, // 1720
  { V_WMMA_F16_16X16X16_F16_threeaddr_w64, false, false }, // 1721
  { V_WMMA_F16_16X16X16_F16_twoaddr_w32, false, false }, // 1722
  { V_WMMA_F16_16X16X16_F16_twoaddr_w64, false, false }, // 1723
  { V_WMMA_F16_16X16X16_F16_w32_threeaddr, false, false }, // 1724
  { V_WMMA_F16_16X16X16_F16_w32_twoaddr, false, false }, // 1725
  { V_WMMA_F16_16X16X16_F16_w64_threeaddr, false, false }, // 1726
  { V_WMMA_F16_16X16X16_F16_w64_twoaddr, false, false }, // 1727
  { V_WMMA_F16_16X16X32_F16_w32_threeaddr, false, false }, // 1728
  { V_WMMA_F16_16X16X32_F16_w32_twoaddr, false, false }, // 1729
  { V_WMMA_F16_16X16X64_BF8_BF8_w32_threeaddr, false, false }, // 1730
  { V_WMMA_F16_16X16X64_BF8_BF8_w32_twoaddr, false, false }, // 1731
  { V_WMMA_F16_16X16X64_BF8_FP8_w32_threeaddr, false, false }, // 1732
  { V_WMMA_F16_16X16X64_BF8_FP8_w32_twoaddr, false, false }, // 1733
  { V_WMMA_F16_16X16X64_FP8_BF8_w32_threeaddr, false, false }, // 1734
  { V_WMMA_F16_16X16X64_FP8_BF8_w32_twoaddr, false, false }, // 1735
  { V_WMMA_F16_16X16X64_FP8_FP8_w32_threeaddr, false, false }, // 1736
  { V_WMMA_F16_16X16X64_FP8_FP8_w32_twoaddr, false, false }, // 1737
  { V_WMMA_F32_16X16X128_BF8_BF8_w32_threeaddr, false, false }, // 1738
  { V_WMMA_F32_16X16X128_BF8_BF8_w32_twoaddr, false, false }, // 1739
  { V_WMMA_F32_16X16X128_BF8_FP8_w32_threeaddr, false, false }, // 1740
  { V_WMMA_F32_16X16X128_BF8_FP8_w32_twoaddr, false, false }, // 1741
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr, false, false }, // 1742
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr, false, false }, // 1743
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr, false, false }, // 1744
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr, false, false }, // 1745
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr, false, false }, // 1746
  { V_WMMA_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr, false, false }, // 1747
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr, false, false }, // 1748
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr, false, false }, // 1749
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr, false, false }, // 1750
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr, false, false }, // 1751
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr, false, false }, // 1752
  { V_WMMA_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr, false, false }, // 1753
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr, false, false }, // 1754
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr, false, false }, // 1755
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr, false, false }, // 1756
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr, false, false }, // 1757
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr, false, false }, // 1758
  { V_WMMA_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr, false, false }, // 1759
  { V_WMMA_F32_16X16X128_FP8_BF8_w32_threeaddr, false, false }, // 1760
  { V_WMMA_F32_16X16X128_FP8_BF8_w32_twoaddr, false, false }, // 1761
  { V_WMMA_F32_16X16X128_FP8_FP8_w32_threeaddr, false, false }, // 1762
  { V_WMMA_F32_16X16X128_FP8_FP8_w32_twoaddr, false, false }, // 1763
  { V_WMMA_F32_16X16X16_BF16_threeaddr_w32, false, false }, // 1764
  { V_WMMA_F32_16X16X16_BF16_threeaddr_w64, false, false }, // 1765
  { V_WMMA_F32_16X16X16_BF16_twoaddr_w32, false, false }, // 1766
  { V_WMMA_F32_16X16X16_BF16_twoaddr_w64, false, false }, // 1767
  { V_WMMA_F32_16X16X16_BF16_w32_threeaddr, false, false }, // 1768
  { V_WMMA_F32_16X16X16_BF16_w32_twoaddr, false, false }, // 1769
  { V_WMMA_F32_16X16X16_BF16_w64_threeaddr, false, false }, // 1770
  { V_WMMA_F32_16X16X16_BF16_w64_twoaddr, false, false }, // 1771
  { V_WMMA_F32_16X16X16_BF8_BF8_w32_threeaddr, false, false }, // 1772
  { V_WMMA_F32_16X16X16_BF8_BF8_w32_twoaddr, false, false }, // 1773
  { V_WMMA_F32_16X16X16_BF8_BF8_w64_threeaddr, false, false }, // 1774
  { V_WMMA_F32_16X16X16_BF8_BF8_w64_twoaddr, false, false }, // 1775
  { V_WMMA_F32_16X16X16_BF8_FP8_w32_threeaddr, false, false }, // 1776
  { V_WMMA_F32_16X16X16_BF8_FP8_w32_twoaddr, false, false }, // 1777
  { V_WMMA_F32_16X16X16_BF8_FP8_w64_threeaddr, false, false }, // 1778
  { V_WMMA_F32_16X16X16_BF8_FP8_w64_twoaddr, false, false }, // 1779
  { V_WMMA_F32_16X16X16_F16_threeaddr_w32, false, false }, // 1780
  { V_WMMA_F32_16X16X16_F16_threeaddr_w64, false, false }, // 1781
  { V_WMMA_F32_16X16X16_F16_twoaddr_w32, false, false }, // 1782
  { V_WMMA_F32_16X16X16_F16_twoaddr_w64, false, false }, // 1783
  { V_WMMA_F32_16X16X16_F16_w32_threeaddr, false, false }, // 1784
  { V_WMMA_F32_16X16X16_F16_w32_twoaddr, false, false }, // 1785
  { V_WMMA_F32_16X16X16_F16_w64_threeaddr, false, false }, // 1786
  { V_WMMA_F32_16X16X16_F16_w64_twoaddr, false, false }, // 1787
  { V_WMMA_F32_16X16X16_FP8_BF8_w32_threeaddr, false, false }, // 1788
  { V_WMMA_F32_16X16X16_FP8_BF8_w32_twoaddr, false, false }, // 1789
  { V_WMMA_F32_16X16X16_FP8_BF8_w64_threeaddr, false, false }, // 1790
  { V_WMMA_F32_16X16X16_FP8_BF8_w64_twoaddr, false, false }, // 1791
  { V_WMMA_F32_16X16X16_FP8_FP8_w32_threeaddr, false, false }, // 1792
  { V_WMMA_F32_16X16X16_FP8_FP8_w32_twoaddr, false, false }, // 1793
  { V_WMMA_F32_16X16X16_FP8_FP8_w64_threeaddr, false, false }, // 1794
  { V_WMMA_F32_16X16X16_FP8_FP8_w64_twoaddr, false, false }, // 1795
  { V_WMMA_F32_16X16X32_BF16_w32_threeaddr, false, false }, // 1796
  { V_WMMA_F32_16X16X32_BF16_w32_twoaddr, false, false }, // 1797
  { V_WMMA_F32_16X16X32_F16_w32_threeaddr, false, false }, // 1798
  { V_WMMA_F32_16X16X32_F16_w32_twoaddr, false, false }, // 1799
  { V_WMMA_F32_16X16X4_F32_w32_threeaddr, false, false }, // 1800
  { V_WMMA_F32_16X16X4_F32_w32_twoaddr, false, false }, // 1801
  { V_WMMA_F32_16X16X64_BF8_BF8_w32_threeaddr, false, false }, // 1802
  { V_WMMA_F32_16X16X64_BF8_BF8_w32_twoaddr, false, false }, // 1803
  { V_WMMA_F32_16X16X64_BF8_FP8_w32_threeaddr, false, false }, // 1804
  { V_WMMA_F32_16X16X64_BF8_FP8_w32_twoaddr, false, false }, // 1805
  { V_WMMA_F32_16X16X64_FP8_BF8_w32_threeaddr, false, false }, // 1806
  { V_WMMA_F32_16X16X64_FP8_BF8_w32_twoaddr, false, false }, // 1807
  { V_WMMA_F32_16X16X64_FP8_FP8_w32_threeaddr, false, false }, // 1808
  { V_WMMA_F32_16X16X64_FP8_FP8_w32_twoaddr, false, false }, // 1809
  { V_WMMA_F32_32X16X128_F4_w32_threeaddr, false, false }, // 1810
  { V_WMMA_F32_32X16X128_F4_w32_twoaddr, false, false }, // 1811
  { V_WMMA_I32_16X16X16_IU4_threeaddr_w32, false, false }, // 1812
  { V_WMMA_I32_16X16X16_IU4_threeaddr_w64, false, false }, // 1813
  { V_WMMA_I32_16X16X16_IU4_twoaddr_w32, false, false }, // 1814
  { V_WMMA_I32_16X16X16_IU4_twoaddr_w64, false, false }, // 1815
  { V_WMMA_I32_16X16X16_IU4_w32_threeaddr, false, false }, // 1816
  { V_WMMA_I32_16X16X16_IU4_w32_twoaddr, false, false }, // 1817
  { V_WMMA_I32_16X16X16_IU4_w64_threeaddr, false, false }, // 1818
  { V_WMMA_I32_16X16X16_IU4_w64_twoaddr, false, false }, // 1819
  { V_WMMA_I32_16X16X16_IU8_threeaddr_w32, false, false }, // 1820
  { V_WMMA_I32_16X16X16_IU8_threeaddr_w64, false, false }, // 1821
  { V_WMMA_I32_16X16X16_IU8_twoaddr_w32, false, false }, // 1822
  { V_WMMA_I32_16X16X16_IU8_twoaddr_w64, false, false }, // 1823
  { V_WMMA_I32_16X16X16_IU8_w32_threeaddr, false, false }, // 1824
  { V_WMMA_I32_16X16X16_IU8_w32_twoaddr, false, false }, // 1825
  { V_WMMA_I32_16X16X16_IU8_w64_threeaddr, false, false }, // 1826
  { V_WMMA_I32_16X16X16_IU8_w64_twoaddr, false, false }, // 1827
  { V_WMMA_I32_16X16X32_IU4_w32_threeaddr, false, false }, // 1828
  { V_WMMA_I32_16X16X32_IU4_w32_twoaddr, false, false }, // 1829
  { V_WMMA_I32_16X16X32_IU4_w64_threeaddr, false, false }, // 1830
  { V_WMMA_I32_16X16X32_IU4_w64_twoaddr, false, false }, // 1831
  { V_WMMA_I32_16X16X64_IU8_w32_threeaddr, false, false }, // 1832
  { V_WMMA_I32_16X16X64_IU8_w32_twoaddr, false, false }, // 1833
  { V_WMMA_LD_SCALE16_PAIRED_B64, false, false }, // 1834
  { V_WMMA_LD_SCALE_PAIRED_B32, false, false }, // 1835
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr, false, false }, // 1836
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr, false, false }, // 1837
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr, false, false }, // 1838
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr, false, false }, // 1839
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr, false, false }, // 1840
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr, false, false }, // 1841
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr, false, false }, // 1842
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr, false, false }, // 1843
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr, false, false }, // 1844
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr, false, false }, // 1845
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr, false, false }, // 1846
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr, false, false }, // 1847
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr, false, false }, // 1848
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr, false, false }, // 1849
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr, false, false }, // 1850
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr, false, false }, // 1851
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr, false, false }, // 1852
  { V_WMMA_SCALE16_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr, false, false }, // 1853
  { V_WMMA_SCALE16_F32_32X16X128_F4_w32_threeaddr, false, false }, // 1854
  { V_WMMA_SCALE16_F32_32X16X128_F4_w32_twoaddr, false, false }, // 1855
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_w32_threeaddr, false, false }, // 1856
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_w32_twoaddr, false, false }, // 1857
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_w32_threeaddr, false, false }, // 1858
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_w32_twoaddr, false, false }, // 1859
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_w32_threeaddr, false, false }, // 1860
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_w32_twoaddr, false, false }, // 1861
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_w32_threeaddr, false, false }, // 1862
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_w32_twoaddr, false, false }, // 1863
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_w32_threeaddr, false, false }, // 1864
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_w32_twoaddr, false, false }, // 1865
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_w32_threeaddr, false, false }, // 1866
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_w32_twoaddr, false, false }, // 1867
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_w32_threeaddr, false, false }, // 1868
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_w32_twoaddr, false, false }, // 1869
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_w32_threeaddr, false, false }, // 1870
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_w32_twoaddr, false, false }, // 1871
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_w32_threeaddr, false, false }, // 1872
  { V_WMMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_w32_twoaddr, false, false }, // 1873
  { V_WMMA_SCALE_F32_32X16X128_F4_w32_threeaddr, false, false }, // 1874
  { V_WMMA_SCALE_F32_32X16X128_F4_w32_twoaddr, false, false }, // 1875
  { V_XAD_U32_e64, false, false }, // 1876
  { V_XNOR_B32_e64, false, false }, // 1877
  { V_XOR3_B32_e64, false, false }, // 1878
  { V_XOR_B16_fake16_e64, false, false }, // 1879
  { V_XOR_B16_t16_e64, false, false }, // 1880
  { V_XOR_B32_e64, false, false }, // 1881
 };

const FP4FP8DstByteSelInfo *getFP4FP8DstByteSelHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  struct Comp {
    bool operator()(const FP4FP8DstByteSelInfo &LHS, const KeyType &RHS) const {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(FP4FP8DstByteSelTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_Gfx9BufferFormat_DECL
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx9BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx9BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x11, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x21, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x31, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x41, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x51, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0x3, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0x13, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x23, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x33, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x43, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x53, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0xA, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x1A, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3A, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x4A, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x5A, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x2, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x12, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x22, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0x32, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0x42, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0x52, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0x72, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x5, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x15, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x25, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x35, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x45, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x55, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x75, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0xC, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x1C, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x2C, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x3C, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x4C, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x5C, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x7C, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x44, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x54, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x74, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x4B, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x5B, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x7B, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x4D, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x5D, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x7D, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4E, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x5E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x7E, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx9BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx9BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 18 },
    { 0x3, 6 },
    { 0x5, 25 },
    { 0xA, 12 },
    { 0xC, 32 },
    { 0x11, 1 },
    { 0x12, 19 },
    { 0x13, 7 },
    { 0x15, 26 },
    { 0x1A, 13 },
    { 0x1C, 33 },
    { 0x21, 2 },
    { 0x22, 20 },
    { 0x23, 8 },
    { 0x25, 27 },
    { 0x2A, 14 },
    { 0x2C, 34 },
    { 0x31, 3 },
    { 0x32, 21 },
    { 0x33, 9 },
    { 0x35, 28 },
    { 0x3A, 15 },
    { 0x3C, 35 },
    { 0x41, 4 },
    { 0x42, 22 },
    { 0x43, 10 },
    { 0x44, 39 },
    { 0x45, 29 },
    { 0x4A, 16 },
    { 0x4B, 42 },
    { 0x4C, 36 },
    { 0x4D, 45 },
    { 0x4E, 48 },
    { 0x51, 5 },
    { 0x52, 23 },
    { 0x53, 11 },
    { 0x54, 40 },
    { 0x55, 30 },
    { 0x5A, 17 },
    { 0x5B, 43 },
    { 0x5C, 37 },
    { 0x5D, 46 },
    { 0x5E, 49 },
    { 0x72, 24 },
    { 0x74, 41 },
    { 0x75, 31 },
    { 0x7B, 44 },
    { 0x7C, 38 },
    { 0x7D, 47 },
    { 0x7E, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx9BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx10BufferFormat_DECL
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx10BufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx10BufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x38, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x39, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x3A, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x3B, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x3C, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x3D, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x41, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x42, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x43, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x44, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x45, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x46, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x47, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x3E, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x3F, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x40, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x48, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x49, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x4A, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x4B, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x4C, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x4D, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx10BufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx10BufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x38, 12 },
    { 0x39, 13 },
    { 0x3A, 14 },
    { 0x3B, 15 },
    { 0x3C, 16 },
    { 0x3D, 17 },
    { 0x3E, 42 },
    { 0x3F, 43 },
    { 0x40, 44 },
    { 0x41, 32 },
    { 0x42, 33 },
    { 0x43, 34 },
    { 0x44, 35 },
    { 0x45, 36 },
    { 0x46, 37 },
    { 0x47, 38 },
    { 0x48, 45 },
    { 0x49, 46 },
    { 0x4A, 47 },
    { 0x4B, 48 },
    { 0x4C, 49 },
    { 0x4D, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx10BufferFormat[Idx->_index];
}
#endif

#ifdef GET_Gfx11PlusBufferFormat_DECL
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat);
const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format);
#endif

#ifdef GET_Gfx11PlusBufferFormat_IMPL
constexpr GcnBufferFormatInfo Gfx11PlusBufferFormat[] = {
  { 0x1, 0x8, 0x1, 0x0, 0x1 }, // 0
  { 0x2, 0x8, 0x1, 0x1, 0x1 }, // 1
  { 0x3, 0x8, 0x1, 0x2, 0x1 }, // 2
  { 0x4, 0x8, 0x1, 0x3, 0x1 }, // 3
  { 0x5, 0x8, 0x1, 0x4, 0x1 }, // 4
  { 0x6, 0x8, 0x1, 0x5, 0x1 }, // 5
  { 0xE, 0x8, 0x2, 0x0, 0x3 }, // 6
  { 0xF, 0x8, 0x2, 0x1, 0x3 }, // 7
  { 0x10, 0x8, 0x2, 0x2, 0x3 }, // 8
  { 0x11, 0x8, 0x2, 0x3, 0x3 }, // 9
  { 0x12, 0x8, 0x2, 0x4, 0x3 }, // 10
  { 0x13, 0x8, 0x2, 0x5, 0x3 }, // 11
  { 0x2A, 0x8, 0x4, 0x0, 0xA }, // 12
  { 0x2B, 0x8, 0x4, 0x1, 0xA }, // 13
  { 0x2C, 0x8, 0x4, 0x2, 0xA }, // 14
  { 0x2D, 0x8, 0x4, 0x3, 0xA }, // 15
  { 0x2E, 0x8, 0x4, 0x4, 0xA }, // 16
  { 0x2F, 0x8, 0x4, 0x5, 0xA }, // 17
  { 0x7, 0x10, 0x1, 0x0, 0x2 }, // 18
  { 0x8, 0x10, 0x1, 0x1, 0x2 }, // 19
  { 0x9, 0x10, 0x1, 0x2, 0x2 }, // 20
  { 0xA, 0x10, 0x1, 0x3, 0x2 }, // 21
  { 0xB, 0x10, 0x1, 0x4, 0x2 }, // 22
  { 0xC, 0x10, 0x1, 0x5, 0x2 }, // 23
  { 0xD, 0x10, 0x1, 0x7, 0x2 }, // 24
  { 0x17, 0x10, 0x2, 0x0, 0x5 }, // 25
  { 0x18, 0x10, 0x2, 0x1, 0x5 }, // 26
  { 0x19, 0x10, 0x2, 0x2, 0x5 }, // 27
  { 0x1A, 0x10, 0x2, 0x3, 0x5 }, // 28
  { 0x1B, 0x10, 0x2, 0x4, 0x5 }, // 29
  { 0x1C, 0x10, 0x2, 0x5, 0x5 }, // 30
  { 0x1D, 0x10, 0x2, 0x7, 0x5 }, // 31
  { 0x33, 0x10, 0x4, 0x0, 0xC }, // 32
  { 0x34, 0x10, 0x4, 0x1, 0xC }, // 33
  { 0x35, 0x10, 0x4, 0x2, 0xC }, // 34
  { 0x36, 0x10, 0x4, 0x3, 0xC }, // 35
  { 0x37, 0x10, 0x4, 0x4, 0xC }, // 36
  { 0x38, 0x10, 0x4, 0x5, 0xC }, // 37
  { 0x39, 0x10, 0x4, 0x7, 0xC }, // 38
  { 0x14, 0x20, 0x1, 0x4, 0x4 }, // 39
  { 0x15, 0x20, 0x1, 0x5, 0x4 }, // 40
  { 0x16, 0x20, 0x1, 0x7, 0x4 }, // 41
  { 0x30, 0x20, 0x2, 0x4, 0xB }, // 42
  { 0x31, 0x20, 0x2, 0x5, 0xB }, // 43
  { 0x32, 0x20, 0x2, 0x7, 0xB }, // 44
  { 0x3A, 0x20, 0x3, 0x4, 0xD }, // 45
  { 0x3B, 0x20, 0x3, 0x5, 0xD }, // 46
  { 0x3C, 0x20, 0x3, 0x7, 0xD }, // 47
  { 0x3D, 0x20, 0x4, 0x4, 0xE }, // 48
  { 0x3E, 0x20, 0x4, 0x5, 0xE }, // 49
  { 0x3F, 0x20, 0x4, 0x7, 0xE }, // 50
 };

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t BitsPerComp, uint8_t NumComponents, uint8_t NumFormat) {
  struct KeyType {
    uint8_t BitsPerComp;
    uint8_t NumComponents;
    uint8_t NumFormat;
  };
  KeyType Key = {BitsPerComp, NumComponents, NumFormat};
  struct Comp {
    bool operator()(const GcnBufferFormatInfo &LHS, const KeyType &RHS) const {
      if (LHS.BitsPerComp < RHS.BitsPerComp)
        return true;
      if (LHS.BitsPerComp > RHS.BitsPerComp)
        return false;
      if (LHS.NumComponents < RHS.NumComponents)
        return true;
      if (LHS.NumComponents > RHS.NumComponents)
        return false;
      if (LHS.NumFormat < RHS.NumFormat)
        return true;
      if (LHS.NumFormat > RHS.NumFormat)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Gfx11PlusBufferFormat);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BitsPerComp != Idx->BitsPerComp ||
      Key.NumComponents != Idx->NumComponents ||
      Key.NumFormat != Idx->NumFormat)
    return nullptr;

  return &*Idx;
}

const GcnBufferFormatInfo *getGfx11PlusBufferFormatInfo(uint8_t Format) {
  struct IndexType {
    uint8_t Format;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x1, 0 },
    { 0x2, 1 },
    { 0x3, 2 },
    { 0x4, 3 },
    { 0x5, 4 },
    { 0x6, 5 },
    { 0x7, 18 },
    { 0x8, 19 },
    { 0x9, 20 },
    { 0xA, 21 },
    { 0xB, 22 },
    { 0xC, 23 },
    { 0xD, 24 },
    { 0xE, 6 },
    { 0xF, 7 },
    { 0x10, 8 },
    { 0x11, 9 },
    { 0x12, 10 },
    { 0x13, 11 },
    { 0x14, 39 },
    { 0x15, 40 },
    { 0x16, 41 },
    { 0x17, 25 },
    { 0x18, 26 },
    { 0x19, 27 },
    { 0x1A, 28 },
    { 0x1B, 29 },
    { 0x1C, 30 },
    { 0x1D, 31 },
    { 0x2A, 12 },
    { 0x2B, 13 },
    { 0x2C, 14 },
    { 0x2D, 15 },
    { 0x2E, 16 },
    { 0x2F, 17 },
    { 0x30, 42 },
    { 0x31, 43 },
    { 0x32, 44 },
    { 0x33, 32 },
    { 0x34, 33 },
    { 0x35, 34 },
    { 0x36, 35 },
    { 0x37, 36 },
    { 0x38, 37 },
    { 0x39, 38 },
    { 0x3A, 45 },
    { 0x3B, 46 },
    { 0x3C, 47 },
    { 0x3D, 48 },
    { 0x3E, 49 },
    { 0x3F, 50 },
  };

  struct KeyType {
    uint8_t Format;
  };
  KeyType Key = {Format};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if (LHS.Format < RHS.Format)
        return true;
      if (LHS.Format > RHS.Format)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Format != Idx->Format)
    return nullptr;

  return &Gfx11PlusBufferFormat[Idx->_index];
}
#endif

#ifdef GET_ImageDimIntrinsicTable_DECL
const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr);
const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim);
#endif

#ifdef GET_ImageDimIntrinsicTable_IMPL
constexpr ImageDimIntrinsicInfo ImageDimIntrinsicTable[] = {
  { Intrinsic::amdgcn_image_atomic_add_1d, IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 0
  { Intrinsic::amdgcn_image_atomic_add_1darray, IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 1
  { Intrinsic::amdgcn_image_atomic_add_2d, IMAGE_ATOMIC_ADD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 2
  { Intrinsic::amdgcn_image_atomic_add_2darray, IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 3
  { Intrinsic::amdgcn_image_atomic_add_2darraymsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 4
  { Intrinsic::amdgcn_image_atomic_add_2dmsaa, IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 5
  { Intrinsic::amdgcn_image_atomic_add_3d, IMAGE_ATOMIC_ADD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 6
  { Intrinsic::amdgcn_image_atomic_add_cube, IMAGE_ATOMIC_ADD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 7
  { Intrinsic::amdgcn_image_atomic_add_flt_1d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 8
  { Intrinsic::amdgcn_image_atomic_add_flt_1darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 9
  { Intrinsic::amdgcn_image_atomic_add_flt_2d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 10
  { Intrinsic::amdgcn_image_atomic_add_flt_2darray, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 11
  { Intrinsic::amdgcn_image_atomic_add_flt_2darraymsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 12
  { Intrinsic::amdgcn_image_atomic_add_flt_2dmsaa, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 13
  { Intrinsic::amdgcn_image_atomic_add_flt_3d, IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 14
  { Intrinsic::amdgcn_image_atomic_add_flt_cube, IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 15
  { Intrinsic::amdgcn_image_atomic_and_1d, IMAGE_ATOMIC_AND, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 16
  { Intrinsic::amdgcn_image_atomic_and_1darray, IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 17
  { Intrinsic::amdgcn_image_atomic_and_2d, IMAGE_ATOMIC_AND, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 18
  { Intrinsic::amdgcn_image_atomic_and_2darray, IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 19
  { Intrinsic::amdgcn_image_atomic_and_2darraymsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 20
  { Intrinsic::amdgcn_image_atomic_and_2dmsaa, IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 21
  { Intrinsic::amdgcn_image_atomic_and_3d, IMAGE_ATOMIC_AND, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 22
  { Intrinsic::amdgcn_image_atomic_and_cube, IMAGE_ATOMIC_AND, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 23
  { Intrinsic::amdgcn_image_atomic_cmpswap_1d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x1, 0x6, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 24
  { Intrinsic::amdgcn_image_atomic_cmpswap_1darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 25
  { Intrinsic::amdgcn_image_atomic_cmpswap_2d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x2, 0x7, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 26
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darray, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 27
  { Intrinsic::amdgcn_image_atomic_cmpswap_2darraymsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x4, 0x9, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 28
  { Intrinsic::amdgcn_image_atomic_cmpswap_2dmsaa, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 29
  { Intrinsic::amdgcn_image_atomic_cmpswap_3d, IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 30
  { Intrinsic::amdgcn_image_atomic_cmpswap_cube, IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x2, 0x3, 0x8, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 31
  { Intrinsic::amdgcn_image_atomic_dec_1d, IMAGE_ATOMIC_DEC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 32
  { Intrinsic::amdgcn_image_atomic_dec_1darray, IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 33
  { Intrinsic::amdgcn_image_atomic_dec_2d, IMAGE_ATOMIC_DEC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 34
  { Intrinsic::amdgcn_image_atomic_dec_2darray, IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 35
  { Intrinsic::amdgcn_image_atomic_dec_2darraymsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 36
  { Intrinsic::amdgcn_image_atomic_dec_2dmsaa, IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 37
  { Intrinsic::amdgcn_image_atomic_dec_3d, IMAGE_ATOMIC_DEC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 38
  { Intrinsic::amdgcn_image_atomic_dec_cube, IMAGE_ATOMIC_DEC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 39
  { Intrinsic::amdgcn_image_atomic_fmax_1d, IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 40
  { Intrinsic::amdgcn_image_atomic_fmax_1darray, IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 41
  { Intrinsic::amdgcn_image_atomic_fmax_2d, IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 42
  { Intrinsic::amdgcn_image_atomic_fmax_2darray, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 43
  { Intrinsic::amdgcn_image_atomic_fmax_2darraymsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 44
  { Intrinsic::amdgcn_image_atomic_fmax_2dmsaa, IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 45
  { Intrinsic::amdgcn_image_atomic_fmax_3d, IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 46
  { Intrinsic::amdgcn_image_atomic_fmax_cube, IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 47
  { Intrinsic::amdgcn_image_atomic_fmin_1d, IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 48
  { Intrinsic::amdgcn_image_atomic_fmin_1darray, IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 49
  { Intrinsic::amdgcn_image_atomic_fmin_2d, IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 50
  { Intrinsic::amdgcn_image_atomic_fmin_2darray, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 51
  { Intrinsic::amdgcn_image_atomic_fmin_2darraymsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 52
  { Intrinsic::amdgcn_image_atomic_fmin_2dmsaa, IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 53
  { Intrinsic::amdgcn_image_atomic_fmin_3d, IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 54
  { Intrinsic::amdgcn_image_atomic_fmin_cube, IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 55
  { Intrinsic::amdgcn_image_atomic_inc_1d, IMAGE_ATOMIC_INC, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 56
  { Intrinsic::amdgcn_image_atomic_inc_1darray, IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 57
  { Intrinsic::amdgcn_image_atomic_inc_2d, IMAGE_ATOMIC_INC, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 58
  { Intrinsic::amdgcn_image_atomic_inc_2darray, IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 59
  { Intrinsic::amdgcn_image_atomic_inc_2darraymsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 60
  { Intrinsic::amdgcn_image_atomic_inc_2dmsaa, IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 61
  { Intrinsic::amdgcn_image_atomic_inc_3d, IMAGE_ATOMIC_INC, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 62
  { Intrinsic::amdgcn_image_atomic_inc_cube, IMAGE_ATOMIC_INC, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 63
  { Intrinsic::amdgcn_image_atomic_max_flt_1d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 64
  { Intrinsic::amdgcn_image_atomic_max_flt_1darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 65
  { Intrinsic::amdgcn_image_atomic_max_flt_2d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 66
  { Intrinsic::amdgcn_image_atomic_max_flt_2darray, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 67
  { Intrinsic::amdgcn_image_atomic_max_flt_2darraymsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 68
  { Intrinsic::amdgcn_image_atomic_max_flt_2dmsaa, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 69
  { Intrinsic::amdgcn_image_atomic_max_flt_3d, IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 70
  { Intrinsic::amdgcn_image_atomic_max_flt_cube, IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 71
  { Intrinsic::amdgcn_image_atomic_min_flt_1d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 72
  { Intrinsic::amdgcn_image_atomic_min_flt_1darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 73
  { Intrinsic::amdgcn_image_atomic_min_flt_2d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 74
  { Intrinsic::amdgcn_image_atomic_min_flt_2darray, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 75
  { Intrinsic::amdgcn_image_atomic_min_flt_2darraymsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 76
  { Intrinsic::amdgcn_image_atomic_min_flt_2dmsaa, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 77
  { Intrinsic::amdgcn_image_atomic_min_flt_3d, IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 78
  { Intrinsic::amdgcn_image_atomic_min_flt_cube, IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 79
  { Intrinsic::amdgcn_image_atomic_or_1d, IMAGE_ATOMIC_OR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 80
  { Intrinsic::amdgcn_image_atomic_or_1darray, IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 81
  { Intrinsic::amdgcn_image_atomic_or_2d, IMAGE_ATOMIC_OR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 82
  { Intrinsic::amdgcn_image_atomic_or_2darray, IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 83
  { Intrinsic::amdgcn_image_atomic_or_2darraymsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 84
  { Intrinsic::amdgcn_image_atomic_or_2dmsaa, IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 85
  { Intrinsic::amdgcn_image_atomic_or_3d, IMAGE_ATOMIC_OR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 86
  { Intrinsic::amdgcn_image_atomic_or_cube, IMAGE_ATOMIC_OR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 87
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 88
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_1darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 89
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 90
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darray, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 91
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 92
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_2dmsaa, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 93
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_3d, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 94
  { Intrinsic::amdgcn_image_atomic_pk_add_bf16_cube, IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 95
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 96
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_1darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 97
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 98
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darray, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 99
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2darraymsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 100
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_2dmsaa, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 101
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_3d, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 102
  { Intrinsic::amdgcn_image_atomic_pk_add_f16_cube, IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 103
  { Intrinsic::amdgcn_image_atomic_smax_1d, IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 104
  { Intrinsic::amdgcn_image_atomic_smax_1darray, IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 105
  { Intrinsic::amdgcn_image_atomic_smax_2d, IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 106
  { Intrinsic::amdgcn_image_atomic_smax_2darray, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 107
  { Intrinsic::amdgcn_image_atomic_smax_2darraymsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 108
  { Intrinsic::amdgcn_image_atomic_smax_2dmsaa, IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 109
  { Intrinsic::amdgcn_image_atomic_smax_3d, IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 110
  { Intrinsic::amdgcn_image_atomic_smax_cube, IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 111
  { Intrinsic::amdgcn_image_atomic_smin_1d, IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 112
  { Intrinsic::amdgcn_image_atomic_smin_1darray, IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 113
  { Intrinsic::amdgcn_image_atomic_smin_2d, IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 114
  { Intrinsic::amdgcn_image_atomic_smin_2darray, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 115
  { Intrinsic::amdgcn_image_atomic_smin_2darraymsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 116
  { Intrinsic::amdgcn_image_atomic_smin_2dmsaa, IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 117
  { Intrinsic::amdgcn_image_atomic_smin_3d, IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 118
  { Intrinsic::amdgcn_image_atomic_smin_cube, IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 119
  { Intrinsic::amdgcn_image_atomic_sub_1d, IMAGE_ATOMIC_SUB, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 120
  { Intrinsic::amdgcn_image_atomic_sub_1darray, IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 121
  { Intrinsic::amdgcn_image_atomic_sub_2d, IMAGE_ATOMIC_SUB, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 122
  { Intrinsic::amdgcn_image_atomic_sub_2darray, IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 123
  { Intrinsic::amdgcn_image_atomic_sub_2darraymsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 124
  { Intrinsic::amdgcn_image_atomic_sub_2dmsaa, IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 125
  { Intrinsic::amdgcn_image_atomic_sub_3d, IMAGE_ATOMIC_SUB, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 126
  { Intrinsic::amdgcn_image_atomic_sub_cube, IMAGE_ATOMIC_SUB, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 127
  { Intrinsic::amdgcn_image_atomic_swap_1d, IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 128
  { Intrinsic::amdgcn_image_atomic_swap_1darray, IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 129
  { Intrinsic::amdgcn_image_atomic_swap_2d, IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 130
  { Intrinsic::amdgcn_image_atomic_swap_2darray, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 131
  { Intrinsic::amdgcn_image_atomic_swap_2darraymsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 132
  { Intrinsic::amdgcn_image_atomic_swap_2dmsaa, IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 133
  { Intrinsic::amdgcn_image_atomic_swap_3d, IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 134
  { Intrinsic::amdgcn_image_atomic_swap_cube, IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 135
  { Intrinsic::amdgcn_image_atomic_umax_1d, IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 136
  { Intrinsic::amdgcn_image_atomic_umax_1darray, IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 137
  { Intrinsic::amdgcn_image_atomic_umax_2d, IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 138
  { Intrinsic::amdgcn_image_atomic_umax_2darray, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 139
  { Intrinsic::amdgcn_image_atomic_umax_2darraymsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 140
  { Intrinsic::amdgcn_image_atomic_umax_2dmsaa, IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 141
  { Intrinsic::amdgcn_image_atomic_umax_3d, IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 142
  { Intrinsic::amdgcn_image_atomic_umax_cube, IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 143
  { Intrinsic::amdgcn_image_atomic_umin_1d, IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 144
  { Intrinsic::amdgcn_image_atomic_umin_1darray, IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 145
  { Intrinsic::amdgcn_image_atomic_umin_2d, IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 146
  { Intrinsic::amdgcn_image_atomic_umin_2darray, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 147
  { Intrinsic::amdgcn_image_atomic_umin_2darraymsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 148
  { Intrinsic::amdgcn_image_atomic_umin_2dmsaa, IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 149
  { Intrinsic::amdgcn_image_atomic_umin_3d, IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 150
  { Intrinsic::amdgcn_image_atomic_umin_cube, IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 151
  { Intrinsic::amdgcn_image_atomic_xor_1d, IMAGE_ATOMIC_XOR, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x5, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 152
  { Intrinsic::amdgcn_image_atomic_xor_1darray, IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 153
  { Intrinsic::amdgcn_image_atomic_xor_2d, IMAGE_ATOMIC_XOR, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x2, 0x6, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 154
  { Intrinsic::amdgcn_image_atomic_xor_2darray, IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 155
  { Intrinsic::amdgcn_image_atomic_xor_2darraymsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x4, 0x8, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 156
  { Intrinsic::amdgcn_image_atomic_xor_2dmsaa, IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 157
  { Intrinsic::amdgcn_image_atomic_xor_3d, IMAGE_ATOMIC_XOR, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 158
  { Intrinsic::amdgcn_image_atomic_xor_cube, IMAGE_ATOMIC_XOR, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x0, 0x1, 0x3, 0x7, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 159
  { Intrinsic::amdgcn_image_gather4_2d, IMAGE_GATHER4, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 160
  { Intrinsic::amdgcn_image_gather4_2darray, IMAGE_GATHER4, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 161
  { Intrinsic::amdgcn_image_gather4_b_2d, IMAGE_GATHER4_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 162
  { Intrinsic::amdgcn_image_gather4_b_2darray, IMAGE_GATHER4_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 163
  { Intrinsic::amdgcn_image_gather4_b_cl_2d, IMAGE_GATHER4_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 164
  { Intrinsic::amdgcn_image_gather4_b_cl_2darray, IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 165
  { Intrinsic::amdgcn_image_gather4_b_cl_cube, IMAGE_GATHER4_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 166
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2d, IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 167
  { Intrinsic::amdgcn_image_gather4_b_cl_o_2darray, IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 168
  { Intrinsic::amdgcn_image_gather4_b_cl_o_cube, IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 169
  { Intrinsic::amdgcn_image_gather4_b_cube, IMAGE_GATHER4_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 170
  { Intrinsic::amdgcn_image_gather4_b_o_2d, IMAGE_GATHER4_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 171
  { Intrinsic::amdgcn_image_gather4_b_o_2darray, IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 172
  { Intrinsic::amdgcn_image_gather4_b_o_cube, IMAGE_GATHER4_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 173
  { Intrinsic::amdgcn_image_gather4_c_2d, IMAGE_GATHER4_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 174
  { Intrinsic::amdgcn_image_gather4_c_2darray, IMAGE_GATHER4_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 175
  { Intrinsic::amdgcn_image_gather4_c_b_2d, IMAGE_GATHER4_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 176
  { Intrinsic::amdgcn_image_gather4_c_b_2darray, IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 177
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2d, IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 178
  { Intrinsic::amdgcn_image_gather4_c_b_cl_2darray, IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 179
  { Intrinsic::amdgcn_image_gather4_c_b_cl_cube, IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 180
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2d, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 181
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_2darray, IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 182
  { Intrinsic::amdgcn_image_gather4_c_b_cl_o_cube, IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 183
  { Intrinsic::amdgcn_image_gather4_c_b_cube, IMAGE_GATHER4_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 184
  { Intrinsic::amdgcn_image_gather4_c_b_o_2d, IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 185
  { Intrinsic::amdgcn_image_gather4_c_b_o_2darray, IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 186
  { Intrinsic::amdgcn_image_gather4_c_b_o_cube, IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 187
  { Intrinsic::amdgcn_image_gather4_c_cl_2d, IMAGE_GATHER4_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 188
  { Intrinsic::amdgcn_image_gather4_c_cl_2darray, IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 189
  { Intrinsic::amdgcn_image_gather4_c_cl_cube, IMAGE_GATHER4_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 190
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2d, IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 191
  { Intrinsic::amdgcn_image_gather4_c_cl_o_2darray, IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 192
  { Intrinsic::amdgcn_image_gather4_c_cl_o_cube, IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 193
  { Intrinsic::amdgcn_image_gather4_c_cube, IMAGE_GATHER4_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 194
  { Intrinsic::amdgcn_image_gather4_c_l_2d, IMAGE_GATHER4_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 195
  { Intrinsic::amdgcn_image_gather4_c_l_2darray, IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 196
  { Intrinsic::amdgcn_image_gather4_c_l_cube, IMAGE_GATHER4_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 197
  { Intrinsic::amdgcn_image_gather4_c_l_o_2d, IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 198
  { Intrinsic::amdgcn_image_gather4_c_l_o_2darray, IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 199
  { Intrinsic::amdgcn_image_gather4_c_l_o_cube, IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 200
  { Intrinsic::amdgcn_image_gather4_c_lz_2d, IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 201
  { Intrinsic::amdgcn_image_gather4_c_lz_2darray, IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 202
  { Intrinsic::amdgcn_image_gather4_c_lz_cube, IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 203
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2d, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 204
  { Intrinsic::amdgcn_image_gather4_c_lz_o_2darray, IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 205
  { Intrinsic::amdgcn_image_gather4_c_lz_o_cube, IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 206
  { Intrinsic::amdgcn_image_gather4_c_o_2d, IMAGE_GATHER4_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 207
  { Intrinsic::amdgcn_image_gather4_c_o_2darray, IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 208
  { Intrinsic::amdgcn_image_gather4_c_o_cube, IMAGE_GATHER4_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 209
  { Intrinsic::amdgcn_image_gather4_cl_2d, IMAGE_GATHER4_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 210
  { Intrinsic::amdgcn_image_gather4_cl_2darray, IMAGE_GATHER4_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 211
  { Intrinsic::amdgcn_image_gather4_cl_cube, IMAGE_GATHER4_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 212
  { Intrinsic::amdgcn_image_gather4_cl_o_2d, IMAGE_GATHER4_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 213
  { Intrinsic::amdgcn_image_gather4_cl_o_2darray, IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 214
  { Intrinsic::amdgcn_image_gather4_cl_o_cube, IMAGE_GATHER4_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 215
  { Intrinsic::amdgcn_image_gather4_cube, IMAGE_GATHER4, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 216
  { Intrinsic::amdgcn_image_gather4_l_2d, IMAGE_GATHER4_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 217
  { Intrinsic::amdgcn_image_gather4_l_2darray, IMAGE_GATHER4_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 218
  { Intrinsic::amdgcn_image_gather4_l_cube, IMAGE_GATHER4_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 219
  { Intrinsic::amdgcn_image_gather4_l_o_2d, IMAGE_GATHER4_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 220
  { Intrinsic::amdgcn_image_gather4_l_o_2darray, IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 221
  { Intrinsic::amdgcn_image_gather4_l_o_cube, IMAGE_GATHER4_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 222
  { Intrinsic::amdgcn_image_gather4_lz_2d, IMAGE_GATHER4_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 223
  { Intrinsic::amdgcn_image_gather4_lz_2darray, IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 224
  { Intrinsic::amdgcn_image_gather4_lz_cube, IMAGE_GATHER4_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 225
  { Intrinsic::amdgcn_image_gather4_lz_o_2d, IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 226
  { Intrinsic::amdgcn_image_gather4_lz_o_2darray, IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 227
  { Intrinsic::amdgcn_image_gather4_lz_o_cube, IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 228
  { Intrinsic::amdgcn_image_gather4_o_2d, IMAGE_GATHER4_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 229
  { Intrinsic::amdgcn_image_gather4_o_2darray, IMAGE_GATHER4_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 230
  { Intrinsic::amdgcn_image_gather4_o_cube, IMAGE_GATHER4_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 231
  { Intrinsic::amdgcn_image_getlod_1d, IMAGE_GET_LOD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 232
  { Intrinsic::amdgcn_image_getlod_1darray, IMAGE_GET_LOD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 233
  { Intrinsic::amdgcn_image_getlod_2d, IMAGE_GET_LOD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 234
  { Intrinsic::amdgcn_image_getlod_2darray, IMAGE_GET_LOD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 235
  { Intrinsic::amdgcn_image_getlod_3d, IMAGE_GET_LOD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 236
  { Intrinsic::amdgcn_image_getlod_cube, IMAGE_GET_LOD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 237
  { Intrinsic::amdgcn_image_getresinfo_1d, IMAGE_GET_RESINFO, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 238
  { Intrinsic::amdgcn_image_getresinfo_1darray, IMAGE_GET_RESINFO, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 239
  { Intrinsic::amdgcn_image_getresinfo_2d, IMAGE_GET_RESINFO, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 240
  { Intrinsic::amdgcn_image_getresinfo_2darray, IMAGE_GET_RESINFO, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 241
  { Intrinsic::amdgcn_image_getresinfo_2darraymsaa, IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 242
  { Intrinsic::amdgcn_image_getresinfo_2dmsaa, IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 243
  { Intrinsic::amdgcn_image_getresinfo_3d, IMAGE_GET_RESINFO, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 244
  { Intrinsic::amdgcn_image_getresinfo_cube, IMAGE_GET_RESINFO, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 245
  { Intrinsic::amdgcn_image_load_1d, IMAGE_LOAD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x5, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x3, 0x4, 0x1, 0x1, 0x1 }, // 246
  { Intrinsic::amdgcn_image_load_1darray, IMAGE_LOAD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 247
  { Intrinsic::amdgcn_image_load_2d, IMAGE_LOAD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 248
  { Intrinsic::amdgcn_image_load_2darray, IMAGE_LOAD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 249
  { Intrinsic::amdgcn_image_load_2darraymsaa, IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 250
  { Intrinsic::amdgcn_image_load_2dmsaa, IMAGE_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 251
  { Intrinsic::amdgcn_image_load_3d, IMAGE_LOAD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 252
  { Intrinsic::amdgcn_image_load_cube, IMAGE_LOAD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 253
  { Intrinsic::amdgcn_image_load_mip_1d, IMAGE_LOAD_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x6, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 254
  { Intrinsic::amdgcn_image_load_mip_1darray, IMAGE_LOAD_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 255
  { Intrinsic::amdgcn_image_load_mip_2d, IMAGE_LOAD_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 256
  { Intrinsic::amdgcn_image_load_mip_2darray, IMAGE_LOAD_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 257
  { Intrinsic::amdgcn_image_load_mip_3d, IMAGE_LOAD_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 258
  { Intrinsic::amdgcn_image_load_mip_cube, IMAGE_LOAD_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 259
  { Intrinsic::amdgcn_image_msaa_load_2darraymsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 260
  { Intrinsic::amdgcn_image_msaa_load_2dmsaa, IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 261
  { Intrinsic::amdgcn_image_msaa_load_x_2darraymsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 262
  { Intrinsic::amdgcn_image_msaa_load_x_2dmsaa, IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 263
  { Intrinsic::amdgcn_image_sample_1d, IMAGE_SAMPLE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 264
  { Intrinsic::amdgcn_image_sample_1d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0 }, // 265
  { Intrinsic::amdgcn_image_sample_1darray, IMAGE_SAMPLE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 266
  { Intrinsic::amdgcn_image_sample_1darray_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 267
  { Intrinsic::amdgcn_image_sample_2d, IMAGE_SAMPLE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 268
  { Intrinsic::amdgcn_image_sample_2d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 269
  { Intrinsic::amdgcn_image_sample_2darray, IMAGE_SAMPLE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 270
  { Intrinsic::amdgcn_image_sample_2darray_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 271
  { Intrinsic::amdgcn_image_sample_3d, IMAGE_SAMPLE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 272
  { Intrinsic::amdgcn_image_sample_3d_nortn, IMAGE_SAMPLE_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 273
  { Intrinsic::amdgcn_image_sample_b_1d, IMAGE_SAMPLE_B, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x2, 0x2 }, // 274
  { Intrinsic::amdgcn_image_sample_b_1d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x1, 0x1 }, // 275
  { Intrinsic::amdgcn_image_sample_b_1darray, IMAGE_SAMPLE_B, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 276
  { Intrinsic::amdgcn_image_sample_b_1darray_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 277
  { Intrinsic::amdgcn_image_sample_b_2d, IMAGE_SAMPLE_B, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 278
  { Intrinsic::amdgcn_image_sample_b_2d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 279
  { Intrinsic::amdgcn_image_sample_b_2darray, IMAGE_SAMPLE_B, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 280
  { Intrinsic::amdgcn_image_sample_b_2darray_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 281
  { Intrinsic::amdgcn_image_sample_b_3d, IMAGE_SAMPLE_B, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 282
  { Intrinsic::amdgcn_image_sample_b_3d_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 283
  { Intrinsic::amdgcn_image_sample_b_cl_1d, IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 284
  { Intrinsic::amdgcn_image_sample_b_cl_1d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 285
  { Intrinsic::amdgcn_image_sample_b_cl_1darray, IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 286
  { Intrinsic::amdgcn_image_sample_b_cl_1darray_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 287
  { Intrinsic::amdgcn_image_sample_b_cl_2d, IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 288
  { Intrinsic::amdgcn_image_sample_b_cl_2d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 289
  { Intrinsic::amdgcn_image_sample_b_cl_2darray, IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 290
  { Intrinsic::amdgcn_image_sample_b_cl_2darray_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 291
  { Intrinsic::amdgcn_image_sample_b_cl_3d, IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 292
  { Intrinsic::amdgcn_image_sample_b_cl_3d_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim3D, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 293
  { Intrinsic::amdgcn_image_sample_b_cl_cube, IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 294
  { Intrinsic::amdgcn_image_sample_b_cl_cube_nortn, IMAGE_SAMPLE_B_CL_nortn, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 295
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 296
  { Intrinsic::amdgcn_image_sample_b_cl_o_1d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 297
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 298
  { Intrinsic::amdgcn_image_sample_b_cl_o_1darray_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 299
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 300
  { Intrinsic::amdgcn_image_sample_b_cl_o_2d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 301
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray, IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 302
  { Intrinsic::amdgcn_image_sample_b_cl_o_2darray_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 303
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d, IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 304
  { Intrinsic::amdgcn_image_sample_b_cl_o_3d_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 305
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube, IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 306
  { Intrinsic::amdgcn_image_sample_b_cl_o_cube_nortn, IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 307
  { Intrinsic::amdgcn_image_sample_b_cube, IMAGE_SAMPLE_B, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 308
  { Intrinsic::amdgcn_image_sample_b_cube_nortn, IMAGE_SAMPLE_B_nortn, AMDGPUDimCube, 0x0, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 309
  { Intrinsic::amdgcn_image_sample_b_o_1d, IMAGE_SAMPLE_B_O, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 310
  { Intrinsic::amdgcn_image_sample_b_o_1d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 311
  { Intrinsic::amdgcn_image_sample_b_o_1darray, IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 312
  { Intrinsic::amdgcn_image_sample_b_o_1darray_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 313
  { Intrinsic::amdgcn_image_sample_b_o_2d, IMAGE_SAMPLE_B_O, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 314
  { Intrinsic::amdgcn_image_sample_b_o_2d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 315
  { Intrinsic::amdgcn_image_sample_b_o_2darray, IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 316
  { Intrinsic::amdgcn_image_sample_b_o_2darray_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 317
  { Intrinsic::amdgcn_image_sample_b_o_3d, IMAGE_SAMPLE_B_O, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 318
  { Intrinsic::amdgcn_image_sample_b_o_3d_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 319
  { Intrinsic::amdgcn_image_sample_b_o_cube, IMAGE_SAMPLE_B_O, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 320
  { Intrinsic::amdgcn_image_sample_b_o_cube_nortn, IMAGE_SAMPLE_B_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 321
  { Intrinsic::amdgcn_image_sample_c_1d, IMAGE_SAMPLE_C, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 322
  { Intrinsic::amdgcn_image_sample_c_1d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 323
  { Intrinsic::amdgcn_image_sample_c_1darray, IMAGE_SAMPLE_C, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 324
  { Intrinsic::amdgcn_image_sample_c_1darray_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 325
  { Intrinsic::amdgcn_image_sample_c_2d, IMAGE_SAMPLE_C, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 326
  { Intrinsic::amdgcn_image_sample_c_2d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 327
  { Intrinsic::amdgcn_image_sample_c_2darray, IMAGE_SAMPLE_C, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 328
  { Intrinsic::amdgcn_image_sample_c_2darray_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 329
  { Intrinsic::amdgcn_image_sample_c_3d, IMAGE_SAMPLE_C, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 330
  { Intrinsic::amdgcn_image_sample_c_3d_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 331
  { Intrinsic::amdgcn_image_sample_c_b_1d, IMAGE_SAMPLE_C_B, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x2, 0x2 }, // 332
  { Intrinsic::amdgcn_image_sample_c_b_1d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x1, 0x1 }, // 333
  { Intrinsic::amdgcn_image_sample_c_b_1darray, IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 334
  { Intrinsic::amdgcn_image_sample_c_b_1darray_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 335
  { Intrinsic::amdgcn_image_sample_c_b_2d, IMAGE_SAMPLE_C_B, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 336
  { Intrinsic::amdgcn_image_sample_c_b_2d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 337
  { Intrinsic::amdgcn_image_sample_c_b_2darray, IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 338
  { Intrinsic::amdgcn_image_sample_c_b_2darray_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 339
  { Intrinsic::amdgcn_image_sample_c_b_3d, IMAGE_SAMPLE_C_B, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 340
  { Intrinsic::amdgcn_image_sample_c_b_3d_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 341
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 342
  { Intrinsic::amdgcn_image_sample_c_b_cl_1d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 343
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 344
  { Intrinsic::amdgcn_image_sample_c_b_cl_1darray_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 345
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 346
  { Intrinsic::amdgcn_image_sample_c_b_cl_2d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 347
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray, IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 348
  { Intrinsic::amdgcn_image_sample_c_b_cl_2darray_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2DArray, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 349
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d, IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 350
  { Intrinsic::amdgcn_image_sample_c_b_cl_3d_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim3D, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 351
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube, IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 352
  { Intrinsic::amdgcn_image_sample_c_b_cl_cube_nortn, IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 353
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 354
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 355
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 356
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_1darray_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 357
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 358
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 359
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 360
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_2darray_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 361
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 362
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_3d_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 363
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube, IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x2, 0x2 }, // 364
  { Intrinsic::amdgcn_image_sample_c_b_cl_o_cube_nortn, IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x1, 0x1 }, // 365
  { Intrinsic::amdgcn_image_sample_c_b_cube, IMAGE_SAMPLE_C_B, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 366
  { Intrinsic::amdgcn_image_sample_c_b_cube_nortn, IMAGE_SAMPLE_C_B_nortn, AMDGPUDimCube, 0x0, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 367
  { Intrinsic::amdgcn_image_sample_c_b_o_1d, IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x2, 0x2 }, // 368
  { Intrinsic::amdgcn_image_sample_c_b_o_1d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x1, 0x1 }, // 369
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 370
  { Intrinsic::amdgcn_image_sample_c_b_o_1darray_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 371
  { Intrinsic::amdgcn_image_sample_c_b_o_2d, IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x2, 0x2 }, // 372
  { Intrinsic::amdgcn_image_sample_c_b_o_2d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x1, 0x1 }, // 373
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray, IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 374
  { Intrinsic::amdgcn_image_sample_c_b_o_2darray_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2DArray, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 375
  { Intrinsic::amdgcn_image_sample_c_b_o_3d, IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 376
  { Intrinsic::amdgcn_image_sample_c_b_o_3d_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim3D, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 377
  { Intrinsic::amdgcn_image_sample_c_b_o_cube, IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x2, 0x2 }, // 378
  { Intrinsic::amdgcn_image_sample_c_b_o_cube_nortn, IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDimCube, 0x1, 0x1, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x3, 0x4, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x1, 0x1 }, // 379
  { Intrinsic::amdgcn_image_sample_c_cd_1d, IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 380
  { Intrinsic::amdgcn_image_sample_c_cd_1d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 381
  { Intrinsic::amdgcn_image_sample_c_cd_1darray, IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 382
  { Intrinsic::amdgcn_image_sample_c_cd_1darray_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 383
  { Intrinsic::amdgcn_image_sample_c_cd_2d, IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 384
  { Intrinsic::amdgcn_image_sample_c_cd_2d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 385
  { Intrinsic::amdgcn_image_sample_c_cd_2darray, IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 386
  { Intrinsic::amdgcn_image_sample_c_cd_2darray_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 387
  { Intrinsic::amdgcn_image_sample_c_cd_3d, IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 388
  { Intrinsic::amdgcn_image_sample_c_cd_3d_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 389
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 390
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 391
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 392
  { Intrinsic::amdgcn_image_sample_c_cd_cl_1darray_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 393
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 394
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 395
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 396
  { Intrinsic::amdgcn_image_sample_c_cd_cl_2darray_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 397
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d, IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 398
  { Intrinsic::amdgcn_image_sample_c_cd_cl_3d_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 399
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube, IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 400
  { Intrinsic::amdgcn_image_sample_c_cd_cl_cube_nortn, IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 401
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 402
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 403
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 404
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_1darray_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 405
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 406
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 407
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 408
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_2darray_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 409
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 410
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_3d_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x0, 0x0, 0x1 }, // 411
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube, IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 412
  { Intrinsic::amdgcn_image_sample_c_cd_cl_o_cube_nortn, IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 413
  { Intrinsic::amdgcn_image_sample_c_cd_cube, IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 414
  { Intrinsic::amdgcn_image_sample_c_cd_cube_nortn, IMAGE_SAMPLE_C_CD_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 415
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 416
  { Intrinsic::amdgcn_image_sample_c_cd_o_1d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 417
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 418
  { Intrinsic::amdgcn_image_sample_c_cd_o_1darray_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 419
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 420
  { Intrinsic::amdgcn_image_sample_c_cd_o_2d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 421
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray, IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 422
  { Intrinsic::amdgcn_image_sample_c_cd_o_2darray_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 423
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d, IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 424
  { Intrinsic::amdgcn_image_sample_c_cd_o_3d_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 425
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube, IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 426
  { Intrinsic::amdgcn_image_sample_c_cd_o_cube_nortn, IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 427
  { Intrinsic::amdgcn_image_sample_c_cl_1d, IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 428
  { Intrinsic::amdgcn_image_sample_c_cl_1d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 429
  { Intrinsic::amdgcn_image_sample_c_cl_1darray, IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 430
  { Intrinsic::amdgcn_image_sample_c_cl_1darray_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 431
  { Intrinsic::amdgcn_image_sample_c_cl_2d, IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 432
  { Intrinsic::amdgcn_image_sample_c_cl_2d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 433
  { Intrinsic::amdgcn_image_sample_c_cl_2darray, IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 434
  { Intrinsic::amdgcn_image_sample_c_cl_2darray_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 435
  { Intrinsic::amdgcn_image_sample_c_cl_3d, IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 436
  { Intrinsic::amdgcn_image_sample_c_cl_3d_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 437
  { Intrinsic::amdgcn_image_sample_c_cl_cube, IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 438
  { Intrinsic::amdgcn_image_sample_c_cl_cube_nortn, IMAGE_SAMPLE_C_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 439
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 440
  { Intrinsic::amdgcn_image_sample_c_cl_o_1d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 441
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 442
  { Intrinsic::amdgcn_image_sample_c_cl_o_1darray_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 443
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 444
  { Intrinsic::amdgcn_image_sample_c_cl_o_2d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 445
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray, IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 446
  { Intrinsic::amdgcn_image_sample_c_cl_o_2darray_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 447
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d, IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 448
  { Intrinsic::amdgcn_image_sample_c_cl_o_3d_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 449
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube, IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 450
  { Intrinsic::amdgcn_image_sample_c_cl_o_cube_nortn, IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 451
  { Intrinsic::amdgcn_image_sample_c_cube, IMAGE_SAMPLE_C, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 452
  { Intrinsic::amdgcn_image_sample_c_cube_nortn, IMAGE_SAMPLE_C_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 453
  { Intrinsic::amdgcn_image_sample_c_d_1d, IMAGE_SAMPLE_C_D, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 454
  { Intrinsic::amdgcn_image_sample_c_d_1d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 455
  { Intrinsic::amdgcn_image_sample_c_d_1darray, IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 456
  { Intrinsic::amdgcn_image_sample_c_d_1darray_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 457
  { Intrinsic::amdgcn_image_sample_c_d_2d, IMAGE_SAMPLE_C_D, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 458
  { Intrinsic::amdgcn_image_sample_c_d_2d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 459
  { Intrinsic::amdgcn_image_sample_c_d_2darray, IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 460
  { Intrinsic::amdgcn_image_sample_c_d_2darray_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 461
  { Intrinsic::amdgcn_image_sample_c_d_3d, IMAGE_SAMPLE_C_D, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 462
  { Intrinsic::amdgcn_image_sample_c_d_3d_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 463
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 464
  { Intrinsic::amdgcn_image_sample_c_d_cl_1d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 465
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 466
  { Intrinsic::amdgcn_image_sample_c_d_cl_1darray_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 467
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 468
  { Intrinsic::amdgcn_image_sample_c_d_cl_2d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 469
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray, IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 470
  { Intrinsic::amdgcn_image_sample_c_d_cl_2darray_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 471
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d, IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 472
  { Intrinsic::amdgcn_image_sample_c_d_cl_3d_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 473
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube, IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 474
  { Intrinsic::amdgcn_image_sample_c_d_cl_cube_nortn, IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 475
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 476
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 477
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 478
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_1darray_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 479
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 480
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 481
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 482
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_2darray_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 483
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x1, 0x1, 0x2 }, // 484
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_3d_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xC, 0x12, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xC, 0xC, 0xD, 0xD, 0xE, 0xF, 0x10, 0x11, 0x0, 0x0, 0x1 }, // 485
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube, IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 486
  { Intrinsic::amdgcn_image_sample_c_d_cl_o_cube_nortn, IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 487
  { Intrinsic::amdgcn_image_sample_c_d_cube, IMAGE_SAMPLE_C_D, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 488
  { Intrinsic::amdgcn_image_sample_c_d_cube_nortn, IMAGE_SAMPLE_C_D_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 489
  { Intrinsic::amdgcn_image_sample_c_d_o_1d, IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 490
  { Intrinsic::amdgcn_image_sample_c_d_o_1d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 491
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 492
  { Intrinsic::amdgcn_image_sample_c_d_o_1darray_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 493
  { Intrinsic::amdgcn_image_sample_c_d_o_2d, IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 494
  { Intrinsic::amdgcn_image_sample_c_d_o_2d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 495
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray, IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 496
  { Intrinsic::amdgcn_image_sample_c_d_o_2darray_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 497
  { Intrinsic::amdgcn_image_sample_c_d_o_3d, IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 498
  { Intrinsic::amdgcn_image_sample_c_d_o_3d_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x9, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 499
  { Intrinsic::amdgcn_image_sample_c_d_o_cube, IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 500
  { Intrinsic::amdgcn_image_sample_c_d_o_cube_nortn, IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 501
  { Intrinsic::amdgcn_image_sample_c_l_1d, IMAGE_SAMPLE_C_L, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 502
  { Intrinsic::amdgcn_image_sample_c_l_1d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 503
  { Intrinsic::amdgcn_image_sample_c_l_1darray, IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 504
  { Intrinsic::amdgcn_image_sample_c_l_1darray_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 505
  { Intrinsic::amdgcn_image_sample_c_l_2d, IMAGE_SAMPLE_C_L, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 506
  { Intrinsic::amdgcn_image_sample_c_l_2d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 507
  { Intrinsic::amdgcn_image_sample_c_l_2darray, IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 508
  { Intrinsic::amdgcn_image_sample_c_l_2darray_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 509
  { Intrinsic::amdgcn_image_sample_c_l_3d, IMAGE_SAMPLE_C_L, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 510
  { Intrinsic::amdgcn_image_sample_c_l_3d_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 511
  { Intrinsic::amdgcn_image_sample_c_l_cube, IMAGE_SAMPLE_C_L, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 512
  { Intrinsic::amdgcn_image_sample_c_l_cube_nortn, IMAGE_SAMPLE_C_L_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 513
  { Intrinsic::amdgcn_image_sample_c_l_o_1d, IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 514
  { Intrinsic::amdgcn_image_sample_c_l_o_1d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 515
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 516
  { Intrinsic::amdgcn_image_sample_c_l_o_1darray_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 517
  { Intrinsic::amdgcn_image_sample_c_l_o_2d, IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 518
  { Intrinsic::amdgcn_image_sample_c_l_o_2d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 519
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray, IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 520
  { Intrinsic::amdgcn_image_sample_c_l_o_2darray_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 521
  { Intrinsic::amdgcn_image_sample_c_l_o_3d, IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 522
  { Intrinsic::amdgcn_image_sample_c_l_o_3d_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 523
  { Intrinsic::amdgcn_image_sample_c_l_o_cube, IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x1 }, // 524
  { Intrinsic::amdgcn_image_sample_c_l_o_cube_nortn, IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x0 }, // 525
  { Intrinsic::amdgcn_image_sample_c_lz_1d, IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 526
  { Intrinsic::amdgcn_image_sample_c_lz_1d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 527
  { Intrinsic::amdgcn_image_sample_c_lz_1darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 528
  { Intrinsic::amdgcn_image_sample_c_lz_1darray_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 529
  { Intrinsic::amdgcn_image_sample_c_lz_2d, IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 530
  { Intrinsic::amdgcn_image_sample_c_lz_2d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 531
  { Intrinsic::amdgcn_image_sample_c_lz_2darray, IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 532
  { Intrinsic::amdgcn_image_sample_c_lz_2darray_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 533
  { Intrinsic::amdgcn_image_sample_c_lz_3d, IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 534
  { Intrinsic::amdgcn_image_sample_c_lz_3d_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim3D, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 535
  { Intrinsic::amdgcn_image_sample_c_lz_cube, IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 536
  { Intrinsic::amdgcn_image_sample_c_lz_cube_nortn, IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDimCube, 0x0, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 537
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 538
  { Intrinsic::amdgcn_image_sample_c_lz_o_1d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 539
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 540
  { Intrinsic::amdgcn_image_sample_c_lz_o_1darray_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 541
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 542
  { Intrinsic::amdgcn_image_sample_c_lz_o_2d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 543
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 544
  { Intrinsic::amdgcn_image_sample_c_lz_o_2darray_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 545
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d, IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 546
  { Intrinsic::amdgcn_image_sample_c_lz_o_3d_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 547
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube, IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 548
  { Intrinsic::amdgcn_image_sample_c_lz_o_cube_nortn, IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 549
  { Intrinsic::amdgcn_image_sample_c_o_1d, IMAGE_SAMPLE_C_O, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 550
  { Intrinsic::amdgcn_image_sample_c_o_1d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 551
  { Intrinsic::amdgcn_image_sample_c_o_1darray, IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 552
  { Intrinsic::amdgcn_image_sample_c_o_1darray_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 553
  { Intrinsic::amdgcn_image_sample_c_o_2d, IMAGE_SAMPLE_C_O, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 554
  { Intrinsic::amdgcn_image_sample_c_o_2d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 555
  { Intrinsic::amdgcn_image_sample_c_o_2darray, IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 556
  { Intrinsic::amdgcn_image_sample_c_o_2darray_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 557
  { Intrinsic::amdgcn_image_sample_c_o_3d, IMAGE_SAMPLE_C_O, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 558
  { Intrinsic::amdgcn_image_sample_c_o_3d_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 559
  { Intrinsic::amdgcn_image_sample_c_o_cube, IMAGE_SAMPLE_C_O, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 560
  { Intrinsic::amdgcn_image_sample_c_o_cube_nortn, IMAGE_SAMPLE_C_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x1, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 561
  { Intrinsic::amdgcn_image_sample_cd_1d, IMAGE_SAMPLE_CD, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 562
  { Intrinsic::amdgcn_image_sample_cd_1d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x1 }, // 563
  { Intrinsic::amdgcn_image_sample_cd_1darray, IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 564
  { Intrinsic::amdgcn_image_sample_cd_1darray_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 565
  { Intrinsic::amdgcn_image_sample_cd_2d, IMAGE_SAMPLE_CD, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 566
  { Intrinsic::amdgcn_image_sample_cd_2d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 567
  { Intrinsic::amdgcn_image_sample_cd_2darray, IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 568
  { Intrinsic::amdgcn_image_sample_cd_2darray_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 569
  { Intrinsic::amdgcn_image_sample_cd_3d, IMAGE_SAMPLE_CD, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 570
  { Intrinsic::amdgcn_image_sample_cd_3d_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 571
  { Intrinsic::amdgcn_image_sample_cd_cl_1d, IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 572
  { Intrinsic::amdgcn_image_sample_cd_cl_1d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 573
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 574
  { Intrinsic::amdgcn_image_sample_cd_cl_1darray_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 575
  { Intrinsic::amdgcn_image_sample_cd_cl_2d, IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 576
  { Intrinsic::amdgcn_image_sample_cd_cl_2d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 577
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray, IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 578
  { Intrinsic::amdgcn_image_sample_cd_cl_2darray_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 579
  { Intrinsic::amdgcn_image_sample_cd_cl_3d, IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 580
  { Intrinsic::amdgcn_image_sample_cd_cl_3d_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 581
  { Intrinsic::amdgcn_image_sample_cd_cl_cube, IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 582
  { Intrinsic::amdgcn_image_sample_cd_cl_cube_nortn, IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 583
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 584
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 585
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 586
  { Intrinsic::amdgcn_image_sample_cd_cl_o_1darray_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 587
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 588
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 589
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 590
  { Intrinsic::amdgcn_image_sample_cd_cl_o_2darray_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 591
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d, IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 592
  { Intrinsic::amdgcn_image_sample_cd_cl_o_3d_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 593
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube, IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 594
  { Intrinsic::amdgcn_image_sample_cd_cl_o_cube_nortn, IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 595
  { Intrinsic::amdgcn_image_sample_cd_cube, IMAGE_SAMPLE_CD, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 596
  { Intrinsic::amdgcn_image_sample_cd_cube_nortn, IMAGE_SAMPLE_CD_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 597
  { Intrinsic::amdgcn_image_sample_cd_o_1d, IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 598
  { Intrinsic::amdgcn_image_sample_cd_o_1d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 599
  { Intrinsic::amdgcn_image_sample_cd_o_1darray, IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 600
  { Intrinsic::amdgcn_image_sample_cd_o_1darray_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 601
  { Intrinsic::amdgcn_image_sample_cd_o_2d, IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 602
  { Intrinsic::amdgcn_image_sample_cd_o_2d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 603
  { Intrinsic::amdgcn_image_sample_cd_o_2darray, IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 604
  { Intrinsic::amdgcn_image_sample_cd_o_2darray_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 605
  { Intrinsic::amdgcn_image_sample_cd_o_3d, IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 606
  { Intrinsic::amdgcn_image_sample_cd_o_3d_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 607
  { Intrinsic::amdgcn_image_sample_cd_o_cube, IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 608
  { Intrinsic::amdgcn_image_sample_cd_o_cube_nortn, IMAGE_SAMPLE_CD_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 609
  { Intrinsic::amdgcn_image_sample_cl_1d, IMAGE_SAMPLE_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 610
  { Intrinsic::amdgcn_image_sample_cl_1d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 611
  { Intrinsic::amdgcn_image_sample_cl_1darray, IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 612
  { Intrinsic::amdgcn_image_sample_cl_1darray_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 613
  { Intrinsic::amdgcn_image_sample_cl_2d, IMAGE_SAMPLE_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 614
  { Intrinsic::amdgcn_image_sample_cl_2d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 615
  { Intrinsic::amdgcn_image_sample_cl_2darray, IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 616
  { Intrinsic::amdgcn_image_sample_cl_2darray_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 617
  { Intrinsic::amdgcn_image_sample_cl_3d, IMAGE_SAMPLE_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 618
  { Intrinsic::amdgcn_image_sample_cl_3d_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 619
  { Intrinsic::amdgcn_image_sample_cl_cube, IMAGE_SAMPLE_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 620
  { Intrinsic::amdgcn_image_sample_cl_cube_nortn, IMAGE_SAMPLE_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 621
  { Intrinsic::amdgcn_image_sample_cl_o_1d, IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 622
  { Intrinsic::amdgcn_image_sample_cl_o_1d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 623
  { Intrinsic::amdgcn_image_sample_cl_o_1darray, IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 624
  { Intrinsic::amdgcn_image_sample_cl_o_1darray_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 625
  { Intrinsic::amdgcn_image_sample_cl_o_2d, IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 626
  { Intrinsic::amdgcn_image_sample_cl_o_2d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 627
  { Intrinsic::amdgcn_image_sample_cl_o_2darray, IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 628
  { Intrinsic::amdgcn_image_sample_cl_o_2darray_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 629
  { Intrinsic::amdgcn_image_sample_cl_o_3d, IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 630
  { Intrinsic::amdgcn_image_sample_cl_o_3d_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 631
  { Intrinsic::amdgcn_image_sample_cl_o_cube, IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 632
  { Intrinsic::amdgcn_image_sample_cl_o_cube_nortn, IMAGE_SAMPLE_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 633
  { Intrinsic::amdgcn_image_sample_cube, IMAGE_SAMPLE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 634
  { Intrinsic::amdgcn_image_sample_cube_nortn, IMAGE_SAMPLE_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 635
  { Intrinsic::amdgcn_image_sample_d_1d, IMAGE_SAMPLE_D, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x2 }, // 636
  { Intrinsic::amdgcn_image_sample_d_1d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x1 }, // 637
  { Intrinsic::amdgcn_image_sample_d_1darray, IMAGE_SAMPLE_D, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 638
  { Intrinsic::amdgcn_image_sample_d_1darray_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 639
  { Intrinsic::amdgcn_image_sample_d_2d, IMAGE_SAMPLE_D, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 640
  { Intrinsic::amdgcn_image_sample_d_2d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 641
  { Intrinsic::amdgcn_image_sample_d_2darray, IMAGE_SAMPLE_D, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 642
  { Intrinsic::amdgcn_image_sample_d_2darray_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 643
  { Intrinsic::amdgcn_image_sample_d_3d, IMAGE_SAMPLE_D, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 644
  { Intrinsic::amdgcn_image_sample_d_3d_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 645
  { Intrinsic::amdgcn_image_sample_d_cl_1d, IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 646
  { Intrinsic::amdgcn_image_sample_d_cl_1d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 647
  { Intrinsic::amdgcn_image_sample_d_cl_1darray, IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 648
  { Intrinsic::amdgcn_image_sample_d_cl_1darray_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 649
  { Intrinsic::amdgcn_image_sample_d_cl_2d, IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 650
  { Intrinsic::amdgcn_image_sample_d_cl_2d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 651
  { Intrinsic::amdgcn_image_sample_d_cl_2darray, IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 652
  { Intrinsic::amdgcn_image_sample_d_cl_2darray_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 653
  { Intrinsic::amdgcn_image_sample_d_cl_3d, IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 654
  { Intrinsic::amdgcn_image_sample_d_cl_3d_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x7, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 655
  { Intrinsic::amdgcn_image_sample_d_cl_cube, IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 656
  { Intrinsic::amdgcn_image_sample_d_cl_cube_nortn, IMAGE_SAMPLE_D_CL_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 657
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 658
  { Intrinsic::amdgcn_image_sample_d_cl_o_1d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 659
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x1, 0x1, 0x2 }, // 660
  { Intrinsic::amdgcn_image_sample_d_cl_o_1darray_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x6, 0xC, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x6, 0x6, 0x7, 0x7, 0x8, 0x9, 0xA, 0xB, 0x0, 0x0, 0x1 }, // 661
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 662
  { Intrinsic::amdgcn_image_sample_d_cl_o_2d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 663
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray, IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 664
  { Intrinsic::amdgcn_image_sample_d_cl_o_2darray_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 665
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d, IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x1, 0x1, 0x2 }, // 666
  { Intrinsic::amdgcn_image_sample_d_cl_o_3d_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xB, 0x11, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xB, 0xB, 0xC, 0xC, 0xD, 0xE, 0xF, 0x10, 0x0, 0x0, 0x1 }, // 667
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube, IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x1, 0x1, 0x2 }, // 668
  { Intrinsic::amdgcn_image_sample_d_cl_o_cube_nortn, IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x9, 0xF, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x9, 0x9, 0xA, 0xA, 0xB, 0xC, 0xD, 0xE, 0x0, 0x0, 0x1 }, // 669
  { Intrinsic::amdgcn_image_sample_d_cube, IMAGE_SAMPLE_D, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 670
  { Intrinsic::amdgcn_image_sample_d_cube_nortn, IMAGE_SAMPLE_D_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x5, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 671
  { Intrinsic::amdgcn_image_sample_d_o_1d, IMAGE_SAMPLE_D_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x2 }, // 672
  { Intrinsic::amdgcn_image_sample_d_o_1d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x1 }, // 673
  { Intrinsic::amdgcn_image_sample_d_o_1darray, IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x2 }, // 674
  { Intrinsic::amdgcn_image_sample_d_o_1darray_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x2, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x4, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x1 }, // 675
  { Intrinsic::amdgcn_image_sample_d_o_2d, IMAGE_SAMPLE_D_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x1, 0x1, 0x2 }, // 676
  { Intrinsic::amdgcn_image_sample_d_o_2d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x7, 0xD, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x7, 0x7, 0x8, 0x8, 0x9, 0xA, 0xB, 0xC, 0x0, 0x0, 0x1 }, // 677
  { Intrinsic::amdgcn_image_sample_d_o_2darray, IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 678
  { Intrinsic::amdgcn_image_sample_d_o_2darray_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 679
  { Intrinsic::amdgcn_image_sample_d_o_3d, IMAGE_SAMPLE_D_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x1, 0x1, 0x2 }, // 680
  { Intrinsic::amdgcn_image_sample_d_o_3d_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x6, 0x1, 0x0, 0xA, 0x10, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x8, 0xA, 0xA, 0xB, 0xB, 0xC, 0xD, 0xE, 0xF, 0x0, 0x0, 0x1 }, // 681
  { Intrinsic::amdgcn_image_sample_d_o_cube, IMAGE_SAMPLE_D_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x1, 0x1, 0x2 }, // 682
  { Intrinsic::amdgcn_image_sample_d_o_cube_nortn, IMAGE_SAMPLE_D_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x4, 0x1, 0x0, 0x8, 0xE, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x6, 0x8, 0x8, 0x9, 0x9, 0xA, 0xB, 0xC, 0xD, 0x0, 0x0, 0x1 }, // 683
  { Intrinsic::amdgcn_image_sample_l_1d, IMAGE_SAMPLE_L, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 684
  { Intrinsic::amdgcn_image_sample_l_1d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 685
  { Intrinsic::amdgcn_image_sample_l_1darray, IMAGE_SAMPLE_L, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 686
  { Intrinsic::amdgcn_image_sample_l_1darray_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 687
  { Intrinsic::amdgcn_image_sample_l_2d, IMAGE_SAMPLE_L, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 688
  { Intrinsic::amdgcn_image_sample_l_2d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 689
  { Intrinsic::amdgcn_image_sample_l_2darray, IMAGE_SAMPLE_L, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 690
  { Intrinsic::amdgcn_image_sample_l_2darray_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 691
  { Intrinsic::amdgcn_image_sample_l_3d, IMAGE_SAMPLE_L, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 692
  { Intrinsic::amdgcn_image_sample_l_3d_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 693
  { Intrinsic::amdgcn_image_sample_l_cube, IMAGE_SAMPLE_L, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 694
  { Intrinsic::amdgcn_image_sample_l_cube_nortn, IMAGE_SAMPLE_L_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 695
  { Intrinsic::amdgcn_image_sample_l_o_1d, IMAGE_SAMPLE_L_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 696
  { Intrinsic::amdgcn_image_sample_l_o_1d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 697
  { Intrinsic::amdgcn_image_sample_l_o_1darray, IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 698
  { Intrinsic::amdgcn_image_sample_l_o_1darray_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 699
  { Intrinsic::amdgcn_image_sample_l_o_2d, IMAGE_SAMPLE_L_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 700
  { Intrinsic::amdgcn_image_sample_l_o_2d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 701
  { Intrinsic::amdgcn_image_sample_l_o_2darray, IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 702
  { Intrinsic::amdgcn_image_sample_l_o_2darray_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 703
  { Intrinsic::amdgcn_image_sample_l_o_3d, IMAGE_SAMPLE_L_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 704
  { Intrinsic::amdgcn_image_sample_l_o_3d_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 705
  { Intrinsic::amdgcn_image_sample_l_o_cube, IMAGE_SAMPLE_L_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x1, 0x1, 0x1 }, // 706
  { Intrinsic::amdgcn_image_sample_l_o_cube_nortn, IMAGE_SAMPLE_L_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x5, 0xB, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x9, 0xA, 0x0, 0x0, 0x0 }, // 707
  { Intrinsic::amdgcn_image_sample_lz_1d, IMAGE_SAMPLE_LZ, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 708
  { Intrinsic::amdgcn_image_sample_lz_1d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x1, 0x7, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x4, 0x5, 0x6, 0x0, 0x0, 0x0 }, // 709
  { Intrinsic::amdgcn_image_sample_lz_1darray, IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 710
  { Intrinsic::amdgcn_image_sample_lz_1darray_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 711
  { Intrinsic::amdgcn_image_sample_lz_2d, IMAGE_SAMPLE_LZ, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 712
  { Intrinsic::amdgcn_image_sample_lz_2d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 713
  { Intrinsic::amdgcn_image_sample_lz_2darray, IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 714
  { Intrinsic::amdgcn_image_sample_lz_2darray_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 715
  { Intrinsic::amdgcn_image_sample_lz_3d, IMAGE_SAMPLE_LZ, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 716
  { Intrinsic::amdgcn_image_sample_lz_3d_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 717
  { Intrinsic::amdgcn_image_sample_lz_cube, IMAGE_SAMPLE_LZ, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 718
  { Intrinsic::amdgcn_image_sample_lz_cube_nortn, IMAGE_SAMPLE_LZ_nortn, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x1, 0x1, 0x1, 0x1, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 719
  { Intrinsic::amdgcn_image_sample_lz_o_1d, IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 720
  { Intrinsic::amdgcn_image_sample_lz_o_1d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 721
  { Intrinsic::amdgcn_image_sample_lz_o_1darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 722
  { Intrinsic::amdgcn_image_sample_lz_o_1darray_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 723
  { Intrinsic::amdgcn_image_sample_lz_o_2d, IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 724
  { Intrinsic::amdgcn_image_sample_lz_o_2d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 725
  { Intrinsic::amdgcn_image_sample_lz_o_2darray, IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 726
  { Intrinsic::amdgcn_image_sample_lz_o_2darray_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 727
  { Intrinsic::amdgcn_image_sample_lz_o_3d, IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 728
  { Intrinsic::amdgcn_image_sample_lz_o_3d_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 729
  { Intrinsic::amdgcn_image_sample_lz_o_cube, IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 730
  { Intrinsic::amdgcn_image_sample_lz_o_cube_nortn, IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 731
  { Intrinsic::amdgcn_image_sample_o_1d, IMAGE_SAMPLE_O, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 732
  { Intrinsic::amdgcn_image_sample_o_1d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim1D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x2, 0x8, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x6, 0x7, 0x0, 0x0, 0x0 }, // 733
  { Intrinsic::amdgcn_image_sample_o_1darray, IMAGE_SAMPLE_O, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 734
  { Intrinsic::amdgcn_image_sample_o_1darray_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim1DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 735
  { Intrinsic::amdgcn_image_sample_o_2d, IMAGE_SAMPLE_O, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 736
  { Intrinsic::amdgcn_image_sample_o_2d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim2D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x3, 0x9, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x7, 0x8, 0x0, 0x0, 0x0 }, // 737
  { Intrinsic::amdgcn_image_sample_o_2darray, IMAGE_SAMPLE_O, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 738
  { Intrinsic::amdgcn_image_sample_o_2darray_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim2DArray, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 739
  { Intrinsic::amdgcn_image_sample_o_3d, IMAGE_SAMPLE_O, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 740
  { Intrinsic::amdgcn_image_sample_o_3d_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDim3D, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 741
  { Intrinsic::amdgcn_image_sample_o_cube, IMAGE_SAMPLE_O, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x1, 0x1, 0x1 }, // 742
  { Intrinsic::amdgcn_image_sample_o_cube_nortn, IMAGE_SAMPLE_O_nortn, AMDGPUDimCube, 0x1, 0x0, 0x0, 0x0, 0x1, 0x0, 0x4, 0xA, 0x0, 0x1, 0x1, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x8, 0x9, 0x0, 0x0, 0x0 }, // 743
  { Intrinsic::amdgcn_image_store_1d, IMAGE_STORE, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x1, 0x6, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x5, 0x4, 0x5, 0x1, 0x1, 0x1 }, // 744
  { Intrinsic::amdgcn_image_store_1darray, IMAGE_STORE, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 745
  { Intrinsic::amdgcn_image_store_2d, IMAGE_STORE, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 746
  { Intrinsic::amdgcn_image_store_2darray, IMAGE_STORE, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 747
  { Intrinsic::amdgcn_image_store_2darraymsaa, IMAGE_STORE, AMDGPUDim2DArrayMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 748
  { Intrinsic::amdgcn_image_store_2dmsaa, IMAGE_STORE, AMDGPUDim2DMsaa, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 749
  { Intrinsic::amdgcn_image_store_3d, IMAGE_STORE, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 750
  { Intrinsic::amdgcn_image_store_cube, IMAGE_STORE, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 751
  { Intrinsic::amdgcn_image_store_mip_1d, IMAGE_STORE_MIP, AMDGPUDim1D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x2, 0x7, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x3, 0x3, 0x4, 0x4, 0x5, 0x6, 0x5, 0x6, 0x1, 0x1, 0x1 }, // 752
  { Intrinsic::amdgcn_image_store_mip_1darray, IMAGE_STORE_MIP, AMDGPUDim1DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 753
  { Intrinsic::amdgcn_image_store_mip_2d, IMAGE_STORE_MIP, AMDGPUDim2D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x3, 0x8, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x4, 0x4, 0x5, 0x5, 0x6, 0x7, 0x6, 0x7, 0x1, 0x1, 0x1 }, // 754
  { Intrinsic::amdgcn_image_store_mip_2darray, IMAGE_STORE_MIP, AMDGPUDim2DArray, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 755
  { Intrinsic::amdgcn_image_store_mip_3d, IMAGE_STORE_MIP, AMDGPUDim3D, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 756
  { Intrinsic::amdgcn_image_store_mip_cube, IMAGE_STORE_MIP, AMDGPUDimCube, 0x0, 0x0, 0x0, 0x0, 0x1, 0x1, 0x4, 0x9, 0x1, 0x2, 0x2, 0x2, 0x2, 0x2, 0x2, 0x5, 0x5, 0x6, 0x6, 0x7, 0x8, 0x7, 0x8, 0x1, 0x1, 0x1 }, // 757
 };

const ImageDimIntrinsicInfo *getImageDimIntrinsicInfo(unsigned Intr) {
  if ((unsigned)Intr != std::clamp((unsigned)Intr, (unsigned)Intrinsic::amdgcn_image_atomic_add_1d, (unsigned)Intrinsic::amdgcn_image_store_mip_cube))
    return nullptr;

  struct KeyType {
    unsigned Intr;
  };
  KeyType Key = {Intr};
  struct Comp {
    bool operator()(const ImageDimIntrinsicInfo &LHS, const KeyType &RHS) const {
      if (LHS.Intr < RHS.Intr)
        return true;
      if (LHS.Intr > RHS.Intr)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(ImageDimIntrinsicTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Intr != Idx->Intr)
    return nullptr;

  return &*Idx;
}

const ImageDimIntrinsicInfo *getImageDimIntrinsicByBaseOpcode(unsigned BaseOpcode, unsigned Dim) {
  struct IndexType {
    unsigned BaseOpcode;
    unsigned Dim;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { IMAGE_ATOMIC_ADD, AMDGPUDim1D, 0 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim1DArray, 1 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2D, 2 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArray, 3 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DArrayMsaa, 4 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim2DMsaa, 5 },
    { IMAGE_ATOMIC_ADD, AMDGPUDim3D, 6 },
    { IMAGE_ATOMIC_ADD, AMDGPUDimCube, 7 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1D, 8 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim1DArray, 9 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2D, 10 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArray, 11 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DArrayMsaa, 12 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim2DMsaa, 13 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDim3D, 14 },
    { IMAGE_ATOMIC_ADD_FLT, AMDGPUDimCube, 15 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1D, 16 },
    { IMAGE_ATOMIC_AND, AMDGPUDim1DArray, 17 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2D, 18 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArray, 19 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DArrayMsaa, 20 },
    { IMAGE_ATOMIC_AND, AMDGPUDim2DMsaa, 21 },
    { IMAGE_ATOMIC_AND, AMDGPUDim3D, 22 },
    { IMAGE_ATOMIC_AND, AMDGPUDimCube, 23 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1D, 24 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim1DArray, 25 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2D, 26 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArray, 27 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DArrayMsaa, 28 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim2DMsaa, 29 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDim3D, 30 },
    { IMAGE_ATOMIC_CMPSWAP, AMDGPUDimCube, 31 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1D, 32 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim1DArray, 33 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2D, 34 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArray, 35 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DArrayMsaa, 36 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim2DMsaa, 37 },
    { IMAGE_ATOMIC_DEC, AMDGPUDim3D, 38 },
    { IMAGE_ATOMIC_DEC, AMDGPUDimCube, 39 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1D, 40 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim1DArray, 41 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2D, 42 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArray, 43 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DArrayMsaa, 44 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim2DMsaa, 45 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDim3D, 46 },
    { IMAGE_ATOMIC_FMAX, AMDGPUDimCube, 47 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1D, 48 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim1DArray, 49 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2D, 50 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArray, 51 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DArrayMsaa, 52 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim2DMsaa, 53 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDim3D, 54 },
    { IMAGE_ATOMIC_FMIN, AMDGPUDimCube, 55 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1D, 56 },
    { IMAGE_ATOMIC_INC, AMDGPUDim1DArray, 57 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2D, 58 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArray, 59 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DArrayMsaa, 60 },
    { IMAGE_ATOMIC_INC, AMDGPUDim2DMsaa, 61 },
    { IMAGE_ATOMIC_INC, AMDGPUDim3D, 62 },
    { IMAGE_ATOMIC_INC, AMDGPUDimCube, 63 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1D, 64 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim1DArray, 65 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2D, 66 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArray, 67 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DArrayMsaa, 68 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim2DMsaa, 69 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDim3D, 70 },
    { IMAGE_ATOMIC_MAX_FLT, AMDGPUDimCube, 71 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1D, 72 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim1DArray, 73 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2D, 74 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArray, 75 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DArrayMsaa, 76 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim2DMsaa, 77 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDim3D, 78 },
    { IMAGE_ATOMIC_MIN_FLT, AMDGPUDimCube, 79 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1D, 80 },
    { IMAGE_ATOMIC_OR, AMDGPUDim1DArray, 81 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2D, 82 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArray, 83 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DArrayMsaa, 84 },
    { IMAGE_ATOMIC_OR, AMDGPUDim2DMsaa, 85 },
    { IMAGE_ATOMIC_OR, AMDGPUDim3D, 86 },
    { IMAGE_ATOMIC_OR, AMDGPUDimCube, 87 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1D, 88 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim1DArray, 89 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2D, 90 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArray, 91 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DArrayMsaa, 92 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim2DMsaa, 93 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDim3D, 94 },
    { IMAGE_ATOMIC_PK_ADD_BF16, AMDGPUDimCube, 95 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1D, 96 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim1DArray, 97 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2D, 98 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArray, 99 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DArrayMsaa, 100 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim2DMsaa, 101 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDim3D, 102 },
    { IMAGE_ATOMIC_PK_ADD_F16, AMDGPUDimCube, 103 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1D, 104 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim1DArray, 105 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2D, 106 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArray, 107 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DArrayMsaa, 108 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim2DMsaa, 109 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDim3D, 110 },
    { IMAGE_ATOMIC_SMAX, AMDGPUDimCube, 111 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1D, 112 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim1DArray, 113 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2D, 114 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArray, 115 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DArrayMsaa, 116 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim2DMsaa, 117 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDim3D, 118 },
    { IMAGE_ATOMIC_SMIN, AMDGPUDimCube, 119 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1D, 120 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim1DArray, 121 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2D, 122 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArray, 123 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DArrayMsaa, 124 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim2DMsaa, 125 },
    { IMAGE_ATOMIC_SUB, AMDGPUDim3D, 126 },
    { IMAGE_ATOMIC_SUB, AMDGPUDimCube, 127 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1D, 128 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim1DArray, 129 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2D, 130 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArray, 131 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DArrayMsaa, 132 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim2DMsaa, 133 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDim3D, 134 },
    { IMAGE_ATOMIC_SWAP, AMDGPUDimCube, 135 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1D, 136 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim1DArray, 137 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2D, 138 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArray, 139 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DArrayMsaa, 140 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim2DMsaa, 141 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDim3D, 142 },
    { IMAGE_ATOMIC_UMAX, AMDGPUDimCube, 143 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1D, 144 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim1DArray, 145 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2D, 146 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArray, 147 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DArrayMsaa, 148 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim2DMsaa, 149 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDim3D, 150 },
    { IMAGE_ATOMIC_UMIN, AMDGPUDimCube, 151 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1D, 152 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim1DArray, 153 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2D, 154 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArray, 155 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DArrayMsaa, 156 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim2DMsaa, 157 },
    { IMAGE_ATOMIC_XOR, AMDGPUDim3D, 158 },
    { IMAGE_ATOMIC_XOR, AMDGPUDimCube, 159 },
    { IMAGE_GATHER4, AMDGPUDim2D, 160 },
    { IMAGE_GATHER4, AMDGPUDim2DArray, 161 },
    { IMAGE_GATHER4, AMDGPUDimCube, 216 },
    { IMAGE_GATHER4_B, AMDGPUDim2D, 162 },
    { IMAGE_GATHER4_B, AMDGPUDim2DArray, 163 },
    { IMAGE_GATHER4_B, AMDGPUDimCube, 170 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2D, 164 },
    { IMAGE_GATHER4_B_CL, AMDGPUDim2DArray, 165 },
    { IMAGE_GATHER4_B_CL, AMDGPUDimCube, 166 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2D, 167 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDim2DArray, 168 },
    { IMAGE_GATHER4_B_CL_O, AMDGPUDimCube, 169 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2D, 171 },
    { IMAGE_GATHER4_B_O, AMDGPUDim2DArray, 172 },
    { IMAGE_GATHER4_B_O, AMDGPUDimCube, 173 },
    { IMAGE_GATHER4_C, AMDGPUDim2D, 174 },
    { IMAGE_GATHER4_C, AMDGPUDim2DArray, 175 },
    { IMAGE_GATHER4_C, AMDGPUDimCube, 194 },
    { IMAGE_GATHER4_CL, AMDGPUDim2D, 210 },
    { IMAGE_GATHER4_CL, AMDGPUDim2DArray, 211 },
    { IMAGE_GATHER4_CL, AMDGPUDimCube, 212 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2D, 213 },
    { IMAGE_GATHER4_CL_O, AMDGPUDim2DArray, 214 },
    { IMAGE_GATHER4_CL_O, AMDGPUDimCube, 215 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2D, 176 },
    { IMAGE_GATHER4_C_B, AMDGPUDim2DArray, 177 },
    { IMAGE_GATHER4_C_B, AMDGPUDimCube, 184 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2D, 178 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDim2DArray, 179 },
    { IMAGE_GATHER4_C_B_CL, AMDGPUDimCube, 180 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2D, 181 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDim2DArray, 182 },
    { IMAGE_GATHER4_C_B_CL_O, AMDGPUDimCube, 183 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2D, 185 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDim2DArray, 186 },
    { IMAGE_GATHER4_C_B_O, AMDGPUDimCube, 187 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2D, 188 },
    { IMAGE_GATHER4_C_CL, AMDGPUDim2DArray, 189 },
    { IMAGE_GATHER4_C_CL, AMDGPUDimCube, 190 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2D, 191 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDim2DArray, 192 },
    { IMAGE_GATHER4_C_CL_O, AMDGPUDimCube, 193 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2D, 195 },
    { IMAGE_GATHER4_C_L, AMDGPUDim2DArray, 196 },
    { IMAGE_GATHER4_C_L, AMDGPUDimCube, 197 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2D, 201 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDim2DArray, 202 },
    { IMAGE_GATHER4_C_LZ, AMDGPUDimCube, 203 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2D, 204 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDim2DArray, 205 },
    { IMAGE_GATHER4_C_LZ_O, AMDGPUDimCube, 206 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2D, 198 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDim2DArray, 199 },
    { IMAGE_GATHER4_C_L_O, AMDGPUDimCube, 200 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2D, 207 },
    { IMAGE_GATHER4_C_O, AMDGPUDim2DArray, 208 },
    { IMAGE_GATHER4_C_O, AMDGPUDimCube, 209 },
    { IMAGE_GATHER4_L, AMDGPUDim2D, 217 },
    { IMAGE_GATHER4_L, AMDGPUDim2DArray, 218 },
    { IMAGE_GATHER4_L, AMDGPUDimCube, 219 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2D, 223 },
    { IMAGE_GATHER4_LZ, AMDGPUDim2DArray, 224 },
    { IMAGE_GATHER4_LZ, AMDGPUDimCube, 225 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2D, 226 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDim2DArray, 227 },
    { IMAGE_GATHER4_LZ_O, AMDGPUDimCube, 228 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2D, 220 },
    { IMAGE_GATHER4_L_O, AMDGPUDim2DArray, 221 },
    { IMAGE_GATHER4_L_O, AMDGPUDimCube, 222 },
    { IMAGE_GATHER4_O, AMDGPUDim2D, 229 },
    { IMAGE_GATHER4_O, AMDGPUDim2DArray, 230 },
    { IMAGE_GATHER4_O, AMDGPUDimCube, 231 },
    { IMAGE_GET_LOD, AMDGPUDim1D, 232 },
    { IMAGE_GET_LOD, AMDGPUDim1DArray, 233 },
    { IMAGE_GET_LOD, AMDGPUDim2D, 234 },
    { IMAGE_GET_LOD, AMDGPUDim2DArray, 235 },
    { IMAGE_GET_LOD, AMDGPUDim3D, 236 },
    { IMAGE_GET_LOD, AMDGPUDimCube, 237 },
    { IMAGE_GET_RESINFO, AMDGPUDim1D, 238 },
    { IMAGE_GET_RESINFO, AMDGPUDim1DArray, 239 },
    { IMAGE_GET_RESINFO, AMDGPUDim2D, 240 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArray, 241 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DArrayMsaa, 242 },
    { IMAGE_GET_RESINFO, AMDGPUDim2DMsaa, 243 },
    { IMAGE_GET_RESINFO, AMDGPUDim3D, 244 },
    { IMAGE_GET_RESINFO, AMDGPUDimCube, 245 },
    { IMAGE_LOAD, AMDGPUDim1D, 246 },
    { IMAGE_LOAD, AMDGPUDim1DArray, 247 },
    { IMAGE_LOAD, AMDGPUDim2D, 248 },
    { IMAGE_LOAD, AMDGPUDim2DArray, 249 },
    { IMAGE_LOAD, AMDGPUDim2DArrayMsaa, 250 },
    { IMAGE_LOAD, AMDGPUDim2DMsaa, 251 },
    { IMAGE_LOAD, AMDGPUDim3D, 252 },
    { IMAGE_LOAD, AMDGPUDimCube, 253 },
    { IMAGE_LOAD_MIP, AMDGPUDim1D, 254 },
    { IMAGE_LOAD_MIP, AMDGPUDim1DArray, 255 },
    { IMAGE_LOAD_MIP, AMDGPUDim2D, 256 },
    { IMAGE_LOAD_MIP, AMDGPUDim2DArray, 257 },
    { IMAGE_LOAD_MIP, AMDGPUDim3D, 258 },
    { IMAGE_LOAD_MIP, AMDGPUDimCube, 259 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DArrayMsaa, 260 },
    { IMAGE_MSAA_LOAD, AMDGPUDim2DMsaa, 261 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DArrayMsaa, 262 },
    { IMAGE_MSAA_LOAD_X, AMDGPUDim2DMsaa, 263 },
    { IMAGE_SAMPLE, AMDGPUDim1D, 264 },
    { IMAGE_SAMPLE, AMDGPUDim1DArray, 266 },
    { IMAGE_SAMPLE, AMDGPUDim2D, 268 },
    { IMAGE_SAMPLE, AMDGPUDim2DArray, 270 },
    { IMAGE_SAMPLE, AMDGPUDim3D, 272 },
    { IMAGE_SAMPLE, AMDGPUDimCube, 634 },
    { IMAGE_SAMPLE_B, AMDGPUDim1D, 274 },
    { IMAGE_SAMPLE_B, AMDGPUDim1DArray, 276 },
    { IMAGE_SAMPLE_B, AMDGPUDim2D, 278 },
    { IMAGE_SAMPLE_B, AMDGPUDim2DArray, 280 },
    { IMAGE_SAMPLE_B, AMDGPUDim3D, 282 },
    { IMAGE_SAMPLE_B, AMDGPUDimCube, 308 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1D, 284 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim1DArray, 286 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2D, 288 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim2DArray, 290 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDim3D, 292 },
    { IMAGE_SAMPLE_B_CL, AMDGPUDimCube, 294 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1D, 296 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim1DArray, 298 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2D, 300 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim2DArray, 302 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDim3D, 304 },
    { IMAGE_SAMPLE_B_CL_O, AMDGPUDimCube, 306 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1D, 297 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim1DArray, 299 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2D, 301 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim2DArray, 303 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDim3D, 305 },
    { IMAGE_SAMPLE_B_CL_O_nortn, AMDGPUDimCube, 307 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1D, 285 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim1DArray, 287 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2D, 289 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim2DArray, 291 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDim3D, 293 },
    { IMAGE_SAMPLE_B_CL_nortn, AMDGPUDimCube, 295 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1D, 310 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim1DArray, 312 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2D, 314 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim2DArray, 316 },
    { IMAGE_SAMPLE_B_O, AMDGPUDim3D, 318 },
    { IMAGE_SAMPLE_B_O, AMDGPUDimCube, 320 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1D, 311 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim1DArray, 313 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2D, 315 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim2DArray, 317 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDim3D, 319 },
    { IMAGE_SAMPLE_B_O_nortn, AMDGPUDimCube, 321 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim1D, 275 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim1DArray, 277 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim2D, 279 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim2DArray, 281 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDim3D, 283 },
    { IMAGE_SAMPLE_B_nortn, AMDGPUDimCube, 309 },
    { IMAGE_SAMPLE_C, AMDGPUDim1D, 322 },
    { IMAGE_SAMPLE_C, AMDGPUDim1DArray, 324 },
    { IMAGE_SAMPLE_C, AMDGPUDim2D, 326 },
    { IMAGE_SAMPLE_C, AMDGPUDim2DArray, 328 },
    { IMAGE_SAMPLE_C, AMDGPUDim3D, 330 },
    { IMAGE_SAMPLE_C, AMDGPUDimCube, 452 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1D, 562 },
    { IMAGE_SAMPLE_CD, AMDGPUDim1DArray, 564 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2D, 566 },
    { IMAGE_SAMPLE_CD, AMDGPUDim2DArray, 568 },
    { IMAGE_SAMPLE_CD, AMDGPUDim3D, 570 },
    { IMAGE_SAMPLE_CD, AMDGPUDimCube, 596 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1D, 572 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim1DArray, 574 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2D, 576 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim2DArray, 578 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDim3D, 580 },
    { IMAGE_SAMPLE_CD_CL, AMDGPUDimCube, 582 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1D, 584 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim1DArray, 586 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2D, 588 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim2DArray, 590 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDim3D, 592 },
    { IMAGE_SAMPLE_CD_CL_O, AMDGPUDimCube, 594 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1D, 585 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim1DArray, 587 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2D, 589 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim2DArray, 591 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDim3D, 593 },
    { IMAGE_SAMPLE_CD_CL_O_nortn, AMDGPUDimCube, 595 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1D, 573 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim1DArray, 575 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2D, 577 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim2DArray, 579 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDim3D, 581 },
    { IMAGE_SAMPLE_CD_CL_nortn, AMDGPUDimCube, 583 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1D, 598 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim1DArray, 600 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2D, 602 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim2DArray, 604 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDim3D, 606 },
    { IMAGE_SAMPLE_CD_O, AMDGPUDimCube, 608 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1D, 599 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim1DArray, 601 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2D, 603 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim2DArray, 605 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDim3D, 607 },
    { IMAGE_SAMPLE_CD_O_nortn, AMDGPUDimCube, 609 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim1D, 563 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim1DArray, 565 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim2D, 567 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim2DArray, 569 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDim3D, 571 },
    { IMAGE_SAMPLE_CD_nortn, AMDGPUDimCube, 597 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1D, 610 },
    { IMAGE_SAMPLE_CL, AMDGPUDim1DArray, 612 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2D, 614 },
    { IMAGE_SAMPLE_CL, AMDGPUDim2DArray, 616 },
    { IMAGE_SAMPLE_CL, AMDGPUDim3D, 618 },
    { IMAGE_SAMPLE_CL, AMDGPUDimCube, 620 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1D, 622 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim1DArray, 624 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2D, 626 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim2DArray, 628 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDim3D, 630 },
    { IMAGE_SAMPLE_CL_O, AMDGPUDimCube, 632 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1D, 623 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim1DArray, 625 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2D, 627 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim2DArray, 629 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDim3D, 631 },
    { IMAGE_SAMPLE_CL_O_nortn, AMDGPUDimCube, 633 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim1D, 611 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim1DArray, 613 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim2D, 615 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim2DArray, 617 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDim3D, 619 },
    { IMAGE_SAMPLE_CL_nortn, AMDGPUDimCube, 621 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1D, 332 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim1DArray, 334 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2D, 336 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim2DArray, 338 },
    { IMAGE_SAMPLE_C_B, AMDGPUDim3D, 340 },
    { IMAGE_SAMPLE_C_B, AMDGPUDimCube, 366 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1D, 342 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim1DArray, 344 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2D, 346 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim2DArray, 348 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDim3D, 350 },
    { IMAGE_SAMPLE_C_B_CL, AMDGPUDimCube, 352 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1D, 354 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim1DArray, 356 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2D, 358 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim2DArray, 360 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDim3D, 362 },
    { IMAGE_SAMPLE_C_B_CL_O, AMDGPUDimCube, 364 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1D, 355 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim1DArray, 357 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2D, 359 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim2DArray, 361 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDim3D, 363 },
    { IMAGE_SAMPLE_C_B_CL_O_nortn, AMDGPUDimCube, 365 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1D, 343 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim1DArray, 345 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2D, 347 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim2DArray, 349 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDim3D, 351 },
    { IMAGE_SAMPLE_C_B_CL_nortn, AMDGPUDimCube, 353 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1D, 368 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim1DArray, 370 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2D, 372 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim2DArray, 374 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDim3D, 376 },
    { IMAGE_SAMPLE_C_B_O, AMDGPUDimCube, 378 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1D, 369 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim1DArray, 371 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2D, 373 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim2DArray, 375 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDim3D, 377 },
    { IMAGE_SAMPLE_C_B_O_nortn, AMDGPUDimCube, 379 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1D, 333 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim1DArray, 335 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2D, 337 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim2DArray, 339 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDim3D, 341 },
    { IMAGE_SAMPLE_C_B_nortn, AMDGPUDimCube, 367 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1D, 380 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim1DArray, 382 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2D, 384 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim2DArray, 386 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDim3D, 388 },
    { IMAGE_SAMPLE_C_CD, AMDGPUDimCube, 414 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1D, 390 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim1DArray, 392 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2D, 394 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim2DArray, 396 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDim3D, 398 },
    { IMAGE_SAMPLE_C_CD_CL, AMDGPUDimCube, 400 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1D, 402 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim1DArray, 404 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2D, 406 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim2DArray, 408 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDim3D, 410 },
    { IMAGE_SAMPLE_C_CD_CL_O, AMDGPUDimCube, 412 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1D, 403 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim1DArray, 405 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2D, 407 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim2DArray, 409 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDim3D, 411 },
    { IMAGE_SAMPLE_C_CD_CL_O_nortn, AMDGPUDimCube, 413 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1D, 391 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim1DArray, 393 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2D, 395 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim2DArray, 397 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDim3D, 399 },
    { IMAGE_SAMPLE_C_CD_CL_nortn, AMDGPUDimCube, 401 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1D, 416 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim1DArray, 418 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2D, 420 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim2DArray, 422 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDim3D, 424 },
    { IMAGE_SAMPLE_C_CD_O, AMDGPUDimCube, 426 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1D, 417 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim1DArray, 419 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2D, 421 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim2DArray, 423 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDim3D, 425 },
    { IMAGE_SAMPLE_C_CD_O_nortn, AMDGPUDimCube, 427 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1D, 381 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim1DArray, 383 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2D, 385 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim2DArray, 387 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDim3D, 389 },
    { IMAGE_SAMPLE_C_CD_nortn, AMDGPUDimCube, 415 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1D, 428 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim1DArray, 430 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2D, 432 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim2DArray, 434 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDim3D, 436 },
    { IMAGE_SAMPLE_C_CL, AMDGPUDimCube, 438 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1D, 440 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim1DArray, 442 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2D, 444 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim2DArray, 446 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDim3D, 448 },
    { IMAGE_SAMPLE_C_CL_O, AMDGPUDimCube, 450 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1D, 441 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim1DArray, 443 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2D, 445 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim2DArray, 447 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDim3D, 449 },
    { IMAGE_SAMPLE_C_CL_O_nortn, AMDGPUDimCube, 451 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1D, 429 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim1DArray, 431 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2D, 433 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim2DArray, 435 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDim3D, 437 },
    { IMAGE_SAMPLE_C_CL_nortn, AMDGPUDimCube, 439 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1D, 454 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim1DArray, 456 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2D, 458 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim2DArray, 460 },
    { IMAGE_SAMPLE_C_D, AMDGPUDim3D, 462 },
    { IMAGE_SAMPLE_C_D, AMDGPUDimCube, 488 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1D, 464 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim1DArray, 466 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2D, 468 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim2DArray, 470 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDim3D, 472 },
    { IMAGE_SAMPLE_C_D_CL, AMDGPUDimCube, 474 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1D, 476 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim1DArray, 478 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2D, 480 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim2DArray, 482 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDim3D, 484 },
    { IMAGE_SAMPLE_C_D_CL_O, AMDGPUDimCube, 486 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1D, 477 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim1DArray, 479 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2D, 481 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim2DArray, 483 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDim3D, 485 },
    { IMAGE_SAMPLE_C_D_CL_O_nortn, AMDGPUDimCube, 487 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1D, 465 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim1DArray, 467 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2D, 469 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim2DArray, 471 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDim3D, 473 },
    { IMAGE_SAMPLE_C_D_CL_nortn, AMDGPUDimCube, 475 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1D, 490 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim1DArray, 492 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2D, 494 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim2DArray, 496 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDim3D, 498 },
    { IMAGE_SAMPLE_C_D_O, AMDGPUDimCube, 500 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1D, 491 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim1DArray, 493 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2D, 495 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim2DArray, 497 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDim3D, 499 },
    { IMAGE_SAMPLE_C_D_O_nortn, AMDGPUDimCube, 501 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1D, 455 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim1DArray, 457 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2D, 459 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim2DArray, 461 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDim3D, 463 },
    { IMAGE_SAMPLE_C_D_nortn, AMDGPUDimCube, 489 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1D, 502 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim1DArray, 504 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2D, 506 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim2DArray, 508 },
    { IMAGE_SAMPLE_C_L, AMDGPUDim3D, 510 },
    { IMAGE_SAMPLE_C_L, AMDGPUDimCube, 512 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1D, 526 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim1DArray, 528 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2D, 530 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim2DArray, 532 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDim3D, 534 },
    { IMAGE_SAMPLE_C_LZ, AMDGPUDimCube, 536 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1D, 538 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim1DArray, 540 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2D, 542 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim2DArray, 544 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDim3D, 546 },
    { IMAGE_SAMPLE_C_LZ_O, AMDGPUDimCube, 548 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1D, 539 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim1DArray, 541 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2D, 543 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim2DArray, 545 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDim3D, 547 },
    { IMAGE_SAMPLE_C_LZ_O_nortn, AMDGPUDimCube, 549 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1D, 527 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim1DArray, 529 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2D, 531 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim2DArray, 533 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDim3D, 535 },
    { IMAGE_SAMPLE_C_LZ_nortn, AMDGPUDimCube, 537 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1D, 514 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim1DArray, 516 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2D, 518 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim2DArray, 520 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDim3D, 522 },
    { IMAGE_SAMPLE_C_L_O, AMDGPUDimCube, 524 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1D, 515 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim1DArray, 517 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2D, 519 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim2DArray, 521 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDim3D, 523 },
    { IMAGE_SAMPLE_C_L_O_nortn, AMDGPUDimCube, 525 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1D, 503 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim1DArray, 505 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2D, 507 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim2DArray, 509 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDim3D, 511 },
    { IMAGE_SAMPLE_C_L_nortn, AMDGPUDimCube, 513 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1D, 550 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim1DArray, 552 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2D, 554 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim2DArray, 556 },
    { IMAGE_SAMPLE_C_O, AMDGPUDim3D, 558 },
    { IMAGE_SAMPLE_C_O, AMDGPUDimCube, 560 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1D, 551 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim1DArray, 553 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2D, 555 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim2DArray, 557 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDim3D, 559 },
    { IMAGE_SAMPLE_C_O_nortn, AMDGPUDimCube, 561 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim1D, 323 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim1DArray, 325 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim2D, 327 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim2DArray, 329 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDim3D, 331 },
    { IMAGE_SAMPLE_C_nortn, AMDGPUDimCube, 453 },
    { IMAGE_SAMPLE_D, AMDGPUDim1D, 636 },
    { IMAGE_SAMPLE_D, AMDGPUDim1DArray, 638 },
    { IMAGE_SAMPLE_D, AMDGPUDim2D, 640 },
    { IMAGE_SAMPLE_D, AMDGPUDim2DArray, 642 },
    { IMAGE_SAMPLE_D, AMDGPUDim3D, 644 },
    { IMAGE_SAMPLE_D, AMDGPUDimCube, 670 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1D, 646 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim1DArray, 648 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2D, 650 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim2DArray, 652 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDim3D, 654 },
    { IMAGE_SAMPLE_D_CL, AMDGPUDimCube, 656 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1D, 658 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim1DArray, 660 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2D, 662 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim2DArray, 664 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDim3D, 666 },
    { IMAGE_SAMPLE_D_CL_O, AMDGPUDimCube, 668 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1D, 659 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim1DArray, 661 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2D, 663 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim2DArray, 665 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDim3D, 667 },
    { IMAGE_SAMPLE_D_CL_O_nortn, AMDGPUDimCube, 669 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1D, 647 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim1DArray, 649 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2D, 651 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim2DArray, 653 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDim3D, 655 },
    { IMAGE_SAMPLE_D_CL_nortn, AMDGPUDimCube, 657 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1D, 672 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim1DArray, 674 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2D, 676 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim2DArray, 678 },
    { IMAGE_SAMPLE_D_O, AMDGPUDim3D, 680 },
    { IMAGE_SAMPLE_D_O, AMDGPUDimCube, 682 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1D, 673 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim1DArray, 675 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2D, 677 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim2DArray, 679 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDim3D, 681 },
    { IMAGE_SAMPLE_D_O_nortn, AMDGPUDimCube, 683 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim1D, 637 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim1DArray, 639 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim2D, 641 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim2DArray, 643 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDim3D, 645 },
    { IMAGE_SAMPLE_D_nortn, AMDGPUDimCube, 671 },
    { IMAGE_SAMPLE_L, AMDGPUDim1D, 684 },
    { IMAGE_SAMPLE_L, AMDGPUDim1DArray, 686 },
    { IMAGE_SAMPLE_L, AMDGPUDim2D, 688 },
    { IMAGE_SAMPLE_L, AMDGPUDim2DArray, 690 },
    { IMAGE_SAMPLE_L, AMDGPUDim3D, 692 },
    { IMAGE_SAMPLE_L, AMDGPUDimCube, 694 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1D, 708 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim1DArray, 710 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2D, 712 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim2DArray, 714 },
    { IMAGE_SAMPLE_LZ, AMDGPUDim3D, 716 },
    { IMAGE_SAMPLE_LZ, AMDGPUDimCube, 718 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1D, 720 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim1DArray, 722 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2D, 724 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim2DArray, 726 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDim3D, 728 },
    { IMAGE_SAMPLE_LZ_O, AMDGPUDimCube, 730 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1D, 721 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim1DArray, 723 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2D, 725 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim2DArray, 727 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDim3D, 729 },
    { IMAGE_SAMPLE_LZ_O_nortn, AMDGPUDimCube, 731 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1D, 709 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim1DArray, 711 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2D, 713 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim2DArray, 715 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDim3D, 717 },
    { IMAGE_SAMPLE_LZ_nortn, AMDGPUDimCube, 719 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1D, 696 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim1DArray, 698 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2D, 700 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim2DArray, 702 },
    { IMAGE_SAMPLE_L_O, AMDGPUDim3D, 704 },
    { IMAGE_SAMPLE_L_O, AMDGPUDimCube, 706 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1D, 697 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim1DArray, 699 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2D, 701 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim2DArray, 703 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDim3D, 705 },
    { IMAGE_SAMPLE_L_O_nortn, AMDGPUDimCube, 707 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim1D, 685 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim1DArray, 687 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim2D, 689 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim2DArray, 691 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDim3D, 693 },
    { IMAGE_SAMPLE_L_nortn, AMDGPUDimCube, 695 },
    { IMAGE_SAMPLE_O, AMDGPUDim1D, 732 },
    { IMAGE_SAMPLE_O, AMDGPUDim1DArray, 734 },
    { IMAGE_SAMPLE_O, AMDGPUDim2D, 736 },
    { IMAGE_SAMPLE_O, AMDGPUDim2DArray, 738 },
    { IMAGE_SAMPLE_O, AMDGPUDim3D, 740 },
    { IMAGE_SAMPLE_O, AMDGPUDimCube, 742 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim1D, 733 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim1DArray, 735 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim2D, 737 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim2DArray, 739 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDim3D, 741 },
    { IMAGE_SAMPLE_O_nortn, AMDGPUDimCube, 743 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim1D, 265 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim1DArray, 267 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim2D, 269 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim2DArray, 271 },
    { IMAGE_SAMPLE_nortn, AMDGPUDim3D, 273 },
    { IMAGE_SAMPLE_nortn, AMDGPUDimCube, 635 },
    { IMAGE_STORE, AMDGPUDim1D, 744 },
    { IMAGE_STORE, AMDGPUDim1DArray, 745 },
    { IMAGE_STORE, AMDGPUDim2D, 746 },
    { IMAGE_STORE, AMDGPUDim2DArray, 747 },
    { IMAGE_STORE, AMDGPUDim2DArrayMsaa, 748 },
    { IMAGE_STORE, AMDGPUDim2DMsaa, 749 },
    { IMAGE_STORE, AMDGPUDim3D, 750 },
    { IMAGE_STORE, AMDGPUDimCube, 751 },
    { IMAGE_STORE_MIP, AMDGPUDim1D, 752 },
    { IMAGE_STORE_MIP, AMDGPUDim1DArray, 753 },
    { IMAGE_STORE_MIP, AMDGPUDim2D, 754 },
    { IMAGE_STORE_MIP, AMDGPUDim2DArray, 755 },
    { IMAGE_STORE_MIP, AMDGPUDim3D, 756 },
    { IMAGE_STORE_MIP, AMDGPUDimCube, 757 },
  };

  struct KeyType {
    unsigned BaseOpcode;
    unsigned Dim;
  };
  KeyType Key = {BaseOpcode, Dim};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.BaseOpcode < (unsigned)RHS.BaseOpcode)
        return true;
      if ((unsigned)LHS.BaseOpcode > (unsigned)RHS.BaseOpcode)
        return false;
      if ((unsigned)LHS.Dim < (unsigned)RHS.Dim)
        return true;
      if ((unsigned)LHS.Dim > (unsigned)RHS.Dim)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.BaseOpcode != Idx->BaseOpcode ||
      Key.Dim != Idx->Dim)
    return nullptr;

  return &ImageDimIntrinsicTable[Idx->_index];
}
#endif

#ifdef GET_MAIInstInfoTable_DECL
const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode);
#endif

#ifdef GET_MAIInstInfoTable_IMPL
constexpr MAIInstInfo MAIInstInfoTable[] = {
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_e64, false, true }, // 0
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 1
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_e64, false, true }, // 2
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 3
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_e64, false, true }, // 4
  { V_MFMA_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 5
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_e64, false, true }, // 6
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 7
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_e64, false, true }, // 8
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 9
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_e64, false, true }, // 10
  { V_MFMA_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 11
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_e64, false, true }, // 12
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 13
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_e64, false, true }, // 14
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 15
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_e64, false, true }, // 16
  { V_MFMA_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 17
  { V_MFMA_F32_16X16X16BF16_1K_e64, false, true }, // 18
  { V_MFMA_F32_16X16X16BF16_1K_vgprcd_e64, false, true }, // 19
  { V_MFMA_F32_16X16X16F16_e64, false, true }, // 20
  { V_MFMA_F32_16X16X16F16_vgprcd_e64, false, true }, // 21
  { V_MFMA_F32_16X16X1F32_e64, false, false }, // 22
  { V_MFMA_F32_16X16X1F32_mac_e64, false, false }, // 23
  { V_MFMA_F32_16X16X1F32_mac_vgprcd_e64, false, false }, // 24
  { V_MFMA_F32_16X16X1F32_vgprcd_e64, false, false }, // 25
  { V_MFMA_F32_16X16X2BF16_e64, false, false }, // 26
  { V_MFMA_F32_16X16X2BF16_mac_e64, false, false }, // 27
  { V_MFMA_F32_16X16X2BF16_mac_vgprcd_e64, false, false }, // 28
  { V_MFMA_F32_16X16X2BF16_vgprcd_e64, false, false }, // 29
  { V_MFMA_F32_16X16X32_BF16_e64, false, true }, // 30
  { V_MFMA_F32_16X16X32_BF16_vgprcd_e64, false, true }, // 31
  { V_MFMA_F32_16X16X32_BF8_BF8_e64, false, true }, // 32
  { V_MFMA_F32_16X16X32_BF8_BF8_vgprcd_e64, false, true }, // 33
  { V_MFMA_F32_16X16X32_BF8_FP8_e64, false, true }, // 34
  { V_MFMA_F32_16X16X32_BF8_FP8_vgprcd_e64, false, true }, // 35
  { V_MFMA_F32_16X16X32_F16_e64, false, true }, // 36
  { V_MFMA_F32_16X16X32_F16_vgprcd_e64, false, true }, // 37
  { V_MFMA_F32_16X16X32_FP8_BF8_e64, false, true }, // 38
  { V_MFMA_F32_16X16X32_FP8_BF8_vgprcd_e64, false, true }, // 39
  { V_MFMA_F32_16X16X32_FP8_FP8_e64, false, true }, // 40
  { V_MFMA_F32_16X16X32_FP8_FP8_vgprcd_e64, false, true }, // 41
  { V_MFMA_F32_16X16X4BF16_1K_e64, false, true }, // 42
  { V_MFMA_F32_16X16X4BF16_1K_mac_e64, false, true }, // 43
  { V_MFMA_F32_16X16X4BF16_1K_mac_vgprcd_e64, false, true }, // 44
  { V_MFMA_F32_16X16X4BF16_1K_vgprcd_e64, false, true }, // 45
  { V_MFMA_F32_16X16X4F16_e64, false, true }, // 46
  { V_MFMA_F32_16X16X4F16_mac_e64, false, true }, // 47
  { V_MFMA_F32_16X16X4F16_mac_vgprcd_e64, false, true }, // 48
  { V_MFMA_F32_16X16X4F16_vgprcd_e64, false, true }, // 49
  { V_MFMA_F32_16X16X4F32_e64, false, false }, // 50
  { V_MFMA_F32_16X16X4F32_vgprcd_e64, false, false }, // 51
  { V_MFMA_F32_16X16X8BF16_e64, false, false }, // 52
  { V_MFMA_F32_16X16X8BF16_vgprcd_e64, false, false }, // 53
  { V_MFMA_F32_16X16X8XF32_e64, false, true }, // 54
  { V_MFMA_F32_16X16X8XF32_vgprcd_e64, false, true }, // 55
  { V_MFMA_F32_32X32X16_BF16_e64, false, true }, // 56
  { V_MFMA_F32_32X32X16_BF16_mac_e64, false, true }, // 57
  { V_MFMA_F32_32X32X16_BF16_mac_vgprcd_e64, false, true }, // 58
  { V_MFMA_F32_32X32X16_BF16_vgprcd_e64, false, true }, // 59
  { V_MFMA_F32_32X32X16_BF8_BF8_e64, false, true }, // 60
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_e64, false, true }, // 61
  { V_MFMA_F32_32X32X16_BF8_BF8_mac_vgprcd_e64, false, true }, // 62
  { V_MFMA_F32_32X32X16_BF8_BF8_vgprcd_e64, false, true }, // 63
  { V_MFMA_F32_32X32X16_BF8_FP8_e64, false, true }, // 64
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_e64, false, true }, // 65
  { V_MFMA_F32_32X32X16_BF8_FP8_mac_vgprcd_e64, false, true }, // 66
  { V_MFMA_F32_32X32X16_BF8_FP8_vgprcd_e64, false, true }, // 67
  { V_MFMA_F32_32X32X16_F16_e64, false, true }, // 68
  { V_MFMA_F32_32X32X16_F16_mac_e64, false, true }, // 69
  { V_MFMA_F32_32X32X16_F16_mac_vgprcd_e64, false, true }, // 70
  { V_MFMA_F32_32X32X16_F16_vgprcd_e64, false, true }, // 71
  { V_MFMA_F32_32X32X16_FP8_BF8_e64, false, true }, // 72
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_e64, false, true }, // 73
  { V_MFMA_F32_32X32X16_FP8_BF8_mac_vgprcd_e64, false, true }, // 74
  { V_MFMA_F32_32X32X16_FP8_BF8_vgprcd_e64, false, true }, // 75
  { V_MFMA_F32_32X32X16_FP8_FP8_e64, false, true }, // 76
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_e64, false, true }, // 77
  { V_MFMA_F32_32X32X16_FP8_FP8_mac_vgprcd_e64, false, true }, // 78
  { V_MFMA_F32_32X32X16_FP8_FP8_vgprcd_e64, false, true }, // 79
  { V_MFMA_F32_32X32X1F32_e64, false, false }, // 80
  { V_MFMA_F32_32X32X1F32_mac_e64, false, false }, // 81
  { V_MFMA_F32_32X32X1F32_mac_vgprcd_e64, false, false }, // 82
  { V_MFMA_F32_32X32X1F32_vgprcd_e64, false, false }, // 83
  { V_MFMA_F32_32X32X2BF16_e64, false, false }, // 84
  { V_MFMA_F32_32X32X2BF16_mac_e64, false, false }, // 85
  { V_MFMA_F32_32X32X2BF16_mac_vgprcd_e64, false, false }, // 86
  { V_MFMA_F32_32X32X2BF16_vgprcd_e64, false, false }, // 87
  { V_MFMA_F32_32X32X2F32_e64, false, false }, // 88
  { V_MFMA_F32_32X32X2F32_mac_e64, false, false }, // 89
  { V_MFMA_F32_32X32X2F32_mac_vgprcd_e64, false, false }, // 90
  { V_MFMA_F32_32X32X2F32_vgprcd_e64, false, false }, // 91
  { V_MFMA_F32_32X32X4BF16_1K_e64, false, true }, // 92
  { V_MFMA_F32_32X32X4BF16_1K_mac_e64, false, true }, // 93
  { V_MFMA_F32_32X32X4BF16_1K_mac_vgprcd_e64, false, true }, // 94
  { V_MFMA_F32_32X32X4BF16_1K_vgprcd_e64, false, true }, // 95
  { V_MFMA_F32_32X32X4BF16_e64, false, false }, // 96
  { V_MFMA_F32_32X32X4BF16_mac_e64, false, false }, // 97
  { V_MFMA_F32_32X32X4BF16_mac_vgprcd_e64, false, false }, // 98
  { V_MFMA_F32_32X32X4BF16_vgprcd_e64, false, false }, // 99
  { V_MFMA_F32_32X32X4F16_e64, false, true }, // 100
  { V_MFMA_F32_32X32X4F16_mac_e64, false, true }, // 101
  { V_MFMA_F32_32X32X4F16_mac_vgprcd_e64, false, true }, // 102
  { V_MFMA_F32_32X32X4F16_vgprcd_e64, false, true }, // 103
  { V_MFMA_F32_32X32X4XF32_e64, false, true }, // 104
  { V_MFMA_F32_32X32X4XF32_mac_e64, false, true }, // 105
  { V_MFMA_F32_32X32X4XF32_mac_vgprcd_e64, false, true }, // 106
  { V_MFMA_F32_32X32X4XF32_vgprcd_e64, false, true }, // 107
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_e64, false, true }, // 108
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, true }, // 109
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, true }, // 110
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 111
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_e64, false, true }, // 112
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, true }, // 113
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, true }, // 114
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 115
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_e64, false, true }, // 116
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, true }, // 117
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, true }, // 118
  { V_MFMA_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 119
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_e64, false, true }, // 120
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, true }, // 121
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, true }, // 122
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 123
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_e64, false, true }, // 124
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, true }, // 125
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, true }, // 126
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 127
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_e64, false, true }, // 128
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, true }, // 129
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, true }, // 130
  { V_MFMA_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 131
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_e64, false, true }, // 132
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, true }, // 133
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, true }, // 134
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 135
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_e64, false, true }, // 136
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, true }, // 137
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, true }, // 138
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 139
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_e64, false, true }, // 140
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, true }, // 141
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, true }, // 142
  { V_MFMA_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 143
  { V_MFMA_F32_32X32X8BF16_1K_e64, false, true }, // 144
  { V_MFMA_F32_32X32X8BF16_1K_mac_e64, false, true }, // 145
  { V_MFMA_F32_32X32X8BF16_1K_mac_vgprcd_e64, false, true }, // 146
  { V_MFMA_F32_32X32X8BF16_1K_vgprcd_e64, false, true }, // 147
  { V_MFMA_F32_32X32X8F16_e64, false, true }, // 148
  { V_MFMA_F32_32X32X8F16_mac_e64, false, true }, // 149
  { V_MFMA_F32_32X32X8F16_mac_vgprcd_e64, false, true }, // 150
  { V_MFMA_F32_32X32X8F16_vgprcd_e64, false, true }, // 151
  { V_MFMA_F32_4X4X1F32_e64, false, false }, // 152
  { V_MFMA_F32_4X4X1F32_vgprcd_e64, false, false }, // 153
  { V_MFMA_F32_4X4X2BF16_e64, false, false }, // 154
  { V_MFMA_F32_4X4X2BF16_vgprcd_e64, false, false }, // 155
  { V_MFMA_F32_4X4X4BF16_1K_e64, false, true }, // 156
  { V_MFMA_F32_4X4X4BF16_1K_vgprcd_e64, false, true }, // 157
  { V_MFMA_F32_4X4X4F16_e64, false, true }, // 158
  { V_MFMA_F32_4X4X4F16_vgprcd_e64, false, true }, // 159
  { V_MFMA_F64_16X16X4F64_e64, true, false }, // 160
  { V_MFMA_F64_16X16X4F64_mac_e64, true, false }, // 161
  { V_MFMA_F64_16X16X4F64_mac_vgprcd_e64, true, false }, // 162
  { V_MFMA_F64_16X16X4F64_vgprcd_e64, true, false }, // 163
  { V_MFMA_F64_4X4X4F64_e64, true, false }, // 164
  { V_MFMA_F64_4X4X4F64_vgprcd_e64, true, false }, // 165
  { V_MFMA_I32_16X16X16I8_e64, false, false }, // 166
  { V_MFMA_I32_16X16X16I8_vgprcd_e64, false, false }, // 167
  { V_MFMA_I32_16X16X32I8_e64, false, true }, // 168
  { V_MFMA_I32_16X16X32I8_vgprcd_e64, false, true }, // 169
  { V_MFMA_I32_16X16X4I8_e64, false, true }, // 170
  { V_MFMA_I32_16X16X4I8_mac_e64, false, true }, // 171
  { V_MFMA_I32_16X16X4I8_mac_vgprcd_e64, false, true }, // 172
  { V_MFMA_I32_16X16X4I8_vgprcd_e64, false, true }, // 173
  { V_MFMA_I32_16X16X64_I8_e64, false, true }, // 174
  { V_MFMA_I32_16X16X64_I8_vgprcd_e64, false, true }, // 175
  { V_MFMA_I32_32X32X16I8_e64, false, true }, // 176
  { V_MFMA_I32_32X32X16I8_mac_e64, false, true }, // 177
  { V_MFMA_I32_32X32X16I8_mac_vgprcd_e64, false, true }, // 178
  { V_MFMA_I32_32X32X16I8_vgprcd_e64, false, true }, // 179
  { V_MFMA_I32_32X32X32_I8_e64, false, true }, // 180
  { V_MFMA_I32_32X32X32_I8_mac_e64, false, true }, // 181
  { V_MFMA_I32_32X32X32_I8_mac_vgprcd_e64, false, true }, // 182
  { V_MFMA_I32_32X32X32_I8_vgprcd_e64, false, true }, // 183
  { V_MFMA_I32_32X32X4I8_e64, false, true }, // 184
  { V_MFMA_I32_32X32X4I8_mac_e64, false, true }, // 185
  { V_MFMA_I32_32X32X4I8_mac_vgprcd_e64, false, true }, // 186
  { V_MFMA_I32_32X32X4I8_vgprcd_e64, false, true }, // 187
  { V_MFMA_I32_32X32X8I8_e64, false, false }, // 188
  { V_MFMA_I32_32X32X8I8_mac_e64, false, false }, // 189
  { V_MFMA_I32_32X32X8I8_mac_vgprcd_e64, false, false }, // 190
  { V_MFMA_I32_32X32X8I8_vgprcd_e64, false, false }, // 191
  { V_MFMA_I32_4X4X4I8_e64, false, true }, // 192
  { V_MFMA_I32_4X4X4I8_vgprcd_e64, false, true }, // 193
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_e64, false, true }, // 194
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 195
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_e64, false, true }, // 196
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 197
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_e64, false, true }, // 198
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 199
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_e64, false, true }, // 200
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 201
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_e64, false, true }, // 202
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 203
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_e64, false, true }, // 204
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 205
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_e64, false, true }, // 206
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 207
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_e64, false, true }, // 208
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 209
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_e64, false, true }, // 210
  { V_MFMA_SCALE_F32_16X16X128_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 211
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_e64, false, true }, // 212
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_e64, false, true }, // 213
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_mac_vgprcd_e64, false, true }, // 214
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f4_vgprcd_e64, false, true }, // 215
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_e64, false, true }, // 216
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_e64, false, true }, // 217
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_mac_vgprcd_e64, false, true }, // 218
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f6_vgprcd_e64, false, true }, // 219
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_e64, false, true }, // 220
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_e64, false, true }, // 221
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_mac_vgprcd_e64, false, true }, // 222
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f4_f8_vgprcd_e64, false, true }, // 223
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_e64, false, true }, // 224
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_e64, false, true }, // 225
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_mac_vgprcd_e64, false, true }, // 226
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f4_vgprcd_e64, false, true }, // 227
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_e64, false, true }, // 228
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_e64, false, true }, // 229
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_mac_vgprcd_e64, false, true }, // 230
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f6_vgprcd_e64, false, true }, // 231
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_e64, false, true }, // 232
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_e64, false, true }, // 233
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_mac_vgprcd_e64, false, true }, // 234
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f6_f8_vgprcd_e64, false, true }, // 235
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_e64, false, true }, // 236
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_e64, false, true }, // 237
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_mac_vgprcd_e64, false, true }, // 238
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f4_vgprcd_e64, false, true }, // 239
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_e64, false, true }, // 240
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_e64, false, true }, // 241
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_mac_vgprcd_e64, false, true }, // 242
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f6_vgprcd_e64, false, true }, // 243
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_e64, false, true }, // 244
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_e64, false, true }, // 245
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_mac_vgprcd_e64, false, true }, // 246
  { V_MFMA_SCALE_F32_32X32X64_F8F6F4_f8_f8_vgprcd_e64, false, true }, // 247
  { V_SMFMAC_F32_16X16X128_BF8_BF8_e64, false, true }, // 248
  { V_SMFMAC_F32_16X16X128_BF8_FP8_e64, false, true }, // 249
  { V_SMFMAC_F32_16X16X128_FP8_BF8_e64, false, true }, // 250
  { V_SMFMAC_F32_16X16X128_FP8_FP8_e64, false, true }, // 251
  { V_SMFMAC_F32_16X16X32_BF16_e64, false, true }, // 252
  { V_SMFMAC_F32_16X16X32_F16_e64, false, true }, // 253
  { V_SMFMAC_F32_16X16X64_BF16_e64, false, true }, // 254
  { V_SMFMAC_F32_16X16X64_BF8_BF8_e64, false, true }, // 255
  { V_SMFMAC_F32_16X16X64_BF8_FP8_e64, false, true }, // 256
  { V_SMFMAC_F32_16X16X64_F16_e64, false, true }, // 257
  { V_SMFMAC_F32_16X16X64_FP8_BF8_e64, false, true }, // 258
  { V_SMFMAC_F32_16X16X64_FP8_FP8_e64, false, true }, // 259
  { V_SMFMAC_F32_32X32X16_BF16_e64, false, true }, // 260
  { V_SMFMAC_F32_32X32X16_F16_e64, false, true }, // 261
  { V_SMFMAC_F32_32X32X32_BF16_e64, false, true }, // 262
  { V_SMFMAC_F32_32X32X32_BF8_BF8_e64, false, true }, // 263
  { V_SMFMAC_F32_32X32X32_BF8_FP8_e64, false, true }, // 264
  { V_SMFMAC_F32_32X32X32_F16_e64, false, true }, // 265
  { V_SMFMAC_F32_32X32X32_FP8_BF8_e64, false, true }, // 266
  { V_SMFMAC_F32_32X32X32_FP8_FP8_e64, false, true }, // 267
  { V_SMFMAC_F32_32X32X64_BF8_BF8_e64, false, true }, // 268
  { V_SMFMAC_F32_32X32X64_BF8_FP8_e64, false, true }, // 269
  { V_SMFMAC_F32_32X32X64_FP8_BF8_e64, false, true }, // 270
  { V_SMFMAC_F32_32X32X64_FP8_FP8_e64, false, true }, // 271
  { V_SMFMAC_I32_16X16X128_I8_e64, false, true }, // 272
  { V_SMFMAC_I32_16X16X64_I8_e64, false, true }, // 273
  { V_SMFMAC_I32_32X32X32_I8_e64, false, true }, // 274
  { V_SMFMAC_I32_32X32X64_I8_e64, false, true }, // 275
 };

const MAIInstInfo *getMAIInstInfoHelper(unsigned Opcode) {
  struct KeyType {
    unsigned Opcode;
  };
  KeyType Key = {Opcode};
  struct Comp {
    bool operator()(const MAIInstInfo &LHS, const KeyType &RHS) const {
      if (LHS.Opcode < RHS.Opcode)
        return true;
      if (LHS.Opcode > RHS.Opcode)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MAIInstInfoTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Opcode != Idx->Opcode)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGBaseOpcodesTable_DECL
const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode);
#endif

#ifdef GET_MIMGBaseOpcodesTable_IMPL
constexpr MIMGBaseOpcodeInfo MIMGBaseOpcodesTable[] = {
  { IMAGE_ATOMIC_ADD, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 0
  { IMAGE_ATOMIC_ADD_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 1
  { IMAGE_ATOMIC_AND, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 2
  { IMAGE_ATOMIC_CMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 3
  { IMAGE_ATOMIC_DEC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 4
  { IMAGE_ATOMIC_FCMPSWAP, false, true, true, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 5
  { IMAGE_ATOMIC_FMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 6
  { IMAGE_ATOMIC_FMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 7
  { IMAGE_ATOMIC_INC, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 8
  { IMAGE_ATOMIC_MAX_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 9
  { IMAGE_ATOMIC_MIN_FLT, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 10
  { IMAGE_ATOMIC_OR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 11
  { IMAGE_ATOMIC_PK_ADD_BF16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 12
  { IMAGE_ATOMIC_PK_ADD_F16, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 13
  { IMAGE_ATOMIC_RSUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 14
  { IMAGE_ATOMIC_SMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 15
  { IMAGE_ATOMIC_SMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 16
  { IMAGE_ATOMIC_SUB, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 17
  { IMAGE_ATOMIC_SWAP, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 18
  { IMAGE_ATOMIC_UMAX, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 19
  { IMAGE_ATOMIC_UMIN, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 20
  { IMAGE_ATOMIC_XOR, false, true, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 21
  { IMAGE_BVH64_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false, false }, // 22
  { IMAGE_BVH64_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true, false, false }, // 23
  { IMAGE_BVH8_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false, false }, // 24
  { IMAGE_BVH_DUAL_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false, false }, // 25
  { IMAGE_BVH_INTERSECT_RAY, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, false, false, false }, // 26
  { IMAGE_BVH_INTERSECT_RAY_a16, false, false, false, false, false, 0x0, false, false, true, false, false, false, true, true, false, false }, // 27
  { IMAGE_GATHER4, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false, false }, // 28
  { IMAGE_GATHER4H, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false, false }, // 29
  { IMAGE_GATHER4_B, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false, false }, // 30
  { IMAGE_GATHER4_B_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false, false }, // 31
  { IMAGE_GATHER4_B_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false, false }, // 32
  { IMAGE_GATHER4_B_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false, false }, // 33
  { IMAGE_GATHER4_C, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false, false }, // 34
  { IMAGE_GATHER4_CL, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false, false, false }, // 35
  { IMAGE_GATHER4_CL_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false, false }, // 36
  { IMAGE_GATHER4_C_B, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false, false }, // 37
  { IMAGE_GATHER4_C_B_CL, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false, false }, // 38
  { IMAGE_GATHER4_C_B_CL_O, false, false, false, true, true, 0x3, false, false, true, true, true, false, false, false, false, false }, // 39
  { IMAGE_GATHER4_C_B_O, false, false, false, true, true, 0x3, false, false, true, false, true, false, false, false, false, false }, // 40
  { IMAGE_GATHER4_C_CL, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false, false }, // 41
  { IMAGE_GATHER4_C_CL_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false, false }, // 42
  { IMAGE_GATHER4_C_L, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false, false }, // 43
  { IMAGE_GATHER4_C_LZ, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false, false }, // 44
  { IMAGE_GATHER4_C_LZ_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false, false }, // 45
  { IMAGE_GATHER4_C_L_O, false, false, false, true, true, 0x2, false, false, true, true, true, false, false, false, false, false }, // 46
  { IMAGE_GATHER4_C_O, false, false, false, true, true, 0x2, false, false, true, false, true, false, false, false, false, false }, // 47
  { IMAGE_GATHER4_L, false, false, false, true, true, 0x0, false, false, true, true, true, false, false, false, false, false }, // 48
  { IMAGE_GATHER4_LZ, false, false, false, true, true, 0x0, false, false, true, false, true, false, false, false, false, false }, // 49
  { IMAGE_GATHER4_LZ_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false, false }, // 50
  { IMAGE_GATHER4_L_O, false, false, false, true, true, 0x1, false, false, true, true, true, false, false, false, false, false }, // 51
  { IMAGE_GATHER4_O, false, false, false, true, true, 0x1, false, false, true, false, true, false, false, false, false, false }, // 52
  { IMAGE_GET_LOD, false, false, false, true, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 53
  { IMAGE_GET_RESINFO, false, false, false, false, false, 0x0, false, false, false, true, false, false, false, false, false, false }, // 54
  { IMAGE_LOAD, false, false, false, false, false, 0x0, false, false, true, false, true, false, false, false, false, false }, // 55
  { IMAGE_LOAD_MIP, false, false, false, false, false, 0x0, false, false, true, true, true, false, false, false, false, false }, // 56
  { IMAGE_LOAD_MIP_PCK, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, false, false }, // 57
  { IMAGE_LOAD_MIP_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, false, false }, // 58
  { IMAGE_LOAD_PCK, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 59
  { IMAGE_LOAD_PCK_SGN, false, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, false, false }, // 60
  { IMAGE_MSAA_LOAD, false, false, false, false, true, 0x0, false, false, true, false, true, true, false, false, false, false }, // 61
  { IMAGE_MSAA_LOAD_X, false, false, false, false, false, 0x0, false, false, true, false, true, true, false, false, false, false }, // 62
  { IMAGE_SAMPLE, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, false, true }, // 63
  { IMAGE_SAMPLE_B, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false, false }, // 64
  { IMAGE_SAMPLE_B_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false, false }, // 65
  { IMAGE_SAMPLE_B_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false, false }, // 66
  { IMAGE_SAMPLE_B_CL_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true, false }, // 67
  { IMAGE_SAMPLE_B_CL_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true, false }, // 68
  { IMAGE_SAMPLE_B_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false, false }, // 69
  { IMAGE_SAMPLE_B_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true, false }, // 70
  { IMAGE_SAMPLE_B_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true, false }, // 71
  { IMAGE_SAMPLE_C, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false, false }, // 72
  { IMAGE_SAMPLE_CD, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, false, false }, // 73
  { IMAGE_SAMPLE_CD_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, false, false }, // 74
  { IMAGE_SAMPLE_CD_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, false, false }, // 75
  { IMAGE_SAMPLE_CD_CL_G16_nortn, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, true, false }, // 76
  { IMAGE_SAMPLE_CD_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false, false }, // 77
  { IMAGE_SAMPLE_CD_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false, false }, // 78
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true, false }, // 79
  { IMAGE_SAMPLE_CD_CL_O_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true, false }, // 80
  { IMAGE_SAMPLE_CD_CL_nortn, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, true, false }, // 81
  { IMAGE_SAMPLE_CD_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, false, false }, // 82
  { IMAGE_SAMPLE_CD_G16_nortn, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, true, false }, // 83
  { IMAGE_SAMPLE_CD_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false, false }, // 84
  { IMAGE_SAMPLE_CD_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false, false }, // 85
  { IMAGE_SAMPLE_CD_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true, false }, // 86
  { IMAGE_SAMPLE_CD_O_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true, false }, // 87
  { IMAGE_SAMPLE_CD_nortn, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, true, false }, // 88
  { IMAGE_SAMPLE_CL, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, false, false }, // 89
  { IMAGE_SAMPLE_CL_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false, false }, // 90
  { IMAGE_SAMPLE_CL_O_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true, false }, // 91
  { IMAGE_SAMPLE_CL_nortn, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, true, false }, // 92
  { IMAGE_SAMPLE_C_B, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false, false }, // 93
  { IMAGE_SAMPLE_C_B_CL, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false, false }, // 94
  { IMAGE_SAMPLE_C_B_CL_O, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false, false, false }, // 95
  { IMAGE_SAMPLE_C_B_CL_O_nortn, false, false, false, true, false, 0x3, false, false, true, true, true, false, false, false, true, false }, // 96
  { IMAGE_SAMPLE_C_B_CL_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true, false }, // 97
  { IMAGE_SAMPLE_C_B_O, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false, false, false }, // 98
  { IMAGE_SAMPLE_C_B_O_nortn, false, false, false, true, false, 0x3, false, false, true, false, true, false, false, false, true, false }, // 99
  { IMAGE_SAMPLE_C_B_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true, false }, // 100
  { IMAGE_SAMPLE_C_CD, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false, false }, // 101
  { IMAGE_SAMPLE_C_CD_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false, false }, // 102
  { IMAGE_SAMPLE_C_CD_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false, false }, // 103
  { IMAGE_SAMPLE_C_CD_CL_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true, false }, // 104
  { IMAGE_SAMPLE_C_CD_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, false, false }, // 105
  { IMAGE_SAMPLE_C_CD_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, false, false }, // 106
  { IMAGE_SAMPLE_C_CD_CL_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, true, false }, // 107
  { IMAGE_SAMPLE_C_CD_CL_O_nortn, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, true, false }, // 108
  { IMAGE_SAMPLE_C_CD_CL_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true, false }, // 109
  { IMAGE_SAMPLE_C_CD_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false, false }, // 110
  { IMAGE_SAMPLE_C_CD_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true, false }, // 111
  { IMAGE_SAMPLE_C_CD_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, false, false }, // 112
  { IMAGE_SAMPLE_C_CD_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, false, false }, // 113
  { IMAGE_SAMPLE_C_CD_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, true, false }, // 114
  { IMAGE_SAMPLE_C_CD_O_nortn, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, true, false }, // 115
  { IMAGE_SAMPLE_C_CD_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true, false }, // 116
  { IMAGE_SAMPLE_C_CL, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false, false }, // 117
  { IMAGE_SAMPLE_C_CL_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false, false }, // 118
  { IMAGE_SAMPLE_C_CL_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true, false }, // 119
  { IMAGE_SAMPLE_C_CL_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true, false }, // 120
  { IMAGE_SAMPLE_C_D, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false, false }, // 121
  { IMAGE_SAMPLE_C_D_CL, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false, false }, // 122
  { IMAGE_SAMPLE_C_D_CL_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false, false }, // 123
  { IMAGE_SAMPLE_C_D_CL_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true, false }, // 124
  { IMAGE_SAMPLE_C_D_CL_O, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, false, false }, // 125
  { IMAGE_SAMPLE_C_D_CL_O_G16, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, false, false }, // 126
  { IMAGE_SAMPLE_C_D_CL_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, true, true, false, false, false, true, false }, // 127
  { IMAGE_SAMPLE_C_D_CL_O_nortn, false, false, false, true, false, 0x2, true, false, true, true, true, false, false, false, true, false }, // 128
  { IMAGE_SAMPLE_C_D_CL_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true, false }, // 129
  { IMAGE_SAMPLE_C_D_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false, false }, // 130
  { IMAGE_SAMPLE_C_D_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true, false }, // 131
  { IMAGE_SAMPLE_C_D_O, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, false, false }, // 132
  { IMAGE_SAMPLE_C_D_O_G16, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, false, false }, // 133
  { IMAGE_SAMPLE_C_D_O_G16_nortn, false, false, false, true, false, 0x2, true, true, true, false, true, false, false, false, true, false }, // 134
  { IMAGE_SAMPLE_C_D_O_nortn, false, false, false, true, false, 0x2, true, false, true, false, true, false, false, false, true, false }, // 135
  { IMAGE_SAMPLE_C_D_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true, false }, // 136
  { IMAGE_SAMPLE_C_L, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false, false }, // 137
  { IMAGE_SAMPLE_C_LZ, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false, false }, // 138
  { IMAGE_SAMPLE_C_LZ_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false, false }, // 139
  { IMAGE_SAMPLE_C_LZ_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true, false }, // 140
  { IMAGE_SAMPLE_C_LZ_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true, false }, // 141
  { IMAGE_SAMPLE_C_L_O, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, false, false }, // 142
  { IMAGE_SAMPLE_C_L_O_nortn, false, false, false, true, false, 0x2, false, false, true, true, true, false, false, false, true, false }, // 143
  { IMAGE_SAMPLE_C_L_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true, false }, // 144
  { IMAGE_SAMPLE_C_O, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, false, false }, // 145
  { IMAGE_SAMPLE_C_O_nortn, false, false, false, true, false, 0x2, false, false, true, false, true, false, false, false, true, false }, // 146
  { IMAGE_SAMPLE_C_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true, false }, // 147
  { IMAGE_SAMPLE_D, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, false, false }, // 148
  { IMAGE_SAMPLE_D_CL, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, false, false }, // 149
  { IMAGE_SAMPLE_D_CL_G16, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, false, false }, // 150
  { IMAGE_SAMPLE_D_CL_G16_nortn, false, false, false, true, false, 0x0, true, true, true, true, true, false, false, false, true, false }, // 151
  { IMAGE_SAMPLE_D_CL_O, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, false, false }, // 152
  { IMAGE_SAMPLE_D_CL_O_G16, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, false, false }, // 153
  { IMAGE_SAMPLE_D_CL_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, true, true, false, false, false, true, false }, // 154
  { IMAGE_SAMPLE_D_CL_O_nortn, false, false, false, true, false, 0x1, true, false, true, true, true, false, false, false, true, false }, // 155
  { IMAGE_SAMPLE_D_CL_nortn, false, false, false, true, false, 0x0, true, false, true, true, true, false, false, false, true, false }, // 156
  { IMAGE_SAMPLE_D_G16, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, false, false }, // 157
  { IMAGE_SAMPLE_D_G16_nortn, false, false, false, true, false, 0x0, true, true, true, false, true, false, false, false, true, false }, // 158
  { IMAGE_SAMPLE_D_O, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, false, false }, // 159
  { IMAGE_SAMPLE_D_O_G16, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, false, false }, // 160
  { IMAGE_SAMPLE_D_O_G16_nortn, false, false, false, true, false, 0x1, true, true, true, false, true, false, false, false, true, false }, // 161
  { IMAGE_SAMPLE_D_O_nortn, false, false, false, true, false, 0x1, true, false, true, false, true, false, false, false, true, false }, // 162
  { IMAGE_SAMPLE_D_nortn, false, false, false, true, false, 0x0, true, false, true, false, true, false, false, false, true, false }, // 163
  { IMAGE_SAMPLE_L, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, false, true }, // 164
  { IMAGE_SAMPLE_LZ, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, false, true }, // 165
  { IMAGE_SAMPLE_LZ_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false, false }, // 166
  { IMAGE_SAMPLE_LZ_O_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true, false }, // 167
  { IMAGE_SAMPLE_LZ_nortn, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, true, false }, // 168
  { IMAGE_SAMPLE_L_O, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, false, false }, // 169
  { IMAGE_SAMPLE_L_O_nortn, false, false, false, true, false, 0x1, false, false, true, true, true, false, false, false, true, false }, // 170
  { IMAGE_SAMPLE_L_nortn, false, false, false, true, false, 0x0, false, false, true, true, true, false, false, false, true, false }, // 171
  { IMAGE_SAMPLE_O, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, false, false }, // 172
  { IMAGE_SAMPLE_O_nortn, false, false, false, true, false, 0x1, false, false, true, false, true, false, false, false, true, false }, // 173
  { IMAGE_SAMPLE_nortn, false, false, false, true, false, 0x0, false, false, true, false, true, false, false, false, true, false }, // 174
  { IMAGE_STORE, true, false, false, false, false, 0x0, false, false, true, false, true, false, false, false, true, false }, // 175
  { IMAGE_STORE_MIP, true, false, false, false, false, 0x0, false, false, true, true, true, false, false, false, true, false }, // 176
  { IMAGE_STORE_MIP_PCK, true, false, false, false, false, 0x0, false, false, true, true, false, false, false, false, true, false }, // 177
  { IMAGE_STORE_PCK, true, false, false, false, false, 0x0, false, false, true, false, false, false, false, false, true, false }, // 178
 };

const MIMGBaseOpcodeInfo *getMIMGBaseOpcodeInfo(unsigned BaseOpcode) {
  if ((unsigned)BaseOpcode != std::clamp((unsigned)BaseOpcode, (unsigned)IMAGE_ATOMIC_ADD, (unsigned)IMAGE_STORE_PCK))
    return nullptr;

  auto Table = ArrayRef(MIMGBaseOpcodesTable);
  size_t Idx = BaseOpcode - IMAGE_ATOMIC_ADD;
  return &Table[Idx];
}
#endif

#ifdef GET_MIMGBiasMappingTable_DECL
const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias);
#endif

#ifdef GET_MIMGBiasMappingTable_IMPL
constexpr MIMGBiasMappingInfo MIMGBiasMappingTable[] = {
  { IMAGE_GATHER4_B, IMAGE_GATHER4 }, // 0
  { IMAGE_GATHER4_B_CL, IMAGE_GATHER4_CL }, // 1
  { IMAGE_GATHER4_B_CL_O, IMAGE_GATHER4_CL_O }, // 2
  { IMAGE_GATHER4_B_O, IMAGE_GATHER4_O }, // 3
  { IMAGE_GATHER4_C_B, IMAGE_GATHER4_C }, // 4
  { IMAGE_GATHER4_C_B_CL, IMAGE_GATHER4_C_CL }, // 5
  { IMAGE_GATHER4_C_B_CL_O, IMAGE_GATHER4_C_CL_O }, // 6
  { IMAGE_GATHER4_C_B_O, IMAGE_GATHER4_C_O }, // 7
  { IMAGE_SAMPLE_B, IMAGE_SAMPLE }, // 8
  { IMAGE_SAMPLE_B_CL, IMAGE_SAMPLE_CL }, // 9
  { IMAGE_SAMPLE_B_CL_O, IMAGE_SAMPLE_CL_O }, // 10
  { IMAGE_SAMPLE_B_CL_O_nortn, IMAGE_SAMPLE_CL_O_nortn }, // 11
  { IMAGE_SAMPLE_B_CL_nortn, IMAGE_SAMPLE_CL_nortn }, // 12
  { IMAGE_SAMPLE_B_O, IMAGE_SAMPLE_O }, // 13
  { IMAGE_SAMPLE_B_O_nortn, IMAGE_SAMPLE_O_nortn }, // 14
  { IMAGE_SAMPLE_B_nortn, IMAGE_SAMPLE_nortn }, // 15
  { IMAGE_SAMPLE_C_B, IMAGE_SAMPLE_C }, // 16
  { IMAGE_SAMPLE_C_B_CL, IMAGE_SAMPLE_C_CL }, // 17
  { IMAGE_SAMPLE_C_B_CL_O, IMAGE_SAMPLE_C_CL_O }, // 18
  { IMAGE_SAMPLE_C_B_CL_O_nortn, IMAGE_SAMPLE_C_CL_O_nortn }, // 19
  { IMAGE_SAMPLE_C_B_CL_nortn, IMAGE_SAMPLE_C_CL_nortn }, // 20
  { IMAGE_SAMPLE_C_B_O, IMAGE_SAMPLE_C_O }, // 21
  { IMAGE_SAMPLE_C_B_O_nortn, IMAGE_SAMPLE_C_O_nortn }, // 22
  { IMAGE_SAMPLE_C_B_nortn, IMAGE_SAMPLE_C_nortn }, // 23
 };

const MIMGBiasMappingInfo *getMIMGBiasMappingInfo(unsigned Bias) {
  struct KeyType {
    unsigned Bias;
  };
  KeyType Key = {Bias};
  struct Comp {
    bool operator()(const MIMGBiasMappingInfo &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.Bias < (unsigned)RHS.Bias)
        return true;
      if ((unsigned)LHS.Bias > (unsigned)RHS.Bias)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MIMGBiasMappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.Bias != Idx->Bias)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGDimInfoTable_DECL
const MIMGDimInfo *getMIMGDimInfo(unsigned Dim);
const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix);
const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding);
#endif

#ifdef GET_MIMGDimInfoTable_IMPL
constexpr MIMGDimInfo MIMGDimInfoTable[] = {
  { AMDGPUDim1D, 0x1, 0x2, false, false, 0x0, "1D" }, // 0
  { AMDGPUDim1DArray, 0x2, 0x2, false, true, 0x4, "1D_ARRAY" }, // 1
  { AMDGPUDim2D, 0x2, 0x4, false, false, 0x1, "2D" }, // 2
  { AMDGPUDim2DArray, 0x3, 0x4, false, true, 0x5, "2D_ARRAY" }, // 3
  { AMDGPUDim2DArrayMsaa, 0x4, 0x4, true, true, 0x7, "2D_MSAA_ARRAY" }, // 4
  { AMDGPUDim2DMsaa, 0x3, 0x4, true, false, 0x6, "2D_MSAA" }, // 5
  { AMDGPUDim3D, 0x3, 0x6, false, false, 0x2, "3D" }, // 6
  { AMDGPUDimCube, 0x3, 0x4, false, true, 0x3, "CUBE" }, // 7
 };

const MIMGDimInfo *getMIMGDimInfo(unsigned Dim) {
  if ((unsigned)Dim != std::clamp((unsigned)Dim, (unsigned)AMDGPUDim1D, (unsigned)AMDGPUDimCube))
    return nullptr;

  auto Table = ArrayRef(MIMGDimInfoTable);
  size_t Idx = Dim - AMDGPUDim1D;
  return &Table[Idx];
}

const MIMGDimInfo *getMIMGDimInfoByAsmSuffix(StringRef AsmSuffix) {
  struct IndexType {
    const char * AsmSuffix;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { "1D", 0 },
    { "1D_ARRAY", 1 },
    { "2D", 2 },
    { "2D_ARRAY", 3 },
    { "2D_MSAA", 5 },
    { "2D_MSAA_ARRAY", 4 },
    { "3D", 6 },
    { "CUBE", 7 },
  };

  struct KeyType {
    std::string AsmSuffix;
  };
  KeyType Key = {AsmSuffix.upper()};
  struct Comp {
    bool operator()(const IndexType &LHS, const KeyType &RHS) const {
      int CmpAsmSuffix = StringRef(LHS.AsmSuffix).compare(RHS.AsmSuffix);
      if (CmpAsmSuffix < 0) return true;
      if (CmpAsmSuffix > 0) return false;
      return false;
    }
  };
  auto Table = ArrayRef(Index);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.AsmSuffix != Idx->AsmSuffix)
    return nullptr;

  return &MIMGDimInfoTable[Idx->_index];
}

const MIMGDimInfo *getMIMGDimInfoByEncoding(uint8_t Encoding) {
  struct IndexType {
    uint8_t Encoding;
    unsigned _index;
  };
  static const struct IndexType Index[] = {
    { 0x0, 0 },
    { 0x1, 2 },
    { 0x2, 6 },
    { 0x3, 7 },
    { 0x4, 1 },
    { 0x5, 3 },
    { 0x6, 5 },
    { 0x7, 4 },
  };

  if ((uint8_t)Encoding != std::clamp((uint8_t)Encoding, (uint8_t)0x0, (uint8_t)0x7))
    return nullptr;

  auto Table = ArrayRef(Index);
  size_t Idx = Encoding - 0x0;
  return &MIMGDimInfoTable[Table[Idx]._index];
}
#endif

#ifdef GET_MIMGG16MappingTable_DECL
const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G);
#endif

#ifdef GET_MIMGG16MappingTable_IMPL
constexpr MIMGG16MappingInfo MIMGG16MappingTable[] = {
  { IMAGE_SAMPLE_CD, IMAGE_SAMPLE_CD_G16 }, // 0
  { IMAGE_SAMPLE_CD_CL, IMAGE_SAMPLE_CD_CL_G16 }, // 1
  { IMAGE_SAMPLE_CD_CL_O, IMAGE_SAMPLE_CD_CL_O_G16 }, // 2
  { IMAGE_SAMPLE_CD_CL_O_nortn, IMAGE_SAMPLE_CD_CL_O_G16_nortn }, // 3
  { IMAGE_SAMPLE_CD_CL_nortn, IMAGE_SAMPLE_CD_CL_G16_nortn }, // 4
  { IMAGE_SAMPLE_CD_O, IMAGE_SAMPLE_CD_O_G16 }, // 5
  { IMAGE_SAMPLE_CD_O_nortn, IMAGE_SAMPLE_CD_O_G16_nortn }, // 6
  { IMAGE_SAMPLE_CD_nortn, IMAGE_SAMPLE_CD_G16_nortn }, // 7
  { IMAGE_SAMPLE_C_CD, IMAGE_SAMPLE_C_CD_G16 }, // 8
  { IMAGE_SAMPLE_C_CD_CL, IMAGE_SAMPLE_C_CD_CL_G16 }, // 9
  { IMAGE_SAMPLE_C_CD_CL_O, IMAGE_SAMPLE_C_CD_CL_O_G16 }, // 10
  { IMAGE_SAMPLE_C_CD_CL_O_nortn, IMAGE_SAMPLE_C_CD_CL_O_G16_nortn }, // 11
  { IMAGE_SAMPLE_C_CD_CL_nortn, IMAGE_SAMPLE_C_CD_CL_G16_nortn }, // 12
  { IMAGE_SAMPLE_C_CD_O, IMAGE_SAMPLE_C_CD_O_G16 }, // 13
  { IMAGE_SAMPLE_C_CD_O_nortn, IMAGE_SAMPLE_C_CD_O_G16_nortn }, // 14
  { IMAGE_SAMPLE_C_CD_nortn, IMAGE_SAMPLE_C_CD_G16_nortn }, // 15
  { IMAGE_SAMPLE_C_D, IMAGE_SAMPLE_C_D_G16 }, // 16
  { IMAGE_SAMPLE_C_D_CL, IMAGE_SAMPLE_C_D_CL_G16 }, // 17
  { IMAGE_SAMPLE_C_D_CL_O, IMAGE_SAMPLE_C_D_CL_O_G16 }, // 18
  { IMAGE_SAMPLE_C_D_CL_O_nortn, IMAGE_SAMPLE_C_D_CL_O_G16_nortn }, // 19
  { IMAGE_SAMPLE_C_D_CL_nortn, IMAGE_SAMPLE_C_D_CL_G16_nortn }, // 20
  { IMAGE_SAMPLE_C_D_O, IMAGE_SAMPLE_C_D_O_G16 }, // 21
  { IMAGE_SAMPLE_C_D_O_nortn, IMAGE_SAMPLE_C_D_O_G16_nortn }, // 22
  { IMAGE_SAMPLE_C_D_nortn, IMAGE_SAMPLE_C_D_G16_nortn }, // 23
  { IMAGE_SAMPLE_D, IMAGE_SAMPLE_D_G16 }, // 24
  { IMAGE_SAMPLE_D_CL, IMAGE_SAMPLE_D_CL_G16 }, // 25
  { IMAGE_SAMPLE_D_CL_O, IMAGE_SAMPLE_D_CL_O_G16 }, // 26
  { IMAGE_SAMPLE_D_CL_O_nortn, IMAGE_SAMPLE_D_CL_O_G16_nortn }, // 27
  { IMAGE_SAMPLE_D_CL_nortn, IMAGE_SAMPLE_D_CL_G16_nortn }, // 28
  { IMAGE_SAMPLE_D_O, IMAGE_SAMPLE_D_O_G16 }, // 29
  { IMAGE_SAMPLE_D_O_nortn, IMAGE_SAMPLE_D_O_G16_nortn }, // 30
  { IMAGE_SAMPLE_D_nortn, IMAGE_SAMPLE_D_G16_nortn }, // 31
 };

const MIMGG16MappingInfo *getMIMGG16MappingInfo(unsigned G) {
  struct KeyType {
    unsigned G;
  };
  KeyType Key = {G};
  struct Comp {
    bool operator()(const MIMGG16MappingInfo &LHS, const KeyType &RHS) const {
      if ((unsigned)LHS.G < (unsigned)RHS.G)
        return true;
      if ((unsigned)LHS.G > (unsigned)RHS.G)
        return false;
      return false;
    }
  };
  auto Table = ArrayRef(MIMGG16MappingTable);
  auto Idx = std::lower_bound(Table.begin(), Table.end(), Key, Comp());
  if (Idx == Table.end() ||
      Key.G != Idx->G)
    return nullptr;

  return &*Idx;
}
#endif

#ifdef GET_MIMGInfoTable_DECL
const MIMGInfo *getMIMGOpcodeHelper(unsigned BaseOpcode, unsigned MIMGEncoding, uint8_t VDataDwords, uint8_t VAddrDwords);
const MIMGInfo *getMIMGInfo(unsigned Opcode);
#endif

#ifdef GET_MIMGInfoTable_IMPL
constexpr MIMGInfo MIMGInfoTable[] = {
  { IMAGE_ATOMIC_ADD_V1_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 0
  { IMAGE_ATOMIC_ADD_V1_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1
  { IMAGE_ATOMIC_ADD_V1_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2
  { IMAGE_ATOMIC_ADD_V1_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3
  { IMAGE_ATOMIC_ADD_V2_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 4
  { IMAGE_ATOMIC_ADD_V2_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5
  { IMAGE_ATOMIC_ADD_V2_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 6
  { IMAGE_ATOMIC_ADD_V2_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 7
  { IMAGE_ATOMIC_ADD_V3_V1_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 8
  { IMAGE_ATOMIC_ADD_V3_V2_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 9
  { IMAGE_ATOMIC_ADD_V3_V3_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 10
  { IMAGE_ATOMIC_ADD_V3_V4_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 11
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 12
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 13
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 14
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 15
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 16
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 17
  { IMAGE_ATOMIC_ADD_V3_V2_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 18
  { IMAGE_ATOMIC_ADD_V3_V3_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 19
  { IMAGE_ATOMIC_ADD_V3_V4_nsa_gfx10, IMAGE_ATOMIC_ADD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 20
  { IMAGE_ATOMIC_ADD_V1_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 21
  { IMAGE_ATOMIC_ADD_V1_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 22
  { IMAGE_ATOMIC_ADD_V1_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 23
  { IMAGE_ATOMIC_ADD_V1_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 24
  { IMAGE_ATOMIC_ADD_V2_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 25
  { IMAGE_ATOMIC_ADD_V2_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 26
  { IMAGE_ATOMIC_ADD_V2_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 27
  { IMAGE_ATOMIC_ADD_V2_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 28
  { IMAGE_ATOMIC_ADD_V3_V1_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 29
  { IMAGE_ATOMIC_ADD_V3_V2_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 30
  { IMAGE_ATOMIC_ADD_V3_V3_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 31
  { IMAGE_ATOMIC_ADD_V3_V4_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 32
  { IMAGE_ATOMIC_ADD_V1_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 33
  { IMAGE_ATOMIC_ADD_V1_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 34
  { IMAGE_ATOMIC_ADD_V1_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 35
  { IMAGE_ATOMIC_ADD_V2_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 36
  { IMAGE_ATOMIC_ADD_V2_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 37
  { IMAGE_ATOMIC_ADD_V2_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 38
  { IMAGE_ATOMIC_ADD_V3_V2_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 39
  { IMAGE_ATOMIC_ADD_V3_V3_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 40
  { IMAGE_ATOMIC_ADD_V3_V4_nsa_gfx11, IMAGE_ATOMIC_ADD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 41
  { IMAGE_ATOMIC_ADD_V1_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 42
  { IMAGE_ATOMIC_ADD_V1_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 43
  { IMAGE_ATOMIC_ADD_V1_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 44
  { IMAGE_ATOMIC_ADD_V1_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 45
  { IMAGE_ATOMIC_ADD_V2_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 46
  { IMAGE_ATOMIC_ADD_V2_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 47
  { IMAGE_ATOMIC_ADD_V2_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 48
  { IMAGE_ATOMIC_ADD_V2_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 49
  { IMAGE_ATOMIC_ADD_V3_V1_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 50
  { IMAGE_ATOMIC_ADD_V3_V2_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 51
  { IMAGE_ATOMIC_ADD_V3_V3_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 52
  { IMAGE_ATOMIC_ADD_V3_V4_gfx12, IMAGE_ATOMIC_ADD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 53
  { IMAGE_ATOMIC_ADD_V1_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 54
  { IMAGE_ATOMIC_ADD_V1_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 55
  { IMAGE_ATOMIC_ADD_V1_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 56
  { IMAGE_ATOMIC_ADD_V1_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 57
  { IMAGE_ATOMIC_ADD_V2_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 58
  { IMAGE_ATOMIC_ADD_V2_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 59
  { IMAGE_ATOMIC_ADD_V2_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 60
  { IMAGE_ATOMIC_ADD_V2_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 61
  { IMAGE_ATOMIC_ADD_V3_V1_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 62
  { IMAGE_ATOMIC_ADD_V3_V2_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 63
  { IMAGE_ATOMIC_ADD_V3_V3_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 64
  { IMAGE_ATOMIC_ADD_V3_V4_si, IMAGE_ATOMIC_ADD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 65
  { IMAGE_ATOMIC_ADD_V1_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 66
  { IMAGE_ATOMIC_ADD_V1_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 67
  { IMAGE_ATOMIC_ADD_V1_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 68
  { IMAGE_ATOMIC_ADD_V1_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 69
  { IMAGE_ATOMIC_ADD_V2_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 70
  { IMAGE_ATOMIC_ADD_V2_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 71
  { IMAGE_ATOMIC_ADD_V2_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 72
  { IMAGE_ATOMIC_ADD_V2_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 73
  { IMAGE_ATOMIC_ADD_V3_V1_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 74
  { IMAGE_ATOMIC_ADD_V3_V2_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 75
  { IMAGE_ATOMIC_ADD_V3_V3_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 76
  { IMAGE_ATOMIC_ADD_V3_V4_vi, IMAGE_ATOMIC_ADD, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 77
  { IMAGE_ATOMIC_ADD_V1_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 78
  { IMAGE_ATOMIC_ADD_V1_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 79
  { IMAGE_ATOMIC_ADD_V1_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 80
  { IMAGE_ATOMIC_ADD_V1_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 81
  { IMAGE_ATOMIC_ADD_V2_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 82
  { IMAGE_ATOMIC_ADD_V2_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 83
  { IMAGE_ATOMIC_ADD_V2_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 84
  { IMAGE_ATOMIC_ADD_V2_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 85
  { IMAGE_ATOMIC_ADD_V3_V1_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 86
  { IMAGE_ATOMIC_ADD_V3_V2_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 87
  { IMAGE_ATOMIC_ADD_V3_V3_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 88
  { IMAGE_ATOMIC_ADD_V3_V4_gfx90a, IMAGE_ATOMIC_ADD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 89
  { IMAGE_ATOMIC_ADD_FLT_V1_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 90
  { IMAGE_ATOMIC_ADD_FLT_V1_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 91
  { IMAGE_ATOMIC_ADD_FLT_V1_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 92
  { IMAGE_ATOMIC_ADD_FLT_V1_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 93
  { IMAGE_ATOMIC_ADD_FLT_V2_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 94
  { IMAGE_ATOMIC_ADD_FLT_V2_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 95
  { IMAGE_ATOMIC_ADD_FLT_V2_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 96
  { IMAGE_ATOMIC_ADD_FLT_V2_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 97
  { IMAGE_ATOMIC_ADD_FLT_V3_V1_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 98
  { IMAGE_ATOMIC_ADD_FLT_V3_V2_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 99
  { IMAGE_ATOMIC_ADD_FLT_V3_V3_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 100
  { IMAGE_ATOMIC_ADD_FLT_V3_V4_gfx12, IMAGE_ATOMIC_ADD_FLT, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 101
  { IMAGE_ATOMIC_AND_V1_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 102
  { IMAGE_ATOMIC_AND_V1_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 103
  { IMAGE_ATOMIC_AND_V1_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 104
  { IMAGE_ATOMIC_AND_V1_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 105
  { IMAGE_ATOMIC_AND_V2_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 106
  { IMAGE_ATOMIC_AND_V2_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 107
  { IMAGE_ATOMIC_AND_V2_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 108
  { IMAGE_ATOMIC_AND_V2_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 109
  { IMAGE_ATOMIC_AND_V3_V1_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 110
  { IMAGE_ATOMIC_AND_V3_V2_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 111
  { IMAGE_ATOMIC_AND_V3_V3_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 112
  { IMAGE_ATOMIC_AND_V3_V4_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 113
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 114
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 115
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 116
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 117
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 118
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 119
  { IMAGE_ATOMIC_AND_V3_V2_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 120
  { IMAGE_ATOMIC_AND_V3_V3_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 121
  { IMAGE_ATOMIC_AND_V3_V4_nsa_gfx10, IMAGE_ATOMIC_AND, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 122
  { IMAGE_ATOMIC_AND_V1_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 123
  { IMAGE_ATOMIC_AND_V1_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 124
  { IMAGE_ATOMIC_AND_V1_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 125
  { IMAGE_ATOMIC_AND_V1_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 126
  { IMAGE_ATOMIC_AND_V2_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 127
  { IMAGE_ATOMIC_AND_V2_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 128
  { IMAGE_ATOMIC_AND_V2_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 129
  { IMAGE_ATOMIC_AND_V2_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 130
  { IMAGE_ATOMIC_AND_V3_V1_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 131
  { IMAGE_ATOMIC_AND_V3_V2_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 132
  { IMAGE_ATOMIC_AND_V3_V3_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 133
  { IMAGE_ATOMIC_AND_V3_V4_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 134
  { IMAGE_ATOMIC_AND_V1_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 135
  { IMAGE_ATOMIC_AND_V1_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 136
  { IMAGE_ATOMIC_AND_V1_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 137
  { IMAGE_ATOMIC_AND_V2_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 138
  { IMAGE_ATOMIC_AND_V2_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 139
  { IMAGE_ATOMIC_AND_V2_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 140
  { IMAGE_ATOMIC_AND_V3_V2_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 141
  { IMAGE_ATOMIC_AND_V3_V3_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 142
  { IMAGE_ATOMIC_AND_V3_V4_nsa_gfx11, IMAGE_ATOMIC_AND, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 143
  { IMAGE_ATOMIC_AND_V1_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 144
  { IMAGE_ATOMIC_AND_V1_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 145
  { IMAGE_ATOMIC_AND_V1_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 146
  { IMAGE_ATOMIC_AND_V1_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 147
  { IMAGE_ATOMIC_AND_V2_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 148
  { IMAGE_ATOMIC_AND_V2_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 149
  { IMAGE_ATOMIC_AND_V2_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 150
  { IMAGE_ATOMIC_AND_V2_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 151
  { IMAGE_ATOMIC_AND_V3_V1_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 152
  { IMAGE_ATOMIC_AND_V3_V2_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 153
  { IMAGE_ATOMIC_AND_V3_V3_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 154
  { IMAGE_ATOMIC_AND_V3_V4_gfx12, IMAGE_ATOMIC_AND, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 155
  { IMAGE_ATOMIC_AND_V1_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 156
  { IMAGE_ATOMIC_AND_V1_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 157
  { IMAGE_ATOMIC_AND_V1_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 158
  { IMAGE_ATOMIC_AND_V1_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 159
  { IMAGE_ATOMIC_AND_V2_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 160
  { IMAGE_ATOMIC_AND_V2_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 161
  { IMAGE_ATOMIC_AND_V2_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 162
  { IMAGE_ATOMIC_AND_V2_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 163
  { IMAGE_ATOMIC_AND_V3_V1_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 164
  { IMAGE_ATOMIC_AND_V3_V2_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 165
  { IMAGE_ATOMIC_AND_V3_V3_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 166
  { IMAGE_ATOMIC_AND_V3_V4_si, IMAGE_ATOMIC_AND, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 167
  { IMAGE_ATOMIC_AND_V1_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 168
  { IMAGE_ATOMIC_AND_V1_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 169
  { IMAGE_ATOMIC_AND_V1_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 170
  { IMAGE_ATOMIC_AND_V1_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 171
  { IMAGE_ATOMIC_AND_V2_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 172
  { IMAGE_ATOMIC_AND_V2_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 173
  { IMAGE_ATOMIC_AND_V2_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 174
  { IMAGE_ATOMIC_AND_V2_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 175
  { IMAGE_ATOMIC_AND_V3_V1_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 176
  { IMAGE_ATOMIC_AND_V3_V2_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 177
  { IMAGE_ATOMIC_AND_V3_V3_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 178
  { IMAGE_ATOMIC_AND_V3_V4_vi, IMAGE_ATOMIC_AND, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 179
  { IMAGE_ATOMIC_AND_V1_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 180
  { IMAGE_ATOMIC_AND_V1_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 181
  { IMAGE_ATOMIC_AND_V1_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 182
  { IMAGE_ATOMIC_AND_V1_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 183
  { IMAGE_ATOMIC_AND_V2_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 184
  { IMAGE_ATOMIC_AND_V2_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 185
  { IMAGE_ATOMIC_AND_V2_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 186
  { IMAGE_ATOMIC_AND_V2_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 187
  { IMAGE_ATOMIC_AND_V3_V1_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 188
  { IMAGE_ATOMIC_AND_V3_V2_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 189
  { IMAGE_ATOMIC_AND_V3_V3_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 190
  { IMAGE_ATOMIC_AND_V3_V4_gfx90a, IMAGE_ATOMIC_AND, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 191
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 192
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 193
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 194
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 195
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 196
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 197
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 198
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 199
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 200
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 201
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 202
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 203
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 204
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 205
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 206
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 207
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 208
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 209
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 210
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 211
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 212
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 213
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 214
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 215
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 216
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 217
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 218
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_nsa_gfx10, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 219
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 220
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 221
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 222
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 223
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 224
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 225
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 226
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 227
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 228
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 229
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 230
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 231
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 232
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 233
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 234
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 235
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 236
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 237
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 238
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 239
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 240
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 241
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 242
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 243
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 244
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 245
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 246
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_nsa_gfx11, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 247
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 248
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 249
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 250
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 251
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 252
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 253
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 254
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 255
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 256
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 257
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 258
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 259
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 260
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 261
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 262
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_gfx12, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 263
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 264
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 265
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 266
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 267
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 268
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 269
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 270
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 271
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 272
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 273
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 274
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 275
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 276
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 277
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 278
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_si, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 279
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 280
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 281
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 282
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 283
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 284
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 285
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 286
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 287
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x1, 0x1 }, // 288
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x2, 0x1 }, // 289
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x3, 0x1 }, // 290
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x4, 0x4, 0x1 }, // 291
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x5, 0x1, 0x1 }, // 292
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x5, 0x2, 0x1 }, // 293
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x5, 0x3, 0x1 }, // 294
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_vi, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx8, 0x5, 0x4, 0x1 }, // 295
  { IMAGE_ATOMIC_CMPSWAP_V2_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 296
  { IMAGE_ATOMIC_CMPSWAP_V2_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 297
  { IMAGE_ATOMIC_CMPSWAP_V2_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 298
  { IMAGE_ATOMIC_CMPSWAP_V2_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 299
  { IMAGE_ATOMIC_CMPSWAP_V3_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 300
  { IMAGE_ATOMIC_CMPSWAP_V3_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 301
  { IMAGE_ATOMIC_CMPSWAP_V3_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 302
  { IMAGE_ATOMIC_CMPSWAP_V3_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 303
  { IMAGE_ATOMIC_CMPSWAP_V4_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 304
  { IMAGE_ATOMIC_CMPSWAP_V4_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 305
  { IMAGE_ATOMIC_CMPSWAP_V4_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 306
  { IMAGE_ATOMIC_CMPSWAP_V4_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 307
  { IMAGE_ATOMIC_CMPSWAP_V5_V1_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 308
  { IMAGE_ATOMIC_CMPSWAP_V5_V2_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 309
  { IMAGE_ATOMIC_CMPSWAP_V5_V3_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 310
  { IMAGE_ATOMIC_CMPSWAP_V5_V4_gfx90a, IMAGE_ATOMIC_CMPSWAP, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 311
  { IMAGE_ATOMIC_DEC_V1_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 312
  { IMAGE_ATOMIC_DEC_V1_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 313
  { IMAGE_ATOMIC_DEC_V1_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 314
  { IMAGE_ATOMIC_DEC_V1_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 315
  { IMAGE_ATOMIC_DEC_V2_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 316
  { IMAGE_ATOMIC_DEC_V2_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 317
  { IMAGE_ATOMIC_DEC_V2_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 318
  { IMAGE_ATOMIC_DEC_V2_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 319
  { IMAGE_ATOMIC_DEC_V3_V1_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 320
  { IMAGE_ATOMIC_DEC_V3_V2_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 321
  { IMAGE_ATOMIC_DEC_V3_V3_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 322
  { IMAGE_ATOMIC_DEC_V3_V4_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 323
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 324
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 325
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 326
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 327
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 328
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 329
  { IMAGE_ATOMIC_DEC_V3_V2_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 330
  { IMAGE_ATOMIC_DEC_V3_V3_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 331
  { IMAGE_ATOMIC_DEC_V3_V4_nsa_gfx10, IMAGE_ATOMIC_DEC, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 332
  { IMAGE_ATOMIC_DEC_V1_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 333
  { IMAGE_ATOMIC_DEC_V1_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 334
  { IMAGE_ATOMIC_DEC_V1_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 335
  { IMAGE_ATOMIC_DEC_V1_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 336
  { IMAGE_ATOMIC_DEC_V2_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 337
  { IMAGE_ATOMIC_DEC_V2_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 338
  { IMAGE_ATOMIC_DEC_V2_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 339
  { IMAGE_ATOMIC_DEC_V2_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 340
  { IMAGE_ATOMIC_DEC_V3_V1_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 341
  { IMAGE_ATOMIC_DEC_V3_V2_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 342
  { IMAGE_ATOMIC_DEC_V3_V3_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 343
  { IMAGE_ATOMIC_DEC_V3_V4_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 344
  { IMAGE_ATOMIC_DEC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 345
  { IMAGE_ATOMIC_DEC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 346
  { IMAGE_ATOMIC_DEC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 347
  { IMAGE_ATOMIC_DEC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 348
  { IMAGE_ATOMIC_DEC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 349
  { IMAGE_ATOMIC_DEC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 350
  { IMAGE_ATOMIC_DEC_V3_V2_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 351
  { IMAGE_ATOMIC_DEC_V3_V3_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 352
  { IMAGE_ATOMIC_DEC_V3_V4_nsa_gfx11, IMAGE_ATOMIC_DEC, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 353
  { IMAGE_ATOMIC_DEC_V1_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 354
  { IMAGE_ATOMIC_DEC_V1_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 355
  { IMAGE_ATOMIC_DEC_V1_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 356
  { IMAGE_ATOMIC_DEC_V1_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 357
  { IMAGE_ATOMIC_DEC_V2_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 358
  { IMAGE_ATOMIC_DEC_V2_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 359
  { IMAGE_ATOMIC_DEC_V2_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 360
  { IMAGE_ATOMIC_DEC_V2_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 361
  { IMAGE_ATOMIC_DEC_V3_V1_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 362
  { IMAGE_ATOMIC_DEC_V3_V2_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 363
  { IMAGE_ATOMIC_DEC_V3_V3_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 364
  { IMAGE_ATOMIC_DEC_V3_V4_gfx12, IMAGE_ATOMIC_DEC, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 365
  { IMAGE_ATOMIC_DEC_V1_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 366
  { IMAGE_ATOMIC_DEC_V1_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 367
  { IMAGE_ATOMIC_DEC_V1_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 368
  { IMAGE_ATOMIC_DEC_V1_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 369
  { IMAGE_ATOMIC_DEC_V2_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 370
  { IMAGE_ATOMIC_DEC_V2_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 371
  { IMAGE_ATOMIC_DEC_V2_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 372
  { IMAGE_ATOMIC_DEC_V2_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 373
  { IMAGE_ATOMIC_DEC_V3_V1_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 374
  { IMAGE_ATOMIC_DEC_V3_V2_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 375
  { IMAGE_ATOMIC_DEC_V3_V3_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 376
  { IMAGE_ATOMIC_DEC_V3_V4_si, IMAGE_ATOMIC_DEC, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 377
  { IMAGE_ATOMIC_DEC_V1_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 378
  { IMAGE_ATOMIC_DEC_V1_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 379
  { IMAGE_ATOMIC_DEC_V1_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 380
  { IMAGE_ATOMIC_DEC_V1_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 381
  { IMAGE_ATOMIC_DEC_V2_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 382
  { IMAGE_ATOMIC_DEC_V2_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 383
  { IMAGE_ATOMIC_DEC_V2_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 384
  { IMAGE_ATOMIC_DEC_V2_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 385
  { IMAGE_ATOMIC_DEC_V3_V1_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 386
  { IMAGE_ATOMIC_DEC_V3_V2_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 387
  { IMAGE_ATOMIC_DEC_V3_V3_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 388
  { IMAGE_ATOMIC_DEC_V3_V4_vi, IMAGE_ATOMIC_DEC, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 389
  { IMAGE_ATOMIC_DEC_V1_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 390
  { IMAGE_ATOMIC_DEC_V1_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 391
  { IMAGE_ATOMIC_DEC_V1_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 392
  { IMAGE_ATOMIC_DEC_V1_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 393
  { IMAGE_ATOMIC_DEC_V2_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 394
  { IMAGE_ATOMIC_DEC_V2_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 395
  { IMAGE_ATOMIC_DEC_V2_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 396
  { IMAGE_ATOMIC_DEC_V2_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 397
  { IMAGE_ATOMIC_DEC_V3_V1_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 398
  { IMAGE_ATOMIC_DEC_V3_V2_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 399
  { IMAGE_ATOMIC_DEC_V3_V3_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 400
  { IMAGE_ATOMIC_DEC_V3_V4_gfx90a, IMAGE_ATOMIC_DEC, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 401
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 402
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 403
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 404
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 405
  { IMAGE_ATOMIC_FCMPSWAP_V3_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 406
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 407
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 408
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 409
  { IMAGE_ATOMIC_FCMPSWAP_V4_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 410
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 411
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 412
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 413
  { IMAGE_ATOMIC_FCMPSWAP_V5_V1_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 414
  { IMAGE_ATOMIC_FCMPSWAP_V5_V2_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 415
  { IMAGE_ATOMIC_FCMPSWAP_V5_V3_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 416
  { IMAGE_ATOMIC_FCMPSWAP_V5_V4_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 417
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 418
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 419
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 420
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 421
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 422
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 423
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 424
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 425
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 426
  { IMAGE_ATOMIC_FCMPSWAP_V5_V2_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 427
  { IMAGE_ATOMIC_FCMPSWAP_V5_V3_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 428
  { IMAGE_ATOMIC_FCMPSWAP_V5_V4_nsa_gfx10, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 429
  { IMAGE_ATOMIC_FCMPSWAP_V2_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 430
  { IMAGE_ATOMIC_FCMPSWAP_V2_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 431
  { IMAGE_ATOMIC_FCMPSWAP_V2_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 432
  { IMAGE_ATOMIC_FCMPSWAP_V2_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 433
  { IMAGE_ATOMIC_FCMPSWAP_V3_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 434
  { IMAGE_ATOMIC_FCMPSWAP_V3_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 435
  { IMAGE_ATOMIC_FCMPSWAP_V3_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 436
  { IMAGE_ATOMIC_FCMPSWAP_V3_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 437
  { IMAGE_ATOMIC_FCMPSWAP_V4_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 438
  { IMAGE_ATOMIC_FCMPSWAP_V4_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 439
  { IMAGE_ATOMIC_FCMPSWAP_V4_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 440
  { IMAGE_ATOMIC_FCMPSWAP_V4_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 441
  { IMAGE_ATOMIC_FCMPSWAP_V5_V1_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 442
  { IMAGE_ATOMIC_FCMPSWAP_V5_V2_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 443
  { IMAGE_ATOMIC_FCMPSWAP_V5_V3_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 444
  { IMAGE_ATOMIC_FCMPSWAP_V5_V4_si, IMAGE_ATOMIC_FCMPSWAP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 445
  { IMAGE_ATOMIC_FMAX_V1_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 446
  { IMAGE_ATOMIC_FMAX_V1_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 447
  { IMAGE_ATOMIC_FMAX_V1_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 448
  { IMAGE_ATOMIC_FMAX_V1_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 449
  { IMAGE_ATOMIC_FMAX_V2_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 450
  { IMAGE_ATOMIC_FMAX_V2_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 451
  { IMAGE_ATOMIC_FMAX_V2_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 452
  { IMAGE_ATOMIC_FMAX_V2_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 453
  { IMAGE_ATOMIC_FMAX_V3_V1_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 454
  { IMAGE_ATOMIC_FMAX_V3_V2_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 455
  { IMAGE_ATOMIC_FMAX_V3_V3_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 456
  { IMAGE_ATOMIC_FMAX_V3_V4_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 457
  { IMAGE_ATOMIC_FMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 458
  { IMAGE_ATOMIC_FMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 459
  { IMAGE_ATOMIC_FMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 460
  { IMAGE_ATOMIC_FMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 461
  { IMAGE_ATOMIC_FMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 462
  { IMAGE_ATOMIC_FMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 463
  { IMAGE_ATOMIC_FMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 464
  { IMAGE_ATOMIC_FMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 465
  { IMAGE_ATOMIC_FMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FMAX, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 466
  { IMAGE_ATOMIC_FMAX_V1_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 467
  { IMAGE_ATOMIC_FMAX_V1_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 468
  { IMAGE_ATOMIC_FMAX_V1_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 469
  { IMAGE_ATOMIC_FMAX_V1_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 470
  { IMAGE_ATOMIC_FMAX_V2_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 471
  { IMAGE_ATOMIC_FMAX_V2_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 472
  { IMAGE_ATOMIC_FMAX_V2_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 473
  { IMAGE_ATOMIC_FMAX_V2_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 474
  { IMAGE_ATOMIC_FMAX_V3_V1_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 475
  { IMAGE_ATOMIC_FMAX_V3_V2_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 476
  { IMAGE_ATOMIC_FMAX_V3_V3_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 477
  { IMAGE_ATOMIC_FMAX_V3_V4_si, IMAGE_ATOMIC_FMAX, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 478
  { IMAGE_ATOMIC_FMIN_V1_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 479
  { IMAGE_ATOMIC_FMIN_V1_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 480
  { IMAGE_ATOMIC_FMIN_V1_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 481
  { IMAGE_ATOMIC_FMIN_V1_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 482
  { IMAGE_ATOMIC_FMIN_V2_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 483
  { IMAGE_ATOMIC_FMIN_V2_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 484
  { IMAGE_ATOMIC_FMIN_V2_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 485
  { IMAGE_ATOMIC_FMIN_V2_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 486
  { IMAGE_ATOMIC_FMIN_V3_V1_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 487
  { IMAGE_ATOMIC_FMIN_V3_V2_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 488
  { IMAGE_ATOMIC_FMIN_V3_V3_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 489
  { IMAGE_ATOMIC_FMIN_V3_V4_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 490
  { IMAGE_ATOMIC_FMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 491
  { IMAGE_ATOMIC_FMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 492
  { IMAGE_ATOMIC_FMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 493
  { IMAGE_ATOMIC_FMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 494
  { IMAGE_ATOMIC_FMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 495
  { IMAGE_ATOMIC_FMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 496
  { IMAGE_ATOMIC_FMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 497
  { IMAGE_ATOMIC_FMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 498
  { IMAGE_ATOMIC_FMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_FMIN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 499
  { IMAGE_ATOMIC_FMIN_V1_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 500
  { IMAGE_ATOMIC_FMIN_V1_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 501
  { IMAGE_ATOMIC_FMIN_V1_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 502
  { IMAGE_ATOMIC_FMIN_V1_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 503
  { IMAGE_ATOMIC_FMIN_V2_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 504
  { IMAGE_ATOMIC_FMIN_V2_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 505
  { IMAGE_ATOMIC_FMIN_V2_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 506
  { IMAGE_ATOMIC_FMIN_V2_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 507
  { IMAGE_ATOMIC_FMIN_V3_V1_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 508
  { IMAGE_ATOMIC_FMIN_V3_V2_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 509
  { IMAGE_ATOMIC_FMIN_V3_V3_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 510
  { IMAGE_ATOMIC_FMIN_V3_V4_si, IMAGE_ATOMIC_FMIN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 511
  { IMAGE_ATOMIC_INC_V1_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 512
  { IMAGE_ATOMIC_INC_V1_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 513
  { IMAGE_ATOMIC_INC_V1_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 514
  { IMAGE_ATOMIC_INC_V1_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 515
  { IMAGE_ATOMIC_INC_V2_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 516
  { IMAGE_ATOMIC_INC_V2_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 517
  { IMAGE_ATOMIC_INC_V2_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 518
  { IMAGE_ATOMIC_INC_V2_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 519
  { IMAGE_ATOMIC_INC_V3_V1_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 520
  { IMAGE_ATOMIC_INC_V3_V2_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 521
  { IMAGE_ATOMIC_INC_V3_V3_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 522
  { IMAGE_ATOMIC_INC_V3_V4_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 523
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 524
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 525
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 526
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 527
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 528
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 529
  { IMAGE_ATOMIC_INC_V3_V2_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 530
  { IMAGE_ATOMIC_INC_V3_V3_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 531
  { IMAGE_ATOMIC_INC_V3_V4_nsa_gfx10, IMAGE_ATOMIC_INC, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 532
  { IMAGE_ATOMIC_INC_V1_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 533
  { IMAGE_ATOMIC_INC_V1_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 534
  { IMAGE_ATOMIC_INC_V1_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 535
  { IMAGE_ATOMIC_INC_V1_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 536
  { IMAGE_ATOMIC_INC_V2_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 537
  { IMAGE_ATOMIC_INC_V2_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 538
  { IMAGE_ATOMIC_INC_V2_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 539
  { IMAGE_ATOMIC_INC_V2_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 540
  { IMAGE_ATOMIC_INC_V3_V1_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 541
  { IMAGE_ATOMIC_INC_V3_V2_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 542
  { IMAGE_ATOMIC_INC_V3_V3_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 543
  { IMAGE_ATOMIC_INC_V3_V4_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 544
  { IMAGE_ATOMIC_INC_V1_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 545
  { IMAGE_ATOMIC_INC_V1_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 546
  { IMAGE_ATOMIC_INC_V1_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 547
  { IMAGE_ATOMIC_INC_V2_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 548
  { IMAGE_ATOMIC_INC_V2_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 549
  { IMAGE_ATOMIC_INC_V2_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 550
  { IMAGE_ATOMIC_INC_V3_V2_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 551
  { IMAGE_ATOMIC_INC_V3_V3_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 552
  { IMAGE_ATOMIC_INC_V3_V4_nsa_gfx11, IMAGE_ATOMIC_INC, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 553
  { IMAGE_ATOMIC_INC_V1_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 554
  { IMAGE_ATOMIC_INC_V1_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 555
  { IMAGE_ATOMIC_INC_V1_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 556
  { IMAGE_ATOMIC_INC_V1_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 557
  { IMAGE_ATOMIC_INC_V2_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 558
  { IMAGE_ATOMIC_INC_V2_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 559
  { IMAGE_ATOMIC_INC_V2_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 560
  { IMAGE_ATOMIC_INC_V2_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 561
  { IMAGE_ATOMIC_INC_V3_V1_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 562
  { IMAGE_ATOMIC_INC_V3_V2_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 563
  { IMAGE_ATOMIC_INC_V3_V3_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 564
  { IMAGE_ATOMIC_INC_V3_V4_gfx12, IMAGE_ATOMIC_INC, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 565
  { IMAGE_ATOMIC_INC_V1_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 566
  { IMAGE_ATOMIC_INC_V1_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 567
  { IMAGE_ATOMIC_INC_V1_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 568
  { IMAGE_ATOMIC_INC_V1_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 569
  { IMAGE_ATOMIC_INC_V2_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 570
  { IMAGE_ATOMIC_INC_V2_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 571
  { IMAGE_ATOMIC_INC_V2_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 572
  { IMAGE_ATOMIC_INC_V2_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 573
  { IMAGE_ATOMIC_INC_V3_V1_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 574
  { IMAGE_ATOMIC_INC_V3_V2_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 575
  { IMAGE_ATOMIC_INC_V3_V3_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 576
  { IMAGE_ATOMIC_INC_V3_V4_si, IMAGE_ATOMIC_INC, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 577
  { IMAGE_ATOMIC_INC_V1_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 578
  { IMAGE_ATOMIC_INC_V1_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 579
  { IMAGE_ATOMIC_INC_V1_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 580
  { IMAGE_ATOMIC_INC_V1_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 581
  { IMAGE_ATOMIC_INC_V2_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 582
  { IMAGE_ATOMIC_INC_V2_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 583
  { IMAGE_ATOMIC_INC_V2_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 584
  { IMAGE_ATOMIC_INC_V2_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 585
  { IMAGE_ATOMIC_INC_V3_V1_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 586
  { IMAGE_ATOMIC_INC_V3_V2_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 587
  { IMAGE_ATOMIC_INC_V3_V3_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 588
  { IMAGE_ATOMIC_INC_V3_V4_vi, IMAGE_ATOMIC_INC, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 589
  { IMAGE_ATOMIC_INC_V1_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 590
  { IMAGE_ATOMIC_INC_V1_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 591
  { IMAGE_ATOMIC_INC_V1_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 592
  { IMAGE_ATOMIC_INC_V1_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 593
  { IMAGE_ATOMIC_INC_V2_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 594
  { IMAGE_ATOMIC_INC_V2_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 595
  { IMAGE_ATOMIC_INC_V2_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 596
  { IMAGE_ATOMIC_INC_V2_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 597
  { IMAGE_ATOMIC_INC_V3_V1_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 598
  { IMAGE_ATOMIC_INC_V3_V2_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 599
  { IMAGE_ATOMIC_INC_V3_V3_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 600
  { IMAGE_ATOMIC_INC_V3_V4_gfx90a, IMAGE_ATOMIC_INC, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 601
  { IMAGE_ATOMIC_MAX_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 602
  { IMAGE_ATOMIC_MAX_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 603
  { IMAGE_ATOMIC_MAX_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 604
  { IMAGE_ATOMIC_MAX_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 605
  { IMAGE_ATOMIC_MAX_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 606
  { IMAGE_ATOMIC_MAX_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 607
  { IMAGE_ATOMIC_MAX_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 608
  { IMAGE_ATOMIC_MAX_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 609
  { IMAGE_ATOMIC_MAX_FLT_V3_V1_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 610
  { IMAGE_ATOMIC_MAX_FLT_V3_V2_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 611
  { IMAGE_ATOMIC_MAX_FLT_V3_V3_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 612
  { IMAGE_ATOMIC_MAX_FLT_V3_V4_gfx12, IMAGE_ATOMIC_MAX_FLT, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 613
  { IMAGE_ATOMIC_MIN_FLT_V1_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 614
  { IMAGE_ATOMIC_MIN_FLT_V1_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 615
  { IMAGE_ATOMIC_MIN_FLT_V1_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 616
  { IMAGE_ATOMIC_MIN_FLT_V1_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 617
  { IMAGE_ATOMIC_MIN_FLT_V2_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 618
  { IMAGE_ATOMIC_MIN_FLT_V2_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 619
  { IMAGE_ATOMIC_MIN_FLT_V2_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 620
  { IMAGE_ATOMIC_MIN_FLT_V2_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 621
  { IMAGE_ATOMIC_MIN_FLT_V3_V1_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 622
  { IMAGE_ATOMIC_MIN_FLT_V3_V2_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 623
  { IMAGE_ATOMIC_MIN_FLT_V3_V3_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 624
  { IMAGE_ATOMIC_MIN_FLT_V3_V4_gfx12, IMAGE_ATOMIC_MIN_FLT, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 625
  { IMAGE_ATOMIC_OR_V1_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 626
  { IMAGE_ATOMIC_OR_V1_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 627
  { IMAGE_ATOMIC_OR_V1_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 628
  { IMAGE_ATOMIC_OR_V1_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 629
  { IMAGE_ATOMIC_OR_V2_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 630
  { IMAGE_ATOMIC_OR_V2_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 631
  { IMAGE_ATOMIC_OR_V2_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 632
  { IMAGE_ATOMIC_OR_V2_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 633
  { IMAGE_ATOMIC_OR_V3_V1_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 634
  { IMAGE_ATOMIC_OR_V3_V2_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 635
  { IMAGE_ATOMIC_OR_V3_V3_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 636
  { IMAGE_ATOMIC_OR_V3_V4_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 637
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 638
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 639
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 640
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 641
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 642
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 643
  { IMAGE_ATOMIC_OR_V3_V2_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 644
  { IMAGE_ATOMIC_OR_V3_V3_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 645
  { IMAGE_ATOMIC_OR_V3_V4_nsa_gfx10, IMAGE_ATOMIC_OR, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 646
  { IMAGE_ATOMIC_OR_V1_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 647
  { IMAGE_ATOMIC_OR_V1_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 648
  { IMAGE_ATOMIC_OR_V1_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 649
  { IMAGE_ATOMIC_OR_V1_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 650
  { IMAGE_ATOMIC_OR_V2_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 651
  { IMAGE_ATOMIC_OR_V2_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 652
  { IMAGE_ATOMIC_OR_V2_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 653
  { IMAGE_ATOMIC_OR_V2_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 654
  { IMAGE_ATOMIC_OR_V3_V1_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 655
  { IMAGE_ATOMIC_OR_V3_V2_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 656
  { IMAGE_ATOMIC_OR_V3_V3_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 657
  { IMAGE_ATOMIC_OR_V3_V4_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 658
  { IMAGE_ATOMIC_OR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 659
  { IMAGE_ATOMIC_OR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 660
  { IMAGE_ATOMIC_OR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 661
  { IMAGE_ATOMIC_OR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 662
  { IMAGE_ATOMIC_OR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 663
  { IMAGE_ATOMIC_OR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 664
  { IMAGE_ATOMIC_OR_V3_V2_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 665
  { IMAGE_ATOMIC_OR_V3_V3_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 666
  { IMAGE_ATOMIC_OR_V3_V4_nsa_gfx11, IMAGE_ATOMIC_OR, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 667
  { IMAGE_ATOMIC_OR_V1_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 668
  { IMAGE_ATOMIC_OR_V1_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 669
  { IMAGE_ATOMIC_OR_V1_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 670
  { IMAGE_ATOMIC_OR_V1_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 671
  { IMAGE_ATOMIC_OR_V2_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 672
  { IMAGE_ATOMIC_OR_V2_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 673
  { IMAGE_ATOMIC_OR_V2_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 674
  { IMAGE_ATOMIC_OR_V2_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 675
  { IMAGE_ATOMIC_OR_V3_V1_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 676
  { IMAGE_ATOMIC_OR_V3_V2_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 677
  { IMAGE_ATOMIC_OR_V3_V3_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 678
  { IMAGE_ATOMIC_OR_V3_V4_gfx12, IMAGE_ATOMIC_OR, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 679
  { IMAGE_ATOMIC_OR_V1_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 680
  { IMAGE_ATOMIC_OR_V1_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 681
  { IMAGE_ATOMIC_OR_V1_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 682
  { IMAGE_ATOMIC_OR_V1_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 683
  { IMAGE_ATOMIC_OR_V2_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 684
  { IMAGE_ATOMIC_OR_V2_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 685
  { IMAGE_ATOMIC_OR_V2_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 686
  { IMAGE_ATOMIC_OR_V2_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 687
  { IMAGE_ATOMIC_OR_V3_V1_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 688
  { IMAGE_ATOMIC_OR_V3_V2_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 689
  { IMAGE_ATOMIC_OR_V3_V3_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 690
  { IMAGE_ATOMIC_OR_V3_V4_si, IMAGE_ATOMIC_OR, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 691
  { IMAGE_ATOMIC_OR_V1_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 692
  { IMAGE_ATOMIC_OR_V1_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 693
  { IMAGE_ATOMIC_OR_V1_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 694
  { IMAGE_ATOMIC_OR_V1_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 695
  { IMAGE_ATOMIC_OR_V2_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 696
  { IMAGE_ATOMIC_OR_V2_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 697
  { IMAGE_ATOMIC_OR_V2_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 698
  { IMAGE_ATOMIC_OR_V2_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 699
  { IMAGE_ATOMIC_OR_V3_V1_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 700
  { IMAGE_ATOMIC_OR_V3_V2_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 701
  { IMAGE_ATOMIC_OR_V3_V3_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 702
  { IMAGE_ATOMIC_OR_V3_V4_vi, IMAGE_ATOMIC_OR, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 703
  { IMAGE_ATOMIC_OR_V1_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 704
  { IMAGE_ATOMIC_OR_V1_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 705
  { IMAGE_ATOMIC_OR_V1_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 706
  { IMAGE_ATOMIC_OR_V1_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 707
  { IMAGE_ATOMIC_OR_V2_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 708
  { IMAGE_ATOMIC_OR_V2_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 709
  { IMAGE_ATOMIC_OR_V2_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 710
  { IMAGE_ATOMIC_OR_V2_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 711
  { IMAGE_ATOMIC_OR_V3_V1_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 712
  { IMAGE_ATOMIC_OR_V3_V2_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 713
  { IMAGE_ATOMIC_OR_V3_V3_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 714
  { IMAGE_ATOMIC_OR_V3_V4_gfx90a, IMAGE_ATOMIC_OR, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 715
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 716
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 717
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 718
  { IMAGE_ATOMIC_PK_ADD_BF16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 719
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 720
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 721
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 722
  { IMAGE_ATOMIC_PK_ADD_BF16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 723
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V1_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 724
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V2_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 725
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V3_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 726
  { IMAGE_ATOMIC_PK_ADD_BF16_V3_V4_gfx12, IMAGE_ATOMIC_PK_ADD_BF16, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 727
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 728
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 729
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 730
  { IMAGE_ATOMIC_PK_ADD_F16_V1_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 731
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 732
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 733
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 734
  { IMAGE_ATOMIC_PK_ADD_F16_V2_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 735
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V1_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 736
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V2_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 737
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V3_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 738
  { IMAGE_ATOMIC_PK_ADD_F16_V3_V4_gfx12, IMAGE_ATOMIC_PK_ADD_F16, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 739
  { IMAGE_ATOMIC_RSUB_V1_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 740
  { IMAGE_ATOMIC_RSUB_V1_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 741
  { IMAGE_ATOMIC_RSUB_V1_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 742
  { IMAGE_ATOMIC_RSUB_V1_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 743
  { IMAGE_ATOMIC_RSUB_V2_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 744
  { IMAGE_ATOMIC_RSUB_V2_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 745
  { IMAGE_ATOMIC_RSUB_V2_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 746
  { IMAGE_ATOMIC_RSUB_V2_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 747
  { IMAGE_ATOMIC_RSUB_V3_V1_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 748
  { IMAGE_ATOMIC_RSUB_V3_V2_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 749
  { IMAGE_ATOMIC_RSUB_V3_V3_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 750
  { IMAGE_ATOMIC_RSUB_V3_V4_si, IMAGE_ATOMIC_RSUB, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 751
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 752
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 753
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 754
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 755
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 756
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 757
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 758
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 759
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 760
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 761
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 762
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 763
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 764
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 765
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 766
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 767
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 768
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 769
  { IMAGE_ATOMIC_SMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 770
  { IMAGE_ATOMIC_SMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 771
  { IMAGE_ATOMIC_SMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SMAX, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 772
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 773
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 774
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 775
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 776
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 777
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 778
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 779
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 780
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 781
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 782
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 783
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 784
  { IMAGE_ATOMIC_SMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 785
  { IMAGE_ATOMIC_SMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 786
  { IMAGE_ATOMIC_SMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 787
  { IMAGE_ATOMIC_SMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 788
  { IMAGE_ATOMIC_SMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 789
  { IMAGE_ATOMIC_SMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 790
  { IMAGE_ATOMIC_SMAX_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 791
  { IMAGE_ATOMIC_SMAX_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 792
  { IMAGE_ATOMIC_SMAX_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SMAX, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 793
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 794
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 795
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 796
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 797
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 798
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 799
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 800
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 801
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 802
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 803
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 804
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx12, IMAGE_ATOMIC_SMAX, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 805
  { IMAGE_ATOMIC_SMAX_V1_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 806
  { IMAGE_ATOMIC_SMAX_V1_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 807
  { IMAGE_ATOMIC_SMAX_V1_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 808
  { IMAGE_ATOMIC_SMAX_V1_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 809
  { IMAGE_ATOMIC_SMAX_V2_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 810
  { IMAGE_ATOMIC_SMAX_V2_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 811
  { IMAGE_ATOMIC_SMAX_V2_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 812
  { IMAGE_ATOMIC_SMAX_V2_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 813
  { IMAGE_ATOMIC_SMAX_V3_V1_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 814
  { IMAGE_ATOMIC_SMAX_V3_V2_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 815
  { IMAGE_ATOMIC_SMAX_V3_V3_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 816
  { IMAGE_ATOMIC_SMAX_V3_V4_si, IMAGE_ATOMIC_SMAX, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 817
  { IMAGE_ATOMIC_SMAX_V1_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 818
  { IMAGE_ATOMIC_SMAX_V1_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 819
  { IMAGE_ATOMIC_SMAX_V1_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 820
  { IMAGE_ATOMIC_SMAX_V1_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 821
  { IMAGE_ATOMIC_SMAX_V2_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 822
  { IMAGE_ATOMIC_SMAX_V2_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 823
  { IMAGE_ATOMIC_SMAX_V2_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 824
  { IMAGE_ATOMIC_SMAX_V2_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 825
  { IMAGE_ATOMIC_SMAX_V3_V1_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 826
  { IMAGE_ATOMIC_SMAX_V3_V2_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 827
  { IMAGE_ATOMIC_SMAX_V3_V3_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 828
  { IMAGE_ATOMIC_SMAX_V3_V4_vi, IMAGE_ATOMIC_SMAX, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 829
  { IMAGE_ATOMIC_SMAX_V1_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 830
  { IMAGE_ATOMIC_SMAX_V1_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 831
  { IMAGE_ATOMIC_SMAX_V1_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 832
  { IMAGE_ATOMIC_SMAX_V1_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 833
  { IMAGE_ATOMIC_SMAX_V2_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 834
  { IMAGE_ATOMIC_SMAX_V2_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 835
  { IMAGE_ATOMIC_SMAX_V2_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 836
  { IMAGE_ATOMIC_SMAX_V2_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 837
  { IMAGE_ATOMIC_SMAX_V3_V1_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 838
  { IMAGE_ATOMIC_SMAX_V3_V2_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 839
  { IMAGE_ATOMIC_SMAX_V3_V3_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 840
  { IMAGE_ATOMIC_SMAX_V3_V4_gfx90a, IMAGE_ATOMIC_SMAX, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 841
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 842
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 843
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 844
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 845
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 846
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 847
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 848
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 849
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 850
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 851
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 852
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 853
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 854
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 855
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 856
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 857
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 858
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 859
  { IMAGE_ATOMIC_SMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 860
  { IMAGE_ATOMIC_SMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 861
  { IMAGE_ATOMIC_SMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SMIN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 862
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 863
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 864
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 865
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 866
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 867
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 868
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 869
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 870
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 871
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 872
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 873
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 874
  { IMAGE_ATOMIC_SMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 875
  { IMAGE_ATOMIC_SMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 876
  { IMAGE_ATOMIC_SMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 877
  { IMAGE_ATOMIC_SMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 878
  { IMAGE_ATOMIC_SMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 879
  { IMAGE_ATOMIC_SMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 880
  { IMAGE_ATOMIC_SMIN_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 881
  { IMAGE_ATOMIC_SMIN_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 882
  { IMAGE_ATOMIC_SMIN_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SMIN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 883
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 884
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 885
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 886
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 887
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 888
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 889
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 890
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 891
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 892
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 893
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 894
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx12, IMAGE_ATOMIC_SMIN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 895
  { IMAGE_ATOMIC_SMIN_V1_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 896
  { IMAGE_ATOMIC_SMIN_V1_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 897
  { IMAGE_ATOMIC_SMIN_V1_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 898
  { IMAGE_ATOMIC_SMIN_V1_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 899
  { IMAGE_ATOMIC_SMIN_V2_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 900
  { IMAGE_ATOMIC_SMIN_V2_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 901
  { IMAGE_ATOMIC_SMIN_V2_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 902
  { IMAGE_ATOMIC_SMIN_V2_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 903
  { IMAGE_ATOMIC_SMIN_V3_V1_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 904
  { IMAGE_ATOMIC_SMIN_V3_V2_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 905
  { IMAGE_ATOMIC_SMIN_V3_V3_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 906
  { IMAGE_ATOMIC_SMIN_V3_V4_si, IMAGE_ATOMIC_SMIN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 907
  { IMAGE_ATOMIC_SMIN_V1_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 908
  { IMAGE_ATOMIC_SMIN_V1_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 909
  { IMAGE_ATOMIC_SMIN_V1_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 910
  { IMAGE_ATOMIC_SMIN_V1_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 911
  { IMAGE_ATOMIC_SMIN_V2_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 912
  { IMAGE_ATOMIC_SMIN_V2_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 913
  { IMAGE_ATOMIC_SMIN_V2_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 914
  { IMAGE_ATOMIC_SMIN_V2_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 915
  { IMAGE_ATOMIC_SMIN_V3_V1_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 916
  { IMAGE_ATOMIC_SMIN_V3_V2_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 917
  { IMAGE_ATOMIC_SMIN_V3_V3_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 918
  { IMAGE_ATOMIC_SMIN_V3_V4_vi, IMAGE_ATOMIC_SMIN, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 919
  { IMAGE_ATOMIC_SMIN_V1_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 920
  { IMAGE_ATOMIC_SMIN_V1_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 921
  { IMAGE_ATOMIC_SMIN_V1_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 922
  { IMAGE_ATOMIC_SMIN_V1_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 923
  { IMAGE_ATOMIC_SMIN_V2_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 924
  { IMAGE_ATOMIC_SMIN_V2_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 925
  { IMAGE_ATOMIC_SMIN_V2_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 926
  { IMAGE_ATOMIC_SMIN_V2_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 927
  { IMAGE_ATOMIC_SMIN_V3_V1_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 928
  { IMAGE_ATOMIC_SMIN_V3_V2_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 929
  { IMAGE_ATOMIC_SMIN_V3_V3_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 930
  { IMAGE_ATOMIC_SMIN_V3_V4_gfx90a, IMAGE_ATOMIC_SMIN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 931
  { IMAGE_ATOMIC_SUB_V1_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 932
  { IMAGE_ATOMIC_SUB_V1_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 933
  { IMAGE_ATOMIC_SUB_V1_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 934
  { IMAGE_ATOMIC_SUB_V1_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 935
  { IMAGE_ATOMIC_SUB_V2_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 936
  { IMAGE_ATOMIC_SUB_V2_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 937
  { IMAGE_ATOMIC_SUB_V2_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 938
  { IMAGE_ATOMIC_SUB_V2_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 939
  { IMAGE_ATOMIC_SUB_V3_V1_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 940
  { IMAGE_ATOMIC_SUB_V3_V2_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 941
  { IMAGE_ATOMIC_SUB_V3_V3_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 942
  { IMAGE_ATOMIC_SUB_V3_V4_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 943
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 944
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 945
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 946
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 947
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 948
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 949
  { IMAGE_ATOMIC_SUB_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 950
  { IMAGE_ATOMIC_SUB_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 951
  { IMAGE_ATOMIC_SUB_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SUB, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 952
  { IMAGE_ATOMIC_SUB_V1_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 953
  { IMAGE_ATOMIC_SUB_V1_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 954
  { IMAGE_ATOMIC_SUB_V1_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 955
  { IMAGE_ATOMIC_SUB_V1_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 956
  { IMAGE_ATOMIC_SUB_V2_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 957
  { IMAGE_ATOMIC_SUB_V2_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 958
  { IMAGE_ATOMIC_SUB_V2_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 959
  { IMAGE_ATOMIC_SUB_V2_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 960
  { IMAGE_ATOMIC_SUB_V3_V1_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 961
  { IMAGE_ATOMIC_SUB_V3_V2_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 962
  { IMAGE_ATOMIC_SUB_V3_V3_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 963
  { IMAGE_ATOMIC_SUB_V3_V4_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 964
  { IMAGE_ATOMIC_SUB_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 965
  { IMAGE_ATOMIC_SUB_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 966
  { IMAGE_ATOMIC_SUB_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 967
  { IMAGE_ATOMIC_SUB_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 968
  { IMAGE_ATOMIC_SUB_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 969
  { IMAGE_ATOMIC_SUB_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 970
  { IMAGE_ATOMIC_SUB_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 971
  { IMAGE_ATOMIC_SUB_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 972
  { IMAGE_ATOMIC_SUB_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SUB, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 973
  { IMAGE_ATOMIC_SUB_V1_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 974
  { IMAGE_ATOMIC_SUB_V1_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 975
  { IMAGE_ATOMIC_SUB_V1_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 976
  { IMAGE_ATOMIC_SUB_V1_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 977
  { IMAGE_ATOMIC_SUB_V2_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 978
  { IMAGE_ATOMIC_SUB_V2_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 979
  { IMAGE_ATOMIC_SUB_V2_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 980
  { IMAGE_ATOMIC_SUB_V2_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 981
  { IMAGE_ATOMIC_SUB_V3_V1_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 982
  { IMAGE_ATOMIC_SUB_V3_V2_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 983
  { IMAGE_ATOMIC_SUB_V3_V3_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 984
  { IMAGE_ATOMIC_SUB_V3_V4_gfx12, IMAGE_ATOMIC_SUB, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 985
  { IMAGE_ATOMIC_SUB_V1_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 986
  { IMAGE_ATOMIC_SUB_V1_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 987
  { IMAGE_ATOMIC_SUB_V1_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 988
  { IMAGE_ATOMIC_SUB_V1_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 989
  { IMAGE_ATOMIC_SUB_V2_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 990
  { IMAGE_ATOMIC_SUB_V2_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 991
  { IMAGE_ATOMIC_SUB_V2_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 992
  { IMAGE_ATOMIC_SUB_V2_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 993
  { IMAGE_ATOMIC_SUB_V3_V1_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 994
  { IMAGE_ATOMIC_SUB_V3_V2_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 995
  { IMAGE_ATOMIC_SUB_V3_V3_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 996
  { IMAGE_ATOMIC_SUB_V3_V4_si, IMAGE_ATOMIC_SUB, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 997
  { IMAGE_ATOMIC_SUB_V1_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 998
  { IMAGE_ATOMIC_SUB_V1_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 999
  { IMAGE_ATOMIC_SUB_V1_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1000
  { IMAGE_ATOMIC_SUB_V1_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1001
  { IMAGE_ATOMIC_SUB_V2_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1002
  { IMAGE_ATOMIC_SUB_V2_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1003
  { IMAGE_ATOMIC_SUB_V2_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1004
  { IMAGE_ATOMIC_SUB_V2_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1005
  { IMAGE_ATOMIC_SUB_V3_V1_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 1006
  { IMAGE_ATOMIC_SUB_V3_V2_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 1007
  { IMAGE_ATOMIC_SUB_V3_V3_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 1008
  { IMAGE_ATOMIC_SUB_V3_V4_vi, IMAGE_ATOMIC_SUB, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 1009
  { IMAGE_ATOMIC_SUB_V1_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1010
  { IMAGE_ATOMIC_SUB_V1_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1011
  { IMAGE_ATOMIC_SUB_V1_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1012
  { IMAGE_ATOMIC_SUB_V1_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1013
  { IMAGE_ATOMIC_SUB_V2_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1014
  { IMAGE_ATOMIC_SUB_V2_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1015
  { IMAGE_ATOMIC_SUB_V2_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1016
  { IMAGE_ATOMIC_SUB_V2_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1017
  { IMAGE_ATOMIC_SUB_V3_V1_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 1018
  { IMAGE_ATOMIC_SUB_V3_V2_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 1019
  { IMAGE_ATOMIC_SUB_V3_V3_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 1020
  { IMAGE_ATOMIC_SUB_V3_V4_gfx90a, IMAGE_ATOMIC_SUB, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 1021
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1022
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1023
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1024
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1025
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1026
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1027
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1028
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1029
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 1030
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 1031
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 1032
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 1033
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1034
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1035
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1036
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1037
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1038
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1039
  { IMAGE_ATOMIC_SWAP_V3_V2_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 1040
  { IMAGE_ATOMIC_SWAP_V3_V3_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 1041
  { IMAGE_ATOMIC_SWAP_V3_V4_nsa_gfx10, IMAGE_ATOMIC_SWAP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 1042
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1043
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1044
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1045
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1046
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1047
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1048
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1049
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1050
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 1051
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 1052
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 1053
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 1054
  { IMAGE_ATOMIC_SWAP_V1_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1055
  { IMAGE_ATOMIC_SWAP_V1_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1056
  { IMAGE_ATOMIC_SWAP_V1_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1057
  { IMAGE_ATOMIC_SWAP_V2_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1058
  { IMAGE_ATOMIC_SWAP_V2_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1059
  { IMAGE_ATOMIC_SWAP_V2_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1060
  { IMAGE_ATOMIC_SWAP_V3_V2_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 1061
  { IMAGE_ATOMIC_SWAP_V3_V3_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 1062
  { IMAGE_ATOMIC_SWAP_V3_V4_nsa_gfx11, IMAGE_ATOMIC_SWAP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 1063
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1064
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1065
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1066
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1067
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1068
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1069
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1070
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1071
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 1072
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 1073
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 1074
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx12, IMAGE_ATOMIC_SWAP, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 1075
  { IMAGE_ATOMIC_SWAP_V1_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1076
  { IMAGE_ATOMIC_SWAP_V1_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1077
  { IMAGE_ATOMIC_SWAP_V1_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1078
  { IMAGE_ATOMIC_SWAP_V1_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1079
  { IMAGE_ATOMIC_SWAP_V2_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1080
  { IMAGE_ATOMIC_SWAP_V2_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1081
  { IMAGE_ATOMIC_SWAP_V2_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1082
  { IMAGE_ATOMIC_SWAP_V2_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1083
  { IMAGE_ATOMIC_SWAP_V3_V1_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 1084
  { IMAGE_ATOMIC_SWAP_V3_V2_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 1085
  { IMAGE_ATOMIC_SWAP_V3_V3_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 1086
  { IMAGE_ATOMIC_SWAP_V3_V4_si, IMAGE_ATOMIC_SWAP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 1087
  { IMAGE_ATOMIC_SWAP_V1_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1088
  { IMAGE_ATOMIC_SWAP_V1_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1089
  { IMAGE_ATOMIC_SWAP_V1_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1090
  { IMAGE_ATOMIC_SWAP_V1_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1091
  { IMAGE_ATOMIC_SWAP_V2_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1092
  { IMAGE_ATOMIC_SWAP_V2_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1093
  { IMAGE_ATOMIC_SWAP_V2_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1094
  { IMAGE_ATOMIC_SWAP_V2_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1095
  { IMAGE_ATOMIC_SWAP_V3_V1_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 1096
  { IMAGE_ATOMIC_SWAP_V3_V2_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 1097
  { IMAGE_ATOMIC_SWAP_V3_V3_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 1098
  { IMAGE_ATOMIC_SWAP_V3_V4_vi, IMAGE_ATOMIC_SWAP, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 1099
  { IMAGE_ATOMIC_SWAP_V1_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1100
  { IMAGE_ATOMIC_SWAP_V1_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1101
  { IMAGE_ATOMIC_SWAP_V1_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1102
  { IMAGE_ATOMIC_SWAP_V1_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1103
  { IMAGE_ATOMIC_SWAP_V2_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1104
  { IMAGE_ATOMIC_SWAP_V2_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1105
  { IMAGE_ATOMIC_SWAP_V2_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1106
  { IMAGE_ATOMIC_SWAP_V2_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1107
  { IMAGE_ATOMIC_SWAP_V3_V1_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 1108
  { IMAGE_ATOMIC_SWAP_V3_V2_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 1109
  { IMAGE_ATOMIC_SWAP_V3_V3_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 1110
  { IMAGE_ATOMIC_SWAP_V3_V4_gfx90a, IMAGE_ATOMIC_SWAP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 1111
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1112
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1113
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1114
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1115
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1116
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1117
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1118
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1119
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 1120
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 1121
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 1122
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 1123
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1124
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1125
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1126
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1127
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1128
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1129
  { IMAGE_ATOMIC_UMAX_V3_V2_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 1130
  { IMAGE_ATOMIC_UMAX_V3_V3_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 1131
  { IMAGE_ATOMIC_UMAX_V3_V4_nsa_gfx10, IMAGE_ATOMIC_UMAX, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 1132
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1133
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1134
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1135
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1136
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1137
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1138
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1139
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1140
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 1141
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 1142
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 1143
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 1144
  { IMAGE_ATOMIC_UMAX_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1145
  { IMAGE_ATOMIC_UMAX_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1146
  { IMAGE_ATOMIC_UMAX_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1147
  { IMAGE_ATOMIC_UMAX_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1148
  { IMAGE_ATOMIC_UMAX_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1149
  { IMAGE_ATOMIC_UMAX_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1150
  { IMAGE_ATOMIC_UMAX_V3_V2_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 1151
  { IMAGE_ATOMIC_UMAX_V3_V3_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 1152
  { IMAGE_ATOMIC_UMAX_V3_V4_nsa_gfx11, IMAGE_ATOMIC_UMAX, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 1153
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1154
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1155
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1156
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1157
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1158
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1159
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1160
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1161
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 1162
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 1163
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 1164
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx12, IMAGE_ATOMIC_UMAX, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 1165
  { IMAGE_ATOMIC_UMAX_V1_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1166
  { IMAGE_ATOMIC_UMAX_V1_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1167
  { IMAGE_ATOMIC_UMAX_V1_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1168
  { IMAGE_ATOMIC_UMAX_V1_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1169
  { IMAGE_ATOMIC_UMAX_V2_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1170
  { IMAGE_ATOMIC_UMAX_V2_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1171
  { IMAGE_ATOMIC_UMAX_V2_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1172
  { IMAGE_ATOMIC_UMAX_V2_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1173
  { IMAGE_ATOMIC_UMAX_V3_V1_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 1174
  { IMAGE_ATOMIC_UMAX_V3_V2_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 1175
  { IMAGE_ATOMIC_UMAX_V3_V3_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 1176
  { IMAGE_ATOMIC_UMAX_V3_V4_si, IMAGE_ATOMIC_UMAX, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 1177
  { IMAGE_ATOMIC_UMAX_V1_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1178
  { IMAGE_ATOMIC_UMAX_V1_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1179
  { IMAGE_ATOMIC_UMAX_V1_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1180
  { IMAGE_ATOMIC_UMAX_V1_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1181
  { IMAGE_ATOMIC_UMAX_V2_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1182
  { IMAGE_ATOMIC_UMAX_V2_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1183
  { IMAGE_ATOMIC_UMAX_V2_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1184
  { IMAGE_ATOMIC_UMAX_V2_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1185
  { IMAGE_ATOMIC_UMAX_V3_V1_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 1186
  { IMAGE_ATOMIC_UMAX_V3_V2_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 1187
  { IMAGE_ATOMIC_UMAX_V3_V3_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 1188
  { IMAGE_ATOMIC_UMAX_V3_V4_vi, IMAGE_ATOMIC_UMAX, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 1189
  { IMAGE_ATOMIC_UMAX_V1_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1190
  { IMAGE_ATOMIC_UMAX_V1_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1191
  { IMAGE_ATOMIC_UMAX_V1_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1192
  { IMAGE_ATOMIC_UMAX_V1_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1193
  { IMAGE_ATOMIC_UMAX_V2_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1194
  { IMAGE_ATOMIC_UMAX_V2_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1195
  { IMAGE_ATOMIC_UMAX_V2_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1196
  { IMAGE_ATOMIC_UMAX_V2_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1197
  { IMAGE_ATOMIC_UMAX_V3_V1_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 1198
  { IMAGE_ATOMIC_UMAX_V3_V2_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 1199
  { IMAGE_ATOMIC_UMAX_V3_V3_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 1200
  { IMAGE_ATOMIC_UMAX_V3_V4_gfx90a, IMAGE_ATOMIC_UMAX, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 1201
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1202
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1203
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1204
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1205
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1206
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1207
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1208
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1209
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 1210
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 1211
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 1212
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 1213
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1214
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1215
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1216
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1217
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1218
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1219
  { IMAGE_ATOMIC_UMIN_V3_V2_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 1220
  { IMAGE_ATOMIC_UMIN_V3_V3_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 1221
  { IMAGE_ATOMIC_UMIN_V3_V4_nsa_gfx10, IMAGE_ATOMIC_UMIN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 1222
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1223
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1224
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1225
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1226
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1227
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1228
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1229
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1230
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 1231
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 1232
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 1233
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 1234
  { IMAGE_ATOMIC_UMIN_V1_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1235
  { IMAGE_ATOMIC_UMIN_V1_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1236
  { IMAGE_ATOMIC_UMIN_V1_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1237
  { IMAGE_ATOMIC_UMIN_V2_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1238
  { IMAGE_ATOMIC_UMIN_V2_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1239
  { IMAGE_ATOMIC_UMIN_V2_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1240
  { IMAGE_ATOMIC_UMIN_V3_V2_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 1241
  { IMAGE_ATOMIC_UMIN_V3_V3_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 1242
  { IMAGE_ATOMIC_UMIN_V3_V4_nsa_gfx11, IMAGE_ATOMIC_UMIN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 1243
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1244
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1245
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1246
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1247
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1248
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1249
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1250
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1251
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 1252
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 1253
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 1254
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx12, IMAGE_ATOMIC_UMIN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 1255
  { IMAGE_ATOMIC_UMIN_V1_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1256
  { IMAGE_ATOMIC_UMIN_V1_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1257
  { IMAGE_ATOMIC_UMIN_V1_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1258
  { IMAGE_ATOMIC_UMIN_V1_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1259
  { IMAGE_ATOMIC_UMIN_V2_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1260
  { IMAGE_ATOMIC_UMIN_V2_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1261
  { IMAGE_ATOMIC_UMIN_V2_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1262
  { IMAGE_ATOMIC_UMIN_V2_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1263
  { IMAGE_ATOMIC_UMIN_V3_V1_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 1264
  { IMAGE_ATOMIC_UMIN_V3_V2_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 1265
  { IMAGE_ATOMIC_UMIN_V3_V3_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 1266
  { IMAGE_ATOMIC_UMIN_V3_V4_si, IMAGE_ATOMIC_UMIN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 1267
  { IMAGE_ATOMIC_UMIN_V1_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1268
  { IMAGE_ATOMIC_UMIN_V1_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1269
  { IMAGE_ATOMIC_UMIN_V1_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1270
  { IMAGE_ATOMIC_UMIN_V1_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1271
  { IMAGE_ATOMIC_UMIN_V2_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1272
  { IMAGE_ATOMIC_UMIN_V2_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1273
  { IMAGE_ATOMIC_UMIN_V2_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1274
  { IMAGE_ATOMIC_UMIN_V2_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1275
  { IMAGE_ATOMIC_UMIN_V3_V1_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 1276
  { IMAGE_ATOMIC_UMIN_V3_V2_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 1277
  { IMAGE_ATOMIC_UMIN_V3_V3_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 1278
  { IMAGE_ATOMIC_UMIN_V3_V4_vi, IMAGE_ATOMIC_UMIN, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 1279
  { IMAGE_ATOMIC_UMIN_V1_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1280
  { IMAGE_ATOMIC_UMIN_V1_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1281
  { IMAGE_ATOMIC_UMIN_V1_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1282
  { IMAGE_ATOMIC_UMIN_V1_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1283
  { IMAGE_ATOMIC_UMIN_V2_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1284
  { IMAGE_ATOMIC_UMIN_V2_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1285
  { IMAGE_ATOMIC_UMIN_V2_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1286
  { IMAGE_ATOMIC_UMIN_V2_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1287
  { IMAGE_ATOMIC_UMIN_V3_V1_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 1288
  { IMAGE_ATOMIC_UMIN_V3_V2_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 1289
  { IMAGE_ATOMIC_UMIN_V3_V3_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 1290
  { IMAGE_ATOMIC_UMIN_V3_V4_gfx90a, IMAGE_ATOMIC_UMIN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 1291
  { IMAGE_ATOMIC_XOR_V1_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 1292
  { IMAGE_ATOMIC_XOR_V1_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 1293
  { IMAGE_ATOMIC_XOR_V1_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 1294
  { IMAGE_ATOMIC_XOR_V1_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 1295
  { IMAGE_ATOMIC_XOR_V2_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1296
  { IMAGE_ATOMIC_XOR_V2_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1297
  { IMAGE_ATOMIC_XOR_V2_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1298
  { IMAGE_ATOMIC_XOR_V2_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1299
  { IMAGE_ATOMIC_XOR_V3_V1_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 1300
  { IMAGE_ATOMIC_XOR_V3_V2_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 1301
  { IMAGE_ATOMIC_XOR_V3_V3_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 1302
  { IMAGE_ATOMIC_XOR_V3_V4_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 1303
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 1304
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 1305
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 1306
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1307
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1308
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1309
  { IMAGE_ATOMIC_XOR_V3_V2_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 1310
  { IMAGE_ATOMIC_XOR_V3_V3_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 1311
  { IMAGE_ATOMIC_XOR_V3_V4_nsa_gfx10, IMAGE_ATOMIC_XOR, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 1312
  { IMAGE_ATOMIC_XOR_V1_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 1313
  { IMAGE_ATOMIC_XOR_V1_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 1314
  { IMAGE_ATOMIC_XOR_V1_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 1315
  { IMAGE_ATOMIC_XOR_V1_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 1316
  { IMAGE_ATOMIC_XOR_V2_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1317
  { IMAGE_ATOMIC_XOR_V2_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1318
  { IMAGE_ATOMIC_XOR_V2_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1319
  { IMAGE_ATOMIC_XOR_V2_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1320
  { IMAGE_ATOMIC_XOR_V3_V1_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 1321
  { IMAGE_ATOMIC_XOR_V3_V2_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 1322
  { IMAGE_ATOMIC_XOR_V3_V3_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 1323
  { IMAGE_ATOMIC_XOR_V3_V4_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 1324
  { IMAGE_ATOMIC_XOR_V1_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 1325
  { IMAGE_ATOMIC_XOR_V1_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 1326
  { IMAGE_ATOMIC_XOR_V1_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 1327
  { IMAGE_ATOMIC_XOR_V2_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1328
  { IMAGE_ATOMIC_XOR_V2_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1329
  { IMAGE_ATOMIC_XOR_V2_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1330
  { IMAGE_ATOMIC_XOR_V3_V2_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 1331
  { IMAGE_ATOMIC_XOR_V3_V3_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 1332
  { IMAGE_ATOMIC_XOR_V3_V4_nsa_gfx11, IMAGE_ATOMIC_XOR, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 1333
  { IMAGE_ATOMIC_XOR_V1_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 1334
  { IMAGE_ATOMIC_XOR_V1_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 1335
  { IMAGE_ATOMIC_XOR_V1_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 1336
  { IMAGE_ATOMIC_XOR_V1_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 1337
  { IMAGE_ATOMIC_XOR_V2_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1338
  { IMAGE_ATOMIC_XOR_V2_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1339
  { IMAGE_ATOMIC_XOR_V2_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1340
  { IMAGE_ATOMIC_XOR_V2_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1341
  { IMAGE_ATOMIC_XOR_V3_V1_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 1342
  { IMAGE_ATOMIC_XOR_V3_V2_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 1343
  { IMAGE_ATOMIC_XOR_V3_V3_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 1344
  { IMAGE_ATOMIC_XOR_V3_V4_gfx12, IMAGE_ATOMIC_XOR, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 1345
  { IMAGE_ATOMIC_XOR_V1_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 1346
  { IMAGE_ATOMIC_XOR_V1_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 1347
  { IMAGE_ATOMIC_XOR_V1_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 1348
  { IMAGE_ATOMIC_XOR_V1_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 1349
  { IMAGE_ATOMIC_XOR_V2_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1350
  { IMAGE_ATOMIC_XOR_V2_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1351
  { IMAGE_ATOMIC_XOR_V2_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1352
  { IMAGE_ATOMIC_XOR_V2_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1353
  { IMAGE_ATOMIC_XOR_V3_V1_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 1354
  { IMAGE_ATOMIC_XOR_V3_V2_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 1355
  { IMAGE_ATOMIC_XOR_V3_V3_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 1356
  { IMAGE_ATOMIC_XOR_V3_V4_si, IMAGE_ATOMIC_XOR, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 1357
  { IMAGE_ATOMIC_XOR_V1_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x1, 0x1 }, // 1358
  { IMAGE_ATOMIC_XOR_V1_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x2, 0x1 }, // 1359
  { IMAGE_ATOMIC_XOR_V1_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x3, 0x1 }, // 1360
  { IMAGE_ATOMIC_XOR_V1_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x1, 0x4, 0x1 }, // 1361
  { IMAGE_ATOMIC_XOR_V2_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x1, 0x1 }, // 1362
  { IMAGE_ATOMIC_XOR_V2_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x2, 0x1 }, // 1363
  { IMAGE_ATOMIC_XOR_V2_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x3, 0x1 }, // 1364
  { IMAGE_ATOMIC_XOR_V2_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x2, 0x4, 0x1 }, // 1365
  { IMAGE_ATOMIC_XOR_V3_V1_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x3, 0x1, 0x1 }, // 1366
  { IMAGE_ATOMIC_XOR_V3_V2_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x3, 0x2, 0x1 }, // 1367
  { IMAGE_ATOMIC_XOR_V3_V3_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x3, 0x3, 0x1 }, // 1368
  { IMAGE_ATOMIC_XOR_V3_V4_vi, IMAGE_ATOMIC_XOR, MIMGEncGfx8, 0x3, 0x4, 0x1 }, // 1369
  { IMAGE_ATOMIC_XOR_V1_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 1370
  { IMAGE_ATOMIC_XOR_V1_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 1371
  { IMAGE_ATOMIC_XOR_V1_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 1372
  { IMAGE_ATOMIC_XOR_V1_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 1373
  { IMAGE_ATOMIC_XOR_V2_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 1374
  { IMAGE_ATOMIC_XOR_V2_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 1375
  { IMAGE_ATOMIC_XOR_V2_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 1376
  { IMAGE_ATOMIC_XOR_V2_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 1377
  { IMAGE_ATOMIC_XOR_V3_V1_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 1378
  { IMAGE_ATOMIC_XOR_V3_V2_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 1379
  { IMAGE_ATOMIC_XOR_V3_V3_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 1380
  { IMAGE_ATOMIC_XOR_V3_V4_gfx90a, IMAGE_ATOMIC_XOR, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 1381
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xC, 0x1 }, // 1382
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xC, 0xC }, // 1383
  { IMAGE_BVH64_INTERSECT_RAY_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xC, 0x1 }, // 1384
  { IMAGE_BVH64_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xC, 0x5 }, // 1385
  { IMAGE_BVH64_INTERSECT_RAY_gfx12, IMAGE_BVH64_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xC, 0x5 }, // 1386
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 1387
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 1388
  { IMAGE_BVH64_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x9, 0x1 }, // 1389
  { IMAGE_BVH64_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x9, 0x4 }, // 1390
  { IMAGE_BVH64_INTERSECT_RAY_a16_gfx12, IMAGE_BVH64_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x9, 0x4 }, // 1391
  { IMAGE_BVH8_INTERSECT_RAY_gfx12, IMAGE_BVH8_INTERSECT_RAY, MIMGEncGfx12, 0xA, 0xB, 0x5 }, // 1392
  { IMAGE_BVH_DUAL_INTERSECT_RAY_gfx12, IMAGE_BVH_DUAL_INTERSECT_RAY, MIMGEncGfx12, 0xA, 0xC, 0x5 }, // 1393
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 1394
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 1395
  { IMAGE_BVH_INTERSECT_RAY_sa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11Default, 0x4, 0xB, 0x1 }, // 1396
  { IMAGE_BVH_INTERSECT_RAY_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx11NSA, 0x4, 0xB, 0x5 }, // 1397
  { IMAGE_BVH_INTERSECT_RAY_gfx12, IMAGE_BVH_INTERSECT_RAY, MIMGEncGfx12, 0x4, 0xB, 0x5 }, // 1398
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1399
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx10, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 1400
  { IMAGE_BVH_INTERSECT_RAY_a16_sa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1401
  { IMAGE_BVH_INTERSECT_RAY_a16_nsa_gfx11, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx11NSA, 0x4, 0x8, 0x4 }, // 1402
  { IMAGE_BVH_INTERSECT_RAY_a16_gfx12, IMAGE_BVH_INTERSECT_RAY_a16, MIMGEncGfx12, 0x4, 0x8, 0x4 }, // 1403
  { IMAGE_GATHER4_V2_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1404
  { IMAGE_GATHER4_V2_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1405
  { IMAGE_GATHER4_V2_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1406
  { IMAGE_GATHER4_V2_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1407
  { IMAGE_GATHER4_V4_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1408
  { IMAGE_GATHER4_V4_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1409
  { IMAGE_GATHER4_V4_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1410
  { IMAGE_GATHER4_V4_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1411
  { IMAGE_GATHER4_V5_V1_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1412
  { IMAGE_GATHER4_V5_V2_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1413
  { IMAGE_GATHER4_V5_V3_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1414
  { IMAGE_GATHER4_V5_V4_gfx10, IMAGE_GATHER4, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1415
  { IMAGE_GATHER4_V2_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1416
  { IMAGE_GATHER4_V2_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1417
  { IMAGE_GATHER4_V4_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1418
  { IMAGE_GATHER4_V4_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1419
  { IMAGE_GATHER4_V5_V2_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1420
  { IMAGE_GATHER4_V5_V3_nsa_gfx10, IMAGE_GATHER4, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1421
  { IMAGE_GATHER4_V2_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1422
  { IMAGE_GATHER4_V2_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1423
  { IMAGE_GATHER4_V2_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1424
  { IMAGE_GATHER4_V2_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1425
  { IMAGE_GATHER4_V4_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1426
  { IMAGE_GATHER4_V4_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1427
  { IMAGE_GATHER4_V4_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1428
  { IMAGE_GATHER4_V4_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1429
  { IMAGE_GATHER4_V5_V1_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1430
  { IMAGE_GATHER4_V5_V2_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1431
  { IMAGE_GATHER4_V5_V3_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1432
  { IMAGE_GATHER4_V5_V4_gfx11, IMAGE_GATHER4, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1433
  { IMAGE_GATHER4_V2_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1434
  { IMAGE_GATHER4_V2_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1435
  { IMAGE_GATHER4_V4_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1436
  { IMAGE_GATHER4_V4_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1437
  { IMAGE_GATHER4_V5_V2_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1438
  { IMAGE_GATHER4_V5_V3_nsa_gfx11, IMAGE_GATHER4, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1439
  { IMAGE_GATHER4_V2_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1440
  { IMAGE_GATHER4_V2_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1441
  { IMAGE_GATHER4_V2_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1442
  { IMAGE_GATHER4_V4_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1443
  { IMAGE_GATHER4_V4_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1444
  { IMAGE_GATHER4_V4_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1445
  { IMAGE_GATHER4_V5_V1_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1446
  { IMAGE_GATHER4_V5_V2_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1447
  { IMAGE_GATHER4_V5_V3_gfx12, IMAGE_GATHER4, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1448
  { IMAGE_GATHER4_V2_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1449
  { IMAGE_GATHER4_V2_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1450
  { IMAGE_GATHER4_V2_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1451
  { IMAGE_GATHER4_V2_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1452
  { IMAGE_GATHER4_V4_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1453
  { IMAGE_GATHER4_V4_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1454
  { IMAGE_GATHER4_V4_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1455
  { IMAGE_GATHER4_V4_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1456
  { IMAGE_GATHER4_V5_V1, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1457
  { IMAGE_GATHER4_V5_V2, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1458
  { IMAGE_GATHER4_V5_V3, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1459
  { IMAGE_GATHER4_V5_V4, IMAGE_GATHER4, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1460
  { IMAGE_GATHER4H_V2_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1461
  { IMAGE_GATHER4H_V2_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1462
  { IMAGE_GATHER4H_V2_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1463
  { IMAGE_GATHER4H_V2_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1464
  { IMAGE_GATHER4H_V4_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1465
  { IMAGE_GATHER4H_V4_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1466
  { IMAGE_GATHER4H_V4_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1467
  { IMAGE_GATHER4H_V4_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1468
  { IMAGE_GATHER4H_V5_V1_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1469
  { IMAGE_GATHER4H_V5_V2_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1470
  { IMAGE_GATHER4H_V5_V3_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1471
  { IMAGE_GATHER4H_V5_V4_gfx10, IMAGE_GATHER4H, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1472
  { IMAGE_GATHER4H_V2_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1473
  { IMAGE_GATHER4H_V2_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1474
  { IMAGE_GATHER4H_V4_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1475
  { IMAGE_GATHER4H_V4_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1476
  { IMAGE_GATHER4H_V5_V2_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1477
  { IMAGE_GATHER4H_V5_V3_nsa_gfx10, IMAGE_GATHER4H, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1478
  { IMAGE_GATHER4H_V2_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1479
  { IMAGE_GATHER4H_V2_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1480
  { IMAGE_GATHER4H_V2_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1481
  { IMAGE_GATHER4H_V2_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1482
  { IMAGE_GATHER4H_V4_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1483
  { IMAGE_GATHER4H_V4_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1484
  { IMAGE_GATHER4H_V4_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1485
  { IMAGE_GATHER4H_V4_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1486
  { IMAGE_GATHER4H_V5_V1_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1487
  { IMAGE_GATHER4H_V5_V2_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1488
  { IMAGE_GATHER4H_V5_V3_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1489
  { IMAGE_GATHER4H_V5_V4_gfx11, IMAGE_GATHER4H, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1490
  { IMAGE_GATHER4H_V2_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1491
  { IMAGE_GATHER4H_V2_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1492
  { IMAGE_GATHER4H_V4_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1493
  { IMAGE_GATHER4H_V4_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1494
  { IMAGE_GATHER4H_V5_V2_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1495
  { IMAGE_GATHER4H_V5_V3_nsa_gfx11, IMAGE_GATHER4H, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1496
  { IMAGE_GATHER4H_V2_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1497
  { IMAGE_GATHER4H_V2_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1498
  { IMAGE_GATHER4H_V2_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1499
  { IMAGE_GATHER4H_V4_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1500
  { IMAGE_GATHER4H_V4_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1501
  { IMAGE_GATHER4H_V4_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1502
  { IMAGE_GATHER4H_V5_V1_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1503
  { IMAGE_GATHER4H_V5_V2_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1504
  { IMAGE_GATHER4H_V5_V3_gfx12, IMAGE_GATHER4H, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1505
  { IMAGE_GATHER4H_V2_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1506
  { IMAGE_GATHER4H_V2_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1507
  { IMAGE_GATHER4H_V2_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1508
  { IMAGE_GATHER4H_V2_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1509
  { IMAGE_GATHER4H_V4_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1510
  { IMAGE_GATHER4H_V4_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1511
  { IMAGE_GATHER4H_V4_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1512
  { IMAGE_GATHER4H_V4_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1513
  { IMAGE_GATHER4H_V5_V1, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1514
  { IMAGE_GATHER4H_V5_V2, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1515
  { IMAGE_GATHER4H_V5_V3, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1516
  { IMAGE_GATHER4H_V5_V4, IMAGE_GATHER4H, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1517
  { IMAGE_GATHER4_B_V2_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1518
  { IMAGE_GATHER4_B_V2_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1519
  { IMAGE_GATHER4_B_V2_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1520
  { IMAGE_GATHER4_B_V4_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1521
  { IMAGE_GATHER4_B_V4_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1522
  { IMAGE_GATHER4_B_V4_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1523
  { IMAGE_GATHER4_B_V5_V2_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1524
  { IMAGE_GATHER4_B_V5_V3_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1525
  { IMAGE_GATHER4_B_V5_V4_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1526
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1527
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1528
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1529
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1530
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1531
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1532
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1533
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1534
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1535
  { IMAGE_GATHER4_B_V2_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1536
  { IMAGE_GATHER4_B_V2_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1537
  { IMAGE_GATHER4_B_V2_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1538
  { IMAGE_GATHER4_B_V4_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1539
  { IMAGE_GATHER4_B_V4_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1540
  { IMAGE_GATHER4_B_V4_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1541
  { IMAGE_GATHER4_B_V5_V2_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1542
  { IMAGE_GATHER4_B_V5_V3_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1543
  { IMAGE_GATHER4_B_V5_V4_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1544
  { IMAGE_GATHER4_B_V2_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1545
  { IMAGE_GATHER4_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1546
  { IMAGE_GATHER4_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1547
  { IMAGE_GATHER4_B_V4_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1548
  { IMAGE_GATHER4_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1549
  { IMAGE_GATHER4_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1550
  { IMAGE_GATHER4_B_V5_V2_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1551
  { IMAGE_GATHER4_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1552
  { IMAGE_GATHER4_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1553
  { IMAGE_GATHER4_B_V2_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1554
  { IMAGE_GATHER4_B_V2_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1555
  { IMAGE_GATHER4_B_V2_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1556
  { IMAGE_GATHER4_B_V4_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1557
  { IMAGE_GATHER4_B_V4_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1558
  { IMAGE_GATHER4_B_V4_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1559
  { IMAGE_GATHER4_B_V5_V2_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1560
  { IMAGE_GATHER4_B_V5_V3_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1561
  { IMAGE_GATHER4_B_V5_V4_gfx12, IMAGE_GATHER4_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1562
  { IMAGE_GATHER4_B_V2_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1563
  { IMAGE_GATHER4_B_V2_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1564
  { IMAGE_GATHER4_B_V2_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1565
  { IMAGE_GATHER4_B_V4_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1566
  { IMAGE_GATHER4_B_V4_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1567
  { IMAGE_GATHER4_B_V4_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1568
  { IMAGE_GATHER4_B_V5_V2, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1569
  { IMAGE_GATHER4_B_V5_V3, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1570
  { IMAGE_GATHER4_B_V5_V4, IMAGE_GATHER4_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1571
  { IMAGE_GATHER4_B_CL_V2_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1572
  { IMAGE_GATHER4_B_CL_V2_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1573
  { IMAGE_GATHER4_B_CL_V2_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1574
  { IMAGE_GATHER4_B_CL_V2_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1575
  { IMAGE_GATHER4_B_CL_V2_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1576
  { IMAGE_GATHER4_B_CL_V4_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1577
  { IMAGE_GATHER4_B_CL_V4_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1578
  { IMAGE_GATHER4_B_CL_V4_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1579
  { IMAGE_GATHER4_B_CL_V4_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1580
  { IMAGE_GATHER4_B_CL_V4_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1581
  { IMAGE_GATHER4_B_CL_V5_V2_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1582
  { IMAGE_GATHER4_B_CL_V5_V3_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1583
  { IMAGE_GATHER4_B_CL_V5_V4_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1584
  { IMAGE_GATHER4_B_CL_V5_V5_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1585
  { IMAGE_GATHER4_B_CL_V5_V8_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1586
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1587
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1588
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1589
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1590
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1591
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1592
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1593
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1594
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1595
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1596
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1597
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1598
  { IMAGE_GATHER4_B_CL_V2_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1599
  { IMAGE_GATHER4_B_CL_V2_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1600
  { IMAGE_GATHER4_B_CL_V2_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1601
  { IMAGE_GATHER4_B_CL_V2_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1602
  { IMAGE_GATHER4_B_CL_V2_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1603
  { IMAGE_GATHER4_B_CL_V4_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1604
  { IMAGE_GATHER4_B_CL_V4_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1605
  { IMAGE_GATHER4_B_CL_V4_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1606
  { IMAGE_GATHER4_B_CL_V4_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1607
  { IMAGE_GATHER4_B_CL_V4_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1608
  { IMAGE_GATHER4_B_CL_V5_V2_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1609
  { IMAGE_GATHER4_B_CL_V5_V3_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1610
  { IMAGE_GATHER4_B_CL_V5_V4_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1611
  { IMAGE_GATHER4_B_CL_V5_V5_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1612
  { IMAGE_GATHER4_B_CL_V5_V8_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1613
  { IMAGE_GATHER4_B_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1614
  { IMAGE_GATHER4_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1615
  { IMAGE_GATHER4_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1616
  { IMAGE_GATHER4_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1617
  { IMAGE_GATHER4_B_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1618
  { IMAGE_GATHER4_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1619
  { IMAGE_GATHER4_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1620
  { IMAGE_GATHER4_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1621
  { IMAGE_GATHER4_B_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1622
  { IMAGE_GATHER4_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1623
  { IMAGE_GATHER4_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1624
  { IMAGE_GATHER4_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1625
  { IMAGE_GATHER4_B_CL_V2_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1626
  { IMAGE_GATHER4_B_CL_V2_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1627
  { IMAGE_GATHER4_B_CL_V2_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1628
  { IMAGE_GATHER4_B_CL_V2_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1629
  { IMAGE_GATHER4_B_CL_V4_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1630
  { IMAGE_GATHER4_B_CL_V4_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1631
  { IMAGE_GATHER4_B_CL_V4_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1632
  { IMAGE_GATHER4_B_CL_V4_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1633
  { IMAGE_GATHER4_B_CL_V5_V2_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1634
  { IMAGE_GATHER4_B_CL_V5_V3_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1635
  { IMAGE_GATHER4_B_CL_V5_V4_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1636
  { IMAGE_GATHER4_B_CL_V5_V5_gfx12, IMAGE_GATHER4_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1637
  { IMAGE_GATHER4_B_CL_V2_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1638
  { IMAGE_GATHER4_B_CL_V2_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1639
  { IMAGE_GATHER4_B_CL_V2_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1640
  { IMAGE_GATHER4_B_CL_V2_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1641
  { IMAGE_GATHER4_B_CL_V2_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1642
  { IMAGE_GATHER4_B_CL_V4_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1643
  { IMAGE_GATHER4_B_CL_V4_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1644
  { IMAGE_GATHER4_B_CL_V4_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1645
  { IMAGE_GATHER4_B_CL_V4_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1646
  { IMAGE_GATHER4_B_CL_V4_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1647
  { IMAGE_GATHER4_B_CL_V5_V2, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1648
  { IMAGE_GATHER4_B_CL_V5_V3, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1649
  { IMAGE_GATHER4_B_CL_V5_V4, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1650
  { IMAGE_GATHER4_B_CL_V5_V5, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1651
  { IMAGE_GATHER4_B_CL_V5_V8, IMAGE_GATHER4_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1652
  { IMAGE_GATHER4_B_CL_O_V2_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1653
  { IMAGE_GATHER4_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1654
  { IMAGE_GATHER4_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1655
  { IMAGE_GATHER4_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1656
  { IMAGE_GATHER4_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1657
  { IMAGE_GATHER4_B_CL_O_V4_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1658
  { IMAGE_GATHER4_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1659
  { IMAGE_GATHER4_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1660
  { IMAGE_GATHER4_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1661
  { IMAGE_GATHER4_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1662
  { IMAGE_GATHER4_B_CL_O_V5_V3_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1663
  { IMAGE_GATHER4_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1664
  { IMAGE_GATHER4_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1665
  { IMAGE_GATHER4_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1666
  { IMAGE_GATHER4_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1667
  { IMAGE_GATHER4_B_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1668
  { IMAGE_GATHER4_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1669
  { IMAGE_GATHER4_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1670
  { IMAGE_GATHER4_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1671
  { IMAGE_GATHER4_B_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1672
  { IMAGE_GATHER4_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1673
  { IMAGE_GATHER4_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1674
  { IMAGE_GATHER4_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1675
  { IMAGE_GATHER4_B_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1676
  { IMAGE_GATHER4_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1677
  { IMAGE_GATHER4_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1678
  { IMAGE_GATHER4_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1679
  { IMAGE_GATHER4_B_CL_O_V2_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1680
  { IMAGE_GATHER4_B_CL_O_V2_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1681
  { IMAGE_GATHER4_B_CL_O_V2_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1682
  { IMAGE_GATHER4_B_CL_O_V2_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 1683
  { IMAGE_GATHER4_B_CL_O_V2_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1684
  { IMAGE_GATHER4_B_CL_O_V4_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1685
  { IMAGE_GATHER4_B_CL_O_V4_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1686
  { IMAGE_GATHER4_B_CL_O_V4_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1687
  { IMAGE_GATHER4_B_CL_O_V4_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 1688
  { IMAGE_GATHER4_B_CL_O_V4_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1689
  { IMAGE_GATHER4_B_CL_O_V5_V3, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1690
  { IMAGE_GATHER4_B_CL_O_V5_V4, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1691
  { IMAGE_GATHER4_B_CL_O_V5_V5, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1692
  { IMAGE_GATHER4_B_CL_O_V5_V6, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 1693
  { IMAGE_GATHER4_B_CL_O_V5_V8, IMAGE_GATHER4_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1694
  { IMAGE_GATHER4_B_O_V2_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1695
  { IMAGE_GATHER4_B_O_V2_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1696
  { IMAGE_GATHER4_B_O_V2_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1697
  { IMAGE_GATHER4_B_O_V2_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1698
  { IMAGE_GATHER4_B_O_V4_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1699
  { IMAGE_GATHER4_B_O_V4_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1700
  { IMAGE_GATHER4_B_O_V4_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1701
  { IMAGE_GATHER4_B_O_V4_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1702
  { IMAGE_GATHER4_B_O_V5_V3_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1703
  { IMAGE_GATHER4_B_O_V5_V4_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1704
  { IMAGE_GATHER4_B_O_V5_V5_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1705
  { IMAGE_GATHER4_B_O_V5_V8_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1706
  { IMAGE_GATHER4_B_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1707
  { IMAGE_GATHER4_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1708
  { IMAGE_GATHER4_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1709
  { IMAGE_GATHER4_B_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1710
  { IMAGE_GATHER4_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1711
  { IMAGE_GATHER4_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1712
  { IMAGE_GATHER4_B_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1713
  { IMAGE_GATHER4_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1714
  { IMAGE_GATHER4_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1715
  { IMAGE_GATHER4_B_O_V2_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1716
  { IMAGE_GATHER4_B_O_V2_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1717
  { IMAGE_GATHER4_B_O_V2_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1718
  { IMAGE_GATHER4_B_O_V2_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1719
  { IMAGE_GATHER4_B_O_V4_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1720
  { IMAGE_GATHER4_B_O_V4_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1721
  { IMAGE_GATHER4_B_O_V4_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1722
  { IMAGE_GATHER4_B_O_V4_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1723
  { IMAGE_GATHER4_B_O_V5_V3, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1724
  { IMAGE_GATHER4_B_O_V5_V4, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1725
  { IMAGE_GATHER4_B_O_V5_V5, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1726
  { IMAGE_GATHER4_B_O_V5_V8, IMAGE_GATHER4_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1727
  { IMAGE_GATHER4_C_V2_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1728
  { IMAGE_GATHER4_C_V2_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1729
  { IMAGE_GATHER4_C_V2_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1730
  { IMAGE_GATHER4_C_V4_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1731
  { IMAGE_GATHER4_C_V4_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1732
  { IMAGE_GATHER4_C_V4_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1733
  { IMAGE_GATHER4_C_V5_V2_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1734
  { IMAGE_GATHER4_C_V5_V3_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1735
  { IMAGE_GATHER4_C_V5_V4_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1736
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1737
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1738
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1739
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1740
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1741
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1742
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1743
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1744
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx10, IMAGE_GATHER4_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1745
  { IMAGE_GATHER4_C_V2_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1746
  { IMAGE_GATHER4_C_V2_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1747
  { IMAGE_GATHER4_C_V2_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1748
  { IMAGE_GATHER4_C_V4_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1749
  { IMAGE_GATHER4_C_V4_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1750
  { IMAGE_GATHER4_C_V4_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1751
  { IMAGE_GATHER4_C_V5_V2_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1752
  { IMAGE_GATHER4_C_V5_V3_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1753
  { IMAGE_GATHER4_C_V5_V4_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1754
  { IMAGE_GATHER4_C_V2_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1755
  { IMAGE_GATHER4_C_V2_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1756
  { IMAGE_GATHER4_C_V2_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1757
  { IMAGE_GATHER4_C_V4_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1758
  { IMAGE_GATHER4_C_V4_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1759
  { IMAGE_GATHER4_C_V4_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1760
  { IMAGE_GATHER4_C_V5_V2_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1761
  { IMAGE_GATHER4_C_V5_V3_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1762
  { IMAGE_GATHER4_C_V5_V4_nsa_gfx11, IMAGE_GATHER4_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1763
  { IMAGE_GATHER4_C_V2_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1764
  { IMAGE_GATHER4_C_V2_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1765
  { IMAGE_GATHER4_C_V2_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1766
  { IMAGE_GATHER4_C_V4_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1767
  { IMAGE_GATHER4_C_V4_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1768
  { IMAGE_GATHER4_C_V4_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1769
  { IMAGE_GATHER4_C_V5_V2_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1770
  { IMAGE_GATHER4_C_V5_V3_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1771
  { IMAGE_GATHER4_C_V5_V4_gfx12, IMAGE_GATHER4_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1772
  { IMAGE_GATHER4_C_V2_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1773
  { IMAGE_GATHER4_C_V2_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1774
  { IMAGE_GATHER4_C_V2_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1775
  { IMAGE_GATHER4_C_V4_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1776
  { IMAGE_GATHER4_C_V4_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1777
  { IMAGE_GATHER4_C_V4_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1778
  { IMAGE_GATHER4_C_V5_V2, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1779
  { IMAGE_GATHER4_C_V5_V3, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1780
  { IMAGE_GATHER4_C_V5_V4, IMAGE_GATHER4_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1781
  { IMAGE_GATHER4_CL_V2_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 1782
  { IMAGE_GATHER4_CL_V2_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1783
  { IMAGE_GATHER4_CL_V2_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1784
  { IMAGE_GATHER4_CL_V2_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1785
  { IMAGE_GATHER4_CL_V4_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 1786
  { IMAGE_GATHER4_CL_V4_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1787
  { IMAGE_GATHER4_CL_V4_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1788
  { IMAGE_GATHER4_CL_V4_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1789
  { IMAGE_GATHER4_CL_V5_V1_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 1790
  { IMAGE_GATHER4_CL_V5_V2_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1791
  { IMAGE_GATHER4_CL_V5_V3_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1792
  { IMAGE_GATHER4_CL_V5_V4_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1793
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1794
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1795
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1796
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1797
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1798
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1799
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1800
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1801
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1802
  { IMAGE_GATHER4_CL_V2_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 1803
  { IMAGE_GATHER4_CL_V2_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 1804
  { IMAGE_GATHER4_CL_V2_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1805
  { IMAGE_GATHER4_CL_V2_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1806
  { IMAGE_GATHER4_CL_V4_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 1807
  { IMAGE_GATHER4_CL_V4_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 1808
  { IMAGE_GATHER4_CL_V4_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1809
  { IMAGE_GATHER4_CL_V4_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1810
  { IMAGE_GATHER4_CL_V5_V1_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 1811
  { IMAGE_GATHER4_CL_V5_V2_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 1812
  { IMAGE_GATHER4_CL_V5_V3_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1813
  { IMAGE_GATHER4_CL_V5_V4_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1814
  { IMAGE_GATHER4_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 1815
  { IMAGE_GATHER4_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1816
  { IMAGE_GATHER4_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1817
  { IMAGE_GATHER4_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 1818
  { IMAGE_GATHER4_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1819
  { IMAGE_GATHER4_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1820
  { IMAGE_GATHER4_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 1821
  { IMAGE_GATHER4_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1822
  { IMAGE_GATHER4_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1823
  { IMAGE_GATHER4_CL_V2_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 1824
  { IMAGE_GATHER4_CL_V2_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 1825
  { IMAGE_GATHER4_CL_V2_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1826
  { IMAGE_GATHER4_CL_V2_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1827
  { IMAGE_GATHER4_CL_V4_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 1828
  { IMAGE_GATHER4_CL_V4_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 1829
  { IMAGE_GATHER4_CL_V4_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1830
  { IMAGE_GATHER4_CL_V4_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1831
  { IMAGE_GATHER4_CL_V5_V1_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 1832
  { IMAGE_GATHER4_CL_V5_V2_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 1833
  { IMAGE_GATHER4_CL_V5_V3_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1834
  { IMAGE_GATHER4_CL_V5_V4_gfx12, IMAGE_GATHER4_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1835
  { IMAGE_GATHER4_CL_V2_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 1836
  { IMAGE_GATHER4_CL_V2_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1837
  { IMAGE_GATHER4_CL_V2_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1838
  { IMAGE_GATHER4_CL_V2_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1839
  { IMAGE_GATHER4_CL_V4_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 1840
  { IMAGE_GATHER4_CL_V4_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1841
  { IMAGE_GATHER4_CL_V4_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1842
  { IMAGE_GATHER4_CL_V4_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1843
  { IMAGE_GATHER4_CL_V5_V1, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 1844
  { IMAGE_GATHER4_CL_V5_V2, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1845
  { IMAGE_GATHER4_CL_V5_V3, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1846
  { IMAGE_GATHER4_CL_V5_V4, IMAGE_GATHER4_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1847
  { IMAGE_GATHER4_CL_O_V2_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 1848
  { IMAGE_GATHER4_CL_O_V2_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1849
  { IMAGE_GATHER4_CL_O_V2_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1850
  { IMAGE_GATHER4_CL_O_V2_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1851
  { IMAGE_GATHER4_CL_O_V2_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1852
  { IMAGE_GATHER4_CL_O_V4_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 1853
  { IMAGE_GATHER4_CL_O_V4_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1854
  { IMAGE_GATHER4_CL_O_V4_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1855
  { IMAGE_GATHER4_CL_O_V4_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1856
  { IMAGE_GATHER4_CL_O_V4_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1857
  { IMAGE_GATHER4_CL_O_V5_V2_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 1858
  { IMAGE_GATHER4_CL_O_V5_V3_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1859
  { IMAGE_GATHER4_CL_O_V5_V4_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1860
  { IMAGE_GATHER4_CL_O_V5_V5_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1861
  { IMAGE_GATHER4_CL_O_V5_V8_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1862
  { IMAGE_GATHER4_CL_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 1863
  { IMAGE_GATHER4_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1864
  { IMAGE_GATHER4_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1865
  { IMAGE_GATHER4_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1866
  { IMAGE_GATHER4_CL_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 1867
  { IMAGE_GATHER4_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1868
  { IMAGE_GATHER4_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1869
  { IMAGE_GATHER4_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1870
  { IMAGE_GATHER4_CL_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 1871
  { IMAGE_GATHER4_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1872
  { IMAGE_GATHER4_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1873
  { IMAGE_GATHER4_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1874
  { IMAGE_GATHER4_CL_O_V2_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 1875
  { IMAGE_GATHER4_CL_O_V2_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1876
  { IMAGE_GATHER4_CL_O_V2_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1877
  { IMAGE_GATHER4_CL_O_V2_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1878
  { IMAGE_GATHER4_CL_O_V2_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1879
  { IMAGE_GATHER4_CL_O_V4_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 1880
  { IMAGE_GATHER4_CL_O_V4_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1881
  { IMAGE_GATHER4_CL_O_V4_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1882
  { IMAGE_GATHER4_CL_O_V4_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1883
  { IMAGE_GATHER4_CL_O_V4_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1884
  { IMAGE_GATHER4_CL_O_V5_V2, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 1885
  { IMAGE_GATHER4_CL_O_V5_V3, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1886
  { IMAGE_GATHER4_CL_O_V5_V4, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1887
  { IMAGE_GATHER4_CL_O_V5_V5, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1888
  { IMAGE_GATHER4_CL_O_V5_V8, IMAGE_GATHER4_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1889
  { IMAGE_GATHER4_C_B_V2_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1890
  { IMAGE_GATHER4_C_B_V2_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1891
  { IMAGE_GATHER4_C_B_V2_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1892
  { IMAGE_GATHER4_C_B_V2_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1893
  { IMAGE_GATHER4_C_B_V4_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1894
  { IMAGE_GATHER4_C_B_V4_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1895
  { IMAGE_GATHER4_C_B_V4_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1896
  { IMAGE_GATHER4_C_B_V4_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1897
  { IMAGE_GATHER4_C_B_V5_V3_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1898
  { IMAGE_GATHER4_C_B_V5_V4_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1899
  { IMAGE_GATHER4_C_B_V5_V5_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1900
  { IMAGE_GATHER4_C_B_V5_V8_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1901
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1902
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1903
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1904
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1905
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1906
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1907
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1908
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1909
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1910
  { IMAGE_GATHER4_C_B_V2_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1911
  { IMAGE_GATHER4_C_B_V2_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1912
  { IMAGE_GATHER4_C_B_V2_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1913
  { IMAGE_GATHER4_C_B_V2_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1914
  { IMAGE_GATHER4_C_B_V4_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1915
  { IMAGE_GATHER4_C_B_V4_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1916
  { IMAGE_GATHER4_C_B_V4_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1917
  { IMAGE_GATHER4_C_B_V4_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1918
  { IMAGE_GATHER4_C_B_V5_V3_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1919
  { IMAGE_GATHER4_C_B_V5_V4_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1920
  { IMAGE_GATHER4_C_B_V5_V5_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1921
  { IMAGE_GATHER4_C_B_V5_V8_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1922
  { IMAGE_GATHER4_C_B_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1923
  { IMAGE_GATHER4_C_B_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1924
  { IMAGE_GATHER4_C_B_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1925
  { IMAGE_GATHER4_C_B_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1926
  { IMAGE_GATHER4_C_B_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 1927
  { IMAGE_GATHER4_C_B_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 1928
  { IMAGE_GATHER4_C_B_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 1929
  { IMAGE_GATHER4_C_B_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 1930
  { IMAGE_GATHER4_C_B_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 1931
  { IMAGE_GATHER4_C_B_V2_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 1932
  { IMAGE_GATHER4_C_B_V2_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 1933
  { IMAGE_GATHER4_C_B_V2_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 1934
  { IMAGE_GATHER4_C_B_V4_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 1935
  { IMAGE_GATHER4_C_B_V4_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 1936
  { IMAGE_GATHER4_C_B_V4_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 1937
  { IMAGE_GATHER4_C_B_V5_V3_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 1938
  { IMAGE_GATHER4_C_B_V5_V4_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 1939
  { IMAGE_GATHER4_C_B_V5_V5_gfx12, IMAGE_GATHER4_C_B, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 1940
  { IMAGE_GATHER4_C_B_V2_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 1941
  { IMAGE_GATHER4_C_B_V2_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 1942
  { IMAGE_GATHER4_C_B_V2_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 1943
  { IMAGE_GATHER4_C_B_V2_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 1944
  { IMAGE_GATHER4_C_B_V4_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 1945
  { IMAGE_GATHER4_C_B_V4_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 1946
  { IMAGE_GATHER4_C_B_V4_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 1947
  { IMAGE_GATHER4_C_B_V4_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 1948
  { IMAGE_GATHER4_C_B_V5_V3, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 1949
  { IMAGE_GATHER4_C_B_V5_V4, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 1950
  { IMAGE_GATHER4_C_B_V5_V5, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 1951
  { IMAGE_GATHER4_C_B_V5_V8, IMAGE_GATHER4_C_B, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 1952
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 1953
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 1954
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 1955
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 1956
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 1957
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 1958
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 1959
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 1960
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 1961
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 1962
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 1963
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 1964
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 1965
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 1966
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 1967
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 1968
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 1969
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 1970
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 1971
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 1972
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 1973
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 1974
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 1975
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 1976
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 1977
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 1978
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 1979
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 1980
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 1981
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 1982
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 1983
  { IMAGE_GATHER4_C_B_CL_V2_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 1984
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 1985
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 1986
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 1987
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 1988
  { IMAGE_GATHER4_C_B_CL_V4_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 1989
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 1990
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 1991
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 1992
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 1993
  { IMAGE_GATHER4_C_B_CL_V5_V8_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 1994
  { IMAGE_GATHER4_C_B_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 1995
  { IMAGE_GATHER4_C_B_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 1996
  { IMAGE_GATHER4_C_B_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 1997
  { IMAGE_GATHER4_C_B_CL_V2_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 1998
  { IMAGE_GATHER4_C_B_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 1999
  { IMAGE_GATHER4_C_B_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2000
  { IMAGE_GATHER4_C_B_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2001
  { IMAGE_GATHER4_C_B_CL_V4_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 2002
  { IMAGE_GATHER4_C_B_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2003
  { IMAGE_GATHER4_C_B_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2004
  { IMAGE_GATHER4_C_B_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2005
  { IMAGE_GATHER4_C_B_CL_V5_V6_nsa_gfx11, IMAGE_GATHER4_C_B_CL, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 2006
  { IMAGE_GATHER4_C_B_CL_V2_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2007
  { IMAGE_GATHER4_C_B_CL_V2_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2008
  { IMAGE_GATHER4_C_B_CL_V2_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2009
  { IMAGE_GATHER4_C_B_CL_V2_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 2010
  { IMAGE_GATHER4_C_B_CL_V4_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2011
  { IMAGE_GATHER4_C_B_CL_V4_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2012
  { IMAGE_GATHER4_C_B_CL_V4_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2013
  { IMAGE_GATHER4_C_B_CL_V4_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 2014
  { IMAGE_GATHER4_C_B_CL_V5_V3_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2015
  { IMAGE_GATHER4_C_B_CL_V5_V4_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2016
  { IMAGE_GATHER4_C_B_CL_V5_V5_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2017
  { IMAGE_GATHER4_C_B_CL_V5_V6_gfx12, IMAGE_GATHER4_C_B_CL, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 2018
  { IMAGE_GATHER4_C_B_CL_V2_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2019
  { IMAGE_GATHER4_C_B_CL_V2_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2020
  { IMAGE_GATHER4_C_B_CL_V2_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2021
  { IMAGE_GATHER4_C_B_CL_V2_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2022
  { IMAGE_GATHER4_C_B_CL_V2_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2023
  { IMAGE_GATHER4_C_B_CL_V4_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2024
  { IMAGE_GATHER4_C_B_CL_V4_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2025
  { IMAGE_GATHER4_C_B_CL_V4_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2026
  { IMAGE_GATHER4_C_B_CL_V4_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2027
  { IMAGE_GATHER4_C_B_CL_V4_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2028
  { IMAGE_GATHER4_C_B_CL_V5_V3, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2029
  { IMAGE_GATHER4_C_B_CL_V5_V4, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2030
  { IMAGE_GATHER4_C_B_CL_V5_V5, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2031
  { IMAGE_GATHER4_C_B_CL_V5_V6, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2032
  { IMAGE_GATHER4_C_B_CL_V5_V8, IMAGE_GATHER4_C_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2033
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2034
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2035
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2036
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 2037
  { IMAGE_GATHER4_C_B_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2038
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2039
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2040
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2041
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 2042
  { IMAGE_GATHER4_C_B_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2043
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2044
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2045
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2046
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 2047
  { IMAGE_GATHER4_C_B_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2048
  { IMAGE_GATHER4_C_B_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2049
  { IMAGE_GATHER4_C_B_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2050
  { IMAGE_GATHER4_C_B_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2051
  { IMAGE_GATHER4_C_B_CL_O_V2_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 2052
  { IMAGE_GATHER4_C_B_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2053
  { IMAGE_GATHER4_C_B_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2054
  { IMAGE_GATHER4_C_B_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2055
  { IMAGE_GATHER4_C_B_CL_O_V4_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 2056
  { IMAGE_GATHER4_C_B_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2057
  { IMAGE_GATHER4_C_B_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2058
  { IMAGE_GATHER4_C_B_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2059
  { IMAGE_GATHER4_C_B_CL_O_V5_V7_nsa_gfx10, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 2060
  { IMAGE_GATHER4_C_B_CL_O_V2_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2061
  { IMAGE_GATHER4_C_B_CL_O_V2_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2062
  { IMAGE_GATHER4_C_B_CL_O_V2_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2063
  { IMAGE_GATHER4_C_B_CL_O_V2_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 2064
  { IMAGE_GATHER4_C_B_CL_O_V2_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2065
  { IMAGE_GATHER4_C_B_CL_O_V4_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2066
  { IMAGE_GATHER4_C_B_CL_O_V4_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2067
  { IMAGE_GATHER4_C_B_CL_O_V4_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2068
  { IMAGE_GATHER4_C_B_CL_O_V4_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 2069
  { IMAGE_GATHER4_C_B_CL_O_V4_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2070
  { IMAGE_GATHER4_C_B_CL_O_V5_V4, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2071
  { IMAGE_GATHER4_C_B_CL_O_V5_V5, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2072
  { IMAGE_GATHER4_C_B_CL_O_V5_V6, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2073
  { IMAGE_GATHER4_C_B_CL_O_V5_V7, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 2074
  { IMAGE_GATHER4_C_B_CL_O_V5_V8, IMAGE_GATHER4_C_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2075
  { IMAGE_GATHER4_C_B_O_V2_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2076
  { IMAGE_GATHER4_C_B_O_V2_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2077
  { IMAGE_GATHER4_C_B_O_V2_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2078
  { IMAGE_GATHER4_C_B_O_V2_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2079
  { IMAGE_GATHER4_C_B_O_V4_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2080
  { IMAGE_GATHER4_C_B_O_V4_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2081
  { IMAGE_GATHER4_C_B_O_V4_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2082
  { IMAGE_GATHER4_C_B_O_V4_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2083
  { IMAGE_GATHER4_C_B_O_V5_V4_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2084
  { IMAGE_GATHER4_C_B_O_V5_V5_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2085
  { IMAGE_GATHER4_C_B_O_V5_V6_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2086
  { IMAGE_GATHER4_C_B_O_V5_V8_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2087
  { IMAGE_GATHER4_C_B_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2088
  { IMAGE_GATHER4_C_B_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2089
  { IMAGE_GATHER4_C_B_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2090
  { IMAGE_GATHER4_C_B_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2091
  { IMAGE_GATHER4_C_B_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2092
  { IMAGE_GATHER4_C_B_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2093
  { IMAGE_GATHER4_C_B_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2094
  { IMAGE_GATHER4_C_B_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2095
  { IMAGE_GATHER4_C_B_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_B_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2096
  { IMAGE_GATHER4_C_B_O_V2_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2097
  { IMAGE_GATHER4_C_B_O_V2_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2098
  { IMAGE_GATHER4_C_B_O_V2_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2099
  { IMAGE_GATHER4_C_B_O_V2_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2100
  { IMAGE_GATHER4_C_B_O_V4_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2101
  { IMAGE_GATHER4_C_B_O_V4_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2102
  { IMAGE_GATHER4_C_B_O_V4_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2103
  { IMAGE_GATHER4_C_B_O_V4_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2104
  { IMAGE_GATHER4_C_B_O_V5_V4, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2105
  { IMAGE_GATHER4_C_B_O_V5_V5, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2106
  { IMAGE_GATHER4_C_B_O_V5_V6, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2107
  { IMAGE_GATHER4_C_B_O_V5_V8, IMAGE_GATHER4_C_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2108
  { IMAGE_GATHER4_C_CL_V2_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2109
  { IMAGE_GATHER4_C_CL_V2_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2110
  { IMAGE_GATHER4_C_CL_V2_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2111
  { IMAGE_GATHER4_C_CL_V2_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2112
  { IMAGE_GATHER4_C_CL_V2_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2113
  { IMAGE_GATHER4_C_CL_V4_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2114
  { IMAGE_GATHER4_C_CL_V4_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2115
  { IMAGE_GATHER4_C_CL_V4_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2116
  { IMAGE_GATHER4_C_CL_V4_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2117
  { IMAGE_GATHER4_C_CL_V4_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2118
  { IMAGE_GATHER4_C_CL_V5_V2_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2119
  { IMAGE_GATHER4_C_CL_V5_V3_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2120
  { IMAGE_GATHER4_C_CL_V5_V4_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2121
  { IMAGE_GATHER4_C_CL_V5_V5_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2122
  { IMAGE_GATHER4_C_CL_V5_V8_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2123
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2124
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2125
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2126
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2127
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2128
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2129
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2130
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2131
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2132
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2133
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2134
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2135
  { IMAGE_GATHER4_C_CL_V2_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2136
  { IMAGE_GATHER4_C_CL_V2_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2137
  { IMAGE_GATHER4_C_CL_V2_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2138
  { IMAGE_GATHER4_C_CL_V2_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2139
  { IMAGE_GATHER4_C_CL_V2_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2140
  { IMAGE_GATHER4_C_CL_V4_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2141
  { IMAGE_GATHER4_C_CL_V4_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2142
  { IMAGE_GATHER4_C_CL_V4_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2143
  { IMAGE_GATHER4_C_CL_V4_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2144
  { IMAGE_GATHER4_C_CL_V4_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2145
  { IMAGE_GATHER4_C_CL_V5_V2_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2146
  { IMAGE_GATHER4_C_CL_V5_V3_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2147
  { IMAGE_GATHER4_C_CL_V5_V4_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2148
  { IMAGE_GATHER4_C_CL_V5_V5_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2149
  { IMAGE_GATHER4_C_CL_V5_V8_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2150
  { IMAGE_GATHER4_C_CL_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2151
  { IMAGE_GATHER4_C_CL_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2152
  { IMAGE_GATHER4_C_CL_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2153
  { IMAGE_GATHER4_C_CL_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2154
  { IMAGE_GATHER4_C_CL_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2155
  { IMAGE_GATHER4_C_CL_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2156
  { IMAGE_GATHER4_C_CL_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2157
  { IMAGE_GATHER4_C_CL_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2158
  { IMAGE_GATHER4_C_CL_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2159
  { IMAGE_GATHER4_C_CL_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2160
  { IMAGE_GATHER4_C_CL_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2161
  { IMAGE_GATHER4_C_CL_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2162
  { IMAGE_GATHER4_C_CL_V2_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2163
  { IMAGE_GATHER4_C_CL_V2_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2164
  { IMAGE_GATHER4_C_CL_V2_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2165
  { IMAGE_GATHER4_C_CL_V2_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2166
  { IMAGE_GATHER4_C_CL_V4_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2167
  { IMAGE_GATHER4_C_CL_V4_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2168
  { IMAGE_GATHER4_C_CL_V4_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2169
  { IMAGE_GATHER4_C_CL_V4_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2170
  { IMAGE_GATHER4_C_CL_V5_V2_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2171
  { IMAGE_GATHER4_C_CL_V5_V3_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2172
  { IMAGE_GATHER4_C_CL_V5_V4_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2173
  { IMAGE_GATHER4_C_CL_V5_V5_gfx12, IMAGE_GATHER4_C_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2174
  { IMAGE_GATHER4_C_CL_V2_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2175
  { IMAGE_GATHER4_C_CL_V2_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2176
  { IMAGE_GATHER4_C_CL_V2_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2177
  { IMAGE_GATHER4_C_CL_V2_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2178
  { IMAGE_GATHER4_C_CL_V2_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2179
  { IMAGE_GATHER4_C_CL_V4_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2180
  { IMAGE_GATHER4_C_CL_V4_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2181
  { IMAGE_GATHER4_C_CL_V4_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2182
  { IMAGE_GATHER4_C_CL_V4_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2183
  { IMAGE_GATHER4_C_CL_V4_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2184
  { IMAGE_GATHER4_C_CL_V5_V2, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2185
  { IMAGE_GATHER4_C_CL_V5_V3, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2186
  { IMAGE_GATHER4_C_CL_V5_V4, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2187
  { IMAGE_GATHER4_C_CL_V5_V5, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2188
  { IMAGE_GATHER4_C_CL_V5_V8, IMAGE_GATHER4_C_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2189
  { IMAGE_GATHER4_C_CL_O_V2_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2190
  { IMAGE_GATHER4_C_CL_O_V2_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2191
  { IMAGE_GATHER4_C_CL_O_V2_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2192
  { IMAGE_GATHER4_C_CL_O_V2_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2193
  { IMAGE_GATHER4_C_CL_O_V2_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2194
  { IMAGE_GATHER4_C_CL_O_V4_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2195
  { IMAGE_GATHER4_C_CL_O_V4_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2196
  { IMAGE_GATHER4_C_CL_O_V4_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2197
  { IMAGE_GATHER4_C_CL_O_V4_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2198
  { IMAGE_GATHER4_C_CL_O_V4_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2199
  { IMAGE_GATHER4_C_CL_O_V5_V3_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2200
  { IMAGE_GATHER4_C_CL_O_V5_V4_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2201
  { IMAGE_GATHER4_C_CL_O_V5_V5_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2202
  { IMAGE_GATHER4_C_CL_O_V5_V6_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2203
  { IMAGE_GATHER4_C_CL_O_V5_V8_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2204
  { IMAGE_GATHER4_C_CL_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2205
  { IMAGE_GATHER4_C_CL_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2206
  { IMAGE_GATHER4_C_CL_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2207
  { IMAGE_GATHER4_C_CL_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2208
  { IMAGE_GATHER4_C_CL_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2209
  { IMAGE_GATHER4_C_CL_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2210
  { IMAGE_GATHER4_C_CL_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2211
  { IMAGE_GATHER4_C_CL_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2212
  { IMAGE_GATHER4_C_CL_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2213
  { IMAGE_GATHER4_C_CL_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2214
  { IMAGE_GATHER4_C_CL_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2215
  { IMAGE_GATHER4_C_CL_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2216
  { IMAGE_GATHER4_C_CL_O_V2_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2217
  { IMAGE_GATHER4_C_CL_O_V2_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2218
  { IMAGE_GATHER4_C_CL_O_V2_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2219
  { IMAGE_GATHER4_C_CL_O_V2_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2220
  { IMAGE_GATHER4_C_CL_O_V2_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2221
  { IMAGE_GATHER4_C_CL_O_V4_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2222
  { IMAGE_GATHER4_C_CL_O_V4_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2223
  { IMAGE_GATHER4_C_CL_O_V4_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2224
  { IMAGE_GATHER4_C_CL_O_V4_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2225
  { IMAGE_GATHER4_C_CL_O_V4_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2226
  { IMAGE_GATHER4_C_CL_O_V5_V3, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2227
  { IMAGE_GATHER4_C_CL_O_V5_V4, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2228
  { IMAGE_GATHER4_C_CL_O_V5_V5, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2229
  { IMAGE_GATHER4_C_CL_O_V5_V6, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2230
  { IMAGE_GATHER4_C_CL_O_V5_V8, IMAGE_GATHER4_C_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2231
  { IMAGE_GATHER4_C_L_V2_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2232
  { IMAGE_GATHER4_C_L_V2_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2233
  { IMAGE_GATHER4_C_L_V2_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2234
  { IMAGE_GATHER4_C_L_V2_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2235
  { IMAGE_GATHER4_C_L_V2_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2236
  { IMAGE_GATHER4_C_L_V4_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2237
  { IMAGE_GATHER4_C_L_V4_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2238
  { IMAGE_GATHER4_C_L_V4_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2239
  { IMAGE_GATHER4_C_L_V4_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2240
  { IMAGE_GATHER4_C_L_V4_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2241
  { IMAGE_GATHER4_C_L_V5_V2_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2242
  { IMAGE_GATHER4_C_L_V5_V3_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2243
  { IMAGE_GATHER4_C_L_V5_V4_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2244
  { IMAGE_GATHER4_C_L_V5_V5_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2245
  { IMAGE_GATHER4_C_L_V5_V8_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2246
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2247
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2248
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2249
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2250
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2251
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2252
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2253
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2254
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2255
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2256
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2257
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2258
  { IMAGE_GATHER4_C_L_V2_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2259
  { IMAGE_GATHER4_C_L_V2_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2260
  { IMAGE_GATHER4_C_L_V2_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2261
  { IMAGE_GATHER4_C_L_V2_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2262
  { IMAGE_GATHER4_C_L_V2_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2263
  { IMAGE_GATHER4_C_L_V4_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2264
  { IMAGE_GATHER4_C_L_V4_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2265
  { IMAGE_GATHER4_C_L_V4_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2266
  { IMAGE_GATHER4_C_L_V4_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2267
  { IMAGE_GATHER4_C_L_V4_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2268
  { IMAGE_GATHER4_C_L_V5_V2_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2269
  { IMAGE_GATHER4_C_L_V5_V3_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2270
  { IMAGE_GATHER4_C_L_V5_V4_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2271
  { IMAGE_GATHER4_C_L_V5_V5_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2272
  { IMAGE_GATHER4_C_L_V5_V8_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2273
  { IMAGE_GATHER4_C_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2274
  { IMAGE_GATHER4_C_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2275
  { IMAGE_GATHER4_C_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2276
  { IMAGE_GATHER4_C_L_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2277
  { IMAGE_GATHER4_C_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2278
  { IMAGE_GATHER4_C_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2279
  { IMAGE_GATHER4_C_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2280
  { IMAGE_GATHER4_C_L_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2281
  { IMAGE_GATHER4_C_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2282
  { IMAGE_GATHER4_C_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2283
  { IMAGE_GATHER4_C_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2284
  { IMAGE_GATHER4_C_L_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_L, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2285
  { IMAGE_GATHER4_C_L_V2_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2286
  { IMAGE_GATHER4_C_L_V2_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2287
  { IMAGE_GATHER4_C_L_V2_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2288
  { IMAGE_GATHER4_C_L_V2_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2289
  { IMAGE_GATHER4_C_L_V4_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2290
  { IMAGE_GATHER4_C_L_V4_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2291
  { IMAGE_GATHER4_C_L_V4_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2292
  { IMAGE_GATHER4_C_L_V4_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2293
  { IMAGE_GATHER4_C_L_V5_V2_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2294
  { IMAGE_GATHER4_C_L_V5_V3_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2295
  { IMAGE_GATHER4_C_L_V5_V4_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2296
  { IMAGE_GATHER4_C_L_V5_V5_gfx12, IMAGE_GATHER4_C_L, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2297
  { IMAGE_GATHER4_C_L_V2_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2298
  { IMAGE_GATHER4_C_L_V2_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2299
  { IMAGE_GATHER4_C_L_V2_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2300
  { IMAGE_GATHER4_C_L_V2_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2301
  { IMAGE_GATHER4_C_L_V2_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2302
  { IMAGE_GATHER4_C_L_V4_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2303
  { IMAGE_GATHER4_C_L_V4_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2304
  { IMAGE_GATHER4_C_L_V4_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2305
  { IMAGE_GATHER4_C_L_V4_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2306
  { IMAGE_GATHER4_C_L_V4_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2307
  { IMAGE_GATHER4_C_L_V5_V2, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2308
  { IMAGE_GATHER4_C_L_V5_V3, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2309
  { IMAGE_GATHER4_C_L_V5_V4, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2310
  { IMAGE_GATHER4_C_L_V5_V5, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2311
  { IMAGE_GATHER4_C_L_V5_V8, IMAGE_GATHER4_C_L, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2312
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2313
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2314
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2315
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2316
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2317
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2318
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2319
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2320
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2321
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2322
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2323
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2324
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2325
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2326
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2327
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2328
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2329
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2330
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2331
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2332
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2333
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2334
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2335
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2336
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2337
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2338
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2339
  { IMAGE_GATHER4_C_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2340
  { IMAGE_GATHER4_C_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2341
  { IMAGE_GATHER4_C_LZ_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2342
  { IMAGE_GATHER4_C_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2343
  { IMAGE_GATHER4_C_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2344
  { IMAGE_GATHER4_C_LZ_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2345
  { IMAGE_GATHER4_C_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2346
  { IMAGE_GATHER4_C_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2347
  { IMAGE_GATHER4_C_LZ_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2348
  { IMAGE_GATHER4_C_LZ_V2_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2349
  { IMAGE_GATHER4_C_LZ_V2_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2350
  { IMAGE_GATHER4_C_LZ_V2_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2351
  { IMAGE_GATHER4_C_LZ_V4_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2352
  { IMAGE_GATHER4_C_LZ_V4_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2353
  { IMAGE_GATHER4_C_LZ_V4_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2354
  { IMAGE_GATHER4_C_LZ_V5_V2_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2355
  { IMAGE_GATHER4_C_LZ_V5_V3_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2356
  { IMAGE_GATHER4_C_LZ_V5_V4_gfx12, IMAGE_GATHER4_C_LZ, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2357
  { IMAGE_GATHER4_C_LZ_V2_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2358
  { IMAGE_GATHER4_C_LZ_V2_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2359
  { IMAGE_GATHER4_C_LZ_V2_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2360
  { IMAGE_GATHER4_C_LZ_V4_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2361
  { IMAGE_GATHER4_C_LZ_V4_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2362
  { IMAGE_GATHER4_C_LZ_V4_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2363
  { IMAGE_GATHER4_C_LZ_V5_V2, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2364
  { IMAGE_GATHER4_C_LZ_V5_V3, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2365
  { IMAGE_GATHER4_C_LZ_V5_V4, IMAGE_GATHER4_C_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2366
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2367
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2368
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2369
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2370
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2371
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2372
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2373
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2374
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2375
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2376
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2377
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2378
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2379
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2380
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2381
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2382
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2383
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2384
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2385
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2386
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2387
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2388
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2389
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 2390
  { IMAGE_GATHER4_C_LZ_O_V2_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 2391
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2392
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2393
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 2394
  { IMAGE_GATHER4_C_LZ_O_V4_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 2395
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2396
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2397
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 2398
  { IMAGE_GATHER4_C_LZ_O_V5_V8_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 2399
  { IMAGE_GATHER4_C_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2400
  { IMAGE_GATHER4_C_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2401
  { IMAGE_GATHER4_C_LZ_O_V2_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 2402
  { IMAGE_GATHER4_C_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2403
  { IMAGE_GATHER4_C_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2404
  { IMAGE_GATHER4_C_LZ_O_V4_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 2405
  { IMAGE_GATHER4_C_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2406
  { IMAGE_GATHER4_C_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2407
  { IMAGE_GATHER4_C_LZ_O_V5_V5_nsa_gfx11, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 2408
  { IMAGE_GATHER4_C_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2409
  { IMAGE_GATHER4_C_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2410
  { IMAGE_GATHER4_C_LZ_O_V2_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 2411
  { IMAGE_GATHER4_C_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2412
  { IMAGE_GATHER4_C_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2413
  { IMAGE_GATHER4_C_LZ_O_V4_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 2414
  { IMAGE_GATHER4_C_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2415
  { IMAGE_GATHER4_C_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2416
  { IMAGE_GATHER4_C_LZ_O_V5_V5_gfx12, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 2417
  { IMAGE_GATHER4_C_LZ_O_V2_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2418
  { IMAGE_GATHER4_C_LZ_O_V2_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2419
  { IMAGE_GATHER4_C_LZ_O_V2_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2420
  { IMAGE_GATHER4_C_LZ_O_V2_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2421
  { IMAGE_GATHER4_C_LZ_O_V4_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2422
  { IMAGE_GATHER4_C_LZ_O_V4_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2423
  { IMAGE_GATHER4_C_LZ_O_V4_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2424
  { IMAGE_GATHER4_C_LZ_O_V4_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2425
  { IMAGE_GATHER4_C_LZ_O_V5_V3, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2426
  { IMAGE_GATHER4_C_LZ_O_V5_V4, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2427
  { IMAGE_GATHER4_C_LZ_O_V5_V5, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2428
  { IMAGE_GATHER4_C_LZ_O_V5_V8, IMAGE_GATHER4_C_LZ_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2429
  { IMAGE_GATHER4_C_L_O_V2_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2430
  { IMAGE_GATHER4_C_L_O_V2_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2431
  { IMAGE_GATHER4_C_L_O_V2_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2432
  { IMAGE_GATHER4_C_L_O_V2_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 2433
  { IMAGE_GATHER4_C_L_O_V2_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2434
  { IMAGE_GATHER4_C_L_O_V4_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2435
  { IMAGE_GATHER4_C_L_O_V4_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2436
  { IMAGE_GATHER4_C_L_O_V4_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2437
  { IMAGE_GATHER4_C_L_O_V4_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 2438
  { IMAGE_GATHER4_C_L_O_V4_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2439
  { IMAGE_GATHER4_C_L_O_V5_V3_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2440
  { IMAGE_GATHER4_C_L_O_V5_V4_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2441
  { IMAGE_GATHER4_C_L_O_V5_V5_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2442
  { IMAGE_GATHER4_C_L_O_V5_V6_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 2443
  { IMAGE_GATHER4_C_L_O_V5_V8_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2444
  { IMAGE_GATHER4_C_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2445
  { IMAGE_GATHER4_C_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2446
  { IMAGE_GATHER4_C_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2447
  { IMAGE_GATHER4_C_L_O_V2_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 2448
  { IMAGE_GATHER4_C_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2449
  { IMAGE_GATHER4_C_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2450
  { IMAGE_GATHER4_C_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2451
  { IMAGE_GATHER4_C_L_O_V4_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 2452
  { IMAGE_GATHER4_C_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2453
  { IMAGE_GATHER4_C_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2454
  { IMAGE_GATHER4_C_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2455
  { IMAGE_GATHER4_C_L_O_V5_V6_nsa_gfx10, IMAGE_GATHER4_C_L_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 2456
  { IMAGE_GATHER4_C_L_O_V2_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2457
  { IMAGE_GATHER4_C_L_O_V2_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2458
  { IMAGE_GATHER4_C_L_O_V2_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2459
  { IMAGE_GATHER4_C_L_O_V2_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 2460
  { IMAGE_GATHER4_C_L_O_V2_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2461
  { IMAGE_GATHER4_C_L_O_V4_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2462
  { IMAGE_GATHER4_C_L_O_V4_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2463
  { IMAGE_GATHER4_C_L_O_V4_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2464
  { IMAGE_GATHER4_C_L_O_V4_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 2465
  { IMAGE_GATHER4_C_L_O_V4_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2466
  { IMAGE_GATHER4_C_L_O_V5_V3, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2467
  { IMAGE_GATHER4_C_L_O_V5_V4, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2468
  { IMAGE_GATHER4_C_L_O_V5_V5, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2469
  { IMAGE_GATHER4_C_L_O_V5_V6, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 2470
  { IMAGE_GATHER4_C_L_O_V5_V8, IMAGE_GATHER4_C_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2471
  { IMAGE_GATHER4_C_O_V2_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2472
  { IMAGE_GATHER4_C_O_V2_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2473
  { IMAGE_GATHER4_C_O_V2_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2474
  { IMAGE_GATHER4_C_O_V2_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2475
  { IMAGE_GATHER4_C_O_V4_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2476
  { IMAGE_GATHER4_C_O_V4_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2477
  { IMAGE_GATHER4_C_O_V4_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2478
  { IMAGE_GATHER4_C_O_V4_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2479
  { IMAGE_GATHER4_C_O_V5_V3_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2480
  { IMAGE_GATHER4_C_O_V5_V4_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2481
  { IMAGE_GATHER4_C_O_V5_V5_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2482
  { IMAGE_GATHER4_C_O_V5_V8_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2483
  { IMAGE_GATHER4_C_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2484
  { IMAGE_GATHER4_C_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2485
  { IMAGE_GATHER4_C_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2486
  { IMAGE_GATHER4_C_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2487
  { IMAGE_GATHER4_C_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2488
  { IMAGE_GATHER4_C_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2489
  { IMAGE_GATHER4_C_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2490
  { IMAGE_GATHER4_C_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2491
  { IMAGE_GATHER4_C_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_C_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2492
  { IMAGE_GATHER4_C_O_V2_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2493
  { IMAGE_GATHER4_C_O_V2_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2494
  { IMAGE_GATHER4_C_O_V2_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2495
  { IMAGE_GATHER4_C_O_V2_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2496
  { IMAGE_GATHER4_C_O_V4_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2497
  { IMAGE_GATHER4_C_O_V4_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2498
  { IMAGE_GATHER4_C_O_V4_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2499
  { IMAGE_GATHER4_C_O_V4_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2500
  { IMAGE_GATHER4_C_O_V5_V3, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2501
  { IMAGE_GATHER4_C_O_V5_V4, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2502
  { IMAGE_GATHER4_C_O_V5_V5, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2503
  { IMAGE_GATHER4_C_O_V5_V8, IMAGE_GATHER4_C_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2504
  { IMAGE_GATHER4_L_V2_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2505
  { IMAGE_GATHER4_L_V2_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2506
  { IMAGE_GATHER4_L_V2_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2507
  { IMAGE_GATHER4_L_V2_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2508
  { IMAGE_GATHER4_L_V4_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2509
  { IMAGE_GATHER4_L_V4_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2510
  { IMAGE_GATHER4_L_V4_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2511
  { IMAGE_GATHER4_L_V4_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2512
  { IMAGE_GATHER4_L_V5_V1_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2513
  { IMAGE_GATHER4_L_V5_V2_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2514
  { IMAGE_GATHER4_L_V5_V3_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2515
  { IMAGE_GATHER4_L_V5_V4_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2516
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2517
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2518
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2519
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2520
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2521
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2522
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2523
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2524
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx10, IMAGE_GATHER4_L, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2525
  { IMAGE_GATHER4_L_V2_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2526
  { IMAGE_GATHER4_L_V2_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2527
  { IMAGE_GATHER4_L_V2_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2528
  { IMAGE_GATHER4_L_V2_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2529
  { IMAGE_GATHER4_L_V4_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2530
  { IMAGE_GATHER4_L_V4_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2531
  { IMAGE_GATHER4_L_V4_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2532
  { IMAGE_GATHER4_L_V4_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2533
  { IMAGE_GATHER4_L_V5_V1_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2534
  { IMAGE_GATHER4_L_V5_V2_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2535
  { IMAGE_GATHER4_L_V5_V3_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2536
  { IMAGE_GATHER4_L_V5_V4_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2537
  { IMAGE_GATHER4_L_V2_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2538
  { IMAGE_GATHER4_L_V2_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2539
  { IMAGE_GATHER4_L_V2_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2540
  { IMAGE_GATHER4_L_V4_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2541
  { IMAGE_GATHER4_L_V4_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2542
  { IMAGE_GATHER4_L_V4_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2543
  { IMAGE_GATHER4_L_V5_V2_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2544
  { IMAGE_GATHER4_L_V5_V3_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2545
  { IMAGE_GATHER4_L_V5_V4_nsa_gfx11, IMAGE_GATHER4_L, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2546
  { IMAGE_GATHER4_L_V2_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2547
  { IMAGE_GATHER4_L_V2_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2548
  { IMAGE_GATHER4_L_V2_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2549
  { IMAGE_GATHER4_L_V2_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2550
  { IMAGE_GATHER4_L_V4_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2551
  { IMAGE_GATHER4_L_V4_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2552
  { IMAGE_GATHER4_L_V4_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2553
  { IMAGE_GATHER4_L_V4_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2554
  { IMAGE_GATHER4_L_V5_V1_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2555
  { IMAGE_GATHER4_L_V5_V2_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2556
  { IMAGE_GATHER4_L_V5_V3_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2557
  { IMAGE_GATHER4_L_V5_V4_gfx12, IMAGE_GATHER4_L, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2558
  { IMAGE_GATHER4_L_V2_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2559
  { IMAGE_GATHER4_L_V2_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2560
  { IMAGE_GATHER4_L_V2_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2561
  { IMAGE_GATHER4_L_V2_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2562
  { IMAGE_GATHER4_L_V4_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2563
  { IMAGE_GATHER4_L_V4_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2564
  { IMAGE_GATHER4_L_V4_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2565
  { IMAGE_GATHER4_L_V4_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2566
  { IMAGE_GATHER4_L_V5_V1, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2567
  { IMAGE_GATHER4_L_V5_V2, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2568
  { IMAGE_GATHER4_L_V5_V3, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2569
  { IMAGE_GATHER4_L_V5_V4, IMAGE_GATHER4_L, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2570
  { IMAGE_GATHER4_LZ_V2_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2571
  { IMAGE_GATHER4_LZ_V2_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2572
  { IMAGE_GATHER4_LZ_V2_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2573
  { IMAGE_GATHER4_LZ_V2_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2574
  { IMAGE_GATHER4_LZ_V4_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2575
  { IMAGE_GATHER4_LZ_V4_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2576
  { IMAGE_GATHER4_LZ_V4_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2577
  { IMAGE_GATHER4_LZ_V4_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2578
  { IMAGE_GATHER4_LZ_V5_V1_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2579
  { IMAGE_GATHER4_LZ_V5_V2_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2580
  { IMAGE_GATHER4_LZ_V5_V3_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2581
  { IMAGE_GATHER4_LZ_V5_V4_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2582
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2583
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2584
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2585
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2586
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2587
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2588
  { IMAGE_GATHER4_LZ_V2_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2589
  { IMAGE_GATHER4_LZ_V2_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2590
  { IMAGE_GATHER4_LZ_V2_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2591
  { IMAGE_GATHER4_LZ_V2_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2592
  { IMAGE_GATHER4_LZ_V4_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2593
  { IMAGE_GATHER4_LZ_V4_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2594
  { IMAGE_GATHER4_LZ_V4_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2595
  { IMAGE_GATHER4_LZ_V4_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2596
  { IMAGE_GATHER4_LZ_V5_V1_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2597
  { IMAGE_GATHER4_LZ_V5_V2_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2598
  { IMAGE_GATHER4_LZ_V5_V3_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2599
  { IMAGE_GATHER4_LZ_V5_V4_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2600
  { IMAGE_GATHER4_LZ_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2601
  { IMAGE_GATHER4_LZ_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2602
  { IMAGE_GATHER4_LZ_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2603
  { IMAGE_GATHER4_LZ_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2604
  { IMAGE_GATHER4_LZ_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2605
  { IMAGE_GATHER4_LZ_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2606
  { IMAGE_GATHER4_LZ_V2_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2607
  { IMAGE_GATHER4_LZ_V2_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2608
  { IMAGE_GATHER4_LZ_V2_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2609
  { IMAGE_GATHER4_LZ_V4_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2610
  { IMAGE_GATHER4_LZ_V4_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2611
  { IMAGE_GATHER4_LZ_V4_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2612
  { IMAGE_GATHER4_LZ_V5_V1_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2613
  { IMAGE_GATHER4_LZ_V5_V2_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2614
  { IMAGE_GATHER4_LZ_V5_V3_gfx12, IMAGE_GATHER4_LZ, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2615
  { IMAGE_GATHER4_LZ_V2_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2616
  { IMAGE_GATHER4_LZ_V2_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2617
  { IMAGE_GATHER4_LZ_V2_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2618
  { IMAGE_GATHER4_LZ_V2_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2619
  { IMAGE_GATHER4_LZ_V4_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2620
  { IMAGE_GATHER4_LZ_V4_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2621
  { IMAGE_GATHER4_LZ_V4_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2622
  { IMAGE_GATHER4_LZ_V4_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2623
  { IMAGE_GATHER4_LZ_V5_V1, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2624
  { IMAGE_GATHER4_LZ_V5_V2, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2625
  { IMAGE_GATHER4_LZ_V5_V3, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2626
  { IMAGE_GATHER4_LZ_V5_V4, IMAGE_GATHER4_LZ, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2627
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2628
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2629
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2630
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2631
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2632
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2633
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2634
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2635
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2636
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2637
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2638
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2639
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2640
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2641
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2642
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2643
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2644
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_LZ_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2645
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2646
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2647
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2648
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2649
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2650
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2651
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2652
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2653
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2654
  { IMAGE_GATHER4_LZ_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2655
  { IMAGE_GATHER4_LZ_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2656
  { IMAGE_GATHER4_LZ_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2657
  { IMAGE_GATHER4_LZ_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2658
  { IMAGE_GATHER4_LZ_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2659
  { IMAGE_GATHER4_LZ_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2660
  { IMAGE_GATHER4_LZ_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2661
  { IMAGE_GATHER4_LZ_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2662
  { IMAGE_GATHER4_LZ_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_LZ_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2663
  { IMAGE_GATHER4_LZ_O_V2_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2664
  { IMAGE_GATHER4_LZ_O_V2_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2665
  { IMAGE_GATHER4_LZ_O_V2_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2666
  { IMAGE_GATHER4_LZ_O_V4_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2667
  { IMAGE_GATHER4_LZ_O_V4_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2668
  { IMAGE_GATHER4_LZ_O_V4_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2669
  { IMAGE_GATHER4_LZ_O_V5_V2_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2670
  { IMAGE_GATHER4_LZ_O_V5_V3_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2671
  { IMAGE_GATHER4_LZ_O_V5_V4_gfx12, IMAGE_GATHER4_LZ_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2672
  { IMAGE_GATHER4_LZ_O_V2_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2673
  { IMAGE_GATHER4_LZ_O_V2_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2674
  { IMAGE_GATHER4_LZ_O_V2_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2675
  { IMAGE_GATHER4_LZ_O_V4_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2676
  { IMAGE_GATHER4_LZ_O_V4_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2677
  { IMAGE_GATHER4_LZ_O_V4_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2678
  { IMAGE_GATHER4_LZ_O_V5_V2, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2679
  { IMAGE_GATHER4_LZ_O_V5_V3, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2680
  { IMAGE_GATHER4_LZ_O_V5_V4, IMAGE_GATHER4_LZ_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2681
  { IMAGE_GATHER4_L_O_V2_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2682
  { IMAGE_GATHER4_L_O_V2_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2683
  { IMAGE_GATHER4_L_O_V2_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2684
  { IMAGE_GATHER4_L_O_V2_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 2685
  { IMAGE_GATHER4_L_O_V2_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 2686
  { IMAGE_GATHER4_L_O_V4_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2687
  { IMAGE_GATHER4_L_O_V4_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2688
  { IMAGE_GATHER4_L_O_V4_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2689
  { IMAGE_GATHER4_L_O_V4_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 2690
  { IMAGE_GATHER4_L_O_V4_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 2691
  { IMAGE_GATHER4_L_O_V5_V2_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2692
  { IMAGE_GATHER4_L_O_V5_V3_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2693
  { IMAGE_GATHER4_L_O_V5_V4_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2694
  { IMAGE_GATHER4_L_O_V5_V5_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 2695
  { IMAGE_GATHER4_L_O_V5_V8_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 2696
  { IMAGE_GATHER4_L_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2697
  { IMAGE_GATHER4_L_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2698
  { IMAGE_GATHER4_L_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2699
  { IMAGE_GATHER4_L_O_V2_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 2700
  { IMAGE_GATHER4_L_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2701
  { IMAGE_GATHER4_L_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2702
  { IMAGE_GATHER4_L_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2703
  { IMAGE_GATHER4_L_O_V4_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 2704
  { IMAGE_GATHER4_L_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2705
  { IMAGE_GATHER4_L_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2706
  { IMAGE_GATHER4_L_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2707
  { IMAGE_GATHER4_L_O_V5_V5_nsa_gfx10, IMAGE_GATHER4_L_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 2708
  { IMAGE_GATHER4_L_O_V2_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2709
  { IMAGE_GATHER4_L_O_V2_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2710
  { IMAGE_GATHER4_L_O_V2_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2711
  { IMAGE_GATHER4_L_O_V2_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 2712
  { IMAGE_GATHER4_L_O_V2_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 2713
  { IMAGE_GATHER4_L_O_V4_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2714
  { IMAGE_GATHER4_L_O_V4_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2715
  { IMAGE_GATHER4_L_O_V4_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2716
  { IMAGE_GATHER4_L_O_V4_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 2717
  { IMAGE_GATHER4_L_O_V4_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 2718
  { IMAGE_GATHER4_L_O_V5_V2, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2719
  { IMAGE_GATHER4_L_O_V5_V3, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2720
  { IMAGE_GATHER4_L_O_V5_V4, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2721
  { IMAGE_GATHER4_L_O_V5_V5, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 2722
  { IMAGE_GATHER4_L_O_V5_V8, IMAGE_GATHER4_L_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 2723
  { IMAGE_GATHER4_O_V2_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2724
  { IMAGE_GATHER4_O_V2_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2725
  { IMAGE_GATHER4_O_V2_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2726
  { IMAGE_GATHER4_O_V4_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2727
  { IMAGE_GATHER4_O_V4_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2728
  { IMAGE_GATHER4_O_V4_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2729
  { IMAGE_GATHER4_O_V5_V2_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2730
  { IMAGE_GATHER4_O_V5_V3_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2731
  { IMAGE_GATHER4_O_V5_V4_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2732
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2733
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2734
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2735
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2736
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2737
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2738
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2739
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2740
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx10, IMAGE_GATHER4_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2741
  { IMAGE_GATHER4_O_V2_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2742
  { IMAGE_GATHER4_O_V2_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2743
  { IMAGE_GATHER4_O_V2_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2744
  { IMAGE_GATHER4_O_V4_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2745
  { IMAGE_GATHER4_O_V4_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2746
  { IMAGE_GATHER4_O_V4_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2747
  { IMAGE_GATHER4_O_V5_V2_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2748
  { IMAGE_GATHER4_O_V5_V3_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2749
  { IMAGE_GATHER4_O_V5_V4_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2750
  { IMAGE_GATHER4_O_V2_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2751
  { IMAGE_GATHER4_O_V2_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2752
  { IMAGE_GATHER4_O_V2_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2753
  { IMAGE_GATHER4_O_V4_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2754
  { IMAGE_GATHER4_O_V4_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2755
  { IMAGE_GATHER4_O_V4_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2756
  { IMAGE_GATHER4_O_V5_V2_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2757
  { IMAGE_GATHER4_O_V5_V3_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2758
  { IMAGE_GATHER4_O_V5_V4_nsa_gfx11, IMAGE_GATHER4_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2759
  { IMAGE_GATHER4_O_V2_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2760
  { IMAGE_GATHER4_O_V2_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2761
  { IMAGE_GATHER4_O_V2_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2762
  { IMAGE_GATHER4_O_V4_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2763
  { IMAGE_GATHER4_O_V4_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2764
  { IMAGE_GATHER4_O_V4_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2765
  { IMAGE_GATHER4_O_V5_V2_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2766
  { IMAGE_GATHER4_O_V5_V3_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2767
  { IMAGE_GATHER4_O_V5_V4_gfx12, IMAGE_GATHER4_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2768
  { IMAGE_GATHER4_O_V2_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2769
  { IMAGE_GATHER4_O_V2_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2770
  { IMAGE_GATHER4_O_V2_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2771
  { IMAGE_GATHER4_O_V4_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2772
  { IMAGE_GATHER4_O_V4_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2773
  { IMAGE_GATHER4_O_V4_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2774
  { IMAGE_GATHER4_O_V5_V2, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2775
  { IMAGE_GATHER4_O_V5_V3, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2776
  { IMAGE_GATHER4_O_V5_V4, IMAGE_GATHER4_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2777
  { IMAGE_GET_LOD_V1_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2778
  { IMAGE_GET_LOD_V1_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2779
  { IMAGE_GET_LOD_V1_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2780
  { IMAGE_GET_LOD_V1_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2781
  { IMAGE_GET_LOD_V2_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2782
  { IMAGE_GET_LOD_V2_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2783
  { IMAGE_GET_LOD_V2_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2784
  { IMAGE_GET_LOD_V2_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2785
  { IMAGE_GET_LOD_V3_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2786
  { IMAGE_GET_LOD_V3_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2787
  { IMAGE_GET_LOD_V3_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2788
  { IMAGE_GET_LOD_V3_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2789
  { IMAGE_GET_LOD_V4_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2790
  { IMAGE_GET_LOD_V4_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2791
  { IMAGE_GET_LOD_V4_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2792
  { IMAGE_GET_LOD_V4_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2793
  { IMAGE_GET_LOD_V5_V1_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2794
  { IMAGE_GET_LOD_V5_V2_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2795
  { IMAGE_GET_LOD_V5_V3_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2796
  { IMAGE_GET_LOD_V5_V4_gfx10, IMAGE_GET_LOD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2797
  { IMAGE_GET_LOD_V1_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2798
  { IMAGE_GET_LOD_V1_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2799
  { IMAGE_GET_LOD_V2_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2800
  { IMAGE_GET_LOD_V2_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2801
  { IMAGE_GET_LOD_V3_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2802
  { IMAGE_GET_LOD_V3_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2803
  { IMAGE_GET_LOD_V4_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2804
  { IMAGE_GET_LOD_V4_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2805
  { IMAGE_GET_LOD_V5_V2_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2806
  { IMAGE_GET_LOD_V5_V3_nsa_gfx10, IMAGE_GET_LOD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2807
  { IMAGE_GET_LOD_V1_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2808
  { IMAGE_GET_LOD_V1_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2809
  { IMAGE_GET_LOD_V1_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2810
  { IMAGE_GET_LOD_V1_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2811
  { IMAGE_GET_LOD_V2_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2812
  { IMAGE_GET_LOD_V2_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2813
  { IMAGE_GET_LOD_V2_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2814
  { IMAGE_GET_LOD_V2_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2815
  { IMAGE_GET_LOD_V3_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2816
  { IMAGE_GET_LOD_V3_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2817
  { IMAGE_GET_LOD_V3_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2818
  { IMAGE_GET_LOD_V3_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2819
  { IMAGE_GET_LOD_V4_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2820
  { IMAGE_GET_LOD_V4_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2821
  { IMAGE_GET_LOD_V4_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2822
  { IMAGE_GET_LOD_V4_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2823
  { IMAGE_GET_LOD_V5_V1_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2824
  { IMAGE_GET_LOD_V5_V2_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2825
  { IMAGE_GET_LOD_V5_V3_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2826
  { IMAGE_GET_LOD_V5_V4_gfx11, IMAGE_GET_LOD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2827
  { IMAGE_GET_LOD_V1_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2828
  { IMAGE_GET_LOD_V1_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2829
  { IMAGE_GET_LOD_V2_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2830
  { IMAGE_GET_LOD_V2_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2831
  { IMAGE_GET_LOD_V3_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2832
  { IMAGE_GET_LOD_V3_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2833
  { IMAGE_GET_LOD_V4_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2834
  { IMAGE_GET_LOD_V4_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2835
  { IMAGE_GET_LOD_V5_V2_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2836
  { IMAGE_GET_LOD_V5_V3_nsa_gfx11, IMAGE_GET_LOD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2837
  { IMAGE_GET_LOD_V1_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2838
  { IMAGE_GET_LOD_V1_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2839
  { IMAGE_GET_LOD_V1_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2840
  { IMAGE_GET_LOD_V2_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2841
  { IMAGE_GET_LOD_V2_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2842
  { IMAGE_GET_LOD_V2_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2843
  { IMAGE_GET_LOD_V3_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2844
  { IMAGE_GET_LOD_V3_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2845
  { IMAGE_GET_LOD_V3_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2846
  { IMAGE_GET_LOD_V4_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2847
  { IMAGE_GET_LOD_V4_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2848
  { IMAGE_GET_LOD_V4_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2849
  { IMAGE_GET_LOD_V5_V1_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2850
  { IMAGE_GET_LOD_V5_V2_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2851
  { IMAGE_GET_LOD_V5_V3_gfx12, IMAGE_GET_LOD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2852
  { IMAGE_GET_LOD_V1_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2853
  { IMAGE_GET_LOD_V1_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2854
  { IMAGE_GET_LOD_V1_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2855
  { IMAGE_GET_LOD_V1_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2856
  { IMAGE_GET_LOD_V2_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2857
  { IMAGE_GET_LOD_V2_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2858
  { IMAGE_GET_LOD_V2_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2859
  { IMAGE_GET_LOD_V2_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2860
  { IMAGE_GET_LOD_V3_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2861
  { IMAGE_GET_LOD_V3_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2862
  { IMAGE_GET_LOD_V3_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2863
  { IMAGE_GET_LOD_V3_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2864
  { IMAGE_GET_LOD_V4_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2865
  { IMAGE_GET_LOD_V4_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2866
  { IMAGE_GET_LOD_V4_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2867
  { IMAGE_GET_LOD_V4_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2868
  { IMAGE_GET_LOD_V5_V1, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2869
  { IMAGE_GET_LOD_V5_V2, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 2870
  { IMAGE_GET_LOD_V5_V3, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 2871
  { IMAGE_GET_LOD_V5_V4, IMAGE_GET_LOD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 2872
  { IMAGE_GET_LOD_V1_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 2873
  { IMAGE_GET_LOD_V1_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 2874
  { IMAGE_GET_LOD_V1_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 2875
  { IMAGE_GET_LOD_V1_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 2876
  { IMAGE_GET_LOD_V2_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 2877
  { IMAGE_GET_LOD_V2_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 2878
  { IMAGE_GET_LOD_V2_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 2879
  { IMAGE_GET_LOD_V2_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 2880
  { IMAGE_GET_LOD_V3_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 2881
  { IMAGE_GET_LOD_V3_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 2882
  { IMAGE_GET_LOD_V3_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 2883
  { IMAGE_GET_LOD_V3_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 2884
  { IMAGE_GET_LOD_V4_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 2885
  { IMAGE_GET_LOD_V4_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 2886
  { IMAGE_GET_LOD_V4_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 2887
  { IMAGE_GET_LOD_V4_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 2888
  { IMAGE_GET_LOD_V5_V1_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 2889
  { IMAGE_GET_LOD_V5_V2_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 2890
  { IMAGE_GET_LOD_V5_V3_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 2891
  { IMAGE_GET_LOD_V5_V4_gfx90a, IMAGE_GET_LOD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 2892
  { IMAGE_GET_RESINFO_V1_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 2893
  { IMAGE_GET_RESINFO_V1_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 2894
  { IMAGE_GET_RESINFO_V1_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 2895
  { IMAGE_GET_RESINFO_V1_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 2896
  { IMAGE_GET_RESINFO_V2_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 2897
  { IMAGE_GET_RESINFO_V2_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 2898
  { IMAGE_GET_RESINFO_V2_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 2899
  { IMAGE_GET_RESINFO_V2_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 2900
  { IMAGE_GET_RESINFO_V3_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 2901
  { IMAGE_GET_RESINFO_V3_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 2902
  { IMAGE_GET_RESINFO_V3_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 2903
  { IMAGE_GET_RESINFO_V3_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 2904
  { IMAGE_GET_RESINFO_V4_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 2905
  { IMAGE_GET_RESINFO_V4_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 2906
  { IMAGE_GET_RESINFO_V4_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 2907
  { IMAGE_GET_RESINFO_V4_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 2908
  { IMAGE_GET_RESINFO_V5_V1_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 2909
  { IMAGE_GET_RESINFO_V5_V2_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 2910
  { IMAGE_GET_RESINFO_V5_V3_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 2911
  { IMAGE_GET_RESINFO_V5_V4_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 2912
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 2913
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 2914
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 2915
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 2916
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 2917
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 2918
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 2919
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 2920
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 2921
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 2922
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 2923
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 2924
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 2925
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 2926
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx10, IMAGE_GET_RESINFO, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 2927
  { IMAGE_GET_RESINFO_V1_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 2928
  { IMAGE_GET_RESINFO_V1_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 2929
  { IMAGE_GET_RESINFO_V1_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 2930
  { IMAGE_GET_RESINFO_V1_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 2931
  { IMAGE_GET_RESINFO_V2_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 2932
  { IMAGE_GET_RESINFO_V2_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 2933
  { IMAGE_GET_RESINFO_V2_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 2934
  { IMAGE_GET_RESINFO_V2_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 2935
  { IMAGE_GET_RESINFO_V3_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 2936
  { IMAGE_GET_RESINFO_V3_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 2937
  { IMAGE_GET_RESINFO_V3_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 2938
  { IMAGE_GET_RESINFO_V3_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 2939
  { IMAGE_GET_RESINFO_V4_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 2940
  { IMAGE_GET_RESINFO_V4_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 2941
  { IMAGE_GET_RESINFO_V4_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 2942
  { IMAGE_GET_RESINFO_V4_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 2943
  { IMAGE_GET_RESINFO_V5_V1_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 2944
  { IMAGE_GET_RESINFO_V5_V2_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 2945
  { IMAGE_GET_RESINFO_V5_V3_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 2946
  { IMAGE_GET_RESINFO_V5_V4_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 2947
  { IMAGE_GET_RESINFO_V1_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 2948
  { IMAGE_GET_RESINFO_V1_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 2949
  { IMAGE_GET_RESINFO_V1_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 2950
  { IMAGE_GET_RESINFO_V2_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 2951
  { IMAGE_GET_RESINFO_V2_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 2952
  { IMAGE_GET_RESINFO_V2_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 2953
  { IMAGE_GET_RESINFO_V3_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 2954
  { IMAGE_GET_RESINFO_V3_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 2955
  { IMAGE_GET_RESINFO_V3_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 2956
  { IMAGE_GET_RESINFO_V4_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 2957
  { IMAGE_GET_RESINFO_V4_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 2958
  { IMAGE_GET_RESINFO_V4_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 2959
  { IMAGE_GET_RESINFO_V5_V2_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 2960
  { IMAGE_GET_RESINFO_V5_V3_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 2961
  { IMAGE_GET_RESINFO_V5_V4_nsa_gfx11, IMAGE_GET_RESINFO, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 2962
  { IMAGE_GET_RESINFO_V1_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 2963
  { IMAGE_GET_RESINFO_V1_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 2964
  { IMAGE_GET_RESINFO_V1_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 2965
  { IMAGE_GET_RESINFO_V1_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 2966
  { IMAGE_GET_RESINFO_V2_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 2967
  { IMAGE_GET_RESINFO_V2_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 2968
  { IMAGE_GET_RESINFO_V2_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 2969
  { IMAGE_GET_RESINFO_V2_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 2970
  { IMAGE_GET_RESINFO_V3_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 2971
  { IMAGE_GET_RESINFO_V3_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 2972
  { IMAGE_GET_RESINFO_V3_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 2973
  { IMAGE_GET_RESINFO_V3_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 2974
  { IMAGE_GET_RESINFO_V4_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 2975
  { IMAGE_GET_RESINFO_V4_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 2976
  { IMAGE_GET_RESINFO_V4_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 2977
  { IMAGE_GET_RESINFO_V4_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 2978
  { IMAGE_GET_RESINFO_V5_V1_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 2979
  { IMAGE_GET_RESINFO_V5_V2_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 2980
  { IMAGE_GET_RESINFO_V5_V3_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 2981
  { IMAGE_GET_RESINFO_V5_V4_gfx12, IMAGE_GET_RESINFO, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 2982
  { IMAGE_GET_RESINFO_V1_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 2983
  { IMAGE_GET_RESINFO_V1_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 2984
  { IMAGE_GET_RESINFO_V1_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 2985
  { IMAGE_GET_RESINFO_V1_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 2986
  { IMAGE_GET_RESINFO_V2_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 2987
  { IMAGE_GET_RESINFO_V2_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 2988
  { IMAGE_GET_RESINFO_V2_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 2989
  { IMAGE_GET_RESINFO_V2_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 2990
  { IMAGE_GET_RESINFO_V3_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 2991
  { IMAGE_GET_RESINFO_V3_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 2992
  { IMAGE_GET_RESINFO_V3_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 2993
  { IMAGE_GET_RESINFO_V3_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 2994
  { IMAGE_GET_RESINFO_V4_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 2995
  { IMAGE_GET_RESINFO_V4_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 2996
  { IMAGE_GET_RESINFO_V4_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 2997
  { IMAGE_GET_RESINFO_V4_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 2998
  { IMAGE_GET_RESINFO_V5_V1, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 2999
  { IMAGE_GET_RESINFO_V5_V2, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3000
  { IMAGE_GET_RESINFO_V5_V3, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3001
  { IMAGE_GET_RESINFO_V5_V4, IMAGE_GET_RESINFO, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3002
  { IMAGE_GET_RESINFO_V1_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3003
  { IMAGE_GET_RESINFO_V1_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3004
  { IMAGE_GET_RESINFO_V1_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3005
  { IMAGE_GET_RESINFO_V1_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3006
  { IMAGE_GET_RESINFO_V2_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3007
  { IMAGE_GET_RESINFO_V2_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3008
  { IMAGE_GET_RESINFO_V2_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3009
  { IMAGE_GET_RESINFO_V2_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3010
  { IMAGE_GET_RESINFO_V3_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3011
  { IMAGE_GET_RESINFO_V3_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3012
  { IMAGE_GET_RESINFO_V3_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3013
  { IMAGE_GET_RESINFO_V3_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3014
  { IMAGE_GET_RESINFO_V4_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3015
  { IMAGE_GET_RESINFO_V4_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3016
  { IMAGE_GET_RESINFO_V4_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3017
  { IMAGE_GET_RESINFO_V4_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3018
  { IMAGE_GET_RESINFO_V5_V1_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3019
  { IMAGE_GET_RESINFO_V5_V2_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3020
  { IMAGE_GET_RESINFO_V5_V3_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3021
  { IMAGE_GET_RESINFO_V5_V4_gfx90a, IMAGE_GET_RESINFO, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3022
  { IMAGE_LOAD_V1_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3023
  { IMAGE_LOAD_V1_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3024
  { IMAGE_LOAD_V1_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3025
  { IMAGE_LOAD_V1_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3026
  { IMAGE_LOAD_V2_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3027
  { IMAGE_LOAD_V2_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3028
  { IMAGE_LOAD_V2_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3029
  { IMAGE_LOAD_V2_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3030
  { IMAGE_LOAD_V3_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3031
  { IMAGE_LOAD_V3_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3032
  { IMAGE_LOAD_V3_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3033
  { IMAGE_LOAD_V3_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3034
  { IMAGE_LOAD_V4_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3035
  { IMAGE_LOAD_V4_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3036
  { IMAGE_LOAD_V4_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3037
  { IMAGE_LOAD_V4_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3038
  { IMAGE_LOAD_V5_V1_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3039
  { IMAGE_LOAD_V5_V2_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3040
  { IMAGE_LOAD_V5_V3_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3041
  { IMAGE_LOAD_V5_V4_gfx10, IMAGE_LOAD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3042
  { IMAGE_LOAD_V1_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3043
  { IMAGE_LOAD_V1_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3044
  { IMAGE_LOAD_V1_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3045
  { IMAGE_LOAD_V2_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3046
  { IMAGE_LOAD_V2_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3047
  { IMAGE_LOAD_V2_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3048
  { IMAGE_LOAD_V3_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3049
  { IMAGE_LOAD_V3_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3050
  { IMAGE_LOAD_V3_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3051
  { IMAGE_LOAD_V4_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3052
  { IMAGE_LOAD_V4_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3053
  { IMAGE_LOAD_V4_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3054
  { IMAGE_LOAD_V5_V2_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3055
  { IMAGE_LOAD_V5_V3_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3056
  { IMAGE_LOAD_V5_V4_nsa_gfx10, IMAGE_LOAD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3057
  { IMAGE_LOAD_V1_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3058
  { IMAGE_LOAD_V1_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3059
  { IMAGE_LOAD_V1_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3060
  { IMAGE_LOAD_V1_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3061
  { IMAGE_LOAD_V2_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3062
  { IMAGE_LOAD_V2_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3063
  { IMAGE_LOAD_V2_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3064
  { IMAGE_LOAD_V2_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3065
  { IMAGE_LOAD_V3_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3066
  { IMAGE_LOAD_V3_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3067
  { IMAGE_LOAD_V3_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3068
  { IMAGE_LOAD_V3_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3069
  { IMAGE_LOAD_V4_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3070
  { IMAGE_LOAD_V4_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3071
  { IMAGE_LOAD_V4_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3072
  { IMAGE_LOAD_V4_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3073
  { IMAGE_LOAD_V5_V1_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3074
  { IMAGE_LOAD_V5_V2_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3075
  { IMAGE_LOAD_V5_V3_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3076
  { IMAGE_LOAD_V5_V4_gfx11, IMAGE_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3077
  { IMAGE_LOAD_V1_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3078
  { IMAGE_LOAD_V1_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3079
  { IMAGE_LOAD_V1_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3080
  { IMAGE_LOAD_V2_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3081
  { IMAGE_LOAD_V2_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3082
  { IMAGE_LOAD_V2_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3083
  { IMAGE_LOAD_V3_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3084
  { IMAGE_LOAD_V3_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3085
  { IMAGE_LOAD_V3_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3086
  { IMAGE_LOAD_V4_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3087
  { IMAGE_LOAD_V4_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3088
  { IMAGE_LOAD_V4_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3089
  { IMAGE_LOAD_V5_V2_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3090
  { IMAGE_LOAD_V5_V3_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3091
  { IMAGE_LOAD_V5_V4_nsa_gfx11, IMAGE_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3092
  { IMAGE_LOAD_V1_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3093
  { IMAGE_LOAD_V1_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3094
  { IMAGE_LOAD_V1_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3095
  { IMAGE_LOAD_V1_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3096
  { IMAGE_LOAD_V2_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3097
  { IMAGE_LOAD_V2_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3098
  { IMAGE_LOAD_V2_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3099
  { IMAGE_LOAD_V2_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3100
  { IMAGE_LOAD_V3_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3101
  { IMAGE_LOAD_V3_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3102
  { IMAGE_LOAD_V3_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3103
  { IMAGE_LOAD_V3_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3104
  { IMAGE_LOAD_V4_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3105
  { IMAGE_LOAD_V4_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3106
  { IMAGE_LOAD_V4_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3107
  { IMAGE_LOAD_V4_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3108
  { IMAGE_LOAD_V5_V1_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3109
  { IMAGE_LOAD_V5_V2_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3110
  { IMAGE_LOAD_V5_V3_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3111
  { IMAGE_LOAD_V5_V4_gfx12, IMAGE_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3112
  { IMAGE_LOAD_V1_V1, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3113
  { IMAGE_LOAD_V1_V2, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3114
  { IMAGE_LOAD_V1_V3, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3115
  { IMAGE_LOAD_V1_V4, IMAGE_LOAD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3116
  { IMAGE_LOAD_V2_V1, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3117
  { IMAGE_LOAD_V2_V2, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3118
  { IMAGE_LOAD_V2_V3, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3119
  { IMAGE_LOAD_V2_V4, IMAGE_LOAD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3120
  { IMAGE_LOAD_V3_V1, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3121
  { IMAGE_LOAD_V3_V2, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3122
  { IMAGE_LOAD_V3_V3, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3123
  { IMAGE_LOAD_V3_V4, IMAGE_LOAD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3124
  { IMAGE_LOAD_V4_V1, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3125
  { IMAGE_LOAD_V4_V2, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3126
  { IMAGE_LOAD_V4_V3, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3127
  { IMAGE_LOAD_V4_V4, IMAGE_LOAD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3128
  { IMAGE_LOAD_V5_V1, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3129
  { IMAGE_LOAD_V5_V2, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3130
  { IMAGE_LOAD_V5_V3, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3131
  { IMAGE_LOAD_V5_V4, IMAGE_LOAD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3132
  { IMAGE_LOAD_V1_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3133
  { IMAGE_LOAD_V1_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3134
  { IMAGE_LOAD_V1_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3135
  { IMAGE_LOAD_V1_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3136
  { IMAGE_LOAD_V2_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3137
  { IMAGE_LOAD_V2_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3138
  { IMAGE_LOAD_V2_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3139
  { IMAGE_LOAD_V2_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3140
  { IMAGE_LOAD_V3_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3141
  { IMAGE_LOAD_V3_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3142
  { IMAGE_LOAD_V3_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3143
  { IMAGE_LOAD_V3_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3144
  { IMAGE_LOAD_V4_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3145
  { IMAGE_LOAD_V4_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3146
  { IMAGE_LOAD_V4_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3147
  { IMAGE_LOAD_V4_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3148
  { IMAGE_LOAD_V5_V1_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3149
  { IMAGE_LOAD_V5_V2_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3150
  { IMAGE_LOAD_V5_V3_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3151
  { IMAGE_LOAD_V5_V4_gfx90a, IMAGE_LOAD, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3152
  { IMAGE_LOAD_MIP_V1_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3153
  { IMAGE_LOAD_MIP_V1_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3154
  { IMAGE_LOAD_MIP_V1_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3155
  { IMAGE_LOAD_MIP_V1_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3156
  { IMAGE_LOAD_MIP_V2_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3157
  { IMAGE_LOAD_MIP_V2_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3158
  { IMAGE_LOAD_MIP_V2_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3159
  { IMAGE_LOAD_MIP_V2_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3160
  { IMAGE_LOAD_MIP_V3_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3161
  { IMAGE_LOAD_MIP_V3_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3162
  { IMAGE_LOAD_MIP_V3_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3163
  { IMAGE_LOAD_MIP_V3_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3164
  { IMAGE_LOAD_MIP_V4_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3165
  { IMAGE_LOAD_MIP_V4_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3166
  { IMAGE_LOAD_MIP_V4_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3167
  { IMAGE_LOAD_MIP_V4_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3168
  { IMAGE_LOAD_MIP_V5_V1_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3169
  { IMAGE_LOAD_MIP_V5_V2_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3170
  { IMAGE_LOAD_MIP_V5_V3_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3171
  { IMAGE_LOAD_MIP_V5_V4_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3172
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3173
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3174
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3175
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3176
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3177
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3178
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3179
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3180
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3181
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3182
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3183
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3184
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3185
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3186
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3187
  { IMAGE_LOAD_MIP_V1_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3188
  { IMAGE_LOAD_MIP_V1_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3189
  { IMAGE_LOAD_MIP_V1_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3190
  { IMAGE_LOAD_MIP_V1_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3191
  { IMAGE_LOAD_MIP_V2_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3192
  { IMAGE_LOAD_MIP_V2_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3193
  { IMAGE_LOAD_MIP_V2_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3194
  { IMAGE_LOAD_MIP_V2_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3195
  { IMAGE_LOAD_MIP_V3_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3196
  { IMAGE_LOAD_MIP_V3_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3197
  { IMAGE_LOAD_MIP_V3_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3198
  { IMAGE_LOAD_MIP_V3_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3199
  { IMAGE_LOAD_MIP_V4_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3200
  { IMAGE_LOAD_MIP_V4_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3201
  { IMAGE_LOAD_MIP_V4_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3202
  { IMAGE_LOAD_MIP_V4_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3203
  { IMAGE_LOAD_MIP_V5_V1_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3204
  { IMAGE_LOAD_MIP_V5_V2_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3205
  { IMAGE_LOAD_MIP_V5_V3_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3206
  { IMAGE_LOAD_MIP_V5_V4_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3207
  { IMAGE_LOAD_MIP_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3208
  { IMAGE_LOAD_MIP_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3209
  { IMAGE_LOAD_MIP_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3210
  { IMAGE_LOAD_MIP_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3211
  { IMAGE_LOAD_MIP_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3212
  { IMAGE_LOAD_MIP_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3213
  { IMAGE_LOAD_MIP_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3214
  { IMAGE_LOAD_MIP_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3215
  { IMAGE_LOAD_MIP_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3216
  { IMAGE_LOAD_MIP_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3217
  { IMAGE_LOAD_MIP_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3218
  { IMAGE_LOAD_MIP_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3219
  { IMAGE_LOAD_MIP_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3220
  { IMAGE_LOAD_MIP_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3221
  { IMAGE_LOAD_MIP_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3222
  { IMAGE_LOAD_MIP_V1_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3223
  { IMAGE_LOAD_MIP_V1_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3224
  { IMAGE_LOAD_MIP_V1_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3225
  { IMAGE_LOAD_MIP_V1_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3226
  { IMAGE_LOAD_MIP_V2_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3227
  { IMAGE_LOAD_MIP_V2_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3228
  { IMAGE_LOAD_MIP_V2_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3229
  { IMAGE_LOAD_MIP_V2_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3230
  { IMAGE_LOAD_MIP_V3_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3231
  { IMAGE_LOAD_MIP_V3_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3232
  { IMAGE_LOAD_MIP_V3_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3233
  { IMAGE_LOAD_MIP_V3_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3234
  { IMAGE_LOAD_MIP_V4_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3235
  { IMAGE_LOAD_MIP_V4_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3236
  { IMAGE_LOAD_MIP_V4_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3237
  { IMAGE_LOAD_MIP_V4_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3238
  { IMAGE_LOAD_MIP_V5_V1_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3239
  { IMAGE_LOAD_MIP_V5_V2_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3240
  { IMAGE_LOAD_MIP_V5_V3_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3241
  { IMAGE_LOAD_MIP_V5_V4_gfx12, IMAGE_LOAD_MIP, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3242
  { IMAGE_LOAD_MIP_V1_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3243
  { IMAGE_LOAD_MIP_V1_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3244
  { IMAGE_LOAD_MIP_V1_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3245
  { IMAGE_LOAD_MIP_V1_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3246
  { IMAGE_LOAD_MIP_V2_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3247
  { IMAGE_LOAD_MIP_V2_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3248
  { IMAGE_LOAD_MIP_V2_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3249
  { IMAGE_LOAD_MIP_V2_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3250
  { IMAGE_LOAD_MIP_V3_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3251
  { IMAGE_LOAD_MIP_V3_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3252
  { IMAGE_LOAD_MIP_V3_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3253
  { IMAGE_LOAD_MIP_V3_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3254
  { IMAGE_LOAD_MIP_V4_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3255
  { IMAGE_LOAD_MIP_V4_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3256
  { IMAGE_LOAD_MIP_V4_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3257
  { IMAGE_LOAD_MIP_V4_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3258
  { IMAGE_LOAD_MIP_V5_V1, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3259
  { IMAGE_LOAD_MIP_V5_V2, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3260
  { IMAGE_LOAD_MIP_V5_V3, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3261
  { IMAGE_LOAD_MIP_V5_V4, IMAGE_LOAD_MIP, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3262
  { IMAGE_LOAD_MIP_V1_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3263
  { IMAGE_LOAD_MIP_V1_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3264
  { IMAGE_LOAD_MIP_V1_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3265
  { IMAGE_LOAD_MIP_V1_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3266
  { IMAGE_LOAD_MIP_V2_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3267
  { IMAGE_LOAD_MIP_V2_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3268
  { IMAGE_LOAD_MIP_V2_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3269
  { IMAGE_LOAD_MIP_V2_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3270
  { IMAGE_LOAD_MIP_V3_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3271
  { IMAGE_LOAD_MIP_V3_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3272
  { IMAGE_LOAD_MIP_V3_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3273
  { IMAGE_LOAD_MIP_V3_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3274
  { IMAGE_LOAD_MIP_V4_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3275
  { IMAGE_LOAD_MIP_V4_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3276
  { IMAGE_LOAD_MIP_V4_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3277
  { IMAGE_LOAD_MIP_V4_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3278
  { IMAGE_LOAD_MIP_V5_V1_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3279
  { IMAGE_LOAD_MIP_V5_V2_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3280
  { IMAGE_LOAD_MIP_V5_V3_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3281
  { IMAGE_LOAD_MIP_V5_V4_gfx90a, IMAGE_LOAD_MIP, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3282
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3283
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3284
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3285
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3286
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3287
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3288
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3289
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3290
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3291
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3292
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3293
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3294
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3295
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3296
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3297
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3298
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3299
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3300
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3301
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3302
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3303
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3304
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3305
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3306
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3307
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3308
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3309
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3310
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3311
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3312
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3313
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3314
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3315
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3316
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3317
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3318
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3319
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3320
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3321
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3322
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3323
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3324
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3325
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3326
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3327
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3328
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3329
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3330
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3331
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3332
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3333
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3334
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3335
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3336
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3337
  { IMAGE_LOAD_MIP_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3338
  { IMAGE_LOAD_MIP_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3339
  { IMAGE_LOAD_MIP_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3340
  { IMAGE_LOAD_MIP_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3341
  { IMAGE_LOAD_MIP_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3342
  { IMAGE_LOAD_MIP_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3343
  { IMAGE_LOAD_MIP_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3344
  { IMAGE_LOAD_MIP_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3345
  { IMAGE_LOAD_MIP_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3346
  { IMAGE_LOAD_MIP_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3347
  { IMAGE_LOAD_MIP_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3348
  { IMAGE_LOAD_MIP_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3349
  { IMAGE_LOAD_MIP_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3350
  { IMAGE_LOAD_MIP_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3351
  { IMAGE_LOAD_MIP_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3352
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3353
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3354
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3355
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3356
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3357
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3358
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3359
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3360
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3361
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3362
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3363
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3364
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3365
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3366
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3367
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3368
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3369
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3370
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3371
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3372
  { IMAGE_LOAD_MIP_PCK_V1_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3373
  { IMAGE_LOAD_MIP_PCK_V1_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3374
  { IMAGE_LOAD_MIP_PCK_V1_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3375
  { IMAGE_LOAD_MIP_PCK_V1_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3376
  { IMAGE_LOAD_MIP_PCK_V2_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3377
  { IMAGE_LOAD_MIP_PCK_V2_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3378
  { IMAGE_LOAD_MIP_PCK_V2_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3379
  { IMAGE_LOAD_MIP_PCK_V2_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3380
  { IMAGE_LOAD_MIP_PCK_V3_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3381
  { IMAGE_LOAD_MIP_PCK_V3_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3382
  { IMAGE_LOAD_MIP_PCK_V3_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3383
  { IMAGE_LOAD_MIP_PCK_V3_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3384
  { IMAGE_LOAD_MIP_PCK_V4_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3385
  { IMAGE_LOAD_MIP_PCK_V4_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3386
  { IMAGE_LOAD_MIP_PCK_V4_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3387
  { IMAGE_LOAD_MIP_PCK_V4_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3388
  { IMAGE_LOAD_MIP_PCK_V5_V1, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3389
  { IMAGE_LOAD_MIP_PCK_V5_V2, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3390
  { IMAGE_LOAD_MIP_PCK_V5_V3, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3391
  { IMAGE_LOAD_MIP_PCK_V5_V4, IMAGE_LOAD_MIP_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3392
  { IMAGE_LOAD_MIP_PCK_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3393
  { IMAGE_LOAD_MIP_PCK_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3394
  { IMAGE_LOAD_MIP_PCK_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3395
  { IMAGE_LOAD_MIP_PCK_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3396
  { IMAGE_LOAD_MIP_PCK_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3397
  { IMAGE_LOAD_MIP_PCK_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3398
  { IMAGE_LOAD_MIP_PCK_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3399
  { IMAGE_LOAD_MIP_PCK_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3400
  { IMAGE_LOAD_MIP_PCK_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3401
  { IMAGE_LOAD_MIP_PCK_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3402
  { IMAGE_LOAD_MIP_PCK_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3403
  { IMAGE_LOAD_MIP_PCK_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3404
  { IMAGE_LOAD_MIP_PCK_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3405
  { IMAGE_LOAD_MIP_PCK_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3406
  { IMAGE_LOAD_MIP_PCK_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3407
  { IMAGE_LOAD_MIP_PCK_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3408
  { IMAGE_LOAD_MIP_PCK_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3409
  { IMAGE_LOAD_MIP_PCK_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3410
  { IMAGE_LOAD_MIP_PCK_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3411
  { IMAGE_LOAD_MIP_PCK_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3412
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3413
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3414
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3415
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3416
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3417
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3418
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3419
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3420
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3421
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3422
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3423
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3424
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3425
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3426
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3427
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3428
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3429
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3430
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3431
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3432
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3433
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3434
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3435
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3436
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3437
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3438
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3439
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3440
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3441
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3442
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3443
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3444
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3445
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3446
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3447
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3448
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3449
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3450
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3451
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3452
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3453
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3454
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3455
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3456
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3457
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3458
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3459
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3460
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3461
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3462
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3463
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3464
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3465
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3466
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3467
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3468
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3469
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3470
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3471
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3472
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3473
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3474
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3475
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3476
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3477
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3478
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3479
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3480
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3481
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3482
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3483
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3484
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3485
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3486
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3487
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3488
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3489
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3490
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3491
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3492
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3493
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3494
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3495
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3496
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3497
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3498
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3499
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3500
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3501
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3502
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3503
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3504
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3505
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3506
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3507
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3508
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3509
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3510
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3511
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3512
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3513
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3514
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3515
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3516
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3517
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3518
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3519
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3520
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3521
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3522
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3523
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3524
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3525
  { IMAGE_LOAD_MIP_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3526
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3527
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3528
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3529
  { IMAGE_LOAD_MIP_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3530
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3531
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3532
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3533
  { IMAGE_LOAD_MIP_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3534
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3535
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3536
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3537
  { IMAGE_LOAD_MIP_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3538
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3539
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3540
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3541
  { IMAGE_LOAD_MIP_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_MIP_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3542
  { IMAGE_LOAD_PCK_V1_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3543
  { IMAGE_LOAD_PCK_V1_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3544
  { IMAGE_LOAD_PCK_V1_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3545
  { IMAGE_LOAD_PCK_V1_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3546
  { IMAGE_LOAD_PCK_V2_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3547
  { IMAGE_LOAD_PCK_V2_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3548
  { IMAGE_LOAD_PCK_V2_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3549
  { IMAGE_LOAD_PCK_V2_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3550
  { IMAGE_LOAD_PCK_V3_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3551
  { IMAGE_LOAD_PCK_V3_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3552
  { IMAGE_LOAD_PCK_V3_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3553
  { IMAGE_LOAD_PCK_V3_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3554
  { IMAGE_LOAD_PCK_V4_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3555
  { IMAGE_LOAD_PCK_V4_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3556
  { IMAGE_LOAD_PCK_V4_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3557
  { IMAGE_LOAD_PCK_V4_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3558
  { IMAGE_LOAD_PCK_V5_V1_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3559
  { IMAGE_LOAD_PCK_V5_V2_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3560
  { IMAGE_LOAD_PCK_V5_V3_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3561
  { IMAGE_LOAD_PCK_V5_V4_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3562
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3563
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3564
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3565
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3566
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3567
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3568
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3569
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3570
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3571
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3572
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3573
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3574
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3575
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3576
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3577
  { IMAGE_LOAD_PCK_V1_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3578
  { IMAGE_LOAD_PCK_V1_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3579
  { IMAGE_LOAD_PCK_V1_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3580
  { IMAGE_LOAD_PCK_V1_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3581
  { IMAGE_LOAD_PCK_V2_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3582
  { IMAGE_LOAD_PCK_V2_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3583
  { IMAGE_LOAD_PCK_V2_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3584
  { IMAGE_LOAD_PCK_V2_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3585
  { IMAGE_LOAD_PCK_V3_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3586
  { IMAGE_LOAD_PCK_V3_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3587
  { IMAGE_LOAD_PCK_V3_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3588
  { IMAGE_LOAD_PCK_V3_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3589
  { IMAGE_LOAD_PCK_V4_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3590
  { IMAGE_LOAD_PCK_V4_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3591
  { IMAGE_LOAD_PCK_V4_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3592
  { IMAGE_LOAD_PCK_V4_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3593
  { IMAGE_LOAD_PCK_V5_V1_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3594
  { IMAGE_LOAD_PCK_V5_V2_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3595
  { IMAGE_LOAD_PCK_V5_V3_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3596
  { IMAGE_LOAD_PCK_V5_V4_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3597
  { IMAGE_LOAD_PCK_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3598
  { IMAGE_LOAD_PCK_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3599
  { IMAGE_LOAD_PCK_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3600
  { IMAGE_LOAD_PCK_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3601
  { IMAGE_LOAD_PCK_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3602
  { IMAGE_LOAD_PCK_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3603
  { IMAGE_LOAD_PCK_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3604
  { IMAGE_LOAD_PCK_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3605
  { IMAGE_LOAD_PCK_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3606
  { IMAGE_LOAD_PCK_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3607
  { IMAGE_LOAD_PCK_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3608
  { IMAGE_LOAD_PCK_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3609
  { IMAGE_LOAD_PCK_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3610
  { IMAGE_LOAD_PCK_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3611
  { IMAGE_LOAD_PCK_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3612
  { IMAGE_LOAD_PCK_V1_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3613
  { IMAGE_LOAD_PCK_V1_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3614
  { IMAGE_LOAD_PCK_V1_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3615
  { IMAGE_LOAD_PCK_V1_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3616
  { IMAGE_LOAD_PCK_V2_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3617
  { IMAGE_LOAD_PCK_V2_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3618
  { IMAGE_LOAD_PCK_V2_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3619
  { IMAGE_LOAD_PCK_V2_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3620
  { IMAGE_LOAD_PCK_V3_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3621
  { IMAGE_LOAD_PCK_V3_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3622
  { IMAGE_LOAD_PCK_V3_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3623
  { IMAGE_LOAD_PCK_V3_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3624
  { IMAGE_LOAD_PCK_V4_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3625
  { IMAGE_LOAD_PCK_V4_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3626
  { IMAGE_LOAD_PCK_V4_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3627
  { IMAGE_LOAD_PCK_V4_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3628
  { IMAGE_LOAD_PCK_V5_V1_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3629
  { IMAGE_LOAD_PCK_V5_V2_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3630
  { IMAGE_LOAD_PCK_V5_V3_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3631
  { IMAGE_LOAD_PCK_V5_V4_gfx12, IMAGE_LOAD_PCK, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3632
  { IMAGE_LOAD_PCK_V1_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3633
  { IMAGE_LOAD_PCK_V1_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3634
  { IMAGE_LOAD_PCK_V1_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3635
  { IMAGE_LOAD_PCK_V1_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3636
  { IMAGE_LOAD_PCK_V2_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3637
  { IMAGE_LOAD_PCK_V2_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3638
  { IMAGE_LOAD_PCK_V2_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3639
  { IMAGE_LOAD_PCK_V2_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3640
  { IMAGE_LOAD_PCK_V3_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3641
  { IMAGE_LOAD_PCK_V3_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3642
  { IMAGE_LOAD_PCK_V3_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3643
  { IMAGE_LOAD_PCK_V3_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3644
  { IMAGE_LOAD_PCK_V4_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3645
  { IMAGE_LOAD_PCK_V4_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3646
  { IMAGE_LOAD_PCK_V4_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3647
  { IMAGE_LOAD_PCK_V4_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3648
  { IMAGE_LOAD_PCK_V5_V1, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3649
  { IMAGE_LOAD_PCK_V5_V2, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3650
  { IMAGE_LOAD_PCK_V5_V3, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3651
  { IMAGE_LOAD_PCK_V5_V4, IMAGE_LOAD_PCK, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3652
  { IMAGE_LOAD_PCK_V1_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3653
  { IMAGE_LOAD_PCK_V1_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3654
  { IMAGE_LOAD_PCK_V1_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3655
  { IMAGE_LOAD_PCK_V1_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3656
  { IMAGE_LOAD_PCK_V2_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3657
  { IMAGE_LOAD_PCK_V2_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3658
  { IMAGE_LOAD_PCK_V2_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3659
  { IMAGE_LOAD_PCK_V2_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3660
  { IMAGE_LOAD_PCK_V3_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3661
  { IMAGE_LOAD_PCK_V3_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3662
  { IMAGE_LOAD_PCK_V3_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3663
  { IMAGE_LOAD_PCK_V3_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3664
  { IMAGE_LOAD_PCK_V4_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3665
  { IMAGE_LOAD_PCK_V4_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3666
  { IMAGE_LOAD_PCK_V4_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3667
  { IMAGE_LOAD_PCK_V4_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3668
  { IMAGE_LOAD_PCK_V5_V1_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3669
  { IMAGE_LOAD_PCK_V5_V2_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3670
  { IMAGE_LOAD_PCK_V5_V3_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3671
  { IMAGE_LOAD_PCK_V5_V4_gfx90a, IMAGE_LOAD_PCK, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3672
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3673
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3674
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3675
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3676
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3677
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3678
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3679
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3680
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3681
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3682
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3683
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3684
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3685
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3686
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3687
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3688
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3689
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3690
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3691
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3692
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3693
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3694
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3695
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3696
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3697
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3698
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3699
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3700
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3701
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3702
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3703
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3704
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3705
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3706
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx10, IMAGE_LOAD_PCK_SGN, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3707
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3708
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3709
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3710
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3711
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3712
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3713
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3714
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3715
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3716
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3717
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3718
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3719
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3720
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3721
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3722
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3723
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3724
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3725
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3726
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3727
  { IMAGE_LOAD_PCK_SGN_V1_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3728
  { IMAGE_LOAD_PCK_SGN_V1_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3729
  { IMAGE_LOAD_PCK_SGN_V1_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 3730
  { IMAGE_LOAD_PCK_SGN_V2_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3731
  { IMAGE_LOAD_PCK_SGN_V2_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3732
  { IMAGE_LOAD_PCK_SGN_V2_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3733
  { IMAGE_LOAD_PCK_SGN_V3_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3734
  { IMAGE_LOAD_PCK_SGN_V3_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3735
  { IMAGE_LOAD_PCK_SGN_V3_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3736
  { IMAGE_LOAD_PCK_SGN_V4_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3737
  { IMAGE_LOAD_PCK_SGN_V4_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3738
  { IMAGE_LOAD_PCK_SGN_V4_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3739
  { IMAGE_LOAD_PCK_SGN_V5_V2_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3740
  { IMAGE_LOAD_PCK_SGN_V5_V3_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3741
  { IMAGE_LOAD_PCK_SGN_V5_V4_nsa_gfx11, IMAGE_LOAD_PCK_SGN, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3742
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3743
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3744
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3745
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 3746
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3747
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3748
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3749
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3750
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3751
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3752
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3753
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3754
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3755
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3756
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3757
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3758
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3759
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3760
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3761
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx12, IMAGE_LOAD_PCK_SGN, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3762
  { IMAGE_LOAD_PCK_SGN_V1_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3763
  { IMAGE_LOAD_PCK_SGN_V1_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3764
  { IMAGE_LOAD_PCK_SGN_V1_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3765
  { IMAGE_LOAD_PCK_SGN_V1_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3766
  { IMAGE_LOAD_PCK_SGN_V2_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3767
  { IMAGE_LOAD_PCK_SGN_V2_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3768
  { IMAGE_LOAD_PCK_SGN_V2_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3769
  { IMAGE_LOAD_PCK_SGN_V2_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3770
  { IMAGE_LOAD_PCK_SGN_V3_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3771
  { IMAGE_LOAD_PCK_SGN_V3_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3772
  { IMAGE_LOAD_PCK_SGN_V3_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3773
  { IMAGE_LOAD_PCK_SGN_V3_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3774
  { IMAGE_LOAD_PCK_SGN_V4_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3775
  { IMAGE_LOAD_PCK_SGN_V4_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3776
  { IMAGE_LOAD_PCK_SGN_V4_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3777
  { IMAGE_LOAD_PCK_SGN_V4_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3778
  { IMAGE_LOAD_PCK_SGN_V5_V1, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3779
  { IMAGE_LOAD_PCK_SGN_V5_V2, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3780
  { IMAGE_LOAD_PCK_SGN_V5_V3, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3781
  { IMAGE_LOAD_PCK_SGN_V5_V4, IMAGE_LOAD_PCK_SGN, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3782
  { IMAGE_LOAD_PCK_SGN_V1_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3783
  { IMAGE_LOAD_PCK_SGN_V1_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3784
  { IMAGE_LOAD_PCK_SGN_V1_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3785
  { IMAGE_LOAD_PCK_SGN_V1_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 3786
  { IMAGE_LOAD_PCK_SGN_V2_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 3787
  { IMAGE_LOAD_PCK_SGN_V2_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 3788
  { IMAGE_LOAD_PCK_SGN_V2_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 3789
  { IMAGE_LOAD_PCK_SGN_V2_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 3790
  { IMAGE_LOAD_PCK_SGN_V3_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 3791
  { IMAGE_LOAD_PCK_SGN_V3_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 3792
  { IMAGE_LOAD_PCK_SGN_V3_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 3793
  { IMAGE_LOAD_PCK_SGN_V3_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 3794
  { IMAGE_LOAD_PCK_SGN_V4_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 3795
  { IMAGE_LOAD_PCK_SGN_V4_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 3796
  { IMAGE_LOAD_PCK_SGN_V4_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 3797
  { IMAGE_LOAD_PCK_SGN_V4_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 3798
  { IMAGE_LOAD_PCK_SGN_V5_V1_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 3799
  { IMAGE_LOAD_PCK_SGN_V5_V2_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 3800
  { IMAGE_LOAD_PCK_SGN_V5_V3_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 3801
  { IMAGE_LOAD_PCK_SGN_V5_V4_gfx90a, IMAGE_LOAD_PCK_SGN, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 3802
  { IMAGE_MSAA_LOAD_V2_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3803
  { IMAGE_MSAA_LOAD_V2_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3804
  { IMAGE_MSAA_LOAD_V2_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3805
  { IMAGE_MSAA_LOAD_V2_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3806
  { IMAGE_MSAA_LOAD_V3_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3807
  { IMAGE_MSAA_LOAD_V3_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3808
  { IMAGE_MSAA_LOAD_V3_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3809
  { IMAGE_MSAA_LOAD_V3_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3810
  { IMAGE_MSAA_LOAD_V4_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3811
  { IMAGE_MSAA_LOAD_V4_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3812
  { IMAGE_MSAA_LOAD_V4_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3813
  { IMAGE_MSAA_LOAD_V4_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3814
  { IMAGE_MSAA_LOAD_V5_V1_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3815
  { IMAGE_MSAA_LOAD_V5_V2_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3816
  { IMAGE_MSAA_LOAD_V5_V3_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3817
  { IMAGE_MSAA_LOAD_V5_V4_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3818
  { IMAGE_MSAA_LOAD_V2_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3819
  { IMAGE_MSAA_LOAD_V2_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3820
  { IMAGE_MSAA_LOAD_V2_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 3821
  { IMAGE_MSAA_LOAD_V3_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3822
  { IMAGE_MSAA_LOAD_V3_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3823
  { IMAGE_MSAA_LOAD_V3_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 3824
  { IMAGE_MSAA_LOAD_V4_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3825
  { IMAGE_MSAA_LOAD_V4_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3826
  { IMAGE_MSAA_LOAD_V4_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 3827
  { IMAGE_MSAA_LOAD_V5_V2_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3828
  { IMAGE_MSAA_LOAD_V5_V3_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3829
  { IMAGE_MSAA_LOAD_V5_V4_nsa_gfx11, IMAGE_MSAA_LOAD, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 3830
  { IMAGE_MSAA_LOAD_V2_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3831
  { IMAGE_MSAA_LOAD_V2_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3832
  { IMAGE_MSAA_LOAD_V2_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3833
  { IMAGE_MSAA_LOAD_V2_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 3834
  { IMAGE_MSAA_LOAD_V3_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3835
  { IMAGE_MSAA_LOAD_V3_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3836
  { IMAGE_MSAA_LOAD_V3_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3837
  { IMAGE_MSAA_LOAD_V3_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 3838
  { IMAGE_MSAA_LOAD_V4_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3839
  { IMAGE_MSAA_LOAD_V4_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3840
  { IMAGE_MSAA_LOAD_V4_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3841
  { IMAGE_MSAA_LOAD_V4_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 3842
  { IMAGE_MSAA_LOAD_V5_V1_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3843
  { IMAGE_MSAA_LOAD_V5_V2_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3844
  { IMAGE_MSAA_LOAD_V5_V3_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3845
  { IMAGE_MSAA_LOAD_V5_V4_gfx12, IMAGE_MSAA_LOAD, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 3846
  { IMAGE_MSAA_LOAD_X_V1_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3847
  { IMAGE_MSAA_LOAD_X_V1_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3848
  { IMAGE_MSAA_LOAD_X_V1_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3849
  { IMAGE_MSAA_LOAD_X_V1_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3850
  { IMAGE_MSAA_LOAD_X_V2_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3851
  { IMAGE_MSAA_LOAD_X_V2_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3852
  { IMAGE_MSAA_LOAD_X_V2_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3853
  { IMAGE_MSAA_LOAD_X_V2_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3854
  { IMAGE_MSAA_LOAD_X_V3_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3855
  { IMAGE_MSAA_LOAD_X_V3_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3856
  { IMAGE_MSAA_LOAD_X_V3_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3857
  { IMAGE_MSAA_LOAD_X_V3_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3858
  { IMAGE_MSAA_LOAD_X_V4_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3859
  { IMAGE_MSAA_LOAD_X_V4_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3860
  { IMAGE_MSAA_LOAD_X_V4_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3861
  { IMAGE_MSAA_LOAD_X_V4_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3862
  { IMAGE_MSAA_LOAD_X_V5_V1_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3863
  { IMAGE_MSAA_LOAD_X_V5_V2_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3864
  { IMAGE_MSAA_LOAD_X_V5_V3_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3865
  { IMAGE_MSAA_LOAD_X_V5_V4_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3866
  { IMAGE_MSAA_LOAD_X_V1_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3867
  { IMAGE_MSAA_LOAD_X_V1_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3868
  { IMAGE_MSAA_LOAD_X_V1_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 3869
  { IMAGE_MSAA_LOAD_X_V2_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3870
  { IMAGE_MSAA_LOAD_X_V2_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3871
  { IMAGE_MSAA_LOAD_X_V2_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 3872
  { IMAGE_MSAA_LOAD_X_V3_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3873
  { IMAGE_MSAA_LOAD_X_V3_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3874
  { IMAGE_MSAA_LOAD_X_V3_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 3875
  { IMAGE_MSAA_LOAD_X_V4_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3876
  { IMAGE_MSAA_LOAD_X_V4_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3877
  { IMAGE_MSAA_LOAD_X_V4_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 3878
  { IMAGE_MSAA_LOAD_X_V5_V2_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3879
  { IMAGE_MSAA_LOAD_X_V5_V3_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3880
  { IMAGE_MSAA_LOAD_X_V5_V4_nsa_gfx10, IMAGE_MSAA_LOAD_X, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 3881
  { IMAGE_MSAA_LOAD_X_V1_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3882
  { IMAGE_MSAA_LOAD_X_V1_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3883
  { IMAGE_MSAA_LOAD_X_V1_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3884
  { IMAGE_MSAA_LOAD_X_V1_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3885
  { IMAGE_MSAA_LOAD_X_V2_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3886
  { IMAGE_MSAA_LOAD_X_V2_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3887
  { IMAGE_MSAA_LOAD_X_V2_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3888
  { IMAGE_MSAA_LOAD_X_V2_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3889
  { IMAGE_MSAA_LOAD_X_V3_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3890
  { IMAGE_MSAA_LOAD_X_V3_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3891
  { IMAGE_MSAA_LOAD_X_V3_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3892
  { IMAGE_MSAA_LOAD_X_V3_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3893
  { IMAGE_MSAA_LOAD_X_V4_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3894
  { IMAGE_MSAA_LOAD_X_V4_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3895
  { IMAGE_MSAA_LOAD_X_V4_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3896
  { IMAGE_MSAA_LOAD_X_V4_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3897
  { IMAGE_MSAA_LOAD_X_V5_V1, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3898
  { IMAGE_MSAA_LOAD_X_V5_V2, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3899
  { IMAGE_MSAA_LOAD_X_V5_V3, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3900
  { IMAGE_MSAA_LOAD_X_V5_V4, IMAGE_MSAA_LOAD_X, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3901
  { IMAGE_SAMPLE_V1_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 3902
  { IMAGE_SAMPLE_V1_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 3903
  { IMAGE_SAMPLE_V1_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 3904
  { IMAGE_SAMPLE_V1_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 3905
  { IMAGE_SAMPLE_V2_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 3906
  { IMAGE_SAMPLE_V2_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 3907
  { IMAGE_SAMPLE_V2_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 3908
  { IMAGE_SAMPLE_V2_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 3909
  { IMAGE_SAMPLE_V3_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 3910
  { IMAGE_SAMPLE_V3_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 3911
  { IMAGE_SAMPLE_V3_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 3912
  { IMAGE_SAMPLE_V3_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 3913
  { IMAGE_SAMPLE_V4_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 3914
  { IMAGE_SAMPLE_V4_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 3915
  { IMAGE_SAMPLE_V4_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 3916
  { IMAGE_SAMPLE_V4_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 3917
  { IMAGE_SAMPLE_V5_V1_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 3918
  { IMAGE_SAMPLE_V5_V2_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 3919
  { IMAGE_SAMPLE_V5_V3_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 3920
  { IMAGE_SAMPLE_V5_V4_gfx10, IMAGE_SAMPLE, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 3921
  { IMAGE_SAMPLE_V1_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 3922
  { IMAGE_SAMPLE_V1_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 3923
  { IMAGE_SAMPLE_V2_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 3924
  { IMAGE_SAMPLE_V2_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 3925
  { IMAGE_SAMPLE_V3_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 3926
  { IMAGE_SAMPLE_V3_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 3927
  { IMAGE_SAMPLE_V4_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 3928
  { IMAGE_SAMPLE_V4_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 3929
  { IMAGE_SAMPLE_V5_V2_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 3930
  { IMAGE_SAMPLE_V5_V3_nsa_gfx10, IMAGE_SAMPLE, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 3931
  { IMAGE_SAMPLE_V1_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 3932
  { IMAGE_SAMPLE_V1_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 3933
  { IMAGE_SAMPLE_V1_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 3934
  { IMAGE_SAMPLE_V1_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 3935
  { IMAGE_SAMPLE_V2_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 3936
  { IMAGE_SAMPLE_V2_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 3937
  { IMAGE_SAMPLE_V2_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 3938
  { IMAGE_SAMPLE_V2_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 3939
  { IMAGE_SAMPLE_V3_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 3940
  { IMAGE_SAMPLE_V3_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 3941
  { IMAGE_SAMPLE_V3_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 3942
  { IMAGE_SAMPLE_V3_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 3943
  { IMAGE_SAMPLE_V4_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 3944
  { IMAGE_SAMPLE_V4_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 3945
  { IMAGE_SAMPLE_V4_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 3946
  { IMAGE_SAMPLE_V4_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 3947
  { IMAGE_SAMPLE_V5_V1_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 3948
  { IMAGE_SAMPLE_V5_V2_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 3949
  { IMAGE_SAMPLE_V5_V3_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 3950
  { IMAGE_SAMPLE_V5_V4_gfx11, IMAGE_SAMPLE, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 3951
  { IMAGE_SAMPLE_V1_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 3952
  { IMAGE_SAMPLE_V1_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 3953
  { IMAGE_SAMPLE_V2_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 3954
  { IMAGE_SAMPLE_V2_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 3955
  { IMAGE_SAMPLE_V3_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 3956
  { IMAGE_SAMPLE_V3_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 3957
  { IMAGE_SAMPLE_V4_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 3958
  { IMAGE_SAMPLE_V4_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 3959
  { IMAGE_SAMPLE_V5_V2_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 3960
  { IMAGE_SAMPLE_V5_V3_nsa_gfx11, IMAGE_SAMPLE, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 3961
  { IMAGE_SAMPLE_V1_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 3962
  { IMAGE_SAMPLE_V1_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 3963
  { IMAGE_SAMPLE_V1_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 3964
  { IMAGE_SAMPLE_V2_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 3965
  { IMAGE_SAMPLE_V2_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 3966
  { IMAGE_SAMPLE_V2_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 3967
  { IMAGE_SAMPLE_V3_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 3968
  { IMAGE_SAMPLE_V3_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 3969
  { IMAGE_SAMPLE_V3_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 3970
  { IMAGE_SAMPLE_V4_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 3971
  { IMAGE_SAMPLE_V4_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 3972
  { IMAGE_SAMPLE_V4_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 3973
  { IMAGE_SAMPLE_V5_V1_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 3974
  { IMAGE_SAMPLE_V5_V2_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 3975
  { IMAGE_SAMPLE_V5_V3_gfx12, IMAGE_SAMPLE, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 3976
  { IMAGE_SAMPLE_V1_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 3977
  { IMAGE_SAMPLE_V1_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 3978
  { IMAGE_SAMPLE_V1_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 3979
  { IMAGE_SAMPLE_V1_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 3980
  { IMAGE_SAMPLE_V2_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 3981
  { IMAGE_SAMPLE_V2_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 3982
  { IMAGE_SAMPLE_V2_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 3983
  { IMAGE_SAMPLE_V2_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 3984
  { IMAGE_SAMPLE_V3_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 3985
  { IMAGE_SAMPLE_V3_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 3986
  { IMAGE_SAMPLE_V3_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 3987
  { IMAGE_SAMPLE_V3_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 3988
  { IMAGE_SAMPLE_V4_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 3989
  { IMAGE_SAMPLE_V4_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 3990
  { IMAGE_SAMPLE_V4_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 3991
  { IMAGE_SAMPLE_V4_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 3992
  { IMAGE_SAMPLE_V5_V1, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 3993
  { IMAGE_SAMPLE_V5_V2, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 3994
  { IMAGE_SAMPLE_V5_V3, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 3995
  { IMAGE_SAMPLE_V5_V4, IMAGE_SAMPLE, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 3996
  { IMAGE_SAMPLE_V1_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x1, 0x1 }, // 3997
  { IMAGE_SAMPLE_V1_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x2, 0x1 }, // 3998
  { IMAGE_SAMPLE_V1_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x3, 0x1 }, // 3999
  { IMAGE_SAMPLE_V1_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x1, 0x4, 0x1 }, // 4000
  { IMAGE_SAMPLE_V2_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x1, 0x1 }, // 4001
  { IMAGE_SAMPLE_V2_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x2, 0x1 }, // 4002
  { IMAGE_SAMPLE_V2_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x3, 0x1 }, // 4003
  { IMAGE_SAMPLE_V2_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x2, 0x4, 0x1 }, // 4004
  { IMAGE_SAMPLE_V3_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x1, 0x1 }, // 4005
  { IMAGE_SAMPLE_V3_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x2, 0x1 }, // 4006
  { IMAGE_SAMPLE_V3_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x3, 0x1 }, // 4007
  { IMAGE_SAMPLE_V3_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x3, 0x4, 0x1 }, // 4008
  { IMAGE_SAMPLE_V4_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x1, 0x1 }, // 4009
  { IMAGE_SAMPLE_V4_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x2, 0x1 }, // 4010
  { IMAGE_SAMPLE_V4_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x3, 0x1 }, // 4011
  { IMAGE_SAMPLE_V4_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x4, 0x4, 0x1 }, // 4012
  { IMAGE_SAMPLE_V5_V1_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x1, 0x1 }, // 4013
  { IMAGE_SAMPLE_V5_V2_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x2, 0x1 }, // 4014
  { IMAGE_SAMPLE_V5_V3_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x3, 0x1 }, // 4015
  { IMAGE_SAMPLE_V5_V4_gfx90a, IMAGE_SAMPLE, MIMGEncGfx90a, 0x5, 0x4, 0x1 }, // 4016
  { IMAGE_SAMPLE_B_V1_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4017
  { IMAGE_SAMPLE_B_V1_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4018
  { IMAGE_SAMPLE_B_V1_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4019
  { IMAGE_SAMPLE_B_V2_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4020
  { IMAGE_SAMPLE_B_V2_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4021
  { IMAGE_SAMPLE_B_V2_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4022
  { IMAGE_SAMPLE_B_V3_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4023
  { IMAGE_SAMPLE_B_V3_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4024
  { IMAGE_SAMPLE_B_V3_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4025
  { IMAGE_SAMPLE_B_V4_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4026
  { IMAGE_SAMPLE_B_V4_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4027
  { IMAGE_SAMPLE_B_V4_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4028
  { IMAGE_SAMPLE_B_V5_V2_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4029
  { IMAGE_SAMPLE_B_V5_V3_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4030
  { IMAGE_SAMPLE_B_V5_V4_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4031
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4032
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4033
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4034
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4035
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4036
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4037
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4038
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4039
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4040
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4041
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4042
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4043
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4044
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4045
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4046
  { IMAGE_SAMPLE_B_V1_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4047
  { IMAGE_SAMPLE_B_V1_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4048
  { IMAGE_SAMPLE_B_V1_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4049
  { IMAGE_SAMPLE_B_V2_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4050
  { IMAGE_SAMPLE_B_V2_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4051
  { IMAGE_SAMPLE_B_V2_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4052
  { IMAGE_SAMPLE_B_V3_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4053
  { IMAGE_SAMPLE_B_V3_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4054
  { IMAGE_SAMPLE_B_V3_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4055
  { IMAGE_SAMPLE_B_V4_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4056
  { IMAGE_SAMPLE_B_V4_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4057
  { IMAGE_SAMPLE_B_V4_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4058
  { IMAGE_SAMPLE_B_V5_V2_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4059
  { IMAGE_SAMPLE_B_V5_V3_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4060
  { IMAGE_SAMPLE_B_V5_V4_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4061
  { IMAGE_SAMPLE_B_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4062
  { IMAGE_SAMPLE_B_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4063
  { IMAGE_SAMPLE_B_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4064
  { IMAGE_SAMPLE_B_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4065
  { IMAGE_SAMPLE_B_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4066
  { IMAGE_SAMPLE_B_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4067
  { IMAGE_SAMPLE_B_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4068
  { IMAGE_SAMPLE_B_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4069
  { IMAGE_SAMPLE_B_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4070
  { IMAGE_SAMPLE_B_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4071
  { IMAGE_SAMPLE_B_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4072
  { IMAGE_SAMPLE_B_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4073
  { IMAGE_SAMPLE_B_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4074
  { IMAGE_SAMPLE_B_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4075
  { IMAGE_SAMPLE_B_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4076
  { IMAGE_SAMPLE_B_V1_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4077
  { IMAGE_SAMPLE_B_V1_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4078
  { IMAGE_SAMPLE_B_V1_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4079
  { IMAGE_SAMPLE_B_V2_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4080
  { IMAGE_SAMPLE_B_V2_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4081
  { IMAGE_SAMPLE_B_V2_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4082
  { IMAGE_SAMPLE_B_V3_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4083
  { IMAGE_SAMPLE_B_V3_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4084
  { IMAGE_SAMPLE_B_V3_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4085
  { IMAGE_SAMPLE_B_V4_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4086
  { IMAGE_SAMPLE_B_V4_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4087
  { IMAGE_SAMPLE_B_V4_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4088
  { IMAGE_SAMPLE_B_V5_V2_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4089
  { IMAGE_SAMPLE_B_V5_V3_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4090
  { IMAGE_SAMPLE_B_V5_V4_gfx12, IMAGE_SAMPLE_B, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4091
  { IMAGE_SAMPLE_B_V1_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4092
  { IMAGE_SAMPLE_B_V1_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4093
  { IMAGE_SAMPLE_B_V1_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4094
  { IMAGE_SAMPLE_B_V2_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4095
  { IMAGE_SAMPLE_B_V2_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4096
  { IMAGE_SAMPLE_B_V2_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4097
  { IMAGE_SAMPLE_B_V3_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4098
  { IMAGE_SAMPLE_B_V3_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4099
  { IMAGE_SAMPLE_B_V3_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4100
  { IMAGE_SAMPLE_B_V4_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4101
  { IMAGE_SAMPLE_B_V4_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4102
  { IMAGE_SAMPLE_B_V4_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4103
  { IMAGE_SAMPLE_B_V5_V2, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4104
  { IMAGE_SAMPLE_B_V5_V3, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4105
  { IMAGE_SAMPLE_B_V5_V4, IMAGE_SAMPLE_B, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4106
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4107
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4108
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4109
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4110
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4111
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4112
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4113
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4114
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4115
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4116
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4117
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4118
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4119
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4120
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4121
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4122
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4123
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4124
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4125
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4126
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4127
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4128
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4129
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4130
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4131
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4132
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4133
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4134
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4135
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4136
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4137
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4138
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4139
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4140
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4141
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4142
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4143
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4144
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4145
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4146
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4147
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4148
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4149
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4150
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4151
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4152
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4153
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4154
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4155
  { IMAGE_SAMPLE_B_CL_V1_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4156
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4157
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4158
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4159
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4160
  { IMAGE_SAMPLE_B_CL_V2_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4161
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4162
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4163
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4164
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4165
  { IMAGE_SAMPLE_B_CL_V3_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4166
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4167
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4168
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4169
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4170
  { IMAGE_SAMPLE_B_CL_V4_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4171
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4172
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4173
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4174
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4175
  { IMAGE_SAMPLE_B_CL_V5_V8_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4176
  { IMAGE_SAMPLE_B_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4177
  { IMAGE_SAMPLE_B_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4178
  { IMAGE_SAMPLE_B_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4179
  { IMAGE_SAMPLE_B_CL_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4180
  { IMAGE_SAMPLE_B_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4181
  { IMAGE_SAMPLE_B_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4182
  { IMAGE_SAMPLE_B_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4183
  { IMAGE_SAMPLE_B_CL_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4184
  { IMAGE_SAMPLE_B_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4185
  { IMAGE_SAMPLE_B_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4186
  { IMAGE_SAMPLE_B_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4187
  { IMAGE_SAMPLE_B_CL_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4188
  { IMAGE_SAMPLE_B_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4189
  { IMAGE_SAMPLE_B_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4190
  { IMAGE_SAMPLE_B_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4191
  { IMAGE_SAMPLE_B_CL_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4192
  { IMAGE_SAMPLE_B_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4193
  { IMAGE_SAMPLE_B_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4194
  { IMAGE_SAMPLE_B_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4195
  { IMAGE_SAMPLE_B_CL_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4196
  { IMAGE_SAMPLE_B_CL_V1_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4197
  { IMAGE_SAMPLE_B_CL_V1_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4198
  { IMAGE_SAMPLE_B_CL_V1_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4199
  { IMAGE_SAMPLE_B_CL_V1_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4200
  { IMAGE_SAMPLE_B_CL_V2_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4201
  { IMAGE_SAMPLE_B_CL_V2_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4202
  { IMAGE_SAMPLE_B_CL_V2_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4203
  { IMAGE_SAMPLE_B_CL_V2_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4204
  { IMAGE_SAMPLE_B_CL_V3_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4205
  { IMAGE_SAMPLE_B_CL_V3_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4206
  { IMAGE_SAMPLE_B_CL_V3_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4207
  { IMAGE_SAMPLE_B_CL_V3_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4208
  { IMAGE_SAMPLE_B_CL_V4_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4209
  { IMAGE_SAMPLE_B_CL_V4_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4210
  { IMAGE_SAMPLE_B_CL_V4_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4211
  { IMAGE_SAMPLE_B_CL_V4_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4212
  { IMAGE_SAMPLE_B_CL_V5_V2_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4213
  { IMAGE_SAMPLE_B_CL_V5_V3_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4214
  { IMAGE_SAMPLE_B_CL_V5_V4_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4215
  { IMAGE_SAMPLE_B_CL_V5_V5_gfx12, IMAGE_SAMPLE_B_CL, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4216
  { IMAGE_SAMPLE_B_CL_V1_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4217
  { IMAGE_SAMPLE_B_CL_V1_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4218
  { IMAGE_SAMPLE_B_CL_V1_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4219
  { IMAGE_SAMPLE_B_CL_V1_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4220
  { IMAGE_SAMPLE_B_CL_V1_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4221
  { IMAGE_SAMPLE_B_CL_V2_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4222
  { IMAGE_SAMPLE_B_CL_V2_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4223
  { IMAGE_SAMPLE_B_CL_V2_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4224
  { IMAGE_SAMPLE_B_CL_V2_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4225
  { IMAGE_SAMPLE_B_CL_V2_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4226
  { IMAGE_SAMPLE_B_CL_V3_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4227
  { IMAGE_SAMPLE_B_CL_V3_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4228
  { IMAGE_SAMPLE_B_CL_V3_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4229
  { IMAGE_SAMPLE_B_CL_V3_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4230
  { IMAGE_SAMPLE_B_CL_V3_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4231
  { IMAGE_SAMPLE_B_CL_V4_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4232
  { IMAGE_SAMPLE_B_CL_V4_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4233
  { IMAGE_SAMPLE_B_CL_V4_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4234
  { IMAGE_SAMPLE_B_CL_V4_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4235
  { IMAGE_SAMPLE_B_CL_V4_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4236
  { IMAGE_SAMPLE_B_CL_V5_V2, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4237
  { IMAGE_SAMPLE_B_CL_V5_V3, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4238
  { IMAGE_SAMPLE_B_CL_V5_V4, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4239
  { IMAGE_SAMPLE_B_CL_V5_V5, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4240
  { IMAGE_SAMPLE_B_CL_V5_V8, IMAGE_SAMPLE_B_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4241
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4242
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4243
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4244
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4245
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4246
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4247
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4248
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4249
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4250
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4251
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4252
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4253
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4254
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4255
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4256
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4257
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4258
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4259
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4260
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4261
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4262
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4263
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4264
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4265
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4266
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4267
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4268
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4269
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4270
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4271
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4272
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4273
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4274
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4275
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4276
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4277
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4278
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4279
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4280
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4281
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4282
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4283
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4284
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4285
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4286
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4287
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4288
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4289
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x6, 0x1 }, // 4290
  { IMAGE_SAMPLE_B_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4291
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4292
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4293
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4294
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x6, 0x1 }, // 4295
  { IMAGE_SAMPLE_B_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4296
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4297
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4298
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4299
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x6, 0x1 }, // 4300
  { IMAGE_SAMPLE_B_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4301
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4302
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4303
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4304
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x6, 0x1 }, // 4305
  { IMAGE_SAMPLE_B_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4306
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4307
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4308
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4309
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x6, 0x1 }, // 4310
  { IMAGE_SAMPLE_B_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4311
  { IMAGE_SAMPLE_B_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4312
  { IMAGE_SAMPLE_B_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4313
  { IMAGE_SAMPLE_B_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4314
  { IMAGE_SAMPLE_B_CL_O_V1_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x1, 0x6, 0x6 }, // 4315
  { IMAGE_SAMPLE_B_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4316
  { IMAGE_SAMPLE_B_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4317
  { IMAGE_SAMPLE_B_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4318
  { IMAGE_SAMPLE_B_CL_O_V2_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x2, 0x6, 0x6 }, // 4319
  { IMAGE_SAMPLE_B_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4320
  { IMAGE_SAMPLE_B_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4321
  { IMAGE_SAMPLE_B_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4322
  { IMAGE_SAMPLE_B_CL_O_V3_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x3, 0x6, 0x6 }, // 4323
  { IMAGE_SAMPLE_B_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4324
  { IMAGE_SAMPLE_B_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4325
  { IMAGE_SAMPLE_B_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4326
  { IMAGE_SAMPLE_B_CL_O_V4_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x4, 0x6, 0x6 }, // 4327
  { IMAGE_SAMPLE_B_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4328
  { IMAGE_SAMPLE_B_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4329
  { IMAGE_SAMPLE_B_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4330
  { IMAGE_SAMPLE_B_CL_O_V5_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx11NSA, 0x5, 0x6, 0x6 }, // 4331
  { IMAGE_SAMPLE_B_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4332
  { IMAGE_SAMPLE_B_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4333
  { IMAGE_SAMPLE_B_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4334
  { IMAGE_SAMPLE_B_CL_O_V1_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x1, 0x6, 0x6 }, // 4335
  { IMAGE_SAMPLE_B_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4336
  { IMAGE_SAMPLE_B_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4337
  { IMAGE_SAMPLE_B_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4338
  { IMAGE_SAMPLE_B_CL_O_V2_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x2, 0x6, 0x6 }, // 4339
  { IMAGE_SAMPLE_B_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4340
  { IMAGE_SAMPLE_B_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4341
  { IMAGE_SAMPLE_B_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4342
  { IMAGE_SAMPLE_B_CL_O_V3_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x3, 0x6, 0x6 }, // 4343
  { IMAGE_SAMPLE_B_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4344
  { IMAGE_SAMPLE_B_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4345
  { IMAGE_SAMPLE_B_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4346
  { IMAGE_SAMPLE_B_CL_O_V4_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x4, 0x6, 0x6 }, // 4347
  { IMAGE_SAMPLE_B_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4348
  { IMAGE_SAMPLE_B_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4349
  { IMAGE_SAMPLE_B_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4350
  { IMAGE_SAMPLE_B_CL_O_V5_V6_gfx12, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx12, 0x5, 0x6, 0x6 }, // 4351
  { IMAGE_SAMPLE_B_CL_O_V1_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4352
  { IMAGE_SAMPLE_B_CL_O_V1_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4353
  { IMAGE_SAMPLE_B_CL_O_V1_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4354
  { IMAGE_SAMPLE_B_CL_O_V1_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4355
  { IMAGE_SAMPLE_B_CL_O_V1_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4356
  { IMAGE_SAMPLE_B_CL_O_V2_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4357
  { IMAGE_SAMPLE_B_CL_O_V2_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4358
  { IMAGE_SAMPLE_B_CL_O_V2_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4359
  { IMAGE_SAMPLE_B_CL_O_V2_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4360
  { IMAGE_SAMPLE_B_CL_O_V2_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4361
  { IMAGE_SAMPLE_B_CL_O_V3_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4362
  { IMAGE_SAMPLE_B_CL_O_V3_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4363
  { IMAGE_SAMPLE_B_CL_O_V3_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4364
  { IMAGE_SAMPLE_B_CL_O_V3_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4365
  { IMAGE_SAMPLE_B_CL_O_V3_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4366
  { IMAGE_SAMPLE_B_CL_O_V4_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4367
  { IMAGE_SAMPLE_B_CL_O_V4_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4368
  { IMAGE_SAMPLE_B_CL_O_V4_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4369
  { IMAGE_SAMPLE_B_CL_O_V4_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4370
  { IMAGE_SAMPLE_B_CL_O_V4_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4371
  { IMAGE_SAMPLE_B_CL_O_V5_V3, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4372
  { IMAGE_SAMPLE_B_CL_O_V5_V4, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4373
  { IMAGE_SAMPLE_B_CL_O_V5_V5, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4374
  { IMAGE_SAMPLE_B_CL_O_V5_V6, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4375
  { IMAGE_SAMPLE_B_CL_O_V5_V8, IMAGE_SAMPLE_B_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4376
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4377
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4378
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4379
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 4380
  { IMAGE_SAMPLE_B_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4381
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4382
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4383
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4384
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 4385
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4386
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4387
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4388
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x6, 0x1 }, // 4389
  { IMAGE_SAMPLE_B_CL_O_nortn_V8_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4390
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4391
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4392
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4393
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_nsa_gfx11, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx11NSA, 0x0, 0x6, 0x6 }, // 4394
  { IMAGE_SAMPLE_B_CL_O_nortn_V3_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4395
  { IMAGE_SAMPLE_B_CL_O_nortn_V4_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4396
  { IMAGE_SAMPLE_B_CL_O_nortn_V5_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4397
  { IMAGE_SAMPLE_B_CL_O_nortn_V6_gfx12, IMAGE_SAMPLE_B_CL_O_nortn, MIMGEncGfx12, 0x0, 0x6, 0x6 }, // 4398
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 4399
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4400
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4401
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4402
  { IMAGE_SAMPLE_B_CL_nortn_V8_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4403
  { IMAGE_SAMPLE_B_CL_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 4404
  { IMAGE_SAMPLE_B_CL_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4405
  { IMAGE_SAMPLE_B_CL_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4406
  { IMAGE_SAMPLE_B_CL_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4407
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 4408
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4409
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4410
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4411
  { IMAGE_SAMPLE_B_CL_nortn_V8_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4412
  { IMAGE_SAMPLE_B_CL_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 4413
  { IMAGE_SAMPLE_B_CL_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4414
  { IMAGE_SAMPLE_B_CL_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4415
  { IMAGE_SAMPLE_B_CL_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4416
  { IMAGE_SAMPLE_B_CL_nortn_V2_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 4417
  { IMAGE_SAMPLE_B_CL_nortn_V3_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4418
  { IMAGE_SAMPLE_B_CL_nortn_V4_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4419
  { IMAGE_SAMPLE_B_CL_nortn_V5_gfx12, IMAGE_SAMPLE_B_CL_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4420
  { IMAGE_SAMPLE_B_O_V1_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4421
  { IMAGE_SAMPLE_B_O_V1_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4422
  { IMAGE_SAMPLE_B_O_V1_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4423
  { IMAGE_SAMPLE_B_O_V1_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4424
  { IMAGE_SAMPLE_B_O_V2_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4425
  { IMAGE_SAMPLE_B_O_V2_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4426
  { IMAGE_SAMPLE_B_O_V2_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4427
  { IMAGE_SAMPLE_B_O_V2_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4428
  { IMAGE_SAMPLE_B_O_V3_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4429
  { IMAGE_SAMPLE_B_O_V3_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4430
  { IMAGE_SAMPLE_B_O_V3_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4431
  { IMAGE_SAMPLE_B_O_V3_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4432
  { IMAGE_SAMPLE_B_O_V4_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4433
  { IMAGE_SAMPLE_B_O_V4_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4434
  { IMAGE_SAMPLE_B_O_V4_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4435
  { IMAGE_SAMPLE_B_O_V4_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4436
  { IMAGE_SAMPLE_B_O_V5_V3_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4437
  { IMAGE_SAMPLE_B_O_V5_V4_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4438
  { IMAGE_SAMPLE_B_O_V5_V5_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4439
  { IMAGE_SAMPLE_B_O_V5_V8_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4440
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4441
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4442
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4443
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4444
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4445
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4446
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4447
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4448
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4449
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4450
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4451
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4452
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4453
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4454
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_B_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4455
  { IMAGE_SAMPLE_B_O_V1_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4456
  { IMAGE_SAMPLE_B_O_V1_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4457
  { IMAGE_SAMPLE_B_O_V1_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 4458
  { IMAGE_SAMPLE_B_O_V1_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 4459
  { IMAGE_SAMPLE_B_O_V2_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4460
  { IMAGE_SAMPLE_B_O_V2_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4461
  { IMAGE_SAMPLE_B_O_V2_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 4462
  { IMAGE_SAMPLE_B_O_V2_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 4463
  { IMAGE_SAMPLE_B_O_V3_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4464
  { IMAGE_SAMPLE_B_O_V3_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4465
  { IMAGE_SAMPLE_B_O_V3_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 4466
  { IMAGE_SAMPLE_B_O_V3_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 4467
  { IMAGE_SAMPLE_B_O_V4_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4468
  { IMAGE_SAMPLE_B_O_V4_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4469
  { IMAGE_SAMPLE_B_O_V4_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 4470
  { IMAGE_SAMPLE_B_O_V4_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 4471
  { IMAGE_SAMPLE_B_O_V5_V3_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4472
  { IMAGE_SAMPLE_B_O_V5_V4_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4473
  { IMAGE_SAMPLE_B_O_V5_V5_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 4474
  { IMAGE_SAMPLE_B_O_V5_V8_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 4475
  { IMAGE_SAMPLE_B_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4476
  { IMAGE_SAMPLE_B_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4477
  { IMAGE_SAMPLE_B_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 4478
  { IMAGE_SAMPLE_B_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4479
  { IMAGE_SAMPLE_B_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4480
  { IMAGE_SAMPLE_B_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 4481
  { IMAGE_SAMPLE_B_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4482
  { IMAGE_SAMPLE_B_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4483
  { IMAGE_SAMPLE_B_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 4484
  { IMAGE_SAMPLE_B_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4485
  { IMAGE_SAMPLE_B_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4486
  { IMAGE_SAMPLE_B_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 4487
  { IMAGE_SAMPLE_B_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4488
  { IMAGE_SAMPLE_B_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4489
  { IMAGE_SAMPLE_B_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_B_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 4490
  { IMAGE_SAMPLE_B_O_V1_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4491
  { IMAGE_SAMPLE_B_O_V1_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4492
  { IMAGE_SAMPLE_B_O_V1_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 4493
  { IMAGE_SAMPLE_B_O_V2_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4494
  { IMAGE_SAMPLE_B_O_V2_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4495
  { IMAGE_SAMPLE_B_O_V2_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 4496
  { IMAGE_SAMPLE_B_O_V3_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4497
  { IMAGE_SAMPLE_B_O_V3_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4498
  { IMAGE_SAMPLE_B_O_V3_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 4499
  { IMAGE_SAMPLE_B_O_V4_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4500
  { IMAGE_SAMPLE_B_O_V4_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4501
  { IMAGE_SAMPLE_B_O_V4_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 4502
  { IMAGE_SAMPLE_B_O_V5_V3_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4503
  { IMAGE_SAMPLE_B_O_V5_V4_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4504
  { IMAGE_SAMPLE_B_O_V5_V5_gfx12, IMAGE_SAMPLE_B_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 4505
  { IMAGE_SAMPLE_B_O_V1_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4506
  { IMAGE_SAMPLE_B_O_V1_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4507
  { IMAGE_SAMPLE_B_O_V1_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4508
  { IMAGE_SAMPLE_B_O_V1_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4509
  { IMAGE_SAMPLE_B_O_V2_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4510
  { IMAGE_SAMPLE_B_O_V2_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4511
  { IMAGE_SAMPLE_B_O_V2_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4512
  { IMAGE_SAMPLE_B_O_V2_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4513
  { IMAGE_SAMPLE_B_O_V3_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4514
  { IMAGE_SAMPLE_B_O_V3_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4515
  { IMAGE_SAMPLE_B_O_V3_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4516
  { IMAGE_SAMPLE_B_O_V3_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4517
  { IMAGE_SAMPLE_B_O_V4_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4518
  { IMAGE_SAMPLE_B_O_V4_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4519
  { IMAGE_SAMPLE_B_O_V4_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4520
  { IMAGE_SAMPLE_B_O_V4_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4521
  { IMAGE_SAMPLE_B_O_V5_V3, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4522
  { IMAGE_SAMPLE_B_O_V5_V4, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4523
  { IMAGE_SAMPLE_B_O_V5_V5, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4524
  { IMAGE_SAMPLE_B_O_V5_V8, IMAGE_SAMPLE_B_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4525
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4526
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4527
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 4528
  { IMAGE_SAMPLE_B_O_nortn_V8_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 4529
  { IMAGE_SAMPLE_B_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4530
  { IMAGE_SAMPLE_B_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4531
  { IMAGE_SAMPLE_B_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 4532
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4533
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4534
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x5, 0x1 }, // 4535
  { IMAGE_SAMPLE_B_O_nortn_V8_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11Default, 0x0, 0x8, 0x1 }, // 4536
  { IMAGE_SAMPLE_B_O_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4537
  { IMAGE_SAMPLE_B_O_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4538
  { IMAGE_SAMPLE_B_O_nortn_V5_nsa_gfx11, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx11NSA, 0x0, 0x5, 0x5 }, // 4539
  { IMAGE_SAMPLE_B_O_nortn_V3_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4540
  { IMAGE_SAMPLE_B_O_nortn_V4_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4541
  { IMAGE_SAMPLE_B_O_nortn_V5_gfx12, IMAGE_SAMPLE_B_O_nortn, MIMGEncGfx12, 0x0, 0x5, 0x5 }, // 4542
  { IMAGE_SAMPLE_B_nortn_V2_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 4543
  { IMAGE_SAMPLE_B_nortn_V3_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 4544
  { IMAGE_SAMPLE_B_nortn_V4_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 4545
  { IMAGE_SAMPLE_B_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 4546
  { IMAGE_SAMPLE_B_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 4547
  { IMAGE_SAMPLE_B_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_B_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 4548
  { IMAGE_SAMPLE_B_nortn_V2_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 4549
  { IMAGE_SAMPLE_B_nortn_V3_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 4550
  { IMAGE_SAMPLE_B_nortn_V4_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11Default, 0x0, 0x4, 0x1 }, // 4551
  { IMAGE_SAMPLE_B_nortn_V2_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x2, 0x2 }, // 4552
  { IMAGE_SAMPLE_B_nortn_V3_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x3, 0x3 }, // 4553
  { IMAGE_SAMPLE_B_nortn_V4_nsa_gfx11, IMAGE_SAMPLE_B_nortn, MIMGEncGfx11NSA, 0x0, 0x4, 0x4 }, // 4554
  { IMAGE_SAMPLE_B_nortn_V2_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x2, 0x2 }, // 4555
  { IMAGE_SAMPLE_B_nortn_V3_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x3, 0x3 }, // 4556
  { IMAGE_SAMPLE_B_nortn_V4_gfx12, IMAGE_SAMPLE_B_nortn, MIMGEncGfx12, 0x0, 0x4, 0x4 }, // 4557
  { IMAGE_SAMPLE_C_V1_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4558
  { IMAGE_SAMPLE_C_V1_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4559
  { IMAGE_SAMPLE_C_V1_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4560
  { IMAGE_SAMPLE_C_V2_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4561
  { IMAGE_SAMPLE_C_V2_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4562
  { IMAGE_SAMPLE_C_V2_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4563
  { IMAGE_SAMPLE_C_V3_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4564
  { IMAGE_SAMPLE_C_V3_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4565
  { IMAGE_SAMPLE_C_V3_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4566
  { IMAGE_SAMPLE_C_V4_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4567
  { IMAGE_SAMPLE_C_V4_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4568
  { IMAGE_SAMPLE_C_V4_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4569
  { IMAGE_SAMPLE_C_V5_V2_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4570
  { IMAGE_SAMPLE_C_V5_V3_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4571
  { IMAGE_SAMPLE_C_V5_V4_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4572
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4573
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4574
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4575
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4576
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4577
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4578
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4579
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4580
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4581
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4582
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4583
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4584
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4585
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4586
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx10, IMAGE_SAMPLE_C, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4587
  { IMAGE_SAMPLE_C_V1_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 4588
  { IMAGE_SAMPLE_C_V1_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 4589
  { IMAGE_SAMPLE_C_V1_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 4590
  { IMAGE_SAMPLE_C_V2_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 4591
  { IMAGE_SAMPLE_C_V2_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 4592
  { IMAGE_SAMPLE_C_V2_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 4593
  { IMAGE_SAMPLE_C_V3_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 4594
  { IMAGE_SAMPLE_C_V3_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 4595
  { IMAGE_SAMPLE_C_V3_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 4596
  { IMAGE_SAMPLE_C_V4_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 4597
  { IMAGE_SAMPLE_C_V4_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 4598
  { IMAGE_SAMPLE_C_V4_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 4599
  { IMAGE_SAMPLE_C_V5_V2_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 4600
  { IMAGE_SAMPLE_C_V5_V3_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 4601
  { IMAGE_SAMPLE_C_V5_V4_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 4602
  { IMAGE_SAMPLE_C_V1_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 4603
  { IMAGE_SAMPLE_C_V1_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 4604
  { IMAGE_SAMPLE_C_V1_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 4605
  { IMAGE_SAMPLE_C_V2_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 4606
  { IMAGE_SAMPLE_C_V2_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 4607
  { IMAGE_SAMPLE_C_V2_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 4608
  { IMAGE_SAMPLE_C_V3_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 4609
  { IMAGE_SAMPLE_C_V3_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 4610
  { IMAGE_SAMPLE_C_V3_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 4611
  { IMAGE_SAMPLE_C_V4_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 4612
  { IMAGE_SAMPLE_C_V4_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 4613
  { IMAGE_SAMPLE_C_V4_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 4614
  { IMAGE_SAMPLE_C_V5_V2_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 4615
  { IMAGE_SAMPLE_C_V5_V3_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 4616
  { IMAGE_SAMPLE_C_V5_V4_nsa_gfx11, IMAGE_SAMPLE_C, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 4617
  { IMAGE_SAMPLE_C_V1_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 4618
  { IMAGE_SAMPLE_C_V1_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 4619
  { IMAGE_SAMPLE_C_V1_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 4620
  { IMAGE_SAMPLE_C_V2_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 4621
  { IMAGE_SAMPLE_C_V2_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 4622
  { IMAGE_SAMPLE_C_V2_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 4623
  { IMAGE_SAMPLE_C_V3_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 4624
  { IMAGE_SAMPLE_C_V3_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 4625
  { IMAGE_SAMPLE_C_V3_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 4626
  { IMAGE_SAMPLE_C_V4_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 4627
  { IMAGE_SAMPLE_C_V4_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 4628
  { IMAGE_SAMPLE_C_V4_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 4629
  { IMAGE_SAMPLE_C_V5_V2_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 4630
  { IMAGE_SAMPLE_C_V5_V3_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 4631
  { IMAGE_SAMPLE_C_V5_V4_gfx12, IMAGE_SAMPLE_C, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 4632
  { IMAGE_SAMPLE_C_V1_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4633
  { IMAGE_SAMPLE_C_V1_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4634
  { IMAGE_SAMPLE_C_V1_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4635
  { IMAGE_SAMPLE_C_V2_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4636
  { IMAGE_SAMPLE_C_V2_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4637
  { IMAGE_SAMPLE_C_V2_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4638
  { IMAGE_SAMPLE_C_V3_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4639
  { IMAGE_SAMPLE_C_V3_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4640
  { IMAGE_SAMPLE_C_V3_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4641
  { IMAGE_SAMPLE_C_V4_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4642
  { IMAGE_SAMPLE_C_V4_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4643
  { IMAGE_SAMPLE_C_V4_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4644
  { IMAGE_SAMPLE_C_V5_V2, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4645
  { IMAGE_SAMPLE_C_V5_V3, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4646
  { IMAGE_SAMPLE_C_V5_V4, IMAGE_SAMPLE_C, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4647
  { IMAGE_SAMPLE_CD_V1_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4648
  { IMAGE_SAMPLE_CD_V1_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4649
  { IMAGE_SAMPLE_CD_V1_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4650
  { IMAGE_SAMPLE_CD_V1_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4651
  { IMAGE_SAMPLE_CD_V1_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4652
  { IMAGE_SAMPLE_CD_V1_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4653
  { IMAGE_SAMPLE_CD_V1_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4654
  { IMAGE_SAMPLE_CD_V1_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4655
  { IMAGE_SAMPLE_CD_V2_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4656
  { IMAGE_SAMPLE_CD_V2_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4657
  { IMAGE_SAMPLE_CD_V2_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4658
  { IMAGE_SAMPLE_CD_V2_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4659
  { IMAGE_SAMPLE_CD_V2_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4660
  { IMAGE_SAMPLE_CD_V2_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4661
  { IMAGE_SAMPLE_CD_V2_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4662
  { IMAGE_SAMPLE_CD_V2_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4663
  { IMAGE_SAMPLE_CD_V3_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4664
  { IMAGE_SAMPLE_CD_V3_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4665
  { IMAGE_SAMPLE_CD_V3_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4666
  { IMAGE_SAMPLE_CD_V3_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4667
  { IMAGE_SAMPLE_CD_V3_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4668
  { IMAGE_SAMPLE_CD_V3_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4669
  { IMAGE_SAMPLE_CD_V3_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4670
  { IMAGE_SAMPLE_CD_V3_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4671
  { IMAGE_SAMPLE_CD_V4_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4672
  { IMAGE_SAMPLE_CD_V4_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4673
  { IMAGE_SAMPLE_CD_V4_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4674
  { IMAGE_SAMPLE_CD_V4_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4675
  { IMAGE_SAMPLE_CD_V4_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4676
  { IMAGE_SAMPLE_CD_V4_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4677
  { IMAGE_SAMPLE_CD_V4_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4678
  { IMAGE_SAMPLE_CD_V4_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4679
  { IMAGE_SAMPLE_CD_V5_V2_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4680
  { IMAGE_SAMPLE_CD_V5_V3_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4681
  { IMAGE_SAMPLE_CD_V5_V4_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4682
  { IMAGE_SAMPLE_CD_V5_V5_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4683
  { IMAGE_SAMPLE_CD_V5_V6_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4684
  { IMAGE_SAMPLE_CD_V5_V7_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4685
  { IMAGE_SAMPLE_CD_V5_V8_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4686
  { IMAGE_SAMPLE_CD_V5_V9_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4687
  { IMAGE_SAMPLE_CD_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4688
  { IMAGE_SAMPLE_CD_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4689
  { IMAGE_SAMPLE_CD_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4690
  { IMAGE_SAMPLE_CD_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4691
  { IMAGE_SAMPLE_CD_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4692
  { IMAGE_SAMPLE_CD_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4693
  { IMAGE_SAMPLE_CD_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4694
  { IMAGE_SAMPLE_CD_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4695
  { IMAGE_SAMPLE_CD_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4696
  { IMAGE_SAMPLE_CD_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4697
  { IMAGE_SAMPLE_CD_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4698
  { IMAGE_SAMPLE_CD_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4699
  { IMAGE_SAMPLE_CD_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4700
  { IMAGE_SAMPLE_CD_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4701
  { IMAGE_SAMPLE_CD_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4702
  { IMAGE_SAMPLE_CD_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4703
  { IMAGE_SAMPLE_CD_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4704
  { IMAGE_SAMPLE_CD_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4705
  { IMAGE_SAMPLE_CD_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4706
  { IMAGE_SAMPLE_CD_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4707
  { IMAGE_SAMPLE_CD_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4708
  { IMAGE_SAMPLE_CD_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4709
  { IMAGE_SAMPLE_CD_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4710
  { IMAGE_SAMPLE_CD_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4711
  { IMAGE_SAMPLE_CD_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4712
  { IMAGE_SAMPLE_CD_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4713
  { IMAGE_SAMPLE_CD_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4714
  { IMAGE_SAMPLE_CD_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4715
  { IMAGE_SAMPLE_CD_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4716
  { IMAGE_SAMPLE_CD_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4717
  { IMAGE_SAMPLE_CD_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4718
  { IMAGE_SAMPLE_CD_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4719
  { IMAGE_SAMPLE_CD_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4720
  { IMAGE_SAMPLE_CD_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4721
  { IMAGE_SAMPLE_CD_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4722
  { IMAGE_SAMPLE_CD_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4723
  { IMAGE_SAMPLE_CD_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4724
  { IMAGE_SAMPLE_CD_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4725
  { IMAGE_SAMPLE_CD_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4726
  { IMAGE_SAMPLE_CD_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4727
  { IMAGE_SAMPLE_CD_V1_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4728
  { IMAGE_SAMPLE_CD_V1_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4729
  { IMAGE_SAMPLE_CD_V1_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4730
  { IMAGE_SAMPLE_CD_V1_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4731
  { IMAGE_SAMPLE_CD_V1_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4732
  { IMAGE_SAMPLE_CD_V1_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4733
  { IMAGE_SAMPLE_CD_V1_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4734
  { IMAGE_SAMPLE_CD_V1_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4735
  { IMAGE_SAMPLE_CD_V2_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4736
  { IMAGE_SAMPLE_CD_V2_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4737
  { IMAGE_SAMPLE_CD_V2_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4738
  { IMAGE_SAMPLE_CD_V2_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4739
  { IMAGE_SAMPLE_CD_V2_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4740
  { IMAGE_SAMPLE_CD_V2_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4741
  { IMAGE_SAMPLE_CD_V2_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4742
  { IMAGE_SAMPLE_CD_V2_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4743
  { IMAGE_SAMPLE_CD_V3_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4744
  { IMAGE_SAMPLE_CD_V3_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4745
  { IMAGE_SAMPLE_CD_V3_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4746
  { IMAGE_SAMPLE_CD_V3_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4747
  { IMAGE_SAMPLE_CD_V3_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4748
  { IMAGE_SAMPLE_CD_V3_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4749
  { IMAGE_SAMPLE_CD_V3_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4750
  { IMAGE_SAMPLE_CD_V3_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4751
  { IMAGE_SAMPLE_CD_V4_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4752
  { IMAGE_SAMPLE_CD_V4_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4753
  { IMAGE_SAMPLE_CD_V4_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4754
  { IMAGE_SAMPLE_CD_V4_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4755
  { IMAGE_SAMPLE_CD_V4_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4756
  { IMAGE_SAMPLE_CD_V4_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4757
  { IMAGE_SAMPLE_CD_V4_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4758
  { IMAGE_SAMPLE_CD_V4_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4759
  { IMAGE_SAMPLE_CD_V5_V2, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4760
  { IMAGE_SAMPLE_CD_V5_V3, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4761
  { IMAGE_SAMPLE_CD_V5_V4, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4762
  { IMAGE_SAMPLE_CD_V5_V5, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4763
  { IMAGE_SAMPLE_CD_V5_V6, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4764
  { IMAGE_SAMPLE_CD_V5_V7, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4765
  { IMAGE_SAMPLE_CD_V5_V8, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4766
  { IMAGE_SAMPLE_CD_V5_V9, IMAGE_SAMPLE_CD, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4767
  { IMAGE_SAMPLE_CD_CL_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4768
  { IMAGE_SAMPLE_CD_CL_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4769
  { IMAGE_SAMPLE_CD_CL_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4770
  { IMAGE_SAMPLE_CD_CL_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4771
  { IMAGE_SAMPLE_CD_CL_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4772
  { IMAGE_SAMPLE_CD_CL_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4773
  { IMAGE_SAMPLE_CD_CL_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4774
  { IMAGE_SAMPLE_CD_CL_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 4775
  { IMAGE_SAMPLE_CD_CL_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 4776
  { IMAGE_SAMPLE_CD_CL_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4777
  { IMAGE_SAMPLE_CD_CL_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4778
  { IMAGE_SAMPLE_CD_CL_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4779
  { IMAGE_SAMPLE_CD_CL_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4780
  { IMAGE_SAMPLE_CD_CL_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4781
  { IMAGE_SAMPLE_CD_CL_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4782
  { IMAGE_SAMPLE_CD_CL_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4783
  { IMAGE_SAMPLE_CD_CL_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 4784
  { IMAGE_SAMPLE_CD_CL_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 4785
  { IMAGE_SAMPLE_CD_CL_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4786
  { IMAGE_SAMPLE_CD_CL_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4787
  { IMAGE_SAMPLE_CD_CL_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4788
  { IMAGE_SAMPLE_CD_CL_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4789
  { IMAGE_SAMPLE_CD_CL_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4790
  { IMAGE_SAMPLE_CD_CL_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4791
  { IMAGE_SAMPLE_CD_CL_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4792
  { IMAGE_SAMPLE_CD_CL_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 4793
  { IMAGE_SAMPLE_CD_CL_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 4794
  { IMAGE_SAMPLE_CD_CL_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4795
  { IMAGE_SAMPLE_CD_CL_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4796
  { IMAGE_SAMPLE_CD_CL_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4797
  { IMAGE_SAMPLE_CD_CL_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4798
  { IMAGE_SAMPLE_CD_CL_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4799
  { IMAGE_SAMPLE_CD_CL_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4800
  { IMAGE_SAMPLE_CD_CL_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4801
  { IMAGE_SAMPLE_CD_CL_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 4802
  { IMAGE_SAMPLE_CD_CL_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 4803
  { IMAGE_SAMPLE_CD_CL_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4804
  { IMAGE_SAMPLE_CD_CL_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4805
  { IMAGE_SAMPLE_CD_CL_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4806
  { IMAGE_SAMPLE_CD_CL_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4807
  { IMAGE_SAMPLE_CD_CL_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4808
  { IMAGE_SAMPLE_CD_CL_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4809
  { IMAGE_SAMPLE_CD_CL_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4810
  { IMAGE_SAMPLE_CD_CL_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 4811
  { IMAGE_SAMPLE_CD_CL_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 4812
  { IMAGE_SAMPLE_CD_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4813
  { IMAGE_SAMPLE_CD_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4814
  { IMAGE_SAMPLE_CD_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4815
  { IMAGE_SAMPLE_CD_CL_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4816
  { IMAGE_SAMPLE_CD_CL_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4817
  { IMAGE_SAMPLE_CD_CL_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4818
  { IMAGE_SAMPLE_CD_CL_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4819
  { IMAGE_SAMPLE_CD_CL_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 4820
  { IMAGE_SAMPLE_CD_CL_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 4821
  { IMAGE_SAMPLE_CD_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4822
  { IMAGE_SAMPLE_CD_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4823
  { IMAGE_SAMPLE_CD_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4824
  { IMAGE_SAMPLE_CD_CL_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4825
  { IMAGE_SAMPLE_CD_CL_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4826
  { IMAGE_SAMPLE_CD_CL_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4827
  { IMAGE_SAMPLE_CD_CL_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4828
  { IMAGE_SAMPLE_CD_CL_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 4829
  { IMAGE_SAMPLE_CD_CL_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 4830
  { IMAGE_SAMPLE_CD_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4831
  { IMAGE_SAMPLE_CD_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4832
  { IMAGE_SAMPLE_CD_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4833
  { IMAGE_SAMPLE_CD_CL_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4834
  { IMAGE_SAMPLE_CD_CL_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4835
  { IMAGE_SAMPLE_CD_CL_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4836
  { IMAGE_SAMPLE_CD_CL_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4837
  { IMAGE_SAMPLE_CD_CL_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 4838
  { IMAGE_SAMPLE_CD_CL_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 4839
  { IMAGE_SAMPLE_CD_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4840
  { IMAGE_SAMPLE_CD_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4841
  { IMAGE_SAMPLE_CD_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4842
  { IMAGE_SAMPLE_CD_CL_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4843
  { IMAGE_SAMPLE_CD_CL_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4844
  { IMAGE_SAMPLE_CD_CL_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4845
  { IMAGE_SAMPLE_CD_CL_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4846
  { IMAGE_SAMPLE_CD_CL_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 4847
  { IMAGE_SAMPLE_CD_CL_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 4848
  { IMAGE_SAMPLE_CD_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4849
  { IMAGE_SAMPLE_CD_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4850
  { IMAGE_SAMPLE_CD_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4851
  { IMAGE_SAMPLE_CD_CL_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4852
  { IMAGE_SAMPLE_CD_CL_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4853
  { IMAGE_SAMPLE_CD_CL_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4854
  { IMAGE_SAMPLE_CD_CL_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4855
  { IMAGE_SAMPLE_CD_CL_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 4856
  { IMAGE_SAMPLE_CD_CL_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 4857
  { IMAGE_SAMPLE_CD_CL_V1_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4858
  { IMAGE_SAMPLE_CD_CL_V1_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4859
  { IMAGE_SAMPLE_CD_CL_V1_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4860
  { IMAGE_SAMPLE_CD_CL_V1_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4861
  { IMAGE_SAMPLE_CD_CL_V1_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4862
  { IMAGE_SAMPLE_CD_CL_V1_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4863
  { IMAGE_SAMPLE_CD_CL_V1_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4864
  { IMAGE_SAMPLE_CD_CL_V1_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 4865
  { IMAGE_SAMPLE_CD_CL_V1_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 4866
  { IMAGE_SAMPLE_CD_CL_V2_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4867
  { IMAGE_SAMPLE_CD_CL_V2_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4868
  { IMAGE_SAMPLE_CD_CL_V2_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4869
  { IMAGE_SAMPLE_CD_CL_V2_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4870
  { IMAGE_SAMPLE_CD_CL_V2_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4871
  { IMAGE_SAMPLE_CD_CL_V2_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4872
  { IMAGE_SAMPLE_CD_CL_V2_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4873
  { IMAGE_SAMPLE_CD_CL_V2_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 4874
  { IMAGE_SAMPLE_CD_CL_V2_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 4875
  { IMAGE_SAMPLE_CD_CL_V3_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4876
  { IMAGE_SAMPLE_CD_CL_V3_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4877
  { IMAGE_SAMPLE_CD_CL_V3_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4878
  { IMAGE_SAMPLE_CD_CL_V3_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4879
  { IMAGE_SAMPLE_CD_CL_V3_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4880
  { IMAGE_SAMPLE_CD_CL_V3_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4881
  { IMAGE_SAMPLE_CD_CL_V3_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4882
  { IMAGE_SAMPLE_CD_CL_V3_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 4883
  { IMAGE_SAMPLE_CD_CL_V3_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 4884
  { IMAGE_SAMPLE_CD_CL_V4_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4885
  { IMAGE_SAMPLE_CD_CL_V4_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4886
  { IMAGE_SAMPLE_CD_CL_V4_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4887
  { IMAGE_SAMPLE_CD_CL_V4_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4888
  { IMAGE_SAMPLE_CD_CL_V4_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4889
  { IMAGE_SAMPLE_CD_CL_V4_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4890
  { IMAGE_SAMPLE_CD_CL_V4_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 4891
  { IMAGE_SAMPLE_CD_CL_V4_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 4892
  { IMAGE_SAMPLE_CD_CL_V4_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 4893
  { IMAGE_SAMPLE_CD_CL_V5_V2, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 4894
  { IMAGE_SAMPLE_CD_CL_V5_V3, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 4895
  { IMAGE_SAMPLE_CD_CL_V5_V4, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 4896
  { IMAGE_SAMPLE_CD_CL_V5_V5, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 4897
  { IMAGE_SAMPLE_CD_CL_V5_V6, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 4898
  { IMAGE_SAMPLE_CD_CL_V5_V7, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 4899
  { IMAGE_SAMPLE_CD_CL_V5_V8, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 4900
  { IMAGE_SAMPLE_CD_CL_V5_V9, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 4901
  { IMAGE_SAMPLE_CD_CL_V5_V10, IMAGE_SAMPLE_CD_CL, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 4902
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 4903
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 4904
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 4905
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 4906
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 4907
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 4908
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 4909
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 4910
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 4911
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 4912
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 4913
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 4914
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 4915
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 4916
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 4917
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 4918
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 4919
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 4920
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 4921
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 4922
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 4923
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 4924
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 4925
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 4926
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 4927
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 4928
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 4929
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 4930
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 4931
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 4932
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 4933
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 4934
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 4935
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 4936
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 4937
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 4938
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 4939
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 4940
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 4941
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 4942
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 4943
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 4944
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 4945
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 4946
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 4947
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 4948
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 4949
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 4950
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 4951
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 4952
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 4953
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 4954
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 4955
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 4956
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 4957
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 4958
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 4959
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 4960
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 4961
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 4962
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 4963
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 4964
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 4965
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 4966
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 4967
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 4968
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 4969
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 4970
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 4971
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 4972
  { IMAGE_SAMPLE_CD_CL_G16_V1_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 4973
  { IMAGE_SAMPLE_CD_CL_G16_V1_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 4974
  { IMAGE_SAMPLE_CD_CL_G16_V1_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 4975
  { IMAGE_SAMPLE_CD_CL_G16_V1_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 4976
  { IMAGE_SAMPLE_CD_CL_G16_V1_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 4977
  { IMAGE_SAMPLE_CD_CL_G16_V1_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 4978
  { IMAGE_SAMPLE_CD_CL_G16_V1_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 4979
  { IMAGE_SAMPLE_CD_CL_G16_V2_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 4980
  { IMAGE_SAMPLE_CD_CL_G16_V2_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 4981
  { IMAGE_SAMPLE_CD_CL_G16_V2_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 4982
  { IMAGE_SAMPLE_CD_CL_G16_V2_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 4983
  { IMAGE_SAMPLE_CD_CL_G16_V2_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 4984
  { IMAGE_SAMPLE_CD_CL_G16_V2_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 4985
  { IMAGE_SAMPLE_CD_CL_G16_V2_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 4986
  { IMAGE_SAMPLE_CD_CL_G16_V3_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 4987
  { IMAGE_SAMPLE_CD_CL_G16_V3_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 4988
  { IMAGE_SAMPLE_CD_CL_G16_V3_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 4989
  { IMAGE_SAMPLE_CD_CL_G16_V3_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 4990
  { IMAGE_SAMPLE_CD_CL_G16_V3_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 4991
  { IMAGE_SAMPLE_CD_CL_G16_V3_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 4992
  { IMAGE_SAMPLE_CD_CL_G16_V3_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 4993
  { IMAGE_SAMPLE_CD_CL_G16_V4_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 4994
  { IMAGE_SAMPLE_CD_CL_G16_V4_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 4995
  { IMAGE_SAMPLE_CD_CL_G16_V4_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 4996
  { IMAGE_SAMPLE_CD_CL_G16_V4_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 4997
  { IMAGE_SAMPLE_CD_CL_G16_V4_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 4998
  { IMAGE_SAMPLE_CD_CL_G16_V4_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 4999
  { IMAGE_SAMPLE_CD_CL_G16_V4_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5000
  { IMAGE_SAMPLE_CD_CL_G16_V5_V2, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5001
  { IMAGE_SAMPLE_CD_CL_G16_V5_V3, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5002
  { IMAGE_SAMPLE_CD_CL_G16_V5_V4, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5003
  { IMAGE_SAMPLE_CD_CL_G16_V5_V5, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5004
  { IMAGE_SAMPLE_CD_CL_G16_V5_V6, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5005
  { IMAGE_SAMPLE_CD_CL_G16_V5_V7, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5006
  { IMAGE_SAMPLE_CD_CL_G16_V5_V8, IMAGE_SAMPLE_CD_CL_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5007
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V2_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5008
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5009
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5010
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5011
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5012
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5013
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5014
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5015
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5016
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5017
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5018
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5019
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5020
  { IMAGE_SAMPLE_CD_CL_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5021
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5022
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5023
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5024
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5025
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5026
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5027
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5028
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5029
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x1, 0xB, 0x1 }, // 5030
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5031
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5032
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5033
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5034
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5035
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5036
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5037
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5038
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x2, 0xB, 0x1 }, // 5039
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5040
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5041
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5042
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5043
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5044
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5045
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5046
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5047
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x3, 0xB, 0x1 }, // 5048
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5049
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5050
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5051
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5052
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5053
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5054
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5055
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5056
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x4, 0xB, 0x1 }, // 5057
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5058
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5059
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5060
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5061
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5062
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5063
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5064
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5065
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10Default, 0x5, 0xB, 0x1 }, // 5066
  { IMAGE_SAMPLE_CD_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5067
  { IMAGE_SAMPLE_CD_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5068
  { IMAGE_SAMPLE_CD_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5069
  { IMAGE_SAMPLE_CD_CL_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5070
  { IMAGE_SAMPLE_CD_CL_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5071
  { IMAGE_SAMPLE_CD_CL_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5072
  { IMAGE_SAMPLE_CD_CL_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5073
  { IMAGE_SAMPLE_CD_CL_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5074
  { IMAGE_SAMPLE_CD_CL_O_V1_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x1, 0xB, 0xB }, // 5075
  { IMAGE_SAMPLE_CD_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5076
  { IMAGE_SAMPLE_CD_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5077
  { IMAGE_SAMPLE_CD_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5078
  { IMAGE_SAMPLE_CD_CL_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5079
  { IMAGE_SAMPLE_CD_CL_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5080
  { IMAGE_SAMPLE_CD_CL_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5081
  { IMAGE_SAMPLE_CD_CL_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5082
  { IMAGE_SAMPLE_CD_CL_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5083
  { IMAGE_SAMPLE_CD_CL_O_V2_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x2, 0xB, 0xB }, // 5084
  { IMAGE_SAMPLE_CD_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5085
  { IMAGE_SAMPLE_CD_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5086
  { IMAGE_SAMPLE_CD_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5087
  { IMAGE_SAMPLE_CD_CL_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5088
  { IMAGE_SAMPLE_CD_CL_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5089
  { IMAGE_SAMPLE_CD_CL_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5090
  { IMAGE_SAMPLE_CD_CL_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5091
  { IMAGE_SAMPLE_CD_CL_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5092
  { IMAGE_SAMPLE_CD_CL_O_V3_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x3, 0xB, 0xB }, // 5093
  { IMAGE_SAMPLE_CD_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5094
  { IMAGE_SAMPLE_CD_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5095
  { IMAGE_SAMPLE_CD_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5096
  { IMAGE_SAMPLE_CD_CL_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5097
  { IMAGE_SAMPLE_CD_CL_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5098
  { IMAGE_SAMPLE_CD_CL_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5099
  { IMAGE_SAMPLE_CD_CL_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5100
  { IMAGE_SAMPLE_CD_CL_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5101
  { IMAGE_SAMPLE_CD_CL_O_V4_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x4, 0xB, 0xB }, // 5102
  { IMAGE_SAMPLE_CD_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5103
  { IMAGE_SAMPLE_CD_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5104
  { IMAGE_SAMPLE_CD_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5105
  { IMAGE_SAMPLE_CD_CL_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5106
  { IMAGE_SAMPLE_CD_CL_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5107
  { IMAGE_SAMPLE_CD_CL_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5108
  { IMAGE_SAMPLE_CD_CL_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5109
  { IMAGE_SAMPLE_CD_CL_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5110
  { IMAGE_SAMPLE_CD_CL_O_V5_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx10NSA, 0x5, 0xB, 0xB }, // 5111
  { IMAGE_SAMPLE_CD_CL_O_V1_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5112
  { IMAGE_SAMPLE_CD_CL_O_V1_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5113
  { IMAGE_SAMPLE_CD_CL_O_V1_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5114
  { IMAGE_SAMPLE_CD_CL_O_V1_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5115
  { IMAGE_SAMPLE_CD_CL_O_V1_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5116
  { IMAGE_SAMPLE_CD_CL_O_V1_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5117
  { IMAGE_SAMPLE_CD_CL_O_V1_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5118
  { IMAGE_SAMPLE_CD_CL_O_V1_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5119
  { IMAGE_SAMPLE_CD_CL_O_V1_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x1, 0xB, 0x1 }, // 5120
  { IMAGE_SAMPLE_CD_CL_O_V2_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5121
  { IMAGE_SAMPLE_CD_CL_O_V2_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5122
  { IMAGE_SAMPLE_CD_CL_O_V2_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5123
  { IMAGE_SAMPLE_CD_CL_O_V2_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5124
  { IMAGE_SAMPLE_CD_CL_O_V2_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5125
  { IMAGE_SAMPLE_CD_CL_O_V2_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5126
  { IMAGE_SAMPLE_CD_CL_O_V2_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5127
  { IMAGE_SAMPLE_CD_CL_O_V2_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5128
  { IMAGE_SAMPLE_CD_CL_O_V2_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x2, 0xB, 0x1 }, // 5129
  { IMAGE_SAMPLE_CD_CL_O_V3_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5130
  { IMAGE_SAMPLE_CD_CL_O_V3_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5131
  { IMAGE_SAMPLE_CD_CL_O_V3_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5132
  { IMAGE_SAMPLE_CD_CL_O_V3_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5133
  { IMAGE_SAMPLE_CD_CL_O_V3_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5134
  { IMAGE_SAMPLE_CD_CL_O_V3_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5135
  { IMAGE_SAMPLE_CD_CL_O_V3_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5136
  { IMAGE_SAMPLE_CD_CL_O_V3_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5137
  { IMAGE_SAMPLE_CD_CL_O_V3_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x3, 0xB, 0x1 }, // 5138
  { IMAGE_SAMPLE_CD_CL_O_V4_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5139
  { IMAGE_SAMPLE_CD_CL_O_V4_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5140
  { IMAGE_SAMPLE_CD_CL_O_V4_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5141
  { IMAGE_SAMPLE_CD_CL_O_V4_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5142
  { IMAGE_SAMPLE_CD_CL_O_V4_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5143
  { IMAGE_SAMPLE_CD_CL_O_V4_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5144
  { IMAGE_SAMPLE_CD_CL_O_V4_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5145
  { IMAGE_SAMPLE_CD_CL_O_V4_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5146
  { IMAGE_SAMPLE_CD_CL_O_V4_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x4, 0xB, 0x1 }, // 5147
  { IMAGE_SAMPLE_CD_CL_O_V5_V3, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5148
  { IMAGE_SAMPLE_CD_CL_O_V5_V4, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5149
  { IMAGE_SAMPLE_CD_CL_O_V5_V5, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5150
  { IMAGE_SAMPLE_CD_CL_O_V5_V6, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5151
  { IMAGE_SAMPLE_CD_CL_O_V5_V7, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5152
  { IMAGE_SAMPLE_CD_CL_O_V5_V8, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5153
  { IMAGE_SAMPLE_CD_CL_O_V5_V9, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5154
  { IMAGE_SAMPLE_CD_CL_O_V5_V10, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5155
  { IMAGE_SAMPLE_CD_CL_O_V5_V11, IMAGE_SAMPLE_CD_CL_O, MIMGEncGfx6, 0x5, 0xB, 0x1 }, // 5156
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5157
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5158
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5159
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5160
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5161
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5162
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5163
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5164
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5165
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5166
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5167
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5168
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5169
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5170
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5171
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5172
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5173
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5174
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5175
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5176
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5177
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5178
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5179
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5180
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5181
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5182
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5183
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5184
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5185
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5186
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5187
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5188
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5189
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5190
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5191
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5192
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5193
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5194
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5195
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5196
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5197
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5198
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5199
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5200
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5201
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5202
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5203
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5204
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5205
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5206
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5207
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5208
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5209
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5210
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5211
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5212
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5213
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5214
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5215
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5216
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5217
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5218
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5219
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5220
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5221
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5222
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5223
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5224
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5225
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5226
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5227
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5228
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5229
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5230
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5231
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5232
  { IMAGE_SAMPLE_CD_CL_O_G16_V1_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5233
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5234
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5235
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5236
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5237
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5238
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5239
  { IMAGE_SAMPLE_CD_CL_O_G16_V2_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5240
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5241
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5242
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5243
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5244
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5245
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5246
  { IMAGE_SAMPLE_CD_CL_O_G16_V3_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5247
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5248
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5249
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5250
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5251
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5252
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5253
  { IMAGE_SAMPLE_CD_CL_O_G16_V4_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5254
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V3, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5255
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V4, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5256
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V5, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5257
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V6, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5258
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V7, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5259
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V8, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5260
  { IMAGE_SAMPLE_CD_CL_O_G16_V5_V9, IMAGE_SAMPLE_CD_CL_O_G16, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5261
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5262
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5263
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5264
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5265
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5266
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5267
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5268
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5269
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5270
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5271
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5272
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5273
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5274
  { IMAGE_SAMPLE_CD_CL_O_G16_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5275
  { IMAGE_SAMPLE_CD_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5276
  { IMAGE_SAMPLE_CD_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5277
  { IMAGE_SAMPLE_CD_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5278
  { IMAGE_SAMPLE_CD_CL_O_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5279
  { IMAGE_SAMPLE_CD_CL_O_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5280
  { IMAGE_SAMPLE_CD_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5281
  { IMAGE_SAMPLE_CD_CL_O_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5282
  { IMAGE_SAMPLE_CD_CL_O_nortn_V10_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 5283
  { IMAGE_SAMPLE_CD_CL_O_nortn_V11_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0xB, 0x1 }, // 5284
  { IMAGE_SAMPLE_CD_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5285
  { IMAGE_SAMPLE_CD_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5286
  { IMAGE_SAMPLE_CD_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5287
  { IMAGE_SAMPLE_CD_CL_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5288
  { IMAGE_SAMPLE_CD_CL_O_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5289
  { IMAGE_SAMPLE_CD_CL_O_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5290
  { IMAGE_SAMPLE_CD_CL_O_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5291
  { IMAGE_SAMPLE_CD_CL_O_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 5292
  { IMAGE_SAMPLE_CD_CL_O_nortn_V11_nsa_gfx10, IMAGE_SAMPLE_CD_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0xB, 0xB }, // 5293
  { IMAGE_SAMPLE_CD_CL_nortn_V2_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5294
  { IMAGE_SAMPLE_CD_CL_nortn_V3_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5295
  { IMAGE_SAMPLE_CD_CL_nortn_V4_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5296
  { IMAGE_SAMPLE_CD_CL_nortn_V5_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5297
  { IMAGE_SAMPLE_CD_CL_nortn_V6_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5298
  { IMAGE_SAMPLE_CD_CL_nortn_V7_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5299
  { IMAGE_SAMPLE_CD_CL_nortn_V8_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5300
  { IMAGE_SAMPLE_CD_CL_nortn_V9_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5301
  { IMAGE_SAMPLE_CD_CL_nortn_V10_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 5302
  { IMAGE_SAMPLE_CD_CL_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5303
  { IMAGE_SAMPLE_CD_CL_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5304
  { IMAGE_SAMPLE_CD_CL_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5305
  { IMAGE_SAMPLE_CD_CL_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5306
  { IMAGE_SAMPLE_CD_CL_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5307
  { IMAGE_SAMPLE_CD_CL_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5308
  { IMAGE_SAMPLE_CD_CL_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5309
  { IMAGE_SAMPLE_CD_CL_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5310
  { IMAGE_SAMPLE_CD_CL_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_CL_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 5311
  { IMAGE_SAMPLE_CD_G16_V1_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5312
  { IMAGE_SAMPLE_CD_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5313
  { IMAGE_SAMPLE_CD_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5314
  { IMAGE_SAMPLE_CD_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5315
  { IMAGE_SAMPLE_CD_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5316
  { IMAGE_SAMPLE_CD_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5317
  { IMAGE_SAMPLE_CD_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5318
  { IMAGE_SAMPLE_CD_G16_V2_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5319
  { IMAGE_SAMPLE_CD_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5320
  { IMAGE_SAMPLE_CD_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5321
  { IMAGE_SAMPLE_CD_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5322
  { IMAGE_SAMPLE_CD_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5323
  { IMAGE_SAMPLE_CD_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5324
  { IMAGE_SAMPLE_CD_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5325
  { IMAGE_SAMPLE_CD_G16_V3_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5326
  { IMAGE_SAMPLE_CD_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5327
  { IMAGE_SAMPLE_CD_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5328
  { IMAGE_SAMPLE_CD_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5329
  { IMAGE_SAMPLE_CD_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5330
  { IMAGE_SAMPLE_CD_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5331
  { IMAGE_SAMPLE_CD_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5332
  { IMAGE_SAMPLE_CD_G16_V4_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5333
  { IMAGE_SAMPLE_CD_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5334
  { IMAGE_SAMPLE_CD_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5335
  { IMAGE_SAMPLE_CD_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5336
  { IMAGE_SAMPLE_CD_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5337
  { IMAGE_SAMPLE_CD_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5338
  { IMAGE_SAMPLE_CD_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5339
  { IMAGE_SAMPLE_CD_G16_V5_V2_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5340
  { IMAGE_SAMPLE_CD_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5341
  { IMAGE_SAMPLE_CD_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5342
  { IMAGE_SAMPLE_CD_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5343
  { IMAGE_SAMPLE_CD_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5344
  { IMAGE_SAMPLE_CD_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5345
  { IMAGE_SAMPLE_CD_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5346
  { IMAGE_SAMPLE_CD_G16_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5347
  { IMAGE_SAMPLE_CD_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5348
  { IMAGE_SAMPLE_CD_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5349
  { IMAGE_SAMPLE_CD_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5350
  { IMAGE_SAMPLE_CD_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5351
  { IMAGE_SAMPLE_CD_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5352
  { IMAGE_SAMPLE_CD_G16_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5353
  { IMAGE_SAMPLE_CD_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5354
  { IMAGE_SAMPLE_CD_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5355
  { IMAGE_SAMPLE_CD_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5356
  { IMAGE_SAMPLE_CD_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5357
  { IMAGE_SAMPLE_CD_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5358
  { IMAGE_SAMPLE_CD_G16_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5359
  { IMAGE_SAMPLE_CD_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5360
  { IMAGE_SAMPLE_CD_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5361
  { IMAGE_SAMPLE_CD_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5362
  { IMAGE_SAMPLE_CD_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5363
  { IMAGE_SAMPLE_CD_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5364
  { IMAGE_SAMPLE_CD_G16_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5365
  { IMAGE_SAMPLE_CD_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5366
  { IMAGE_SAMPLE_CD_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5367
  { IMAGE_SAMPLE_CD_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5368
  { IMAGE_SAMPLE_CD_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5369
  { IMAGE_SAMPLE_CD_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5370
  { IMAGE_SAMPLE_CD_G16_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5371
  { IMAGE_SAMPLE_CD_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5372
  { IMAGE_SAMPLE_CD_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5373
  { IMAGE_SAMPLE_CD_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5374
  { IMAGE_SAMPLE_CD_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5375
  { IMAGE_SAMPLE_CD_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5376
  { IMAGE_SAMPLE_CD_G16_V1_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5377
  { IMAGE_SAMPLE_CD_G16_V1_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5378
  { IMAGE_SAMPLE_CD_G16_V1_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5379
  { IMAGE_SAMPLE_CD_G16_V1_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5380
  { IMAGE_SAMPLE_CD_G16_V1_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5381
  { IMAGE_SAMPLE_CD_G16_V1_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5382
  { IMAGE_SAMPLE_CD_G16_V1_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5383
  { IMAGE_SAMPLE_CD_G16_V2_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5384
  { IMAGE_SAMPLE_CD_G16_V2_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5385
  { IMAGE_SAMPLE_CD_G16_V2_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5386
  { IMAGE_SAMPLE_CD_G16_V2_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5387
  { IMAGE_SAMPLE_CD_G16_V2_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5388
  { IMAGE_SAMPLE_CD_G16_V2_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5389
  { IMAGE_SAMPLE_CD_G16_V2_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5390
  { IMAGE_SAMPLE_CD_G16_V3_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5391
  { IMAGE_SAMPLE_CD_G16_V3_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5392
  { IMAGE_SAMPLE_CD_G16_V3_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5393
  { IMAGE_SAMPLE_CD_G16_V3_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5394
  { IMAGE_SAMPLE_CD_G16_V3_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5395
  { IMAGE_SAMPLE_CD_G16_V3_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5396
  { IMAGE_SAMPLE_CD_G16_V3_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5397
  { IMAGE_SAMPLE_CD_G16_V4_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5398
  { IMAGE_SAMPLE_CD_G16_V4_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5399
  { IMAGE_SAMPLE_CD_G16_V4_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5400
  { IMAGE_SAMPLE_CD_G16_V4_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5401
  { IMAGE_SAMPLE_CD_G16_V4_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5402
  { IMAGE_SAMPLE_CD_G16_V4_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5403
  { IMAGE_SAMPLE_CD_G16_V4_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5404
  { IMAGE_SAMPLE_CD_G16_V5_V2, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5405
  { IMAGE_SAMPLE_CD_G16_V5_V3, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5406
  { IMAGE_SAMPLE_CD_G16_V5_V4, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5407
  { IMAGE_SAMPLE_CD_G16_V5_V5, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5408
  { IMAGE_SAMPLE_CD_G16_V5_V6, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5409
  { IMAGE_SAMPLE_CD_G16_V5_V7, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5410
  { IMAGE_SAMPLE_CD_G16_V5_V8, IMAGE_SAMPLE_CD_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5411
  { IMAGE_SAMPLE_CD_G16_nortn_V2_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5412
  { IMAGE_SAMPLE_CD_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5413
  { IMAGE_SAMPLE_CD_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5414
  { IMAGE_SAMPLE_CD_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5415
  { IMAGE_SAMPLE_CD_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5416
  { IMAGE_SAMPLE_CD_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5417
  { IMAGE_SAMPLE_CD_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5418
  { IMAGE_SAMPLE_CD_G16_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5419
  { IMAGE_SAMPLE_CD_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5420
  { IMAGE_SAMPLE_CD_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5421
  { IMAGE_SAMPLE_CD_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5422
  { IMAGE_SAMPLE_CD_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5423
  { IMAGE_SAMPLE_CD_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5424
  { IMAGE_SAMPLE_CD_O_V1_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5425
  { IMAGE_SAMPLE_CD_O_V1_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5426
  { IMAGE_SAMPLE_CD_O_V1_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5427
  { IMAGE_SAMPLE_CD_O_V1_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5428
  { IMAGE_SAMPLE_CD_O_V1_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5429
  { IMAGE_SAMPLE_CD_O_V1_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5430
  { IMAGE_SAMPLE_CD_O_V1_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0x9, 0x1 }, // 5431
  { IMAGE_SAMPLE_CD_O_V1_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x1, 0xA, 0x1 }, // 5432
  { IMAGE_SAMPLE_CD_O_V2_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5433
  { IMAGE_SAMPLE_CD_O_V2_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5434
  { IMAGE_SAMPLE_CD_O_V2_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5435
  { IMAGE_SAMPLE_CD_O_V2_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5436
  { IMAGE_SAMPLE_CD_O_V2_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5437
  { IMAGE_SAMPLE_CD_O_V2_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5438
  { IMAGE_SAMPLE_CD_O_V2_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0x9, 0x1 }, // 5439
  { IMAGE_SAMPLE_CD_O_V2_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x2, 0xA, 0x1 }, // 5440
  { IMAGE_SAMPLE_CD_O_V3_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5441
  { IMAGE_SAMPLE_CD_O_V3_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5442
  { IMAGE_SAMPLE_CD_O_V3_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5443
  { IMAGE_SAMPLE_CD_O_V3_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5444
  { IMAGE_SAMPLE_CD_O_V3_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5445
  { IMAGE_SAMPLE_CD_O_V3_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5446
  { IMAGE_SAMPLE_CD_O_V3_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0x9, 0x1 }, // 5447
  { IMAGE_SAMPLE_CD_O_V3_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x3, 0xA, 0x1 }, // 5448
  { IMAGE_SAMPLE_CD_O_V4_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5449
  { IMAGE_SAMPLE_CD_O_V4_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5450
  { IMAGE_SAMPLE_CD_O_V4_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5451
  { IMAGE_SAMPLE_CD_O_V4_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5452
  { IMAGE_SAMPLE_CD_O_V4_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5453
  { IMAGE_SAMPLE_CD_O_V4_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5454
  { IMAGE_SAMPLE_CD_O_V4_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0x9, 0x1 }, // 5455
  { IMAGE_SAMPLE_CD_O_V4_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x4, 0xA, 0x1 }, // 5456
  { IMAGE_SAMPLE_CD_O_V5_V3_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5457
  { IMAGE_SAMPLE_CD_O_V5_V4_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5458
  { IMAGE_SAMPLE_CD_O_V5_V5_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5459
  { IMAGE_SAMPLE_CD_O_V5_V6_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5460
  { IMAGE_SAMPLE_CD_O_V5_V7_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5461
  { IMAGE_SAMPLE_CD_O_V5_V8_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5462
  { IMAGE_SAMPLE_CD_O_V5_V9_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0x9, 0x1 }, // 5463
  { IMAGE_SAMPLE_CD_O_V5_V10_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10Default, 0x5, 0xA, 0x1 }, // 5464
  { IMAGE_SAMPLE_CD_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5465
  { IMAGE_SAMPLE_CD_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5466
  { IMAGE_SAMPLE_CD_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5467
  { IMAGE_SAMPLE_CD_O_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5468
  { IMAGE_SAMPLE_CD_O_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5469
  { IMAGE_SAMPLE_CD_O_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5470
  { IMAGE_SAMPLE_CD_O_V1_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0x9, 0x9 }, // 5471
  { IMAGE_SAMPLE_CD_O_V1_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x1, 0xA, 0xA }, // 5472
  { IMAGE_SAMPLE_CD_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5473
  { IMAGE_SAMPLE_CD_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5474
  { IMAGE_SAMPLE_CD_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5475
  { IMAGE_SAMPLE_CD_O_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5476
  { IMAGE_SAMPLE_CD_O_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5477
  { IMAGE_SAMPLE_CD_O_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5478
  { IMAGE_SAMPLE_CD_O_V2_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0x9, 0x9 }, // 5479
  { IMAGE_SAMPLE_CD_O_V2_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x2, 0xA, 0xA }, // 5480
  { IMAGE_SAMPLE_CD_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5481
  { IMAGE_SAMPLE_CD_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5482
  { IMAGE_SAMPLE_CD_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5483
  { IMAGE_SAMPLE_CD_O_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5484
  { IMAGE_SAMPLE_CD_O_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5485
  { IMAGE_SAMPLE_CD_O_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5486
  { IMAGE_SAMPLE_CD_O_V3_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0x9, 0x9 }, // 5487
  { IMAGE_SAMPLE_CD_O_V3_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x3, 0xA, 0xA }, // 5488
  { IMAGE_SAMPLE_CD_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5489
  { IMAGE_SAMPLE_CD_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5490
  { IMAGE_SAMPLE_CD_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5491
  { IMAGE_SAMPLE_CD_O_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5492
  { IMAGE_SAMPLE_CD_O_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5493
  { IMAGE_SAMPLE_CD_O_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5494
  { IMAGE_SAMPLE_CD_O_V4_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0x9, 0x9 }, // 5495
  { IMAGE_SAMPLE_CD_O_V4_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x4, 0xA, 0xA }, // 5496
  { IMAGE_SAMPLE_CD_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5497
  { IMAGE_SAMPLE_CD_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5498
  { IMAGE_SAMPLE_CD_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5499
  { IMAGE_SAMPLE_CD_O_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5500
  { IMAGE_SAMPLE_CD_O_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5501
  { IMAGE_SAMPLE_CD_O_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5502
  { IMAGE_SAMPLE_CD_O_V5_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0x9, 0x9 }, // 5503
  { IMAGE_SAMPLE_CD_O_V5_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O, MIMGEncGfx10NSA, 0x5, 0xA, 0xA }, // 5504
  { IMAGE_SAMPLE_CD_O_V1_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5505
  { IMAGE_SAMPLE_CD_O_V1_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5506
  { IMAGE_SAMPLE_CD_O_V1_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5507
  { IMAGE_SAMPLE_CD_O_V1_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5508
  { IMAGE_SAMPLE_CD_O_V1_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5509
  { IMAGE_SAMPLE_CD_O_V1_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5510
  { IMAGE_SAMPLE_CD_O_V1_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0x9, 0x1 }, // 5511
  { IMAGE_SAMPLE_CD_O_V1_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x1, 0xA, 0x1 }, // 5512
  { IMAGE_SAMPLE_CD_O_V2_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5513
  { IMAGE_SAMPLE_CD_O_V2_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5514
  { IMAGE_SAMPLE_CD_O_V2_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5515
  { IMAGE_SAMPLE_CD_O_V2_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5516
  { IMAGE_SAMPLE_CD_O_V2_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5517
  { IMAGE_SAMPLE_CD_O_V2_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5518
  { IMAGE_SAMPLE_CD_O_V2_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0x9, 0x1 }, // 5519
  { IMAGE_SAMPLE_CD_O_V2_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x2, 0xA, 0x1 }, // 5520
  { IMAGE_SAMPLE_CD_O_V3_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5521
  { IMAGE_SAMPLE_CD_O_V3_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5522
  { IMAGE_SAMPLE_CD_O_V3_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5523
  { IMAGE_SAMPLE_CD_O_V3_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5524
  { IMAGE_SAMPLE_CD_O_V3_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5525
  { IMAGE_SAMPLE_CD_O_V3_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5526
  { IMAGE_SAMPLE_CD_O_V3_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0x9, 0x1 }, // 5527
  { IMAGE_SAMPLE_CD_O_V3_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x3, 0xA, 0x1 }, // 5528
  { IMAGE_SAMPLE_CD_O_V4_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5529
  { IMAGE_SAMPLE_CD_O_V4_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5530
  { IMAGE_SAMPLE_CD_O_V4_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5531
  { IMAGE_SAMPLE_CD_O_V4_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5532
  { IMAGE_SAMPLE_CD_O_V4_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5533
  { IMAGE_SAMPLE_CD_O_V4_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5534
  { IMAGE_SAMPLE_CD_O_V4_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0x9, 0x1 }, // 5535
  { IMAGE_SAMPLE_CD_O_V4_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x4, 0xA, 0x1 }, // 5536
  { IMAGE_SAMPLE_CD_O_V5_V3, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5537
  { IMAGE_SAMPLE_CD_O_V5_V4, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5538
  { IMAGE_SAMPLE_CD_O_V5_V5, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5539
  { IMAGE_SAMPLE_CD_O_V5_V6, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5540
  { IMAGE_SAMPLE_CD_O_V5_V7, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5541
  { IMAGE_SAMPLE_CD_O_V5_V8, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5542
  { IMAGE_SAMPLE_CD_O_V5_V9, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0x9, 0x1 }, // 5543
  { IMAGE_SAMPLE_CD_O_V5_V10, IMAGE_SAMPLE_CD_O, MIMGEncGfx6, 0x5, 0xA, 0x1 }, // 5544
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5545
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5546
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5547
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x6, 0x1 }, // 5548
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x7, 0x1 }, // 5549
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5550
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5551
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5552
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5553
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x6, 0x1 }, // 5554
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x7, 0x1 }, // 5555
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5556
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5557
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5558
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5559
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x6, 0x1 }, // 5560
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x7, 0x1 }, // 5561
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5562
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5563
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5564
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5565
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x6, 0x1 }, // 5566
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x7, 0x1 }, // 5567
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5568
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5569
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5570
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5571
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x6, 0x1 }, // 5572
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x7, 0x1 }, // 5573
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5574
  { IMAGE_SAMPLE_CD_O_G16_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5575
  { IMAGE_SAMPLE_CD_O_G16_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5576
  { IMAGE_SAMPLE_CD_O_G16_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5577
  { IMAGE_SAMPLE_CD_O_G16_V1_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x6, 0x6 }, // 5578
  { IMAGE_SAMPLE_CD_O_G16_V1_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x7, 0x7 }, // 5579
  { IMAGE_SAMPLE_CD_O_G16_V1_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x1, 0x8, 0x8 }, // 5580
  { IMAGE_SAMPLE_CD_O_G16_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5581
  { IMAGE_SAMPLE_CD_O_G16_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5582
  { IMAGE_SAMPLE_CD_O_G16_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5583
  { IMAGE_SAMPLE_CD_O_G16_V2_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x6, 0x6 }, // 5584
  { IMAGE_SAMPLE_CD_O_G16_V2_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x7, 0x7 }, // 5585
  { IMAGE_SAMPLE_CD_O_G16_V2_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x2, 0x8, 0x8 }, // 5586
  { IMAGE_SAMPLE_CD_O_G16_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5587
  { IMAGE_SAMPLE_CD_O_G16_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5588
  { IMAGE_SAMPLE_CD_O_G16_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5589
  { IMAGE_SAMPLE_CD_O_G16_V3_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x6, 0x6 }, // 5590
  { IMAGE_SAMPLE_CD_O_G16_V3_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x7, 0x7 }, // 5591
  { IMAGE_SAMPLE_CD_O_G16_V3_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x3, 0x8, 0x8 }, // 5592
  { IMAGE_SAMPLE_CD_O_G16_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5593
  { IMAGE_SAMPLE_CD_O_G16_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5594
  { IMAGE_SAMPLE_CD_O_G16_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5595
  { IMAGE_SAMPLE_CD_O_G16_V4_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x6, 0x6 }, // 5596
  { IMAGE_SAMPLE_CD_O_G16_V4_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x7, 0x7 }, // 5597
  { IMAGE_SAMPLE_CD_O_G16_V4_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x4, 0x8, 0x8 }, // 5598
  { IMAGE_SAMPLE_CD_O_G16_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5599
  { IMAGE_SAMPLE_CD_O_G16_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5600
  { IMAGE_SAMPLE_CD_O_G16_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5601
  { IMAGE_SAMPLE_CD_O_G16_V5_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x6, 0x6 }, // 5602
  { IMAGE_SAMPLE_CD_O_G16_V5_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x7, 0x7 }, // 5603
  { IMAGE_SAMPLE_CD_O_G16_V5_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx10NSA, 0x5, 0x8, 0x8 }, // 5604
  { IMAGE_SAMPLE_CD_O_G16_V1_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5605
  { IMAGE_SAMPLE_CD_O_G16_V1_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5606
  { IMAGE_SAMPLE_CD_O_G16_V1_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5607
  { IMAGE_SAMPLE_CD_O_G16_V1_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x6, 0x1 }, // 5608
  { IMAGE_SAMPLE_CD_O_G16_V1_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x7, 0x1 }, // 5609
  { IMAGE_SAMPLE_CD_O_G16_V1_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5610
  { IMAGE_SAMPLE_CD_O_G16_V2_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5611
  { IMAGE_SAMPLE_CD_O_G16_V2_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5612
  { IMAGE_SAMPLE_CD_O_G16_V2_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5613
  { IMAGE_SAMPLE_CD_O_G16_V2_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x6, 0x1 }, // 5614
  { IMAGE_SAMPLE_CD_O_G16_V2_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x7, 0x1 }, // 5615
  { IMAGE_SAMPLE_CD_O_G16_V2_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5616
  { IMAGE_SAMPLE_CD_O_G16_V3_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5617
  { IMAGE_SAMPLE_CD_O_G16_V3_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5618
  { IMAGE_SAMPLE_CD_O_G16_V3_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5619
  { IMAGE_SAMPLE_CD_O_G16_V3_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x6, 0x1 }, // 5620
  { IMAGE_SAMPLE_CD_O_G16_V3_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x7, 0x1 }, // 5621
  { IMAGE_SAMPLE_CD_O_G16_V3_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5622
  { IMAGE_SAMPLE_CD_O_G16_V4_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5623
  { IMAGE_SAMPLE_CD_O_G16_V4_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5624
  { IMAGE_SAMPLE_CD_O_G16_V4_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5625
  { IMAGE_SAMPLE_CD_O_G16_V4_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x6, 0x1 }, // 5626
  { IMAGE_SAMPLE_CD_O_G16_V4_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x7, 0x1 }, // 5627
  { IMAGE_SAMPLE_CD_O_G16_V4_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5628
  { IMAGE_SAMPLE_CD_O_G16_V5_V3, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5629
  { IMAGE_SAMPLE_CD_O_G16_V5_V4, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5630
  { IMAGE_SAMPLE_CD_O_G16_V5_V5, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5631
  { IMAGE_SAMPLE_CD_O_G16_V5_V6, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x6, 0x1 }, // 5632
  { IMAGE_SAMPLE_CD_O_G16_V5_V7, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x7, 0x1 }, // 5633
  { IMAGE_SAMPLE_CD_O_G16_V5_V8, IMAGE_SAMPLE_CD_O_G16, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5634
  { IMAGE_SAMPLE_CD_O_G16_nortn_V3_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5635
  { IMAGE_SAMPLE_CD_O_G16_nortn_V4_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5636
  { IMAGE_SAMPLE_CD_O_G16_nortn_V5_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5637
  { IMAGE_SAMPLE_CD_O_G16_nortn_V6_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5638
  { IMAGE_SAMPLE_CD_O_G16_nortn_V7_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5639
  { IMAGE_SAMPLE_CD_O_G16_nortn_V8_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5640
  { IMAGE_SAMPLE_CD_O_G16_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5641
  { IMAGE_SAMPLE_CD_O_G16_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5642
  { IMAGE_SAMPLE_CD_O_G16_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5643
  { IMAGE_SAMPLE_CD_O_G16_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5644
  { IMAGE_SAMPLE_CD_O_G16_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5645
  { IMAGE_SAMPLE_CD_O_G16_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_G16_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5646
  { IMAGE_SAMPLE_CD_O_nortn_V3_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5647
  { IMAGE_SAMPLE_CD_O_nortn_V4_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5648
  { IMAGE_SAMPLE_CD_O_nortn_V5_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5649
  { IMAGE_SAMPLE_CD_O_nortn_V6_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5650
  { IMAGE_SAMPLE_CD_O_nortn_V7_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5651
  { IMAGE_SAMPLE_CD_O_nortn_V8_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5652
  { IMAGE_SAMPLE_CD_O_nortn_V9_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5653
  { IMAGE_SAMPLE_CD_O_nortn_V10_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10Default, 0x0, 0xA, 0x1 }, // 5654
  { IMAGE_SAMPLE_CD_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5655
  { IMAGE_SAMPLE_CD_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5656
  { IMAGE_SAMPLE_CD_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5657
  { IMAGE_SAMPLE_CD_O_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5658
  { IMAGE_SAMPLE_CD_O_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5659
  { IMAGE_SAMPLE_CD_O_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5660
  { IMAGE_SAMPLE_CD_O_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5661
  { IMAGE_SAMPLE_CD_O_nortn_V10_nsa_gfx10, IMAGE_SAMPLE_CD_O_nortn, MIMGEncGfx10NSA, 0x0, 0xA, 0xA }, // 5662
  { IMAGE_SAMPLE_CD_nortn_V2_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5663
  { IMAGE_SAMPLE_CD_nortn_V3_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5664
  { IMAGE_SAMPLE_CD_nortn_V4_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5665
  { IMAGE_SAMPLE_CD_nortn_V5_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5666
  { IMAGE_SAMPLE_CD_nortn_V6_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x6, 0x1 }, // 5667
  { IMAGE_SAMPLE_CD_nortn_V7_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x7, 0x1 }, // 5668
  { IMAGE_SAMPLE_CD_nortn_V8_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5669
  { IMAGE_SAMPLE_CD_nortn_V9_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10Default, 0x0, 0x9, 0x1 }, // 5670
  { IMAGE_SAMPLE_CD_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5671
  { IMAGE_SAMPLE_CD_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5672
  { IMAGE_SAMPLE_CD_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5673
  { IMAGE_SAMPLE_CD_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5674
  { IMAGE_SAMPLE_CD_nortn_V6_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x6, 0x6 }, // 5675
  { IMAGE_SAMPLE_CD_nortn_V7_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x7, 0x7 }, // 5676
  { IMAGE_SAMPLE_CD_nortn_V8_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x8, 0x8 }, // 5677
  { IMAGE_SAMPLE_CD_nortn_V9_nsa_gfx10, IMAGE_SAMPLE_CD_nortn, MIMGEncGfx10NSA, 0x0, 0x9, 0x9 }, // 5678
  { IMAGE_SAMPLE_CL_V1_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x1, 0x1 }, // 5679
  { IMAGE_SAMPLE_CL_V1_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5680
  { IMAGE_SAMPLE_CL_V1_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5681
  { IMAGE_SAMPLE_CL_V1_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5682
  { IMAGE_SAMPLE_CL_V2_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x1, 0x1 }, // 5683
  { IMAGE_SAMPLE_CL_V2_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5684
  { IMAGE_SAMPLE_CL_V2_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5685
  { IMAGE_SAMPLE_CL_V2_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5686
  { IMAGE_SAMPLE_CL_V3_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x1, 0x1 }, // 5687
  { IMAGE_SAMPLE_CL_V3_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5688
  { IMAGE_SAMPLE_CL_V3_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5689
  { IMAGE_SAMPLE_CL_V3_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5690
  { IMAGE_SAMPLE_CL_V4_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x1, 0x1 }, // 5691
  { IMAGE_SAMPLE_CL_V4_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5692
  { IMAGE_SAMPLE_CL_V4_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5693
  { IMAGE_SAMPLE_CL_V4_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5694
  { IMAGE_SAMPLE_CL_V5_V1_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x1, 0x1 }, // 5695
  { IMAGE_SAMPLE_CL_V5_V2_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5696
  { IMAGE_SAMPLE_CL_V5_V3_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5697
  { IMAGE_SAMPLE_CL_V5_V4_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5698
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5699
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5700
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5701
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5702
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5703
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5704
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5705
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5706
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5707
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5708
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5709
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5710
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5711
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5712
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5713
  { IMAGE_SAMPLE_CL_V1_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x1, 0x1 }, // 5714
  { IMAGE_SAMPLE_CL_V1_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 5715
  { IMAGE_SAMPLE_CL_V1_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5716
  { IMAGE_SAMPLE_CL_V1_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5717
  { IMAGE_SAMPLE_CL_V2_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x1, 0x1 }, // 5718
  { IMAGE_SAMPLE_CL_V2_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 5719
  { IMAGE_SAMPLE_CL_V2_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5720
  { IMAGE_SAMPLE_CL_V2_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5721
  { IMAGE_SAMPLE_CL_V3_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x1, 0x1 }, // 5722
  { IMAGE_SAMPLE_CL_V3_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 5723
  { IMAGE_SAMPLE_CL_V3_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5724
  { IMAGE_SAMPLE_CL_V3_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5725
  { IMAGE_SAMPLE_CL_V4_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x1, 0x1 }, // 5726
  { IMAGE_SAMPLE_CL_V4_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5727
  { IMAGE_SAMPLE_CL_V4_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5728
  { IMAGE_SAMPLE_CL_V4_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5729
  { IMAGE_SAMPLE_CL_V5_V1_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x1, 0x1 }, // 5730
  { IMAGE_SAMPLE_CL_V5_V2_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5731
  { IMAGE_SAMPLE_CL_V5_V3_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5732
  { IMAGE_SAMPLE_CL_V5_V4_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5733
  { IMAGE_SAMPLE_CL_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5734
  { IMAGE_SAMPLE_CL_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5735
  { IMAGE_SAMPLE_CL_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5736
  { IMAGE_SAMPLE_CL_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 5737
  { IMAGE_SAMPLE_CL_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5738
  { IMAGE_SAMPLE_CL_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5739
  { IMAGE_SAMPLE_CL_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 5740
  { IMAGE_SAMPLE_CL_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5741
  { IMAGE_SAMPLE_CL_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5742
  { IMAGE_SAMPLE_CL_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 5743
  { IMAGE_SAMPLE_CL_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5744
  { IMAGE_SAMPLE_CL_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5745
  { IMAGE_SAMPLE_CL_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 5746
  { IMAGE_SAMPLE_CL_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5747
  { IMAGE_SAMPLE_CL_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5748
  { IMAGE_SAMPLE_CL_V1_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x1, 0x1 }, // 5749
  { IMAGE_SAMPLE_CL_V1_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 5750
  { IMAGE_SAMPLE_CL_V1_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5751
  { IMAGE_SAMPLE_CL_V1_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5752
  { IMAGE_SAMPLE_CL_V2_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x1, 0x1 }, // 5753
  { IMAGE_SAMPLE_CL_V2_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 5754
  { IMAGE_SAMPLE_CL_V2_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5755
  { IMAGE_SAMPLE_CL_V2_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5756
  { IMAGE_SAMPLE_CL_V3_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x1, 0x1 }, // 5757
  { IMAGE_SAMPLE_CL_V3_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 5758
  { IMAGE_SAMPLE_CL_V3_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5759
  { IMAGE_SAMPLE_CL_V3_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5760
  { IMAGE_SAMPLE_CL_V4_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x1, 0x1 }, // 5761
  { IMAGE_SAMPLE_CL_V4_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 5762
  { IMAGE_SAMPLE_CL_V4_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5763
  { IMAGE_SAMPLE_CL_V4_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5764
  { IMAGE_SAMPLE_CL_V5_V1_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x1, 0x1 }, // 5765
  { IMAGE_SAMPLE_CL_V5_V2_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 5766
  { IMAGE_SAMPLE_CL_V5_V3_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5767
  { IMAGE_SAMPLE_CL_V5_V4_gfx12, IMAGE_SAMPLE_CL, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5768
  { IMAGE_SAMPLE_CL_V1_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x1, 0x1 }, // 5769
  { IMAGE_SAMPLE_CL_V1_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5770
  { IMAGE_SAMPLE_CL_V1_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5771
  { IMAGE_SAMPLE_CL_V1_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5772
  { IMAGE_SAMPLE_CL_V2_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x1, 0x1 }, // 5773
  { IMAGE_SAMPLE_CL_V2_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5774
  { IMAGE_SAMPLE_CL_V2_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5775
  { IMAGE_SAMPLE_CL_V2_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5776
  { IMAGE_SAMPLE_CL_V3_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x1, 0x1 }, // 5777
  { IMAGE_SAMPLE_CL_V3_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5778
  { IMAGE_SAMPLE_CL_V3_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5779
  { IMAGE_SAMPLE_CL_V3_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5780
  { IMAGE_SAMPLE_CL_V4_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x1, 0x1 }, // 5781
  { IMAGE_SAMPLE_CL_V4_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5782
  { IMAGE_SAMPLE_CL_V4_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5783
  { IMAGE_SAMPLE_CL_V4_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5784
  { IMAGE_SAMPLE_CL_V5_V1, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x1, 0x1 }, // 5785
  { IMAGE_SAMPLE_CL_V5_V2, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5786
  { IMAGE_SAMPLE_CL_V5_V3, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5787
  { IMAGE_SAMPLE_CL_V5_V4, IMAGE_SAMPLE_CL, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5788
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x2, 0x1 }, // 5789
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x3, 0x1 }, // 5790
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x4, 0x1 }, // 5791
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x5, 0x1 }, // 5792
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x1, 0x8, 0x1 }, // 5793
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x2, 0x1 }, // 5794
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x3, 0x1 }, // 5795
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x4, 0x1 }, // 5796
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x5, 0x1 }, // 5797
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x2, 0x8, 0x1 }, // 5798
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x2, 0x1 }, // 5799
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x3, 0x1 }, // 5800
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x4, 0x1 }, // 5801
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x5, 0x1 }, // 5802
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x3, 0x8, 0x1 }, // 5803
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x2, 0x1 }, // 5804
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x3, 0x1 }, // 5805
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x4, 0x1 }, // 5806
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x5, 0x1 }, // 5807
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x4, 0x8, 0x1 }, // 5808
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x2, 0x1 }, // 5809
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x3, 0x1 }, // 5810
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x4, 0x1 }, // 5811
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x5, 0x1 }, // 5812
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10Default, 0x5, 0x8, 0x1 }, // 5813
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x2, 0x2 }, // 5814
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x3, 0x3 }, // 5815
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x4, 0x4 }, // 5816
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x1, 0x5, 0x5 }, // 5817
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x2, 0x2 }, // 5818
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x3, 0x3 }, // 5819
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x4, 0x4 }, // 5820
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x2, 0x5, 0x5 }, // 5821
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x2, 0x2 }, // 5822
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x3, 0x3 }, // 5823
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x4, 0x4 }, // 5824
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x3, 0x5, 0x5 }, // 5825
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x2, 0x2 }, // 5826
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x3, 0x3 }, // 5827
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x4, 0x4 }, // 5828
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x4, 0x5, 0x5 }, // 5829
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x2, 0x2 }, // 5830
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x3, 0x3 }, // 5831
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x4, 0x4 }, // 5832
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O, MIMGEncGfx10NSA, 0x5, 0x5, 0x5 }, // 5833
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x2, 0x1 }, // 5834
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x3, 0x1 }, // 5835
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x4, 0x1 }, // 5836
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x5, 0x1 }, // 5837
  { IMAGE_SAMPLE_CL_O_V1_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x1, 0x8, 0x1 }, // 5838
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x2, 0x1 }, // 5839
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x3, 0x1 }, // 5840
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x4, 0x1 }, // 5841
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x5, 0x1 }, // 5842
  { IMAGE_SAMPLE_CL_O_V2_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x2, 0x8, 0x1 }, // 5843
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x2, 0x1 }, // 5844
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x3, 0x1 }, // 5845
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x4, 0x1 }, // 5846
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x5, 0x1 }, // 5847
  { IMAGE_SAMPLE_CL_O_V3_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x3, 0x8, 0x1 }, // 5848
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x2, 0x1 }, // 5849
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x3, 0x1 }, // 5850
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x4, 0x1 }, // 5851
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x5, 0x1 }, // 5852
  { IMAGE_SAMPLE_CL_O_V4_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x4, 0x8, 0x1 }, // 5853
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x2, 0x1 }, // 5854
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x3, 0x1 }, // 5855
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x4, 0x1 }, // 5856
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x5, 0x1 }, // 5857
  { IMAGE_SAMPLE_CL_O_V5_V8_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11Default, 0x5, 0x8, 0x1 }, // 5858
  { IMAGE_SAMPLE_CL_O_V1_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x2, 0x2 }, // 5859
  { IMAGE_SAMPLE_CL_O_V1_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x3, 0x3 }, // 5860
  { IMAGE_SAMPLE_CL_O_V1_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x4, 0x4 }, // 5861
  { IMAGE_SAMPLE_CL_O_V1_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x1, 0x5, 0x5 }, // 5862
  { IMAGE_SAMPLE_CL_O_V2_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x2, 0x2 }, // 5863
  { IMAGE_SAMPLE_CL_O_V2_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x3, 0x3 }, // 5864
  { IMAGE_SAMPLE_CL_O_V2_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x4, 0x4 }, // 5865
  { IMAGE_SAMPLE_CL_O_V2_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x2, 0x5, 0x5 }, // 5866
  { IMAGE_SAMPLE_CL_O_V3_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x2, 0x2 }, // 5867
  { IMAGE_SAMPLE_CL_O_V3_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x3, 0x3 }, // 5868
  { IMAGE_SAMPLE_CL_O_V3_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x4, 0x4 }, // 5869
  { IMAGE_SAMPLE_CL_O_V3_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x3, 0x5, 0x5 }, // 5870
  { IMAGE_SAMPLE_CL_O_V4_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x2, 0x2 }, // 5871
  { IMAGE_SAMPLE_CL_O_V4_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x3, 0x3 }, // 5872
  { IMAGE_SAMPLE_CL_O_V4_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x4, 0x4 }, // 5873
  { IMAGE_SAMPLE_CL_O_V4_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x4, 0x5, 0x5 }, // 5874
  { IMAGE_SAMPLE_CL_O_V5_V2_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x2, 0x2 }, // 5875
  { IMAGE_SAMPLE_CL_O_V5_V3_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x3, 0x3 }, // 5876
  { IMAGE_SAMPLE_CL_O_V5_V4_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x4, 0x4 }, // 5877
  { IMAGE_SAMPLE_CL_O_V5_V5_nsa_gfx11, IMAGE_SAMPLE_CL_O, MIMGEncGfx11NSA, 0x5, 0x5, 0x5 }, // 5878
  { IMAGE_SAMPLE_CL_O_V1_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x2, 0x2 }, // 5879
  { IMAGE_SAMPLE_CL_O_V1_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x3, 0x3 }, // 5880
  { IMAGE_SAMPLE_CL_O_V1_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x4, 0x4 }, // 5881
  { IMAGE_SAMPLE_CL_O_V1_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x1, 0x5, 0x5 }, // 5882
  { IMAGE_SAMPLE_CL_O_V2_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x2, 0x2 }, // 5883
  { IMAGE_SAMPLE_CL_O_V2_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x3, 0x3 }, // 5884
  { IMAGE_SAMPLE_CL_O_V2_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x4, 0x4 }, // 5885
  { IMAGE_SAMPLE_CL_O_V2_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x2, 0x5, 0x5 }, // 5886
  { IMAGE_SAMPLE_CL_O_V3_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x2, 0x2 }, // 5887
  { IMAGE_SAMPLE_CL_O_V3_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x3, 0x3 }, // 5888
  { IMAGE_SAMPLE_CL_O_V3_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x4, 0x4 }, // 5889
  { IMAGE_SAMPLE_CL_O_V3_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x3, 0x5, 0x5 }, // 5890
  { IMAGE_SAMPLE_CL_O_V4_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x2, 0x2 }, // 5891
  { IMAGE_SAMPLE_CL_O_V4_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x3, 0x3 }, // 5892
  { IMAGE_SAMPLE_CL_O_V4_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x4, 0x4 }, // 5893
  { IMAGE_SAMPLE_CL_O_V4_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x4, 0x5, 0x5 }, // 5894
  { IMAGE_SAMPLE_CL_O_V5_V2_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x2, 0x2 }, // 5895
  { IMAGE_SAMPLE_CL_O_V5_V3_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x3, 0x3 }, // 5896
  { IMAGE_SAMPLE_CL_O_V5_V4_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x4, 0x4 }, // 5897
  { IMAGE_SAMPLE_CL_O_V5_V5_gfx12, IMAGE_SAMPLE_CL_O, MIMGEncGfx12, 0x5, 0x5, 0x5 }, // 5898
  { IMAGE_SAMPLE_CL_O_V1_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x2, 0x1 }, // 5899
  { IMAGE_SAMPLE_CL_O_V1_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x3, 0x1 }, // 5900
  { IMAGE_SAMPLE_CL_O_V1_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x4, 0x1 }, // 5901
  { IMAGE_SAMPLE_CL_O_V1_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x5, 0x1 }, // 5902
  { IMAGE_SAMPLE_CL_O_V1_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x1, 0x8, 0x1 }, // 5903
  { IMAGE_SAMPLE_CL_O_V2_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x2, 0x1 }, // 5904
  { IMAGE_SAMPLE_CL_O_V2_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x3, 0x1 }, // 5905
  { IMAGE_SAMPLE_CL_O_V2_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x4, 0x1 }, // 5906
  { IMAGE_SAMPLE_CL_O_V2_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x5, 0x1 }, // 5907
  { IMAGE_SAMPLE_CL_O_V2_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x2, 0x8, 0x1 }, // 5908
  { IMAGE_SAMPLE_CL_O_V3_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x2, 0x1 }, // 5909
  { IMAGE_SAMPLE_CL_O_V3_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x3, 0x1 }, // 5910
  { IMAGE_SAMPLE_CL_O_V3_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x4, 0x1 }, // 5911
  { IMAGE_SAMPLE_CL_O_V3_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x5, 0x1 }, // 5912
  { IMAGE_SAMPLE_CL_O_V3_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x3, 0x8, 0x1 }, // 5913
  { IMAGE_SAMPLE_CL_O_V4_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x2, 0x1 }, // 5914
  { IMAGE_SAMPLE_CL_O_V4_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x3, 0x1 }, // 5915
  { IMAGE_SAMPLE_CL_O_V4_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x4, 0x1 }, // 5916
  { IMAGE_SAMPLE_CL_O_V4_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x5, 0x1 }, // 5917
  { IMAGE_SAMPLE_CL_O_V4_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x4, 0x8, 0x1 }, // 5918
  { IMAGE_SAMPLE_CL_O_V5_V2, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x2, 0x1 }, // 5919
  { IMAGE_SAMPLE_CL_O_V5_V3, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x3, 0x1 }, // 5920
  { IMAGE_SAMPLE_CL_O_V5_V4, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x4, 0x1 }, // 5921
  { IMAGE_SAMPLE_CL_O_V5_V5, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x5, 0x1 }, // 5922
  { IMAGE_SAMPLE_CL_O_V5_V8, IMAGE_SAMPLE_CL_O, MIMGEncGfx6, 0x5, 0x8, 0x1 }, // 5923
  { IMAGE_SAMPLE_CL_O_nortn_V2_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x2, 0x1 }, // 5924
  { IMAGE_SAMPLE_CL_O_nortn_V3_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x3, 0x1 }, // 5925
  { IMAGE_SAMPLE_CL_O_nortn_V4_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x4, 0x1 }, // 5926
  { IMAGE_SAMPLE_CL_O_nortn_V5_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x5, 0x1 }, // 5927
  { IMAGE_SAMPLE_CL_O_nortn_V8_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10Default, 0x0, 0x8, 0x1 }, // 5928
  { IMAGE_SAMPLE_CL_O_nortn_V2_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x2, 0x2 }, // 5929
  { IMAGE_SAMPLE_CL_O_nortn_V3_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x3, 0x3 }, // 5930
  { IMAGE_SAMPLE_CL_O_nortn_V4_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x4, 0x4 }, // 5931
  { IMAGE_SAMPLE_CL_O_nortn_V5_nsa_gfx10, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx10NSA, 0x0, 0x5, 0x5 }, // 5932
  { IMAGE_SAMPLE_CL_O_nortn_V2_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x2, 0x1 }, // 5933
  { IMAGE_SAMPLE_CL_O_nortn_V3_gfx11, IMAGE_SAMPLE_CL_O_nortn, MIMGEncGfx11Default, 0x0, 0x3, 0x1 }, // 5934
  { 