/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the AMDGPU target                          *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 152;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(AMDGPUInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(AMDGPUInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static AMDGPUInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static AMDGPUInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(6),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_p1s64,
  GILLT_p2s32,
  GILLT_p3s32,
  GILLT_p4s64,
  GILLT_p5s32,
  GILLT_p6s32,
  GILLT_s1,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s16,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v3s32,
  GILLT_v3s64,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v5s32,
  GILLT_v6s32,
  GILLT_v7s32,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v9s32,
  GILLT_v10s32,
  GILLT_v11s32,
  GILLT_v12s32,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v16s64,
  GILLT_v32s16,
  GILLT_v32s32,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::pointer(1, 64),
  LLT::pointer(2, 32),
  LLT::pointer(3, 32),
  LLT::pointer(4, 64),
  LLT::pointer(5, 32),
  LLT::pointer(6, 32),
  LLT::scalar(1),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 16),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(3), 32),
  LLT::vector(ElementCount::getFixed(3), 64),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(5), 32),
  LLT::vector(ElementCount::getFixed(6), 32),
  LLT::vector(ElementCount::getFixed(7), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(9), 32),
  LLT::vector(ElementCount::getFixed(10), 32),
  LLT::vector(ElementCount::getFixed(11), 32),
  LLT::vector(ElementCount::getFixed(12), 32),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(16), 64),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(32), 32),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_FalsePredicateBit = 136,
  Feature_isGFX6Bit = 61,
  Feature_isGFX6GFX7Bit = 12,
  Feature_isGFX6GFX7GFX10Bit = 133,
  Feature_isGFX7OnlyBit = 102,
  Feature_isGFX7GFX8GFX9Bit = 56,
  Feature_isGFX6GFX7GFX8GFX9Bit = 77,
  Feature_isGFX6GFX7GFX8GFX9GFX10Bit = 148,
  Feature_isNotGFX12PlusBit = 26,
  Feature_isGFX8GFX9GFX10GFX11Bit = 28,
  Feature_isGFX7PlusBit = 18,
  Feature_isGFX8PlusBit = 4,
  Feature_isGFX8OnlyBit = 29,
  Feature_isGFX9PlusBit = 0,
  Feature_isNotGFX9PlusBit = 67,
  Feature_isGFX90APlusBit = 49,
  Feature_isNotGFX90APlusBit = 30,
  Feature_isGFX908orGFX90ABit = 50,
  Feature_isGFX940PlusBit = 51,
  Feature_isNotGFX940PlusBit = 62,
  Feature_HasGFX950InstsBit = 35,
  Feature_isGFX8GFX9Bit = 21,
  Feature_isGFX10OnlyBit = 20,
  Feature_isGFX10PlusBit = 9,
  Feature_isGFX9GFX10Bit = 68,
  Feature_isGFX11OnlyBit = 74,
  Feature_isGFX11PlusBit = 1,
  Feature_isGFX12OnlyBit = 75,
  Feature_isGFX12PlusBit = 3,
  Feature_isGFX12PlusNot12_50Bit = 73,
  Feature_isGFX125xOnlyBit = 36,
  Feature_isGFX1250PlusBit = 8,
  Feature_isNotGFX1250PlusBit = 5,
  Feature_HasIEEEMinimumMaximumInstsBit = 23,
  Feature_HasMinimum3Maximum3F32Bit = 27,
  Feature_HasMinimum3Maximum3F16Bit = 32,
  Feature_HasMin3Max3PKF16Bit = 42,
  Feature_HasMinimum3Maximum3PKF16Bit = 43,
  Feature_HasFlatAddressSpaceBit = 104,
  Feature_HasFlatBufferGlobalAtomicFaddF64InstBit = 122,
  Feature_HasAtomicFMinFMaxF32GlobalInstsBit = 116,
  Feature_HasAtomicFMinFMaxF64GlobalInstsBit = 121,
  Feature_HasAtomicFMinFMaxF32FlatInstsBit = 111,
  Feature_HasAtomicFMinFMaxF64FlatInstsBit = 112,
  Feature_HasLdsAtomicAddF64Bit = 151,
  Feature_HasFlatGlobalInstsBit = 106,
  Feature_HasFlatScratchInstsBit = 109,
  Feature_HasD16LoadStoreBit = 114,
  Feature_HasFlatScratchSVSModeBit = 110,
  Feature_HasFlatGVSModeBit = 105,
  Feature_HasGFX10_BEncodingBit = 60,
  Feature_HasUnpackedD16VMemBit = 128,
  Feature_HasPackedD16VMemBit = 129,
  Feature_HasUnrestrictedSOffsetBit = 126,
  Feature_D16PreservesUnusedBitsBit = 107,
  Feature_LDSRequiresM0InitBit = 144,
  Feature_NotLDSRequiresM0InitBit = 145,
  Feature_HasMTBUFInstsBit = 131,
  Feature_HasFormattedMUBUFInstsBit = 127,
  Feature_HasExportInstsBit = 11,
  Feature_HasLDSFPAtomicAddF32Bit = 150,
  Feature_HasAddNoCarryInstsBit = 76,
  Feature_NotHasAddNoCarryInstsBit = 141,
  Feature_HasXNACKEnabledBit = 101,
  Feature_Has16BitInstsBit = 13,
  Feature_NotHasTrue16BitInstsBit = 14,
  Feature_UseRealTrue16InstsBit = 15,
  Feature_UseFakeTrue16InstsBit = 16,
  Feature_HasVOP3PInstsBit = 93,
  Feature_HasMed3_16Bit = 142,
  Feature_HasMinMaxDenormModesBit = 135,
  Feature_NotHasMinMaxDenormModesBit = 137,
  Feature_HasSDWABit = 72,
  Feature_HasPackedFP32OpsBit = 54,
  Feature_HasAddMinMaxInstsBit = 87,
  Feature_HasPkAddMinMaxInstsBit = 97,
  Feature_HasPkMinMax3InstsBit = 98,
  Feature_HasSGetShaderCyclesInstBit = 7,
  Feature_HasImageInstsBit = 10,
  Feature_HasIntClampBit = 82,
  Feature_HasMadMixInstsBit = 94,
  Feature_HasScalarStoresBit = 57,
  Feature_has16BankLDSBit = 63,
  Feature_has32BankLDSBit = 31,
  Feature_HasFmaMixInstsBit = 96,
  Feature_HasDLInstsBit = 22,
  Feature_HasFmacF64InstBit = 140,
  Feature_HasDot1InstsBit = 47,
  Feature_HasDot2InstsBit = 44,
  Feature_HasDot3InstsBit = 81,
  Feature_HasDot4InstsBit = 80,
  Feature_HasDot5InstsBit = 78,
  Feature_HasDot6InstsBit = 79,
  Feature_HasDot7InstsBit = 46,
  Feature_HasDot8InstsBit = 99,
  Feature_HasDot9InstsBit = 39,
  Feature_HasDot10InstsBit = 45,
  Feature_HasDot11InstsBit = 100,
  Feature_HasGetWaveIdInstBit = 59,
  Feature_HasMAIInstsBit = 48,
  Feature_HasSMemRealTimeBit = 58,
  Feature_HasSMemTimeInstBit = 55,
  Feature_HasShaderCyclesRegisterBit = 103,
  Feature_HasShaderCyclesHiLoRegistersBit = 65,
  Feature_HasFP8InstsBit = 53,
  Feature_HasFP8ConversionInstsBit = 70,
  Feature_HasFP8E5M3InstsBit = 83,
  Feature_NotHasFP8E5M3InstsBit = 84,
  Feature_HasMadMacF32InstsBit = 24,
  Feature_HasFmaLegacy32Bit = 25,
  Feature_HasAtomicDsPkAdd16InstsBit = 149,
  Feature_HasAtomicFlatPkAdd16InstsBit = 124,
  Feature_HasAtomicFaddRtnInstsBit = 119,
  Feature_HasAtomicFaddNoRtnInstsBit = 117,
  Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit = 118,
  Feature_HasAtomicBufferGlobalPkAddF16InstsBit = 120,
  Feature_HasFlatAtomicFaddF32InstBit = 123,
  Feature_EnableFlatScratchBit = 108,
  Feature_DisableFlatScratchBit = 130,
  Feature_HasUnalignedAccessModeBit = 146,
  Feature_HasMADIntraFwdBugBit = 89,
  Feature_HasNotMADIntraFwdBugBit = 88,
  Feature_HasSALUFloatInstsBit = 2,
  Feature_NotHasSALUFloatInstsBit = 132,
  Feature_HasPseudoScalarTransBit = 40,
  Feature_HasBitOp3InstsBit = 91,
  Feature_HasTanhInstsBit = 17,
  Feature_HasTensorCvtLutInstsBit = 38,
  Feature_HasTransposeLoadF4F6InstsBit = 115,
  Feature_HasPrngInstBit = 19,
  Feature_Has64BitLiteralsBit = 66,
  Feature_HasFP6BF6ConversionScaleInstsBit = 33,
  Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit = 34,
  Feature_HasCvtPkF16F32InstBit = 90,
  Feature_HasF32ToF16BF16ConversionSRInstsBit = 92,
  Feature_HasGDSBit = 147,
  Feature_HasCvtFP8VOP1BugBit = 69,
  Feature_HasNoCvtFP8VOP1BugBit = 71,
  Feature_HasAtomicCSubNoRtnInstsBit = 113,
  Feature_HasXF32InstsBit = 52,
  Feature_HasVmemPrefInstsBit = 125,
  Feature_HasAshrPkInstsBit = 41,
  Feature_HasLshlAddU64InstBit = 86,
  Feature_HasMadU32InstBit = 85,
  Feature_HasLdsBarrierArriveAtomicBit = 143,
  Feature_HasSetPrioIncWgInstBit = 6,
  Feature_FP16DenormalsBit = 139,
  Feature_FP64DenormalsBit = 138,
  Feature_NoFP32DenormalsBit = 95,
  Feature_IEEEModeDisabledBit = 134,
  Feature_isWave32Bit = 37,
  Feature_isWave64Bit = 64,
};

PredicateBitset AMDGPUInstructionSelector::
computeAvailableModuleFeatures(const AMDGPUSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (false)
    Features.set(Feature_FalsePredicateBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS)
    Features.set(Feature_isGFX6Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX6GFX7Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7OnlyBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX6GFX7GFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::SOUTHERN_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::SEA_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX6GFX7GFX8GFX9GFX10Bit);
  if (Subtarget->getGeneration() <= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isNotGFX12PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX8GFX9GFX10GFX11Bit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::SEA_ISLANDS)
    Features.set(Feature_isGFX7PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8PlusBit);
  if (Subtarget->getGeneration() ==AMDGPUSubtarget::VOLCANIC_ISLANDS)
    Features.set(Feature_isGFX8OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX9PlusBit);
  if (Subtarget->getGeneration() < AMDGPUSubtarget::GFX9)
    Features.set(Feature_isNotGFX9PlusBit);
  if (Subtarget->hasGFX90AInsts())
    Features.set(Feature_isGFX90APlusBit);
  if (!Subtarget->hasGFX90AInsts())
    Features.set(Feature_isNotGFX90APlusBit);
  if (Subtarget->hasMAIInsts() && !Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX908orGFX90ABit);
  if (Subtarget->hasGFX940Insts())
    Features.set(Feature_isGFX940PlusBit);
  if (!Subtarget->hasGFX940Insts())
    Features.set(Feature_isNotGFX940PlusBit);
  if (Subtarget->hasGFX950Insts())
    Features.set(Feature_HasGFX950InstsBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::VOLCANIC_ISLANDS ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX9)
    Features.set(Feature_isGFX8GFX9Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX10PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX9 ||Subtarget->getGeneration() == AMDGPUSubtarget::GFX10)
    Features.set(Feature_isGFX9GFX10Bit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX11)
    Features.set(Feature_isGFX11PlusBit);
  if (Subtarget->getGeneration() == AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12OnlyBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12)
    Features.set(Feature_isGFX12PlusBit);
  if (Subtarget->getGeneration() >= AMDGPUSubtarget::GFX12 && !Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX12PlusNot12_50Bit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX125xOnlyBit);
  if (Subtarget->hasGFX1250Insts())
    Features.set(Feature_isGFX1250PlusBit);
  if (!Subtarget->hasGFX1250Insts())
    Features.set(Feature_isNotGFX1250PlusBit);
  if (Subtarget->hasIEEEMinimumMaximumInsts())
    Features.set(Feature_HasIEEEMinimumMaximumInstsBit);
  if (Subtarget->hasMinimum3Maximum3F32())
    Features.set(Feature_HasMinimum3Maximum3F32Bit);
  if (Subtarget->hasMinimum3Maximum3F16())
    Features.set(Feature_HasMinimum3Maximum3F16Bit);
  if (Subtarget->hasMin3Max3PKF16())
    Features.set(Feature_HasMin3Max3PKF16Bit);
  if (Subtarget->hasMinimum3Maximum3PKF16())
    Features.set(Feature_HasMinimum3Maximum3PKF16Bit);
  if (Subtarget->hasFlatAddressSpace())
    Features.set(Feature_HasFlatAddressSpaceBit);
  if (Subtarget->hasFlatBufferGlobalAtomicFaddF64Inst())
    Features.set(Feature_HasFlatBufferGlobalAtomicFaddF64InstBit);
  if (Subtarget->hasAtomicFMinFMaxF32GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64GlobalInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64GlobalInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF32FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF32FlatInstsBit);
  if (Subtarget->hasAtomicFMinFMaxF64FlatInsts())
    Features.set(Feature_HasAtomicFMinFMaxF64FlatInstsBit);
  if (Subtarget->hasLdsAtomicAddF64())
    Features.set(Feature_HasLdsAtomicAddF64Bit);
  if (Subtarget->hasFlatGlobalInsts())
    Features.set(Feature_HasFlatGlobalInstsBit);
  if (Subtarget->hasFlatScratchInsts())
    Features.set(Feature_HasFlatScratchInstsBit);
  if (Subtarget->hasD16LoadStore())
    Features.set(Feature_HasD16LoadStoreBit);
  if (Subtarget->hasFlatScratchSVSMode())
    Features.set(Feature_HasFlatScratchSVSModeBit);
  if (Subtarget->hasFlatGVSMode())
    Features.set(Feature_HasFlatGVSModeBit);
  if (Subtarget->hasGFX10_BEncoding())
    Features.set(Feature_HasGFX10_BEncodingBit);
  if (Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasUnpackedD16VMemBit);
  if (!Subtarget->hasUnpackedD16VMem())
    Features.set(Feature_HasPackedD16VMemBit);
  if (!Subtarget->hasRestrictedSOffset())
    Features.set(Feature_HasUnrestrictedSOffsetBit);
  if (Subtarget->d16PreservesUnusedBits())
    Features.set(Feature_D16PreservesUnusedBitsBit);
  if (Subtarget->ldsRequiresM0Init())
    Features.set(Feature_LDSRequiresM0InitBit);
  if (!Subtarget->ldsRequiresM0Init())
    Features.set(Feature_NotLDSRequiresM0InitBit);
  if (Subtarget->hasMTBUFInsts())
    Features.set(Feature_HasMTBUFInstsBit);
  if (Subtarget->hasFormattedMUBUFInsts())
    Features.set(Feature_HasFormattedMUBUFInstsBit);
  if (Subtarget->hasExportInsts())
    Features.set(Feature_HasExportInstsBit);
  if (Subtarget->hasLDSFPAtomicAddF32())
    Features.set(Feature_HasLDSFPAtomicAddF32Bit);
  if (Subtarget->hasAddNoCarry())
    Features.set(Feature_HasAddNoCarryInstsBit);
  if (!Subtarget->hasAddNoCarry())
    Features.set(Feature_NotHasAddNoCarryInstsBit);
  if (Subtarget->isXNACKEnabled())
    Features.set(Feature_HasXNACKEnabledBit);
  if (Subtarget->has16BitInsts())
    Features.set(Feature_Has16BitInstsBit);
  if (!Subtarget->hasTrue16BitInsts())
    Features.set(Feature_NotHasTrue16BitInstsBit);
  if (Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseRealTrue16InstsBit);
  if (Subtarget->hasTrue16BitInsts() && !Subtarget->useRealTrue16Insts())
    Features.set(Feature_UseFakeTrue16InstsBit);
  if (Subtarget->hasVOP3PInsts())
    Features.set(Feature_HasVOP3PInstsBit);
  if (Subtarget->hasMed3_16())
    Features.set(Feature_HasMed3_16Bit);
  if (Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_HasMinMaxDenormModesBit);
  if (!Subtarget->supportsMinMaxDenormModes())
    Features.set(Feature_NotHasMinMaxDenormModesBit);
  if (Subtarget->hasSDWA())
    Features.set(Feature_HasSDWABit);
  if (Subtarget->hasPackedFP32Ops())
    Features.set(Feature_HasPackedFP32OpsBit);
  if (Subtarget->hasAddMinMaxInsts())
    Features.set(Feature_HasAddMinMaxInstsBit);
  if (Subtarget->hasPkAddMinMaxInsts())
    Features.set(Feature_HasPkAddMinMaxInstsBit);
  if (Subtarget->hasPkMinMax3Insts())
    Features.set(Feature_HasPkMinMax3InstsBit);
  if (Subtarget->hasSGetShaderCyclesInst())
    Features.set(Feature_HasSGetShaderCyclesInstBit);
  if (Subtarget->hasImageInsts())
    Features.set(Feature_HasImageInstsBit);
  if (Subtarget->hasIntClamp())
    Features.set(Feature_HasIntClampBit);
  if (Subtarget->hasMadMixInsts())
    Features.set(Feature_HasMadMixInstsBit);
  if (Subtarget->hasScalarStores())
    Features.set(Feature_HasScalarStoresBit);
  if (Subtarget->getLDSBankCount() == 16)
    Features.set(Feature_has16BankLDSBit);
  if (Subtarget->getLDSBankCount() == 32)
    Features.set(Feature_has32BankLDSBit);
  if (Subtarget->hasFmaMixInsts())
    Features.set(Feature_HasFmaMixInstsBit);
  if (Subtarget->hasDLInsts())
    Features.set(Feature_HasDLInstsBit);
  if (Subtarget->hasFmacF64Inst())
    Features.set(Feature_HasFmacF64InstBit);
  if (Subtarget->hasDot1Insts())
    Features.set(Feature_HasDot1InstsBit);
  if (Subtarget->hasDot2Insts())
    Features.set(Feature_HasDot2InstsBit);
  if (Subtarget->hasDot3Insts())
    Features.set(Feature_HasDot3InstsBit);
  if (Subtarget->hasDot4Insts())
    Features.set(Feature_HasDot4InstsBit);
  if (Subtarget->hasDot5Insts())
    Features.set(Feature_HasDot5InstsBit);
  if (Subtarget->hasDot6Insts())
    Features.set(Feature_HasDot6InstsBit);
  if (Subtarget->hasDot7Insts())
    Features.set(Feature_HasDot7InstsBit);
  if (Subtarget->hasDot8Insts())
    Features.set(Feature_HasDot8InstsBit);
  if (Subtarget->hasDot9Insts())
    Features.set(Feature_HasDot9InstsBit);
  if (Subtarget->hasDot10Insts())
    Features.set(Feature_HasDot10InstsBit);
  if (Subtarget->hasDot11Insts())
    Features.set(Feature_HasDot11InstsBit);
  if (Subtarget->hasGetWaveIdInst())
    Features.set(Feature_HasGetWaveIdInstBit);
  if (Subtarget->hasMAIInsts())
    Features.set(Feature_HasMAIInstsBit);
  if (Subtarget->hasSMemRealTime())
    Features.set(Feature_HasSMemRealTimeBit);
  if (Subtarget->hasSMemTimeInst())
    Features.set(Feature_HasSMemTimeInstBit);
  if (Subtarget->hasShaderCyclesRegister())
    Features.set(Feature_HasShaderCyclesRegisterBit);
  if (Subtarget->hasShaderCyclesHiLoRegisters())
    Features.set(Feature_HasShaderCyclesHiLoRegistersBit);
  if (Subtarget->hasFP8Insts())
    Features.set(Feature_HasFP8InstsBit);
  if (Subtarget->hasFP8ConversionInsts())
    Features.set(Feature_HasFP8ConversionInstsBit);
  if (Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_HasFP8E5M3InstsBit);
  if (!Subtarget->hasFP8E5M3Insts())
    Features.set(Feature_NotHasFP8E5M3InstsBit);
  if (Subtarget->hasMadMacF32Insts())
    Features.set(Feature_HasMadMacF32InstsBit);
  if (Subtarget->hasGFX10_3Insts())
    Features.set(Feature_HasFmaLegacy32Bit);
  if (Subtarget->hasAtomicDsPkAdd16Insts())
    Features.set(Feature_HasAtomicDsPkAdd16InstsBit);
  if (Subtarget->hasAtomicFlatPkAdd16Insts())
    Features.set(Feature_HasAtomicFlatPkAdd16InstsBit);
  if (Subtarget->hasAtomicFaddRtnInsts())
    Features.set(Feature_HasAtomicFaddRtnInstsBit);
  if (Subtarget->hasAtomicFaddNoRtnInsts())
    Features.set(Feature_HasAtomicFaddNoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16NoRtnInsts() || Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit);
  if (Subtarget->hasAtomicBufferGlobalPkAddF16Insts())
    Features.set(Feature_HasAtomicBufferGlobalPkAddF16InstsBit);
  if (Subtarget->hasFlatAtomicFaddF32Inst())
    Features.set(Feature_HasFlatAtomicFaddF32InstBit);
  if (Subtarget->enableFlatScratch())
    Features.set(Feature_EnableFlatScratchBit);
  if (!Subtarget->enableFlatScratch())
    Features.set(Feature_DisableFlatScratchBit);
  if (Subtarget->hasUnalignedAccessMode())
    Features.set(Feature_HasUnalignedAccessModeBit);
  if (Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasMADIntraFwdBugBit);
  if (!Subtarget->hasMADIntraFwdBug())
    Features.set(Feature_HasNotMADIntraFwdBugBit);
  if (Subtarget->hasSALUFloatInsts())
    Features.set(Feature_HasSALUFloatInstsBit);
  if (!Subtarget->hasSALUFloatInsts())
    Features.set(Feature_NotHasSALUFloatInstsBit);
  if (Subtarget->hasPseudoScalarTrans())
    Features.set(Feature_HasPseudoScalarTransBit);
  if (Subtarget->hasBitOp3Insts())
    Features.set(Feature_HasBitOp3InstsBit);
  if (Subtarget->hasTanhInsts())
    Features.set(Feature_HasTanhInstsBit);
  if (Subtarget->hasTensorCvtLutInsts())
    Features.set(Feature_HasTensorCvtLutInstsBit);
  if (Subtarget->hasTransposeLoadF4F6Insts())
    Features.set(Feature_HasTransposeLoadF4F6InstsBit);
  if (Subtarget->hasPrngInst())
    Features.set(Feature_HasPrngInstBit);
  if (Subtarget->has64BitLiterals())
    Features.set(Feature_Has64BitLiteralsBit);
  if (Subtarget->hasFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasF16BF16ToFP6BF6ConversionScaleInsts())
    Features.set(Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit);
  if (Subtarget->hasCvtPkF16F32Inst())
    Features.set(Feature_HasCvtPkF16F32InstBit);
  if (Subtarget->hasF32ToF16BF16ConversionSRInsts())
    Features.set(Feature_HasF32ToF16BF16ConversionSRInstsBit);
  if (Subtarget->hasGDS())
    Features.set(Feature_HasGDSBit);
  if (Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasCvtFP8VOP1BugBit);
  if (!Subtarget->hasCvtFP8VOP1Bug())
    Features.set(Feature_HasNoCvtFP8VOP1BugBit);
  if (Subtarget->hasAtomicCSubNoRtnInsts())
    Features.set(Feature_HasAtomicCSubNoRtnInstsBit);
  if (Subtarget->hasXF32Insts())
    Features.set(Feature_HasXF32InstsBit);
  if (Subtarget->hasVmemPrefInsts())
    Features.set(Feature_HasVmemPrefInstsBit);
  if (Subtarget->hasAshrPkInsts())
    Features.set(Feature_HasAshrPkInstsBit);
  if (Subtarget->hasLshlAddU64Inst())
    Features.set(Feature_HasLshlAddU64InstBit);
  if (Subtarget->hasMadU32Inst())
    Features.set(Feature_HasMadU32InstBit);
  if (Subtarget->hasLdsBarrierArriveAtomic())
    Features.set(Feature_HasLdsBarrierArriveAtomicBit);
  if (Subtarget->hasSetPrioIncWgInst())
    Features.set(Feature_HasSetPrioIncWgInstBit);
  if (Subtarget->isWave32())
    Features.set(Feature_isWave32Bit);
  if (Subtarget->isWave64())
    Features.set(Feature_isWave64Bit);
  return Features;
}

void AMDGPUInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const AMDGPUSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset AMDGPUInstructionSelector::
computeAvailableFunctionFeatures(const AMDGPUSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP16DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP64FP16Denormals != DenormalMode::getPreserveSign())
    Features.set(Feature_FP64DenormalsBit);
  if (MF->getInfo<SIMachineFunctionInfo>()->getMode().FP32Denormals == DenormalMode::getPreserveSign())
    Features.set(Feature_NoFP32DenormalsBit);
  if (!MF->getInfo<SIMachineFunctionInfo>()->getMode().IEEE)
    Features.set(Feature_IEEEModeDisabledBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_DisableFlatScratch,
  GIFBS_Has16BitInsts,
  GIFBS_HasAddMinMaxInsts,
  GIFBS_HasAddNoCarryInsts,
  GIFBS_HasAshrPkInsts,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts,
  GIFBS_HasAtomicCSubNoRtnInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts,
  GIFBS_HasAtomicFaddNoRtnInsts,
  GIFBS_HasAtomicFaddRtnInsts,
  GIFBS_HasAtomicFlatPkAdd16Insts,
  GIFBS_HasBitOp3Insts,
  GIFBS_HasCvtPkF16F32Inst,
  GIFBS_HasD16LoadStore,
  GIFBS_HasDLInsts,
  GIFBS_HasDot10Insts,
  GIFBS_HasDot1Insts,
  GIFBS_HasDot2Insts,
  GIFBS_HasDot3Insts,
  GIFBS_HasDot4Insts,
  GIFBS_HasDot5Insts,
  GIFBS_HasDot6Insts,
  GIFBS_HasDot7Insts,
  GIFBS_HasDot8Insts,
  GIFBS_HasF16BF16ToFP6BF6ConversionScaleInsts,
  GIFBS_HasF32ToF16BF16ConversionSRInsts,
  GIFBS_HasFP6BF6ConversionScaleInsts,
  GIFBS_HasFP8Insts,
  GIFBS_HasFlatAddressSpace,
  GIFBS_HasFlatAtomicFaddF32Inst,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst,
  GIFBS_HasFlatGlobalInsts,
  GIFBS_HasFmaLegacy32,
  GIFBS_HasFmaMixInsts,
  GIFBS_HasFmacF64Inst,
  GIFBS_HasFormattedMUBUFInsts,
  GIFBS_HasGDS,
  GIFBS_HasGFX10_BEncoding,
  GIFBS_HasGFX950Insts,
  GIFBS_HasGetWaveIdInst,
  GIFBS_HasIEEEMinimumMaximumInsts,
  GIFBS_HasIntClamp,
  GIFBS_HasLdsAtomicAddF64,
  GIFBS_HasLshlAddU64Inst,
  GIFBS_HasMAIInsts,
  GIFBS_HasMTBUFInsts,
  GIFBS_HasMadMacF32Insts,
  GIFBS_HasMadU32Inst,
  GIFBS_HasMinMaxDenormModes,
  GIFBS_HasMinimum3Maximum3F32,
  GIFBS_HasMinimum3Maximum3PKF16,
  GIFBS_HasPackedFP32Ops,
  GIFBS_HasPkAddMinMaxInsts,
  GIFBS_HasPkMinMax3Insts,
  GIFBS_HasPrngInst,
  GIFBS_HasPseudoScalarTrans,
  GIFBS_HasSALUFloatInsts,
  GIFBS_HasSGetShaderCyclesInst,
  GIFBS_HasSMemRealTime,
  GIFBS_HasSMemTimeInst,
  GIFBS_HasSetPrioIncWgInst,
  GIFBS_HasShaderCyclesHiLoRegisters,
  GIFBS_HasShaderCyclesRegister,
  GIFBS_HasTanhInsts,
  GIFBS_HasTensorCvtLutInsts,
  GIFBS_HasUnrestrictedSOffset,
  GIFBS_HasVOP3PInsts,
  GIFBS_HasVmemPrefInsts,
  GIFBS_HasXF32Insts,
  GIFBS_HasXNACKEnabled,
  GIFBS_IEEEModeDisabled,
  GIFBS_LDSRequiresM0Init,
  GIFBS_NotHasAddNoCarryInsts,
  GIFBS_NotHasTrue16BitInsts,
  GIFBS_NotLDSRequiresM0Init,
  GIFBS_UseFakeTrue16Insts,
  GIFBS_UseRealTrue16Insts,
  GIFBS_isGFX10Only,
  GIFBS_isGFX10Plus,
  GIFBS_isGFX11Only,
  GIFBS_isGFX11Plus,
  GIFBS_isGFX1250Plus,
  GIFBS_isGFX125xOnly,
  GIFBS_isGFX12Only,
  GIFBS_isGFX12Plus,
  GIFBS_isGFX12PlusNot12_50,
  GIFBS_isGFX6,
  GIFBS_isGFX6GFX7,
  GIFBS_isGFX6GFX7GFX8GFX9,
  GIFBS_isGFX7GFX8GFX9,
  GIFBS_isGFX7Only,
  GIFBS_isGFX7Plus,
  GIFBS_isGFX8GFX9,
  GIFBS_isGFX8GFX9GFX10GFX11,
  GIFBS_isGFX8Plus,
  GIFBS_isGFX908orGFX90A,
  GIFBS_isGFX90APlus,
  GIFBS_isGFX940Plus,
  GIFBS_isGFX9GFX10,
  GIFBS_isGFX9Plus,
  GIFBS_isNotGFX1250Plus,
  GIFBS_isNotGFX12Plus,
  GIFBS_isNotGFX90APlus,
  GIFBS_isNotGFX940Plus,
  GIFBS_isNotGFX9Plus,
  GIFBS_isWave32,
  GIFBS_isWave64,
  GIFBS_DisableFlatScratch_HasD16LoadStore,
  GIFBS_DisableFlatScratch_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts,
  GIFBS_FP16Denormals_NotHasMinMaxDenormModes,
  GIFBS_FalsePredicate_NotHasMinMaxDenormModes,
  GIFBS_Has16BitInsts_HasIntClamp,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8GFX9,
  GIFBS_Has16BitInsts_isGFX8Only,
  GIFBS_Has16BitInsts_isNotGFX90APlus,
  GIFBS_HasAddNoCarryInsts_HasIntClamp,
  GIFBS_HasAtomicBufferGlobalPkAddF16Insts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicBufferGlobalPkAddF16NoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicCSubNoRtnInsts_isGFX12Plus,
  GIFBS_HasAtomicDsPkAdd16Insts_HasGDS,
  GIFBS_HasAtomicDsPkAdd16Insts_LDSRequiresM0Init,
  GIFBS_HasAtomicDsPkAdd16Insts_NotLDSRequiresM0Init,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF32FlatInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF32GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFMinFMaxF64FlatInsts_HasFlatAddressSpace,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasFlatGlobalInsts,
  GIFBS_HasAtomicFMinFMaxF64GlobalInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddNoRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFaddRtnInsts_HasUnrestrictedSOffset,
  GIFBS_HasAtomicFlatPkAdd16Insts_HasFlatGVSMode,
  GIFBS_HasBitOp3Insts_isGFX940Plus,
  GIFBS_HasCvtFP8VOP1Bug_HasFP8ConversionInsts,
  GIFBS_HasD16LoadStore_HasFlatGVSMode,
  GIFBS_HasDot11Insts_isGFX12Plus,
  GIFBS_HasDot9Insts_NotHasTrue16BitInsts,
  GIFBS_HasDot9Insts_UseFakeTrue16Insts,
  GIFBS_HasDot9Insts_UseRealTrue16Insts,
  GIFBS_HasExportInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasSDWA,
  GIFBS_HasFP8ConversionInsts_isGFX125xOnly,
  GIFBS_HasFP8ConversionInsts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_isGFX12PlusNot12_50,
  GIFBS_HasFP8ConversionInsts_isGFX940Plus,
  GIFBS_HasFP8Insts_isGFX90APlus,
  GIFBS_HasFlatAddressSpace_HasFlatGVSMode,
  GIFBS_HasFlatAddressSpace_NotHasTrue16BitInsts,
  GIFBS_HasFlatAddressSpace_UseFakeTrue16Insts,
  GIFBS_HasFlatAtomicFaddF32Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasFlatGVSMode,
  GIFBS_HasFlatBufferGlobalAtomicFaddF64Inst_HasUnrestrictedSOffset,
  GIFBS_HasFlatGVSMode_isGFX12Only,
  GIFBS_HasFlatGVSMode_isGFX12Plus,
  GIFBS_HasFlatGlobalInsts_NotHasTrue16BitInsts,
  GIFBS_HasFlatGlobalInsts_UseFakeTrue16Insts,
  GIFBS_HasFlatGlobalInsts_isGFX12Plus,
  GIFBS_HasFmaMixInsts_NotHasTrue16BitInsts,
  GIFBS_HasFmaMixInsts_UseFakeTrue16Insts,
  GIFBS_HasFmaMixInsts_UseRealTrue16Insts,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasFormattedMUBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasGDS_HasLDSFPAtomicAddF32,
  GIFBS_HasGDS_isGFX11Plus,
  GIFBS_HasGDS_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_HasGFX950Insts_isGFX90APlus,
  GIFBS_HasIEEEMinimumMaximumInsts_NotHasTrue16BitInsts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseFakeTrue16Insts,
  GIFBS_HasIEEEMinimumMaximumInsts_UseRealTrue16Insts,
  GIFBS_HasImageInsts_isGFX12Plus,
  GIFBS_HasLDSFPAtomicAddF32_LDSRequiresM0Init,
  GIFBS_HasLDSFPAtomicAddF32_NotLDSRequiresM0Init,
  GIFBS_HasLdsBarrierArriveAtomic_isGFX1250Plus,
  GIFBS_HasMADIntraFwdBug_isGFX11Only,
  GIFBS_HasMAIInsts_isGFX90APlus,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnpackedD16VMem,
  GIFBS_HasMTBUFInsts_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals,
  GIFBS_HasMadMixInsts_NoFP32Denormals,
  GIFBS_HasMed3_16_NotHasTrue16BitInsts,
  GIFBS_HasMed3_16_UseFakeTrue16Insts,
  GIFBS_HasMed3_16_UseRealTrue16Insts,
  GIFBS_HasMinMaxDenormModes_isGFX12Plus,
  GIFBS_HasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_HasNotMADIntraFwdBug_isGFX9Plus,
  GIFBS_HasScalarStores_isGFX8Plus,
  GIFBS_HasTanhInsts_UseFakeTrue16Insts,
  GIFBS_HasTanhInsts_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isWave32,
  GIFBS_HasUnalignedAccessMode_LDSRequiresM0Init,
  GIFBS_HasUnalignedAccessMode_NotLDSRequiresM0Init,
  GIFBS_HasVOP3PInsts_IEEEModeDisabled,
  GIFBS_HasVOP3PInsts_NotHasTrue16BitInsts,
  GIFBS_HasVOP3PInsts_UseFakeTrue16Insts,
  GIFBS_HasVOP3PInsts_UseRealTrue16Insts,
  GIFBS_HasXF32Insts_isGFX90APlus,
  GIFBS_HasXNACKEnabled_isGFX7Only,
  GIFBS_HasXNACKEnabled_isGFX9Plus,
  GIFBS_HasXNACKEnabled_isNotGFX9Plus,
  GIFBS_LDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_LDSRequiresM0Init_isGFX7Plus,
  GIFBS_NotHasTrue16BitInsts_NotLDSRequiresM0Init,
  GIFBS_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX125xOnly,
  GIFBS_NotHasTrue16BitInsts_isGFX8Plus,
  GIFBS_NotHasTrue16BitInsts_isGFX9GFX10,
  GIFBS_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_NotHasTrue16BitInsts_isNotGFX9Plus,
  GIFBS_NotLDSRequiresM0Init_UseFakeTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_UseRealTrue16Insts,
  GIFBS_NotLDSRequiresM0Init_isGFX6GFX7GFX8GFX9GFX10,
  GIFBS_NotLDSRequiresM0Init_isGFX7Plus,
  GIFBS_UseFakeTrue16Insts_isGFX10Plus,
  GIFBS_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_UseFakeTrue16Insts_isGFX125xOnly,
  GIFBS_UseFakeTrue16Insts_isGFX8Plus,
  GIFBS_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_UseRealTrue16Insts_isGFX10Plus,
  GIFBS_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_UseRealTrue16Insts_isGFX125xOnly,
  GIFBS_UseRealTrue16Insts_isGFX8Plus,
  GIFBS_UseRealTrue16Insts_isGFX9Plus,
  GIFBS_has16BankLDS_isNotGFX90APlus,
  GIFBS_has32BankLDS_isNotGFX90APlus,
  GIFBS_isGFX11Only_isWave32,
  GIFBS_isGFX11Only_isWave64,
  GIFBS_isGFX1250Plus_isWave32,
  GIFBS_isGFX125xOnly_isWave32,
  GIFBS_isGFX12Plus_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave32,
  GIFBS_isGFX12PlusNot12_50_isWave64,
  GIFBS_isGFX90APlus_isGFX908orGFX90A,
  GIFBS_isGFX90APlus_isGFX940Plus,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_UseRealTrue16Insts,
  GIFBS_D16PreservesUnusedBits_HasFlatGlobalInsts_UseRealTrue16Insts,
  GIFBS_DisableFlatScratch_HasD16LoadStore_HasUnrestrictedSOffset,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_UseRealTrue16Insts,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isGFX12Plus,
  GIFBS_FP64Denormals_NotHasMinMaxDenormModes_isNotGFX12Plus,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_HasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_HasTanhInsts_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_NotHasTrue16BitInsts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseFakeTrue16Insts,
  GIFBS_Has16BitInsts_IEEEModeDisabled_UseRealTrue16Insts,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus,
  GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX1250Plus,
  GIFBS_Has16BitInsts_has32BankLDS_isNotGFX90APlus,
  GIFBS_HasAtomicCSubNoRtnInsts_HasFlatGVSMode_isGFX12Plus,
  GIFBS_HasBitOp3Insts_UseFakeTrue16Insts_isGFX1250Plus,
  GIFBS_HasBitOp3Insts_UseRealTrue16Insts_isGFX1250Plus,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_HasNoCvtFP8VOP1Bug_HasSDWA,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_isGFX12Plus,
  GIFBS_HasFP8ConversionInsts_NotHasTrue16BitInsts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFlatAddressSpace_HasFlatGVSMode_NotHasTrue16BitInsts,
  GIFBS_HasFlatAddressSpace_HasFlatGVSMode_UseFakeTrue16Insts,
  GIFBS_HasFormattedMUBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMTBUFInsts_HasPackedD16VMem_HasUnrestrictedSOffset,
  GIFBS_HasMadMacF32Insts_NoFP32Denormals_isGFX6GFX7GFX10,
  GIFBS_HasMadMixInsts_NoFP32Denormals_NotHasTrue16BitInsts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseFakeTrue16Insts,
  GIFBS_HasMadMixInsts_NoFP32Denormals_UseRealTrue16Insts,
  GIFBS_HasTransposeLoadF4F6Insts_isGFX1250Plus_isWave32,
  GIFBS_D16PreservesUnusedBits_HasFlatAddressSpace_HasFlatGVSMode_UseRealTrue16Insts,
  GIFBS_EnableFlatScratch_HasD16LoadStore_HasFlatScratchInsts_HasFlatScratchSVSMode,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_NotHasTrue16BitInsts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseFakeTrue16Insts,
  GIFBS_EnableFlatScratch_HasFlatScratchInsts_HasFlatScratchSVSMode_UseRealTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_NotHasTrue16BitInsts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseFakeTrue16Insts,
  GIFBS_FP16Denormals_Has16BitInsts_NotHasMinMaxDenormModes_UseRealTrue16Insts,
  GIFBS_HasFP8ConversionInsts_HasFP8E5M3Insts_UseFakeTrue16Insts_isGFX9Plus,
  GIFBS_HasFP8ConversionInsts_NotHasFP8E5M3Insts_NotHasTrue16BitInsts_isGFX9Plus,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_DisableFlatScratchBit, },
  {Feature_Has16BitInstsBit, },
  {Feature_HasAddMinMaxInstsBit, },
  {Feature_HasAddNoCarryInstsBit, },
  {Feature_HasAshrPkInstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, },
  {Feature_HasAtomicFaddRtnInstsBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, },
  {Feature_HasBitOp3InstsBit, },
  {Feature_HasCvtPkF16F32InstBit, },
  {Feature_HasD16LoadStoreBit, },
  {Feature_HasDLInstsBit, },
  {Feature_HasDot10InstsBit, },
  {Feature_HasDot1InstsBit, },
  {Feature_HasDot2InstsBit, },
  {Feature_HasDot3InstsBit, },
  {Feature_HasDot4InstsBit, },
  {Feature_HasDot5InstsBit, },
  {Feature_HasDot6InstsBit, },
  {Feature_HasDot7InstsBit, },
  {Feature_HasDot8InstsBit, },
  {Feature_HasF16BF16ToFP6BF6ConversionScaleInstsBit, },
  {Feature_HasF32ToF16BF16ConversionSRInstsBit, },
  {Feature_HasFP6BF6ConversionScaleInstsBit, },
  {Feature_HasFP8InstsBit, },
  {Feature_HasFlatAddressSpaceBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, },
  {Feature_HasFlatGlobalInstsBit, },
  {Feature_HasFmaLegacy32Bit, },
  {Feature_HasFmaMixInstsBit, },
  {Feature_HasFmacF64InstBit, },
  {Feature_HasFormattedMUBUFInstsBit, },
  {Feature_HasGDSBit, },
  {Feature_HasGFX10_BEncodingBit, },
  {Feature_HasGFX950InstsBit, },
  {Feature_HasGetWaveIdInstBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, },
  {Feature_HasIntClampBit, },
  {Feature_HasLdsAtomicAddF64Bit, },
  {Feature_HasLshlAddU64InstBit, },
  {Feature_HasMAIInstsBit, },
  {Feature_HasMTBUFInstsBit, },
  {Feature_HasMadMacF32InstsBit, },
  {Feature_HasMadU32InstBit, },
  {Feature_HasMinMaxDenormModesBit, },
  {Feature_HasMinimum3Maximum3F32Bit, },
  {Feature_HasMinimum3Maximum3PKF16Bit, },
  {Feature_HasPackedFP32OpsBit, },
  {Feature_HasPkAddMinMaxInstsBit, },
  {Feature_HasPkMinMax3InstsBit, },
  {Feature_HasPrngInstBit, },
  {Feature_HasPseudoScalarTransBit, },
  {Feature_HasSALUFloatInstsBit, },
  {Feature_HasSGetShaderCyclesInstBit, },
  {Feature_HasSMemRealTimeBit, },
  {Feature_HasSMemTimeInstBit, },
  {Feature_HasSetPrioIncWgInstBit, },
  {Feature_HasShaderCyclesHiLoRegistersBit, },
  {Feature_HasShaderCyclesRegisterBit, },
  {Feature_HasTanhInstsBit, },
  {Feature_HasTensorCvtLutInstsBit, },
  {Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasVOP3PInstsBit, },
  {Feature_HasVmemPrefInstsBit, },
  {Feature_HasXF32InstsBit, },
  {Feature_HasXNACKEnabledBit, },
  {Feature_IEEEModeDisabledBit, },
  {Feature_LDSRequiresM0InitBit, },
  {Feature_NotHasAddNoCarryInstsBit, },
  {Feature_NotHasTrue16BitInstsBit, },
  {Feature_NotLDSRequiresM0InitBit, },
  {Feature_UseFakeTrue16InstsBit, },
  {Feature_UseRealTrue16InstsBit, },
  {Feature_isGFX10OnlyBit, },
  {Feature_isGFX10PlusBit, },
  {Feature_isGFX11OnlyBit, },
  {Feature_isGFX11PlusBit, },
  {Feature_isGFX1250PlusBit, },
  {Feature_isGFX125xOnlyBit, },
  {Feature_isGFX12OnlyBit, },
  {Feature_isGFX12PlusBit, },
  {Feature_isGFX12PlusNot12_50Bit, },
  {Feature_isGFX6Bit, },
  {Feature_isGFX6GFX7Bit, },
  {Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_isGFX7GFX8GFX9Bit, },
  {Feature_isGFX7OnlyBit, },
  {Feature_isGFX7PlusBit, },
  {Feature_isGFX8GFX9Bit, },
  {Feature_isGFX8GFX9GFX10GFX11Bit, },
  {Feature_isGFX8PlusBit, },
  {Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, },
  {Feature_isGFX940PlusBit, },
  {Feature_isGFX9GFX10Bit, },
  {Feature_isGFX9PlusBit, },
  {Feature_isNotGFX1250PlusBit, },
  {Feature_isNotGFX12PlusBit, },
  {Feature_isNotGFX90APlusBit, },
  {Feature_isNotGFX940PlusBit, },
  {Feature_isNotGFX9PlusBit, },
  {Feature_isWave32Bit, },
  {Feature_isWave64Bit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, },
  {Feature_DisableFlatScratchBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, },
  {Feature_FP16DenormalsBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_FalsePredicateBit, Feature_NotHasMinMaxDenormModesBit, },
  {Feature_Has16BitInstsBit, Feature_HasIntClampBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_isGFX6GFX7GFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8GFX9Bit, },
  {Feature_Has16BitInstsBit, Feature_isGFX8OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAddNoCarryInstsBit, Feature_HasIntClampBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16InstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicBufferGlobalPkAddF16NoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_HasGDSBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasAtomicDsPkAdd16InstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF32FlatInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF32GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFMinFMaxF64FlatInstsBit, Feature_HasFlatAddressSpaceBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasFlatGlobalInstsBit, },
  {Feature_HasAtomicFMinFMaxF64GlobalInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddNoRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFaddRtnInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasAtomicFlatPkAdd16InstsBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasBitOp3InstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasCvtFP8VOP1BugBit, Feature_HasFP8ConversionInstsBit, },
  {Feature_HasD16LoadStoreBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasDot11InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasDot9InstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasDot9InstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasExportInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX12PlusNot12_50Bit, },
  {Feature_HasFP8ConversionInstsBit, Feature_isGFX940PlusBit, },
  {Feature_HasFP8InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatAtomicFaddF32InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasFlatGVSModeBit, },
  {Feature_HasFlatBufferGlobalAtomicFaddF64InstBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12OnlyBit, },
  {Feature_HasFlatGVSModeBit, Feature_isGFX12PlusBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFlatGlobalInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFmaMixInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFmaMixInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasGDSBit, Feature_HasLDSFPAtomicAddF32Bit, },
  {Feature_HasGDSBit, Feature_isGFX11PlusBit, },
  {Feature_HasGDSBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_HasGFX950InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasIEEEMinimumMaximumInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasImageInstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasLDSFPAtomicAddF32Bit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasLdsBarrierArriveAtomicBit, Feature_isGFX1250PlusBit, },
  {Feature_HasMADIntraFwdBugBit, Feature_isGFX11OnlyBit, },
  {Feature_HasMAIInstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnpackedD16VMemBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, },
  {Feature_HasMed3_16Bit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMed3_16Bit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_HasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_HasNotMADIntraFwdBugBit, Feature_isGFX9PlusBit, },
  {Feature_HasScalarStoresBit, Feature_isGFX8PlusBit, },
  {Feature_HasTanhInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasTanhInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isWave32Bit, },
  {Feature_HasUnalignedAccessModeBit, Feature_LDSRequiresM0InitBit, },
  {Feature_HasUnalignedAccessModeBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_HasVOP3PInstsBit, Feature_IEEEModeDisabledBit, },
  {Feature_HasVOP3PInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasVOP3PInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasXF32InstsBit, Feature_isGFX90APlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX7OnlyBit, },
  {Feature_HasXNACKEnabledBit, Feature_isGFX9PlusBit, },
  {Feature_HasXNACKEnabledBit, Feature_isNotGFX9PlusBit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_LDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_NotLDSRequiresM0InitBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX8PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9GFX10Bit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_NotHasTrue16BitInstsBit, Feature_isNotGFX9PlusBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_UseRealTrue16InstsBit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX6GFX7GFX8GFX9GFX10Bit, },
  {Feature_NotLDSRequiresM0InitBit, Feature_isGFX7PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX10PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX125xOnlyBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX8PlusBit, },
  {Feature_UseRealTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_has16BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_isGFX11OnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX11OnlyBit, Feature_isWave64Bit, },
  {Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX125xOnlyBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusBit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave32Bit, },
  {Feature_isGFX12PlusNot12_50Bit, Feature_isWave64Bit, },
  {Feature_isGFX90APlusBit, Feature_isGFX908orGFX90ABit, },
  {Feature_isGFX90APlusBit, Feature_isGFX940PlusBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_UseRealTrue16InstsBit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatGlobalInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_DisableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isGFX12PlusBit, },
  {Feature_FP64DenormalsBit, Feature_NotHasMinMaxDenormModesBit, Feature_isNotGFX12PlusBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_HasTanhInstsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_IEEEModeDisabledBit, Feature_UseRealTrue16InstsBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10OnlyBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX10PlusBit, },
  {Feature_Has16BitInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX1250PlusBit, },
  {Feature_Has16BitInstsBit, Feature_has32BankLDSBit, Feature_isNotGFX90APlusBit, },
  {Feature_HasAtomicCSubNoRtnInstsBit, Feature_HasFlatGVSModeBit, Feature_isGFX12PlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasBitOp3InstsBit, Feature_UseRealTrue16InstsBit, Feature_isGFX1250PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasNoCvtFP8VOP1BugBit, Feature_HasSDWABit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_isGFX12PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasFormattedMUBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMTBUFInstsBit, Feature_HasPackedD16VMemBit, Feature_HasUnrestrictedSOffsetBit, },
  {Feature_HasMadMacF32InstsBit, Feature_NoFP32DenormalsBit, Feature_isGFX6GFX7GFX10Bit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_HasMadMixInstsBit, Feature_NoFP32DenormalsBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasTransposeLoadF4F6InstsBit, Feature_isGFX1250PlusBit, Feature_isWave32Bit, },
  {Feature_D16PreservesUnusedBitsBit, Feature_HasFlatAddressSpaceBit, Feature_HasFlatGVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasD16LoadStoreBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_EnableFlatScratchBit, Feature_HasFlatScratchInstsBit, Feature_HasFlatScratchSVSModeBit, Feature_UseRealTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_NotHasTrue16BitInstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseFakeTrue16InstsBit, },
  {Feature_FP16DenormalsBit, Feature_Has16BitInstsBit, Feature_NotHasMinMaxDenormModesBit, Feature_UseRealTrue16InstsBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_HasFP8E5M3InstsBit, Feature_UseFakeTrue16InstsBit, Feature_isGFX9PlusBit, },
  {Feature_HasFP8ConversionInstsBit, Feature_NotHasFP8E5M3InstsBit, Feature_NotHasTrue16BitInstsBit, Feature_isGFX9PlusBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_gi_buf_soffset,
  GICP_gi_ds_128bit_8byte_aligned,
  GICP_gi_ds_1addr_1offset,
  GICP_gi_ds_64bit_4byte_aligned,
  GICP_gi_flat_offset,
  GICP_gi_flat_scratch_offset,
  GICP_gi_flat_scratch_saddr,
  GICP_gi_flat_scratch_svaddr,
  GICP_gi_global_offset,
  GICP_gi_global_saddr,
  GICP_gi_global_saddr_cpol,
  GICP_gi_global_saddr_glc,
  GICP_gi_global_saddr_no_ioffset,
  GICP_gi_mubuf_addr64,
  GICP_gi_mubuf_offset,
  GICP_gi_mubuf_scratch_offen,
  GICP_gi_mubuf_scratch_offset,
  GICP_gi_smrd_buffer_imm,
  GICP_gi_smrd_buffer_imm32,
  GICP_gi_smrd_buffer_sgpr_imm,
  GICP_gi_smrd_imm,
  GICP_gi_smrd_imm32,
  GICP_gi_smrd_sgpr,
  GICP_gi_smrd_sgpr_imm,
  GICP_gi_swmmacindex16,
  GICP_gi_swmmacindex32,
  GICP_gi_swmmacindex8,
  GICP_gi_vcsrc,
  GICP_gi_vinterpmods,
  GICP_gi_vinterpmods_hi,
  GICP_gi_vop3_mad_mix_mods,
  GICP_gi_vop3_mad_mix_mods_ext,
  GICP_gi_vop3_no_mods,
  GICP_gi_vop3mods,
  GICP_gi_vop3mods0,
  GICP_gi_vop3modsnoncanonicalizing,
  GICP_gi_vop3omods,
  GICP_gi_vop3opsel,
  GICP_gi_vop3opselmods,
  GICP_gi_vop3pmods,
  GICP_gi_vop3pmodsdot,
  GICP_gi_vsrc0,
  GICP_gi_wmmamods,
  GICP_gi_wmmamodsf16Neg,
  GICP_gi_wmmamodsf16NegAbs,
  GICP_gi_wmmaopselvop3pmods,
  GICP_gi_wmmavisrc,
};
// See constructor for table contents

AMDGPUInstructionSelector::ComplexMatcherMemFn
AMDGPUInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &AMDGPUInstructionSelector::selectBUFSOffset, // gi_buf_soffset
  &AMDGPUInstructionSelector::selectDS128Bit8ByteAligned, // gi_ds_128bit_8byte_aligned
  &AMDGPUInstructionSelector::selectDS1Addr1Offset, // gi_ds_1addr_1offset
  &AMDGPUInstructionSelector::selectDS64Bit4ByteAligned, // gi_ds_64bit_4byte_aligned
  &AMDGPUInstructionSelector::selectFlatOffset, // gi_flat_offset
  &AMDGPUInstructionSelector::selectScratchOffset, // gi_flat_scratch_offset
  &AMDGPUInstructionSelector::selectScratchSAddr, // gi_flat_scratch_saddr
  &AMDGPUInstructionSelector::selectScratchSVAddr, // gi_flat_scratch_svaddr
  &AMDGPUInstructionSelector::selectGlobalOffset, // gi_global_offset
  &AMDGPUInstructionSelector::selectGlobalSAddr, // gi_global_saddr
  &AMDGPUInstructionSelector::selectGlobalSAddrCPol, // gi_global_saddr_cpol
  &AMDGPUInstructionSelector::selectGlobalSAddrGLC, // gi_global_saddr_glc
  &AMDGPUInstructionSelector::selectGlobalSAddrNoIOffset, // gi_global_saddr_no_ioffset
  &AMDGPUInstructionSelector::selectMUBUFAddr64, // gi_mubuf_addr64
  &AMDGPUInstructionSelector::selectMUBUFOffset, // gi_mubuf_offset
  &AMDGPUInstructionSelector::selectMUBUFScratchOffen, // gi_mubuf_scratch_offen
  &AMDGPUInstructionSelector::selectMUBUFScratchOffset, // gi_mubuf_scratch_offset
  &AMDGPUInstructionSelector::selectSMRDBufferImm, // gi_smrd_buffer_imm
  &AMDGPUInstructionSelector::selectSMRDBufferImm32, // gi_smrd_buffer_imm32
  &AMDGPUInstructionSelector::selectSMRDBufferSgprImm, // gi_smrd_buffer_sgpr_imm
  &AMDGPUInstructionSelector::selectSmrdImm, // gi_smrd_imm
  &AMDGPUInstructionSelector::selectSmrdImm32, // gi_smrd_imm32
  &AMDGPUInstructionSelector::selectSmrdSgpr, // gi_smrd_sgpr
  &AMDGPUInstructionSelector::selectSmrdSgprImm, // gi_smrd_sgpr_imm
  &AMDGPUInstructionSelector::selectSWMMACIndex16, // gi_swmmacindex16
  &AMDGPUInstructionSelector::selectSWMMACIndex32, // gi_swmmacindex32
  &AMDGPUInstructionSelector::selectSWMMACIndex8, // gi_swmmacindex8
  &AMDGPUInstructionSelector::selectVCSRC, // gi_vcsrc
  &AMDGPUInstructionSelector::selectVINTERPMods, // gi_vinterpmods
  &AMDGPUInstructionSelector::selectVINTERPModsHi, // gi_vinterpmods_hi
  &AMDGPUInstructionSelector::selectVOP3PMadMixMods, // gi_vop3_mad_mix_mods
  &AMDGPUInstructionSelector::selectVOP3PMadMixModsExt, // gi_vop3_mad_mix_mods_ext
  &AMDGPUInstructionSelector::selectVOP3NoMods, // gi_vop3_no_mods
  &AMDGPUInstructionSelector::selectVOP3Mods, // gi_vop3mods
  &AMDGPUInstructionSelector::selectVOP3Mods0, // gi_vop3mods0
  &AMDGPUInstructionSelector::selectVOP3ModsNonCanonicalizing, // gi_vop3modsnoncanonicalizing
  &AMDGPUInstructionSelector::selectVOP3OMods, // gi_vop3omods
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opsel
  &AMDGPUInstructionSelector::selectVOP3OpSelMods, // gi_vop3opselmods
  &AMDGPUInstructionSelector::selectVOP3PMods, // gi_vop3pmods
  &AMDGPUInstructionSelector::selectVOP3PModsDOT, // gi_vop3pmodsdot
  &AMDGPUInstructionSelector::selectVSRC0, // gi_vsrc0
  &AMDGPUInstructionSelector::selectWMMAModsF32NegAbs, // gi_wmmamods
  &AMDGPUInstructionSelector::selectWMMAModsF16Neg, // gi_wmmamodsf16Neg
  &AMDGPUInstructionSelector::selectWMMAModsF16NegAbs, // gi_wmmamodsf16NegAbs
  &AMDGPUInstructionSelector::selectWMMAOpSelVOP3PMods, // gi_wmmaopselvop3pmods
  &AMDGPUInstructionSelector::selectWMMAVISrc, // gi_wmmavisrc
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_aligned_smrd_load = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_anonymous_14884,
  GICXXPred_MI_Predicate_anonymous_14887,
  GICXXPred_MI_Predicate_anonymous_14888,
  GICXXPred_MI_Predicate_anonymous_14889,
  GICXXPred_MI_Predicate_anonymous_14890,
  GICXXPred_MI_Predicate_anonymous_14891,
  GICXXPred_MI_Predicate_anonymous_14894,
  GICXXPred_MI_Predicate_anonymous_14895,
  GICXXPred_MI_Predicate_anonymous_14896,
  GICXXPred_MI_Predicate_anonymous_14897,
  GICXXPred_MI_Predicate_anonymous_14898,
  GICXXPred_MI_Predicate_anonymous_14899,
  GICXXPred_MI_Predicate_anonymous_14900,
  GICXXPred_MI_Predicate_anonymous_14901,
  GICXXPred_MI_Predicate_anonymous_14902,
  GICXXPred_MI_Predicate_anonymous_14903,
  GICXXPred_MI_Predicate_anonymous_14904,
  GICXXPred_MI_Predicate_anonymous_14905,
  GICXXPred_MI_Predicate_anonymous_14906,
  GICXXPred_MI_Predicate_anonymous_14907,
  GICXXPred_MI_Predicate_anonymous_14908,
  GICXXPred_MI_Predicate_anonymous_14909,
  GICXXPred_MI_Predicate_anonymous_14910,
  GICXXPred_MI_Predicate_anonymous_14911,
  GICXXPred_MI_Predicate_anonymous_14912,
  GICXXPred_MI_Predicate_anonymous_14913,
  GICXXPred_MI_Predicate_anonymous_14914,
  GICXXPred_MI_Predicate_anonymous_14915,
  GICXXPred_MI_Predicate_anonymous_14916,
  GICXXPred_MI_Predicate_anonymous_14917,
  GICXXPred_MI_Predicate_anonymous_14918,
  GICXXPred_MI_Predicate_anonymous_14919,
  GICXXPred_MI_Predicate_anonymous_14920,
  GICXXPred_MI_Predicate_anonymous_14921,
  GICXXPred_MI_Predicate_anonymous_14922,
  GICXXPred_MI_Predicate_anonymous_14923,
  GICXXPred_MI_Predicate_anonymous_14924,
  GICXXPred_MI_Predicate_anonymous_14925,
  GICXXPred_MI_Predicate_anonymous_14926,
  GICXXPred_MI_Predicate_anonymous_14927,
  GICXXPred_MI_Predicate_anonymous_14928,
  GICXXPred_MI_Predicate_anonymous_14929,
  GICXXPred_MI_Predicate_anonymous_14930,
  GICXXPred_MI_Predicate_anonymous_14931,
  GICXXPred_MI_Predicate_anonymous_14932,
  GICXXPred_MI_Predicate_anonymous_14933,
  GICXXPred_MI_Predicate_anonymous_14934,
  GICXXPred_MI_Predicate_anonymous_14935,
  GICXXPred_MI_Predicate_anonymous_14936,
  GICXXPred_MI_Predicate_anonymous_14937,
  GICXXPred_MI_Predicate_anonymous_14944,
  GICXXPred_MI_Predicate_anonymous_14956,
  GICXXPred_MI_Predicate_anonymous_19573,
  GICXXPred_MI_Predicate_anonymous_20870,
  GICXXPred_MI_Predicate_anonymous_20872,
  GICXXPred_MI_Predicate_anonymous_20876,
  GICXXPred_MI_Predicate_anonymous_20878,
  GICXXPred_MI_Predicate_anonymous_21220,
  GICXXPred_MI_Predicate_anonymous_21282,
  GICXXPred_MI_Predicate_anonymous_21284,
  GICXXPred_MI_Predicate_anonymous_21286,
  GICXXPred_MI_Predicate_anonymous_21288,
  GICXXPred_MI_Predicate_anonymous_21290,
  GICXXPred_MI_Predicate_anonymous_21294,
  GICXXPred_MI_Predicate_anonymous_21296,
  GICXXPred_MI_Predicate_anonymous_21298,
  GICXXPred_MI_Predicate_anonymous_21300,
  GICXXPred_MI_Predicate_anonymous_21302,
  GICXXPred_MI_Predicate_anonymous_21565,
  GICXXPred_MI_Predicate_anonymous_21567,
  GICXXPred_MI_Predicate_anonymous_22010,
  GICXXPred_MI_Predicate_anonymous_22609,
  GICXXPred_MI_Predicate_anonymous_22612,
  GICXXPred_MI_Predicate_anonymous_22615,
  GICXXPred_MI_Predicate_anonymous_22617,
  GICXXPred_MI_Predicate_anonymous_22620,
  GICXXPred_MI_Predicate_anonymous_22622,
  GICXXPred_MI_Predicate_anonymous_22625,
  GICXXPred_MI_Predicate_anonymous_22628,
  GICXXPred_MI_Predicate_anonymous_22631,
  GICXXPred_MI_Predicate_anonymous_22635,
  GICXXPred_MI_Predicate_anonymous_22638,
  GICXXPred_MI_Predicate_anonymous_22640,
  GICXXPred_MI_Predicate_anonymous_22642,
  GICXXPred_MI_Predicate_anonymous_22644,
  GICXXPred_MI_Predicate_anonymous_23086,
  GICXXPred_MI_Predicate_anonymous_23942,
  GICXXPred_MI_Predicate_anonymous_23945,
  GICXXPred_MI_Predicate_anonymous_23947,
  GICXXPred_MI_Predicate_anonymous_23949,
  GICXXPred_MI_Predicate_anonymous_23951,
  GICXXPred_MI_Predicate_anonymous_23953,
  GICXXPred_MI_Predicate_anonymous_23955,
  GICXXPred_MI_Predicate_anonymous_24243,
  GICXXPred_MI_Predicate_anonymous_24246,
  GICXXPred_MI_Predicate_anonymous_24249,
  GICXXPred_MI_Predicate_anonymous_24252,
  GICXXPred_MI_Predicate_anonymous_25761,
  GICXXPred_MI_Predicate_anonymous_25763,
  GICXXPred_MI_Predicate_anonymous_25767,
  GICXXPred_MI_Predicate_anonymous_25769,
  GICXXPred_MI_Predicate_anonymous_25771,
  GICXXPred_MI_Predicate_anonymous_25773,
  GICXXPred_MI_Predicate_anonymous_25777,
  GICXXPred_MI_Predicate_anonymous_25779,
  GICXXPred_MI_Predicate_anonymous_25781,
  GICXXPred_MI_Predicate_anonymous_25783,
  GICXXPred_MI_Predicate_anonymous_25785,
  GICXXPred_MI_Predicate_anonymous_25787,
  GICXXPred_MI_Predicate_anonymous_25789,
  GICXXPred_MI_Predicate_anonymous_25791,
  GICXXPred_MI_Predicate_anonymous_25795,
  GICXXPred_MI_Predicate_anonymous_25797,
  GICXXPred_MI_Predicate_anonymous_25799,
  GICXXPred_MI_Predicate_anonymous_25801,
  GICXXPred_MI_Predicate_anonymous_25805,
  GICXXPred_MI_Predicate_anonymous_25807,
  GICXXPred_MI_Predicate_anonymous_25811,
  GICXXPred_MI_Predicate_anonymous_25813,
  GICXXPred_MI_Predicate_anonymous_25815,
  GICXXPred_MI_Predicate_anonymous_25817,
  GICXXPred_MI_Predicate_anonymous_25821,
  GICXXPred_MI_Predicate_anonymous_25823,
  GICXXPred_MI_Predicate_anonymous_25825,
  GICXXPred_MI_Predicate_anonymous_25827,
  GICXXPred_MI_Predicate_anonymous_25829,
  GICXXPred_MI_Predicate_anonymous_25831,
  GICXXPred_MI_Predicate_anonymous_25833,
  GICXXPred_MI_Predicate_anonymous_25835,
  GICXXPred_MI_Predicate_anonymous_25839,
  GICXXPred_MI_Predicate_anonymous_25841,
  GICXXPred_MI_Predicate_anonymous_25843,
  GICXXPred_MI_Predicate_anonymous_25845,
  GICXXPred_MI_Predicate_anonymous_25849,
  GICXXPred_MI_Predicate_anonymous_25851,
  GICXXPred_MI_Predicate_anonymous_25853,
  GICXXPred_MI_Predicate_anonymous_25855,
  GICXXPred_MI_Predicate_anonymous_25857,
  GICXXPred_MI_Predicate_anonymous_25859,
  GICXXPred_MI_Predicate_anonymous_25863,
  GICXXPred_MI_Predicate_anonymous_25865,
  GICXXPred_MI_Predicate_anonymous_25867,
  GICXXPred_MI_Predicate_anonymous_25869,
  GICXXPred_MI_Predicate_anonymous_25871,
  GICXXPred_MI_Predicate_anonymous_25873,
  GICXXPred_MI_Predicate_anonymous_25877,
  GICXXPred_MI_Predicate_anonymous_25879,
  GICXXPred_MI_Predicate_anonymous_25883,
  GICXXPred_MI_Predicate_anonymous_25885,
  GICXXPred_MI_Predicate_anonymous_25887,
  GICXXPred_MI_Predicate_anonymous_25889,
  GICXXPred_MI_Predicate_anonymous_25909,
  GICXXPred_MI_Predicate_anonymous_25911,
  GICXXPred_MI_Predicate_anonymous_25945,
  GICXXPred_MI_Predicate_anonymous_25947,
  GICXXPred_MI_Predicate_anonymous_25967,
  GICXXPred_MI_Predicate_anonymous_25969,
  GICXXPred_MI_Predicate_anonymous_26007,
  GICXXPred_MI_Predicate_anonymous_26009,
  GICXXPred_MI_Predicate_anonymous_26013,
  GICXXPred_MI_Predicate_anonymous_26015,
  GICXXPred_MI_Predicate_anonymous_26017,
  GICXXPred_MI_Predicate_anonymous_26019,
  GICXXPred_MI_Predicate_anonymous_26021,
  GICXXPred_MI_Predicate_anonymous_26023,
  GICXXPred_MI_Predicate_anonymous_26025,
  GICXXPred_MI_Predicate_anonymous_26027,
  GICXXPred_MI_Predicate_anonymous_26031,
  GICXXPred_MI_Predicate_anonymous_26033,
  GICXXPred_MI_Predicate_anonymous_26035,
  GICXXPred_MI_Predicate_anonymous_26037,
  GICXXPred_MI_Predicate_anonymous_26041,
  GICXXPred_MI_Predicate_anonymous_26043,
  GICXXPred_MI_Predicate_anonymous_26045,
  GICXXPred_MI_Predicate_anonymous_26047,
  GICXXPred_MI_Predicate_anonymous_26049,
  GICXXPred_MI_Predicate_anonymous_26051,
  GICXXPred_MI_Predicate_anonymous_26055,
  GICXXPred_MI_Predicate_anonymous_26057,
  GICXXPred_MI_Predicate_anonymous_26059,
  GICXXPred_MI_Predicate_anonymous_26061,
  GICXXPred_MI_Predicate_anonymous_26063,
  GICXXPred_MI_Predicate_anonymous_26065,
  GICXXPred_MI_Predicate_anonymous_26067,
  GICXXPred_MI_Predicate_anonymous_26069,
  GICXXPred_MI_Predicate_anonymous_26071,
  GICXXPred_MI_Predicate_anonymous_26073,
  GICXXPred_MI_Predicate_anonymous_26077,
  GICXXPred_MI_Predicate_anonymous_26079,
  GICXXPred_MI_Predicate_anonymous_26081,
  GICXXPred_MI_Predicate_anonymous_26083,
  GICXXPred_MI_Predicate_anonymous_26085,
  GICXXPred_MI_Predicate_anonymous_26087,
  GICXXPred_MI_Predicate_anonymous_26089,
  GICXXPred_MI_Predicate_anonymous_26091,
  GICXXPred_MI_Predicate_anonymous_38136,
  GICXXPred_MI_Predicate_anonymous_38141,
  GICXXPred_MI_Predicate_anonymous_38143,
  GICXXPred_MI_Predicate_anonymous_38592,
  GICXXPred_MI_Predicate_anonymous_38594,
  GICXXPred_MI_Predicate_anonymous_38647,
  GICXXPred_MI_Predicate_anonymous_38662,
  GICXXPred_MI_Predicate_anonymous_38663,
  GICXXPred_MI_Predicate_anonymous_38666,
  GICXXPred_MI_Predicate_anonymous_38669,
  GICXXPred_MI_Predicate_anonymous_38672,
  GICXXPred_MI_Predicate_anonymous_38676,
  GICXXPred_MI_Predicate_anonymous_38679,
  GICXXPred_MI_Predicate_anonymous_38682,
  GICXXPred_MI_Predicate_anonymous_38684,
  GICXXPred_MI_Predicate_anonymous_38685,
  GICXXPred_MI_Predicate_anonymous_38694,
  GICXXPred_MI_Predicate_anonymous_38696,
  GICXXPred_MI_Predicate_anonymous_38704,
  GICXXPred_MI_Predicate_anonymous_38709,
  GICXXPred_MI_Predicate_anonymous_38713,
  GICXXPred_MI_Predicate_anonymous_38717,
  GICXXPred_MI_Predicate_anonymous_38727,
  GICXXPred_MI_Predicate_anonymous_38884,
  GICXXPred_MI_Predicate_anonymous_38887,
  GICXXPred_MI_Predicate_anonymous_38898,
  GICXXPred_MI_Predicate_anonymous_38965,
  GICXXPred_MI_Predicate_anonymous_38967,
  GICXXPred_MI_Predicate_anonymous_39040,
  GICXXPred_MI_Predicate_anonymous_39068,
  GICXXPred_MI_Predicate_anonymous_39070,
  GICXXPred_MI_Predicate_anonymous_39099,
  GICXXPred_MI_Predicate_anonymous_39101,
  GICXXPred_MI_Predicate_anonymous_39103,
  GICXXPred_MI_Predicate_anonymous_39105,
  GICXXPred_MI_Predicate_anonymous_39107,
  GICXXPred_MI_Predicate_anonymous_39137,
  GICXXPred_MI_Predicate_anonymous_39139,
  GICXXPred_MI_Predicate_bf16_fpround,
  GICXXPred_MI_Predicate_csh_mask_16,
  GICXXPred_MI_Predicate_csh_mask_32,
  GICXXPred_MI_Predicate_csh_mask_64,
  GICXXPred_MI_Predicate_fmaxnum_like_nnan,
  GICXXPred_MI_Predicate_fminnum_like_nnan,
  GICXXPred_MI_Predicate_is_canonicalized,
  GICXXPred_MI_Predicate_load_align_less_than_4_local,
  GICXXPred_MI_Predicate_load_align_less_than_4_local_m0,
  GICXXPred_MI_Predicate_or_disjoint,
  GICXXPred_MI_Predicate_prefetch_flat,
  GICXXPred_MI_Predicate_prefetch_global,
  GICXXPred_MI_Predicate_shl1_add,
  GICXXPred_MI_Predicate_shl2_add,
  GICXXPred_MI_Predicate_shl3_add,
  GICXXPred_MI_Predicate_shl4_add,
  GICXXPred_MI_Predicate_shl_0_to_4,
  GICXXPred_MI_Predicate_smrd_extloadi8,
  GICXXPred_MI_Predicate_smrd_extloadi16,
  GICXXPred_MI_Predicate_smrd_load,
  GICXXPred_MI_Predicate_smrd_prefetch,
  GICXXPred_MI_Predicate_smrd_sextloadi8,
  GICXXPred_MI_Predicate_smrd_sextloadi16,
  GICXXPred_MI_Predicate_smrd_zextloadi8,
  GICXXPred_MI_Predicate_smrd_zextloadi16,
  GICXXPred_MI_Predicate_store_align_less_than_4_local,
  GICXXPred_MI_Predicate_store_align_less_than_4_local_m0,
};
bool AMDGPUInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_aligned_smrd_load: {
    
      auto &Ld = cast<GLoad>(MI);
      TypeSize Size = Ld.getMMO().getSize().getValue();
      return Size <= 4 || Ld.getMMO().getAlign().value() >= Size;
      
    llvm_unreachable("aligned_smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_14884: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14887: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14888: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14889: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14890: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14891: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14894: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14895: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14896: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14897: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14898: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14899: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14900: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14901: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14902: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14903: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14904: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14905: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14906: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14907: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14908: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14909: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14910: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14911: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14912: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14913: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14914: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14915: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14916: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14917: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14918: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14919: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14920: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14921: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14922: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14923: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14924: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14925: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14926: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14927: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14928: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14929: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14930: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14931: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14932: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14933: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14934: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14935: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14936: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14937: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14944: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_14956: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_19573: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20870: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20872: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20876: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_20878: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21220: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21282: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21284: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21286: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21288: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21290: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21294: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21296: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21298: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21300: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21302: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21565: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_21567: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22010: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_22609: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22609 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22612: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22612 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22615: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22615 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22617: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22617 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22620: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22620 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22622: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22622 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22625: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22625 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22628: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22628 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22631: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22631 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22635: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22635 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22638: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22638 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22640: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22640 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22642: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22642 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_22644: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_22644 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_23086: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_23086 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_23942: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23945: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23947: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23949: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23951: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23953: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_23955: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_24243: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24243 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24246: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24246 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24249: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24249 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_24252: {
    
        const int ConstantBusLimit = Subtarget->getConstantBusLimit(AMDGPU::V_ADD3_U32_e64);
        int ConstantBusUses = 0;
        for (unsigned i = 0; i < 3; ++i) {
          const RegisterBank *RegBank = RBI.getRegBank(Operands[i]->getReg(), MRI, TRI);
          if (RegBank->getID() == AMDGPU::SGPRRegBankID) {
            if (++ConstantBusUses > ConstantBusLimit)
              return false;
          }
        }
        return true;
      
    llvm_unreachable("anonymous_24252 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_25761: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25763: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25767: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25769: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25771: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25773: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25777: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25779: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25781: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25783: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25785: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25787: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25789: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25791: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25795: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25797: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25799: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25801: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25805: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25807: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25811: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25813: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25815: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25817: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25821: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25823: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25825: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25827: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25829: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25831: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25833: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25835: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25839: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25841: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25843: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25845: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25849: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25851: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25853: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25855: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25857: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25859: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25863: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25865: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25867: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25869: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25871: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25873: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25877: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25879: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25883: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25885: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25887: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25889: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25909: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25911: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25945: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25947: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25967: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_25969: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26007: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26009: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26013: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26015: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26017: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26019: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26021: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26023: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26025: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26027: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26031: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26033: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26035: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26037: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26041: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26043: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26045: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26047: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26049: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26051: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26055: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26057: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26059: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26061: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26063: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26065: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26067: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26069: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26071: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26073: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26077: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26079: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26081: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26083: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26085: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26087: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26089: {
    
      return MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_26091: {
    
      return !MF.getInfo<SIMachineFunctionInfo>()->mayNeedAGPRs();
    
  }
  case GICXXPred_MI_Predicate_anonymous_38136: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38141: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38143: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38592: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38594: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38647: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38662: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38663: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38666: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38669: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38672: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38676: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38679: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38682: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38684: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38685: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38694: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38696: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38704: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38709: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38713: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38717: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38727: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38884: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38887: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38898: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38965: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_38967: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39040: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF) &&
          TLI->isCanonicalized(MI.getOperand(2).getReg(), MF);
      
    llvm_unreachable("anonymous_39040 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_39068: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39070: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39099: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
          MF.getSubtarget().getTargetLowering());
    
        return TLI->isCanonicalized(MI.getOperand(1).getReg(), MF);
      
    llvm_unreachable("anonymous_39099 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_39101: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39103: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39105: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39107: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39137: {
    return true;
  }
  case GICXXPred_MI_Predicate_anonymous_39139: {
    return true;
  }
  case GICXXPred_MI_Predicate_bf16_fpround: {
    return false;
  }
  case GICXXPred_MI_Predicate_csh_mask_16: {
     return isUnneededShiftMask(MI, 4); 
  }
  case GICXXPred_MI_Predicate_csh_mask_32: {
     return isUnneededShiftMask(MI, 5); 
  }
  case GICXXPred_MI_Predicate_csh_mask_64: {
     return isUnneededShiftMask(MI, 6); 
  }
  case GICXXPred_MI_Predicate_fmaxnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_fminnum_like_nnan: {
    
        return isKnownNeverNaN(MI.getOperand(0).getReg(), MRI);
      
  }
  case GICXXPred_MI_Predicate_is_canonicalized: {
    
        const SITargetLowering *TLI = static_cast<const SITargetLowering *>(
            MF.getSubtarget().getTargetLowering());
        const MachineOperand &Dst = MI.getOperand(0);
        assert(Dst.isDef());
        return TLI->isCanonicalized(Dst.getReg(), MF);
       
    llvm_unreachable("is_canonicalized should have returned");
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_load_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  case GICXXPred_MI_Predicate_prefetch_flat: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::FLAT_ADDRESS;
      
  }
  case GICXXPred_MI_Predicate_prefetch_global: {
    
        return (*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::GLOBAL_ADDRESS ||
                ((*MI.memoperands_begin())->getAddrSpace() == AMDGPUAS::CONSTANT_ADDRESS &&
                 !Subtarget->hasSafeSmemPrefetch());
      
  }
  case GICXXPred_MI_Predicate_shl1_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl2_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl3_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl4_add: {
    return true;
  }
  case GICXXPred_MI_Predicate_shl_0_to_4: {
    
        int64_t Imm = 0;
        if (!mi_match(MI.getOperand(2).getReg(), MRI, m_ICst(Imm)) &&
            !mi_match(MI.getOperand(2).getReg(), MRI, m_Copy(m_ICst(Imm))))
          return false;
        return (uint64_t)Imm <= 4;
      
    llvm_unreachable("shl_0_to_4 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_extloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_extloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_load: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_load should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_prefetch: {
    
        return isInstrUniform(MI) && Subtarget->hasSafeSmemPrefetch();
      
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_sextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_sextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi8: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi8 should have returned");
  }
  case GICXXPred_MI_Predicate_smrd_zextloadi16: {
    
        if (!MI.hasOneMemOperand())
          return false;
        if (!isInstrUniform(MI))
          return false;
    
        // FIXME: We should probably be caching this.
        SmallVector<GEPInfo, 4> AddrInfo;
        getAddrModeInfo(MI, MRI, AddrInfo);
    
        if (hasVgprParts(AddrInfo))
          return false;
        return true;
      
    llvm_unreachable("smrd_zextloadi16 should have returned");
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  case GICXXPred_MI_Predicate_store_align_less_than_4_local_m0: {
    return (*MI.memoperands_begin())->getAlign() < 4;
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool AMDGPUInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_MFMALdScaleModifierOp,
  GICXXPred_I64_Predicate_NegSubInlineConst32,
  GICXXPred_I64_Predicate_NegSubInlineIntConst16,
  GICXXPred_I64_Predicate_SIMM16bit,
  GICXXPred_I64_Predicate_ShiftAmt32Imm,
  GICXXPred_I64_Predicate_SupportedRoundMode,
  GICXXPred_I64_Predicate_i32imm_one,
  GICXXPred_I64_Predicate_i32imm_zero,
  GICXXPred_I64_Predicate_i64imm_32bit,
};
bool AMDGPUInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask: {
    
      return isMask_32(Imm);
    
  }
  case GICXXPred_I64_Predicate_MFMALdScaleModifierOp: {
    
      return isUInt<2>(Imm);
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineConst32: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_NegSubInlineIntConst16: {
    
      return Imm < -16 && Imm >= -64;
    
  }
  case GICXXPred_I64_Predicate_SIMM16bit: {
    return isInt<16>(Imm) || isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_ShiftAmt32Imm: {
    
      return Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_SupportedRoundMode: {
    
      return Imm == (int)RoundingMode::TowardZero ||
             Imm == (int)RoundingMode::NearestTiesToEven ||
             Imm == (int)RoundingMode::TowardPositive ||
             Imm == (int)RoundingMode::TowardNegative;
    
  }
  case GICXXPred_I64_Predicate_i32imm_one: {
    
      return Imm == 1;
    
  }
  case GICXXPred_I64_Predicate_i32imm_zero: {
    
      return Imm == 0;
    
  }
  case GICXXPred_I64_Predicate_i64imm_32bit: {
    
      return (Imm & 0xffffffffULL) == static_cast<uint64_t>(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_InlineImmFP32 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_InlineImmFP64,
  GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64,
  GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64,
};
bool AMDGPUInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_InlineImmFP32: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_InlineImmFP64: {
    
      return isInlineImmediate(Imm);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm_neg_pow2_prefer_ldexp_f64: {
    
        if (!Imm.isNegative())
          return false;
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_neg_pow2_prefer_ldexp_f64 should have returned");
  }
  case GICXXPred_APFloat_Predicate_fpimm_pos_pow2_prefer_ldexp_f64: {
    
        if (Imm.isNegative())
          return false;
    
        int Exp = Imm.getExactLog2Abs();
        // Prefer leaving the FP inline immediates as they are.
        // 0.5, 1.0, 2.0, 4.0
    
        // For f64 ldexp is always better than materializing a 64-bit
        // constant.
        return Exp != INT_MIN && (Exp < -1 || Exp > 2);
      
    llvm_unreachable("fpimm_pos_pow2_prefer_ldexp_f64 should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_InlineImm64 = GICXXPred_Invalid + 1,
};
bool AMDGPUInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_InlineImm64: {
    
      return isInlineImmediate(Imm);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool AMDGPUInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderBitcastFPImm32,
  GICR_renderBitcastFPImm64,
  GICR_renderDstSelToOpSel3XFormXForm,
  GICR_renderDstSelToOpSelXForm,
  GICR_renderExtractCPol,
  GICR_renderExtractCpolSetGLC,
  GICR_renderExtractSWZ,
  GICR_renderFPPow2ToExponent,
  GICR_renderFrameIndex,
  GICR_renderNegateImm,
  GICR_renderOpSelTImm,
  GICR_renderPopcntImm,
  GICR_renderPrefetchLoc,
  GICR_renderRoundMode,
  GICR_renderScaledMAIIntrinsicOperand,
  GICR_renderSrcAndDstSelToOpSelXForm_0_0,
  GICR_renderSrcAndDstSelToOpSelXForm_0_1,
  GICR_renderSrcAndDstSelToOpSelXForm_1_0,
  GICR_renderSrcAndDstSelToOpSelXForm_1_1,
  GICR_renderSrcAndDstSelToOpSelXForm_2_0,
  GICR_renderSrcSelToOpSelXForm,
  GICR_renderTruncTImm,
  GICR_renderVOP3PModsNeg,
  GICR_renderVOP3PModsNegAbs,
  GICR_renderVOP3PModsNegs,
  GICR_renderZextBoolTImm,
};
AMDGPUInstructionSelector::CustomRendererFn
AMDGPUInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &AMDGPUInstructionSelector::renderBitcastFPImm32,
  &AMDGPUInstructionSelector::renderBitcastFPImm64,
  &AMDGPUInstructionSelector::renderDstSelToOpSel3XFormXForm,
  &AMDGPUInstructionSelector::renderDstSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderExtractCPol,
  &AMDGPUInstructionSelector::renderExtractCpolSetGLC,
  &AMDGPUInstructionSelector::renderExtractSWZ,
  &AMDGPUInstructionSelector::renderFPPow2ToExponent,
  &AMDGPUInstructionSelector::renderFrameIndex,
  &AMDGPUInstructionSelector::renderNegateImm,
  &AMDGPUInstructionSelector::renderOpSelTImm,
  &AMDGPUInstructionSelector::renderPopcntImm,
  &AMDGPUInstructionSelector::renderPrefetchLoc,
  &AMDGPUInstructionSelector::renderRoundMode,
  &AMDGPUInstructionSelector::renderScaledMAIIntrinsicOperand,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_0_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_0,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_1_1,
  &AMDGPUInstructionSelector::renderSrcAndDstSelToOpSelXForm_2_0,
  &AMDGPUInstructionSelector::renderSrcSelToOpSelXForm,
  &AMDGPUInstructionSelector::renderTruncTImm,
  &AMDGPUInstructionSelector::renderVOP3PModsNeg,
  &AMDGPUInstructionSelector::renderVOP3PModsNegAbs,
  &AMDGPUInstructionSelector::renderVOP3PModsNegs,
  &AMDGPUInstructionSelector::renderZextBoolTImm,
};

bool AMDGPUInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool AMDGPUInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("AMDGPUInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((Val) >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((Val) >> 8), uint8_t((Val) >> 16), uint8_t((Val) >> 24),  uint8_t(uint64_t(Val) >> 32), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t(uint64_t(Val) >> 56), uint8_t(uint64_t(Val) >> 48), uint8_t(uint64_t(Val) >> 40), uint8_t(uint64_t(Val) >> 32),  uint8_t((Val) >> 24), uint8_t((Val) >> 16), uint8_t((Val) >> 8), uint8_t(Val)
#endif
const uint8_t *AMDGPUInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(3848), /*)*//*default:*//*Label 170*/ GIMT_Encode4(823750),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(15190),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(38562),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(39185), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(39623),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(41024),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(56536), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     74 */ /*TargetOpcode::G_FRAME_INDEX*//*Label 6*/ GIMT_Encode4(61403), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 7*/ GIMT_Encode4(61458), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 8*/ GIMT_Encode4(67241), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    138 */ /*TargetOpcode::G_INTRINSIC_FPTRUNC_ROUND*//*Label 9*/ GIMT_Encode4(76405),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(76600), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 11*/ GIMT_Encode4(76928),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 12*/ GIMT_Encode4(77256),
     /*    166 */ /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 13*/ GIMT_Encode4(77417),
     /*    170 */ /*TargetOpcode::G_LOAD*//*Label 14*/ GIMT_Encode4(77475),
     /*    174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 15*/ GIMT_Encode4(149933),
     /*    178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 16*/ GIMT_Encode4(158031), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    194 */ /*TargetOpcode::G_STORE*//*Label 17*/ GIMT_Encode4(166806), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 18*/ GIMT_Encode4(204785),
     /*    210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 19*/ GIMT_Encode4(205911),
     /*    214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 20*/ GIMT_Encode4(208623),
     /*    218 */ /*TargetOpcode::G_ATOMICRMW_SUB*//*Label 21*/ GIMT_Encode4(211635),
     /*    222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 22*/ GIMT_Encode4(214647), GIMT_Encode4(0),
     /*    230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 23*/ GIMT_Encode4(217659),
     /*    234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 24*/ GIMT_Encode4(220671),
     /*    238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 25*/ GIMT_Encode4(223683),
     /*    242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 26*/ GIMT_Encode4(226695),
     /*    246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 27*/ GIMT_Encode4(229707),
     /*    250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 28*/ GIMT_Encode4(232719),
     /*    254 */ /*TargetOpcode::G_ATOMICRMW_FADD*//*Label 29*/ GIMT_Encode4(235731), GIMT_Encode4(0),
     /*    262 */ /*TargetOpcode::G_ATOMICRMW_FMAX*//*Label 30*/ GIMT_Encode4(238328),
     /*    266 */ /*TargetOpcode::G_ATOMICRMW_FMIN*//*Label 31*/ GIMT_Encode4(241598), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    278 */ /*TargetOpcode::G_ATOMICRMW_UINC_WRAP*//*Label 32*/ GIMT_Encode4(244868),
     /*    282 */ /*TargetOpcode::G_ATOMICRMW_UDEC_WRAP*//*Label 33*/ GIMT_Encode4(247880), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 34*/ GIMT_Encode4(250892),
     /*    298 */ /*TargetOpcode::G_PREFETCH*//*Label 35*/ GIMT_Encode4(250911), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 36*/ GIMT_Encode4(251924),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 37*/ GIMT_Encode4(273568),
     /*    322 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT*//*Label 38*/ GIMT_Encode4(280015),
     /*    326 */ /*TargetOpcode::G_INTRINSIC_CONVERGENT_W_SIDE_EFFECTS*//*Label 39*/ GIMT_Encode4(315021),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 40*/ GIMT_Encode4(317666),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 41*/ GIMT_Encode4(318320), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 42*/ GIMT_Encode4(318560),
     /*    354 */ /*TargetOpcode::G_FCONSTANT*//*Label 43*/ GIMT_Encode4(319286), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 44*/ GIMT_Encode4(319574), GIMT_Encode4(0),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 45*/ GIMT_Encode4(321009),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 46*/ GIMT_Encode4(324212),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 47*/ GIMT_Encode4(325896),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 48*/ GIMT_Encode4(327206), GIMT_Encode4(0),
     /*    394 */ /*TargetOpcode::G_FSHR*//*Label 49*/ GIMT_Encode4(328516),
     /*    398 */ /*TargetOpcode::G_ROTR*//*Label 50*/ GIMT_Encode4(328814), GIMT_Encode4(0),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 51*/ GIMT_Encode4(328927),
     /*    410 */ /*TargetOpcode::G_FCMP*//*Label 52*/ GIMT_Encode4(330519), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 53*/ GIMT_Encode4(334682), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 54*/ GIMT_Encode4(335026),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 55*/ GIMT_Encode4(335135),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 56*/ GIMT_Encode4(335244),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 57*/ GIMT_Encode4(335632),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 58*/ GIMT_Encode4(335958),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 59*/ GIMT_Encode4(336346), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 60*/ GIMT_Encode4(336672),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 61*/ GIMT_Encode4(338030),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 62*/ GIMT_Encode4(338394),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 63*/ GIMT_Encode4(339780),
     /*    546 */ /*TargetOpcode::G_FMAD*//*Label 64*/ GIMT_Encode4(341649), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    558 */ /*TargetOpcode::G_FPOW*//*Label 65*/ GIMT_Encode4(342595), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    570 */ /*TargetOpcode::G_FEXP2*//*Label 66*/ GIMT_Encode4(342713), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    582 */ /*TargetOpcode::G_FLOG2*//*Label 67*/ GIMT_Encode4(342936), GIMT_Encode4(0),
     /*    590 */ /*TargetOpcode::G_FLDEXP*//*Label 68*/ GIMT_Encode4(343159), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 69*/ GIMT_Encode4(343522),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 70*/ GIMT_Encode4(345385),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 71*/ GIMT_Encode4(345785),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 72*/ GIMT_Encode4(346721),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 73*/ GIMT_Encode4(347447),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 74*/ GIMT_Encode4(348173),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 75*/ GIMT_Encode4(348906), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 76*/ GIMT_Encode4(349639),
     /*    638 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 77*/ GIMT_Encode4(350440),
     /*    642 */ /*TargetOpcode::G_IS_FPCLASS*//*Label 78*/ GIMT_Encode4(350865),
     /*    646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 79*/ GIMT_Encode4(351196),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 80*/ GIMT_Encode4(352664),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 81*/ GIMT_Encode4(424443),
     /*    658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 82*/ GIMT_Encode4(496222),
     /*    662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 83*/ GIMT_Encode4(568001),
     /*    666 */ /*TargetOpcode::G_FMINIMUM*//*Label 84*/ GIMT_Encode4(639780),
     /*    670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 85*/ GIMT_Encode4(641895),
     /*    674 */ /*TargetOpcode::G_FMINIMUMNUM*//*Label 86*/ GIMT_Encode4(644010),
     /*    678 */ /*TargetOpcode::G_FMAXIMUMNUM*//*Label 87*/ GIMT_Encode4(644438), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    694 */ /*TargetOpcode::G_GET_FPMODE*//*Label 88*/ GIMT_Encode4(644866), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    710 */ /*TargetOpcode::G_PTR_ADD*//*Label 89*/ GIMT_Encode4(644990), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 90*/ GIMT_Encode4(645067),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 91*/ GIMT_Encode4(652033),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 92*/ GIMT_Encode4(659167),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 93*/ GIMT_Encode4(666133),
     /*    734 */ /*TargetOpcode::G_ABS*//*Label 94*/ GIMT_Encode4(673099), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 95*/ GIMT_Encode4(673236), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    794 */ /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 96*/ GIMT_Encode4(673270), GIMT_Encode4(0),
     /*    802 */ /*TargetOpcode::G_CTLZ_ZERO_UNDEF*//*Label 97*/ GIMT_Encode4(673369),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 98*/ GIMT_Encode4(673471),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 99*/ GIMT_Encode4(673686),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 100*/ GIMT_Encode4(675435),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 101*/ GIMT_Encode4(675683), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 102*/ GIMT_Encode4(676011),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 103*/ GIMT_Encode4(676303), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 104*/ GIMT_Encode4(676817),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 105*/ GIMT_Encode4(677779),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 106*/ GIMT_Encode4(678143), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 107*/ GIMT_Encode4(679411), GIMT_Encode4(0),
     /*    934 */ /*TargetOpcode::G_STRICT_FLDEXP*//*Label 108*/ GIMT_Encode4(680457), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  14878 */ /*AMDGPU::G_AMDGPU_ATOMIC_CMPXCHG*//*Label 109*/ GIMT_Encode4(680820),
     /*  14882 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_ADD*//*Label 110*/ GIMT_Encode4(683624),
     /*  14886 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_AND*//*Label 111*/ GIMT_Encode4(686008),
     /*  14890 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_CMPSWAP*//*Label 112*/ GIMT_Encode4(688392),
     /*  14894 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_COND_SUB_U32*//*Label 113*/ GIMT_Encode4(692686),
     /*  14898 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_DEC*//*Label 114*/ GIMT_Encode4(693303),
     /*  14902 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FADD*//*Label 115*/ GIMT_Encode4(695687),
     /*  14906 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMAX*//*Label 116*/ GIMT_Encode4(699329),
     /*  14910 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_FMIN*//*Label 117*/ GIMT_Encode4(702945),
     /*  14914 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_INC*//*Label 118*/ GIMT_Encode4(706561),
     /*  14918 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_OR*//*Label 119*/ GIMT_Encode4(708945),
     /*  14922 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMAX*//*Label 120*/ GIMT_Encode4(711329),
     /*  14926 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SMIN*//*Label 121*/ GIMT_Encode4(713713),
     /*  14930 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SUB*//*Label 122*/ GIMT_Encode4(716097),
     /*  14934 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_SWAP*//*Label 123*/ GIMT_Encode4(718481),
     /*  14938 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMAX*//*Label 124*/ GIMT_Encode4(722025),
     /*  14942 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_UMIN*//*Label 125*/ GIMT_Encode4(724409),
     /*  14946 */ /*AMDGPU::G_AMDGPU_BUFFER_ATOMIC_XOR*//*Label 126*/ GIMT_Encode4(726793),
     /*  14950 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD*//*Label 127*/ GIMT_Encode4(729177),
     /*  14954 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT*//*Label 128*/ GIMT_Encode4(744549),
     /*  14958 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_D16*//*Label 129*/ GIMT_Encode4(749553),
     /*  14962 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_FORMAT_TFE*//*Label 130*/ GIMT_Encode4(757298),
     /*  14966 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE*//*Label 131*/ GIMT_Encode4(759866),
     /*  14970 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SBYTE_TFE*//*Label 132*/ GIMT_Encode4(760472),
     /*  14974 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT*//*Label 133*/ GIMT_Encode4(761078),
     /*  14978 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_SSHORT_TFE*//*Label 134*/ GIMT_Encode4(761684),
     /*  14982 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_TFE*//*Label 135*/ GIMT_Encode4(762290),
     /*  14986 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE*//*Label 136*/ GIMT_Encode4(764810),
     /*  14990 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_UBYTE_TFE*//*Label 137*/ GIMT_Encode4(765416),
     /*  14994 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT*//*Label 138*/ GIMT_Encode4(766022),
     /*  14998 */ /*AMDGPU::G_AMDGPU_BUFFER_LOAD_USHORT_TFE*//*Label 139*/ GIMT_Encode4(766628),
     /*  15002 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE*//*Label 140*/ GIMT_Encode4(767234),
     /*  15006 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_BYTE*//*Label 141*/ GIMT_Encode4(782542),
     /*  15010 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT*//*Label 142*/ GIMT_Encode4(783144),
     /*  15014 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_FORMAT_D16*//*Label 143*/ GIMT_Encode4(788132),
     /*  15018 */ /*AMDGPU::G_AMDGPU_BUFFER_STORE_SHORT*//*Label 144*/ GIMT_Encode4(795725), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15034 */ /*AMDGPU::G_AMDGPU_CLAMP*//*Label 145*/ GIMT_Encode4(796327), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15046 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE0*//*Label 146*/ GIMT_Encode4(797266),
     /*  15050 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE1*//*Label 147*/ GIMT_Encode4(797311),
     /*  15054 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE2*//*Label 148*/ GIMT_Encode4(797356),
     /*  15058 */ /*AMDGPU::G_AMDGPU_CVT_F32_UBYTE3*//*Label 149*/ GIMT_Encode4(797401),
     /*  15062 */ /*AMDGPU::G_AMDGPU_CVT_PK_I16_I32*//*Label 150*/ GIMT_Encode4(797446),
     /*  15066 */ /*AMDGPU::G_AMDGPU_FFBH_U32*//*Label 151*/ GIMT_Encode4(797476),
     /*  15070 */ /*AMDGPU::G_AMDGPU_FFBL_B32*//*Label 152*/ GIMT_Encode4(797578),
     /*  15074 */ /*AMDGPU::G_AMDGPU_FMAX_LEGACY*//*Label 153*/ GIMT_Encode4(797677),
     /*  15078 */ /*AMDGPU::G_AMDGPU_FMED3*//*Label 154*/ GIMT_Encode4(797750),
     /*  15082 */ /*AMDGPU::G_AMDGPU_FMIN_LEGACY*//*Label 155*/ GIMT_Encode4(798110), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15114 */ /*AMDGPU::G_AMDGPU_RCP_IFLAG*//*Label 156*/ GIMT_Encode4(798183), GIMT_Encode4(0),
     /*  15122 */ /*AMDGPU::G_AMDGPU_SMED3*//*Label 157*/ GIMT_Encode4(798233),
     /*  15126 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD*//*Label 158*/ GIMT_Encode4(798539),
     /*  15130 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SBYTE*//*Label 159*/ GIMT_Encode4(800841),
     /*  15134 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_SSHORT*//*Label 160*/ GIMT_Encode4(800979),
     /*  15138 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_UBYTE*//*Label 161*/ GIMT_Encode4(801117),
     /*  15142 */ /*AMDGPU::G_AMDGPU_S_BUFFER_LOAD_USHORT*//*Label 162*/ GIMT_Encode4(801255),
     /*  15146 */ /*AMDGPU::G_AMDGPU_S_BUFFER_PREFETCH*//*Label 163*/ GIMT_Encode4(801393), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15158 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT*//*Label 164*/ GIMT_Encode4(801500),
     /*  15162 */ /*AMDGPU::G_AMDGPU_TBUFFER_LOAD_FORMAT_D16*//*Label 165*/ GIMT_Encode4(807080),
     /*  15166 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT*//*Label 166*/ GIMT_Encode4(812509),
     /*  15170 */ /*AMDGPU::G_AMDGPU_TBUFFER_STORE_FORMAT_D16*//*Label 167*/ GIMT_Encode4(818073),
     /*  15174 */ /*AMDGPU::G_AMDGPU_UMED3*//*Label 168*/ GIMT_Encode4(823414), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  15186 */ /*AMDGPU::G_AMDGPU_WHOLE_WAVE_FUNC_SETUP*//*Label 169*/ GIMT_Encode4(823720),
     /*  15190 */ // Label 0: @15190
     /*  15190 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 176*/ GIMT_Encode4(38561),
     /*  15201 */ /*GILLT_s1*//*Label 171*/ GIMT_Encode4(15221),
     /*  15205 */ /*GILLT_s16*//*Label 172*/ GIMT_Encode4(15340),
     /*  15209 */ /*GILLT_s32*//*Label 173*/ GIMT_Encode4(16331),
     /*  15213 */ /*GILLT_s64*//*Label 174*/ GIMT_Encode4(37820),
     /*  15217 */ /*GILLT_v2s16*//*Label 175*/ GIMT_Encode4(38291),
     /*  15221 */ // Label 171: @15221
     /*  15221 */ GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(15339),
     /*  15226 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  15229 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  15232 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(15260), // Rule ID 8160 //
     /*  15237 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  15240 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  15244 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  15248 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  15248 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  15251 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  15253 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15255 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  15258 */     GIR_RootConstrainSelectedInstOperands,
     /*  15259 */     // GIR_Coverage, 8160,
     /*  15259 */     GIR_EraseRootFromParent_Done,
     /*  15260 */   // Label 178: @15260
     /*  15260 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(15288), // Rule ID 8167 //
     /*  15265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  15268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  15272 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  15276 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  15276 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  15279 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  15281 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15283 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  15286 */     GIR_RootConstrainSelectedInstOperands,
     /*  15287 */     // GIR_Coverage, 8167,
     /*  15287 */     GIR_EraseRootFromParent_Done,
     /*  15288 */   // Label 179: @15288
     /*  15288 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(15313), // Rule ID 8158 //
     /*  15293 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  15296 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  15300 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  15300 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  15305 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  15311 */     GIR_RootConstrainSelectedInstOperands,
     /*  15312 */     // GIR_Coverage, 8158,
     /*  15312 */     GIR_Done,
     /*  15313 */   // Label 180: @15313
     /*  15313 */   GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(15338), // Rule ID 8165 //
     /*  15318 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  15321 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  15325 */     // (add:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  15325 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  15330 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  15336 */     GIR_RootConstrainSelectedInstOperands,
     /*  15337 */     // GIR_Coverage, 8165,
     /*  15337 */     GIR_Done,
     /*  15338 */   // Label 181: @15338
     /*  15338 */   GIM_Reject,
     /*  15339 */ // Label 177: @15339
     /*  15339 */ GIM_Reject,
     /*  15340 */ // Label 172: @15340
     /*  15340 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(16330),
     /*  15345 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  15348 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  15351 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(15403), // Rule ID 7624 //
     /*  15356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15360 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15364 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  15368 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  15372 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15376 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  15380 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  15384 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_38136),
     /*  15388 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15390 */     // (add:{ *:[i16] } (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_38136>>), i16:{ *:[i16] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  15390 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  15393 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15395 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  15399 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  15401 */     GIR_RootConstrainSelectedInstOperands,
     /*  15402 */     // GIR_Coverage, 7624,
     /*  15402 */     GIR_EraseRootFromParent_Done,
     /*  15403 */   // Label 183: @15403
     /*  15403 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(15455), // Rule ID 11934 //
     /*  15408 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15412 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15416 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_TRUNC),
     /*  15420 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  15424 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15428 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  15432 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  15436 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_38136),
     /*  15440 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  15442 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$val, (trunc:{ *:[i16] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_38136>>))  =>  (V_BCNT_U32_B32_e64:{ *:[i16] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i16] }:$val)
     /*  15442 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  15445 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // popcnt
     /*  15451 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  15453 */     GIR_RootConstrainSelectedInstOperands,
     /*  15454 */     // GIR_Coverage, 11934,
     /*  15454 */     GIR_EraseRootFromParent_Done,
     /*  15455 */   // Label 184: @15455
     /*  15455 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(15498), // Rule ID 2630 //
     /*  15460 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX8GFX9),
     /*  15463 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15467 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15471 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15475 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15479 */     // MIs[1] Operand 1
     /*  15479 */     // No operand predicates
     /*  15479 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15481 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } VSrc_b16:{ *:[i16] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1))
     /*  15481 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  15484 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15486 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15488 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15493 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15496 */     GIR_RootConstrainSelectedInstOperands,
     /*  15497 */     // GIR_Coverage, 2630,
     /*  15497 */     GIR_EraseRootFromParent_Done,
     /*  15498 */   // Label 185: @15498
     /*  15498 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(15550), // Rule ID 2794 //
     /*  15503 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  15506 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15510 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15514 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15518 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15522 */     // MIs[1] Operand 1
     /*  15522 */     // No operand predicates
     /*  15522 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15524 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  15524 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  15527 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15529 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15532 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15534 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15537 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15542 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15545 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15548 */     GIR_RootConstrainSelectedInstOperands,
     /*  15549 */     // GIR_Coverage, 2794,
     /*  15549 */     GIR_EraseRootFromParent_Done,
     /*  15550 */   // Label 186: @15550
     /*  15550 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(15602), // Rule ID 2797 //
     /*  15555 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15558 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15562 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15566 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15570 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15574 */     // MIs[1] Operand 1
     /*  15574 */     // No operand predicates
     /*  15574 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15576 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 bf16 f16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  15576 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  15579 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15581 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15584 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15586 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15589 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15594 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15597 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15600 */     GIR_RootConstrainSelectedInstOperands,
     /*  15601 */     // GIR_Coverage, 2797,
     /*  15601 */     GIR_EraseRootFromParent_Done,
     /*  15602 */   // Label 187: @15602
     /*  15602 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(15654), // Rule ID 2800 //
     /*  15607 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  15610 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15614 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15618 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  15622 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineIntConst16),
     /*  15626 */     // MIs[1] Operand 1
     /*  15626 */     // No operand predicates
     /*  15626 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15628 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>><<X:NegateImm>>:$src1)  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, VSrc_b16:{ *:[i16] }:$src0, 0:{ *:[i32] }, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i16] })<<P:Predicate_NegSubInlineIntConst16>>:$src1), 0:{ *:[i1] }, 0:{ *:[i32] })
     /*  15628 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  15631 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15636 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  15638 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15641 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  15646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15649 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15652 */     GIR_RootConstrainSelectedInstOperands,
     /*  15653 */     // GIR_Coverage, 2800,
     /*  15653 */     GIR_EraseRootFromParent_Done,
     /*  15654 */   // Label 188: @15654
     /*  15654 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(15704), // Rule ID 2675 //
     /*  15659 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  15662 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15666 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15670 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15674 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15678 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15682 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15684 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15684 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  15687 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15689 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15693 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15697 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15699 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15702 */     GIR_RootConstrainSelectedInstOperands,
     /*  15703 */     // GIR_Coverage, 2675,
     /*  15703 */     GIR_EraseRootFromParent_Done,
     /*  15704 */   // Label 189: @15704
     /*  15704 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(15766), // Rule ID 2676 //
     /*  15709 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15712 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15716 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15720 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15724 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15728 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15732 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15734 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15734 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  15737 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15739 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15742 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15746 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15749 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15753 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15756 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15758 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15761 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15764 */     GIR_RootConstrainSelectedInstOperands,
     /*  15765 */     // GIR_Coverage, 2676,
     /*  15765 */     GIR_EraseRootFromParent_Done,
     /*  15766 */   // Label 190: @15766
     /*  15766 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(15828), // Rule ID 2677 //
     /*  15771 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  15774 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15778 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15790 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15794 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15796 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15796 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  15799 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15801 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15808 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15815 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15818 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15820 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15823 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15826 */     GIR_RootConstrainSelectedInstOperands,
     /*  15827 */     // GIR_Coverage, 2677,
     /*  15827 */     GIR_EraseRootFromParent_Done,
     /*  15828 */   // Label 191: @15828
     /*  15828 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(15890), // Rule ID 2678 //
     /*  15833 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  15836 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15840 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15844 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15848 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15852 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15856 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15858 */     // (add:{ *:[i16] } (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1), i16:{ *:[i16] }:$src2)  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15858 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  15861 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15863 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15866 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15870 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15873 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15877 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15880 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  15882 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15885 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15888 */     GIR_RootConstrainSelectedInstOperands,
     /*  15889 */     // GIR_Coverage, 2678,
     /*  15889 */     GIR_EraseRootFromParent_Done,
     /*  15890 */   // Label 192: @15890
     /*  15890 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(15940), // Rule ID 9257 //
     /*  15895 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_isGFX6GFX7GFX8GFX9),
     /*  15898 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  15902 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15906 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15910 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15914 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15918 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15920 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1, i16:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15920 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_e64),
     /*  15923 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15929 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15933 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15935 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15938 */     GIR_RootConstrainSelectedInstOperands,
     /*  15939 */     // GIR_Coverage, 9257,
     /*  15939 */     GIR_EraseRootFromParent_Done,
     /*  15940 */   // Label 193: @15940
     /*  15940 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(16002), // Rule ID 9258 //
     /*  15945 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  15948 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  15952 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  15956 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  15960 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  15964 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  15968 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  15970 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_t16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  15970 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_t16_e64),
     /*  15973 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  15975 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15978 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  15982 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15985 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  15989 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15992 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  15994 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  15997 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16000 */     GIR_RootConstrainSelectedInstOperands,
     /*  16001 */     // GIR_Coverage, 9258,
     /*  16001 */     GIR_EraseRootFromParent_Done,
     /*  16002 */   // Label 194: @16002
     /*  16002 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(16064), // Rule ID 9259 //
     /*  16007 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  16010 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16014 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16018 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16022 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16026 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16030 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16032 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_fake16_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16032 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_fake16_e64),
     /*  16035 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16037 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16044 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16047 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16051 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16054 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16056 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16059 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16062 */     GIR_RootConstrainSelectedInstOperands,
     /*  16063 */     // GIR_Coverage, 9259,
     /*  16063 */     GIR_EraseRootFromParent_Done,
     /*  16064 */   // Label 195: @16064
     /*  16064 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(16126), // Rule ID 9260 //
     /*  16069 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16072 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  16080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  16084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  16088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  16092 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  16094 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src2, (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1))  =>  (V_MAD_U16_gfx9_e64:{ *:[i16] } 0:{ *:[i32] }, ?:{ *:[i16] }:$src0, 0:{ *:[i32] }, ?:{ *:[i16] }:$src1, 0:{ *:[i32] }, ?:{ *:[i16] }:$src2, 0:{ *:[i1] })
     /*  16094 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U16_gfx9_e64),
     /*  16097 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16099 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16102 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  16106 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16109 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  16113 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16116 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  16118 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16124 */     GIR_RootConstrainSelectedInstOperands,
     /*  16125 */     // GIR_Coverage, 9260,
     /*  16125 */     GIR_EraseRootFromParent_Done,
     /*  16126 */   // Label 196: @16126
     /*  16126 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(16185), // Rule ID 1105 //
     /*  16131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  16134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16138 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16145 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  16152 */     // (add:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  16152 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_e64),
     /*  16155 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16157 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  16162 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  16167 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  16172 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  16177 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16180 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16183 */     GIR_RootConstrainSelectedInstOperands,
     /*  16184 */     // GIR_Coverage, 1105,
     /*  16184 */     GIR_EraseRootFromParent_Done,
     /*  16185 */   // Label 197: @16185
     /*  16185 */   GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(16244), // Rule ID 1106 //
     /*  16190 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  16193 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  16197 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  16204 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  16211 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  16211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_t16_e64),
     /*  16214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16216 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  16221 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  16226 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  16231 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  16236 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16239 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16242 */     GIR_RootConstrainSelectedInstOperands,
     /*  16243 */     // GIR_Coverage, 1106,
     /*  16243 */     GIR_EraseRootFromParent_Done,
     /*  16244 */   // Label 198: @16244
     /*  16244 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(16303), // Rule ID 1107 //
     /*  16249 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  16252 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16256 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  16263 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  16270 */     // (add:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_ADD_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  16270 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_NC_U16_fake16_e64),
     /*  16273 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16275 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  16280 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  16285 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  16290 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  16295 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16298 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16301 */     GIR_RootConstrainSelectedInstOperands,
     /*  16302 */     // GIR_Coverage, 1107,
     /*  16302 */     GIR_EraseRootFromParent_Done,
     /*  16303 */   // Label 199: @16303
     /*  16303 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(16329), // Rule ID 944 //
     /*  16308 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  16311 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16315 */     // (add:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_ADD_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  16315 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U16_e64),
     /*  16318 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16320 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  16322 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  16324 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16327 */     GIR_RootConstrainSelectedInstOperands,
     /*  16328 */     // GIR_Coverage, 944,
     /*  16328 */     GIR_EraseRootFromParent_Done,
     /*  16329 */   // Label 200: @16329
     /*  16329 */   GIM_Reject,
     /*  16330 */ // Label 182: @16330
     /*  16330 */ GIM_Reject,
     /*  16331 */ // Label 173: @16331
     /*  16331 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(37819),
     /*  16336 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  16339 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  16342 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(16841), // Rule ID 9379 //
     /*  16347 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  16350 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  16352 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16356 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16360 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16364 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  16367 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16372 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16376 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  16380 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  16382 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16386 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16390 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16394 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16398 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  16402 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  16406 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16410 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  16414 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  16418 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  16422 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  16426 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16430 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  16434 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  16438 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  16440 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16444 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16448 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  16451 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16456 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  16460 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  16464 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  16466 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  16470 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16474 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  16478 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  16482 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  16486 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16490 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  16494 */     // MIs[7] src0
     /*  16494 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16499 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  16503 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  16514 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  16518 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16522 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  16526 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  16530 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  16534 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16538 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  16542 */     // MIs[9] src1
     /*  16542 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16547 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  16551 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  16562 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  16566 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16570 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  16574 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  16578 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  16580 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  16584 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16588 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  16591 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16596 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  16600 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  16604 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  16606 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  16610 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16614 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  16618 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  16622 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  16626 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16630 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  16634 */     // MIs[13] src0
     /*  16634 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16639 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  16643 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  16654 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  16658 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16662 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  16666 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  16670 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  16674 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16678 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  16682 */     // MIs[15] src1
     /*  16682 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16687 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  16691 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  16702 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  16706 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16710 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  16714 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  16718 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  16720 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  16724 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16728 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  16731 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16736 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  16740 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  16744 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  16746 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  16750 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16754 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  16758 */     // MIs[18] src0
     /*  16758 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16763 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  16774 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  16778 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16782 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  16786 */     // MIs[19] src1
     /*  16786 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  16791 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  16802 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  16804 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  16804 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  16807 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  16809 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16812 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  16816 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16819 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  16823 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  16826 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  16830 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16833 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  16839 */     GIR_RootConstrainSelectedInstOperands,
     /*  16840 */     // GIR_Coverage, 9379,
     /*  16840 */     GIR_EraseRootFromParent_Done,
     /*  16841 */   // Label 202: @16841
     /*  16841 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(17340), // Rule ID 9378 //
     /*  16846 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  16849 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  16851 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  16855 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16859 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16863 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  16866 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16871 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  16875 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  16879 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  16881 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16885 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16889 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  16893 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  16897 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  16901 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  16905 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16909 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  16913 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  16917 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  16921 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  16925 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  16929 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  16933 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  16937 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  16939 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16943 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  16947 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  16950 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  16955 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  16959 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  16963 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  16965 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  16969 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16973 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  16977 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  16981 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  16985 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  16989 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  16993 */     // MIs[7] src0
     /*  16993 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16998 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17002 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17013 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17017 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17021 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17025 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17029 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17033 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17037 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17041 */     // MIs[9] src1
     /*  17041 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17046 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17050 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17061 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17065 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17069 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17073 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17077 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17079 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17083 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17087 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  17090 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17095 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17099 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  17103 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17105 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  17109 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17113 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  17117 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17121 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  17125 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17129 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17133 */     // MIs[13] src0
     /*  17133 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17138 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  17142 */     GIM_CheckConstantInt, /*MI*/12, /*Op*/2, GIMT_Encode8(255),
     /*  17153 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  17157 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17161 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  17165 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17169 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  17173 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17177 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17181 */     // MIs[15] src1
     /*  17181 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17186 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  17190 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17201 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  17205 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17209 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17213 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17217 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  17219 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  17223 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17227 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  17230 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17235 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17239 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  17243 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  17245 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  17249 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17253 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17257 */     // MIs[18] src0
     /*  17257 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17262 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17273 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  17277 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17281 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17285 */     // MIs[19] src1
     /*  17285 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17290 */     GIM_CheckConstantInt, /*MI*/19, /*Op*/2, GIMT_Encode8(255),
     /*  17301 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17303 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17303 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17306 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17308 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17311 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17315 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17322 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17325 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  17329 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17332 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17335 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17338 */     GIR_RootConstrainSelectedInstOperands,
     /*  17339 */     // GIR_Coverage, 9378,
     /*  17339 */     GIR_EraseRootFromParent_Done,
     /*  17340 */   // Label 203: @17340
     /*  17340 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(17839), // Rule ID 9377 //
     /*  17345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17348 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17350 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17354 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17358 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17362 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17365 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17370 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17374 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17378 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17380 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17384 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17388 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17392 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17396 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17400 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17404 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17408 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17412 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17416 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17420 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17424 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17428 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17432 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17436 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17438 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17442 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17446 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17449 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17454 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17458 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17462 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17464 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17468 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17472 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17476 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17480 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17484 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17488 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17492 */     // MIs[7] src0
     /*  17492 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17497 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  17501 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  17512 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  17516 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17520 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  17524 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  17528 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  17532 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17536 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  17540 */     // MIs[9] src1
     /*  17540 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17545 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  17549 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  17560 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  17564 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17568 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  17572 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  17576 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  17578 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  17582 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17586 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  17590 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  17594 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  17596 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  17600 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17604 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  17607 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17612 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  17616 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  17620 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  17622 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  17626 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17630 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  17634 */     // MIs[13] src0
     /*  17634 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17639 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  17650 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  17654 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17658 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  17662 */     // MIs[14] src1
     /*  17662 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17667 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  17678 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  17682 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17686 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  17689 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17694 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  17698 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  17702 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  17704 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  17708 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17712 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  17716 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  17720 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  17724 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17728 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  17732 */     // MIs[17] src0
     /*  17732 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17737 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  17741 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  17752 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  17756 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17760 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  17764 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  17768 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  17772 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17776 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  17780 */     // MIs[19] src1
     /*  17780 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  17785 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  17789 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  17800 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  17802 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  17802 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  17805 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  17807 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17810 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  17814 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17817 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  17821 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  17824 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  17828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17831 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17834 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  17837 */     GIR_RootConstrainSelectedInstOperands,
     /*  17838 */     // GIR_Coverage, 9377,
     /*  17838 */     GIR_EraseRootFromParent_Done,
     /*  17839 */   // Label 204: @17839
     /*  17839 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(18338), // Rule ID 9376 //
     /*  17844 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  17847 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  17849 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  17853 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17857 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17861 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  17864 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17869 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  17873 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  17877 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  17879 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17883 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17887 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  17891 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  17895 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  17899 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  17903 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17907 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  17911 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  17915 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  17919 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  17923 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  17927 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  17931 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  17935 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  17937 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17941 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  17945 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  17948 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  17953 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  17957 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  17961 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  17963 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  17967 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17971 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  17975 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  17979 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  17983 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  17987 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  17991 */     // MIs[7] src0
     /*  17991 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17996 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  18000 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  18011 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  18015 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18019 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  18023 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18027 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  18031 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18035 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18039 */     // MIs[9] src1
     /*  18039 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18044 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  18048 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  18059 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  18063 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18067 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  18071 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18075 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  18077 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  18081 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18085 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18089 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18093 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18095 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  18099 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18103 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18106 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18111 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18115 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18119 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18121 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18125 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18129 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18133 */     // MIs[13] src0
     /*  18133 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18138 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18149 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18153 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18157 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18161 */     // MIs[14] src1
     /*  18161 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18166 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18177 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  18181 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18185 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18188 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18193 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18197 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18201 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18203 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18207 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18211 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18215 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18219 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18223 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18227 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18231 */     // MIs[17] src0
     /*  18231 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18236 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  18240 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18251 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18255 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18259 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18263 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18267 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18271 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18275 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18279 */     // MIs[19] src1
     /*  18279 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18284 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  18288 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18299 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18301 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18306 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18309 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18313 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18320 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18323 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  18327 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18330 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18336 */     GIR_RootConstrainSelectedInstOperands,
     /*  18337 */     // GIR_Coverage, 9376,
     /*  18337 */     GIR_EraseRootFromParent_Done,
     /*  18338 */   // Label 205: @18338
     /*  18338 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(18837), // Rule ID 9375 //
     /*  18343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18346 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18348 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18360 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18363 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18368 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18372 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18376 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18378 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18382 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18386 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18390 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18394 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18398 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18402 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18406 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18410 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18414 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18418 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18422 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18426 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18430 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18434 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18436 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18440 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18444 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  18448 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18452 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18454 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  18458 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18462 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  18465 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18470 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18474 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  18478 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  18480 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  18484 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18488 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  18492 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18496 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  18500 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18504 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  18508 */     // MIs[8] src0
     /*  18508 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18513 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  18517 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  18528 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  18532 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18536 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  18540 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  18544 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  18548 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18552 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  18556 */     // MIs[10] src1
     /*  18556 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18561 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  18565 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  18576 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  18580 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18584 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  18588 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  18592 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  18594 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  18598 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18602 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  18605 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18610 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  18614 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  18618 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  18620 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  18624 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18628 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  18632 */     // MIs[13] src0
     /*  18632 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18637 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  18648 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  18652 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18656 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  18660 */     // MIs[14] src1
     /*  18660 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18665 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  18676 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  18680 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18684 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  18687 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18692 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  18696 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  18700 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  18702 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  18706 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18710 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  18714 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  18718 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  18722 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18726 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  18730 */     // MIs[17] src0
     /*  18730 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18735 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  18739 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  18750 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  18754 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18758 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  18762 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  18766 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  18770 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18774 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  18778 */     // MIs[19] src1
     /*  18778 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  18783 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  18787 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  18798 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  18800 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  18800 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  18803 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  18805 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18808 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  18812 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18815 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  18819 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  18822 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  18826 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18829 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18832 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  18835 */     GIR_RootConstrainSelectedInstOperands,
     /*  18836 */     // GIR_Coverage, 9375,
     /*  18836 */     GIR_EraseRootFromParent_Done,
     /*  18837 */   // Label 206: @18837
     /*  18837 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(19336), // Rule ID 9374 //
     /*  18842 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  18845 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  18847 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  18851 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18855 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18859 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  18862 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18867 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  18871 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  18875 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  18877 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18881 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18885 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  18889 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  18893 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  18897 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  18901 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  18905 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  18909 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  18913 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  18917 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  18921 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18925 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  18929 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  18933 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  18935 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18939 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  18943 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  18947 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  18951 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  18953 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  18957 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  18961 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  18964 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  18969 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  18973 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  18977 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  18979 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  18983 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18987 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  18991 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  18995 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  18999 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19003 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19007 */     // MIs[8] src0
     /*  19007 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19012 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  19016 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(255),
     /*  19027 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  19031 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19035 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  19039 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19043 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  19047 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19051 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19055 */     // MIs[10] src1
     /*  19055 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19060 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  19064 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19075 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  19079 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19083 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19087 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19091 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  19093 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  19097 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19101 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  19104 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19109 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19113 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  19117 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  19119 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  19123 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19127 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19131 */     // MIs[13] src0
     /*  19131 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19136 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19147 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  19151 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19155 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19159 */     // MIs[14] src1
     /*  19159 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19164 */     GIM_CheckConstantInt, /*MI*/14, /*Op*/2, GIMT_Encode8(255),
     /*  19175 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19179 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19183 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19186 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19191 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19195 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19199 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19201 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19205 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19209 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19213 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19217 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19221 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19225 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19229 */     // MIs[17] src0
     /*  19229 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19234 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19238 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19249 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19253 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19257 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19261 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19265 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19269 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19273 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19277 */     // MIs[19] src1
     /*  19277 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19282 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19286 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19297 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19299 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19299 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19302 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19304 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19307 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19311 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19321 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  19325 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19328 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19331 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19334 */     GIR_RootConstrainSelectedInstOperands,
     /*  19335 */     // GIR_Coverage, 9374,
     /*  19335 */     GIR_EraseRootFromParent_Done,
     /*  19336 */   // Label 207: @19336
     /*  19336 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(19835), // Rule ID 9373 //
     /*  19341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19344 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19358 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19361 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19366 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19370 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19374 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19376 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19380 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19384 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19388 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19392 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19396 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19400 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19404 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19408 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19412 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19416 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19420 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19424 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19428 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19432 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19434 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19438 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19442 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19446 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19450 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19452 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19456 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19460 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  19464 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19468 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19470 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  19474 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19478 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  19481 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19486 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19490 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  19494 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  19496 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  19500 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19504 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  19508 */     // MIs[8] src0
     /*  19508 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19513 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  19524 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  19528 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19532 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  19536 */     // MIs[9] src1
     /*  19536 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19541 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  19552 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  19556 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19560 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  19563 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19568 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  19572 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  19576 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  19578 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  19582 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19586 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  19590 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  19594 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  19598 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19602 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  19606 */     // MIs[12] src0
     /*  19606 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19611 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  19615 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  19626 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  19630 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19634 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  19638 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  19642 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  19646 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19650 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  19654 */     // MIs[14] src1
     /*  19654 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19659 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  19663 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  19674 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  19678 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19682 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  19685 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19690 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  19694 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  19698 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  19700 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  19704 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19708 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  19712 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  19716 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  19720 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19724 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  19728 */     // MIs[17] src0
     /*  19728 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19733 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  19737 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  19748 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  19752 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19756 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  19760 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  19764 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  19768 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19772 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  19776 */     // MIs[19] src1
     /*  19776 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  19781 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  19785 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  19796 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  19798 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  19798 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  19801 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  19803 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19806 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  19810 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19813 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  19817 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  19820 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  19824 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19827 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19830 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  19833 */     GIR_RootConstrainSelectedInstOperands,
     /*  19834 */     // GIR_Coverage, 9373,
     /*  19834 */     GIR_EraseRootFromParent_Done,
     /*  19835 */   // Label 208: @19835
     /*  19835 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(20334), // Rule ID 9372 //
     /*  19840 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  19843 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  19845 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  19849 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19853 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19857 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  19860 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19865 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  19869 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  19873 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  19875 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19879 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19883 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  19887 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  19891 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  19895 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  19899 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  19903 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  19907 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  19911 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  19915 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  19919 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19923 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  19927 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  19931 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  19933 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19937 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19941 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  19945 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  19949 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  19951 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  19955 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  19959 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  19963 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  19967 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  19969 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  19973 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  19977 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  19980 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  19985 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  19989 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  19993 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  19995 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  19999 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20003 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20007 */     // MIs[8] src0
     /*  20007 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20012 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  20023 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  20027 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20031 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20035 */     // MIs[9] src1
     /*  20035 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20040 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20051 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  20055 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20059 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  20062 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20067 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20071 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  20075 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  20077 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  20081 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20085 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20089 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20093 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20097 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20101 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20105 */     // MIs[12] src0
     /*  20105 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20110 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20114 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20125 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  20129 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20133 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20137 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20141 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20145 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20149 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20153 */     // MIs[14] src1
     /*  20153 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20158 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  20162 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  20173 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  20177 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20181 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  20184 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20189 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20193 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  20197 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  20199 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  20203 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20207 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  20211 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20215 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  20219 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20223 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20227 */     // MIs[17] src0
     /*  20227 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20232 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  20236 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20247 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  20251 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20255 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  20259 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20263 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  20267 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20271 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20275 */     // MIs[19] src1
     /*  20275 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  20280 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  20284 */     GIM_CheckConstantInt, /*MI*/18, /*Op*/2, GIMT_Encode8(255),
     /*  20295 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20297 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20297 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20300 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20302 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20305 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  20309 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  20316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20319 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  20323 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20329 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20332 */     GIR_RootConstrainSelectedInstOperands,
     /*  20333 */     // GIR_Coverage, 9372,
     /*  20333 */     GIR_EraseRootFromParent_Done,
     /*  20334 */   // Label 209: @20334
     /*  20334 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(20833), // Rule ID 9371 //
     /*  20339 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20342 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20356 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20360 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20364 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20366 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  20370 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20374 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  20377 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20382 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20386 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  20390 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  20392 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  20396 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20400 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20404 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20408 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20412 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20416 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20420 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20424 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  20428 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  20439 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  20443 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20447 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20451 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20455 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20459 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20463 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20467 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20471 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  20475 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  20486 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  20490 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20494 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  20498 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  20502 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  20504 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  20508 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20512 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  20515 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20520 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  20524 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  20528 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  20530 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  20534 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20538 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  20542 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  20546 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  20550 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20554 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  20558 */     // MIs[10] src0
     /*  20558 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20563 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  20567 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  20578 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  20582 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20586 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  20590 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  20594 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  20598 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20602 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  20606 */     // MIs[12] src1
     /*  20606 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20611 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  20615 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  20626 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  20630 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20634 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  20638 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  20642 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  20644 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  20648 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20652 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  20655 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20660 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  20664 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  20668 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  20670 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  20674 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20678 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  20682 */     // MIs[15] src0
     /*  20682 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20687 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  20698 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  20702 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20706 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  20710 */     // MIs[16] src1
     /*  20710 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20715 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  20726 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  20730 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20734 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  20737 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20742 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  20746 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  20750 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  20752 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  20756 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20760 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  20764 */     // MIs[18] src0
     /*  20764 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  20769 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  20773 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  20777 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20781 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  20785 */     // MIs[19] src1
     /*  20785 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  20790 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  20794 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  20796 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  20796 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  20799 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  20801 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  20808 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  20815 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  20818 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  20822 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20825 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20828 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  20831 */     GIR_RootConstrainSelectedInstOperands,
     /*  20832 */     // GIR_Coverage, 9371,
     /*  20832 */     GIR_EraseRootFromParent_Done,
     /*  20833 */   // Label 210: @20833
     /*  20833 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(21332), // Rule ID 9370 //
     /*  20838 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  20841 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  20843 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  20847 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20851 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20855 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  20859 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  20863 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  20865 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  20869 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  20873 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  20876 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  20881 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  20885 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  20889 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  20891 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  20895 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20899 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  20903 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  20907 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20911 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20915 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  20919 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  20923 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  20927 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  20938 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  20942 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20946 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  20950 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  20954 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  20958 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  20962 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  20966 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  20970 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  20974 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  20985 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  20989 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  20993 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  20997 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21001 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21003 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21007 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21011 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  21014 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21019 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21023 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  21027 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21029 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  21033 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21037 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  21041 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21045 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  21049 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21053 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21057 */     // MIs[10] src0
     /*  21057 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21062 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  21066 */     GIM_CheckConstantInt, /*MI*/9, /*Op*/2, GIMT_Encode8(255),
     /*  21077 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  21081 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21085 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  21089 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21093 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  21097 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21101 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21105 */     // MIs[12] src1
     /*  21105 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21110 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  21114 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21125 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  21129 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21133 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21137 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21141 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  21143 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  21147 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21151 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  21154 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21159 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21163 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  21167 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  21169 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  21173 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21177 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21181 */     // MIs[15] src0
     /*  21181 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21186 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21197 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  21201 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21205 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21209 */     // MIs[16] src1
     /*  21209 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21214 */     GIM_CheckConstantInt, /*MI*/16, /*Op*/2, GIMT_Encode8(255),
     /*  21225 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21229 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21233 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21236 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21241 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21245 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21249 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21251 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21255 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21259 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21263 */     // MIs[18] src0
     /*  21263 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21268 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21272 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21276 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21280 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21284 */     // MIs[19] src1
     /*  21284 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21289 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21293 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21295 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21295 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21298 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21300 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21303 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21307 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21310 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21314 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21317 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  21321 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21324 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21327 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21330 */     GIR_RootConstrainSelectedInstOperands,
     /*  21331 */     // GIR_Coverage, 9370,
     /*  21331 */     GIR_EraseRootFromParent_Done,
     /*  21332 */   // Label 211: @21332
     /*  21332 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(21831), // Rule ID 9369 //
     /*  21337 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21340 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21342 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21346 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21350 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21354 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21358 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21362 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21364 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21368 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21372 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21375 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21380 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21384 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21388 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21390 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21394 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21398 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21402 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21406 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21410 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21414 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21418 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21422 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21426 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21437 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21441 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21445 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21449 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21453 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21457 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21461 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21465 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21469 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21473 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21484 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21488 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21492 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21496 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21500 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  21502 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  21506 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21510 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  21514 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  21518 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  21520 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  21524 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21528 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  21531 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21536 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  21540 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  21544 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  21546 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  21550 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21554 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  21558 */     // MIs[10] src0
     /*  21558 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21563 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  21574 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  21578 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21582 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  21586 */     // MIs[11] src1
     /*  21586 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21591 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  21602 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  21606 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21610 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  21613 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21618 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  21622 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  21626 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  21628 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  21632 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21636 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  21640 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  21644 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  21648 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21652 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  21656 */     // MIs[14] src0
     /*  21656 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21661 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  21665 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  21676 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  21680 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21684 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  21688 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  21692 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  21696 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21700 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  21704 */     // MIs[16] src1
     /*  21704 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21709 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  21713 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  21724 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  21728 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21732 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  21735 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21740 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  21744 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  21748 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  21750 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  21754 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21758 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  21762 */     // MIs[18] src0
     /*  21762 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  21767 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  21771 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  21775 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21779 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  21783 */     // MIs[19] src1
     /*  21783 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  21788 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  21792 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  21794 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  21794 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  21797 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  21799 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  21806 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21809 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  21813 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  21816 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  21820 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21823 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21826 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  21829 */     GIR_RootConstrainSelectedInstOperands,
     /*  21830 */     // GIR_Coverage, 9369,
     /*  21830 */     GIR_EraseRootFromParent_Done,
     /*  21831 */   // Label 212: @21831
     /*  21831 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(22330), // Rule ID 9368 //
     /*  21836 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  21839 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  21841 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  21845 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21849 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21853 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  21857 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  21861 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  21863 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  21867 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  21871 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  21874 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  21879 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  21883 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  21887 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  21889 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  21893 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21897 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  21901 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  21905 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21909 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21913 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  21917 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  21921 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  21925 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
     /*  21936 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  21940 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21944 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  21948 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  21952 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  21956 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  21960 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  21964 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  21968 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  21972 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  21983 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  21987 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  21991 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  21995 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  21999 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  22001 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  22005 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22009 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22013 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22017 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22019 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  22023 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22027 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22030 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22035 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22039 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22043 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22045 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22049 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22053 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22057 */     // MIs[10] src0
     /*  22057 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22062 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22073 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22077 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22081 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22085 */     // MIs[11] src1
     /*  22085 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22090 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22101 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  22105 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22109 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22112 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22117 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22121 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22125 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22127 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22131 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22135 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22139 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22143 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22147 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22151 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22155 */     // MIs[14] src0
     /*  22155 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22160 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  22164 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22175 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22179 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22183 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22187 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22191 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22195 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22199 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22203 */     // MIs[16] src1
     /*  22203 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22208 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  22212 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22223 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22227 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22231 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22234 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22239 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22243 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22247 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22249 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22253 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22257 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22261 */     // MIs[18] src0
     /*  22261 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  22266 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22270 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22274 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22278 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22282 */     // MIs[19] src1
     /*  22282 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  22287 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22291 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22293 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22293 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22296 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22298 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22301 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  22305 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  22312 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22315 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  22319 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22322 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22325 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22328 */     GIR_RootConstrainSelectedInstOperands,
     /*  22329 */     // GIR_Coverage, 9368,
     /*  22329 */     GIR_EraseRootFromParent_Done,
     /*  22330 */   // Label 213: @22330
     /*  22330 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(22829), // Rule ID 9367 //
     /*  22335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22338 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22340 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22344 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22348 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22352 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22356 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22360 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22362 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22366 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22370 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  22374 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22378 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22380 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  22384 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22388 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  22391 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22396 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22400 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  22404 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  22406 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  22410 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22414 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22418 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22422 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  22426 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22430 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22434 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22438 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  22442 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  22453 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  22457 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22461 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22465 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22469 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  22473 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22477 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22481 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22485 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  22489 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  22500 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  22504 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22508 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  22512 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  22516 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  22518 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  22522 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22526 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  22529 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22534 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  22538 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  22542 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  22544 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  22548 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22552 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  22556 */     // MIs[10] src0
     /*  22556 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22561 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  22572 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  22576 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22580 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  22584 */     // MIs[11] src1
     /*  22584 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22589 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  22600 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  22604 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22608 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  22611 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22616 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  22620 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  22624 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  22626 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  22630 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22634 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  22638 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  22642 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  22646 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22650 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  22654 */     // MIs[14] src0
     /*  22654 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22659 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  22663 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  22674 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  22678 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22682 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  22686 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  22690 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  22694 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22698 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  22702 */     // MIs[16] src1
     /*  22702 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22707 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  22711 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  22722 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  22726 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22730 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  22733 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22738 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  22742 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  22746 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  22748 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  22752 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22756 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  22760 */     // MIs[18] src0
     /*  22760 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  22765 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  22769 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  22773 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22777 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  22781 */     // MIs[19] src1
     /*  22781 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  22786 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  22790 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  22792 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  22792 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  22795 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  22797 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  22804 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22807 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  22811 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  22814 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  22818 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22821 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22824 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  22827 */     GIR_RootConstrainSelectedInstOperands,
     /*  22828 */     // GIR_Coverage, 9367,
     /*  22828 */     GIR_EraseRootFromParent_Done,
     /*  22829 */   // Label 214: @22829
     /*  22829 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(23328), // Rule ID 9366 //
     /*  22834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  22837 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  22839 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  22843 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22847 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22851 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  22855 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  22859 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  22861 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  22865 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  22869 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  22873 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  22877 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  22879 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  22883 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  22887 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  22890 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  22895 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  22899 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  22903 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  22905 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  22909 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22913 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  22917 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  22921 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  22925 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22929 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  22933 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  22937 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  22941 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  22952 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  22956 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22960 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  22964 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  22968 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  22972 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  22976 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  22980 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  22984 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  22988 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  22999 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  23003 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23007 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23011 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23015 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  23017 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  23021 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23025 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  23028 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23033 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23037 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  23041 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  23043 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  23047 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23051 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23055 */     // MIs[10] src0
     /*  23055 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23060 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23071 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  23075 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23079 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23083 */     // MIs[11] src1
     /*  23083 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23088 */     GIM_CheckConstantInt, /*MI*/11, /*Op*/2, GIMT_Encode8(255),
     /*  23099 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23103 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23107 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23110 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23115 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23119 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23123 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23125 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23129 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23133 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23137 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23141 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23145 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23149 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23153 */     // MIs[14] src0
     /*  23153 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23158 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23162 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23173 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23177 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23181 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23185 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23189 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23193 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23197 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23201 */     // MIs[16] src1
     /*  23201 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23206 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23210 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23221 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23225 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23229 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23232 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23237 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23241 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23245 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23247 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23251 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23255 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23259 */     // MIs[18] src0
     /*  23259 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23264 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23268 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23272 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23276 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23280 */     // MIs[19] src1
     /*  23280 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  23285 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23289 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23291 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23291 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23294 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23296 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23299 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23303 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23306 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  23310 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23313 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  23317 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23320 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23323 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23326 */     GIR_RootConstrainSelectedInstOperands,
     /*  23327 */     // GIR_Coverage, 9366,
     /*  23327 */     GIR_EraseRootFromParent_Done,
     /*  23328 */   // Label 215: @23328
     /*  23328 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(23827), // Rule ID 9365 //
     /*  23333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23336 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23338 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23342 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23346 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23350 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23354 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23358 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23360 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23364 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23368 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23372 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23376 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23378 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23382 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23386 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  23390 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23394 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23396 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23400 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23404 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  23407 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23412 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23416 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  23420 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  23422 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23426 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23430 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23434 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23438 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  23449 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  23453 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23457 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23461 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23465 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23476 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  23480 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23484 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  23487 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23492 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23496 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  23500 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  23502 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  23506 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23510 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  23514 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  23518 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  23522 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23526 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  23530 */     // MIs[9] src0
     /*  23530 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23535 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  23539 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  23550 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  23554 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23558 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  23562 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  23566 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  23570 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23574 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  23578 */     // MIs[11] src1
     /*  23578 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23583 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  23587 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  23598 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  23602 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23606 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  23609 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23614 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  23618 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  23622 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  23624 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  23628 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23632 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  23636 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  23640 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  23644 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23648 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  23652 */     // MIs[14] src0
     /*  23652 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23657 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  23661 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  23672 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  23676 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23680 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  23684 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  23688 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  23692 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23696 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  23700 */     // MIs[16] src1
     /*  23700 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23705 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  23709 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  23720 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  23724 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23728 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  23731 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23736 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  23740 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  23744 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  23746 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  23750 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23754 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  23758 */     // MIs[18] src0
     /*  23758 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  23763 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  23767 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  23771 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  23775 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  23779 */     // MIs[19] src1
     /*  23779 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  23784 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  23788 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  23790 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  23790 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  23793 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  23795 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23798 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  23802 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23805 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  23809 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  23812 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  23816 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23819 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23822 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  23825 */     GIR_RootConstrainSelectedInstOperands,
     /*  23826 */     // GIR_Coverage, 9365,
     /*  23826 */     GIR_EraseRootFromParent_Done,
     /*  23827 */   // Label 216: @23827
     /*  23827 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(24326), // Rule ID 2910 //
     /*  23832 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot7Insts),
     /*  23835 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  23837 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  23841 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23845 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23849 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  23853 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  23857 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  23859 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  23863 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23867 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  23871 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  23875 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  23877 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  23881 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  23885 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  23889 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  23893 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  23895 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  23899 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23903 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  23906 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23911 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  23915 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  23919 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  23921 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23925 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23929 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  23933 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  23937 */     GIM_CheckConstantInt, /*MI*/5, /*Op*/2, GIMT_Encode8(255),
     /*  23948 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  23952 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23956 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  23960 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  23964 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(255),
     /*  23975 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  23979 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  23983 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  23986 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  23991 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  23995 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  23999 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  24001 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  24005 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24009 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24013 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  24017 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24021 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24025 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24029 */     // MIs[9] src0
     /*  24029 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24034 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  24038 */     GIM_CheckConstantInt, /*MI*/8, /*Op*/2, GIMT_Encode8(255),
     /*  24049 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  24053 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24057 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24061 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24065 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24069 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24073 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24077 */     // MIs[11] src1
     /*  24077 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24082 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  24086 */     GIM_CheckConstantInt, /*MI*/10, /*Op*/2, GIMT_Encode8(255),
     /*  24097 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  24101 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24105 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  24108 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24113 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  24117 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  24121 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  24123 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  24127 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24131 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  24135 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24139 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  24143 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24147 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  24151 */     // MIs[14] src0
     /*  24151 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24156 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  24160 */     GIM_CheckConstantInt, /*MI*/13, /*Op*/2, GIMT_Encode8(255),
     /*  24171 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  24175 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24179 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  24183 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24187 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  24191 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24195 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24199 */     // MIs[16] src1
     /*  24199 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24204 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  24208 */     GIM_CheckConstantInt, /*MI*/15, /*Op*/2, GIMT_Encode8(255),
     /*  24219 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  24223 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24227 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24230 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  24235 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24239 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24243 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24245 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24249 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24253 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  24257 */     // MIs[18] src0
     /*  24257 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  24262 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  24266 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24270 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24274 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  24278 */     // MIs[19] src1
     /*  24278 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  24283 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  24287 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24289 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 255:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), 255:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), 255:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_U32_U8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24289 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_U32_U8),
     /*  24292 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24294 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24297 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  24301 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24304 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  24308 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24311 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  24315 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24321 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24324 */     GIR_RootConstrainSelectedInstOperands,
     /*  24325 */     // GIR_Coverage, 2910,
     /*  24325 */     GIR_EraseRootFromParent_Done,
     /*  24326 */   // Label 217: @24326
     /*  24326 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(24801), // Rule ID 10659 //
     /*  24331 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  24334 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24348 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24351 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24356 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24360 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  24364 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24366 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24370 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24374 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24378 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24382 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  24386 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  24390 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24394 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24398 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24402 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  24406 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  24410 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24414 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  24418 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24422 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24424 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  24428 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24432 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  24435 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24440 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24444 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  24448 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  24450 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  24454 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24458 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24462 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  24466 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24470 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24474 */     // MIs[7] src0
     /*  24474 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24479 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  24483 */     // MIs[6] Operand 2
     /*  24483 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  24494 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  24498 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24502 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24506 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24510 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24514 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24518 */     // MIs[9] src1
     /*  24518 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24523 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  24527 */     // MIs[8] Operand 2
     /*  24527 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  24538 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  24542 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24546 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  24550 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  24554 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  24556 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  24560 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24564 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  24567 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24572 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  24576 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  24580 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  24582 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  24586 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24590 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  24594 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  24598 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24602 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  24606 */     // MIs[13] src0
     /*  24606 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24611 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  24615 */     // MIs[12] Operand 2
     /*  24615 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  24626 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  24630 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24634 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  24638 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  24642 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24646 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  24650 */     // MIs[15] src1
     /*  24650 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24655 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  24659 */     // MIs[14] Operand 2
     /*  24659 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  24670 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  24674 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24678 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  24682 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  24686 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  24688 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  24692 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24696 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  24699 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24704 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  24708 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  24712 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  24714 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  24718 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24722 */     // MIs[18] src0
     /*  24722 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24727 */     // MIs[18] Operand 2
     /*  24727 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  24738 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  24742 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24746 */     // MIs[19] src1
     /*  24746 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24751 */     // MIs[19] Operand 2
     /*  24751 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  24762 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  24764 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  24764 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  24767 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  24769 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  24776 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24779 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  24783 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  24786 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/2, // src2
     /*  24790 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24793 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24796 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  24799 */     GIR_RootConstrainSelectedInstOperands,
     /*  24800 */     // GIR_Coverage, 10659,
     /*  24800 */     GIR_EraseRootFromParent_Done,
     /*  24801 */   // Label 218: @24801
     /*  24801 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(25276), // Rule ID 10658 //
     /*  24806 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  24809 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  24811 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  24815 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24819 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24823 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  24826 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24831 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  24835 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  24839 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  24841 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24845 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24849 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  24853 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  24857 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  24861 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  24865 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  24869 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  24873 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  24877 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  24881 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  24885 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  24889 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  24893 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  24897 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  24899 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  24903 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  24907 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  24910 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  24915 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  24919 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  24923 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  24925 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  24929 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24933 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  24937 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  24941 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24945 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  24949 */     // MIs[7] src0
     /*  24949 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24954 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  24958 */     // MIs[6] Operand 2
     /*  24958 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  24969 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  24973 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  24977 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  24981 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  24985 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  24989 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  24993 */     // MIs[9] src1
     /*  24993 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  24998 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25002 */     // MIs[8] Operand 2
     /*  25002 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25013 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25017 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25021 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25025 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25029 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25031 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25035 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25039 */     GIM_CheckNumOperands, /*MI*/11, /*Expected*/4,
     /*  25042 */     GIM_CheckIntrinsicID, /*MI*/11, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25047 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25051 */     GIM_CheckType, /*MI*/11, /*Op*/3, /*Type*/GILLT_s32,
     /*  25055 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25057 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  25061 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25065 */     GIM_CheckType, /*MI*/12, /*Op*/1, /*Type*/GILLT_s32,
     /*  25069 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/1, // MIs[13]
     /*  25073 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25077 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  25081 */     // MIs[13] src0
     /*  25081 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25086 */     GIM_CheckConstantInt8, /*MI*/13, /*Op*/2, 8,
     /*  25090 */     // MIs[12] Operand 2
     /*  25090 */     GIM_CheckLiteralInt, /*MI*/12, /*Op*/2, GIMT_Encode8(8),
     /*  25101 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/11, /*OpIdx*/3, // MIs[14]
     /*  25105 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25109 */     GIM_CheckType, /*MI*/14, /*Op*/1, /*Type*/GILLT_s32,
     /*  25113 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/1, // MIs[15]
     /*  25117 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25121 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25125 */     // MIs[15] src1
     /*  25125 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25130 */     GIM_CheckConstantInt8, /*MI*/15, /*Op*/2, 8,
     /*  25134 */     // MIs[14] Operand 2
     /*  25134 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25145 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/10, /*OpIdx*/2, // MIs[16]
     /*  25149 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25153 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25157 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  25161 */     GIM_CheckHasOneUse, /*MI*/16,
     /*  25163 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/2, // MIs[17]
     /*  25167 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25171 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  25174 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25179 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25183 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  25187 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  25189 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  25193 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25197 */     // MIs[18] src0
     /*  25197 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25202 */     // MIs[18] Operand 2
     /*  25202 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25213 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  25217 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25221 */     // MIs[19] src1
     /*  25221 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25226 */     // MIs[19] Operand 2
     /*  25226 */     GIM_CheckLiteralInt, /*MI*/19, /*Op*/2, GIMT_Encode8(8),
     /*  25237 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25239 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25239 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25242 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25244 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25247 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25251 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25254 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/16, /*OpIdx*/1, // src2
     /*  25265 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25268 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25271 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25274 */     GIR_RootConstrainSelectedInstOperands,
     /*  25275 */     // GIR_Coverage, 10658,
     /*  25275 */     GIR_EraseRootFromParent_Done,
     /*  25276 */   // Label 219: @25276
     /*  25276 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(25751), // Rule ID 10657 //
     /*  25281 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25284 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25286 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25290 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25294 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25298 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25301 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25306 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25310 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25314 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25316 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25320 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25324 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25328 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25332 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25336 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25340 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25344 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25348 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25352 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25356 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25360 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25364 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25368 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25372 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25374 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25378 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25382 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25385 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25390 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25394 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25398 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25400 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25404 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25408 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25412 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25416 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25420 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25424 */     // MIs[7] src0
     /*  25424 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25429 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25433 */     // MIs[6] Operand 2
     /*  25433 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25444 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25448 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25452 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25456 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25460 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25464 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25468 */     // MIs[9] src1
     /*  25468 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25473 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25477 */     // MIs[8] Operand 2
     /*  25477 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25488 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25492 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25496 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25500 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25504 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25506 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25510 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25514 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  25518 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25522 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25524 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  25528 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25532 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  25535 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25540 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  25544 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  25548 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  25550 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  25554 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25558 */     // MIs[13] src0
     /*  25558 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25563 */     // MIs[13] Operand 2
     /*  25563 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  25574 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  25578 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25582 */     // MIs[14] src1
     /*  25582 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25587 */     // MIs[14] Operand 2
     /*  25587 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  25598 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  25602 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25606 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  25609 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25614 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  25618 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  25622 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  25624 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  25628 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25632 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  25636 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  25640 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25644 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  25648 */     // MIs[17] src0
     /*  25648 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25653 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  25657 */     // MIs[16] Operand 2
     /*  25657 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  25668 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  25672 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25676 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  25680 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  25684 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25688 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  25692 */     // MIs[19] src1
     /*  25692 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25697 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  25701 */     // MIs[18] Operand 2
     /*  25701 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  25712 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  25714 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  25714 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  25717 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  25719 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  25726 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25729 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  25733 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  25736 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  25740 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25746 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  25749 */     GIR_RootConstrainSelectedInstOperands,
     /*  25750 */     // GIR_Coverage, 10657,
     /*  25750 */     GIR_EraseRootFromParent_Done,
     /*  25751 */   // Label 220: @25751
     /*  25751 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(26226), // Rule ID 10656 //
     /*  25756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  25759 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  25761 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  25765 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25769 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25773 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  25776 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25781 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  25785 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  25789 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  25791 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25795 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25799 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  25803 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  25807 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  25811 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  25815 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  25819 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  25823 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  25827 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  25831 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  25835 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25839 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  25843 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  25847 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  25849 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  25853 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  25857 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  25860 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  25865 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  25869 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  25873 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  25875 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  25879 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25883 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  25887 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  25891 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25895 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  25899 */     // MIs[7] src0
     /*  25899 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25904 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  25908 */     // MIs[6] Operand 2
     /*  25908 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  25919 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/5, /*OpIdx*/3, // MIs[8]
     /*  25923 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  25927 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  25931 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  25935 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  25939 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  25943 */     // MIs[9] src1
     /*  25943 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25948 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 16,
     /*  25952 */     // MIs[8] Operand 2
     /*  25952 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  25963 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/4, /*OpIdx*/2, // MIs[10]
     /*  25967 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25971 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  25975 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  25979 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  25981 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  25985 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  25989 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  25993 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  25997 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  25999 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  26003 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26007 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26010 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26015 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26019 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26023 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26025 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26029 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26033 */     // MIs[13] src0
     /*  26033 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26038 */     // MIs[13] Operand 2
     /*  26038 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26049 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26053 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26057 */     // MIs[14] src1
     /*  26057 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26062 */     // MIs[14] Operand 2
     /*  26062 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26073 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/10, /*OpIdx*/2, // MIs[15]
     /*  26077 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26081 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26084 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26089 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26093 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26097 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26099 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26103 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26107 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26111 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26115 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26119 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26123 */     // MIs[17] src0
     /*  26123 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26128 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 8,
     /*  26132 */     // MIs[16] Operand 2
     /*  26132 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26143 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26147 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26151 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26155 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26159 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26163 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26167 */     // MIs[19] src1
     /*  26167 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26172 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 8,
     /*  26176 */     // MIs[18] Operand 2
     /*  26176 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26187 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26189 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26189 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26192 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26197 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26201 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26208 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  26215 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26218 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26221 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26224 */     GIR_RootConstrainSelectedInstOperands,
     /*  26225 */     // GIR_Coverage, 10656,
     /*  26225 */     GIR_EraseRootFromParent_Done,
     /*  26226 */   // Label 221: @26226
     /*  26226 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(26701), // Rule ID 10655 //
     /*  26231 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26234 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26236 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26240 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26244 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26248 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26251 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26256 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26260 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26264 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26266 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26270 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26274 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26278 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26282 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26286 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26290 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26294 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26298 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26302 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26306 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26310 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26314 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26318 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26322 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26324 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26328 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26332 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  26336 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26340 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26342 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26346 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26350 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  26353 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26358 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  26362 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  26366 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  26368 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  26372 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26376 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  26380 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  26384 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26388 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  26392 */     // MIs[8] src0
     /*  26392 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26397 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  26401 */     // MIs[7] Operand 2
     /*  26401 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  26412 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  26416 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26420 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  26424 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  26428 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26432 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26436 */     // MIs[10] src1
     /*  26436 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26441 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  26445 */     // MIs[9] Operand 2
     /*  26445 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  26456 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  26460 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26464 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26468 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26472 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26474 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  26478 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26482 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26485 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26490 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26494 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26498 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26500 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26504 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26508 */     // MIs[13] src0
     /*  26508 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26513 */     // MIs[13] Operand 2
     /*  26513 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26524 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  26528 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26532 */     // MIs[14] src1
     /*  26532 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26537 */     // MIs[14] Operand 2
     /*  26537 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  26548 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  26552 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26556 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  26559 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26564 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  26568 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  26572 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  26574 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  26578 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26582 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  26586 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  26590 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26594 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  26598 */     // MIs[17] src0
     /*  26598 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26603 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  26607 */     // MIs[16] Operand 2
     /*  26607 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  26618 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  26622 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26626 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  26630 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  26634 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26638 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  26642 */     // MIs[19] src1
     /*  26642 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26647 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  26651 */     // MIs[18] Operand 2
     /*  26651 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  26662 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  26664 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  26664 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  26667 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  26669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26672 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  26676 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26679 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  26683 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  26686 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/2, // src2
     /*  26690 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26693 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26696 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  26699 */     GIR_RootConstrainSelectedInstOperands,
     /*  26700 */     // GIR_Coverage, 10655,
     /*  26700 */     GIR_EraseRootFromParent_Done,
     /*  26701 */   // Label 222: @26701
     /*  26701 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(27176), // Rule ID 10654 //
     /*  26706 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  26709 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  26711 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  26715 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26719 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26723 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  26726 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26731 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  26735 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  26739 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  26741 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  26745 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26749 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  26753 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  26757 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  26761 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  26765 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  26769 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  26773 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  26777 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  26781 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  26785 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26789 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  26793 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  26797 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  26799 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  26803 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26807 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  26811 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  26815 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  26817 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26821 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26825 */     GIM_CheckNumOperands, /*MI*/6, /*Expected*/4,
     /*  26828 */     GIM_CheckIntrinsicID, /*MI*/6, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26833 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  26837 */     GIM_CheckType, /*MI*/6, /*Op*/3, /*Type*/GILLT_s32,
     /*  26841 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  26843 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  26847 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26851 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  26855 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  26859 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26863 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  26867 */     // MIs[8] src0
     /*  26867 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26872 */     GIM_CheckConstantInt8, /*MI*/8, /*Op*/2, 8,
     /*  26876 */     // MIs[7] Operand 2
     /*  26876 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(8),
     /*  26887 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/6, /*OpIdx*/3, // MIs[9]
     /*  26891 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26895 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  26899 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  26903 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  26907 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  26911 */     // MIs[10] src1
     /*  26911 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26916 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  26920 */     // MIs[9] Operand 2
     /*  26920 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  26931 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/5, /*OpIdx*/2, // MIs[11]
     /*  26935 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  26939 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  26943 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  26947 */     GIM_CheckHasOneUse, /*MI*/11,
     /*  26949 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/2, // MIs[12]
     /*  26953 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  26957 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  26960 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  26965 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  26969 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  26973 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  26975 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  26979 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  26983 */     // MIs[13] src0
     /*  26983 */     GIM_CheckIsSameOperand, /*MI*/13, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  26988 */     // MIs[13] Operand 2
     /*  26988 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  26999 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/12, /*OpIdx*/3, // MIs[14]
     /*  27003 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27007 */     // MIs[14] src1
     /*  27007 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27012 */     // MIs[14] Operand 2
     /*  27012 */     GIM_CheckLiteralInt, /*MI*/14, /*Op*/2, GIMT_Encode8(8),
     /*  27023 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27027 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27031 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27034 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27039 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27043 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27047 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27049 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27053 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27057 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27061 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27065 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27069 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27073 */     // MIs[17] src0
     /*  27073 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27078 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27082 */     // MIs[16] Operand 2
     /*  27082 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27093 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27097 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27101 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27105 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27109 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27113 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27117 */     // MIs[19] src1
     /*  27117 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27122 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27126 */     // MIs[18] Operand 2
     /*  27126 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27137 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27139 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27139 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27142 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27144 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27147 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27151 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27154 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27158 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27161 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/11, /*OpIdx*/1, // src2
     /*  27165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27168 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27174 */     GIR_RootConstrainSelectedInstOperands,
     /*  27175 */     // GIR_Coverage, 10654,
     /*  27175 */     GIR_EraseRootFromParent_Done,
     /*  27176 */   // Label 223: @27176
     /*  27176 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(27651), // Rule ID 10653 //
     /*  27181 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27184 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27186 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27198 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27201 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27206 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27210 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27214 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27216 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27220 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27224 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27228 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27232 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27236 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27240 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27244 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27248 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27252 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27256 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27260 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27264 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27268 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27272 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27274 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27278 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27282 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27286 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27290 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27292 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27296 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27300 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  27304 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27308 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27310 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  27314 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27318 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  27321 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27326 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  27330 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  27334 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  27336 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  27340 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27344 */     // MIs[8] src0
     /*  27344 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27349 */     // MIs[8] Operand 2
     /*  27349 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  27360 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  27364 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27368 */     // MIs[9] src1
     /*  27368 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27373 */     // MIs[9] Operand 2
     /*  27373 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27384 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  27388 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27392 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  27395 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27400 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27404 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  27408 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  27410 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  27414 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27418 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27422 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27426 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27430 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27434 */     // MIs[12] src0
     /*  27434 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27439 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  27443 */     // MIs[11] Operand 2
     /*  27443 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  27454 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  27458 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27462 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  27466 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  27470 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27474 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  27478 */     // MIs[14] src1
     /*  27478 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27483 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  27487 */     // MIs[13] Operand 2
     /*  27487 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27498 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27502 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27506 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27509 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27514 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27518 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27522 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27524 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  27528 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27532 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  27536 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  27540 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27544 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  27548 */     // MIs[17] src0
     /*  27548 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27553 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  27557 */     // MIs[16] Operand 2
     /*  27557 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  27568 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  27572 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27576 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  27580 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  27584 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27588 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  27592 */     // MIs[19] src1
     /*  27592 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27597 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  27601 */     // MIs[18] Operand 2
     /*  27601 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  27612 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  27614 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  27614 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  27617 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  27619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  27626 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27629 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  27633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  27636 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/2, // src2
     /*  27640 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27643 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27646 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  27649 */     GIR_RootConstrainSelectedInstOperands,
     /*  27650 */     // GIR_Coverage, 10653,
     /*  27650 */     GIR_EraseRootFromParent_Done,
     /*  27651 */   // Label 224: @27651
     /*  27651 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(28126), // Rule ID 10652 //
     /*  27656 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  27659 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  27661 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  27665 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27669 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27673 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  27676 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27681 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  27685 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  27689 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  27691 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  27695 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27699 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  27703 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  27707 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
     /*  27711 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  27715 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  27719 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  27723 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  27727 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
     /*  27731 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  27735 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27739 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  27743 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  27747 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  27749 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  27753 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27757 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  27761 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  27765 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  27767 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27771 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  27775 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  27779 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  27783 */     GIM_CheckHasOneUse, /*MI*/6,
     /*  27785 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/2, // MIs[7]
     /*  27789 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27793 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  27796 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27801 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  27805 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  27809 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  27811 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  27815 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27819 */     // MIs[8] src0
     /*  27819 */     GIM_CheckIsSameOperand, /*MI*/8, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27824 */     // MIs[8] Operand 2
     /*  27824 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  27835 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/7, /*OpIdx*/3, // MIs[9]
     /*  27839 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27843 */     // MIs[9] src1
     /*  27843 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27848 */     // MIs[9] Operand 2
     /*  27848 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  27859 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/5, /*OpIdx*/2, // MIs[10]
     /*  27863 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27867 */     GIM_CheckNumOperands, /*MI*/10, /*Expected*/4,
     /*  27870 */     GIM_CheckIntrinsicID, /*MI*/10, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27875 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  27879 */     GIM_CheckType, /*MI*/10, /*Op*/3, /*Type*/GILLT_s32,
     /*  27883 */     GIM_CheckHasOneUse, /*MI*/10,
     /*  27885 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/2, // MIs[11]
     /*  27889 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27893 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  27897 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  27901 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27905 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  27909 */     // MIs[12] src0
     /*  27909 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  27914 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  27918 */     // MIs[11] Operand 2
     /*  27918 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  27929 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/10, /*OpIdx*/3, // MIs[13]
     /*  27933 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  27937 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  27941 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  27945 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  27949 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  27953 */     // MIs[14] src1
     /*  27953 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27958 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  27962 */     // MIs[13] Operand 2
     /*  27962 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  27973 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/4, /*OpIdx*/2, // MIs[15]
     /*  27977 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  27981 */     GIM_CheckNumOperands, /*MI*/15, /*Expected*/4,
     /*  27984 */     GIM_CheckIntrinsicID, /*MI*/15, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  27989 */     GIM_CheckType, /*MI*/15, /*Op*/2, /*Type*/GILLT_s32,
     /*  27993 */     GIM_CheckType, /*MI*/15, /*Op*/3, /*Type*/GILLT_s32,
     /*  27997 */     GIM_CheckHasOneUse, /*MI*/15,
     /*  27999 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/2, // MIs[16]
     /*  28003 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28007 */     GIM_CheckType, /*MI*/16, /*Op*/1, /*Type*/GILLT_s32,
     /*  28011 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/16, /*OpIdx*/1, // MIs[17]
     /*  28015 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28019 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28023 */     // MIs[17] src0
     /*  28023 */     GIM_CheckIsSameOperand, /*MI*/17, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  28028 */     GIM_CheckConstantInt8, /*MI*/17, /*Op*/2, 16,
     /*  28032 */     // MIs[16] Operand 2
     /*  28032 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28043 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/15, /*OpIdx*/3, // MIs[18]
     /*  28047 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28051 */     GIM_CheckType, /*MI*/18, /*Op*/1, /*Type*/GILLT_s32,
     /*  28055 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/18, /*OpIdx*/1, // MIs[19]
     /*  28059 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28063 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28067 */     // MIs[19] src1
     /*  28067 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28072 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 16,
     /*  28076 */     // MIs[18] Operand 2
     /*  28076 */     GIM_CheckLiteralInt, /*MI*/18, /*Op*/2, GIMT_Encode8(8),
     /*  28087 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28089 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28089 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28092 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28094 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28097 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  28101 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28104 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  28108 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src2
     /*  28115 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28118 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28124 */     GIR_RootConstrainSelectedInstOperands,
     /*  28125 */     // GIR_Coverage, 10652,
     /*  28125 */     GIR_EraseRootFromParent_Done,
     /*  28126 */   // Label 225: @28126
     /*  28126 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(28601), // Rule ID 10651 //
     /*  28131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28134 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28136 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28148 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  28152 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28156 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28158 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28162 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28166 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28169 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28174 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28178 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  28182 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  28184 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28188 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28192 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28196 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  28200 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28204 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28208 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28212 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  28216 */     // MIs[3] Operand 2
     /*  28216 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  28227 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  28231 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28235 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28239 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28243 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28247 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28251 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28255 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  28259 */     // MIs[5] Operand 2
     /*  28259 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  28270 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  28274 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28278 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  28282 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28286 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28288 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  28292 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28296 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  28299 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28304 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  28308 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  28312 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  28314 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  28318 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28322 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  28326 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  28330 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28334 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28338 */     // MIs[10] src0
     /*  28338 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28343 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  28347 */     // MIs[9] Operand 2
     /*  28347 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28358 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  28362 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28366 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28370 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28374 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28378 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28382 */     // MIs[12] src1
     /*  28382 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28387 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28391 */     // MIs[11] Operand 2
     /*  28391 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28402 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  28406 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28410 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28414 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  28418 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  28420 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  28424 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28428 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  28431 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28436 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28440 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  28444 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  28446 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  28450 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28454 */     // MIs[15] src0
     /*  28454 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28459 */     // MIs[15] Operand 2
     /*  28459 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  28470 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  28474 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28478 */     // MIs[16] src1
     /*  28478 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28483 */     // MIs[16] Operand 2
     /*  28483 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28494 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  28498 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28502 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  28505 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28510 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28514 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  28518 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  28520 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  28524 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28528 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  28532 */     // MIs[18] src0
     /*  28532 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28537 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  28541 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  28545 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  28549 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  28553 */     // MIs[19] src1
     /*  28553 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28558 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  28562 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  28564 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  28564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  28567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  28569 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28572 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  28576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28579 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  28583 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  28586 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/2, // src2
     /*  28590 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28593 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28596 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  28599 */     GIR_RootConstrainSelectedInstOperands,
     /*  28600 */     // GIR_Coverage, 10651,
     /*  28600 */     GIR_EraseRootFromParent_Done,
     /*  28601 */   // Label 226: @28601
     /*  28601 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(29076), // Rule ID 10650 //
     /*  28606 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  28609 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  28611 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  28615 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28619 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28623 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  28627 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  28631 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  28633 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28637 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28641 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  28644 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28649 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  28653 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  28657 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  28659 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  28663 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28667 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  28671 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  28675 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28679 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  28683 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  28687 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  28691 */     // MIs[3] Operand 2
     /*  28691 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  28702 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  28706 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28710 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  28714 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28718 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28722 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  28726 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  28730 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  28734 */     // MIs[5] Operand 2
     /*  28734 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  28745 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  28749 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28753 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  28757 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  28761 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  28763 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  28767 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28771 */     GIM_CheckNumOperands, /*MI*/8, /*Expected*/4,
     /*  28774 */     GIM_CheckIntrinsicID, /*MI*/8, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28779 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  28783 */     GIM_CheckType, /*MI*/8, /*Op*/3, /*Type*/GILLT_s32,
     /*  28787 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  28789 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  28793 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28797 */     GIM_CheckType, /*MI*/9, /*Op*/1, /*Type*/GILLT_s32,
     /*  28801 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/1, // MIs[10]
     /*  28805 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28809 */     GIM_CheckType, /*MI*/10, /*Op*/2, /*Type*/GILLT_s32,
     /*  28813 */     // MIs[10] src0
     /*  28813 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28818 */     GIM_CheckConstantInt8, /*MI*/10, /*Op*/2, 8,
     /*  28822 */     // MIs[9] Operand 2
     /*  28822 */     GIM_CheckLiteralInt, /*MI*/9, /*Op*/2, GIMT_Encode8(8),
     /*  28833 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/8, /*OpIdx*/3, // MIs[11]
     /*  28837 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28841 */     GIM_CheckType, /*MI*/11, /*Op*/1, /*Type*/GILLT_s32,
     /*  28845 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/11, /*OpIdx*/1, // MIs[12]
     /*  28849 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  28853 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  28857 */     // MIs[12] src1
     /*  28857 */     GIM_CheckIsSameOperand, /*MI*/12, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28862 */     GIM_CheckConstantInt8, /*MI*/12, /*Op*/2, 8,
     /*  28866 */     // MIs[11] Operand 2
     /*  28866 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  28877 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/7, /*OpIdx*/2, // MIs[13]
     /*  28881 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  28885 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  28889 */     GIM_CheckType, /*MI*/13, /*Op*/2, /*Type*/GILLT_s32,
     /*  28893 */     GIM_CheckHasOneUse, /*MI*/13,
     /*  28895 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/2, // MIs[14]
     /*  28899 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28903 */     GIM_CheckNumOperands, /*MI*/14, /*Expected*/4,
     /*  28906 */     GIM_CheckIntrinsicID, /*MI*/14, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28911 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  28915 */     GIM_CheckType, /*MI*/14, /*Op*/3, /*Type*/GILLT_s32,
     /*  28919 */     GIM_CheckHasOneUse, /*MI*/14,
     /*  28921 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/14, /*OpIdx*/2, // MIs[15]
     /*  28925 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28929 */     // MIs[15] src0
     /*  28929 */     GIM_CheckIsSameOperand, /*MI*/15, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  28934 */     // MIs[15] Operand 2
     /*  28934 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  28945 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/14, /*OpIdx*/3, // MIs[16]
     /*  28949 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  28953 */     // MIs[16] src1
     /*  28953 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  28958 */     // MIs[16] Operand 2
     /*  28958 */     GIM_CheckLiteralInt, /*MI*/16, /*Op*/2, GIMT_Encode8(8),
     /*  28969 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  28973 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  28977 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  28980 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  28985 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  28989 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  28993 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  28995 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  28999 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29003 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29007 */     // MIs[18] src0
     /*  29007 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29012 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29016 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29020 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29024 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29028 */     // MIs[19] src1
     /*  29028 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29033 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29037 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29039 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29039 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29042 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29044 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29047 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29051 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29054 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  29058 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29061 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/13, /*OpIdx*/1, // src2
     /*  29065 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29068 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29071 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29074 */     GIR_RootConstrainSelectedInstOperands,
     /*  29075 */     // GIR_Coverage, 10650,
     /*  29075 */     GIR_EraseRootFromParent_Done,
     /*  29076 */   // Label 227: @29076
     /*  29076 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(29551), // Rule ID 10649 //
     /*  29081 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29084 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29086 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29090 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29094 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29098 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29102 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29106 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29108 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29112 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29116 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29119 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29124 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29128 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29132 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29134 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29138 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29142 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29146 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29150 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29154 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29158 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29162 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29166 */     // MIs[3] Operand 2
     /*  29166 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29177 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29181 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29185 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29189 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29193 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29197 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29201 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29205 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29209 */     // MIs[5] Operand 2
     /*  29209 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29220 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29224 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29228 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29232 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29236 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29238 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29242 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29246 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  29250 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29254 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29256 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  29260 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29264 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  29267 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29272 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  29276 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  29280 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  29282 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  29286 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29290 */     // MIs[10] src0
     /*  29290 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29295 */     // MIs[10] Operand 2
     /*  29295 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  29306 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  29310 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29314 */     // MIs[11] src1
     /*  29314 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29319 */     // MIs[11] Operand 2
     /*  29319 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29330 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  29334 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29338 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  29341 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29346 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29350 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  29354 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  29356 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  29360 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29364 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29368 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29372 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29376 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29380 */     // MIs[14] src0
     /*  29380 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29385 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  29389 */     // MIs[13] Operand 2
     /*  29389 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  29400 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  29404 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29408 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  29412 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  29416 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29420 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  29424 */     // MIs[16] src1
     /*  29424 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29429 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  29433 */     // MIs[15] Operand 2
     /*  29433 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29444 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29448 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29452 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29455 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29460 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29464 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29468 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29470 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29474 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29478 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29482 */     // MIs[18] src0
     /*  29482 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29487 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29491 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29495 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29499 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29503 */     // MIs[19] src1
     /*  29503 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29508 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29512 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29514 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29514 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29517 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29519 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  29526 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29529 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  29533 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29536 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  29540 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29543 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  29549 */     GIR_RootConstrainSelectedInstOperands,
     /*  29550 */     // GIR_Coverage, 10649,
     /*  29550 */     GIR_EraseRootFromParent_Done,
     /*  29551 */   // Label 228: @29551
     /*  29551 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(30026), // Rule ID 10648 //
     /*  29556 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  29559 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  29561 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  29565 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29569 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29573 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  29577 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  29581 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  29583 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29587 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29591 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  29594 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29599 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  29603 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  29607 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  29609 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  29613 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29617 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  29621 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  29625 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29629 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  29633 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  29637 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  29641 */     // MIs[3] Operand 2
     /*  29641 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(8),
     /*  29652 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/2, /*OpIdx*/3, // MIs[5]
     /*  29656 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29660 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  29664 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29668 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29672 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  29676 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  29680 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  29684 */     // MIs[5] Operand 2
     /*  29684 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  29695 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/1, /*OpIdx*/2, // MIs[7]
     /*  29699 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29703 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  29707 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  29711 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  29713 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/1, // MIs[8]
     /*  29717 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  29721 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  29725 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  29729 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  29731 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  29735 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29739 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  29742 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29747 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  29751 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  29755 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  29757 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  29761 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29765 */     // MIs[10] src0
     /*  29765 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29770 */     // MIs[10] Operand 2
     /*  29770 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  29781 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  29785 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29789 */     // MIs[11] src1
     /*  29789 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29794 */     // MIs[11] Operand 2
     /*  29794 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  29805 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/7, /*OpIdx*/2, // MIs[12]
     /*  29809 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29813 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  29816 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29821 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  29825 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  29829 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  29831 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  29835 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29839 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  29843 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  29847 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29851 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  29855 */     // MIs[14] src0
     /*  29855 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29860 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 8,
     /*  29864 */     // MIs[13] Operand 2
     /*  29864 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  29875 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  29879 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  29883 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  29887 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  29891 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  29895 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  29899 */     // MIs[16] src1
     /*  29899 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29904 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 8,
     /*  29908 */     // MIs[15] Operand 2
     /*  29908 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  29919 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  29923 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  29927 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  29930 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  29935 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  29939 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  29943 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  29945 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  29949 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29953 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  29957 */     // MIs[18] src0
     /*  29957 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  29962 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  29966 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  29970 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  29974 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  29978 */     // MIs[19] src1
     /*  29978 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  29983 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  29987 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  29989 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  29989 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  29992 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  29994 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  29997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src0
     /*  30001 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  30008 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30011 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  30015 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30018 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30021 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30024 */     GIR_RootConstrainSelectedInstOperands,
     /*  30025 */     // GIR_Coverage, 10648,
     /*  30025 */     GIR_EraseRootFromParent_Done,
     /*  30026 */   // Label 229: @30026
     /*  30026 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(30501), // Rule ID 10647 //
     /*  30031 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30034 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30036 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30040 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30044 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30048 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30052 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30056 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30058 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30062 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30066 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  30070 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30074 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30076 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30080 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30084 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  30087 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30092 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  30096 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  30100 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  30102 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  30106 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30110 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30114 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  30118 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30122 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30126 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  30130 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  30134 */     // MIs[4] Operand 2
     /*  30134 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  30145 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  30149 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30153 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30157 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  30161 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30165 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30169 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30173 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  30177 */     // MIs[6] Operand 2
     /*  30177 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  30188 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  30192 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30196 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30200 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30204 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30206 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  30210 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30214 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30217 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30222 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30226 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30230 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30232 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30236 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30240 */     // MIs[10] src0
     /*  30240 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30245 */     // MIs[10] Operand 2
     /*  30245 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30256 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30260 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30264 */     // MIs[11] src1
     /*  30264 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30269 */     // MIs[11] Operand 2
     /*  30269 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30280 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  30284 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30288 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30291 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30296 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30300 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30304 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30306 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30310 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30314 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30318 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30322 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30326 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30330 */     // MIs[14] src0
     /*  30330 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30335 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  30339 */     // MIs[13] Operand 2
     /*  30339 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30350 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30354 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30358 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30362 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30366 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30370 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30374 */     // MIs[16] src1
     /*  30374 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30379 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  30383 */     // MIs[15] Operand 2
     /*  30383 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30394 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30398 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30402 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30405 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30410 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30414 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30418 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30420 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30424 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30428 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30432 */     // MIs[18] src0
     /*  30432 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30437 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30441 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30445 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30449 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30453 */     // MIs[19] src1
     /*  30453 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30458 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30462 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30464 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30464 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30467 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30469 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30472 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  30476 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30479 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  30483 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/2, // src2
     /*  30490 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30493 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30496 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30499 */     GIR_RootConstrainSelectedInstOperands,
     /*  30500 */     // GIR_Coverage, 10647,
     /*  30500 */     GIR_EraseRootFromParent_Done,
     /*  30501 */   // Label 230: @30501
     /*  30501 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(30976), // Rule ID 10646 //
     /*  30506 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30509 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30511 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30515 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30519 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30523 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  30527 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  30531 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  30533 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30537 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30541 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  30545 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  30549 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  30551 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30555 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30559 */     GIM_CheckNumOperands, /*MI*/3, /*Expected*/4,
     /*  30562 */     GIM_CheckIntrinsicID, /*MI*/3, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30567 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  30571 */     GIM_CheckType, /*MI*/3, /*Op*/3, /*Type*/GILLT_s32,
     /*  30575 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  30577 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  30581 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30585 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  30589 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  30593 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30597 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  30601 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  30605 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 8,
     /*  30609 */     // MIs[4] Operand 2
     /*  30609 */     GIM_CheckLiteralInt, /*MI*/4, /*Op*/2, GIMT_Encode8(8),
     /*  30620 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/3, // MIs[6]
     /*  30624 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30628 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  30632 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/6, /*OpIdx*/1, // MIs[7]
     /*  30636 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30640 */     GIM_CheckType, /*MI*/7, /*Op*/1, /*Type*/GILLT_s32,
     /*  30644 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  30648 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 8,
     /*  30652 */     // MIs[6] Operand 2
     /*  30652 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  30663 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/2, /*OpIdx*/2, // MIs[8]
     /*  30667 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30671 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  30675 */     GIM_CheckType, /*MI*/8, /*Op*/2, /*Type*/GILLT_s32,
     /*  30679 */     GIM_CheckHasOneUse, /*MI*/8,
     /*  30681 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/2, // MIs[9]
     /*  30685 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30689 */     GIM_CheckNumOperands, /*MI*/9, /*Expected*/4,
     /*  30692 */     GIM_CheckIntrinsicID, /*MI*/9, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30697 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  30701 */     GIM_CheckType, /*MI*/9, /*Op*/3, /*Type*/GILLT_s32,
     /*  30705 */     GIM_CheckHasOneUse, /*MI*/9,
     /*  30707 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/9, /*OpIdx*/2, // MIs[10]
     /*  30711 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30715 */     // MIs[10] src0
     /*  30715 */     GIM_CheckIsSameOperand, /*MI*/10, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30720 */     // MIs[10] Operand 2
     /*  30720 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  30731 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/9, /*OpIdx*/3, // MIs[11]
     /*  30735 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30739 */     // MIs[11] src1
     /*  30739 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30744 */     // MIs[11] Operand 2
     /*  30744 */     GIM_CheckLiteralInt, /*MI*/11, /*Op*/2, GIMT_Encode8(8),
     /*  30755 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  30759 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30763 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  30766 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30771 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  30775 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  30779 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  30781 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  30785 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30789 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  30793 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  30797 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30801 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  30805 */     // MIs[14] src0
     /*  30805 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30810 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  30814 */     // MIs[13] Operand 2
     /*  30814 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  30825 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  30829 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  30833 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  30837 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  30841 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  30845 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  30849 */     // MIs[16] src1
     /*  30849 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30854 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  30858 */     // MIs[15] Operand 2
     /*  30858 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  30869 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  30873 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  30877 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  30880 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  30885 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  30889 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  30893 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  30895 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  30899 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30903 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  30907 */     // MIs[18] src0
     /*  30907 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  30912 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  30916 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  30920 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  30924 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  30928 */     // MIs[19] src1
     /*  30928 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/7, /*OtherOpIdx*/1,
     /*  30933 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  30937 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  30939 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  30939 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  30942 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  30944 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30947 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  30951 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30954 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/7, /*OpIdx*/1, // src1
     /*  30958 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  30961 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/8, /*OpIdx*/1, // src2
     /*  30965 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30968 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30971 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  30974 */     GIR_RootConstrainSelectedInstOperands,
     /*  30975 */     // GIR_Coverage, 10646,
     /*  30975 */     GIR_EraseRootFromParent_Done,
     /*  30976 */   // Label 231: @30976
     /*  30976 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(31451), // Rule ID 10645 //
     /*  30981 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  30984 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  30986 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  30990 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30994 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  30998 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31002 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31006 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31008 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31012 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31016 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31020 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31024 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31026 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31030 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31034 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  31038 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31042 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31044 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  31048 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31052 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  31055 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31060 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  31064 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  31068 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  31070 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  31074 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31078 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31082 */     // MIs[5] Operand 2
     /*  31082 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  31093 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  31097 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31101 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31105 */     // MIs[6] Operand 2
     /*  31105 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31116 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  31120 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31124 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  31127 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31132 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31136 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  31140 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  31142 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  31146 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31150 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31154 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  31158 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31162 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31166 */     // MIs[9] src0
     /*  31166 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31171 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  31175 */     // MIs[8] Operand 2
     /*  31175 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  31186 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  31190 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31194 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  31198 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  31202 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31206 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  31210 */     // MIs[11] src1
     /*  31210 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31215 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  31219 */     // MIs[10] Operand 2
     /*  31219 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31230 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31234 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31238 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31241 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31246 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31250 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31254 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31256 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31260 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31264 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31268 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31272 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31276 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31280 */     // MIs[14] src0
     /*  31280 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31285 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31289 */     // MIs[13] Operand 2
     /*  31289 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31300 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31304 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31308 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31312 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31316 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31320 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31324 */     // MIs[16] src1
     /*  31324 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31329 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31333 */     // MIs[15] Operand 2
     /*  31333 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31344 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31348 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31352 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31355 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31360 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31364 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31368 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31370 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31374 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31378 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31382 */     // MIs[18] src0
     /*  31382 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31387 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31391 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31395 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31399 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31403 */     // MIs[19] src1
     /*  31403 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31408 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31412 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31414 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31414 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31417 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31419 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31422 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31426 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31429 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  31433 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31436 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  31440 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31443 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31446 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31449 */     GIR_RootConstrainSelectedInstOperands,
     /*  31450 */     // GIR_Coverage, 10645,
     /*  31450 */     GIR_EraseRootFromParent_Done,
     /*  31451 */   // Label 232: @31451
     /*  31451 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(31926), // Rule ID 2926 //
     /*  31456 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot1Insts),
     /*  31459 */     GIM_CheckHasOneUse, /*MI*/0,
     /*  31461 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31465 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31469 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31473 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  31477 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31481 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31483 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31487 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31491 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31495 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31499 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  31501 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31505 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  31509 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  31513 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  31517 */     GIM_CheckHasOneUse, /*MI*/3,
     /*  31519 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
     /*  31523 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31527 */     GIM_CheckNumOperands, /*MI*/4, /*Expected*/4,
     /*  31530 */     GIM_CheckIntrinsicID, /*MI*/4, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31535 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  31539 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  31543 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  31545 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  31549 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31553 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  31557 */     // MIs[5] Operand 2
     /*  31557 */     GIM_CheckLiteralInt, /*MI*/5, /*Op*/2, GIMT_Encode8(8),
     /*  31568 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/4, /*OpIdx*/3, // MIs[6]
     /*  31572 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31576 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  31580 */     // MIs[6] Operand 2
     /*  31580 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(8),
     /*  31591 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/2, /*OpIdx*/2, // MIs[7]
     /*  31595 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31599 */     GIM_CheckNumOperands, /*MI*/7, /*Expected*/4,
     /*  31602 */     GIM_CheckIntrinsicID, /*MI*/7, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31607 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  31611 */     GIM_CheckType, /*MI*/7, /*Op*/3, /*Type*/GILLT_s32,
     /*  31615 */     GIM_CheckHasOneUse, /*MI*/7,
     /*  31617 */     GIM_RecordInsn, /*DefineMI*/8, /*MI*/7, /*OpIdx*/2, // MIs[8]
     /*  31621 */     GIM_CheckOpcode, /*MI*/8, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31625 */     GIM_CheckType, /*MI*/8, /*Op*/1, /*Type*/GILLT_s32,
     /*  31629 */     GIM_RecordInsn, /*DefineMI*/9, /*MI*/8, /*OpIdx*/1, // MIs[9]
     /*  31633 */     GIM_CheckOpcode, /*MI*/9, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31637 */     GIM_CheckType, /*MI*/9, /*Op*/2, /*Type*/GILLT_s32,
     /*  31641 */     // MIs[9] src0
     /*  31641 */     GIM_CheckIsSameOperand, /*MI*/9, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31646 */     GIM_CheckConstantInt8, /*MI*/9, /*Op*/2, 8,
     /*  31650 */     // MIs[8] Operand 2
     /*  31650 */     GIM_CheckLiteralInt, /*MI*/8, /*Op*/2, GIMT_Encode8(8),
     /*  31661 */     GIM_RecordInsn, /*DefineMI*/10, /*MI*/7, /*OpIdx*/3, // MIs[10]
     /*  31665 */     GIM_CheckOpcode, /*MI*/10, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31669 */     GIM_CheckType, /*MI*/10, /*Op*/1, /*Type*/GILLT_s32,
     /*  31673 */     GIM_RecordInsn, /*DefineMI*/11, /*MI*/10, /*OpIdx*/1, // MIs[11]
     /*  31677 */     GIM_CheckOpcode, /*MI*/11, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31681 */     GIM_CheckType, /*MI*/11, /*Op*/2, /*Type*/GILLT_s32,
     /*  31685 */     // MIs[11] src1
     /*  31685 */     GIM_CheckIsSameOperand, /*MI*/11, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31690 */     GIM_CheckConstantInt8, /*MI*/11, /*Op*/2, 8,
     /*  31694 */     // MIs[10] Operand 2
     /*  31694 */     GIM_CheckLiteralInt, /*MI*/10, /*Op*/2, GIMT_Encode8(8),
     /*  31705 */     GIM_RecordInsn, /*DefineMI*/12, /*MI*/1, /*OpIdx*/2, // MIs[12]
     /*  31709 */     GIM_CheckOpcode, /*MI*/12, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31713 */     GIM_CheckNumOperands, /*MI*/12, /*Expected*/4,
     /*  31716 */     GIM_CheckIntrinsicID, /*MI*/12, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31721 */     GIM_CheckType, /*MI*/12, /*Op*/2, /*Type*/GILLT_s32,
     /*  31725 */     GIM_CheckType, /*MI*/12, /*Op*/3, /*Type*/GILLT_s32,
     /*  31729 */     GIM_CheckHasOneUse, /*MI*/12,
     /*  31731 */     GIM_RecordInsn, /*DefineMI*/13, /*MI*/12, /*OpIdx*/2, // MIs[13]
     /*  31735 */     GIM_CheckOpcode, /*MI*/13, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31739 */     GIM_CheckType, /*MI*/13, /*Op*/1, /*Type*/GILLT_s32,
     /*  31743 */     GIM_RecordInsn, /*DefineMI*/14, /*MI*/13, /*OpIdx*/1, // MIs[14]
     /*  31747 */     GIM_CheckOpcode, /*MI*/14, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31751 */     GIM_CheckType, /*MI*/14, /*Op*/2, /*Type*/GILLT_s32,
     /*  31755 */     // MIs[14] src0
     /*  31755 */     GIM_CheckIsSameOperand, /*MI*/14, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31760 */     GIM_CheckConstantInt8, /*MI*/14, /*Op*/2, 16,
     /*  31764 */     // MIs[13] Operand 2
     /*  31764 */     GIM_CheckLiteralInt, /*MI*/13, /*Op*/2, GIMT_Encode8(8),
     /*  31775 */     GIM_RecordInsn, /*DefineMI*/15, /*MI*/12, /*OpIdx*/3, // MIs[15]
     /*  31779 */     GIM_CheckOpcode, /*MI*/15, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  31783 */     GIM_CheckType, /*MI*/15, /*Op*/1, /*Type*/GILLT_s32,
     /*  31787 */     GIM_RecordInsn, /*DefineMI*/16, /*MI*/15, /*OpIdx*/1, // MIs[16]
     /*  31791 */     GIM_CheckOpcode, /*MI*/16, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  31795 */     GIM_CheckType, /*MI*/16, /*Op*/2, /*Type*/GILLT_s32,
     /*  31799 */     // MIs[16] src1
     /*  31799 */     GIM_CheckIsSameOperand, /*MI*/16, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31804 */     GIM_CheckConstantInt8, /*MI*/16, /*Op*/2, 16,
     /*  31808 */     // MIs[15] Operand 2
     /*  31808 */     GIM_CheckLiteralInt, /*MI*/15, /*Op*/2, GIMT_Encode8(8),
     /*  31819 */     GIM_RecordInsn, /*DefineMI*/17, /*MI*/0, /*OpIdx*/2, // MIs[17]
     /*  31823 */     GIM_CheckOpcode, /*MI*/17, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31827 */     GIM_CheckNumOperands, /*MI*/17, /*Expected*/4,
     /*  31830 */     GIM_CheckIntrinsicID, /*MI*/17, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  31835 */     GIM_CheckType, /*MI*/17, /*Op*/2, /*Type*/GILLT_s32,
     /*  31839 */     GIM_CheckType, /*MI*/17, /*Op*/3, /*Type*/GILLT_s32,
     /*  31843 */     GIM_CheckHasOneUse, /*MI*/17,
     /*  31845 */     GIM_RecordInsn, /*DefineMI*/18, /*MI*/17, /*OpIdx*/2, // MIs[18]
     /*  31849 */     GIM_CheckOpcode, /*MI*/18, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31853 */     GIM_CheckType, /*MI*/18, /*Op*/2, /*Type*/GILLT_s32,
     /*  31857 */     // MIs[18] src0
     /*  31857 */     GIM_CheckIsSameOperand, /*MI*/18, /*OpIdx*/1, /*OtherMI*/5, /*OtherOpIdx*/1,
     /*  31862 */     GIM_CheckConstantInt8, /*MI*/18, /*Op*/2, 24,
     /*  31866 */     GIM_RecordInsn, /*DefineMI*/19, /*MI*/17, /*OpIdx*/3, // MIs[19]
     /*  31870 */     GIM_CheckOpcode, /*MI*/19, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  31874 */     GIM_CheckType, /*MI*/19, /*Op*/2, /*Type*/GILLT_s32,
     /*  31878 */     // MIs[19] src1
     /*  31878 */     GIM_CheckIsSameOperand, /*MI*/19, /*OpIdx*/1, /*OtherMI*/6, /*OtherOpIdx*/1,
     /*  31883 */     GIM_CheckConstantInt8, /*MI*/19, /*Op*/2, 24,
     /*  31887 */     GIM_CheckIsSafeToFold, /*NumInsns*/19,
     /*  31889 */     // (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 8:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 8:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), i8:{ *:[Other] }), (sext_inreg:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }), i8:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 24:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 24:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>  =>  (V_DOT4_I32_I8:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  31889 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT4_I32_I8),
     /*  31892 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  31894 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31897 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  31901 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31904 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  31908 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  31911 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
     /*  31915 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31918 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31921 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  31924 */     GIR_RootConstrainSelectedInstOperands,
     /*  31925 */     // GIR_Coverage, 2926,
     /*  31925 */     GIR_EraseRootFromParent_Done,
     /*  31926 */   // Label 233: @31926
     /*  31926 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(32149), // Rule ID 9302 //
     /*  31931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  31934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  31938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  31946 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  31949 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  31954 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  31958 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  31962 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  31964 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  31968 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31972 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  31976 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  31980 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  31991 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  31995 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31999 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32003 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32007 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  32018 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  32022 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32026 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32030 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32034 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32036 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  32040 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32044 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32047 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32052 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32056 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32060 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32062 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32066 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32070 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32074 */     // MIs[6] src0
     /*  32074 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  32079 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  32083 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32087 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32091 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32095 */     // MIs[7] src1
     /*  32095 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32100 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  32104 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32106 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32111 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32114 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  32118 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32121 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  32125 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32128 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  32132 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32135 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32144 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32147 */     GIR_RootConstrainSelectedInstOperands,
     /*  32148 */     // GIR_Coverage, 9302,
     /*  32148 */     GIR_EraseRootFromParent_Done,
     /*  32149 */   // Label 234: @32149
     /*  32149 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(32372), // Rule ID 9303 //
     /*  32154 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32157 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32161 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32165 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32169 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32172 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32177 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32181 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32185 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32187 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32191 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32195 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32199 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32203 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
     /*  32214 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32218 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32222 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32226 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32230 */     GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
     /*  32241 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  32245 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32249 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32253 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32257 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32259 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  32263 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32267 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32270 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32275 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32279 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32283 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32285 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32289 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32293 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32297 */     // MIs[6] src0
     /*  32297 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  32302 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  32306 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32310 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32314 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32318 */     // MIs[7] src1
     /*  32318 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32323 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  32327 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32329 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32329 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32332 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32334 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32337 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  32341 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  32348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32351 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  32355 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32358 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32361 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32364 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32367 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32370 */     GIR_RootConstrainSelectedInstOperands,
     /*  32371 */     // GIR_Coverage, 9303,
     /*  32371 */     GIR_EraseRootFromParent_Done,
     /*  32372 */   // Label 235: @32372
     /*  32372 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(32595), // Rule ID 2902 //
     /*  32377 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32392 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32396 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32400 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32402 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32406 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32410 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32413 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32418 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32422 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  32426 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32428 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  32432 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32436 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32440 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32444 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  32448 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  32452 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32456 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32460 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32464 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  32468 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32472 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32476 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32479 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32484 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32488 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32492 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32494 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32498 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32502 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32506 */     // MIs[6] src0
     /*  32506 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32511 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  32522 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32526 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32530 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32534 */     // MIs[7] src1
     /*  32534 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  32539 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  32550 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32552 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32552 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32555 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32557 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  32564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32567 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  32571 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32574 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  32578 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32581 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32584 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32587 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32590 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32593 */     GIR_RootConstrainSelectedInstOperands,
     /*  32594 */     // GIR_Coverage, 2902,
     /*  32594 */     GIR_EraseRootFromParent_Done,
     /*  32595 */   // Label 236: @32595
     /*  32595 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(32818), // Rule ID 9301 //
     /*  32600 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32603 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32607 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32611 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32615 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  32619 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32623 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32625 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32629 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32633 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  32636 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32641 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  32645 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  32649 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  32651 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  32655 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32659 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32663 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  32667 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  32671 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  32675 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  32679 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32683 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32687 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  32691 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32695 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32699 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32702 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  32707 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32711 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32715 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32717 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32721 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32725 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32729 */     // MIs[6] src0
     /*  32729 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32734 */     GIM_CheckConstantInt, /*MI*/6, /*Op*/2, GIMT_Encode8(65535),
     /*  32745 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32749 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32753 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32757 */     // MIs[7] src1
     /*  32757 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  32762 */     GIM_CheckConstantInt, /*MI*/7, /*Op*/2, GIMT_Encode8(65535),
     /*  32773 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32775 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (srl:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (srl:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, (and:{ *:[i32] } i32:{ *:[i32] }:$src0, 65535:{ *:[i32] }), (and:{ *:[i32] } i32:{ *:[i32] }:$src1, 65535:{ *:[i32] }))<<P:Predicate_AMDGPUmul_u24_oneuse>>)  =>  (V_DOT2_U32_U16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32775 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_U32_U16),
     /*  32778 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32780 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32783 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  32787 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32790 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  32794 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32797 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  32801 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32804 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32807 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32810 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32813 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  32816 */     GIR_RootConstrainSelectedInstOperands,
     /*  32817 */     // GIR_Coverage, 9301,
     /*  32817 */     GIR_EraseRootFromParent_Done,
     /*  32818 */   // Label 237: @32818
     /*  32818 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(33033), // Rule ID 9334 //
     /*  32823 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  32826 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  32830 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32834 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32838 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  32841 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32846 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  32850 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  32854 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  32856 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  32860 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32864 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  32868 */     // MIs[2] Operand 2
     /*  32868 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  32879 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  32883 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  32887 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  32891 */     // MIs[3] Operand 2
     /*  32891 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  32902 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  32906 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  32910 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  32914 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  32918 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  32920 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  32924 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  32928 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  32931 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  32936 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  32940 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  32944 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  32946 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32950 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32954 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  32958 */     // MIs[6] src0
     /*  32958 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  32963 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  32967 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  32971 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  32975 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  32979 */     // MIs[7] src1
     /*  32979 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32984 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  32988 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  32990 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  32990 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  32993 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  32995 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  32998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33002 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33005 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33009 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33012 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/2, // src2
     /*  33016 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33019 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33022 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33025 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33031 */     GIR_RootConstrainSelectedInstOperands,
     /*  33032 */     // GIR_Coverage, 9334,
     /*  33032 */     GIR_EraseRootFromParent_Done,
     /*  33033 */   // Label 238: @33033
     /*  33033 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(33248), // Rule ID 9335 //
     /*  33038 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33041 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33045 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33049 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33053 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  33056 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33061 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33065 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33069 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33071 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33075 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33079 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  33083 */     // MIs[2] Operand 2
     /*  33083 */     GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
     /*  33094 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/3, // MIs[3]
     /*  33098 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33102 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33106 */     // MIs[3] Operand 2
     /*  33106 */     GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
     /*  33117 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  33121 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33125 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33129 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33133 */     GIM_CheckHasOneUse, /*MI*/4,
     /*  33135 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  33139 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33143 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33146 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33151 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33155 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33159 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33161 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33165 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33169 */     GIM_CheckType, /*MI*/6, /*Op*/2, /*Type*/GILLT_s32,
     /*  33173 */     // MIs[6] src0
     /*  33173 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  33178 */     GIM_CheckConstantInt8, /*MI*/6, /*Op*/2, 16,
     /*  33182 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33186 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33190 */     GIM_CheckType, /*MI*/7, /*Op*/2, /*Type*/GILLT_s32,
     /*  33194 */     // MIs[7] src1
     /*  33194 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33199 */     GIM_CheckConstantInt8, /*MI*/7, /*Op*/2, 16,
     /*  33203 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33205 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33205 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33208 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33213 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  33217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33220 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  33224 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33227 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src2
     /*  33231 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33234 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33237 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33240 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33243 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33246 */     GIR_RootConstrainSelectedInstOperands,
     /*  33247 */     // GIR_Coverage, 9335,
     /*  33247 */     GIR_EraseRootFromParent_Done,
     /*  33248 */   // Label 239: @33248
     /*  33248 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(33463), // Rule ID 2906 //
     /*  33253 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33256 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33260 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33264 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33268 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33272 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33276 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33278 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33282 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33286 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33289 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33294 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33298 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33302 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33304 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33308 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33312 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33316 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33320 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33324 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33328 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33332 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33336 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33340 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33344 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33348 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33352 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33355 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33360 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33364 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33368 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33370 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33374 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33378 */     // MIs[6] src0
     /*  33378 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33383 */     // MIs[6] Operand 2
     /*  33383 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  33394 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33398 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33402 */     // MIs[7] src1
     /*  33402 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33407 */     // MIs[7] Operand 2
     /*  33407 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  33418 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33420 */     // (add:{ *:[i32] } (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>, i32:{ *:[i32] }:$src2)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33420 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33423 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33425 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33428 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33432 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33435 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33439 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  33446 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33452 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33455 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33458 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33461 */     GIR_RootConstrainSelectedInstOperands,
     /*  33462 */     // GIR_Coverage, 2906,
     /*  33462 */     GIR_EraseRootFromParent_Done,
     /*  33463 */   // Label 240: @33463
     /*  33463 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(33678), // Rule ID 9333 //
     /*  33468 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDot2Insts),
     /*  33471 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33475 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33479 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  33483 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33487 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33491 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33493 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  33497 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33501 */     GIM_CheckNumOperands, /*MI*/2, /*Expected*/4,
     /*  33504 */     GIM_CheckIntrinsicID, /*MI*/2, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33509 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33513 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33517 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  33519 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  33523 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33527 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  33531 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  33535 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
     /*  33539 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/3, // MIs[4]
     /*  33543 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  33547 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  33551 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  33555 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 16,
     /*  33559 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33563 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  33567 */     GIM_CheckNumOperands, /*MI*/5, /*Expected*/4,
     /*  33570 */     GIM_CheckIntrinsicID, /*MI*/5, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  33575 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  33579 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  33583 */     GIM_CheckHasOneUse, /*MI*/5,
     /*  33585 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33589 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33593 */     // MIs[6] src0
     /*  33593 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33598 */     // MIs[6] Operand 2
     /*  33598 */     GIM_CheckLiteralInt, /*MI*/6, /*Op*/2, GIMT_Encode8(16),
     /*  33609 */     GIM_RecordInsn, /*DefineMI*/7, /*MI*/5, /*OpIdx*/3, // MIs[7]
     /*  33613 */     GIM_CheckOpcode, /*MI*/7, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
     /*  33617 */     // MIs[7] src1
     /*  33617 */     GIM_CheckIsSameOperand, /*MI*/7, /*OpIdx*/1, /*OtherMI*/4, /*OtherOpIdx*/1,
     /*  33622 */     // MIs[7] Operand 2
     /*  33622 */     GIM_CheckLiteralInt, /*MI*/7, /*Op*/2, GIMT_Encode8(16),
     /*  33633 */     GIM_CheckIsSafeToFold, /*NumInsns*/7,
     /*  33635 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, 16:{ *:[i32] }), (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, 16:{ *:[i32] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)<<P:Predicate_add_oneuse>>, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src0, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } i32:{ *:[i32] }:$src1, i16:{ *:[Other] }))<<P:Predicate_AMDGPUmul_i24_oneuse>>)  =>  (V_DOT2_I32_I16:{ *:[i32] } 8:{ *:[i32] }, ?:{ *:[i32] }:$src0, 8:{ *:[i32] }, ?:{ *:[i32] }:$src1, 8:{ *:[i32] }, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  33635 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_DOT2_I32_I16),
     /*  33638 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33640 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33643 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  33647 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33650 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
     /*  33654 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*  33657 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
     /*  33661 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33664 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33667 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33673 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33676 */     GIR_RootConstrainSelectedInstOperands,
     /*  33677 */     // GIR_Coverage, 9333,
     /*  33677 */     GIR_EraseRootFromParent_Done,
     /*  33678 */   // Label 241: @33678
     /*  33678 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(33743), // Rule ID 2722 //
     /*  33683 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  33686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33690 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33694 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  33698 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33702 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33706 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33708 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  33712 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  33716 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:9:z
     /*  33720 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  33724 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33726 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_22632>>, i32:{ *:[i32] }:$src2:$pred:9:z)<<P:9:Predicate_anonymous_22631>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  33726 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  33729 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33731 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33735 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  33739 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  33741 */     GIR_RootConstrainSelectedInstOperands,
     /*  33742 */     // GIR_Coverage, 2722,
     /*  33742 */     GIR_EraseRootFromParent_Done,
     /*  33743 */   // Label 242: @33743
     /*  33743 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(33808), // Rule ID 9269 //
     /*  33748 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMadU32Inst),
     /*  33751 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33755 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:9:z
     /*  33759 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  33763 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  33767 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33771 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33775 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33777 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*  33781 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*  33785 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  33789 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33791 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:9:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:9:x, i32:{ *:[i32] }:$src1:$pred:9:y)<<P:Predicate_anonymous_22632>>)<<P:9:Predicate_anonymous_22631>>  =>  (V_MAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  33791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_e64),
     /*  33794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  33800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  33804 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  33806 */     GIR_RootConstrainSelectedInstOperands,
     /*  33807 */     // GIR_Coverage, 9269,
     /*  33807 */     GIR_EraseRootFromParent_Done,
     /*  33808 */   // Label 243: @33808
     /*  33808 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(33861), // Rule ID 8324 //
     /*  33813 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  33817 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33821 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33825 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33829 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33833 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  33837 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  33841 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14905),
     /*  33845 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33847 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_14905>>  =>  (S_BFM_B32:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  33847 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_BFM_B32),
     /*  33850 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  33852 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  33856 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33859 */     GIR_RootConstrainSelectedInstOperands,
     /*  33860 */     // GIR_Coverage, 8324,
     /*  33860 */     GIR_EraseRootFromParent_Done,
     /*  33861 */   // Label 244: @33861
     /*  33861 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(33914), // Rule ID 8326 //
     /*  33866 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33870 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33874 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  33878 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  33882 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33886 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
     /*  33890 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  33894 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  33898 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  33900 */     // (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$a), -1:{ *:[i32] })<<P:Predicate_anonymous_21288>>  =>  (V_BFM_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$a, 0:{ *:[i32] })
     /*  33900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFM_B32_e64),
     /*  33903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  33905 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // a
     /*  33909 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  33912 */     GIR_RootConstrainSelectedInstOperands,
     /*  33913 */     // GIR_Coverage, 8326,
     /*  33913 */     GIR_EraseRootFromParent_Done,
     /*  33914 */   // Label 245: @33914
     /*  33914 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(34024), // Rule ID 8117 //
     /*  33919 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  33923 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33927 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  33931 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  33935 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  33939 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  33943 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  33945 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33949 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  33953 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  33957 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  33961 */     // MIs[2] Operand 1
     /*  33961 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  33966 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  33970 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33974 */     // MIs[3] src0
     /*  33974 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33979 */     // MIs[3] src1
     /*  33979 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33984 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  33988 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  33992 */     // MIs[4] src1
     /*  33992 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  33997 */     // MIs[4] src0
     /*  33997 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34002 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  34004 */     // (add:{ *:[i32] } (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34004 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34007 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34009 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34013 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  34017 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34019 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34022 */     GIR_RootConstrainSelectedInstOperands,
     /*  34023 */     // GIR_Coverage, 8117,
     /*  34023 */     GIR_EraseRootFromParent_Done,
     /*  34024 */   // Label 246: @34024
     /*  34024 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(34134), // Rule ID 11975 //
     /*  34029 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34033 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34037 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  34041 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*  34045 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34049 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34053 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34055 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34059 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ICMP),
     /*  34063 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34067 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  34071 */     // MIs[2] Operand 1
     /*  34071 */     GIM_CheckCmpPredicate, /*MI*/2, /*Op*/1, /*Predicate*/GIMT_Encode2(CmpInst::ICMP_UGT),
     /*  34076 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34080 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34084 */     // MIs[3] src0
     /*  34084 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34089 */     // MIs[3] src1
     /*  34089 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34094 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/3, // MIs[4]
     /*  34098 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34102 */     // MIs[4] src1
     /*  34102 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/3,
     /*  34107 */     // MIs[4] src0
     /*  34107 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34112 */     GIM_CheckIsSafeToFold, /*NumInsns*/4,
     /*  34114 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (select:{ *:[i32] } (setcc:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, SETUGT:{ *:[Other] }), (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (sub:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_select_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34114 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34117 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34119 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34123 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/3, // src1
     /*  34127 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34129 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34132 */     GIR_RootConstrainSelectedInstOperands,
     /*  34133 */     // GIR_Coverage, 11975,
     /*  34133 */     GIR_EraseRootFromParent_Done,
     /*  34134 */   // Label 247: @34134
     /*  34134 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(34227), // Rule ID 2712 //
     /*  34139 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34142 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34146 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34150 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34154 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34158 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34162 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34164 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  34168 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34172 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34176 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34180 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34184 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  34188 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34192 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34196 */     // MIs[3] Operand 1
     /*  34196 */     // No operand predicates
     /*  34196 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  34200 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  34204 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22609),
     /*  34208 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34210 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_22610>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_22609>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34210 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  34213 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34215 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34219 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34223 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34225 */     GIR_RootConstrainSelectedInstOperands,
     /*  34226 */     // GIR_Coverage, 2712,
     /*  34226 */     GIR_EraseRootFromParent_Done,
     /*  34227 */   // Label 248: @34227
     /*  34227 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(34320), // Rule ID 9262 //
     /*  34232 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34235 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34239 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  34243 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  34247 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34251 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34255 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34259 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34261 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  34265 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  34269 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34273 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34277 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34281 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*  34285 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  34289 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  34293 */     // MIs[3] Operand 1
     /*  34293 */     // No operand predicates
     /*  34293 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  34297 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22609),
     /*  34301 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34303 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:1:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_22610>>)<<P:1:Predicate_anonymous_22609>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  34303 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  34306 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34316 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  34318 */     GIR_RootConstrainSelectedInstOperands,
     /*  34319 */     // GIR_Coverage, 9262,
     /*  34319 */     GIR_EraseRootFromParent_Done,
     /*  34320 */   // Label 249: @34320
     /*  34320 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(34375), // Rule ID 8053 //
     /*  34325 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34329 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34333 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34337 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34340 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  34345 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34349 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34353 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34355 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34355 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  34358 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34360 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  34364 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  34368 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34370 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34373 */     GIR_RootConstrainSelectedInstOperands,
     /*  34374 */     // GIR_Coverage, 8053,
     /*  34374 */     GIR_EraseRootFromParent_Done,
     /*  34375 */   // Label 250: @34375
     /*  34375 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(34430), // Rule ID 8055 //
     /*  34380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  34392 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  34395 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  34400 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34404 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  34408 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34410 */     // (add:{ *:[i32] } (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i32:{ *:[i32] }:$src2)  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34410 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  34413 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34415 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  34419 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  34423 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34425 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34428 */     GIR_RootConstrainSelectedInstOperands,
     /*  34429 */     // GIR_Coverage, 8055,
     /*  34429 */     GIR_EraseRootFromParent_Done,
     /*  34430 */   // Label 251: @34430
     /*  34430 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(34495), // Rule ID 82 //
     /*  34435 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34438 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34442 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34446 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34450 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34454 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34458 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34460 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34465 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  34469 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34473 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  34477 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34479 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34479 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  34482 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34488 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  34490 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34493 */     GIR_RootConstrainSelectedInstOperands,
     /*  34494 */     // GIR_Coverage, 82,
     /*  34494 */     GIR_EraseRootFromParent_Done,
     /*  34495 */   // Label 252: @34495
     /*  34495 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(34560), // Rule ID 83 //
     /*  34500 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34503 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34507 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34511 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34515 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34519 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34523 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34525 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34530 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  34534 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34538 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  34542 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34544 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34544 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  34547 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34549 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34553 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  34555 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34558 */     GIR_RootConstrainSelectedInstOperands,
     /*  34559 */     // GIR_Coverage, 83,
     /*  34559 */     GIR_EraseRootFromParent_Done,
     /*  34560 */   // Label 253: @34560
     /*  34560 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(34625), // Rule ID 84 //
     /*  34565 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34568 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34572 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34576 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34580 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34584 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34588 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34590 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34595 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  34599 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34603 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  34607 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34609 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  34612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34618 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  34620 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34623 */     GIR_RootConstrainSelectedInstOperands,
     /*  34624 */     // GIR_Coverage, 84,
     /*  34624 */     GIR_EraseRootFromParent_Done,
     /*  34625 */   // Label 254: @34625
     /*  34625 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(34690), // Rule ID 85 //
     /*  34630 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  34633 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34637 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34641 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  34645 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34649 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34653 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34655 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34660 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  34664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  34668 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  34672 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  34674 */     // (add:{ *:[i32] } (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  34674 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  34677 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  34679 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  34683 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  34685 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  34688 */     GIR_RootConstrainSelectedInstOperands,
     /*  34689 */     // GIR_Coverage, 85,
     /*  34689 */     GIR_EraseRootFromParent_Done,
     /*  34690 */   // Label 255: @34690
     /*  34690 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(34773), // Rule ID 8116 //
     /*  34695 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34699 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34703 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34707 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34711 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34715 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34717 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34721 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34725 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34729 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34733 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34737 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34741 */     // MIs[3] src0
     /*  34741 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34746 */     // MIs[3] src1
     /*  34746 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34751 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34753 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34766 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34768 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34771 */     GIR_RootConstrainSelectedInstOperands,
     /*  34772 */     // GIR_Coverage, 8116,
     /*  34772 */     GIR_EraseRootFromParent_Done,
     /*  34773 */   // Label 256: @34773
     /*  34773 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(34856), // Rule ID 11968 //
     /*  34778 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34782 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34786 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34790 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34794 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34798 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34800 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34804 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34808 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34812 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34816 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34820 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34824 */     // MIs[3] src1
     /*  34824 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34829 */     // MIs[3] src0
     /*  34829 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34834 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34836 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34836 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34839 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34841 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  34845 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  34849 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34851 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34854 */     GIR_RootConstrainSelectedInstOperands,
     /*  34855 */     // GIR_Coverage, 11968,
     /*  34855 */     GIR_EraseRootFromParent_Done,
     /*  34856 */   // Label 257: @34856
     /*  34856 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(34939), // Rule ID 11969 //
     /*  34861 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34865 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34869 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34873 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34877 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34881 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34883 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34887 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34891 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34895 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34899 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34903 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34907 */     // MIs[3] src0
     /*  34907 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34912 */     // MIs[3] src1
     /*  34912 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34917 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  34919 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  34919 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  34922 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  34924 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  34928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  34932 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  34934 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  34937 */     GIR_RootConstrainSelectedInstOperands,
     /*  34938 */     // GIR_Coverage, 11969,
     /*  34938 */     GIR_EraseRootFromParent_Done,
     /*  34939 */   // Label 258: @34939
     /*  34939 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(35022), // Rule ID 11970 //
     /*  34944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  34948 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34952 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  34956 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  34960 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  34964 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  34966 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34970 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  34974 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  34978 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  34982 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  34986 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  34990 */     // MIs[3] src1
     /*  34990 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  34995 */     // MIs[3] src0
     /*  34995 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35000 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35002 */     // (add:{ *:[i32] } (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>, i32:{ *:[i32] }:$src2)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35002 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35005 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35007 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35011 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35015 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  35017 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35020 */     GIR_RootConstrainSelectedInstOperands,
     /*  35021 */     // GIR_Coverage, 11970,
     /*  35021 */     GIR_EraseRootFromParent_Done,
     /*  35022 */   // Label 259: @35022
     /*  35022 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(35087), // Rule ID 9175 //
     /*  35027 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35030 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35034 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35038 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35042 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35046 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35050 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35054 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35056 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35061 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*  35065 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl1_add),
     /*  35069 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35071 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 1:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl1_add>>  =>  (S_LSHL1_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL1_ADD_U32),
     /*  35074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35080 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  35082 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35085 */     GIR_RootConstrainSelectedInstOperands,
     /*  35086 */     // GIR_Coverage, 9175,
     /*  35086 */     GIR_EraseRootFromParent_Done,
     /*  35087 */   // Label 260: @35087
     /*  35087 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(35152), // Rule ID 9176 //
     /*  35092 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35095 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35099 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35103 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35107 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35111 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35115 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35119 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35121 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35126 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*  35130 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl2_add),
     /*  35134 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35136 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 2:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl2_add>>  =>  (S_LSHL2_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35136 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL2_ADD_U32),
     /*  35139 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35141 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35145 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  35147 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35150 */     GIR_RootConstrainSelectedInstOperands,
     /*  35151 */     // GIR_Coverage, 9176,
     /*  35151 */     GIR_EraseRootFromParent_Done,
     /*  35152 */   // Label 261: @35152
     /*  35152 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(35217), // Rule ID 9177 //
     /*  35157 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35160 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35164 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35176 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35180 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35184 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35186 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35191 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*  35195 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl3_add),
     /*  35199 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35201 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 3:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl3_add>>  =>  (S_LSHL3_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35201 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL3_ADD_U32),
     /*  35204 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35206 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35210 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  35212 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35215 */     GIR_RootConstrainSelectedInstOperands,
     /*  35216 */     // GIR_Coverage, 9177,
     /*  35216 */     GIR_EraseRootFromParent_Done,
     /*  35217 */   // Label 262: @35217
     /*  35217 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(35282), // Rule ID 9178 //
     /*  35222 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  35225 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35229 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35233 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35237 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  35241 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35245 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35249 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35251 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  35256 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 4,
     /*  35260 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl4_add),
     /*  35264 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35266 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src1, (shl:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, 4:{ *:[i32] })<<P:Predicate_shl_oneuse>>)<<P:Predicate_shl4_add>>  =>  (S_LSHL4_ADD_U32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  35266 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_LSHL4_ADD_U32),
     /*  35269 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  35271 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35275 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  35277 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  35280 */     GIR_RootConstrainSelectedInstOperands,
     /*  35281 */     // GIR_Coverage, 9178,
     /*  35281 */     GIR_EraseRootFromParent_Done,
     /*  35282 */   // Label 263: @35282
     /*  35282 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(35337), // Rule ID 11935 //
     /*  35287 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35291 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35295 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35299 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35302 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_i24),
     /*  35307 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35311 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35315 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35317 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3262:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_I32_I24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35317 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_I32_I24_e64),
     /*  35320 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35326 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35330 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35332 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35335 */     GIR_RootConstrainSelectedInstOperands,
     /*  35336 */     // GIR_Coverage, 11935,
     /*  35336 */     GIR_EraseRootFromParent_Done,
     /*  35337 */   // Label 264: @35337
     /*  35337 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(35392), // Rule ID 11937 //
     /*  35342 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35346 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35350 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  35354 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  35357 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  35362 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35366 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  35370 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35372 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (intrinsic_wo_chain:{ *:[i32] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U32_U24_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35372 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U32_U24_e64),
     /*  35375 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  35381 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  35385 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35387 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35390 */     GIR_RootConstrainSelectedInstOperands,
     /*  35391 */     // GIR_Coverage, 11937,
     /*  35391 */     GIR_EraseRootFromParent_Done,
     /*  35392 */   // Label 265: @35392
     /*  35392 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(35475), // Rule ID 11971 //
     /*  35397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35413 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35417 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35419 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35423 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35427 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35431 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35435 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35439 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35443 */     // MIs[3] src0
     /*  35443 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35448 */     // MIs[3] src1
     /*  35448 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35453 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35455 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35455 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35458 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35460 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35464 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35468 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35470 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35473 */     GIR_RootConstrainSelectedInstOperands,
     /*  35474 */     // GIR_Coverage, 11971,
     /*  35474 */     GIR_EraseRootFromParent_Done,
     /*  35475 */   // Label 266: @35475
     /*  35475 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(35558), // Rule ID 11972 //
     /*  35480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35484 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35488 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35492 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35496 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35500 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35502 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35506 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35510 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35514 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35518 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35522 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35526 */     // MIs[3] src1
     /*  35526 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35531 */     // MIs[3] src0
     /*  35531 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35536 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35538 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35538 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35541 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35543 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  35547 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src1
     /*  35551 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35553 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35556 */     GIR_RootConstrainSelectedInstOperands,
     /*  35557 */     // GIR_Coverage, 11972,
     /*  35557 */     GIR_EraseRootFromParent_Done,
     /*  35558 */   // Label 267: @35558
     /*  35558 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(35641), // Rule ID 11973 //
     /*  35563 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35567 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35571 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35575 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35579 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35583 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35585 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35589 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35593 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35597 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35601 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35605 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35609 */     // MIs[3] src0
     /*  35609 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35614 */     // MIs[3] src1
     /*  35614 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35619 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35621 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35630 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35634 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35636 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35639 */     GIR_RootConstrainSelectedInstOperands,
     /*  35640 */     // GIR_Coverage, 11973,
     /*  35640 */     GIR_EraseRootFromParent_Done,
     /*  35641 */   // Label 268: @35641
     /*  35641 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(35724), // Rule ID 11974 //
     /*  35646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35650 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35654 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /*  35658 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35662 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35666 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35668 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35672 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_UMAX),
     /*  35676 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  35680 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  35684 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*  35688 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_UMIN),
     /*  35692 */     // MIs[3] src1
     /*  35692 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35697 */     // MIs[3] src0
     /*  35697 */     GIM_CheckIsSameOperand, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35702 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  35704 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2, (sub:{ *:[i32] } (umax:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0), (umin:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src0))<<P:Predicate_sub_oneuse>>)  =>  (V_SAD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i32] }:$src2, 0:{ *:[i1] })
     /*  35704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SAD_U32_e64),
     /*  35707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  35709 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src0
     /*  35713 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  35717 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  35719 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  35722 */     GIR_RootConstrainSelectedInstOperands,
     /*  35723 */     // GIR_Coverage, 11974,
     /*  35723 */     GIR_EraseRootFromParent_Done,
     /*  35724 */   // Label 269: @35724
     /*  35724 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(35889), // Rule ID 9277 //
     /*  35729 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  35732 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35736 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:16:z
     /*  35740 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35744 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35748 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35752 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35756 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35760 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35762 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  35766 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  35770 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  35774 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35776 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:16:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_22632>>)<<P:16:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35776 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35779 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35783 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35788 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35790 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35793 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35797 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35802 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  35806 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35809 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35812 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35815 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35820 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35825 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35830 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35833 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  35836 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  35840 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35845 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  35850 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  35854 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  35858 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  35861 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  35864 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  35866 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  35869 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  35871 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  35878 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35883 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35888 */     // GIR_Coverage, 9277,
     /*  35888 */     GIR_EraseRootFromParent_Done,
     /*  35889 */   // Label 270: @35889
     /*  35889 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(36054), // Rule ID 9281 //
     /*  35894 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  35897 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35901 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:19:z
     /*  35905 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35909 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  35913 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  35917 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  35921 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  35925 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  35927 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  35931 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  35935 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  35939 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  35941 */     // (add:{ *:[i32] } VGPR_32:{ *:[i32] }:$src2:$pred:19:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_22632>>)<<P:19:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  35941 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  35944 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  35948 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35953 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  35955 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  35958 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  35962 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  35967 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  35971 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  35974 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  35977 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  35980 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  35985 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35990 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  35995 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  35998 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36001 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36005 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36010 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36015 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36019 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36023 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36026 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36029 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36036 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36043 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36048 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36053 */     // GIR_Coverage, 9281,
     /*  36053 */     GIR_EraseRootFromParent_Done,
     /*  36054 */   // Label 271: @36054
     /*  36054 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(36119), // Rule ID 2715 //
     /*  36059 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36062 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36066 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36070 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  36074 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36078 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36082 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36084 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  36088 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  36092 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:3:z
     /*  36096 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22615),
     /*  36100 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36102 */     // (add:{ *:[i32] } (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_22613>>, i32:{ *:[i32] }:$src2:$pred:3:z)<<P:3:Predicate_anonymous_22615>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36102 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  36105 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36107 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36111 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36115 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36117 */     GIR_RootConstrainSelectedInstOperands,
     /*  36118 */     // GIR_Coverage, 2715,
     /*  36118 */     GIR_EraseRootFromParent_Done,
     /*  36119 */   // Label 272: @36119
     /*  36119 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(36284), // Rule ID 2739 //
     /*  36124 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  36127 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36131 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36135 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36139 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36143 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36147 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36149 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*  36153 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*  36157 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:16:z
     /*  36161 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36165 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  36169 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36171 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:16:x, i32:{ *:[i32] }:$src1:$pred:16:y)<<P:Predicate_anonymous_22632>>, VGPR_32:{ *:[i32] }:$src2:$pred:16:z)<<P:16:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36171 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36174 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36178 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36183 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36185 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36188 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36192 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36197 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  36201 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36204 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36207 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36210 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36215 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36220 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36225 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36228 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36231 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  36235 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36240 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36245 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36249 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36253 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36256 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36259 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36261 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36264 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36266 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36273 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36278 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36283 */     // GIR_Coverage, 2739,
     /*  36283 */     GIR_EraseRootFromParent_Done,
     /*  36284 */   // Label 273: @36284
     /*  36284 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(36449), // Rule ID 2744 //
     /*  36289 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  36292 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36296 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36300 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36304 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36308 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36312 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36314 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*  36318 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*  36322 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:19:z
     /*  36326 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36330 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  36334 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36336 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:19:x, i32:{ *:[i32] }:$src1:$pred:19:y)<<P:Predicate_anonymous_22632>>, VGPR_32:{ *:[i32] }:$src2:$pred:19:z)<<P:19:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } VReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36336 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36339 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36343 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36348 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36350 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36353 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36357 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36362 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  36366 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36369 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36372 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36375 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36380 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36385 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36390 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36393 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36396 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36400 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36405 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36410 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36414 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36418 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36421 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36424 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36426 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36429 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36431 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36438 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36443 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36448 */     // GIR_Coverage, 2744,
     /*  36448 */     GIR_EraseRootFromParent_Done,
     /*  36449 */   // Label 274: @36449
     /*  36449 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(36610), // Rule ID 2738 //
     /*  36454 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  36457 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36461 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36465 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36469 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36473 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36477 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36479 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
     /*  36483 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
     /*  36487 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:15:z
     /*  36491 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  36495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36497 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:15:x, i32:{ *:[i32] }:$src1:$pred:15:y)<<P:Predicate_anonymous_22632>>, i32:{ *:[i32] }:$src2:$pred:15:z)<<P:15:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36497 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36500 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36504 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36509 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36511 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36514 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36518 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36523 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  36527 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36530 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36533 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36536 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  36541 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  36546 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  36551 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36554 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36557 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  36561 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36566 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36571 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36575 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36579 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36582 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36585 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36587 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36590 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36592 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36599 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36604 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36609 */     // GIR_Coverage, 2738,
     /*  36609 */     GIR_EraseRootFromParent_Done,
     /*  36610 */   // Label 275: @36610
     /*  36610 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(36771), // Rule ID 2743 //
     /*  36615 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  36618 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36622 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36626 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  36630 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36634 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36638 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36640 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
     /*  36644 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
     /*  36648 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:18:z
     /*  36652 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  36656 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36658 */     // (add:{ *:[i32] } (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:18:x, i32:{ *:[i32] }:$src1:$pred:18:y)<<P:Predicate_anonymous_22632>>, i32:{ *:[i32] }:$src2:$pred:18:z)<<P:18:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  36658 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  36661 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  36665 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36670 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  36672 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  36675 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  36679 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36684 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // src2
     /*  36688 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  36691 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  36694 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  36697 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  36702 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  36707 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  36712 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  36715 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  36718 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  36722 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  36727 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  36732 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36736 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36740 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  36743 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  36746 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  36748 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  36751 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  36753 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  36760 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36765 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  36770 */     // GIR_Coverage, 2743,
     /*  36770 */     GIR_EraseRootFromParent_Done,
     /*  36771 */   // Label 276: @36771
     /*  36771 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(36836), // Rule ID 2711 //
     /*  36776 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36779 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36783 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36787 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  36791 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36795 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36799 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36801 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  36805 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  36809 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:1:z
     /*  36813 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22609),
     /*  36817 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36819 */     // (add:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_22610>>, i32:{ *:[i32] }:$src2:$pred:1:z)<<P:1:Predicate_anonymous_22609>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  36822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36824 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36828 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36832 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36834 */     GIR_RootConstrainSelectedInstOperands,
     /*  36835 */     // GIR_Coverage, 2711,
     /*  36835 */     GIR_EraseRootFromParent_Done,
     /*  36836 */   // Label 277: @36836
     /*  36836 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(36901), // Rule ID 2721 //
     /*  36841 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36844 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36848 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36852 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36856 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36860 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36864 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36866 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  36870 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  36874 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:8:z
     /*  36878 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22628),
     /*  36882 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36884 */     // (add:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_22629>>, i32:{ *:[i32] }:$src2:$pred:8:z)<<P:8:Predicate_anonymous_22628>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  36887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36893 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  36897 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  36899 */     GIR_RootConstrainSelectedInstOperands,
     /*  36900 */     // GIR_Coverage, 2721,
     /*  36900 */     GIR_EraseRootFromParent_Done,
     /*  36901 */   // Label 278: @36901
     /*  36901 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(36941), // Rule ID 7622 //
     /*  36906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36910 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36914 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  36918 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36922 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_38136),
     /*  36926 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36928 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_38136>>, i32:{ *:[i32] }:$val)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  36928 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  36931 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36933 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  36937 */     GIR_RootToRootCopy, /*OpIdx*/2, // val
     /*  36939 */     GIR_RootConstrainSelectedInstOperands,
     /*  36940 */     // GIR_Coverage, 7622,
     /*  36940 */     GIR_EraseRootFromParent_Done,
     /*  36941 */   // Label 279: @36941
     /*  36941 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(37006), // Rule ID 9263 //
     /*  36946 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  36949 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  36953 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:3:z
     /*  36957 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  36961 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  36965 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  36969 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  36973 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  36975 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*  36979 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*  36983 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22615),
     /*  36987 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  36989 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:3:z, (add:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:3:x, i32:{ *:[i32] }:$src1:$pred:3:y)<<P:Predicate_anonymous_22613>>)<<P:3:Predicate_anonymous_22615>>  =>  (V_ADD3_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  36989 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD3_U32_e64),
     /*  36992 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  36994 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  36998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37002 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37004 */     GIR_RootConstrainSelectedInstOperands,
     /*  37005 */     // GIR_Coverage, 9263,
     /*  37005 */     GIR_EraseRootFromParent_Done,
     /*  37006 */   // Label 280: @37006
     /*  37006 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(37167), // Rule ID 9276 //
     /*  37011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37014 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37018 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:15:z
     /*  37022 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37026 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37030 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37034 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37038 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37040 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
     /*  37044 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
     /*  37048 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  37052 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37054 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:15:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:15:x, i32:{ *:[i32] }:$src1:$pred:15:y)<<P:Predicate_anonymous_22632>>)<<P:15:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37054 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37057 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37061 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37066 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37068 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37071 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37075 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37080 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  37084 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37087 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37090 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37093 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37098 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37103 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37108 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37111 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37114 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37118 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37123 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37128 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37132 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37136 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37139 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37142 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37144 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37147 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37149 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37156 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37161 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37166 */     // GIR_Coverage, 9276,
     /*  37166 */     GIR_EraseRootFromParent_Done,
     /*  37167 */   // Label 281: @37167
     /*  37167 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(37328), // Rule ID 9280 //
     /*  37172 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37175 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37179 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:18:z
     /*  37183 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37187 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  37191 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37195 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37199 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37201 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
     /*  37205 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
     /*  37209 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22631),
     /*  37213 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37215 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:18:z, (mul:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:18:x, i32:{ *:[i32] }:$src1:$pred:18:y)<<P:Predicate_anonymous_22632>>)<<P:18:Predicate_anonymous_22631>>  =>  (EXTRACT_SUBREG:{ *:[i32] } (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1, (REG_SEQUENCE:{ *:[i64] } SReg_64:{ *:[i32] }, ?:{ *:[i32] }:$src2, sub0:{ *:[i32] }, (IMPLICIT_DEF:{ *:[i32] }), sub1:{ *:[i32] }), 0:{ *:[i1] }), sub0:{ *:[i32] })
     /*  37215 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
     /*  37218 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*  37222 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37227 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
     /*  37229 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s64,
     /*  37232 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
     /*  37236 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37241 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src2
     /*  37245 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/3,
     /*  37248 */     GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/3,
     /*  37251 */     GIR_AddImm8, /*InsnID*/2, /*SubRegIndex*/11,
     /*  37254 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  37259 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(AMDGPU::SReg_32_XEXEC_HI_and_SReg_32_XM0RegClassID),
     /*  37264 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/3, GIMT_Encode2(AMDGPU::SReg_32_XM0RegClassID),
     /*  37269 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s1,
     /*  37272 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*  37275 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37279 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  37284 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37289 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37293 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37297 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  37300 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
     /*  37303 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  37305 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  37308 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  37310 */     GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(AMDGPU::sub0),
     /*  37317 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37322 */     GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37327 */     // GIR_Coverage, 9280,
     /*  37327 */     GIR_EraseRootFromParent_Done,
     /*  37328 */   // Label 282: @37328
     /*  37328 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(37393), // Rule ID 9261 //
     /*  37333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37340 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:1:z
     /*  37344 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37348 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  37352 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37356 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37360 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37362 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*  37366 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*  37370 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22609),
     /*  37374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37376 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:1:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:1:x, i32:{ *:[i32] }:$src1:$pred:1:y)<<P:Predicate_anonymous_22610>>)<<P:1:Predicate_anonymous_22609>>  =>  (V_LSHL_ADD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37376 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U32_e64),
     /*  37379 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37381 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37385 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37389 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37391 */     GIR_RootConstrainSelectedInstOperands,
     /*  37392 */     // GIR_Coverage, 9261,
     /*  37392 */     GIR_EraseRootFromParent_Done,
     /*  37393 */   // Label 283: @37393
     /*  37393 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(37458), // Rule ID 9268 //
     /*  37398 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  37401 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37405 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:8:z
     /*  37409 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37413 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37417 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37421 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37425 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  37427 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*  37431 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*  37435 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22628),
     /*  37439 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37441 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:8:z, (xor:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:8:x, i32:{ *:[i32] }:$src1:$pred:8:y)<<P:Predicate_anonymous_22629>>)<<P:8:Predicate_anonymous_22628>>  =>  (V_XAD_U32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  37441 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_XAD_U32_e64),
     /*  37444 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37450 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  37454 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  37456 */     GIR_RootConstrainSelectedInstOperands,
     /*  37457 */     // GIR_Coverage, 9268,
     /*  37457 */     GIR_EraseRootFromParent_Done,
     /*  37458 */   // Label 284: @37458
     /*  37458 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(37498), // Rule ID 11933 //
     /*  37463 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37467 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37471 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37475 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37479 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_38136),
     /*  37483 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37485 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$val, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$popcnt)<<P:Predicate_anonymous_38136>>)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } ?:{ *:[i32] }:$popcnt, ?:{ *:[i32] }:$val)
     /*  37485 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37488 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37490 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // popcnt
     /*  37494 */     GIR_RootToRootCopy, /*OpIdx*/1, // val
     /*  37496 */     GIR_RootConstrainSelectedInstOperands,
     /*  37497 */     // GIR_Coverage, 11933,
     /*  37497 */     GIR_EraseRootFromParent_Done,
     /*  37498 */   // Label 285: @37498
     /*  37498 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(37542), // Rule ID 8319 //
     /*  37503 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  37507 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37511 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  37515 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  37519 */     // MIs[1] Operand 1
     /*  37519 */     // No operand predicates
     /*  37519 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14905),
     /*  37523 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37525 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_14905>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SReg_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i1 i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  37525 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  37528 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  37530 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37532 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  37537 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  37540 */     GIR_RootConstrainSelectedInstOperands,
     /*  37541 */     // GIR_Coverage, 8319,
     /*  37541 */     GIR_EraseRootFromParent_Done,
     /*  37542 */   // Label 286: @37542
     /*  37542 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(37589), // Rule ID 8320 //
     /*  37547 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  37550 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37554 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37558 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  37562 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  37566 */     // MIs[1] Operand 1
     /*  37566 */     // No operand predicates
     /*  37566 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  37570 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37572 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_21288>>  =>  (V_SUB_U32_e64:{ *:[i32] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  37572 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  37575 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37577 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37579 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  37584 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37587 */     GIR_RootConstrainSelectedInstOperands,
     /*  37588 */     // GIR_Coverage, 8320,
     /*  37588 */     GIR_EraseRootFromParent_Done,
     /*  37589 */   // Label 287: @37589
     /*  37589 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(37644), // Rule ID 8321 //
     /*  37594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasAddNoCarryInsts),
     /*  37597 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37601 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37605 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  37609 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_NegSubInlineConst32),
     /*  37613 */     // MIs[1] Operand 1
     /*  37613 */     // No operand predicates
     /*  37613 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  37617 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37619 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>><<X:NegateImm>>:$src1)<<P:Predicate_anonymous_21288>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } VS_32:{ *:[i32] }:$src0, (NegateImm:{ *:[i16 i32 bf16 f16 f32 v2i16 v2f16 v2bf16] } (imm:{ *:[i32] })<<P:Predicate_NegSubInlineConst32>>:$src1))
     /*  37619 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37622 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  37625 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37627 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37632 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37634 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderNegateImm), // src1
     /*  37639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37642 */     GIR_RootConstrainSelectedInstOperands,
     /*  37643 */     // GIR_Coverage, 8321,
     /*  37643 */     GIR_EraseRootFromParent_Done,
     /*  37644 */   // Label 288: @37644
     /*  37644 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(37678), // Rule ID 43 //
     /*  37649 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  37653 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  37657 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  37661 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14905),
     /*  37665 */     // (add:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14905>>  =>  (S_ADD_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  37665 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_I32),
     /*  37670 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  37676 */     GIR_RootConstrainSelectedInstOperands,
     /*  37677 */     // GIR_Coverage, 43,
     /*  37677 */     GIR_Done,
     /*  37678 */   // Label 289: @37678
     /*  37678 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(37708), // Rule ID 2591 //
     /*  37683 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  37686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37690 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  37694 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_21288>>  =>  (V_ADD_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  37694 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U32_e64),
     /*  37697 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37699 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37701 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37703 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37706 */     GIR_RootConstrainSelectedInstOperands,
     /*  37707 */     // GIR_Coverage, 2591,
     /*  37707 */     GIR_EraseRootFromParent_Done,
     /*  37708 */   // Label 290: @37708
     /*  37708 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(37746), // Rule ID 2593 //
     /*  37713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  37716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37720 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  37724 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_21288>>  =>  (V_ADD_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  37724 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37727 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_CO_U32_e64),
     /*  37730 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37732 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37737 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  37739 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37741 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37744 */     GIR_RootConstrainSelectedInstOperands,
     /*  37745 */     // GIR_Coverage, 2593,
     /*  37745 */     GIR_EraseRootFromParent_Done,
     /*  37746 */   // Label 291: @37746
     /*  37746 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(37782), // Rule ID 841 //
     /*  37751 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37755 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37759 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37763 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37767 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37769 */     // (add:{ *:[i32] } (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  37769 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37772 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37774 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37778 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  37780 */     GIR_RootConstrainSelectedInstOperands,
     /*  37781 */     // GIR_Coverage, 841,
     /*  37781 */     GIR_EraseRootFromParent_Done,
     /*  37782 */   // Label 292: @37782
     /*  37782 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(37818), // Rule ID 9190 //
     /*  37787 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  37791 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37795 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CTPOP),
     /*  37799 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  37803 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37805 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$src1, (ctpop:{ *:[i32] } i32:{ *:[i32] }:$src0))  =>  (V_BCNT_U32_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  37805 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BCNT_U32_B32_e64),
     /*  37808 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37810 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  37814 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  37816 */     GIR_RootConstrainSelectedInstOperands,
     /*  37817 */     // GIR_Coverage, 9190,
     /*  37817 */     GIR_EraseRootFromParent_Done,
     /*  37818 */   // Label 293: @37818
     /*  37818 */   GIM_Reject,
     /*  37819 */ // Label 201: @37819
     /*  37819 */ GIM_Reject,
     /*  37820 */ // Label 174: @37820
     /*  37820 */ GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(38290),
     /*  37825 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  37828 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  37831 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(37897), // Rule ID 2741 //
     /*  37836 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37839 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37843 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37847 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37851 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37854 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37859 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37863 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37867 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37869 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37869 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37872 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  37875 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37877 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37882 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37886 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37890 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37892 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37895 */     GIR_RootConstrainSelectedInstOperands,
     /*  37896 */     // GIR_Coverage, 2741,
     /*  37896 */     GIR_EraseRootFromParent_Done,
     /*  37897 */   // Label 295: @37897
     /*  37897 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(37963), // Rule ID 2746 //
     /*  37902 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  37905 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37909 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37913 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37917 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37920 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37925 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37929 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37933 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  37935 */     // (add:{ *:[i64] } (intrinsic_wo_chain:{ *:[i64] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1), i64:{ *:[i64] }:$src2)  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  37935 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  37938 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  37941 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  37943 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  37948 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  37952 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  37956 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  37958 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  37961 */     GIR_RootConstrainSelectedInstOperands,
     /*  37962 */     // GIR_Coverage, 2746,
     /*  37962 */     GIR_EraseRootFromParent_Done,
     /*  37963 */   // Label 296: @37963
     /*  37963 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(38029), // Rule ID 9278 //
     /*  37968 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNotMADIntraFwdBug_isGFX9Plus),
     /*  37971 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  37975 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  37979 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  37983 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  37986 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  37991 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  37995 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  37999 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38001 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38001 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38004 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_e64),
     /*  38007 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38009 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38014 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38018 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38022 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38027 */     GIR_RootConstrainSelectedInstOperands,
     /*  38028 */     // GIR_Coverage, 9278,
     /*  38028 */     GIR_EraseRootFromParent_Done,
     /*  38029 */   // Label 297: @38029
     /*  38029 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(38095), // Rule ID 9282 //
     /*  38034 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMADIntraFwdBug_isGFX11Only),
     /*  38037 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38041 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38045 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_INTRINSIC),
     /*  38049 */     GIM_CheckNumOperands, /*MI*/1, /*Expected*/4,
     /*  38052 */     GIM_CheckIntrinsicID, /*MI*/1, /*Op*/1, GIMT_Encode2(Intrinsic::amdgcn_mul_u24),
     /*  38057 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38061 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  38065 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38067 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2, (intrinsic_wo_chain:{ *:[i64] } 3263:{ *:[iPTR] }, i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1))  =>  (V_MAD_U64_U32_gfx11_e64:{ *:[i64] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, ?:{ *:[i64] }:$src2, 0:{ *:[i1] })
     /*  38067 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  38070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MAD_U64_U32_gfx11_e64),
     /*  38073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38075 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  38080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src0
     /*  38084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src1
     /*  38088 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38090 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38093 */     GIR_RootConstrainSelectedInstOperands,
     /*  38094 */     // GIR_Coverage, 9282,
     /*  38094 */     GIR_EraseRootFromParent_Done,
     /*  38095 */   // Label 298: @38095
     /*  38095 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(38164), // Rule ID 2724 //
     /*  38100 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  38103 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38107 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38111 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  38115 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  38119 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38123 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38125 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  38129 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  38133 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  38137 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:10:z
     /*  38141 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22635),
     /*  38145 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38147 */     // (add:{ *:[i64] } (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_22636>>, i64:{ *:[i64] }:$src2:$pred:10:z)<<P:10:Predicate_anonymous_22635>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  38147 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  38150 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38152 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38156 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38160 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  38162 */     GIR_RootConstrainSelectedInstOperands,
     /*  38163 */     // GIR_Coverage, 2724,
     /*  38163 */     GIR_EraseRootFromParent_Done,
     /*  38164 */   // Label 299: @38164
     /*  38164 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(38233), // Rule ID 9270 //
     /*  38169 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLshlAddU64Inst),
     /*  38172 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38176 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:10:z
     /*  38180 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38184 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  38188 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  38192 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  38196 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  38198 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*  38202 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*  38206 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_shl_0_to_4),
     /*  38210 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22635),
     /*  38214 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38216 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src2:$pred:10:z, (shl:{ *:[i64] } i64:{ *:[i64] }:$src0:$pred:10:x, i32:{ *:[i32] }:$src1:$pred:10:y)<<P:Predicate_shl_0_to_4>><<P:Predicate_anonymous_22636>>)<<P:10:Predicate_anonymous_22635>>  =>  (V_LSHL_ADD_U64_e64:{ *:[i64] } VSrc_b64:{ *:[i64] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b64:{ *:[i64] }:$src2)
     /*  38216 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_ADD_U64_e64),
     /*  38219 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38221 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  38225 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  38229 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  38231 */     GIR_RootConstrainSelectedInstOperands,
     /*  38232 */     // GIR_Coverage, 9270,
     /*  38232 */     GIR_EraseRootFromParent_Done,
     /*  38233 */   // Label 300: @38233
     /*  38233 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(38263), // Rule ID 1426 //
     /*  38238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  38242 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21288),
     /*  38246 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_21288>>  =>  (V_ADD_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  38246 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_ADD_U64_PSEUDO),
     /*  38251 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  38257 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  38261 */     GIR_RootConstrainSelectedInstOperands,
     /*  38262 */     // GIR_Coverage, 1426,
     /*  38262 */     GIR_Done,
     /*  38263 */   // Label 301: @38263
     /*  38263 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(38289), // Rule ID 1428 //
     /*  38268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38272 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14905),
     /*  38276 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_14905>>  =>  (S_ADD_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  38276 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_ADD_U64_PSEUDO),
     /*  38281 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38287 */     GIR_RootConstrainSelectedInstOperands,
     /*  38288 */     // GIR_Coverage, 1428,
     /*  38288 */     GIR_Done,
     /*  38289 */   // Label 302: @38289
     /*  38289 */   GIM_Reject,
     /*  38290 */ // Label 294: @38290
     /*  38290 */ GIM_Reject,
     /*  38291 */ // Label 175: @38291
     /*  38291 */ GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(38560),
     /*  38296 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  38299 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  38302 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38306 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(38402), // Rule ID 9244 //
     /*  38311 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  38315 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38319 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  38323 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  38327 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38329 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38336 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38343 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38350 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers), (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  38350 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  38353 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38355 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src0_modifiers
     /*  38360 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src0
     /*  38365 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src1_modifiers
     /*  38370 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src1
     /*  38375 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src2_modifiers
     /*  38380 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src2
     /*  38385 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38388 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38391 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38394 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38397 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38400 */     GIR_RootConstrainSelectedInstOperands,
     /*  38401 */     // GIR_Coverage, 9244,
     /*  38401 */     GIR_EraseRootFromParent_Done,
     /*  38402 */   // Label 304: @38402
     /*  38402 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(38498), // Rule ID 1166 //
     /*  38407 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38411 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*  38415 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  38419 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  38423 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  38425 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(2), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38432 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38439 */     GIM_CheckComplexPattern, /*MI*/1, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38446 */     // (add:{ *:[v2i16] } (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers)), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src2, i32:{ *:[i32] }:$src2_modifiers))  =>  (V_PK_MAD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src2_modifiers, v2i16:{ *:[v2i16] }:$src2)
     /*  38446 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MAD_U16),
     /*  38449 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38451 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38456 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38461 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38466 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38471 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/1, // src2_modifiers
     /*  38476 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(2), /*SubOperand*/0, // src2
     /*  38481 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38484 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38487 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38490 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38493 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38496 */     GIR_RootConstrainSelectedInstOperands,
     /*  38497 */     // GIR_Coverage, 1166,
     /*  38497 */     GIR_EraseRootFromParent_Done,
     /*  38498 */   // Label 305: @38498
     /*  38498 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(38559), // Rule ID 1177 //
     /*  38503 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38510 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  38517 */     // (add:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_ADD_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  38517 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_ADD_U16),
     /*  38520 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38522 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38527 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38532 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38537 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38542 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38545 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38548 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38551 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38554 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38557 */     GIR_RootConstrainSelectedInstOperands,
     /*  38558 */     // GIR_Coverage, 1177,
     /*  38558 */     GIR_EraseRootFromParent_Done,
     /*  38559 */   // Label 306: @38559
     /*  38559 */   GIM_Reject,
     /*  38560 */ // Label 303: @38560
     /*  38560 */ GIM_Reject,
     /*  38561 */ // Label 176: @38561
     /*  38561 */ GIM_Reject,
     /*  38562 */ // Label 1: @38562
     /*  38562 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(12), /*)*//*default:*//*Label 312*/ GIMT_Encode4(39184),
     /*  38573 */ /*GILLT_s1*//*Label 307*/ GIMT_Encode4(38593),
     /*  38577 */ /*GILLT_s16*//*Label 308*/ GIMT_Encode4(38712),
     /*  38581 */ /*GILLT_s32*//*Label 309*/ GIMT_Encode4(38928),
     /*  38585 */ /*GILLT_s64*//*Label 310*/ GIMT_Encode4(39043),
     /*  38589 */ /*GILLT_v2s16*//*Label 311*/ GIMT_Encode4(39112),
     /*  38593 */ // Label 307: @38593
     /*  38593 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(38711),
     /*  38598 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  38601 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  38604 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(38632), // Rule ID 8161 //
     /*  38609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  38612 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38616 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  38620 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  38620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B64),
     /*  38623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  38625 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38627 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  38630 */     GIR_RootConstrainSelectedInstOperands,
     /*  38631 */     // GIR_Coverage, 8161,
     /*  38631 */     GIR_EraseRootFromParent_Done,
     /*  38632 */   // Label 314: @38632
     /*  38632 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(38660), // Rule ID 8168 //
     /*  38637 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  38640 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38644 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 255,
     /*  38648 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, -1:{ *:[i1] })  =>  (S_NOT_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0)
     /*  38648 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_NOT_B32),
     /*  38651 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  38653 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38655 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  38658 */     GIR_RootConstrainSelectedInstOperands,
     /*  38659 */     // GIR_Coverage, 8168,
     /*  38659 */     GIR_EraseRootFromParent_Done,
     /*  38660 */   // Label 315: @38660
     /*  38660 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(38685), // Rule ID 8159 //
     /*  38665 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  38668 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  38672 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  38672 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B64),
     /*  38677 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38683 */     GIR_RootConstrainSelectedInstOperands,
     /*  38684 */     // GIR_Coverage, 8159,
     /*  38684 */     GIR_Done,
     /*  38685 */   // Label 316: @38685
     /*  38685 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(38710), // Rule ID 8166 //
     /*  38690 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  38693 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38697 */     // (sub:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_XOR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  38697 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_XOR_B32),
     /*  38702 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38708 */     GIR_RootConstrainSelectedInstOperands,
     /*  38709 */     // GIR_Coverage, 8166,
     /*  38709 */     GIR_Done,
     /*  38710 */   // Label 317: @38710
     /*  38710 */   GIM_Reject,
     /*  38711 */ // Label 313: @38711
     /*  38711 */ GIM_Reject,
     /*  38712 */ // Label 308: @38712
     /*  38712 */ GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(38927),
     /*  38717 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  38720 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  38723 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(38782), // Rule ID 1108 //
     /*  38728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts_isGFX10Plus),
     /*  38731 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38735 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38742 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  38749 */     // (sub:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_e64),
     /*  38752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38754 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38759 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38764 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38769 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38774 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38777 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38780 */     GIR_RootConstrainSelectedInstOperands,
     /*  38781 */     // GIR_Coverage, 1108,
     /*  38781 */     GIR_EraseRootFromParent_Done,
     /*  38782 */   // Label 319: @38782
     /*  38782 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(38841), // Rule ID 1109 //
     /*  38787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts_isGFX10Plus),
     /*  38790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  38794 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38801 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38808 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38808 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_t16_e64),
     /*  38811 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38813 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38818 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38823 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38828 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38833 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38839 */     GIR_RootConstrainSelectedInstOperands,
     /*  38840 */     // GIR_Coverage, 1109,
     /*  38840 */     GIR_EraseRootFromParent_Done,
     /*  38841 */   // Label 320: @38841
     /*  38841 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(38900), // Rule ID 1110 //
     /*  38846 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts_isGFX10Plus),
     /*  38849 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38853 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38860 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  38867 */     // (sub:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_SUB_NC_U16_fake16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  38867 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_NC_U16_fake16_e64),
     /*  38870 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38872 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  38877 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  38882 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  38887 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  38892 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38895 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38898 */     GIR_RootConstrainSelectedInstOperands,
     /*  38899 */     // GIR_Coverage, 1110,
     /*  38899 */     GIR_EraseRootFromParent_Done,
     /*  38900 */   // Label 321: @38900
     /*  38900 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(38926), // Rule ID 945 //
     /*  38905 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX8GFX9),
     /*  38908 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38912 */     // (sub:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_SUB_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  38912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U16_e64),
     /*  38915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38917 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38919 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38921 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  38924 */     GIR_RootConstrainSelectedInstOperands,
     /*  38925 */     // GIR_Coverage, 945,
     /*  38925 */     GIR_EraseRootFromParent_Done,
     /*  38926 */   // Label 322: @38926
     /*  38926 */   GIM_Reject,
     /*  38927 */ // Label 318: @38927
     /*  38927 */ GIM_Reject,
     /*  38928 */ // Label 309: @38928
     /*  38928 */ GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(39042),
     /*  38933 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  38936 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  38939 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(38973), // Rule ID 44 //
     /*  38944 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38948 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38952 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  38956 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14906),
     /*  38960 */     // (sub:{ *:[i32] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14906>>  =>  (S_SUB_I32:{ *:[i32] }:{ *:[i1] } SSrc_b32:{ *:[i32] }:$src0, SSrc_b32:{ *:[i32] }:$src1)
     /*  38960 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_I32),
     /*  38965 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  38971 */     GIR_RootConstrainSelectedInstOperands,
     /*  38972 */     // GIR_Coverage, 44,
     /*  38972 */     GIR_Done,
     /*  38973 */   // Label 324: @38973
     /*  38973 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(39003), // Rule ID 2592 //
     /*  38978 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAddNoCarryInsts),
     /*  38981 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  38985 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21290),
     /*  38989 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_21290>>  =>  (V_SUB_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  38989 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U32_e64),
     /*  38992 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  38994 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  38996 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  38998 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39001 */     GIR_RootConstrainSelectedInstOperands,
     /*  39002 */     // GIR_Coverage, 2592,
     /*  39002 */     GIR_EraseRootFromParent_Done,
     /*  39003 */   // Label 325: @39003
     /*  39003 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(39041), // Rule ID 2594 //
     /*  39008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX6GFX7GFX8GFX9),
     /*  39011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39015 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21290),
     /*  39019 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_21290>>  =>  (V_SUB_CO_U32_e64:{ *:[i32] }:{ *:[i1] } ?:{ *:[i32] }:$src0, ?:{ *:[i32] }:$src1, 0:{ *:[i1] })
     /*  39019 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s1,
     /*  39022 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_CO_U32_e64),
     /*  39025 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39027 */     GIR_AddTempRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define|RegState::Dead),
     /*  39032 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39034 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39036 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39039 */     GIR_RootConstrainSelectedInstOperands,
     /*  39040 */     // GIR_Coverage, 2594,
     /*  39040 */     GIR_EraseRootFromParent_Done,
     /*  39041 */   // Label 326: @39041
     /*  39041 */   GIM_Reject,
     /*  39042 */ // Label 323: @39042
     /*  39042 */ GIM_Reject,
     /*  39043 */ // Label 310: @39043
     /*  39043 */ GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(39111),
     /*  39048 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  39051 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  39054 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(39084), // Rule ID 1427 //
     /*  39059 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39063 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21290),
     /*  39067 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_21290>>  =>  (V_SUB_U64_PSEUDO:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39067 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_SUB_U64_PSEUDO),
     /*  39072 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::VCC), GIMT_Encode2(RegState::Dead),
     /*  39078 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39082 */     GIR_RootConstrainSelectedInstOperands,
     /*  39083 */     // GIR_Coverage, 1427,
     /*  39083 */     GIR_Done,
     /*  39084 */   // Label 328: @39084
     /*  39084 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(39110), // Rule ID 1429 //
     /*  39089 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39093 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14906),
     /*  39097 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_14906>>  =>  (S_SUB_U64_PSEUDO:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39097 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_SUB_U64_PSEUDO),
     /*  39102 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39108 */     GIR_RootConstrainSelectedInstOperands,
     /*  39109 */     // GIR_Coverage, 1429,
     /*  39109 */     GIR_Done,
     /*  39110 */   // Label 329: @39110
     /*  39110 */   GIM_Reject,
     /*  39111 */ // Label 327: @39111
     /*  39111 */ GIM_Reject,
     /*  39112 */ // Label 311: @39112
     /*  39112 */ GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(39183), // Rule ID 1185 //
     /*  39117 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39120 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39123 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39127 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39134 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39141 */   // (sub:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_SUB_I16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  39141 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_SUB_I16),
     /*  39144 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39146 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39151 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39156 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39161 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39166 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39169 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39172 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39175 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39178 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39181 */   GIR_RootConstrainSelectedInstOperands,
     /*  39182 */   // GIR_Coverage, 1185,
     /*  39182 */   GIR_EraseRootFromParent_Done,
     /*  39183 */ // Label 330: @39183
     /*  39183 */ GIM_Reject,
     /*  39184 */ // Label 312: @39184
     /*  39184 */ GIM_Reject,
     /*  39185 */ // Label 2: @39185
     /*  39185 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(8), GIMT_Encode2(12), /*)*//*default:*//*Label 335*/ GIMT_Encode4(39622),
     /*  39196 */ /*GILLT_s16*//*Label 331*/ GIMT_Encode4(39212),
     /*  39200 */ /*GILLT_s32*//*Label 332*/ GIMT_Encode4(39386),
     /*  39204 */ /*GILLT_s64*//*Label 333*/ GIMT_Encode4(39487),
     /*  39208 */ /*GILLT_v2s16*//*Label 334*/ GIMT_Encode4(39550),
     /*  39212 */ // Label 331: @39212
     /*  39212 */ GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(39385),
     /*  39217 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  39220 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  39223 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(39282), // Rule ID 907 //
     /*  39228 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts_isGFX10Only),
     /*  39231 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39235 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39242 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opsel),
     /*  39249 */     // (mul:{ *:[i16] } (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSel:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_opsel_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39249 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_opsel_e64),
     /*  39252 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39254 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39259 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39264 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39269 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39277 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39280 */     GIR_RootConstrainSelectedInstOperands,
     /*  39281 */     // GIR_Coverage, 907,
     /*  39281 */     GIR_EraseRootFromParent_Done,
     /*  39282 */   // Label 337: @39282
     /*  39282 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(39338), // Rule ID 908 //
     /*  39287 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseRealTrue16Insts),
     /*  39290 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  39294 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39301 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39308 */     // (mul:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_MUL_LO_U16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39308 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_t16_e64),
     /*  39311 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39313 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39318 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39323 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39328 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39336 */     GIR_RootConstrainSelectedInstOperands,
     /*  39337 */     // GIR_Coverage, 908,
     /*  39337 */     GIR_EraseRootFromParent_Done,
     /*  39338 */   // Label 338: @39338
     /*  39338 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(39361), // Rule ID 906 //
     /*  39343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has16BitInsts_NotHasTrue16BitInsts),
     /*  39346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39350 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39350 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_e64),
     /*  39355 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39359 */     GIR_RootConstrainSelectedInstOperands,
     /*  39360 */     // GIR_Coverage, 906,
     /*  39360 */     GIR_Done,
     /*  39361 */   // Label 339: @39361
     /*  39361 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(39384), // Rule ID 909 //
     /*  39366 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  39369 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39373 */     // (mul:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_MUL_LO_U16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39373 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U16_fake16_e64),
     /*  39378 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39382 */     GIR_RootConstrainSelectedInstOperands,
     /*  39383 */     // GIR_Coverage, 909,
     /*  39383 */     GIR_Done,
     /*  39384 */   // Label 340: @39384
     /*  39384 */   GIM_Reject,
     /*  39385 */ // Label 336: @39385
     /*  39385 */ GIM_Reject,
     /*  39386 */ // Label 332: @39386
     /*  39386 */ GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(39486),
     /*  39391 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  39394 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  39397 */   GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(39417), // Rule ID 81 //
     /*  39402 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39406 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14913),
     /*  39410 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14913>>  =>  (S_MUL_I32:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39410 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_I32),
     /*  39415 */     GIR_RootConstrainSelectedInstOperands,
     /*  39416 */     // GIR_Coverage, 81,
     /*  39416 */     GIR_Done,
     /*  39417 */   // Label 342: @39417
     /*  39417 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(39451), // Rule ID 973 //
     /*  39422 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39426 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21220),
     /*  39430 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  39437 */     // (mul:{ *:[i32] } (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0), i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_21220>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39437 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  39440 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39442 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39447 */     GIR_RootToRootCopy, /*OpIdx*/2, // src1
     /*  39449 */     GIR_RootConstrainSelectedInstOperands,
     /*  39450 */     // GIR_Coverage, 973,
     /*  39450 */     GIR_EraseRootFromParent_Done,
     /*  39451 */   // Label 343: @39451
     /*  39451 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(39485), // Rule ID 9230 //
     /*  39456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39460 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21220),
     /*  39464 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3mods0),
     /*  39471 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$src1, (VOP3Mods0:{ *:[i32] } i32:{ *:[i32] }:$src0))<<P:Predicate_anonymous_21220>>  =>  (V_MUL_LO_U32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  39471 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_LO_U32_e64),
     /*  39474 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39476 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39481 */     GIR_RootToRootCopy, /*OpIdx*/1, // src1
     /*  39483 */     GIR_RootConstrainSelectedInstOperands,
     /*  39484 */     // GIR_Coverage, 9230,
     /*  39484 */     GIR_EraseRootFromParent_Done,
     /*  39485 */   // Label 344: @39485
     /*  39485 */   GIM_Reject,
     /*  39486 */ // Label 341: @39486
     /*  39486 */ GIM_Reject,
     /*  39487 */ // Label 333: @39487
     /*  39487 */ GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(39549),
     /*  39492 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  39495 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  39498 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(39521), // Rule ID 51 //
     /*  39503 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX12Plus),
     /*  39506 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39510 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14913),
     /*  39514 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_14913>>  =>  (S_MUL_U64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39514 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_MUL_U64),
     /*  39519 */     GIR_RootConstrainSelectedInstOperands,
     /*  39520 */     // GIR_Coverage, 51,
     /*  39520 */     GIR_Done,
     /*  39521 */   // Label 346: @39521
     /*  39521 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(39548), // Rule ID 840 //
     /*  39526 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX1250Plus),
     /*  39529 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VReg_64RegClassID),
     /*  39533 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21220),
     /*  39537 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_21220>>  =>  (V_MUL_U64_e64:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  39537 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_MUL_U64_e64),
     /*  39542 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39546 */     GIR_RootConstrainSelectedInstOperands,
     /*  39547 */     // GIR_Coverage, 840,
     /*  39547 */     GIR_Done,
     /*  39548 */   // Label 347: @39548
     /*  39548 */   GIM_Reject,
     /*  39549 */ // Label 345: @39549
     /*  39549 */ GIM_Reject,
     /*  39550 */ // Label 334: @39550
     /*  39550 */ GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(39621), // Rule ID 1178 //
     /*  39555 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  39558 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  39561 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39565 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39572 */   GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3pmods),
     /*  39579 */   // (mul:{ *:[v2i16] } (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3PMods:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_PK_MUL_LO_U16:{ *:[v2i16] } i32:{ *:[i32] }:$src0_modifiers, v2i16:{ *:[v2i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, v2i16:{ *:[v2i16] }:$src1)
     /*  39579 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_PK_MUL_LO_U16),
     /*  39582 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39584 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39589 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39594 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39599 */   GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39604 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39607 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39610 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39613 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39616 */   GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39619 */   GIR_RootConstrainSelectedInstOperands,
     /*  39620 */   // GIR_Coverage, 1178,
     /*  39620 */   GIR_EraseRootFromParent_Done,
     /*  39621 */ // Label 348: @39621
     /*  39621 */ GIM_Reject,
     /*  39622 */ // Label 335: @39622
     /*  39622 */ GIM_Reject,
     /*  39623 */ // Label 3: @39623
     /*  39623 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 356*/ GIMT_Encode4(41023),
     /*  39634 */ /*GILLT_s1*//*Label 349*/ GIMT_Encode4(39674),
     /*  39638 */ /*GILLT_s16*//*Label 350*/ GIMT_Encode4(39737),
     /*  39642 */ /*GILLT_s32*//*Label 351*/ GIMT_Encode4(39977),
     /*  39646 */ /*GILLT_s64*//*Label 352*/ GIMT_Encode4(40501),
     /*  39650 */ /*GILLT_v2s16*//*Label 353*/ GIMT_Encode4(40626),
     /*  39654 */ /*GILLT_v2s32*//*Label 354*/ GIMT_Encode4(40777), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  39670 */ /*GILLT_v4s16*//*Label 355*/ GIMT_Encode4(40900),
     /*  39674 */ // Label 349: @39674
     /*  39674 */ GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(39736),
     /*  39679 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  39682 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  39685 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(39710), // Rule ID 8155 //
     /*  39690 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  39693 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  39697 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39697 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  39702 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39708 */     GIR_RootConstrainSelectedInstOperands,
     /*  39709 */     // GIR_Coverage, 8155,
     /*  39709 */     GIR_Done,
     /*  39710 */   // Label 358: @39710
     /*  39710 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(39735), // Rule ID 8162 //
     /*  39715 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  39718 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39722 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_AND_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  39722 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  39727 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  39733 */     GIR_RootConstrainSelectedInstOperands,
     /*  39734 */     // GIR_Coverage, 8162,
     /*  39734 */     GIR_Done,
     /*  39735 */   // Label 359: @39735
     /*  39735 */   GIM_Reject,
     /*  39736 */ // Label 357: @39736
     /*  39736 */ GIM_Reject,
     /*  39737 */ // Label 350: @39737
     /*  39737 */ GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(39976),
     /*  39742 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  39745 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  39748 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(39799), // Rule ID 9246 //
     /*  39753 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39757 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  39761 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39765 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  39769 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  39773 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  39777 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  39781 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39783 */     // (and:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  39783 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39786 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39788 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  39790 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39794 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39797 */     GIR_RootConstrainSelectedInstOperands,
     /*  39798 */     // GIR_Coverage, 9246,
     /*  39798 */     GIR_EraseRootFromParent_Done,
     /*  39799 */   // Label 361: @39799
     /*  39799 */   GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(39850), // Rule ID 1972 //
     /*  39804 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  39808 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  39812 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  39816 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  39820 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  39824 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  39828 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  39832 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  39834 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  39834 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  39837 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  39839 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  39841 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  39845 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  39848 */     GIR_RootConstrainSelectedInstOperands,
     /*  39849 */     // GIR_Coverage, 1972,
     /*  39849 */     GIR_EraseRootFromParent_Done,
     /*  39850 */   // Label 362: @39850
     /*  39850 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(39873), // Rule ID 2621 //
     /*  39855 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  39858 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39862 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  39862 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  39867 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39871 */     GIR_RootConstrainSelectedInstOperands,
     /*  39872 */     // GIR_Coverage, 2621,
     /*  39872 */     GIR_Done,
     /*  39873 */   // Label 363: @39873
     /*  39873 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(39896), // Rule ID 2624 //
     /*  39878 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  39881 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39885 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  39885 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  39890 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39894 */     GIR_RootConstrainSelectedInstOperands,
     /*  39895 */     // GIR_Coverage, 2624,
     /*  39895 */     GIR_Done,
     /*  39896 */   // Label 364: @39896
     /*  39896 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(39952), // Rule ID 938 //
     /*  39901 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  39904 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  39908 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39915 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  39922 */     // (and:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_AND_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  39922 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_t16_e64),
     /*  39925 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  39927 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  39932 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  39937 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  39942 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  39947 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  39950 */     GIR_RootConstrainSelectedInstOperands,
     /*  39951 */     // GIR_Coverage, 938,
     /*  39951 */     GIR_EraseRootFromParent_Done,
     /*  39952 */   // Label 365: @39952
     /*  39952 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(39975), // Rule ID 939 //
     /*  39957 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  39960 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39964 */     // (and:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_AND_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  39964 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B16_fake16_e64),
     /*  39969 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  39973 */     GIR_RootConstrainSelectedInstOperands,
     /*  39974 */     // GIR_Coverage, 939,
     /*  39974 */     GIR_Done,
     /*  39975 */   // Label 366: @39975
     /*  39975 */   GIM_Reject,
     /*  39976 */ // Label 360: @39976
     /*  39976 */ GIM_Reject,
     /*  39977 */ // Label 351: @39977
     /*  39977 */ GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(40500),
     /*  39982 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  39985 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  39988 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(40063), // Rule ID 11976 //
     /*  39993 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  39997 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40001 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  40005 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40009 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40013 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40015 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40019 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40023 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40027 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40031 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  40033 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  40037 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40041 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21298),
     /*  40045 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40047 */     // (and:{ *:[i32] } (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_21298>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  40047 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  40050 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40052 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  40054 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40057 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  40061 */     GIR_RootConstrainSelectedInstOperands,
     /*  40062 */     // GIR_Coverage, 11976,
     /*  40062 */     GIR_EraseRootFromParent_Done,
     /*  40063 */   // Label 368: @40063
     /*  40063 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(40138), // Rule ID 11977 //
     /*  40068 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40072 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40076 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40080 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40084 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40088 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40090 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40094 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40098 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40102 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40106 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  40108 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  40112 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40116 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21298),
     /*  40120 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40122 */     // (and:{ *:[i32] } (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>, i32:{ *:[i32] }:$src)<<P:Predicate_anonymous_21298>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  40122 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  40125 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40127 */     GIR_RootToRootCopy, /*OpIdx*/2, // src
     /*  40129 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40132 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  40136 */     GIR_RootConstrainSelectedInstOperands,
     /*  40137 */     // GIR_Coverage, 11977,
     /*  40137 */     GIR_EraseRootFromParent_Done,
     /*  40138 */   // Label 369: @40138
     /*  40138 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(40213), // Rule ID 8328 //
     /*  40143 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40147 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40151 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  40155 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40159 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40163 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40165 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40169 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40173 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40177 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40181 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  40183 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 1,
     /*  40187 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40191 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21298),
     /*  40195 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40197 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (add:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_add_oneuse>>)<<P:Predicate_anonymous_21298>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  40197 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  40200 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40202 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  40204 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40207 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  40211 */     GIR_RootConstrainSelectedInstOperands,
     /*  40212 */     // GIR_Coverage, 8328,
     /*  40212 */     GIR_EraseRootFromParent_Done,
     /*  40213 */   // Label 370: @40213
     /*  40213 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(40288), // Rule ID 8329 //
     /*  40218 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40222 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40226 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40230 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40234 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40238 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  40240 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  40244 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  40248 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  40252 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  40256 */     GIM_CheckHasOneUse, /*MI*/2,
     /*  40258 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/1, 255,
     /*  40262 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40266 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21298),
     /*  40270 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40272 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src, (xor:{ *:[i32] } (shl:{ *:[i32] } -1:{ *:[i32] }, i32:{ *:[i32] }:$width)<<P:Predicate_shl_oneuse>>, -1:{ *:[i32] })<<P:Predicate_xor_oneuse>>)<<P:Predicate_anonymous_21298>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, 0:{ *:[i32] }, ?:{ *:[i32] }:$width)
     /*  40272 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  40275 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40277 */     GIR_RootToRootCopy, /*OpIdx*/1, // src
     /*  40279 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  40282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // width
     /*  40286 */     GIR_RootConstrainSelectedInstOperands,
     /*  40287 */     // GIR_Coverage, 8329,
     /*  40287 */     GIR_EraseRootFromParent_Done,
     /*  40288 */   // Label 371: @40288
     /*  40288 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(40339), // Rule ID 9171 //
     /*  40293 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40297 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40301 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40305 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40309 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40313 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40317 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40321 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40323 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40323 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40326 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40328 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40330 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40334 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40337 */     GIR_RootConstrainSelectedInstOperands,
     /*  40338 */     // GIR_Coverage, 9171,
     /*  40338 */     GIR_EraseRootFromParent_Done,
     /*  40339 */   // Label 372: @40339
     /*  40339 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(40390), // Rule ID 64 //
     /*  40344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40356 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40360 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40364 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40368 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40372 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40374 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40374 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40377 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40379 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40381 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40385 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40388 */     GIR_RootConstrainSelectedInstOperands,
     /*  40389 */     // GIR_Coverage, 64,
     /*  40389 */     GIR_EraseRootFromParent_Done,
     /*  40390 */   // Label 373: @40390
     /*  40390 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(40453), // Rule ID 8327 //
     /*  40395 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40399 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40403 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /*  40407 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  40411 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  40415 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  40419 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  40423 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_IMMZeroBasedBitfieldMask),
     /*  40427 */     // MIs[2] Operand 1
     /*  40427 */     // No operand predicates
     /*  40427 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21298),
     /*  40431 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40433 */     // (and:{ *:[i32] } (srl:{ *:[i32] } i32:{ *:[i32] }:$src, i32:{ *:[i32] }:$rshift), (imm:{ *:[i32] })<<P:Predicate_IMMZeroBasedBitfieldMask>>:$mask)<<P:Predicate_anonymous_21298>>  =>  (V_BFE_U32_e64:{ *:[i32] } ?:{ *:[i32] }:$src, ?:{ *:[i32] }:$rshift, (IMMPopCount:{ *:[i32] } ?:{ *:[i32] }:$mask))
     /*  40433 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFE_U32_e64),
     /*  40436 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  40438 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  40442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rshift
     /*  40446 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/2, /*Renderer*/GIMT_Encode2(GICR_renderPopcntImm), // mask
     /*  40451 */     GIR_RootConstrainSelectedInstOperands,
     /*  40452 */     // GIR_Coverage, 8327,
     /*  40452 */     GIR_EraseRootFromParent_Done,
     /*  40453 */   // Label 374: @40453
     /*  40453 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(40479), // Rule ID 52 //
     /*  40458 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40462 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40466 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)<<P:Predicate_anonymous_14914>>  =>  (S_AND_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40466 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B32),
     /*  40471 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40477 */     GIR_RootConstrainSelectedInstOperands,
     /*  40478 */     // GIR_Coverage, 52,
     /*  40478 */     GIR_Done,
     /*  40479 */   // Label 375: @40479
     /*  40479 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(40499), // Rule ID 837 //
     /*  40484 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40488 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)  =>  (V_AND_B32_e64:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  40488 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40493 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40497 */     GIR_RootConstrainSelectedInstOperands,
     /*  40498 */     // GIR_Coverage, 837,
     /*  40498 */     GIR_Done,
     /*  40499 */   // Label 376: @40499
     /*  40499 */   GIM_Reject,
     /*  40500 */ // Label 367: @40500
     /*  40500 */ GIM_Reject,
     /*  40501 */ // Label 352: @40501
     /*  40501 */ GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(40625),
     /*  40506 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  40509 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  40512 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40516 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40520 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(40563), // Rule ID 9172 //
     /*  40525 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40529 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40533 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  40537 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  40541 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40545 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40547 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }), i64:{ *:[i64] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40547 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40550 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40552 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40558 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40561 */     GIR_RootConstrainSelectedInstOperands,
     /*  40562 */     // GIR_Coverage, 9172,
     /*  40562 */     GIR_EraseRootFromParent_Done,
     /*  40563 */   // Label 378: @40563
     /*  40563 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(40606), // Rule ID 65 //
     /*  40568 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40572 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40576 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  40580 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  40584 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  40588 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  40590 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, (xor:{ *:[i64] } i64:{ *:[i64] }:$src1, -1:{ *:[i64] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40590 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40593 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40595 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40597 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40601 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40604 */     GIR_RootConstrainSelectedInstOperands,
     /*  40605 */     // GIR_Coverage, 65,
     /*  40605 */     GIR_EraseRootFromParent_Done,
     /*  40606 */   // Label 379: @40606
     /*  40606 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(40624), // Rule ID 53 //
     /*  40611 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)<<P:Predicate_anonymous_14914>>  =>  (S_AND_B64:{ *:[i64] }:{ *:[i1] } i64:{ *:[i64] }:$src0, i64:{ *:[i64] }:$src1)
     /*  40611 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_AND_B64),
     /*  40616 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  40622 */     GIR_RootConstrainSelectedInstOperands,
     /*  40623 */     // GIR_Coverage, 53,
     /*  40623 */     GIR_Done,
     /*  40624 */   // Label 380: @40624
     /*  40624 */   GIM_Reject,
     /*  40625 */ // Label 377: @40625
     /*  40625 */ GIM_Reject,
     /*  40626 */ // Label 353: @40626
     /*  40626 */ GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(40776),
     /*  40631 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40634 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40637 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(40696), // Rule ID 9247 //
     /*  40642 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40646 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40650 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40654 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40658 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40662 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40666 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40672 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40674 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40678 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40680 */     // (and:{ *:[v2i16] } (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }), v2i16:{ *:[v2i16] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  40680 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40683 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40685 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40687 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40691 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40694 */     GIR_RootConstrainSelectedInstOperands,
     /*  40695 */     // GIR_Coverage, 9247,
     /*  40695 */     GIR_EraseRootFromParent_Done,
     /*  40696 */   // Label 382: @40696
     /*  40696 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(40755), // Rule ID 1973 //
     /*  40701 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  40705 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40709 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40713 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s16,
     /*  40717 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s16,
     /*  40721 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40725 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40731 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40733 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40737 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40739 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, (xor:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src1, immAllOnesV:{ *:[v2i16] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B32:{ *:[v2i16] }:{ *:[i1] } SSrc_b32:{ *:[v2i16] }:$src0, SSrc_b32:{ *:[v2i16] }:$src1)
     /*  40739 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B32),
     /*  40742 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40744 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40746 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40750 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40753 */     GIR_RootConstrainSelectedInstOperands,
     /*  40754 */     // GIR_Coverage, 1973,
     /*  40754 */     GIR_EraseRootFromParent_Done,
     /*  40755 */   // Label 383: @40755
     /*  40755 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(40775), // Rule ID 2627 //
     /*  40760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  40764 */     // (and:{ *:[v2i16] } v2i16:{ *:[v2i16] }:$src0, v2i16:{ *:[v2i16] }:$src1)  =>  (V_AND_B32_e64:{ *:[v2i16] } VSrc_b32:{ *:[v2i16] }:$src0, VSrc_b32:{ *:[v2i16] }:$src1)
     /*  40764 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_AND_B32_e64),
     /*  40769 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  40773 */     GIR_RootConstrainSelectedInstOperands,
     /*  40774 */     // GIR_Coverage, 2627,
     /*  40774 */     GIR_Done,
     /*  40775 */   // Label 384: @40775
     /*  40775 */   GIM_Reject,
     /*  40776 */ // Label 381: @40776
     /*  40776 */ GIM_Reject,
     /*  40777 */ // Label 354: @40777
     /*  40777 */ GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(40899),
     /*  40782 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40785 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40788 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40792 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40796 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(40847), // Rule ID 9249 //
     /*  40801 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40805 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40809 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40813 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40817 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40821 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40827 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40829 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40831 */     // (and:{ *:[v2i32] } (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }), v2i32:{ *:[v2i32] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  40831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40836 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40842 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40845 */     GIR_RootConstrainSelectedInstOperands,
     /*  40846 */     // GIR_Coverage, 9249,
     /*  40846 */     GIR_EraseRootFromParent_Done,
     /*  40847 */   // Label 386: @40847
     /*  40847 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(40898), // Rule ID 1975 //
     /*  40852 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40856 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40860 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
     /*  40864 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
     /*  40868 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40872 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40878 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40880 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40882 */     // (and:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src0, (xor:{ *:[v2i32] } v2i32:{ *:[v2i32] }:$src1, immAllOnesV:{ *:[v2i32] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[v2i32] }:{ *:[i1] } SSrc_b64:{ *:[v2i32] }:$src0, SSrc_b64:{ *:[v2i32] }:$src1)
     /*  40882 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40885 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40887 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  40889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40893 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40896 */     GIR_RootConstrainSelectedInstOperands,
     /*  40897 */     // GIR_Coverage, 1975,
     /*  40897 */     GIR_EraseRootFromParent_Done,
     /*  40898 */   // Label 387: @40898
     /*  40898 */   GIM_Reject,
     /*  40899 */ // Label 385: @40899
     /*  40899 */ GIM_Reject,
     /*  40900 */ // Label 355: @40900
     /*  40900 */ GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(41022),
     /*  40905 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40908 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40911 */   GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14914),
     /*  40915 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  40919 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(40970), // Rule ID 9248 //
     /*  40924 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  40928 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40932 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40936 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40940 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40944 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  40950 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  40952 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  40954 */     // (and:{ *:[v4i16] } (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }), v4i16:{ *:[v4i16] }:$src0)<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  40954 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  40957 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  40959 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  40961 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  40965 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  40968 */     GIR_RootConstrainSelectedInstOperands,
     /*  40969 */     // GIR_Coverage, 9248,
     /*  40969 */     GIR_EraseRootFromParent_Done,
     /*  40970 */   // Label 389: @40970
     /*  40970 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(41021), // Rule ID 1974 //
     /*  40975 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  40979 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  40983 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
     /*  40987 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
     /*  40991 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  40995 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  41001 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*  41003 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*  41005 */     // (and:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src0, (xor:{ *:[v4i16] } v4i16:{ *:[v4i16] }:$src1, immAllOnesV:{ *:[v4i16] }))<<P:Predicate_anonymous_14914>>  =>  (S_ANDN2_B64:{ *:[v4i16] }:{ *:[i1] } SSrc_b64:{ *:[v4i16] }:$src0, SSrc_b64:{ *:[v4i16] }:$src1)
     /*  41005 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ANDN2_B64),
     /*  41008 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41010 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  41012 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41016 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41019 */     GIR_RootConstrainSelectedInstOperands,
     /*  41020 */     // GIR_Coverage, 1974,
     /*  41020 */     GIR_EraseRootFromParent_Done,
     /*  41021 */   // Label 390: @41021
     /*  41021 */   GIM_Reject,
     /*  41022 */ // Label 388: @41022
     /*  41022 */ GIM_Reject,
     /*  41023 */ // Label 356: @41023
     /*  41023 */ GIM_Reject,
     /*  41024 */ // Label 4: @41024
     /*  41024 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(7), GIMT_Encode2(17), /*)*//*default:*//*Label 398*/ GIMT_Encode4(56535),
     /*  41035 */ /*GILLT_s1*//*Label 391*/ GIMT_Encode4(41075),
     /*  41039 */ /*GILLT_s16*//*Label 392*/ GIMT_Encode4(41138),
     /*  41043 */ /*GILLT_s32*//*Label 393*/ GIMT_Encode4(41378),
     /*  41047 */ /*GILLT_s64*//*Label 394*/ GIMT_Encode4(46949),
     /*  41051 */ /*GILLT_v2s16*//*Label 395*/ GIMT_Encode4(56138),
     /*  41055 */ /*GILLT_v2s32*//*Label 396*/ GIMT_Encode4(56289), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*  41071 */ /*GILLT_v4s16*//*Label 397*/ GIMT_Encode4(56412),
     /*  41075 */ // Label 391: @41075
     /*  41075 */ GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(41137),
     /*  41080 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*  41083 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*  41086 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(41111), // Rule ID 8156 //
     /*  41091 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave64),
     /*  41094 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_64RegClassID),
     /*  41098 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B64:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  41098 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B64),
     /*  41103 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  41109 */     GIR_RootConstrainSelectedInstOperands,
     /*  41110 */     // GIR_Coverage, 8156,
     /*  41110 */     GIR_Done,
     /*  41111 */   // Label 400: @41111
     /*  41111 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(41136), // Rule ID 8163 //
     /*  41116 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isWave32),
     /*  41119 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41123 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$src0, i1:{ *:[i1] }:$src1)  =>  (S_OR_B32:{ *:[i1] }:{ *:[i1] } ?:{ *:[i1] }:$src0, ?:{ *:[i1] }:$src1)
     /*  41123 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::S_OR_B32),
     /*  41128 */     GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(AMDGPU::SCC), GIMT_Encode2(RegState::Dead),
     /*  41134 */     GIR_RootConstrainSelectedInstOperands,
     /*  41135 */     // GIR_Coverage, 8163,
     /*  41135 */     GIR_Done,
     /*  41136 */   // Label 401: @41136
     /*  41136 */   GIM_Reject,
     /*  41137 */ // Label 399: @41137
     /*  41137 */ GIM_Reject,
     /*  41138 */ // Label 392: @41138
     /*  41138 */ GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(41377),
     /*  41143 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
     /*  41146 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
     /*  41149 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(41200), // Rule ID 9250 //
     /*  41154 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41158 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41162 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41166 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  41170 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  41174 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41178 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14915),
     /*  41182 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41184 */     // (or:{ *:[i16] } (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }), i16:{ *:[i16] }:$src0)<<P:Predicate_anonymous_14915>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  41184 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  41187 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41189 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  41191 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41195 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41198 */     GIR_RootConstrainSelectedInstOperands,
     /*  41199 */     // GIR_Coverage, 9250,
     /*  41199 */     GIR_EraseRootFromParent_Done,
     /*  41200 */   // Label 403: @41200
     /*  41200 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(41251), // Rule ID 1976 //
     /*  41205 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  41209 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  41213 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  41217 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
     /*  41221 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s16,
     /*  41225 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  41229 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14915),
     /*  41233 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  41235 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, (xor:{ *:[i16] } i16:{ *:[i16] }:$src1, -1:{ *:[i16] }))<<P:Predicate_anonymous_14915>>  =>  (S_ORN2_B32:{ *:[i16] }:{ *:[i1] } SSrc_b32:{ *:[i16] }:$src0, SSrc_b32:{ *:[i16] }:$src1)
     /*  41235 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  41238 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  41240 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  41242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  41246 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  41249 */     GIR_RootConstrainSelectedInstOperands,
     /*  41250 */     // GIR_Coverage, 1976,
     /*  41250 */     GIR_EraseRootFromParent_Done,
     /*  41251 */   // Label 404: @41251
     /*  41251 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(41274), // Rule ID 2622 //
     /*  41256 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_NotHasTrue16BitInsts),
     /*  41259 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41263 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  41263 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  41268 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  41272 */     GIR_RootConstrainSelectedInstOperands,
     /*  41273 */     // GIR_Coverage, 2622,
     /*  41273 */     GIR_Done,
     /*  41274 */   // Label 405: @41274
     /*  41274 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(41297), // Rule ID 2625 //
     /*  41279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseFakeTrue16Insts),
     /*  41282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41286 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B32_e64:{ *:[i16] } VSrc_b32:{ *:[i16] }:$src0, VSrc_b32:{ *:[i16] }:$src1)
     /*  41286 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B32_e64),
     /*  41291 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  41295 */     GIR_RootConstrainSelectedInstOperands,
     /*  41296 */     // GIR_Coverage, 2625,
     /*  41296 */     GIR_Done,
     /*  41297 */   // Label 406: @41297
     /*  41297 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(41353), // Rule ID 940 //
     /*  41302 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  41305 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_16RegClassID),
     /*  41309 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  41316 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(1), GIMT_Encode2(GICP_gi_vop3opselmods),
     /*  41323 */     // (or:{ *:[i16] } (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src0_modifiers), (VOP3OpSelMods:{ *:[i16] } i16:{ *:[i16] }:$src1, i32:{ *:[i32] }:$src1_modifiers))  =>  (V_OR_B16_t16_e64:{ *:[i16] } i32:{ *:[i32] }:$src0_modifiers, i16:{ *:[i16] }:$src0, i32:{ *:[i32] }:$src1_modifiers, i16:{ *:[i16] }:$src1)
     /*  41323 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_t16_e64),
     /*  41326 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41328 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/1, // src0_modifiers
     /*  41333 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), /*SubOperand*/0, // src0
     /*  41338 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/1, // src1_modifiers
     /*  41343 */     GIR_ComplexSubOperandRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(1), /*SubOperand*/0, // src1
     /*  41348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41351 */     GIR_RootConstrainSelectedInstOperands,
     /*  41352 */     // GIR_Coverage, 940,
     /*  41352 */     GIR_EraseRootFromParent_Done,
     /*  41353 */   // Label 407: @41353
     /*  41353 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(41376), // Rule ID 941 //
     /*  41358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX11Plus),
     /*  41361 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41365 */     // (or:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)  =>  (V_OR_B16_fake16_e64:{ *:[i16] } i16:{ *:[i16] }:$src0, i16:{ *:[i16] }:$src1)
     /*  41365 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(AMDGPU::V_OR_B16_fake16_e64),
     /*  41370 */     GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(AMDGPU::EXEC),
     /*  41374 */     GIR_RootConstrainSelectedInstOperands,
     /*  41375 */     // GIR_Coverage, 941,
     /*  41375 */     GIR_Done,
     /*  41376 */   // Label 408: @41376
     /*  41376 */   GIM_Reject,
     /*  41377 */ // Label 402: @41377
     /*  41377 */ GIM_Reject,
     /*  41378 */ // Label 393: @41378
     /*  41378 */ GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(46948),
     /*  41383 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*  41386 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*  41389 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(41570), // Rule ID 9285 //
     /*  41394 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41397 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41413 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41417 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41421 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41425 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41429 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41433 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  41437 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  41441 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41445 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41449 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41453 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  41457 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  41461 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
     /*  41472 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  41476 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41480 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  41484 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  41488 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  41492 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41496 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  41500 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  41504 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  41508 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  41512 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41516 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  41520 */     // MIs[6] src2
     /*  41520 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  41525 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  41529 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  41533 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
     /*  41537 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  41539 */     // (or:{ *:[i32] } (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41539 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  41542 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41544 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41547 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src0
     /*  41551 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src1
     /*  41558 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41561 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  41565 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41568 */     GIR_RootConstrainSelectedInstOperands,
     /*  41569 */     // GIR_Coverage, 9285,
     /*  41569 */     GIR_EraseRootFromParent_Done,
     /*  41570 */   // Label 410: @41570
     /*  41570 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(41751), // Rule ID 2839 //
     /*  41575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41582 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41586 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41590 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41594 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41598 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41602 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41606 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41610 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41614 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  41618 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  41622 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41626 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41630 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41634 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 128,
     /*  41638 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/3, 127,
     /*  41642 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  41646 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  41650 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
     /*  41654 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  41658 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  41662 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  41666 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41670 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  41674 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_s32,
     /*  41678 */     GIM_CheckType, /*MI*/5, /*Op*/3, /*Type*/GILLT_s32,
     /*  41682 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  41686 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41690 */     GIM_CheckType, /*MI*/6, /*Op*/1, /*Type*/GILLT_s32,
     /*  41694 */     // MIs[6] src2
     /*  41694 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  41699 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/2, 128,
     /*  41703 */     GIM_CheckConstantInt8, /*MI*/5, /*Op*/3, 127,
     /*  41707 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(255),
     /*  41718 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  41720 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 8:{ *:[i32] }), (and:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), -128:{ *:[i32] }, 127:{ *:[i32] }), 255:{ *:[i32] }))  =>  (V_ASHR_PK_I8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41720 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_I8_I32_e64),
     /*  41723 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41725 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/6, /*OpIdx*/1, // src0
     /*  41732 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41735 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  41739 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41742 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  41746 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41749 */     GIR_RootConstrainSelectedInstOperands,
     /*  41750 */     // GIR_Coverage, 2839,
     /*  41750 */     GIR_EraseRootFromParent_Done,
     /*  41751 */   // Label 411: @41751
     /*  41751 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(41919), // Rule ID 9286 //
     /*  41756 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41759 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41763 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41767 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41771 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41775 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41779 */     GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s32,
     /*  41783 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41787 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41791 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41795 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41799 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 0,
     /*  41803 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/3, GIMT_Encode8(255),
     /*  41814 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  41818 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41822 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41826 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41830 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  41834 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41838 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  41842 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  41846 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  41850 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  41854 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41858 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  41862 */     // MIs[5] src2
     /*  41862 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  41867 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  41871 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  41882 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
     /*  41886 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  41888 */     // (or:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  41888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  41891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  41893 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src0
     /*  41900 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41903 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src1
     /*  41907 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41910 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
     /*  41914 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  41917 */     GIR_RootConstrainSelectedInstOperands,
     /*  41918 */     // GIR_Coverage, 9286,
     /*  41918 */     GIR_EraseRootFromParent_Done,
     /*  41919 */   // Label 412: @41919
     /*  41919 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(42087), // Rule ID 2840 //
     /*  41924 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAshrPkInsts),
     /*  41927 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  41931 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  41935 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  41939 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  41943 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  41947 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  41951 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  41955 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  41959 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  41963 */     GIM_CheckType, /*MI*/2, /*Op*/3, /*Type*/GILLT_s32,
     /*  41967 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  41971 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  41975 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  41979 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  41983 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 0,
     /*  41987 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/3, GIMT_Encode8(255),
     /*  41998 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
     /*  42002 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
     /*  42006 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(AMDGPU::G_AMDGPU_SMED3),
     /*  42010 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
     /*  42014 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
     /*  42018 */     GIM_CheckType, /*MI*/4, /*Op*/3, /*Type*/GILLT_s32,
     /*  42022 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  42026 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  42030 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_s32,
     /*  42034 */     // MIs[5] src2
     /*  42034 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  42039 */     GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 0,
     /*  42043 */     GIM_CheckConstantInt, /*MI*/4, /*Op*/3, GIMT_Encode8(255),
     /*  42054 */     GIM_CheckIsSafeToFold, /*NumInsns*/5,
     /*  42056 */     // (or:{ *:[i32] } (shl:{ *:[i32] } (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src1, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }), 8:{ *:[i32] }), (AMDGPUsmed3:{ *:[i32] } (sra:{ *:[i32] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src2), 0:{ *:[i32] }, 255:{ *:[i32] }))  =>  (V_ASHR_PK_U8_I32_e64:{ *:[i32] } 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src0, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src1, 0:{ *:[i32] }, VSrc_b32:{ *:[i32] }:$src2, 0:{ *:[i32] })
     /*  42056 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_ASHR_PK_U8_I32_e64),
     /*  42059 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42061 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42064 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/5, /*OpIdx*/1, // src0
     /*  42068 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42071 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
     /*  42075 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // src2
     /*  42082 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
     /*  42085 */     GIR_RootConstrainSelectedInstOperands,
     /*  42086 */     // GIR_Coverage, 2840,
     /*  42086 */     GIR_EraseRootFromParent_Done,
     /*  42087 */   // Label 413: @42087
     /*  42087 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(42234), // Rule ID 11945 //
     /*  42092 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42096 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42100 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42104 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42108 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42112 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  42116 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42120 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42124 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42128 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  42132 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42136 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42140 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42144 */     // MIs[3] x
     /*  42144 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42149 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42153 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42155 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42155 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42158 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42162 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42167 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  42171 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42176 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42179 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42183 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42188 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  42192 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42197 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42200 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42204 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42209 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  42213 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42218 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42221 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42223 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42226 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42229 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42232 */     GIR_RootConstrainSelectedInstOperands,
     /*  42233 */     // GIR_Coverage, 11945,
     /*  42233 */     GIR_EraseRootFromParent_Done,
     /*  42234 */   // Label 414: @42234
     /*  42234 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(42381), // Rule ID 11944 //
     /*  42239 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42243 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42247 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42251 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42255 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42259 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  42263 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42267 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42271 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42275 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  42279 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42283 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42287 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  42291 */     // MIs[3] x
     /*  42291 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42296 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42300 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42302 */     // (or:{ *:[i32] } (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42302 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42305 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42309 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42314 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  42318 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42323 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42326 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42330 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42335 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  42339 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42344 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42347 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42351 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42356 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  42360 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42365 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42368 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42370 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42373 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42376 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42379 */     GIR_RootConstrainSelectedInstOperands,
     /*  42380 */     // GIR_Coverage, 11944,
     /*  42380 */     GIR_EraseRootFromParent_Done,
     /*  42381 */   // Label 415: @42381
     /*  42381 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(42528), // Rule ID 11943 //
     /*  42386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42390 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42394 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42398 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42402 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42406 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42410 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42414 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42418 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42422 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  42426 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42430 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42434 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42438 */     // MIs[3] x
     /*  42438 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42443 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42447 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42449 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42449 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42452 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42456 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42461 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  42465 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42470 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42473 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42477 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42482 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/2, // y
     /*  42486 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42491 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42494 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42498 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42503 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  42507 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42512 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42515 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42517 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42520 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42523 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42526 */     GIR_RootConstrainSelectedInstOperands,
     /*  42527 */     // GIR_Coverage, 11943,
     /*  42527 */     GIR_EraseRootFromParent_Done,
     /*  42528 */   // Label 416: @42528
     /*  42528 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(42675), // Rule ID 11942 //
     /*  42533 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42537 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42541 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42545 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42549 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42553 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  42557 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42561 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42565 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42569 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 255,
     /*  42573 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  42577 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42581 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
     /*  42585 */     // MIs[3] x
     /*  42585 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  42590 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42594 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42596 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })), (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42596 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42599 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42603 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42608 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  42612 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42617 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42620 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42624 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42629 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/3, /*OpIdx*/1, // y
     /*  42633 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42638 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42641 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42645 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42650 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  42654 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42664 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42667 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42670 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42673 */     GIR_RootConstrainSelectedInstOperands,
     /*  42674 */     // GIR_Coverage, 11942,
     /*  42674 */     GIR_EraseRootFromParent_Done,
     /*  42675 */   // Label 417: @42675
     /*  42675 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(42822), // Rule ID 11939 //
     /*  42680 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42684 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42688 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42692 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42696 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42700 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42704 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42708 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42712 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42716 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  42720 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42724 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42728 */     // MIs[3] x
     /*  42728 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  42733 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  42737 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42741 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42743 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42743 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42746 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42750 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42755 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  42759 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42764 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42767 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42771 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42776 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  42780 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42785 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42788 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42792 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42797 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  42801 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42806 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42809 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42811 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42814 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42817 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42820 */     GIR_RootConstrainSelectedInstOperands,
     /*  42821 */     // GIR_Coverage, 11939,
     /*  42821 */     GIR_EraseRootFromParent_Done,
     /*  42822 */   // Label 418: @42822
     /*  42822 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(42969), // Rule ID 11941 //
     /*  42827 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42831 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42835 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42839 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42843 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42847 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42851 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42855 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  42859 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  42863 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  42867 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  42871 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  42875 */     // MIs[3] x
     /*  42875 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  42880 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  42884 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  42888 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  42890 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] }), i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  42890 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  42893 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42897 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42902 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  42906 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42911 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  42914 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42918 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42923 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  42927 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42932 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  42935 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  42939 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  42944 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  42948 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42953 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  42956 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  42958 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  42961 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  42964 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  42967 */     GIR_RootConstrainSelectedInstOperands,
     /*  42968 */     // GIR_Coverage, 11941,
     /*  42968 */     GIR_EraseRootFromParent_Done,
     /*  42969 */   // Label 419: @42969
     /*  42969 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(43116), // Rule ID 8057 //
     /*  42974 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  42978 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  42982 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  42986 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  42990 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  42994 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  42998 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43002 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43006 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43010 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  43014 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43018 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43022 */     // MIs[3] x
     /*  43022 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  43027 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  43031 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  43035 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43037 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43037 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43040 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43044 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43049 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43053 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43058 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43061 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43065 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43070 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  43074 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43079 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43082 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43086 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43091 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  43095 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43100 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43103 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43105 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43108 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43111 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43114 */     GIR_RootConstrainSelectedInstOperands,
     /*  43115 */     // GIR_Coverage, 8057,
     /*  43115 */     GIR_EraseRootFromParent_Done,
     /*  43116 */   // Label 420: @43116
     /*  43116 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(43263), // Rule ID 11940 //
     /*  43121 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43125 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43129 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43133 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43137 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43141 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  43145 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43149 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43153 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43157 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  43161 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  43165 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
     /*  43169 */     // MIs[3] x
     /*  43169 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  43174 */     GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 255,
     /*  43178 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  43182 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43184 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, (xor:{ *:[i32] } i32:{ *:[i32] }:$x, -1:{ *:[i32] })))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }))
     /*  43184 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43187 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43191 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43196 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43200 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43205 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43208 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43212 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43217 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43221 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43226 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43229 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43233 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43238 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  43242 */     GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43247 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43250 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43252 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43255 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/1,
     /*  43258 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/2,
     /*  43261 */     GIR_RootConstrainSelectedInstOperands,
     /*  43262 */     // GIR_Coverage, 11940,
     /*  43262 */     GIR_EraseRootFromParent_Done,
     /*  43263 */   // Label 421: @43263
     /*  43263 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(43356), // Rule ID 2718 //
     /*  43268 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  43271 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43275 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43279 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43283 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43287 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43291 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  43293 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  43297 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43301 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43305 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43309 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43313 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  43317 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  43321 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  43325 */     // MIs[3] Operand 1
     /*  43325 */     // No operand predicates
     /*  43325 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  43329 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:5:z
     /*  43333 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22620),
     /*  43337 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43339 */     // (or:{ *:[i32] } (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_22610>>, i32:{ *:[i32] }:$src2:$pred:5:z)<<P:5:Predicate_anonymous_22620>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  43339 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  43342 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  43348 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  43352 */     GIR_RootToRootCopy, /*OpIdx*/2, // src2
     /*  43354 */     GIR_RootConstrainSelectedInstOperands,
     /*  43355 */     // GIR_Coverage, 2718,
     /*  43355 */     GIR_EraseRootFromParent_Done,
     /*  43356 */   // Label 422: @43356
     /*  43356 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(43449), // Rule ID 9265 //
     /*  43361 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  43364 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43368 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/2, // Name : pred:5:z
     /*  43372 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  43376 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*  43380 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43384 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43388 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  43390 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*  43394 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  43398 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43402 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43406 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43410 */     GIM_RecordNamedOperand, /*MI*/2, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*  43414 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  43418 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  43422 */     // MIs[3] Operand 1
     /*  43422 */     // No operand predicates
     /*  43422 */     GIM_CheckCxxInsnPredicate, /*MI*/2, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_csh_mask_32),
     /*  43426 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22620),
     /*  43430 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43432 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src2:$pred:5:z, (shl:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:5:x, (and:{ *:[i32] } i32:{ *:[i32] }:$src1:$pred:5:y, (imm:{ *:[i32] }))<<P:Predicate_csh_mask_32>>)<<P:Predicate_anonymous_22610>>)<<P:5:Predicate_anonymous_22620>>  =>  (V_LSHL_OR_B32_e64:{ *:[i32] } VSrc_b32:{ *:[i32] }:$src0, VSrc_b32:{ *:[i32] }:$src1, VSrc_b32:{ *:[i32] }:$src2)
     /*  43432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_LSHL_OR_B32_e64),
     /*  43435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43437 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src0
     /*  43441 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
     /*  43445 */     GIR_RootToRootCopy, /*OpIdx*/1, // src2
     /*  43447 */     GIR_RootConstrainSelectedInstOperands,
     /*  43448 */     // GIR_Coverage, 9265,
     /*  43448 */     GIR_EraseRootFromParent_Done,
     /*  43449 */   // Label 423: @43449
     /*  43449 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(43634), // Rule ID 11990 //
     /*  43454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43458 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43462 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43466 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43470 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43474 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43478 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43482 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43486 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43490 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43494 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43498 */     // MIs[3] x
     /*  43498 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43503 */     // MIs[3] z
     /*  43503 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43508 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  43512 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43514 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43514 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43517 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43521 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43526 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43530 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43535 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43538 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43542 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43547 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  43551 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43556 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43559 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43563 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43568 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43572 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43577 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43580 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43584 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43589 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43593 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43598 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43601 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43605 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43610 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43613 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43616 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43618 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43621 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43623 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43626 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43629 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43632 */     GIR_RootConstrainSelectedInstOperands,
     /*  43633 */     // GIR_Coverage, 11990,
     /*  43633 */     GIR_EraseRootFromParent_Done,
     /*  43634 */   // Label 424: @43634
     /*  43634 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(43819), // Rule ID 11991 //
     /*  43639 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43643 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43647 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43651 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43655 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43659 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43663 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43667 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43671 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43675 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43679 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43683 */     // MIs[3] z
     /*  43683 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43688 */     // MIs[3] x
     /*  43688 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43693 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  43697 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43699 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43699 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43702 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43706 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43711 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43715 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43720 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43723 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43727 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43732 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  43736 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43741 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43744 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43748 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43753 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43757 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43762 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43765 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43769 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43774 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  43778 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43783 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43786 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43790 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43795 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43798 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43801 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43803 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43806 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43808 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43811 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43814 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  43817 */     GIR_RootConstrainSelectedInstOperands,
     /*  43818 */     // GIR_Coverage, 11991,
     /*  43818 */     GIR_EraseRootFromParent_Done,
     /*  43819 */   // Label 425: @43819
     /*  43819 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(44004), // Rule ID 11992 //
     /*  43824 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43828 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  43832 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43836 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  43840 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  43844 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  43848 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  43852 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  43856 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  43860 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  43864 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  43868 */     // MIs[3] x
     /*  43868 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  43873 */     // MIs[3] z
     /*  43873 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  43878 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  43882 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  43884 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  43884 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  43887 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43891 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43896 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43900 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43905 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  43908 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43912 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43917 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  43921 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43926 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  43929 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43933 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43938 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  43942 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43947 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  43950 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  43954 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43959 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  43963 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  43968 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  43971 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  43975 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  43980 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  43983 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  43986 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  43988 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  43991 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  43993 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  43996 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  43999 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44002 */     GIR_RootConstrainSelectedInstOperands,
     /*  44003 */     // GIR_Coverage, 11992,
     /*  44003 */     GIR_EraseRootFromParent_Done,
     /*  44004 */   // Label 426: @44004
     /*  44004 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(44189), // Rule ID 11993 //
     /*  44009 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44013 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44017 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44021 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44025 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44029 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  44033 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44037 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44041 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44045 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44049 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44053 */     // MIs[3] z
     /*  44053 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44058 */     // MIs[3] x
     /*  44058 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44063 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44067 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44069 */     // (or:{ *:[i32] } (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44069 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44072 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44076 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44081 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44085 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44090 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44093 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44097 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44102 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44106 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44111 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44114 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44118 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44123 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // y
     /*  44127 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44132 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44135 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44139 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44144 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  44148 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44153 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44156 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44160 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44165 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44168 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44171 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44178 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44181 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44184 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44187 */     GIR_RootConstrainSelectedInstOperands,
     /*  44188 */     // GIR_Coverage, 11993,
     /*  44188 */     GIR_EraseRootFromParent_Done,
     /*  44189 */   // Label 427: @44189
     /*  44189 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(44374), // Rule ID 11986 //
     /*  44194 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44198 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44202 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44206 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44210 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44214 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44218 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44222 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44226 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44230 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44234 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44238 */     // MIs[3] x
     /*  44238 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44243 */     // MIs[3] z
     /*  44243 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44248 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44252 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44254 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44254 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44257 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44261 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44266 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44270 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44275 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44278 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44282 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44287 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44291 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44296 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44299 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44303 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44308 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44312 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44317 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44320 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44324 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44329 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44333 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44338 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44341 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44345 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44350 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44353 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44356 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44358 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44361 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44363 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44366 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44369 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44372 */     GIR_RootConstrainSelectedInstOperands,
     /*  44373 */     // GIR_Coverage, 11986,
     /*  44373 */     GIR_EraseRootFromParent_Done,
     /*  44374 */   // Label 428: @44374
     /*  44374 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(44559), // Rule ID 11987 //
     /*  44379 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44383 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44387 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44391 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44395 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44399 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44403 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44407 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44411 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44415 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44419 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44423 */     // MIs[3] z
     /*  44423 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44428 */     // MIs[3] x
     /*  44428 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44433 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44437 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44439 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44439 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44442 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44446 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44451 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44455 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44460 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44463 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44467 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44472 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/2, // z
     /*  44476 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44481 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44484 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44488 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44493 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44497 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44502 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44505 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44509 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44514 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/1, // x
     /*  44518 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44523 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44526 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44530 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44535 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44538 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44541 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44543 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44546 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44548 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44551 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44554 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44557 */     GIR_RootConstrainSelectedInstOperands,
     /*  44558 */     // GIR_Coverage, 11987,
     /*  44558 */     GIR_EraseRootFromParent_Done,
     /*  44559 */   // Label 429: @44559
     /*  44559 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(44744), // Rule ID 11988 //
     /*  44564 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44568 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44572 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44576 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44580 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44584 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44588 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44592 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44596 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44600 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44604 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44608 */     // MIs[3] x
     /*  44608 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44613 */     // MIs[3] z
     /*  44613 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44618 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44622 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44624 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44624 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44627 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44631 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44636 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44640 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44645 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44648 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44652 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44657 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44661 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44666 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44669 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44673 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44678 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44682 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44687 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44690 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44694 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44699 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  44703 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44708 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44711 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44715 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44720 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44723 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44726 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44728 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44731 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44733 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44736 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44739 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44742 */     GIR_RootConstrainSelectedInstOperands,
     /*  44743 */     // GIR_Coverage, 11988,
     /*  44743 */     GIR_EraseRootFromParent_Done,
     /*  44744 */   // Label 430: @44744
     /*  44744 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(44929), // Rule ID 11989 //
     /*  44749 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44753 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44757 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44761 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44765 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44769 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  44773 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44777 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44781 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44785 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  44789 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44793 */     // MIs[3] z
     /*  44793 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  44798 */     // MIs[3] x
     /*  44798 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  44803 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44807 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44809 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)), (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44809 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44812 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44816 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44821 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44825 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44830 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  44833 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44837 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44842 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/2, /*OpIdx*/1, // z
     /*  44846 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44851 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  44854 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44858 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44863 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/1, // y
     /*  44867 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44872 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  44875 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  44879 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44884 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/2, /*OpIdx*/2, // x
     /*  44888 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44893 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  44896 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  44900 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  44905 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  44908 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  44911 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  44913 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  44916 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  44918 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  44921 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  44924 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  44927 */     GIR_RootConstrainSelectedInstOperands,
     /*  44928 */     // GIR_Coverage, 11989,
     /*  44928 */     GIR_EraseRootFromParent_Done,
     /*  44929 */   // Label 431: @44929
     /*  44929 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(45114), // Rule ID 11980 //
     /*  44934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  44938 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  44942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44946 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  44950 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  44954 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  44958 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  44962 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  44966 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  44970 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  44974 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  44978 */     // MIs[3] x
     /*  44978 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  44983 */     // MIs[3] z
     /*  44983 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  44988 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  44992 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  44994 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  44994 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  44997 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45001 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45006 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45010 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45015 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45018 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45022 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45027 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45031 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45036 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45039 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45043 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45048 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45052 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45057 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45060 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45064 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45069 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45073 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45078 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45081 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45085 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45090 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45093 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45096 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45098 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45101 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45103 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45106 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45109 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45112 */     GIR_RootConstrainSelectedInstOperands,
     /*  45113 */     // GIR_Coverage, 11980,
     /*  45113 */     GIR_EraseRootFromParent_Done,
     /*  45114 */   // Label 432: @45114
     /*  45114 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(45299), // Rule ID 11981 //
     /*  45119 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45123 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45127 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45131 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45135 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45139 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45143 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45147 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45151 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45155 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  45159 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45163 */     // MIs[3] z
     /*  45163 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45168 */     // MIs[3] x
     /*  45168 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45173 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  45177 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45179 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45179 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45182 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45186 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45191 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45195 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45200 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45203 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45207 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45212 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45216 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45221 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45224 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45228 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45233 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45237 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45242 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45245 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45249 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45254 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45258 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45263 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45266 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45270 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45275 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45278 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45281 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45283 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45286 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45288 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45291 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45294 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45297 */     GIR_RootConstrainSelectedInstOperands,
     /*  45298 */     // GIR_Coverage, 11981,
     /*  45298 */     GIR_EraseRootFromParent_Done,
     /*  45299 */   // Label 433: @45299
     /*  45299 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(45484), // Rule ID 11984 //
     /*  45304 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45308 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45312 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45316 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45320 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45324 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45328 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45332 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45336 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45340 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  45344 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45348 */     // MIs[3] x
     /*  45348 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45353 */     // MIs[3] z
     /*  45353 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45358 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  45362 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45364 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45364 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45367 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45371 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45376 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45380 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45385 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45388 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45392 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45397 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  45401 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45406 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45409 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45413 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45418 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45422 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45427 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45430 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45434 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45439 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  45443 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45448 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45451 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45455 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45460 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45463 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45466 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45468 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45471 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45473 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45476 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45479 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45482 */     GIR_RootConstrainSelectedInstOperands,
     /*  45483 */     // GIR_Coverage, 11984,
     /*  45483 */     GIR_EraseRootFromParent_Done,
     /*  45484 */   // Label 434: @45484
     /*  45484 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(45669), // Rule ID 11985 //
     /*  45489 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45493 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45497 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45501 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45505 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45509 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45513 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45517 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45521 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45525 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  45529 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45533 */     // MIs[3] z
     /*  45533 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45538 */     // MIs[3] x
     /*  45538 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45543 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  45547 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45549 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), i32:{ *:[i32] }:$y))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45549 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45552 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45556 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45561 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45565 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45570 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45573 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45577 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45582 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  45586 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45591 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45594 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45598 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45603 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/2, // y
     /*  45607 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45612 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45615 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45619 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45624 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  45628 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45633 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45636 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45640 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45645 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45648 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45651 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45658 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45661 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45664 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45667 */     GIR_RootConstrainSelectedInstOperands,
     /*  45668 */     // GIR_Coverage, 11985,
     /*  45668 */     GIR_EraseRootFromParent_Done,
     /*  45669 */   // Label 435: @45669
     /*  45669 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(45854), // Rule ID 8331 //
     /*  45674 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45678 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45682 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45686 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45690 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45694 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45698 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45702 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45706 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45710 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  45714 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45718 */     // MIs[3] x
     /*  45718 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45723 */     // MIs[3] z
     /*  45723 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45728 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  45732 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45734 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45734 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45737 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45741 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45746 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45750 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45755 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45758 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45762 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45767 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45771 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45776 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45779 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45783 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45788 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45792 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45797 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45800 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45804 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45809 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45813 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45818 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  45821 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  45825 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45830 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  45833 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  45836 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  45838 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  45841 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  45843 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  45846 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  45849 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  45852 */     GIR_RootConstrainSelectedInstOperands,
     /*  45853 */     // GIR_Coverage, 8331,
     /*  45853 */     GIR_EraseRootFromParent_Done,
     /*  45854 */   // Label 436: @45854
     /*  45854 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(46039), // Rule ID 11979 //
     /*  45859 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45863 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  45867 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45871 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  45875 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  45879 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  45883 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  45887 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  45891 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  45895 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  45899 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  45903 */     // MIs[3] z
     /*  45903 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  45908 */     // MIs[3] x
     /*  45908 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  45913 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  45917 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  45919 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  45919 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  45922 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45926 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45931 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45935 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45940 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  45943 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45947 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45952 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/2, // z
     /*  45956 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45961 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  45964 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45968 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45973 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  45977 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  45982 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  45985 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  45989 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  45994 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // x
     /*  45998 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46003 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46006 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46010 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46015 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46018 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46021 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46028 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46031 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46034 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46037 */     GIR_RootConstrainSelectedInstOperands,
     /*  46038 */     // GIR_Coverage, 11979,
     /*  46038 */     GIR_EraseRootFromParent_Done,
     /*  46039 */   // Label 437: @46039
     /*  46039 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(46224), // Rule ID 11982 //
     /*  46044 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46048 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46052 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46056 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46060 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46064 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46068 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46072 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46076 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46080 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  46084 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46088 */     // MIs[3] x
     /*  46088 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46093 */     // MIs[3] z
     /*  46093 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46098 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  46102 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46104 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$x, i32:{ *:[i32] }:$z)))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46104 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46107 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46111 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46116 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  46120 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46125 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46128 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46132 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46137 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  46141 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46146 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46149 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46153 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46158 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  46162 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46167 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46170 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46174 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46179 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  46183 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46188 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46191 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46195 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46200 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46203 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46206 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46208 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46211 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46213 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46216 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46219 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46222 */     GIR_RootConstrainSelectedInstOperands,
     /*  46223 */     // GIR_Coverage, 11982,
     /*  46223 */     GIR_EraseRootFromParent_Done,
     /*  46224 */   // Label 438: @46224
     /*  46224 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(46409), // Rule ID 11983 //
     /*  46229 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46233 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46237 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46241 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46245 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46249 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*  46253 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46257 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
     /*  46261 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
     /*  46265 */     GIM_RecordInsnIgnoreCopies, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  46269 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  46273 */     // MIs[3] z
     /*  46273 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  46278 */     // MIs[3] x
     /*  46278 */     GIM_CheckIsSameOperandIgnoreCopies, /*MI*/3, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  46283 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_21300),
     /*  46287 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*  46289 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x), (and:{ *:[i32] } i32:{ *:[i32] }:$y, (or:{ *:[i32] } i32:{ *:[i32] }:$z, i32:{ *:[i32] }:$x)))<<P:Predicate_anonymous_21300>>  =>  (V_BFI_B32_e64:{ *:[i32] } (V_XOR_B32_e64:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$x, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] })), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$z, VGPR_32:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i16] } VSrc_b32:{ *:[i32] }:$y, VGPR_32:{ *:[i32] }))
     /*  46289 */     GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_s16,
     /*  46292 */     GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46296 */     GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46301 */     GIR_Copy, /*NewInsnID*/5, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  46305 */     GIR_ConstrainOperandRC, /*InsnID*/5, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46310 */     GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s16,
     /*  46313 */     GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46317 */     GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46322 */     GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/1, /*OpIdx*/1, // z
     /*  46326 */     GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46331 */     GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s16,
     /*  46334 */     GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46338 */     GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46343 */     GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/2, /*OpIdx*/1, // y
     /*  46347 */     GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46352 */     GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
     /*  46355 */     GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
     /*  46359 */     GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46364 */     GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/2, // x
     /*  46368 */     GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46373 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
     /*  46376 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(AMDGPU::V_XOR_B32_e64),
     /*  46380 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*  46385 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
     /*  46388 */     GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
     /*  46391 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*  46393 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::V_BFI_B32_e64),
     /*  46396 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[vdst]
     /*  46398 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*  46401 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/3,
     /*  46404 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/4,
     /*  46407 */     GIR_RootConstrainSelectedInstOperands,
     /*  46408 */     // GIR_Coverage, 11983,
     /*  46408 */     GIR_EraseRootFromParent_Done,
     /*  46409 */   // Label 439: @46409
     /*  46409 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(46460), // Rule ID 9173 //
     /*  46414 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  46418 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46422 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  46426 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46430 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46434 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  46438 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14915),
     /*  46442 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46444 */     // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }), i32:{ *:[i32] }:$src0)<<P:Predicate_anonymous_14915>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  46444 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  46447 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  46449 */     GIR_RootToRootCopy, /*OpIdx*/2, // src0
     /*  46451 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  46455 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  46458 */     GIR_RootConstrainSelectedInstOperands,
     /*  46459 */     // GIR_Coverage, 9173,
     /*  46459 */     GIR_EraseRootFromParent_Done,
     /*  46460 */   // Label 440: @46460
     /*  46460 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(46511), // Rule ID 66 //
     /*  46465 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::SReg_32RegClassID),
     /*  46469 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*  46473 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  46477 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46481 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46485 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 255,
     /*  46489 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_14915),
     /*  46493 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46495 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$src0, (xor:{ *:[i32] } i32:{ *:[i32] }:$src1, -1:{ *:[i32] }))<<P:Predicate_anonymous_14915>>  =>  (S_ORN2_B32:{ *:[i32] }:{ *:[i1] } i32:{ *:[i32] }:$src0, i32:{ *:[i32] }:$src1)
     /*  46495 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(AMDGPU::S_ORN2_B32),
     /*  46498 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[sdst]
     /*  46500 */     GIR_RootToRootCopy, /*OpIdx*/1, // src0
     /*  46502 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
     /*  46506 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for AMDGPU::SCC*/0,
     /*  46509 */     GIR_RootConstrainSelectedInstOperands,
     /*  46510 */     // GIR_Coverage, 66,
     /*  46510 */     GIR_EraseRootFromParent_Done,
     /*  46511 */   // Label 441: @46511
     /*  46511 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(46576), // Rule ID 2719 //
     /*  46516 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_isGFX9Plus),
     /*  46519 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(AMDGPU::VGPR_32RegClassID),
     /*  46523 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  46527 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  46531 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*  46535 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*  46539 */     GIM_CheckHasOneUse, /*MI*/1,
     /*  46541 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
     /*  46545 */     GIM_RecordNamedOperand, /*MI*/1, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
     /*  46549 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/2, // Name : pred:6:z
     /*  46553 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_22622),
     /*  46557 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  46559 */     // (or:{ *:[i32] } (and:{ *:[i32] } i32:{ *:[i32] }:$src0:$pred:6:x, i32:{ *:[i32] }:$src1:$pred:6:y)<<P:Predicate_anonymous_22623>>, i32:{ *:[i32] }:$src2:$pred:6:z)<<P: