/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.10.0
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/stream.h>
        #include <wx/stream.h>
        //--------------------------------------------------------------------------
        
        static PyObject* wxPyGetMethod(PyObject* py, char* name)
        {
            if (!PyObject_HasAttrString(py, name))
                return NULL;
            PyObject* o = PyObject_GetAttrString(py, name);
            if (!PyMethod_Check(o) && !PyCFunction_Check(o)) {
                Py_DECREF(o);
                return NULL;
            }
            return o;
        }
        
        #define wxPyBlock_t_default PyGILState_UNLOCKED
        
        
        // This class can wrap a Python file-like object and allow it to be used
        // as a wxInputStream.
        class wxPyOutputStream : public wxOutputStream
        {
        public:
        
            // Make sure there is at least a write method
            static bool Check(PyObject* fileObj)
            {
                PyObject* method = wxPyGetMethod(fileObj, "write");
                bool rval = method != NULL;
                Py_XDECREF(method);
                return rval;
            }
        
            wxPyOutputStream(PyObject* fileObj, bool block=true)
            {
                m_block = block;
                wxPyThreadBlocker blocker(m_block);
        
                m_write = wxPyGetMethod(fileObj, "write");
                m_seek = wxPyGetMethod(fileObj, "seek");
                m_tell = wxPyGetMethod(fileObj, "tell");
            }
        
            virtual ~wxPyOutputStream()
            {
                wxPyThreadBlocker blocker(m_block);
                Py_XDECREF(m_write);
                Py_XDECREF(m_seek);
                Py_XDECREF(m_tell);
            }
        
            wxPyOutputStream(const wxPyOutputStream& other)
            {
                wxPyThreadBlocker blocker;
                m_write  = other.m_write;
                m_seek  = other.m_seek;
                m_tell  = other.m_tell;
                m_block = other.m_block;
                Py_INCREF(m_write);
                Py_INCREF(m_seek);
                Py_INCREF(m_tell);
            }
        
        protected:
        
            // implement base class virtuals
        
            wxFileOffset GetLength() const
            {
                wxPyOutputStream* self = (wxPyOutputStream*)this; // cast off const
                if (m_seek && m_tell) {
                    wxFileOffset temp = self->OnSysTell();
                    wxFileOffset ret = self->OnSysSeek(0, wxFromEnd);
                    self->OnSysSeek(temp, wxFromStart);
                    return ret;
                }
                else
                    return wxInvalidOffset;
            }
        
            size_t OnSysRead(void *buffer, size_t bufsize)
            {
                m_lasterror = wxSTREAM_READ_ERROR;
                return 0;
            }
        
            size_t OnSysWrite(const void *buffer, size_t bufsize)
            {
                if (bufsize == 0)
                    return 0;
        
                wxPyThreadBlocker blocker;
                PyObject* arglist = PyTuple_New(1);
                PyTuple_SET_ITEM(arglist, 0, PyBytes_FromStringAndSize((char*)buffer, bufsize));
        
                PyObject* result = PyObject_CallObject(m_write, arglist);
                Py_DECREF(arglist);
        
                if (result != NULL)
                    Py_DECREF(result);
                else
                    m_lasterror = wxSTREAM_WRITE_ERROR;
                return bufsize;
            }
        
            wxFileOffset OnSysSeek(wxFileOffset off, wxSeekMode mode)
            {
                wxPyThreadBlocker blocker;
                PyObject* arglist = PyTuple_New(2);
        
                if (sizeof(wxFileOffset) > sizeof(long))
                    // wxFileOffset is a 64-bit value...
                    PyTuple_SET_ITEM(arglist, 0, PyLong_FromLongLong(off));
                else
                    PyTuple_SET_ITEM(arglist, 0, wxPyInt_FromLong(off));
        
                PyTuple_SET_ITEM(arglist, 1, wxPyInt_FromLong(mode));
        
        
                PyObject* result = PyObject_CallObject(m_seek, arglist);
                Py_DECREF(arglist);
                Py_XDECREF(result);
                return OnSysTell();
            }
        
            wxFileOffset OnSysTell() const
            {
                wxPyThreadBlocker blocker;
                PyObject* arglist = Py_BuildValue("()");
                PyObject* result = PyObject_CallObject(m_tell, arglist);
                Py_DECREF(arglist);
                wxFileOffset o = 0;
                if (result != NULL) {
                    if (PyLong_Check(result))
                        o = PyLong_AsLongLong(result);
                    else
                        o = wxPyInt_AsLong(result);
                    Py_DECREF(result);
                };
                return o;
            }
        
            bool IsSeekable() const
            {
                return (m_seek != NULL);
            }
        
        private:
            PyObject* m_write;
            PyObject* m_seek;
            PyObject* m_tell;
            bool      m_block;
        };
        
        //--------------------------------------------------------------------------
    void _wxOutputStream_seek(wxOutputStream* self, wxFileOffset offset, int whence)
    {
        self->SeekO(offset, (wxSeekMode)whence);
    }
    wxFileOffset _wxOutputStream_tell(wxOutputStream* self)
    {
        return self->TellO();
    }
    void _wxOutputStream_close(wxOutputStream* self)
    {
        self->Close();
    }
    void _wxOutputStream_flush(wxOutputStream* self)
    {
        self->Sync();
    }
    bool _wxOutputStream_eof(wxOutputStream* self)
    {
        return false; //self->Eof();
    }
    PyObject* _wxOutputStream_write(wxOutputStream* self, PyObject* data)
    {
        // We use only bytes objects (strings in 2.7) for the streams, never unicode
        wxPyThreadBlocker blocker;
        if (!PyBytes_Check(data)) {
            PyErr_SetString(PyExc_TypeError, "Bytes object expected");
            return NULL;
        }
        self->Write(PyBytes_AS_STRING(data), PyBytes_GET_SIZE(data));
        RETURN_NONE();
    }


PyDoc_STRVAR(doc_wxOutputStream_Close, "Close() -> bool\n"
"\n"
"Closes the stream, returning false if an error occurs.");

extern "C" {static PyObject *meth_wxOutputStream_Close(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_Close(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Close();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_Close, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_LastWrite, "LastWrite() -> int\n"
"\n"
"Returns the number of bytes written during the last Write().");

extern "C" {static PyObject *meth_wxOutputStream_LastWrite(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_LastWrite(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            size_t sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->LastWrite();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromUnsignedLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_LastWrite, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_PutC, "PutC(c) -> None\n"
"\n"
"Puts the specified character in the output queue and increments the\n"
"stream position.");

extern "C" {static PyObject *meth_wxOutputStream_PutC(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_PutC(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        char c;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_c,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bc", &sipSelf, sipType_wxOutputStream, &sipCpp, &c))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->PutC(c);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_PutC, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_SeekO, "SeekO(pos, mode=FromStart) -> FileOffset\n"
"\n"
"Changes the stream current position.");

extern "C" {static PyObject *meth_wxOutputStream_SeekO(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_SeekO(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFileOffset pos;
        ::wxSeekMode mode = wxFromStart;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pos,
            sipName_mode,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|E", &sipSelf, sipType_wxOutputStream, &sipCpp, &pos, sipType_wxSeekMode, &mode))
        {
            ::wxFileOffset sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->SeekO(pos, mode);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_SeekO, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_TellO, "TellO() -> FileOffset\n"
"\n"
"Returns the current stream position.");

extern "C" {static PyObject *meth_wxOutputStream_TellO(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_TellO(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            ::wxFileOffset sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->TellO();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_TellO, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_Write, "Write(buffer, size) -> OutputStream\n"
"Write(stream_in) -> OutputStream\n"
"\n"
"Writes up to the specified amount of bytes using the data of buffer.\n"
"");

extern "C" {static PyObject *meth_wxOutputStream_Write(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_Write(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* buffer;
        size_t size;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv=", &sipSelf, sipType_wxOutputStream, &sipCpp, &buffer, &size))
        {
            ::wxOutputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Write(buffer, size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxOutputStream, SIP_NULLPTR);
        }
    }

    {
        ::wxInputStream* stream_in;
        int stream_inState = 0;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_stream_in,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxOutputStream, &sipCpp, sipType_wxInputStream, &stream_in, &stream_inState))
        {
            ::wxOutputStream*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->Write(*stream_in);
            Py_END_ALLOW_THREADS
            sipReleaseType(stream_in, sipType_wxInputStream, stream_inState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes, sipType_wxOutputStream, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_Write, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_WriteAll, "WriteAll(buffer, size) -> bool\n"
"\n"
"Writes exactly the specified number of bytes from the buffer.");

extern "C" {static PyObject *meth_wxOutputStream_WriteAll(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_WriteAll(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const void* buffer;
        size_t size;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_buffer,
            sipName_size,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bv=", &sipSelf, sipType_wxOutputStream, &sipCpp, &buffer, &size))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->WriteAll(buffer, size);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_WriteAll, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_seek, "seek(offset, whence=0) -> None");

extern "C" {static PyObject *meth_wxOutputStream_seek(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_seek(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxFileOffset offset;
        int whence = 0;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_offset,
            sipName_whence,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bn|i", &sipSelf, sipType_wxOutputStream, &sipCpp, &offset, &whence))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxOutputStream_seek(sipCpp, offset, whence);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_seek, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_tell, "tell() -> FileOffset");

extern "C" {static PyObject *meth_wxOutputStream_tell(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_tell(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            ::wxFileOffset sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxOutputStream_tell(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyLong_FromLongLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_tell, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_close, "close() -> None");

extern "C" {static PyObject *meth_wxOutputStream_close(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_close(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxOutputStream_close(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_close, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_flush, "flush() -> None");

extern "C" {static PyObject *meth_wxOutputStream_flush(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_flush(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        _wxOutputStream_flush(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_flush, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_eof, "eof() -> bool");

extern "C" {static PyObject *meth_wxOutputStream_eof(PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_eof(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxOutputStream *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxOutputStream, &sipCpp))
        {
            bool sipRes = 0;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxOutputStream_eof(sipCpp);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_eof, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxOutputStream_write, "write(data) -> Any");

extern "C" {static PyObject *meth_wxOutputStream_write(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxOutputStream_write(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        PyObject * data;
        ::wxOutputStream *sipCpp;

        static const char *sipKwdList[] = {
            sipName_data,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BP0", &sipSelf, sipType_wxOutputStream, &sipCpp, &data))
        {
            PyObject * sipRes = SIP_NULLPTR;
            int sipIsErr = 0;
        PyErr_Clear();
        Py_BEGIN_ALLOW_THREADS
        sipRes = _wxOutputStream_write(sipCpp, data);
        Py_END_ALLOW_THREADS
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
                return 0;

            return sipRes;
        }
    }

    sipNoMethod(sipParseErr, sipName_OutputStream, sipName_write, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxOutputStream(void *, const sipTypeDef *);}
static void *cast_wxOutputStream(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxOutputStream *sipCpp = reinterpret_cast<::wxOutputStream *>(sipCppV);

    if (targetType == sipType_wxOutputStream)
        return sipCppV;

    if (targetType == sipType_wxStreamBase)
        return static_cast<::wxStreamBase *>(sipCpp);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxOutputStream(void *, int);}
static void release_wxOutputStream(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast<::wxOutputStream *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxOutputStream(sipSimpleWrapper *);}
static void dealloc_wxOutputStream(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxOutputStream(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static int convertTo_wxOutputStream(PyObject *, void **, int *, PyObject *);}
static int convertTo_wxOutputStream(PyObject *sipPy, void **sipCppPtrV, int *sipIsErr, PyObject *sipTransferObj)
{
    ::wxOutputStream **sipCppPtr = reinterpret_cast<::wxOutputStream **>(sipCppPtrV);
        // is it just a typecheck?
        if (!sipIsErr) {
            if (wxPyOutputStream::Check(sipPy))
                return 1;
            return 0;
        }
        // otherwise do the conversion
        *sipCppPtr = new wxPyOutputStream(sipPy);
        return sipGetState(sipTransferObj);
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxOutputStream[] = {{550, 255, 1}};


static PyMethodDef methods_wxOutputStream[] = {
    {sipName_Close, meth_wxOutputStream_Close, METH_VARARGS, doc_wxOutputStream_Close},
    {sipName_LastWrite, meth_wxOutputStream_LastWrite, METH_VARARGS, doc_wxOutputStream_LastWrite},
    {sipName_PutC, SIP_MLMETH_CAST(meth_wxOutputStream_PutC), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_PutC},
    {sipName_SeekO, SIP_MLMETH_CAST(meth_wxOutputStream_SeekO), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_SeekO},
    {sipName_TellO, meth_wxOutputStream_TellO, METH_VARARGS, doc_wxOutputStream_TellO},
    {sipName_Write, SIP_MLMETH_CAST(meth_wxOutputStream_Write), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_Write},
    {sipName_WriteAll, SIP_MLMETH_CAST(meth_wxOutputStream_WriteAll), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_WriteAll},
    {sipName_close, meth_wxOutputStream_close, METH_VARARGS, doc_wxOutputStream_close},
    {sipName_eof, meth_wxOutputStream_eof, METH_VARARGS, doc_wxOutputStream_eof},
    {sipName_flush, meth_wxOutputStream_flush, METH_VARARGS, doc_wxOutputStream_flush},
    {sipName_seek, SIP_MLMETH_CAST(meth_wxOutputStream_seek), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_seek},
    {sipName_tell, meth_wxOutputStream_tell, METH_VARARGS, doc_wxOutputStream_tell},
    {sipName_write, SIP_MLMETH_CAST(meth_wxOutputStream_write), METH_VARARGS|METH_KEYWORDS, doc_wxOutputStream_write}
};

PyDoc_STRVAR(doc_wxOutputStream, "OutputStream() -> None\n"
"\n"
"wxOutputStream is an abstract base class which may not be used\n"
"directly.");


sipClassTypeDef sipTypeDef__core_wxOutputStream = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxOutputStream,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_OutputStream,
        {0, 0, 1},
        13, methods_wxOutputStream,
        0, SIP_NULLPTR,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxOutputStream,
    -1,
    -1,
    supers_wxOutputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxOutputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxOutputStream,
    cast_wxOutputStream,
    convertTo_wxOutputStream,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    0,
};
