/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.0
 *
 * Copyright (c) 2024 Riverbank Computing Limited <info@riverbankcomputing.com>
 * 
 * This file is part of PyQt5.
 * 
 * This file may be used under the terms of the GNU General Public License
 * version 3.0 as published by the Free Software Foundation and appearing in
 * the file LICENSE included in the packaging of this file.  Please review the
 * following information to ensure the GNU General Public License version 3.0
 * requirements will be met: http://www.gnu.org/copyleft/gpl.html.
 * 
 * If you do not wish to use this file under the terms of the GPL version 3.0
 * then you may purchase a commercial license.  For more information contact
 * info@riverbankcomputing.com.
 * 
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include "sipAPIQtCore.h"

#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcalendar.sip"
#include <qcalendar.h>
#line 29 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"

#line 36 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstringlist.sip"
#include <qstringlist.h>
#line 33 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 27 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qstring.sip"
#include <qstring.h>
#line 36 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 360 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 39 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 42 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 216 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qdatetime.sip"
#include <qdatetime.h>
#line 45 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 26 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qlocale.sip"
#include <qlocale.h>
#line 48 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
#line 28 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcalendar.sip"
#include <qcalendar.h>
#line 40 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcalendar.sip"
#include <qcalendar.h>
#line 53 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"


PyDoc_STRVAR(doc_QCalendar_daysInMonth, "daysInMonth(self, month: int, year: int = QCalendar.Unspecified) -> int");

extern "C" {static PyObject *meth_QCalendar_daysInMonth(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCalendar_daysInMonth(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1 = QCalendar::Unspecified;
        const ::QCalendar *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            sipName_year,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bi|i", &sipSelf, sipType_QCalendar, &sipCpp, &a0, &a1))
        {
            int sipRes;

            sipRes = sipCpp->daysInMonth(a0, a1);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_daysInMonth, doc_QCalendar_daysInMonth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_daysInYear, "daysInYear(self, year: int) -> int");

extern "C" {static PyObject *meth_QCalendar_daysInYear(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_daysInYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QCalendar, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->daysInYear(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_daysInYear, doc_QCalendar_daysInYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_monthsInYear, "monthsInYear(self, year: int) -> int");

extern "C" {static PyObject *meth_QCalendar_monthsInYear(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_monthsInYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QCalendar, &sipCpp, &a0))
        {
            int sipRes;

            sipRes = sipCpp->monthsInYear(a0);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_monthsInYear, doc_QCalendar_monthsInYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isDateValid, "isDateValid(self, year: int, month: int, day: int) -> bool");

extern "C" {static PyObject *meth_QCalendar_isDateValid(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isDateValid(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QCalendar, &sipCpp, &a0, &a1, &a2))
        {
            bool sipRes;

            sipRes = sipCpp->isDateValid(a0, a1, a2);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isDateValid, doc_QCalendar_isDateValid);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isLeapYear, "isLeapYear(self, year: int) -> bool");

extern "C" {static PyObject *meth_QCalendar_isLeapYear(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isLeapYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Bi", &sipSelf, sipType_QCalendar, &sipCpp, &a0))
        {
            bool sipRes;

            sipRes = sipCpp->isLeapYear(a0);

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isLeapYear, doc_QCalendar_isLeapYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isGregorian, "isGregorian(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_isGregorian(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isGregorian(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isGregorian();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isGregorian, doc_QCalendar_isGregorian);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isLunar, "isLunar(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_isLunar(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isLunar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isLunar();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isLunar, doc_QCalendar_isLunar);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isLuniSolar, "isLuniSolar(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_isLuniSolar(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isLuniSolar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isLuniSolar();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isLuniSolar, doc_QCalendar_isLuniSolar);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isSolar, "isSolar(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_isSolar(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isSolar(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isSolar();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isSolar, doc_QCalendar_isSolar);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_isProleptic, "isProleptic(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_isProleptic(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_isProleptic(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->isProleptic();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_isProleptic, doc_QCalendar_isProleptic);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_hasYearZero, "hasYearZero(self) -> bool");

extern "C" {static PyObject *meth_QCalendar_hasYearZero(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_hasYearZero(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            bool sipRes;

            sipRes = sipCpp->hasYearZero();

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_hasYearZero, doc_QCalendar_hasYearZero);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_maximumDaysInMonth, "maximumDaysInMonth(self) -> int");

extern "C" {static PyObject *meth_QCalendar_maximumDaysInMonth(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_maximumDaysInMonth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->maximumDaysInMonth();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_maximumDaysInMonth, doc_QCalendar_maximumDaysInMonth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_minimumDaysInMonth, "minimumDaysInMonth(self) -> int");

extern "C" {static PyObject *meth_QCalendar_minimumDaysInMonth(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_minimumDaysInMonth(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->minimumDaysInMonth();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_minimumDaysInMonth, doc_QCalendar_minimumDaysInMonth);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_maximumMonthsInYear, "maximumMonthsInYear(self) -> int");

extern "C" {static PyObject *meth_QCalendar_maximumMonthsInYear(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_maximumMonthsInYear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            int sipRes;

            sipRes = sipCpp->maximumMonthsInYear();

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_maximumMonthsInYear, doc_QCalendar_maximumMonthsInYear);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_name, "name(self) -> str");

extern "C" {static PyObject *meth_QCalendar_name(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_name(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_QCalendar, &sipCpp))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->name());

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_name, doc_QCalendar_name);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_dateFromParts, "dateFromParts(self, year: int, month: int, day: int) -> QDate\n"
"dateFromParts(self, parts: QCalendar.YearMonthDay) -> QDate");

extern "C" {static PyObject *meth_QCalendar_dateFromParts(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_dateFromParts(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        int a0;
        int a1;
        int a2;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "Biii", &sipSelf, sipType_QCalendar, &sipCpp, &a0, &a1, &a2))
        {
            ::QDate*sipRes;

            sipRes = new ::QDate(sipCpp->dateFromParts(a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QDate, SIP_NULLPTR);
        }
    }

    {
        const ::QCalendar::YearMonthDay* a0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ9", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QCalendar_YearMonthDay, &a0))
        {
            ::QDate*sipRes;

            sipRes = new ::QDate(sipCpp->dateFromParts(*a0));

            return sipConvertFromNewType(sipRes, sipType_QDate, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_dateFromParts, doc_QCalendar_dateFromParts);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_partsFromDate, "partsFromDate(self, date: QDate|datetime.date) -> QCalendar.YearMonthDay");

extern "C" {static PyObject *meth_QCalendar_partsFromDate(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_partsFromDate(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDate* a0;
        int a0State = 0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QDate, &a0, &a0State))
        {
            ::QCalendar::YearMonthDay*sipRes;

            sipRes = new ::QCalendar::YearMonthDay(sipCpp->partsFromDate(*a0));
            sipReleaseType(a0, sipType_QDate, a0State);

            return sipConvertFromNewType(sipRes, sipType_QCalendar_YearMonthDay, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_partsFromDate, doc_QCalendar_partsFromDate);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_dayOfWeek, "dayOfWeek(self, date: QDate|datetime.date) -> int");

extern "C" {static PyObject *meth_QCalendar_dayOfWeek(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_dayOfWeek(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::QDate* a0;
        int a0State = 0;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QDate, &a0, &a0State))
        {
            int sipRes;

            sipRes = sipCpp->dayOfWeek(*a0);
            sipReleaseType(a0, sipType_QDate, a0State);

            return PyLong_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_dayOfWeek, doc_QCalendar_dayOfWeek);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_monthName, "monthName(self, locale: QLocale, month: int, year: int = QCalendar.Unspecified, format: QLocale.FormatType = QLocale.LongFormat) -> str");

extern "C" {static PyObject *meth_QCalendar_monthName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCalendar_monthName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLocale* a0;
        int a1;
        int a2 = QCalendar::Unspecified;
        ::QLocale::FormatType a3 = QLocale::LongFormat;
        const ::QCalendar *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_year,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9i|iE", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QLocale, &a0, &a1, &a2, sipType_QLocale_FormatType, &a3))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->monthName(*a0, a1, a2, a3));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_monthName, doc_QCalendar_monthName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_standaloneMonthName, "standaloneMonthName(self, locale: QLocale, month: int, year: int = QCalendar.Unspecified, format: QLocale.FormatType = QLocale.LongFormat) -> str");

extern "C" {static PyObject *meth_QCalendar_standaloneMonthName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCalendar_standaloneMonthName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLocale* a0;
        int a1;
        int a2 = QCalendar::Unspecified;
        ::QLocale::FormatType a3 = QLocale::LongFormat;
        const ::QCalendar *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_year,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9i|iE", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QLocale, &a0, &a1, &a2, sipType_QLocale_FormatType, &a3))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->standaloneMonthName(*a0, a1, a2, a3));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_standaloneMonthName, doc_QCalendar_standaloneMonthName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_weekDayName, "weekDayName(self, locale: QLocale, day: int, format: QLocale.FormatType = QLocale.LongFormat) -> str");

extern "C" {static PyObject *meth_QCalendar_weekDayName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCalendar_weekDayName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLocale* a0;
        int a1;
        ::QLocale::FormatType a2 = QLocale::LongFormat;
        const ::QCalendar *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9i|E", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QLocale, &a0, &a1, sipType_QLocale_FormatType, &a2))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->weekDayName(*a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_weekDayName, doc_QCalendar_weekDayName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_standaloneWeekDayName, "standaloneWeekDayName(self, locale: QLocale, day: int, format: QLocale.FormatType = QLocale.LongFormat) -> str");

extern "C" {static PyObject *meth_QCalendar_standaloneWeekDayName(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_QCalendar_standaloneWeekDayName(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QLocale* a0;
        int a1;
        ::QLocale::FormatType a2 = QLocale::LongFormat;
        const ::QCalendar *sipCpp;

        static const char *sipKwdList[] = {
            SIP_NULLPTR,
            SIP_NULLPTR,
            sipName_format,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9i|E", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QLocale, &a0, &a1, sipType_QLocale_FormatType, &a2))
        {
            ::QString*sipRes;

            sipRes = new ::QString(sipCpp->standaloneWeekDayName(*a0, a1, a2));

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_standaloneWeekDayName, doc_QCalendar_standaloneWeekDayName);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_dateTimeToString, "dateTimeToString(self, format: str|None, datetime: QDateTime|datetime.datetime, dateOnly: QDate|datetime.date, timeOnly: QTime|datetime.time, locale: QLocale) -> str");

extern "C" {static PyObject *meth_QCalendar_dateTimeToString(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_dateTimeToString(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::QString* a0;
        int a0State = 0;
        const ::QDateTime* a1;
        int a1State = 0;
        const ::QDate* a2;
        int a2State = 0;
        const ::QTime* a3;
        int a3State = 0;
        const ::QLocale* a4;
        const ::QCalendar *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "BJ1J1J1J1J9", &sipSelf, sipType_QCalendar, &sipCpp, sipType_QString, &a0, &a0State, sipType_QDateTime, &a1, &a1State, sipType_QDate, &a2, &a2State, sipType_QTime, &a3, &a3State, sipType_QLocale, &a4))
        {
            ::QString*sipRes = 0;

#line 93 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcalendar.sip"
        // QStringView has issues being implemented as a mapped type.
        sipRes = new QString(sipCpp->dateTimeToString(QStringView(*a0), *a1, *a2, *a3, *a4));
#line 731 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
            sipReleaseType(const_cast< ::QString *>(a0), sipType_QString, a0State);
            sipReleaseType(const_cast< ::QDateTime *>(a1), sipType_QDateTime, a1State);
            sipReleaseType(const_cast< ::QDate *>(a2), sipType_QDate, a2State);
            sipReleaseType(const_cast< ::QTime *>(a3), sipType_QTime, a3State);

            return sipConvertFromNewType(sipRes, sipType_QString, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_dateTimeToString, doc_QCalendar_dateTimeToString);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_QCalendar_availableCalendars, "availableCalendars() -> list[str]");

extern "C" {static PyObject *meth_QCalendar_availableCalendars(PyObject *, PyObject *);}
static PyObject *meth_QCalendar_availableCalendars(PyObject *, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        if (sipParseArgs(&sipParseErr, sipArgs, ""))
        {
            ::QStringList*sipRes;

            sipRes = new ::QStringList(::QCalendar::availableCalendars());

            return sipConvertFromNewType(sipRes, sipType_QStringList, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_QCalendar, sipName_availableCalendars, doc_QCalendar_availableCalendars);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_QCalendar(void *, int);}
static void release_QCalendar(void *sipCppV, int)
{
    delete reinterpret_cast< ::QCalendar *>(sipCppV);
}


extern "C" {static void *array_QCalendar(Py_ssize_t);}
static void *array_QCalendar(Py_ssize_t sipNrElem)
{
    return new ::QCalendar[sipNrElem];
}


extern "C" {static void array_delete_QCalendar(void *);}
static void array_delete_QCalendar(void *sipCpp)
{
    delete[] reinterpret_cast< ::QCalendar *>(sipCpp);
}


extern "C" {static void assign_QCalendar(void *, Py_ssize_t, void *);}
static void assign_QCalendar(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::QCalendar *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::QCalendar *>(sipSrc);
}


extern "C" {static void *copy_QCalendar(const void *, Py_ssize_t);}
static void *copy_QCalendar(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::QCalendar(reinterpret_cast<const ::QCalendar *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_QCalendar(sipSimpleWrapper *);}
static void dealloc_QCalendar(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_QCalendar(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_QCalendar(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_QCalendar(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::QCalendar *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            sipCpp = new ::QCalendar();

            return sipCpp;
        }
    }

    {
        ::QCalendar::System a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "E", sipType_QCalendar_System, &a0))
        {
            sipCpp = new ::QCalendar(a0);

            return sipCpp;
        }
    }

    {
        const char* a0;
        PyObject *a0Keep;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "AL", &a0Keep, &a0))
        {
#line 64 "/build/pyqt5/src/PyQt5-5.15.11/sip/QtCore/qcalendar.sip"
        // This is currently the only occurence of a QLatin1String argument.
        sipCpp = new QCalendar(QLatin1String(a0));
#line 851 "/build/pyqt5/src/PyQt5-5.15.11/build/QtCore/sipQtCoreQCalendar.cpp"
            Py_DECREF(a0Keep);

            return sipCpp;
        }
    }

    {
        const ::QCalendar* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_QCalendar, &a0))
        {
            sipCpp = new ::QCalendar(*a0);

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_QCalendar[] = {
    {sipName_availableCalendars, meth_QCalendar_availableCalendars, METH_VARARGS, doc_QCalendar_availableCalendars},
    {sipName_dateFromParts, meth_QCalendar_dateFromParts, METH_VARARGS, doc_QCalendar_dateFromParts},
    {sipName_dateTimeToString, meth_QCalendar_dateTimeToString, METH_VARARGS, doc_QCalendar_dateTimeToString},
    {sipName_dayOfWeek, meth_QCalendar_dayOfWeek, METH_VARARGS, doc_QCalendar_dayOfWeek},
    {sipName_daysInMonth, SIP_MLMETH_CAST(meth_QCalendar_daysInMonth), METH_VARARGS|METH_KEYWORDS, doc_QCalendar_daysInMonth},
    {sipName_daysInYear, meth_QCalendar_daysInYear, METH_VARARGS, doc_QCalendar_daysInYear},
    {sipName_hasYearZero, meth_QCalendar_hasYearZero, METH_VARARGS, doc_QCalendar_hasYearZero},
    {sipName_isDateValid, meth_QCalendar_isDateValid, METH_VARARGS, doc_QCalendar_isDateValid},
    {sipName_isGregorian, meth_QCalendar_isGregorian, METH_VARARGS, doc_QCalendar_isGregorian},
    {sipName_isLeapYear, meth_QCalendar_isLeapYear, METH_VARARGS, doc_QCalendar_isLeapYear},
    {sipName_isLunar, meth_QCalendar_isLunar, METH_VARARGS, doc_QCalendar_isLunar},
    {sipName_isLuniSolar, meth_QCalendar_isLuniSolar, METH_VARARGS, doc_QCalendar_isLuniSolar},
    {sipName_isProleptic, meth_QCalendar_isProleptic, METH_VARARGS, doc_QCalendar_isProleptic},
    {sipName_isSolar, meth_QCalendar_isSolar, METH_VARARGS, doc_QCalendar_isSolar},
    {sipName_maximumDaysInMonth, meth_QCalendar_maximumDaysInMonth, METH_VARARGS, doc_QCalendar_maximumDaysInMonth},
    {sipName_maximumMonthsInYear, meth_QCalendar_maximumMonthsInYear, METH_VARARGS, doc_QCalendar_maximumMonthsInYear},
    {sipName_minimumDaysInMonth, meth_QCalendar_minimumDaysInMonth, METH_VARARGS, doc_QCalendar_minimumDaysInMonth},
    {sipName_monthName, SIP_MLMETH_CAST(meth_QCalendar_monthName), METH_VARARGS|METH_KEYWORDS, doc_QCalendar_monthName},
    {sipName_monthsInYear, meth_QCalendar_monthsInYear, METH_VARARGS, doc_QCalendar_monthsInYear},
    {sipName_name, meth_QCalendar_name, METH_VARARGS, doc_QCalendar_name},
    {sipName_partsFromDate, meth_QCalendar_partsFromDate, METH_VARARGS, doc_QCalendar_partsFromDate},
    {sipName_standaloneMonthName, SIP_MLMETH_CAST(meth_QCalendar_standaloneMonthName), METH_VARARGS|METH_KEYWORDS, doc_QCalendar_standaloneMonthName},
    {sipName_standaloneWeekDayName, SIP_MLMETH_CAST(meth_QCalendar_standaloneWeekDayName), METH_VARARGS|METH_KEYWORDS, doc_QCalendar_standaloneWeekDayName},
    {sipName_weekDayName, SIP_MLMETH_CAST(meth_QCalendar_weekDayName), METH_VARARGS|METH_KEYWORDS, doc_QCalendar_weekDayName}
};

static sipEnumMemberDef enummembers_QCalendar[] = {
    {sipName_Gregorian, static_cast<int>(::QCalendar::System::Gregorian), 28},
    {sipName_IslamicCivil, static_cast<int>(::QCalendar::System::IslamicCivil), 28},
    {sipName_Jalali, static_cast<int>(::QCalendar::System::Jalali), 28},
    {sipName_Julian, static_cast<int>(::QCalendar::System::Julian), 28},
    {sipName_Milankovic, static_cast<int>(::QCalendar::System::Milankovic), 28},
    {sipName_Unspecified, static_cast<int>(::QCalendar::Unspecified), -1},
};

PyDoc_STRVAR(doc_QCalendar, "\1QCalendar()\n"
"QCalendar(system: QCalendar.System)\n"
"QCalendar(name: str)\n"
"QCalendar(a0: QCalendar)");


static pyqt5ClassPluginDef plugin_QCalendar = {
    SIP_NULLPTR,
    0,
    SIP_NULLPTR,
    SIP_NULLPTR
};


sipClassTypeDef sipTypeDef_QtCore_QCalendar = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SUPER_INIT|SIP_TYPE_LIMITED_API|SIP_TYPE_CLASS,
        sipNameNr_QCalendar,
        SIP_NULLPTR,
        &plugin_QCalendar,
    },
    {
        sipNameNr_QCalendar,
        {0, 0, 1},
        24, methods_QCalendar,
        6, enummembers_QCalendar,
        0, SIP_NULLPTR,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_QCalendar,
    -1,
    sipNameNr_sip_simplewrapper,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_QCalendar,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_QCalendar,
    assign_QCalendar,
    array_QCalendar,
    copy_QCalendar,
    release_QCalendar,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_QCalendar,
    sizeof (::QCalendar),
};
