#ifndef SBK_ACTIONWRAPPER_H
#define SBK_ACTIONWRAPPER_H

#include <enhancedmenu.h>


// Argument includes
#include <QString>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class ActionWrapper : public Action
{
public:
    ActionWrapper(::QObject * parent = nullptr);
    ActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent = nullptr);
    ActionWrapper(const ::QString & text, ::QObject * parent = nullptr);
    ActionWrapper(const ActionWrapper &) = delete;
    ActionWrapper& operator=(const ActionWrapper &) = delete;
    ActionWrapper(ActionWrapper &&) = delete;
    ActionWrapper& operator=(ActionWrapper &&) = delete;
    ~ActionWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QAction::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  ifndef SBK_QACTIONWRAPPER_H
#  define SBK_QACTIONWRAPPER_H

// Inherited base class:
class QActionWrapper : public QAction
{
public:
    QActionWrapper(::QObject * parent = nullptr);
    QActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent = nullptr);
    QActionWrapper(const ::QString & text, ::QObject * parent = nullptr);
    QActionWrapper(const QActionWrapper &) = delete;
    QActionWrapper& operator=(const QActionWrapper &) = delete;
    QActionWrapper(QActionWrapper &&) = delete;
    QActionWrapper& operator=(QActionWrapper &&) = delete;
    ~QActionWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event_protected(::QEvent * arg__1) { return QAction::event(arg__1); }
    bool event(::QEvent * arg__1) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QACTIONWRAPPER_H

#  ifndef SBK_QOBJECTWRAPPER_H
#  define SBK_QOBJECTWRAPPER_H

// Inherited base class:
class QObjectWrapper : public QObject
{
public:
    QObjectWrapper(::QObject * parent = nullptr);
    QObjectWrapper(const QObjectWrapper &) = delete;
    QObjectWrapper& operator=(const QObjectWrapper &) = delete;
    QObjectWrapper(QObjectWrapper &&) = delete;
    QObjectWrapper& operator=(QObjectWrapper &&) = delete;
    ~QObjectWrapper() override;

    void childEvent_protected(::QChildEvent * event) { QObject::childEvent(event); }
    void childEvent(::QChildEvent * event) override;
    static void sbk_o_childEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChildEvent * event);
    void connectNotify_protected(const ::QMetaMethod & signal) { QObject::connectNotify(signal); }
    void connectNotify(const ::QMetaMethod & signal) override;
    void customEvent_protected(::QEvent * event) { QObject::customEvent(event); }
    void customEvent(::QEvent * event) override;
    static void sbk_o_customEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    void disconnectNotify_protected(const ::QMetaMethod & signal) { QObject::disconnectNotify(signal); }
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    static bool sbk_o_event(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QEvent * event);
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    static bool sbk_o_eventFilter(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QObject * watched, ::QEvent * event);
    bool isSignalConnected_protected(const ::QMetaMethod & signal) const { return QObject::isSignalConnected(signal); }
    int receivers_protected(const char * signal) const { return QObject::receivers(signal); }
    ::QObject * sender_protected() const { return QObject::sender(); }
    int senderSignalIndex_protected() const { return QObject::senderSignalIndex(); }
    void timerEvent_protected(::QTimerEvent * event) { QObject::timerEvent(event); }
    void timerEvent(::QTimerEvent * event) override;
    static void sbk_o_timerEvent(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QTimerEvent * event);

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 7> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#  endif // SBK_QOBJECTWRAPPER_H

#endif // SBK_ACTIONWRAPPER_H
